import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::DirectoryService::MicrosoftAD`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html
 * @external
 */
export interface CfnMicrosoftADProps {
    /**
     * `AWS::DirectoryService::MicrosoftAD.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::DirectoryService::MicrosoftAD.Password`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-password
     * @external
     */
    readonly password: string;
    /**
     * `AWS::DirectoryService::MicrosoftAD.VpcSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-vpcsettings
     * @external
     */
    readonly vpcSettings: CfnMicrosoftAD.VpcSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::MicrosoftAD.CreateAlias`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-createalias
     * @external
     */
    readonly createAlias?: boolean | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::MicrosoftAD.Edition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-edition
     * @external
     */
    readonly edition?: string;
    /**
     * `AWS::DirectoryService::MicrosoftAD.EnableSso`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-enablesso
     * @external
     */
    readonly enableSso?: boolean | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::MicrosoftAD.ShortName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-shortname
     * @external
     */
    readonly shortName?: string;
}
/**
 * A CloudFormation `AWS::DirectoryService::MicrosoftAD`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html
 * @external
 * @cloudformationResource AWS::DirectoryService::MicrosoftAD
 */
export declare class CfnMicrosoftAD extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DirectoryService::MicrosoftAD";
    /**
     * @external
     * @cloudformationAttribute Alias
     */
    readonly attrAlias: string;
    /**
     * @external
     * @cloudformationAttribute DnsIpAddresses
     */
    readonly attrDnsIpAddresses: string[];
    /**
     * `AWS::DirectoryService::MicrosoftAD.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-name
     * @external
     */
    name: string;
    /**
     * `AWS::DirectoryService::MicrosoftAD.Password`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-password
     * @external
     */
    password: string;
    /**
     * `AWS::DirectoryService::MicrosoftAD.VpcSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-vpcsettings
     * @external
     */
    vpcSettings: CfnMicrosoftAD.VpcSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::MicrosoftAD.CreateAlias`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-createalias
     * @external
     */
    createAlias: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DirectoryService::MicrosoftAD.Edition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-edition
     * @external
     */
    edition: string | undefined;
    /**
     * `AWS::DirectoryService::MicrosoftAD.EnableSso`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-enablesso
     * @external
     */
    enableSso: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DirectoryService::MicrosoftAD.ShortName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html#cfn-directoryservice-microsoftad-shortname
     * @external
     */
    shortName: string | undefined;
    /**
     * Create a new `AWS::DirectoryService::MicrosoftAD`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMicrosoftADProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DirectoryService::MicrosoftAD`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-microsoftad.html
 * @external
 * @cloudformationResource AWS::DirectoryService::MicrosoftAD
 */
export declare namespace CfnMicrosoftAD {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-microsoftad-vpcsettings.html
     * @external
     */
    interface VpcSettingsProperty {
        /**
         * `CfnMicrosoftAD.VpcSettingsProperty.SubnetIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-microsoftad-vpcsettings.html#cfn-directoryservice-microsoftad-vpcsettings-subnetids
         * @external
         */
        readonly subnetIds: string[];
        /**
         * `CfnMicrosoftAD.VpcSettingsProperty.VpcId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-microsoftad-vpcsettings.html#cfn-directoryservice-microsoftad-vpcsettings-vpcid
         * @external
         */
        readonly vpcId: string;
    }
}
/**
 * Properties for defining a `AWS::DirectoryService::SimpleAD`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html
 * @external
 */
export interface CfnSimpleADProps {
    /**
     * `AWS::DirectoryService::SimpleAD.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::DirectoryService::SimpleAD.Password`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-password
     * @external
     */
    readonly password: string;
    /**
     * `AWS::DirectoryService::SimpleAD.Size`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-size
     * @external
     */
    readonly size: string;
    /**
     * `AWS::DirectoryService::SimpleAD.VpcSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-vpcsettings
     * @external
     */
    readonly vpcSettings: CfnSimpleAD.VpcSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::SimpleAD.CreateAlias`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-createalias
     * @external
     */
    readonly createAlias?: boolean | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::SimpleAD.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::DirectoryService::SimpleAD.EnableSso`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-enablesso
     * @external
     */
    readonly enableSso?: boolean | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::SimpleAD.ShortName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-shortname
     * @external
     */
    readonly shortName?: string;
}
/**
 * A CloudFormation `AWS::DirectoryService::SimpleAD`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html
 * @external
 * @cloudformationResource AWS::DirectoryService::SimpleAD
 */
export declare class CfnSimpleAD extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DirectoryService::SimpleAD";
    /**
     * @external
     * @cloudformationAttribute Alias
     */
    readonly attrAlias: string;
    /**
     * @external
     * @cloudformationAttribute DnsIpAddresses
     */
    readonly attrDnsIpAddresses: string[];
    /**
     * `AWS::DirectoryService::SimpleAD.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-name
     * @external
     */
    name: string;
    /**
     * `AWS::DirectoryService::SimpleAD.Password`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-password
     * @external
     */
    password: string;
    /**
     * `AWS::DirectoryService::SimpleAD.Size`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-size
     * @external
     */
    size: string;
    /**
     * `AWS::DirectoryService::SimpleAD.VpcSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-vpcsettings
     * @external
     */
    vpcSettings: CfnSimpleAD.VpcSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DirectoryService::SimpleAD.CreateAlias`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-createalias
     * @external
     */
    createAlias: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DirectoryService::SimpleAD.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::DirectoryService::SimpleAD.EnableSso`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-enablesso
     * @external
     */
    enableSso: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DirectoryService::SimpleAD.ShortName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html#cfn-directoryservice-simplead-shortname
     * @external
     */
    shortName: string | undefined;
    /**
     * Create a new `AWS::DirectoryService::SimpleAD`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSimpleADProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DirectoryService::SimpleAD`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-directoryservice-simplead.html
 * @external
 * @cloudformationResource AWS::DirectoryService::SimpleAD
 */
export declare namespace CfnSimpleAD {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-simplead-vpcsettings.html
     * @external
     */
    interface VpcSettingsProperty {
        /**
         * `CfnSimpleAD.VpcSettingsProperty.SubnetIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-simplead-vpcsettings.html#cfn-directoryservice-simplead-vpcsettings-subnetids
         * @external
         */
        readonly subnetIds: string[];
        /**
         * `CfnSimpleAD.VpcSettingsProperty.VpcId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-directoryservice-simplead-vpcsettings.html#cfn-directoryservice-simplead-vpcsettings-vpcid
         * @external
         */
        readonly vpcId: string;
    }
}
