[![Buy Us Tea](https://github.com/nlpia/nlpia-bot/raw/develop/docs/media/small-leaf-and-name-screenshot-31x80.png)](https://buymeacoffee.com/hobs)
[![PyPI version](https://img.shields.io/pypi/pyversions/qary.svg)](https://pypi.org/project/qary/)
[![License](https://img.shields.io/pypi/l/qary.svg)](https://pypi.python.org/pypi/qary/)
[![codecov](https://codecov.io/gl/tangibleai/qary/branch/master/graph/badge.svg)](https://codecov.io/gl/tangibleai/qary)
[![DigitalOcean Referral Badge](https://web-platforms.sfo2.digitaloceanspaces.com/WWW/Badge%202.svg)](https://www.digitalocean.com/?refcode=5bc34fba1bee&utm_campaign=Referral_Invite&utm_medium=Referral_Program&utm_source=badge)


# `qary`

The `qary` package is both a chatbot framework and a working "reference implementation" virtual assistant that actually assists! Most bots manipulate you to make money for their corporate masters. With qary, you can build **your** bot to protect you and amplify your intelligence and prosocial instincts.

`qary` was conceived as part of [NLP in Action](https://www.manning.com/books/natural-language-processing-in-action) book, is maintained by an [active developer community](/docs/wiki/contributors.md) and is supported by [San Diego Python User Group](https://www.pythonsd.org/index.html) (some qary talks [here](https://www.youtube.com/playlist?list=PLOa5qP-zwt22Noym1Nf8BeL24NeE__ofj) and in `docs/`) and [San Diego Machine Learning Group](https://www.meetup.com/San-Diego-Machine-Learning/).

## Install

### Install from source

Retrieve the source code from GitLab:

```bash
git clone git@gitlab.com:tangibleai/qary
cd qary
```

Then, install and use the `conda` python package manager within the [Anaconda](https://www.anaconda.com/products/individual#Downloads) software package.

```bash
conda update -y -n base -c defaults conda
conda create -y -n qaryenv 'python==3.9.7'
conda activate qaryenv || source activate qaryenv
source ./scripts/install_editable.sh
```

**Windows Users**: [docs/README-windows-install.md](docs/README-windows-install.md)

### PyPi package
`qary` is on [PyPi](https://pypi.org/project/qary/) but this install is unlikely to work, unless you've already installed all the dependencies:

```bash
pip install qary
```

## Usage

```bash
$ qary --help
usage: qary [-h] [--version] [--name STR] [-p] [-s STR] [-v] [-vv] [words [words ...]]
```

### Running `qary` for just one skill

```bash
$ qary -s qa
# ... (logging messages)
YOU: When was Barack Obama born?
# ... (logging messages)
qary: August 4, 1961
```

### `qary` skills

`qary`'s probabilistic conversation manager chooses a reply from the possiblities generated by the different personalities:

- `pattern` (`skills/pattern.py`): example skill using regex patterns to reply to greetings like "hi"
- `qa` (`skills/qa.py`): BERT and ALBERT Wikipedia Question Answering (WikiQA reading comprehension tests)
- `faq` (`skills/faq.py`): answers to frequently asked questions using data/faq/*.yml
- `glossary` (`skills/glossary.py`): definitions from glossary yml files in data/faq/glossary-*.yml
- `eliza` (`eliza.py`): a python port of the ELIZA therapist bot

### Configuring default personalities

By default, `qary` runs with `qa` personality. Check out the config file in `qary.ini` to change the default skills loaded for your own custom skill in the skills directory.

## Approach

`qary`'s chatbot framework allows you to combine many approaches to give you state-of-the-art capability to answer questions and carry on a conversation:

1. search: [chatterbot](https://github.com/gunthercox/ChatterBot), [will](https://github.com/skoczen/will)
2. pattern matching and response templates: Alexa, [AIML](https://github.com/keiffster/program-y)
3. generative deep learning: [robot-bernie](https://github.com/nlpia/robot-bernie), [movie-bot](https://github.com/totalgood/nlpia/blob/master/src/nlpia/book/examples/ch10_movie_dialog_chatbot.py)
4. grounding: [snips](https://github.com/snipsco/snips-nlu)

It's all explained in detail at [NLP in Action](https://www.manning.com/books/natural-language-processing-in-action).

Presentations for San Diego Python User Group are in [docs/](/docs/2019-08-22--San Diego Python User Group -- How to Build a Chatbot.odp) and on the web at [http://totalgood.org/midata/talks](http://totalgood.org/midata/talks/)

## Contributing pattern for developers

DM @hobs on SD PUG's [discord server](https://discord.gg/yFTAQDxg) if you'd like to join us for weekly collaborative-coding sessions on `qary` and other open source projects.

1. [Create a fork](https://docs.gitlab.com/ee/user/project/repository/forking_workflow.html#creating-a-fork) of the [main qary repository](https://gitlab.com/tangibleai/qary) on Gitlab.
2. Make your changes in a branch named something different from `master`, e.g. create
   a new branch `my-pull-request`.
3. [Create a merge request](https://docs.gitlab.com/ee/user/project/merge_requests/creating_merge_requests.html).
4. Help your fellow contributors out by:
  - Follow the [PEP-8 style guide](https://www.python.org/dev/peps/pep-0008/).
  - Try to include a docstring, at least a single line, in any function, method, or class
  - Bonus points for adding a [doctest](https://docs.python.org/3/library/doctest.html) as part of your contribution.
  - If you add a new feature, write some quick docs in the README.
  - Add your name and attribution to the AUTHORS file.
  - Know we are grateful for your contribution! You've made the chatbot world a little better!

