# Generated by Django 3.2.3 on 2021-06-01 17:31

import random

from django.db import migrations


def seed_data(apps, schema_editor):
    Structure = apps.get_model("qdmtkdemo", "Structure")
    Building = apps.get_model("qdmtkdemo", "Building")

    for i in range(1000):
        x = random.uniform(6.10, 6.15)
        y = random.uniform(46.20, 46.25)
        if i % 2 == 0:
            Structure.objects.create(
                name=f"structure {i}",
                geom=f"SRID=4326;POINT({x} {y})",
            )
        else:
            Building.objects.create(
                name=f"house {i}",
                stories_count=4,
                geom=f"SRID=4326;POINT({x} {y})",
            )


class Migration(migrations.Migration):

    dependencies = [
        ("qdmtkdemo", "0001_initial"),
    ]

    operations = [migrations.RunPython(seed_data)]
