import { Integration, IntegrationConfig, IntegrationOptions } from '../integration';
import { Method } from '../method';
/**
 * @stability stable
 */
export interface AwsIntegrationProps {
    /**
     * Use AWS_PROXY integration.
     *
     * @default false
     * @stability stable
     */
    readonly proxy?: boolean;
    /**
     * The name of the integrated AWS service (e.g. `s3`).
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * A designated subdomain supported by certain AWS service for fast host-name lookup.
     *
     * @stability stable
     */
    readonly subdomain?: string;
    /**
     * The path to use for path-base APIs.
     *
     * For example, for S3 GET, you can set path to `bucket/key`.
     * For lambda, you can set path to `2015-03-31/functions/${function-arn}/invocations`
     *
     * Mutually exclusive with the `action` options.
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * The AWS action to perform in the integration.
     *
     * Use `actionParams` to specify key-value params for the action.
     *
     * Mutually exclusive with `path`.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Parameters for the action.
     *
     * `action` must be set, and `path` must be undefined.
     * The action params will be URL encoded.
     *
     * @stability stable
     */
    readonly actionParameters?: {
        [key: string]: string;
    };
    /**
     * The integration's HTTP method type.
     *
     * @default POST
     * @stability stable
     */
    readonly integrationHttpMethod?: string;
    /**
     * Integration options, such as content handling, request/response mapping, etc.
     *
     * @stability stable
     */
    readonly options?: IntegrationOptions;
    /**
     * The region of the integrated AWS service.
     *
     * @default - same region as the stack
     * @stability stable
     */
    readonly region?: string;
}
/**
 * This type of integration lets an API expose AWS service actions.
 *
 * It is
 * intended for calling all AWS service actions, but is not recommended for
 * calling a Lambda function, because the Lambda custom integration is a legacy
 * technology.
 *
 * @stability stable
 */
export declare class AwsIntegration extends Integration {
    private scope?;
    /**
     * @stability stable
     */
    constructor(props: AwsIntegrationProps);
    /**
     * Can be overridden by subclasses to allow the integration to interact with the method being integrated, access the REST API object, method ARNs, etc.
     *
     * @stability stable
     */
    bind(method: Method): IntegrationConfig;
}
