"""File generated by TLObjects' generator. All changes will be ERASED"""
from ...tl.tlobject import TLObject
from ...tl.tlobject import TLRequest
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
from datetime import datetime
if TYPE_CHECKING:
    from ...tl.types import TypeAccountDaysTTL, TypeAutoDownloadSettings, TypeCodeSettings, TypeGlobalPrivacySettings, TypeInputCheckPasswordSRP, TypeInputDocument, TypeInputFile, TypeInputNotifyPeer, TypeInputPeer, TypeInputPeerNotifySettings, TypeInputPrivacyKey, TypeInputPrivacyRule, TypeInputSecureValue, TypeInputTheme, TypeInputThemeSettings, TypeInputWallPaper, TypeReportReason, TypeSecureCredentialsEncrypted, TypeSecureValueHash, TypeSecureValueType, TypeWallPaperSettings
    from ...tl.types.account import TypePasswordInputSettings



class AcceptAuthorizationRequest(TLRequest):
    CONSTRUCTOR_ID = 0xe7027c94
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, bot_id: int, scope: str, public_key: str, value_hashes: List['TypeSecureValueHash'], credentials: 'TypeSecureCredentialsEncrypted'):
        """
        :returns Bool: This type has no constructors.
        """
        self.bot_id = bot_id
        self.scope = scope
        self.public_key = public_key
        self.value_hashes = value_hashes
        self.credentials = credentials

    def to_dict(self):
        return {
            '_': 'AcceptAuthorizationRequest',
            'bot_id': self.bot_id,
            'scope': self.scope,
            'public_key': self.public_key,
            'value_hashes': [] if self.value_hashes is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.value_hashes],
            'credentials': self.credentials.to_dict() if isinstance(self.credentials, TLObject) else self.credentials
        }

    def _bytes(self):
        return b''.join((
            b'\x94|\x02\xe7',
            struct.pack('<i', self.bot_id),
            self.serialize_bytes(self.scope),
            self.serialize_bytes(self.public_key),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.value_hashes)),b''.join(x._bytes() for x in self.value_hashes),
            self.credentials._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _bot_id = reader.read_int()
        _scope = reader.tgread_string()
        _public_key = reader.tgread_string()
        reader.read_int()
        _value_hashes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _value_hashes.append(_x)

        _credentials = reader.tgread_object()
        return cls(bot_id=_bot_id, scope=_scope, public_key=_public_key, value_hashes=_value_hashes, credentials=_credentials)


class CancelPasswordEmailRequest(TLRequest):
    CONSTRUCTOR_ID = 0xc1cbd5b6
    SUBCLASS_OF_ID = 0xf5b399ac

    def to_dict(self):
        return {
            '_': 'CancelPasswordEmailRequest'
        }

    def _bytes(self):
        return b''.join((
            b'\xb6\xd5\xcb\xc1',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChangePhoneRequest(TLRequest):
    CONSTRUCTOR_ID = 0x70c32edb
    SUBCLASS_OF_ID = 0x2da17977

    def __init__(self, phone_number: str, phone_code_hash: str, phone_code: str):
        """
        :returns User: Instance of either UserEmpty, User.
        """
        self.phone_number = phone_number
        self.phone_code_hash = phone_code_hash
        self.phone_code = phone_code

    def to_dict(self):
        return {
            '_': 'ChangePhoneRequest',
            'phone_number': self.phone_number,
            'phone_code_hash': self.phone_code_hash,
            'phone_code': self.phone_code
        }

    def _bytes(self):
        return b''.join((
            b'\xdb.\xc3p',
            self.serialize_bytes(self.phone_number),
            self.serialize_bytes(self.phone_code_hash),
            self.serialize_bytes(self.phone_code),
        ))

    @classmethod
    def from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _phone_code_hash = reader.tgread_string()
        _phone_code = reader.tgread_string()
        return cls(phone_number=_phone_number, phone_code_hash=_phone_code_hash, phone_code=_phone_code)


class CheckUsernameRequest(TLRequest):
    CONSTRUCTOR_ID = 0x2714d86c
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, username: str):
        """
        :returns Bool: This type has no constructors.
        """
        self.username = username

    def to_dict(self):
        return {
            '_': 'CheckUsernameRequest',
            'username': self.username
        }

    def _bytes(self):
        return b''.join((
            b"l\xd8\x14'",
            self.serialize_bytes(self.username),
        ))

    @classmethod
    def from_reader(cls, reader):
        _username = reader.tgread_string()
        return cls(username=_username)


class ConfirmPasswordEmailRequest(TLRequest):
    CONSTRUCTOR_ID = 0x8fdf1920
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, code: str):
        """
        :returns Bool: This type has no constructors.
        """
        self.code = code

    def to_dict(self):
        return {
            '_': 'ConfirmPasswordEmailRequest',
            'code': self.code
        }

    def _bytes(self):
        return b''.join((
            b' \x19\xdf\x8f',
            self.serialize_bytes(self.code),
        ))

    @classmethod
    def from_reader(cls, reader):
        _code = reader.tgread_string()
        return cls(code=_code)


class ConfirmPhoneRequest(TLRequest):
    CONSTRUCTOR_ID = 0x5f2178c3
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, phone_code_hash: str, phone_code: str):
        """
        :returns Bool: This type has no constructors.
        """
        self.phone_code_hash = phone_code_hash
        self.phone_code = phone_code

    def to_dict(self):
        return {
            '_': 'ConfirmPhoneRequest',
            'phone_code_hash': self.phone_code_hash,
            'phone_code': self.phone_code
        }

    def _bytes(self):
        return b''.join((
            b'\xc3x!_',
            self.serialize_bytes(self.phone_code_hash),
            self.serialize_bytes(self.phone_code),
        ))

    @classmethod
    def from_reader(cls, reader):
        _phone_code_hash = reader.tgread_string()
        _phone_code = reader.tgread_string()
        return cls(phone_code_hash=_phone_code_hash, phone_code=_phone_code)


class CreateThemeRequest(TLRequest):
    CONSTRUCTOR_ID = 0x8432c21f
    SUBCLASS_OF_ID = 0x56b4c80c

    def __init__(self, slug: str, title: str, document: Optional['TypeInputDocument']=None, settings: Optional['TypeInputThemeSettings']=None):
        """
        :returns Theme: Instance of Theme.
        """
        self.slug = slug
        self.title = title
        self.document = document
        self.settings = settings

    async def resolve(self, client, utils):
        if self.document:
            self.document = utils.get_input_document(self.document)

    def to_dict(self):
        return {
            '_': 'CreateThemeRequest',
            'slug': self.slug,
            'title': self.title,
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document,
            'settings': self.settings.to_dict() if isinstance(self.settings, TLObject) else self.settings
        }

    def _bytes(self):
        return b''.join((
            b'\x1f\xc22\x84',
            struct.pack('<I', (0 if self.document is None or self.document is False else 4) | (0 if self.settings is None or self.settings is False else 8)),
            self.serialize_bytes(self.slug),
            self.serialize_bytes(self.title),
            b'' if self.document is None or self.document is False else (self.document._bytes()),
            b'' if self.settings is None or self.settings is False else (self.settings._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _slug = reader.tgread_string()
        _title = reader.tgread_string()
        if flags & 4:
            _document = reader.tgread_object()
        else:
            _document = None
        if flags & 8:
            _settings = reader.tgread_object()
        else:
            _settings = None
        return cls(slug=_slug, title=_title, document=_document, settings=_settings)


class DeleteAccountRequest(TLRequest):
    CONSTRUCTOR_ID = 0x418d4e0b
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, reason: str):
        """
        :returns Bool: This type has no constructors.
        """
        self.reason = reason

    def to_dict(self):
        return {
            '_': 'DeleteAccountRequest',
            'reason': self.reason
        }

    def _bytes(self):
        return b''.join((
            b'\x0bN\x8dA',
            self.serialize_bytes(self.reason),
        ))

    @classmethod
    def from_reader(cls, reader):
        _reason = reader.tgread_string()
        return cls(reason=_reason)


class DeleteSecureValueRequest(TLRequest):
    CONSTRUCTOR_ID = 0xb880bc4b
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, types: List['TypeSecureValueType']):
        """
        :returns Bool: This type has no constructors.
        """
        self.types = types

    def to_dict(self):
        return {
            '_': 'DeleteSecureValueRequest',
            'types': [] if self.types is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.types]
        }

    def _bytes(self):
        return b''.join((
            b'K\xbc\x80\xb8',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.types)),b''.join(x._bytes() for x in self.types),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _types = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _types.append(_x)

        return cls(types=_types)


class FinishTakeoutSessionRequest(TLRequest):
    CONSTRUCTOR_ID = 0x1d2652ee
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, success: Optional[bool]=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.success = success

    def to_dict(self):
        return {
            '_': 'FinishTakeoutSessionRequest',
            'success': self.success
        }

    def _bytes(self):
        return b''.join((
            b'\xeeR&\x1d',
            struct.pack('<I', (0 if self.success is None or self.success is False else 1)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _success = bool(flags & 1)
        return cls(success=_success)


class GetAccountTTLRequest(TLRequest):
    CONSTRUCTOR_ID = 0x8fc711d
    SUBCLASS_OF_ID = 0xbaa39d88

    def to_dict(self):
        return {
            '_': 'GetAccountTTLRequest'
        }

    def _bytes(self):
        return b''.join((
            b'\x1dq\xfc\x08',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class GetAllSecureValuesRequest(TLRequest):
    CONSTRUCTOR_ID = 0xb288bc7d
    SUBCLASS_OF_ID = 0xe82e4121

    def to_dict(self):
        return {
            '_': 'GetAllSecureValuesRequest'
        }

    def _bytes(self):
        return b''.join((
            b'}\xbc\x88\xb2',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class GetAuthorizationFormRequest(TLRequest):
    CONSTRUCTOR_ID = 0xb86ba8e1
    SUBCLASS_OF_ID = 0x78049a94

    def __init__(self, bot_id: int, scope: str, public_key: str):
        """
        :returns account.AuthorizationForm: Instance of AuthorizationForm.
        """
        self.bot_id = bot_id
        self.scope = scope
        self.public_key = public_key

    def to_dict(self):
        return {
            '_': 'GetAuthorizationFormRequest',
            'bot_id': self.bot_id,
            'scope': self.scope,
            'public_key': self.public_key
        }

    def _bytes(self):
        return b''.join((
            b'\xe1\xa8k\xb8',
            struct.pack('<i', self.bot_id),
            self.serialize_bytes(self.scope),
            self.serialize_bytes(self.public_key),
        ))

    @classmethod
    def from_reader(cls, reader):
        _bot_id = reader.read_int()
        _scope = reader.tgread_string()
        _public_key = reader.tgread_string()
        return cls(bot_id=_bot_id, scope=_scope, public_key=_public_key)


class GetAuthorizationsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xe320c158
    SUBCLASS_OF_ID = 0xbf5e0ff

    def to_dict(self):
        return {
            '_': 'GetAuthorizationsRequest'
        }

    def _bytes(self):
        return b''.join((
            b'X\xc1 \xe3',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class GetAutoDownloadSettingsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x56da0b3f
    SUBCLASS_OF_ID = 0x2fb85921

    def to_dict(self):
        return {
            '_': 'GetAutoDownloadSettingsRequest'
        }

    def _bytes(self):
        return b''.join((
            b'?\x0b\xdaV',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class GetContactSignUpNotificationRequest(TLRequest):
    CONSTRUCTOR_ID = 0x9f07c728
    SUBCLASS_OF_ID = 0xf5b399ac

    def to_dict(self):
        return {
            '_': 'GetContactSignUpNotificationRequest'
        }

    def _bytes(self):
        return b''.join((
            b'(\xc7\x07\x9f',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class GetContentSettingsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x8b9b4dae
    SUBCLASS_OF_ID = 0xae3ff891

    def to_dict(self):
        return {
            '_': 'GetContentSettingsRequest'
        }

    def _bytes(self):
        return b''.join((
            b'\xaeM\x9b\x8b',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class GetGlobalPrivacySettingsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xeb2b4cf6
    SUBCLASS_OF_ID = 0xc90e5770

    def to_dict(self):
        return {
            '_': 'GetGlobalPrivacySettingsRequest'
        }

    def _bytes(self):
        return b''.join((
            b'\xf6L+\xeb',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class GetMultiWallPapersRequest(TLRequest):
    CONSTRUCTOR_ID = 0x65ad71dc
    SUBCLASS_OF_ID = 0x8ec35283

    def __init__(self, wallpapers: List['TypeInputWallPaper']):
        """
        :returns Vector<WallPaper>: This type has no constructors.
        """
        self.wallpapers = wallpapers

    def to_dict(self):
        return {
            '_': 'GetMultiWallPapersRequest',
            'wallpapers': [] if self.wallpapers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.wallpapers]
        }

    def _bytes(self):
        return b''.join((
            b'\xdcq\xade',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.wallpapers)),b''.join(x._bytes() for x in self.wallpapers),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _wallpapers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _wallpapers.append(_x)

        return cls(wallpapers=_wallpapers)


class GetNotifyExceptionsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x53577479
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, compare_sound: Optional[bool]=None, peer: Optional['TypeInputNotifyPeer']=None):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.compare_sound = compare_sound
        self.peer = peer

    async def resolve(self, client, utils):
        if self.peer:
            self.peer = await client._get_input_notify(self.peer)

    def to_dict(self):
        return {
            '_': 'GetNotifyExceptionsRequest',
            'compare_sound': self.compare_sound,
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def _bytes(self):
        return b''.join((
            b'ytWS',
            struct.pack('<I', (0 if self.compare_sound is None or self.compare_sound is False else 2) | (0 if self.peer is None or self.peer is False else 1)),
            b'' if self.peer is None or self.peer is False else (self.peer._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _compare_sound = bool(flags & 2)
        if flags & 1:
            _peer = reader.tgread_object()
        else:
            _peer = None
        return cls(compare_sound=_compare_sound, peer=_peer)


class GetNotifySettingsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x12b3ad31
    SUBCLASS_OF_ID = 0xcf20c074

    def __init__(self, peer: 'TypeInputNotifyPeer'):
        """
        :returns PeerNotifySettings: Instance of PeerNotifySettings.
        """
        self.peer = peer

    async def resolve(self, client, utils):
        self.peer = await client._get_input_notify(self.peer)

    def to_dict(self):
        return {
            '_': 'GetNotifySettingsRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def _bytes(self):
        return b''.join((
            b'1\xad\xb3\x12',
            self.peer._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class GetPasswordRequest(TLRequest):
    CONSTRUCTOR_ID = 0x548a30f5
    SUBCLASS_OF_ID = 0x53a211a3

    def to_dict(self):
        return {
            '_': 'GetPasswordRequest'
        }

    def _bytes(self):
        return b''.join((
            b'\xf50\x8aT',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class GetPasswordSettingsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x9cd4eaf9
    SUBCLASS_OF_ID = 0xd23fb078

    def __init__(self, password: 'TypeInputCheckPasswordSRP'):
        """
        :returns account.PasswordSettings: Instance of PasswordSettings.
        """
        self.password = password

    def to_dict(self):
        return {
            '_': 'GetPasswordSettingsRequest',
            'password': self.password.to_dict() if isinstance(self.password, TLObject) else self.password
        }

    def _bytes(self):
        return b''.join((
            b'\xf9\xea\xd4\x9c',
            self.password._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _password = reader.tgread_object()
        return cls(password=_password)


class GetPrivacyRequest(TLRequest):
    CONSTRUCTOR_ID = 0xdadbc950
    SUBCLASS_OF_ID = 0xb55aba82

    def __init__(self, key: 'TypeInputPrivacyKey'):
        """
        :returns account.PrivacyRules: Instance of PrivacyRules.
        """
        self.key = key

    def to_dict(self):
        return {
            '_': 'GetPrivacyRequest',
            'key': self.key.to_dict() if isinstance(self.key, TLObject) else self.key
        }

    def _bytes(self):
        return b''.join((
            b'P\xc9\xdb\xda',
            self.key._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _key = reader.tgread_object()
        return cls(key=_key)


class GetSecureValueRequest(TLRequest):
    CONSTRUCTOR_ID = 0x73665bc2
    SUBCLASS_OF_ID = 0xe82e4121

    def __init__(self, types: List['TypeSecureValueType']):
        """
        :returns Vector<SecureValue>: This type has no constructors.
        """
        self.types = types

    def to_dict(self):
        return {
            '_': 'GetSecureValueRequest',
            'types': [] if self.types is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.types]
        }

    def _bytes(self):
        return b''.join((
            b'\xc2[fs',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.types)),b''.join(x._bytes() for x in self.types),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _types = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _types.append(_x)

        return cls(types=_types)


class GetThemeRequest(TLRequest):
    CONSTRUCTOR_ID = 0x8d9d742b
    SUBCLASS_OF_ID = 0x56b4c80c

    # noinspection PyShadowingBuiltins
    def __init__(self, format: str, theme: 'TypeInputTheme', document_id: int):
        """
        :returns Theme: Instance of Theme.
        """
        self.format = format
        self.theme = theme
        self.document_id = document_id

    def to_dict(self):
        return {
            '_': 'GetThemeRequest',
            'format': self.format,
            'theme': self.theme.to_dict() if isinstance(self.theme, TLObject) else self.theme,
            'document_id': self.document_id
        }

    def _bytes(self):
        return b''.join((
            b'+t\x9d\x8d',
            self.serialize_bytes(self.format),
            self.theme._bytes(),
            struct.pack('<q', self.document_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _format = reader.tgread_string()
        _theme = reader.tgread_object()
        _document_id = reader.read_long()
        return cls(format=_format, theme=_theme, document_id=_document_id)


class GetThemesRequest(TLRequest):
    CONSTRUCTOR_ID = 0x285946f8
    SUBCLASS_OF_ID = 0x7fc52204

    # noinspection PyShadowingBuiltins
    def __init__(self, format: str, hash: int):
        """
        :returns account.Themes: Instance of either ThemesNotModified, Themes.
        """
        self.format = format
        self.hash = hash

    def to_dict(self):
        return {
            '_': 'GetThemesRequest',
            'format': self.format,
            'hash': self.hash
        }

    def _bytes(self):
        return b''.join((
            b'\xf8FY(',
            self.serialize_bytes(self.format),
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _format = reader.tgread_string()
        _hash = reader.read_int()
        return cls(format=_format, hash=_hash)


class GetTmpPasswordRequest(TLRequest):
    CONSTRUCTOR_ID = 0x449e0b51
    SUBCLASS_OF_ID = 0xb064992d

    def __init__(self, password: 'TypeInputCheckPasswordSRP', period: int):
        """
        :returns account.TmpPassword: Instance of TmpPassword.
        """
        self.password = password
        self.period = period

    def to_dict(self):
        return {
            '_': 'GetTmpPasswordRequest',
            'password': self.password.to_dict() if isinstance(self.password, TLObject) else self.password,
            'period': self.period
        }

    def _bytes(self):
        return b''.join((
            b'Q\x0b\x9eD',
            self.password._bytes(),
            struct.pack('<i', self.period),
        ))

    @classmethod
    def from_reader(cls, reader):
        _password = reader.tgread_object()
        _period = reader.read_int()
        return cls(password=_password, period=_period)


class GetWallPaperRequest(TLRequest):
    CONSTRUCTOR_ID = 0xfc8ddbea
    SUBCLASS_OF_ID = 0x96a2c98b

    def __init__(self, wallpaper: 'TypeInputWallPaper'):
        """
        :returns WallPaper: Instance of either WallPaper, WallPaperNoFile.
        """
        self.wallpaper = wallpaper

    def to_dict(self):
        return {
            '_': 'GetWallPaperRequest',
            'wallpaper': self.wallpaper.to_dict() if isinstance(self.wallpaper, TLObject) else self.wallpaper
        }

    def _bytes(self):
        return b''.join((
            b'\xea\xdb\x8d\xfc',
            self.wallpaper._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _wallpaper = reader.tgread_object()
        return cls(wallpaper=_wallpaper)


class GetWallPapersRequest(TLRequest):
    CONSTRUCTOR_ID = 0xaabb1763
    SUBCLASS_OF_ID = 0xa2c548fd

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        """
        :returns account.WallPapers: Instance of either WallPapersNotModified, WallPapers.
        """
        self.hash = hash

    def to_dict(self):
        return {
            '_': 'GetWallPapersRequest',
            'hash': self.hash
        }

    def _bytes(self):
        return b''.join((
            b'c\x17\xbb\xaa',
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_int()
        return cls(hash=_hash)


class GetWebAuthorizationsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x182e6d6f
    SUBCLASS_OF_ID = 0x9a365b32

    def to_dict(self):
        return {
            '_': 'GetWebAuthorizationsRequest'
        }

    def _bytes(self):
        return b''.join((
            b'om.\x18',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InitTakeoutSessionRequest(TLRequest):
    CONSTRUCTOR_ID = 0xf05b4804
    SUBCLASS_OF_ID = 0x843ebe85

    def __init__(self, contacts: Optional[bool]=None, message_users: Optional[bool]=None, message_chats: Optional[bool]=None, message_megagroups: Optional[bool]=None, message_channels: Optional[bool]=None, files: Optional[bool]=None, file_max_size: Optional[int]=None):
        """
        :returns account.Takeout: Instance of Takeout.
        """
        self.contacts = contacts
        self.message_users = message_users
        self.message_chats = message_chats
        self.message_megagroups = message_megagroups
        self.message_channels = message_channels
        self.files = files
        self.file_max_size = file_max_size

    def to_dict(self):
        return {
            '_': 'InitTakeoutSessionRequest',
            'contacts': self.contacts,
            'message_users': self.message_users,
            'message_chats': self.message_chats,
            'message_megagroups': self.message_megagroups,
            'message_channels': self.message_channels,
            'files': self.files,
            'file_max_size': self.file_max_size
        }

    def _bytes(self):
        assert ((self.files or self.files is not None) and (self.file_max_size or self.file_max_size is not None)) or ((self.files is None or self.files is False) and (self.file_max_size is None or self.file_max_size is False)), 'files, file_max_size parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\x04H[\xf0',
            struct.pack('<I', (0 if self.contacts is None or self.contacts is False else 1) | (0 if self.message_users is None or self.message_users is False else 2) | (0 if self.message_chats is None or self.message_chats is False else 4) | (0 if self.message_megagroups is None or self.message_megagroups is False else 8) | (0 if self.message_channels is None or self.message_channels is False else 16) | (0 if self.files is None or self.files is False else 32) | (0 if self.file_max_size is None or self.file_max_size is False else 32)),
            b'' if self.file_max_size is None or self.file_max_size is False else (struct.pack('<i', self.file_max_size)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _contacts = bool(flags & 1)
        _message_users = bool(flags & 2)
        _message_chats = bool(flags & 4)
        _message_megagroups = bool(flags & 8)
        _message_channels = bool(flags & 16)
        _files = bool(flags & 32)
        if flags & 32:
            _file_max_size = reader.read_int()
        else:
            _file_max_size = None
        return cls(contacts=_contacts, message_users=_message_users, message_chats=_message_chats, message_megagroups=_message_megagroups, message_channels=_message_channels, files=_files, file_max_size=_file_max_size)


class InstallThemeRequest(TLRequest):
    CONSTRUCTOR_ID = 0x7ae43737
    SUBCLASS_OF_ID = 0xf5b399ac

    # noinspection PyShadowingBuiltins
    def __init__(self, dark: Optional[bool]=None, format: Optional[str]=None, theme: Optional['TypeInputTheme']=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.dark = dark
        self.format = format
        self.theme = theme

    def to_dict(self):
        return {
            '_': 'InstallThemeRequest',
            'dark': self.dark,
            'format': self.format,
            'theme': self.theme.to_dict() if isinstance(self.theme, TLObject) else self.theme
        }

    def _bytes(self):
        assert ((self.format or self.format is not None) and (self.theme or self.theme is not None)) or ((self.format is None or self.format is False) and (self.theme is None or self.theme is False)), 'format, theme parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'77\xe4z',
            struct.pack('<I', (0 if self.dark is None or self.dark is False else 1) | (0 if self.format is None or self.format is False else 2) | (0 if self.theme is None or self.theme is False else 2)),
            b'' if self.format is None or self.format is False else (self.serialize_bytes(self.format)),
            b'' if self.theme is None or self.theme is False else (self.theme._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _dark = bool(flags & 1)
        if flags & 2:
            _format = reader.tgread_string()
        else:
            _format = None
        if flags & 2:
            _theme = reader.tgread_object()
        else:
            _theme = None
        return cls(dark=_dark, format=_format, theme=_theme)


class InstallWallPaperRequest(TLRequest):
    CONSTRUCTOR_ID = 0xfeed5769
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, wallpaper: 'TypeInputWallPaper', settings: 'TypeWallPaperSettings'):
        """
        :returns Bool: This type has no constructors.
        """
        self.wallpaper = wallpaper
        self.settings = settings

    def to_dict(self):
        return {
            '_': 'InstallWallPaperRequest',
            'wallpaper': self.wallpaper.to_dict() if isinstance(self.wallpaper, TLObject) else self.wallpaper,
            'settings': self.settings.to_dict() if isinstance(self.settings, TLObject) else self.settings
        }

    def _bytes(self):
        return b''.join((
            b'iW\xed\xfe',
            self.wallpaper._bytes(),
            self.settings._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _wallpaper = reader.tgread_object()
        _settings = reader.tgread_object()
        return cls(wallpaper=_wallpaper, settings=_settings)


class RegisterDeviceRequest(TLRequest):
    CONSTRUCTOR_ID = 0x68976c6f
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, token_type: int, token: str, app_sandbox: bool, secret: bytes, other_uids: List[int], no_muted: Optional[bool]=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.token_type = token_type
        self.token = token
        self.app_sandbox = app_sandbox
        self.secret = secret
        self.other_uids = other_uids
        self.no_muted = no_muted

    def to_dict(self):
        return {
            '_': 'RegisterDeviceRequest',
            'token_type': self.token_type,
            'token': self.token,
            'app_sandbox': self.app_sandbox,
            'secret': self.secret,
            'other_uids': [] if self.other_uids is None else self.other_uids[:],
            'no_muted': self.no_muted
        }

    def _bytes(self):
        return b''.join((
            b'ol\x97h',
            struct.pack('<I', (0 if self.no_muted is None or self.no_muted is False else 1)),
            struct.pack('<i', self.token_type),
            self.serialize_bytes(self.token),
            b'\xb5ur\x99' if self.app_sandbox else b'7\x97y\xbc',
            self.serialize_bytes(self.secret),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.other_uids)),b''.join(struct.pack('<i', x) for x in self.other_uids),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _no_muted = bool(flags & 1)
        _token_type = reader.read_int()
        _token = reader.tgread_string()
        _app_sandbox = reader.tgread_bool()
        _secret = reader.tgread_bytes()
        reader.read_int()
        _other_uids = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _other_uids.append(_x)

        return cls(token_type=_token_type, token=_token, app_sandbox=_app_sandbox, secret=_secret, other_uids=_other_uids, no_muted=_no_muted)


class ReportPeerRequest(TLRequest):
    CONSTRUCTOR_ID = 0xae189d5f
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, peer: 'TypeInputPeer', reason: 'TypeReportReason'):
        """
        :returns Bool: This type has no constructors.
        """
        self.peer = peer
        self.reason = reason

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'ReportPeerRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'reason': self.reason.to_dict() if isinstance(self.reason, TLObject) else self.reason
        }

    def _bytes(self):
        return b''.join((
            b'_\x9d\x18\xae',
            self.peer._bytes(),
            self.reason._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _reason = reader.tgread_object()
        return cls(peer=_peer, reason=_reason)


class ResendPasswordEmailRequest(TLRequest):
    CONSTRUCTOR_ID = 0x7a7f2a15
    SUBCLASS_OF_ID = 0xf5b399ac

    def to_dict(self):
        return {
            '_': 'ResendPasswordEmailRequest'
        }

    def _bytes(self):
        return b''.join((
            b'\x15*\x7fz',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ResetAuthorizationRequest(TLRequest):
    CONSTRUCTOR_ID = 0xdf77f3bc
    SUBCLASS_OF_ID = 0xf5b399ac

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        """
        :returns Bool: This type has no constructors.
        """
        self.hash = hash

    def to_dict(self):
        return {
            '_': 'ResetAuthorizationRequest',
            'hash': self.hash
        }

    def _bytes(self):
        return b''.join((
            b'\xbc\xf3w\xdf',
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_long()
        return cls(hash=_hash)


class ResetNotifySettingsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xdb7e1747
    SUBCLASS_OF_ID = 0xf5b399ac

    def to_dict(self):
        return {
            '_': 'ResetNotifySettingsRequest'
        }

    def _bytes(self):
        return b''.join((
            b'G\x17~\xdb',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ResetWallPapersRequest(TLRequest):
    CONSTRUCTOR_ID = 0xbb3b9804
    SUBCLASS_OF_ID = 0xf5b399ac

    def to_dict(self):
        return {
            '_': 'ResetWallPapersRequest'
        }

    def _bytes(self):
        return b''.join((
            b'\x04\x98;\xbb',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ResetWebAuthorizationRequest(TLRequest):
    CONSTRUCTOR_ID = 0x2d01b9ef
    SUBCLASS_OF_ID = 0xf5b399ac

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        """
        :returns Bool: This type has no constructors.
        """
        self.hash = hash

    def to_dict(self):
        return {
            '_': 'ResetWebAuthorizationRequest',
            'hash': self.hash
        }

    def _bytes(self):
        return b''.join((
            b'\xef\xb9\x01-',
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_long()
        return cls(hash=_hash)


class ResetWebAuthorizationsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x682d2594
    SUBCLASS_OF_ID = 0xf5b399ac

    def to_dict(self):
        return {
            '_': 'ResetWebAuthorizationsRequest'
        }

    def _bytes(self):
        return b''.join((
            b'\x94%-h',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SaveAutoDownloadSettingsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x76f36233
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, settings: 'TypeAutoDownloadSettings', low: Optional[bool]=None, high: Optional[bool]=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.settings = settings
        self.low = low
        self.high = high

    def to_dict(self):
        return {
            '_': 'SaveAutoDownloadSettingsRequest',
            'settings': self.settings.to_dict() if isinstance(self.settings, TLObject) else self.settings,
            'low': self.low,
            'high': self.high
        }

    def _bytes(self):
        return b''.join((
            b'3b\xf3v',
            struct.pack('<I', (0 if self.low is None or self.low is False else 1) | (0 if self.high is None or self.high is False else 2)),
            self.settings._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _low = bool(flags & 1)
        _high = bool(flags & 2)
        _settings = reader.tgread_object()
        return cls(settings=_settings, low=_low, high=_high)


class SaveSecureValueRequest(TLRequest):
    CONSTRUCTOR_ID = 0x899fe31d
    SUBCLASS_OF_ID = 0x51138ae

    def __init__(self, value: 'TypeInputSecureValue', secure_secret_id: int):
        """
        :returns SecureValue: Instance of SecureValue.
        """
        self.value = value
        self.secure_secret_id = secure_secret_id

    def to_dict(self):
        return {
            '_': 'SaveSecureValueRequest',
            'value': self.value.to_dict() if isinstance(self.value, TLObject) else self.value,
            'secure_secret_id': self.secure_secret_id
        }

    def _bytes(self):
        return b''.join((
            b'\x1d\xe3\x9f\x89',
            self.value._bytes(),
            struct.pack('<q', self.secure_secret_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _value = reader.tgread_object()
        _secure_secret_id = reader.read_long()
        return cls(value=_value, secure_secret_id=_secure_secret_id)


class SaveThemeRequest(TLRequest):
    CONSTRUCTOR_ID = 0xf257106c
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, theme: 'TypeInputTheme', unsave: bool):
        """
        :returns Bool: This type has no constructors.
        """
        self.theme = theme
        self.unsave = unsave

    def to_dict(self):
        return {
            '_': 'SaveThemeRequest',
            'theme': self.theme.to_dict() if isinstance(self.theme, TLObject) else self.theme,
            'unsave': self.unsave
        }

    def _bytes(self):
        return b''.join((
            b'l\x10W\xf2',
            self.theme._bytes(),
            b'\xb5ur\x99' if self.unsave else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _theme = reader.tgread_object()
        _unsave = reader.tgread_bool()
        return cls(theme=_theme, unsave=_unsave)


class SaveWallPaperRequest(TLRequest):
    CONSTRUCTOR_ID = 0x6c5a5b37
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, wallpaper: 'TypeInputWallPaper', unsave: bool, settings: 'TypeWallPaperSettings'):
        """
        :returns Bool: This type has no constructors.
        """
        self.wallpaper = wallpaper
        self.unsave = unsave
        self.settings = settings

    def to_dict(self):
        return {
            '_': 'SaveWallPaperRequest',
            'wallpaper': self.wallpaper.to_dict() if isinstance(self.wallpaper, TLObject) else self.wallpaper,
            'unsave': self.unsave,
            'settings': self.settings.to_dict() if isinstance(self.settings, TLObject) else self.settings
        }

    def _bytes(self):
        return b''.join((
            b'7[Zl',
            self.wallpaper._bytes(),
            b'\xb5ur\x99' if self.unsave else b'7\x97y\xbc',
            self.settings._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _wallpaper = reader.tgread_object()
        _unsave = reader.tgread_bool()
        _settings = reader.tgread_object()
        return cls(wallpaper=_wallpaper, unsave=_unsave, settings=_settings)


class SendChangePhoneCodeRequest(TLRequest):
    CONSTRUCTOR_ID = 0x82574ae5
    SUBCLASS_OF_ID = 0x6ce87081

    def __init__(self, phone_number: str, settings: 'TypeCodeSettings'):
        """
        :returns auth.SentCode: Instance of SentCode.
        """
        self.phone_number = phone_number
        self.settings = settings

    def to_dict(self):
        return {
            '_': 'SendChangePhoneCodeRequest',
            'phone_number': self.phone_number,
            'settings': self.settings.to_dict() if isinstance(self.settings, TLObject) else self.settings
        }

    def _bytes(self):
        return b''.join((
            b'\xe5JW\x82',
            self.serialize_bytes(self.phone_number),
            self.settings._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _settings = reader.tgread_object()
        return cls(phone_number=_phone_number, settings=_settings)


class SendConfirmPhoneCodeRequest(TLRequest):
    CONSTRUCTOR_ID = 0x1b3faa88
    SUBCLASS_OF_ID = 0x6ce87081

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: str, settings: 'TypeCodeSettings'):
        """
        :returns auth.SentCode: Instance of SentCode.
        """
        self.hash = hash
        self.settings = settings

    def to_dict(self):
        return {
            '_': 'SendConfirmPhoneCodeRequest',
            'hash': self.hash,
            'settings': self.settings.to_dict() if isinstance(self.settings, TLObject) else self.settings
        }

    def _bytes(self):
        return b''.join((
            b'\x88\xaa?\x1b',
            self.serialize_bytes(self.hash),
            self.settings._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.tgread_string()
        _settings = reader.tgread_object()
        return cls(hash=_hash, settings=_settings)


class SendVerifyEmailCodeRequest(TLRequest):
    CONSTRUCTOR_ID = 0x7011509f
    SUBCLASS_OF_ID = 0x69f3c06e

    def __init__(self, email: str):
        """
        :returns account.SentEmailCode: Instance of SentEmailCode.
        """
        self.email = email

    def to_dict(self):
        return {
            '_': 'SendVerifyEmailCodeRequest',
            'email': self.email
        }

    def _bytes(self):
        return b''.join((
            b'\x9fP\x11p',
            self.serialize_bytes(self.email),
        ))

    @classmethod
    def from_reader(cls, reader):
        _email = reader.tgread_string()
        return cls(email=_email)


class SendVerifyPhoneCodeRequest(TLRequest):
    CONSTRUCTOR_ID = 0xa5a356f9
    SUBCLASS_OF_ID = 0x6ce87081

    def __init__(self, phone_number: str, settings: 'TypeCodeSettings'):
        """
        :returns auth.SentCode: Instance of SentCode.
        """
        self.phone_number = phone_number
        self.settings = settings

    def to_dict(self):
        return {
            '_': 'SendVerifyPhoneCodeRequest',
            'phone_number': self.phone_number,
            'settings': self.settings.to_dict() if isinstance(self.settings, TLObject) else self.settings
        }

    def _bytes(self):
        return b''.join((
            b'\xf9V\xa3\xa5',
            self.serialize_bytes(self.phone_number),
            self.settings._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _settings = reader.tgread_object()
        return cls(phone_number=_phone_number, settings=_settings)


class SetAccountTTLRequest(TLRequest):
    CONSTRUCTOR_ID = 0x2442485e
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, ttl: 'TypeAccountDaysTTL'):
        """
        :returns Bool: This type has no constructors.
        """
        self.ttl = ttl

    def to_dict(self):
        return {
            '_': 'SetAccountTTLRequest',
            'ttl': self.ttl.to_dict() if isinstance(self.ttl, TLObject) else self.ttl
        }

    def _bytes(self):
        return b''.join((
            b'^HB$',
            self.ttl._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _ttl = reader.tgread_object()
        return cls(ttl=_ttl)


class SetContactSignUpNotificationRequest(TLRequest):
    CONSTRUCTOR_ID = 0xcff43f61
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, silent: bool):
        """
        :returns Bool: This type has no constructors.
        """
        self.silent = silent

    def to_dict(self):
        return {
            '_': 'SetContactSignUpNotificationRequest',
            'silent': self.silent
        }

    def _bytes(self):
        return b''.join((
            b'a?\xf4\xcf',
            b'\xb5ur\x99' if self.silent else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _silent = reader.tgread_bool()
        return cls(silent=_silent)


class SetContentSettingsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xb574b16b
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, sensitive_enabled: Optional[bool]=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.sensitive_enabled = sensitive_enabled

    def to_dict(self):
        return {
            '_': 'SetContentSettingsRequest',
            'sensitive_enabled': self.sensitive_enabled
        }

    def _bytes(self):
        return b''.join((
            b'k\xb1t\xb5',
            struct.pack('<I', (0 if self.sensitive_enabled is None or self.sensitive_enabled is False else 1)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _sensitive_enabled = bool(flags & 1)
        return cls(sensitive_enabled=_sensitive_enabled)


class SetGlobalPrivacySettingsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x1edaaac2
    SUBCLASS_OF_ID = 0xc90e5770

    def __init__(self, settings: 'TypeGlobalPrivacySettings'):
        """
        :returns GlobalPrivacySettings: Instance of GlobalPrivacySettings.
        """
        self.settings = settings

    def to_dict(self):
        return {
            '_': 'SetGlobalPrivacySettingsRequest',
            'settings': self.settings.to_dict() if isinstance(self.settings, TLObject) else self.settings
        }

    def _bytes(self):
        return b''.join((
            b'\xc2\xaa\xda\x1e',
            self.settings._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _settings = reader.tgread_object()
        return cls(settings=_settings)


class SetPrivacyRequest(TLRequest):
    CONSTRUCTOR_ID = 0xc9f81ce8
    SUBCLASS_OF_ID = 0xb55aba82

    def __init__(self, key: 'TypeInputPrivacyKey', rules: List['TypeInputPrivacyRule']):
        """
        :returns account.PrivacyRules: Instance of PrivacyRules.
        """
        self.key = key
        self.rules = rules

    def to_dict(self):
        return {
            '_': 'SetPrivacyRequest',
            'key': self.key.to_dict() if isinstance(self.key, TLObject) else self.key,
            'rules': [] if self.rules is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.rules]
        }

    def _bytes(self):
        return b''.join((
            b'\xe8\x1c\xf8\xc9',
            self.key._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.rules)),b''.join(x._bytes() for x in self.rules),
        ))

    @classmethod
    def from_reader(cls, reader):
        _key = reader.tgread_object()
        reader.read_int()
        _rules = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _rules.append(_x)

        return cls(key=_key, rules=_rules)


class UnregisterDeviceRequest(TLRequest):
    CONSTRUCTOR_ID = 0x3076c4bf
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, token_type: int, token: str, other_uids: List[int]):
        """
        :returns Bool: This type has no constructors.
        """
        self.token_type = token_type
        self.token = token
        self.other_uids = other_uids

    def to_dict(self):
        return {
            '_': 'UnregisterDeviceRequest',
            'token_type': self.token_type,
            'token': self.token,
            'other_uids': [] if self.other_uids is None else self.other_uids[:]
        }

    def _bytes(self):
        return b''.join((
            b'\xbf\xc4v0',
            struct.pack('<i', self.token_type),
            self.serialize_bytes(self.token),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.other_uids)),b''.join(struct.pack('<i', x) for x in self.other_uids),
        ))

    @classmethod
    def from_reader(cls, reader):
        _token_type = reader.read_int()
        _token = reader.tgread_string()
        reader.read_int()
        _other_uids = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _other_uids.append(_x)

        return cls(token_type=_token_type, token=_token, other_uids=_other_uids)


class UpdateDeviceLockedRequest(TLRequest):
    CONSTRUCTOR_ID = 0x38df3532
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, period: int):
        """
        :returns Bool: This type has no constructors.
        """
        self.period = period

    def to_dict(self):
        return {
            '_': 'UpdateDeviceLockedRequest',
            'period': self.period
        }

    def _bytes(self):
        return b''.join((
            b'25\xdf8',
            struct.pack('<i', self.period),
        ))

    @classmethod
    def from_reader(cls, reader):
        _period = reader.read_int()
        return cls(period=_period)


class UpdateNotifySettingsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x84be5b93
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, peer: 'TypeInputNotifyPeer', settings: 'TypeInputPeerNotifySettings'):
        """
        :returns Bool: This type has no constructors.
        """
        self.peer = peer
        self.settings = settings

    async def resolve(self, client, utils):
        self.peer = await client._get_input_notify(self.peer)

    def to_dict(self):
        return {
            '_': 'UpdateNotifySettingsRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'settings': self.settings.to_dict() if isinstance(self.settings, TLObject) else self.settings
        }

    def _bytes(self):
        return b''.join((
            b'\x93[\xbe\x84',
            self.peer._bytes(),
            self.settings._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _settings = reader.tgread_object()
        return cls(peer=_peer, settings=_settings)


class UpdatePasswordSettingsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xa59b102f
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, password: 'TypeInputCheckPasswordSRP', new_settings: 'TypePasswordInputSettings'):
        """
        :returns Bool: This type has no constructors.
        """
        self.password = password
        self.new_settings = new_settings

    def to_dict(self):
        return {
            '_': 'UpdatePasswordSettingsRequest',
            'password': self.password.to_dict() if isinstance(self.password, TLObject) else self.password,
            'new_settings': self.new_settings.to_dict() if isinstance(self.new_settings, TLObject) else self.new_settings
        }

    def _bytes(self):
        return b''.join((
            b'/\x10\x9b\xa5',
            self.password._bytes(),
            self.new_settings._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _password = reader.tgread_object()
        _new_settings = reader.tgread_object()
        return cls(password=_password, new_settings=_new_settings)


class UpdateProfileRequest(TLRequest):
    CONSTRUCTOR_ID = 0x78515775
    SUBCLASS_OF_ID = 0x2da17977

    def __init__(self, first_name: Optional[str]=None, last_name: Optional[str]=None, about: Optional[str]=None):
        """
        :returns User: Instance of either UserEmpty, User.
        """
        self.first_name = first_name
        self.last_name = last_name
        self.about = about

    def to_dict(self):
        return {
            '_': 'UpdateProfileRequest',
            'first_name': self.first_name,
            'last_name': self.last_name,
            'about': self.about
        }

    def _bytes(self):
        return b''.join((
            b'uWQx',
            struct.pack('<I', (0 if self.first_name is None or self.first_name is False else 1) | (0 if self.last_name is None or self.last_name is False else 2) | (0 if self.about is None or self.about is False else 4)),
            b'' if self.first_name is None or self.first_name is False else (self.serialize_bytes(self.first_name)),
            b'' if self.last_name is None or self.last_name is False else (self.serialize_bytes(self.last_name)),
            b'' if self.about is None or self.about is False else (self.serialize_bytes(self.about)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _first_name = reader.tgread_string()
        else:
            _first_name = None
        if flags & 2:
            _last_name = reader.tgread_string()
        else:
            _last_name = None
        if flags & 4:
            _about = reader.tgread_string()
        else:
            _about = None
        return cls(first_name=_first_name, last_name=_last_name, about=_about)


class UpdateStatusRequest(TLRequest):
    CONSTRUCTOR_ID = 0x6628562c
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, offline: bool):
        """
        :returns Bool: This type has no constructors.
        """
        self.offline = offline

    def to_dict(self):
        return {
            '_': 'UpdateStatusRequest',
            'offline': self.offline
        }

    def _bytes(self):
        return b''.join((
            b',V(f',
            b'\xb5ur\x99' if self.offline else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _offline = reader.tgread_bool()
        return cls(offline=_offline)


class UpdateThemeRequest(TLRequest):
    CONSTRUCTOR_ID = 0x5cb367d5
    SUBCLASS_OF_ID = 0x56b4c80c

    # noinspection PyShadowingBuiltins
    def __init__(self, format: str, theme: 'TypeInputTheme', slug: Optional[str]=None, title: Optional[str]=None, document: Optional['TypeInputDocument']=None, settings: Optional['TypeInputThemeSettings']=None):
        """
        :returns Theme: Instance of Theme.
        """
        self.format = format
        self.theme = theme
        self.slug = slug
        self.title = title
        self.document = document
        self.settings = settings

    async def resolve(self, client, utils):
        if self.document:
            self.document = utils.get_input_document(self.document)

    def to_dict(self):
        return {
            '_': 'UpdateThemeRequest',
            'format': self.format,
            'theme': self.theme.to_dict() if isinstance(self.theme, TLObject) else self.theme,
            'slug': self.slug,
            'title': self.title,
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document,
            'settings': self.settings.to_dict() if isinstance(self.settings, TLObject) else self.settings
        }

    def _bytes(self):
        return b''.join((
            b'\xd5g\xb3\\',
            struct.pack('<I', (0 if self.slug is None or self.slug is False else 1) | (0 if self.title is None or self.title is False else 2) | (0 if self.document is None or self.document is False else 4) | (0 if self.settings is None or self.settings is False else 8)),
            self.serialize_bytes(self.format),
            self.theme._bytes(),
            b'' if self.slug is None or self.slug is False else (self.serialize_bytes(self.slug)),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
            b'' if self.document is None or self.document is False else (self.document._bytes()),
            b'' if self.settings is None or self.settings is False else (self.settings._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _format = reader.tgread_string()
        _theme = reader.tgread_object()
        if flags & 1:
            _slug = reader.tgread_string()
        else:
            _slug = None
        if flags & 2:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 4:
            _document = reader.tgread_object()
        else:
            _document = None
        if flags & 8:
            _settings = reader.tgread_object()
        else:
            _settings = None
        return cls(format=_format, theme=_theme, slug=_slug, title=_title, document=_document, settings=_settings)


class UpdateUsernameRequest(TLRequest):
    CONSTRUCTOR_ID = 0x3e0bdd7c
    SUBCLASS_OF_ID = 0x2da17977

    def __init__(self, username: str):
        """
        :returns User: Instance of either UserEmpty, User.
        """
        self.username = username

    def to_dict(self):
        return {
            '_': 'UpdateUsernameRequest',
            'username': self.username
        }

    def _bytes(self):
        return b''.join((
            b'|\xdd\x0b>',
            self.serialize_bytes(self.username),
        ))

    @classmethod
    def from_reader(cls, reader):
        _username = reader.tgread_string()
        return cls(username=_username)


class UploadThemeRequest(TLRequest):
    CONSTRUCTOR_ID = 0x1c3db333
    SUBCLASS_OF_ID = 0x211fe820

    def __init__(self, file: 'TypeInputFile', file_name: str, mime_type: str, thumb: Optional['TypeInputFile']=None):
        """
        :returns Document: Instance of either DocumentEmpty, Document.
        """
        self.file = file
        self.file_name = file_name
        self.mime_type = mime_type
        self.thumb = thumb

    def to_dict(self):
        return {
            '_': 'UploadThemeRequest',
            'file': self.file.to_dict() if isinstance(self.file, TLObject) else self.file,
            'file_name': self.file_name,
            'mime_type': self.mime_type,
            'thumb': self.thumb.to_dict() if isinstance(self.thumb, TLObject) else self.thumb
        }

    def _bytes(self):
        return b''.join((
            b'3\xb3=\x1c',
            struct.pack('<I', (0 if self.thumb is None or self.thumb is False else 1)),
            self.file._bytes(),
            b'' if self.thumb is None or self.thumb is False else (self.thumb._bytes()),
            self.serialize_bytes(self.file_name),
            self.serialize_bytes(self.mime_type),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _file = reader.tgread_object()
        if flags & 1:
            _thumb = reader.tgread_object()
        else:
            _thumb = None
        _file_name = reader.tgread_string()
        _mime_type = reader.tgread_string()
        return cls(file=_file, file_name=_file_name, mime_type=_mime_type, thumb=_thumb)


class UploadWallPaperRequest(TLRequest):
    CONSTRUCTOR_ID = 0xdd853661
    SUBCLASS_OF_ID = 0x96a2c98b

    def __init__(self, file: 'TypeInputFile', mime_type: str, settings: 'TypeWallPaperSettings'):
        """
        :returns WallPaper: Instance of either WallPaper, WallPaperNoFile.
        """
        self.file = file
        self.mime_type = mime_type
        self.settings = settings

    def to_dict(self):
        return {
            '_': 'UploadWallPaperRequest',
            'file': self.file.to_dict() if isinstance(self.file, TLObject) else self.file,
            'mime_type': self.mime_type,
            'settings': self.settings.to_dict() if isinstance(self.settings, TLObject) else self.settings
        }

    def _bytes(self):
        return b''.join((
            b'a6\x85\xdd',
            self.file._bytes(),
            self.serialize_bytes(self.mime_type),
            self.settings._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _file = reader.tgread_object()
        _mime_type = reader.tgread_string()
        _settings = reader.tgread_object()
        return cls(file=_file, mime_type=_mime_type, settings=_settings)


class VerifyEmailRequest(TLRequest):
    CONSTRUCTOR_ID = 0xecba39db
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, email: str, code: str):
        """
        :returns Bool: This type has no constructors.
        """
        self.email = email
        self.code = code

    def to_dict(self):
        return {
            '_': 'VerifyEmailRequest',
            'email': self.email,
            'code': self.code
        }

    def _bytes(self):
        return b''.join((
            b'\xdb9\xba\xec',
            self.serialize_bytes(self.email),
            self.serialize_bytes(self.code),
        ))

    @classmethod
    def from_reader(cls, reader):
        _email = reader.tgread_string()
        _code = reader.tgread_string()
        return cls(email=_email, code=_code)


class VerifyPhoneRequest(TLRequest):
    CONSTRUCTOR_ID = 0x4dd3a7f6
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, phone_number: str, phone_code_hash: str, phone_code: str):
        """
        :returns Bool: This type has no constructors.
        """
        self.phone_number = phone_number
        self.phone_code_hash = phone_code_hash
        self.phone_code = phone_code

    def to_dict(self):
        return {
            '_': 'VerifyPhoneRequest',
            'phone_number': self.phone_number,
            'phone_code_hash': self.phone_code_hash,
            'phone_code': self.phone_code
        }

    def _bytes(self):
        return b''.join((
            b'\xf6\xa7\xd3M',
            self.serialize_bytes(self.phone_number),
            self.serialize_bytes(self.phone_code_hash),
            self.serialize_bytes(self.phone_code),
        ))

    @classmethod
    def from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _phone_code_hash = reader.tgread_string()
        _phone_code = reader.tgread_string()
        return cls(phone_number=_phone_number, phone_code_hash=_phone_code_hash, phone_code=_phone_code)

