"""File generated by TLObjects' generator. All changes will be ERASED"""
from ...tl.tlobject import TLObject
from ...tl.tlobject import TLRequest
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
from datetime import datetime
if TYPE_CHECKING:
    from ...tl.types import TypeDataJSON, TypeInputPhoneCall, TypeInputUser, TypePhoneCallDiscardReason, TypePhoneCallProtocol



class AcceptCallRequest(TLRequest):
    CONSTRUCTOR_ID = 0x3bd2b4a0
    SUBCLASS_OF_ID = 0xd48afe4f

    def __init__(self, peer: 'TypeInputPhoneCall', g_b: bytes, protocol: 'TypePhoneCallProtocol'):
        """
        :returns phone.PhoneCall: Instance of PhoneCall.
        """
        self.peer = peer
        self.g_b = g_b
        self.protocol = protocol

    def to_dict(self):
        return {
            '_': 'AcceptCallRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'g_b': self.g_b,
            'protocol': self.protocol.to_dict() if isinstance(self.protocol, TLObject) else self.protocol
        }

    def _bytes(self):
        return b''.join((
            b'\xa0\xb4\xd2;',
            self.peer._bytes(),
            self.serialize_bytes(self.g_b),
            self.protocol._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _g_b = reader.tgread_bytes()
        _protocol = reader.tgread_object()
        return cls(peer=_peer, g_b=_g_b, protocol=_protocol)


class ConfirmCallRequest(TLRequest):
    CONSTRUCTOR_ID = 0x2efe1722
    SUBCLASS_OF_ID = 0xd48afe4f

    def __init__(self, peer: 'TypeInputPhoneCall', g_a: bytes, key_fingerprint: int, protocol: 'TypePhoneCallProtocol'):
        """
        :returns phone.PhoneCall: Instance of PhoneCall.
        """
        self.peer = peer
        self.g_a = g_a
        self.key_fingerprint = key_fingerprint
        self.protocol = protocol

    def to_dict(self):
        return {
            '_': 'ConfirmCallRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'g_a': self.g_a,
            'key_fingerprint': self.key_fingerprint,
            'protocol': self.protocol.to_dict() if isinstance(self.protocol, TLObject) else self.protocol
        }

    def _bytes(self):
        return b''.join((
            b'"\x17\xfe.',
            self.peer._bytes(),
            self.serialize_bytes(self.g_a),
            struct.pack('<q', self.key_fingerprint),
            self.protocol._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _g_a = reader.tgread_bytes()
        _key_fingerprint = reader.read_long()
        _protocol = reader.tgread_object()
        return cls(peer=_peer, g_a=_g_a, key_fingerprint=_key_fingerprint, protocol=_protocol)


class DiscardCallRequest(TLRequest):
    CONSTRUCTOR_ID = 0xb2cbc1c0
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, peer: 'TypeInputPhoneCall', duration: int, reason: 'TypePhoneCallDiscardReason', connection_id: int, video: Optional[bool]=None):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.peer = peer
        self.duration = duration
        self.reason = reason
        self.connection_id = connection_id
        self.video = video

    def to_dict(self):
        return {
            '_': 'DiscardCallRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'duration': self.duration,
            'reason': self.reason.to_dict() if isinstance(self.reason, TLObject) else self.reason,
            'connection_id': self.connection_id,
            'video': self.video
        }

    def _bytes(self):
        return b''.join((
            b'\xc0\xc1\xcb\xb2',
            struct.pack('<I', (0 if self.video is None or self.video is False else 1)),
            self.peer._bytes(),
            struct.pack('<i', self.duration),
            self.reason._bytes(),
            struct.pack('<q', self.connection_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _video = bool(flags & 1)
        _peer = reader.tgread_object()
        _duration = reader.read_int()
        _reason = reader.tgread_object()
        _connection_id = reader.read_long()
        return cls(peer=_peer, duration=_duration, reason=_reason, connection_id=_connection_id, video=_video)


class GetCallConfigRequest(TLRequest):
    CONSTRUCTOR_ID = 0x55451fa9
    SUBCLASS_OF_ID = 0xad0352e8

    def to_dict(self):
        return {
            '_': 'GetCallConfigRequest'
        }

    def _bytes(self):
        return b''.join((
            b'\xa9\x1fEU',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ReceivedCallRequest(TLRequest):
    CONSTRUCTOR_ID = 0x17d54f61
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, peer: 'TypeInputPhoneCall'):
        """
        :returns Bool: This type has no constructors.
        """
        self.peer = peer

    def to_dict(self):
        return {
            '_': 'ReceivedCallRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def _bytes(self):
        return b''.join((
            b'aO\xd5\x17',
            self.peer._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class RequestCallRequest(TLRequest):
    CONSTRUCTOR_ID = 0x42ff96ed
    SUBCLASS_OF_ID = 0xd48afe4f

    def __init__(self, user_id: 'TypeInputUser', g_a_hash: bytes, protocol: 'TypePhoneCallProtocol', video: Optional[bool]=None, random_id: int=None):
        """
        :returns phone.PhoneCall: Instance of PhoneCall.
        """
        self.user_id = user_id
        self.g_a_hash = g_a_hash
        self.protocol = protocol
        self.video = video
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(4), 'big', signed=True)

    async def resolve(self, client, utils):
        self.user_id = utils.get_input_user(await client.get_input_entity(self.user_id))

    def to_dict(self):
        return {
            '_': 'RequestCallRequest',
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id,
            'g_a_hash': self.g_a_hash,
            'protocol': self.protocol.to_dict() if isinstance(self.protocol, TLObject) else self.protocol,
            'video': self.video,
            'random_id': self.random_id
        }

    def _bytes(self):
        return b''.join((
            b'\xed\x96\xffB',
            struct.pack('<I', (0 if self.video is None or self.video is False else 1)),
            self.user_id._bytes(),
            struct.pack('<i', self.random_id),
            self.serialize_bytes(self.g_a_hash),
            self.protocol._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _video = bool(flags & 1)
        _user_id = reader.tgread_object()
        _random_id = reader.read_int()
        _g_a_hash = reader.tgread_bytes()
        _protocol = reader.tgread_object()
        return cls(user_id=_user_id, g_a_hash=_g_a_hash, protocol=_protocol, video=_video, random_id=_random_id)


class SaveCallDebugRequest(TLRequest):
    CONSTRUCTOR_ID = 0x277add7e
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, peer: 'TypeInputPhoneCall', debug: 'TypeDataJSON'):
        """
        :returns Bool: This type has no constructors.
        """
        self.peer = peer
        self.debug = debug

    def to_dict(self):
        return {
            '_': 'SaveCallDebugRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'debug': self.debug.to_dict() if isinstance(self.debug, TLObject) else self.debug
        }

    def _bytes(self):
        return b''.join((
            b"~\xddz'",
            self.peer._bytes(),
            self.debug._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _debug = reader.tgread_object()
        return cls(peer=_peer, debug=_debug)


class SendSignalingDataRequest(TLRequest):
    CONSTRUCTOR_ID = 0xff7a9383
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, peer: 'TypeInputPhoneCall', data: bytes):
        """
        :returns Bool: This type has no constructors.
        """
        self.peer = peer
        self.data = data

    def to_dict(self):
        return {
            '_': 'SendSignalingDataRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'data': self.data
        }

    def _bytes(self):
        return b''.join((
            b'\x83\x93z\xff',
            self.peer._bytes(),
            self.serialize_bytes(self.data),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _data = reader.tgread_bytes()
        return cls(peer=_peer, data=_data)


class SetCallRatingRequest(TLRequest):
    CONSTRUCTOR_ID = 0x59ead627
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, peer: 'TypeInputPhoneCall', rating: int, comment: str, user_initiative: Optional[bool]=None):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.peer = peer
        self.rating = rating
        self.comment = comment
        self.user_initiative = user_initiative

    def to_dict(self):
        return {
            '_': 'SetCallRatingRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'rating': self.rating,
            'comment': self.comment,
            'user_initiative': self.user_initiative
        }

    def _bytes(self):
        return b''.join((
            b"'\xd6\xeaY",
            struct.pack('<I', (0 if self.user_initiative is None or self.user_initiative is False else 1)),
            self.peer._bytes(),
            struct.pack('<i', self.rating),
            self.serialize_bytes(self.comment),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _user_initiative = bool(flags & 1)
        _peer = reader.tgread_object()
        _rating = reader.read_int()
        _comment = reader.tgread_string()
        return cls(peer=_peer, rating=_rating, comment=_comment, user_initiative=_user_initiative)

