"""File generated by TLObjects' generator. All changes will be ERASED"""
from ...tl.tlobject import TLObject
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
from datetime import datetime
if TYPE_CHECKING:
    from ...tl.types import TypeBotInlineResult, TypeChat, TypeChatFull, TypeDialog, TypeDocument, TypeEncryptedFile, TypeHighScore, TypeInlineBotSwitchPM, TypeMessage, TypeMessageUserVote, TypeMessageViews, TypeMessagesFilter, TypeStickerPack, TypeStickerSet, TypeStickerSetCovered, TypeUser
    from ...tl.types.updates import TypeState



class AffectedHistory(TLObject):
    CONSTRUCTOR_ID = 0xb45c69d1
    SUBCLASS_OF_ID = 0x2c49c116

    def __init__(self, pts: int, pts_count: int, offset: int):
        """
        Constructor for messages.AffectedHistory: Instance of AffectedHistory.
        """
        self.pts = pts
        self.pts_count = pts_count
        self.offset = offset

    def to_dict(self):
        return {
            '_': 'AffectedHistory',
            'pts': self.pts,
            'pts_count': self.pts_count,
            'offset': self.offset
        }

    def _bytes(self):
        return b''.join((
            b'\xd1i\\\xb4',
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
            struct.pack('<i', self.offset),
        ))

    @classmethod
    def from_reader(cls, reader):
        _pts = reader.read_int()
        _pts_count = reader.read_int()
        _offset = reader.read_int()
        return cls(pts=_pts, pts_count=_pts_count, offset=_offset)


class AffectedMessages(TLObject):
    CONSTRUCTOR_ID = 0x84d19185
    SUBCLASS_OF_ID = 0xced3c06e

    def __init__(self, pts: int, pts_count: int):
        """
        Constructor for messages.AffectedMessages: Instance of AffectedMessages.
        """
        self.pts = pts
        self.pts_count = pts_count

    def to_dict(self):
        return {
            '_': 'AffectedMessages',
            'pts': self.pts,
            'pts_count': self.pts_count
        }

    def _bytes(self):
        return b''.join((
            b'\x85\x91\xd1\x84',
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
        ))

    @classmethod
    def from_reader(cls, reader):
        _pts = reader.read_int()
        _pts_count = reader.read_int()
        return cls(pts=_pts, pts_count=_pts_count)


class AllStickers(TLObject):
    CONSTRUCTOR_ID = 0xedfd405f
    SUBCLASS_OF_ID = 0x45834829

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, sets: List['TypeStickerSet']):
        """
        Constructor for messages.AllStickers: Instance of either AllStickersNotModified, AllStickers.
        """
        self.hash = hash
        self.sets = sets

    def to_dict(self):
        return {
            '_': 'AllStickers',
            'hash': self.hash,
            'sets': [] if self.sets is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.sets]
        }

    def _bytes(self):
        return b''.join((
            b'_@\xfd\xed',
            struct.pack('<i', self.hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.sets)),b''.join(x._bytes() for x in self.sets),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_int()
        reader.read_int()
        _sets = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _sets.append(_x)

        return cls(hash=_hash, sets=_sets)


class AllStickersNotModified(TLObject):
    CONSTRUCTOR_ID = 0xe86602c3
    SUBCLASS_OF_ID = 0x45834829

    def to_dict(self):
        return {
            '_': 'AllStickersNotModified'
        }

    def _bytes(self):
        return b''.join((
            b'\xc3\x02f\xe8',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ArchivedStickers(TLObject):
    CONSTRUCTOR_ID = 0x4fcba9c8
    SUBCLASS_OF_ID = 0x7296d771

    def __init__(self, count: int, sets: List['TypeStickerSetCovered']):
        """
        Constructor for messages.ArchivedStickers: Instance of ArchivedStickers.
        """
        self.count = count
        self.sets = sets

    def to_dict(self):
        return {
            '_': 'ArchivedStickers',
            'count': self.count,
            'sets': [] if self.sets is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.sets]
        }

    def _bytes(self):
        return b''.join((
            b'\xc8\xa9\xcbO',
            struct.pack('<i', self.count),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.sets)),b''.join(x._bytes() for x in self.sets),
        ))

    @classmethod
    def from_reader(cls, reader):
        _count = reader.read_int()
        reader.read_int()
        _sets = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _sets.append(_x)

        return cls(count=_count, sets=_sets)


class BotCallbackAnswer(TLObject):
    CONSTRUCTOR_ID = 0x36585ea4
    SUBCLASS_OF_ID = 0x6c4dd18c

    def __init__(self, cache_time: int, alert: Optional[bool]=None, has_url: Optional[bool]=None, native_ui: Optional[bool]=None, message: Optional[str]=None, url: Optional[str]=None):
        """
        Constructor for messages.BotCallbackAnswer: Instance of BotCallbackAnswer.
        """
        self.cache_time = cache_time
        self.alert = alert
        self.has_url = has_url
        self.native_ui = native_ui
        self.message = message
        self.url = url

    def to_dict(self):
        return {
            '_': 'BotCallbackAnswer',
            'cache_time': self.cache_time,
            'alert': self.alert,
            'has_url': self.has_url,
            'native_ui': self.native_ui,
            'message': self.message,
            'url': self.url
        }

    def _bytes(self):
        return b''.join((
            b'\xa4^X6',
            struct.pack('<I', (0 if self.alert is None or self.alert is False else 2) | (0 if self.has_url is None or self.has_url is False else 8) | (0 if self.native_ui is None or self.native_ui is False else 16) | (0 if self.message is None or self.message is False else 1) | (0 if self.url is None or self.url is False else 4)),
            b'' if self.message is None or self.message is False else (self.serialize_bytes(self.message)),
            b'' if self.url is None or self.url is False else (self.serialize_bytes(self.url)),
            struct.pack('<i', self.cache_time),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _alert = bool(flags & 2)
        _has_url = bool(flags & 8)
        _native_ui = bool(flags & 16)
        if flags & 1:
            _message = reader.tgread_string()
        else:
            _message = None
        if flags & 4:
            _url = reader.tgread_string()
        else:
            _url = None
        _cache_time = reader.read_int()
        return cls(cache_time=_cache_time, alert=_alert, has_url=_has_url, native_ui=_native_ui, message=_message, url=_url)


class BotResults(TLObject):
    CONSTRUCTOR_ID = 0x947ca848
    SUBCLASS_OF_ID = 0x3ed4d9c9

    def __init__(self, query_id: int, results: List['TypeBotInlineResult'], cache_time: int, users: List['TypeUser'], gallery: Optional[bool]=None, next_offset: Optional[str]=None, switch_pm: Optional['TypeInlineBotSwitchPM']=None):
        """
        Constructor for messages.BotResults: Instance of BotResults.
        """
        self.query_id = query_id
        self.results = results
        self.cache_time = cache_time
        self.users = users
        self.gallery = gallery
        self.next_offset = next_offset
        self.switch_pm = switch_pm

    def to_dict(self):
        return {
            '_': 'BotResults',
            'query_id': self.query_id,
            'results': [] if self.results is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.results],
            'cache_time': self.cache_time,
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users],
            'gallery': self.gallery,
            'next_offset': self.next_offset,
            'switch_pm': self.switch_pm.to_dict() if isinstance(self.switch_pm, TLObject) else self.switch_pm
        }

    def _bytes(self):
        return b''.join((
            b'H\xa8|\x94',
            struct.pack('<I', (0 if self.gallery is None or self.gallery is False else 1) | (0 if self.next_offset is None or self.next_offset is False else 2) | (0 if self.switch_pm is None or self.switch_pm is False else 4)),
            struct.pack('<q', self.query_id),
            b'' if self.next_offset is None or self.next_offset is False else (self.serialize_bytes(self.next_offset)),
            b'' if self.switch_pm is None or self.switch_pm is False else (self.switch_pm._bytes()),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.results)),b''.join(x._bytes() for x in self.results),
            struct.pack('<i', self.cache_time),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _gallery = bool(flags & 1)
        _query_id = reader.read_long()
        if flags & 2:
            _next_offset = reader.tgread_string()
        else:
            _next_offset = None
        if flags & 4:
            _switch_pm = reader.tgread_object()
        else:
            _switch_pm = None
        reader.read_int()
        _results = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _results.append(_x)

        _cache_time = reader.read_int()
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(query_id=_query_id, results=_results, cache_time=_cache_time, users=_users, gallery=_gallery, next_offset=_next_offset, switch_pm=_switch_pm)


class ChannelMessages(TLObject):
    CONSTRUCTOR_ID = 0x64479808
    SUBCLASS_OF_ID = 0xd4b40b5e

    def __init__(self, pts: int, count: int, messages: List['TypeMessage'], chats: List['TypeChat'], users: List['TypeUser'], inexact: Optional[bool]=None, offset_id_offset: Optional[int]=None):
        """
        Constructor for messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
        """
        self.pts = pts
        self.count = count
        self.messages = messages
        self.chats = chats
        self.users = users
        self.inexact = inexact
        self.offset_id_offset = offset_id_offset

    def to_dict(self):
        return {
            '_': 'ChannelMessages',
            'pts': self.pts,
            'count': self.count,
            'messages': [] if self.messages is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.messages],
            'chats': [] if self.chats is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.chats],
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users],
            'inexact': self.inexact,
            'offset_id_offset': self.offset_id_offset
        }

    def _bytes(self):
        return b''.join((
            b'\x08\x98Gd',
            struct.pack('<I', (0 if self.inexact is None or self.inexact is False else 2) | (0 if self.offset_id_offset is None or self.offset_id_offset is False else 4)),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.count),
            b'' if self.offset_id_offset is None or self.offset_id_offset is False else (struct.pack('<i', self.offset_id_offset)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(x._bytes() for x in self.messages),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _inexact = bool(flags & 2)
        _pts = reader.read_int()
        _count = reader.read_int()
        if flags & 4:
            _offset_id_offset = reader.read_int()
        else:
            _offset_id_offset = None
        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _messages.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(pts=_pts, count=_count, messages=_messages, chats=_chats, users=_users, inexact=_inexact, offset_id_offset=_offset_id_offset)


class ChatFull(TLObject):
    CONSTRUCTOR_ID = 0xe5d7d19c
    SUBCLASS_OF_ID = 0x225a5109

    def __init__(self, full_chat: 'TypeChatFull', chats: List['TypeChat'], users: List['TypeUser']):
        """
        Constructor for messages.ChatFull: Instance of ChatFull.
        """
        self.full_chat = full_chat
        self.chats = chats
        self.users = users

    def to_dict(self):
        return {
            '_': 'ChatFull',
            'full_chat': self.full_chat.to_dict() if isinstance(self.full_chat, TLObject) else self.full_chat,
            'chats': [] if self.chats is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.chats],
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users]
        }

    def _bytes(self):
        return b''.join((
            b'\x9c\xd1\xd7\xe5',
            self.full_chat._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        _full_chat = reader.tgread_object()
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(full_chat=_full_chat, chats=_chats, users=_users)


class Chats(TLObject):
    CONSTRUCTOR_ID = 0x64ff9fd5
    SUBCLASS_OF_ID = 0x99d5cb14

    def __init__(self, chats: List['TypeChat']):
        """
        Constructor for messages.Chats: Instance of either Chats, ChatsSlice.
        """
        self.chats = chats

    def to_dict(self):
        return {
            '_': 'Chats',
            'chats': [] if self.chats is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.chats]
        }

    def _bytes(self):
        return b''.join((
            b'\xd5\x9f\xffd',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        return cls(chats=_chats)


class ChatsSlice(TLObject):
    CONSTRUCTOR_ID = 0x9cd81144
    SUBCLASS_OF_ID = 0x99d5cb14

    def __init__(self, count: int, chats: List['TypeChat']):
        """
        Constructor for messages.Chats: Instance of either Chats, ChatsSlice.
        """
        self.count = count
        self.chats = chats

    def to_dict(self):
        return {
            '_': 'ChatsSlice',
            'count': self.count,
            'chats': [] if self.chats is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.chats]
        }

    def _bytes(self):
        return b''.join((
            b'D\x11\xd8\x9c',
            struct.pack('<i', self.count),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
        ))

    @classmethod
    def from_reader(cls, reader):
        _count = reader.read_int()
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        return cls(count=_count, chats=_chats)


class DhConfig(TLObject):
    CONSTRUCTOR_ID = 0x2c221edd
    SUBCLASS_OF_ID = 0xe488ed8b

    def __init__(self, g: int, p: bytes, version: int, random: bytes):
        """
        Constructor for messages.DhConfig: Instance of either DhConfigNotModified, DhConfig.
        """
        self.g = g
        self.p = p
        self.version = version
        self.random = random

    def to_dict(self):
        return {
            '_': 'DhConfig',
            'g': self.g,
            'p': self.p,
            'version': self.version,
            'random': self.random
        }

    def _bytes(self):
        return b''.join((
            b'\xdd\x1e",',
            struct.pack('<i', self.g),
            self.serialize_bytes(self.p),
            struct.pack('<i', self.version),
            self.serialize_bytes(self.random),
        ))

    @classmethod
    def from_reader(cls, reader):
        _g = reader.read_int()
        _p = reader.tgread_bytes()
        _version = reader.read_int()
        _random = reader.tgread_bytes()
        return cls(g=_g, p=_p, version=_version, random=_random)


class DhConfigNotModified(TLObject):
    CONSTRUCTOR_ID = 0xc0e24635
    SUBCLASS_OF_ID = 0xe488ed8b

    def __init__(self, random: bytes):
        """
        Constructor for messages.DhConfig: Instance of either DhConfigNotModified, DhConfig.
        """
        self.random = random

    def to_dict(self):
        return {
            '_': 'DhConfigNotModified',
            'random': self.random
        }

    def _bytes(self):
        return b''.join((
            b'5F\xe2\xc0',
            self.serialize_bytes(self.random),
        ))

    @classmethod
    def from_reader(cls, reader):
        _random = reader.tgread_bytes()
        return cls(random=_random)


class Dialogs(TLObject):
    CONSTRUCTOR_ID = 0x15ba6c40
    SUBCLASS_OF_ID = 0xe1b52ee

    def __init__(self, dialogs: List['TypeDialog'], messages: List['TypeMessage'], chats: List['TypeChat'], users: List['TypeUser']):
        """
        Constructor for messages.Dialogs: Instance of either Dialogs, DialogsSlice, DialogsNotModified.
        """
        self.dialogs = dialogs
        self.messages = messages
        self.chats = chats
        self.users = users

    def to_dict(self):
        return {
            '_': 'Dialogs',
            'dialogs': [] if self.dialogs is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.dialogs],
            'messages': [] if self.messages is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.messages],
            'chats': [] if self.chats is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.chats],
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users]
        }

    def _bytes(self):
        return b''.join((
            b'@l\xba\x15',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.dialogs)),b''.join(x._bytes() for x in self.dialogs),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(x._bytes() for x in self.messages),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _dialogs = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _dialogs.append(_x)

        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _messages.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(dialogs=_dialogs, messages=_messages, chats=_chats, users=_users)


class DialogsNotModified(TLObject):
    CONSTRUCTOR_ID = 0xf0e3e596
    SUBCLASS_OF_ID = 0xe1b52ee

    def __init__(self, count: int):
        """
        Constructor for messages.Dialogs: Instance of either Dialogs, DialogsSlice, DialogsNotModified.
        """
        self.count = count

    def to_dict(self):
        return {
            '_': 'DialogsNotModified',
            'count': self.count
        }

    def _bytes(self):
        return b''.join((
            b'\x96\xe5\xe3\xf0',
            struct.pack('<i', self.count),
        ))

    @classmethod
    def from_reader(cls, reader):
        _count = reader.read_int()
        return cls(count=_count)


class DialogsSlice(TLObject):
    CONSTRUCTOR_ID = 0x71e094f3
    SUBCLASS_OF_ID = 0xe1b52ee

    def __init__(self, count: int, dialogs: List['TypeDialog'], messages: List['TypeMessage'], chats: List['TypeChat'], users: List['TypeUser']):
        """
        Constructor for messages.Dialogs: Instance of either Dialogs, DialogsSlice, DialogsNotModified.
        """
        self.count = count
        self.dialogs = dialogs
        self.messages = messages
        self.chats = chats
        self.users = users

    def to_dict(self):
        return {
            '_': 'DialogsSlice',
            'count': self.count,
            'dialogs': [] if self.dialogs is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.dialogs],
            'messages': [] if self.messages is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.messages],
            'chats': [] if self.chats is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.chats],
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users]
        }

    def _bytes(self):
        return b''.join((
            b'\xf3\x94\xe0q',
            struct.pack('<i', self.count),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.dialogs)),b''.join(x._bytes() for x in self.dialogs),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(x._bytes() for x in self.messages),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        _count = reader.read_int()
        reader.read_int()
        _dialogs = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _dialogs.append(_x)

        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _messages.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(count=_count, dialogs=_dialogs, messages=_messages, chats=_chats, users=_users)


class DiscussionMessage(TLObject):
    CONSTRUCTOR_ID = 0xf5dd8f9d
    SUBCLASS_OF_ID = 0x53f8e3e8

    def __init__(self, messages: List['TypeMessage'], chats: List['TypeChat'], users: List['TypeUser'], max_id: Optional[int]=None, read_inbox_max_id: Optional[int]=None, read_outbox_max_id: Optional[int]=None):
        """
        Constructor for messages.DiscussionMessage: Instance of DiscussionMessage.
        """
        self.messages = messages
        self.chats = chats
        self.users = users
        self.max_id = max_id
        self.read_inbox_max_id = read_inbox_max_id
        self.read_outbox_max_id = read_outbox_max_id

    def to_dict(self):
        return {
            '_': 'DiscussionMessage',
            'messages': [] if self.messages is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.messages],
            'chats': [] if self.chats is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.chats],
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users],
            'max_id': self.max_id,
            'read_inbox_max_id': self.read_inbox_max_id,
            'read_outbox_max_id': self.read_outbox_max_id
        }

    def _bytes(self):
        return b''.join((
            b'\x9d\x8f\xdd\xf5',
            struct.pack('<I', (0 if self.max_id is None or self.max_id is False else 1) | (0 if self.read_inbox_max_id is None or self.read_inbox_max_id is False else 2) | (0 if self.read_outbox_max_id is None or self.read_outbox_max_id is False else 4)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(x._bytes() for x in self.messages),
            b'' if self.max_id is None or self.max_id is False else (struct.pack('<i', self.max_id)),
            b'' if self.read_inbox_max_id is None or self.read_inbox_max_id is False else (struct.pack('<i', self.read_inbox_max_id)),
            b'' if self.read_outbox_max_id is None or self.read_outbox_max_id is False else (struct.pack('<i', self.read_outbox_max_id)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _messages.append(_x)

        if flags & 1:
            _max_id = reader.read_int()
        else:
            _max_id = None
        if flags & 2:
            _read_inbox_max_id = reader.read_int()
        else:
            _read_inbox_max_id = None
        if flags & 4:
            _read_outbox_max_id = reader.read_int()
        else:
            _read_outbox_max_id = None
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(messages=_messages, chats=_chats, users=_users, max_id=_max_id, read_inbox_max_id=_read_inbox_max_id, read_outbox_max_id=_read_outbox_max_id)


class FavedStickers(TLObject):
    CONSTRUCTOR_ID = 0xf37f2f16
    SUBCLASS_OF_ID = 0x8e736fb9

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, packs: List['TypeStickerPack'], stickers: List['TypeDocument']):
        """
        Constructor for messages.FavedStickers: Instance of either FavedStickersNotModified, FavedStickers.
        """
        self.hash = hash
        self.packs = packs
        self.stickers = stickers

    def to_dict(self):
        return {
            '_': 'FavedStickers',
            'hash': self.hash,
            'packs': [] if self.packs is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.packs],
            'stickers': [] if self.stickers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.stickers]
        }

    def _bytes(self):
        return b''.join((
            b'\x16/\x7f\xf3',
            struct.pack('<i', self.hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.packs)),b''.join(x._bytes() for x in self.packs),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.stickers)),b''.join(x._bytes() for x in self.stickers),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_int()
        reader.read_int()
        _packs = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _packs.append(_x)

        reader.read_int()
        _stickers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _stickers.append(_x)

        return cls(hash=_hash, packs=_packs, stickers=_stickers)


class FavedStickersNotModified(TLObject):
    CONSTRUCTOR_ID = 0x9e8fa6d3
    SUBCLASS_OF_ID = 0x8e736fb9

    def to_dict(self):
        return {
            '_': 'FavedStickersNotModified'
        }

    def _bytes(self):
        return b''.join((
            b'\xd3\xa6\x8f\x9e',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class FeaturedStickers(TLObject):
    CONSTRUCTOR_ID = 0xb6abc341
    SUBCLASS_OF_ID = 0x2614b722

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, count: int, sets: List['TypeStickerSetCovered'], unread: List[int]):
        """
        Constructor for messages.FeaturedStickers: Instance of either FeaturedStickersNotModified, FeaturedStickers.
        """
        self.hash = hash
        self.count = count
        self.sets = sets
        self.unread = unread

    def to_dict(self):
        return {
            '_': 'FeaturedStickers',
            'hash': self.hash,
            'count': self.count,
            'sets': [] if self.sets is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.sets],
            'unread': [] if self.unread is None else self.unread[:]
        }

    def _bytes(self):
        return b''.join((
            b'A\xc3\xab\xb6',
            struct.pack('<i', self.hash),
            struct.pack('<i', self.count),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.sets)),b''.join(x._bytes() for x in self.sets),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.unread)),b''.join(struct.pack('<q', x) for x in self.unread),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_int()
        _count = reader.read_int()
        reader.read_int()
        _sets = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _sets.append(_x)

        reader.read_int()
        _unread = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _unread.append(_x)

        return cls(hash=_hash, count=_count, sets=_sets, unread=_unread)


class FeaturedStickersNotModified(TLObject):
    CONSTRUCTOR_ID = 0xc6dc0c66
    SUBCLASS_OF_ID = 0x2614b722

    def __init__(self, count: int):
        """
        Constructor for messages.FeaturedStickers: Instance of either FeaturedStickersNotModified, FeaturedStickers.
        """
        self.count = count

    def to_dict(self):
        return {
            '_': 'FeaturedStickersNotModified',
            'count': self.count
        }

    def _bytes(self):
        return b''.join((
            b'f\x0c\xdc\xc6',
            struct.pack('<i', self.count),
        ))

    @classmethod
    def from_reader(cls, reader):
        _count = reader.read_int()
        return cls(count=_count)


class FoundStickerSets(TLObject):
    CONSTRUCTOR_ID = 0x5108d648
    SUBCLASS_OF_ID = 0x40df361

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, sets: List['TypeStickerSetCovered']):
        """
        Constructor for messages.FoundStickerSets: Instance of either FoundStickerSetsNotModified, FoundStickerSets.
        """
        self.hash = hash
        self.sets = sets

    def to_dict(self):
        return {
            '_': 'FoundStickerSets',
            'hash': self.hash,
            'sets': [] if self.sets is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.sets]
        }

    def _bytes(self):
        return b''.join((
            b'H\xd6\x08Q',
            struct.pack('<i', self.hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.sets)),b''.join(x._bytes() for x in self.sets),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_int()
        reader.read_int()
        _sets = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _sets.append(_x)

        return cls(hash=_hash, sets=_sets)


class FoundStickerSetsNotModified(TLObject):
    CONSTRUCTOR_ID = 0xd54b65d
    SUBCLASS_OF_ID = 0x40df361

    def to_dict(self):
        return {
            '_': 'FoundStickerSetsNotModified'
        }

    def _bytes(self):
        return b''.join((
            b']\xb6T\r',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class HighScores(TLObject):
    CONSTRUCTOR_ID = 0x9a3bfd99
    SUBCLASS_OF_ID = 0x6ccd95fd

    def __init__(self, scores: List['TypeHighScore'], users: List['TypeUser']):
        """
        Constructor for messages.HighScores: Instance of HighScores.
        """
        self.scores = scores
        self.users = users

    def to_dict(self):
        return {
            '_': 'HighScores',
            'scores': [] if self.scores is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.scores],
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users]
        }

    def _bytes(self):
        return b''.join((
            b'\x99\xfd;\x9a',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.scores)),b''.join(x._bytes() for x in self.scores),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _scores = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _scores.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(scores=_scores, users=_users)


class InactiveChats(TLObject):
    CONSTRUCTOR_ID = 0xa927fec5
    SUBCLASS_OF_ID = 0x8bf3d7d4

    def __init__(self, dates: List[int], chats: List['TypeChat'], users: List['TypeUser']):
        """
        Constructor for messages.InactiveChats: Instance of InactiveChats.
        """
        self.dates = dates
        self.chats = chats
        self.users = users

    def to_dict(self):
        return {
            '_': 'InactiveChats',
            'dates': [] if self.dates is None else self.dates[:],
            'chats': [] if self.chats is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.chats],
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users]
        }

    def _bytes(self):
        return b''.join((
            b"\xc5\xfe'\xa9",
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.dates)),b''.join(struct.pack('<i', x) for x in self.dates),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _dates = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _dates.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(dates=_dates, chats=_chats, users=_users)


class MessageEditData(TLObject):
    CONSTRUCTOR_ID = 0x26b5dde6
    SUBCLASS_OF_ID = 0xfb47949d

    def __init__(self, caption: Optional[bool]=None):
        """
        Constructor for messages.MessageEditData: Instance of MessageEditData.
        """
        self.caption = caption

    def to_dict(self):
        return {
            '_': 'MessageEditData',
            'caption': self.caption
        }

    def _bytes(self):
        return b''.join((
            b'\xe6\xdd\xb5&',
            struct.pack('<I', (0 if self.caption is None or self.caption is False else 1)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _caption = bool(flags & 1)
        return cls(caption=_caption)


class MessageViews(TLObject):
    CONSTRUCTOR_ID = 0xb6c4f543
    SUBCLASS_OF_ID = 0xafb5eb9c

    def __init__(self, views: List['TypeMessageViews'], chats: List['TypeChat'], users: List['TypeUser']):
        """
        Constructor for messages.MessageViews: Instance of MessageViews.
        """
        self.views = views
        self.chats = chats
        self.users = users

    def to_dict(self):
        return {
            '_': 'MessageViews',
            'views': [] if self.views is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.views],
            'chats': [] if self.chats is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.chats],
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users]
        }

    def _bytes(self):
        return b''.join((
            b'C\xf5\xc4\xb6',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.views)),b''.join(x._bytes() for x in self.views),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _views = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _views.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(views=_views, chats=_chats, users=_users)


class Messages(TLObject):
    CONSTRUCTOR_ID = 0x8c718e87
    SUBCLASS_OF_ID = 0xd4b40b5e

    def __init__(self, messages: List['TypeMessage'], chats: List['TypeChat'], users: List['TypeUser']):
        """
        Constructor for messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
        """
        self.messages = messages
        self.chats = chats
        self.users = users

    def to_dict(self):
        return {
            '_': 'Messages',
            'messages': [] if self.messages is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.messages],
            'chats': [] if self.chats is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.chats],
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users]
        }

    def _bytes(self):
        return b''.join((
            b'\x87\x8eq\x8c',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(x._bytes() for x in self.messages),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _messages.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(messages=_messages, chats=_chats, users=_users)


class MessagesNotModified(TLObject):
    CONSTRUCTOR_ID = 0x74535f21
    SUBCLASS_OF_ID = 0xd4b40b5e

    def __init__(self, count: int):
        """
        Constructor for messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
        """
        self.count = count

    def to_dict(self):
        return {
            '_': 'MessagesNotModified',
            'count': self.count
        }

    def _bytes(self):
        return b''.join((
            b'!_St',
            struct.pack('<i', self.count),
        ))

    @classmethod
    def from_reader(cls, reader):
        _count = reader.read_int()
        return cls(count=_count)


class MessagesSlice(TLObject):
    CONSTRUCTOR_ID = 0x3a54685e
    SUBCLASS_OF_ID = 0xd4b40b5e

    def __init__(self, count: int, messages: List['TypeMessage'], chats: List['TypeChat'], users: List['TypeUser'], inexact: Optional[bool]=None, next_rate: Optional[int]=None, offset_id_offset: Optional[int]=None):
        """
        Constructor for messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
        """
        self.count = count
        self.messages = messages
        self.chats = chats
        self.users = users
        self.inexact = inexact
        self.next_rate = next_rate
        self.offset_id_offset = offset_id_offset

    def to_dict(self):
        return {
            '_': 'MessagesSlice',
            'count': self.count,
            'messages': [] if self.messages is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.messages],
            'chats': [] if self.chats is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.chats],
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users],
            'inexact': self.inexact,
            'next_rate': self.next_rate,
            'offset_id_offset': self.offset_id_offset
        }

    def _bytes(self):
        return b''.join((
            b'^hT:',
            struct.pack('<I', (0 if self.inexact is None or self.inexact is False else 2) | (0 if self.next_rate is None or self.next_rate is False else 1) | (0 if self.offset_id_offset is None or self.offset_id_offset is False else 4)),
            struct.pack('<i', self.count),
            b'' if self.next_rate is None or self.next_rate is False else (struct.pack('<i', self.next_rate)),
            b'' if self.offset_id_offset is None or self.offset_id_offset is False else (struct.pack('<i', self.offset_id_offset)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(x._bytes() for x in self.messages),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _inexact = bool(flags & 2)
        _count = reader.read_int()
        if flags & 1:
            _next_rate = reader.read_int()
        else:
            _next_rate = None
        if flags & 4:
            _offset_id_offset = reader.read_int()
        else:
            _offset_id_offset = None
        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _messages.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(count=_count, messages=_messages, chats=_chats, users=_users, inexact=_inexact, next_rate=_next_rate, offset_id_offset=_offset_id_offset)


class PeerDialogs(TLObject):
    CONSTRUCTOR_ID = 0x3371c354
    SUBCLASS_OF_ID = 0x3ac70132

    def __init__(self, dialogs: List['TypeDialog'], messages: List['TypeMessage'], chats: List['TypeChat'], users: List['TypeUser'], state: 'TypeState'):
        """
        Constructor for messages.PeerDialogs: Instance of PeerDialogs.
        """
        self.dialogs = dialogs
        self.messages = messages
        self.chats = chats
        self.users = users
        self.state = state

    def to_dict(self):
        return {
            '_': 'PeerDialogs',
            'dialogs': [] if self.dialogs is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.dialogs],
            'messages': [] if self.messages is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.messages],
            'chats': [] if self.chats is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.chats],
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users],
            'state': self.state.to_dict() if isinstance(self.state, TLObject) else self.state
        }

    def _bytes(self):
        return b''.join((
            b'T\xc3q3',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.dialogs)),b''.join(x._bytes() for x in self.dialogs),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(x._bytes() for x in self.messages),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(x._bytes() for x in self.chats),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
            self.state._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _dialogs = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _dialogs.append(_x)

        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _messages.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        _state = reader.tgread_object()
        return cls(dialogs=_dialogs, messages=_messages, chats=_chats, users=_users, state=_state)


class RecentStickers(TLObject):
    CONSTRUCTOR_ID = 0x22f3afb3
    SUBCLASS_OF_ID = 0xf76f8683

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, packs: List['TypeStickerPack'], stickers: List['TypeDocument'], dates: List[int]):
        """
        Constructor for messages.RecentStickers: Instance of either RecentStickersNotModified, RecentStickers.
        """
        self.hash = hash
        self.packs = packs
        self.stickers = stickers
        self.dates = dates

    def to_dict(self):
        return {
            '_': 'RecentStickers',
            'hash': self.hash,
            'packs': [] if self.packs is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.packs],
            'stickers': [] if self.stickers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.stickers],
            'dates': [] if self.dates is None else self.dates[:]
        }

    def _bytes(self):
        return b''.join((
            b'\xb3\xaf\xf3"',
            struct.pack('<i', self.hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.packs)),b''.join(x._bytes() for x in self.packs),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.stickers)),b''.join(x._bytes() for x in self.stickers),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.dates)),b''.join(struct.pack('<i', x) for x in self.dates),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_int()
        reader.read_int()
        _packs = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _packs.append(_x)

        reader.read_int()
        _stickers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _stickers.append(_x)

        reader.read_int()
        _dates = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _dates.append(_x)

        return cls(hash=_hash, packs=_packs, stickers=_stickers, dates=_dates)


class RecentStickersNotModified(TLObject):
    CONSTRUCTOR_ID = 0xb17f890
    SUBCLASS_OF_ID = 0xf76f8683

    def to_dict(self):
        return {
            '_': 'RecentStickersNotModified'
        }

    def _bytes(self):
        return b''.join((
            b'\x90\xf8\x17\x0b',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SavedGifs(TLObject):
    CONSTRUCTOR_ID = 0x2e0709a5
    SUBCLASS_OF_ID = 0xa68b61f5

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, gifs: List['TypeDocument']):
        """
        Constructor for messages.SavedGifs: Instance of either SavedGifsNotModified, SavedGifs.
        """
        self.hash = hash
        self.gifs = gifs

    def to_dict(self):
        return {
            '_': 'SavedGifs',
            'hash': self.hash,
            'gifs': [] if self.gifs is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.gifs]
        }

    def _bytes(self):
        return b''.join((
            b'\xa5\t\x07.',
            struct.pack('<i', self.hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.gifs)),b''.join(x._bytes() for x in self.gifs),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_int()
        reader.read_int()
        _gifs = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _gifs.append(_x)

        return cls(hash=_hash, gifs=_gifs)


class SavedGifsNotModified(TLObject):
    CONSTRUCTOR_ID = 0xe8025ca2
    SUBCLASS_OF_ID = 0xa68b61f5

    def to_dict(self):
        return {
            '_': 'SavedGifsNotModified'
        }

    def _bytes(self):
        return b''.join((
            b'\xa2\\\x02\xe8',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SearchCounter(TLObject):
    CONSTRUCTOR_ID = 0xe844ebff
    SUBCLASS_OF_ID = 0xd6a7bfa2

    # noinspection PyShadowingBuiltins
    def __init__(self, filter: 'TypeMessagesFilter', count: int, inexact: Optional[bool]=None):
        """
        Constructor for messages.SearchCounter: Instance of SearchCounter.
        """
        self.filter = filter
        self.count = count
        self.inexact = inexact

    def to_dict(self):
        return {
            '_': 'SearchCounter',
            'filter': self.filter.to_dict() if isinstance(self.filter, TLObject) else self.filter,
            'count': self.count,
            'inexact': self.inexact
        }

    def _bytes(self):
        return b''.join((
            b'\xff\xebD\xe8',
            struct.pack('<I', (0 if self.inexact is None or self.inexact is False else 2)),
            self.filter._bytes(),
            struct.pack('<i', self.count),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _inexact = bool(flags & 2)
        _filter = reader.tgread_object()
        _count = reader.read_int()
        return cls(filter=_filter, count=_count, inexact=_inexact)


class SentEncryptedFile(TLObject):
    CONSTRUCTOR_ID = 0x9493ff32
    SUBCLASS_OF_ID = 0xc99e3e50

    def __init__(self, date: Optional[datetime], file: 'TypeEncryptedFile'):
        """
        Constructor for messages.SentEncryptedMessage: Instance of either SentEncryptedMessage, SentEncryptedFile.
        """
        self.date = date
        self.file = file

    def to_dict(self):
        return {
            '_': 'SentEncryptedFile',
            'date': self.date,
            'file': self.file.to_dict() if isinstance(self.file, TLObject) else self.file
        }

    def _bytes(self):
        return b''.join((
            b'2\xff\x93\x94',
            self.serialize_datetime(self.date),
            self.file._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _date = reader.tgread_date()
        _file = reader.tgread_object()
        return cls(date=_date, file=_file)


class SentEncryptedMessage(TLObject):
    CONSTRUCTOR_ID = 0x560f8935
    SUBCLASS_OF_ID = 0xc99e3e50

    def __init__(self, date: Optional[datetime]):
        """
        Constructor for messages.SentEncryptedMessage: Instance of either SentEncryptedMessage, SentEncryptedFile.
        """
        self.date = date

    def to_dict(self):
        return {
            '_': 'SentEncryptedMessage',
            'date': self.date
        }

    def _bytes(self):
        return b''.join((
            b'5\x89\x0fV',
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _date = reader.tgread_date()
        return cls(date=_date)


class StickerSet(TLObject):
    CONSTRUCTOR_ID = 0xb60a24a6
    SUBCLASS_OF_ID = 0x9b704a5a

    # noinspection PyShadowingBuiltins
    def __init__(self, set: 'TypeStickerSet', packs: List['TypeStickerPack'], documents: List['TypeDocument']):
        """
        Constructor for messages.StickerSet: Instance of StickerSet.
        """
        self.set = set
        self.packs = packs
        self.documents = documents

    def to_dict(self):
        return {
            '_': 'StickerSet',
            'set': self.set.to_dict() if isinstance(self.set, TLObject) else self.set,
            'packs': [] if self.packs is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.packs],
            'documents': [] if self.documents is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.documents]
        }

    def _bytes(self):
        return b''.join((
            b'\xa6$\n\xb6',
            self.set._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.packs)),b''.join(x._bytes() for x in self.packs),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.documents)),b''.join(x._bytes() for x in self.documents),
        ))

    @classmethod
    def from_reader(cls, reader):
        _set = reader.tgread_object()
        reader.read_int()
        _packs = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _packs.append(_x)

        reader.read_int()
        _documents = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _documents.append(_x)

        return cls(set=_set, packs=_packs, documents=_documents)


class StickerSetInstallResultArchive(TLObject):
    CONSTRUCTOR_ID = 0x35e410a8
    SUBCLASS_OF_ID = 0x67cb3fe8

    def __init__(self, sets: List['TypeStickerSetCovered']):
        """
        Constructor for messages.StickerSetInstallResult: Instance of either StickerSetInstallResultSuccess, StickerSetInstallResultArchive.
        """
        self.sets = sets

    def to_dict(self):
        return {
            '_': 'StickerSetInstallResultArchive',
            'sets': [] if self.sets is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.sets]
        }

    def _bytes(self):
        return b''.join((
            b'\xa8\x10\xe45',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.sets)),b''.join(x._bytes() for x in self.sets),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _sets = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _sets.append(_x)

        return cls(sets=_sets)


class StickerSetInstallResultSuccess(TLObject):
    CONSTRUCTOR_ID = 0x38641628
    SUBCLASS_OF_ID = 0x67cb3fe8

    def to_dict(self):
        return {
            '_': 'StickerSetInstallResultSuccess'
        }

    def _bytes(self):
        return b''.join((
            b'(\x16d8',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class Stickers(TLObject):
    CONSTRUCTOR_ID = 0xe4599bbd
    SUBCLASS_OF_ID = 0xd73bb9de

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, stickers: List['TypeDocument']):
        """
        Constructor for messages.Stickers: Instance of either StickersNotModified, Stickers.
        """
        self.hash = hash
        self.stickers = stickers

    def to_dict(self):
        return {
            '_': 'Stickers',
            'hash': self.hash,
            'stickers': [] if self.stickers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.stickers]
        }

    def _bytes(self):
        return b''.join((
            b'\xbd\x9bY\xe4',
            struct.pack('<i', self.hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.stickers)),b''.join(x._bytes() for x in self.stickers),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_int()
        reader.read_int()
        _stickers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _stickers.append(_x)

        return cls(hash=_hash, stickers=_stickers)


class StickersNotModified(TLObject):
    CONSTRUCTOR_ID = 0xf1749a22
    SUBCLASS_OF_ID = 0xd73bb9de

    def to_dict(self):
        return {
            '_': 'StickersNotModified'
        }

    def _bytes(self):
        return b''.join((
            b'"\x9at\xf1',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class VotesList(TLObject):
    CONSTRUCTOR_ID = 0x823f649
    SUBCLASS_OF_ID = 0xc2199885

    def __init__(self, count: int, votes: List['TypeMessageUserVote'], users: List['TypeUser'], next_offset: Optional[str]=None):
        """
        Constructor for messages.VotesList: Instance of VotesList.
        """
        self.count = count
        self.votes = votes
        self.users = users
        self.next_offset = next_offset

    def to_dict(self):
        return {
            '_': 'VotesList',
            'count': self.count,
            'votes': [] if self.votes is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.votes],
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users],
            'next_offset': self.next_offset
        }

    def _bytes(self):
        return b''.join((
            b'I\xf6#\x08',
            struct.pack('<I', (0 if self.next_offset is None or self.next_offset is False else 1)),
            struct.pack('<i', self.count),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.votes)),b''.join(x._bytes() for x in self.votes),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
            b'' if self.next_offset is None or self.next_offset is False else (self.serialize_bytes(self.next_offset)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _count = reader.read_int()
        reader.read_int()
        _votes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _votes.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        if flags & 1:
            _next_offset = reader.tgread_string()
        else:
            _next_offset = None
        return cls(count=_count, votes=_votes, users=_users, next_offset=_next_offset)

