# Generated by Django 2.2.13 on 2020-06-17 06:48

import django.contrib.auth.validators
import django.contrib.postgres.fields.jsonb
import django.db.models.deletion
import django.utils.timezone
import localized_fields.fields.char_field
import localized_fields.fields.text_field
import mptt.fields
from django.conf import settings
from django.db import migrations, models

import emeis.core.models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="User",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("modified_at", models.DateTimeField(auto_now=True, db_index=True)),
                (
                    "meta",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name="meta"
                    ),
                ),
                (
                    "id",
                    models.UUIDField(
                        default=emeis.core.models.make_uuid,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "username",
                    models.CharField(
                        error_messages={
                            "unique": "A user with that username already exists."
                        },
                        help_text="Required. 255 characters or fewer. Letters, digits and @/./+/-/_ only.",
                        max_length=255,
                        unique=True,
                        validators=[
                            django.contrib.auth.validators.UnicodeUsernameValidator()
                        ],
                        verbose_name="username",
                    ),
                ),
                (
                    "first_name",
                    models.CharField(
                        blank=True, max_length=255, null=True, verbose_name="first name"
                    ),
                ),
                (
                    "last_name",
                    models.CharField(
                        blank=True, max_length=255, null=True, verbose_name="last name"
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        blank=True,
                        max_length=254,
                        null=True,
                        verbose_name="email address",
                    ),
                ),
                (
                    "phone",
                    models.CharField(
                        blank=True, max_length=100, null=True, verbose_name="phone"
                    ),
                ),
                (
                    "language",
                    models.CharField(
                        default=emeis.core.models.get_language_code,
                        max_length=2,
                        verbose_name="language",
                    ),
                ),
                (
                    "address",
                    models.CharField(
                        blank=True, max_length=255, null=True, verbose_name="address"
                    ),
                ),
                (
                    "city",
                    models.CharField(
                        blank=True, max_length=255, null=True, verbose_name="city"
                    ),
                ),
                (
                    "zip",
                    models.CharField(
                        blank=True, max_length=10, null=True, verbose_name="zip"
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True,
                        help_text="Designates whether this user should be treated as active.",
                        verbose_name="active",
                    ),
                ),
                (
                    "date_joined",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="date joined"
                    ),
                ),
                (
                    "created_by_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={"verbose_name": "user", "verbose_name_plural": "users"},
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Permission",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("modified_at", models.DateTimeField(auto_now=True, db_index=True)),
                (
                    "meta",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name="meta"
                    ),
                ),
                (
                    "slug",
                    models.SlugField(max_length=255, primary_key=True, serialize=False),
                ),
                (
                    "name",
                    localized_fields.fields.char_field.LocalizedCharField(
                        required=[], verbose_name="permission name"
                    ),
                ),
                (
                    "description",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True,
                        null=True,
                        required=[],
                        verbose_name="permission description",
                    ),
                ),
                (
                    "created_by_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={"abstract": False},
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Scope",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("modified_at", models.DateTimeField(auto_now=True, db_index=True)),
                (
                    "meta",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name="meta"
                    ),
                ),
                (
                    "id",
                    models.UUIDField(
                        default=emeis.core.models.make_uuid,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "name",
                    localized_fields.fields.char_field.LocalizedCharField(
                        required=[], verbose_name="scope name"
                    ),
                ),
                (
                    "description",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True,
                        null=True,
                        required=[],
                        verbose_name="scope description",
                    ),
                ),
                ("lft", models.PositiveIntegerField(editable=False)),
                ("rght", models.PositiveIntegerField(editable=False)),
                ("tree_id", models.PositiveIntegerField(db_index=True, editable=False)),
                ("level", models.PositiveIntegerField(editable=False)),
                (
                    "created_by_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent",
                    mptt.fields.TreeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="children",
                        to="emeis_core.Scope",
                    ),
                ),
            ],
            options={"abstract": False},
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Role",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("modified_at", models.DateTimeField(auto_now=True, db_index=True)),
                (
                    "meta",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name="meta"
                    ),
                ),
                (
                    "slug",
                    models.SlugField(max_length=255, primary_key=True, serialize=False),
                ),
                (
                    "name",
                    localized_fields.fields.char_field.LocalizedCharField(
                        required=[], verbose_name="role name"
                    ),
                ),
                (
                    "description",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True,
                        null=True,
                        required=[],
                        verbose_name="role description",
                    ),
                ),
                (
                    "created_by_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "permissions",
                    models.ManyToManyField(
                        related_name="roles", to="emeis_core.Permission"
                    ),
                ),
            ],
            options={"ordering": ["slug"]},
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ACL",
            fields=[
                ("created_at", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("modified_at", models.DateTimeField(auto_now=True, db_index=True)),
                (
                    "meta",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, verbose_name="meta"
                    ),
                ),
                (
                    "id",
                    models.UUIDField(
                        default=emeis.core.models.make_uuid,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "created_by_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "role",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="acls",
                        to="emeis_core.Role",
                    ),
                ),
                (
                    "scope",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="acls",
                        to="emeis_core.Scope",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="acls",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={"unique_together": {("user", "scope", "role")}},
            bases=(models.Model,),
        ),
    ]
