"""
CompletionsTag automatically generated by SDKgen please do not edit this file manually
https://sdkgen.app
"""

import requests
import sdkgen
from requests import RequestException
from typing import List
from typing import Dict
from typing import Any
from urllib.parse import parse_qs

from .completion_collection import CompletionCollection
from .completion_deleted import CompletionDeleted
from .completion_request import CompletionRequest
from .completion_response import CompletionResponse
from .error import Error
from .error_exception import ErrorException

class CompletionsTag(sdkgen.TagAbstract):
    def __init__(self, http_client: requests.Session, parser: sdkgen.Parser):
        super().__init__(http_client, parser)


    def create(self, payload: CompletionRequest) -> CompletionResponse:
        """
        Creates a model response for the given chat conversation.
        """
        try:
            path_params = {}

            query_params = {}

            query_struct_names = []

            url = self.parser.url('/v1/chat/completions', path_params)

            options = {}
            options['headers'] = {}
            options['params'] = self.parser.query(query_params, query_struct_names)

            options['json'] = payload.model_dump(by_alias=True)

            options['headers']['Content-Type'] = 'application/json'

            response = self.http_client.request('POST', url, **options)

            if response.status_code >= 200 and response.status_code < 300:
                data = CompletionResponse.model_validate_json(json_data=response.content)

                return data

            statusCode = response.status_code
            if statusCode >= 0 and statusCode <= 999:
                data = Error.model_validate_json(json_data=response.content)

                raise ErrorException(data)

            raise sdkgen.UnknownStatusCodeException('The server returned an unknown status code: ' + str(statusCode))
        except RequestException as e:
            raise sdkgen.ClientException('An unknown error occurred: ' + str(e))

    def delete(self, completion_id: str) -> CompletionDeleted:
        """
        Delete a stored chat completion. Only Chat Completions that have been created with the store parameter set to true can be deleted.
        """
        try:
            path_params = {}
            path_params['completion_id'] = completion_id

            query_params = {}

            query_struct_names = []

            url = self.parser.url('/v1/chat/completions/:completion_id', path_params)

            options = {}
            options['headers'] = {}
            options['params'] = self.parser.query(query_params, query_struct_names)



            response = self.http_client.request('DELETE', url, **options)

            if response.status_code >= 200 and response.status_code < 300:
                data = CompletionDeleted.model_validate_json(json_data=response.content)

                return data

            statusCode = response.status_code
            if statusCode >= 0 and statusCode <= 999:
                data = Error.model_validate_json(json_data=response.content)

                raise ErrorException(data)

            raise sdkgen.UnknownStatusCodeException('The server returned an unknown status code: ' + str(statusCode))
        except RequestException as e:
            raise sdkgen.ClientException('An unknown error occurred: ' + str(e))

    def get_all(self, after: str, limit: int, model: str, order: str) -> CompletionCollection:
        """
        List stored Chat Completions. Only Chat Completions that have been stored with the store parameter set to true will be returned.
        """
        try:
            path_params = {}

            query_params = {}
            query_params['after'] = after
            query_params['limit'] = limit
            query_params['model'] = model
            query_params['order'] = order

            query_struct_names = []

            url = self.parser.url('/v1/chat/completions', path_params)

            options = {}
            options['headers'] = {}
            options['params'] = self.parser.query(query_params, query_struct_names)



            response = self.http_client.request('GET', url, **options)

            if response.status_code >= 200 and response.status_code < 300:
                data = CompletionCollection.model_validate_json(json_data=response.content)

                return data

            statusCode = response.status_code
            if statusCode >= 0 and statusCode <= 999:
                data = Error.model_validate_json(json_data=response.content)

                raise ErrorException(data)

            raise sdkgen.UnknownStatusCodeException('The server returned an unknown status code: ' + str(statusCode))
        except RequestException as e:
            raise sdkgen.ClientException('An unknown error occurred: ' + str(e))



