from fast_enum import FastEnum
from ..base import Ward, VietNamDivisionType


class WardEnum(metaclass=FastEnum):
    """
    Ward Enum type, which is convenient for fast looking up Ward by its numeric code.
    """

    W_1 = Ward("Phường Phúc Xá", 1, VietNamDivisionType.PHUONG, "phuong_phuc_xa", 1)
    W_4 = Ward("Phường Trúc Bạch", 4, VietNamDivisionType.PHUONG, "phuong_truc_bach", 1)
    W_6 = Ward("Phường Vĩnh Phúc", 6, VietNamDivisionType.PHUONG, "phuong_vinh_phuc", 1)
    W_7 = Ward("Phường Cống Vị", 7, VietNamDivisionType.PHUONG, "phuong_cong_vi", 1)
    W_8 = Ward("Phường Liễu Giai", 8, VietNamDivisionType.PHUONG, "phuong_lieu_giai", 1)
    W_10 = Ward("Phường Nguyễn Trung Trực", 10, VietNamDivisionType.PHUONG, "phuong_nguyen_trung_truc", 1)
    W_13 = Ward("Phường Quán Thánh", 13, VietNamDivisionType.PHUONG, "phuong_quan_thanh", 1)
    W_16 = Ward("Phường Ngọc Hà", 16, VietNamDivisionType.PHUONG, "phuong_ngoc_ha", 1)
    W_19 = Ward("Phường Điện Biên", 19, VietNamDivisionType.PHUONG, "phuong_dien_bien", 1)
    W_22 = Ward("Phường Đội Cấn", 22, VietNamDivisionType.PHUONG, "phuong_doi_can", 1)
    W_25 = Ward("Phường Ngọc Khánh", 25, VietNamDivisionType.PHUONG, "phuong_ngoc_khanh", 1)
    W_28 = Ward("Phường Kim Mã", 28, VietNamDivisionType.PHUONG, "phuong_kim_ma", 1)
    W_31 = Ward("Phường Giảng Võ", 31, VietNamDivisionType.PHUONG, "phuong_giang_vo", 1)
    W_34 = Ward("Phường Thành Công", 34, VietNamDivisionType.PHUONG, "phuong_thanh_cong", 1)
    W_37 = Ward("Phường Phúc Tân", 37, VietNamDivisionType.PHUONG, "phuong_phuc_tan", 2)
    W_40 = Ward("Phường Đồng Xuân", 40, VietNamDivisionType.PHUONG, "phuong_dong_xuan", 2)
    W_43 = Ward("Phường Hàng Mã", 43, VietNamDivisionType.PHUONG, "phuong_hang_ma", 2)
    W_46 = Ward("Phường Hàng Buồm", 46, VietNamDivisionType.PHUONG, "phuong_hang_buom", 2)
    W_49 = Ward("Phường Hàng Đào", 49, VietNamDivisionType.PHUONG, "phuong_hang_dao", 2)
    W_52 = Ward("Phường Hàng Bồ", 52, VietNamDivisionType.PHUONG, "phuong_hang_bo", 2)
    W_55 = Ward("Phường Cửa Đông", 55, VietNamDivisionType.PHUONG, "phuong_cua_dong", 2)
    W_58 = Ward("Phường Lý Thái Tổ", 58, VietNamDivisionType.PHUONG, "phuong_ly_thai_to", 2)
    W_61 = Ward("Phường Hàng Bạc", 61, VietNamDivisionType.PHUONG, "phuong_hang_bac", 2)
    W_64 = Ward("Phường Hàng Gai", 64, VietNamDivisionType.PHUONG, "phuong_hang_gai", 2)
    W_67 = Ward("Phường Chương Dương", 67, VietNamDivisionType.PHUONG, "phuong_chuong_duong", 2)
    W_70 = Ward("Phường Hàng Trống", 70, VietNamDivisionType.PHUONG, "phuong_hang_trong", 2)
    W_73 = Ward("Phường Cửa Nam", 73, VietNamDivisionType.PHUONG, "phuong_cua_nam", 2)
    W_76 = Ward("Phường Hàng Bông", 76, VietNamDivisionType.PHUONG, "phuong_hang_bong", 2)
    W_79 = Ward("Phường Tràng Tiền", 79, VietNamDivisionType.PHUONG, "phuong_trang_tien", 2)
    W_82 = Ward("Phường Trần Hưng Đạo", 82, VietNamDivisionType.PHUONG, "phuong_tran_hung_dao", 2)
    W_85 = Ward("Phường Phan Chu Trinh", 85, VietNamDivisionType.PHUONG, "phuong_phan_chu_trinh", 2)
    W_88 = Ward("Phường Hàng Bài", 88, VietNamDivisionType.PHUONG, "phuong_hang_bai", 2)
    W_91 = Ward("Phường Phú Thượng", 91, VietNamDivisionType.PHUONG, "phuong_phu_thuong", 3)
    W_94 = Ward("Phường Nhật Tân", 94, VietNamDivisionType.PHUONG, "phuong_nhat_tan", 3)
    W_97 = Ward("Phường Tứ Liên", 97, VietNamDivisionType.PHUONG, "phuong_tu_lien", 3)
    W_100 = Ward("Phường Quảng An", 100, VietNamDivisionType.PHUONG, "phuong_quang_an", 3)
    W_103 = Ward("Phường Xuân La", 103, VietNamDivisionType.PHUONG, "phuong_xuan_la", 3)
    W_106 = Ward("Phường Yên Phụ", 106, VietNamDivisionType.PHUONG, "phuong_yen_phu", 3)
    W_109 = Ward("Phường Bưởi", 109, VietNamDivisionType.PHUONG, "phuong_buoi", 3)
    W_112 = Ward("Phường Thụy Khuê", 112, VietNamDivisionType.PHUONG, "phuong_thuy_khue", 3)
    W_115 = Ward("Phường Thượng Thanh", 115, VietNamDivisionType.PHUONG, "phuong_thuong_thanh", 4)
    W_118 = Ward("Phường Ngọc Thụy", 118, VietNamDivisionType.PHUONG, "phuong_ngoc_thuy", 4)
    W_121 = Ward("Phường Giang Biên", 121, VietNamDivisionType.PHUONG, "phuong_giang_bien", 4)
    W_124 = Ward("Phường Đức Giang", 124, VietNamDivisionType.PHUONG, "phuong_duc_giang", 4)
    W_127 = Ward("Phường Việt Hưng", 127, VietNamDivisionType.PHUONG, "phuong_viet_hung", 4)
    W_130 = Ward("Phường Gia Thụy", 130, VietNamDivisionType.PHUONG, "phuong_gia_thuy", 4)
    W_133 = Ward("Phường Ngọc Lâm", 133, VietNamDivisionType.PHUONG, "phuong_ngoc_lam", 4)
    W_136 = Ward("Phường Phúc Lợi", 136, VietNamDivisionType.PHUONG, "phuong_phuc_loi", 4)
    W_139 = Ward("Phường Bồ Đề", 139, VietNamDivisionType.PHUONG, "phuong_bo_de", 4)
    W_142 = Ward("Phường Sài Đồng", 142, VietNamDivisionType.PHUONG, "phuong_sai_dong", 4)
    W_145 = Ward("Phường Long Biên", 145, VietNamDivisionType.PHUONG, "phuong_long_bien", 4)
    W_148 = Ward("Phường Thạch Bàn", 148, VietNamDivisionType.PHUONG, "phuong_thach_ban", 4)
    W_151 = Ward("Phường Phúc Đồng", 151, VietNamDivisionType.PHUONG, "phuong_phuc_dong", 4)
    W_154 = Ward("Phường Cự Khối", 154, VietNamDivisionType.PHUONG, "phuong_cu_khoi", 4)
    W_157 = Ward("Phường Nghĩa Đô", 157, VietNamDivisionType.PHUONG, "phuong_nghia_do", 5)
    W_160 = Ward("Phường Nghĩa Tân", 160, VietNamDivisionType.PHUONG, "phuong_nghia_tan", 5)
    W_163 = Ward("Phường Mai Dịch", 163, VietNamDivisionType.PHUONG, "phuong_mai_dich", 5)
    W_166 = Ward("Phường Dịch Vọng", 166, VietNamDivisionType.PHUONG, "phuong_dich_vong", 5)
    W_167 = Ward("Phường Dịch Vọng Hậu", 167, VietNamDivisionType.PHUONG, "phuong_dich_vong_hau", 5)
    W_169 = Ward("Phường Quan Hoa", 169, VietNamDivisionType.PHUONG, "phuong_quan_hoa", 5)
    W_172 = Ward("Phường Yên Hoà", 172, VietNamDivisionType.PHUONG, "phuong_yen_hoa", 5)
    W_175 = Ward("Phường Trung Hoà", 175, VietNamDivisionType.PHUONG, "phuong_trung_hoa", 5)
    W_178 = Ward("Phường Cát Linh", 178, VietNamDivisionType.PHUONG, "phuong_cat_linh", 6)
    W_181 = Ward("Phường Văn Miếu", 181, VietNamDivisionType.PHUONG, "phuong_van_mieu", 6)
    W_184 = Ward("Phường Quốc Tử Giám", 184, VietNamDivisionType.PHUONG, "phuong_quoc_tu_giam", 6)
    W_187 = Ward("Phường Láng Thượng", 187, VietNamDivisionType.PHUONG, "phuong_lang_thuong", 6)
    W_190 = Ward("Phường Ô Chợ Dừa", 190, VietNamDivisionType.PHUONG, "phuong_o_cho_dua", 6)
    W_193 = Ward("Phường Văn Chương", 193, VietNamDivisionType.PHUONG, "phuong_van_chuong", 6)
    W_196 = Ward("Phường Hàng Bột", 196, VietNamDivisionType.PHUONG, "phuong_hang_bot", 6)
    W_199 = Ward("Phường Láng Hạ", 199, VietNamDivisionType.PHUONG, "phuong_lang_ha", 6)
    W_202 = Ward("Phường Khâm Thiên", 202, VietNamDivisionType.PHUONG, "phuong_kham_thien", 6)
    W_205 = Ward("Phường Thổ Quan", 205, VietNamDivisionType.PHUONG, "phuong_tho_quan", 6)
    W_208 = Ward("Phường Nam Đồng", 208, VietNamDivisionType.PHUONG, "phuong_nam_dong", 6)
    W_211 = Ward("Phường Trung Phụng", 211, VietNamDivisionType.PHUONG, "phuong_trung_phung", 6)
    W_214 = Ward("Phường Quang Trung", 214, VietNamDivisionType.PHUONG, "phuong_quang_trung", 6)
    W_217 = Ward("Phường Trung Liệt", 217, VietNamDivisionType.PHUONG, "phuong_trung_liet", 6)
    W_220 = Ward("Phường Phương Liên", 220, VietNamDivisionType.PHUONG, "phuong_phuong_lien", 6)
    W_223 = Ward("Phường Thịnh Quang", 223, VietNamDivisionType.PHUONG, "phuong_thinh_quang", 6)
    W_226 = Ward("Phường Trung Tự", 226, VietNamDivisionType.PHUONG, "phuong_trung_tu", 6)
    W_229 = Ward("Phường Kim Liên", 229, VietNamDivisionType.PHUONG, "phuong_kim_lien", 6)
    W_232 = Ward("Phường Phương Mai", 232, VietNamDivisionType.PHUONG, "phuong_phuong_mai", 6)
    W_235 = Ward("Phường Ngã Tư Sở", 235, VietNamDivisionType.PHUONG, "phuong_nga_tu_so", 6)
    W_238 = Ward("Phường Khương Thượng", 238, VietNamDivisionType.PHUONG, "phuong_khuong_thuong", 6)
    W_241 = Ward("Phường Nguyễn Du", 241, VietNamDivisionType.PHUONG, "phuong_nguyen_du", 7)
    W_244 = Ward("Phường Bạch Đằng", 244, VietNamDivisionType.PHUONG, "phuong_bach_dang", 7)
    W_247 = Ward("Phường Phạm Đình Hổ", 247, VietNamDivisionType.PHUONG, "phuong_pham_dinh_ho", 7)
    W_256 = Ward("Phường Lê Đại Hành", 256, VietNamDivisionType.PHUONG, "phuong_le_dai_hanh", 7)
    W_259 = Ward("Phường Đồng Nhân", 259, VietNamDivisionType.PHUONG, "phuong_dong_nhan", 7)
    W_262 = Ward("Phường Phố Huế", 262, VietNamDivisionType.PHUONG, "phuong_pho_hue", 7)
    W_265 = Ward("Phường Đống Mác", 265, VietNamDivisionType.PHUONG, "phuong_dong_mac", 7)
    W_268 = Ward("Phường Thanh Lương", 268, VietNamDivisionType.PHUONG, "phuong_thanh_luong", 7)
    W_271 = Ward("Phường Thanh Nhàn", 271, VietNamDivisionType.PHUONG, "phuong_thanh_nhan", 7)
    W_274 = Ward("Phường Cầu Dền", 274, VietNamDivisionType.PHUONG, "phuong_cau_den", 7)
    W_277 = Ward("Phường Bách Khoa", 277, VietNamDivisionType.PHUONG, "phuong_bach_khoa", 7)
    W_280 = Ward("Phường Đồng Tâm", 280, VietNamDivisionType.PHUONG, "phuong_dong_tam", 7)
    W_283 = Ward("Phường Vĩnh Tuy", 283, VietNamDivisionType.PHUONG, "phuong_vinh_tuy", 7)
    W_286 = Ward("Phường Bạch Mai", 286, VietNamDivisionType.PHUONG, "phuong_bach_mai", 7)
    W_289 = Ward("Phường Quỳnh Mai", 289, VietNamDivisionType.PHUONG, "phuong_quynh_mai", 7)
    W_292 = Ward("Phường Quỳnh Lôi", 292, VietNamDivisionType.PHUONG, "phuong_quynh_loi", 7)
    W_295 = Ward("Phường Minh Khai", 295, VietNamDivisionType.PHUONG, "phuong_minh_khai", 7)
    W_298 = Ward("Phường Trương Định", 298, VietNamDivisionType.PHUONG, "phuong_truong_dinh", 7)
    W_301 = Ward("Phường Thanh Trì", 301, VietNamDivisionType.PHUONG, "phuong_thanh_tri", 8)
    W_304 = Ward("Phường Vĩnh Hưng", 304, VietNamDivisionType.PHUONG, "phuong_vinh_hung", 8)
    W_307 = Ward("Phường Định Công", 307, VietNamDivisionType.PHUONG, "phuong_dinh_cong", 8)
    W_310 = Ward("Phường Mai Động", 310, VietNamDivisionType.PHUONG, "phuong_mai_dong", 8)
    W_313 = Ward("Phường Tương Mai", 313, VietNamDivisionType.PHUONG, "phuong_tuong_mai", 8)
    W_316 = Ward("Phường Đại Kim", 316, VietNamDivisionType.PHUONG, "phuong_dai_kim", 8)
    W_319 = Ward("Phường Tân Mai", 319, VietNamDivisionType.PHUONG, "phuong_tan_mai", 8)
    W_322 = Ward("Phường Hoàng Văn Thụ", 322, VietNamDivisionType.PHUONG, "phuong_hoang_van_thu", 8)
    W_325 = Ward("Phường Giáp Bát", 325, VietNamDivisionType.PHUONG, "phuong_giap_bat", 8)
    W_328 = Ward("Phường Lĩnh Nam", 328, VietNamDivisionType.PHUONG, "phuong_linh_nam", 8)
    W_331 = Ward("Phường Thịnh Liệt", 331, VietNamDivisionType.PHUONG, "phuong_thinh_liet", 8)
    W_334 = Ward("Phường Trần Phú", 334, VietNamDivisionType.PHUONG, "phuong_tran_phu", 8)
    W_337 = Ward("Phường Hoàng Liệt", 337, VietNamDivisionType.PHUONG, "phuong_hoang_liet", 8)
    W_340 = Ward("Phường Yên Sở", 340, VietNamDivisionType.PHUONG, "phuong_yen_so", 8)
    W_343 = Ward("Phường Nhân Chính", 343, VietNamDivisionType.PHUONG, "phuong_nhan_chinh", 9)
    W_346 = Ward("Phường Thượng Đình", 346, VietNamDivisionType.PHUONG, "phuong_thuong_dinh", 9)
    W_349 = Ward("Phường Khương Trung", 349, VietNamDivisionType.PHUONG, "phuong_khuong_trung", 9)
    W_352 = Ward("Phường Khương Mai", 352, VietNamDivisionType.PHUONG, "phuong_khuong_mai", 9)
    W_355 = Ward("Phường Thanh Xuân Trung", 355, VietNamDivisionType.PHUONG, "phuong_thanh_xuan_trung", 9)
    W_358 = Ward("Phường Phương Liệt", 358, VietNamDivisionType.PHUONG, "phuong_phuong_liet", 9)
    W_361 = Ward("Phường Hạ Đình", 361, VietNamDivisionType.PHUONG, "phuong_ha_dinh", 9)
    W_364 = Ward("Phường Khương Đình", 364, VietNamDivisionType.PHUONG, "phuong_khuong_dinh", 9)
    W_367 = Ward("Phường Thanh Xuân Bắc", 367, VietNamDivisionType.PHUONG, "phuong_thanh_xuan_bac", 9)
    W_370 = Ward("Phường Thanh Xuân Nam", 370, VietNamDivisionType.PHUONG, "phuong_thanh_xuan_nam", 9)
    W_373 = Ward("Phường Kim Giang", 373, VietNamDivisionType.PHUONG, "phuong_kim_giang", 9)
    W_376 = Ward("Thị trấn Sóc Sơn", 376, VietNamDivisionType.THI_TRAN, "thi_tran_soc_son", 16)
    W_379 = Ward("Xã Bắc Sơn", 379, VietNamDivisionType.XA, "xa_bac_son", 16)
    W_382 = Ward("Xã Minh Trí", 382, VietNamDivisionType.XA, "xa_minh_tri", 16)
    W_385 = Ward("Xã Hồng Kỳ", 385, VietNamDivisionType.XA, "xa_hong_ky", 16)
    W_388 = Ward("Xã Nam Sơn", 388, VietNamDivisionType.XA, "xa_nam_son", 16)
    W_391 = Ward("Xã Trung Giã", 391, VietNamDivisionType.XA, "xa_trung_gia", 16)
    W_394 = Ward("Xã Tân Hưng", 394, VietNamDivisionType.XA, "xa_tan_hung", 16)
    W_397 = Ward("Xã Minh Phú", 397, VietNamDivisionType.XA, "xa_minh_phu", 16)
    W_400 = Ward("Xã Phù Linh", 400, VietNamDivisionType.XA, "xa_phu_linh", 16)
    W_403 = Ward("Xã Bắc Phú", 403, VietNamDivisionType.XA, "xa_bac_phu", 16)
    W_406 = Ward("Xã Tân Minh", 406, VietNamDivisionType.XA, "xa_tan_minh", 16)
    W_409 = Ward("Xã Quang Tiến", 409, VietNamDivisionType.XA, "xa_quang_tien", 16)
    W_412 = Ward("Xã Hiền Ninh", 412, VietNamDivisionType.XA, "xa_hien_ninh", 16)
    W_415 = Ward("Xã Tân Dân", 415, VietNamDivisionType.XA, "xa_tan_dan", 16)
    W_418 = Ward("Xã Tiên Dược", 418, VietNamDivisionType.XA, "xa_tien_duoc", 16)
    W_421 = Ward("Xã Việt Long", 421, VietNamDivisionType.XA, "xa_viet_long", 16)
    W_424 = Ward("Xã Xuân Giang", 424, VietNamDivisionType.XA, "xa_xuan_giang", 16)
    W_427 = Ward("Xã Mai Đình", 427, VietNamDivisionType.XA, "xa_mai_dinh", 16)
    W_430 = Ward("Xã Đức Hoà", 430, VietNamDivisionType.XA, "xa_duc_hoa", 16)
    W_433 = Ward("Xã Thanh Xuân", 433, VietNamDivisionType.XA, "xa_thanh_xuan", 16)
    W_436 = Ward("Xã Đông Xuân", 436, VietNamDivisionType.XA, "xa_dong_xuan", 16)
    W_439 = Ward("Xã Kim Lũ", 439, VietNamDivisionType.XA, "xa_kim_lu", 16)
    W_442 = Ward("Xã Phú Cường", 442, VietNamDivisionType.XA, "xa_phu_cuong", 16)
    W_445 = Ward("Xã Phú Minh", 445, VietNamDivisionType.XA, "xa_phu_minh", 16)
    W_448 = Ward("Xã Phù Lỗ", 448, VietNamDivisionType.XA, "xa_phu_lo", 16)
    W_451 = Ward("Xã Xuân Thu", 451, VietNamDivisionType.XA, "xa_xuan_thu", 16)
    W_454 = Ward("Thị trấn Đông Anh", 454, VietNamDivisionType.THI_TRAN, "thi_tran_dong_anh", 17)
    W_457 = Ward("Xã Xuân Nộn", 457, VietNamDivisionType.XA, "xa_xuan_non", 17)
    W_460 = Ward("Xã Thuỵ Lâm", 460, VietNamDivisionType.XA, "xa_thuy_lam", 17)
    W_463 = Ward("Xã Bắc Hồng", 463, VietNamDivisionType.XA, "xa_bac_hong", 17)
    W_466 = Ward("Xã Nguyên Khê", 466, VietNamDivisionType.XA, "xa_nguyen_khe", 17)
    W_469 = Ward("Xã Nam Hồng", 469, VietNamDivisionType.XA, "xa_nam_hong", 17)
    W_472 = Ward("Xã Tiên Dương", 472, VietNamDivisionType.XA, "xa_tien_duong", 17)
    W_475 = Ward("Xã Vân Hà", 475, VietNamDivisionType.XA, "xa_van_ha", 17)
    W_478 = Ward("Xã Uy Nỗ", 478, VietNamDivisionType.XA, "xa_uy_no", 17)
    W_481 = Ward("Xã Vân Nội", 481, VietNamDivisionType.XA, "xa_van_noi", 17)
    W_484 = Ward("Xã Liên Hà", 484, VietNamDivisionType.XA, "xa_lien_ha", 17)
    W_487 = Ward("Xã Việt Hùng", 487, VietNamDivisionType.XA, "xa_viet_hung", 17)
    W_490 = Ward("Xã Kim Nỗ", 490, VietNamDivisionType.XA, "xa_kim_no", 17)
    W_493 = Ward("Xã Kim Chung", 493, VietNamDivisionType.XA, "xa_kim_chung", 17)
    W_496 = Ward("Xã Dục Tú", 496, VietNamDivisionType.XA, "xa_duc_tu", 17)
    W_499 = Ward("Xã Đại Mạch", 499, VietNamDivisionType.XA, "xa_dai_mach", 17)
    W_502 = Ward("Xã Vĩnh Ngọc", 502, VietNamDivisionType.XA, "xa_vinh_ngoc", 17)
    W_505 = Ward("Xã Cổ Loa", 505, VietNamDivisionType.XA, "xa_co_loa", 17)
    W_508 = Ward("Xã Hải Bối", 508, VietNamDivisionType.XA, "xa_hai_boi", 17)
    W_511 = Ward("Xã Xuân Canh", 511, VietNamDivisionType.XA, "xa_xuan_canh", 17)
    W_514 = Ward("Xã Võng La", 514, VietNamDivisionType.XA, "xa_vong_la", 17)
    W_517 = Ward("Xã Tàm Xá", 517, VietNamDivisionType.XA, "xa_tam_xa", 17)
    W_520 = Ward("Xã Mai Lâm", 520, VietNamDivisionType.XA, "xa_mai_lam", 17)
    W_523 = Ward("Xã Đông Hội", 523, VietNamDivisionType.XA, "xa_dong_hoi", 17)
    W_526 = Ward("Thị trấn Yên Viên", 526, VietNamDivisionType.THI_TRAN, "thi_tran_yen_vien", 18)
    W_529 = Ward("Xã Yên Thường", 529, VietNamDivisionType.XA, "xa_yen_thuong", 18)
    W_532 = Ward("Xã Yên Viên", 532, VietNamDivisionType.XA, "xa_yen_vien", 18)
    W_535 = Ward("Xã Ninh Hiệp", 535, VietNamDivisionType.XA, "xa_ninh_hiep", 18)
    W_538 = Ward("Xã Đình Xuyên", 538, VietNamDivisionType.XA, "xa_dinh_xuyen", 18)
    W_541 = Ward("Xã Dương Hà", 541, VietNamDivisionType.XA, "xa_duong_ha", 18)
    W_544 = Ward("Xã Phù Đổng", 544, VietNamDivisionType.XA, "xa_phu_dong", 18)
    W_547 = Ward("Xã Trung Mầu", 547, VietNamDivisionType.XA, "xa_trung_mau", 18)
    W_550 = Ward("Xã Lệ Chi", 550, VietNamDivisionType.XA, "xa_le_chi", 18)
    W_553 = Ward("Xã Cổ Bi", 553, VietNamDivisionType.XA, "xa_co_bi", 18)
    W_556 = Ward("Xã Đặng Xá", 556, VietNamDivisionType.XA, "xa_dang_xa", 18)
    W_559 = Ward("Xã Phú Thị", 559, VietNamDivisionType.XA, "xa_phu_thi", 18)
    W_562 = Ward("Xã Kim Sơn", 562, VietNamDivisionType.XA, "xa_kim_son", 18)
    W_565 = Ward("Thị trấn Trâu Quỳ", 565, VietNamDivisionType.THI_TRAN, "thi_tran_trau_quy", 18)
    W_568 = Ward("Xã Dương Quang", 568, VietNamDivisionType.XA, "xa_duong_quang", 18)
    W_571 = Ward("Xã Dương Xá", 571, VietNamDivisionType.XA, "xa_duong_xa", 18)
    W_574 = Ward("Xã Đông Dư", 574, VietNamDivisionType.XA, "xa_dong_du", 18)
    W_577 = Ward("Xã Đa Tốn", 577, VietNamDivisionType.XA, "xa_da_ton", 18)
    W_580 = Ward("Xã Kiêu Kỵ", 580, VietNamDivisionType.XA, "xa_kieu_ky", 18)
    W_583 = Ward("Xã Bát Tràng", 583, VietNamDivisionType.XA, "xa_bat_trang", 18)
    W_586 = Ward("Xã Kim Lan", 586, VietNamDivisionType.XA, "xa_kim_lan", 18)
    W_589 = Ward("Xã Văn Đức", 589, VietNamDivisionType.XA, "xa_van_duc", 18)
    W_592 = Ward("Phường Cầu Diễn", 592, VietNamDivisionType.PHUONG, "phuong_cau_dien", 19)
    W_622 = Ward("Phường Xuân Phương", 622, VietNamDivisionType.PHUONG, "phuong_xuan_phuong", 19)
    W_623 = Ward("Phường Phương Canh", 623, VietNamDivisionType.PHUONG, "phuong_phuong_canh", 19)
    W_625 = Ward("Phường Mỹ Đình 1", 625, VietNamDivisionType.PHUONG, "phuong_my_dinh_1", 19)
    W_626 = Ward("Phường Mỹ Đình 2", 626, VietNamDivisionType.PHUONG, "phuong_my_dinh_2", 19)
    W_628 = Ward("Phường Tây Mỗ", 628, VietNamDivisionType.PHUONG, "phuong_tay_mo", 19)
    W_631 = Ward("Phường Mễ Trì", 631, VietNamDivisionType.PHUONG, "phuong_me_tri", 19)
    W_632 = Ward("Phường Phú Đô", 632, VietNamDivisionType.PHUONG, "phuong_phu_do", 19)
    W_634 = Ward("Phường Đại Mỗ", 634, VietNamDivisionType.PHUONG, "phuong_dai_mo", 19)
    W_637 = Ward("Phường Trung Văn", 637, VietNamDivisionType.PHUONG, "phuong_trung_van", 19)
    W_640 = Ward("Thị trấn Văn Điển", 640, VietNamDivisionType.THI_TRAN, "thi_tran_van_dien", 20)
    W_643 = Ward("Xã Tân Triều", 643, VietNamDivisionType.XA, "xa_tan_trieu", 20)
    W_646 = Ward("Xã Thanh Liệt", 646, VietNamDivisionType.XA, "xa_thanh_liet", 20)
    W_649 = Ward("Xã Tả Thanh Oai", 649, VietNamDivisionType.XA, "xa_ta_thanh_oai", 20)
    W_652 = Ward("Xã Hữu Hoà", 652, VietNamDivisionType.XA, "xa_huu_hoa", 20)
    W_655 = Ward("Xã Tam Hiệp", 655, VietNamDivisionType.XA, "xa_tam_hiep", 20)
    W_658 = Ward("Xã Tứ Hiệp", 658, VietNamDivisionType.XA, "xa_tu_hiep", 20)
    W_661 = Ward("Xã Yên Mỹ", 661, VietNamDivisionType.XA, "xa_yen_my", 20)
    W_664 = Ward("Xã Vĩnh Quỳnh", 664, VietNamDivisionType.XA, "xa_vinh_quynh", 20)
    W_667 = Ward("Xã Ngũ Hiệp", 667, VietNamDivisionType.XA, "xa_ngu_hiep", 20)
    W_670 = Ward("Xã Duyên Hà", 670, VietNamDivisionType.XA, "xa_duyen_ha", 20)
    W_673 = Ward("Xã Ngọc Hồi", 673, VietNamDivisionType.XA, "xa_ngoc_hoi", 20)
    W_676 = Ward("Xã Vạn Phúc", 676, VietNamDivisionType.XA, "xa_van_phuc", 20)
    W_679 = Ward("Xã Đại áng", 679, VietNamDivisionType.XA, "xa_dai_ang", 20)
    W_682 = Ward("Xã Liên Ninh", 682, VietNamDivisionType.XA, "xa_lien_ninh", 20)
    W_685 = Ward("Xã Đông Mỹ", 685, VietNamDivisionType.XA, "xa_dong_my", 20)
    W_595 = Ward("Phường Thượng Cát", 595, VietNamDivisionType.PHUONG, "phuong_thuong_cat", 21)
    W_598 = Ward("Phường Liên Mạc", 598, VietNamDivisionType.PHUONG, "phuong_lien_mac", 21)
    W_601 = Ward("Phường Đông Ngạc", 601, VietNamDivisionType.PHUONG, "phuong_dong_ngac", 21)
    W_602 = Ward("Phường Đức Thắng", 602, VietNamDivisionType.PHUONG, "phuong_duc_thang", 21)
    W_604 = Ward("Phường Thụy Phương", 604, VietNamDivisionType.PHUONG, "phuong_thuy_phuong", 21)
    W_607 = Ward("Phường Tây Tựu", 607, VietNamDivisionType.PHUONG, "phuong_tay_tuu", 21)
    W_610 = Ward("Phường Xuân Đỉnh", 610, VietNamDivisionType.PHUONG, "phuong_xuan_dinh", 21)
    W_611 = Ward("Phường Xuân Tảo", 611, VietNamDivisionType.PHUONG, "phuong_xuan_tao", 21)
    W_613 = Ward("Phường Minh Khai", 613, VietNamDivisionType.PHUONG, "phuong_minh_khai", 21)
    W_616 = Ward("Phường Cổ Nhuế 1", 616, VietNamDivisionType.PHUONG, "phuong_co_nhue_1", 21)
    W_617 = Ward("Phường Cổ Nhuế 2", 617, VietNamDivisionType.PHUONG, "phuong_co_nhue_2", 21)
    W_619 = Ward("Phường Phú Diễn", 619, VietNamDivisionType.PHUONG, "phuong_phu_dien", 21)
    W_620 = Ward("Phường Phúc Diễn", 620, VietNamDivisionType.PHUONG, "phuong_phuc_dien", 21)
    W_8973 = Ward("Thị trấn Chi Đông", 8973, VietNamDivisionType.THI_TRAN, "thi_tran_chi_dong", 250)
    W_8974 = Ward("Xã Đại Thịnh", 8974, VietNamDivisionType.XA, "xa_dai_thinh", 250)
    W_8977 = Ward("Xã Kim Hoa", 8977, VietNamDivisionType.XA, "xa_kim_hoa", 250)
    W_8980 = Ward("Xã Thạch Đà", 8980, VietNamDivisionType.XA, "xa_thach_da", 250)
    W_8983 = Ward("Xã Tiến Thắng", 8983, VietNamDivisionType.XA, "xa_tien_thang", 250)
    W_8986 = Ward("Xã Tự Lập", 8986, VietNamDivisionType.XA, "xa_tu_lap", 250)
    W_8989 = Ward("Thị trấn Quang Minh", 8989, VietNamDivisionType.THI_TRAN, "thi_tran_quang_minh", 250)
    W_8992 = Ward("Xã Thanh Lâm", 8992, VietNamDivisionType.XA, "xa_thanh_lam", 250)
    W_8995 = Ward("Xã Tam Đồng", 8995, VietNamDivisionType.XA, "xa_tam_dong", 250)
    W_8998 = Ward("Xã Liên Mạc", 8998, VietNamDivisionType.XA, "xa_lien_mac", 250)
    W_9001 = Ward("Xã Vạn Yên", 9001, VietNamDivisionType.XA, "xa_van_yen", 250)
    W_9004 = Ward("Xã Chu Phan", 9004, VietNamDivisionType.XA, "xa_chu_phan", 250)
    W_9007 = Ward("Xã Tiến Thịnh", 9007, VietNamDivisionType.XA, "xa_tien_thinh", 250)
    W_9010 = Ward("Xã Mê Linh", 9010, VietNamDivisionType.XA, "xa_me_linh", 250)
    W_9013 = Ward("Xã Văn Khê", 9013, VietNamDivisionType.XA, "xa_van_khe", 250)
    W_9016 = Ward("Xã Hoàng Kim", 9016, VietNamDivisionType.XA, "xa_hoang_kim", 250)
    W_9019 = Ward("Xã Tiền Phong", 9019, VietNamDivisionType.XA, "xa_tien_phong", 250)
    W_9022 = Ward("Xã Tráng Việt", 9022, VietNamDivisionType.XA, "xa_trang_viet", 250)
    W_9538 = Ward("Phường Nguyễn Trãi", 9538, VietNamDivisionType.PHUONG, "phuong_nguyen_trai", 268)
    W_9541 = Ward("Phường Mộ Lao", 9541, VietNamDivisionType.PHUONG, "phuong_mo_lao", 268)
    W_9542 = Ward("Phường Văn Quán", 9542, VietNamDivisionType.PHUONG, "phuong_van_quan", 268)
    W_9544 = Ward("Phường Vạn Phúc", 9544, VietNamDivisionType.PHUONG, "phuong_van_phuc", 268)
    W_9547 = Ward("Phường Yết Kiêu", 9547, VietNamDivisionType.PHUONG, "phuong_yet_kieu", 268)
    W_9550 = Ward("Phường Quang Trung", 9550, VietNamDivisionType.PHUONG, "phuong_quang_trung", 268)
    W_9551 = Ward("Phường La Khê", 9551, VietNamDivisionType.PHUONG, "phuong_la_khe", 268)
    W_9552 = Ward("Phường Phú La", 9552, VietNamDivisionType.PHUONG, "phuong_phu_la", 268)
    W_9553 = Ward("Phường Phúc La", 9553, VietNamDivisionType.PHUONG, "phuong_phuc_la", 268)
    W_9556 = Ward("Phường Hà Cầu", 9556, VietNamDivisionType.PHUONG, "phuong_ha_cau", 268)
    W_9562 = Ward("Phường Yên Nghĩa", 9562, VietNamDivisionType.PHUONG, "phuong_yen_nghia", 268)
    W_9565 = Ward("Phường Kiến Hưng", 9565, VietNamDivisionType.PHUONG, "phuong_kien_hung", 268)
    W_9568 = Ward("Phường Phú Lãm", 9568, VietNamDivisionType.PHUONG, "phuong_phu_lam", 268)
    W_9571 = Ward("Phường Phú Lương", 9571, VietNamDivisionType.PHUONG, "phuong_phu_luong", 268)
    W_9886 = Ward("Phường Dương Nội", 9886, VietNamDivisionType.PHUONG, "phuong_duong_noi", 268)
    W_10117 = Ward("Phường Đồng Mai", 10117, VietNamDivisionType.PHUONG, "phuong_dong_mai", 268)
    W_10123 = Ward("Phường Biên Giang", 10123, VietNamDivisionType.PHUONG, "phuong_bien_giang", 268)
    W_9574 = Ward("Phường Lê Lợi", 9574, VietNamDivisionType.PHUONG, "phuong_le_loi", 269)
    W_9577 = Ward("Phường Phú Thịnh", 9577, VietNamDivisionType.PHUONG, "phuong_phu_thinh", 269)
    W_9580 = Ward("Phường Ngô Quyền", 9580, VietNamDivisionType.PHUONG, "phuong_ngo_quyen", 269)
    W_9583 = Ward("Phường Quang Trung", 9583, VietNamDivisionType.PHUONG, "phuong_quang_trung", 269)
    W_9586 = Ward("Phường Sơn Lộc", 9586, VietNamDivisionType.PHUONG, "phuong_son_loc", 269)
    W_9589 = Ward("Phường Xuân Khanh", 9589, VietNamDivisionType.PHUONG, "phuong_xuan_khanh", 269)
    W_9592 = Ward("Xã Đường Lâm", 9592, VietNamDivisionType.XA, "xa_duong_lam", 269)
    W_9595 = Ward("Phường Viên Sơn", 9595, VietNamDivisionType.PHUONG, "phuong_vien_son", 269)
    W_9598 = Ward("Xã Xuân Sơn", 9598, VietNamDivisionType.XA, "xa_xuan_son", 269)
    W_9601 = Ward("Phường Trung Hưng", 9601, VietNamDivisionType.PHUONG, "phuong_trung_hung", 269)
    W_9604 = Ward("Xã Thanh Mỹ", 9604, VietNamDivisionType.XA, "xa_thanh_my", 269)
    W_9607 = Ward("Phường Trung Sơn Trầm", 9607, VietNamDivisionType.PHUONG, "phuong_trung_son_tram", 269)
    W_9610 = Ward("Xã Kim Sơn", 9610, VietNamDivisionType.XA, "xa_kim_son", 269)
    W_9613 = Ward("Xã Sơn Đông", 9613, VietNamDivisionType.XA, "xa_son_dong", 269)
    W_9616 = Ward("Xã Cổ Đông", 9616, VietNamDivisionType.XA, "xa_co_dong", 269)
    W_9619 = Ward("Thị trấn Tây Đằng", 9619, VietNamDivisionType.THI_TRAN, "thi_tran_tay_dang", 271)
    W_9625 = Ward("Xã Phú Cường", 9625, VietNamDivisionType.XA, "xa_phu_cuong", 271)
    W_9628 = Ward("Xã Cổ Đô", 9628, VietNamDivisionType.XA, "xa_co_do", 271)
    W_9631 = Ward("Xã Tản Hồng", 9631, VietNamDivisionType.XA, "xa_tan_hong", 271)
    W_9634 = Ward("Xã Vạn Thắng", 9634, VietNamDivisionType.XA, "xa_van_thang", 271)
    W_9637 = Ward("Xã Châu Sơn", 9637, VietNamDivisionType.XA, "xa_chau_son", 271)
    W_9640 = Ward("Xã Phong Vân", 9640, VietNamDivisionType.XA, "xa_phong_van", 271)
    W_9643 = Ward("Xã Phú Đông", 9643, VietNamDivisionType.XA, "xa_phu_dong", 271)
    W_9646 = Ward("Xã Phú Phương", 9646, VietNamDivisionType.XA, "xa_phu_phuong", 271)
    W_9649 = Ward("Xã Phú Châu", 9649, VietNamDivisionType.XA, "xa_phu_chau", 271)
    W_9652 = Ward("Xã Thái Hòa", 9652, VietNamDivisionType.XA, "xa_thai_hoa", 271)
    W_9655 = Ward("Xã Đồng Thái", 9655, VietNamDivisionType.XA, "xa_dong_thai", 271)
    W_9658 = Ward("Xã Phú Sơn", 9658, VietNamDivisionType.XA, "xa_phu_son", 271)
    W_9661 = Ward("Xã Minh Châu", 9661, VietNamDivisionType.XA, "xa_minh_chau", 271)
    W_9664 = Ward("Xã Vật Lại", 9664, VietNamDivisionType.XA, "xa_vat_lai", 271)
    W_9667 = Ward("Xã Chu Minh", 9667, VietNamDivisionType.XA, "xa_chu_minh", 271)
    W_9670 = Ward("Xã Tòng Bạt", 9670, VietNamDivisionType.XA, "xa_tong_bat", 271)
    W_9673 = Ward("Xã Cẩm Lĩnh", 9673, VietNamDivisionType.XA, "xa_cam_linh", 271)
    W_9676 = Ward("Xã Sơn Đà", 9676, VietNamDivisionType.XA, "xa_son_da", 271)
    W_9679 = Ward("Xã Đông Quang", 9679, VietNamDivisionType.XA, "xa_dong_quang", 271)
    W_9682 = Ward("Xã Tiên Phong", 9682, VietNamDivisionType.XA, "xa_tien_phong", 271)
    W_9685 = Ward("Xã Thụy An", 9685, VietNamDivisionType.XA, "xa_thuy_an", 271)
    W_9688 = Ward("Xã Cam Thượng", 9688, VietNamDivisionType.XA, "xa_cam_thuong", 271)
    W_9691 = Ward("Xã Thuần Mỹ", 9691, VietNamDivisionType.XA, "xa_thuan_my", 271)
    W_9694 = Ward("Xã Tản Lĩnh", 9694, VietNamDivisionType.XA, "xa_tan_linh", 271)
    W_9697 = Ward("Xã Ba Trại", 9697, VietNamDivisionType.XA, "xa_ba_trai", 271)
    W_9700 = Ward("Xã Minh Quang", 9700, VietNamDivisionType.XA, "xa_minh_quang", 271)
    W_9703 = Ward("Xã Ba Vì", 9703, VietNamDivisionType.XA, "xa_ba_vi", 271)
    W_9706 = Ward("Xã Vân Hòa", 9706, VietNamDivisionType.XA, "xa_van_hoa", 271)
    W_9709 = Ward("Xã Yên Bài", 9709, VietNamDivisionType.XA, "xa_yen_bai", 271)
    W_9712 = Ward("Xã Khánh Thượng", 9712, VietNamDivisionType.XA, "xa_khanh_thuong", 271)
    W_9715 = Ward("Thị trấn Phúc Thọ", 9715, VietNamDivisionType.THI_TRAN, "thi_tran_phuc_tho", 272)
    W_9718 = Ward("Xã Vân Hà", 9718, VietNamDivisionType.XA, "xa_van_ha", 272)
    W_9721 = Ward("Xã Vân Phúc", 9721, VietNamDivisionType.XA, "xa_van_phuc", 272)
    W_9724 = Ward("Xã Vân Nam", 9724, VietNamDivisionType.XA, "xa_van_nam", 272)
    W_9727 = Ward("Xã Xuân Đình", 9727, VietNamDivisionType.XA, "xa_xuan_dinh", 272)
    W_9733 = Ward("Xã Sen Phương", 9733, VietNamDivisionType.XA, "xa_sen_phuong", 272)
    W_9739 = Ward("Xã Võng Xuyên", 9739, VietNamDivisionType.XA, "xa_vong_xuyen", 272)
    W_9742 = Ward("Xã Thọ Lộc", 9742, VietNamDivisionType.XA, "xa_tho_loc", 272)
    W_9745 = Ward("Xã Long Xuyên", 9745, VietNamDivisionType.XA, "xa_long_xuyen", 272)
    W_9748 = Ward("Xã Thượng Cốc", 9748, VietNamDivisionType.XA, "xa_thuong_coc", 272)
    W_9751 = Ward("Xã Hát Môn", 9751, VietNamDivisionType.XA, "xa_hat_mon", 272)
    W_9754 = Ward("Xã Tích Giang", 9754, VietNamDivisionType.XA, "xa_tich_giang", 272)
    W_9757 = Ward("Xã Thanh Đa", 9757, VietNamDivisionType.XA, "xa_thanh_da", 272)
    W_9760 = Ward("Xã Trạch Mỹ Lộc", 9760, VietNamDivisionType.XA, "xa_trach_my_loc", 272)
    W_9763 = Ward("Xã Phúc Hòa", 9763, VietNamDivisionType.XA, "xa_phuc_hoa", 272)
    W_9766 = Ward("Xã Ngọc Tảo", 9766, VietNamDivisionType.XA, "xa_ngoc_tao", 272)
    W_9769 = Ward("Xã Phụng Thượng", 9769, VietNamDivisionType.XA, "xa_phung_thuong", 272)
    W_9772 = Ward("Xã Tam Thuấn", 9772, VietNamDivisionType.XA, "xa_tam_thuan", 272)
    W_9775 = Ward("Xã Tam Hiệp", 9775, VietNamDivisionType.XA, "xa_tam_hiep", 272)
    W_9778 = Ward("Xã Hiệp Thuận", 9778, VietNamDivisionType.XA, "xa_hiep_thuan", 272)
    W_9781 = Ward("Xã Liên Hiệp", 9781, VietNamDivisionType.XA, "xa_lien_hiep", 272)
    W_9784 = Ward("Thị trấn Phùng", 9784, VietNamDivisionType.THI_TRAN, "thi_tran_phung", 273)
    W_9787 = Ward("Xã Trung Châu", 9787, VietNamDivisionType.XA, "xa_trung_chau", 273)
    W_9790 = Ward("Xã Thọ An", 9790, VietNamDivisionType.XA, "xa_tho_an", 273)
    W_9793 = Ward("Xã Thọ Xuân", 9793, VietNamDivisionType.XA, "xa_tho_xuan", 273)
    W_9796 = Ward("Xã Hồng Hà", 9796, VietNamDivisionType.XA, "xa_hong_ha", 273)
    W_9799 = Ward("Xã Liên Hồng", 9799, VietNamDivisionType.XA, "xa_lien_hong", 273)
    W_9802 = Ward("Xã Liên Hà", 9802, VietNamDivisionType.XA, "xa_lien_ha", 273)
    W_9805 = Ward("Xã Hạ Mỗ", 9805, VietNamDivisionType.XA, "xa_ha_mo", 273)
    W_9808 = Ward("Xã Liên Trung", 9808, VietNamDivisionType.XA, "xa_lien_trung", 273)
    W_9811 = Ward("Xã Phương Đình", 9811, VietNamDivisionType.XA, "xa_phuong_dinh", 273)
    W_9814 = Ward("Xã Thượng Mỗ", 9814, VietNamDivisionType.XA, "xa_thuong_mo", 273)
    W_9817 = Ward("Xã Tân Hội", 9817, VietNamDivisionType.XA, "xa_tan_hoi", 273)
    W_9820 = Ward("Xã Tân Lập", 9820, VietNamDivisionType.XA, "xa_tan_lap", 273)
    W_9823 = Ward("Xã Đan Phượng", 9823, VietNamDivisionType.XA, "xa_dan_phuong", 273)
    W_9826 = Ward("Xã Đồng Tháp", 9826, VietNamDivisionType.XA, "xa_dong_thap", 273)
    W_9829 = Ward("Xã Song Phượng", 9829, VietNamDivisionType.XA, "xa_song_phuong", 273)
    W_9832 = Ward("Thị trấn Trạm Trôi", 9832, VietNamDivisionType.THI_TRAN, "thi_tran_tram_troi", 274)
    W_9835 = Ward("Xã Đức Thượng", 9835, VietNamDivisionType.XA, "xa_duc_thuong", 274)
    W_9838 = Ward("Xã Minh Khai", 9838, VietNamDivisionType.XA, "xa_minh_khai", 274)
    W_9841 = Ward("Xã Dương Liễu", 9841, VietNamDivisionType.XA, "xa_duong_lieu", 274)
    W_9844 = Ward("Xã Di Trạch", 9844, VietNamDivisionType.XA, "xa_di_trach", 274)
    W_9847 = Ward("Xã Đức Giang", 9847, VietNamDivisionType.XA, "xa_duc_giang", 274)
    W_9850 = Ward("Xã Cát Quế", 9850, VietNamDivisionType.XA, "xa_cat_que", 274)
    W_9853 = Ward("Xã Kim Chung", 9853, VietNamDivisionType.XA, "xa_kim_chung", 274)
    W_9856 = Ward("Xã Yên Sở", 9856, VietNamDivisionType.XA, "xa_yen_so", 274)
    W_9859 = Ward("Xã Sơn Đồng", 9859, VietNamDivisionType.XA, "xa_son_dong", 274)
    W_9862 = Ward("Xã Vân Canh", 9862, VietNamDivisionType.XA, "xa_van_canh", 274)
    W_9865 = Ward("Xã Đắc Sở", 9865, VietNamDivisionType.XA, "xa_dac_so", 274)
    W_9868 = Ward("Xã Lại Yên", 9868, VietNamDivisionType.XA, "xa_lai_yen", 274)
    W_9871 = Ward("Xã Tiền Yên", 9871, VietNamDivisionType.XA, "xa_tien_yen", 274)
    W_9874 = Ward("Xã Song Phương", 9874, VietNamDivisionType.XA, "xa_song_phuong", 274)
    W_9877 = Ward("Xã An Khánh", 9877, VietNamDivisionType.XA, "xa_an_khanh", 274)
    W_9880 = Ward("Xã An Thượng", 9880, VietNamDivisionType.XA, "xa_an_thuong", 274)
    W_9883 = Ward("Xã Vân Côn", 9883, VietNamDivisionType.XA, "xa_van_con", 274)
    W_9889 = Ward("Xã La Phù", 9889, VietNamDivisionType.XA, "xa_la_phu", 274)
    W_9892 = Ward("Xã Đông La", 9892, VietNamDivisionType.XA, "xa_dong_la", 274)
    W_4939 = Ward("Xã Đông Xuân", 4939, VietNamDivisionType.XA, "xa_dong_xuan", 275)
    W_9895 = Ward("Thị trấn Quốc Oai", 9895, VietNamDivisionType.THI_TRAN, "thi_tran_quoc_oai", 275)
    W_9898 = Ward("Xã Sài Sơn", 9898, VietNamDivisionType.XA, "xa_sai_son", 275)
    W_9901 = Ward("Xã Phượng Cách", 9901, VietNamDivisionType.XA, "xa_phuong_cach", 275)
    W_9904 = Ward("Xã Yên Sơn", 9904, VietNamDivisionType.XA, "xa_yen_son", 275)
    W_9907 = Ward("Xã Ngọc Liệp", 9907, VietNamDivisionType.XA, "xa_ngoc_liep", 275)
    W_9910 = Ward("Xã Ngọc Mỹ", 9910, VietNamDivisionType.XA, "xa_ngoc_my", 275)
    W_9913 = Ward("Xã Liệp Tuyết", 9913, VietNamDivisionType.XA, "xa_liep_tuyet", 275)
    W_9916 = Ward("Xã Thạch Thán", 9916, VietNamDivisionType.XA, "xa_thach_than", 275)
    W_9919 = Ward("Xã Đồng Quang", 9919, VietNamDivisionType.XA, "xa_dong_quang", 275)
    W_9922 = Ward("Xã Phú Cát", 9922, VietNamDivisionType.XA, "xa_phu_cat", 275)
    W_9925 = Ward("Xã Tuyết Nghĩa", 9925, VietNamDivisionType.XA, "xa_tuyet_nghia", 275)
    W_9928 = Ward("Xã Nghĩa Hương", 9928, VietNamDivisionType.XA, "xa_nghia_huong", 275)
    W_9931 = Ward("Xã Cộng Hòa", 9931, VietNamDivisionType.XA, "xa_cong_hoa", 275)
    W_9934 = Ward("Xã Tân Phú", 9934, VietNamDivisionType.XA, "xa_tan_phu", 275)
    W_9937 = Ward("Xã Đại Thành", 9937, VietNamDivisionType.XA, "xa_dai_thanh", 275)
    W_9940 = Ward("Xã Phú Mãn", 9940, VietNamDivisionType.XA, "xa_phu_man", 275)
    W_9943 = Ward("Xã Cấn Hữu", 9943, VietNamDivisionType.XA, "xa_can_huu", 275)
    W_9946 = Ward("Xã Tân Hòa", 9946, VietNamDivisionType.XA, "xa_tan_hoa", 275)
    W_9949 = Ward("Xã Hòa Thạch", 9949, VietNamDivisionType.XA, "xa_hoa_thach", 275)
    W_9952 = Ward("Xã Đông Yên", 9952, VietNamDivisionType.XA, "xa_dong_yen", 275)
    W_4927 = Ward("Xã Yên Trung", 4927, VietNamDivisionType.XA, "xa_yen_trung", 276)
    W_4930 = Ward("Xã Yên Bình", 4930, VietNamDivisionType.XA, "xa_yen_binh", 276)
    W_4936 = Ward("Xã Tiến Xuân", 4936, VietNamDivisionType.XA, "xa_tien_xuan", 276)
    W_9955 = Ward("Thị trấn Liên Quan", 9955, VietNamDivisionType.THI_TRAN, "thi_tran_lien_quan", 276)
    W_9958 = Ward("Xã Đại Đồng", 9958, VietNamDivisionType.XA, "xa_dai_dong", 276)
    W_9961 = Ward("Xã Cẩm Yên", 9961, VietNamDivisionType.XA, "xa_cam_yen", 276)
    W_9964 = Ward("Xã Lại Thượng", 9964, VietNamDivisionType.XA, "xa_lai_thuong", 276)
    W_9967 = Ward("Xã Phú Kim", 9967, VietNamDivisionType.XA, "xa_phu_kim", 276)
    W_9970 = Ward("Xã Hương Ngải", 9970, VietNamDivisionType.XA, "xa_huong_ngai", 276)
    W_9973 = Ward("Xã Canh Nậu", 9973, VietNamDivisionType.XA, "xa_canh_nau", 276)
    W_9976 = Ward("Xã Kim Quan", 9976, VietNamDivisionType.XA, "xa_kim_quan", 276)
    W_9979 = Ward("Xã Dị Nậu", 9979, VietNamDivisionType.XA, "xa_di_nau", 276)
    W_9982 = Ward("Xã Bình Yên", 9982, VietNamDivisionType.XA, "xa_binh_yen", 276)
    W_9985 = Ward("Xã Chàng Sơn", 9985, VietNamDivisionType.XA, "xa_chang_son", 276)
    W_9988 = Ward("Xã Thạch Hoà", 9988, VietNamDivisionType.XA, "xa_thach_hoa", 276)
    W_9991 = Ward("Xã Cần Kiệm", 9991, VietNamDivisionType.XA, "xa_can_kiem", 276)
    W_9994 = Ward("Xã Hữu Bằng", 9994, VietNamDivisionType.XA, "xa_huu_bang", 276)
    W_9997 = Ward("Xã Phùng Xá", 9997, VietNamDivisionType.XA, "xa_phung_xa", 276)
    W_10000 = Ward("Xã Tân Xã", 10000, VietNamDivisionType.XA, "xa_tan_xa", 276)
    W_10003 = Ward("Xã Thạch Xá", 10003, VietNamDivisionType.XA, "xa_thach_xa", 276)
    W_10006 = Ward("Xã Bình Phú", 10006, VietNamDivisionType.XA, "xa_binh_phu", 276)
    W_10009 = Ward("Xã Hạ Bằng", 10009, VietNamDivisionType.XA, "xa_ha_bang", 276)
    W_10012 = Ward("Xã Đồng Trúc", 10012, VietNamDivisionType.XA, "xa_dong_truc", 276)
    W_10015 = Ward("Thị trấn Chúc Sơn", 10015, VietNamDivisionType.THI_TRAN, "thi_tran_chuc_son", 277)
    W_10018 = Ward("Thị trấn Xuân Mai", 10018, VietNamDivisionType.THI_TRAN, "thi_tran_xuan_mai", 277)
    W_10021 = Ward("Xã Phụng Châu", 10021, VietNamDivisionType.XA, "xa_phung_chau", 277)
    W_10024 = Ward("Xã Tiên Phương", 10024, VietNamDivisionType.XA, "xa_tien_phuong", 277)
    W_10027 = Ward("Xã Đông Sơn", 10027, VietNamDivisionType.XA, "xa_dong_son", 277)
    W_10030 = Ward("Xã Đông Phương Yên", 10030, VietNamDivisionType.XA, "xa_dong_phuong_yen", 277)
    W_10033 = Ward("Xã Phú Nghĩa", 10033, VietNamDivisionType.XA, "xa_phu_nghia", 277)
    W_10039 = Ward("Xã Trường Yên", 10039, VietNamDivisionType.XA, "xa_truong_yen", 277)
    W_10042 = Ward("Xã Ngọc Hòa", 10042, VietNamDivisionType.XA, "xa_ngoc_hoa", 277)
    W_10045 = Ward("Xã Thủy Xuân Tiên", 10045, VietNamDivisionType.XA, "xa_thuy_xuan_tien", 277)
    W_10048 = Ward("Xã Thanh Bình", 10048, VietNamDivisionType.XA, "xa_thanh_binh", 277)
    W_10051 = Ward("Xã Trung Hòa", 10051, VietNamDivisionType.XA, "xa_trung_hoa", 277)
    W_10054 = Ward("Xã Đại Yên", 10054, VietNamDivisionType.XA, "xa_dai_yen", 277)
    W_10057 = Ward("Xã Thụy Hương", 10057, VietNamDivisionType.XA, "xa_thuy_huong", 277)
    W_10060 = Ward("Xã Tốt Động", 10060, VietNamDivisionType.XA, "xa_tot_dong", 277)
    W_10063 = Ward("Xã Lam Điền", 10063, VietNamDivisionType.XA, "xa_lam_dien", 277)
    W_10066 = Ward("Xã Tân Tiến", 10066, VietNamDivisionType.XA, "xa_tan_tien", 277)
    W_10069 = Ward("Xã Nam Phương Tiến", 10069, VietNamDivisionType.XA, "xa_nam_phuong_tien", 277)
    W_10072 = Ward("Xã Hợp Đồng", 10072, VietNamDivisionType.XA, "xa_hop_dong", 277)
    W_10075 = Ward("Xã Hoàng Văn Thụ", 10075, VietNamDivisionType.XA, "xa_hoang_van_thu", 277)
    W_10078 = Ward("Xã Hoàng Diệu", 10078, VietNamDivisionType.XA, "xa_hoang_dieu", 277)
    W_10081 = Ward("Xã Hữu Văn", 10081, VietNamDivisionType.XA, "xa_huu_van", 277)
    W_10084 = Ward("Xã Quảng Bị", 10084, VietNamDivisionType.XA, "xa_quang_bi", 277)
    W_10087 = Ward("Xã Mỹ Lương", 10087, VietNamDivisionType.XA, "xa_my_luong", 277)
    W_10090 = Ward("Xã Thượng Vực", 10090, VietNamDivisionType.XA, "xa_thuong_vuc", 277)
    W_10093 = Ward("Xã Hồng Phong", 10093, VietNamDivisionType.XA, "xa_hong_phong", 277)
    W_10096 = Ward("Xã Đồng Phú", 10096, VietNamDivisionType.XA, "xa_dong_phu", 277)
    W_10099 = Ward("Xã Trần Phú", 10099, VietNamDivisionType.XA, "xa_tran_phu", 277)
    W_10102 = Ward("Xã Văn Võ", 10102, VietNamDivisionType.XA, "xa_van_vo", 277)
    W_10105 = Ward("Xã Đồng Lạc", 10105, VietNamDivisionType.XA, "xa_dong_lac", 277)
    W_10108 = Ward("Xã Hòa Chính", 10108, VietNamDivisionType.XA, "xa_hoa_chinh", 277)
    W_10111 = Ward("Xã Phú Nam An", 10111, VietNamDivisionType.XA, "xa_phu_nam_an", 277)
    W_10114 = Ward("Thị trấn Kim Bài", 10114, VietNamDivisionType.THI_TRAN, "thi_tran_kim_bai", 278)
    W_10120 = Ward("Xã Cự Khê", 10120, VietNamDivisionType.XA, "xa_cu_khe", 278)
    W_10126 = Ward("Xã Bích Hòa", 10126, VietNamDivisionType.XA, "xa_bich_hoa", 278)
    W_10129 = Ward("Xã Mỹ Hưng", 10129, VietNamDivisionType.XA, "xa_my_hung", 278)
    W_10132 = Ward("Xã Cao Viên", 10132, VietNamDivisionType.XA, "xa_cao_vien", 278)
    W_10135 = Ward("Xã Bình Minh", 10135, VietNamDivisionType.XA, "xa_binh_minh", 278)
    W_10138 = Ward("Xã Tam Hưng", 10138, VietNamDivisionType.XA, "xa_tam_hung", 278)
    W_10141 = Ward("Xã Thanh Cao", 10141, VietNamDivisionType.XA, "xa_thanh_cao", 278)
    W_10144 = Ward("Xã Thanh Thùy", 10144, VietNamDivisionType.XA, "xa_thanh_thuy", 278)
    W_10147 = Ward("Xã Thanh Mai", 10147, VietNamDivisionType.XA, "xa_thanh_mai", 278)
    W_10150 = Ward("Xã Thanh Văn", 10150, VietNamDivisionType.XA, "xa_thanh_van", 278)
    W_10153 = Ward("Xã Đỗ Động", 10153, VietNamDivisionType.XA, "xa_do_dong", 278)
    W_10156 = Ward("Xã Kim An", 10156, VietNamDivisionType.XA, "xa_kim_an", 278)
    W_10159 = Ward("Xã Kim Thư", 10159, VietNamDivisionType.XA, "xa_kim_thu", 278)
    W_10162 = Ward("Xã Phương Trung", 10162, VietNamDivisionType.XA, "xa_phuong_trung", 278)
    W_10165 = Ward("Xã Tân Ước", 10165, VietNamDivisionType.XA, "xa_tan_uoc", 278)
    W_10168 = Ward("Xã Dân Hòa", 10168, VietNamDivisionType.XA, "xa_dan_hoa", 278)
    W_10171 = Ward("Xã Liên Châu", 10171, VietNamDivisionType.XA, "xa_lien_chau", 278)
    W_10174 = Ward("Xã Cao Dương", 10174, VietNamDivisionType.XA, "xa_cao_duong", 278)
    W_10177 = Ward("Xã Xuân Dương", 10177, VietNamDivisionType.XA, "xa_xuan_duong", 278)
    W_10180 = Ward("Xã Hồng Dương", 10180, VietNamDivisionType.XA, "xa_hong_duong", 278)
    W_10183 = Ward("Thị trấn Thường Tín", 10183, VietNamDivisionType.THI_TRAN, "thi_tran_thuong_tin", 279)
    W_10186 = Ward("Xã Ninh Sở", 10186, VietNamDivisionType.XA, "xa_ninh_so", 279)
    W_10189 = Ward("Xã Nhị Khê", 10189, VietNamDivisionType.XA, "xa_nhi_khe", 279)
    W_10192 = Ward("Xã Duyên Thái", 10192, VietNamDivisionType.XA, "xa_duyen_thai", 279)
    W_10195 = Ward("Xã Khánh Hà", 10195, VietNamDivisionType.XA, "xa_khanh_ha", 279)
    W_10198 = Ward("Xã Hòa Bình", 10198, VietNamDivisionType.XA, "xa_hoa_binh", 279)
    W_10201 = Ward("Xã Văn Bình", 10201, VietNamDivisionType.XA, "xa_van_binh", 279)
    W_10204 = Ward("Xã Hiền Giang", 10204, VietNamDivisionType.XA, "xa_hien_giang", 279)
    W_10207 = Ward("Xã Hồng Vân", 10207, VietNamDivisionType.XA, "xa_hong_van", 279)
    W_10210 = Ward("Xã Vân Tảo", 10210, VietNamDivisionType.XA, "xa_van_tao", 279)
    W_10213 = Ward("Xã Liên Phương", 10213, VietNamDivisionType.XA, "xa_lien_phuong", 279)
    W_10216 = Ward("Xã Văn Phú", 10216, VietNamDivisionType.XA, "xa_van_phu", 279)
    W_10219 = Ward("Xã Tự Nhiên", 10219, VietNamDivisionType.XA, "xa_tu_nhien", 279)
    W_10222 = Ward("Xã Tiền Phong", 10222, VietNamDivisionType.XA, "xa_tien_phong", 279)
    W_10225 = Ward("Xã Hà Hồi", 10225, VietNamDivisionType.XA, "xa_ha_hoi", 279)
    W_10228 = Ward("Xã Thư Phú", 10228, VietNamDivisionType.XA, "xa_thu_phu", 279)
    W_10231 = Ward("Xã Nguyễn Trãi", 10231, VietNamDivisionType.XA, "xa_nguyen_trai", 279)
    W_10234 = Ward("Xã Quất Động", 10234, VietNamDivisionType.XA, "xa_quat_dong", 279)
    W_10237 = Ward("Xã Chương Dương", 10237, VietNamDivisionType.XA, "xa_chuong_duong", 279)
    W_10240 = Ward("Xã Tân Minh", 10240, VietNamDivisionType.XA, "xa_tan_minh", 279)
    W_10243 = Ward("Xã Lê Lợi", 10243, VietNamDivisionType.XA, "xa_le_loi", 279)
    W_10246 = Ward("Xã Thắng Lợi", 10246, VietNamDivisionType.XA, "xa_thang_loi", 279)
    W_10249 = Ward("Xã Dũng Tiến", 10249, VietNamDivisionType.XA, "xa_dung_tien", 279)
    W_10252 = Ward("Xã Thống Nhất", 10252, VietNamDivisionType.XA, "xa_thong_nhat", 279)
    W_10255 = Ward("Xã Nghiêm Xuyên", 10255, VietNamDivisionType.XA, "xa_nghiem_xuyen", 279)
    W_10258 = Ward("Xã Tô Hiệu", 10258, VietNamDivisionType.XA, "xa_to_hieu", 279)
    W_10261 = Ward("Xã Văn Tự", 10261, VietNamDivisionType.XA, "xa_van_tu", 279)
    W_10264 = Ward("Xã Vạn Điểm", 10264, VietNamDivisionType.XA, "xa_van_diem", 279)
    W_10267 = Ward("Xã Minh Cường", 10267, VietNamDivisionType.XA, "xa_minh_cuong", 279)
    W_10270 = Ward("Thị trấn Phú Minh", 10270, VietNamDivisionType.THI_TRAN, "thi_tran_phu_minh", 280)
    W_10273 = Ward("Thị trấn Phú Xuyên", 10273, VietNamDivisionType.THI_TRAN, "thi_tran_phu_xuyen", 280)
    W_10276 = Ward("Xã Hồng Minh", 10276, VietNamDivisionType.XA, "xa_hong_minh", 280)
    W_10279 = Ward("Xã Phượng Dực", 10279, VietNamDivisionType.XA, "xa_phuong_duc", 280)
    W_10282 = Ward("Xã Nam Tiến", 10282, VietNamDivisionType.XA, "xa_nam_tien", 280)
    W_10288 = Ward("Xã Tri Trung", 10288, VietNamDivisionType.XA, "xa_tri_trung", 280)
    W_10291 = Ward("Xã Đại Thắng", 10291, VietNamDivisionType.XA, "xa_dai_thang", 280)
    W_10294 = Ward("Xã Phú Túc", 10294, VietNamDivisionType.XA, "xa_phu_tuc", 280)
    W_10297 = Ward("Xã Văn Hoàng", 10297, VietNamDivisionType.XA, "xa_van_hoang", 280)
    W_10300 = Ward("Xã Hồng Thái", 10300, VietNamDivisionType.XA, "xa_hong_thai", 280)
    W_10303 = Ward("Xã Hoàng Long", 10303, VietNamDivisionType.XA, "xa_hoang_long", 280)
    W_10306 = Ward("Xã Quang Trung", 10306, VietNamDivisionType.XA, "xa_quang_trung", 280)
    W_10309 = Ward("Xã Nam Phong", 10309, VietNamDivisionType.XA, "xa_nam_phong", 280)
    W_10312 = Ward("Xã Nam Triều", 10312, VietNamDivisionType.XA, "xa_nam_trieu", 280)
    W_10315 = Ward("Xã Tân Dân", 10315, VietNamDivisionType.XA, "xa_tan_dan", 280)
    W_10318 = Ward("Xã Sơn Hà", 10318, VietNamDivisionType.XA, "xa_son_ha", 280)
    W_10321 = Ward("Xã Chuyên Mỹ", 10321, VietNamDivisionType.XA, "xa_chuyen_my", 280)
    W_10324 = Ward("Xã Khai Thái", 10324, VietNamDivisionType.XA, "xa_khai_thai", 280)
    W_10327 = Ward("Xã Phúc Tiến", 10327, VietNamDivisionType.XA, "xa_phuc_tien", 280)
    W_10330 = Ward("Xã Vân Từ", 10330, VietNamDivisionType.XA, "xa_van_tu", 280)
    W_10333 = Ward("Xã Tri Thủy", 10333, VietNamDivisionType.XA, "xa_tri_thuy", 280)
    W_10336 = Ward("Xã Đại Xuyên", 10336, VietNamDivisionType.XA, "xa_dai_xuyen", 280)
    W_10339 = Ward("Xã Phú Yên", 10339, VietNamDivisionType.XA, "xa_phu_yen", 280)
    W_10342 = Ward("Xã Bạch Hạ", 10342, VietNamDivisionType.XA, "xa_bach_ha", 280)
    W_10345 = Ward("Xã Quang Lãng", 10345, VietNamDivisionType.XA, "xa_quang_lang", 280)
    W_10348 = Ward("Xã Châu Can", 10348, VietNamDivisionType.XA, "xa_chau_can", 280)
    W_10351 = Ward("Xã Minh Tân", 10351, VietNamDivisionType.XA, "xa_minh_tan", 280)
    W_10354 = Ward("Thị trấn Vân Đình", 10354, VietNamDivisionType.THI_TRAN, "thi_tran_van_dinh", 281)
    W_10357 = Ward("Xã Viên An", 10357, VietNamDivisionType.XA, "xa_vien_an", 281)
    W_10360 = Ward("Xã Viên Nội", 10360, VietNamDivisionType.XA, "xa_vien_noi", 281)
    W_10363 = Ward("Xã Hoa Sơn", 10363, VietNamDivisionType.XA, "xa_hoa_son", 281)
    W_10366 = Ward("Xã Quảng Phú Cầu", 10366, VietNamDivisionType.XA, "xa_quang_phu_cau", 281)
    W_10369 = Ward("Xã Trường Thịnh", 10369, VietNamDivisionType.XA, "xa_truong_thinh", 281)
    W_10372 = Ward("Xã Cao Thành", 10372, VietNamDivisionType.XA, "xa_cao_thanh", 281)
    W_10375 = Ward("Xã Liên Bạt", 10375, VietNamDivisionType.XA, "xa_lien_bat", 281)
    W_10378 = Ward("Xã Sơn Công", 10378, VietNamDivisionType.XA, "xa_son_cong", 281)
    W_10381 = Ward("Xã Đồng Tiến", 10381, VietNamDivisionType.XA, "xa_dong_tien", 281)
    W_10384 = Ward("Xã Phương Tú", 10384, VietNamDivisionType.XA, "xa_phuong_tu", 281)
    W_10387 = Ward("Xã Trung Tú", 10387, VietNamDivisionType.XA, "xa_trung_tu", 281)
    W_10390 = Ward("Xã Đồng Tân", 10390, VietNamDivisionType.XA, "xa_dong_tan", 281)
    W_10393 = Ward("Xã Tảo Dương Văn", 10393, VietNamDivisionType.XA, "xa_tao_duong_van", 281)
    W_10396 = Ward("Xã Vạn Thái", 10396, VietNamDivisionType.XA, "xa_van_thai", 281)
    W_10399 = Ward("Xã Minh Đức", 10399, VietNamDivisionType.XA, "xa_minh_duc", 281)
    W_10402 = Ward("Xã Hòa Lâm", 10402, VietNamDivisionType.XA, "xa_hoa_lam", 281)
    W_10405 = Ward("Xã Hòa Xá", 10405, VietNamDivisionType.XA, "xa_hoa_xa", 281)
    W_10408 = Ward("Xã Trầm Lộng", 10408, VietNamDivisionType.XA, "xa_tram_long", 281)
    W_10411 = Ward("Xã Kim Đường", 10411, VietNamDivisionType.XA, "xa_kim_duong", 281)
    W_10414 = Ward("Xã Hòa Nam", 10414, VietNamDivisionType.XA, "xa_hoa_nam", 281)
    W_10417 = Ward("Xã Hòa Phú", 10417, VietNamDivisionType.XA, "xa_hoa_phu", 281)
    W_10420 = Ward("Xã Đội Bình", 10420, VietNamDivisionType.XA, "xa_doi_binh", 281)
    W_10423 = Ward("Xã Đại Hùng", 10423, VietNamDivisionType.XA, "xa_dai_hung", 281)
    W_10426 = Ward("Xã Đông Lỗ", 10426, VietNamDivisionType.XA, "xa_dong_lo", 281)
    W_10429 = Ward("Xã Phù Lưu", 10429, VietNamDivisionType.XA, "xa_phu_luu", 281)
    W_10432 = Ward("Xã Đại Cường", 10432, VietNamDivisionType.XA, "xa_dai_cuong", 281)
    W_10435 = Ward("Xã Lưu Hoàng", 10435, VietNamDivisionType.XA, "xa_luu_hoang", 281)
    W_10438 = Ward("Xã Hồng Quang", 10438, VietNamDivisionType.XA, "xa_hong_quang", 281)
    W_10441 = Ward("Thị trấn Đại Nghĩa", 10441, VietNamDivisionType.THI_TRAN, "thi_tran_dai_nghia", 282)
    W_10444 = Ward("Xã Đồng Tâm", 10444, VietNamDivisionType.XA, "xa_dong_tam", 282)
    W_10447 = Ward("Xã Thượng Lâm", 10447, VietNamDivisionType.XA, "xa_thuong_lam", 282)
    W_10450 = Ward("Xã Tuy Lai", 10450, VietNamDivisionType.XA, "xa_tuy_lai", 282)
    W_10453 = Ward("Xã Phúc Lâm", 10453, VietNamDivisionType.XA, "xa_phuc_lam", 282)
    W_10456 = Ward("Xã Mỹ Thành", 10456, VietNamDivisionType.XA, "xa_my_thanh", 282)
    W_10459 = Ward("Xã Bột Xuyên", 10459, VietNamDivisionType.XA, "xa_bot_xuyen", 282)
    W_10462 = Ward("Xã An Mỹ", 10462, VietNamDivisionType.XA, "xa_an_my", 282)
    W_10465 = Ward("Xã Hồng Sơn", 10465, VietNamDivisionType.XA, "xa_hong_son", 282)
    W_10468 = Ward("Xã Lê Thanh", 10468, VietNamDivisionType.XA, "xa_le_thanh", 282)
    W_10471 = Ward("Xã Xuy Xá", 10471, VietNamDivisionType.XA, "xa_xuy_xa", 282)
    W_10474 = Ward("Xã Phùng Xá", 10474, VietNamDivisionType.XA, "xa_phung_xa", 282)
    W_10477 = Ward("Xã Phù Lưu Tế", 10477, VietNamDivisionType.XA, "xa_phu_luu_te", 282)
    W_10480 = Ward("Xã Đại Hưng", 10480, VietNamDivisionType.XA, "xa_dai_hung", 282)
    W_10483 = Ward("Xã Vạn Kim", 10483, VietNamDivisionType.XA, "xa_van_kim", 282)
    W_10486 = Ward("Xã Đốc Tín", 10486, VietNamDivisionType.XA, "xa_doc_tin", 282)
    W_10489 = Ward("Xã Hương Sơn", 10489, VietNamDivisionType.XA, "xa_huong_son", 282)
    W_10492 = Ward("Xã Hùng Tiến", 10492, VietNamDivisionType.XA, "xa_hung_tien", 282)
    W_10495 = Ward("Xã An Tiến", 10495, VietNamDivisionType.XA, "xa_an_tien", 282)
    W_10498 = Ward("Xã Hợp Tiến", 10498, VietNamDivisionType.XA, "xa_hop_tien", 282)
    W_10501 = Ward("Xã Hợp Thanh", 10501, VietNamDivisionType.XA, "xa_hop_thanh", 282)
    W_10504 = Ward("Xã An Phú", 10504, VietNamDivisionType.XA, "xa_an_phu", 282)
    W_688 = Ward("Phường Quang Trung", 688, VietNamDivisionType.PHUONG, "phuong_quang_trung", 24)
    W_691 = Ward("Phường Trần Phú", 691, VietNamDivisionType.PHUONG, "phuong_tran_phu", 24)
    W_692 = Ward("Phường Ngọc Hà", 692, VietNamDivisionType.PHUONG, "phuong_ngoc_ha", 24)
    W_694 = Ward("Phường Nguyễn Trãi", 694, VietNamDivisionType.PHUONG, "phuong_nguyen_trai", 24)
    W_697 = Ward("Phường Minh Khai", 697, VietNamDivisionType.PHUONG, "phuong_minh_khai", 24)
    W_700 = Ward("Xã Ngọc Đường", 700, VietNamDivisionType.XA, "xa_ngoc_duong", 24)
    W_946 = Ward("Xã Phương Độ", 946, VietNamDivisionType.XA, "xa_phuong_do", 24)
    W_949 = Ward("Xã Phương Thiện", 949, VietNamDivisionType.XA, "xa_phuong_thien", 24)
    W_712 = Ward("Thị trấn Phó Bảng", 712, VietNamDivisionType.THI_TRAN, "thi_tran_pho_bang", 26)
    W_715 = Ward("Xã Lũng Cú", 715, VietNamDivisionType.XA, "xa_lung_cu", 26)
    W_718 = Ward("Xã Má Lé", 718, VietNamDivisionType.XA, "xa_ma_le", 26)
    W_721 = Ward("Thị trấn Đồng Văn", 721, VietNamDivisionType.THI_TRAN, "thi_tran_dong_van", 26)
    W_724 = Ward("Xã Lũng Táo", 724, VietNamDivisionType.XA, "xa_lung_tao", 26)
    W_727 = Ward("Xã Phố Là", 727, VietNamDivisionType.XA, "xa_pho_la", 26)
    W_730 = Ward("Xã Thài Phìn Tủng", 730, VietNamDivisionType.XA, "xa_thai_phin_tung", 26)
    W_733 = Ward("Xã Sủng Là", 733, VietNamDivisionType.XA, "xa_sung_la", 26)
    W_736 = Ward("Xã Xà Phìn", 736, VietNamDivisionType.XA, "xa_xa_phin", 26)
    W_739 = Ward("Xã Tả Phìn", 739, VietNamDivisionType.XA, "xa_ta_phin", 26)
    W_742 = Ward("Xã Tả Lủng", 742, VietNamDivisionType.XA, "xa_ta_lung", 26)
    W_745 = Ward("Xã Phố Cáo", 745, VietNamDivisionType.XA, "xa_pho_cao", 26)
    W_748 = Ward("Xã Sính Lủng", 748, VietNamDivisionType.XA, "xa_sinh_lung", 26)
    W_751 = Ward("Xã Sảng Tủng", 751, VietNamDivisionType.XA, "xa_sang_tung", 26)
    W_754 = Ward("Xã Lũng Thầu", 754, VietNamDivisionType.XA, "xa_lung_thau", 26)
    W_757 = Ward("Xã Hố Quáng Phìn", 757, VietNamDivisionType.XA, "xa_ho_quang_phin", 26)
    W_760 = Ward("Xã Vần Chải", 760, VietNamDivisionType.XA, "xa_van_chai", 26)
    W_763 = Ward("Xã Lũng Phìn", 763, VietNamDivisionType.XA, "xa_lung_phin", 26)
    W_766 = Ward("Xã Sủng Trái", 766, VietNamDivisionType.XA, "xa_sung_trai", 26)
    W_769 = Ward("Thị trấn Mèo Vạc", 769, VietNamDivisionType.THI_TRAN, "thi_tran_meo_vac", 27)
    W_772 = Ward("Xã Thượng Phùng", 772, VietNamDivisionType.XA, "xa_thuong_phung", 27)
    W_775 = Ward("Xã Pải Lủng", 775, VietNamDivisionType.XA, "xa_pai_lung", 27)
    W_778 = Ward("Xã Xín Cái", 778, VietNamDivisionType.XA, "xa_xin_cai", 27)
    W_781 = Ward("Xã Pả Vi", 781, VietNamDivisionType.XA, "xa_pa_vi", 27)
    W_784 = Ward("Xã Giàng Chu Phìn", 784, VietNamDivisionType.XA, "xa_giang_chu_phin", 27)
    W_787 = Ward("Xã Sủng Trà", 787, VietNamDivisionType.XA, "xa_sung_tra", 27)
    W_790 = Ward("Xã Sủng Máng", 790, VietNamDivisionType.XA, "xa_sung_mang", 27)
    W_793 = Ward("Xã Sơn Vĩ", 793, VietNamDivisionType.XA, "xa_son_vi", 27)
    W_796 = Ward("Xã Tả Lủng", 796, VietNamDivisionType.XA, "xa_ta_lung", 27)
    W_799 = Ward("Xã Cán Chu Phìn", 799, VietNamDivisionType.XA, "xa_can_chu_phin", 27)
    W_802 = Ward("Xã Lũng Pù", 802, VietNamDivisionType.XA, "xa_lung_pu", 27)
    W_805 = Ward("Xã Lũng Chinh", 805, VietNamDivisionType.XA, "xa_lung_chinh", 27)
    W_808 = Ward("Xã Tát Ngà", 808, VietNamDivisionType.XA, "xa_tat_nga", 27)
    W_811 = Ward("Xã Nậm Ban", 811, VietNamDivisionType.XA, "xa_nam_ban", 27)
    W_814 = Ward("Xã Khâu Vai", 814, VietNamDivisionType.XA, "xa_khau_vai", 27)
    W_815 = Ward("Xã Niêm Tòng", 815, VietNamDivisionType.XA, "xa_niem_tong", 27)
    W_817 = Ward("Xã Niêm Sơn", 817, VietNamDivisionType.XA, "xa_niem_son", 27)
    W_820 = Ward("Thị trấn Yên Minh", 820, VietNamDivisionType.THI_TRAN, "thi_tran_yen_minh", 28)
    W_823 = Ward("Xã Thắng Mố", 823, VietNamDivisionType.XA, "xa_thang_mo", 28)
    W_826 = Ward("Xã Phú Lũng", 826, VietNamDivisionType.XA, "xa_phu_lung", 28)
    W_829 = Ward("Xã Sủng Tráng", 829, VietNamDivisionType.XA, "xa_sung_trang", 28)
    W_832 = Ward("Xã Bạch Đích", 832, VietNamDivisionType.XA, "xa_bach_dich", 28)
    W_835 = Ward("Xã Na Khê", 835, VietNamDivisionType.XA, "xa_na_khe", 28)
    W_838 = Ward("Xã Sủng Thài", 838, VietNamDivisionType.XA, "xa_sung_thai", 28)
    W_841 = Ward("Xã Hữu Vinh", 841, VietNamDivisionType.XA, "xa_huu_vinh", 28)
    W_844 = Ward("Xã Lao Và Chải", 844, VietNamDivisionType.XA, "xa_lao_va_chai", 28)
    W_847 = Ward("Xã Mậu Duệ", 847, VietNamDivisionType.XA, "xa_mau_due", 28)
    W_850 = Ward("Xã Đông Minh", 850, VietNamDivisionType.XA, "xa_dong_minh", 28)
    W_853 = Ward("Xã Mậu Long", 853, VietNamDivisionType.XA, "xa_mau_long", 28)
    W_856 = Ward("Xã Ngam La", 856, VietNamDivisionType.XA, "xa_ngam_la", 28)
    W_859 = Ward("Xã Ngọc Long", 859, VietNamDivisionType.XA, "xa_ngoc_long", 28)
    W_862 = Ward("Xã Đường Thượng", 862, VietNamDivisionType.XA, "xa_duong_thuong", 28)
    W_865 = Ward("Xã Lũng Hồ", 865, VietNamDivisionType.XA, "xa_lung_ho", 28)
    W_868 = Ward("Xã Du Tiến", 868, VietNamDivisionType.XA, "xa_du_tien", 28)
    W_871 = Ward("Xã Du Già", 871, VietNamDivisionType.XA, "xa_du_gia", 28)
    W_874 = Ward("Thị trấn Tam Sơn", 874, VietNamDivisionType.THI_TRAN, "thi_tran_tam_son", 29)
    W_877 = Ward("Xã Bát Đại Sơn", 877, VietNamDivisionType.XA, "xa_bat_dai_son", 29)
    W_880 = Ward("Xã Nghĩa Thuận", 880, VietNamDivisionType.XA, "xa_nghia_thuan", 29)
    W_883 = Ward("Xã Cán Tỷ", 883, VietNamDivisionType.XA, "xa_can_ty", 29)
    W_886 = Ward("Xã Cao Mã Pờ", 886, VietNamDivisionType.XA, "xa_cao_ma_po", 29)
    W_889 = Ward("Xã Thanh Vân", 889, VietNamDivisionType.XA, "xa_thanh_van", 29)
    W_892 = Ward("Xã Tùng Vài", 892, VietNamDivisionType.XA, "xa_tung_vai", 29)
    W_895 = Ward("Xã Đông Hà", 895, VietNamDivisionType.XA, "xa_dong_ha", 29)
    W_898 = Ward("Xã Quản Bạ", 898, VietNamDivisionType.XA, "xa_quan_ba", 29)
    W_901 = Ward("Xã Lùng Tám", 901, VietNamDivisionType.XA, "xa_lung_tam", 29)
    W_904 = Ward("Xã Quyết Tiến", 904, VietNamDivisionType.XA, "xa_quyet_tien", 29)
    W_907 = Ward("Xã Tả Ván", 907, VietNamDivisionType.XA, "xa_ta_van", 29)
    W_910 = Ward("Xã Thái An", 910, VietNamDivisionType.XA, "xa_thai_an", 29)
    W_703 = Ward("Xã Kim Thạch", 703, VietNamDivisionType.XA, "xa_kim_thach", 30)
    W_706 = Ward("Xã Phú Linh", 706, VietNamDivisionType.XA, "xa_phu_linh", 30)
    W_709 = Ward("Xã Kim Linh", 709, VietNamDivisionType.XA, "xa_kim_linh", 30)
    W_913 = Ward("Thị trấn Vị Xuyên", 913, VietNamDivisionType.THI_TRAN, "thi_tran_vi_xuyen", 30)
    W_916 = Ward(
        "Thị trấn Nông Trường Việt Lâm", 916, VietNamDivisionType.THI_TRAN, "thi_tran_nong_truong_viet_lam", 30
    )
    W_919 = Ward("Xã Minh Tân", 919, VietNamDivisionType.XA, "xa_minh_tan", 30)
    W_922 = Ward("Xã Thuận Hoà", 922, VietNamDivisionType.XA, "xa_thuan_hoa", 30)
    W_925 = Ward("Xã Tùng Bá", 925, VietNamDivisionType.XA, "xa_tung_ba", 30)
    W_928 = Ward("Xã Thanh Thủy", 928, VietNamDivisionType.XA, "xa_thanh_thuy", 30)
    W_931 = Ward("Xã Thanh Đức", 931, VietNamDivisionType.XA, "xa_thanh_duc", 30)
    W_934 = Ward("Xã Phong Quang", 934, VietNamDivisionType.XA, "xa_phong_quang", 30)
    W_937 = Ward("Xã Xín Chải", 937, VietNamDivisionType.XA, "xa_xin_chai", 30)
    W_940 = Ward("Xã Phương Tiến", 940, VietNamDivisionType.XA, "xa_phuong_tien", 30)
    W_943 = Ward("Xã Lao Chải", 943, VietNamDivisionType.XA, "xa_lao_chai", 30)
    W_952 = Ward("Xã Cao Bồ", 952, VietNamDivisionType.XA, "xa_cao_bo", 30)
    W_955 = Ward("Xã Đạo Đức", 955, VietNamDivisionType.XA, "xa_dao_duc", 30)
    W_958 = Ward("Xã Thượng Sơn", 958, VietNamDivisionType.XA, "xa_thuong_son", 30)
    W_961 = Ward("Xã Linh Hồ", 961, VietNamDivisionType.XA, "xa_linh_ho", 30)
    W_964 = Ward("Xã Quảng Ngần", 964, VietNamDivisionType.XA, "xa_quang_ngan", 30)
    W_967 = Ward("Xã Việt Lâm", 967, VietNamDivisionType.XA, "xa_viet_lam", 30)
    W_970 = Ward("Xã Ngọc Linh", 970, VietNamDivisionType.XA, "xa_ngoc_linh", 30)
    W_973 = Ward("Xã Ngọc Minh", 973, VietNamDivisionType.XA, "xa_ngoc_minh", 30)
    W_976 = Ward("Xã Bạch Ngọc", 976, VietNamDivisionType.XA, "xa_bach_ngoc", 30)
    W_979 = Ward("Xã Trung Thành", 979, VietNamDivisionType.XA, "xa_trung_thanh", 30)
    W_982 = Ward("Xã Minh Sơn", 982, VietNamDivisionType.XA, "xa_minh_son", 31)
    W_985 = Ward("Xã Giáp Trung", 985, VietNamDivisionType.XA, "xa_giap_trung", 31)
    W_988 = Ward("Xã Yên Định", 988, VietNamDivisionType.XA, "xa_yen_dinh", 31)
    W_991 = Ward("Thị trấn Yên Phú", 991, VietNamDivisionType.THI_TRAN, "thi_tran_yen_phu", 31)
    W_994 = Ward("Xã Minh Ngọc", 994, VietNamDivisionType.XA, "xa_minh_ngoc", 31)
    W_997 = Ward("Xã Yên Phong", 997, VietNamDivisionType.XA, "xa_yen_phong", 31)
    W_1000 = Ward("Xã Lạc Nông", 1000, VietNamDivisionType.XA, "xa_lac_nong", 31)
    W_1003 = Ward("Xã Phú Nam", 1003, VietNamDivisionType.XA, "xa_phu_nam", 31)
    W_1006 = Ward("Xã Yên Cường", 1006, VietNamDivisionType.XA, "xa_yen_cuong", 31)
    W_1009 = Ward("Xã Thượng Tân", 1009, VietNamDivisionType.XA, "xa_thuong_tan", 31)
    W_1012 = Ward("Xã Đường Âm", 1012, VietNamDivisionType.XA, "xa_duong_am", 31)
    W_1015 = Ward("Xã Đường Hồng", 1015, VietNamDivisionType.XA, "xa_duong_hong", 31)
    W_1018 = Ward("Xã Phiêng Luông", 1018, VietNamDivisionType.XA, "xa_phieng_luong", 31)
    W_1021 = Ward("Thị trấn Vinh Quang", 1021, VietNamDivisionType.THI_TRAN, "thi_tran_vinh_quang", 32)
    W_1024 = Ward("Xã Bản Máy", 1024, VietNamDivisionType.XA, "xa_ban_may", 32)
    W_1027 = Ward("Xã Thàng Tín", 1027, VietNamDivisionType.XA, "xa_thang_tin", 32)
    W_1030 = Ward("Xã Thèn Chu Phìn", 1030, VietNamDivisionType.XA, "xa_then_chu_phin", 32)
    W_1033 = Ward("Xã Pố Lồ", 1033, VietNamDivisionType.XA, "xa_po_lo", 32)
    W_1036 = Ward("Xã Bản Phùng", 1036, VietNamDivisionType.XA, "xa_ban_phung", 32)
    W_1039 = Ward("Xã Túng Sán", 1039, VietNamDivisionType.XA, "xa_tung_san", 32)
    W_1042 = Ward("Xã Chiến Phố", 1042, VietNamDivisionType.XA, "xa_chien_pho", 32)
    W_1045 = Ward("Xã Đản Ván", 1045, VietNamDivisionType.XA, "xa_dan_van", 32)
    W_1048 = Ward("Xã Tụ Nhân", 1048, VietNamDivisionType.XA, "xa_tu_nhan", 32)
    W_1051 = Ward("Xã Tân Tiến", 1051, VietNamDivisionType.XA, "xa_tan_tien", 32)
    W_1054 = Ward("Xã Nàng Đôn", 1054, VietNamDivisionType.XA, "xa_nang_don", 32)
    W_1057 = Ward("Xã Pờ Ly Ngài", 1057, VietNamDivisionType.XA, "xa_po_ly_ngai", 32)
    W_1060 = Ward("Xã Sán Xả Hồ", 1060, VietNamDivisionType.XA, "xa_san_xa_ho", 32)
    W_1063 = Ward("Xã Bản Luốc", 1063, VietNamDivisionType.XA, "xa_ban_luoc", 32)
    W_1066 = Ward("Xã Ngàm Đăng Vài", 1066, VietNamDivisionType.XA, "xa_ngam_dang_vai", 32)
    W_1069 = Ward("Xã Bản Nhùng", 1069, VietNamDivisionType.XA, "xa_ban_nhung", 32)
    W_1072 = Ward("Xã Tả Sử Choóng", 1072, VietNamDivisionType.XA, "xa_ta_su_choong", 32)
    W_1075 = Ward("Xã Nậm Dịch", 1075, VietNamDivisionType.XA, "xa_nam_dich", 32)
    W_1081 = Ward("Xã Hồ Thầu", 1081, VietNamDivisionType.XA, "xa_ho_thau", 32)
    W_1084 = Ward("Xã Nam Sơn", 1084, VietNamDivisionType.XA, "xa_nam_son", 32)
    W_1087 = Ward("Xã Nậm Tỵ", 1087, VietNamDivisionType.XA, "xa_nam_ty", 32)
    W_1090 = Ward("Xã Thông Nguyên", 1090, VietNamDivisionType.XA, "xa_thong_nguyen", 32)
    W_1093 = Ward("Xã Nậm Khòa", 1093, VietNamDivisionType.XA, "xa_nam_khoa", 32)
    W_1096 = Ward("Thị trấn Cốc Pài", 1096, VietNamDivisionType.THI_TRAN, "thi_tran_coc_pai", 33)
    W_1099 = Ward("Xã Nàn Xỉn", 1099, VietNamDivisionType.XA, "xa_nan_xin", 33)
    W_1102 = Ward("Xã Bản Díu", 1102, VietNamDivisionType.XA, "xa_ban_diu", 33)
    W_1105 = Ward("Xã Chí Cà", 1105, VietNamDivisionType.XA, "xa_chi_ca", 33)
    W_1108 = Ward("Xã Xín Mần", 1108, VietNamDivisionType.XA, "xa_xin_man", 33)
    W_1114 = Ward("Xã Thèn Phàng", 1114, VietNamDivisionType.XA, "xa_then_phang", 33)
    W_1117 = Ward("Xã Trung Thịnh", 1117, VietNamDivisionType.XA, "xa_trung_thinh", 33)
    W_1120 = Ward("Xã Pà Vầy Sủ", 1120, VietNamDivisionType.XA, "xa_pa_vay_su", 33)
    W_1123 = Ward("Xã Cốc Rế", 1123, VietNamDivisionType.XA, "xa_coc_re", 33)
    W_1126 = Ward("Xã Thu Tà", 1126, VietNamDivisionType.XA, "xa_thu_ta", 33)
    W_1129 = Ward("Xã Nàn Ma", 1129, VietNamDivisionType.XA, "xa_nan_ma", 33)
    W_1132 = Ward("Xã Tả Nhìu", 1132, VietNamDivisionType.XA, "xa_ta_nhiu", 33)
    W_1135 = Ward("Xã Bản Ngò", 1135, VietNamDivisionType.XA, "xa_ban_ngo", 33)
    W_1138 = Ward("Xã Chế Là", 1138, VietNamDivisionType.XA, "xa_che_la", 33)
    W_1141 = Ward("Xã Nấm Dẩn", 1141, VietNamDivisionType.XA, "xa_nam_dan", 33)
    W_1144 = Ward("Xã Quảng Nguyên", 1144, VietNamDivisionType.XA, "xa_quang_nguyen", 33)
    W_1147 = Ward("Xã Nà Chì", 1147, VietNamDivisionType.XA, "xa_na_chi", 33)
    W_1150 = Ward("Xã Khuôn Lùng", 1150, VietNamDivisionType.XA, "xa_khuon_lung", 33)
    W_1153 = Ward("Thị trấn Việt Quang", 1153, VietNamDivisionType.THI_TRAN, "thi_tran_viet_quang", 34)
    W_1156 = Ward("Thị trấn Vĩnh Tuy", 1156, VietNamDivisionType.THI_TRAN, "thi_tran_vinh_tuy", 34)
    W_1159 = Ward("Xã Tân Lập", 1159, VietNamDivisionType.XA, "xa_tan_lap", 34)
    W_1162 = Ward("Xã Tân Thành", 1162, VietNamDivisionType.XA, "xa_tan_thanh", 34)
    W_1165 = Ward("Xã Đồng Tiến", 1165, VietNamDivisionType.XA, "xa_dong_tien", 34)
    W_1168 = Ward("Xã Đồng Tâm", 1168, VietNamDivisionType.XA, "xa_dong_tam", 34)
    W_1171 = Ward("Xã Tân Quang", 1171, VietNamDivisionType.XA, "xa_tan_quang", 34)
    W_1174 = Ward("Xã Thượng Bình", 1174, VietNamDivisionType.XA, "xa_thuong_binh", 34)
    W_1177 = Ward("Xã Hữu Sản", 1177, VietNamDivisionType.XA, "xa_huu_san", 34)
    W_1180 = Ward("Xã Kim Ngọc", 1180, VietNamDivisionType.XA, "xa_kim_ngoc", 34)
    W_1183 = Ward("Xã Việt Vinh", 1183, VietNamDivisionType.XA, "xa_viet_vinh", 34)
    W_1186 = Ward("Xã Bằng Hành", 1186, VietNamDivisionType.XA, "xa_bang_hanh", 34)
    W_1189 = Ward("Xã Quang Minh", 1189, VietNamDivisionType.XA, "xa_quang_minh", 34)
    W_1192 = Ward("Xã Liên Hiệp", 1192, VietNamDivisionType.XA, "xa_lien_hiep", 34)
    W_1195 = Ward("Xã Vô Điếm", 1195, VietNamDivisionType.XA, "xa_vo_diem", 34)
    W_1198 = Ward("Xã Việt Hồng", 1198, VietNamDivisionType.XA, "xa_viet_hong", 34)
    W_1201 = Ward("Xã Hùng An", 1201, VietNamDivisionType.XA, "xa_hung_an", 34)
    W_1204 = Ward("Xã Đức Xuân", 1204, VietNamDivisionType.XA, "xa_duc_xuan", 34)
    W_1207 = Ward("Xã Tiên Kiều", 1207, VietNamDivisionType.XA, "xa_tien_kieu", 34)
    W_1210 = Ward("Xã Vĩnh Hảo", 1210, VietNamDivisionType.XA, "xa_vinh_hao", 34)
    W_1213 = Ward("Xã Vĩnh Phúc", 1213, VietNamDivisionType.XA, "xa_vinh_phuc", 34)
    W_1216 = Ward("Xã Đồng Yên", 1216, VietNamDivisionType.XA, "xa_dong_yen", 34)
    W_1219 = Ward("Xã Đông Thành", 1219, VietNamDivisionType.XA, "xa_dong_thanh", 34)
    W_1222 = Ward("Xã Xuân Minh", 1222, VietNamDivisionType.XA, "xa_xuan_minh", 35)
    W_1225 = Ward("Xã Tiên Nguyên", 1225, VietNamDivisionType.XA, "xa_tien_nguyen", 35)
    W_1228 = Ward("Xã Tân Nam", 1228, VietNamDivisionType.XA, "xa_tan_nam", 35)
    W_1231 = Ward("Xã Bản Rịa", 1231, VietNamDivisionType.XA, "xa_ban_ria", 35)
    W_1234 = Ward("Xã Yên Thành", 1234, VietNamDivisionType.XA, "xa_yen_thanh", 35)
    W_1237 = Ward("Thị trấn Yên Bình", 1237, VietNamDivisionType.THI_TRAN, "thi_tran_yen_binh", 35)
    W_1240 = Ward("Xã Tân Trịnh", 1240, VietNamDivisionType.XA, "xa_tan_trinh", 35)
    W_1243 = Ward("Xã Tân Bắc", 1243, VietNamDivisionType.XA, "xa_tan_bac", 35)
    W_1246 = Ward("Xã Bằng Lang", 1246, VietNamDivisionType.XA, "xa_bang_lang", 35)
    W_1249 = Ward("Xã Yên Hà", 1249, VietNamDivisionType.XA, "xa_yen_ha", 35)
    W_1252 = Ward("Xã Hương Sơn", 1252, VietNamDivisionType.XA, "xa_huong_son", 35)
    W_1255 = Ward("Xã Xuân Giang", 1255, VietNamDivisionType.XA, "xa_xuan_giang", 35)
    W_1258 = Ward("Xã Nà Khương", 1258, VietNamDivisionType.XA, "xa_na_khuong", 35)
    W_1261 = Ward("Xã Tiên Yên", 1261, VietNamDivisionType.XA, "xa_tien_yen", 35)
    W_1264 = Ward("Xã Vĩ Thượng", 1264, VietNamDivisionType.XA, "xa_vi_thuong", 35)
    W_1267 = Ward("Phường Sông Hiến", 1267, VietNamDivisionType.PHUONG, "phuong_song_hien", 40)
    W_1270 = Ward("Phường Sông Bằng", 1270, VietNamDivisionType.PHUONG, "phuong_song_bang", 40)
    W_1273 = Ward("Phường Hợp Giang", 1273, VietNamDivisionType.PHUONG, "phuong_hop_giang", 40)
    W_1276 = Ward("Phường Tân Giang", 1276, VietNamDivisionType.PHUONG, "phuong_tan_giang", 40)
    W_1279 = Ward("Phường Ngọc Xuân", 1279, VietNamDivisionType.PHUONG, "phuong_ngoc_xuan", 40)
    W_1282 = Ward("Phường Đề Thám", 1282, VietNamDivisionType.PHUONG, "phuong_de_tham", 40)
    W_1285 = Ward("Phường Hoà Chung", 1285, VietNamDivisionType.PHUONG, "phuong_hoa_chung", 40)
    W_1288 = Ward("Phường Duyệt Trung", 1288, VietNamDivisionType.PHUONG, "phuong_duyet_trung", 40)
    W_1693 = Ward("Xã Vĩnh Quang", 1693, VietNamDivisionType.XA, "xa_vinh_quang", 40)
    W_1705 = Ward("Xã Hưng Đạo", 1705, VietNamDivisionType.XA, "xa_hung_dao", 40)
    W_1720 = Ward("Xã Chu Trinh", 1720, VietNamDivisionType.XA, "xa_chu_trinh", 40)
    W_1290 = Ward("Thị trấn Pác Miầu", 1290, VietNamDivisionType.THI_TRAN, "thi_tran_pac_miau", 42)
    W_1291 = Ward("Xã Đức Hạnh", 1291, VietNamDivisionType.XA, "xa_duc_hanh", 42)
    W_1294 = Ward("Xã Lý Bôn", 1294, VietNamDivisionType.XA, "xa_ly_bon", 42)
    W_1296 = Ward("Xã Nam Cao", 1296, VietNamDivisionType.XA, "xa_nam_cao", 42)
    W_1297 = Ward("Xã Nam Quang", 1297, VietNamDivisionType.XA, "xa_nam_quang", 42)
    W_1300 = Ward("Xã Vĩnh Quang", 1300, VietNamDivisionType.XA, "xa_vinh_quang", 42)
    W_1303 = Ward("Xã Quảng Lâm", 1303, VietNamDivisionType.XA, "xa_quang_lam", 42)
    W_1304 = Ward("Xã Thạch Lâm", 1304, VietNamDivisionType.XA, "xa_thach_lam", 42)
    W_1309 = Ward("Xã Vĩnh Phong", 1309, VietNamDivisionType.XA, "xa_vinh_phong", 42)
    W_1312 = Ward("Xã Mông Ân", 1312, VietNamDivisionType.XA, "xa_mong_an", 42)
    W_1315 = Ward("Xã Thái Học", 1315, VietNamDivisionType.XA, "xa_thai_hoc", 42)
    W_1316 = Ward("Xã Thái Sơn", 1316, VietNamDivisionType.XA, "xa_thai_son", 42)
    W_1318 = Ward("Xã Yên Thổ", 1318, VietNamDivisionType.XA, "xa_yen_tho", 42)
    W_1321 = Ward("Thị trấn Bảo Lạc", 1321, VietNamDivisionType.THI_TRAN, "thi_tran_bao_lac", 43)
    W_1324 = Ward("Xã Cốc Pàng", 1324, VietNamDivisionType.XA, "xa_coc_pang", 43)
    W_1327 = Ward("Xã Thượng Hà", 1327, VietNamDivisionType.XA, "xa_thuong_ha", 43)
    W_1330 = Ward("Xã Cô Ba", 1330, VietNamDivisionType.XA, "xa_co_ba", 43)
    W_1333 = Ward("Xã Bảo Toàn", 1333, VietNamDivisionType.XA, "xa_bao_toan", 43)
    W_1336 = Ward("Xã Khánh Xuân", 1336, VietNamDivisionType.XA, "xa_khanh_xuan", 43)
    W_1339 = Ward("Xã Xuân Trường", 1339, VietNamDivisionType.XA, "xa_xuan_truong", 43)
    W_1342 = Ward("Xã Hồng Trị", 1342, VietNamDivisionType.XA, "xa_hong_tri", 43)
    W_1343 = Ward("Xã Kim Cúc", 1343, VietNamDivisionType.XA, "xa_kim_cuc", 43)
    W_1345 = Ward("Xã Phan Thanh", 1345, VietNamDivisionType.XA, "xa_phan_thanh", 43)
    W_1348 = Ward("Xã Hồng An", 1348, VietNamDivisionType.XA, "xa_hong_an", 43)
    W_1351 = Ward("Xã Hưng Đạo", 1351, VietNamDivisionType.XA, "xa_hung_dao", 43)
    W_1352 = Ward("Xã Hưng Thịnh", 1352, VietNamDivisionType.XA, "xa_hung_thinh", 43)
    W_1354 = Ward("Xã Huy Giáp", 1354, VietNamDivisionType.XA, "xa_huy_giap", 43)
    W_1357 = Ward("Xã Đình Phùng", 1357, VietNamDivisionType.XA, "xa_dinh_phung", 43)
    W_1359 = Ward("Xã Sơn Lập", 1359, VietNamDivisionType.XA, "xa_son_lap", 43)
    W_1360 = Ward("Xã Sơn Lộ", 1360, VietNamDivisionType.XA, "xa_son_lo", 43)
    W_1363 = Ward("Thị trấn Thông Nông", 1363, VietNamDivisionType.THI_TRAN, "thi_tran_thong_nong", 45)
    W_1366 = Ward("Xã Cần Yên", 1366, VietNamDivisionType.XA, "xa_can_yen", 45)
    W_1367 = Ward("Xã Cần Nông", 1367, VietNamDivisionType.XA, "xa_can_nong", 45)
    W_1372 = Ward("Xã Lương Thông", 1372, VietNamDivisionType.XA, "xa_luong_thong", 45)
    W_1375 = Ward("Xã Đa Thông", 1375, VietNamDivisionType.XA, "xa_da_thong", 45)
    W_1378 = Ward("Xã Ngọc Động", 1378, VietNamDivisionType.XA, "xa_ngoc_dong", 45)
    W_1381 = Ward("Xã Yên Sơn", 1381, VietNamDivisionType.XA, "xa_yen_son", 45)
    W_1384 = Ward("Xã Lương Can", 1384, VietNamDivisionType.XA, "xa_luong_can", 45)
    W_1387 = Ward("Xã Thanh Long", 1387, VietNamDivisionType.XA, "xa_thanh_long", 45)
    W_1392 = Ward("Thị trấn Xuân Hòa", 1392, VietNamDivisionType.THI_TRAN, "thi_tran_xuan_hoa", 45)
    W_1393 = Ward("Xã Lũng Nặm", 1393, VietNamDivisionType.XA, "xa_lung_nam", 45)
    W_1399 = Ward("Xã Trường Hà", 1399, VietNamDivisionType.XA, "xa_truong_ha", 45)
    W_1402 = Ward("Xã Cải Viên", 1402, VietNamDivisionType.XA, "xa_cai_vien", 45)
    W_1411 = Ward("Xã Nội Thôn", 1411, VietNamDivisionType.XA, "xa_noi_thon", 45)
    W_1414 = Ward("Xã Tổng Cọt", 1414, VietNamDivisionType.XA, "xa_tong_cot", 45)
    W_1417 = Ward("Xã Sóc Hà", 1417, VietNamDivisionType.XA, "xa_soc_ha", 45)
    W_1420 = Ward("Xã Thượng Thôn", 1420, VietNamDivisionType.XA, "xa_thuong_thon", 45)
    W_1429 = Ward("Xã Hồng Sỹ", 1429, VietNamDivisionType.XA, "xa_hong_sy", 45)
    W_1432 = Ward("Xã Quý Quân", 1432, VietNamDivisionType.XA, "xa_quy_quan", 45)
    W_1435 = Ward("Xã Mã Ba", 1435, VietNamDivisionType.XA, "xa_ma_ba", 45)
    W_1438 = Ward("Xã Ngọc Đào", 1438, VietNamDivisionType.XA, "xa_ngoc_dao", 45)
    W_1447 = Ward("Thị trấn Trà Lĩnh", 1447, VietNamDivisionType.THI_TRAN, "thi_tran_tra_linh", 47)
    W_1453 = Ward("Xã Tri Phương", 1453, VietNamDivisionType.XA, "xa_tri_phuong", 47)
    W_1456 = Ward("Xã Quang Hán", 1456, VietNamDivisionType.XA, "xa_quang_han", 47)
    W_1462 = Ward("Xã Xuân Nội", 1462, VietNamDivisionType.XA, "xa_xuan_noi", 47)
    W_1465 = Ward("Xã Quang Trung", 1465, VietNamDivisionType.XA, "xa_quang_trung", 47)
    W_1468 = Ward("Xã Quang Vinh", 1468, VietNamDivisionType.XA, "xa_quang_vinh", 47)
    W_1471 = Ward("Xã Cao Chương", 1471, VietNamDivisionType.XA, "xa_cao_chuong", 47)
    W_1477 = Ward("Thị trấn Trùng Khánh", 1477, VietNamDivisionType.THI_TRAN, "thi_tran_trung_khanh", 47)
    W_1480 = Ward("Xã Ngọc Khê", 1480, VietNamDivisionType.XA, "xa_ngoc_khe", 47)
    W_1481 = Ward("Xã Ngọc Côn", 1481, VietNamDivisionType.XA, "xa_ngoc_con", 47)
    W_1483 = Ward("Xã Phong Nậm", 1483, VietNamDivisionType.XA, "xa_phong_nam", 47)
    W_1489 = Ward("Xã Đình Phong", 1489, VietNamDivisionType.XA, "xa_dinh_phong", 47)
    W_1495 = Ward("Xã Đàm Thuỷ", 1495, VietNamDivisionType.XA, "xa_dam_thuy", 47)
    W_1498 = Ward("Xã Khâm Thành", 1498, VietNamDivisionType.XA, "xa_kham_thanh", 47)
    W_1501 = Ward("Xã Chí Viễn", 1501, VietNamDivisionType.XA, "xa_chi_vien", 47)
    W_1504 = Ward("Xã Lăng Hiếu", 1504, VietNamDivisionType.XA, "xa_lang_hieu", 47)
    W_1507 = Ward("Xã Phong Châu", 1507, VietNamDivisionType.XA, "xa_phong_chau", 47)
    W_1516 = Ward("Xã Trung Phúc", 1516, VietNamDivisionType.XA, "xa_trung_phuc", 47)
    W_1519 = Ward("Xã Cao Thăng", 1519, VietNamDivisionType.XA, "xa_cao_thang", 47)
    W_1522 = Ward("Xã Đức Hồng", 1522, VietNamDivisionType.XA, "xa_duc_hong", 47)
    W_1525 = Ward("Xã Đoài Dương", 1525, VietNamDivisionType.XA, "xa_doai_duong", 47)
    W_1534 = Ward("Xã Minh Long", 1534, VietNamDivisionType.XA, "xa_minh_long", 48)
    W_1537 = Ward("Xã Lý Quốc", 1537, VietNamDivisionType.XA, "xa_ly_quoc", 48)
    W_1540 = Ward("Xã Thắng Lợi", 1540, VietNamDivisionType.XA, "xa_thang_loi", 48)
    W_1543 = Ward("Xã Đồng Loan", 1543, VietNamDivisionType.XA, "xa_dong_loan", 48)
    W_1546 = Ward("Xã Đức Quang", 1546, VietNamDivisionType.XA, "xa_duc_quang", 48)
    W_1549 = Ward("Xã Kim Loan", 1549, VietNamDivisionType.XA, "xa_kim_loan", 48)
    W_1552 = Ward("Xã Quang Long", 1552, VietNamDivisionType.XA, "xa_quang_long", 48)
    W_1555 = Ward("Xã An Lạc", 1555, VietNamDivisionType.XA, "xa_an_lac", 48)
    W_1558 = Ward("Thị trấn Thanh Nhật", 1558, VietNamDivisionType.THI_TRAN, "thi_tran_thanh_nhat", 48)
    W_1561 = Ward("Xã Vinh Quý", 1561, VietNamDivisionType.XA, "xa_vinh_quy", 48)
    W_1564 = Ward("Xã Thống Nhất", 1564, VietNamDivisionType.XA, "xa_thong_nhat", 48)
    W_1567 = Ward("Xã Cô Ngân", 1567, VietNamDivisionType.XA, "xa_co_ngan", 48)
    W_1573 = Ward("Xã Thị Hoa", 1573, VietNamDivisionType.XA, "xa_thi_hoa", 48)
    W_1474 = Ward("Xã Quốc Toản", 1474, VietNamDivisionType.XA, "xa_quoc_toan", 49)
    W_1576 = Ward("Thị trấn Quảng Uyên", 1576, VietNamDivisionType.THI_TRAN, "thi_tran_quang_uyen", 49)
    W_1579 = Ward("Xã Phi Hải", 1579, VietNamDivisionType.XA, "xa_phi_hai", 49)
    W_1582 = Ward("Xã Quảng Hưng", 1582, VietNamDivisionType.XA, "xa_quang_hung", 49)
    W_1594 = Ward("Xã Độc Lập", 1594, VietNamDivisionType.XA, "xa_doc_lap", 49)
    W_1597 = Ward("Xã Cai Bộ", 1597, VietNamDivisionType.XA, "xa_cai_bo", 49)
    W_1603 = Ward("Xã Phúc Sen", 1603, VietNamDivisionType.XA, "xa_phuc_sen", 49)
    W_1606 = Ward("Xã Chí Thảo", 1606, VietNamDivisionType.XA, "xa_chi_thao", 49)
    W_1609 = Ward("Xã Tự Do", 1609, VietNamDivisionType.XA, "xa_tu_do", 49)
    W_1615 = Ward("Xã Hồng Quang", 1615, VietNamDivisionType.XA, "xa_hong_quang", 49)
    W_1618 = Ward("Xã Ngọc Động", 1618, VietNamDivisionType.XA, "xa_ngoc_dong", 49)
    W_1624 = Ward("Xã Hạnh Phúc", 1624, VietNamDivisionType.XA, "xa_hanh_phuc", 49)
    W_1627 = Ward("Thị trấn Tà Lùng", 1627, VietNamDivisionType.THI_TRAN, "thi_tran_ta_lung", 49)
    W_1630 = Ward("Xã Bế Văn Đàn", 1630, VietNamDivisionType.XA, "xa_be_van_dan", 49)
    W_1636 = Ward("Xã Cách Linh", 1636, VietNamDivisionType.XA, "xa_cach_linh", 49)
    W_1639 = Ward("Xã Đại Sơn", 1639, VietNamDivisionType.XA, "xa_dai_son", 49)
    W_1645 = Ward("Xã Tiên Thành", 1645, VietNamDivisionType.XA, "xa_tien_thanh", 49)
    W_1648 = Ward("Thị trấn Hoà Thuận", 1648, VietNamDivisionType.THI_TRAN, "thi_tran_hoa_thuan", 49)
    W_1651 = Ward("Xã Mỹ Hưng", 1651, VietNamDivisionType.XA, "xa_my_hung", 49)
    W_1654 = Ward("Thị trấn Nước Hai", 1654, VietNamDivisionType.THI_TRAN, "thi_tran_nuoc_hai", 51)
    W_1657 = Ward("Xã Dân Chủ", 1657, VietNamDivisionType.XA, "xa_dan_chu", 51)
    W_1660 = Ward("Xã Nam Tuấn", 1660, VietNamDivisionType.XA, "xa_nam_tuan", 51)
    W_1666 = Ward("Xã Đại Tiến", 1666, VietNamDivisionType.XA, "xa_dai_tien", 51)
    W_1669 = Ward("Xã Đức Long", 1669, VietNamDivisionType.XA, "xa_duc_long", 51)
    W_1672 = Ward("Xã Ngũ Lão", 1672, VietNamDivisionType.XA, "xa_ngu_lao", 51)
    W_1675 = Ward("Xã Trương Lương", 1675, VietNamDivisionType.XA, "xa_truong_luong", 51)
    W_1687 = Ward("Xã Hồng Việt", 1687, VietNamDivisionType.XA, "xa_hong_viet", 51)
    W_1696 = Ward("Xã Hoàng Tung", 1696, VietNamDivisionType.XA, "xa_hoang_tung", 51)
    W_1699 = Ward("Xã Nguyễn Huệ", 1699, VietNamDivisionType.XA, "xa_nguyen_hue", 51)
    W_1702 = Ward("Xã Quang Trung", 1702, VietNamDivisionType.XA, "xa_quang_trung", 51)
    W_1708 = Ward("Xã Bạch Đằng", 1708, VietNamDivisionType.XA, "xa_bach_dang", 51)
    W_1711 = Ward("Xã Bình Dương", 1711, VietNamDivisionType.XA, "xa_binh_duong", 51)
    W_1714 = Ward("Xã Lê Chung", 1714, VietNamDivisionType.XA, "xa_le_chung", 51)
    W_1723 = Ward("Xã Hồng Nam", 1723, VietNamDivisionType.XA, "xa_hong_nam", 51)
    W_1726 = Ward("Thị trấn Nguyên Bình", 1726, VietNamDivisionType.THI_TRAN, "thi_tran_nguyen_binh", 52)
    W_1729 = Ward("Thị trấn Tĩnh Túc", 1729, VietNamDivisionType.THI_TRAN, "thi_tran_tinh_tuc", 52)
    W_1732 = Ward("Xã Yên Lạc", 1732, VietNamDivisionType.XA, "xa_yen_lac", 52)
    W_1735 = Ward("Xã Triệu Nguyên", 1735, VietNamDivisionType.XA, "xa_trieu_nguyen", 52)
    W_1738 = Ward("Xã Ca Thành", 1738, VietNamDivisionType.XA, "xa_ca_thanh", 52)
    W_1744 = Ward("Xã Vũ Nông", 1744, VietNamDivisionType.XA, "xa_vu_nong", 52)
    W_1747 = Ward("Xã Minh Tâm", 1747, VietNamDivisionType.XA, "xa_minh_tam", 52)
    W_1750 = Ward("Xã Thể Dục", 1750, VietNamDivisionType.XA, "xa_the_duc", 52)
    W_1756 = Ward("Xã Mai Long", 1756, VietNamDivisionType.XA, "xa_mai_long", 52)
    W_1762 = Ward("Xã Vũ Minh", 1762, VietNamDivisionType.XA, "xa_vu_minh", 52)
    W_1765 = Ward("Xã Hoa Thám", 1765, VietNamDivisionType.XA, "xa_hoa_tham", 52)
    W_1768 = Ward("Xã Phan Thanh", 1768, VietNamDivisionType.XA, "xa_phan_thanh", 52)
    W_1771 = Ward("Xã Quang Thành", 1771, VietNamDivisionType.XA, "xa_quang_thanh", 52)
    W_1774 = Ward("Xã Tam Kim", 1774, VietNamDivisionType.XA, "xa_tam_kim", 52)
    W_1777 = Ward("Xã Thành Công", 1777, VietNamDivisionType.XA, "xa_thanh_cong", 52)
    W_1780 = Ward("Xã Thịnh Vượng", 1780, VietNamDivisionType.XA, "xa_thinh_vuong", 52)
    W_1783 = Ward("Xã Hưng Đạo", 1783, VietNamDivisionType.XA, "xa_hung_dao", 52)
    W_1786 = Ward("Thị trấn Đông Khê", 1786, VietNamDivisionType.THI_TRAN, "thi_tran_dong_khe", 53)
    W_1789 = Ward("Xã Canh Tân", 1789, VietNamDivisionType.XA, "xa_canh_tan", 53)
    W_1792 = Ward("Xã Kim Đồng", 1792, VietNamDivisionType.XA, "xa_kim_dong", 53)
    W_1795 = Ward("Xã Minh Khai", 1795, VietNamDivisionType.XA, "xa_minh_khai", 53)
    W_1801 = Ward("Xã Đức Thông", 1801, VietNamDivisionType.XA, "xa_duc_thong", 53)
    W_1804 = Ward("Xã Thái Cường", 1804, VietNamDivisionType.XA, "xa_thai_cuong", 53)
    W_1807 = Ward("Xã Vân Trình", 1807, VietNamDivisionType.XA, "xa_van_trinh", 53)
    W_1810 = Ward("Xã Thụy Hùng", 1810, VietNamDivisionType.XA, "xa_thuy_hung", 53)
    W_1813 = Ward("Xã Quang Trọng", 1813, VietNamDivisionType.XA, "xa_quang_trong", 53)
    W_1816 = Ward("Xã Trọng Con", 1816, VietNamDivisionType.XA, "xa_trong_con", 53)
    W_1819 = Ward("Xã Lê Lai", 1819, VietNamDivisionType.XA, "xa_le_lai", 53)
    W_1822 = Ward("Xã Đức Long", 1822, VietNamDivisionType.XA, "xa_duc_long", 53)
    W_1828 = Ward("Xã Lê Lợi", 1828, VietNamDivisionType.XA, "xa_le_loi", 53)
    W_1831 = Ward("Xã Đức Xuân", 1831, VietNamDivisionType.XA, "xa_duc_xuan", 53)
    W_1834 = Ward("Phường Nguyễn Thị Minh Khai", 1834, VietNamDivisionType.PHUONG, "phuong_nguyen_thi_minh_khai", 58)
    W_1837 = Ward("Phường Sông Cầu", 1837, VietNamDivisionType.PHUONG, "phuong_song_cau", 58)
    W_1840 = Ward("Phường Đức Xuân", 1840, VietNamDivisionType.PHUONG, "phuong_duc_xuan", 58)
    W_1843 = Ward("Phường Phùng Chí Kiên", 1843, VietNamDivisionType.PHUONG, "phuong_phung_chi_kien", 58)
    W_1846 = Ward("Phường Huyền Tụng", 1846, VietNamDivisionType.PHUONG, "phuong_huyen_tung", 58)
    W_1849 = Ward("Xã Dương Quang", 1849, VietNamDivisionType.XA, "xa_duong_quang", 58)
    W_1852 = Ward("Xã Nông Thượng", 1852, VietNamDivisionType.XA, "xa_nong_thuong", 58)
    W_1855 = Ward("Phường Xuất Hóa", 1855, VietNamDivisionType.PHUONG, "phuong_xuat_hoa", 58)
    W_1858 = Ward("Xã Bằng Thành", 1858, VietNamDivisionType.XA, "xa_bang_thanh", 60)
    W_1861 = Ward("Xã Nhạn Môn", 1861, VietNamDivisionType.XA, "xa_nhan_mon", 60)
    W_1864 = Ward("Xã Bộc Bố", 1864, VietNamDivisionType.XA, "xa_boc_bo", 60)
    W_1867 = Ward("Xã Công Bằng", 1867, VietNamDivisionType.XA, "xa_cong_bang", 60)
    W_1870 = Ward("Xã Giáo Hiệu", 1870, VietNamDivisionType.XA, "xa_giao_hieu", 60)
    W_1873 = Ward("Xã Xuân La", 1873, VietNamDivisionType.XA, "xa_xuan_la", 60)
    W_1876 = Ward("Xã An Thắng", 1876, VietNamDivisionType.XA, "xa_an_thang", 60)
    W_1879 = Ward("Xã Cổ Linh", 1879, VietNamDivisionType.XA, "xa_co_linh", 60)
    W_1882 = Ward("Xã Nghiên Loan", 1882, VietNamDivisionType.XA, "xa_nghien_loan", 60)
    W_1885 = Ward("Xã Cao Tân", 1885, VietNamDivisionType.XA, "xa_cao_tan", 60)
    W_1888 = Ward("Thị trấn Chợ Rã", 1888, VietNamDivisionType.THI_TRAN, "thi_tran_cho_ra", 61)
    W_1891 = Ward("Xã Bành Trạch", 1891, VietNamDivisionType.XA, "xa_banh_trach", 61)
    W_1894 = Ward("Xã Phúc Lộc", 1894, VietNamDivisionType.XA, "xa_phuc_loc", 61)
    W_1897 = Ward("Xã Hà Hiệu", 1897, VietNamDivisionType.XA, "xa_ha_hieu", 61)
    W_1900 = Ward("Xã Cao Thượng", 1900, VietNamDivisionType.XA, "xa_cao_thuong", 61)
    W_1906 = Ward("Xã Khang Ninh", 1906, VietNamDivisionType.XA, "xa_khang_ninh", 61)
    W_1909 = Ward("Xã Nam Mẫu", 1909, VietNamDivisionType.XA, "xa_nam_mau", 61)
    W_1912 = Ward("Xã Thượng Giáo", 1912, VietNamDivisionType.XA, "xa_thuong_giao", 61)
    W_1915 = Ward("Xã Địa Linh", 1915, VietNamDivisionType.XA, "xa_dia_linh", 61)
    W_1918 = Ward("Xã Yến Dương", 1918, VietNamDivisionType.XA, "xa_yen_duong", 61)
    W_1921 = Ward("Xã Chu Hương", 1921, VietNamDivisionType.XA, "xa_chu_huong", 61)
    W_1924 = Ward("Xã Quảng Khê", 1924, VietNamDivisionType.XA, "xa_quang_khe", 61)
    W_1927 = Ward("Xã Mỹ Phương", 1927, VietNamDivisionType.XA, "xa_my_phuong", 61)
    W_1930 = Ward("Xã Hoàng Trĩ", 1930, VietNamDivisionType.XA, "xa_hoang_tri", 61)
    W_1933 = Ward("Xã Đồng Phúc", 1933, VietNamDivisionType.XA, "xa_dong_phuc", 61)
    W_1936 = Ward("Thị trấn Nà Phặc", 1936, VietNamDivisionType.THI_TRAN, "thi_tran_na_phac", 62)
    W_1939 = Ward("Xã Thượng Ân", 1939, VietNamDivisionType.XA, "xa_thuong_an", 62)
    W_1942 = Ward("Xã Bằng Vân", 1942, VietNamDivisionType.XA, "xa_bang_van", 62)
    W_1945 = Ward("Xã Cốc Đán", 1945, VietNamDivisionType.XA, "xa_coc_dan", 62)
    W_1948 = Ward("Xã Trung Hoà", 1948, VietNamDivisionType.XA, "xa_trung_hoa", 62)
    W_1951 = Ward("Xã Đức Vân", 1951, VietNamDivisionType.XA, "xa_duc_van", 62)
    W_1954 = Ward("Xã Vân Tùng", 1954, VietNamDivisionType.XA, "xa_van_tung", 62)
    W_1957 = Ward("Xã Thượng Quan", 1957, VietNamDivisionType.XA, "xa_thuong_quan", 62)
    W_1960 = Ward("Xã Hiệp Lực", 1960, VietNamDivisionType.XA, "xa_hiep_luc", 62)
    W_1963 = Ward("Xã Thuần Mang", 1963, VietNamDivisionType.XA, "xa_thuan_mang", 62)
    W_1969 = Ward("Thị trấn Phủ Thông", 1969, VietNamDivisionType.THI_TRAN, "thi_tran_phu_thong", 63)
    W_1975 = Ward("Xã Vi Hương", 1975, VietNamDivisionType.XA, "xa_vi_huong", 63)
    W_1978 = Ward("Xã Sĩ Bình", 1978, VietNamDivisionType.XA, "xa_si_binh", 63)
    W_1981 = Ward("Xã Vũ Muộn", 1981, VietNamDivisionType.XA, "xa_vu_muon", 63)
    W_1984 = Ward("Xã Đôn Phong", 1984, VietNamDivisionType.XA, "xa_don_phong", 63)
    W_1990 = Ward("Xã Lục Bình", 1990, VietNamDivisionType.XA, "xa_luc_binh", 63)
    W_1993 = Ward("Xã Tân Tú", 1993, VietNamDivisionType.XA, "xa_tan_tu", 63)
    W_1999 = Ward("Xã Nguyên Phúc", 1999, VietNamDivisionType.XA, "xa_nguyen_phuc", 63)
    W_2002 = Ward("Xã Cao Sơn", 2002, VietNamDivisionType.XA, "xa_cao_son", 63)
    W_2005 = Ward("Xã Quân Hà", 2005, VietNamDivisionType.XA, "xa_quan_ha", 63)
    W_2008 = Ward("Xã Cẩm Giàng", 2008, VietNamDivisionType.XA, "xa_cam_giang", 63)
    W_2011 = Ward("Xã Mỹ Thanh", 2011, VietNamDivisionType.XA, "xa_my_thanh", 63)
    W_2014 = Ward("Xã Dương Phong", 2014, VietNamDivisionType.XA, "xa_duong_phong", 63)
    W_2017 = Ward("Xã Quang Thuận", 2017, VietNamDivisionType.XA, "xa_quang_thuan", 63)
    W_2020 = Ward("Thị trấn Bằng Lũng", 2020, VietNamDivisionType.THI_TRAN, "thi_tran_bang_lung", 64)
    W_2023 = Ward("Xã Xuân Lạc", 2023, VietNamDivisionType.XA, "xa_xuan_lac", 64)
    W_2026 = Ward("Xã Nam Cường", 2026, VietNamDivisionType.XA, "xa_nam_cuong", 64)
    W_2029 = Ward("Xã Đồng Lạc", 2029, VietNamDivisionType.XA, "xa_dong_lac", 64)
    W_2032 = Ward("Xã Tân Lập", 2032, VietNamDivisionType.XA, "xa_tan_lap", 64)
    W_2035 = Ward("Xã Bản Thi", 2035, VietNamDivisionType.XA, "xa_ban_thi", 64)
    W_2038 = Ward("Xã Quảng Bạch", 2038, VietNamDivisionType.XA, "xa_quang_bach", 64)
    W_2041 = Ward("Xã Bằng Phúc", 2041, VietNamDivisionType.XA, "xa_bang_phuc", 64)
    W_2044 = Ward("Xã Yên Thịnh", 2044, VietNamDivisionType.XA, "xa_yen_thinh", 64)
    W_2047 = Ward("Xã Yên Thượng", 2047, VietNamDivisionType.XA, "xa_yen_thuong", 64)
    W_2050 = Ward("Xã Phương Viên", 2050, VietNamDivisionType.XA, "xa_phuong_vien", 64)
    W_2053 = Ward("Xã Ngọc Phái", 2053, VietNamDivisionType.XA, "xa_ngoc_phai", 64)
    W_2059 = Ward("Xã Đồng Thắng", 2059, VietNamDivisionType.XA, "xa_dong_thang", 64)
    W_2062 = Ward("Xã Lương Bằng", 2062, VietNamDivisionType.XA, "xa_luong_bang", 64)
    W_2065 = Ward("Xã Bằng Lãng", 2065, VietNamDivisionType.XA, "xa_bang_lang", 64)
    W_2068 = Ward("Xã Đại Sảo", 2068, VietNamDivisionType.XA, "xa_dai_sao", 64)
    W_2071 = Ward("Xã Nghĩa Tá", 2071, VietNamDivisionType.XA, "xa_nghia_ta", 64)
    W_2077 = Ward("Xã Yên Mỹ", 2077, VietNamDivisionType.XA, "xa_yen_my", 64)
    W_2080 = Ward("Xã Bình Trung", 2080, VietNamDivisionType.XA, "xa_binh_trung", 64)
    W_2083 = Ward("Xã Yên Phong", 2083, VietNamDivisionType.XA, "xa_yen_phong", 64)
    W_2086 = Ward("Thị trấn Đồng Tâm", 2086, VietNamDivisionType.THI_TRAN, "thi_tran_dong_tam", 65)
    W_2089 = Ward("Xã Tân Sơn", 2089, VietNamDivisionType.XA, "xa_tan_son", 65)
    W_2092 = Ward("Xã Thanh Vận", 2092, VietNamDivisionType.XA, "xa_thanh_van", 65)
    W_2095 = Ward("Xã Mai Lạp", 2095, VietNamDivisionType.XA, "xa_mai_lap", 65)
    W_2098 = Ward("Xã Hoà Mục", 2098, VietNamDivisionType.XA, "xa_hoa_muc", 65)
    W_2101 = Ward("Xã Thanh Mai", 2101, VietNamDivisionType.XA, "xa_thanh_mai", 65)
    W_2104 = Ward("Xã Cao Kỳ", 2104, VietNamDivisionType.XA, "xa_cao_ky", 65)
    W_2107 = Ward("Xã Nông Hạ", 2107, VietNamDivisionType.XA, "xa_nong_ha", 65)
    W_2110 = Ward("Xã Yên Cư", 2110, VietNamDivisionType.XA, "xa_yen_cu", 65)
    W_2113 = Ward("Xã Thanh Thịnh", 2113, VietNamDivisionType.XA, "xa_thanh_thinh", 65)
    W_2116 = Ward("Xã Yên Hân", 2116, VietNamDivisionType.XA, "xa_yen_han", 65)
    W_2122 = Ward("Xã Như Cố", 2122, VietNamDivisionType.XA, "xa_nhu_co", 65)
    W_2125 = Ward("Xã Bình Văn", 2125, VietNamDivisionType.XA, "xa_binh_van", 65)
    W_2131 = Ward("Xã Quảng Chu", 2131, VietNamDivisionType.XA, "xa_quang_chu", 65)
    W_2137 = Ward("Xã Văn Vũ", 2137, VietNamDivisionType.XA, "xa_van_vu", 66)
    W_2140 = Ward("Xã Văn Lang", 2140, VietNamDivisionType.XA, "xa_van_lang", 66)
    W_2143 = Ward("Xã Lương Thượng", 2143, VietNamDivisionType.XA, "xa_luong_thuong", 66)
    W_2146 = Ward("Xã Kim Hỷ", 2146, VietNamDivisionType.XA, "xa_kim_hy", 66)
    W_2152 = Ward("Xã Cường Lợi", 2152, VietNamDivisionType.XA, "xa_cuong_loi", 66)
    W_2155 = Ward("Thị trấn Yến Lạc", 2155, VietNamDivisionType.THI_TRAN, "thi_tran_yen_lac", 66)
    W_2158 = Ward("Xã Kim Lư", 2158, VietNamDivisionType.XA, "xa_kim_lu", 66)
    W_2161 = Ward("Xã Sơn Thành", 2161, VietNamDivisionType.XA, "xa_son_thanh", 66)
    W_2170 = Ward("Xã Văn Minh", 2170, VietNamDivisionType.XA, "xa_van_minh", 66)
    W_2173 = Ward("Xã Côn Minh", 2173, VietNamDivisionType.XA, "xa_con_minh", 66)
    W_2176 = Ward("Xã Cư Lễ", 2176, VietNamDivisionType.XA, "xa_cu_le", 66)
    W_2179 = Ward("Xã Trần Phú", 2179, VietNamDivisionType.XA, "xa_tran_phu", 66)
    W_2185 = Ward("Xã Quang Phong", 2185, VietNamDivisionType.XA, "xa_quang_phong", 66)
    W_2188 = Ward("Xã Dương Sơn", 2188, VietNamDivisionType.XA, "xa_duong_son", 66)
    W_2191 = Ward("Xã Xuân Dương", 2191, VietNamDivisionType.XA, "xa_xuan_duong", 66)
    W_2194 = Ward("Xã Đổng Xá", 2194, VietNamDivisionType.XA, "xa_dong_xa", 66)
    W_2197 = Ward("Xã Liêm Thuỷ", 2197, VietNamDivisionType.XA, "xa_liem_thuy", 66)
    W_2200 = Ward("Phường Phan Thiết", 2200, VietNamDivisionType.PHUONG, "phuong_phan_thiet", 70)
    W_2203 = Ward("Phường Minh Xuân", 2203, VietNamDivisionType.PHUONG, "phuong_minh_xuan", 70)
    W_2206 = Ward("Phường Tân Quang", 2206, VietNamDivisionType.PHUONG, "phuong_tan_quang", 70)
    W_2209 = Ward("Xã Tràng Đà", 2209, VietNamDivisionType.XA, "xa_trang_da", 70)
    W_2212 = Ward("Phường Nông Tiến", 2212, VietNamDivisionType.PHUONG, "phuong_nong_tien", 70)
    W_2215 = Ward("Phường Ỷ La", 2215, VietNamDivisionType.PHUONG, "phuong_y_la", 70)
    W_2216 = Ward("Phường Tân Hà", 2216, VietNamDivisionType.PHUONG, "phuong_tan_ha", 70)
    W_2218 = Ward("Phường Hưng Thành", 2218, VietNamDivisionType.PHUONG, "phuong_hung_thanh", 70)
    W_2497 = Ward("Xã Kim Phú", 2497, VietNamDivisionType.XA, "xa_kim_phu", 70)
    W_2503 = Ward("Xã An Khang", 2503, VietNamDivisionType.XA, "xa_an_khang", 70)
    W_2509 = Ward("Phường Mỹ Lâm", 2509, VietNamDivisionType.PHUONG, "phuong_my_lam", 70)
    W_2512 = Ward("Phường An Tường", 2512, VietNamDivisionType.PHUONG, "phuong_an_tuong", 70)
    W_2515 = Ward("Xã Lưỡng Vượng", 2515, VietNamDivisionType.XA, "xa_luong_vuong", 70)
    W_2521 = Ward("Xã Thái Long", 2521, VietNamDivisionType.XA, "xa_thai_long", 70)
    W_2524 = Ward("Phường Đội Cấn", 2524, VietNamDivisionType.PHUONG, "phuong_doi_can", 70)
    W_2233 = Ward("Xã Phúc Yên", 2233, VietNamDivisionType.XA, "xa_phuc_yen", 71)
    W_2242 = Ward("Xã Xuân Lập", 2242, VietNamDivisionType.XA, "xa_xuan_lap", 71)
    W_2251 = Ward("Xã Khuôn Hà", 2251, VietNamDivisionType.XA, "xa_khuon_ha", 71)
    W_2266 = Ward("Xã Lăng Can", 2266, VietNamDivisionType.XA, "xa_lang_can", 71)
    W_2269 = Ward("Xã Thượng Lâm", 2269, VietNamDivisionType.XA, "xa_thuong_lam", 71)
    W_2290 = Ward("Xã Bình An", 2290, VietNamDivisionType.XA, "xa_binh_an", 71)
    W_2293 = Ward("Xã Hồng Quang", 2293, VietNamDivisionType.XA, "xa_hong_quang", 71)
    W_2296 = Ward("Xã Thổ Bình", 2296, VietNamDivisionType.XA, "xa_tho_binh", 71)
    W_2221 = Ward("Thị trấn Na Hang", 2221, VietNamDivisionType.THI_TRAN, "thi_tran_na_hang", 72)
    W_2227 = Ward("Xã Sinh Long", 2227, VietNamDivisionType.XA, "xa_sinh_long", 72)
    W_2230 = Ward("Xã Thượng Giáp", 2230, VietNamDivisionType.XA, "xa_thuong_giap", 72)
    W_2239 = Ward("Xã Thượng Nông", 2239, VietNamDivisionType.XA, "xa_thuong_nong", 72)
    W_2245 = Ward("Xã Côn Lôn", 2245, VietNamDivisionType.XA, "xa_con_lon", 72)
    W_2248 = Ward("Xã Yên Hoa", 2248, VietNamDivisionType.XA, "xa_yen_hoa", 72)
    W_2254 = Ward("Xã Hồng Thái", 2254, VietNamDivisionType.XA, "xa_hong_thai", 72)
    W_2260 = Ward("Xã Đà Vị", 2260, VietNamDivisionType.XA, "xa_da_vi", 72)
    W_2263 = Ward("Xã Khau Tinh", 2263, VietNamDivisionType.XA, "xa_khau_tinh", 72)
    W_2275 = Ward("Xã Sơn Phú", 2275, VietNamDivisionType.XA, "xa_son_phu", 72)
    W_2281 = Ward("Xã Năng Khả", 2281, VietNamDivisionType.XA, "xa_nang_kha", 72)
    W_2284 = Ward("Xã Thanh Tương", 2284, VietNamDivisionType.XA, "xa_thanh_tuong", 72)
    W_2287 = Ward("Thị trấn Vĩnh Lộc", 2287, VietNamDivisionType.THI_TRAN, "thi_tran_vinh_loc", 73)
    W_2299 = Ward("Xã Phúc Sơn", 2299, VietNamDivisionType.XA, "xa_phuc_son", 73)
    W_2302 = Ward("Xã Minh Quang", 2302, VietNamDivisionType.XA, "xa_minh_quang", 73)
    W_2305 = Ward("Xã Trung Hà", 2305, VietNamDivisionType.XA, "xa_trung_ha", 73)
    W_2308 = Ward("Xã Tân Mỹ", 2308, VietNamDivisionType.XA, "xa_tan_my", 73)
    W_2311 = Ward("Xã Hà Lang", 2311, VietNamDivisionType.XA, "xa_ha_lang", 73)
    W_2314 = Ward("Xã Hùng Mỹ", 2314, VietNamDivisionType.XA, "xa_hung_my", 73)
    W_2317 = Ward("Xã Yên Lập", 2317, VietNamDivisionType.XA, "xa_yen_lap", 73)
    W_2320 = Ward("Xã Tân An", 2320, VietNamDivisionType.XA, "xa_tan_an", 73)
    W_2323 = Ward("Xã Bình Phú", 2323, VietNamDivisionType.XA, "xa_binh_phu", 73)
    W_2326 = Ward("Xã Xuân Quang", 2326, VietNamDivisionType.XA, "xa_xuan_quang", 73)
    W_2329 = Ward("Xã Ngọc Hội", 2329, VietNamDivisionType.XA, "xa_ngoc_hoi", 73)
    W_2332 = Ward("Xã Phú Bình", 2332, VietNamDivisionType.XA, "xa_phu_binh", 73)
    W_2335 = Ward("Xã Hòa Phú", 2335, VietNamDivisionType.XA, "xa_hoa_phu", 73)
    W_2338 = Ward("Xã Phúc Thịnh", 2338, VietNamDivisionType.XA, "xa_phuc_thinh", 73)
    W_2341 = Ward("Xã Kiên Đài", 2341, VietNamDivisionType.XA, "xa_kien_dai", 73)
    W_2344 = Ward("Xã Tân Thịnh", 2344, VietNamDivisionType.XA, "xa_tan_thinh", 73)
    W_2347 = Ward("Xã Trung Hòa", 2347, VietNamDivisionType.XA, "xa_trung_hoa", 73)
    W_2350 = Ward("Xã Kim Bình", 2350, VietNamDivisionType.XA, "xa_kim_binh", 73)
    W_2353 = Ward("Xã Hòa An", 2353, VietNamDivisionType.XA, "xa_hoa_an", 73)
    W_2356 = Ward("Xã Vinh Quang", 2356, VietNamDivisionType.XA, "xa_vinh_quang", 73)
    W_2359 = Ward("Xã Tri Phú", 2359, VietNamDivisionType.XA, "xa_tri_phu", 73)
    W_2362 = Ward("Xã Nhân Lý", 2362, VietNamDivisionType.XA, "xa_nhan_ly", 73)
    W_2365 = Ward("Xã Yên Nguyên", 2365, VietNamDivisionType.XA, "xa_yen_nguyen", 73)
    W_2368 = Ward("Xã Linh Phú", 2368, VietNamDivisionType.XA, "xa_linh_phu", 73)
    W_2371 = Ward("Xã Bình Nhân", 2371, VietNamDivisionType.XA, "xa_binh_nhan", 73)
    W_2374 = Ward("Thị trấn Tân Yên", 2374, VietNamDivisionType.THI_TRAN, "thi_tran_tan_yen", 74)
    W_2377 = Ward("Xã Yên Thuận", 2377, VietNamDivisionType.XA, "xa_yen_thuan", 74)
    W_2380 = Ward("Xã Bạch Xa", 2380, VietNamDivisionType.XA, "xa_bach_xa", 74)
    W_2383 = Ward("Xã Minh Khương", 2383, VietNamDivisionType.XA, "xa_minh_khuong", 74)
    W_2386 = Ward("Xã Yên Lâm", 2386, VietNamDivisionType.XA, "xa_yen_lam", 74)
    W_2389 = Ward("Xã Minh Dân", 2389, VietNamDivisionType.XA, "xa_minh_dan", 74)
    W_2392 = Ward("Xã Phù Lưu", 2392, VietNamDivisionType.XA, "xa_phu_luu", 74)
    W_2395 = Ward("Xã Minh Hương", 2395, VietNamDivisionType.XA, "xa_minh_huong", 74)
    W_2398 = Ward("Xã Yên Phú", 2398, VietNamDivisionType.XA, "xa_yen_phu", 74)
    W_2401 = Ward("Xã Tân Thành", 2401, VietNamDivisionType.XA, "xa_tan_thanh", 74)
    W_2404 = Ward("Xã Bình Xa", 2404, VietNamDivisionType.XA, "xa_binh_xa", 74)
    W_2407 = Ward("Xã Thái Sơn", 2407, VietNamDivisionType.XA, "xa_thai_son", 74)
    W_2410 = Ward("Xã Nhân Mục", 2410, VietNamDivisionType.XA, "xa_nhan_muc", 74)
    W_2413 = Ward("Xã Thành Long", 2413, VietNamDivisionType.XA, "xa_thanh_long", 74)
    W_2416 = Ward("Xã Bằng Cốc", 2416, VietNamDivisionType.XA, "xa_bang_coc", 74)
    W_2419 = Ward("Xã Thái Hòa", 2419, VietNamDivisionType.XA, "xa_thai_hoa", 74)
    W_2422 = Ward("Xã Đức Ninh", 2422, VietNamDivisionType.XA, "xa_duc_ninh", 74)
    W_2425 = Ward("Xã Hùng Đức", 2425, VietNamDivisionType.XA, "xa_hung_duc", 74)
    W_2431 = Ward("Xã Quí Quân", 2431, VietNamDivisionType.XA, "xa_qui_quan", 75)
    W_2434 = Ward("Xã Lực Hành", 2434, VietNamDivisionType.XA, "xa_luc_hanh", 75)
    W_2437 = Ward("Xã Kiến Thiết", 2437, VietNamDivisionType.XA, "xa_kien_thiet", 75)
    W_2440 = Ward("Xã Trung Minh", 2440, VietNamDivisionType.XA, "xa_trung_minh", 75)
    W_2443 = Ward("Xã Chiêu Yên", 2443, VietNamDivisionType.XA, "xa_chieu_yen", 75)
    W_2446 = Ward("Xã Trung Trực", 2446, VietNamDivisionType.XA, "xa_trung_truc", 75)
    W_2449 = Ward("Xã Xuân Vân", 2449, VietNamDivisionType.XA, "xa_xuan_van", 75)
    W_2452 = Ward("Xã Phúc Ninh", 2452, VietNamDivisionType.XA, "xa_phuc_ninh", 75)
    W_2455 = Ward("Xã Hùng Lợi", 2455, VietNamDivisionType.XA, "xa_hung_loi", 75)
    W_2458 = Ward("Xã Trung Sơn", 2458, VietNamDivisionType.XA, "xa_trung_son", 75)
    W_2461 = Ward("Xã Tân Tiến", 2461, VietNamDivisionType.XA, "xa_tan_tien", 75)
    W_2464 = Ward("Xã Tứ Quận", 2464, VietNamDivisionType.XA, "xa_tu_quan", 75)
    W_2467 = Ward("Xã Đạo Viện", 2467, VietNamDivisionType.XA, "xa_dao_vien", 75)
    W_2470 = Ward("Xã Tân Long", 2470, VietNamDivisionType.XA, "xa_tan_long", 75)
    W_2473 = Ward("Xã Thắng Quân", 2473, VietNamDivisionType.XA, "xa_thang_quan", 75)
    W_2476 = Ward("Xã Kim Quan", 2476, VietNamDivisionType.XA, "xa_kim_quan", 75)
    W_2479 = Ward("Xã Lang Quán", 2479, VietNamDivisionType.XA, "xa_lang_quan", 75)
    W_2482 = Ward("Xã Phú Thịnh", 2482, VietNamDivisionType.XA, "xa_phu_thinh", 75)
    W_2485 = Ward("Xã Công Đa", 2485, VietNamDivisionType.XA, "xa_cong_da", 75)
    W_2488 = Ward("Xã Trung Môn", 2488, VietNamDivisionType.XA, "xa_trung_mon", 75)
    W_2491 = Ward("Xã Chân Sơn", 2491, VietNamDivisionType.XA, "xa_chan_son", 75)
    W_2494 = Ward("Xã Thái Bình", 2494, VietNamDivisionType.XA, "xa_thai_binh", 75)
    W_2500 = Ward("Xã Tiến Bộ", 2500, VietNamDivisionType.XA, "xa_tien_bo", 75)
    W_2506 = Ward("Xã Mỹ Bằng", 2506, VietNamDivisionType.XA, "xa_my_bang", 75)
    W_2518 = Ward("Xã Hoàng Khai", 2518, VietNamDivisionType.XA, "xa_hoang_khai", 75)
    W_2527 = Ward("Xã Nhữ Hán", 2527, VietNamDivisionType.XA, "xa_nhu_han", 75)
    W_2530 = Ward("Xã Nhữ Khê", 2530, VietNamDivisionType.XA, "xa_nhu_khe", 75)
    W_2533 = Ward("Xã Đội Bình", 2533, VietNamDivisionType.XA, "xa_doi_binh", 75)
    W_2536 = Ward("Thị trấn Sơn Dương", 2536, VietNamDivisionType.THI_TRAN, "thi_tran_son_duong", 76)
    W_2539 = Ward("Xã Trung Yên", 2539, VietNamDivisionType.XA, "xa_trung_yen", 76)
    W_2542 = Ward("Xã Minh Thanh", 2542, VietNamDivisionType.XA, "xa_minh_thanh", 76)
    W_2545 = Ward("Xã Tân Trào", 2545, VietNamDivisionType.XA, "xa_tan_trao", 76)
    W_2548 = Ward("Xã Vĩnh Lợi", 2548, VietNamDivisionType.XA, "xa_vinh_loi", 76)
    W_2551 = Ward("Xã Thượng Ấm", 2551, VietNamDivisionType.XA, "xa_thuong_am", 76)
    W_2554 = Ward("Xã Bình Yên", 2554, VietNamDivisionType.XA, "xa_binh_yen", 76)
    W_2557 = Ward("Xã Lương Thiện", 2557, VietNamDivisionType.XA, "xa_luong_thien", 76)
    W_2560 = Ward("Xã Tú Thịnh", 2560, VietNamDivisionType.XA, "xa_tu_thinh", 76)
    W_2563 = Ward("Xã Cấp Tiến", 2563, VietNamDivisionType.XA, "xa_cap_tien", 76)
    W_2566 = Ward("Xã Hợp Thành", 2566, VietNamDivisionType.XA, "xa_hop_thanh", 76)
    W_2569 = Ward("Xã Phúc Ứng", 2569, VietNamDivisionType.XA, "xa_phuc_ung", 76)
    W_2572 = Ward("Xã Đông Thọ", 2572, VietNamDivisionType.XA, "xa_dong_tho", 76)
    W_2575 = Ward("Xã Kháng Nhật", 2575, VietNamDivisionType.XA, "xa_khang_nhat", 76)
    W_2578 = Ward("Xã Hợp Hòa", 2578, VietNamDivisionType.XA, "xa_hop_hoa", 76)
    W_2584 = Ward("Xã Quyết Thắng", 2584, VietNamDivisionType.XA, "xa_quyet_thang", 76)
    W_2587 = Ward("Xã Đồng Quý", 2587, VietNamDivisionType.XA, "xa_dong_quy", 76)
    W_2590 = Ward("Xã Tân Thanh", 2590, VietNamDivisionType.XA, "xa_tan_thanh", 76)
    W_2593 = Ward("Xã Vân Sơn", 2593, VietNamDivisionType.XA, "xa_van_son", 76)
    W_2596 = Ward("Xã Văn Phú", 2596, VietNamDivisionType.XA, "xa_van_phu", 76)
    W_2599 = Ward("Xã Chi Thiết", 2599, VietNamDivisionType.XA, "xa_chi_thiet", 76)
    W_2602 = Ward("Xã Đông Lợi", 2602, VietNamDivisionType.XA, "xa_dong_loi", 76)
    W_2605 = Ward("Xã Thiện Kế", 2605, VietNamDivisionType.XA, "xa_thien_ke", 76)
    W_2608 = Ward("Xã Hồng Lạc", 2608, VietNamDivisionType.XA, "xa_hong_lac", 76)
    W_2611 = Ward("Xã Phú Lương", 2611, VietNamDivisionType.XA, "xa_phu_luong", 76)
    W_2614 = Ward("Xã Ninh Lai", 2614, VietNamDivisionType.XA, "xa_ninh_lai", 76)
    W_2617 = Ward("Xã Đại Phú", 2617, VietNamDivisionType.XA, "xa_dai_phu", 76)
    W_2620 = Ward("Xã Sơn Nam", 2620, VietNamDivisionType.XA, "xa_son_nam", 76)
    W_2623 = Ward("Xã Hào Phú", 2623, VietNamDivisionType.XA, "xa_hao_phu", 76)
    W_2626 = Ward("Xã Tam Đa", 2626, VietNamDivisionType.XA, "xa_tam_da", 76)
    W_2632 = Ward("Xã Trường Sinh", 2632, VietNamDivisionType.XA, "xa_truong_sinh", 76)
    W_2635 = Ward("Phường Duyên Hải", 2635, VietNamDivisionType.PHUONG, "phuong_duyen_hai", 80)
    W_2641 = Ward("Phường Lào Cai", 2641, VietNamDivisionType.PHUONG, "phuong_lao_cai", 80)
    W_2644 = Ward("Phường Cốc Lếu", 2644, VietNamDivisionType.PHUONG, "phuong_coc_leu", 80)
    W_2647 = Ward("Phường Kim Tân", 2647, VietNamDivisionType.PHUONG, "phuong_kim_tan", 80)
    W_2650 = Ward("Phường Bắc Lệnh", 2650, VietNamDivisionType.PHUONG, "phuong_bac_lenh", 80)
    W_2653 = Ward("Phường Pom Hán", 2653, VietNamDivisionType.PHUONG, "phuong_pom_han", 80)
    W_2656 = Ward("Phường Xuân Tăng", 2656, VietNamDivisionType.PHUONG, "phuong_xuan_tang", 80)
    W_2658 = Ward("Phường Bình Minh", 2658, VietNamDivisionType.PHUONG, "phuong_binh_minh", 80)
    W_2659 = Ward("Xã Thống Nhất", 2659, VietNamDivisionType.XA, "xa_thong_nhat", 80)
    W_2662 = Ward("Xã Đồng Tuyển", 2662, VietNamDivisionType.XA, "xa_dong_tuyen", 80)
    W_2665 = Ward("Xã Vạn Hoà", 2665, VietNamDivisionType.XA, "xa_van_hoa", 80)
    W_2668 = Ward("Phường Bắc Cường", 2668, VietNamDivisionType.PHUONG, "phuong_bac_cuong", 80)
    W_2671 = Ward("Phường Nam Cường", 2671, VietNamDivisionType.PHUONG, "phuong_nam_cuong", 80)
    W_2674 = Ward("Xã Cam Đường", 2674, VietNamDivisionType.XA, "xa_cam_duong", 80)
    W_2677 = Ward("Xã Tả Phời", 2677, VietNamDivisionType.XA, "xa_ta_phoi", 80)
    W_2680 = Ward("Xã Hợp Thành", 2680, VietNamDivisionType.XA, "xa_hop_thanh", 80)
    W_2746 = Ward("Xã Cốc San", 2746, VietNamDivisionType.XA, "xa_coc_san", 80)
    W_2683 = Ward("Thị trấn Bát Xát", 2683, VietNamDivisionType.THI_TRAN, "thi_tran_bat_xat", 82)
    W_2686 = Ward("Xã A Mú Sung", 2686, VietNamDivisionType.XA, "xa_a_mu_sung", 82)
    W_2689 = Ward("Xã Nậm Chạc", 2689, VietNamDivisionType.XA, "xa_nam_chac", 82)
    W_2692 = Ward("Xã A Lù", 2692, VietNamDivisionType.XA, "xa_a_lu", 82)
    W_2695 = Ward("Xã Trịnh Tường", 2695, VietNamDivisionType.XA, "xa_trinh_tuong", 82)
    W_2701 = Ward("Xã Y Tý", 2701, VietNamDivisionType.XA, "xa_y_ty", 82)
    W_2704 = Ward("Xã Cốc Mỳ", 2704, VietNamDivisionType.XA, "xa_coc_my", 82)
    W_2707 = Ward("Xã Dền Sáng", 2707, VietNamDivisionType.XA, "xa_den_sang", 82)
    W_2710 = Ward("Xã Bản Vược", 2710, VietNamDivisionType.XA, "xa_ban_vuoc", 82)
    W_2713 = Ward("Xã Sàng Ma Sáo", 2713, VietNamDivisionType.XA, "xa_sang_ma_sao", 82)
    W_2716 = Ward("Xã Bản Qua", 2716, VietNamDivisionType.XA, "xa_ban_qua", 82)
    W_2719 = Ward("Xã Mường Vi", 2719, VietNamDivisionType.XA, "xa_muong_vi", 82)
    W_2722 = Ward("Xã Dền Thàng", 2722, VietNamDivisionType.XA, "xa_den_thang", 82)
    W_2725 = Ward("Xã Bản Xèo", 2725, VietNamDivisionType.XA, "xa_ban_xeo", 82)
    W_2728 = Ward("Xã Mường Hum", 2728, VietNamDivisionType.XA, "xa_muong_hum", 82)
    W_2731 = Ward("Xã Trung Lèng Hồ", 2731, VietNamDivisionType.XA, "xa_trung_leng_ho", 82)
    W_2734 = Ward("Xã Quang Kim", 2734, VietNamDivisionType.XA, "xa_quang_kim", 82)
    W_2737 = Ward("Xã Pa Cheo", 2737, VietNamDivisionType.XA, "xa_pa_cheo", 82)
    W_2740 = Ward("Xã Nậm Pung", 2740, VietNamDivisionType.XA, "xa_nam_pung", 82)
    W_2743 = Ward("Xã Phìn Ngan", 2743, VietNamDivisionType.XA, "xa_phin_ngan", 82)
    W_2749 = Ward("Xã Tòng Sành", 2749, VietNamDivisionType.XA, "xa_tong_sanh", 82)
    W_2752 = Ward("Xã Pha Long", 2752, VietNamDivisionType.XA, "xa_pha_long", 83)
    W_2755 = Ward("Xã Tả Ngải Chồ", 2755, VietNamDivisionType.XA, "xa_ta_ngai_cho", 83)
    W_2758 = Ward("Xã Tung Chung Phố", 2758, VietNamDivisionType.XA, "xa_tung_chung_pho", 83)
    W_2761 = Ward("Thị trấn Mường Khương", 2761, VietNamDivisionType.THI_TRAN, "thi_tran_muong_khuong", 83)
    W_2764 = Ward("Xã Dìn Chin", 2764, VietNamDivisionType.XA, "xa_din_chin", 83)
    W_2767 = Ward("Xã Tả Gia Khâu", 2767, VietNamDivisionType.XA, "xa_ta_gia_khau", 83)
    W_2770 = Ward("Xã Nậm Chảy", 2770, VietNamDivisionType.XA, "xa_nam_chay", 83)
    W_2773 = Ward("Xã Nấm Lư", 2773, VietNamDivisionType.XA, "xa_nam_lu", 83)
    W_2776 = Ward("Xã Lùng Khấu Nhin", 2776, VietNamDivisionType.XA, "xa_lung_khau_nhin", 83)
    W_2779 = Ward("Xã Thanh Bình", 2779, VietNamDivisionType.XA, "xa_thanh_binh", 83)
    W_2782 = Ward("Xã Cao Sơn", 2782, VietNamDivisionType.XA, "xa_cao_son", 83)
    W_2785 = Ward("Xã Lùng Vai", 2785, VietNamDivisionType.XA, "xa_lung_vai", 83)
    W_2788 = Ward("Xã Bản Lầu", 2788, VietNamDivisionType.XA, "xa_ban_lau", 83)
    W_2791 = Ward("Xã La Pan Tẩn", 2791, VietNamDivisionType.XA, "xa_la_pan_tan", 83)
    W_2794 = Ward("Xã Tả Thàng", 2794, VietNamDivisionType.XA, "xa_ta_thang", 83)
    W_2797 = Ward("Xã Bản Sen", 2797, VietNamDivisionType.XA, "xa_ban_sen", 83)
    W_2800 = Ward("Xã Nàn Sán", 2800, VietNamDivisionType.XA, "xa_nan_san", 84)
    W_2803 = Ward("Xã Thào Chư Phìn", 2803, VietNamDivisionType.XA, "xa_thao_chu_phin", 84)
    W_2806 = Ward("Xã Bản Mế", 2806, VietNamDivisionType.XA, "xa_ban_me", 84)
    W_2809 = Ward("Thị trấn Si Ma Cai", 2809, VietNamDivisionType.THI_TRAN, "thi_tran_si_ma_cai", 84)
    W_2812 = Ward("Xã Sán Chải", 2812, VietNamDivisionType.XA, "xa_san_chai", 84)
    W_2818 = Ward("Xã Lùng Thẩn", 2818, VietNamDivisionType.XA, "xa_lung_than", 84)
    W_2821 = Ward("Xã Cán Cấu", 2821, VietNamDivisionType.XA, "xa_can_cau", 84)
    W_2824 = Ward("Xã Sín Chéng", 2824, VietNamDivisionType.XA, "xa_sin_cheng", 84)
    W_2827 = Ward("Xã Quan Hồ Thẩn", 2827, VietNamDivisionType.XA, "xa_quan_ho_than", 84)
    W_2836 = Ward("Xã Nàn Xín", 2836, VietNamDivisionType.XA, "xa_nan_xin", 84)
    W_2839 = Ward("Thị trấn Bắc Hà", 2839, VietNamDivisionType.THI_TRAN, "thi_tran_bac_ha", 85)
    W_2842 = Ward("Xã Lùng Cải", 2842, VietNamDivisionType.XA, "xa_lung_cai", 85)
    W_2848 = Ward("Xã Lùng Phình", 2848, VietNamDivisionType.XA, "xa_lung_phinh", 85)
    W_2851 = Ward("Xã Tả Van Chư", 2851, VietNamDivisionType.XA, "xa_ta_van_chu", 85)
    W_2854 = Ward("Xã Tả Củ Tỷ", 2854, VietNamDivisionType.XA, "xa_ta_cu_ty", 85)
    W_2857 = Ward("Xã Thải Giàng Phố", 2857, VietNamDivisionType.XA, "xa_thai_giang_pho", 85)
    W_2863 = Ward("Xã Hoàng Thu Phố", 2863, VietNamDivisionType.XA, "xa_hoang_thu_pho", 85)
    W_2866 = Ward("Xã Bản Phố", 2866, VietNamDivisionType.XA, "xa_ban_pho", 85)
    W_2869 = Ward("Xã Bản Liền", 2869, VietNamDivisionType.XA, "xa_ban_lien", 85)
    W_2872 = Ward("Xã Tà Chải", 2872, VietNamDivisionType.XA, "xa_ta_chai", 85)
    W_2875 = Ward("Xã Na Hối", 2875, VietNamDivisionType.XA, "xa_na_hoi", 85)
    W_2878 = Ward("Xã Cốc Ly", 2878, VietNamDivisionType.XA, "xa_coc_ly", 85)
    W_2881 = Ward("Xã Nậm Mòn", 2881, VietNamDivisionType.XA, "xa_nam_mon", 85)
    W_2884 = Ward("Xã Nậm Đét", 2884, VietNamDivisionType.XA, "xa_nam_det", 85)
    W_2887 = Ward("Xã Nậm Khánh", 2887, VietNamDivisionType.XA, "xa_nam_khanh", 85)
    W_2890 = Ward("Xã Bảo Nhai", 2890, VietNamDivisionType.XA, "xa_bao_nhai", 85)
    W_2893 = Ward("Xã Nậm Lúc", 2893, VietNamDivisionType.XA, "xa_nam_luc", 85)
    W_2896 = Ward("Xã Cốc Lầu", 2896, VietNamDivisionType.XA, "xa_coc_lau", 85)
    W_2899 = Ward("Xã Bản Cái", 2899, VietNamDivisionType.XA, "xa_ban_cai", 85)
    W_2902 = Ward("Thị trấn N.T Phong Hải", 2902, VietNamDivisionType.THI_TRAN, "thi_tran_n_t_phong_hai", 86)
    W_2905 = Ward("Thị trấn Phố Lu", 2905, VietNamDivisionType.THI_TRAN, "thi_tran_pho_lu", 86)
    W_2908 = Ward("Thị trấn Tằng Loỏng", 2908, VietNamDivisionType.THI_TRAN, "thi_tran_tang_loong", 86)
    W_2911 = Ward("Xã Bản Phiệt", 2911, VietNamDivisionType.XA, "xa_ban_phiet", 86)
    W_2914 = Ward("Xã Bản Cầm", 2914, VietNamDivisionType.XA, "xa_ban_cam", 86)
    W_2917 = Ward("Xã Thái Niên", 2917, VietNamDivisionType.XA, "xa_thai_nien", 86)
    W_2920 = Ward("Xã Phong Niên", 2920, VietNamDivisionType.XA, "xa_phong_nien", 86)
    W_2923 = Ward("Xã Gia Phú", 2923, VietNamDivisionType.XA, "xa_gia_phu", 86)
    W_2926 = Ward("Xã Xuân Quang", 2926, VietNamDivisionType.XA, "xa_xuan_quang", 86)
    W_2929 = Ward("Xã Sơn Hải", 2929, VietNamDivisionType.XA, "xa_son_hai", 86)
    W_2932 = Ward("Xã Xuân Giao", 2932, VietNamDivisionType.XA, "xa_xuan_giao", 86)
    W_2935 = Ward("Xã Trì Quang", 2935, VietNamDivisionType.XA, "xa_tri_quang", 86)
    W_2938 = Ward("Xã Sơn Hà", 2938, VietNamDivisionType.XA, "xa_son_ha", 86)
    W_2944 = Ward("Xã Phú Nhuận", 2944, VietNamDivisionType.XA, "xa_phu_nhuan", 86)
    W_2947 = Ward("Thị trấn Phố Ràng", 2947, VietNamDivisionType.THI_TRAN, "thi_tran_pho_rang", 87)
    W_2950 = Ward("Xã Tân Tiến", 2950, VietNamDivisionType.XA, "xa_tan_tien", 87)
    W_2953 = Ward("Xã Nghĩa Đô", 2953, VietNamDivisionType.XA, "xa_nghia_do", 87)
    W_2956 = Ward("Xã Vĩnh Yên", 2956, VietNamDivisionType.XA, "xa_vinh_yen", 87)
    W_2959 = Ward("Xã Điện Quan", 2959, VietNamDivisionType.XA, "xa_dien_quan", 87)
    W_2962 = Ward("Xã Xuân Hoà", 2962, VietNamDivisionType.XA, "xa_xuan_hoa", 87)
    W_2965 = Ward("Xã Tân Dương", 2965, VietNamDivisionType.XA, "xa_tan_duong", 87)
    W_2968 = Ward("Xã Thượng Hà", 2968, VietNamDivisionType.XA, "xa_thuong_ha", 87)
    W_2971 = Ward("Xã Kim Sơn", 2971, VietNamDivisionType.XA, "xa_kim_son", 87)
    W_2974 = Ward("Xã Cam Cọn", 2974, VietNamDivisionType.XA, "xa_cam_con", 87)
    W_2977 = Ward("Xã Minh Tân", 2977, VietNamDivisionType.XA, "xa_minh_tan", 87)
    W_2980 = Ward("Xã Xuân Thượng", 2980, VietNamDivisionType.XA, "xa_xuan_thuong", 87)
    W_2983 = Ward("Xã Việt Tiến", 2983, VietNamDivisionType.XA, "xa_viet_tien", 87)
    W_2986 = Ward("Xã Yên Sơn", 2986, VietNamDivisionType.XA, "xa_yen_son", 87)
    W_2989 = Ward("Xã Bảo Hà", 2989, VietNamDivisionType.XA, "xa_bao_ha", 87)
    W_2992 = Ward("Xã Lương Sơn", 2992, VietNamDivisionType.XA, "xa_luong_son", 87)
    W_2998 = Ward("Xã Phúc Khánh", 2998, VietNamDivisionType.XA, "xa_phuc_khanh", 87)
    W_3001 = Ward("Phường Sa Pa", 3001, VietNamDivisionType.PHUONG, "phuong_sa_pa", 88)
    W_3002 = Ward("Phường Sa Pả", 3002, VietNamDivisionType.PHUONG, "phuong_sa_pa", 88)
    W_3003 = Ward("Phường Ô Quý Hồ", 3003, VietNamDivisionType.PHUONG, "phuong_o_quy_ho", 88)
    W_3004 = Ward("Xã Ngũ Chỉ Sơn", 3004, VietNamDivisionType.XA, "xa_ngu_chi_son", 88)
    W_3006 = Ward("Phường Phan Si Păng", 3006, VietNamDivisionType.PHUONG, "phuong_phan_si_pang", 88)
    W_3010 = Ward("Xã Trung Chải", 3010, VietNamDivisionType.XA, "xa_trung_chai", 88)
    W_3013 = Ward("Xã Tả Phìn", 3013, VietNamDivisionType.XA, "xa_ta_phin", 88)
    W_3016 = Ward("Phường Hàm Rồng", 3016, VietNamDivisionType.PHUONG, "phuong_ham_rong", 88)
    W_3019 = Ward("Xã Hoàng Liên", 3019, VietNamDivisionType.XA, "xa_hoang_lien", 88)
    W_3022 = Ward("Xã Thanh Bình", 3022, VietNamDivisionType.XA, "xa_thanh_binh", 88)
    W_3028 = Ward("Phường Cầu Mây", 3028, VietNamDivisionType.PHUONG, "phuong_cau_may", 88)
    W_3037 = Ward("Xã Mường Hoa", 3037, VietNamDivisionType.XA, "xa_muong_hoa", 88)
    W_3040 = Ward("Xã Tả Van", 3040, VietNamDivisionType.XA, "xa_ta_van", 88)
    W_3043 = Ward("Xã Mường Bo", 3043, VietNamDivisionType.XA, "xa_muong_bo", 88)
    W_3046 = Ward("Xã Bản Hồ", 3046, VietNamDivisionType.XA, "xa_ban_ho", 88)
    W_3052 = Ward("Xã Liên Minh", 3052, VietNamDivisionType.XA, "xa_lien_minh", 88)
    W_3055 = Ward("Thị trấn Khánh Yên", 3055, VietNamDivisionType.THI_TRAN, "thi_tran_khanh_yen", 89)
    W_3061 = Ward("Xã Võ Lao", 3061, VietNamDivisionType.XA, "xa_vo_lao", 89)
    W_3064 = Ward("Xã Sơn Thuỷ", 3064, VietNamDivisionType.XA, "xa_son_thuy", 89)
    W_3067 = Ward("Xã Nậm Mả", 3067, VietNamDivisionType.XA, "xa_nam_ma", 89)
    W_3070 = Ward("Xã Tân Thượng", 3070, VietNamDivisionType.XA, "xa_tan_thuong", 89)
    W_3073 = Ward("Xã Nậm Rạng", 3073, VietNamDivisionType.XA, "xa_nam_rang", 89)
    W_3076 = Ward("Xã Nậm Chầy", 3076, VietNamDivisionType.XA, "xa_nam_chay", 89)
    W_3079 = Ward("Xã Tân An", 3079, VietNamDivisionType.XA, "xa_tan_an", 89)
    W_3082 = Ward("Xã Khánh Yên Thượng", 3082, VietNamDivisionType.XA, "xa_khanh_yen_thuong", 89)
    W_3085 = Ward("Xã Nậm Xé", 3085, VietNamDivisionType.XA, "xa_nam_xe", 89)
    W_3088 = Ward("Xã Dần Thàng", 3088, VietNamDivisionType.XA, "xa_dan_thang", 89)
    W_3091 = Ward("Xã Chiềng Ken", 3091, VietNamDivisionType.XA, "xa_chieng_ken", 89)
    W_3094 = Ward("Xã Làng Giàng", 3094, VietNamDivisionType.XA, "xa_lang_giang", 89)
    W_3097 = Ward("Xã Hoà Mạc", 3097, VietNamDivisionType.XA, "xa_hoa_mac", 89)
    W_3100 = Ward("Xã Khánh Yên Trung", 3100, VietNamDivisionType.XA, "xa_khanh_yen_trung", 89)
    W_3103 = Ward("Xã Khánh Yên Hạ", 3103, VietNamDivisionType.XA, "xa_khanh_yen_ha", 89)
    W_3106 = Ward("Xã Dương Quỳ", 3106, VietNamDivisionType.XA, "xa_duong_quy", 89)
    W_3109 = Ward("Xã Nậm Tha", 3109, VietNamDivisionType.XA, "xa_nam_tha", 89)
    W_3112 = Ward("Xã Minh Lương", 3112, VietNamDivisionType.XA, "xa_minh_luong", 89)
    W_3115 = Ward("Xã Thẩm Dương", 3115, VietNamDivisionType.XA, "xa_tham_duong", 89)
    W_3118 = Ward("Xã Liêm Phú", 3118, VietNamDivisionType.XA, "xa_liem_phu", 89)
    W_3121 = Ward("Xã Nậm Xây", 3121, VietNamDivisionType.XA, "xa_nam_xay", 89)
    W_3124 = Ward("Phường Noong Bua", 3124, VietNamDivisionType.PHUONG, "phuong_noong_bua", 94)
    W_3127 = Ward("Phường Him Lam", 3127, VietNamDivisionType.PHUONG, "phuong_him_lam", 94)
    W_3130 = Ward("Phường Thanh Bình", 3130, VietNamDivisionType.PHUONG, "phuong_thanh_binh", 94)
    W_3133 = Ward("Phường Tân Thanh", 3133, VietNamDivisionType.PHUONG, "phuong_tan_thanh", 94)
    W_3136 = Ward("Phường Mường Thanh", 3136, VietNamDivisionType.PHUONG, "phuong_muong_thanh", 94)
    W_3139 = Ward("Phường Nam Thanh", 3139, VietNamDivisionType.PHUONG, "phuong_nam_thanh", 94)
    W_3142 = Ward("Phường Thanh Trường", 3142, VietNamDivisionType.PHUONG, "phuong_thanh_truong", 94)
    W_3145 = Ward("Xã Thanh Minh", 3145, VietNamDivisionType.XA, "xa_thanh_minh", 94)
    W_3316 = Ward("Xã Nà Tấu", 3316, VietNamDivisionType.XA, "xa_na_tau", 94)
    W_3317 = Ward("Xã Nà Nhạn", 3317, VietNamDivisionType.XA, "xa_na_nhan", 94)
    W_3325 = Ward("Xã Mường Phăng", 3325, VietNamDivisionType.XA, "xa_muong_phang", 94)
    W_3326 = Ward("Xã Pá Khoang", 3326, VietNamDivisionType.XA, "xa_pa_khoang", 94)
    W_3148 = Ward("Phường Sông Đà", 3148, VietNamDivisionType.PHUONG, "phuong_song_da", 95)
    W_3151 = Ward("Phường Na Lay", 3151, VietNamDivisionType.PHUONG, "phuong_na_lay", 95)
    W_3184 = Ward("Xã Lay Nưa", 3184, VietNamDivisionType.XA, "xa_lay_nua", 95)
    W_3154 = Ward("Xã Sín Thầu", 3154, VietNamDivisionType.XA, "xa_sin_thau", 96)
    W_3155 = Ward("Xã Sen Thượng", 3155, VietNamDivisionType.XA, "xa_sen_thuong", 96)
    W_3157 = Ward("Xã Chung Chải", 3157, VietNamDivisionType.XA, "xa_chung_chai", 96)
    W_3158 = Ward("Xã Leng Su Sìn", 3158, VietNamDivisionType.XA, "xa_leng_su_sin", 96)
    W_3159 = Ward("Xã Pá Mỳ", 3159, VietNamDivisionType.XA, "xa_pa_my", 96)
    W_3160 = Ward("Xã Mường Nhé", 3160, VietNamDivisionType.XA, "xa_muong_nhe", 96)
    W_3161 = Ward("Xã Nậm Vì", 3161, VietNamDivisionType.XA, "xa_nam_vi", 96)
    W_3162 = Ward("Xã Nậm Kè", 3162, VietNamDivisionType.XA, "xa_nam_ke", 96)
    W_3163 = Ward("Xã Mường Toong", 3163, VietNamDivisionType.XA, "xa_muong_toong", 96)
    W_3164 = Ward("Xã Quảng Lâm", 3164, VietNamDivisionType.XA, "xa_quang_lam", 96)
    W_3177 = Ward("Xã Huổi Lếnh", 3177, VietNamDivisionType.XA, "xa_huoi_lenh", 96)
    W_3172 = Ward("Thị trấn Mường Chà", 3172, VietNamDivisionType.THI_TRAN, "thi_tran_muong_cha", 97)
    W_3178 = Ward("Xã Xá Tổng", 3178, VietNamDivisionType.XA, "xa_xa_tong", 97)
    W_3181 = Ward("Xã Mường Tùng", 3181, VietNamDivisionType.XA, "xa_muong_tung", 97)
    W_3190 = Ward("Xã Hừa Ngài", 3190, VietNamDivisionType.XA, "xa_hua_ngai", 97)
    W_3191 = Ward("Xã Huổi Mí", 3191, VietNamDivisionType.XA, "xa_huoi_mi", 97)
    W_3193 = Ward("Xã Pa Ham", 3193, VietNamDivisionType.XA, "xa_pa_ham", 97)
    W_3194 = Ward("Xã Nậm Nèn", 3194, VietNamDivisionType.XA, "xa_nam_nen", 97)
    W_3196 = Ward("Xã Huổi Lèng", 3196, VietNamDivisionType.XA, "xa_huoi_leng", 97)
    W_3197 = Ward("Xã Sa Lông", 3197, VietNamDivisionType.XA, "xa_sa_long", 97)
    W_3200 = Ward("Xã Ma Thì Hồ", 3200, VietNamDivisionType.XA, "xa_ma_thi_ho", 97)
    W_3201 = Ward("Xã Na Sang", 3201, VietNamDivisionType.XA, "xa_na_sang", 97)
    W_3202 = Ward("Xã Mường Mươn", 3202, VietNamDivisionType.XA, "xa_muong_muon", 97)
    W_3217 = Ward("Thị trấn Tủa Chùa", 3217, VietNamDivisionType.THI_TRAN, "thi_tran_tua_chua", 98)
    W_3220 = Ward("Xã Huổi Só", 3220, VietNamDivisionType.XA, "xa_huoi_so", 98)
    W_3223 = Ward("Xã Xín Chải", 3223, VietNamDivisionType.XA, "xa_xin_chai", 98)
    W_3226 = Ward("Xã Tả Sìn Thàng", 3226, VietNamDivisionType.XA, "xa_ta_sin_thang", 98)
    W_3229 = Ward("Xã Lao Xả Phình", 3229, VietNamDivisionType.XA, "xa_lao_xa_phinh", 98)
    W_3232 = Ward("Xã Tả Phìn", 3232, VietNamDivisionType.XA, "xa_ta_phin", 98)
    W_3235 = Ward("Xã Tủa Thàng", 3235, VietNamDivisionType.XA, "xa_tua_thang", 98)
    W_3238 = Ward("Xã Trung Thu", 3238, VietNamDivisionType.XA, "xa_trung_thu", 98)
    W_3241 = Ward("Xã Sính Phình", 3241, VietNamDivisionType.XA, "xa_sinh_phinh", 98)
    W_3244 = Ward("Xã Sáng Nhè", 3244, VietNamDivisionType.XA, "xa_sang_nhe", 98)
    W_3247 = Ward("Xã Mường Đun", 3247, VietNamDivisionType.XA, "xa_muong_dun", 98)
    W_3250 = Ward("Xã Mường Báng", 3250, VietNamDivisionType.XA, "xa_muong_bang", 98)
    W_3253 = Ward("Thị trấn Tuần Giáo", 3253, VietNamDivisionType.THI_TRAN, "thi_tran_tuan_giao", 99)
    W_3259 = Ward("Xã Phình Sáng", 3259, VietNamDivisionType.XA, "xa_phinh_sang", 99)
    W_3260 = Ward("Xã Rạng Đông", 3260, VietNamDivisionType.XA, "xa_rang_dong", 99)
    W_3262 = Ward("Xã Mùn Chung", 3262, VietNamDivisionType.XA, "xa_mun_chung", 99)
    W_3263 = Ward("Xã Nà Tòng", 3263, VietNamDivisionType.XA, "xa_na_tong", 99)
    W_3265 = Ward("Xã Ta Ma", 3265, VietNamDivisionType.XA, "xa_ta_ma", 99)
    W_3268 = Ward("Xã Mường Mùn", 3268, VietNamDivisionType.XA, "xa_muong_mun", 99)
    W_3269 = Ward("Xã Pú Xi", 3269, VietNamDivisionType.XA, "xa_pu_xi", 99)
    W_3271 = Ward("Xã Pú Nhung", 3271, VietNamDivisionType.XA, "xa_pu_nhung", 99)
    W_3274 = Ward("Xã Quài Nưa", 3274, VietNamDivisionType.XA, "xa_quai_nua", 99)
    W_3277 = Ward("Xã Mường Thín", 3277, VietNamDivisionType.XA, "xa_muong_thin", 99)
    W_3280 = Ward("Xã Tỏa Tình", 3280, VietNamDivisionType.XA, "xa_toa_tinh", 99)
    W_3283 = Ward("Xã Nà Sáy", 3283, VietNamDivisionType.XA, "xa_na_say", 99)
    W_3284 = Ward("Xã Mường Khong", 3284, VietNamDivisionType.XA, "xa_muong_khong", 99)
    W_3289 = Ward("Xã Quài Cang", 3289, VietNamDivisionType.XA, "xa_quai_cang", 99)
    W_3295 = Ward("Xã Quài Tở", 3295, VietNamDivisionType.XA, "xa_quai_to", 99)
    W_3298 = Ward("Xã Chiềng Sinh", 3298, VietNamDivisionType.XA, "xa_chieng_sinh", 99)
    W_3299 = Ward("Xã Chiềng Đông", 3299, VietNamDivisionType.XA, "xa_chieng_dong", 99)
    W_3304 = Ward("Xã Tênh Phông", 3304, VietNamDivisionType.XA, "xa_tenh_phong", 99)
    W_3319 = Ward("Xã Mường Pồn", 3319, VietNamDivisionType.XA, "xa_muong_pon", 100)
    W_3322 = Ward("Xã Thanh Nưa", 3322, VietNamDivisionType.XA, "xa_thanh_nua", 100)
    W_3323 = Ward("Xã Hua Thanh", 3323, VietNamDivisionType.XA, "xa_hua_thanh", 100)
    W_3328 = Ward("Xã Thanh Luông", 3328, VietNamDivisionType.XA, "xa_thanh_luong", 100)
    W_3331 = Ward("Xã Thanh Hưng", 3331, VietNamDivisionType.XA, "xa_thanh_hung", 100)
    W_3334 = Ward("Xã Thanh Xương", 3334, VietNamDivisionType.XA, "xa_thanh_xuong", 100)
    W_3337 = Ward("Xã Thanh Chăn", 3337, VietNamDivisionType.XA, "xa_thanh_chan", 100)
    W_3340 = Ward("Xã Pa Thơm", 3340, VietNamDivisionType.XA, "xa_pa_thom", 100)
    W_3343 = Ward("Xã Thanh An", 3343, VietNamDivisionType.XA, "xa_thanh_an", 100)
    W_3346 = Ward("Xã Thanh Yên", 3346, VietNamDivisionType.XA, "xa_thanh_yen", 100)
    W_3349 = Ward("Xã Noong Luống", 3349, VietNamDivisionType.XA, "xa_noong_luong", 100)
    W_3352 = Ward("Xã Noọng Hẹt", 3352, VietNamDivisionType.XA, "xa_noong_het", 100)
    W_3355 = Ward("Xã Sam Mứn", 3355, VietNamDivisionType.XA, "xa_sam_mun", 100)
    W_3356 = Ward("Xã Pom Lót", 3356, VietNamDivisionType.XA, "xa_pom_lot", 100)
    W_3358 = Ward("Xã Núa Ngam", 3358, VietNamDivisionType.XA, "xa_nua_ngam", 100)
    W_3359 = Ward("Xã Hẹ Muông", 3359, VietNamDivisionType.XA, "xa_he_muong", 100)
    W_3361 = Ward("Xã Na Ư", 3361, VietNamDivisionType.XA, "xa_na_u", 100)
    W_3364 = Ward("Xã Mường Nhà", 3364, VietNamDivisionType.XA, "xa_muong_nha", 100)
    W_3365 = Ward("Xã Na Tông", 3365, VietNamDivisionType.XA, "xa_na_tong", 100)
    W_3367 = Ward("Xã Mường Lói", 3367, VietNamDivisionType.XA, "xa_muong_loi", 100)
    W_3368 = Ward("Xã Phu Luông", 3368, VietNamDivisionType.XA, "xa_phu_luong", 100)
    W_3203 = Ward("Thị trấn Điện Biên Đông", 3203, VietNamDivisionType.THI_TRAN, "thi_tran_dien_bien_dong", 101)
    W_3205 = Ward("Xã Na Son", 3205, VietNamDivisionType.XA, "xa_na_son", 101)
    W_3208 = Ward("Xã Phì Nhừ", 3208, VietNamDivisionType.XA, "xa_phi_nhu", 101)
    W_3211 = Ward("Xã Chiềng Sơ", 3211, VietNamDivisionType.XA, "xa_chieng_so", 101)
    W_3214 = Ward("Xã Mường Luân", 3214, VietNamDivisionType.XA, "xa_muong_luan", 101)
    W_3370 = Ward("Xã Pú Nhi", 3370, VietNamDivisionType.XA, "xa_pu_nhi", 101)
    W_3371 = Ward("Xã Nong U", 3371, VietNamDivisionType.XA, "xa_nong_u", 101)
    W_3373 = Ward("Xã Xa Dung", 3373, VietNamDivisionType.XA, "xa_xa_dung", 101)
    W_3376 = Ward("Xã Keo Lôm", 3376, VietNamDivisionType.XA, "xa_keo_lom", 101)
    W_3379 = Ward("Xã Luân Giới", 3379, VietNamDivisionType.XA, "xa_luan_gioi", 101)
    W_3382 = Ward("Xã Phình Giàng", 3382, VietNamDivisionType.XA, "xa_phinh_giang", 101)
    W_3383 = Ward("Xã Pú Hồng", 3383, VietNamDivisionType.XA, "xa_pu_hong", 101)
    W_3384 = Ward("Xã Tìa Dình", 3384, VietNamDivisionType.XA, "xa_tia_dinh", 101)
    W_3385 = Ward("Xã Háng Lìa", 3385, VietNamDivisionType.XA, "xa_hang_lia", 101)
    W_3256 = Ward("Thị trấn Mường Ảng", 3256, VietNamDivisionType.THI_TRAN, "thi_tran_muong_ang", 102)
    W_3286 = Ward("Xã Mường Đăng", 3286, VietNamDivisionType.XA, "xa_muong_dang", 102)
    W_3287 = Ward("Xã Ngối Cáy", 3287, VietNamDivisionType.XA, "xa_ngoi_cay", 102)
    W_3292 = Ward("Xã Ẳng Tở", 3292, VietNamDivisionType.XA, "xa_ang_to", 102)
    W_3301 = Ward("Xã Búng Lao", 3301, VietNamDivisionType.XA, "xa_bung_lao", 102)
    W_3302 = Ward("Xã Xuân Lao", 3302, VietNamDivisionType.XA, "xa_xuan_lao", 102)
    W_3307 = Ward("Xã Ẳng Nưa", 3307, VietNamDivisionType.XA, "xa_ang_nua", 102)
    W_3310 = Ward("Xã Ẳng Cang", 3310, VietNamDivisionType.XA, "xa_ang_cang", 102)
    W_3312 = Ward("Xã Nặm Lịch", 3312, VietNamDivisionType.XA, "xa_nam_lich", 102)
    W_3313 = Ward("Xã Mường Lạn", 3313, VietNamDivisionType.XA, "xa_muong_lan", 102)
    W_3156 = Ward("Xã Nậm Tin", 3156, VietNamDivisionType.XA, "xa_nam_tin", 103)
    W_3165 = Ward("Xã Pa Tần", 3165, VietNamDivisionType.XA, "xa_pa_tan", 103)
    W_3166 = Ward("Xã Chà Cang", 3166, VietNamDivisionType.XA, "xa_cha_cang", 103)
    W_3167 = Ward("Xã Na Cô Sa", 3167, VietNamDivisionType.XA, "xa_na_co_sa", 103)
    W_3168 = Ward("Xã Nà Khoa", 3168, VietNamDivisionType.XA, "xa_na_khoa", 103)
    W_3169 = Ward("Xã Nà Hỳ", 3169, VietNamDivisionType.XA, "xa_na_hy", 103)
    W_3170 = Ward("Xã Nà Bủng", 3170, VietNamDivisionType.XA, "xa_na_bung", 103)
    W_3171 = Ward("Xã Nậm Nhừ", 3171, VietNamDivisionType.XA, "xa_nam_nhu", 103)
    W_3173 = Ward("Xã Nậm Chua", 3173, VietNamDivisionType.XA, "xa_nam_chua", 103)
    W_3174 = Ward("Xã Nậm Khăn", 3174, VietNamDivisionType.XA, "xa_nam_khan", 103)
    W_3175 = Ward("Xã Chà Tở", 3175, VietNamDivisionType.XA, "xa_cha_to", 103)
    W_3176 = Ward("Xã Vàng Đán", 3176, VietNamDivisionType.XA, "xa_vang_dan", 103)
    W_3187 = Ward("Xã Chà Nưa", 3187, VietNamDivisionType.XA, "xa_cha_nua", 103)
    W_3198 = Ward("Xã Phìn Hồ", 3198, VietNamDivisionType.XA, "xa_phin_ho", 103)
    W_3199 = Ward("Xã Si Pa Phìn", 3199, VietNamDivisionType.XA, "xa_si_pa_phin", 103)
    W_3386 = Ward("Phường Quyết Thắng", 3386, VietNamDivisionType.PHUONG, "phuong_quyet_thang", 105)
    W_3387 = Ward("Phường Tân Phong", 3387, VietNamDivisionType.PHUONG, "phuong_tan_phong", 105)
    W_3388 = Ward("Phường Quyết Tiến", 3388, VietNamDivisionType.PHUONG, "phuong_quyet_tien", 105)
    W_3389 = Ward("Phường Đoàn Kết", 3389, VietNamDivisionType.PHUONG, "phuong_doan_ket", 105)
    W_3403 = Ward("Xã Sùng Phài", 3403, VietNamDivisionType.XA, "xa_sung_phai", 105)
    W_3408 = Ward("Phường Đông Phong", 3408, VietNamDivisionType.PHUONG, "phuong_dong_phong", 105)
    W_3409 = Ward("Xã San Thàng", 3409, VietNamDivisionType.XA, "xa_san_thang", 105)
    W_3390 = Ward("Thị trấn Tam Đường", 3390, VietNamDivisionType.THI_TRAN, "thi_tran_tam_duong", 106)
    W_3394 = Ward("Xã Thèn Sin", 3394, VietNamDivisionType.XA, "xa_then_sin", 106)
    W_3400 = Ward("Xã Tả Lèng", 3400, VietNamDivisionType.XA, "xa_ta_leng", 106)
    W_3405 = Ward("Xã Giang Ma", 3405, VietNamDivisionType.XA, "xa_giang_ma", 106)
    W_3406 = Ward("Xã Hồ Thầu", 3406, VietNamDivisionType.XA, "xa_ho_thau", 106)
    W_3412 = Ward("Xã Bình Lư", 3412, VietNamDivisionType.XA, "xa_binh_lu", 106)
    W_3413 = Ward("Xã Sơn Bình", 3413, VietNamDivisionType.XA, "xa_son_binh", 106)
    W_3415 = Ward("Xã Nùng Nàng", 3415, VietNamDivisionType.XA, "xa_nung_nang", 106)
    W_3418 = Ward("Xã Bản Giang", 3418, VietNamDivisionType.XA, "xa_ban_giang", 106)
    W_3421 = Ward("Xã Bản Hon", 3421, VietNamDivisionType.XA, "xa_ban_hon", 106)
    W_3424 = Ward("Xã Bản Bo", 3424, VietNamDivisionType.XA, "xa_ban_bo", 106)
    W_3427 = Ward("Xã Nà Tăm", 3427, VietNamDivisionType.XA, "xa_na_tam", 106)
    W_3430 = Ward("Xã Khun Há", 3430, VietNamDivisionType.XA, "xa_khun_ha", 106)
    W_3433 = Ward("Thị trấn Mường Tè", 3433, VietNamDivisionType.THI_TRAN, "thi_tran_muong_te", 107)
    W_3436 = Ward("Xã Thu Lũm", 3436, VietNamDivisionType.XA, "xa_thu_lum", 107)
    W_3439 = Ward("Xã Ka Lăng", 3439, VietNamDivisionType.XA, "xa_ka_lang", 107)
    W_3440 = Ward("Xã Tá Bạ", 3440, VietNamDivisionType.XA, "xa_ta_ba", 107)
    W_3442 = Ward("Xã Pa ủ", 3442, VietNamDivisionType.XA, "xa_pa_u", 107)
    W_3445 = Ward("Xã Mường Tè", 3445, VietNamDivisionType.XA, "xa_muong_te", 107)
    W_3448 = Ward("Xã Pa Vệ Sử", 3448, VietNamDivisionType.XA, "xa_pa_ve_su", 107)
    W_3451 = Ward("Xã Mù Cả", 3451, VietNamDivisionType.XA, "xa_mu_ca", 107)
    W_3454 = Ward("Xã Bum Tở", 3454, VietNamDivisionType.XA, "xa_bum_to", 107)
    W_3457 = Ward("Xã Nậm Khao", 3457, VietNamDivisionType.XA, "xa_nam_khao", 107)
    W_3463 = Ward("Xã Tà Tổng", 3463, VietNamDivisionType.XA, "xa_ta_tong", 107)
    W_3466 = Ward("Xã Bum Nưa", 3466, VietNamDivisionType.XA, "xa_bum_nua", 107)
    W_3467 = Ward("Xã Vàng San", 3467, VietNamDivisionType.XA, "xa_vang_san", 107)
    W_3469 = Ward("Xã Kan Hồ", 3469, VietNamDivisionType.XA, "xa_kan_ho", 107)
    W_3478 = Ward("Thị trấn Sìn Hồ", 3478, VietNamDivisionType.THI_TRAN, "thi_tran_sin_ho", 108)
    W_3487 = Ward("Xã Chăn Nưa", 3487, VietNamDivisionType.XA, "xa_chan_nua", 108)
    W_3493 = Ward("Xã Pa Tần", 3493, VietNamDivisionType.XA, "xa_pa_tan", 108)
    W_3496 = Ward("Xã Phìn Hồ", 3496, VietNamDivisionType.XA, "xa_phin_ho", 108)
    W_3499 = Ward("Xã Hồng Thu", 3499, VietNamDivisionType.XA, "xa_hong_thu", 108)
    W_3505 = Ward("Xã Phăng Sô Lin", 3505, VietNamDivisionType.XA, "xa_phang_so_lin", 108)
    W_3508 = Ward("Xã Ma Quai", 3508, VietNamDivisionType.XA, "xa_ma_quai", 108)
    W_3509 = Ward("Xã Lùng Thàng", 3509, VietNamDivisionType.XA, "xa_lung_thang", 108)
    W_3511 = Ward("Xã Tả Phìn", 3511, VietNamDivisionType.XA, "xa_ta_phin", 108)
    W_3514 = Ward("Xã Sà Dề Phìn", 3514, VietNamDivisionType.XA, "xa_sa_de_phin", 108)
    W_3517 = Ward("Xã Nậm Tăm", 3517, VietNamDivisionType.XA, "xa_nam_tam", 108)
    W_3520 = Ward("Xã Tả Ngảo", 3520, VietNamDivisionType.XA, "xa_ta_ngao", 108)
    W_3523 = Ward("Xã Pu Sam Cáp", 3523, VietNamDivisionType.XA, "xa_pu_sam_cap", 108)
    W_3526 = Ward("Xã Nậm Cha", 3526, VietNamDivisionType.XA, "xa_nam_cha", 108)
    W_3527 = Ward("Xã Pa Khoá", 3527, VietNamDivisionType.XA, "xa_pa_khoa", 108)
    W_3529 = Ward("Xã Làng Mô", 3529, VietNamDivisionType.XA, "xa_lang_mo", 108)
    W_3532 = Ward("Xã Noong Hẻo", 3532, VietNamDivisionType.XA, "xa_noong_heo", 108)
    W_3535 = Ward("Xã Nậm Mạ", 3535, VietNamDivisionType.XA, "xa_nam_ma", 108)
    W_3538 = Ward("Xã Căn Co", 3538, VietNamDivisionType.XA, "xa_can_co", 108)
    W_3541 = Ward("Xã Tủa Sín Chải", 3541, VietNamDivisionType.XA, "xa_tua_sin_chai", 108)
    W_3544 = Ward("Xã Nậm Cuổi", 3544, VietNamDivisionType.XA, "xa_nam_cuoi", 108)
    W_3547 = Ward("Xã Nậm Hăn", 3547, VietNamDivisionType.XA, "xa_nam_han", 108)
    W_3391 = Ward("Xã Lả Nhì Thàng", 3391, VietNamDivisionType.XA, "xa_la_nhi_thang", 109)
    W_3490 = Ward("Xã Huổi Luông", 3490, VietNamDivisionType.XA, "xa_huoi_luong", 109)
    W_3549 = Ward("Thị trấn Phong Thổ", 3549, VietNamDivisionType.THI_TRAN, "thi_tran_phong_tho", 109)
    W_3550 = Ward("Xã Sì Lở Lầu", 3550, VietNamDivisionType.XA, "xa_si_lo_lau", 109)
    W_3553 = Ward("Xã Mồ Sì San", 3553, VietNamDivisionType.XA, "xa_mo_si_san", 109)
    W_3559 = Ward("Xã Pa Vây Sử", 3559, VietNamDivisionType.XA, "xa_pa_vay_su", 109)
    W_3562 = Ward("Xã Vàng Ma Chải", 3562, VietNamDivisionType.XA, "xa_vang_ma_chai", 109)
    W_3565 = Ward("Xã Tông Qua Lìn", 3565, VietNamDivisionType.XA, "xa_tong_qua_lin", 109)
    W_3568 = Ward("Xã Mù Sang", 3568, VietNamDivisionType.XA, "xa_mu_sang", 109)
    W_3571 = Ward("Xã Dào San", 3571, VietNamDivisionType.XA, "xa_dao_san", 109)
    W_3574 = Ward("Xã Ma Ly Pho", 3574, VietNamDivisionType.XA, "xa_ma_ly_pho", 109)
    W_3577 = Ward("Xã Bản Lang", 3577, VietNamDivisionType.XA, "xa_ban_lang", 109)
    W_3580 = Ward("Xã Hoang Thèn", 3580, VietNamDivisionType.XA, "xa_hoang_then", 109)
    W_3583 = Ward("Xã Khổng Lào", 3583, VietNamDivisionType.XA, "xa_khong_lao", 109)
    W_3586 = Ward("Xã Nậm Xe", 3586, VietNamDivisionType.XA, "xa_nam_xe", 109)
    W_3589 = Ward("Xã Mường So", 3589, VietNamDivisionType.XA, "xa_muong_so", 109)
    W_3592 = Ward("Xã Sin Suối Hồ", 3592, VietNamDivisionType.XA, "xa_sin_suoi_ho", 109)
    W_3595 = Ward("Thị trấn Than Uyên", 3595, VietNamDivisionType.THI_TRAN, "thi_tran_than_uyen", 110)
    W_3618 = Ward("Xã Phúc Than", 3618, VietNamDivisionType.XA, "xa_phuc_than", 110)
    W_3619 = Ward("Xã Mường Than", 3619, VietNamDivisionType.XA, "xa_muong_than", 110)
    W_3625 = Ward("Xã Mường Mít", 3625, VietNamDivisionType.XA, "xa_muong_mit", 110)
    W_3628 = Ward("Xã Pha Mu", 3628, VietNamDivisionType.XA, "xa_pha_mu", 110)
    W_3631 = Ward("Xã Mường Cang", 3631, VietNamDivisionType.XA, "xa_muong_cang", 110)
    W_3632 = Ward("Xã Hua Nà", 3632, VietNamDivisionType.XA, "xa_hua_na", 110)
    W_3634 = Ward("Xã Tà Hừa", 3634, VietNamDivisionType.XA, "xa_ta_hua", 110)
    W_3637 = Ward("Xã Mường Kim", 3637, VietNamDivisionType.XA, "xa_muong_kim", 110)
    W_3638 = Ward("Xã Tà Mung", 3638, VietNamDivisionType.XA, "xa_ta_mung", 110)
    W_3640 = Ward("Xã Tà Gia", 3640, VietNamDivisionType.XA, "xa_ta_gia", 110)
    W_3643 = Ward("Xã Khoen On", 3643, VietNamDivisionType.XA, "xa_khoen_on", 110)
    W_3598 = Ward("Thị trấn Tân Uyên", 3598, VietNamDivisionType.THI_TRAN, "thi_tran_tan_uyen", 111)
    W_3601 = Ward("Xã Mường Khoa", 3601, VietNamDivisionType.XA, "xa_muong_khoa", 111)
    W_3602 = Ward("Xã Phúc Khoa", 3602, VietNamDivisionType.XA, "xa_phuc_khoa", 111)
    W_3604 = Ward("Xã Thân Thuộc", 3604, VietNamDivisionType.XA, "xa_than_thuoc", 111)
    W_3605 = Ward("Xã Trung Đồng", 3605, VietNamDivisionType.XA, "xa_trung_dong", 111)
    W_3607 = Ward("Xã Hố Mít", 3607, VietNamDivisionType.XA, "xa_ho_mit", 111)
    W_3610 = Ward("Xã Nậm Cần", 3610, VietNamDivisionType.XA, "xa_nam_can", 111)
    W_3613 = Ward("Xã Nậm Sỏ", 3613, VietNamDivisionType.XA, "xa_nam_so", 111)
    W_3616 = Ward("Xã Pắc Ta", 3616, VietNamDivisionType.XA, "xa_pac_ta", 111)
    W_3622 = Ward("Xã Tà Mít", 3622, VietNamDivisionType.XA, "xa_ta_mit", 111)
    W_3434 = Ward("Thị trấn Nậm Nhùn", 3434, VietNamDivisionType.THI_TRAN, "thi_tran_nam_nhun", 112)
    W_3460 = Ward("Xã Hua Bun", 3460, VietNamDivisionType.XA, "xa_hua_bun", 112)
    W_3472 = Ward("Xã Mường Mô", 3472, VietNamDivisionType.XA, "xa_muong_mo", 112)
    W_3473 = Ward("Xã Nậm Chà", 3473, VietNamDivisionType.XA, "xa_nam_cha", 112)
    W_3474 = Ward("Xã Nậm Manh", 3474, VietNamDivisionType.XA, "xa_nam_manh", 112)
    W_3475 = Ward("Xã Nậm Hàng", 3475, VietNamDivisionType.XA, "xa_nam_hang", 112)
    W_3481 = Ward("Xã Lê Lợi", 3481, VietNamDivisionType.XA, "xa_le_loi", 112)
    W_3484 = Ward("Xã Pú Đao", 3484, VietNamDivisionType.XA, "xa_pu_dao", 112)
    W_3488 = Ward("Xã Nậm Pì", 3488, VietNamDivisionType.XA, "xa_nam_pi", 112)
    W_3502 = Ward("Xã Nậm Ban", 3502, VietNamDivisionType.XA, "xa_nam_ban", 112)
    W_3503 = Ward("Xã Trung Chải", 3503, VietNamDivisionType.XA, "xa_trung_chai", 112)
    W_3646 = Ward("Phường Chiềng Lề", 3646, VietNamDivisionType.PHUONG, "phuong_chieng_le", 116)
    W_3649 = Ward("Phường Tô Hiệu", 3649, VietNamDivisionType.PHUONG, "phuong_to_hieu", 116)
    W_3652 = Ward("Phường Quyết Thắng", 3652, VietNamDivisionType.PHUONG, "phuong_quyet_thang", 116)
    W_3655 = Ward("Phường Quyết Tâm", 3655, VietNamDivisionType.PHUONG, "phuong_quyet_tam", 116)
    W_3658 = Ward("Xã Chiềng Cọ", 3658, VietNamDivisionType.XA, "xa_chieng_co", 116)
    W_3661 = Ward("Xã Chiềng Đen", 3661, VietNamDivisionType.XA, "xa_chieng_den", 116)
    W_3664 = Ward("Xã Chiềng Xôm", 3664, VietNamDivisionType.XA, "xa_chieng_xom", 116)
    W_3667 = Ward("Phường Chiềng An", 3667, VietNamDivisionType.PHUONG, "phuong_chieng_an", 116)
    W_3670 = Ward("Phường Chiềng Cơi", 3670, VietNamDivisionType.PHUONG, "phuong_chieng_coi", 116)
    W_3673 = Ward("Xã Chiềng Ngần", 3673, VietNamDivisionType.XA, "xa_chieng_ngan", 116)
    W_3676 = Ward("Xã Hua La", 3676, VietNamDivisionType.XA, "xa_hua_la", 116)
    W_3679 = Ward("Phường Chiềng Sinh", 3679, VietNamDivisionType.PHUONG, "phuong_chieng_sinh", 116)
    W_3682 = Ward("Xã Mường Chiên", 3682, VietNamDivisionType.XA, "xa_muong_chien", 118)
    W_3685 = Ward("Xã Cà Nàng", 3685, VietNamDivisionType.XA, "xa_ca_nang", 118)
    W_3688 = Ward("Xã Chiềng Khay", 3688, VietNamDivisionType.XA, "xa_chieng_khay", 118)
    W_3694 = Ward("Xã Mường Giôn", 3694, VietNamDivisionType.XA, "xa_muong_gion", 118)
    W_3697 = Ward("Xã Pá Ma Pha Khinh", 3697, VietNamDivisionType.XA, "xa_pa_ma_pha_khinh", 118)
    W_3700 = Ward("Xã Chiềng Ơn", 3700, VietNamDivisionType.XA, "xa_chieng_on", 118)
    W_3703 = Ward("Xã Mường Giàng", 3703, VietNamDivisionType.XA, "xa_muong_giang", 118)
    W_3706 = Ward("Xã Chiềng Bằng", 3706, VietNamDivisionType.XA, "xa_chieng_bang", 118)
    W_3709 = Ward("Xã Mường Sại", 3709, VietNamDivisionType.XA, "xa_muong_sai", 118)
    W_3712 = Ward("Xã Nậm ét", 3712, VietNamDivisionType.XA, "xa_nam_et", 118)
    W_3718 = Ward("Xã Chiềng Khoang", 3718, VietNamDivisionType.XA, "xa_chieng_khoang", 118)
    W_3721 = Ward("Thị trấn Thuận Châu", 3721, VietNamDivisionType.THI_TRAN, "thi_tran_thuan_chau", 119)
    W_3724 = Ward("Xã Phổng Lái", 3724, VietNamDivisionType.XA, "xa_phong_lai", 119)
    W_3727 = Ward("Xã Mường é", 3727, VietNamDivisionType.XA, "xa_muong_e", 119)
    W_3730 = Ward("Xã Chiềng Pha", 3730, VietNamDivisionType.XA, "xa_chieng_pha", 119)
    W_3733 = Ward("Xã Chiềng La", 3733, VietNamDivisionType.XA, "xa_chieng_la", 119)
    W_3736 = Ward("Xã Chiềng Ngàm", 3736, VietNamDivisionType.XA, "xa_chieng_ngam", 119)
    W_3739 = Ward("Xã Liệp Tè", 3739, VietNamDivisionType.XA, "xa_liep_te", 119)
    W_3742 = Ward("Xã é Tòng", 3742, VietNamDivisionType.XA, "xa_e_tong", 119)
    W_3745 = Ward("Xã Phổng Lập", 3745, VietNamDivisionType.XA, "xa_phong_lap", 119)
    W_3748 = Ward("Xã Phổng Lăng", 3748, VietNamDivisionType.XA, "xa_phong_lang", 119)
    W_3751 = Ward("Xã Chiềng Ly", 3751, VietNamDivisionType.XA, "xa_chieng_ly", 119)
    W_3754 = Ward("Xã Noong Lay", 3754, VietNamDivisionType.XA, "xa_noong_lay", 119)
    W_3757 = Ward("Xã Mường Khiêng", 3757, VietNamDivisionType.XA, "xa_muong_khieng", 119)
    W_3760 = Ward("Xã Mường Bám", 3760, VietNamDivisionType.XA, "xa_muong_bam", 119)
    W_3763 = Ward("Xã Long Hẹ", 3763, VietNamDivisionType.XA, "xa_long_he", 119)
    W_3766 = Ward("Xã Chiềng Bôm", 3766, VietNamDivisionType.XA, "xa_chieng_bom", 119)
    W_3769 = Ward("Xã Thôm Mòn", 3769, VietNamDivisionType.XA, "xa_thom_mon", 119)
    W_3772 = Ward("Xã Tông Lạnh", 3772, VietNamDivisionType.XA, "xa_tong_lanh", 119)
    W_3775 = Ward("Xã Tông Cọ", 3775, VietNamDivisionType.XA, "xa_tong_co", 119)
    W_3778 = Ward("Xã Bó Mười", 3778, VietNamDivisionType.XA, "xa_bo_muoi", 119)
    W_3781 = Ward("Xã Co Mạ", 3781, VietNamDivisionType.XA, "xa_co_ma", 119)
    W_3784 = Ward("Xã Púng Tra", 3784, VietNamDivisionType.XA, "xa_pung_tra", 119)
    W_3787 = Ward("Xã Chiềng Pấc", 3787, VietNamDivisionType.XA, "xa_chieng_pac", 119)
    W_3790 = Ward("Xã Nậm Lầu", 3790, VietNamDivisionType.XA, "xa_nam_lau", 119)
    W_3793 = Ward("Xã Bon Phặng", 3793, VietNamDivisionType.XA, "xa_bon_phang", 119)
    W_3796 = Ward("Xã Co Tòng", 3796, VietNamDivisionType.XA, "xa_co_tong", 119)
    W_3799 = Ward("Xã Muổi Nọi", 3799, VietNamDivisionType.XA, "xa_muoi_noi", 119)
    W_3802 = Ward("Xã Pá Lông", 3802, VietNamDivisionType.XA, "xa_pa_long", 119)
    W_3805 = Ward("Xã Bản Lầm", 3805, VietNamDivisionType.XA, "xa_ban_lam", 119)
    W_3808 = Ward("Thị trấn Ít Ong", 3808, VietNamDivisionType.THI_TRAN, "thi_tran_it_ong", 120)
    W_3811 = Ward("Xã Nậm Giôn", 3811, VietNamDivisionType.XA, "xa_nam_gion", 120)
    W_3814 = Ward("Xã Chiềng Lao", 3814, VietNamDivisionType.XA, "xa_chieng_lao", 120)
    W_3817 = Ward("Xã Hua Trai", 3817, VietNamDivisionType.XA, "xa_hua_trai", 120)
    W_3820 = Ward("Xã Ngọc Chiến", 3820, VietNamDivisionType.XA, "xa_ngoc_chien", 120)
    W_3823 = Ward("Xã Mường Trai", 3823, VietNamDivisionType.XA, "xa_muong_trai", 120)
    W_3826 = Ward("Xã Nậm Păm", 3826, VietNamDivisionType.XA, "xa_nam_pam", 120)
    W_3829 = Ward("Xã Chiềng Muôn", 3829, VietNamDivisionType.XA, "xa_chieng_muon", 120)
    W_3832 = Ward("Xã Chiềng Ân", 3832, VietNamDivisionType.XA, "xa_chieng_an", 120)
    W_3835 = Ward("Xã Pi Toong", 3835, VietNamDivisionType.XA, "xa_pi_toong", 120)
    W_3838 = Ward("Xã Chiềng Công", 3838, VietNamDivisionType.XA, "xa_chieng_cong", 120)
    W_3841 = Ward("Xã Tạ Bú", 3841, VietNamDivisionType.XA, "xa_ta_bu", 120)
    W_3844 = Ward("Xã Chiềng San", 3844, VietNamDivisionType.XA, "xa_chieng_san", 120)
    W_3847 = Ward("Xã Mường Bú", 3847, VietNamDivisionType.XA, "xa_muong_bu", 120)
    W_3850 = Ward("Xã Chiềng Hoa", 3850, VietNamDivisionType.XA, "xa_chieng_hoa", 120)
    W_3853 = Ward("Xã Mường Chùm", 3853, VietNamDivisionType.XA, "xa_muong_chum", 120)
    W_3856 = Ward("Thị trấn Bắc Yên", 3856, VietNamDivisionType.THI_TRAN, "thi_tran_bac_yen", 121)
    W_3859 = Ward("Xã Phiêng Ban", 3859, VietNamDivisionType.XA, "xa_phieng_ban", 121)
    W_3862 = Ward("Xã Hang Chú", 3862, VietNamDivisionType.XA, "xa_hang_chu", 121)
    W_3865 = Ward("Xã Xím Vàng", 3865, VietNamDivisionType.XA, "xa_xim_vang", 121)
    W_3868 = Ward("Xã Tà Xùa", 3868, VietNamDivisionType.XA, "xa_ta_xua", 121)
    W_3869 = Ward("Xã Háng Đồng", 3869, VietNamDivisionType.XA, "xa_hang_dong", 121)
    W_3871 = Ward("Xã Pắc Ngà", 3871, VietNamDivisionType.XA, "xa_pac_nga", 121)
    W_3874 = Ward("Xã Làng Chếu", 3874, VietNamDivisionType.XA, "xa_lang_cheu", 121)
    W_3877 = Ward("Xã Chim Vàn", 3877, VietNamDivisionType.XA, "xa_chim_van", 121)
    W_3880 = Ward("Xã Mường Khoa", 3880, VietNamDivisionType.XA, "xa_muong_khoa", 121)
    W_3883 = Ward("Xã Song Pe", 3883, VietNamDivisionType.XA, "xa_song_pe", 121)
    W_3886 = Ward("Xã Hồng Ngài", 3886, VietNamDivisionType.XA, "xa_hong_ngai", 121)
    W_3889 = Ward("Xã Tạ Khoa", 3889, VietNamDivisionType.XA, "xa_ta_khoa", 121)
    W_3890 = Ward("Xã Hua Nhàn", 3890, VietNamDivisionType.XA, "xa_hua_nhan", 121)
    W_3892 = Ward("Xã Phiêng Côn", 3892, VietNamDivisionType.XA, "xa_phieng_con", 121)
    W_3895 = Ward("Xã Chiềng Sại", 3895, VietNamDivisionType.XA, "xa_chieng_sai", 121)
    W_3898 = Ward("Thị trấn Phù Yên", 3898, VietNamDivisionType.THI_TRAN, "thi_tran_phu_yen", 122)
    W_3901 = Ward("Xã Suối Tọ", 3901, VietNamDivisionType.XA, "xa_suoi_to", 122)
    W_3904 = Ward("Xã Mường Thải", 3904, VietNamDivisionType.XA, "xa_muong_thai", 122)
    W_3907 = Ward("Xã Mường Cơi", 3907, VietNamDivisionType.XA, "xa_muong_coi", 122)
    W_3910 = Ward("Xã Quang Huy", 3910, VietNamDivisionType.XA, "xa_quang_huy", 122)
    W_3913 = Ward("Xã Huy Bắc", 3913, VietNamDivisionType.XA, "xa_huy_bac", 122)
    W_3916 = Ward("Xã Huy Thượng", 3916, VietNamDivisionType.XA, "xa_huy_thuong", 122)
    W_3919 = Ward("Xã Tân Lang", 3919, VietNamDivisionType.XA, "xa_tan_lang", 122)
    W_3922 = Ward("Xã Gia Phù", 3922, VietNamDivisionType.XA, "xa_gia_phu", 122)
    W_3925 = Ward("Xã Tường Phù", 3925, VietNamDivisionType.XA, "xa_tuong_phu", 122)
    W_3928 = Ward("Xã Huy Hạ", 3928, VietNamDivisionType.XA, "xa_huy_ha", 122)
    W_3931 = Ward("Xã Huy Tân", 3931, VietNamDivisionType.XA, "xa_huy_tan", 122)
    W_3934 = Ward("Xã Mường Lang", 3934, VietNamDivisionType.XA, "xa_muong_lang", 122)
    W_3937 = Ward("Xã Suối Bau", 3937, VietNamDivisionType.XA, "xa_suoi_bau", 122)
    W_3940 = Ward("Xã Huy Tường", 3940, VietNamDivisionType.XA, "xa_huy_tuong", 122)
    W_3943 = Ward("Xã Mường Do", 3943, VietNamDivisionType.XA, "xa_muong_do", 122)
    W_3946 = Ward("Xã Sập Xa", 3946, VietNamDivisionType.XA, "xa_sap_xa", 122)
    W_3949 = Ward("Xã Tường Thượng", 3949, VietNamDivisionType.XA, "xa_tuong_thuong", 122)
    W_3952 = Ward("Xã Tường Tiến", 3952, VietNamDivisionType.XA, "xa_tuong_tien", 122)
    W_3955 = Ward("Xã Tường Phong", 3955, VietNamDivisionType.XA, "xa_tuong_phong", 122)
    W_3958 = Ward("Xã Tường Hạ", 3958, VietNamDivisionType.XA, "xa_tuong_ha", 122)
    W_3961 = Ward("Xã Kim Bon", 3961, VietNamDivisionType.XA, "xa_kim_bon", 122)
    W_3964 = Ward("Xã Mường Bang", 3964, VietNamDivisionType.XA, "xa_muong_bang", 122)
    W_3967 = Ward("Xã Đá Đỏ", 3967, VietNamDivisionType.XA, "xa_da_do", 122)
    W_3970 = Ward("Xã Tân Phong", 3970, VietNamDivisionType.XA, "xa_tan_phong", 122)
    W_3973 = Ward("Xã Nam Phong", 3973, VietNamDivisionType.XA, "xa_nam_phong", 122)
    W_3976 = Ward("Xã Bắc Phong", 3976, VietNamDivisionType.XA, "xa_bac_phong", 122)
    W_3979 = Ward("Thị trấn Mộc Châu", 3979, VietNamDivisionType.THI_TRAN, "thi_tran_moc_chau", 123)
    W_3982 = Ward("Thị trấn NT Mộc Châu", 3982, VietNamDivisionType.THI_TRAN, "thi_tran_nt_moc_chau", 123)
    W_3985 = Ward("Xã Chiềng Sơn", 3985, VietNamDivisionType.XA, "xa_chieng_son", 123)
    W_3988 = Ward("Xã Tân Hợp", 3988, VietNamDivisionType.XA, "xa_tan_hop", 123)
    W_3991 = Ward("Xã Qui Hướng", 3991, VietNamDivisionType.XA, "xa_qui_huong", 123)
    W_3997 = Ward("Xã Tân Lập", 3997, VietNamDivisionType.XA, "xa_tan_lap", 123)
    W_4000 = Ward("Xã Nà Mường", 4000, VietNamDivisionType.XA, "xa_na_muong", 123)
    W_4003 = Ward("Xã Tà Lai", 4003, VietNamDivisionType.XA, "xa_ta_lai", 123)
    W_4012 = Ward("Xã Chiềng Hắc", 4012, VietNamDivisionType.XA, "xa_chieng_hac", 123)
    W_4015 = Ward("Xã Hua Păng", 4015, VietNamDivisionType.XA, "xa_hua_pang", 123)
    W_4024 = Ward("Xã Chiềng Khừa", 4024, VietNamDivisionType.XA, "xa_chieng_khua", 123)
    W_4027 = Ward("Xã Mường Sang", 4027, VietNamDivisionType.XA, "xa_muong_sang", 123)
    W_4030 = Ward("Xã Đông Sang", 4030, VietNamDivisionType.XA, "xa_dong_sang", 123)
    W_4033 = Ward("Xã Phiêng Luông", 4033, VietNamDivisionType.XA, "xa_phieng_luong", 123)
    W_4045 = Ward("Xã Lóng Sập", 4045, VietNamDivisionType.XA, "xa_long_sap", 123)
    W_4060 = Ward("Thị trấn Yên Châu", 4060, VietNamDivisionType.THI_TRAN, "thi_tran_yen_chau", 124)
    W_4063 = Ward("Xã Chiềng Đông", 4063, VietNamDivisionType.XA, "xa_chieng_dong", 124)
    W_4066 = Ward("Xã Sập Vạt", 4066, VietNamDivisionType.XA, "xa_sap_vat", 124)
    W_4069 = Ward("Xã Chiềng Sàng", 4069, VietNamDivisionType.XA, "xa_chieng_sang", 124)
    W_4072 = Ward("Xã Chiềng Pằn", 4072, VietNamDivisionType.XA, "xa_chieng_pan", 124)
    W_4075 = Ward("Xã Viêng Lán", 4075, VietNamDivisionType.XA, "xa_vieng_lan", 124)
    W_4078 = Ward("Xã Chiềng Hặc", 4078, VietNamDivisionType.XA, "xa_chieng_hac", 124)
    W_4081 = Ward("Xã Mường Lựm", 4081, VietNamDivisionType.XA, "xa_muong_lum", 124)
    W_4084 = Ward("Xã Chiềng On", 4084, VietNamDivisionType.XA, "xa_chieng_on", 124)
    W_4087 = Ward("Xã Yên Sơn", 4087, VietNamDivisionType.XA, "xa_yen_son", 124)
    W_4090 = Ward("Xã Chiềng Khoi", 4090, VietNamDivisionType.XA, "xa_chieng_khoi", 124)
    W_4093 = Ward("Xã Tú Nang", 4093, VietNamDivisionType.XA, "xa_tu_nang", 124)
    W_4096 = Ward("Xã Lóng Phiêng", 4096, VietNamDivisionType.XA, "xa_long_phieng", 124)
    W_4099 = Ward("Xã Phiêng Khoài", 4099, VietNamDivisionType.XA, "xa_phieng_khoai", 124)
    W_4102 = Ward("Xã Chiềng Tương", 4102, VietNamDivisionType.XA, "xa_chieng_tuong", 124)
    W_4105 = Ward("Thị trấn Hát Lót", 4105, VietNamDivisionType.THI_TRAN, "thi_tran_hat_lot", 125)
    W_4108 = Ward("Xã Chiềng Sung", 4108, VietNamDivisionType.XA, "xa_chieng_sung", 125)
    W_4111 = Ward("Xã Mường Bằng", 4111, VietNamDivisionType.XA, "xa_muong_bang", 125)
    W_4114 = Ward("Xã Chiềng Chăn", 4114, VietNamDivisionType.XA, "xa_chieng_chan", 125)
    W_4117 = Ward("Xã Mương Chanh", 4117, VietNamDivisionType.XA, "xa_muong_chanh", 125)
    W_4120 = Ward("Xã Chiềng Ban", 4120, VietNamDivisionType.XA, "xa_chieng_ban", 125)
    W_4123 = Ward("Xã Chiềng Mung", 4123, VietNamDivisionType.XA, "xa_chieng_mung", 125)
    W_4126 = Ward("Xã Mường Bon", 4126, VietNamDivisionType.XA, "xa_muong_bon", 125)
    W_4129 = Ward("Xã Chiềng Chung", 4129, VietNamDivisionType.XA, "xa_chieng_chung", 125)
    W_4132 = Ward("Xã Chiềng Mai", 4132, VietNamDivisionType.XA, "xa_chieng_mai", 125)
    W_4135 = Ward("Xã Hát Lót", 4135, VietNamDivisionType.XA, "xa_hat_lot", 125)
    W_4136 = Ward("Xã Nà Pó", 4136, VietNamDivisionType.XA, "xa_na_po", 125)
    W_4138 = Ward("Xã Cò Nòi", 4138, VietNamDivisionType.XA, "xa_co_noi", 125)
    W_4141 = Ward("Xã Chiềng Nơi", 4141, VietNamDivisionType.XA, "xa_chieng_noi", 125)
    W_4144 = Ward("Xã Phiêng Cằm", 4144, VietNamDivisionType.XA, "xa_phieng_cam", 125)
    W_4147 = Ward("Xã Chiềng Dong", 4147, VietNamDivisionType.XA, "xa_chieng_dong", 125)
    W_4150 = Ward("Xã Chiềng Kheo", 4150, VietNamDivisionType.XA, "xa_chieng_kheo", 125)
    W_4153 = Ward("Xã Chiềng Ve", 4153, VietNamDivisionType.XA, "xa_chieng_ve", 125)
    W_4156 = Ward("Xã Chiềng Lương", 4156, VietNamDivisionType.XA, "xa_chieng_luong", 125)
    W_4159 = Ward("Xã Phiêng Pằn", 4159, VietNamDivisionType.XA, "xa_phieng_pan", 125)
    W_4162 = Ward("Xã Nà Ơt", 4162, VietNamDivisionType.XA, "xa_na_ot", 125)
    W_4165 = Ward("Xã Tà Hộc", 4165, VietNamDivisionType.XA, "xa_ta_hoc", 125)
    W_4168 = Ward("Thị trấn Sông Mã", 4168, VietNamDivisionType.THI_TRAN, "thi_tran_song_ma", 126)
    W_4171 = Ward("Xã Bó Sinh", 4171, VietNamDivisionType.XA, "xa_bo_sinh", 126)
    W_4174 = Ward("Xã Pú Pẩu", 4174, VietNamDivisionType.XA, "xa_pu_pau", 126)
    W_4177 = Ward("Xã Chiềng Phung", 4177, VietNamDivisionType.XA, "xa_chieng_phung", 126)
    W_4180 = Ward("Xã Chiềng En", 4180, VietNamDivisionType.XA, "xa_chieng_en", 126)
    W_4183 = Ward("Xã Mường Lầm", 4183, VietNamDivisionType.XA, "xa_muong_lam", 126)
    W_4186 = Ward("Xã Nậm Ty", 4186, VietNamDivisionType.XA, "xa_nam_ty", 126)
    W_4189 = Ward("Xã Đứa Mòn", 4189, VietNamDivisionType.XA, "xa_dua_mon", 126)
    W_4192 = Ward("Xã Yên Hưng", 4192, VietNamDivisionType.XA, "xa_yen_hung", 126)
    W_4195 = Ward("Xã Chiềng Sơ", 4195, VietNamDivisionType.XA, "xa_chieng_so", 126)
    W_4198 = Ward("Xã Nà Nghịu", 4198, VietNamDivisionType.XA, "xa_na_nghiu", 126)
    W_4201 = Ward("Xã Nậm Mằn", 4201, VietNamDivisionType.XA, "xa_nam_man", 126)
    W_4204 = Ward("Xã Chiềng Khoong", 4204, VietNamDivisionType.XA, "xa_chieng_khoong", 126)
    W_4207 = Ward("Xã Chiềng Cang", 4207, VietNamDivisionType.XA, "xa_chieng_cang", 126)
    W_4210 = Ward("Xã Huổi Một", 4210, VietNamDivisionType.XA, "xa_huoi_mot", 126)
    W_4213 = Ward("Xã Mường Sai", 4213, VietNamDivisionType.XA, "xa_muong_sai", 126)
    W_4216 = Ward("Xã Mường Cai", 4216, VietNamDivisionType.XA, "xa_muong_cai", 126)
    W_4219 = Ward("Xã Mường Hung", 4219, VietNamDivisionType.XA, "xa_muong_hung", 126)
    W_4222 = Ward("Xã Chiềng Khương", 4222, VietNamDivisionType.XA, "xa_chieng_khuong", 126)
    W_4225 = Ward("Xã Sam Kha", 4225, VietNamDivisionType.XA, "xa_sam_kha", 127)
    W_4228 = Ward("Xã Púng Bánh", 4228, VietNamDivisionType.XA, "xa_pung_banh", 127)
    W_4231 = Ward("Xã Sốp Cộp", 4231, VietNamDivisionType.XA, "xa_sop_cop", 127)
    W_4234 = Ward("Xã Dồm Cang", 4234, VietNamDivisionType.XA, "xa_dom_cang", 127)
    W_4237 = Ward("Xã Nậm Lạnh", 4237, VietNamDivisionType.XA, "xa_nam_lanh", 127)
    W_4240 = Ward("Xã Mường Lèo", 4240, VietNamDivisionType.XA, "xa_muong_leo", 127)
    W_4243 = Ward("Xã Mường Và", 4243, VietNamDivisionType.XA, "xa_muong_va", 127)
    W_4246 = Ward("Xã Mường Lạn", 4246, VietNamDivisionType.XA, "xa_muong_lan", 127)
    W_3994 = Ward("Xã Suối Bàng", 3994, VietNamDivisionType.XA, "xa_suoi_bang", 128)
    W_4006 = Ward("Xã Song Khủa", 4006, VietNamDivisionType.XA, "xa_song_khua", 128)
    W_4009 = Ward("Xã Liên Hoà", 4009, VietNamDivisionType.XA, "xa_lien_hoa", 128)
    W_4018 = Ward("Xã Tô Múa", 4018, VietNamDivisionType.XA, "xa_to_mua", 128)
    W_4021 = Ward("Xã Mường Tè", 4021, VietNamDivisionType.XA, "xa_muong_te", 128)
    W_4036 = Ward("Xã Chiềng Khoa", 4036, VietNamDivisionType.XA, "xa_chieng_khoa", 128)
    W_4039 = Ward("Xã Mường Men", 4039, VietNamDivisionType.XA, "xa_muong_men", 128)
    W_4042 = Ward("Xã Quang Minh", 4042, VietNamDivisionType.XA, "xa_quang_minh", 128)
    W_4048 = Ward("Xã Vân Hồ", 4048, VietNamDivisionType.XA, "xa_van_ho", 128)
    W_4051 = Ward("Xã Lóng Luông", 4051, VietNamDivisionType.XA, "xa_long_luong", 128)
    W_4054 = Ward("Xã Chiềng Yên", 4054, VietNamDivisionType.XA, "xa_chieng_yen", 128)
    W_4056 = Ward("Xã Chiềng Xuân", 4056, VietNamDivisionType.XA, "xa_chieng_xuan", 128)
    W_4057 = Ward("Xã Xuân Nha", 4057, VietNamDivisionType.XA, "xa_xuan_nha", 128)
    W_4058 = Ward("Xã Tân Xuân", 4058, VietNamDivisionType.XA, "xa_tan_xuan", 128)
    W_4249 = Ward("Phường Yên Thịnh", 4249, VietNamDivisionType.PHUONG, "phuong_yen_thinh", 132)
    W_4252 = Ward("Phường Yên Ninh", 4252, VietNamDivisionType.PHUONG, "phuong_yen_ninh", 132)
    W_4255 = Ward("Phường Minh Tân", 4255, VietNamDivisionType.PHUONG, "phuong_minh_tan", 132)
    W_4258 = Ward("Phường Nguyễn Thái Học", 4258, VietNamDivisionType.PHUONG, "phuong_nguyen_thai_hoc", 132)
    W_4261 = Ward("Phường Đồng Tâm", 4261, VietNamDivisionType.PHUONG, "phuong_dong_tam", 132)
    W_4264 = Ward("Phường Nguyễn Phúc", 4264, VietNamDivisionType.PHUONG, "phuong_nguyen_phuc", 132)
    W_4267 = Ward("Phường Hồng Hà", 4267, VietNamDivisionType.PHUONG, "phuong_hong_ha", 132)
    W_4270 = Ward("Xã Minh Bảo", 4270, VietNamDivisionType.XA, "xa_minh_bao", 132)
    W_4273 = Ward("Phường Nam Cường", 4273, VietNamDivisionType.PHUONG, "phuong_nam_cuong", 132)
    W_4276 = Ward("Xã Tuy Lộc", 4276, VietNamDivisionType.XA, "xa_tuy_loc", 132)
    W_4279 = Ward("Xã Tân Thịnh", 4279, VietNamDivisionType.XA, "xa_tan_thinh", 132)
    W_4540 = Ward("Xã Âu Lâu", 4540, VietNamDivisionType.XA, "xa_au_lau", 132)
    W_4543 = Ward("Xã Giới Phiên", 4543, VietNamDivisionType.XA, "xa_gioi_phien", 132)
    W_4546 = Ward("Phường Hợp Minh", 4546, VietNamDivisionType.PHUONG, "phuong_hop_minh", 132)
    W_4558 = Ward("Xã Văn Phú", 4558, VietNamDivisionType.XA, "xa_van_phu", 132)
    W_4282 = Ward("Phường Pú Trạng", 4282, VietNamDivisionType.PHUONG, "phuong_pu_trang", 133)
    W_4285 = Ward("Phường Trung Tâm", 4285, VietNamDivisionType.PHUONG, "phuong_trung_tam", 133)
    W_4288 = Ward("Phường Tân An", 4288, VietNamDivisionType.PHUONG, "phuong_tan_an", 133)
    W_4291 = Ward("Phường Cầu Thia", 4291, VietNamDivisionType.PHUONG, "phuong_cau_thia", 133)
    W_4294 = Ward("Xã Nghĩa Lợi", 4294, VietNamDivisionType.XA, "xa_nghia_loi", 133)
    W_4297 = Ward("Xã Nghĩa Phúc", 4297, VietNamDivisionType.XA, "xa_nghia_phuc", 133)
    W_4300 = Ward("Xã Nghĩa An", 4300, VietNamDivisionType.XA, "xa_nghia_an", 133)
    W_4624 = Ward("Xã Nghĩa Lộ", 4624, VietNamDivisionType.XA, "xa_nghia_lo", 133)
    W_4660 = Ward("Xã Sơn A", 4660, VietNamDivisionType.XA, "xa_son_a", 133)
    W_4663 = Ward("Xã Phù Nham", 4663, VietNamDivisionType.XA, "xa_phu_nham", 133)
    W_4675 = Ward("Xã Thanh Lương", 4675, VietNamDivisionType.XA, "xa_thanh_luong", 133)
    W_4678 = Ward("Xã Hạnh Sơn", 4678, VietNamDivisionType.XA, "xa_hanh_son", 133)
    W_4681 = Ward("Xã Phúc Sơn", 4681, VietNamDivisionType.XA, "xa_phuc_son", 133)
    W_4684 = Ward("Xã Thạch Lương", 4684, VietNamDivisionType.XA, "xa_thach_luong", 133)
    W_4303 = Ward("Thị trấn Yên Thế", 4303, VietNamDivisionType.THI_TRAN, "thi_tran_yen_the", 135)
    W_4306 = Ward("Xã Tân Phượng", 4306, VietNamDivisionType.XA, "xa_tan_phuong", 135)
    W_4309 = Ward("Xã Lâm Thượng", 4309, VietNamDivisionType.XA, "xa_lam_thuong", 135)
    W_4312 = Ward("Xã Khánh Thiện", 4312, VietNamDivisionType.XA, "xa_khanh_thien", 135)
    W_4315 = Ward("Xã Minh Chuẩn", 4315, VietNamDivisionType.XA, "xa_minh_chuan", 135)
    W_4318 = Ward("Xã Mai Sơn", 4318, VietNamDivisionType.XA, "xa_mai_son", 135)
    W_4321 = Ward("Xã Khai Trung", 4321, VietNamDivisionType.XA, "xa_khai_trung", 135)
    W_4324 = Ward("Xã Mường Lai", 4324, VietNamDivisionType.XA, "xa_muong_lai", 135)
    W_4327 = Ward("Xã An Lạc", 4327, VietNamDivisionType.XA, "xa_an_lac", 135)
    W_4330 = Ward("Xã Minh Xuân", 4330, VietNamDivisionType.XA, "xa_minh_xuan", 135)
    W_4333 = Ward("Xã Tô Mậu", 4333, VietNamDivisionType.XA, "xa_to_mau", 135)
    W_4336 = Ward("Xã Tân Lĩnh", 4336, VietNamDivisionType.XA, "xa_tan_linh", 135)
    W_4339 = Ward("Xã Yên Thắng", 4339, VietNamDivisionType.XA, "xa_yen_thang", 135)
    W_4342 = Ward("Xã Khánh Hoà", 4342, VietNamDivisionType.XA, "xa_khanh_hoa", 135)
    W_4345 = Ward("Xã Vĩnh Lạc", 4345, VietNamDivisionType.XA, "xa_vinh_lac", 135)
    W_4348 = Ward("Xã Liễu Đô", 4348, VietNamDivisionType.XA, "xa_lieu_do", 135)
    W_4351 = Ward("Xã Động Quan", 4351, VietNamDivisionType.XA, "xa_dong_quan", 135)
    W_4354 = Ward("Xã Tân Lập", 4354, VietNamDivisionType.XA, "xa_tan_lap", 135)
    W_4357 = Ward("Xã Minh Tiến", 4357, VietNamDivisionType.XA, "xa_minh_tien", 135)
    W_4360 = Ward("Xã Trúc Lâu", 4360, VietNamDivisionType.XA, "xa_truc_lau", 135)
    W_4363 = Ward("Xã Phúc Lợi", 4363, VietNamDivisionType.XA, "xa_phuc_loi", 135)
    W_4366 = Ward("Xã Phan Thanh", 4366, VietNamDivisionType.XA, "xa_phan_thanh", 135)
    W_4369 = Ward("Xã An Phú", 4369, VietNamDivisionType.XA, "xa_an_phu", 135)
    W_4372 = Ward("Xã Trung Tâm", 4372, VietNamDivisionType.XA, "xa_trung_tam", 135)
    W_4375 = Ward("Thị trấn Mậu A", 4375, VietNamDivisionType.THI_TRAN, "thi_tran_mau_a", 136)
    W_4378 = Ward("Xã Lang Thíp", 4378, VietNamDivisionType.XA, "xa_lang_thip", 136)
    W_4381 = Ward("Xã Lâm Giang", 4381, VietNamDivisionType.XA, "xa_lam_giang", 136)
    W_4384 = Ward("Xã Châu Quế Thượng", 4384, VietNamDivisionType.XA, "xa_chau_que_thuong", 136)
    W_4387 = Ward("Xã Châu Quế Hạ", 4387, VietNamDivisionType.XA, "xa_chau_que_ha", 136)
    W_4390 = Ward("Xã An Bình", 4390, VietNamDivisionType.XA, "xa_an_binh", 136)
    W_4393 = Ward("Xã Quang Minh", 4393, VietNamDivisionType.XA, "xa_quang_minh", 136)
    W_4396 = Ward("Xã Đông An", 4396, VietNamDivisionType.XA, "xa_dong_an", 136)
    W_4399 = Ward("Xã Đông Cuông", 4399, VietNamDivisionType.XA, "xa_dong_cuong", 136)
    W_4402 = Ward("Xã Phong Dụ Hạ", 4402, VietNamDivisionType.XA, "xa_phong_du_ha", 136)
    W_4405 = Ward("Xã Mậu Đông", 4405, VietNamDivisionType.XA, "xa_mau_dong", 136)
    W_4408 = Ward("Xã Ngòi A", 4408, VietNamDivisionType.XA, "xa_ngoi_a", 136)
    W_4411 = Ward("Xã Xuân Tầm", 4411, VietNamDivisionType.XA, "xa_xuan_tam", 136)
    W_4414 = Ward("Xã Tân Hợp", 4414, VietNamDivisionType.XA, "xa_tan_hop", 136)
    W_4417 = Ward("Xã An Thịnh", 4417, VietNamDivisionType.XA, "xa_an_thinh", 136)
    W_4420 = Ward("Xã Yên Thái", 4420, VietNamDivisionType.XA, "xa_yen_thai", 136)
    W_4423 = Ward("Xã Phong Dụ Thượng", 4423, VietNamDivisionType.XA, "xa_phong_du_thuong", 136)
    W_4426 = Ward("Xã Yên Hợp", 4426, VietNamDivisionType.XA, "xa_yen_hop", 136)
    W_4429 = Ward("Xã Đại Sơn", 4429, VietNamDivisionType.XA, "xa_dai_son", 136)
    W_4435 = Ward("Xã Đại Phác", 4435, VietNamDivisionType.XA, "xa_dai_phac", 136)
    W_4438 = Ward("Xã Yên Phú", 4438, VietNamDivisionType.XA, "xa_yen_phu", 136)
    W_4441 = Ward("Xã Xuân Ái", 4441, VietNamDivisionType.XA, "xa_xuan_ai", 136)
    W_4447 = Ward("Xã Viễn Sơn", 4447, VietNamDivisionType.XA, "xa_vien_son", 136)
    W_4450 = Ward("Xã Mỏ Vàng", 4450, VietNamDivisionType.XA, "xa_mo_vang", 136)
    W_4453 = Ward("Xã Nà Hẩu", 4453, VietNamDivisionType.XA, "xa_na_hau", 136)
    W_4456 = Ward("Thị trấn Mù Căng Chải", 4456, VietNamDivisionType.THI_TRAN, "thi_tran_mu_cang_chai", 137)
    W_4459 = Ward("Xã Hồ Bốn", 4459, VietNamDivisionType.XA, "xa_ho_bon", 137)
    W_4462 = Ward("Xã Nậm Có", 4462, VietNamDivisionType.XA, "xa_nam_co", 137)
    W_4465 = Ward("Xã Khao Mang", 4465, VietNamDivisionType.XA, "xa_khao_mang", 137)
    W_4468 = Ward("Xã Mồ Dề", 4468, VietNamDivisionType.XA, "xa_mo_de", 137)
    W_4471 = Ward("Xã Chế Cu Nha", 4471, VietNamDivisionType.XA, "xa_che_cu_nha", 137)
    W_4474 = Ward("Xã Lao Chải", 4474, VietNamDivisionType.XA, "xa_lao_chai", 137)
    W_4477 = Ward("Xã Kim Nọi", 4477, VietNamDivisionType.XA, "xa_kim_noi", 137)
    W_4480 = Ward("Xã Cao Phạ", 4480, VietNamDivisionType.XA, "xa_cao_pha", 137)
    W_4483 = Ward("Xã La Pán Tẩn", 4483, VietNamDivisionType.XA, "xa_la_pan_tan", 137)
    W_4486 = Ward("Xã Dế Su Phình", 4486, VietNamDivisionType.XA, "xa_de_su_phinh", 137)
    W_4489 = Ward("Xã Chế Tạo", 4489, VietNamDivisionType.XA, "xa_che_tao", 137)
    W_4492 = Ward("Xã Púng Luông", 4492, VietNamDivisionType.XA, "xa_pung_luong", 137)
    W_4495 = Ward("Xã Nậm Khắt", 4495, VietNamDivisionType.XA, "xa_nam_khat", 137)
    W_4498 = Ward("Thị trấn Cổ Phúc", 4498, VietNamDivisionType.THI_TRAN, "thi_tran_co_phuc", 138)
    W_4501 = Ward("Xã Tân Đồng", 4501, VietNamDivisionType.XA, "xa_tan_dong", 138)
    W_4504 = Ward("Xã Báo Đáp", 4504, VietNamDivisionType.XA, "xa_bao_dap", 138)
    W_4507 = Ward("Xã Đào Thịnh", 4507, VietNamDivisionType.XA, "xa_dao_thinh", 138)
    W_4510 = Ward("Xã Việt Thành", 4510, VietNamDivisionType.XA, "xa_viet_thanh", 138)
    W_4513 = Ward("Xã Hòa Cuông", 4513, VietNamDivisionType.XA, "xa_hoa_cuong", 138)
    W_4516 = Ward("Xã Minh Quán", 4516, VietNamDivisionType.XA, "xa_minh_quan", 138)
    W_4519 = Ward("Xã Quy Mông", 4519, VietNamDivisionType.XA, "xa_quy_mong", 138)
    W_4522 = Ward("Xã Cường Thịnh", 4522, VietNamDivisionType.XA, "xa_cuong_thinh", 138)
    W_4525 = Ward("Xã Kiên Thành", 4525, VietNamDivisionType.XA, "xa_kien_thanh", 138)
    W_4528 = Ward("Xã Nga Quán", 4528, VietNamDivisionType.XA, "xa_nga_quan", 138)
    W_4531 = Ward("Xã Y Can", 4531, VietNamDivisionType.XA, "xa_y_can", 138)
    W_4537 = Ward("Xã Lương Thịnh", 4537, VietNamDivisionType.XA, "xa_luong_thinh", 138)
    W_4561 = Ward("Xã Bảo Hưng", 4561, VietNamDivisionType.XA, "xa_bao_hung", 138)
    W_4564 = Ward("Xã Việt Cường", 4564, VietNamDivisionType.XA, "xa_viet_cuong", 138)
    W_4567 = Ward("Xã Minh Quân", 4567, VietNamDivisionType.XA, "xa_minh_quan", 138)
    W_4570 = Ward("Xã Hồng Ca", 4570, VietNamDivisionType.XA, "xa_hong_ca", 138)
    W_4573 = Ward("Xã Hưng Thịnh", 4573, VietNamDivisionType.XA, "xa_hung_thinh", 138)
    W_4576 = Ward("Xã Hưng Khánh", 4576, VietNamDivisionType.XA, "xa_hung_khanh", 138)
    W_4579 = Ward("Xã Việt Hồng", 4579, VietNamDivisionType.XA, "xa_viet_hong", 138)
    W_4582 = Ward("Xã Vân Hội", 4582, VietNamDivisionType.XA, "xa_van_hoi", 138)
    W_4585 = Ward("Thị trấn Trạm Tấu", 4585, VietNamDivisionType.THI_TRAN, "thi_tran_tram_tau", 139)
    W_4588 = Ward("Xã Túc Đán", 4588, VietNamDivisionType.XA, "xa_tuc_dan", 139)
    W_4591 = Ward("Xã Pá Lau", 4591, VietNamDivisionType.XA, "xa_pa_lau", 139)
    W_4594 = Ward("Xã Xà Hồ", 4594, VietNamDivisionType.XA, "xa_xa_ho", 139)
    W_4597 = Ward("Xã Phình Hồ", 4597, VietNamDivisionType.XA, "xa_phinh_ho", 139)
    W_4600 = Ward("Xã Trạm Tấu", 4600, VietNamDivisionType.XA, "xa_tram_tau", 139)
    W_4603 = Ward("Xã Tà Si Láng", 4603, VietNamDivisionType.XA, "xa_ta_si_lang", 139)
    W_4606 = Ward("Xã Pá Hu", 4606, VietNamDivisionType.XA, "xa_pa_hu", 139)
    W_4609 = Ward("Xã Làng Nhì", 4609, VietNamDivisionType.XA, "xa_lang_nhi", 139)
    W_4612 = Ward("Xã Bản Công", 4612, VietNamDivisionType.XA, "xa_ban_cong", 139)
    W_4615 = Ward("Xã Bản Mù", 4615, VietNamDivisionType.XA, "xa_ban_mu", 139)
    W_4618 = Ward("Xã Hát Lìu", 4618, VietNamDivisionType.XA, "xa_hat_liu", 139)
    W_4621 = Ward("Thị trấn NT Liên Sơn", 4621, VietNamDivisionType.THI_TRAN, "thi_tran_nt_lien_son", 140)
    W_4627 = Ward("Thị trấn NT Trần Phú", 4627, VietNamDivisionType.THI_TRAN, "thi_tran_nt_tran_phu", 140)
    W_4630 = Ward("Xã Tú Lệ", 4630, VietNamDivisionType.XA, "xa_tu_le", 140)
    W_4633 = Ward("Xã Nậm Búng", 4633, VietNamDivisionType.XA, "xa_nam_bung", 140)
    W_4636 = Ward("Xã Gia Hội", 4636, VietNamDivisionType.XA, "xa_gia_hoi", 140)
    W_4639 = Ward("Xã Sùng Đô", 4639, VietNamDivisionType.XA, "xa_sung_do", 140)
    W_4642 = Ward("Xã Nậm Mười", 4642, VietNamDivisionType.XA, "xa_nam_muoi", 140)
    W_4645 = Ward("Xã An Lương", 4645, VietNamDivisionType.XA, "xa_an_luong", 140)
    W_4648 = Ward("Xã Nậm Lành", 4648, VietNamDivisionType.XA, "xa_nam_lanh", 140)
    W_4651 = Ward("Xã Sơn Lương", 4651, VietNamDivisionType.XA, "xa_son_luong", 140)
    W_4654 = Ward("Xã Suối Quyền", 4654, VietNamDivisionType.XA, "xa_suoi_quyen", 140)
    W_4657 = Ward("Xã Suối Giàng", 4657, VietNamDivisionType.XA, "xa_suoi_giang", 140)
    W_4666 = Ward("Xã Nghĩa Sơn", 4666, VietNamDivisionType.XA, "xa_nghia_son", 140)
    W_4669 = Ward("Xã Suối Bu", 4669, VietNamDivisionType.XA, "xa_suoi_bu", 140)
    W_4672 = Ward("Thị trấn Sơn Thịnh", 4672, VietNamDivisionType.THI_TRAN, "thi_tran_son_thinh", 140)
    W_4687 = Ward("Xã Đại Lịch", 4687, VietNamDivisionType.XA, "xa_dai_lich", 140)
    W_4690 = Ward("Xã Đồng Khê", 4690, VietNamDivisionType.XA, "xa_dong_khe", 140)
    W_4693 = Ward("Xã Cát Thịnh", 4693, VietNamDivisionType.XA, "xa_cat_thinh", 140)
    W_4696 = Ward("Xã Tân Thịnh", 4696, VietNamDivisionType.XA, "xa_tan_thinh", 140)
    W_4699 = Ward("Xã Chấn Thịnh", 4699, VietNamDivisionType.XA, "xa_chan_thinh", 140)
    W_4702 = Ward("Xã Bình Thuận", 4702, VietNamDivisionType.XA, "xa_binh_thuan", 140)
    W_4705 = Ward("Xã Thượng Bằng La", 4705, VietNamDivisionType.XA, "xa_thuong_bang_la", 140)
    W_4708 = Ward("Xã Minh An", 4708, VietNamDivisionType.XA, "xa_minh_an", 140)
    W_4711 = Ward("Xã Nghĩa Tâm", 4711, VietNamDivisionType.XA, "xa_nghia_tam", 140)
    W_4714 = Ward("Thị trấn Yên Bình", 4714, VietNamDivisionType.THI_TRAN, "thi_tran_yen_binh", 141)
    W_4717 = Ward("Thị trấn Thác Bà", 4717, VietNamDivisionType.THI_TRAN, "thi_tran_thac_ba", 141)
    W_4720 = Ward("Xã Xuân Long", 4720, VietNamDivisionType.XA, "xa_xuan_long", 141)
    W_4726 = Ward("Xã Cảm Nhân", 4726, VietNamDivisionType.XA, "xa_cam_nhan", 141)
    W_4729 = Ward("Xã Ngọc Chấn", 4729, VietNamDivisionType.XA, "xa_ngoc_chan", 141)
    W_4732 = Ward("Xã Tân Nguyên", 4732, VietNamDivisionType.XA, "xa_tan_nguyen", 141)
    W_4735 = Ward("Xã Phúc Ninh", 4735, VietNamDivisionType.XA, "xa_phuc_ninh", 141)
    W_4738 = Ward("Xã Bảo Ái", 4738, VietNamDivisionType.XA, "xa_bao_ai", 141)
    W_4741 = Ward("Xã Mỹ Gia", 4741, VietNamDivisionType.XA, "xa_my_gia", 141)
    W_4744 = Ward("Xã Xuân Lai", 4744, VietNamDivisionType.XA, "xa_xuan_lai", 141)
    W_4747 = Ward("Xã Mông Sơn", 4747, VietNamDivisionType.XA, "xa_mong_son", 141)
    W_4750 = Ward("Xã Cảm Ân", 4750, VietNamDivisionType.XA, "xa_cam_an", 141)
    W_4753 = Ward("Xã Yên Thành", 4753, VietNamDivisionType.XA, "xa_yen_thanh", 141)
    W_4756 = Ward("Xã Tân Hương", 4756, VietNamDivisionType.XA, "xa_tan_huong", 141)
    W_4759 = Ward("Xã Phúc An", 4759, VietNamDivisionType.XA, "xa_phuc_an", 141)
    W_4762 = Ward("Xã Bạch Hà", 4762, VietNamDivisionType.XA, "xa_bach_ha", 141)
    W_4765 = Ward("Xã Vũ Linh", 4765, VietNamDivisionType.XA, "xa_vu_linh", 141)
    W_4768 = Ward("Xã Đại Đồng", 4768, VietNamDivisionType.XA, "xa_dai_dong", 141)
    W_4771 = Ward("Xã Vĩnh Kiên", 4771, VietNamDivisionType.XA, "xa_vinh_kien", 141)
    W_4774 = Ward("Xã Yên Bình", 4774, VietNamDivisionType.XA, "xa_yen_binh", 141)
    W_4777 = Ward("Xã Thịnh Hưng", 4777, VietNamDivisionType.XA, "xa_thinh_hung", 141)
    W_4780 = Ward("Xã Hán Đà", 4780, VietNamDivisionType.XA, "xa_han_da", 141)
    W_4783 = Ward("Xã Phú Thịnh", 4783, VietNamDivisionType.XA, "xa_phu_thinh", 141)
    W_4786 = Ward("Xã Đại Minh", 4786, VietNamDivisionType.XA, "xa_dai_minh", 141)
    W_4789 = Ward("Phường Thái Bình", 4789, VietNamDivisionType.PHUONG, "phuong_thai_binh", 148)
    W_4792 = Ward("Phường Tân Hòa", 4792, VietNamDivisionType.PHUONG, "phuong_tan_hoa", 148)
    W_4795 = Ward("Phường Thịnh Lang", 4795, VietNamDivisionType.PHUONG, "phuong_thinh_lang", 148)
    W_4798 = Ward("Phường Hữu Nghị", 4798, VietNamDivisionType.PHUONG, "phuong_huu_nghi", 148)
    W_4801 = Ward("Phường Tân Thịnh", 4801, VietNamDivisionType.PHUONG, "phuong_tan_thinh", 148)
    W_4804 = Ward("Phường Đồng Tiến", 4804, VietNamDivisionType.PHUONG, "phuong_dong_tien", 148)
    W_4807 = Ward("Phường Phương Lâm", 4807, VietNamDivisionType.PHUONG, "phuong_phuong_lam", 148)
    W_4813 = Ward("Xã Yên Mông", 4813, VietNamDivisionType.XA, "xa_yen_mong", 148)
    W_4816 = Ward("Phường Quỳnh Lâm", 4816, VietNamDivisionType.PHUONG, "phuong_quynh_lam", 148)
    W_4819 = Ward("Phường Dân Chủ", 4819, VietNamDivisionType.PHUONG, "phuong_dan_chu", 148)
    W_4825 = Ward("Xã Hòa Bình", 4825, VietNamDivisionType.XA, "xa_hoa_binh", 148)
    W_4828 = Ward("Phường Thống Nhất", 4828, VietNamDivisionType.PHUONG, "phuong_thong_nhat", 148)
    W_4894 = Ward("Phường Kỳ Sơn", 4894, VietNamDivisionType.PHUONG, "phuong_ky_son", 148)
    W_4897 = Ward("Xã Thịnh Minh", 4897, VietNamDivisionType.XA, "xa_thinh_minh", 148)
    W_4903 = Ward("Xã Hợp Thành", 4903, VietNamDivisionType.XA, "xa_hop_thanh", 148)
    W_4906 = Ward("Xã Quang Tiến", 4906, VietNamDivisionType.XA, "xa_quang_tien", 148)
    W_4912 = Ward("Xã Mông Hóa", 4912, VietNamDivisionType.XA, "xa_mong_hoa", 148)
    W_4918 = Ward("Phường Trung Minh", 4918, VietNamDivisionType.PHUONG, "phuong_trung_minh", 148)
    W_4921 = Ward("Xã Độc Lập", 4921, VietNamDivisionType.XA, "xa_doc_lap", 148)
    W_4831 = Ward("Thị trấn Đà Bắc", 4831, VietNamDivisionType.THI_TRAN, "thi_tran_da_bac", 150)
    W_4834 = Ward("Xã Nánh Nghê", 4834, VietNamDivisionType.XA, "xa_nanh_nghe", 150)
    W_4840 = Ward("Xã Giáp Đắt", 4840, VietNamDivisionType.XA, "xa_giap_dat", 150)
    W_4846 = Ward("Xã Mường Chiềng", 4846, VietNamDivisionType.XA, "xa_muong_chieng", 150)
    W_4849 = Ward("Xã Tân Pheo", 4849, VietNamDivisionType.XA, "xa_tan_pheo", 150)
    W_4852 = Ward("Xã Đồng Chum", 4852, VietNamDivisionType.XA, "xa_dong_chum", 150)
    W_4855 = Ward("Xã Tân Minh", 4855, VietNamDivisionType.XA, "xa_tan_minh", 150)
    W_4858 = Ward("Xã Đoàn Kết", 4858, VietNamDivisionType.XA, "xa_doan_ket", 150)
    W_4861 = Ward("Xã Đồng Ruộng", 4861, VietNamDivisionType.XA, "xa_dong_ruong", 150)
    W_4867 = Ward("Xã Tú Lý", 4867, VietNamDivisionType.XA, "xa_tu_ly", 150)
    W_4870 = Ward("Xã Trung Thành", 4870, VietNamDivisionType.XA, "xa_trung_thanh", 150)
    W_4873 = Ward("Xã Yên Hòa", 4873, VietNamDivisionType.XA, "xa_yen_hoa", 150)
    W_4876 = Ward("Xã Cao Sơn", 4876, VietNamDivisionType.XA, "xa_cao_son", 150)
    W_4879 = Ward("Xã Toàn Sơn", 4879, VietNamDivisionType.XA, "xa_toan_son", 150)
    W_4885 = Ward("Xã Hiền Lương", 4885, VietNamDivisionType.XA, "xa_hien_luong", 150)
    W_4888 = Ward("Xã Tiền Phong", 4888, VietNamDivisionType.XA, "xa_tien_phong", 150)
    W_4891 = Ward("Xã Vầy Nưa", 4891, VietNamDivisionType.XA, "xa_vay_nua", 150)
    W_4924 = Ward("Thị trấn Lương Sơn", 4924, VietNamDivisionType.THI_TRAN, "thi_tran_luong_son", 152)
    W_4942 = Ward("Xã Lâm Sơn", 4942, VietNamDivisionType.XA, "xa_lam_son", 152)
    W_4945 = Ward("Xã Hòa Sơn", 4945, VietNamDivisionType.XA, "xa_hoa_son", 152)
    W_4951 = Ward("Xã Tân Vinh", 4951, VietNamDivisionType.XA, "xa_tan_vinh", 152)
    W_4954 = Ward("Xã Nhuận Trạch", 4954, VietNamDivisionType.XA, "xa_nhuan_trach", 152)
    W_4957 = Ward("Xã Cao Sơn", 4957, VietNamDivisionType.XA, "xa_cao_son", 152)
    W_4960 = Ward("Xã Cư Yên", 4960, VietNamDivisionType.XA, "xa_cu_yen", 152)
    W_4969 = Ward("Xã Liên Sơn", 4969, VietNamDivisionType.XA, "xa_lien_son", 152)
    W_5008 = Ward("Xã Cao Dương", 5008, VietNamDivisionType.XA, "xa_cao_duong", 152)
    W_5041 = Ward("Xã Thanh Sơn", 5041, VietNamDivisionType.XA, "xa_thanh_son", 152)
    W_5047 = Ward("Xã Thanh Cao", 5047, VietNamDivisionType.XA, "xa_thanh_cao", 152)
    W_4978 = Ward("Thị trấn Bo", 4978, VietNamDivisionType.THI_TRAN, "thi_tran_bo", 153)
    W_4984 = Ward("Xã Đú Sáng", 4984, VietNamDivisionType.XA, "xa_du_sang", 153)
    W_4987 = Ward("Xã Hùng Sơn", 4987, VietNamDivisionType.XA, "xa_hung_son", 153)
    W_4990 = Ward("Xã Bình Sơn", 4990, VietNamDivisionType.XA, "xa_binh_son", 153)
    W_4999 = Ward("Xã Tú Sơn", 4999, VietNamDivisionType.XA, "xa_tu_son", 153)
    W_5005 = Ward("Xã Vĩnh Tiến", 5005, VietNamDivisionType.XA, "xa_vinh_tien", 153)
    W_5014 = Ward("Xã Đông Bắc", 5014, VietNamDivisionType.XA, "xa_dong_bac", 153)
    W_5017 = Ward("Xã Xuân Thủy", 5017, VietNamDivisionType.XA, "xa_xuan_thuy", 153)
    W_5026 = Ward("Xã Vĩnh Đồng", 5026, VietNamDivisionType.XA, "xa_vinh_dong", 153)
    W_5035 = Ward("Xã Kim Lập", 5035, VietNamDivisionType.XA, "xa_kim_lap", 153)
    W_5038 = Ward("Xã Hợp Tiến", 5038, VietNamDivisionType.XA, "xa_hop_tien", 153)
    W_5065 = Ward("Xã Kim Bôi", 5065, VietNamDivisionType.XA, "xa_kim_boi", 153)
    W_5068 = Ward("Xã Nam Thượng", 5068, VietNamDivisionType.XA, "xa_nam_thuong", 153)
    W_5077 = Ward("Xã Cuối Hạ", 5077, VietNamDivisionType.XA, "xa_cuoi_ha", 153)
    W_5080 = Ward("Xã Sào Báy", 5080, VietNamDivisionType.XA, "xa_sao_bay", 153)
    W_5083 = Ward("Xã Mi Hòa", 5083, VietNamDivisionType.XA, "xa_mi_hoa", 153)
    W_5086 = Ward("Xã Nuông Dăm", 5086, VietNamDivisionType.XA, "xa_nuong_dam", 153)
    W_5089 = Ward("Thị trấn Cao Phong", 5089, VietNamDivisionType.THI_TRAN, "thi_tran_cao_phong", 154)
    W_5092 = Ward("Xã Bình Thanh", 5092, VietNamDivisionType.XA, "xa_binh_thanh", 154)
    W_5095 = Ward("Xã Thung Nai", 5095, VietNamDivisionType.XA, "xa_thung_nai", 154)
    W_5098 = Ward("Xã Bắc Phong", 5098, VietNamDivisionType.XA, "xa_bac_phong", 154)
    W_5101 = Ward("Xã Thu Phong", 5101, VietNamDivisionType.XA, "xa_thu_phong", 154)
    W_5104 = Ward("Xã Hợp Phong", 5104, VietNamDivisionType.XA, "xa_hop_phong", 154)
    W_5110 = Ward("Xã Tây Phong", 5110, VietNamDivisionType.XA, "xa_tay_phong", 154)
    W_5116 = Ward("Xã Dũng Phong", 5116, VietNamDivisionType.XA, "xa_dung_phong", 154)
    W_5119 = Ward("Xã Nam Phong", 5119, VietNamDivisionType.XA, "xa_nam_phong", 154)
    W_5125 = Ward("Xã Thạch Yên", 5125, VietNamDivisionType.XA, "xa_thach_yen", 154)
    W_5128 = Ward("Thị trấn Mãn Đức", 5128, VietNamDivisionType.THI_TRAN, "thi_tran_man_duc", 155)
    W_5134 = Ward("Xã Suối Hoa", 5134, VietNamDivisionType.XA, "xa_suoi_hoa", 155)
    W_5137 = Ward("Xã Phú Vinh", 5137, VietNamDivisionType.XA, "xa_phu_vinh", 155)
    W_5140 = Ward("Xã Phú Cường", 5140, VietNamDivisionType.XA, "xa_phu_cuong", 155)
    W_5143 = Ward("Xã Mỹ Hòa", 5143, VietNamDivisionType.XA, "xa_my_hoa", 155)
    W_5152 = Ward("Xã Quyết Chiến", 5152, VietNamDivisionType.XA, "xa_quyet_chien", 155)
    W_5158 = Ward("Xã Phong Phú", 5158, VietNamDivisionType.XA, "xa_phong_phu", 155)
    W_5164 = Ward("Xã Tử Nê", 5164, VietNamDivisionType.XA, "xa_tu_ne", 155)
    W_5167 = Ward("Xã Thanh Hối", 5167, VietNamDivisionType.XA, "xa_thanh_hoi", 155)
    W_5170 = Ward("Xã Ngọc Mỹ", 5170, VietNamDivisionType.XA, "xa_ngoc_my", 155)
    W_5173 = Ward("Xã Đông Lai", 5173, VietNamDivisionType.XA, "xa_dong_lai", 155)
    W_5176 = Ward("Xã Vân Sơn", 5176, VietNamDivisionType.XA, "xa_van_son", 155)
    W_5182 = Ward("Xã Nhân Mỹ", 5182, VietNamDivisionType.XA, "xa_nhan_my", 155)
    W_5191 = Ward("Xã Lỗ Sơn", 5191, VietNamDivisionType.XA, "xa_lo_son", 155)
    W_5194 = Ward("Xã Ngổ Luông", 5194, VietNamDivisionType.XA, "xa_ngo_luong", 155)
    W_5197 = Ward("Xã Gia Mô", 5197, VietNamDivisionType.XA, "xa_gia_mo", 155)
    W_4882 = Ward("Xã Tân Thành", 4882, VietNamDivisionType.XA, "xa_tan_thanh", 156)
    W_5200 = Ward("Thị trấn Mai Châu", 5200, VietNamDivisionType.THI_TRAN, "thi_tran_mai_chau", 156)
    W_5206 = Ward("Xã Sơn Thủy", 5206, VietNamDivisionType.XA, "xa_son_thuy", 156)
    W_5209 = Ward("Xã Pà Cò", 5209, VietNamDivisionType.XA, "xa_pa_co", 156)
    W_5212 = Ward("Xã Hang Kia", 5212, VietNamDivisionType.XA, "xa_hang_kia", 156)
    W_5221 = Ward("Xã Đồng Tân", 5221, VietNamDivisionType.XA, "xa_dong_tan", 156)
    W_5224 = Ward("Xã Cun Pheo", 5224, VietNamDivisionType.XA, "xa_cun_pheo", 156)
    W_5227 = Ward("Xã Bao La", 5227, VietNamDivisionType.XA, "xa_bao_la", 156)
    W_5233 = Ward("Xã Tòng Đậu", 5233, VietNamDivisionType.XA, "xa_tong_dau", 156)
    W_5242 = Ward("Xã Nà Phòn", 5242, VietNamDivisionType.XA, "xa_na_phon", 156)
    W_5245 = Ward("Xã Săm Khóe", 5245, VietNamDivisionType.XA, "xa_sam_khoe", 156)
    W_5248 = Ward("Xã Chiềng Châu", 5248, VietNamDivisionType.XA, "xa_chieng_chau", 156)
    W_5251 = Ward("Xã Mai Hạ", 5251, VietNamDivisionType.XA, "xa_mai_ha", 156)
    W_5254 = Ward("Xã Thành Sơn", 5254, VietNamDivisionType.XA, "xa_thanh_son", 156)
    W_5257 = Ward("Xã Mai Hịch", 5257, VietNamDivisionType.XA, "xa_mai_hich", 156)
    W_5263 = Ward("Xã Vạn Mai", 5263, VietNamDivisionType.XA, "xa_van_mai", 156)
    W_5266 = Ward("Thị trấn Vụ Bản", 5266, VietNamDivisionType.THI_TRAN, "thi_tran_vu_ban", 157)
    W_5269 = Ward("Xã Quý Hòa", 5269, VietNamDivisionType.XA, "xa_quy_hoa", 157)
    W_5272 = Ward("Xã Miền Đồi", 5272, VietNamDivisionType.XA, "xa_mien_doi", 157)
    W_5275 = Ward("Xã Mỹ Thành", 5275, VietNamDivisionType.XA, "xa_my_thanh", 157)
    W_5278 = Ward("Xã Tuân Đạo", 5278, VietNamDivisionType.XA, "xa_tuan_dao", 157)
    W_5281 = Ward("Xã Văn Nghĩa", 5281, VietNamDivisionType.XA, "xa_van_nghia", 157)
    W_5284 = Ward("Xã Văn Sơn", 5284, VietNamDivisionType.XA, "xa_van_son", 157)
    W_5287 = Ward("Xã Tân Lập", 5287, VietNamDivisionType.XA, "xa_tan_lap", 157)
    W_5290 = Ward("Xã Nhân Nghĩa", 5290, VietNamDivisionType.XA, "xa_nhan_nghia", 157)
    W_5293 = Ward("Xã Thượng Cốc", 5293, VietNamDivisionType.XA, "xa_thuong_coc", 157)
    W_5299 = Ward("Xã Quyết Thắng", 5299, VietNamDivisionType.XA, "xa_quyet_thang", 157)
    W_5302 = Ward("Xã Xuất Hóa", 5302, VietNamDivisionType.XA, "xa_xuat_hoa", 157)
    W_5305 = Ward("Xã Yên Phú", 5305, VietNamDivisionType.XA, "xa_yen_phu", 157)
    W_5308 = Ward("Xã Bình Hẻm", 5308, VietNamDivisionType.XA, "xa_binh_hem", 157)
    W_5320 = Ward("Xã Định Cư", 5320, VietNamDivisionType.XA, "xa_dinh_cu", 157)
    W_5323 = Ward("Xã Chí Đạo", 5323, VietNamDivisionType.XA, "xa_chi_dao", 157)
    W_5329 = Ward("Xã Ngọc Sơn", 5329, VietNamDivisionType.XA, "xa_ngoc_son", 157)
    W_5332 = Ward("Xã Hương Nhượng", 5332, VietNamDivisionType.XA, "xa_huong_nhuong", 157)
    W_5335 = Ward("Xã Vũ Bình", 5335, VietNamDivisionType.XA, "xa_vu_binh", 157)
    W_5338 = Ward("Xã Tự Do", 5338, VietNamDivisionType.XA, "xa_tu_do", 157)
    W_5341 = Ward("Xã Yên Nghiệp", 5341, VietNamDivisionType.XA, "xa_yen_nghiep", 157)
    W_5344 = Ward("Xã Tân Mỹ", 5344, VietNamDivisionType.XA, "xa_tan_my", 157)
    W_5347 = Ward("Xã Ân Nghĩa", 5347, VietNamDivisionType.XA, "xa_an_nghia", 157)
    W_5350 = Ward("Xã Ngọc Lâu", 5350, VietNamDivisionType.XA, "xa_ngoc_lau", 157)
    W_5353 = Ward("Thị trấn Hàng Trạm", 5353, VietNamDivisionType.THI_TRAN, "thi_tran_hang_tram", 158)
    W_5356 = Ward("Xã Lạc Sỹ", 5356, VietNamDivisionType.XA, "xa_lac_sy", 158)
    W_5362 = Ward("Xã Lạc Lương", 5362, VietNamDivisionType.XA, "xa_lac_luong", 158)
    W_5365 = Ward("Xã Bảo Hiệu", 5365, VietNamDivisionType.XA, "xa_bao_hieu", 158)
    W_5368 = Ward("Xã Đa Phúc", 5368, VietNamDivisionType.XA, "xa_da_phuc", 158)
    W_5371 = Ward("Xã Hữu Lợi", 5371, VietNamDivisionType.XA, "xa_huu_loi", 158)
    W_5374 = Ward("Xã Lạc Thịnh", 5374, VietNamDivisionType.XA, "xa_lac_thinh", 158)
    W_5380 = Ward("Xã Đoàn Kết", 5380, VietNamDivisionType.XA, "xa_doan_ket", 158)
    W_5383 = Ward("Xã Phú Lai", 5383, VietNamDivisionType.XA, "xa_phu_lai", 158)
    W_5386 = Ward("Xã Yên Trị", 5386, VietNamDivisionType.XA, "xa_yen_tri", 158)
    W_5389 = Ward("Xã Ngọc Lương", 5389, VietNamDivisionType.XA, "xa_ngoc_luong", 158)
    W_4981 = Ward("Thị trấn Ba Hàng Đồi", 4981, VietNamDivisionType.THI_TRAN, "thi_tran_ba_hang_doi", 159)
    W_5392 = Ward("Thị trấn Chi Nê", 5392, VietNamDivisionType.THI_TRAN, "thi_tran_chi_ne", 159)
    W_5395 = Ward("Xã Phú Nghĩa", 5395, VietNamDivisionType.XA, "xa_phu_nghia", 159)
    W_5398 = Ward("Xã Phú Thành", 5398, VietNamDivisionType.XA, "xa_phu_thanh", 159)
    W_5404 = Ward("Xã Hưng Thi", 5404, VietNamDivisionType.XA, "xa_hung_thi", 159)
    W_5413 = Ward("Xã Khoan Dụ", 5413, VietNamDivisionType.XA, "xa_khoan_du", 159)
    W_5419 = Ward("Xã Đồng Tâm", 5419, VietNamDivisionType.XA, "xa_dong_tam", 159)
    W_5422 = Ward("Xã Yên Bồng", 5422, VietNamDivisionType.XA, "xa_yen_bong", 159)
    W_5425 = Ward("Xã Thống Nhất", 5425, VietNamDivisionType.XA, "xa_thong_nhat", 159)
    W_5428 = Ward("Xã An Bình", 5428, VietNamDivisionType.XA, "xa_an_binh", 159)
    W_5431 = Ward("Phường Quán Triều", 5431, VietNamDivisionType.PHUONG, "phuong_quan_trieu", 164)
    W_5434 = Ward("Phường Quang Vinh", 5434, VietNamDivisionType.PHUONG, "phuong_quang_vinh", 164)
    W_5437 = Ward("Phường Túc Duyên", 5437, VietNamDivisionType.PHUONG, "phuong_tuc_duyen", 164)
    W_5440 = Ward("Phường Hoàng Văn Thụ", 5440, VietNamDivisionType.PHUONG, "phuong_hoang_van_thu", 164)
    W_5443 = Ward("Phường Trưng Vương", 5443, VietNamDivisionType.PHUONG, "phuong_trung_vuong", 164)
    W_5446 = Ward("Phường Quang Trung", 5446, VietNamDivisionType.PHUONG, "phuong_quang_trung", 164)
    W_5449 = Ward("Phường Phan Đình Phùng", 5449, VietNamDivisionType.PHUONG, "phuong_phan_dinh_phung", 164)
    W_5452 = Ward("Phường Tân Thịnh", 5452, VietNamDivisionType.PHUONG, "phuong_tan_thinh", 164)
    W_5455 = Ward("Phường Thịnh Đán", 5455, VietNamDivisionType.PHUONG, "phuong_thinh_dan", 164)
    W_5458 = Ward("Phường Đồng Quang", 5458, VietNamDivisionType.PHUONG, "phuong_dong_quang", 164)
    W_5461 = Ward("Phường Gia Sàng", 5461, VietNamDivisionType.PHUONG, "phuong_gia_sang", 164)
    W_5464 = Ward("Phường Tân Lập", 5464, VietNamDivisionType.PHUONG, "phuong_tan_lap", 164)
    W_5467 = Ward("Phường Cam Giá", 5467, VietNamDivisionType.PHUONG, "phuong_cam_gia", 164)
    W_5470 = Ward("Phường Phú Xá", 5470, VietNamDivisionType.PHUONG, "phuong_phu_xa", 164)
    W_5473 = Ward("Phường Hương Sơn", 5473, VietNamDivisionType.PHUONG, "phuong_huong_son", 164)
    W_5476 = Ward("Phường Trung Thành", 5476, VietNamDivisionType.PHUONG, "phuong_trung_thanh", 164)
    W_5479 = Ward("Phường Tân Thành", 5479, VietNamDivisionType.PHUONG, "phuong_tan_thanh", 164)
    W_5482 = Ward("Phường Tân Long", 5482, VietNamDivisionType.PHUONG, "phuong_tan_long", 164)
    W_5485 = Ward("Xã Phúc Hà", 5485, VietNamDivisionType.XA, "xa_phuc_ha", 164)
    W_5488 = Ward("Xã Phúc Xuân", 5488, VietNamDivisionType.XA, "xa_phuc_xuan", 164)
    W_5491 = Ward("Xã Quyết Thắng", 5491, VietNamDivisionType.XA, "xa_quyet_thang", 164)
    W_5494 = Ward("Xã Phúc Trìu", 5494, VietNamDivisionType.XA, "xa_phuc_triu", 164)
    W_5497 = Ward("Xã Thịnh Đức", 5497, VietNamDivisionType.XA, "xa_thinh_duc", 164)
    W_5500 = Ward("Phường Tích Lương", 5500, VietNamDivisionType.PHUONG, "phuong_tich_luong", 164)
    W_5503 = Ward("Xã Tân Cương", 5503, VietNamDivisionType.XA, "xa_tan_cuong", 164)
    W_5653 = Ward("Xã Sơn Cẩm", 5653, VietNamDivisionType.XA, "xa_son_cam", 164)
    W_5659 = Ward("Phường Chùa Hang", 5659, VietNamDivisionType.PHUONG, "phuong_chua_hang", 164)
    W_5695 = Ward("Xã Cao Ngạn", 5695, VietNamDivisionType.XA, "xa_cao_ngan", 164)
    W_5701 = Ward("Xã Linh Sơn", 5701, VietNamDivisionType.XA, "xa_linh_son", 164)
    W_5710 = Ward("Phường Đồng Bẩm", 5710, VietNamDivisionType.PHUONG, "phuong_dong_bam", 164)
    W_5713 = Ward("Xã Huống Thượng", 5713, VietNamDivisionType.XA, "xa_huong_thuong", 164)
    W_5914 = Ward("Xã Đồng Liên", 5914, VietNamDivisionType.XA, "xa_dong_lien", 164)
    W_5506 = Ward("Phường Lương Sơn", 5506, VietNamDivisionType.PHUONG, "phuong_luong_son", 165)
    W_5509 = Ward("Phường Châu Sơn", 5509, VietNamDivisionType.PHUONG, "phuong_chau_son", 165)
    W_5512 = Ward("Phường Mỏ Chè", 5512, VietNamDivisionType.PHUONG, "phuong_mo_che", 165)
    W_5515 = Ward("Phường Cải Đan", 5515, VietNamDivisionType.PHUONG, "phuong_cai_dan", 165)
    W_5518 = Ward("Phường Thắng Lợi", 5518, VietNamDivisionType.PHUONG, "phuong_thang_loi", 165)
    W_5521 = Ward("Phường Phố Cò", 5521, VietNamDivisionType.PHUONG, "phuong_pho_co", 165)
    W_5527 = Ward("Xã Tân Quang", 5527, VietNamDivisionType.XA, "xa_tan_quang", 165)
    W_5528 = Ward("Phường Bách Quang", 5528, VietNamDivisionType.PHUONG, "phuong_bach_quang", 165)
    W_5530 = Ward("Xã Bình Sơn", 5530, VietNamDivisionType.XA, "xa_binh_son", 165)
    W_5533 = Ward("Xã Bá Xuyên", 5533, VietNamDivisionType.XA, "xa_ba_xuyen", 165)
    W_5536 = Ward("Thị trấn Chợ Chu", 5536, VietNamDivisionType.THI_TRAN, "thi_tran_cho_chu", 167)
    W_5539 = Ward("Xã Linh Thông", 5539, VietNamDivisionType.XA, "xa_linh_thong", 167)
    W_5542 = Ward("Xã Lam Vỹ", 5542, VietNamDivisionType.XA, "xa_lam_vy", 167)
    W_5545 = Ward("Xã Quy Kỳ", 5545, VietNamDivisionType.XA, "xa_quy_ky", 167)
    W_5548 = Ward("Xã Tân Thịnh", 5548, VietNamDivisionType.XA, "xa_tan_thinh", 167)
    W_5551 = Ward("Xã Kim Phượng", 5551, VietNamDivisionType.XA, "xa_kim_phuong", 167)
    W_5554 = Ward("Xã Bảo Linh", 5554, VietNamDivisionType.XA, "xa_bao_linh", 167)
    W_5560 = Ward("Xã Phúc Chu", 5560, VietNamDivisionType.XA, "xa_phuc_chu", 167)
    W_5563 = Ward("Xã Tân Dương", 5563, VietNamDivisionType.XA, "xa_tan_duong", 167)
    W_5566 = Ward("Xã Phượng Tiến", 5566, VietNamDivisionType.XA, "xa_phuong_tien", 167)
    W_5569 = Ward("Xã Bảo Cường", 5569, VietNamDivisionType.XA, "xa_bao_cuong", 167)
    W_5572 = Ward("Xã Đồng Thịnh", 5572, VietNamDivisionType.XA, "xa_dong_thinh", 167)
    W_5575 = Ward("Xã Định Biên", 5575, VietNamDivisionType.XA, "xa_dinh_bien", 167)
    W_5578 = Ward("Xã Thanh Định", 5578, VietNamDivisionType.XA, "xa_thanh_dinh", 167)
    W_5581 = Ward("Xã Trung Hội", 5581, VietNamDivisionType.XA, "xa_trung_hoi", 167)
    W_5584 = Ward("Xã Trung Lương", 5584, VietNamDivisionType.XA, "xa_trung_luong", 167)
    W_5587 = Ward("Xã Bình Yên", 5587, VietNamDivisionType.XA, "xa_binh_yen", 167)
    W_5590 = Ward("Xã Điềm Mặc", 5590, VietNamDivisionType.XA, "xa_diem_mac", 167)
    W_5593 = Ward("Xã Phú Tiến", 5593, VietNamDivisionType.XA, "xa_phu_tien", 167)
    W_5596 = Ward("Xã Bộc Nhiêu", 5596, VietNamDivisionType.XA, "xa_boc_nhieu", 167)
    W_5599 = Ward("Xã Sơn Phú", 5599, VietNamDivisionType.XA, "xa_son_phu", 167)
    W_5602 = Ward("Xã Phú Đình", 5602, VietNamDivisionType.XA, "xa_phu_dinh", 167)
    W_5605 = Ward("Xã Bình Thành", 5605, VietNamDivisionType.XA, "xa_binh_thanh", 167)
    W_5608 = Ward("Thị trấn Giang Tiên", 5608, VietNamDivisionType.THI_TRAN, "thi_tran_giang_tien", 168)
    W_5611 = Ward("Thị trấn Đu", 5611, VietNamDivisionType.THI_TRAN, "thi_tran_du", 168)
    W_5614 = Ward("Xã Yên Ninh", 5614, VietNamDivisionType.XA, "xa_yen_ninh", 168)
    W_5617 = Ward("Xã Yên Trạch", 5617, VietNamDivisionType.XA, "xa_yen_trach", 168)
    W_5620 = Ward("Xã Yên Đổ", 5620, VietNamDivisionType.XA, "xa_yen_do", 168)
    W_5623 = Ward("Xã Yên Lạc", 5623, VietNamDivisionType.XA, "xa_yen_lac", 168)
    W_5626 = Ward("Xã Ôn Lương", 5626, VietNamDivisionType.XA, "xa_on_luong", 168)
    W_5629 = Ward("Xã Động Đạt", 5629, VietNamDivisionType.XA, "xa_dong_dat", 168)
    W_5632 = Ward("Xã Phủ Lý", 5632, VietNamDivisionType.XA, "xa_phu_ly", 168)
    W_5635 = Ward("Xã Phú Đô", 5635, VietNamDivisionType.XA, "xa_phu_do", 168)
    W_5638 = Ward("Xã Hợp Thành", 5638, VietNamDivisionType.XA, "xa_hop_thanh", 168)
    W_5641 = Ward("Xã Tức Tranh", 5641, VietNamDivisionType.XA, "xa_tuc_tranh", 168)
    W_5644 = Ward("Xã Phấn Mễ", 5644, VietNamDivisionType.XA, "xa_phan_me", 168)
    W_5647 = Ward("Xã Vô Tranh", 5647, VietNamDivisionType.XA, "xa_vo_tranh", 168)
    W_5650 = Ward("Xã Cổ Lũng", 5650, VietNamDivisionType.XA, "xa_co_lung", 168)
    W_5656 = Ward("Thị trấn Sông Cầu", 5656, VietNamDivisionType.THI_TRAN, "thi_tran_song_cau", 169)
    W_5662 = Ward("Thị trấn Trại Cau", 5662, VietNamDivisionType.THI_TRAN, "thi_tran_trai_cau", 169)
    W_5665 = Ward("Xã Văn Lăng", 5665, VietNamDivisionType.XA, "xa_van_lang", 169)
    W_5668 = Ward("Xã Tân Long", 5668, VietNamDivisionType.XA, "xa_tan_long", 169)
    W_5671 = Ward("Xã Hòa Bình", 5671, VietNamDivisionType.XA, "xa_hoa_binh", 169)
    W_5674 = Ward("Xã Quang Sơn", 5674, VietNamDivisionType.XA, "xa_quang_son", 169)
    W_5677 = Ward("Xã Minh Lập", 5677, VietNamDivisionType.XA, "xa_minh_lap", 169)
    W_5680 = Ward("Xã Văn Hán", 5680, VietNamDivisionType.XA, "xa_van_han", 169)
    W_5683 = Ward("Xã Hóa Trung", 5683, VietNamDivisionType.XA, "xa_hoa_trung", 169)
    W_5686 = Ward("Xã Khe Mo", 5686, VietNamDivisionType.XA, "xa_khe_mo", 169)
    W_5689 = Ward("Xã Cây Thị", 5689, VietNamDivisionType.XA, "xa_cay_thi", 169)
    W_5692 = Ward("Xã Hóa Thượng", 5692, VietNamDivisionType.XA, "xa_hoa_thuong", 169)
    W_5698 = Ward("Xã Hợp Tiến", 5698, VietNamDivisionType.XA, "xa_hop_tien", 169)
    W_5704 = Ward("Xã Tân Lợi", 5704, VietNamDivisionType.XA, "xa_tan_loi", 169)
    W_5707 = Ward("Xã Nam Hòa", 5707, VietNamDivisionType.XA, "xa_nam_hoa", 169)
    W_5716 = Ward("Thị trấn Đình Cả", 5716, VietNamDivisionType.THI_TRAN, "thi_tran_dinh_ca", 170)
    W_5719 = Ward("Xã Sảng Mộc", 5719, VietNamDivisionType.XA, "xa_sang_moc", 170)
    W_5722 = Ward("Xã Nghinh Tường", 5722, VietNamDivisionType.XA, "xa_nghinh_tuong", 170)
    W_5725 = Ward("Xã Thần Xa", 5725, VietNamDivisionType.XA, "xa_than_xa", 170)
    W_5728 = Ward("Xã Vũ Chấn", 5728, VietNamDivisionType.XA, "xa_vu_chan", 170)
    W_5731 = Ward("Xã Thượng Nung", 5731, VietNamDivisionType.XA, "xa_thuong_nung", 170)
    W_5734 = Ward("Xã Phú Thượng", 5734, VietNamDivisionType.XA, "xa_phu_thuong", 170)
    W_5737 = Ward("Xã Cúc Đường", 5737, VietNamDivisionType.XA, "xa_cuc_duong", 170)
    W_5740 = Ward("Xã La Hiên", 5740, VietNamDivisionType.XA, "xa_la_hien", 170)
    W_5743 = Ward("Xã Lâu Thượng", 5743, VietNamDivisionType.XA, "xa_lau_thuong", 170)
    W_5746 = Ward("Xã Tràng Xá", 5746, VietNamDivisionType.XA, "xa_trang_xa", 170)
    W_5749 = Ward("Xã Phương Giao", 5749, VietNamDivisionType.XA, "xa_phuong_giao", 170)
    W_5752 = Ward("Xã Liên Minh", 5752, VietNamDivisionType.XA, "xa_lien_minh", 170)
    W_5755 = Ward("Xã Dân Tiến", 5755, VietNamDivisionType.XA, "xa_dan_tien", 170)
    W_5758 = Ward("Xã Bình Long", 5758, VietNamDivisionType.XA, "xa_binh_long", 170)
    W_5761 = Ward("Thị trấn Hùng Sơn", 5761, VietNamDivisionType.THI_TRAN, "thi_tran_hung_son", 171)
    W_5764 = Ward("Thị trấn Quân Chu", 5764, VietNamDivisionType.THI_TRAN, "thi_tran_quan_chu", 171)
    W_5767 = Ward("Xã Phúc Lương", 5767, VietNamDivisionType.XA, "xa_phuc_luong", 171)
    W_5770 = Ward("Xã Minh Tiến", 5770, VietNamDivisionType.XA, "xa_minh_tien", 171)
    W_5773 = Ward("Xã Yên Lãng", 5773, VietNamDivisionType.XA, "xa_yen_lang", 171)
    W_5776 = Ward("Xã Đức Lương", 5776, VietNamDivisionType.XA, "xa_duc_luong", 171)
    W_5779 = Ward("Xã Phú Cường", 5779, VietNamDivisionType.XA, "xa_phu_cuong", 171)
    W_5782 = Ward("Xã Na Mao", 5782, VietNamDivisionType.XA, "xa_na_mao", 171)
    W_5785 = Ward("Xã Phú Lạc", 5785, VietNamDivisionType.XA, "xa_phu_lac", 171)
    W_5788 = Ward("Xã Tân Linh", 5788, VietNamDivisionType.XA, "xa_tan_linh", 171)
    W_5791 = Ward("Xã Phú Thịnh", 5791, VietNamDivisionType.XA, "xa_phu_thinh", 171)
    W_5794 = Ward("Xã Phục Linh", 5794, VietNamDivisionType.XA, "xa_phuc_linh", 171)
    W_5797 = Ward("Xã Phú Xuyên", 5797, VietNamDivisionType.XA, "xa_phu_xuyen", 171)
    W_5800 = Ward("Xã Bản Ngoại", 5800, VietNamDivisionType.XA, "xa_ban_ngoai", 171)
    W_5803 = Ward("Xã Tiên Hội", 5803, VietNamDivisionType.XA, "xa_tien_hoi", 171)
    W_5809 = Ward("Xã Cù Vân", 5809, VietNamDivisionType.XA, "xa_cu_van", 171)
    W_5812 = Ward("Xã Hà Thượng", 5812, VietNamDivisionType.XA, "xa_ha_thuong", 171)
    W_5815 = Ward("Xã La Bằng", 5815, VietNamDivisionType.XA, "xa_la_bang", 171)
    W_5818 = Ward("Xã Hoàng Nông", 5818, VietNamDivisionType.XA, "xa_hoang_nong", 171)
    W_5821 = Ward("Xã Khôi Kỳ", 5821, VietNamDivisionType.XA, "xa_khoi_ky", 171)
    W_5824 = Ward("Xã An Khánh", 5824, VietNamDivisionType.XA, "xa_an_khanh", 171)
    W_5827 = Ward("Xã Tân Thái", 5827, VietNamDivisionType.XA, "xa_tan_thai", 171)
    W_5830 = Ward("Xã Bình Thuận", 5830, VietNamDivisionType.XA, "xa_binh_thuan", 171)
    W_5833 = Ward("Xã Lục Ba", 5833, VietNamDivisionType.XA, "xa_luc_ba", 171)
    W_5836 = Ward("Xã Mỹ Yên", 5836, VietNamDivisionType.XA, "xa_my_yen", 171)
    W_5839 = Ward("Xã Vạn Thọ", 5839, VietNamDivisionType.XA, "xa_van_tho", 171)
    W_5842 = Ward("Xã Văn Yên", 5842, VietNamDivisionType.XA, "xa_van_yen", 171)
    W_5845 = Ward("Xã Ký Phú", 5845, VietNamDivisionType.XA, "xa_ky_phu", 171)
    W_5848 = Ward("Xã Cát Nê", 5848, VietNamDivisionType.XA, "xa_cat_ne", 171)
    W_5851 = Ward("Xã Quân Chu", 5851, VietNamDivisionType.XA, "xa_quan_chu", 171)
    W_5854 = Ward("Phường Bãi Bông", 5854, VietNamDivisionType.PHUONG, "phuong_bai_bong", 172)
    W_5857 = Ward("Phường Bắc Sơn", 5857, VietNamDivisionType.PHUONG, "phuong_bac_son", 172)
    W_5860 = Ward("Phường Ba Hàng", 5860, VietNamDivisionType.PHUONG, "phuong_ba_hang", 172)
    W_5863 = Ward("Xã Phúc Tân", 5863, VietNamDivisionType.XA, "xa_phuc_tan", 172)
    W_5866 = Ward("Xã Phúc Thuận", 5866, VietNamDivisionType.XA, "xa_phuc_thuan", 172)
    W_5869 = Ward("Xã Hồng Tiến", 5869, VietNamDivisionType.XA, "xa_hong_tien", 172)
    W_5872 = Ward("Xã Minh Đức", 5872, VietNamDivisionType.XA, "xa_minh_duc", 172)
    W_5875 = Ward("Xã Đắc Sơn", 5875, VietNamDivisionType.XA, "xa_dac_son", 172)
    W_5878 = Ward("Phường Đồng Tiến", 5878, VietNamDivisionType.PHUONG, "phuong_dong_tien", 172)
    W_5881 = Ward("Xã Thành Công", 5881, VietNamDivisionType.XA, "xa_thanh_cong", 172)
    W_5884 = Ward("Xã Tiên Phong", 5884, VietNamDivisionType.XA, "xa_tien_phong", 172)
    W_5887 = Ward("Xã Vạn Phái", 5887, VietNamDivisionType.XA, "xa_van_phai", 172)
    W_5890 = Ward("Xã Nam Tiến", 5890, VietNamDivisionType.XA, "xa_nam_tien", 172)
    W_5893 = Ward("Xã Tân Hương", 5893, VietNamDivisionType.XA, "xa_tan_huong", 172)
    W_5896 = Ward("Xã Đông Cao", 5896, VietNamDivisionType.XA, "xa_dong_cao", 172)
    W_5899 = Ward("Xã Trung Thành", 5899, VietNamDivisionType.XA, "xa_trung_thanh", 172)
    W_5902 = Ward("Xã Tân Phú", 5902, VietNamDivisionType.XA, "xa_tan_phu", 172)
    W_5905 = Ward("Xã Thuận Thành", 5905, VietNamDivisionType.XA, "xa_thuan_thanh", 172)
    W_5908 = Ward("Thị trấn Hương Sơn", 5908, VietNamDivisionType.THI_TRAN, "thi_tran_huong_son", 173)
    W_5911 = Ward("Xã Bàn Đạt", 5911, VietNamDivisionType.XA, "xa_ban_dat", 173)
    W_5917 = Ward("Xã Tân Khánh", 5917, VietNamDivisionType.XA, "xa_tan_khanh", 173)
    W_5920 = Ward("Xã Tân Kim", 5920, VietNamDivisionType.XA, "xa_tan_kim", 173)
    W_5923 = Ward("Xã Tân Thành", 5923, VietNamDivisionType.XA, "xa_tan_thanh", 173)
    W_5926 = Ward("Xã Đào Xá", 5926, VietNamDivisionType.XA, "xa_dao_xa", 173)
    W_5929 = Ward("Xã Bảo Lý", 5929, VietNamDivisionType.XA, "xa_bao_ly", 173)
    W_5932 = Ward("Xã Thượng Đình", 5932, VietNamDivisionType.XA, "xa_thuong_dinh", 173)
    W_5935 = Ward("Xã Tân Hòa", 5935, VietNamDivisionType.XA, "xa_tan_hoa", 173)
    W_5938 = Ward("Xã Nhã Lộng", 5938, VietNamDivisionType.XA, "xa_nha_long", 173)
    W_5941 = Ward("Xã Điềm Thụy", 5941, VietNamDivisionType.XA, "xa_diem_thuy", 173)
    W_5944 = Ward("Xã Xuân Phương", 5944, VietNamDivisionType.XA, "xa_xuan_phuong", 173)
    W_5947 = Ward("Xã Tân Đức", 5947, VietNamDivisionType.XA, "xa_tan_duc", 173)
    W_5950 = Ward("Xã Úc Kỳ", 5950, VietNamDivisionType.XA, "xa_uc_ky", 173)
    W_5953 = Ward("Xã Lương Phú", 5953, VietNamDivisionType.XA, "xa_luong_phu", 173)
    W_5956 = Ward("Xã Nga My", 5956, VietNamDivisionType.XA, "xa_nga_my", 173)
    W_5959 = Ward("Xã Kha Sơn", 5959, VietNamDivisionType.XA, "xa_kha_son", 173)
    W_5962 = Ward("Xã Thanh Ninh", 5962, VietNamDivisionType.XA, "xa_thanh_ninh", 173)
    W_5965 = Ward("Xã Dương Thành", 5965, VietNamDivisionType.XA, "xa_duong_thanh", 173)
    W_5968 = Ward("Xã Hà Châu", 5968, VietNamDivisionType.XA, "xa_ha_chau", 173)
    W_5971 = Ward("Phường Hoàng Văn Thụ", 5971, VietNamDivisionType.PHUONG, "phuong_hoang_van_thu", 178)
    W_5974 = Ward("Phường Tam Thanh", 5974, VietNamDivisionType.PHUONG, "phuong_tam_thanh", 178)
    W_5977 = Ward("Phường Vĩnh Trại", 5977, VietNamDivisionType.PHUONG, "phuong_vinh_trai", 178)
    W_5980 = Ward("Phường Đông Kinh", 5980, VietNamDivisionType.PHUONG, "phuong_dong_kinh", 178)
    W_5983 = Ward("Phường Chi Lăng", 5983, VietNamDivisionType.PHUONG, "phuong_chi_lang", 178)
    W_5986 = Ward("Xã Hoàng Đồng", 5986, VietNamDivisionType.XA, "xa_hoang_dong", 178)
    W_5989 = Ward("Xã Quảng Lạc", 5989, VietNamDivisionType.XA, "xa_quang_lac", 178)
    W_5992 = Ward("Xã Mai Pha", 5992, VietNamDivisionType.XA, "xa_mai_pha", 178)
    W_5995 = Ward("Thị trấn Thất Khê", 5995, VietNamDivisionType.THI_TRAN, "thi_tran_that_khe", 180)
    W_5998 = Ward("Xã Khánh Long", 5998, VietNamDivisionType.XA, "xa_khanh_long", 180)
    W_6001 = Ward("Xã Đoàn Kết", 6001, VietNamDivisionType.XA, "xa_doan_ket", 180)
    W_6004 = Ward("Xã Quốc Khánh", 6004, VietNamDivisionType.XA, "xa_quoc_khanh", 180)
    W_6007 = Ward("Xã Vĩnh Tiến", 6007, VietNamDivisionType.XA, "xa_vinh_tien", 180)
    W_6010 = Ward("Xã Cao Minh", 6010, VietNamDivisionType.XA, "xa_cao_minh", 180)
    W_6013 = Ward("Xã Chí Minh", 6013, VietNamDivisionType.XA, "xa_chi_minh", 180)
    W_6016 = Ward("Xã Tri Phương", 6016, VietNamDivisionType.XA, "xa_tri_phuong", 180)
    W_6019 = Ward("Xã Tân Tiến", 6019, VietNamDivisionType.XA, "xa_tan_tien", 180)
    W_6022 = Ward("Xã Tân Yên", 6022, VietNamDivisionType.XA, "xa_tan_yen", 180)
    W_6025 = Ward("Xã Đội Cấn", 6025, VietNamDivisionType.XA, "xa_doi_can", 180)
    W_6028 = Ward("Xã Tân Minh", 6028, VietNamDivisionType.XA, "xa_tan_minh", 180)
    W_6031 = Ward("Xã Kim Đồng", 6031, VietNamDivisionType.XA, "xa_kim_dong", 180)
    W_6034 = Ward("Xã Chi Lăng", 6034, VietNamDivisionType.XA, "xa_chi_lang", 180)
    W_6037 = Ward("Xã Trung Thành", 6037, VietNamDivisionType.XA, "xa_trung_thanh", 180)
    W_6040 = Ward("Xã Đại Đồng", 6040, VietNamDivisionType.XA, "xa_dai_dong", 180)
    W_6043 = Ward("Xã Đào Viên", 6043, VietNamDivisionType.XA, "xa_dao_vien", 180)
    W_6046 = Ward("Xã Đề Thám", 6046, VietNamDivisionType.XA, "xa_de_tham", 180)
    W_6049 = Ward("Xã Kháng Chiến", 6049, VietNamDivisionType.XA, "xa_khang_chien", 180)
    W_6055 = Ward("Xã Hùng Sơn", 6055, VietNamDivisionType.XA, "xa_hung_son", 180)
    W_6058 = Ward("Xã Quốc Việt", 6058, VietNamDivisionType.XA, "xa_quoc_viet", 180)
    W_6061 = Ward("Xã Hùng Việt", 6061, VietNamDivisionType.XA, "xa_hung_viet", 180)
    W_6067 = Ward("Xã Hưng Đạo", 6067, VietNamDivisionType.XA, "xa_hung_dao", 181)
    W_6070 = Ward("Xã Vĩnh Yên", 6070, VietNamDivisionType.XA, "xa_vinh_yen", 181)
    W_6073 = Ward("Xã Hoa Thám", 6073, VietNamDivisionType.XA, "xa_hoa_tham", 181)
    W_6076 = Ward("Xã Quý Hòa", 6076, VietNamDivisionType.XA, "xa_quy_hoa", 181)
    W_6079 = Ward("Xã Hồng Phong", 6079, VietNamDivisionType.XA, "xa_hong_phong", 181)
    W_6082 = Ward("Xã Yên Lỗ", 6082, VietNamDivisionType.XA, "xa_yen_lo", 181)
    W_6085 = Ward("Xã Thiện Hòa", 6085, VietNamDivisionType.XA, "xa_thien_hoa", 181)
    W_6088 = Ward("Xã Quang Trung", 6088, VietNamDivisionType.XA, "xa_quang_trung", 181)
    W_6091 = Ward("Xã Thiện Thuật", 6091, VietNamDivisionType.XA, "xa_thien_thuat", 181)
    W_6094 = Ward("Xã Minh Khai", 6094, VietNamDivisionType.XA, "xa_minh_khai", 181)
    W_6097 = Ward("Xã Thiện Long", 6097, VietNamDivisionType.XA, "xa_thien_long", 181)
    W_6100 = Ward("Xã Hoàng Văn Thụ", 6100, VietNamDivisionType.XA, "xa_hoang_van_thu", 181)
    W_6103 = Ward("Xã Hòa Bình", 6103, VietNamDivisionType.XA, "xa_hoa_binh", 181)
    W_6106 = Ward("Xã Mông Ân", 6106, VietNamDivisionType.XA, "xa_mong_an", 181)
    W_6109 = Ward("Xã Tân Hòa", 6109, VietNamDivisionType.XA, "xa_tan_hoa", 181)
    W_6112 = Ward("Thị trấn Bình Gia", 6112, VietNamDivisionType.THI_TRAN, "thi_tran_binh_gia", 181)
    W_6115 = Ward("Xã Hồng Thái", 6115, VietNamDivisionType.XA, "xa_hong_thai", 181)
    W_6118 = Ward("Xã Bình La", 6118, VietNamDivisionType.XA, "xa_binh_la", 181)
    W_6121 = Ward("Xã Tân Văn", 6121, VietNamDivisionType.XA, "xa_tan_van", 181)
    W_6124 = Ward("Thị trấn Na Sầm", 6124, VietNamDivisionType.THI_TRAN, "thi_tran_na_sam", 182)
    W_6127 = Ward("Xã Trùng Khánh", 6127, VietNamDivisionType.XA, "xa_trung_khanh", 182)
    W_6133 = Ward("Xã Bắc La", 6133, VietNamDivisionType.XA, "xa_bac_la", 182)
    W_6136 = Ward("Xã Thụy Hùng", 6136, VietNamDivisionType.XA, "xa_thuy_hung", 182)
    W_6139 = Ward("Xã Bắc Hùng", 6139, VietNamDivisionType.XA, "xa_bac_hung", 182)
    W_6142 = Ward("Xã Tân Tác", 6142, VietNamDivisionType.XA, "xa_tan_tac", 182)
    W_6148 = Ward("Xã Thanh Long", 6148, VietNamDivisionType.XA, "xa_thanh_long", 182)
    W_6151 = Ward("Xã Hội Hoan", 6151, VietNamDivisionType.XA, "xa_hoi_hoan", 182)
    W_6154 = Ward("Xã Bắc Việt", 6154, VietNamDivisionType.XA, "xa_bac_viet", 182)
    W_6157 = Ward("Xã Hoàng Việt", 6157, VietNamDivisionType.XA, "xa_hoang_viet", 182)
    W_6160 = Ward("Xã Gia Miễn", 6160, VietNamDivisionType.XA, "xa_gia_mien", 182)
    W_6163 = Ward("Xã Thành Hòa", 6163, VietNamDivisionType.XA, "xa_thanh_hoa", 182)
    W_6166 = Ward("Xã Tân Thanh", 6166, VietNamDivisionType.XA, "xa_tan_thanh", 182)
    W_6172 = Ward("Xã Tân Mỹ", 6172, VietNamDivisionType.XA, "xa_tan_my", 182)
    W_6175 = Ward("Xã Hồng Thái", 6175, VietNamDivisionType.XA, "xa_hong_thai", 182)
    W_6178 = Ward("Xã Hoàng Văn Thụ", 6178, VietNamDivisionType.XA, "xa_hoang_van_thu", 182)
    W_6181 = Ward("Xã Nhạc Kỳ", 6181, VietNamDivisionType.XA, "xa_nhac_ky", 182)
    W_6184 = Ward("Thị trấn Đồng Đăng", 6184, VietNamDivisionType.THI_TRAN, "thi_tran_dong_dang", 183)
    W_6187 = Ward("Thị trấn Cao Lộc", 6187, VietNamDivisionType.THI_TRAN, "thi_tran_cao_loc", 183)
    W_6190 = Ward("Xã Bảo Lâm", 6190, VietNamDivisionType.XA, "xa_bao_lam", 183)
    W_6193 = Ward("Xã Thanh Lòa", 6193, VietNamDivisionType.XA, "xa_thanh_loa", 183)
    W_6196 = Ward("Xã Cao Lâu", 6196, VietNamDivisionType.XA, "xa_cao_lau", 183)
    W_6199 = Ward("Xã Thạch Đạn", 6199, VietNamDivisionType.XA, "xa_thach_dan", 183)
    W_6202 = Ward("Xã Xuất Lễ", 6202, VietNamDivisionType.XA, "xa_xuat_le", 183)
    W_6205 = Ward("Xã Hồng Phong", 6205, VietNamDivisionType.XA, "xa_hong_phong", 183)
    W_6208 = Ward("Xã Thụy Hùng", 6208, VietNamDivisionType.XA, "xa_thuy_hung", 183)
    W_6211 = Ward("Xã Lộc Yên", 6211, VietNamDivisionType.XA, "xa_loc_yen", 183)
    W_6214 = Ward("Xã Phú Xá", 6214, VietNamDivisionType.XA, "xa_phu_xa", 183)
    W_6217 = Ward("Xã Bình Trung", 6217, VietNamDivisionType.XA, "xa_binh_trung", 183)
    W_6220 = Ward("Xã Hải Yến", 6220, VietNamDivisionType.XA, "xa_hai_yen", 183)
    W_6223 = Ward("Xã Hòa Cư", 6223, VietNamDivisionType.XA, "xa_hoa_cu", 183)
    W_6226 = Ward("Xã Hợp Thành", 6226, VietNamDivisionType.XA, "xa_hop_thanh", 183)
    W_6232 = Ward("Xã Công Sơn", 6232, VietNamDivisionType.XA, "xa_cong_son", 183)
    W_6235 = Ward("Xã Gia Cát", 6235, VietNamDivisionType.XA, "xa_gia_cat", 183)
    W_6238 = Ward("Xã Mẫu Sơn", 6238, VietNamDivisionType.XA, "xa_mau_son", 183)
    W_6241 = Ward("Xã Xuân Long", 6241, VietNamDivisionType.XA, "xa_xuan_long", 183)
    W_6244 = Ward("Xã Tân Liên", 6244, VietNamDivisionType.XA, "xa_tan_lien", 183)
    W_6247 = Ward("Xã Yên Trạch", 6247, VietNamDivisionType.XA, "xa_yen_trach", 183)
    W_6250 = Ward("Xã Tân Thành", 6250, VietNamDivisionType.XA, "xa_tan_thanh", 183)
    W_6253 = Ward("Thị trấn Văn Quan", 6253, VietNamDivisionType.THI_TRAN, "thi_tran_van_quan", 184)
    W_6256 = Ward("Xã Trấn Ninh", 6256, VietNamDivisionType.XA, "xa_tran_ninh", 184)
    W_6268 = Ward("Xã Liên Hội", 6268, VietNamDivisionType.XA, "xa_lien_hoi", 184)
    W_6274 = Ward("Xã Hòa Bình", 6274, VietNamDivisionType.XA, "xa_hoa_binh", 184)
    W_6277 = Ward("Xã Tú Xuyên", 6277, VietNamDivisionType.XA, "xa_tu_xuyen", 184)
    W_6280 = Ward("Xã Điềm He", 6280, VietNamDivisionType.XA, "xa_diem_he", 184)
    W_6283 = Ward("Xã An Sơn", 6283, VietNamDivisionType.XA, "xa_an_son", 184)
    W_6286 = Ward("Xã Khánh Khê", 6286, VietNamDivisionType.XA, "xa_khanh_khe", 184)
    W_6292 = Ward("Xã Lương Năng", 6292, VietNamDivisionType.XA, "xa_luong_nang", 184)
    W_6295 = Ward("Xã Đồng Giáp", 6295, VietNamDivisionType.XA, "xa_dong_giap", 184)
    W_6298 = Ward("Xã Bình Phúc", 6298, VietNamDivisionType.XA, "xa_binh_phuc", 184)
    W_6301 = Ward("Xã Tràng Các", 6301, VietNamDivisionType.XA, "xa_trang_cac", 184)
    W_6307 = Ward("Xã Tân Đoàn", 6307, VietNamDivisionType.XA, "xa_tan_doan", 184)
    W_6313 = Ward("Xã Tri Lễ", 6313, VietNamDivisionType.XA, "xa_tri_le", 184)
    W_6316 = Ward("Xã Tràng Phái", 6316, VietNamDivisionType.XA, "xa_trang_phai", 184)
    W_6319 = Ward("Xã Yên Phúc", 6319, VietNamDivisionType.XA, "xa_yen_phuc", 184)
    W_6322 = Ward("Xã Hữu Lễ", 6322, VietNamDivisionType.XA, "xa_huu_le", 184)
    W_6325 = Ward("Thị trấn Bắc Sơn", 6325, VietNamDivisionType.THI_TRAN, "thi_tran_bac_son", 185)
    W_6328 = Ward("Xã Long Đống", 6328, VietNamDivisionType.XA, "xa_long_dong", 185)
    W_6331 = Ward("Xã Vạn Thủy", 6331, VietNamDivisionType.XA, "xa_van_thuy", 185)
    W_6337 = Ward("Xã Đồng ý", 6337, VietNamDivisionType.XA, "xa_dong_y", 185)
    W_6340 = Ward("Xã Tân Tri", 6340, VietNamDivisionType.XA, "xa_tan_tri", 185)
    W_6343 = Ward("Xã Bắc Quỳnh", 6343, VietNamDivisionType.XA, "xa_bac_quynh", 185)
    W_6349 = Ward("Xã Hưng Vũ", 6349, VietNamDivisionType.XA, "xa_hung_vu", 185)
    W_6352 = Ward("Xã Tân Lập", 6352, VietNamDivisionType.XA, "xa_tan_lap", 185)
    W_6355 = Ward("Xã Vũ Sơn", 6355, VietNamDivisionType.XA, "xa_vu_son", 185)
    W_6358 = Ward("Xã Chiêu Vũ", 6358, VietNamDivisionType.XA, "xa_chieu_vu", 185)
    W_6361 = Ward("Xã Tân Hương", 6361, VietNamDivisionType.XA, "xa_tan_huong", 185)
    W_6364 = Ward("Xã Chiến Thắng", 6364, VietNamDivisionType.XA, "xa_chien_thang", 185)
    W_6367 = Ward("Xã Vũ Lăng", 6367, VietNamDivisionType.XA, "xa_vu_lang", 185)
    W_6370 = Ward("Xã Trấn Yên", 6370, VietNamDivisionType.XA, "xa_tran_yen", 185)
    W_6373 = Ward("Xã Vũ Lễ", 6373, VietNamDivisionType.XA, "xa_vu_le", 185)
    W_6376 = Ward("Xã Nhất Hòa", 6376, VietNamDivisionType.XA, "xa_nhat_hoa", 185)
    W_6379 = Ward("Xã Tân Thành", 6379, VietNamDivisionType.XA, "xa_tan_thanh", 185)
    W_6382 = Ward("Xã Nhất Tiến", 6382, VietNamDivisionType.XA, "xa_nhat_tien", 185)
    W_6385 = Ward("Thị trấn Hữu Lũng", 6385, VietNamDivisionType.THI_TRAN, "thi_tran_huu_lung", 186)
    W_6388 = Ward("Xã Hữu Liên", 6388, VietNamDivisionType.XA, "xa_huu_lien", 186)
    W_6391 = Ward("Xã Yên Bình", 6391, VietNamDivisionType.XA, "xa_yen_binh", 186)
    W_6394 = Ward("Xã Quyết Thắng", 6394, VietNamDivisionType.XA, "xa_quyet_thang", 186)
    W_6397 = Ward("Xã Hòa Bình", 6397, VietNamDivisionType.XA, "xa_hoa_binh", 186)
    W_6400 = Ward("Xã Yên Thịnh", 6400, VietNamDivisionType.XA, "xa_yen_thinh", 186)
    W_6403 = Ward("Xã Yên Sơn", 6403, VietNamDivisionType.XA, "xa_yen_son", 186)
    W_6406 = Ward("Xã Thiện Tân", 6406, VietNamDivisionType.XA, "xa_thien_tan", 186)
    W_6412 = Ward("Xã Yên Vượng", 6412, VietNamDivisionType.XA, "xa_yen_vuong", 186)
    W_6415 = Ward("Xã Minh Tiến", 6415, VietNamDivisionType.XA, "xa_minh_tien", 186)
    W_6418 = Ward("Xã Nhật Tiến", 6418, VietNamDivisionType.XA, "xa_nhat_tien", 186)
    W_6421 = Ward("Xã Thanh Sơn", 6421, VietNamDivisionType.XA, "xa_thanh_son", 186)
    W_6424 = Ward("Xã Đồng Tân", 6424, VietNamDivisionType.XA, "xa_dong_tan", 186)
    W_6427 = Ward("Xã Cai Kinh", 6427, VietNamDivisionType.XA, "xa_cai_kinh", 186)
    W_6430 = Ward("Xã Hòa Lạc", 6430, VietNamDivisionType.XA, "xa_hoa_lac", 186)
    W_6433 = Ward("Xã Vân Nham", 6433, VietNamDivisionType.XA, "xa_van_nham", 186)
    W_6436 = Ward("Xã Đồng Tiến", 6436, VietNamDivisionType.XA, "xa_dong_tien", 186)
    W_6442 = Ward("Xã Tân Thành", 6442, VietNamDivisionType.XA, "xa_tan_thanh", 186)
    W_6445 = Ward("Xã Hòa Sơn", 6445, VietNamDivisionType.XA, "xa_hoa_son", 186)
    W_6448 = Ward("Xã Minh Sơn", 6448, VietNamDivisionType.XA, "xa_minh_son", 186)
    W_6451 = Ward("Xã Hồ Sơn", 6451, VietNamDivisionType.XA, "xa_ho_son", 186)
    W_6454 = Ward("Xã Sơn Hà", 6454, VietNamDivisionType.XA, "xa_son_ha", 186)
    W_6457 = Ward("Xã Minh Hòa", 6457, VietNamDivisionType.XA, "xa_minh_hoa", 186)
    W_6460 = Ward("Xã Hòa Thắng", 6460, VietNamDivisionType.XA, "xa_hoa_thang", 186)
    W_6463 = Ward("Thị trấn Đồng Mỏ", 6463, VietNamDivisionType.THI_TRAN, "thi_tran_dong_mo", 187)
    W_6466 = Ward("Thị trấn Chi Lăng", 6466, VietNamDivisionType.THI_TRAN, "thi_tran_chi_lang", 187)
    W_6469 = Ward("Xã Vân An", 6469, VietNamDivisionType.XA, "xa_van_an", 187)
    W_6472 = Ward("Xã Vân Thủy", 6472, VietNamDivisionType.XA, "xa_van_thuy", 187)
    W_6475 = Ward("Xã Gia Lộc", 6475, VietNamDivisionType.XA, "xa_gia_loc", 187)
    W_6478 = Ward("Xã Bắc Thủy", 6478, VietNamDivisionType.XA, "xa_bac_thuy", 187)
    W_6481 = Ward("Xã Chiến Thắng", 6481, VietNamDivisionType.XA, "xa_chien_thang", 187)
    W_6484 = Ward("Xã Mai Sao", 6484, VietNamDivisionType.XA, "xa_mai_sao", 187)
    W_6487 = Ward("Xã Bằng Hữu", 6487, VietNamDivisionType.XA, "xa_bang_huu", 187)
    W_6490 = Ward("Xã Thượng Cường", 6490, VietNamDivisionType.XA, "xa_thuong_cuong", 187)
    W_6493 = Ward("Xã Bằng Mạc", 6493, VietNamDivisionType.XA, "xa_bang_mac", 187)
    W_6496 = Ward("Xã Nhân Lý", 6496, VietNamDivisionType.XA, "xa_nhan_ly", 187)
    W_6499 = Ward("Xã Lâm Sơn", 6499, VietNamDivisionType.XA, "xa_lam_son", 187)
    W_6502 = Ward("Xã Liên Sơn", 6502, VietNamDivisionType.XA, "xa_lien_son", 187)
    W_6505 = Ward("Xã Vạn Linh", 6505, VietNamDivisionType.XA, "xa_van_linh", 187)
    W_6508 = Ward("Xã Hòa Bình", 6508, VietNamDivisionType.XA, "xa_hoa_binh", 187)
    W_6514 = Ward("Xã Hữu Kiên", 6514, VietNamDivisionType.XA, "xa_huu_kien", 187)
    W_6517 = Ward("Xã Quan Sơn", 6517, VietNamDivisionType.XA, "xa_quan_son", 187)
    W_6520 = Ward("Xã Y Tịch", 6520, VietNamDivisionType.XA, "xa_y_tich", 187)
    W_6523 = Ward("Xã Chi Lăng", 6523, VietNamDivisionType.XA, "xa_chi_lang", 187)
    W_6526 = Ward("Thị trấn Na Dương", 6526, VietNamDivisionType.THI_TRAN, "thi_tran_na_duong", 188)
    W_6529 = Ward("Thị trấn Lộc Bình", 6529, VietNamDivisionType.THI_TRAN, "thi_tran_loc_binh", 188)
    W_6532 = Ward("Xã Mẫu Sơn", 6532, VietNamDivisionType.XA, "xa_mau_son", 188)
    W_6541 = Ward("Xã Yên Khoái", 6541, VietNamDivisionType.XA, "xa_yen_khoai", 188)
    W_6544 = Ward("Xã Khánh Xuân", 6544, VietNamDivisionType.XA, "xa_khanh_xuan", 188)
    W_6547 = Ward("Xã Tú Mịch", 6547, VietNamDivisionType.XA, "xa_tu_mich", 188)
    W_6550 = Ward("Xã Hữu Khánh", 6550, VietNamDivisionType.XA, "xa_huu_khanh", 188)
    W_6553 = Ward("Xã Đồng Bục", 6553, VietNamDivisionType.XA, "xa_dong_buc", 188)
    W_6559 = Ward("Xã Tam Gia", 6559, VietNamDivisionType.XA, "xa_tam_gia", 188)
    W_6562 = Ward("Xã Tú Đoạn", 6562, VietNamDivisionType.XA, "xa_tu_doan", 188)
    W_6565 = Ward("Xã Khuất Xá", 6565, VietNamDivisionType.XA, "xa_khuat_xa", 188)
    W_6574 = Ward("Xã Tĩnh Bắc", 6574, VietNamDivisionType.XA, "xa_tinh_bac", 188)
    W_6577 = Ward("Xã Thống Nhất", 6577, VietNamDivisionType.XA, "xa_thong_nhat", 188)
    W_6589 = Ward("Xã Sàn Viên", 6589, VietNamDivisionType.XA, "xa_san_vien", 188)
    W_6592 = Ward("Xã Đông Quan", 6592, VietNamDivisionType.XA, "xa_dong_quan", 188)
    W_6595 = Ward("Xã Minh Hiệp", 6595, VietNamDivisionType.XA, "xa_minh_hiep", 188)
    W_6598 = Ward("Xã Hữu Lân", 6598, VietNamDivisionType.XA, "xa_huu_lan", 188)
    W_6601 = Ward("Xã Lợi Bác", 6601, VietNamDivisionType.XA, "xa_loi_bac", 188)
    W_6604 = Ward("Xã Nam Quan", 6604, VietNamDivisionType.XA, "xa_nam_quan", 188)
    W_6607 = Ward("Xã Xuân Dương", 6607, VietNamDivisionType.XA, "xa_xuan_duong", 188)
    W_6610 = Ward("Xã Ái Quốc", 6610, VietNamDivisionType.XA, "xa_ai_quoc", 188)
    W_6613 = Ward("Thị trấn Đình Lập", 6613, VietNamDivisionType.THI_TRAN, "thi_tran_dinh_lap", 189)
    W_6616 = Ward("Thị trấn NT Thái Bình", 6616, VietNamDivisionType.THI_TRAN, "thi_tran_nt_thai_binh", 189)
    W_6619 = Ward("Xã Bắc Xa", 6619, VietNamDivisionType.XA, "xa_bac_xa", 189)
    W_6622 = Ward("Xã Bính Xá", 6622, VietNamDivisionType.XA, "xa_binh_xa", 189)
    W_6625 = Ward("Xã Kiên Mộc", 6625, VietNamDivisionType.XA, "xa_kien_moc", 189)
    W_6628 = Ward("Xã Đình Lập", 6628, VietNamDivisionType.XA, "xa_dinh_lap", 189)
    W_6631 = Ward("Xã Thái Bình", 6631, VietNamDivisionType.XA, "xa_thai_binh", 189)
    W_6634 = Ward("Xã Cường Lợi", 6634, VietNamDivisionType.XA, "xa_cuong_loi", 189)
    W_6637 = Ward("Xã Châu Sơn", 6637, VietNamDivisionType.XA, "xa_chau_son", 189)
    W_6640 = Ward("Xã Lâm Ca", 6640, VietNamDivisionType.XA, "xa_lam_ca", 189)
    W_6643 = Ward("Xã Đồng Thắng", 6643, VietNamDivisionType.XA, "xa_dong_thang", 189)
    W_6646 = Ward("Xã Bắc Lãng", 6646, VietNamDivisionType.XA, "xa_bac_lang", 189)
    W_6649 = Ward("Phường Hà Khánh", 6649, VietNamDivisionType.PHUONG, "phuong_ha_khanh", 193)
    W_6652 = Ward("Phường Hà Phong", 6652, VietNamDivisionType.PHUONG, "phuong_ha_phong", 193)
    W_6655 = Ward("Phường Hà Khẩu", 6655, VietNamDivisionType.PHUONG, "phuong_ha_khau", 193)
    W_6658 = Ward("Phường Cao Xanh", 6658, VietNamDivisionType.PHUONG, "phuong_cao_xanh", 193)
    W_6661 = Ward("Phường Giếng Đáy", 6661, VietNamDivisionType.PHUONG, "phuong_gieng_day", 193)
    W_6664 = Ward("Phường Hà Tu", 6664, VietNamDivisionType.PHUONG, "phuong_ha_tu", 193)
    W_6667 = Ward("Phường Hà Trung", 6667, VietNamDivisionType.PHUONG, "phuong_ha_trung", 193)
    W_6670 = Ward("Phường Hà Lầm", 6670, VietNamDivisionType.PHUONG, "phuong_ha_lam", 193)
    W_6673 = Ward("Phường Bãi Cháy", 6673, VietNamDivisionType.PHUONG, "phuong_bai_chay", 193)
    W_6676 = Ward("Phường Cao Thắng", 6676, VietNamDivisionType.PHUONG, "phuong_cao_thang", 193)
    W_6679 = Ward("Phường Hùng Thắng", 6679, VietNamDivisionType.PHUONG, "phuong_hung_thang", 193)
    W_6682 = Ward("Phường Yết Kiêu", 6682, VietNamDivisionType.PHUONG, "phuong_yet_kieu", 193)
    W_6685 = Ward("Phường Trần Hưng Đạo", 6685, VietNamDivisionType.PHUONG, "phuong_tran_hung_dao", 193)
    W_6688 = Ward("Phường Hồng Hải", 6688, VietNamDivisionType.PHUONG, "phuong_hong_hai", 193)
    W_6691 = Ward("Phường Hồng Gai", 6691, VietNamDivisionType.PHUONG, "phuong_hong_gai", 193)
    W_6694 = Ward("Phường Bạch Đằng", 6694, VietNamDivisionType.PHUONG, "phuong_bach_dang", 193)
    W_6697 = Ward("Phường Hồng Hà", 6697, VietNamDivisionType.PHUONG, "phuong_hong_ha", 193)
    W_6700 = Ward("Phường Tuần Châu", 6700, VietNamDivisionType.PHUONG, "phuong_tuan_chau", 193)
    W_6703 = Ward("Phường Việt Hưng", 6703, VietNamDivisionType.PHUONG, "phuong_viet_hung", 193)
    W_6706 = Ward("Phường Đại Yên", 6706, VietNamDivisionType.PHUONG, "phuong_dai_yen", 193)
    W_7030 = Ward("Phường Hoành Bồ", 7030, VietNamDivisionType.PHUONG, "phuong_hoanh_bo", 193)
    W_7033 = Ward("Xã Kỳ Thượng", 7033, VietNamDivisionType.XA, "xa_ky_thuong", 193)
    W_7036 = Ward("Xã Đồng Sơn", 7036, VietNamDivisionType.XA, "xa_dong_son", 193)
    W_7039 = Ward("Xã Tân Dân", 7039, VietNamDivisionType.XA, "xa_tan_dan", 193)
    W_7042 = Ward("Xã Đồng Lâm", 7042, VietNamDivisionType.XA, "xa_dong_lam", 193)
    W_7045 = Ward("Xã Hòa Bình", 7045, VietNamDivisionType.XA, "xa_hoa_binh", 193)
    W_7048 = Ward("Xã Vũ Oai", 7048, VietNamDivisionType.XA, "xa_vu_oai", 193)
    W_7051 = Ward("Xã Dân Chủ", 7051, VietNamDivisionType.XA, "xa_dan_chu", 193)
    W_7054 = Ward("Xã Quảng La", 7054, VietNamDivisionType.XA, "xa_quang_la", 193)
    W_7057 = Ward("Xã Bằng Cả", 7057, VietNamDivisionType.XA, "xa_bang_ca", 193)
    W_7060 = Ward("Xã Thống Nhất", 7060, VietNamDivisionType.XA, "xa_thong_nhat", 193)
    W_7063 = Ward("Xã Sơn Dương", 7063, VietNamDivisionType.XA, "xa_son_duong", 193)
    W_7066 = Ward("Xã Lê Lợi", 7066, VietNamDivisionType.XA, "xa_le_loi", 193)
    W_6709 = Ward("Phường Ka Long", 6709, VietNamDivisionType.PHUONG, "phuong_ka_long", 194)
    W_6712 = Ward("Phường Trần Phú", 6712, VietNamDivisionType.PHUONG, "phuong_tran_phu", 194)
    W_6715 = Ward("Phường Ninh Dương", 6715, VietNamDivisionType.PHUONG, "phuong_ninh_duong", 194)
    W_6718 = Ward("Phường Hoà Lạc", 6718, VietNamDivisionType.PHUONG, "phuong_hoa_lac", 194)
    W_6721 = Ward("Phường Trà Cổ", 6721, VietNamDivisionType.PHUONG, "phuong_tra_co", 194)
    W_6724 = Ward("Xã Hải Sơn", 6724, VietNamDivisionType.XA, "xa_hai_son", 194)
    W_6727 = Ward("Xã Bắc Sơn", 6727, VietNamDivisionType.XA, "xa_bac_son", 194)
    W_6730 = Ward("Xã Hải Đông", 6730, VietNamDivisionType.XA, "xa_hai_dong", 194)
    W_6733 = Ward("Xã Hải Tiến", 6733, VietNamDivisionType.XA, "xa_hai_tien", 194)
    W_6736 = Ward("Phường Hải Yên", 6736, VietNamDivisionType.PHUONG, "phuong_hai_yen", 194)
    W_6739 = Ward("Xã Quảng Nghĩa", 6739, VietNamDivisionType.XA, "xa_quang_nghia", 194)
    W_6742 = Ward("Phường Hải Hoà", 6742, VietNamDivisionType.PHUONG, "phuong_hai_hoa", 194)
    W_6745 = Ward("Xã Hải Xuân", 6745, VietNamDivisionType.XA, "xa_hai_xuan", 194)
    W_6748 = Ward("Xã Vạn Ninh", 6748, VietNamDivisionType.XA, "xa_van_ninh", 194)
    W_6751 = Ward("Phường Bình Ngọc", 6751, VietNamDivisionType.PHUONG, "phuong_binh_ngoc", 194)
    W_6754 = Ward("Xã Vĩnh Trung", 6754, VietNamDivisionType.XA, "xa_vinh_trung", 194)
    W_6757 = Ward("Xã Vĩnh Thực", 6757, VietNamDivisionType.XA, "xa_vinh_thuc", 194)
    W_6760 = Ward("Phường Mông Dương", 6760, VietNamDivisionType.PHUONG, "phuong_mong_duong", 195)
    W_6763 = Ward("Phường Cửa Ông", 6763, VietNamDivisionType.PHUONG, "phuong_cua_ong", 195)
    W_6766 = Ward("Phường Cẩm Sơn", 6766, VietNamDivisionType.PHUONG, "phuong_cam_son", 195)
    W_6769 = Ward("Phường Cẩm Đông", 6769, VietNamDivisionType.PHUONG, "phuong_cam_dong", 195)
    W_6772 = Ward("Phường Cẩm Phú", 6772, VietNamDivisionType.PHUONG, "phuong_cam_phu", 195)
    W_6775 = Ward("Phường Cẩm Tây", 6775, VietNamDivisionType.PHUONG, "phuong_cam_tay", 195)
    W_6778 = Ward("Phường Quang Hanh", 6778, VietNamDivisionType.PHUONG, "phuong_quang_hanh", 195)
    W_6781 = Ward("Phường Cẩm Thịnh", 6781, VietNamDivisionType.PHUONG, "phuong_cam_thinh", 195)
    W_6784 = Ward("Phường Cẩm Thủy", 6784, VietNamDivisionType.PHUONG, "phuong_cam_thuy", 195)
    W_6787 = Ward("Phường Cẩm Thạch", 6787, VietNamDivisionType.PHUONG, "phuong_cam_thach", 195)
    W_6790 = Ward("Phường Cẩm Thành", 6790, VietNamDivisionType.PHUONG, "phuong_cam_thanh", 195)
    W_6793 = Ward("Phường Cẩm Trung", 6793, VietNamDivisionType.PHUONG, "phuong_cam_trung", 195)
    W_6796 = Ward("Phường Cẩm Bình", 6796, VietNamDivisionType.PHUONG, "phuong_cam_binh", 195)
    W_6799 = Ward("Xã Cộng Hòa", 6799, VietNamDivisionType.XA, "xa_cong_hoa", 195)
    W_6802 = Ward("Xã Cẩm Hải", 6802, VietNamDivisionType.XA, "xa_cam_hai", 195)
    W_6805 = Ward("Xã Dương Huy", 6805, VietNamDivisionType.XA, "xa_duong_huy", 195)
    W_6808 = Ward("Phường Vàng Danh", 6808, VietNamDivisionType.PHUONG, "phuong_vang_danh", 196)
    W_6811 = Ward("Phường Thanh Sơn", 6811, VietNamDivisionType.PHUONG, "phuong_thanh_son", 196)
    W_6814 = Ward("Phường Bắc Sơn", 6814, VietNamDivisionType.PHUONG, "phuong_bac_son", 196)
    W_6817 = Ward("Phường Quang Trung", 6817, VietNamDivisionType.PHUONG, "phuong_quang_trung", 196)
    W_6820 = Ward("Phường Trưng Vương", 6820, VietNamDivisionType.PHUONG, "phuong_trung_vuong", 196)
    W_6823 = Ward("Phường Nam Khê", 6823, VietNamDivisionType.PHUONG, "phuong_nam_khe", 196)
    W_6826 = Ward("Phường Yên Thanh", 6826, VietNamDivisionType.PHUONG, "phuong_yen_thanh", 196)
    W_6829 = Ward("Xã Thượng Yên Công", 6829, VietNamDivisionType.XA, "xa_thuong_yen_cong", 196)
    W_6832 = Ward("Phường Phương Đông", 6832, VietNamDivisionType.PHUONG, "phuong_phuong_dong", 196)
    W_6835 = Ward("Phường Phương Nam", 6835, VietNamDivisionType.PHUONG, "phuong_phuong_nam", 196)
    W_6838 = Ward("Thị trấn Bình Liêu", 6838, VietNamDivisionType.THI_TRAN, "thi_tran_binh_lieu", 198)
    W_6841 = Ward("Xã Hoành Mô", 6841, VietNamDivisionType.XA, "xa_hoanh_mo", 198)
    W_6844 = Ward("Xã Đồng Tâm", 6844, VietNamDivisionType.XA, "xa_dong_tam", 198)
    W_6847 = Ward("Xã Đồng Văn", 6847, VietNamDivisionType.XA, "xa_dong_van", 198)
    W_6853 = Ward("Xã Vô Ngại", 6853, VietNamDivisionType.XA, "xa_vo_ngai", 198)
    W_6856 = Ward("Xã Lục Hồn", 6856, VietNamDivisionType.XA, "xa_luc_hon", 198)
    W_6859 = Ward("Xã Húc Động", 6859, VietNamDivisionType.XA, "xa_huc_dong", 198)
    W_6862 = Ward("Thị trấn Tiên Yên", 6862, VietNamDivisionType.THI_TRAN, "thi_tran_tien_yen", 199)
    W_6865 = Ward("Xã Hà Lâu", 6865, VietNamDivisionType.XA, "xa_ha_lau", 199)
    W_6868 = Ward("Xã Đại Dực", 6868, VietNamDivisionType.XA, "xa_dai_duc", 199)
    W_6871 = Ward("Xã Phong Dụ", 6871, VietNamDivisionType.XA, "xa_phong_du", 199)
    W_6874 = Ward("Xã Điền Xá", 6874, VietNamDivisionType.XA, "xa_dien_xa", 199)
    W_6877 = Ward("Xã Đông Ngũ", 6877, VietNamDivisionType.XA, "xa_dong_ngu", 199)
    W_6880 = Ward("Xã Yên Than", 6880, VietNamDivisionType.XA, "xa_yen_than", 199)
    W_6883 = Ward("Xã Đông Hải", 6883, VietNamDivisionType.XA, "xa_dong_hai", 199)
    W_6886 = Ward("Xã Hải Lạng", 6886, VietNamDivisionType.XA, "xa_hai_lang", 199)
    W_6889 = Ward("Xã Tiên Lãng", 6889, VietNamDivisionType.XA, "xa_tien_lang", 199)
    W_6892 = Ward("Xã Đồng Rui", 6892, VietNamDivisionType.XA, "xa_dong_rui", 199)
    W_6895 = Ward("Thị trấn Đầm Hà", 6895, VietNamDivisionType.THI_TRAN, "thi_tran_dam_ha", 200)
    W_6898 = Ward("Xã Quảng Lâm", 6898, VietNamDivisionType.XA, "xa_quang_lam", 200)
    W_6901 = Ward("Xã Quảng An", 6901, VietNamDivisionType.XA, "xa_quang_an", 200)
    W_6904 = Ward("Xã Tân Bình", 6904, VietNamDivisionType.XA, "xa_tan_binh", 200)
    W_6910 = Ward("Xã Dực Yên", 6910, VietNamDivisionType.XA, "xa_duc_yen", 200)
    W_6913 = Ward("Xã Quảng Tân", 6913, VietNamDivisionType.XA, "xa_quang_tan", 200)
    W_6916 = Ward("Xã Đầm Hà", 6916, VietNamDivisionType.XA, "xa_dam_ha", 200)
    W_6917 = Ward("Xã Tân Lập", 6917, VietNamDivisionType.XA, "xa_tan_lap", 200)
    W_6919 = Ward("Xã Đại Bình", 6919, VietNamDivisionType.XA, "xa_dai_binh", 200)
    W_6922 = Ward("Thị trấn Quảng Hà", 6922, VietNamDivisionType.THI_TRAN, "thi_tran_quang_ha", 201)
    W_6925 = Ward("Xã Quảng Đức", 6925, VietNamDivisionType.XA, "xa_quang_duc", 201)
    W_6928 = Ward("Xã Quảng Sơn", 6928, VietNamDivisionType.XA, "xa_quang_son", 201)
    W_6931 = Ward("Xã Quảng Thành", 6931, VietNamDivisionType.XA, "xa_quang_thanh", 201)
    W_6937 = Ward("Xã Quảng Thịnh", 6937, VietNamDivisionType.XA, "xa_quang_thinh", 201)
    W_6940 = Ward("Xã Quảng Minh", 6940, VietNamDivisionType.XA, "xa_quang_minh", 201)
    W_6943 = Ward("Xã Quảng Chính", 6943, VietNamDivisionType.XA, "xa_quang_chinh", 201)
    W_6946 = Ward("Xã Quảng Long", 6946, VietNamDivisionType.XA, "xa_quang_long", 201)
    W_6949 = Ward("Xã Đường Hoa", 6949, VietNamDivisionType.XA, "xa_duong_hoa", 201)
    W_6952 = Ward("Xã Quảng Phong", 6952, VietNamDivisionType.XA, "xa_quang_phong", 201)
    W_6967 = Ward("Xã Cái Chiên", 6967, VietNamDivisionType.XA, "xa_cai_chien", 201)
    W_6970 = Ward("Thị trấn Ba Chẽ", 6970, VietNamDivisionType.THI_TRAN, "thi_tran_ba_che", 202)
    W_6973 = Ward("Xã Thanh Sơn", 6973, VietNamDivisionType.XA, "xa_thanh_son", 202)
    W_6976 = Ward("Xã Thanh Lâm", 6976, VietNamDivisionType.XA, "xa_thanh_lam", 202)
    W_6979 = Ward("Xã Đạp Thanh", 6979, VietNamDivisionType.XA, "xa_dap_thanh", 202)
    W_6982 = Ward("Xã Nam Sơn", 6982, VietNamDivisionType.XA, "xa_nam_son", 202)
    W_6985 = Ward("Xã Lương Mông", 6985, VietNamDivisionType.XA, "xa_luong_mong", 202)
    W_6988 = Ward("Xã Đồn Đạc", 6988, VietNamDivisionType.XA, "xa_don_dac", 202)
    W_6991 = Ward("Xã Minh Cầm", 6991, VietNamDivisionType.XA, "xa_minh_cam", 202)
    W_6994 = Ward("Thị trấn Cái Rồng", 6994, VietNamDivisionType.THI_TRAN, "thi_tran_cai_rong", 203)
    W_6997 = Ward("Xã Đài Xuyên", 6997, VietNamDivisionType.XA, "xa_dai_xuyen", 203)
    W_7000 = Ward("Xã Bình Dân", 7000, VietNamDivisionType.XA, "xa_binh_dan", 203)
    W_7003 = Ward("Xã Vạn Yên", 7003, VietNamDivisionType.XA, "xa_van_yen", 203)
    W_7006 = Ward("Xã Minh Châu", 7006, VietNamDivisionType.XA, "xa_minh_chau", 203)
    W_7009 = Ward("Xã Đoàn Kết", 7009, VietNamDivisionType.XA, "xa_doan_ket", 203)
    W_7012 = Ward("Xã Hạ Long", 7012, VietNamDivisionType.XA, "xa_ha_long", 203)
    W_7015 = Ward("Xã Đông Xá", 7015, VietNamDivisionType.XA, "xa_dong_xa", 203)
    W_7018 = Ward("Xã Bản Sen", 7018, VietNamDivisionType.XA, "xa_ban_sen", 203)
    W_7021 = Ward("Xã Thắng Lợi", 7021, VietNamDivisionType.XA, "xa_thang_loi", 203)
    W_7024 = Ward("Xã Quan Lạn", 7024, VietNamDivisionType.XA, "xa_quan_lan", 203)
    W_7027 = Ward("Xã Ngọc Vừng", 7027, VietNamDivisionType.XA, "xa_ngoc_vung", 203)
    W_7069 = Ward("Phường Mạo Khê", 7069, VietNamDivisionType.PHUONG, "phuong_mao_khe", 205)
    W_7072 = Ward("Phường Đông Triều", 7072, VietNamDivisionType.PHUONG, "phuong_dong_trieu", 205)
    W_7075 = Ward("Xã An Sinh", 7075, VietNamDivisionType.XA, "xa_an_sinh", 205)
    W_7078 = Ward("Xã Tràng Lương", 7078, VietNamDivisionType.XA, "xa_trang_luong", 205)
    W_7081 = Ward("Xã Bình Khê", 7081, VietNamDivisionType.XA, "xa_binh_khe", 205)
    W_7084 = Ward("Xã Việt Dân", 7084, VietNamDivisionType.XA, "xa_viet_dan", 205)
    W_7087 = Ward("Xã Tân Việt", 7087, VietNamDivisionType.XA, "xa_tan_viet", 205)
    W_7090 = Ward("Xã Bình Dương", 7090, VietNamDivisionType.XA, "xa_binh_duong", 205)
    W_7093 = Ward("Phường Đức Chính", 7093, VietNamDivisionType.PHUONG, "phuong_duc_chinh", 205)
    W_7096 = Ward("Phường Tràng An", 7096, VietNamDivisionType.PHUONG, "phuong_trang_an", 205)
    W_7099 = Ward("Xã Nguyễn Huệ", 7099, VietNamDivisionType.XA, "xa_nguyen_hue", 205)
    W_7102 = Ward("Xã Thủy An", 7102, VietNamDivisionType.XA, "xa_thuy_an", 205)
    W_7105 = Ward("Phường Xuân Sơn", 7105, VietNamDivisionType.PHUONG, "phuong_xuan_son", 205)
    W_7108 = Ward("Xã Hồng Thái Tây", 7108, VietNamDivisionType.XA, "xa_hong_thai_tay", 205)
    W_7111 = Ward("Xã Hồng Thái Đông", 7111, VietNamDivisionType.XA, "xa_hong_thai_dong", 205)
    W_7114 = Ward("Phường Hoàng Quế", 7114, VietNamDivisionType.PHUONG, "phuong_hoang_que", 205)
    W_7117 = Ward("Phường Yên Thọ", 7117, VietNamDivisionType.PHUONG, "phuong_yen_tho", 205)
    W_7120 = Ward("Phường Hồng Phong", 7120, VietNamDivisionType.PHUONG, "phuong_hong_phong", 205)
    W_7123 = Ward("Phường Kim Sơn", 7123, VietNamDivisionType.PHUONG, "phuong_kim_son", 205)
    W_7126 = Ward("Phường Hưng Đạo", 7126, VietNamDivisionType.PHUONG, "phuong_hung_dao", 205)
    W_7129 = Ward("Xã Yên Đức", 7129, VietNamDivisionType.XA, "xa_yen_duc", 205)
    W_7132 = Ward("Phường Quảng Yên", 7132, VietNamDivisionType.PHUONG, "phuong_quang_yen", 206)
    W_7135 = Ward("Phường Đông Mai", 7135, VietNamDivisionType.PHUONG, "phuong_dong_mai", 206)
    W_7138 = Ward("Phường Minh Thành", 7138, VietNamDivisionType.PHUONG, "phuong_minh_thanh", 206)
    W_7144 = Ward("Xã Sông Khoai", 7144, VietNamDivisionType.XA, "xa_song_khoai", 206)
    W_7147 = Ward("Xã Hiệp Hòa", 7147, VietNamDivisionType.XA, "xa_hiep_hoa", 206)
    W_7150 = Ward("Phường Cộng Hòa", 7150, VietNamDivisionType.PHUONG, "phuong_cong_hoa", 206)
    W_7153 = Ward("Xã Tiền An", 7153, VietNamDivisionType.XA, "xa_tien_an", 206)
    W_7156 = Ward("Xã Hoàng Tân", 7156, VietNamDivisionType.XA, "xa_hoang_tan", 206)
    W_7159 = Ward("Phường Tân An", 7159, VietNamDivisionType.PHUONG, "phuong_tan_an", 206)
    W_7162 = Ward("Phường Yên Giang", 7162, VietNamDivisionType.PHUONG, "phuong_yen_giang", 206)
    W_7165 = Ward("Phường Nam Hoà", 7165, VietNamDivisionType.PHUONG, "phuong_nam_hoa", 206)
    W_7168 = Ward("Phường Hà An", 7168, VietNamDivisionType.PHUONG, "phuong_ha_an", 206)
    W_7171 = Ward("Xã Cẩm La", 7171, VietNamDivisionType.XA, "xa_cam_la", 206)
    W_7174 = Ward("Phường Phong Hải", 7174, VietNamDivisionType.PHUONG, "phuong_phong_hai", 206)
    W_7177 = Ward("Phường Yên Hải", 7177, VietNamDivisionType.PHUONG, "phuong_yen_hai", 206)
    W_7180 = Ward("Xã Liên Hòa", 7180, VietNamDivisionType.XA, "xa_lien_hoa", 206)
    W_7183 = Ward("Phường Phong Cốc", 7183, VietNamDivisionType.PHUONG, "phuong_phong_coc", 206)
    W_7186 = Ward("Xã Liên Vị", 7186, VietNamDivisionType.XA, "xa_lien_vi", 206)
    W_7189 = Ward("Xã Tiền Phong", 7189, VietNamDivisionType.XA, "xa_tien_phong", 206)
    W_7192 = Ward("Thị trấn Cô Tô", 7192, VietNamDivisionType.THI_TRAN, "thi_tran_co_to", 207)
    W_7195 = Ward("Xã Đồng Tiến", 7195, VietNamDivisionType.XA, "xa_dong_tien", 207)
    W_7198 = Ward("Xã Thanh Lân", 7198, VietNamDivisionType.XA, "xa_thanh_lan", 207)
    W_7201 = Ward("Phường Thọ Xương", 7201, VietNamDivisionType.PHUONG, "phuong_tho_xuong", 213)
    W_7204 = Ward("Phường Trần Nguyên Hãn", 7204, VietNamDivisionType.PHUONG, "phuong_tran_nguyen_han", 213)
    W_7207 = Ward("Phường Ngô Quyền", 7207, VietNamDivisionType.PHUONG, "phuong_ngo_quyen", 213)
    W_7210 = Ward("Phường Hoàng Văn Thụ", 7210, VietNamDivisionType.PHUONG, "phuong_hoang_van_thu", 213)
    W_7213 = Ward("Phường Trần Phú", 7213, VietNamDivisionType.PHUONG, "phuong_tran_phu", 213)
    W_7216 = Ward("Phường Mỹ Độ", 7216, VietNamDivisionType.PHUONG, "phuong_my_do", 213)
    W_7219 = Ward("Phường Lê Lợi", 7219, VietNamDivisionType.PHUONG, "phuong_le_loi", 213)
    W_7222 = Ward("Xã Song Mai", 7222, VietNamDivisionType.XA, "xa_song_mai", 213)
    W_7225 = Ward("Phường Xương Giang", 7225, VietNamDivisionType.PHUONG, "phuong_xuong_giang", 213)
    W_7228 = Ward("Phường Đa Mai", 7228, VietNamDivisionType.PHUONG, "phuong_da_mai", 213)
    W_7231 = Ward("Phường Dĩnh Kế", 7231, VietNamDivisionType.PHUONG, "phuong_dinh_ke", 213)
    W_7441 = Ward("Xã Dĩnh Trì", 7441, VietNamDivisionType.XA, "xa_dinh_tri", 213)
    W_7687 = Ward("Xã Tân Mỹ", 7687, VietNamDivisionType.XA, "xa_tan_my", 213)
    W_7696 = Ward("Xã Đồng Sơn", 7696, VietNamDivisionType.XA, "xa_dong_son", 213)
    W_7699 = Ward("Xã Tân Tiến", 7699, VietNamDivisionType.XA, "xa_tan_tien", 213)
    W_7705 = Ward("Xã Song Khê", 7705, VietNamDivisionType.XA, "xa_song_khe", 213)
    W_7243 = Ward("Xã Đồng Tiến", 7243, VietNamDivisionType.XA, "xa_dong_tien", 215)
    W_7246 = Ward("Xã Canh Nậu", 7246, VietNamDivisionType.XA, "xa_canh_nau", 215)
    W_7249 = Ward("Xã Xuân Lương", 7249, VietNamDivisionType.XA, "xa_xuan_luong", 215)
    W_7252 = Ward("Xã Tam Tiến", 7252, VietNamDivisionType.XA, "xa_tam_tien", 215)
    W_7255 = Ward("Xã Đồng Vương", 7255, VietNamDivisionType.XA, "xa_dong_vuong", 215)
    W_7258 = Ward("Xã Đồng Hưu", 7258, VietNamDivisionType.XA, "xa_dong_huu", 215)
    W_7260 = Ward("Xã Đồng Tâm", 7260, VietNamDivisionType.XA, "xa_dong_tam", 215)
    W_7261 = Ward("Xã Tam Hiệp", 7261, VietNamDivisionType.XA, "xa_tam_hiep", 215)
    W_7264 = Ward("Xã Tiến Thắng", 7264, VietNamDivisionType.XA, "xa_tien_thang", 215)
    W_7267 = Ward("Xã Hồng Kỳ", 7267, VietNamDivisionType.XA, "xa_hong_ky", 215)
    W_7270 = Ward("Xã Đồng Lạc", 7270, VietNamDivisionType.XA, "xa_dong_lac", 215)
    W_7273 = Ward("Xã Đông Sơn", 7273, VietNamDivisionType.XA, "xa_dong_son", 215)
    W_7276 = Ward("Xã Tân Hiệp", 7276, VietNamDivisionType.XA, "xa_tan_hiep", 215)
    W_7279 = Ward("Xã Hương Vĩ", 7279, VietNamDivisionType.XA, "xa_huong_vi", 215)
    W_7282 = Ward("Xã Đồng Kỳ", 7282, VietNamDivisionType.XA, "xa_dong_ky", 215)
    W_7285 = Ward("Xã An Thượng", 7285, VietNamDivisionType.XA, "xa_an_thuong", 215)
    W_7288 = Ward("Thị trấn Phồn Xương", 7288, VietNamDivisionType.THI_TRAN, "thi_tran_phon_xuong", 215)
    W_7291 = Ward("Xã Tân Sỏi", 7291, VietNamDivisionType.XA, "xa_tan_soi", 215)
    W_7294 = Ward("Thị trấn Bố Hạ", 7294, VietNamDivisionType.THI_TRAN, "thi_tran_bo_ha", 215)
    W_7303 = Ward("Xã Lan Giới", 7303, VietNamDivisionType.XA, "xa_lan_gioi", 216)
    W_7306 = Ward("Thị trấn Nhã Nam", 7306, VietNamDivisionType.THI_TRAN, "thi_tran_nha_nam", 216)
    W_7309 = Ward("Xã Tân Trung", 7309, VietNamDivisionType.XA, "xa_tan_trung", 216)
    W_7312 = Ward("Xã Đại Hóa", 7312, VietNamDivisionType.XA, "xa_dai_hoa", 216)
    W_7315 = Ward("Xã Quang Tiến", 7315, VietNamDivisionType.XA, "xa_quang_tien", 216)
    W_7318 = Ward("Xã Phúc Sơn", 7318, VietNamDivisionType.XA, "xa_phuc_son", 216)
    W_7321 = Ward("Xã An Dương", 7321, VietNamDivisionType.XA, "xa_an_duong", 216)
    W_7324 = Ward("Xã Phúc Hòa", 7324, VietNamDivisionType.XA, "xa_phuc_hoa", 216)
    W_7327 = Ward("Xã Liên Sơn", 7327, VietNamDivisionType.XA, "xa_lien_son", 216)
    W_7330 = Ward("Xã Hợp Đức", 7330, VietNamDivisionType.XA, "xa_hop_duc", 216)
    W_7333 = Ward("Xã Lam Cốt", 7333, VietNamDivisionType.XA, "xa_lam_cot", 216)
    W_7336 = Ward("Xã Cao Xá", 7336, VietNamDivisionType.XA, "xa_cao_xa", 216)
    W_7339 = Ward("Thị trấn Cao Thượng", 7339, VietNamDivisionType.THI_TRAN, "thi_tran_cao_thuong", 216)
    W_7342 = Ward("Xã Việt Ngọc", 7342, VietNamDivisionType.XA, "xa_viet_ngoc", 216)
    W_7345 = Ward("Xã Song Vân", 7345, VietNamDivisionType.XA, "xa_song_van", 216)
    W_7348 = Ward("Xã Ngọc Châu", 7348, VietNamDivisionType.XA, "xa_ngoc_chau", 216)
    W_7351 = Ward("Xã Ngọc Vân", 7351, VietNamDivisionType.XA, "xa_ngoc_van", 216)
    W_7354 = Ward("Xã Việt Lập", 7354, VietNamDivisionType.XA, "xa_viet_lap", 216)
    W_7357 = Ward("Xã Liên Chung", 7357, VietNamDivisionType.XA, "xa_lien_chung", 216)
    W_7360 = Ward("Xã Ngọc Thiện", 7360, VietNamDivisionType.XA, "xa_ngoc_thien", 216)
    W_7363 = Ward("Xã Ngọc Lý", 7363, VietNamDivisionType.XA, "xa_ngoc_ly", 216)
    W_7366 = Ward("Xã Quế Nham", 7366, VietNamDivisionType.XA, "xa_que_nham", 216)
    W_7375 = Ward("Thị trấn Vôi", 7375, VietNamDivisionType.THI_TRAN, "thi_tran_voi", 217)
    W_7378 = Ward("Xã Nghĩa Hòa", 7378, VietNamDivisionType.XA, "xa_nghia_hoa", 217)
    W_7381 = Ward("Xã Nghĩa Hưng", 7381, VietNamDivisionType.XA, "xa_nghia_hung", 217)
    W_7384 = Ward("Xã Quang Thịnh", 7384, VietNamDivisionType.XA, "xa_quang_thinh", 217)
    W_7387 = Ward("Xã Hương Sơn", 7387, VietNamDivisionType.XA, "xa_huong_son", 217)
    W_7390 = Ward("Xã Đào Mỹ", 7390, VietNamDivisionType.XA, "xa_dao_my", 217)
    W_7393 = Ward("Xã Tiên Lục", 7393, VietNamDivisionType.XA, "xa_tien_luc", 217)
    W_7396 = Ward("Xã An Hà", 7396, VietNamDivisionType.XA, "xa_an_ha", 217)
    W_7399 = Ward("Thị trấn Kép", 7399, VietNamDivisionType.THI_TRAN, "thi_tran_kep", 217)
    W_7402 = Ward("Xã Mỹ Hà", 7402, VietNamDivisionType.XA, "xa_my_ha", 217)
    W_7405 = Ward("Xã Hương Lạc", 7405, VietNamDivisionType.XA, "xa_huong_lac", 217)
    W_7408 = Ward("Xã Dương Đức", 7408, VietNamDivisionType.XA, "xa_duong_duc", 217)
    W_7411 = Ward("Xã Tân Thanh", 7411, VietNamDivisionType.XA, "xa_tan_thanh", 217)
    W_7414 = Ward("Xã Yên Mỹ", 7414, VietNamDivisionType.XA, "xa_yen_my", 217)
    W_7417 = Ward("Xã Tân Hưng", 7417, VietNamDivisionType.XA, "xa_tan_hung", 217)
    W_7420 = Ward("Xã Mỹ Thái", 7420, VietNamDivisionType.XA, "xa_my_thai", 217)
    W_7426 = Ward("Xã Xương Lâm", 7426, VietNamDivisionType.XA, "xa_xuong_lam", 217)
    W_7429 = Ward("Xã Xuân Hương", 7429, VietNamDivisionType.XA, "xa_xuan_huong", 217)
    W_7432 = Ward("Xã Tân Dĩnh", 7432, VietNamDivisionType.XA, "xa_tan_dinh", 217)
    W_7435 = Ward("Xã Đại Lâm", 7435, VietNamDivisionType.XA, "xa_dai_lam", 217)
    W_7438 = Ward("Xã Thái Đào", 7438, VietNamDivisionType.XA, "xa_thai_dao", 217)
    W_7444 = Ward("Thị trấn Đồi Ngô", 7444, VietNamDivisionType.THI_TRAN, "thi_tran_doi_ngo", 218)
    W_7450 = Ward("Xã Đông Hưng", 7450, VietNamDivisionType.XA, "xa_dong_hung", 218)
    W_7453 = Ward("Xã Đông Phú", 7453, VietNamDivisionType.XA, "xa_dong_phu", 218)
    W_7456 = Ward("Xã Tam Dị", 7456, VietNamDivisionType.XA, "xa_tam_di", 218)
    W_7459 = Ward("Xã Bảo Sơn", 7459, VietNamDivisionType.XA, "xa_bao_son", 218)
    W_7462 = Ward("Xã Bảo Đài", 7462, VietNamDivisionType.XA, "xa_bao_dai", 218)
    W_7465 = Ward("Xã Thanh Lâm", 7465, VietNamDivisionType.XA, "xa_thanh_lam", 218)
    W_7468 = Ward("Xã Tiên Nha", 7468, VietNamDivisionType.XA, "xa_tien_nha", 218)
    W_7471 = Ward("Xã Trường Giang", 7471, VietNamDivisionType.XA, "xa_truong_giang", 218)
    W_7477 = Ward("Xã Phương Sơn", 7477, VietNamDivisionType.XA, "xa_phuong_son", 218)
    W_7480 = Ward("Xã Chu Điện", 7480, VietNamDivisionType.XA, "xa_chu_dien", 218)
    W_7483 = Ward("Xã Cương Sơn", 7483, VietNamDivisionType.XA, "xa_cuong_son", 218)
    W_7486 = Ward("Xã Nghĩa Phương", 7486, VietNamDivisionType.XA, "xa_nghia_phuong", 218)
    W_7489 = Ward("Xã Vô Tranh", 7489, VietNamDivisionType.XA, "xa_vo_tranh", 218)
    W_7492 = Ward("Xã Bình Sơn", 7492, VietNamDivisionType.XA, "xa_binh_son", 218)
    W_7495 = Ward("Xã Lan Mẫu", 7495, VietNamDivisionType.XA, "xa_lan_mau", 218)
    W_7498 = Ward("Xã Yên Sơn", 7498, VietNamDivisionType.XA, "xa_yen_son", 218)
    W_7501 = Ward("Xã Khám Lạng", 7501, VietNamDivisionType.XA, "xa_kham_lang", 218)
    W_7504 = Ward("Xã Huyền Sơn", 7504, VietNamDivisionType.XA, "xa_huyen_son", 218)
    W_7507 = Ward("Xã Trường Sơn", 7507, VietNamDivisionType.XA, "xa_truong_son", 218)
    W_7510 = Ward("Xã Lục Sơn", 7510, VietNamDivisionType.XA, "xa_luc_son", 218)
    W_7513 = Ward("Xã Bắc Lũng", 7513, VietNamDivisionType.XA, "xa_bac_lung", 218)
    W_7516 = Ward("Xã Vũ Xá", 7516, VietNamDivisionType.XA, "xa_vu_xa", 218)
    W_7519 = Ward("Xã Cẩm Lý", 7519, VietNamDivisionType.XA, "xa_cam_ly", 218)
    W_7522 = Ward("Xã Đan Hội", 7522, VietNamDivisionType.XA, "xa_dan_hoi", 218)
    W_7525 = Ward("Thị trấn Chũ", 7525, VietNamDivisionType.THI_TRAN, "thi_tran_chu", 219)
    W_7528 = Ward("Xã Cấm Sơn", 7528, VietNamDivisionType.XA, "xa_cam_son", 219)
    W_7531 = Ward("Xã Tân Sơn", 7531, VietNamDivisionType.XA, "xa_tan_son", 219)
    W_7534 = Ward("Xã Phong Minh", 7534, VietNamDivisionType.XA, "xa_phong_minh", 219)
    W_7537 = Ward("Xã Phong Vân", 7537, VietNamDivisionType.XA, "xa_phong_van", 219)
    W_7540 = Ward("Xã Xa Lý", 7540, VietNamDivisionType.XA, "xa_xa_ly", 219)
    W_7543 = Ward("Xã Hộ Đáp", 7543, VietNamDivisionType.XA, "xa_ho_dap", 219)
    W_7546 = Ward("Xã Sơn Hải", 7546, VietNamDivisionType.XA, "xa_son_hai", 219)
    W_7549 = Ward("Xã Thanh Hải", 7549, VietNamDivisionType.XA, "xa_thanh_hai", 219)
    W_7552 = Ward("Xã Kiên Lao", 7552, VietNamDivisionType.XA, "xa_kien_lao", 219)
    W_7555 = Ward("Xã Biên Sơn", 7555, VietNamDivisionType.XA, "xa_bien_son", 219)
    W_7558 = Ward("Xã Kiên Thành", 7558, VietNamDivisionType.XA, "xa_kien_thanh", 219)
    W_7561 = Ward("Xã Hồng Giang", 7561, VietNamDivisionType.XA, "xa_hong_giang", 219)
    W_7564 = Ward("Xã Kim Sơn", 7564, VietNamDivisionType.XA, "xa_kim_son", 219)
    W_7567 = Ward("Xã Tân Hoa", 7567, VietNamDivisionType.XA, "xa_tan_hoa", 219)
    W_7570 = Ward("Xã Giáp Sơn", 7570, VietNamDivisionType.XA, "xa_giap_son", 219)
    W_7573 = Ward("Xã Biển Động", 7573, VietNamDivisionType.XA, "xa_bien_dong", 219)
    W_7576 = Ward("Xã Quý Sơn", 7576, VietNamDivisionType.XA, "xa_quy_son", 219)
    W_7579 = Ward("Xã Trù Hựu", 7579, VietNamDivisionType.XA, "xa_tru_huu", 219)
    W_7582 = Ward("Xã Phì Điền", 7582, VietNamDivisionType.XA, "xa_phi_dien", 219)
    W_7588 = Ward("Xã Tân Quang", 7588, VietNamDivisionType.XA, "xa_tan_quang", 219)
    W_7591 = Ward("Xã Đồng Cốc", 7591, VietNamDivisionType.XA, "xa_dong_coc", 219)
    W_7594 = Ward("Xã Tân Lập", 7594, VietNamDivisionType.XA, "xa_tan_lap", 219)
    W_7597 = Ward("Xã Phú Nhuận", 7597, VietNamDivisionType.XA, "xa_phu_nhuan", 219)
    W_7600 = Ward("Xã Mỹ An", 7600, VietNamDivisionType.XA, "xa_my_an", 219)
    W_7603 = Ward("Xã Nam Dương", 7603, VietNamDivisionType.XA, "xa_nam_duong", 219)
    W_7606 = Ward("Xã Tân Mộc", 7606, VietNamDivisionType.XA, "xa_tan_moc", 219)
    W_7609 = Ward("Xã Đèo Gia", 7609, VietNamDivisionType.XA, "xa_deo_gia", 219)
    W_7612 = Ward("Xã Phượng Sơn", 7612, VietNamDivisionType.XA, "xa_phuong_son", 219)
    W_7615 = Ward("Thị trấn An Châu", 7615, VietNamDivisionType.THI_TRAN, "thi_tran_an_chau", 220)
    W_7616 = Ward("Thị trấn Tây Yên Tử", 7616, VietNamDivisionType.THI_TRAN, "thi_tran_tay_yen_tu", 220)
    W_7621 = Ward("Xã Vân Sơn", 7621, VietNamDivisionType.XA, "xa_van_son", 220)
    W_7624 = Ward("Xã Hữu Sản", 7624, VietNamDivisionType.XA, "xa_huu_san", 220)
    W_7627 = Ward("Xã Đại Sơn", 7627, VietNamDivisionType.XA, "xa_dai_son", 220)
    W_7630 = Ward("Xã Phúc Sơn", 7630, VietNamDivisionType.XA, "xa_phuc_son", 220)
    W_7636 = Ward("Xã Giáo Liêm", 7636, VietNamDivisionType.XA, "xa_giao_liem", 220)
    W_7642 = Ward("Xã Cẩm Đàn", 7642, VietNamDivisionType.XA, "xa_cam_dan", 220)
    W_7645 = Ward("Xã An Lạc", 7645, VietNamDivisionType.XA, "xa_an_lac", 220)
    W_7648 = Ward("Xã Vĩnh An", 7648, VietNamDivisionType.XA, "xa_vinh_an", 220)
    W_7651 = Ward("Xã Yên Định", 7651, VietNamDivisionType.XA, "xa_yen_dinh", 220)
    W_7654 = Ward("Xã Lệ Viễn", 7654, VietNamDivisionType.XA, "xa_le_vien", 220)
    W_7660 = Ward("Xã An Bá", 7660, VietNamDivisionType.XA, "xa_an_ba", 220)
    W_7663 = Ward("Xã Tuấn Đạo", 7663, VietNamDivisionType.XA, "xa_tuan_dao", 220)
    W_7666 = Ward("Xã Dương Hưu", 7666, VietNamDivisionType.XA, "xa_duong_huu", 220)
    W_7672 = Ward("Xã Long Sơn", 7672, VietNamDivisionType.XA, "xa_long_son", 220)
    W_7678 = Ward("Xã Thanh Luận", 7678, VietNamDivisionType.XA, "xa_thanh_luan", 220)
    W_7681 = Ward("Thị trấn Nham Biền", 7681, VietNamDivisionType.THI_TRAN, "thi_tran_nham_bien", 221)
    W_7682 = Ward("Thị trấn Tân An", 7682, VietNamDivisionType.THI_TRAN, "thi_tran_tan_an", 221)
    W_7684 = Ward("Xã Lão Hộ", 7684, VietNamDivisionType.XA, "xa_lao_ho", 221)
    W_7690 = Ward("Xã Hương Gián", 7690, VietNamDivisionType.XA, "xa_huong_gian", 221)
    W_7702 = Ward("Xã Quỳnh Sơn", 7702, VietNamDivisionType.XA, "xa_quynh_son", 221)
    W_7708 = Ward("Xã Nội Hoàng", 7708, VietNamDivisionType.XA, "xa_noi_hoang", 221)
    W_7711 = Ward("Xã Tiền Phong", 7711, VietNamDivisionType.XA, "xa_tien_phong", 221)
    W_7714 = Ward("Xã Xuân Phú", 7714, VietNamDivisionType.XA, "xa_xuan_phu", 221)
    W_7717 = Ward("Xã Tân Liễu", 7717, VietNamDivisionType.XA, "xa_tan_lieu", 221)
    W_7720 = Ward("Xã Trí Yên", 7720, VietNamDivisionType.XA, "xa_tri_yen", 221)
    W_7723 = Ward("Xã Lãng Sơn", 7723, VietNamDivisionType.XA, "xa_lang_son", 221)
    W_7726 = Ward("Xã Yên Lư", 7726, VietNamDivisionType.XA, "xa_yen_lu", 221)
    W_7729 = Ward("Xã Tiến Dũng", 7729, VietNamDivisionType.XA, "xa_tien_dung", 221)
    W_7735 = Ward("Xã Đức Giang", 7735, VietNamDivisionType.XA, "xa_duc_giang", 221)
    W_7738 = Ward("Xã Cảnh Thụy", 7738, VietNamDivisionType.XA, "xa_canh_thuy", 221)
    W_7741 = Ward("Xã Tư Mại", 7741, VietNamDivisionType.XA, "xa_tu_mai", 221)
    W_7747 = Ward("Xã Đồng Việt", 7747, VietNamDivisionType.XA, "xa_dong_viet", 221)
    W_7750 = Ward("Xã Đồng Phúc", 7750, VietNamDivisionType.XA, "xa_dong_phuc", 221)
    W_7759 = Ward("Xã Thượng Lan", 7759, VietNamDivisionType.XA, "xa_thuong_lan", 222)
    W_7762 = Ward("Xã Việt Tiến", 7762, VietNamDivisionType.XA, "xa_viet_tien", 222)
    W_7765 = Ward("Xã Nghĩa Trung", 7765, VietNamDivisionType.XA, "xa_nghia_trung", 222)
    W_7768 = Ward("Xã Minh Đức", 7768, VietNamDivisionType.XA, "xa_minh_duc", 222)
    W_7771 = Ward("Xã Hương Mai", 7771, VietNamDivisionType.XA, "xa_huong_mai", 222)
    W_7774 = Ward("Xã Tự Lạn", 7774, VietNamDivisionType.XA, "xa_tu_lan", 222)
    W_7777 = Ward("Thị trấn Bích Động", 7777, VietNamDivisionType.THI_TRAN, "thi_tran_bich_dong", 222)
    W_7780 = Ward("Xã Trung Sơn", 7780, VietNamDivisionType.XA, "xa_trung_son", 222)
    W_7783 = Ward("Xã Hồng Thái", 7783, VietNamDivisionType.XA, "xa_hong_thai", 222)
    W_7786 = Ward("Xã Tiên Sơn", 7786, VietNamDivisionType.XA, "xa_tien_son", 222)
    W_7789 = Ward("Xã Tăng Tiến", 7789, VietNamDivisionType.XA, "xa_tang_tien", 222)
    W_7792 = Ward("Xã Quảng Minh", 7792, VietNamDivisionType.XA, "xa_quang_minh", 222)
    W_7795 = Ward("Thị trấn Nếnh", 7795, VietNamDivisionType.THI_TRAN, "thi_tran_nenh", 222)
    W_7798 = Ward("Xã Ninh Sơn", 7798, VietNamDivisionType.XA, "xa_ninh_son", 222)
    W_7801 = Ward("Xã Vân Trung", 7801, VietNamDivisionType.XA, "xa_van_trung", 222)
    W_7804 = Ward("Xã Vân Hà", 7804, VietNamDivisionType.XA, "xa_van_ha", 222)
    W_7807 = Ward("Xã Quang Châu", 7807, VietNamDivisionType.XA, "xa_quang_chau", 222)
    W_7813 = Ward("Xã Đồng Tân", 7813, VietNamDivisionType.XA, "xa_dong_tan", 223)
    W_7816 = Ward("Xã Thanh Vân", 7816, VietNamDivisionType.XA, "xa_thanh_van", 223)
    W_7819 = Ward("Xã Hoàng Lương", 7819, VietNamDivisionType.XA, "xa_hoang_luong", 223)
    W_7822 = Ward("Xã Hoàng Vân", 7822, VietNamDivisionType.XA, "xa_hoang_van", 223)
    W_7825 = Ward("Xã Hoàng Thanh", 7825, VietNamDivisionType.XA, "xa_hoang_thanh", 223)
    W_7828 = Ward("Xã Hoàng An", 7828, VietNamDivisionType.XA, "xa_hoang_an", 223)
    W_7831 = Ward("Xã Ngọc Sơn", 7831, VietNamDivisionType.XA, "xa_ngoc_son", 223)
    W_7834 = Ward("Xã Thái Sơn", 7834, VietNamDivisionType.XA, "xa_thai_son", 223)
    W_7837 = Ward("Xã Hòa Sơn", 7837, VietNamDivisionType.XA, "xa_hoa_son", 223)
    W_7840 = Ward("Thị trấn Thắng", 7840, VietNamDivisionType.THI_TRAN, "thi_tran_thang", 223)
    W_7843 = Ward("Xã Quang Minh", 7843, VietNamDivisionType.XA, "xa_quang_minh", 223)
    W_7846 = Ward("Xã Lương Phong", 7846, VietNamDivisionType.XA, "xa_luong_phong", 223)
    W_7849 = Ward("Xã Hùng Sơn", 7849, VietNamDivisionType.XA, "xa_hung_son", 223)
    W_7852 = Ward("Xã Đại Thành", 7852, VietNamDivisionType.XA, "xa_dai_thanh", 223)
    W_7855 = Ward("Xã Thường Thắng", 7855, VietNamDivisionType.XA, "xa_thuong_thang", 223)
    W_7858 = Ward("Xã Hợp Thịnh", 7858, VietNamDivisionType.XA, "xa_hop_thinh", 223)
    W_7861 = Ward("Xã Danh Thắng", 7861, VietNamDivisionType.XA, "xa_danh_thang", 223)
    W_7864 = Ward("Xã Mai Trung", 7864, VietNamDivisionType.XA, "xa_mai_trung", 223)
    W_7867 = Ward("Xã Đoan Bái", 7867, VietNamDivisionType.XA, "xa_doan_bai", 223)
    W_7870 = Ward("Xã Bắc Lý", 7870, VietNamDivisionType.XA, "xa_bac_ly", 223)
    W_7873 = Ward("Xã Xuân Cẩm", 7873, VietNamDivisionType.XA, "xa_xuan_cam", 223)
    W_7876 = Ward("Xã Hương Lâm", 7876, VietNamDivisionType.XA, "xa_huong_lam", 223)
    W_7879 = Ward("Xã Đông Lỗ", 7879, VietNamDivisionType.XA, "xa_dong_lo", 223)
    W_7882 = Ward("Xã Châu Minh", 7882, VietNamDivisionType.XA, "xa_chau_minh", 223)
    W_7885 = Ward("Xã Mai Đình", 7885, VietNamDivisionType.XA, "xa_mai_dinh", 223)
    W_7888 = Ward("Phường Dữu Lâu", 7888, VietNamDivisionType.PHUONG, "phuong_duu_lau", 227)
    W_7891 = Ward("Phường Vân Cơ", 7891, VietNamDivisionType.PHUONG, "phuong_van_co", 227)
    W_7894 = Ward("Phường Nông Trang", 7894, VietNamDivisionType.PHUONG, "phuong_nong_trang", 227)
    W_7897 = Ward("Phường Tân Dân", 7897, VietNamDivisionType.PHUONG, "phuong_tan_dan", 227)
    W_7900 = Ward("Phường Gia Cẩm", 7900, VietNamDivisionType.PHUONG, "phuong_gia_cam", 227)
    W_7903 = Ward("Phường Tiên Cát", 7903, VietNamDivisionType.PHUONG, "phuong_tien_cat", 227)
    W_7906 = Ward("Phường Thọ Sơn", 7906, VietNamDivisionType.PHUONG, "phuong_tho_son", 227)
    W_7909 = Ward("Phường Thanh Miếu", 7909, VietNamDivisionType.PHUONG, "phuong_thanh_mieu", 227)
    W_7912 = Ward("Phường Bạch Hạc", 7912, VietNamDivisionType.PHUONG, "phuong_bach_hac", 227)
    W_7915 = Ward("Phường Bến Gót", 7915, VietNamDivisionType.PHUONG, "phuong_ben_got", 227)
    W_7918 = Ward("Phường Vân Phú", 7918, VietNamDivisionType.PHUONG, "phuong_van_phu", 227)
    W_7921 = Ward("Xã Phượng Lâu", 7921, VietNamDivisionType.XA, "xa_phuong_lau", 227)
    W_7924 = Ward("Xã Thụy Vân", 7924, VietNamDivisionType.XA, "xa_thuy_van", 227)
    W_7927 = Ward("Phường Minh Phương", 7927, VietNamDivisionType.PHUONG, "phuong_minh_phuong", 227)
    W_7930 = Ward("Xã Trưng Vương", 7930, VietNamDivisionType.XA, "xa_trung_vuong", 227)
    W_7933 = Ward("Phường Minh Nông", 7933, VietNamDivisionType.PHUONG, "phuong_minh_nong", 227)
    W_7936 = Ward("Xã Sông Lô", 7936, VietNamDivisionType.XA, "xa_song_lo", 227)
    W_8281 = Ward("Xã Kim Đức", 8281, VietNamDivisionType.XA, "xa_kim_duc", 227)
    W_8287 = Ward("Xã Hùng Lô", 8287, VietNamDivisionType.XA, "xa_hung_lo", 227)
    W_8503 = Ward("Xã Hy Cương", 8503, VietNamDivisionType.XA, "xa_hy_cuong", 227)
    W_8506 = Ward("Xã Chu Hóa", 8506, VietNamDivisionType.XA, "xa_chu_hoa", 227)
    W_8515 = Ward("Xã Thanh Đình", 8515, VietNamDivisionType.XA, "xa_thanh_dinh", 227)
    W_7942 = Ward("Phường Hùng Vương", 7942, VietNamDivisionType.PHUONG, "phuong_hung_vuong", 228)
    W_7945 = Ward("Phường Phong Châu", 7945, VietNamDivisionType.PHUONG, "phuong_phong_chau", 228)
    W_7948 = Ward("Phường Âu Cơ", 7948, VietNamDivisionType.PHUONG, "phuong_au_co", 228)
    W_7951 = Ward("Xã Hà Lộc", 7951, VietNamDivisionType.XA, "xa_ha_loc", 228)
    W_7954 = Ward("Xã Phú Hộ", 7954, VietNamDivisionType.XA, "xa_phu_ho", 228)
    W_7957 = Ward("Xã Văn Lung", 7957, VietNamDivisionType.XA, "xa_van_lung", 228)
    W_7960 = Ward("Xã Thanh Minh", 7960, VietNamDivisionType.XA, "xa_thanh_minh", 228)
    W_7963 = Ward("Xã Hà Thạch", 7963, VietNamDivisionType.XA, "xa_ha_thach", 228)
    W_7966 = Ward("Phường Thanh Vinh", 7966, VietNamDivisionType.PHUONG, "phuong_thanh_vinh", 228)
    W_7969 = Ward("Thị trấn Đoan Hùng", 7969, VietNamDivisionType.THI_TRAN, "thi_tran_doan_hung", 230)
    W_7975 = Ward("Xã Hùng Xuyên", 7975, VietNamDivisionType.XA, "xa_hung_xuyen", 230)
    W_7981 = Ward("Xã Bằng Luân", 7981, VietNamDivisionType.XA, "xa_bang_luan", 230)
    W_7984 = Ward("Xã Vân Du", 7984, VietNamDivisionType.XA, "xa_van_du", 230)
    W_7987 = Ward("Xã Phú Lâm", 7987, VietNamDivisionType.XA, "xa_phu_lam", 230)
    W_7993 = Ward("Xã Minh Lương", 7993, VietNamDivisionType.XA, "xa_minh_luong", 230)
    W_7996 = Ward("Xã Bằng Doãn", 7996, VietNamDivisionType.XA, "xa_bang_doan", 230)
    W_7999 = Ward("Xã Chí Đám", 7999, VietNamDivisionType.XA, "xa_chi_dam", 230)
    W_8005 = Ward("Xã Phúc Lai", 8005, VietNamDivisionType.XA, "xa_phuc_lai", 230)
    W_8008 = Ward("Xã Ngọc Quan", 8008, VietNamDivisionType.XA, "xa_ngoc_quan", 230)
    W_8014 = Ward("Xã Hợp Nhất", 8014, VietNamDivisionType.XA, "xa_hop_nhat", 230)
    W_8017 = Ward("Xã Sóc Đăng", 8017, VietNamDivisionType.XA, "xa_soc_dang", 230)
    W_8023 = Ward("Xã Tây Cốc", 8023, VietNamDivisionType.XA, "xa_tay_coc", 230)
    W_8026 = Ward("Xã Yên Kiện", 8026, VietNamDivisionType.XA, "xa_yen_kien", 230)
    W_8029 = Ward("Xã Hùng Long", 8029, VietNamDivisionType.XA, "xa_hung_long", 230)
    W_8032 = Ward("Xã Vụ Quang", 8032, VietNamDivisionType.XA, "xa_vu_quang", 230)
    W_8035 = Ward("Xã Vân Đồn", 8035, VietNamDivisionType.XA, "xa_van_don", 230)
    W_8038 = Ward("Xã Tiêu Sơn", 8038, VietNamDivisionType.XA, "xa_tieu_son", 230)
    W_8041 = Ward("Xã Minh Tiến", 8041, VietNamDivisionType.XA, "xa_minh_tien", 230)
    W_8044 = Ward("Xã Minh Phú", 8044, VietNamDivisionType.XA, "xa_minh_phu", 230)
    W_8047 = Ward("Xã Chân Mộng", 8047, VietNamDivisionType.XA, "xa_chan_mong", 230)
    W_8050 = Ward("Xã Ca Đình", 8050, VietNamDivisionType.XA, "xa_ca_dinh", 230)
    W_8053 = Ward("Thị trấn Hạ Hoà", 8053, VietNamDivisionType.THI_TRAN, "thi_tran_ha_hoa", 231)
    W_8056 = Ward("Xã Đại Phạm", 8056, VietNamDivisionType.XA, "xa_dai_pham", 231)
    W_8062 = Ward("Xã Đan Thượng", 8062, VietNamDivisionType.XA, "xa_dan_thuong", 231)
    W_8065 = Ward("Xã Hà Lương", 8065, VietNamDivisionType.XA, "xa_ha_luong", 231)
    W_8071 = Ward("Xã Tứ Hiệp", 8071, VietNamDivisionType.XA, "xa_tu_hiep", 231)
    W_8080 = Ward("Xã Hiền Lương", 8080, VietNamDivisionType.XA, "xa_hien_luong", 231)
    W_8089 = Ward("Xã Phương Viên", 8089, VietNamDivisionType.XA, "xa_phuong_vien", 231)
    W_8092 = Ward("Xã Gia Điền", 8092, VietNamDivisionType.XA, "xa_gia_dien", 231)
    W_8095 = Ward("Xã Ấm Hạ", 8095, VietNamDivisionType.XA, "xa_am_ha", 231)
    W_8104 = Ward("Xã Hương Xạ", 8104, VietNamDivisionType.XA, "xa_huong_xa", 231)
    W_8110 = Ward("Xã Xuân Áng", 8110, VietNamDivisionType.XA, "xa_xuan_ang", 231)
    W_8113 = Ward("Xã Yên Kỳ", 8113, VietNamDivisionType.XA, "xa_yen_ky", 231)
    W_8119 = Ward("Xã Minh Hạc", 8119, VietNamDivisionType.XA, "xa_minh_hac", 231)
    W_8122 = Ward("Xã Lang Sơn", 8122, VietNamDivisionType.XA, "xa_lang_son", 231)
    W_8125 = Ward("Xã Bằng Giã", 8125, VietNamDivisionType.XA, "xa_bang_gia", 231)
    W_8128 = Ward("Xã Yên Luật", 8128, VietNamDivisionType.XA, "xa_yen_luat", 231)
    W_8131 = Ward("Xã Vô Tranh", 8131, VietNamDivisionType.XA, "xa_vo_tranh", 231)
    W_8134 = Ward("Xã Văn Lang", 8134, VietNamDivisionType.XA, "xa_van_lang", 231)
    W_8140 = Ward("Xã Minh Côi", 8140, VietNamDivisionType.XA, "xa_minh_coi", 231)
    W_8143 = Ward("Xã Vĩnh Chân", 8143, VietNamDivisionType.XA, "xa_vinh_chan", 231)
    W_8152 = Ward("Thị trấn Thanh Ba", 8152, VietNamDivisionType.THI_TRAN, "thi_tran_thanh_ba", 232)
    W_8156 = Ward("Xã Vân Lĩnh", 8156, VietNamDivisionType.XA, "xa_van_linh", 232)
    W_8158 = Ward("Xã Đông Lĩnh", 8158, VietNamDivisionType.XA, "xa_dong_linh", 232)
    W_8161 = Ward("Xã Đại An", 8161, VietNamDivisionType.XA, "xa_dai_an", 232)
    W_8164 = Ward("Xã Hanh Cù", 8164, VietNamDivisionType.XA, "xa_hanh_cu", 232)
    W_8170 = Ward("Xã Đồng Xuân", 8170, VietNamDivisionType.XA, "xa_dong_xuan", 232)
    W_8173 = Ward("Xã Quảng Yên", 8173, VietNamDivisionType.XA, "xa_quang_yen", 232)
    W_8179 = Ward("Xã Ninh Dân", 8179, VietNamDivisionType.XA, "xa_ninh_dan", 232)
    W_8194 = Ward("Xã Võ Lao", 8194, VietNamDivisionType.XA, "xa_vo_lao", 232)
    W_8197 = Ward("Xã Khải Xuân", 8197, VietNamDivisionType.XA, "xa_khai_xuan", 232)
    W_8200 = Ward("Xã Mạn Lạn", 8200, VietNamDivisionType.XA, "xa_man_lan", 232)
    W_8203 = Ward("Xã Hoàng Cương", 8203, VietNamDivisionType.XA, "xa_hoang_cuong", 232)
    W_8206 = Ward("Xã Chí Tiên", 8206, VietNamDivisionType.XA, "xa_chi_tien", 232)
    W_8209 = Ward("Xã Đông Thành", 8209, VietNamDivisionType.XA, "xa_dong_thanh", 232)
    W_8215 = Ward("Xã Sơn Cương", 8215, VietNamDivisionType.XA, "xa_son_cuong", 232)
    W_8218 = Ward("Xã Thanh Hà", 8218, VietNamDivisionType.XA, "xa_thanh_ha", 232)
    W_8221 = Ward("Xã Đỗ Sơn", 8221, VietNamDivisionType.XA, "xa_do_son", 232)
    W_8224 = Ward("Xã Đỗ Xuyên", 8224, VietNamDivisionType.XA, "xa_do_xuyen", 232)
    W_8227 = Ward("Xã Lương Lỗ", 8227, VietNamDivisionType.XA, "xa_luong_lo", 232)
    W_8230 = Ward("Thị trấn Phong Châu", 8230, VietNamDivisionType.THI_TRAN, "thi_tran_phong_chau", 233)
    W_8233 = Ward("Xã Phú Mỹ", 8233, VietNamDivisionType.XA, "xa_phu_my", 233)
    W_8234 = Ward("Xã Lệ Mỹ", 8234, VietNamDivisionType.XA, "xa_le_my", 233)
    W_8236 = Ward("Xã Liên Hoa", 8236, VietNamDivisionType.XA, "xa_lien_hoa", 233)
    W_8239 = Ward("Xã Trạm Thản", 8239, VietNamDivisionType.XA, "xa_tram_than", 233)
    W_8242 = Ward("Xã Trị Quận", 8242, VietNamDivisionType.XA, "xa_tri_quan", 233)
    W_8245 = Ward("Xã Trung Giáp", 8245, VietNamDivisionType.XA, "xa_trung_giap", 233)
    W_8248 = Ward("Xã Tiên Phú", 8248, VietNamDivisionType.XA, "xa_tien_phu", 233)
    W_8251 = Ward("Xã Hạ Giáp", 8251, VietNamDivisionType.XA, "xa_ha_giap", 233)
    W_8254 = Ward("Xã Bảo Thanh", 8254, VietNamDivisionType.XA, "xa_bao_thanh", 233)
    W_8257 = Ward("Xã Phú Lộc", 8257, VietNamDivisionType.XA, "xa_phu_loc", 233)
    W_8260 = Ward("Xã Gia Thanh", 8260, VietNamDivisionType.XA, "xa_gia_thanh", 233)
    W_8263 = Ward("Xã Tiên Du", 8263, VietNamDivisionType.XA, "xa_tien_du", 233)
    W_8266 = Ward("Xã Phú Nham", 8266, VietNamDivisionType.XA, "xa_phu_nham", 233)
    W_8272 = Ward("Xã An Đạo", 8272, VietNamDivisionType.XA, "xa_an_dao", 233)
    W_8275 = Ward("Xã Bình Phú", 8275, VietNamDivisionType.XA, "xa_binh_phu", 233)
    W_8278 = Ward("Xã Phù Ninh", 8278, VietNamDivisionType.XA, "xa_phu_ninh", 233)
    W_8290 = Ward("Thị trấn Yên Lập", 8290, VietNamDivisionType.THI_TRAN, "thi_tran_yen_lap", 234)
    W_8293 = Ward("Xã Mỹ Lung", 8293, VietNamDivisionType.XA, "xa_my_lung", 234)
    W_8296 = Ward("Xã Mỹ Lương", 8296, VietNamDivisionType.XA, "xa_my_luong", 234)
    W_8299 = Ward("Xã Lương Sơn", 8299, VietNamDivisionType.XA, "xa_luong_son", 234)
    W_8302 = Ward("Xã Xuân An", 8302, VietNamDivisionType.XA, "xa_xuan_an", 234)
    W_8305 = Ward("Xã Xuân Viên", 8305, VietNamDivisionType.XA, "xa_xuan_vien", 234)
    W_8308 = Ward("Xã Xuân Thủy", 8308, VietNamDivisionType.XA, "xa_xuan_thuy", 234)
    W_8311 = Ward("Xã Trung Sơn", 8311, VietNamDivisionType.XA, "xa_trung_son", 234)
    W_8314 = Ward("Xã Hưng Long", 8314, VietNamDivisionType.XA, "xa_hung_long", 234)
    W_8317 = Ward("Xã Nga Hoàng", 8317, VietNamDivisionType.XA, "xa_nga_hoang", 234)
    W_8320 = Ward("Xã Đồng Lạc", 8320, VietNamDivisionType.XA, "xa_dong_lac", 234)
    W_8323 = Ward("Xã Thượng Long", 8323, VietNamDivisionType.XA, "xa_thuong_long", 234)
    W_8326 = Ward("Xã Đồng Thịnh", 8326, VietNamDivisionType.XA, "xa_dong_thinh", 234)
    W_8329 = Ward("Xã Phúc Khánh", 8329, VietNamDivisionType.XA, "xa_phuc_khanh", 234)
    W_8332 = Ward("Xã Minh Hòa", 8332, VietNamDivisionType.XA, "xa_minh_hoa", 234)
    W_8335 = Ward("Xã Ngọc Lập", 8335, VietNamDivisionType.XA, "xa_ngoc_lap", 234)
    W_8338 = Ward("Xã Ngọc Đồng", 8338, VietNamDivisionType.XA, "xa_ngoc_dong", 234)
    W_8341 = Ward("Thị trấn Cẩm Khê", 8341, VietNamDivisionType.THI_TRAN, "thi_tran_cam_khe", 235)
    W_8344 = Ward("Xã Tiên Lương", 8344, VietNamDivisionType.XA, "xa_tien_luong", 235)
    W_8347 = Ward("Xã Tuy Lộc", 8347, VietNamDivisionType.XA, "xa_tuy_loc", 235)
    W_8350 = Ward("Xã Ngô Xá", 8350, VietNamDivisionType.XA, "xa_ngo_xa", 235)
    W_8353 = Ward("Xã Minh Tân", 8353, VietNamDivisionType.XA, "xa_minh_tan", 235)
    W_8356 = Ward("Xã Phượng Vĩ", 8356, VietNamDivisionType.XA, "xa_phuong_vi", 235)
    W_8362 = Ward("Xã Thụy Liễu", 8362, VietNamDivisionType.XA, "xa_thuy_lieu", 235)
    W_8374 = Ward("Xã Tùng Khê", 8374, VietNamDivisionType.XA, "xa_tung_khe", 235)
    W_8377 = Ward("Xã Tam Sơn", 8377, VietNamDivisionType.XA, "xa_tam_son", 235)
    W_8380 = Ward("Xã Văn Bán", 8380, VietNamDivisionType.XA, "xa_van_ban", 235)
    W_8383 = Ward("Xã Cấp Dẫn", 8383, VietNamDivisionType.XA, "xa_cap_dan", 235)
    W_8389 = Ward("Xã Xương Thịnh", 8389, VietNamDivisionType.XA, "xa_xuong_thinh", 235)
    W_8392 = Ward("Xã Phú Khê", 8392, VietNamDivisionType.XA, "xa_phu_khe", 235)
    W_8395 = Ward("Xã Sơn Tình", 8395, VietNamDivisionType.XA, "xa_son_tinh", 235)
    W_8398 = Ward("Xã Yên Tập", 8398, VietNamDivisionType.XA, "xa_yen_tap", 235)
    W_8401 = Ward("Xã Hương Lung", 8401, VietNamDivisionType.XA, "xa_huong_lung", 235)
    W_8404 = Ward("Xã Tạ Xá", 8404, VietNamDivisionType.XA, "xa_ta_xa", 235)
    W_8407 = Ward("Xã Phú Lạc", 8407, VietNamDivisionType.XA, "xa_phu_lac", 235)
    W_8413 = Ward("Xã Chương Xá", 8413, VietNamDivisionType.XA, "xa_chuong_xa", 235)
    W_8416 = Ward("Xã Hùng Việt", 8416, VietNamDivisionType.XA, "xa_hung_viet", 235)
    W_8419 = Ward("Xã Văn Khúc", 8419, VietNamDivisionType.XA, "xa_van_khuc", 235)
    W_8422 = Ward("Xã Yên Dưỡng", 8422, VietNamDivisionType.XA, "xa_yen_duong", 235)
    W_8428 = Ward("Xã Điêu Lương", 8428, VietNamDivisionType.XA, "xa_dieu_luong", 235)
    W_8431 = Ward("Xã Đồng Lương", 8431, VietNamDivisionType.XA, "xa_dong_luong", 235)
    W_8434 = Ward("Thị trấn Hưng Hoá", 8434, VietNamDivisionType.THI_TRAN, "thi_tran_hung_hoa", 236)
    W_8440 = Ward("Xã Hiền Quan", 8440, VietNamDivisionType.XA, "xa_hien_quan", 236)
    W_8443 = Ward("Xã Bắc Sơn", 8443, VietNamDivisionType.XA, "xa_bac_son", 236)
    W_8446 = Ward("Xã Thanh Uyên", 8446, VietNamDivisionType.XA, "xa_thanh_uyen", 236)
    W_8461 = Ward("Xã Lam Sơn", 8461, VietNamDivisionType.XA, "xa_lam_son", 236)
    W_8467 = Ward("Xã Vạn Xuân", 8467, VietNamDivisionType.XA, "xa_van_xuan", 236)
    W_8470 = Ward("Xã Quang Húc", 8470, VietNamDivisionType.XA, "xa_quang_huc", 236)
    W_8473 = Ward("Xã Hương Nộn", 8473, VietNamDivisionType.XA, "xa_huong_non", 236)
    W_8476 = Ward("Xã Tề Lễ", 8476, VietNamDivisionType.XA, "xa_te_le", 236)
    W_8479 = Ward("Xã Thọ Văn", 8479, VietNamDivisionType.XA, "xa_tho_van", 236)
    W_8482 = Ward("Xã Dị Nậu", 8482, VietNamDivisionType.XA, "xa_di_nau", 236)
    W_8491 = Ward("Xã Dân Quyền", 8491, VietNamDivisionType.XA, "xa_dan_quyen", 236)
    W_8494 = Ward("Thị trấn Lâm Thao", 8494, VietNamDivisionType.THI_TRAN, "thi_tran_lam_thao", 237)
    W_8497 = Ward("Xã Tiên Kiên", 8497, VietNamDivisionType.XA, "xa_tien_kien", 237)
    W_8498 = Ward("Thị trấn Hùng Sơn", 8498, VietNamDivisionType.THI_TRAN, "thi_tran_hung_son", 237)
    W_8500 = Ward("Xã Xuân Lũng", 8500, VietNamDivisionType.XA, "xa_xuan_lung", 237)
    W_8509 = Ward("Xã Xuân Huy", 8509, VietNamDivisionType.XA, "xa_xuan_huy", 237)
    W_8512 = Ward("Xã Thạch Sơn", 8512, VietNamDivisionType.XA, "xa_thach_son", 237)
    W_8518 = Ward("Xã Sơn Vi", 8518, VietNamDivisionType.XA, "xa_son_vi", 237)
    W_8521 = Ward("Xã Phùng Nguyên", 8521, VietNamDivisionType.XA, "xa_phung_nguyen", 237)
    W_8527 = Ward("Xã Cao Xá", 8527, VietNamDivisionType.XA, "xa_cao_xa", 237)
    W_8533 = Ward("Xã Vĩnh Lại", 8533, VietNamDivisionType.XA, "xa_vinh_lai", 237)
    W_8536 = Ward("Xã Tứ Xã", 8536, VietNamDivisionType.XA, "xa_tu_xa", 237)
    W_8539 = Ward("Xã Bản Nguyên", 8539, VietNamDivisionType.XA, "xa_ban_nguyen", 237)
    W_8542 = Ward("Thị trấn Thanh Sơn", 8542, VietNamDivisionType.THI_TRAN, "thi_tran_thanh_son", 238)
    W_8563 = Ward("Xã Sơn Hùng", 8563, VietNamDivisionType.XA, "xa_son_hung", 238)
    W_8572 = Ward("Xã Địch Quả", 8572, VietNamDivisionType.XA, "xa_dich_qua", 238)
    W_8575 = Ward("Xã Giáp Lai", 8575, VietNamDivisionType.XA, "xa_giap_lai", 238)
    W_8581 = Ward("Xã Thục Luyện", 8581, VietNamDivisionType.XA, "xa_thuc_luyen", 238)
    W_8584 = Ward("Xã Võ Miếu", 8584, VietNamDivisionType.XA, "xa_vo_mieu", 238)
    W_8587 = Ward("Xã Thạch Khoán", 8587, VietNamDivisionType.XA, "xa_thach_khoan", 238)
    W_8602 = Ward("Xã Cự Thắng", 8602, VietNamDivisionType.XA, "xa_cu_thang", 238)
    W_8605 = Ward("Xã Tất Thắng", 8605, VietNamDivisionType.XA, "xa_tat_thang", 238)
    W_8611 = Ward("Xã Văn Miếu", 8611, VietNamDivisionType.XA, "xa_van_mieu", 238)
    W_8614 = Ward("Xã Cự Đồng", 8614, VietNamDivisionType.XA, "xa_cu_dong", 238)
    W_8623 = Ward("Xã Thắng Sơn", 8623, VietNamDivisionType.XA, "xa_thang_son", 238)
    W_8629 = Ward("Xã Tân Minh", 8629, VietNamDivisionType.XA, "xa_tan_minh", 238)
    W_8632 = Ward("Xã Hương Cần", 8632, VietNamDivisionType.XA, "xa_huong_can", 238)
    W_8635 = Ward("Xã Khả Cửu", 8635, VietNamDivisionType.XA, "xa_kha_cuu", 238)
    W_8638 = Ward("Xã Đông Cửu", 8638, VietNamDivisionType.XA, "xa_dong_cuu", 238)
    W_8641 = Ward("Xã Tân Lập", 8641, VietNamDivisionType.XA, "xa_tan_lap", 238)
    W_8644 = Ward("Xã Yên Lãng", 8644, VietNamDivisionType.XA, "xa_yen_lang", 238)
    W_8647 = Ward("Xã Yên Lương", 8647, VietNamDivisionType.XA, "xa_yen_luong", 238)
    W_8650 = Ward("Xã Thượng Cửu", 8650, VietNamDivisionType.XA, "xa_thuong_cuu", 238)
    W_8653 = Ward("Xã Lương Nha", 8653, VietNamDivisionType.XA, "xa_luong_nha", 238)
    W_8656 = Ward("Xã Yên Sơn", 8656, VietNamDivisionType.XA, "xa_yen_son", 238)
    W_8659 = Ward("Xã Tinh Nhuệ", 8659, VietNamDivisionType.XA, "xa_tinh_nhue", 238)
    W_8662 = Ward("Xã Đào Xá", 8662, VietNamDivisionType.XA, "xa_dao_xa", 239)
    W_8665 = Ward("Xã Thạch Đồng", 8665, VietNamDivisionType.XA, "xa_thach_dong", 239)
    W_8668 = Ward("Xã Xuân Lộc", 8668, VietNamDivisionType.XA, "xa_xuan_loc", 239)
    W_8671 = Ward("Xã Tân Phương", 8671, VietNamDivisionType.XA, "xa_tan_phuong", 239)
    W_8674 = Ward("Thị trấn Thanh Thủy", 8674, VietNamDivisionType.THI_TRAN, "thi_tran_thanh_thuy", 239)
    W_8677 = Ward("Xã Sơn Thủy", 8677, VietNamDivisionType.XA, "xa_son_thuy", 239)
    W_8680 = Ward("Xã Bảo Yên", 8680, VietNamDivisionType.XA, "xa_bao_yen", 239)
    W_8683 = Ward("Xã Đoan Hạ", 8683, VietNamDivisionType.XA, "xa_doan_ha", 239)
    W_8686 = Ward("Xã Đồng Trung", 8686, VietNamDivisionType.XA, "xa_dong_trung", 239)
    W_8689 = Ward("Xã Hoàng Xá", 8689, VietNamDivisionType.XA, "xa_hoang_xa", 239)
    W_8701 = Ward("Xã Tu Vũ", 8701, VietNamDivisionType.XA, "xa_tu_vu", 239)
    W_8545 = Ward("Xã Thu Cúc", 8545, VietNamDivisionType.XA, "xa_thu_cuc", 240)
    W_8548 = Ward("Xã Thạch Kiệt", 8548, VietNamDivisionType.XA, "xa_thach_kiet", 240)
    W_8551 = Ward("Xã Thu Ngạc", 8551, VietNamDivisionType.XA, "xa_thu_ngac", 240)
    W_8554 = Ward("Xã Kiệt Sơn", 8554, VietNamDivisionType.XA, "xa_kiet_son", 240)
    W_8557 = Ward("Xã Đồng Sơn", 8557, VietNamDivisionType.XA, "xa_dong_son", 240)
    W_8560 = Ward("Xã Lai Đồng", 8560, VietNamDivisionType.XA, "xa_lai_dong", 240)
    W_8566 = Ward("Xã Tân Phú", 8566, VietNamDivisionType.XA, "xa_tan_phu", 240)
    W_8569 = Ward("Xã Mỹ Thuận", 8569, VietNamDivisionType.XA, "xa_my_thuan", 240)
    W_8578 = Ward("Xã Tân Sơn", 8578, VietNamDivisionType.XA, "xa_tan_son", 240)
    W_8590 = Ward("Xã Xuân Đài", 8590, VietNamDivisionType.XA, "xa_xuan_dai", 240)
    W_8593 = Ward("Xã Minh Đài", 8593, VietNamDivisionType.XA, "xa_minh_dai", 240)
    W_8596 = Ward("Xã Văn Luông", 8596, VietNamDivisionType.XA, "xa_van_luong", 240)
    W_8599 = Ward("Xã Xuân Sơn", 8599, VietNamDivisionType.XA, "xa_xuan_son", 240)
    W_8608 = Ward("Xã Long Cốc", 8608, VietNamDivisionType.XA, "xa_long_coc", 240)
    W_8617 = Ward("Xã Kim Thượng", 8617, VietNamDivisionType.XA, "xa_kim_thuong", 240)
    W_8620 = Ward("Xã Tam Thanh", 8620, VietNamDivisionType.XA, "xa_tam_thanh", 240)
    W_8626 = Ward("Xã Vinh Tiền", 8626, VietNamDivisionType.XA, "xa_vinh_tien", 240)
    W_8707 = Ward("Phường Tích Sơn", 8707, VietNamDivisionType.PHUONG, "phuong_tich_son", 243)
    W_8710 = Ward("Phường Liên Bảo", 8710, VietNamDivisionType.PHUONG, "phuong_lien_bao", 243)
    W_8713 = Ward("Phường Hội Hợp", 8713, VietNamDivisionType.PHUONG, "phuong_hoi_hop", 243)
    W_8716 = Ward("Phường Đống Đa", 8716, VietNamDivisionType.PHUONG, "phuong_dong_da", 243)
    W_8719 = Ward("Phường Ngô Quyền", 8719, VietNamDivisionType.PHUONG, "phuong_ngo_quyen", 243)
    W_8722 = Ward("Phường Đồng Tâm", 8722, VietNamDivisionType.PHUONG, "phuong_dong_tam", 243)
    W_8725 = Ward("Xã Định Trung", 8725, VietNamDivisionType.XA, "xa_dinh_trung", 243)
    W_8728 = Ward("Phường Khai Quang", 8728, VietNamDivisionType.PHUONG, "phuong_khai_quang", 243)
    W_8731 = Ward("Xã Thanh Trù", 8731, VietNamDivisionType.XA, "xa_thanh_tru", 243)
    W_8734 = Ward("Phường Trưng Trắc", 8734, VietNamDivisionType.PHUONG, "phuong_trung_trac", 244)
    W_8737 = Ward("Phường Hùng Vương", 8737, VietNamDivisionType.PHUONG, "phuong_hung_vuong", 244)
    W_8740 = Ward("Phường Trưng Nhị", 8740, VietNamDivisionType.PHUONG, "phuong_trung_nhi", 244)
    W_8743 = Ward("Phường Phúc Thắng", 8743, VietNamDivisionType.PHUONG, "phuong_phuc_thang", 244)
    W_8746 = Ward("Phường Xuân Hoà", 8746, VietNamDivisionType.PHUONG, "phuong_xuan_hoa", 244)
    W_8747 = Ward("Phường Đồng Xuân", 8747, VietNamDivisionType.PHUONG, "phuong_dong_xuan", 244)
    W_8749 = Ward("Xã Ngọc Thanh", 8749, VietNamDivisionType.XA, "xa_ngoc_thanh", 244)
    W_8752 = Ward("Xã Cao Minh", 8752, VietNamDivisionType.XA, "xa_cao_minh", 244)
    W_8755 = Ward("Phường Nam Viêm", 8755, VietNamDivisionType.PHUONG, "phuong_nam_viem", 244)
    W_8758 = Ward("Phường Tiền Châu", 8758, VietNamDivisionType.PHUONG, "phuong_tien_chau", 244)
    W_8761 = Ward("Thị trấn Lập Thạch", 8761, VietNamDivisionType.THI_TRAN, "thi_tran_lap_thach", 246)
    W_8764 = Ward("Xã Quang Sơn", 8764, VietNamDivisionType.XA, "xa_quang_son", 246)
    W_8767 = Ward("Xã Ngọc Mỹ", 8767, VietNamDivisionType.XA, "xa_ngoc_my", 246)
    W_8770 = Ward("Xã Hợp Lý", 8770, VietNamDivisionType.XA, "xa_hop_ly", 246)
    W_8785 = Ward("Xã Bắc Bình", 8785, VietNamDivisionType.XA, "xa_bac_binh", 246)
    W_8788 = Ward("Xã Thái Hòa", 8788, VietNamDivisionType.XA, "xa_thai_hoa", 246)
    W_8789 = Ward("Thị trấn Hoa Sơn", 8789, VietNamDivisionType.THI_TRAN, "thi_tran_hoa_son", 246)
    W_8791 = Ward("Xã Liễn Sơn", 8791, VietNamDivisionType.XA, "xa_lien_son", 246)
    W_8794 = Ward("Xã Xuân Hòa", 8794, VietNamDivisionType.XA, "xa_xuan_hoa", 246)
    W_8797 = Ward("Xã Vân Trục", 8797, VietNamDivisionType.XA, "xa_van_truc", 246)
    W_8812 = Ward("Xã Liên Hòa", 8812, VietNamDivisionType.XA, "xa_lien_hoa", 246)
    W_8815 = Ward("Xã Tử Du", 8815, VietNamDivisionType.XA, "xa_tu_du", 246)
    W_8833 = Ward("Xã Bàn Giản", 8833, VietNamDivisionType.XA, "xa_ban_gian", 246)
    W_8836 = Ward("Xã Xuân Lôi", 8836, VietNamDivisionType.XA, "xa_xuan_loi", 246)
    W_8839 = Ward("Xã Đồng Ích", 8839, VietNamDivisionType.XA, "xa_dong_ich", 246)
    W_8842 = Ward("Xã Tiên Lữ", 8842, VietNamDivisionType.XA, "xa_tien_lu", 246)
    W_8845 = Ward("Xã Văn Quán", 8845, VietNamDivisionType.XA, "xa_van_quan", 246)
    W_8857 = Ward("Xã Đình Chu", 8857, VietNamDivisionType.XA, "xa_dinh_chu", 246)
    W_8863 = Ward("Xã Triệu Đề", 8863, VietNamDivisionType.XA, "xa_trieu_de", 246)
    W_8866 = Ward("Xã Sơn Đông", 8866, VietNamDivisionType.XA, "xa_son_dong", 246)
    W_8869 = Ward("Thị trấn Hợp Hòa", 8869, VietNamDivisionType.THI_TRAN, "thi_tran_hop_hoa", 247)
    W_8872 = Ward("Xã Hoàng Hoa", 8872, VietNamDivisionType.XA, "xa_hoang_hoa", 247)
    W_8875 = Ward("Xã Đồng Tĩnh", 8875, VietNamDivisionType.XA, "xa_dong_tinh", 247)
    W_8878 = Ward("Xã Kim Long", 8878, VietNamDivisionType.XA, "xa_kim_long", 247)
    W_8881 = Ward("Xã Hướng Đạo", 8881, VietNamDivisionType.XA, "xa_huong_dao", 247)
    W_8884 = Ward("Xã Đạo Tú", 8884, VietNamDivisionType.XA, "xa_dao_tu", 247)
    W_8887 = Ward("Xã An Hòa", 8887, VietNamDivisionType.XA, "xa_an_hoa", 247)
    W_8890 = Ward("Xã Thanh Vân", 8890, VietNamDivisionType.XA, "xa_thanh_van", 247)
    W_8893 = Ward("Xã Duy Phiên", 8893, VietNamDivisionType.XA, "xa_duy_phien", 247)
    W_8896 = Ward("Xã Hoàng Đan", 8896, VietNamDivisionType.XA, "xa_hoang_dan", 247)
    W_8899 = Ward("Xã Hoàng Lâu", 8899, VietNamDivisionType.XA, "xa_hoang_lau", 247)
    W_8902 = Ward("Xã Vân Hội", 8902, VietNamDivisionType.XA, "xa_van_hoi", 247)
    W_8905 = Ward("Xã Hợp Thịnh", 8905, VietNamDivisionType.XA, "xa_hop_thinh", 247)
    W_8908 = Ward("Thị trấn Tam Đảo", 8908, VietNamDivisionType.THI_TRAN, "thi_tran_tam_dao", 248)
    W_8911 = Ward("Thị trấn Hợp Châu", 8911, VietNamDivisionType.THI_TRAN, "thi_tran_hop_chau", 248)
    W_8914 = Ward("Xã Đạo Trù", 8914, VietNamDivisionType.XA, "xa_dao_tru", 248)
    W_8917 = Ward("Xã Yên Dương", 8917, VietNamDivisionType.XA, "xa_yen_duong", 248)
    W_8920 = Ward("Xã Bồ Lý", 8920, VietNamDivisionType.XA, "xa_bo_ly", 248)
    W_8923 = Ward("Thị trấn Đại Đình", 8923, VietNamDivisionType.THI_TRAN, "thi_tran_dai_dinh", 248)
    W_8926 = Ward("Xã Tam Quan", 8926, VietNamDivisionType.XA, "xa_tam_quan", 248)
    W_8929 = Ward("Xã Hồ Sơn", 8929, VietNamDivisionType.XA, "xa_ho_son", 248)
    W_8932 = Ward("Xã Minh Quang", 8932, VietNamDivisionType.XA, "xa_minh_quang", 248)
    W_8935 = Ward("Thị trấn Hương Canh", 8935, VietNamDivisionType.THI_TRAN, "thi_tran_huong_canh", 249)
    W_8936 = Ward("Thị trấn Gia Khánh", 8936, VietNamDivisionType.THI_TRAN, "thi_tran_gia_khanh", 249)
    W_8938 = Ward("Xã Trung Mỹ", 8938, VietNamDivisionType.XA, "xa_trung_my", 249)
    W_8944 = Ward("Thị trấn Bá Hiến", 8944, VietNamDivisionType.THI_TRAN, "thi_tran_ba_hien", 249)
    W_8947 = Ward("Xã Thiện Kế", 8947, VietNamDivisionType.XA, "xa_thien_ke", 249)
    W_8950 = Ward("Xã Hương Sơn", 8950, VietNamDivisionType.XA, "xa_huong_son", 249)
    W_8953 = Ward("Xã Tam Hợp", 8953, VietNamDivisionType.XA, "xa_tam_hop", 249)
    W_8956 = Ward("Xã Quất Lưu", 8956, VietNamDivisionType.XA, "xa_quat_luu", 249)
    W_8959 = Ward("Xã Sơn Lôi", 8959, VietNamDivisionType.XA, "xa_son_loi", 249)
    W_8962 = Ward("Thị trấn Đạo Đức", 8962, VietNamDivisionType.THI_TRAN, "thi_tran_dao_duc", 249)
    W_8965 = Ward("Xã Tân Phong", 8965, VietNamDivisionType.XA, "xa_tan_phong", 249)
    W_8968 = Ward("Thị trấn Thanh Lãng", 8968, VietNamDivisionType.THI_TRAN, "thi_tran_thanh_lang", 249)
    W_8971 = Ward("Xã Phú Xuân", 8971, VietNamDivisionType.XA, "xa_phu_xuan", 249)
    W_9025 = Ward("Thị trấn Yên Lạc", 9025, VietNamDivisionType.THI_TRAN, "thi_tran_yen_lac", 251)
    W_9028 = Ward("Xã Đồng Cương", 9028, VietNamDivisionType.XA, "xa_dong_cuong", 251)
    W_9031 = Ward("Xã Đồng Văn", 9031, VietNamDivisionType.XA, "xa_dong_van", 251)
    W_9034 = Ward("Xã Bình Định", 9034, VietNamDivisionType.XA, "xa_binh_dinh", 251)
    W_9037 = Ward("Xã Trung Nguyên", 9037, VietNamDivisionType.XA, "xa_trung_nguyen", 251)
    W_9040 = Ward("Xã Tề Lỗ", 9040, VietNamDivisionType.XA, "xa_te_lo", 251)
    W_9043 = Ward("Xã Tam Hồng", 9043, VietNamDivisionType.XA, "xa_tam_hong", 251)
    W_9046 = Ward("Xã Yên Đồng", 9046, VietNamDivisionType.XA, "xa_yen_dong", 251)
    W_9049 = Ward("Xã Văn Tiến", 9049, VietNamDivisionType.XA, "xa_van_tien", 251)
    W_9052 = Ward("Xã Nguyệt Đức", 9052, VietNamDivisionType.XA, "xa_nguyet_duc", 251)
    W_9055 = Ward("Xã Yên Phương", 9055, VietNamDivisionType.XA, "xa_yen_phuong", 251)
    W_9058 = Ward("Xã Hồng Phương", 9058, VietNamDivisionType.XA, "xa_hong_phuong", 251)
    W_9061 = Ward("Xã Trung Kiên", 9061, VietNamDivisionType.XA, "xa_trung_kien", 251)
    W_9064 = Ward("Xã Liên Châu", 9064, VietNamDivisionType.XA, "xa_lien_chau", 251)
    W_9067 = Ward("Xã Đại Tự", 9067, VietNamDivisionType.XA, "xa_dai_tu", 251)
    W_9070 = Ward("Xã Hồng Châu", 9070, VietNamDivisionType.XA, "xa_hong_chau", 251)
    W_9073 = Ward("Xã Trung Hà", 9073, VietNamDivisionType.XA, "xa_trung_ha", 251)
    W_9076 = Ward("Thị trấn Vĩnh Tường", 9076, VietNamDivisionType.THI_TRAN, "thi_tran_vinh_tuong", 252)
    W_9079 = Ward("Xã Kim Xá", 9079, VietNamDivisionType.XA, "xa_kim_xa", 252)
    W_9082 = Ward("Xã Yên Bình", 9082, VietNamDivisionType.XA, "xa_yen_binh", 252)
    W_9085 = Ward("Xã Chấn Hưng", 9085, VietNamDivisionType.XA, "xa_chan_hung", 252)
    W_9088 = Ward("Xã Nghĩa Hưng", 9088, VietNamDivisionType.XA, "xa_nghia_hung", 252)
    W_9091 = Ward("Xã Yên Lập", 9091, VietNamDivisionType.XA, "xa_yen_lap", 252)
    W_9094 = Ward("Xã Việt Xuân", 9094, VietNamDivisionType.XA, "xa_viet_xuan", 252)
    W_9097 = Ward("Xã Bồ Sao", 9097, VietNamDivisionType.XA, "xa_bo_sao", 252)
    W_9100 = Ward("Xã Đại Đồng", 9100, VietNamDivisionType.XA, "xa_dai_dong", 252)
    W_9103 = Ward("Xã Tân Tiến", 9103, VietNamDivisionType.XA, "xa_tan_tien", 252)
    W_9106 = Ward("Xã Lũng Hoà", 9106, VietNamDivisionType.XA, "xa_lung_hoa", 252)
    W_9109 = Ward("Xã Cao Đại", 9109, VietNamDivisionType.XA, "xa_cao_dai", 252)
    W_9112 = Ward("Thị trấn Thổ Tang", 9112, VietNamDivisionType.THI_TRAN, "thi_tran_tho_tang", 252)
    W_9115 = Ward("Xã Vĩnh Sơn", 9115, VietNamDivisionType.XA, "xa_vinh_son", 252)
    W_9118 = Ward("Xã Bình Dương", 9118, VietNamDivisionType.XA, "xa_binh_duong", 252)
    W_9124 = Ward("Xã Tân Phú", 9124, VietNamDivisionType.XA, "xa_tan_phu", 252)
    W_9127 = Ward("Xã Thượng Trưng", 9127, VietNamDivisionType.XA, "xa_thuong_trung", 252)
    W_9130 = Ward("Xã Vũ Di", 9130, VietNamDivisionType.XA, "xa_vu_di", 252)
    W_9133 = Ward("Xã Lý Nhân", 9133, VietNamDivisionType.XA, "xa_ly_nhan", 252)
    W_9136 = Ward("Xã Tuân Chính", 9136, VietNamDivisionType.XA, "xa_tuan_chinh", 252)
    W_9139 = Ward("Xã Vân Xuân", 9139, VietNamDivisionType.XA, "xa_van_xuan", 252)
    W_9142 = Ward("Xã Tam Phúc", 9142, VietNamDivisionType.XA, "xa_tam_phuc", 252)
    W_9145 = Ward("Thị trấn Tứ Trưng", 9145, VietNamDivisionType.THI_TRAN, "thi_tran_tu_trung", 252)
    W_9148 = Ward("Xã Ngũ Kiên", 9148, VietNamDivisionType.XA, "xa_ngu_kien", 252)
    W_9151 = Ward("Xã An Tường", 9151, VietNamDivisionType.XA, "xa_an_tuong", 252)
    W_9154 = Ward("Xã Vĩnh Thịnh", 9154, VietNamDivisionType.XA, "xa_vinh_thinh", 252)
    W_9157 = Ward("Xã Phú Đa", 9157, VietNamDivisionType.XA, "xa_phu_da", 252)
    W_9160 = Ward("Xã Vĩnh Ninh", 9160, VietNamDivisionType.XA, "xa_vinh_ninh", 252)
    W_8773 = Ward("Xã Lãng Công", 8773, VietNamDivisionType.XA, "xa_lang_cong", 253)
    W_8776 = Ward("Xã Quang Yên", 8776, VietNamDivisionType.XA, "xa_quang_yen", 253)
    W_8779 = Ward("Xã Bạch Lưu", 8779, VietNamDivisionType.XA, "xa_bach_luu", 253)
    W_8782 = Ward("Xã Hải Lựu", 8782, VietNamDivisionType.XA, "xa_hai_luu", 253)
    W_8800 = Ward("Xã Đồng Quế", 8800, VietNamDivisionType.XA, "xa_dong_que", 253)
    W_8803 = Ward("Xã Nhân Đạo", 8803, VietNamDivisionType.XA, "xa_nhan_dao", 253)
    W_8806 = Ward("Xã Đôn Nhân", 8806, VietNamDivisionType.XA, "xa_don_nhan", 253)
    W_8809 = Ward("Xã Phương Khoan", 8809, VietNamDivisionType.XA, "xa_phuong_khoan", 253)
    W_8818 = Ward("Xã Tân Lập", 8818, VietNamDivisionType.XA, "xa_tan_lap", 253)
    W_8821 = Ward("Xã Nhạo Sơn", 8821, VietNamDivisionType.XA, "xa_nhao_son", 253)
    W_8824 = Ward("Thị trấn Tam Sơn", 8824, VietNamDivisionType.THI_TRAN, "thi_tran_tam_son", 253)
    W_8827 = Ward("Xã Như Thụy", 8827, VietNamDivisionType.XA, "xa_nhu_thuy", 253)
    W_8830 = Ward("Xã Yên Thạch", 8830, VietNamDivisionType.XA, "xa_yen_thach", 253)
    W_8848 = Ward("Xã Đồng Thịnh", 8848, VietNamDivisionType.XA, "xa_dong_thinh", 253)
    W_8851 = Ward("Xã Tứ Yên", 8851, VietNamDivisionType.XA, "xa_tu_yen", 253)
    W_8854 = Ward("Xã Đức Bác", 8854, VietNamDivisionType.XA, "xa_duc_bac", 253)
    W_8860 = Ward("Xã Cao Phong", 8860, VietNamDivisionType.XA, "xa_cao_phong", 253)
    W_9163 = Ward("Phường Vũ Ninh", 9163, VietNamDivisionType.PHUONG, "phuong_vu_ninh", 256)
    W_9166 = Ward("Phường Đáp Cầu", 9166, VietNamDivisionType.PHUONG, "phuong_dap_cau", 256)
    W_9169 = Ward("Phường Thị Cầu", 9169, VietNamDivisionType.PHUONG, "phuong_thi_cau", 256)
    W_9172 = Ward("Phường Kinh Bắc", 9172, VietNamDivisionType.PHUONG, "phuong_kinh_bac", 256)
    W_9175 = Ward("Phường Vệ An", 9175, VietNamDivisionType.PHUONG, "phuong_ve_an", 256)
    W_9178 = Ward("Phường Tiền An", 9178, VietNamDivisionType.PHUONG, "phuong_tien_an", 256)
    W_9181 = Ward("Phường Đại Phúc", 9181, VietNamDivisionType.PHUONG, "phuong_dai_phuc", 256)
    W_9184 = Ward("Phường Ninh Xá", 9184, VietNamDivisionType.PHUONG, "phuong_ninh_xa", 256)
    W_9187 = Ward("Phường Suối Hoa", 9187, VietNamDivisionType.PHUONG, "phuong_suoi_hoa", 256)
    W_9190 = Ward("Phường Võ Cường", 9190, VietNamDivisionType.PHUONG, "phuong_vo_cuong", 256)
    W_9214 = Ward("Phường Hòa Long", 9214, VietNamDivisionType.PHUONG, "phuong_hoa_long", 256)
    W_9226 = Ward("Phường Vạn An", 9226, VietNamDivisionType.PHUONG, "phuong_van_an", 256)
    W_9235 = Ward("Phường Khúc Xuyên", 9235, VietNamDivisionType.PHUONG, "phuong_khuc_xuyen", 256)
    W_9244 = Ward("Phường Phong Khê", 9244, VietNamDivisionType.PHUONG, "phuong_phong_khe", 256)
    W_9256 = Ward("Phường Kim Chân", 9256, VietNamDivisionType.PHUONG, "phuong_kim_chan", 256)
    W_9271 = Ward("Phường Vân Dương", 9271, VietNamDivisionType.PHUONG, "phuong_van_duong", 256)
    W_9286 = Ward("Phường Nam Sơn", 9286, VietNamDivisionType.PHUONG, "phuong_nam_son", 256)
    W_9325 = Ward("Phường Khắc Niệm", 9325, VietNamDivisionType.PHUONG, "phuong_khac_niem", 256)
    W_9331 = Ward("Phường Hạp Lĩnh", 9331, VietNamDivisionType.PHUONG, "phuong_hap_linh", 256)
    W_9193 = Ward("Thị trấn Chờ", 9193, VietNamDivisionType.THI_TRAN, "thi_tran_cho", 258)
    W_9196 = Ward("Xã Dũng Liệt", 9196, VietNamDivisionType.XA, "xa_dung_liet", 258)
    W_9199 = Ward("Xã Tam Đa", 9199, VietNamDivisionType.XA, "xa_tam_da", 258)
    W_9202 = Ward("Xã Tam Giang", 9202, VietNamDivisionType.XA, "xa_tam_giang", 258)
    W_9205 = Ward("Xã Yên Trung", 9205, VietNamDivisionType.XA, "xa_yen_trung", 258)
    W_9208 = Ward("Xã Thụy Hòa", 9208, VietNamDivisionType.XA, "xa_thuy_hoa", 258)
    W_9211 = Ward("Xã Hòa Tiến", 9211, VietNamDivisionType.XA, "xa_hoa_tien", 258)
    W_9217 = Ward("Xã Đông Tiến", 9217, VietNamDivisionType.XA, "xa_dong_tien", 258)
    W_9220 = Ward("Xã Yên Phụ", 9220, VietNamDivisionType.XA, "xa_yen_phu", 258)
    W_9223 = Ward("Xã Trung Nghĩa", 9223, VietNamDivisionType.XA, "xa_trung_nghia", 258)
    W_9229 = Ward("Xã Đông Phong", 9229, VietNamDivisionType.XA, "xa_dong_phong", 258)
    W_9232 = Ward("Xã Long Châu", 9232, VietNamDivisionType.XA, "xa_long_chau", 258)
    W_9238 = Ward("Xã Văn Môn", 9238, VietNamDivisionType.XA, "xa_van_mon", 258)
    W_9241 = Ward("Xã Đông Thọ", 9241, VietNamDivisionType.XA, "xa_dong_tho", 258)
    W_9247 = Ward("Thị trấn Phố Mới", 9247, VietNamDivisionType.THI_TRAN, "thi_tran_pho_moi", 259)
    W_9250 = Ward("Xã Việt Thống", 9250, VietNamDivisionType.XA, "xa_viet_thong", 259)
    W_9253 = Ward("Xã Đại Xuân", 9253, VietNamDivisionType.XA, "xa_dai_xuan", 259)
    W_9259 = Ward("Xã Nhân Hòa", 9259, VietNamDivisionType.XA, "xa_nhan_hoa", 259)
    W_9262 = Ward("Xã Bằng An", 9262, VietNamDivisionType.XA, "xa_bang_an", 259)
    W_9265 = Ward("Xã Phương Liễu", 9265, VietNamDivisionType.XA, "xa_phuong_lieu", 259)
    W_9268 = Ward("Xã Quế Tân", 9268, VietNamDivisionType.XA, "xa_que_tan", 259)
    W_9274 = Ward("Xã Phù Lương", 9274, VietNamDivisionType.XA, "xa_phu_luong", 259)
    W_9277 = Ward("Xã Phù Lãng", 9277, VietNamDivisionType.XA, "xa_phu_lang", 259)
    W_9280 = Ward("Xã Phượng Mao", 9280, VietNamDivisionType.XA, "xa_phuong_mao", 259)
    W_9283 = Ward("Xã Việt Hùng", 9283, VietNamDivisionType.XA, "xa_viet_hung", 259)
    W_9289 = Ward("Xã Ngọc Xá", 9289, VietNamDivisionType.XA, "xa_ngoc_xa", 259)
    W_9292 = Ward("Xã Châu Phong", 9292, VietNamDivisionType.XA, "xa_chau_phong", 259)
    W_9295 = Ward("Xã Bồng Lai", 9295, VietNamDivisionType.XA, "xa_bong_lai", 259)
    W_9298 = Ward("Xã Cách Bi", 9298, VietNamDivisionType.XA, "xa_cach_bi", 259)
    W_9301 = Ward("Xã Đào Viên", 9301, VietNamDivisionType.XA, "xa_dao_vien", 259)
    W_9304 = Ward("Xã Yên Giả", 9304, VietNamDivisionType.XA, "xa_yen_gia", 259)
    W_9307 = Ward("Xã Mộ Đạo", 9307, VietNamDivisionType.XA, "xa_mo_dao", 259)
    W_9310 = Ward("Xã Đức Long", 9310, VietNamDivisionType.XA, "xa_duc_long", 259)
    W_9313 = Ward("Xã Chi Lăng", 9313, VietNamDivisionType.XA, "xa_chi_lang", 259)
    W_9316 = Ward("Xã Hán Quảng", 9316, VietNamDivisionType.XA, "xa_han_quang", 259)
    W_9319 = Ward("Thị trấn Lim", 9319, VietNamDivisionType.THI_TRAN, "thi_tran_lim", 260)
    W_9322 = Ward("Xã Phú Lâm", 9322, VietNamDivisionType.XA, "xa_phu_lam", 260)
    W_9328 = Ward("Xã Nội Duệ", 9328, VietNamDivisionType.XA, "xa_noi_due", 260)
    W_9334 = Ward("Xã Liên Bão", 9334, VietNamDivisionType.XA, "xa_lien_bao", 260)
    W_9337 = Ward("Xã Hiên Vân", 9337, VietNamDivisionType.XA, "xa_hien_van", 260)
    W_9340 = Ward("Xã Hoàn Sơn", 9340, VietNamDivisionType.XA, "xa_hoan_son", 260)
    W_9343 = Ward("Xã Lạc Vệ", 9343, VietNamDivisionType.XA, "xa_lac_ve", 260)
    W_9346 = Ward("Xã Việt Đoàn", 9346, VietNamDivisionType.XA, "xa_viet_doan", 260)
    W_9349 = Ward("Xã Phật Tích", 9349, VietNamDivisionType.XA, "xa_phat_tich", 260)
    W_9352 = Ward("Xã Tân Chi", 9352, VietNamDivisionType.XA, "xa_tan_chi", 260)
    W_9355 = Ward("Xã Đại Đồng", 9355, VietNamDivisionType.XA, "xa_dai_dong", 260)
    W_9358 = Ward("Xã Tri Phương", 9358, VietNamDivisionType.XA, "xa_tri_phuong", 260)
    W_9361 = Ward("Xã Minh Đạo", 9361, VietNamDivisionType.XA, "xa_minh_dao", 260)
    W_9364 = Ward("Xã Cảnh Hưng", 9364, VietNamDivisionType.XA, "xa_canh_hung", 260)
    W_9367 = Ward("Phường Đông Ngàn", 9367, VietNamDivisionType.PHUONG, "phuong_dong_ngan", 261)
    W_9370 = Ward("Phường Tam Sơn", 9370, VietNamDivisionType.PHUONG, "phuong_tam_son", 261)
    W_9373 = Ward("Phường Hương Mạc", 9373, VietNamDivisionType.PHUONG, "phuong_huong_mac", 261)
    W_9376 = Ward("Phường Tương Giang", 9376, VietNamDivisionType.PHUONG, "phuong_tuong_giang", 261)
    W_9379 = Ward("Phường Phù Khê", 9379, VietNamDivisionType.PHUONG, "phuong_phu_khe", 261)
    W_9382 = Ward("Phường Đồng Kỵ", 9382, VietNamDivisionType.PHUONG, "phuong_dong_ky", 261)
    W_9383 = Ward("Phường Trang Hạ", 9383, VietNamDivisionType.PHUONG, "phuong_trang_ha", 261)
    W_9385 = Ward("Phường Đồng Nguyên", 9385, VietNamDivisionType.PHUONG, "phuong_dong_nguyen", 261)
    W_9388 = Ward("Phường Châu Khê", 9388, VietNamDivisionType.PHUONG, "phuong_chau_khe", 261)
    W_9391 = Ward("Phường Tân Hồng", 9391, VietNamDivisionType.PHUONG, "phuong_tan_hong", 261)
    W_9394 = Ward("Phường Đình Bảng", 9394, VietNamDivisionType.PHUONG, "phuong_dinh_bang", 261)
    W_9397 = Ward("Phường Phù Chẩn", 9397, VietNamDivisionType.PHUONG, "phuong_phu_chan", 261)
    W_9400 = Ward("Thị trấn Hồ", 9400, VietNamDivisionType.THI_TRAN, "thi_tran_ho", 262)
    W_9403 = Ward("Xã Hoài Thượng", 9403, VietNamDivisionType.XA, "xa_hoai_thuong", 262)
    W_9406 = Ward("Xã Đại Đồng Thành", 9406, VietNamDivisionType.XA, "xa_dai_dong_thanh", 262)
    W_9409 = Ward("Xã Mão Điền", 9409, VietNamDivisionType.XA, "xa_mao_dien", 262)
    W_9412 = Ward("Xã Song Hồ", 9412, VietNamDivisionType.XA, "xa_song_ho", 262)
    W_9415 = Ward("Xã Đình Tổ", 9415, VietNamDivisionType.XA, "xa_dinh_to", 262)
    W_9418 = Ward("Xã An Bình", 9418, VietNamDivisionType.XA, "xa_an_binh", 262)
    W_9421 = Ward("Xã Trí Quả", 9421, VietNamDivisionType.XA, "xa_tri_qua", 262)
    W_9424 = Ward("Xã Gia Đông", 9424, VietNamDivisionType.XA, "xa_gia_dong", 262)
    W_9427 = Ward("Xã Thanh Khương", 9427, VietNamDivisionType.XA, "xa_thanh_khuong", 262)
    W_9430 = Ward("Xã Trạm Lộ", 9430, VietNamDivisionType.XA, "xa_tram_lo", 262)
    W_9433 = Ward("Xã Xuân Lâm", 9433, VietNamDivisionType.XA, "xa_xuan_lam", 262)
    W_9436 = Ward("Xã Hà Mãn", 9436, VietNamDivisionType.XA, "xa_ha_man", 262)
    W_9439 = Ward("Xã Ngũ Thái", 9439, VietNamDivisionType.XA, "xa_ngu_thai", 262)
    W_9442 = Ward("Xã Nguyệt Đức", 9442, VietNamDivisionType.XA, "xa_nguyet_duc", 262)
    W_9445 = Ward("Xã Ninh Xá", 9445, VietNamDivisionType.XA, "xa_ninh_xa", 262)
    W_9448 = Ward("Xã Nghĩa Đạo", 9448, VietNamDivisionType.XA, "xa_nghia_dao", 262)
    W_9451 = Ward("Xã Song Liễu", 9451, VietNamDivisionType.XA, "xa_song_lieu", 262)
    W_9454 = Ward("Thị trấn Gia Bình", 9454, VietNamDivisionType.THI_TRAN, "thi_tran_gia_binh", 263)
    W_9457 = Ward("Xã Vạn Ninh", 9457, VietNamDivisionType.XA, "xa_van_ninh", 263)
    W_9460 = Ward("Xã Thái Bảo", 9460, VietNamDivisionType.XA, "xa_thai_bao", 263)
    W_9463 = Ward("Xã Giang Sơn", 9463, VietNamDivisionType.XA, "xa_giang_son", 263)
    W_9466 = Ward("Xã Cao Đức", 9466, VietNamDivisionType.XA, "xa_cao_duc", 263)
    W_9469 = Ward("Xã Đại Lai", 9469, VietNamDivisionType.XA, "xa_dai_lai", 263)
    W_9472 = Ward("Xã Song Giang", 9472, VietNamDivisionType.XA, "xa_song_giang", 263)
    W_9475 = Ward("Xã Bình Dương", 9475, VietNamDivisionType.XA, "xa_binh_duong", 263)
    W_9478 = Ward("Xã Lãng Ngâm", 9478, VietNamDivisionType.XA, "xa_lang_ngam", 263)
    W_9481 = Ward("Xã Nhân Thắng", 9481, VietNamDivisionType.XA, "xa_nhan_thang", 263)
    W_9484 = Ward("Xã Xuân Lai", 9484, VietNamDivisionType.XA, "xa_xuan_lai", 263)
    W_9487 = Ward("Xã Đông Cứu", 9487, VietNamDivisionType.XA, "xa_dong_cuu", 263)
    W_9490 = Ward("Xã Đại Bái", 9490, VietNamDivisionType.XA, "xa_dai_bai", 263)
    W_9493 = Ward("Xã Quỳnh Phú", 9493, VietNamDivisionType.XA, "xa_quynh_phu", 263)
    W_9496 = Ward("Thị trấn Thứa", 9496, VietNamDivisionType.THI_TRAN, "thi_tran_thua", 264)
    W_9499 = Ward("Xã An Thịnh", 9499, VietNamDivisionType.XA, "xa_an_thinh", 264)
    W_9502 = Ward("Xã Trung Kênh", 9502, VietNamDivisionType.XA, "xa_trung_kenh", 264)
    W_9505 = Ward("Xã Phú Hòa", 9505, VietNamDivisionType.XA, "xa_phu_hoa", 264)
    W_9508 = Ward("Xã Mỹ Hương", 9508, VietNamDivisionType.XA, "xa_my_huong", 264)
    W_9511 = Ward("Xã Tân Lãng", 9511, VietNamDivisionType.XA, "xa_tan_lang", 264)
    W_9514 = Ward("Xã Quảng Phú", 9514, VietNamDivisionType.XA, "xa_quang_phu", 264)
    W_9517 = Ward("Xã Trừng Xá", 9517, VietNamDivisionType.XA, "xa_trung_xa", 264)
    W_9520 = Ward("Xã Lai Hạ", 9520, VietNamDivisionType.XA, "xa_lai_ha", 264)
    W_9523 = Ward("Xã Trung Chính", 9523, VietNamDivisionType.XA, "xa_trung_chinh", 264)
    W_9526 = Ward("Xã Minh Tân", 9526, VietNamDivisionType.XA, "xa_minh_tan", 264)
    W_9529 = Ward("Xã Bình Định", 9529, VietNamDivisionType.XA, "xa_binh_dinh", 264)
    W_9532 = Ward("Xã Phú Lương", 9532, VietNamDivisionType.XA, "xa_phu_luong", 264)
    W_9535 = Ward("Xã Lâm Thao", 9535, VietNamDivisionType.XA, "xa_lam_thao", 264)
    W_10507 = Ward("Phường Cẩm Thượng", 10507, VietNamDivisionType.PHUONG, "phuong_cam_thuong", 288)
    W_10510 = Ward("Phường Bình Hàn", 10510, VietNamDivisionType.PHUONG, "phuong_binh_han", 288)
    W_10513 = Ward("Phường Ngọc Châu", 10513, VietNamDivisionType.PHUONG, "phuong_ngoc_chau", 288)
    W_10514 = Ward("Phường Nhị Châu", 10514, VietNamDivisionType.PHUONG, "phuong_nhi_chau", 288)
    W_10516 = Ward("Phường Quang Trung", 10516, VietNamDivisionType.PHUONG, "phuong_quang_trung", 288)
    W_10519 = Ward("Phường Nguyễn Trãi", 10519, VietNamDivisionType.PHUONG, "phuong_nguyen_trai", 288)
    W_10522 = Ward("Phường Phạm Ngũ Lão", 10522, VietNamDivisionType.PHUONG, "phuong_pham_ngu_lao", 288)
    W_10525 = Ward("Phường Trần Hưng Đạo", 10525, VietNamDivisionType.PHUONG, "phuong_tran_hung_dao", 288)
    W_10528 = Ward("Phường Trần Phú", 10528, VietNamDivisionType.PHUONG, "phuong_tran_phu", 288)
    W_10531 = Ward("Phường Thanh Bình", 10531, VietNamDivisionType.PHUONG, "phuong_thanh_binh", 288)
    W_10532 = Ward("Phường Tân Bình", 10532, VietNamDivisionType.PHUONG, "phuong_tan_binh", 288)
    W_10534 = Ward("Phường Lê Thanh Nghị", 10534, VietNamDivisionType.PHUONG, "phuong_le_thanh_nghi", 288)
    W_10537 = Ward("Phường Hải Tân", 10537, VietNamDivisionType.PHUONG, "phuong_hai_tan", 288)
    W_10540 = Ward("Phường Tứ Minh", 10540, VietNamDivisionType.PHUONG, "phuong_tu_minh", 288)
    W_10543 = Ward("Phường Việt Hoà", 10543, VietNamDivisionType.PHUONG, "phuong_viet_hoa", 288)
    W_10660 = Ward("Phường Ái Quốc", 10660, VietNamDivisionType.PHUONG, "phuong_ai_quoc", 288)
    W_10663 = Ward("Xã An Thượng", 10663, VietNamDivisionType.XA, "xa_an_thuong", 288)
    W_10672 = Ward("Phường Nam Đồng", 10672, VietNamDivisionType.PHUONG, "phuong_nam_dong", 288)
    W_10822 = Ward("Xã Quyết Thắng", 10822, VietNamDivisionType.XA, "xa_quyet_thang", 288)
    W_10837 = Ward("Xã Tiền Tiến", 10837, VietNamDivisionType.XA, "xa_tien_tien", 288)
    W_11002 = Ward("Phường Thạch Khôi", 11002, VietNamDivisionType.PHUONG, "phuong_thach_khoi", 288)
    W_11005 = Ward("Xã Liên Hồng", 11005, VietNamDivisionType.XA, "xa_lien_hong", 288)
    W_11011 = Ward("Phường Tân Hưng", 11011, VietNamDivisionType.PHUONG, "phuong_tan_hung", 288)
    W_11017 = Ward("Xã Gia Xuyên", 11017, VietNamDivisionType.XA, "xa_gia_xuyen", 288)
    W_11077 = Ward("Xã Ngọc Sơn", 11077, VietNamDivisionType.XA, "xa_ngoc_son", 288)
    W_10546 = Ward("Phường Phả Lại", 10546, VietNamDivisionType.PHUONG, "phuong_pha_lai", 290)
    W_10549 = Ward("Phường Sao Đỏ", 10549, VietNamDivisionType.PHUONG, "phuong_sao_do", 290)
    W_10552 = Ward("Phường Bến Tắm", 10552, VietNamDivisionType.PHUONG, "phuong_ben_tam", 290)
    W_10555 = Ward("Xã Hoàng Hoa Thám", 10555, VietNamDivisionType.XA, "xa_hoang_hoa_tham", 290)
    W_10558 = Ward("Xã Bắc An", 10558, VietNamDivisionType.XA, "xa_bac_an", 290)
    W_10561 = Ward("Xã Hưng Đạo", 10561, VietNamDivisionType.XA, "xa_hung_dao", 290)
    W_10564 = Ward("Xã Lê Lợi", 10564, VietNamDivisionType.XA, "xa_le_loi", 290)
    W_10567 = Ward("Phường Hoàng Tiến", 10567, VietNamDivisionType.PHUONG, "phuong_hoang_tien", 290)
    W_10570 = Ward("Phường Cộng Hoà", 10570, VietNamDivisionType.PHUONG, "phuong_cong_hoa", 290)
    W_10573 = Ward("Phường Hoàng Tân", 10573, VietNamDivisionType.PHUONG, "phuong_hoang_tan", 290)
    W_10576 = Ward("Phường Cổ Thành", 10576, VietNamDivisionType.PHUONG, "phuong_co_thanh", 290)
    W_10579 = Ward("Phường Văn An", 10579, VietNamDivisionType.PHUONG, "phuong_van_an", 290)
    W_10582 = Ward("Phường Chí Minh", 10582, VietNamDivisionType.PHUONG, "phuong_chi_minh", 290)
    W_10585 = Ward("Phường Văn Đức", 10585, VietNamDivisionType.PHUONG, "phuong_van_duc", 290)
    W_10588 = Ward("Phường Thái Học", 10588, VietNamDivisionType.PHUONG, "phuong_thai_hoc", 290)
    W_10591 = Ward("Xã Nhân Huệ", 10591, VietNamDivisionType.XA, "xa_nhan_hue", 290)
    W_10594 = Ward("Phường An Lạc", 10594, VietNamDivisionType.PHUONG, "phuong_an_lac", 290)
    W_10600 = Ward("Phường Đồng Lạc", 10600, VietNamDivisionType.PHUONG, "phuong_dong_lac", 290)
    W_10603 = Ward("Phường Tân Dân", 10603, VietNamDivisionType.PHUONG, "phuong_tan_dan", 290)
    W_10606 = Ward("Thị trấn Nam Sách", 10606, VietNamDivisionType.THI_TRAN, "thi_tran_nam_sach", 291)
    W_10609 = Ward("Xã Nam Hưng", 10609, VietNamDivisionType.XA, "xa_nam_hung", 291)
    W_10612 = Ward("Xã Nam Tân", 10612, VietNamDivisionType.XA, "xa_nam_tan", 291)
    W_10615 = Ward("Xã Hợp Tiến", 10615, VietNamDivisionType.XA, "xa_hop_tien", 291)
    W_10618 = Ward("Xã Hiệp Cát", 10618, VietNamDivisionType.XA, "xa_hiep_cat", 291)
    W_10621 = Ward("Xã Thanh Quang", 10621, VietNamDivisionType.XA, "xa_thanh_quang", 291)
    W_10624 = Ward("Xã Quốc Tuấn", 10624, VietNamDivisionType.XA, "xa_quoc_tuan", 291)
    W_10627 = Ward("Xã Nam Chính", 10627, VietNamDivisionType.XA, "xa_nam_chinh", 291)
    W_10630 = Ward("Xã An Bình", 10630, VietNamDivisionType.XA, "xa_an_binh", 291)
    W_10633 = Ward("Xã Nam Trung", 10633, VietNamDivisionType.XA, "xa_nam_trung", 291)
    W_10636 = Ward("Xã An Sơn", 10636, VietNamDivisionType.XA, "xa_an_son", 291)
    W_10639 = Ward("Xã Cộng Hòa", 10639, VietNamDivisionType.XA, "xa_cong_hoa", 291)
    W_10642 = Ward("Xã Thái Tân", 10642, VietNamDivisionType.XA, "xa_thai_tan", 291)
    W_10645 = Ward("Xã An Lâm", 10645, VietNamDivisionType.XA, "xa_an_lam", 291)
    W_10648 = Ward("Xã Phú Điền", 10648, VietNamDivisionType.XA, "xa_phu_dien", 291)
    W_10651 = Ward("Xã Nam Hồng", 10651, VietNamDivisionType.XA, "xa_nam_hong", 291)
    W_10654 = Ward("Xã Hồng Phong", 10654, VietNamDivisionType.XA, "xa_hong_phong", 291)
    W_10657 = Ward("Xã Đồng Lạc", 10657, VietNamDivisionType.XA, "xa_dong_lac", 291)
    W_10666 = Ward("Xã Minh Tân", 10666, VietNamDivisionType.XA, "xa_minh_tan", 291)
    W_10675 = Ward("Phường An Lưu", 10675, VietNamDivisionType.PHUONG, "phuong_an_luu", 292)
    W_10678 = Ward("Xã Bạch Đằng", 10678, VietNamDivisionType.XA, "xa_bach_dang", 292)
    W_10681 = Ward("Phường Thất Hùng", 10681, VietNamDivisionType.PHUONG, "phuong_that_hung", 292)
    W_10684 = Ward("Xã Lê Ninh", 10684, VietNamDivisionType.XA, "xa_le_ninh", 292)
    W_10687 = Ward("Xã Hoành Sơn", 10687, VietNamDivisionType.XA, "xa_hoanh_son", 292)
    W_10693 = Ward("Phường Phạm Thái", 10693, VietNamDivisionType.PHUONG, "phuong_pham_thai", 292)
    W_10696 = Ward("Phường Duy Tân", 10696, VietNamDivisionType.PHUONG, "phuong_duy_tan", 292)
    W_10699 = Ward("Phường Tân Dân", 10699, VietNamDivisionType.PHUONG, "phuong_tan_dan", 292)
    W_10702 = Ward("Phường Minh Tân", 10702, VietNamDivisionType.PHUONG, "phuong_minh_tan", 292)
    W_10705 = Ward("Xã Quang Thành", 10705, VietNamDivisionType.XA, "xa_quang_thanh", 292)
    W_10708 = Ward("Xã Hiệp Hòa", 10708, VietNamDivisionType.XA, "xa_hiep_hoa", 292)
    W_10714 = Ward("Phường Phú Thứ", 10714, VietNamDivisionType.PHUONG, "phuong_phu_thu", 292)
    W_10717 = Ward("Xã Thăng Long", 10717, VietNamDivisionType.XA, "xa_thang_long", 292)
    W_10720 = Ward("Xã Lạc Long", 10720, VietNamDivisionType.XA, "xa_lac_long", 292)
    W_10723 = Ward("Phường An Sinh", 10723, VietNamDivisionType.PHUONG, "phuong_an_sinh", 292)
    W_10726 = Ward("Phường Hiệp Sơn", 10726, VietNamDivisionType.PHUONG, "phuong_hiep_son", 292)
    W_10729 = Ward("Xã Thượng Quận", 10729, VietNamDivisionType.XA, "xa_thuong_quan", 292)
    W_10732 = Ward("Phường An Phụ", 10732, VietNamDivisionType.PHUONG, "phuong_an_phu", 292)
    W_10735 = Ward("Phường Hiệp An", 10735, VietNamDivisionType.PHUONG, "phuong_hiep_an", 292)
    W_10738 = Ward("Phường Long Xuyên", 10738, VietNamDivisionType.PHUONG, "phuong_long_xuyen", 292)
    W_10741 = Ward("Phường Thái Thịnh", 10741, VietNamDivisionType.PHUONG, "phuong_thai_thinh", 292)
    W_10744 = Ward("Phường Hiến Thành", 10744, VietNamDivisionType.PHUONG, "phuong_hien_thanh", 292)
    W_10747 = Ward("Xã Minh Hòa", 10747, VietNamDivisionType.XA, "xa_minh_hoa", 292)
    W_10750 = Ward("Thị trấn Phú Thái", 10750, VietNamDivisionType.THI_TRAN, "thi_tran_phu_thai", 293)
    W_10753 = Ward("Xã Lai Vu", 10753, VietNamDivisionType.XA, "xa_lai_vu", 293)
    W_10756 = Ward("Xã Cộng Hòa", 10756, VietNamDivisionType.XA, "xa_cong_hoa", 293)
    W_10759 = Ward("Xã Thượng Vũ", 10759, VietNamDivisionType.XA, "xa_thuong_vu", 293)
    W_10762 = Ward("Xã Cổ Dũng", 10762, VietNamDivisionType.XA, "xa_co_dung", 293)
    W_10768 = Ward("Xã Tuấn Việt", 10768, VietNamDivisionType.XA, "xa_tuan_viet", 293)
    W_10771 = Ward("Xã Kim Xuyên", 10771, VietNamDivisionType.XA, "xa_kim_xuyen", 293)
    W_10774 = Ward("Xã Phúc Thành A", 10774, VietNamDivisionType.XA, "xa_phuc_thanh_a", 293)
    W_10777 = Ward("Xã Ngũ Phúc", 10777, VietNamDivisionType.XA, "xa_ngu_phuc", 293)
    W_10780 = Ward("Xã Kim Anh", 10780, VietNamDivisionType.XA, "xa_kim_anh", 293)
    W_10783 = Ward("Xã Kim Liên", 10783, VietNamDivisionType.XA, "xa_kim_lien", 293)
    W_10786 = Ward("Xã Kim Tân", 10786, VietNamDivisionType.XA, "xa_kim_tan", 293)
    W_10792 = Ward("Xã Kim Đính", 10792, VietNamDivisionType.XA, "xa_kim_dinh", 293)
    W_10798 = Ward("Xã Bình Dân", 10798, VietNamDivisionType.XA, "xa_binh_dan", 293)
    W_10801 = Ward("Xã Tam Kỳ", 10801, VietNamDivisionType.XA, "xa_tam_ky", 293)
    W_10804 = Ward("Xã Đồng Cẩm", 10804, VietNamDivisionType.XA, "xa_dong_cam", 293)
    W_10807 = Ward("Xã Liên Hòa", 10807, VietNamDivisionType.XA, "xa_lien_hoa", 293)
    W_10810 = Ward("Xã Đại Đức", 10810, VietNamDivisionType.XA, "xa_dai_duc", 293)
    W_10813 = Ward("Thị trấn Thanh Hà", 10813, VietNamDivisionType.THI_TRAN, "thi_tran_thanh_ha", 294)
    W_10816 = Ward("Xã Hồng Lạc", 10816, VietNamDivisionType.XA, "xa_hong_lac", 294)
    W_10819 = Ward("Xã Việt Hồng", 10819, VietNamDivisionType.XA, "xa_viet_hong", 294)
    W_10825 = Ward("Xã Tân Việt", 10825, VietNamDivisionType.XA, "xa_tan_viet", 294)
    W_10828 = Ward("Xã Cẩm Chế", 10828, VietNamDivisionType.XA, "xa_cam_che", 294)
    W_10831 = Ward("Xã Thanh An", 10831, VietNamDivisionType.XA, "xa_thanh_an", 294)
    W_10834 = Ward("Xã Thanh Lang", 10834, VietNamDivisionType.XA, "xa_thanh_lang", 294)
    W_10840 = Ward("Xã Tân An", 10840, VietNamDivisionType.XA, "xa_tan_an", 294)
    W_10843 = Ward("Xã Liên Mạc", 10843, VietNamDivisionType.XA, "xa_lien_mac", 294)
    W_10846 = Ward("Xã Thanh Hải", 10846, VietNamDivisionType.XA, "xa_thanh_hai", 294)
    W_10849 = Ward("Xã Thanh Khê", 10849, VietNamDivisionType.XA, "xa_thanh_khe", 294)
    W_10852 = Ward("Xã Thanh Xá", 10852, VietNamDivisionType.XA, "xa_thanh_xa", 294)
    W_10855 = Ward("Xã Thanh Xuân", 10855, VietNamDivisionType.XA, "xa_thanh_xuan", 294)
    W_10861 = Ward("Xã Thanh Thủy", 10861, VietNamDivisionType.XA, "xa_thanh_thuy", 294)
    W_10864 = Ward("Xã An Phượng", 10864, VietNamDivisionType.XA, "xa_an_phuong", 294)
    W_10867 = Ward("Xã Thanh Sơn", 10867, VietNamDivisionType.XA, "xa_thanh_son", 294)
    W_10876 = Ward("Xã Thanh Quang", 10876, VietNamDivisionType.XA, "xa_thanh_quang", 294)
    W_10879 = Ward("Xã Thanh Hồng", 10879, VietNamDivisionType.XA, "xa_thanh_hong", 294)
    W_10882 = Ward("Xã Thanh Cường", 10882, VietNamDivisionType.XA, "xa_thanh_cuong", 294)
    W_10885 = Ward("Xã Vĩnh Lập", 10885, VietNamDivisionType.XA, "xa_vinh_lap", 294)
    W_10888 = Ward("Thị trấn Cẩm Giang", 10888, VietNamDivisionType.THI_TRAN, "thi_tran_cam_giang", 295)
    W_10891 = Ward("Thị trấn Lai Cách", 10891, VietNamDivisionType.THI_TRAN, "thi_tran_lai_cach", 295)
    W_10894 = Ward("Xã Cẩm Hưng", 10894, VietNamDivisionType.XA, "xa_cam_hung", 295)
    W_10897 = Ward("Xã Cẩm Hoàng", 10897, VietNamDivisionType.XA, "xa_cam_hoang", 295)
    W_10900 = Ward("Xã Cẩm Văn", 10900, VietNamDivisionType.XA, "xa_cam_van", 295)
    W_10903 = Ward("Xã Ngọc Liên", 10903, VietNamDivisionType.XA, "xa_ngoc_lien", 295)
    W_10906 = Ward("Xã Thạch Lỗi", 10906, VietNamDivisionType.XA, "xa_thach_loi", 295)
    W_10909 = Ward("Xã Cẩm Vũ", 10909, VietNamDivisionType.XA, "xa_cam_vu", 295)
    W_10912 = Ward("Xã Đức Chính", 10912, VietNamDivisionType.XA, "xa_duc_chinh", 295)
    W_10918 = Ward("Xã Định Sơn", 10918, VietNamDivisionType.XA, "xa_dinh_son", 295)
    W_10924 = Ward("Xã Lương Điền", 10924, VietNamDivisionType.XA, "xa_luong_dien", 295)
    W_10927 = Ward("Xã Cao An", 10927, VietNamDivisionType.XA, "xa_cao_an", 295)
    W_10930 = Ward("Xã Tân Trường", 10930, VietNamDivisionType.XA, "xa_tan_truong", 295)
    W_10933 = Ward("Xã Cẩm Phúc", 10933, VietNamDivisionType.XA, "xa_cam_phuc", 295)
    W_10936 = Ward("Xã Cẩm Điền", 10936, VietNamDivisionType.XA, "xa_cam_dien", 295)
    W_10939 = Ward("Xã Cẩm Đông", 10939, VietNamDivisionType.XA, "xa_cam_dong", 295)
    W_10942 = Ward("Xã Cẩm Đoài", 10942, VietNamDivisionType.XA, "xa_cam_doai", 295)
    W_10945 = Ward("Thị trấn Kẻ Sặt", 10945, VietNamDivisionType.THI_TRAN, "thi_tran_ke_sat", 296)
    W_10951 = Ward("Xã Vĩnh Hưng", 10951, VietNamDivisionType.XA, "xa_vinh_hung", 296)
    W_10954 = Ward("Xã Hùng Thắng", 10954, VietNamDivisionType.XA, "xa_hung_thang", 296)
    W_10960 = Ward("Xã Vĩnh Hồng", 10960, VietNamDivisionType.XA, "xa_vinh_hong", 296)
    W_10963 = Ward("Xã Long Xuyên", 10963, VietNamDivisionType.XA, "xa_long_xuyen", 296)
    W_10966 = Ward("Xã Tân Việt", 10966, VietNamDivisionType.XA, "xa_tan_viet", 296)
    W_10969 = Ward("Xã Thúc Kháng", 10969, VietNamDivisionType.XA, "xa_thuc_khang", 296)
    W_10972 = Ward("Xã Tân Hồng", 10972, VietNamDivisionType.XA, "xa_tan_hong", 296)
    W_10975 = Ward("Xã Bình Minh", 10975, VietNamDivisionType.XA, "xa_binh_minh", 296)
    W_10978 = Ward("Xã Hồng Khê", 10978, VietNamDivisionType.XA, "xa_hong_khe", 296)
    W_10981 = Ward("Xã Thái Học", 10981, VietNamDivisionType.XA, "xa_thai_hoc", 296)
    W_10984 = Ward("Xã Cổ Bì", 10984, VietNamDivisionType.XA, "xa_co_bi", 296)
    W_10987 = Ward("Xã Nhân Quyền", 10987, VietNamDivisionType.XA, "xa_nhan_quyen", 296)
    W_10990 = Ward("Xã Thái Dương", 10990, VietNamDivisionType.XA, "xa_thai_duong", 296)
    W_10993 = Ward("Xã Thái Hòa", 10993, VietNamDivisionType.XA, "xa_thai_hoa", 296)
    W_10996 = Ward("Xã Bình Xuyên", 10996, VietNamDivisionType.XA, "xa_binh_xuyen", 296)
    W_10999 = Ward("Thị trấn Gia Lộc", 10999, VietNamDivisionType.THI_TRAN, "thi_tran_gia_loc", 297)
    W_11008 = Ward("Xã Thống Nhất", 11008, VietNamDivisionType.XA, "xa_thong_nhat", 297)
    W_11020 = Ward("Xã Yết Kiêu", 11020, VietNamDivisionType.XA, "xa_yet_kieu", 297)
    W_11029 = Ward("Xã Gia Tân", 11029, VietNamDivisionType.XA, "xa_gia_tan", 297)
    W_11032 = Ward("Xã Tân Tiến", 11032, VietNamDivisionType.XA, "xa_tan_tien", 297)
    W_11035 = Ward("Xã Gia Khánh", 11035, VietNamDivisionType.XA, "xa_gia_khanh", 297)
    W_11038 = Ward("Xã Gia Lương", 11038, VietNamDivisionType.XA, "xa_gia_luong", 297)
    W_11041 = Ward("Xã Lê Lợi", 11041, VietNamDivisionType.XA, "xa_le_loi", 297)
    W_11044 = Ward("Xã Toàn Thắng", 11044, VietNamDivisionType.XA, "xa_toan_thang", 297)
    W_11047 = Ward("Xã Hoàng Diệu", 11047, VietNamDivisionType.XA, "xa_hoang_dieu", 297)
    W_11050 = Ward("Xã Hồng Hưng", 11050, VietNamDivisionType.XA, "xa_hong_hung", 297)
    W_11053 = Ward("Xã Phạm Trấn", 11053, VietNamDivisionType.XA, "xa_pham_tran", 297)
    W_11056 = Ward("Xã Đoàn Thượng", 11056, VietNamDivisionType.XA, "xa_doan_thuong", 297)
    W_11059 = Ward("Xã Thống Kênh", 11059, VietNamDivisionType.XA, "xa_thong_kenh", 297)
    W_11062 = Ward("Xã Quang Minh", 11062, VietNamDivisionType.XA, "xa_quang_minh", 297)
    W_11065 = Ward("Xã Đồng Quang", 11065, VietNamDivisionType.XA, "xa_dong_quang", 297)
    W_11068 = Ward("Xã Nhật Tân", 11068, VietNamDivisionType.XA, "xa_nhat_tan", 297)
    W_11071 = Ward("Xã Đức Xương", 11071, VietNamDivisionType.XA, "xa_duc_xuong", 297)
    W_11074 = Ward("Thị trấn Tứ Kỳ", 11074, VietNamDivisionType.THI_TRAN, "thi_tran_tu_ky", 298)
    W_11083 = Ward("Xã Đại Sơn", 11083, VietNamDivisionType.XA, "xa_dai_son", 298)
    W_11086 = Ward("Xã Hưng Đạo", 11086, VietNamDivisionType.XA, "xa_hung_dao", 298)
    W_11089 = Ward("Xã Ngọc Kỳ", 11089, VietNamDivisionType.XA, "xa_ngoc_ky", 298)
    W_11092 = Ward("Xã Bình Lăng", 11092, VietNamDivisionType.XA, "xa_binh_lang", 298)
    W_11095 = Ward("Xã Chí Minh", 11095, VietNamDivisionType.XA, "xa_chi_minh", 298)
    W_11098 = Ward("Xã Tái Sơn", 11098, VietNamDivisionType.XA, "xa_tai_son", 298)
    W_11101 = Ward("Xã Quang Phục", 11101, VietNamDivisionType.XA, "xa_quang_phuc", 298)
    W_11110 = Ward("Xã Dân Chủ", 11110, VietNamDivisionType.XA, "xa_dan_chu", 298)
    W_11113 = Ward("Xã Tân Kỳ", 11113, VietNamDivisionType.XA, "xa_tan_ky", 298)
    W_11116 = Ward("Xã Quang Khải", 11116, VietNamDivisionType.XA, "xa_quang_khai", 298)
    W_11119 = Ward("Xã Đại Hợp", 11119, VietNamDivisionType.XA, "xa_dai_hop", 298)
    W_11122 = Ward("Xã Quảng Nghiệp", 11122, VietNamDivisionType.XA, "xa_quang_nghiep", 298)
    W_11125 = Ward("Xã An Thanh", 11125, VietNamDivisionType.XA, "xa_an_thanh", 298)
    W_11128 = Ward("Xã Minh Đức", 11128, VietNamDivisionType.XA, "xa_minh_duc", 298)
    W_11131 = Ward("Xã Văn Tố", 11131, VietNamDivisionType.XA, "xa_van_to", 298)
    W_11134 = Ward("Xã Quang Trung", 11134, VietNamDivisionType.XA, "xa_quang_trung", 298)
    W_11137 = Ward("Xã Phượng Kỳ", 11137, VietNamDivisionType.XA, "xa_phuong_ky", 298)
    W_11140 = Ward("Xã Cộng Lạc", 11140, VietNamDivisionType.XA, "xa_cong_lac", 298)
    W_11143 = Ward("Xã Tiên Động", 11143, VietNamDivisionType.XA, "xa_tien_dong", 298)
    W_11146 = Ward("Xã Nguyên Giáp", 11146, VietNamDivisionType.XA, "xa_nguyen_giap", 298)
    W_11149 = Ward("Xã Hà Kỳ", 11149, VietNamDivisionType.XA, "xa_ha_ky", 298)
    W_11152 = Ward("Xã Hà Thanh", 11152, VietNamDivisionType.XA, "xa_ha_thanh", 298)
    W_11155 = Ward("Thị trấn Ninh Giang", 11155, VietNamDivisionType.THI_TRAN, "thi_tran_ninh_giang", 299)
    W_11161 = Ward("Xã Ứng Hoè", 11161, VietNamDivisionType.XA, "xa_ung_hoe", 299)
    W_11164 = Ward("Xã Nghĩa An", 11164, VietNamDivisionType.XA, "xa_nghia_an", 299)
    W_11167 = Ward("Xã Hồng Đức", 11167, VietNamDivisionType.XA, "xa_hong_duc", 299)
    W_11173 = Ward("Xã An Đức", 11173, VietNamDivisionType.XA, "xa_an_duc", 299)
    W_11176 = Ward("Xã Vạn Phúc", 11176, VietNamDivisionType.XA, "xa_van_phuc", 299)
    W_11179 = Ward("Xã Tân Hương", 11179, VietNamDivisionType.XA, "xa_tan_huong", 299)
    W_11185 = Ward("Xã Vĩnh Hòa", 11185, VietNamDivisionType.XA, "xa_vinh_hoa", 299)
    W_11188 = Ward("Xã Đông Xuyên", 11188, VietNamDivisionType.XA, "xa_dong_xuyen", 299)
    W_11197 = Ward("Xã Tân Phong", 11197, VietNamDivisionType.XA, "xa_tan_phong", 299)
    W_11200 = Ward("Xã Ninh Hải", 11200, VietNamDivisionType.XA, "xa_ninh_hai", 299)
    W_11203 = Ward("Xã Đồng Tâm", 11203, VietNamDivisionType.XA, "xa_dong_tam", 299)
    W_11206 = Ward("Xã Tân Quang", 11206, VietNamDivisionType.XA, "xa_tan_quang", 299)
    W_11209 = Ward("Xã Kiến Quốc", 11209, VietNamDivisionType.XA, "xa_kien_quoc", 299)
    W_11215 = Ward("Xã Hồng Dụ", 11215, VietNamDivisionType.XA, "xa_hong_du", 299)
    W_11218 = Ward("Xã Văn Hội", 11218, VietNamDivisionType.XA, "xa_van_hoi", 299)
    W_11224 = Ward("Xã Hồng Phong", 11224, VietNamDivisionType.XA, "xa_hong_phong", 299)
    W_11227 = Ward("Xã Hiệp Lực", 11227, VietNamDivisionType.XA, "xa_hiep_luc", 299)
    W_11230 = Ward("Xã Hồng Phúc", 11230, VietNamDivisionType.XA, "xa_hong_phuc", 299)
    W_11233 = Ward("Xã Hưng Long", 11233, VietNamDivisionType.XA, "xa_hung_long", 299)
    W_11239 = Ward("Thị trấn Thanh Miện", 11239, VietNamDivisionType.THI_TRAN, "thi_tran_thanh_mien", 300)
    W_11242 = Ward("Xã Thanh Tùng", 11242, VietNamDivisionType.XA, "xa_thanh_tung", 300)
    W_11245 = Ward("Xã Phạm Kha", 11245, VietNamDivisionType.XA, "xa_pham_kha", 300)
    W_11248 = Ward("Xã Ngô Quyền", 11248, VietNamDivisionType.XA, "xa_ngo_quyen", 300)
    W_11251 = Ward("Xã Đoàn Tùng", 11251, VietNamDivisionType.XA, "xa_doan_tung", 300)
    W_11254 = Ward("Xã Hồng Quang", 11254, VietNamDivisionType.XA, "xa_hong_quang", 300)
    W_11257 = Ward("Xã Tân Trào", 11257, VietNamDivisionType.XA, "xa_tan_trao", 300)
    W_11260 = Ward("Xã Lam Sơn", 11260, VietNamDivisionType.XA, "xa_lam_son", 300)
    W_11263 = Ward("Xã Đoàn Kết", 11263, VietNamDivisionType.XA, "xa_doan_ket", 300)
    W_11266 = Ward("Xã Lê Hồng", 11266, VietNamDivisionType.XA, "xa_le_hong", 300)
    W_11269 = Ward("Xã Tứ Cường", 11269, VietNamDivisionType.XA, "xa_tu_cuong", 300)
    W_11275 = Ward("Xã Ngũ Hùng", 11275, VietNamDivisionType.XA, "xa_ngu_hung", 300)
    W_11278 = Ward("Xã Cao Thắng", 11278, VietNamDivisionType.XA, "xa_cao_thang", 300)
    W_11281 = Ward("Xã Chi Lăng Bắc", 11281, VietNamDivisionType.XA, "xa_chi_lang_bac", 300)
    W_11284 = Ward("Xã Chi Lăng Nam", 11284, VietNamDivisionType.XA, "xa_chi_lang_nam", 300)
    W_11287 = Ward("Xã Thanh Giang", 11287, VietNamDivisionType.XA, "xa_thanh_giang", 300)
    W_11293 = Ward("Xã Hồng Phong", 11293, VietNamDivisionType.XA, "xa_hong_phong", 300)
    W_11296 = Ward("Phường Quán Toan", 11296, VietNamDivisionType.PHUONG, "phuong_quan_toan", 303)
    W_11299 = Ward("Phường Hùng Vương", 11299, VietNamDivisionType.PHUONG, "phuong_hung_vuong", 303)
    W_11302 = Ward("Phường Sở Dầu", 11302, VietNamDivisionType.PHUONG, "phuong_so_dau", 303)
    W_11305 = Ward("Phường Thượng Lý", 11305, VietNamDivisionType.PHUONG, "phuong_thuong_ly", 303)
    W_11308 = Ward("Phường Hạ Lý", 11308, VietNamDivisionType.PHUONG, "phuong_ha_ly", 303)
    W_11311 = Ward("Phường Minh Khai", 11311, VietNamDivisionType.PHUONG, "phuong_minh_khai", 303)
    W_11314 = Ward("Phường Trại Chuối", 11314, VietNamDivisionType.PHUONG, "phuong_trai_chuoi", 303)
    W_11320 = Ward("Phường Hoàng Văn Thụ", 11320, VietNamDivisionType.PHUONG, "phuong_hoang_van_thu", 303)
    W_11323 = Ward("Phường Phan Bội Châu", 11323, VietNamDivisionType.PHUONG, "phuong_phan_boi_chau", 303)
    W_11329 = Ward("Phường Máy Chai", 11329, VietNamDivisionType.PHUONG, "phuong_may_chai", 304)
    W_11332 = Ward("Phường Máy Tơ", 11332, VietNamDivisionType.PHUONG, "phuong_may_to", 304)
    W_11335 = Ward("Phường Vạn Mỹ", 11335, VietNamDivisionType.PHUONG, "phuong_van_my", 304)
    W_11338 = Ward("Phường Cầu Tre", 11338, VietNamDivisionType.PHUONG, "phuong_cau_tre", 304)
    W_11341 = Ward("Phường Lạc Viên", 11341, VietNamDivisionType.PHUONG, "phuong_lac_vien", 304)
    W_11347 = Ward("Phường Gia Viên", 11347, VietNamDivisionType.PHUONG, "phuong_gia_vien", 304)
    W_11350 = Ward("Phường Đông Khê", 11350, VietNamDivisionType.PHUONG, "phuong_dong_khe", 304)
    W_11353 = Ward("Phường Cầu Đất", 11353, VietNamDivisionType.PHUONG, "phuong_cau_dat", 304)
    W_11356 = Ward("Phường Lê Lợi", 11356, VietNamDivisionType.PHUONG, "phuong_le_loi", 304)
    W_11359 = Ward("Phường Đằng Giang", 11359, VietNamDivisionType.PHUONG, "phuong_dang_giang", 304)
    W_11362 = Ward("Phường Lạch Tray", 11362, VietNamDivisionType.PHUONG, "phuong_lach_tray", 304)
    W_11365 = Ward("Phường Đổng Quốc Bình", 11365, VietNamDivisionType.PHUONG, "phuong_dong_quoc_binh", 304)
    W_11368 = Ward("Phường Cát Dài", 11368, VietNamDivisionType.PHUONG, "phuong_cat_dai", 305)
    W_11371 = Ward("Phường An Biên", 11371, VietNamDivisionType.PHUONG, "phuong_an_bien", 305)
    W_11374 = Ward("Phường Lam Sơn", 11374, VietNamDivisionType.PHUONG, "phuong_lam_son", 305)
    W_11377 = Ward("Phường An Dương", 11377, VietNamDivisionType.PHUONG, "phuong_an_duong", 305)
    W_11380 = Ward("Phường Trần Nguyên Hãn", 11380, VietNamDivisionType.PHUONG, "phuong_tran_nguyen_han", 305)
    W_11383 = Ward("Phường Hồ Nam", 11383, VietNamDivisionType.PHUONG, "phuong_ho_nam", 305)
    W_11386 = Ward("Phường Trại Cau", 11386, VietNamDivisionType.PHUONG, "phuong_trai_cau", 305)
    W_11389 = Ward("Phường Dư Hàng", 11389, VietNamDivisionType.PHUONG, "phuong_du_hang", 305)
    W_11392 = Ward("Phường Hàng Kênh", 11392, VietNamDivisionType.PHUONG, "phuong_hang_kenh", 305)
    W_11395 = Ward("Phường Đông Hải", 11395, VietNamDivisionType.PHUONG, "phuong_dong_hai", 305)
    W_11398 = Ward("Phường Niệm Nghĩa", 11398, VietNamDivisionType.PHUONG, "phuong_niem_nghia", 305)
    W_11401 = Ward("Phường Nghĩa Xá", 11401, VietNamDivisionType.PHUONG, "phuong_nghia_xa", 305)
    W_11404 = Ward("Phường Dư Hàng Kênh", 11404, VietNamDivisionType.PHUONG, "phuong_du_hang_kenh", 305)
    W_11405 = Ward("Phường Kênh Dương", 11405, VietNamDivisionType.PHUONG, "phuong_kenh_duong", 305)
    W_11407 = Ward("Phường Vĩnh Niệm", 11407, VietNamDivisionType.PHUONG, "phuong_vinh_niem", 305)
    W_11410 = Ward("Phường Đông Hải 1", 11410, VietNamDivisionType.PHUONG, "phuong_dong_hai_1", 306)
    W_11411 = Ward("Phường Đông Hải 2", 11411, VietNamDivisionType.PHUONG, "phuong_dong_hai_2", 306)
    W_11413 = Ward("Phường Đằng Lâm", 11413, VietNamDivisionType.PHUONG, "phuong_dang_lam", 306)
    W_11414 = Ward("Phường Thành Tô", 11414, VietNamDivisionType.PHUONG, "phuong_thanh_to", 306)
    W_11416 = Ward("Phường Đằng Hải", 11416, VietNamDivisionType.PHUONG, "phuong_dang_hai", 306)
    W_11419 = Ward("Phường Nam Hải", 11419, VietNamDivisionType.PHUONG, "phuong_nam_hai", 306)
    W_11422 = Ward("Phường Cát Bi", 11422, VietNamDivisionType.PHUONG, "phuong_cat_bi", 306)
    W_11425 = Ward("Phường Tràng Cát", 11425, VietNamDivisionType.PHUONG, "phuong_trang_cat", 306)
    W_11428 = Ward("Phường Quán Trữ", 11428, VietNamDivisionType.PHUONG, "phuong_quan_tru", 307)
    W_11429 = Ward("Phường Lãm Hà", 11429, VietNamDivisionType.PHUONG, "phuong_lam_ha", 307)
    W_11431 = Ward("Phường Đồng Hoà", 11431, VietNamDivisionType.PHUONG, "phuong_dong_hoa", 307)
    W_11434 = Ward("Phường Bắc Sơn", 11434, VietNamDivisionType.PHUONG, "phuong_bac_son", 307)
    W_11437 = Ward("Phường Nam Sơn", 11437, VietNamDivisionType.PHUONG, "phuong_nam_son", 307)
    W_11440 = Ward("Phường Ngọc Sơn", 11440, VietNamDivisionType.PHUONG, "phuong_ngoc_son", 307)
    W_11443 = Ward("Phường Trần Thành Ngọ", 11443, VietNamDivisionType.PHUONG, "phuong_tran_thanh_ngo", 307)
    W_11446 = Ward("Phường Văn Đẩu", 11446, VietNamDivisionType.PHUONG, "phuong_van_dau", 307)
    W_11449 = Ward("Phường Phù Liễn", 11449, VietNamDivisionType.PHUONG, "phuong_phu_lien", 307)
    W_11452 = Ward("Phường Tràng Minh", 11452, VietNamDivisionType.PHUONG, "phuong_trang_minh", 307)
    W_11455 = Ward("Phường Ngọc Xuyên", 11455, VietNamDivisionType.PHUONG, "phuong_ngoc_xuyen", 308)
    W_11458 = Ward("Phường Hải Sơn", 11458, VietNamDivisionType.PHUONG, "phuong_hai_son", 308)
    W_11461 = Ward("Phường Vạn Hương", 11461, VietNamDivisionType.PHUONG, "phuong_van_huong", 308)
    W_11465 = Ward("Phường Minh Đức", 11465, VietNamDivisionType.PHUONG, "phuong_minh_duc", 308)
    W_11467 = Ward("Phường Bàng La", 11467, VietNamDivisionType.PHUONG, "phuong_bang_la", 308)
    W_11737 = Ward("Phường Hợp Đức", 11737, VietNamDivisionType.PHUONG, "phuong_hop_duc", 308)
    W_11683 = Ward("Phường Đa Phúc", 11683, VietNamDivisionType.PHUONG, "phuong_da_phuc", 309)
    W_11686 = Ward("Phường Hưng Đạo", 11686, VietNamDivisionType.PHUONG, "phuong_hung_dao", 309)
    W_11689 = Ward("Phường Anh Dũng", 11689, VietNamDivisionType.PHUONG, "phuong_anh_dung", 309)
    W_11692 = Ward("Phường Hải Thành", 11692, VietNamDivisionType.PHUONG, "phuong_hai_thanh", 309)
    W_11707 = Ward("Phường Hoà Nghĩa", 11707, VietNamDivisionType.PHUONG, "phuong_hoa_nghia", 309)
    W_11740 = Ward("Phường Tân Thành", 11740, VietNamDivisionType.PHUONG, "phuong_tan_thanh", 309)
    W_11470 = Ward("Thị trấn Núi Đèo", 11470, VietNamDivisionType.THI_TRAN, "thi_tran_nui_deo", 311)
    W_11473 = Ward("Thị trấn Minh Đức", 11473, VietNamDivisionType.THI_TRAN, "thi_tran_minh_duc", 311)
    W_11476 = Ward("Xã Lại Xuân", 11476, VietNamDivisionType.XA, "xa_lai_xuan", 311)
    W_11479 = Ward("Xã An Sơn", 11479, VietNamDivisionType.XA, "xa_an_son", 311)
    W_11482 = Ward("Xã Kỳ Sơn", 11482, VietNamDivisionType.XA, "xa_ky_son", 311)
    W_11485 = Ward("Xã Liên Khê", 11485, VietNamDivisionType.XA, "xa_lien_khe", 311)
    W_11488 = Ward("Xã Lưu Kiếm", 11488, VietNamDivisionType.XA, "xa_luu_kiem", 311)
    W_11491 = Ward("Xã Lưu Kỳ", 11491, VietNamDivisionType.XA, "xa_luu_ky", 311)
    W_11494 = Ward("Xã Gia Minh", 11494, VietNamDivisionType.XA, "xa_gia_minh", 311)
    W_11497 = Ward("Xã Gia Đức", 11497, VietNamDivisionType.XA, "xa_gia_duc", 311)
    W_11500 = Ward("Xã Minh Tân", 11500, VietNamDivisionType.XA, "xa_minh_tan", 311)
    W_11503 = Ward("Xã Phù Ninh", 11503, VietNamDivisionType.XA, "xa_phu_ninh", 311)
    W_11506 = Ward("Xã Quảng Thanh", 11506, VietNamDivisionType.XA, "xa_quang_thanh", 311)
    W_11509 = Ward("Xã Chính Mỹ", 11509, VietNamDivisionType.XA, "xa_chinh_my", 311)
    W_11512 = Ward("Xã Kênh Giang", 11512, VietNamDivisionType.XA, "xa_kenh_giang", 311)
    W_11515 = Ward("Xã Hợp Thành", 11515, VietNamDivisionType.XA, "xa_hop_thanh", 311)
    W_11518 = Ward("Xã Cao Nhân", 11518, VietNamDivisionType.XA, "xa_cao_nhan", 311)
    W_11521 = Ward("Xã Mỹ Đồng", 11521, VietNamDivisionType.XA, "xa_my_dong", 311)
    W_11524 = Ward("Xã Đông Sơn", 11524, VietNamDivisionType.XA, "xa_dong_son", 311)
    W_11527 = Ward("Xã Hoà Bình", 11527, VietNamDivisionType.XA, "xa_hoa_binh", 311)
    W_11530 = Ward("Xã Trung Hà", 11530, VietNamDivisionType.XA, "xa_trung_ha", 311)
    W_11533 = Ward("Xã An Lư", 11533, VietNamDivisionType.XA, "xa_an_lu", 311)
    W_11536 = Ward("Xã Thuỷ Triều", 11536, VietNamDivisionType.XA, "xa_thuy_trieu", 311)
    W_11539 = Ward("Xã Ngũ Lão", 11539, VietNamDivisionType.XA, "xa_ngu_lao", 311)
    W_11542 = Ward("Xã Phục Lễ", 11542, VietNamDivisionType.XA, "xa_phuc_le", 311)
    W_11545 = Ward("Xã Tam Hưng", 11545, VietNamDivisionType.XA, "xa_tam_hung", 311)
    W_11548 = Ward("Xã Phả Lễ", 11548, VietNamDivisionType.XA, "xa_pha_le", 311)
    W_11551 = Ward("Xã Lập Lễ", 11551, VietNamDivisionType.XA, "xa_lap_le", 311)
    W_11554 = Ward("Xã Kiền Bái", 11554, VietNamDivisionType.XA, "xa_kien_bai", 311)
    W_11557 = Ward("Xã Thiên Hương", 11557, VietNamDivisionType.XA, "xa_thien_huong", 311)
    W_11560 = Ward("Xã Thuỷ Sơn", 11560, VietNamDivisionType.XA, "xa_thuy_son", 311)
    W_11563 = Ward("Xã Thuỷ Đường", 11563, VietNamDivisionType.XA, "xa_thuy_duong", 311)
    W_11566 = Ward("Xã Hoàng Động", 11566, VietNamDivisionType.XA, "xa_hoang_dong", 311)
    W_11569 = Ward("Xã Lâm Động", 11569, VietNamDivisionType.XA, "xa_lam_dong", 311)
    W_11572 = Ward("Xã Hoa Động", 11572, VietNamDivisionType.XA, "xa_hoa_dong", 311)
    W_11575 = Ward("Xã Tân Dương", 11575, VietNamDivisionType.XA, "xa_tan_duong", 311)
    W_11578 = Ward("Xã Dương Quan", 11578, VietNamDivisionType.XA, "xa_duong_quan", 311)
    W_11581 = Ward("Thị trấn An Dương", 11581, VietNamDivisionType.THI_TRAN, "thi_tran_an_duong", 312)
    W_11584 = Ward("Xã Lê Thiện", 11584, VietNamDivisionType.XA, "xa_le_thien", 312)
    W_11587 = Ward("Xã Đại Bản", 11587, VietNamDivisionType.XA, "xa_dai_ban", 312)
    W_11590 = Ward("Xã An Hoà", 11590, VietNamDivisionType.XA, "xa_an_hoa", 312)
    W_11593 = Ward("Xã Hồng Phong", 11593, VietNamDivisionType.XA, "xa_hong_phong", 312)
    W_11596 = Ward("Xã Tân Tiến", 11596, VietNamDivisionType.XA, "xa_tan_tien", 312)
    W_11599 = Ward("Xã An Hưng", 11599, VietNamDivisionType.XA, "xa_an_hung", 312)
    W_11602 = Ward("Xã An Hồng", 11602, VietNamDivisionType.XA, "xa_an_hong", 312)
    W_11605 = Ward("Xã Bắc Sơn", 11605, VietNamDivisionType.XA, "xa_bac_son", 312)
    W_11608 = Ward("Xã Nam Sơn", 11608, VietNamDivisionType.XA, "xa_nam_son", 312)
    W_11611 = Ward("Xã Lê Lợi", 11611, VietNamDivisionType.XA, "xa_le_loi", 312)
    W_11614 = Ward("Xã Đặng Cương", 11614, VietNamDivisionType.XA, "xa_dang_cuong", 312)
    W_11617 = Ward("Xã Đồng Thái", 11617, VietNamDivisionType.XA, "xa_dong_thai", 312)
    W_11620 = Ward("Xã Quốc Tuấn", 11620, VietNamDivisionType.XA, "xa_quoc_tuan", 312)
    W_11623 = Ward("Xã An Đồng", 11623, VietNamDivisionType.XA, "xa_an_dong", 312)
    W_11626 = Ward("Xã Hồng Thái", 11626, VietNamDivisionType.XA, "xa_hong_thai", 312)
    W_11629 = Ward("Thị trấn An Lão", 11629, VietNamDivisionType.THI_TRAN, "thi_tran_an_lao", 313)
    W_11632 = Ward("Xã Bát Trang", 11632, VietNamDivisionType.XA, "xa_bat_trang", 313)
    W_11635 = Ward("Xã Trường Thọ", 11635, VietNamDivisionType.XA, "xa_truong_tho", 313)
    W_11638 = Ward("Xã Trường Thành", 11638, VietNamDivisionType.XA, "xa_truong_thanh", 313)
    W_11641 = Ward("Xã An Tiến", 11641, VietNamDivisionType.XA, "xa_an_tien", 313)
    W_11644 = Ward("Xã Quang Hưng", 11644, VietNamDivisionType.XA, "xa_quang_hung", 313)
    W_11647 = Ward("Xã Quang Trung", 11647, VietNamDivisionType.XA, "xa_quang_trung", 313)
    W_11650 = Ward("Xã Quốc Tuấn", 11650, VietNamDivisionType.XA, "xa_quoc_tuan", 313)
    W_11653 = Ward("Xã An Thắng", 11653, VietNamDivisionType.XA, "xa_an_thang", 313)
    W_11656 = Ward("Thị trấn Trường Sơn", 11656, VietNamDivisionType.THI_TRAN, "thi_tran_truong_son", 313)
    W_11659 = Ward("Xã Tân Dân", 11659, VietNamDivisionType.XA, "xa_tan_dan", 313)
    W_11662 = Ward("Xã Thái Sơn", 11662, VietNamDivisionType.XA, "xa_thai_son", 313)
    W_11665 = Ward("Xã Tân Viên", 11665, VietNamDivisionType.XA, "xa_tan_vien", 313)
    W_11668 = Ward("Xã Mỹ Đức", 11668, VietNamDivisionType.XA, "xa_my_duc", 313)
    W_11671 = Ward("Xã Chiến Thắng", 11671, VietNamDivisionType.XA, "xa_chien_thang", 313)
    W_11674 = Ward("Xã An Thọ", 11674, VietNamDivisionType.XA, "xa_an_tho", 313)
    W_11677 = Ward("Xã An Thái", 11677, VietNamDivisionType.XA, "xa_an_thai", 313)
    W_11680 = Ward("Thị trấn Núi Đối", 11680, VietNamDivisionType.THI_TRAN, "thi_tran_nui_doi", 314)
    W_11695 = Ward("Xã Đông Phương", 11695, VietNamDivisionType.XA, "xa_dong_phuong", 314)
    W_11698 = Ward("Xã Thuận Thiên", 11698, VietNamDivisionType.XA, "xa_thuan_thien", 314)
    W_11701 = Ward("Xã Hữu Bằng", 11701, VietNamDivisionType.XA, "xa_huu_bang", 314)
    W_11704 = Ward("Xã Đại Đồng", 11704, VietNamDivisionType.XA, "xa_dai_dong", 314)
    W_11710 = Ward("Xã Ngũ Phúc", 11710, VietNamDivisionType.XA, "xa_ngu_phuc", 314)
    W_11713 = Ward("Xã Kiến Quốc", 11713, VietNamDivisionType.XA, "xa_kien_quoc", 314)
    W_11716 = Ward("Xã Du Lễ", 11716, VietNamDivisionType.XA, "xa_du_le", 314)
    W_11719 = Ward("Xã Thuỵ Hương", 11719, VietNamDivisionType.XA, "xa_thuy_huong", 314)
    W_11722 = Ward("Xã Thanh Sơn", 11722, VietNamDivisionType.XA, "xa_thanh_son", 314)
    W_11725 = Ward("Xã Minh Tân", 11725, VietNamDivisionType.XA, "xa_minh_tan", 314)
    W_11728 = Ward("Xã Đại Hà", 11728, VietNamDivisionType.XA, "xa_dai_ha", 314)
    W_11731 = Ward("Xã Ngũ Đoan", 11731, VietNamDivisionType.XA, "xa_ngu_doan", 314)
    W_11734 = Ward("Xã Tân Phong", 11734, VietNamDivisionType.XA, "xa_tan_phong", 314)
    W_11743 = Ward("Xã Tân Trào", 11743, VietNamDivisionType.XA, "xa_tan_trao", 314)
    W_11746 = Ward("Xã Đoàn Xá", 11746, VietNamDivisionType.XA, "xa_doan_xa", 314)
    W_11749 = Ward("Xã Tú Sơn", 11749, VietNamDivisionType.XA, "xa_tu_son", 314)
    W_11752 = Ward("Xã Đại Hợp", 11752, VietNamDivisionType.XA, "xa_dai_hop", 314)
    W_11755 = Ward("Thị trấn Tiên Lãng", 11755, VietNamDivisionType.THI_TRAN, "thi_tran_tien_lang", 315)
    W_11758 = Ward("Xã Đại Thắng", 11758, VietNamDivisionType.XA, "xa_dai_thang", 315)
    W_11761 = Ward("Xã Tiên Cường", 11761, VietNamDivisionType.XA, "xa_tien_cuong", 315)
    W_11764 = Ward("Xã Tự Cường", 11764, VietNamDivisionType.XA, "xa_tu_cuong", 315)
    W_11770 = Ward("Xã Quyết Tiến", 11770, VietNamDivisionType.XA, "xa_quyet_tien", 315)
    W_11773 = Ward("Xã Khởi Nghĩa", 11773, VietNamDivisionType.XA, "xa_khoi_nghia", 315)
    W_11776 = Ward("Xã Tiên Thanh", 11776, VietNamDivisionType.XA, "xa_tien_thanh", 315)
    W_11779 = Ward("Xã Cấp Tiến", 11779, VietNamDivisionType.XA, "xa_cap_tien", 315)
    W_11782 = Ward("Xã Kiến Thiết", 11782, VietNamDivisionType.XA, "xa_kien_thiet", 315)
    W_11785 = Ward("Xã Đoàn Lập", 11785, VietNamDivisionType.XA, "xa_doan_lap", 315)
    W_11788 = Ward("Xã Bạch Đằng", 11788, VietNamDivisionType.XA, "xa_bach_dang", 315)
    W_11791 = Ward("Xã Quang Phục", 11791, VietNamDivisionType.XA, "xa_quang_phuc", 315)
    W_11794 = Ward("Xã Toàn Thắng", 11794, VietNamDivisionType.XA, "xa_toan_thang", 315)
    W_11797 = Ward("Xã Tiên Thắng", 11797, VietNamDivisionType.XA, "xa_tien_thang", 315)
    W_11800 = Ward("Xã Tiên Minh", 11800, VietNamDivisionType.XA, "xa_tien_minh", 315)
    W_11803 = Ward("Xã Bắc Hưng", 11803, VietNamDivisionType.XA, "xa_bac_hung", 315)
    W_11806 = Ward("Xã Nam Hưng", 11806, VietNamDivisionType.XA, "xa_nam_hung", 315)
    W_11809 = Ward("Xã Hùng Thắng", 11809, VietNamDivisionType.XA, "xa_hung_thang", 315)
    W_11812 = Ward("Xã Tây Hưng", 11812, VietNamDivisionType.XA, "xa_tay_hung", 315)
    W_11815 = Ward("Xã Đông Hưng", 11815, VietNamDivisionType.XA, "xa_dong_hung", 315)
    W_11821 = Ward("Xã Vinh Quang", 11821, VietNamDivisionType.XA, "xa_vinh_quang", 315)
    W_11824 = Ward("Thị trấn Vĩnh Bảo", 11824, VietNamDivisionType.THI_TRAN, "thi_tran_vinh_bao", 316)
    W_11827 = Ward("Xã Dũng Tiến", 11827, VietNamDivisionType.XA, "xa_dung_tien", 316)
    W_11830 = Ward("Xã Giang Biên", 11830, VietNamDivisionType.XA, "xa_giang_bien", 316)
    W_11833 = Ward("Xã Thắng Thuỷ", 11833, VietNamDivisionType.XA, "xa_thang_thuy", 316)
    W_11836 = Ward("Xã Trung Lập", 11836, VietNamDivisionType.XA, "xa_trung_lap", 316)
    W_11839 = Ward("Xã Việt Tiến", 11839, VietNamDivisionType.XA, "xa_viet_tien", 316)
    W_11842 = Ward("Xã Vĩnh An", 11842, VietNamDivisionType.XA, "xa_vinh_an", 316)
    W_11845 = Ward("Xã Vĩnh Long", 11845, VietNamDivisionType.XA, "xa_vinh_long", 316)
    W_11848 = Ward("Xã Hiệp Hoà", 11848, VietNamDivisionType.XA, "xa_hiep_hoa", 316)
    W_11851 = Ward("Xã Hùng Tiến", 11851, VietNamDivisionType.XA, "xa_hung_tien", 316)
    W_11854 = Ward("Xã An Hoà", 11854, VietNamDivisionType.XA, "xa_an_hoa", 316)
    W_11857 = Ward("Xã Tân Hưng", 11857, VietNamDivisionType.XA, "xa_tan_hung", 316)
    W_11860 = Ward("Xã Tân Liên", 11860, VietNamDivisionType.XA, "xa_tan_lien", 316)
    W_11863 = Ward("Xã Nhân Hoà", 11863, VietNamDivisionType.XA, "xa_nhan_hoa", 316)
    W_11866 = Ward("Xã Tam Đa", 11866, VietNamDivisionType.XA, "xa_tam_da", 316)
    W_11869 = Ward("Xã Hưng Nhân", 11869, VietNamDivisionType.XA, "xa_hung_nhan", 316)
    W_11872 = Ward("Xã Vinh Quang", 11872, VietNamDivisionType.XA, "xa_vinh_quang", 316)
    W_11875 = Ward("Xã Đồng Minh", 11875, VietNamDivisionType.XA, "xa_dong_minh", 316)
    W_11878 = Ward("Xã Thanh Lương", 11878, VietNamDivisionType.XA, "xa_thanh_luong", 316)
    W_11881 = Ward("Xã Liên Am", 11881, VietNamDivisionType.XA, "xa_lien_am", 316)
    W_11884 = Ward("Xã Lý Học", 11884, VietNamDivisionType.XA, "xa_ly_hoc", 316)
    W_11887 = Ward("Xã Tam Cường", 11887, VietNamDivisionType.XA, "xa_tam_cuong", 316)
    W_11890 = Ward("Xã Hoà Bình", 11890, VietNamDivisionType.XA, "xa_hoa_binh", 316)
    W_11893 = Ward("Xã Tiền Phong", 11893, VietNamDivisionType.XA, "xa_tien_phong", 316)
    W_11896 = Ward("Xã Vĩnh Phong", 11896, VietNamDivisionType.XA, "xa_vinh_phong", 316)
    W_11899 = Ward("Xã Cộng Hiền", 11899, VietNamDivisionType.XA, "xa_cong_hien", 316)
    W_11902 = Ward("Xã Cao Minh", 11902, VietNamDivisionType.XA, "xa_cao_minh", 316)
    W_11905 = Ward("Xã Cổ Am", 11905, VietNamDivisionType.XA, "xa_co_am", 316)
    W_11908 = Ward("Xã Vĩnh Tiến", 11908, VietNamDivisionType.XA, "xa_vinh_tien", 316)
    W_11911 = Ward("Xã Trấn Dương", 11911, VietNamDivisionType.XA, "xa_tran_duong", 316)
    W_11914 = Ward("Thị trấn Cát Bà", 11914, VietNamDivisionType.THI_TRAN, "thi_tran_cat_ba", 317)
    W_11917 = Ward("Thị trấn Cát Hải", 11917, VietNamDivisionType.THI_TRAN, "thi_tran_cat_hai", 317)
    W_11920 = Ward("Xã Nghĩa Lộ", 11920, VietNamDivisionType.XA, "xa_nghia_lo", 317)
    W_11923 = Ward("Xã Đồng Bài", 11923, VietNamDivisionType.XA, "xa_dong_bai", 317)
    W_11926 = Ward("Xã Hoàng Châu", 11926, VietNamDivisionType.XA, "xa_hoang_chau", 317)
    W_11929 = Ward("Xã Văn Phong", 11929, VietNamDivisionType.XA, "xa_van_phong", 317)
    W_11932 = Ward("Xã Phù Long", 11932, VietNamDivisionType.XA, "xa_phu_long", 317)
    W_11935 = Ward("Xã Gia Luận", 11935, VietNamDivisionType.XA, "xa_gia_luan", 317)
    W_11938 = Ward("Xã Hiền Hào", 11938, VietNamDivisionType.XA, "xa_hien_hao", 317)
    W_11941 = Ward("Xã Trân Châu", 11941, VietNamDivisionType.XA, "xa_tran_chau", 317)
    W_11944 = Ward("Xã Việt Hải", 11944, VietNamDivisionType.XA, "xa_viet_hai", 317)
    W_11947 = Ward("Xã Xuân Đám", 11947, VietNamDivisionType.XA, "xa_xuan_dam", 317)
    W_11950 = Ward("Phường Lam Sơn", 11950, VietNamDivisionType.PHUONG, "phuong_lam_son", 323)
    W_11953 = Ward("Phường Hiến Nam", 11953, VietNamDivisionType.PHUONG, "phuong_hien_nam", 323)
    W_11956 = Ward("Phường An Tảo", 11956, VietNamDivisionType.PHUONG, "phuong_an_tao", 323)
    W_11959 = Ward("Phường Lê Lợi", 11959, VietNamDivisionType.PHUONG, "phuong_le_loi", 323)
    W_11962 = Ward("Phường Minh Khai", 11962, VietNamDivisionType.PHUONG, "phuong_minh_khai", 323)
    W_11965 = Ward("Phường Quang Trung", 11965, VietNamDivisionType.PHUONG, "phuong_quang_trung", 323)
    W_11968 = Ward("Phường Hồng Châu", 11968, VietNamDivisionType.PHUONG, "phuong_hong_chau", 323)
    W_11971 = Ward("Xã Trung Nghĩa", 11971, VietNamDivisionType.XA, "xa_trung_nghia", 323)
    W_11974 = Ward("Xã Liên Phương", 11974, VietNamDivisionType.XA, "xa_lien_phuong", 323)
    W_11977 = Ward("Xã Hồng Nam", 11977, VietNamDivisionType.XA, "xa_hong_nam", 323)
    W_11980 = Ward("Xã Quảng Châu", 11980, VietNamDivisionType.XA, "xa_quang_chau", 323)
    W_11983 = Ward("Xã Bảo Khê", 11983, VietNamDivisionType.XA, "xa_bao_khe", 323)
    W_12331 = Ward("Xã Phú Cường", 12331, VietNamDivisionType.XA, "xa_phu_cuong", 323)
    W_12334 = Ward("Xã Hùng Cường", 12334, VietNamDivisionType.XA, "xa_hung_cuong", 323)
    W_12382 = Ward("Xã Phương Chiểu", 12382, VietNamDivisionType.XA, "xa_phuong_chieu", 323)
    W_12385 = Ward("Xã Tân Hưng", 12385, VietNamDivisionType.XA, "xa_tan_hung", 323)
    W_12388 = Ward("Xã Hoàng Hanh", 12388, VietNamDivisionType.XA, "xa_hoang_hanh", 323)
    W_11986 = Ward("Thị trấn Như Quỳnh", 11986, VietNamDivisionType.THI_TRAN, "thi_tran_nhu_quynh", 325)
    W_11989 = Ward("Xã Lạc Đạo", 11989, VietNamDivisionType.XA, "xa_lac_dao", 325)
    W_11992 = Ward("Xã Chỉ Đạo", 11992, VietNamDivisionType.XA, "xa_chi_dao", 325)
    W_11995 = Ward("Xã Đại Đồng", 11995, VietNamDivisionType.XA, "xa_dai_dong", 325)
    W_11998 = Ward("Xã Việt Hưng", 11998, VietNamDivisionType.XA, "xa_viet_hung", 325)
    W_12001 = Ward("Xã Tân Quang", 12001, VietNamDivisionType.XA, "xa_tan_quang", 325)
    W_12004 = Ward("Xã Đình Dù", 12004, VietNamDivisionType.XA, "xa_dinh_du", 325)
    W_12007 = Ward("Xã Minh Hải", 12007, VietNamDivisionType.XA, "xa_minh_hai", 325)
    W_12010 = Ward("Xã Lương Tài", 12010, VietNamDivisionType.XA, "xa_luong_tai", 325)
    W_12013 = Ward("Xã Trưng Trắc", 12013, VietNamDivisionType.XA, "xa_trung_trac", 325)
    W_12016 = Ward("Xã Lạc Hồng", 12016, VietNamDivisionType.XA, "xa_lac_hong", 325)
    W_12019 = Ward("Thị trấn Văn Giang", 12019, VietNamDivisionType.THI_TRAN, "thi_tran_van_giang", 326)
    W_12022 = Ward("Xã Xuân Quan", 12022, VietNamDivisionType.XA, "xa_xuan_quan", 326)
    W_12025 = Ward("Xã Cửu Cao", 12025, VietNamDivisionType.XA, "xa_cuu_cao", 326)
    W_12028 = Ward("Xã Phụng Công", 12028, VietNamDivisionType.XA, "xa_phung_cong", 326)
    W_12031 = Ward("Xã Nghĩa Trụ", 12031, VietNamDivisionType.XA, "xa_nghia_tru", 326)
    W_12034 = Ward("Xã Long Hưng", 12034, VietNamDivisionType.XA, "xa_long_hung", 326)
    W_12037 = Ward("Xã Vĩnh Khúc", 12037, VietNamDivisionType.XA, "xa_vinh_khuc", 326)
    W_12040 = Ward("Xã Liên Nghĩa", 12040, VietNamDivisionType.XA, "xa_lien_nghia", 326)
    W_12043 = Ward("Xã Tân Tiến", 12043, VietNamDivisionType.XA, "xa_tan_tien", 326)
    W_12046 = Ward("Xã Thắng Lợi", 12046, VietNamDivisionType.XA, "xa_thang_loi", 326)
    W_12049 = Ward("Xã Mễ Sở", 12049, VietNamDivisionType.XA, "xa_me_so", 326)
    W_12052 = Ward("Thị trấn Yên Mỹ", 12052, VietNamDivisionType.THI_TRAN, "thi_tran_yen_my", 327)
    W_12055 = Ward("Xã Giai Phạm", 12055, VietNamDivisionType.XA, "xa_giai_pham", 327)
    W_12058 = Ward("Xã Nghĩa Hiệp", 12058, VietNamDivisionType.XA, "xa_nghia_hiep", 327)
    W_12061 = Ward("Xã Đồng Than", 12061, VietNamDivisionType.XA, "xa_dong_than", 327)
    W_12064 = Ward("Xã Ngọc Long", 12064, VietNamDivisionType.XA, "xa_ngoc_long", 327)
    W_12067 = Ward("Xã Liêu Xá", 12067, VietNamDivisionType.XA, "xa_lieu_xa", 327)
    W_12070 = Ward("Xã Hoàn Long", 12070, VietNamDivisionType.XA, "xa_hoan_long", 327)
    W_12073 = Ward("Xã Tân Lập", 12073, VietNamDivisionType.XA, "xa_tan_lap", 327)
    W_12076 = Ward("Xã Thanh Long", 12076, VietNamDivisionType.XA, "xa_thanh_long", 327)
    W_12079 = Ward("Xã Yên Phú", 12079, VietNamDivisionType.XA, "xa_yen_phu", 327)
    W_12082 = Ward("Xã Việt Cường", 12082, VietNamDivisionType.XA, "xa_viet_cuong", 327)
    W_12085 = Ward("Xã Trung Hòa", 12085, VietNamDivisionType.XA, "xa_trung_hoa", 327)
    W_12088 = Ward("Xã Yên Hòa", 12088, VietNamDivisionType.XA, "xa_yen_hoa", 327)
    W_12091 = Ward("Xã Minh Châu", 12091, VietNamDivisionType.XA, "xa_minh_chau", 327)
    W_12094 = Ward("Xã Trung Hưng", 12094, VietNamDivisionType.XA, "xa_trung_hung", 327)
    W_12097 = Ward("Xã Lý Thường Kiệt", 12097, VietNamDivisionType.XA, "xa_ly_thuong_kiet", 327)
    W_12100 = Ward("Xã Tân Việt", 12100, VietNamDivisionType.XA, "xa_tan_viet", 327)
    W_12103 = Ward("Phường Bần Yên Nhân", 12103, VietNamDivisionType.PHUONG, "phuong_ban_yen_nhan", 328)
    W_12106 = Ward("Phường Phan Đình Phùng", 12106, VietNamDivisionType.PHUONG, "phuong_phan_dinh_phung", 328)
    W_12109 = Ward("Xã Cẩm Xá", 12109, VietNamDivisionType.XA, "xa_cam_xa", 328)
    W_12112 = Ward("Xã Dương Quang", 12112, VietNamDivisionType.XA, "xa_duong_quang", 328)
    W_12115 = Ward("Xã Hòa Phong", 12115, VietNamDivisionType.XA, "xa_hoa_phong", 328)
    W_12118 = Ward("Phường Nhân Hòa", 12118, VietNamDivisionType.PHUONG, "phuong_nhan_hoa", 328)
    W_12121 = Ward("Phường Dị Sử", 12121, VietNamDivisionType.PHUONG, "phuong_di_su", 328)
    W_12124 = Ward("Phường Bạch Sam", 12124, VietNamDivisionType.PHUONG, "phuong_bach_sam", 328)
    W_12127 = Ward("Phường Minh Đức", 12127, VietNamDivisionType.PHUONG, "phuong_minh_duc", 328)
    W_12130 = Ward("Phường Phùng Chí Kiên", 12130, VietNamDivisionType.PHUONG, "phuong_phung_chi_kien", 328)
    W_12133 = Ward("Xã Xuân Dục", 12133, VietNamDivisionType.XA, "xa_xuan_duc", 328)
    W_12136 = Ward("Xã Ngọc Lâm", 12136, VietNamDivisionType.XA, "xa_ngoc_lam", 328)
    W_12139 = Ward("Xã Hưng Long", 12139, VietNamDivisionType.XA, "xa_hung_long", 328)
    W_12142 = Ward("Thị trấn Ân Thi", 12142, VietNamDivisionType.THI_TRAN, "thi_tran_an_thi", 329)
    W_12145 = Ward("Xã Phù Ủng", 12145, VietNamDivisionType.XA, "xa_phu_ung", 329)
    W_12148 = Ward("Xã Bắc Sơn", 12148, VietNamDivisionType.XA, "xa_bac_son", 329)
    W_12151 = Ward("Xã Bãi Sậy", 12151, VietNamDivisionType.XA, "xa_bai_say", 329)
    W_12154 = Ward("Xã Đào Dương", 12154, VietNamDivisionType.XA, "xa_dao_duong", 329)
    W_12157 = Ward("Xã Tân Phúc", 12157, VietNamDivisionType.XA, "xa_tan_phuc", 329)
    W_12160 = Ward("Xã Vân Du", 12160, VietNamDivisionType.XA, "xa_van_du", 329)
    W_12163 = Ward("Xã Quang Vinh", 12163, VietNamDivisionType.XA, "xa_quang_vinh", 329)
    W_12166 = Ward("Xã Xuân Trúc", 12166, VietNamDivisionType.XA, "xa_xuan_truc", 329)
    W_12169 = Ward("Xã Hoàng Hoa Thám", 12169, VietNamDivisionType.XA, "xa_hoang_hoa_tham", 329)
    W_12172 = Ward("Xã Quảng Lãng", 12172, VietNamDivisionType.XA, "xa_quang_lang", 329)
    W_12175 = Ward("Xã Văn Nhuệ", 12175, VietNamDivisionType.XA, "xa_van_nhue", 329)
    W_12178 = Ward("Xã Đặng Lễ", 12178, VietNamDivisionType.XA, "xa_dang_le", 329)
    W_12181 = Ward("Xã Cẩm Ninh", 12181, VietNamDivisionType.XA, "xa_cam_ninh", 329)
    W_12184 = Ward("Xã Nguyễn Trãi", 12184, VietNamDivisionType.XA, "xa_nguyen_trai", 329)
    W_12187 = Ward("Xã Đa Lộc", 12187, VietNamDivisionType.XA, "xa_da_loc", 329)
    W_12190 = Ward("Xã Hồ Tùng Mậu", 12190, VietNamDivisionType.XA, "xa_ho_tung_mau", 329)
    W_12193 = Ward("Xã Tiền Phong", 12193, VietNamDivisionType.XA, "xa_tien_phong", 329)
    W_12196 = Ward("Xã Hồng Vân", 12196, VietNamDivisionType.XA, "xa_hong_van", 329)
    W_12199 = Ward("Xã Hồng Quang", 12199, VietNamDivisionType.XA, "xa_hong_quang", 329)
    W_12202 = Ward("Xã Hạ Lễ", 12202, VietNamDivisionType.XA, "xa_ha_le", 329)
    W_12205 = Ward("Thị trấn Khoái Châu", 12205, VietNamDivisionType.THI_TRAN, "thi_tran_khoai_chau", 330)
    W_12208 = Ward("Xã Đông Tảo", 12208, VietNamDivisionType.XA, "xa_dong_tao", 330)
    W_12211 = Ward("Xã Bình Minh", 12211, VietNamDivisionType.XA, "xa_binh_minh", 330)
    W_12214 = Ward("Xã Dạ Trạch", 12214, VietNamDivisionType.XA, "xa_da_trach", 330)
    W_12217 = Ward("Xã Hàm Tử", 12217, VietNamDivisionType.XA, "xa_ham_tu", 330)
    W_12220 = Ward("Xã Ông Đình", 12220, VietNamDivisionType.XA, "xa_ong_dinh", 330)
    W_12223 = Ward("Xã Tân Dân", 12223, VietNamDivisionType.XA, "xa_tan_dan", 330)
    W_12226 = Ward("Xã Tứ Dân", 12226, VietNamDivisionType.XA, "xa_tu_dan", 330)
    W_12229 = Ward("Xã An Vĩ", 12229, VietNamDivisionType.XA, "xa_an_vi", 330)
    W_12232 = Ward("Xã Đông Kết", 12232, VietNamDivisionType.XA, "xa_dong_ket", 330)
    W_12235 = Ward("Xã Bình Kiều", 12235, VietNamDivisionType.XA, "xa_binh_kieu", 330)
    W_12238 = Ward("Xã Dân Tiến", 12238, VietNamDivisionType.XA, "xa_dan_tien", 330)
    W_12241 = Ward("Xã Đồng Tiến", 12241, VietNamDivisionType.XA, "xa_dong_tien", 330)
    W_12244 = Ward("Xã Hồng Tiến", 12244, VietNamDivisionType.XA, "xa_hong_tien", 330)
    W_12247 = Ward("Xã Tân Châu", 12247, VietNamDivisionType.XA, "xa_tan_chau", 330)
    W_12250 = Ward("Xã Liên Khê", 12250, VietNamDivisionType.XA, "xa_lien_khe", 330)
    W_12253 = Ward("Xã Phùng Hưng", 12253, VietNamDivisionType.XA, "xa_phung_hung", 330)
    W_12256 = Ward("Xã Việt Hòa", 12256, VietNamDivisionType.XA, "xa_viet_hoa", 330)
    W_12259 = Ward("Xã Đông Ninh", 12259, VietNamDivisionType.XA, "xa_dong_ninh", 330)
    W_12262 = Ward("Xã Đại Tập", 12262, VietNamDivisionType.XA, "xa_dai_tap", 330)
    W_12265 = Ward("Xã Chí Tân", 12265, VietNamDivisionType.XA, "xa_chi_tan", 330)
    W_12268 = Ward("Xã Đại Hưng", 12268, VietNamDivisionType.XA, "xa_dai_hung", 330)
    W_12271 = Ward("Xã Thuần Hưng", 12271, VietNamDivisionType.XA, "xa_thuan_hung", 330)
    W_12274 = Ward("Xã Thành Công", 12274, VietNamDivisionType.XA, "xa_thanh_cong", 330)
    W_12277 = Ward("Xã Nhuế Dương", 12277, VietNamDivisionType.XA, "xa_nhue_duong", 330)
    W_12280 = Ward("Thị trấn Lương Bằng", 12280, VietNamDivisionType.THI_TRAN, "thi_tran_luong_bang", 331)
    W_12283 = Ward("Xã Nghĩa Dân", 12283, VietNamDivisionType.XA, "xa_nghia_dan", 331)
    W_12286 = Ward("Xã Toàn Thắng", 12286, VietNamDivisionType.XA, "xa_toan_thang", 331)
    W_12289 = Ward("Xã Vĩnh Xá", 12289, VietNamDivisionType.XA, "xa_vinh_xa", 331)
    W_12292 = Ward("Xã Phạm Ngũ Lão", 12292, VietNamDivisionType.XA, "xa_pham_ngu_lao", 331)
    W_12295 = Ward("Xã Thọ Vinh", 12295, VietNamDivisionType.XA, "xa_tho_vinh", 331)
    W_12298 = Ward("Xã Đồng Thanh", 12298, VietNamDivisionType.XA, "xa_dong_thanh", 331)
    W_12301 = Ward("Xã Song Mai", 12301, VietNamDivisionType.XA, "xa_song_mai", 331)
    W_12304 = Ward("Xã Chính Nghĩa", 12304, VietNamDivisionType.XA, "xa_chinh_nghia", 331)
    W_12307 = Ward("Xã Nhân La", 12307, VietNamDivisionType.XA, "xa_nhan_la", 331)
    W_12310 = Ward("Xã Phú Thịnh", 12310, VietNamDivisionType.XA, "xa_phu_thinh", 331)
    W_12313 = Ward("Xã Mai Động", 12313, VietNamDivisionType.XA, "xa_mai_dong", 331)
    W_12316 = Ward("Xã Đức Hợp", 12316, VietNamDivisionType.XA, "xa_duc_hop", 331)
    W_12319 = Ward("Xã Hùng An", 12319, VietNamDivisionType.XA, "xa_hung_an", 331)
    W_12322 = Ward("Xã Ngọc Thanh", 12322, VietNamDivisionType.XA, "xa_ngoc_thanh", 331)
    W_12325 = Ward("Xã Vũ Xá", 12325, VietNamDivisionType.XA, "xa_vu_xa", 331)
    W_12328 = Ward("Xã Hiệp Cường", 12328, VietNamDivisionType.XA, "xa_hiep_cuong", 331)
    W_12337 = Ward("Thị trấn Vương", 12337, VietNamDivisionType.THI_TRAN, "thi_tran_vuong", 332)
    W_12340 = Ward("Xã Hưng Đạo", 12340, VietNamDivisionType.XA, "xa_hung_dao", 332)
    W_12343 = Ward("Xã Ngô Quyền", 12343, VietNamDivisionType.XA, "xa_ngo_quyen", 332)
    W_12346 = Ward("Xã Nhật Tân", 12346, VietNamDivisionType.XA, "xa_nhat_tan", 332)
    W_12349 = Ward("Xã Dị Chế", 12349, VietNamDivisionType.XA, "xa_di_che", 332)
    W_12352 = Ward("Xã Lệ Xá", 12352, VietNamDivisionType.XA, "xa_le_xa", 332)
    W_12355 = Ward("Xã An Viên", 12355, VietNamDivisionType.XA, "xa_an_vien", 332)
    W_12358 = Ward("Xã Đức Thắng", 12358, VietNamDivisionType.XA, "xa_duc_thang", 332)
    W_12361 = Ward("Xã Trung Dũng", 12361, VietNamDivisionType.XA, "xa_trung_dung", 332)
    W_12364 = Ward("Xã Hải Triều", 12364, VietNamDivisionType.XA, "xa_hai_trieu", 332)
    W_12367 = Ward("Xã Thủ Sỹ", 12367, VietNamDivisionType.XA, "xa_thu_sy", 332)
    W_12370 = Ward("Xã Thiện Phiến", 12370, VietNamDivisionType.XA, "xa_thien_phien", 332)
    W_12373 = Ward("Xã Thụy Lôi", 12373, VietNamDivisionType.XA, "xa_thuy_loi", 332)
    W_12376 = Ward("Xã Cương Chính", 12376, VietNamDivisionType.XA, "xa_cuong_chinh", 332)
    W_12379 = Ward("Xã Minh Phượng", 12379, VietNamDivisionType.XA, "xa_minh_phuong", 332)
    W_12391 = Ward("Thị trấn Trần Cao", 12391, VietNamDivisionType.THI_TRAN, "thi_tran_tran_cao", 333)
    W_12394 = Ward("Xã Minh Tân", 12394, VietNamDivisionType.XA, "xa_minh_tan", 333)
    W_12397 = Ward("Xã Phan Sào Nam", 12397, VietNamDivisionType.XA, "xa_phan_sao_nam", 333)
    W_12400 = Ward("Xã Quang Hưng", 12400, VietNamDivisionType.XA, "xa_quang_hung", 333)
    W_12403 = Ward("Xã Minh Hoàng", 12403, VietNamDivisionType.XA, "xa_minh_hoang", 333)
    W_12406 = Ward("Xã Đoàn Đào", 12406, VietNamDivisionType.XA, "xa_doan_dao", 333)
    W_12409 = Ward("Xã Tống Phan", 12409, VietNamDivisionType.XA, "xa_tong_phan", 333)
    W_12412 = Ward("Xã Đình Cao", 12412, VietNamDivisionType.XA, "xa_dinh_cao", 333)
    W_12415 = Ward("Xã Nhật Quang", 12415, VietNamDivisionType.XA, "xa_nhat_quang", 333)
    W_12418 = Ward("Xã Tiền Tiến", 12418, VietNamDivisionType.XA, "xa_tien_tien", 333)
    W_12421 = Ward("Xã Tam Đa", 12421, VietNamDivisionType.XA, "xa_tam_da", 333)
    W_12424 = Ward("Xã Minh Tiến", 12424, VietNamDivisionType.XA, "xa_minh_tien", 333)
    W_12427 = Ward("Xã Nguyên Hòa", 12427, VietNamDivisionType.XA, "xa_nguyen_hoa", 333)
    W_12430 = Ward("Xã Tống Trân", 12430, VietNamDivisionType.XA, "xa_tong_tran", 333)
    W_12433 = Ward("Phường Lê Hồng Phong", 12433, VietNamDivisionType.PHUONG, "phuong_le_hong_phong", 336)
    W_12436 = Ward("Phường Bồ Xuyên", 12436, VietNamDivisionType.PHUONG, "phuong_bo_xuyen", 336)
    W_12439 = Ward("Phường Đề Thám", 12439, VietNamDivisionType.PHUONG, "phuong_de_tham", 336)
    W_12442 = Ward("Phường Kỳ Bá", 12442, VietNamDivisionType.PHUONG, "phuong_ky_ba", 336)
    W_12445 = Ward("Phường Quang Trung", 12445, VietNamDivisionType.PHUONG, "phuong_quang_trung", 336)
    W_12448 = Ward("Phường Phú Khánh", 12448, VietNamDivisionType.PHUONG, "phuong_phu_khanh", 336)
    W_12451 = Ward("Phường Tiền Phong", 12451, VietNamDivisionType.PHUONG, "phuong_tien_phong", 336)
    W_12452 = Ward("Phường Trần Hưng Đạo", 12452, VietNamDivisionType.PHUONG, "phuong_tran_hung_dao", 336)
    W_12454 = Ward("Phường Trần Lãm", 12454, VietNamDivisionType.PHUONG, "phuong_tran_lam", 336)
    W_12457 = Ward("Xã Đông Hòa", 12457, VietNamDivisionType.XA, "xa_dong_hoa", 336)
    W_12460 = Ward("Phường Hoàng Diệu", 12460, VietNamDivisionType.PHUONG, "phuong_hoang_dieu", 336)
    W_12463 = Ward("Xã Phú Xuân", 12463, VietNamDivisionType.XA, "xa_phu_xuan", 336)
    W_12466 = Ward("Xã Vũ Phúc", 12466, VietNamDivisionType.XA, "xa_vu_phuc", 336)
    W_12469 = Ward("Xã Vũ Chính", 12469, VietNamDivisionType.XA, "xa_vu_chinh", 336)
    W_12817 = Ward("Xã Đông Mỹ", 12817, VietNamDivisionType.XA, "xa_dong_my", 336)
    W_12820 = Ward("Xã Đông Thọ", 12820, VietNamDivisionType.XA, "xa_dong_tho", 336)
    W_13084 = Ward("Xã Vũ Đông", 13084, VietNamDivisionType.XA, "xa_vu_dong", 336)
    W_13108 = Ward("Xã Vũ Lạc", 13108, VietNamDivisionType.XA, "xa_vu_lac", 336)
    W_13225 = Ward("Xã Tân Bình", 13225, VietNamDivisionType.XA, "xa_tan_binh", 336)
    W_12472 = Ward("Thị trấn Quỳnh Côi", 12472, VietNamDivisionType.THI_TRAN, "thi_tran_quynh_coi", 338)
    W_12475 = Ward("Xã An Khê", 12475, VietNamDivisionType.XA, "xa_an_khe", 338)
    W_12478 = Ward("Xã An Đồng", 12478, VietNamDivisionType.XA, "xa_an_dong", 338)
    W_12481 = Ward("Xã Quỳnh Hoa", 12481, VietNamDivisionType.XA, "xa_quynh_hoa", 338)
    W_12484 = Ward("Xã Quỳnh Lâm", 12484, VietNamDivisionType.XA, "xa_quynh_lam", 338)
    W_12487 = Ward("Xã Quỳnh Thọ", 12487, VietNamDivisionType.XA, "xa_quynh_tho", 338)
    W_12490 = Ward("Xã An Hiệp", 12490, VietNamDivisionType.XA, "xa_an_hiep", 338)
    W_12493 = Ward("Xã Quỳnh Hoàng", 12493, VietNamDivisionType.XA, "xa_quynh_hoang", 338)
    W_12496 = Ward("Xã Quỳnh Giao", 12496, VietNamDivisionType.XA, "xa_quynh_giao", 338)
    W_12499 = Ward("Xã An Thái", 12499, VietNamDivisionType.XA, "xa_an_thai", 338)
    W_12502 = Ward("Xã An Cầu", 12502, VietNamDivisionType.XA, "xa_an_cau", 338)
    W_12505 = Ward("Xã Quỳnh Hồng", 12505, VietNamDivisionType.XA, "xa_quynh_hong", 338)
    W_12508 = Ward("Xã Quỳnh Khê", 12508, VietNamDivisionType.XA, "xa_quynh_khe", 338)
    W_12511 = Ward("Xã Quỳnh Minh", 12511, VietNamDivisionType.XA, "xa_quynh_minh", 338)
    W_12514 = Ward("Xã An Ninh", 12514, VietNamDivisionType.XA, "xa_an_ninh", 338)
    W_12517 = Ward("Xã Quỳnh Ngọc", 12517, VietNamDivisionType.XA, "xa_quynh_ngoc", 338)
    W_12520 = Ward("Xã Quỳnh Hải", 12520, VietNamDivisionType.XA, "xa_quynh_hai", 338)
    W_12523 = Ward("Thị trấn An Bài", 12523, VietNamDivisionType.THI_TRAN, "thi_tran_an_bai", 338)
    W_12526 = Ward("Xã An Ấp", 12526, VietNamDivisionType.XA, "xa_an_ap", 338)
    W_12529 = Ward("Xã Quỳnh Hội", 12529, VietNamDivisionType.XA, "xa_quynh_hoi", 338)
    W_12532 = Ward("Xã Châu Sơn", 12532, VietNamDivisionType.XA, "xa_chau_son", 338)
    W_12535 = Ward("Xã Quỳnh Mỹ", 12535, VietNamDivisionType.XA, "xa_quynh_my", 338)
    W_12538 = Ward("Xã An Quí", 12538, VietNamDivisionType.XA, "xa_an_qui", 338)
    W_12541 = Ward("Xã An Thanh", 12541, VietNamDivisionType.XA, "xa_an_thanh", 338)
    W_12547 = Ward("Xã An Vũ", 12547, VietNamDivisionType.XA, "xa_an_vu", 338)
    W_12550 = Ward("Xã An Lễ", 12550, VietNamDivisionType.XA, "xa_an_le", 338)
    W_12553 = Ward("Xã Quỳnh Hưng", 12553, VietNamDivisionType.XA, "xa_quynh_hung", 338)
    W_12556 = Ward("Xã Quỳnh Bảo", 12556, VietNamDivisionType.XA, "xa_quynh_bao", 338)
    W_12559 = Ward("Xã An Mỹ", 12559, VietNamDivisionType.XA, "xa_an_my", 338)
    W_12562 = Ward("Xã Quỳnh Nguyên", 12562, VietNamDivisionType.XA, "xa_quynh_nguyen", 338)
    W_12565 = Ward("Xã An Vinh", 12565, VietNamDivisionType.XA, "xa_an_vinh", 338)
    W_12568 = Ward("Xã Quỳnh Xá", 12568, VietNamDivisionType.XA, "xa_quynh_xa", 338)
    W_12571 = Ward("Xã An Dục", 12571, VietNamDivisionType.XA, "xa_an_duc", 338)
    W_12574 = Ward("Xã Đông Hải", 12574, VietNamDivisionType.XA, "xa_dong_hai", 338)
    W_12577 = Ward("Xã Quỳnh Trang", 12577, VietNamDivisionType.XA, "xa_quynh_trang", 338)
    W_12580 = Ward("Xã An Tràng", 12580, VietNamDivisionType.XA, "xa_an_trang", 338)
    W_12583 = Ward("Xã Đồng Tiến", 12583, VietNamDivisionType.XA, "xa_dong_tien", 338)
    W_12586 = Ward("Thị trấn Hưng Hà", 12586, VietNamDivisionType.THI_TRAN, "thi_tran_hung_ha", 339)
    W_12589 = Ward("Xã Điệp Nông", 12589, VietNamDivisionType.XA, "xa_diep_nong", 339)
    W_12592 = Ward("Xã Tân Lễ", 12592, VietNamDivisionType.XA, "xa_tan_le", 339)
    W_12595 = Ward("Xã Cộng Hòa", 12595, VietNamDivisionType.XA, "xa_cong_hoa", 339)
    W_12598 = Ward("Xã Dân Chủ", 12598, VietNamDivisionType.XA, "xa_dan_chu", 339)
    W_12601 = Ward("Xã Canh Tân", 12601, VietNamDivisionType.XA, "xa_canh_tan", 339)
    W_12604 = Ward("Xã Hòa Tiến", 12604, VietNamDivisionType.XA, "xa_hoa_tien", 339)
    W_12607 = Ward("Xã Hùng Dũng", 12607, VietNamDivisionType.XA, "xa_hung_dung", 339)
    W_12610 = Ward("Xã Tân Tiến", 12610, VietNamDivisionType.XA, "xa_tan_tien", 339)
    W_12613 = Ward("Thị trấn Hưng Nhân", 12613, VietNamDivisionType.THI_TRAN, "thi_tran_hung_nhan", 339)
    W_12616 = Ward("Xã Đoan Hùng", 12616, VietNamDivisionType.XA, "xa_doan_hung", 339)
    W_12619 = Ward("Xã Duyên Hải", 12619, VietNamDivisionType.XA, "xa_duyen_hai", 339)
    W_12622 = Ward("Xã Tân Hòa", 12622, VietNamDivisionType.XA, "xa_tan_hoa", 339)
    W_12625 = Ward("Xã Văn Cẩm", 12625, VietNamDivisionType.XA, "xa_van_cam", 339)
    W_12628 = Ward("Xã Bắc Sơn", 12628, VietNamDivisionType.XA, "xa_bac_son", 339)
    W_12631 = Ward("Xã Đông Đô", 12631, VietNamDivisionType.XA, "xa_dong_do", 339)
    W_12634 = Ward("Xã Phúc Khánh", 12634, VietNamDivisionType.XA, "xa_phuc_khanh", 339)
    W_12637 = Ward("Xã Liên Hiệp", 12637, VietNamDivisionType.XA, "xa_lien_hiep", 339)
    W_12640 = Ward("Xã Tây Đô", 12640, VietNamDivisionType.XA, "xa_tay_do", 339)
    W_12643 = Ward("Xã Thống Nhất", 12643, VietNamDivisionType.XA, "xa_thong_nhat", 339)
    W_12646 = Ward("Xã Tiến Đức", 12646, VietNamDivisionType.XA, "xa_tien_duc", 339)
    W_12649 = Ward("Xã Thái Hưng", 12649, VietNamDivisionType.XA, "xa_thai_hung", 339)
    W_12652 = Ward("Xã Thái Phương", 12652, VietNamDivisionType.XA, "xa_thai_phuong", 339)
    W_12655 = Ward("Xã Hòa Bình", 12655, VietNamDivisionType.XA, "xa_hoa_binh", 339)
    W_12656 = Ward("Xã Chi Lăng", 12656, VietNamDivisionType.XA, "xa_chi_lang", 339)
    W_12658 = Ward("Xã Minh Khai", 12658, VietNamDivisionType.XA, "xa_minh_khai", 339)
    W_12661 = Ward("Xã Hồng An", 12661, VietNamDivisionType.XA, "xa_hong_an", 339)
    W_12664 = Ward("Xã Kim Chung", 12664, VietNamDivisionType.XA, "xa_kim_chung", 339)
    W_12667 = Ward("Xã Hồng Lĩnh", 12667, VietNamDivisionType.XA, "xa_hong_linh", 339)
    W_12670 = Ward("Xã Minh Tân", 12670, VietNamDivisionType.XA, "xa_minh_tan", 339)
    W_12673 = Ward("Xã Văn Lang", 12673, VietNamDivisionType.XA, "xa_van_lang", 339)
    W_12676 = Ward("Xã Độc Lập", 12676, VietNamDivisionType.XA, "xa_doc_lap", 339)
    W_12679 = Ward("Xã Chí Hòa", 12679, VietNamDivisionType.XA, "xa_chi_hoa", 339)
    W_12682 = Ward("Xã Minh Hòa", 12682, VietNamDivisionType.XA, "xa_minh_hoa", 339)
    W_12685 = Ward("Xã Hồng Minh", 12685, VietNamDivisionType.XA, "xa_hong_minh", 339)
    W_12688 = Ward("Thị trấn Đông Hưng", 12688, VietNamDivisionType.THI_TRAN, "thi_tran_dong_hung", 340)
    W_12691 = Ward("Xã Đô Lương", 12691, VietNamDivisionType.XA, "xa_do_luong", 340)
    W_12694 = Ward("Xã Đông Phương", 12694, VietNamDivisionType.XA, "xa_dong_phuong", 340)
    W_12697 = Ward("Xã Liên Giang", 12697, VietNamDivisionType.XA, "xa_lien_giang", 340)
    W_12700 = Ward("Xã An Châu", 12700, VietNamDivisionType.XA, "xa_an_chau", 340)
    W_12703 = Ward("Xã Đông Sơn", 12703, VietNamDivisionType.XA, "xa_dong_son", 340)
    W_12706 = Ward("Xã Đông Cường", 12706, VietNamDivisionType.XA, "xa_dong_cuong", 340)
    W_12709 = Ward("Xã Phú Lương", 12709, VietNamDivisionType.XA, "xa_phu_luong", 340)
    W_12712 = Ward("Xã Mê Linh", 12712, VietNamDivisionType.XA, "xa_me_linh", 340)
    W_12715 = Ward("Xã Lô Giang", 12715, VietNamDivisionType.XA, "xa_lo_giang", 340)
    W_12718 = Ward("Xã Đông La", 12718, VietNamDivisionType.XA, "xa_dong_la", 340)
    W_12721 = Ward("Xã Minh Tân", 12721, VietNamDivisionType.XA, "xa_minh_tan", 340)
    W_12724 = Ward("Xã Đông Xá", 12724, VietNamDivisionType.XA, "xa_dong_xa", 340)
    W_12727 = Ward("Xã Chương Dương", 12727, VietNamDivisionType.XA, "xa_chuong_duong", 340)
    W_12730 = Ward("Xã Nguyên Xá", 12730, VietNamDivisionType.XA, "xa_nguyen_xa", 340)
    W_12733 = Ward("Xã Phong Châu", 12733, VietNamDivisionType.XA, "xa_phong_chau", 340)
    W_12736 = Ward("Xã Hợp Tiến", 12736, VietNamDivisionType.XA, "xa_hop_tien", 340)
    W_12739 = Ward("Xã Hồng Việt", 12739, VietNamDivisionType.XA, "xa_hong_viet", 340)
    W_12745 = Ward("Xã Hà Giang", 12745, VietNamDivisionType.XA, "xa_ha_giang", 340)
    W_12748 = Ward("Xã Đông Kinh", 12748, VietNamDivisionType.XA, "xa_dong_kinh", 340)
    W_12751 = Ward("Xã Đông Hợp", 12751, VietNamDivisionType.XA, "xa_dong_hop", 340)
    W_12754 = Ward("Xã Thăng Long", 12754, VietNamDivisionType.XA, "xa_thang_long", 340)
    W_12757 = Ward("Xã Đông Các", 12757, VietNamDivisionType.XA, "xa_dong_cac", 340)
    W_12760 = Ward("Xã Phú Châu", 12760, VietNamDivisionType.XA, "xa_phu_chau", 340)
    W_12763 = Ward("Xã Liên Hoa", 12763, VietNamDivisionType.XA, "xa_lien_hoa", 340)
    W_12769 = Ward("Xã Đông Tân", 12769, VietNamDivisionType.XA, "xa_dong_tan", 340)
    W_12772 = Ward("Xã Đông Vinh", 12772, VietNamDivisionType.XA, "xa_dong_vinh", 340)
    W_12775 = Ward("Xã Đông Động", 12775, VietNamDivisionType.XA, "xa_dong_dong", 340)
    W_12778 = Ward("Xã Hồng Bạch", 12778, VietNamDivisionType.XA, "xa_hong_bach", 340)
    W_12784 = Ward("Xã Trọng Quan", 12784, VietNamDivisionType.XA, "xa_trong_quan", 340)
    W_12790 = Ward("Xã Hồng Giang", 12790, VietNamDivisionType.XA, "xa_hong_giang", 340)
    W_12793 = Ward("Xã Đông Quan", 12793, VietNamDivisionType.XA, "xa_dong_quan", 340)
    W_12796 = Ward("Xã Đông Quang", 12796, VietNamDivisionType.XA, "xa_dong_quang", 340)
    W_12799 = Ward("Xã Đông Xuân", 12799, VietNamDivisionType.XA, "xa_dong_xuan", 340)
    W_12802 = Ward("Xã Đông Á", 12802, VietNamDivisionType.XA, "xa_dong_a", 340)
    W_12808 = Ward("Xã Đông Hoàng", 12808, VietNamDivisionType.XA, "xa_dong_hoang", 340)
    W_12811 = Ward("Xã Đông Dương", 12811, VietNamDivisionType.XA, "xa_dong_duong", 340)
    W_12823 = Ward("Xã Minh Phú", 12823, VietNamDivisionType.XA, "xa_minh_phu", 340)
    W_12826 = Ward("Thị trấn Diêm Điền", 12826, VietNamDivisionType.THI_TRAN, "thi_tran_diem_dien", 341)
    W_12832 = Ward("Xã Thụy Trường", 12832, VietNamDivisionType.XA, "xa_thuy_truong", 341)
    W_12841 = Ward("Xã Hồng Dũng", 12841, VietNamDivisionType.XA, "xa_hong_dung", 341)
    W_12844 = Ward("Xã Thụy Quỳnh", 12844, VietNamDivisionType.XA, "xa_thuy_quynh", 341)
    W_12847 = Ward("Xã An Tân", 12847, VietNamDivisionType.XA, "xa_an_tan", 341)
    W_12850 = Ward("Xã Thụy Ninh", 12850, VietNamDivisionType.XA, "xa_thuy_ninh", 341)
    W_12853 = Ward("Xã Thụy Hưng", 12853, VietNamDivisionType.XA, "xa_thuy_hung", 341)
    W_12856 = Ward("Xã Thụy Việt", 12856, VietNamDivisionType.XA, "xa_thuy_viet", 341)
    W_12859 = Ward("Xã Thụy Văn", 12859, VietNamDivisionType.XA, "xa_thuy_van", 341)
    W_12862 = Ward("Xã Thụy Xuân", 12862, VietNamDivisionType.XA, "xa_thuy_xuan", 341)
    W_12865 = Ward("Xã Dương Phúc", 12865, VietNamDivisionType.XA, "xa_duong_phuc", 341)
    W_12868 = Ward("Xã Thụy Trình", 12868, VietNamDivisionType.XA, "xa_thuy_trinh", 341)
    W_12871 = Ward("Xã Thụy Bình", 12871, VietNamDivisionType.XA, "xa_thuy_binh", 341)
    W_12874 = Ward("Xã Thụy Chính", 12874, VietNamDivisionType.XA, "xa_thuy_chinh", 341)
    W_12877 = Ward("Xã Thụy Dân", 12877, VietNamDivisionType.XA, "xa_thuy_dan", 341)
    W_12880 = Ward("Xã Thụy Hải", 12880, VietNamDivisionType.XA, "xa_thuy_hai", 341)
    W_12889 = Ward("Xã Thụy Liên", 12889, VietNamDivisionType.XA, "xa_thuy_lien", 341)
    W_12892 = Ward("Xã Thụy Duyên", 12892, VietNamDivisionType.XA, "xa_thuy_duyen", 341)
    W_12898 = Ward("Xã Thụy Thanh", 12898, VietNamDivisionType.XA, "xa_thuy_thanh", 341)
    W_12901 = Ward("Xã Thụy Sơn", 12901, VietNamDivisionType.XA, "xa_thuy_son", 341)
    W_12904 = Ward("Xã Thụy Phong", 12904, VietNamDivisionType.XA, "xa_thuy_phong", 341)
    W_12907 = Ward("Xã Thái Thượng", 12907, VietNamDivisionType.XA, "xa_thai_thuong", 341)
    W_12910 = Ward("Xã Thái Nguyên", 12910, VietNamDivisionType.XA, "xa_thai_nguyen", 341)
    W_12916 = Ward("Xã Dương Hồng Thủy", 12916, VietNamDivisionType.XA, "xa_duong_hong_thuy", 341)
    W_12919 = Ward("Xã Thái Giang", 12919, VietNamDivisionType.XA, "xa_thai_giang", 341)
    W_12922 = Ward("Xã Hòa An", 12922, VietNamDivisionType.XA, "xa_hoa_an", 341)
    W_12925 = Ward("Xã Sơn Hà", 12925, VietNamDivisionType.XA, "xa_son_ha", 341)
    W_12934 = Ward("Xã Thái Phúc", 12934, VietNamDivisionType.XA, "xa_thai_phuc", 341)
    W_12937 = Ward("Xã Thái Hưng", 12937, VietNamDivisionType.XA, "xa_thai_hung", 341)
    W_12940 = Ward("Xã Thái Đô", 12940, VietNamDivisionType.XA, "xa_thai_do", 341)
    W_12943 = Ward("Xã Thái Xuyên", 12943, VietNamDivisionType.XA, "xa_thai_xuyen", 341)
    W_12949 = Ward("Xã Mỹ Lộc", 12949, VietNamDivisionType.XA, "xa_my_loc", 341)
    W_12958 = Ward("Xã Tân Học", 12958, VietNamDivisionType.XA, "xa_tan_hoc", 341)
    W_12961 = Ward("Xã Thái Thịnh", 12961, VietNamDivisionType.XA, "xa_thai_thinh", 341)
    W_12964 = Ward("Xã Thuần Thành", 12964, VietNamDivisionType.XA, "xa_thuan_thanh", 341)
    W_12967 = Ward("Xã Thái Thọ", 12967, VietNamDivisionType.XA, "xa_thai_tho", 341)
    W_12970 = Ward("Thị trấn Tiền Hải", 12970, VietNamDivisionType.THI_TRAN, "thi_tran_tien_hai", 342)
    W_12976 = Ward("Xã Đông Trà", 12976, VietNamDivisionType.XA, "xa_dong_tra", 342)
    W_12979 = Ward("Xã Đông Long", 12979, VietNamDivisionType.XA, "xa_dong_long", 342)
    W_12982 = Ward("Xã Đông Quí", 12982, VietNamDivisionType.XA, "xa_dong_qui", 342)
    W_12985 = Ward("Xã Vũ Lăng", 12985, VietNamDivisionType.XA, "xa_vu_lang", 342)
    W_12988 = Ward("Xã Đông Xuyên", 12988, VietNamDivisionType.XA, "xa_dong_xuyen", 342)
    W_12991 = Ward("Xã Tây Lương", 12991, VietNamDivisionType.XA, "xa_tay_luong", 342)
    W_12994 = Ward("Xã Tây Ninh", 12994, VietNamDivisionType.XA, "xa_tay_ninh", 342)
    W_12997 = Ward("Xã Đông Trung", 12997, VietNamDivisionType.XA, "xa_dong_trung", 342)
    W_13000 = Ward("Xã Đông Hoàng", 13000, VietNamDivisionType.XA, "xa_dong_hoang", 342)
    W_13003 = Ward("Xã Đông Minh", 13003, VietNamDivisionType.XA, "xa_dong_minh", 342)
    W_13009 = Ward("Xã Đông Phong", 13009, VietNamDivisionType.XA, "xa_dong_phong", 342)
    W_13012 = Ward("Xã An Ninh", 13012, VietNamDivisionType.XA, "xa_an_ninh", 342)
    W_13018 = Ward("Xã Đông Cơ", 13018, VietNamDivisionType.XA, "xa_dong_co", 342)
    W_13021 = Ward("Xã Tây Giang", 13021, VietNamDivisionType.XA, "xa_tay_giang", 342)
    W_13024 = Ward("Xã Đông Lâm", 13024, VietNamDivisionType.XA, "xa_dong_lam", 342)
    W_13027 = Ward("Xã Phương Công", 13027, VietNamDivisionType.XA, "xa_phuong_cong", 342)
    W_13030 = Ward("Xã Tây Phong", 13030, VietNamDivisionType.XA, "xa_tay_phong", 342)
    W_13033 = Ward("Xã Tây Tiến", 13033, VietNamDivisionType.XA, "xa_tay_tien", 342)
    W_13036 = Ward("Xã Nam Cường", 13036, VietNamDivisionType.XA, "xa_nam_cuong", 342)
    W_13039 = Ward("Xã Vân Trường", 13039, VietNamDivisionType.XA, "xa_van_truong", 342)
    W_13042 = Ward("Xã Nam Thắng", 13042, VietNamDivisionType.XA, "xa_nam_thang", 342)
    W_13045 = Ward("Xã Nam Chính", 13045, VietNamDivisionType.XA, "xa_nam_chinh", 342)
    W_13048 = Ward("Xã Bắc Hải", 13048, VietNamDivisionType.XA, "xa_bac_hai", 342)
    W_13051 = Ward("Xã Nam Thịnh", 13051, VietNamDivisionType.XA, "xa_nam_thinh", 342)
    W_13054 = Ward("Xã Nam Hà", 13054, VietNamDivisionType.XA, "xa_nam_ha", 342)
    W_13057 = Ward("Xã Nam Thanh", 13057, VietNamDivisionType.XA, "xa_nam_thanh", 342)
    W_13060 = Ward("Xã Nam Trung", 13060, VietNamDivisionType.XA, "xa_nam_trung", 342)
    W_13063 = Ward("Xã Nam Hồng", 13063, VietNamDivisionType.XA, "xa_nam_hong", 342)
    W_13066 = Ward("Xã Nam Hưng", 13066, VietNamDivisionType.XA, "xa_nam_hung", 342)
    W_13069 = Ward("Xã Nam Hải", 13069, VietNamDivisionType.XA, "xa_nam_hai", 342)
    W_13072 = Ward("Xã Nam Phú", 13072, VietNamDivisionType.XA, "xa_nam_phu", 342)
    W_13075 = Ward("Thị trấn Kiến Xương", 13075, VietNamDivisionType.THI_TRAN, "thi_tran_kien_xuong", 343)
    W_13078 = Ward("Xã Trà Giang", 13078, VietNamDivisionType.XA, "xa_tra_giang", 343)
    W_13081 = Ward("Xã Quốc Tuấn", 13081, VietNamDivisionType.XA, "xa_quoc_tuan", 343)
    W_13087 = Ward("Xã An Bình", 13087, VietNamDivisionType.XA, "xa_an_binh", 343)
    W_13090 = Ward("Xã Tây Sơn", 13090, VietNamDivisionType.XA, "xa_tay_son", 343)
    W_13093 = Ward("Xã Hồng Thái", 13093, VietNamDivisionType.XA, "xa_hong_thai", 343)
    W_13096 = Ward("Xã Bình Nguyên", 13096, VietNamDivisionType.XA, "xa_binh_nguyen", 343)
    W_13102 = Ward("Xã Lê Lợi", 13102, VietNamDivisionType.XA, "xa_le_loi", 343)
    W_13111 = Ward("Xã Vũ Lễ", 13111, VietNamDivisionType.XA, "xa_vu_le", 343)
    W_13114 = Ward("Xã Thanh Tân", 13114, VietNamDivisionType.XA, "xa_thanh_tan", 343)
    W_13117 = Ward("Xã Thượng Hiền", 13117, VietNamDivisionType.XA, "xa_thuong_hien", 343)
    W_13120 = Ward("Xã Nam Cao", 13120, VietNamDivisionType.XA, "xa_nam_cao", 343)
    W_13123 = Ward("Xã Đình Phùng", 13123, VietNamDivisionType.XA, "xa_dinh_phung", 343)
    W_13126 = Ward("Xã Vũ Ninh", 13126, VietNamDivisionType.XA, "xa_vu_ninh", 343)
    W_13129 = Ward("Xã Vũ An", 13129, VietNamDivisionType.XA, "xa_vu_an", 343)
    W_13132 = Ward("Xã Quang Lịch", 13132, VietNamDivisionType.XA, "xa_quang_lich", 343)
    W_13135 = Ward("Xã Hòa Bình", 13135, VietNamDivisionType.XA, "xa_hoa_binh", 343)
    W_13138 = Ward("Xã Bình Minh", 13138, VietNamDivisionType.XA, "xa_binh_minh", 343)
    W_13141 = Ward("Xã Vũ Quí", 13141, VietNamDivisionType.XA, "xa_vu_qui", 343)
    W_13144 = Ward("Xã Quang Bình", 13144, VietNamDivisionType.XA, "xa_quang_binh", 343)
    W_13150 = Ward("Xã Vũ Trung", 13150, VietNamDivisionType.XA, "xa_vu_trung", 343)
    W_13153 = Ward("Xã Vũ Thắng", 13153, VietNamDivisionType.XA, "xa_vu_thang", 343)
    W_13156 = Ward("Xã Vũ Công", 13156, VietNamDivisionType.XA, "xa_vu_cong", 343)
    W_13159 = Ward("Xã Vũ Hòa", 13159, VietNamDivisionType.XA, "xa_vu_hoa", 343)
    W_13162 = Ward("Xã Quang Minh", 13162, VietNamDivisionType.XA, "xa_quang_minh", 343)
    W_13165 = Ward("Xã Quang Trung", 13165, VietNamDivisionType.XA, "xa_quang_trung", 343)
    W_13171 = Ward("Xã Minh Quang", 13171, VietNamDivisionType.XA, "xa_minh_quang", 343)
    W_13174 = Ward("Xã Vũ Bình", 13174, VietNamDivisionType.XA, "xa_vu_binh", 343)
    W_13177 = Ward("Xã Minh Tân", 13177, VietNamDivisionType.XA, "xa_minh_tan", 343)
    W_13180 = Ward("Xã Nam Bình", 13180, VietNamDivisionType.XA, "xa_nam_binh", 343)
    W_13183 = Ward("Xã Bình Thanh", 13183, VietNamDivisionType.XA, "xa_binh_thanh", 343)
    W_13186 = Ward("Xã Bình Định", 13186, VietNamDivisionType.XA, "xa_binh_dinh", 343)
    W_13189 = Ward("Xã Hồng Tiến", 13189, VietNamDivisionType.XA, "xa_hong_tien", 343)
    W_13192 = Ward("Thị trấn Vũ Thư", 13192, VietNamDivisionType.THI_TRAN, "thi_tran_vu_thu", 344)
    W_13195 = Ward("Xã Hồng Lý", 13195, VietNamDivisionType.XA, "xa_hong_ly", 344)
    W_13198 = Ward("Xã Đồng Thanh", 13198, VietNamDivisionType.XA, "xa_dong_thanh", 344)
    W_13201 = Ward("Xã Xuân Hòa", 13201, VietNamDivisionType.XA, "xa_xuan_hoa", 344)
    W_13204 = Ward("Xã Hiệp Hòa", 13204, VietNamDivisionType.XA, "xa_hiep_hoa", 344)
    W_13207 = Ward("Xã Phúc Thành", 13207, VietNamDivisionType.XA, "xa_phuc_thanh", 344)
    W_13210 = Ward("Xã Tân Phong", 13210, VietNamDivisionType.XA, "xa_tan_phong", 344)
    W_13213 = Ward("Xã Song Lãng", 13213, VietNamDivisionType.XA, "xa_song_lang", 344)
    W_13216 = Ward("Xã Tân Hòa", 13216, VietNamDivisionType.XA, "xa_tan_hoa", 344)
    W_13219 = Ward("Xã Việt Hùng", 13219, VietNamDivisionType.XA, "xa_viet_hung", 344)
    W_13222 = Ward("Xã Minh Lãng", 13222, VietNamDivisionType.XA, "xa_minh_lang", 344)
    W_13228 = Ward("Xã Minh Khai", 13228, VietNamDivisionType.XA, "xa_minh_khai", 344)
    W_13231 = Ward("Xã Dũng Nghĩa", 13231, VietNamDivisionType.XA, "xa_dung_nghia", 344)
    W_13234 = Ward("Xã Minh Quang", 13234, VietNamDivisionType.XA, "xa_minh_quang", 344)
    W_13237 = Ward("Xã Tam Quang", 13237, VietNamDivisionType.XA, "xa_tam_quang", 344)
    W_13240 = Ward("Xã Tân Lập", 13240, VietNamDivisionType.XA, "xa_tan_lap", 344)
    W_13243 = Ward("Xã Bách Thuận", 13243, VietNamDivisionType.XA, "xa_bach_thuan", 344)
    W_13246 = Ward("Xã Tự Tân", 13246, VietNamDivisionType.XA, "xa_tu_tan", 344)
    W_13249 = Ward("Xã Song An", 13249, VietNamDivisionType.XA, "xa_song_an", 344)
    W_13252 = Ward("Xã Trung An", 13252, VietNamDivisionType.XA, "xa_trung_an", 344)
    W_13255 = Ward("Xã Vũ Hội", 13255, VietNamDivisionType.XA, "xa_vu_hoi", 344)
    W_13258 = Ward("Xã Hòa Bình", 13258, VietNamDivisionType.XA, "xa_hoa_binh", 344)
    W_13261 = Ward("Xã Nguyên Xá", 13261, VietNamDivisionType.XA, "xa_nguyen_xa", 344)
    W_13264 = Ward("Xã Việt Thuận", 13264, VietNamDivisionType.XA, "xa_viet_thuan", 344)
    W_13267 = Ward("Xã Vũ Vinh", 13267, VietNamDivisionType.XA, "xa_vu_vinh", 344)
    W_13270 = Ward("Xã Vũ Đoài", 13270, VietNamDivisionType.XA, "xa_vu_doai", 344)
    W_13273 = Ward("Xã Vũ Tiến", 13273, VietNamDivisionType.XA, "xa_vu_tien", 344)
    W_13276 = Ward("Xã Vũ Vân", 13276, VietNamDivisionType.XA, "xa_vu_van", 344)
    W_13279 = Ward("Xã Duy Nhất", 13279, VietNamDivisionType.XA, "xa_duy_nhat", 344)
    W_13282 = Ward("Xã Hồng Phong", 13282, VietNamDivisionType.XA, "xa_hong_phong", 344)
    W_13285 = Ward("Phường Quang Trung", 13285, VietNamDivisionType.PHUONG, "phuong_quang_trung", 347)
    W_13288 = Ward("Phường Lương Khánh Thiện", 13288, VietNamDivisionType.PHUONG, "phuong_luong_khanh_thien", 347)
    W_13291 = Ward("Phường Lê Hồng Phong", 13291, VietNamDivisionType.PHUONG, "phuong_le_hong_phong", 347)
    W_13294 = Ward("Phường Minh Khai", 13294, VietNamDivisionType.PHUONG, "phuong_minh_khai", 347)
    W_13297 = Ward("Phường Hai Bà Trưng", 13297, VietNamDivisionType.PHUONG, "phuong_hai_ba_trung", 347)
    W_13300 = Ward("Phường Trần Hưng Đạo", 13300, VietNamDivisionType.PHUONG, "phuong_tran_hung_dao", 347)
    W_13303 = Ward("Phường Lam Hạ", 13303, VietNamDivisionType.PHUONG, "phuong_lam_ha", 347)
    W_13306 = Ward("Xã Phù Vân", 13306, VietNamDivisionType.XA, "xa_phu_van", 347)
    W_13309 = Ward("Phường Liêm Chính", 13309, VietNamDivisionType.PHUONG, "phuong_liem_chinh", 347)
    W_13312 = Ward("Xã Liêm Chung", 13312, VietNamDivisionType.XA, "xa_liem_chung", 347)
    W_13315 = Ward("Phường Thanh Châu", 13315, VietNamDivisionType.PHUONG, "phuong_thanh_chau", 347)
    W_13318 = Ward("Phường Châu Sơn", 13318, VietNamDivisionType.PHUONG, "phuong_chau_son", 347)
    W_13366 = Ward("Xã Tiên Tân", 13366, VietNamDivisionType.XA, "xa_tien_tan", 347)
    W_13372 = Ward("Xã Tiên Hiệp", 13372, VietNamDivisionType.XA, "xa_tien_hiep", 347)
    W_13381 = Ward("Xã Tiên Hải", 13381, VietNamDivisionType.XA, "xa_tien_hai", 347)
    W_13426 = Ward("Xã Kim Bình", 13426, VietNamDivisionType.XA, "xa_kim_binh", 347)
    W_13444 = Ward("Xã Liêm Tuyền", 13444, VietNamDivisionType.XA, "xa_liem_tuyen", 347)
    W_13447 = Ward("Xã Liêm Tiết", 13447, VietNamDivisionType.XA, "xa_liem_tiet", 347)
    W_13459 = Ward("Phường Thanh Tuyền", 13459, VietNamDivisionType.PHUONG, "phuong_thanh_tuyen", 347)
    W_13507 = Ward("Xã Đinh Xá", 13507, VietNamDivisionType.XA, "xa_dinh_xa", 347)
    W_13513 = Ward("Xã Trịnh Xá", 13513, VietNamDivisionType.XA, "xa_trinh_xa", 347)
    W_13321 = Ward("Phường Đồng Văn", 13321, VietNamDivisionType.PHUONG, "phuong_dong_van", 349)
    W_13324 = Ward("Phường Hòa Mạc", 13324, VietNamDivisionType.PHUONG, "phuong_hoa_mac", 349)
    W_13327 = Ward("Xã Mộc Bắc", 13327, VietNamDivisionType.XA, "xa_moc_bac", 349)
    W_13330 = Ward("Phường Châu Giang", 13330, VietNamDivisionType.PHUONG, "phuong_chau_giang", 349)
    W_13333 = Ward("Phường Bạch Thượng", 13333, VietNamDivisionType.PHUONG, "phuong_bach_thuong", 349)
    W_13336 = Ward("Phường Duy Minh", 13336, VietNamDivisionType.PHUONG, "phuong_duy_minh", 349)
    W_13339 = Ward("Xã Mộc Nam", 13339, VietNamDivisionType.XA, "xa_moc_nam", 349)
    W_13342 = Ward("Phường Duy Hải", 13342, VietNamDivisionType.PHUONG, "phuong_duy_hai", 349)
    W_13345 = Ward("Xã Chuyên Ngoại", 13345, VietNamDivisionType.XA, "xa_chuyen_ngoai", 349)
    W_13348 = Ward("Phường Yên Bắc", 13348, VietNamDivisionType.PHUONG, "phuong_yen_bac", 349)
    W_13351 = Ward("Xã Trác Văn", 13351, VietNamDivisionType.XA, "xa_trac_van", 349)
    W_13354 = Ward("Phường Tiên Nội", 13354, VietNamDivisionType.PHUONG, "phuong_tien_noi", 349)
    W_13357 = Ward("Phường Hoàng Đông", 13357, VietNamDivisionType.PHUONG, "phuong_hoang_dong", 349)
    W_13360 = Ward("Xã Yên Nam", 13360, VietNamDivisionType.XA, "xa_yen_nam", 349)
    W_13363 = Ward("Xã Tiên Ngoại", 13363, VietNamDivisionType.XA, "xa_tien_ngoai", 349)
    W_13369 = Ward("Xã Tiên Sơn", 13369, VietNamDivisionType.XA, "xa_tien_son", 349)
    W_13384 = Ward("Thị trấn Quế", 13384, VietNamDivisionType.THI_TRAN, "thi_tran_que", 350)
    W_13387 = Ward("Xã Nguyễn Úy", 13387, VietNamDivisionType.XA, "xa_nguyen_uy", 350)
    W_13390 = Ward("Xã Đại Cương", 13390, VietNamDivisionType.XA, "xa_dai_cuong", 350)
    W_13393 = Ward("Xã Lê Hồ", 13393, VietNamDivisionType.XA, "xa_le_ho", 350)
    W_13396 = Ward("Xã Tượng Lĩnh", 13396, VietNamDivisionType.XA, "xa_tuong_linh", 350)
    W_13399 = Ward("Xã Nhật Tựu", 13399, VietNamDivisionType.XA, "xa_nhat_tuu", 350)
    W_13402 = Ward("Xã Nhật Tân", 13402, VietNamDivisionType.XA, "xa_nhat_tan", 350)
    W_13405 = Ward("Xã Đồng Hóa", 13405, VietNamDivisionType.XA, "xa_dong_hoa", 350)
    W_13408 = Ward("Xã Hoàng Tây", 13408, VietNamDivisionType.XA, "xa_hoang_tay", 350)
    W_13411 = Ward("Xã Tân Sơn", 13411, VietNamDivisionType.XA, "xa_tan_son", 350)
    W_13414 = Ward("Xã Thụy Lôi", 13414, VietNamDivisionType.XA, "xa_thuy_loi", 350)
    W_13417 = Ward("Xã Văn Xá", 13417, VietNamDivisionType.XA, "xa_van_xa", 350)
    W_13420 = Ward("Xã Khả Phong", 13420, VietNamDivisionType.XA, "xa_kha_phong", 350)
    W_13423 = Ward("Xã Ngọc Sơn", 13423, VietNamDivisionType.XA, "xa_ngoc_son", 350)
    W_13429 = Ward("Thị trấn Ba Sao", 13429, VietNamDivisionType.THI_TRAN, "thi_tran_ba_sao", 350)
    W_13432 = Ward("Xã Liên Sơn", 13432, VietNamDivisionType.XA, "xa_lien_son", 350)
    W_13435 = Ward("Xã Thi Sơn", 13435, VietNamDivisionType.XA, "xa_thi_son", 350)
    W_13438 = Ward("Xã Thanh Sơn", 13438, VietNamDivisionType.XA, "xa_thanh_son", 350)
    W_13441 = Ward("Thị trấn Kiện Khê", 13441, VietNamDivisionType.THI_TRAN, "thi_tran_kien_khe", 351)
    W_13450 = Ward("Xã Liêm Phong", 13450, VietNamDivisionType.XA, "xa_liem_phong", 351)
    W_13453 = Ward("Xã Thanh Hà", 13453, VietNamDivisionType.XA, "xa_thanh_ha", 351)
    W_13456 = Ward("Xã Liêm Cần", 13456, VietNamDivisionType.XA, "xa_liem_can", 351)
    W_13465 = Ward("Xã Liêm Thuận", 13465, VietNamDivisionType.XA, "xa_liem_thuan", 351)
    W_13468 = Ward("Xã Thanh Thủy", 13468, VietNamDivisionType.XA, "xa_thanh_thuy", 351)
    W_13471 = Ward("Xã Thanh Phong", 13471, VietNamDivisionType.XA, "xa_thanh_phong", 351)
    W_13474 = Ward("Thị trấn Tân Thanh", 13474, VietNamDivisionType.THI_TRAN, "thi_tran_tan_thanh", 351)
    W_13477 = Ward("Xã Thanh Tân", 13477, VietNamDivisionType.XA, "xa_thanh_tan", 351)
    W_13480 = Ward("Xã Liêm Túc", 13480, VietNamDivisionType.XA, "xa_liem_tuc", 351)
    W_13483 = Ward("Xã Liêm Sơn", 13483, VietNamDivisionType.XA, "xa_liem_son", 351)
    W_13486 = Ward("Xã Thanh Hương", 13486, VietNamDivisionType.XA, "xa_thanh_huong", 351)
    W_13489 = Ward("Xã Thanh Nghị", 13489, VietNamDivisionType.XA, "xa_thanh_nghi", 351)
    W_13492 = Ward("Xã Thanh Tâm", 13492, VietNamDivisionType.XA, "xa_thanh_tam", 351)
    W_13495 = Ward("Xã Thanh Nguyên", 13495, VietNamDivisionType.XA, "xa_thanh_nguyen", 351)
    W_13498 = Ward("Xã Thanh Hải", 13498, VietNamDivisionType.XA, "xa_thanh_hai", 351)
    W_13501 = Ward("Thị trấn Bình Mỹ", 13501, VietNamDivisionType.THI_TRAN, "thi_tran_binh_my", 352)
    W_13504 = Ward("Xã Bình Nghĩa", 13504, VietNamDivisionType.XA, "xa_binh_nghia", 352)
    W_13510 = Ward("Xã Tràng An", 13510, VietNamDivisionType.XA, "xa_trang_an", 352)
    W_13516 = Ward("Xã Đồng Du", 13516, VietNamDivisionType.XA, "xa_dong_du", 352)
    W_13519 = Ward("Xã Ngọc Lũ", 13519, VietNamDivisionType.XA, "xa_ngoc_lu", 352)
    W_13522 = Ward("Xã Hưng Công", 13522, VietNamDivisionType.XA, "xa_hung_cong", 352)
    W_13525 = Ward("Xã Đồn Xá", 13525, VietNamDivisionType.XA, "xa_don_xa", 352)
    W_13528 = Ward("Xã An Ninh", 13528, VietNamDivisionType.XA, "xa_an_ninh", 352)
    W_13531 = Ward("Xã Bồ Đề", 13531, VietNamDivisionType.XA, "xa_bo_de", 352)
    W_13534 = Ward("Xã Bối Cầu", 13534, VietNamDivisionType.XA, "xa_boi_cau", 352)
    W_13540 = Ward("Xã An Nội", 13540, VietNamDivisionType.XA, "xa_an_noi", 352)
    W_13543 = Ward("Xã Vũ Bản", 13543, VietNamDivisionType.XA, "xa_vu_ban", 352)
    W_13546 = Ward("Xã Trung Lương", 13546, VietNamDivisionType.XA, "xa_trung_luong", 352)
    W_13552 = Ward("Xã An Đổ", 13552, VietNamDivisionType.XA, "xa_an_do", 352)
    W_13555 = Ward("Xã La Sơn", 13555, VietNamDivisionType.XA, "xa_la_son", 352)
    W_13558 = Ward("Xã Tiêu Động", 13558, VietNamDivisionType.XA, "xa_tieu_dong", 352)
    W_13561 = Ward("Xã An Lão", 13561, VietNamDivisionType.XA, "xa_an_lao", 352)
    W_13567 = Ward("Xã Hợp Lý", 13567, VietNamDivisionType.XA, "xa_hop_ly", 353)
    W_13570 = Ward("Xã Nguyên Lý", 13570, VietNamDivisionType.XA, "xa_nguyen_ly", 353)
    W_13573 = Ward("Xã Chính Lý", 13573, VietNamDivisionType.XA, "xa_chinh_ly", 353)
    W_13576 = Ward("Xã Chân Lý", 13576, VietNamDivisionType.XA, "xa_chan_ly", 353)
    W_13579 = Ward("Xã Đạo Lý", 13579, VietNamDivisionType.XA, "xa_dao_ly", 353)
    W_13582 = Ward("Xã Công Lý", 13582, VietNamDivisionType.XA, "xa_cong_ly", 353)
    W_13585 = Ward("Xã Văn Lý", 13585, VietNamDivisionType.XA, "xa_van_ly", 353)
    W_13588 = Ward("Xã Bắc Lý", 13588, VietNamDivisionType.XA, "xa_bac_ly", 353)
    W_13591 = Ward("Xã Đức Lý", 13591, VietNamDivisionType.XA, "xa_duc_ly", 353)
    W_13594 = Ward("Xã Trần Hưng Đạo", 13594, VietNamDivisionType.XA, "xa_tran_hung_dao", 353)
    W_13597 = Ward("Thị trấn Vĩnh Trụ", 13597, VietNamDivisionType.THI_TRAN, "thi_tran_vinh_tru", 353)
    W_13600 = Ward("Xã Nhân Thịnh", 13600, VietNamDivisionType.XA, "xa_nhan_thinh", 353)
    W_13606 = Ward("Xã Nhân Khang", 13606, VietNamDivisionType.XA, "xa_nhan_khang", 353)
    W_13609 = Ward("Xã Nhân Mỹ", 13609, VietNamDivisionType.XA, "xa_nhan_my", 353)
    W_13612 = Ward("Xã Nhân Nghĩa", 13612, VietNamDivisionType.XA, "xa_nhan_nghia", 353)
    W_13615 = Ward("Xã Nhân Chính", 13615, VietNamDivisionType.XA, "xa_nhan_chinh", 353)
    W_13618 = Ward("Xã Nhân Bình", 13618, VietNamDivisionType.XA, "xa_nhan_binh", 353)
    W_13621 = Ward("Xã Phú Phúc", 13621, VietNamDivisionType.XA, "xa_phu_phuc", 353)
    W_13624 = Ward("Xã Xuân Khê", 13624, VietNamDivisionType.XA, "xa_xuan_khe", 353)
    W_13627 = Ward("Xã Tiến Thắng", 13627, VietNamDivisionType.XA, "xa_tien_thang", 353)
    W_13630 = Ward("Xã Hòa Hậu", 13630, VietNamDivisionType.XA, "xa_hoa_hau", 353)
    W_13633 = Ward("Phường Hạ Long", 13633, VietNamDivisionType.PHUONG, "phuong_ha_long", 356)
    W_13636 = Ward("Phường Trần Tế Xương", 13636, VietNamDivisionType.PHUONG, "phuong_tran_te_xuong", 356)
    W_13639 = Ward("Phường Vị Hoàng", 13639, VietNamDivisionType.PHUONG, "phuong_vi_hoang", 356)
    W_13642 = Ward("Phường Vị Xuyên", 13642, VietNamDivisionType.PHUONG, "phuong_vi_xuyen", 356)
    W_13645 = Ward("Phường Quang Trung", 13645, VietNamDivisionType.PHUONG, "phuong_quang_trung", 356)
    W_13648 = Ward("Phường Cửa Bắc", 13648, VietNamDivisionType.PHUONG, "phuong_cua_bac", 356)
    W_13651 = Ward("Phường Nguyễn Du", 13651, VietNamDivisionType.PHUONG, "phuong_nguyen_du", 356)
    W_13654 = Ward("Phường Bà Triệu", 13654, VietNamDivisionType.PHUONG, "phuong_ba_trieu", 356)
    W_13657 = Ward("Phường Trường Thi", 13657, VietNamDivisionType.PHUONG, "phuong_truong_thi", 356)
    W_13660 = Ward("Phường Phan Đình Phùng", 13660, VietNamDivisionType.PHUONG, "phuong_phan_dinh_phung", 356)
    W_13663 = Ward("Phường Ngô Quyền", 13663, VietNamDivisionType.PHUONG, "phuong_ngo_quyen", 356)
    W_13666 = Ward("Phường Trần Hưng Đạo", 13666, VietNamDivisionType.PHUONG, "phuong_tran_hung_dao", 356)
    W_13669 = Ward("Phường Trần Đăng Ninh", 13669, VietNamDivisionType.PHUONG, "phuong_tran_dang_ninh", 356)
    W_13672 = Ward("Phường Năng Tĩnh", 13672, VietNamDivisionType.PHUONG, "phuong_nang_tinh", 356)
    W_13675 = Ward("Phường Văn Miếu", 13675, VietNamDivisionType.PHUONG, "phuong_van_mieu", 356)
    W_13678 = Ward("Phường Trần Quang Khải", 13678, VietNamDivisionType.PHUONG, "phuong_tran_quang_khai", 356)
    W_13681 = Ward("Phường Thống Nhất", 13681, VietNamDivisionType.PHUONG, "phuong_thong_nhat", 356)
    W_13684 = Ward("Phường Lộc Hạ", 13684, VietNamDivisionType.PHUONG, "phuong_loc_ha", 356)
    W_13687 = Ward("Phường Lộc Vượng", 13687, VietNamDivisionType.PHUONG, "phuong_loc_vuong", 356)
    W_13690 = Ward("Phường Cửa Nam", 13690, VietNamDivisionType.PHUONG, "phuong_cua_nam", 356)
    W_13693 = Ward("Phường Lộc Hòa", 13693, VietNamDivisionType.PHUONG, "phuong_loc_hoa", 356)
    W_13696 = Ward("Xã Nam Phong", 13696, VietNamDivisionType.XA, "xa_nam_phong", 356)
    W_13699 = Ward("Phường Mỹ Xá", 13699, VietNamDivisionType.PHUONG, "phuong_my_xa", 356)
    W_13702 = Ward("Xã Lộc An", 13702, VietNamDivisionType.XA, "xa_loc_an", 356)
    W_13705 = Ward("Xã Nam Vân", 13705, VietNamDivisionType.XA, "xa_nam_van", 356)
    W_13708 = Ward("Thị trấn Mỹ Lộc", 13708, VietNamDivisionType.THI_TRAN, "thi_tran_my_loc", 358)
    W_13711 = Ward("Xã Mỹ Hà", 13711, VietNamDivisionType.XA, "xa_my_ha", 358)
    W_13714 = Ward("Xã Mỹ Tiến", 13714, VietNamDivisionType.XA, "xa_my_tien", 358)
    W_13717 = Ward("Xã Mỹ Thắng", 13717, VietNamDivisionType.XA, "xa_my_thang", 358)
    W_13720 = Ward("Xã Mỹ Trung", 13720, VietNamDivisionType.XA, "xa_my_trung", 358)
    W_13723 = Ward("Xã Mỹ Tân", 13723, VietNamDivisionType.XA, "xa_my_tan", 358)
    W_13726 = Ward("Xã Mỹ Phúc", 13726, VietNamDivisionType.XA, "xa_my_phuc", 358)
    W_13729 = Ward("Xã Mỹ Hưng", 13729, VietNamDivisionType.XA, "xa_my_hung", 358)
    W_13732 = Ward("Xã Mỹ Thuận", 13732, VietNamDivisionType.XA, "xa_my_thuan", 358)
    W_13735 = Ward("Xã Mỹ Thịnh", 13735, VietNamDivisionType.XA, "xa_my_thinh", 358)
    W_13738 = Ward("Xã Mỹ Thành", 13738, VietNamDivisionType.XA, "xa_my_thanh", 358)
    W_13741 = Ward("Thị trấn Gôi", 13741, VietNamDivisionType.THI_TRAN, "thi_tran_goi", 359)
    W_13744 = Ward("Xã Minh Thuận", 13744, VietNamDivisionType.XA, "xa_minh_thuan", 359)
    W_13747 = Ward("Xã Hiển Khánh", 13747, VietNamDivisionType.XA, "xa_hien_khanh", 359)
    W_13750 = Ward("Xã Tân Khánh", 13750, VietNamDivisionType.XA, "xa_tan_khanh", 359)
    W_13753 = Ward("Xã Hợp Hưng", 13753, VietNamDivisionType.XA, "xa_hop_hung", 359)
    W_13756 = Ward("Xã Đại An", 13756, VietNamDivisionType.XA, "xa_dai_an", 359)
    W_13759 = Ward("Xã Tân Thành", 13759, VietNamDivisionType.XA, "xa_tan_thanh", 359)
    W_13762 = Ward("Xã Cộng Hòa", 13762, VietNamDivisionType.XA, "xa_cong_hoa", 359)
    W_13765 = Ward("Xã Trung Thành", 13765, VietNamDivisionType.XA, "xa_trung_thanh", 359)
    W_13768 = Ward("Xã Quang Trung", 13768, VietNamDivisionType.XA, "xa_quang_trung", 359)
    W_13771 = Ward("Xã Minh Tân", 13771, VietNamDivisionType.XA, "xa_minh_tan", 359)
    W_13774 = Ward("Xã Liên Bảo", 13774, VietNamDivisionType.XA, "xa_lien_bao", 359)
    W_13777 = Ward("Xã Thành Lợi", 13777, VietNamDivisionType.XA, "xa_thanh_loi", 359)
    W_13780 = Ward("Xã Kim Thái", 13780, VietNamDivisionType.XA, "xa_kim_thai", 359)
    W_13783 = Ward("Xã Liên Minh", 13783, VietNamDivisionType.XA, "xa_lien_minh", 359)
    W_13786 = Ward("Xã Đại Thắng", 13786, VietNamDivisionType.XA, "xa_dai_thang", 359)
    W_13789 = Ward("Xã Tam Thanh", 13789, VietNamDivisionType.XA, "xa_tam_thanh", 359)
    W_13792 = Ward("Xã Vĩnh Hào", 13792, VietNamDivisionType.XA, "xa_vinh_hao", 359)
    W_13795 = Ward("Thị trấn Lâm", 13795, VietNamDivisionType.THI_TRAN, "thi_tran_lam", 360)
    W_13798 = Ward("Xã Yên Trung", 13798, VietNamDivisionType.XA, "xa_yen_trung", 360)
    W_13801 = Ward("Xã Yên Thành", 13801, VietNamDivisionType.XA, "xa_yen_thanh", 360)
    W_13804 = Ward("Xã Yên Tân", 13804, VietNamDivisionType.XA, "xa_yen_tan", 360)
    W_13807 = Ward("Xã Yên Lợi", 13807, VietNamDivisionType.XA, "xa_yen_loi", 360)
    W_13810 = Ward("Xã Yên Thọ", 13810, VietNamDivisionType.XA, "xa_yen_tho", 360)
    W_13813 = Ward("Xã Yên Nghĩa", 13813, VietNamDivisionType.XA, "xa_yen_nghia", 360)
    W_13816 = Ward("Xã Yên Minh", 13816, VietNamDivisionType.XA, "xa_yen_minh", 360)
    W_13819 = Ward("Xã Yên Phương", 13819, VietNamDivisionType.XA, "xa_yen_phuong", 360)
    W_13822 = Ward("Xã Yên Chính", 13822, VietNamDivisionType.XA, "xa_yen_chinh", 360)
    W_13825 = Ward("Xã Yên Bình", 13825, VietNamDivisionType.XA, "xa_yen_binh", 360)
    W_13828 = Ward("Xã Yên Phú", 13828, VietNamDivisionType.XA, "xa_yen_phu", 360)
    W_13831 = Ward("Xã Yên Mỹ", 13831, VietNamDivisionType.XA, "xa_yen_my", 360)
    W_13834 = Ward("Xã Yên Dương", 13834, VietNamDivisionType.XA, "xa_yen_duong", 360)
    W_13840 = Ward("Xã Yên Hưng", 13840, VietNamDivisionType.XA, "xa_yen_hung", 360)
    W_13843 = Ward("Xã Yên Khánh", 13843, VietNamDivisionType.XA, "xa_yen_khanh", 360)
    W_13846 = Ward("Xã Yên Phong", 13846, VietNamDivisionType.XA, "xa_yen_phong", 360)
    W_13849 = Ward("Xã Yên Ninh", 13849, VietNamDivisionType.XA, "xa_yen_ninh", 360)
    W_13852 = Ward("Xã Yên Lương", 13852, VietNamDivisionType.XA, "xa_yen_luong", 360)
    W_13855 = Ward("Xã Yên Hồng", 13855, VietNamDivisionType.XA, "xa_yen_hong", 360)
    W_13858 = Ward("Xã Yên Quang", 13858, VietNamDivisionType.XA, "xa_yen_quang", 360)
    W_13861 = Ward("Xã Yên Tiến", 13861, VietNamDivisionType.XA, "xa_yen_tien", 360)
    W_13864 = Ward("Xã Yên Thắng", 13864, VietNamDivisionType.XA, "xa_yen_thang", 360)
    W_13867 = Ward("Xã Yên Phúc", 13867, VietNamDivisionType.XA, "xa_yen_phuc", 360)
    W_13870 = Ward("Xã Yên Cường", 13870, VietNamDivisionType.XA, "xa_yen_cuong", 360)
    W_13873 = Ward("Xã Yên Lộc", 13873, VietNamDivisionType.XA, "xa_yen_loc", 360)
    W_13876 = Ward("Xã Yên Bằng", 13876, VietNamDivisionType.XA, "xa_yen_bang", 360)
    W_13879 = Ward("Xã Yên Đồng", 13879, VietNamDivisionType.XA, "xa_yen_dong", 360)
    W_13882 = Ward("Xã Yên Khang", 13882, VietNamDivisionType.XA, "xa_yen_khang", 360)
    W_13885 = Ward("Xã Yên Nhân", 13885, VietNamDivisionType.XA, "xa_yen_nhan", 360)
    W_13888 = Ward("Xã Yên Trị", 13888, VietNamDivisionType.XA, "xa_yen_tri", 360)
    W_13891 = Ward("Thị trấn Liễu Đề", 13891, VietNamDivisionType.THI_TRAN, "thi_tran_lieu_de", 361)
    W_13894 = Ward("Thị trấn Rạng Đông", 13894, VietNamDivisionType.THI_TRAN, "thi_tran_rang_dong", 361)
    W_13897 = Ward("Xã Nghĩa Đồng", 13897, VietNamDivisionType.XA, "xa_nghia_dong", 361)
    W_13900 = Ward("Xã Nghĩa Thịnh", 13900, VietNamDivisionType.XA, "xa_nghia_thinh", 361)
    W_13903 = Ward("Xã Nghĩa Minh", 13903, VietNamDivisionType.XA, "xa_nghia_minh", 361)
    W_13906 = Ward("Xã Nghĩa Thái", 13906, VietNamDivisionType.XA, "xa_nghia_thai", 361)
    W_13909 = Ward("Xã Hoàng Nam", 13909, VietNamDivisionType.XA, "xa_hoang_nam", 361)
    W_13912 = Ward("Xã Nghĩa Châu", 13912, VietNamDivisionType.XA, "xa_nghia_chau", 361)
    W_13915 = Ward("Xã Nghĩa Trung", 13915, VietNamDivisionType.XA, "xa_nghia_trung", 361)
    W_13918 = Ward("Xã Nghĩa Sơn", 13918, VietNamDivisionType.XA, "xa_nghia_son", 361)
    W_13921 = Ward("Xã Nghĩa Lạc", 13921, VietNamDivisionType.XA, "xa_nghia_lac", 361)
    W_13924 = Ward("Xã Nghĩa Hồng", 13924, VietNamDivisionType.XA, "xa_nghia_hong", 361)
    W_13927 = Ward("Xã Nghĩa Phong", 13927, VietNamDivisionType.XA, "xa_nghia_phong", 361)
    W_13930 = Ward("Xã Nghĩa Phú", 13930, VietNamDivisionType.XA, "xa_nghia_phu", 361)
    W_13933 = Ward("Xã Nghĩa Bình", 13933, VietNamDivisionType.XA, "xa_nghia_binh", 361)
    W_13936 = Ward("Thị trấn Quỹ Nhất", 13936, VietNamDivisionType.THI_TRAN, "thi_tran_quy_nhat", 361)
    W_13939 = Ward("Xã Nghĩa Tân", 13939, VietNamDivisionType.XA, "xa_nghia_tan", 361)
    W_13942 = Ward("Xã Nghĩa Hùng", 13942, VietNamDivisionType.XA, "xa_nghia_hung", 361)
    W_13945 = Ward("Xã Nghĩa Lâm", 13945, VietNamDivisionType.XA, "xa_nghia_lam", 361)
    W_13948 = Ward("Xã Nghĩa Thành", 13948, VietNamDivisionType.XA, "xa_nghia_thanh", 361)
    W_13951 = Ward("Xã Phúc Thắng", 13951, VietNamDivisionType.XA, "xa_phuc_thang", 361)
    W_13954 = Ward("Xã Nghĩa Lợi", 13954, VietNamDivisionType.XA, "xa_nghia_loi", 361)
    W_13957 = Ward("Xã Nghĩa Hải", 13957, VietNamDivisionType.XA, "xa_nghia_hai", 361)
    W_13963 = Ward("Xã Nam Điền", 13963, VietNamDivisionType.XA, "xa_nam_dien", 361)
    W_13966 = Ward("Thị trấn Nam Giang", 13966, VietNamDivisionType.THI_TRAN, "thi_tran_nam_giang", 362)
    W_13969 = Ward("Xã Nam Mỹ", 13969, VietNamDivisionType.XA, "xa_nam_my", 362)
    W_13972 = Ward("Xã Điền Xá", 13972, VietNamDivisionType.XA, "xa_dien_xa", 362)
    W_13975 = Ward("Xã Nghĩa An", 13975, VietNamDivisionType.XA, "xa_nghia_an", 362)
    W_13978 = Ward("Xã Nam Thắng", 13978, VietNamDivisionType.XA, "xa_nam_thang", 362)
    W_13981 = Ward("Xã Nam Toàn", 13981, VietNamDivisionType.XA, "xa_nam_toan", 362)
    W_13984 = Ward("Xã Hồng Quang", 13984, VietNamDivisionType.XA, "xa_hong_quang", 362)
    W_13987 = Ward("Xã Tân Thịnh", 13987, VietNamDivisionType.XA, "xa_tan_thinh", 362)
    W_13990 = Ward("Xã Nam Cường", 13990, VietNamDivisionType.XA, "xa_nam_cuong", 362)
    W_13993 = Ward("Xã Nam Hồng", 13993, VietNamDivisionType.XA, "xa_nam_hong", 362)
    W_13996 = Ward("Xã Nam Hùng", 13996, VietNamDivisionType.XA, "xa_nam_hung", 362)
    W_13999 = Ward("Xã Nam Hoa", 13999, VietNamDivisionType.XA, "xa_nam_hoa", 362)
    W_14002 = Ward("Xã Nam Dương", 14002, VietNamDivisionType.XA, "xa_nam_duong", 362)
    W_14005 = Ward("Xã Nam Thanh", 14005, VietNamDivisionType.XA, "xa_nam_thanh", 362)
    W_14008 = Ward("Xã Nam Lợi", 14008, VietNamDivisionType.XA, "xa_nam_loi", 362)
    W_14011 = Ward("Xã Bình Minh", 14011, VietNamDivisionType.XA, "xa_binh_minh", 362)
    W_14014 = Ward("Xã Đồng Sơn", 14014, VietNamDivisionType.XA, "xa_dong_son", 362)
    W_14017 = Ward("Xã Nam Tiến", 14017, VietNamDivisionType.XA, "xa_nam_tien", 362)
    W_14020 = Ward("Xã Nam Hải", 14020, VietNamDivisionType.XA, "xa_nam_hai", 362)
    W_14023 = Ward("Xã Nam Thái", 14023, VietNamDivisionType.XA, "xa_nam_thai", 362)
    W_14026 = Ward("Thị trấn Cổ Lễ", 14026, VietNamDivisionType.THI_TRAN, "thi_tran_co_le", 363)
    W_14029 = Ward("Xã Phương Định", 14029, VietNamDivisionType.XA, "xa_phuong_dinh", 363)
    W_14032 = Ward("Xã Trực Chính", 14032, VietNamDivisionType.XA, "xa_truc_chinh", 363)
    W_14035 = Ward("Xã Trung Đông", 14035, VietNamDivisionType.XA, "xa_trung_dong", 363)
    W_14038 = Ward("Xã Liêm Hải", 14038, VietNamDivisionType.XA, "xa_liem_hai", 363)
    W_14041 = Ward("Xã Trực Tuấn", 14041, VietNamDivisionType.XA, "xa_truc_tuan", 363)
    W_14044 = Ward("Xã Việt Hùng", 14044, VietNamDivisionType.XA, "xa_viet_hung", 363)
    W_14047 = Ward("Xã Trực Đạo", 14047, VietNamDivisionType.XA, "xa_truc_dao", 363)
    W_14050 = Ward("Xã Trực Hưng", 14050, VietNamDivisionType.XA, "xa_truc_hung", 363)
    W_14053 = Ward("Xã Trực Nội", 14053, VietNamDivisionType.XA, "xa_truc_noi", 363)
    W_14056 = Ward("Thị trấn Cát Thành", 14056, VietNamDivisionType.THI_TRAN, "thi_tran_cat_thanh", 363)
    W_14059 = Ward("Xã Trực Thanh", 14059, VietNamDivisionType.XA, "xa_truc_thanh", 363)
    W_14062 = Ward("Xã Trực Khang", 14062, VietNamDivisionType.XA, "xa_truc_khang", 363)
    W_14065 = Ward("Xã Trực Thuận", 14065, VietNamDivisionType.XA, "xa_truc_thuan", 363)
    W_14068 = Ward("Xã Trực Mỹ", 14068, VietNamDivisionType.XA, "xa_truc_my", 363)
    W_14071 = Ward("Xã Trực Đại", 14071, VietNamDivisionType.XA, "xa_truc_dai", 363)
    W_14074 = Ward("Xã Trực Cường", 14074, VietNamDivisionType.XA, "xa_truc_cuong", 363)
    W_14077 = Ward("Thị trấn Ninh Cường", 14077, VietNamDivisionType.THI_TRAN, "thi_tran_ninh_cuong", 363)
    W_14080 = Ward("Xã Trực Thái", 14080, VietNamDivisionType.XA, "xa_truc_thai", 363)
    W_14083 = Ward("Xã Trực Hùng", 14083, VietNamDivisionType.XA, "xa_truc_hung", 363)
    W_14086 = Ward("Xã Trực Thắng", 14086, VietNamDivisionType.XA, "xa_truc_thang", 363)
    W_14089 = Ward("Thị trấn Xuân Trường", 14089, VietNamDivisionType.THI_TRAN, "thi_tran_xuan_truong", 364)
    W_14092 = Ward("Xã Xuân Châu", 14092, VietNamDivisionType.XA, "xa_xuan_chau", 364)
    W_14095 = Ward("Xã Xuân Hồng", 14095, VietNamDivisionType.XA, "xa_xuan_hong", 364)
    W_14098 = Ward("Xã Xuân Thành", 14098, VietNamDivisionType.XA, "xa_xuan_thanh", 364)
    W_14101 = Ward("Xã Xuân Thượng", 14101, VietNamDivisionType.XA, "xa_xuan_thuong", 364)
    W_14104 = Ward("Xã Xuân Phong", 14104, VietNamDivisionType.XA, "xa_xuan_phong", 364)
    W_14107 = Ward("Xã Xuân Đài", 14107, VietNamDivisionType.XA, "xa_xuan_dai", 364)
    W_14110 = Ward("Xã Xuân Tân", 14110, VietNamDivisionType.XA, "xa_xuan_tan", 364)
    W_14113 = Ward("Xã Xuân Thủy", 14113, VietNamDivisionType.XA, "xa_xuan_thuy", 364)
    W_14116 = Ward("Xã Xuân Ngọc", 14116, VietNamDivisionType.XA, "xa_xuan_ngoc", 364)
    W_14119 = Ward("Xã Xuân Bắc", 14119, VietNamDivisionType.XA, "xa_xuan_bac", 364)
    W_14122 = Ward("Xã Xuân Phương", 14122, VietNamDivisionType.XA, "xa_xuan_phuong", 364)
    W_14125 = Ward("Xã Thọ Nghiệp", 14125, VietNamDivisionType.XA, "xa_tho_nghiep", 364)
    W_14128 = Ward("Xã Xuân Phú", 14128, VietNamDivisionType.XA, "xa_xuan_phu", 364)
    W_14131 = Ward("Xã Xuân Trung", 14131, VietNamDivisionType.XA, "xa_xuan_trung", 364)
    W_14134 = Ward("Xã Xuân Vinh", 14134, VietNamDivisionType.XA, "xa_xuan_vinh", 364)
    W_14137 = Ward("Xã Xuân Kiên", 14137, VietNamDivisionType.XA, "xa_xuan_kien", 364)
    W_14140 = Ward("Xã Xuân Tiến", 14140, VietNamDivisionType.XA, "xa_xuan_tien", 364)
    W_14143 = Ward("Xã Xuân Ninh", 14143, VietNamDivisionType.XA, "xa_xuan_ninh", 364)
    W_14146 = Ward("Xã Xuân Hòa", 14146, VietNamDivisionType.XA, "xa_xuan_hoa", 364)
    W_14149 = Ward("Thị trấn Ngô Đồng", 14149, VietNamDivisionType.THI_TRAN, "thi_tran_ngo_dong", 365)
    W_14152 = Ward("Thị trấn Quất Lâm", 14152, VietNamDivisionType.THI_TRAN, "thi_tran_quat_lam", 365)
    W_14155 = Ward("Xã Giao Hương", 14155, VietNamDivisionType.XA, "xa_giao_huong", 365)
    W_14158 = Ward("Xã Hồng Thuận", 14158, VietNamDivisionType.XA, "xa_hong_thuan", 365)
    W_14161 = Ward("Xã Giao Thiện", 14161, VietNamDivisionType.XA, "xa_giao_thien", 365)
    W_14164 = Ward("Xã Giao Thanh", 14164, VietNamDivisionType.XA, "xa_giao_thanh", 365)
    W_14167 = Ward("Xã Hoành Sơn", 14167, VietNamDivisionType.XA, "xa_hoanh_son", 365)
    W_14170 = Ward("Xã Bình Hòa", 14170, VietNamDivisionType.XA, "xa_binh_hoa", 365)
    W_14173 = Ward("Xã Giao Tiến", 14173, VietNamDivisionType.XA, "xa_giao_tien", 365)
    W_14176 = Ward("Xã Giao Hà", 14176, VietNamDivisionType.XA, "xa_giao_ha", 365)
    W_14179 = Ward("Xã Giao Nhân", 14179, VietNamDivisionType.XA, "xa_giao_nhan", 365)
    W_14182 = Ward("Xã Giao An", 14182, VietNamDivisionType.XA, "xa_giao_an", 365)
    W_14185 = Ward("Xã Giao Lạc", 14185, VietNamDivisionType.XA, "xa_giao_lac", 365)
    W_14188 = Ward("Xã Giao Châu", 14188, VietNamDivisionType.XA, "xa_giao_chau", 365)
    W_14191 = Ward("Xã Giao Tân", 14191, VietNamDivisionType.XA, "xa_giao_tan", 365)
    W_14194 = Ward("Xã Giao Yến", 14194, VietNamDivisionType.XA, "xa_giao_yen", 365)
    W_14197 = Ward("Xã Giao Xuân", 14197, VietNamDivisionType.XA, "xa_giao_xuan", 365)
    W_14200 = Ward("Xã Giao Thịnh", 14200, VietNamDivisionType.XA, "xa_giao_thinh", 365)
    W_14203 = Ward("Xã Giao Hải", 14203, VietNamDivisionType.XA, "xa_giao_hai", 365)
    W_14206 = Ward("Xã Bạch Long", 14206, VietNamDivisionType.XA, "xa_bach_long", 365)
    W_14209 = Ward("Xã Giao Long", 14209, VietNamDivisionType.XA, "xa_giao_long", 365)
    W_14212 = Ward("Xã Giao Phong", 14212, VietNamDivisionType.XA, "xa_giao_phong", 365)
    W_14215 = Ward("Thị trấn Yên Định", 14215, VietNamDivisionType.THI_TRAN, "thi_tran_yen_dinh", 366)
    W_14218 = Ward("Thị trấn Cồn", 14218, VietNamDivisionType.THI_TRAN, "thi_tran_con", 366)
    W_14221 = Ward("Thị trấn Thịnh Long", 14221, VietNamDivisionType.THI_TRAN, "thi_tran_thinh_long", 366)
    W_14224 = Ward("Xã Hải Nam", 14224, VietNamDivisionType.XA, "xa_hai_nam", 366)
    W_14227 = Ward("Xã Hải Trung", 14227, VietNamDivisionType.XA, "xa_hai_trung", 366)
    W_14230 = Ward("Xã Hải Vân", 14230, VietNamDivisionType.XA, "xa_hai_van", 366)
    W_14233 = Ward("Xã Hải Minh", 14233, VietNamDivisionType.XA, "xa_hai_minh", 366)
    W_14236 = Ward("Xã Hải Anh", 14236, VietNamDivisionType.XA, "xa_hai_anh", 366)
    W_14239 = Ward("Xã Hải Hưng", 14239, VietNamDivisionType.XA, "xa_hai_hung", 366)
    W_14242 = Ward("Xã Hải Bắc", 14242, VietNamDivisionType.XA, "xa_hai_bac", 366)
    W_14245 = Ward("Xã Hải Phúc", 14245, VietNamDivisionType.XA, "xa_hai_phuc", 366)
    W_14248 = Ward("Xã Hải Thanh", 14248, VietNamDivisionType.XA, "xa_hai_thanh", 366)
    W_14251 = Ward("Xã Hải Hà", 14251, VietNamDivisionType.XA, "xa_hai_ha", 366)
    W_14254 = Ward("Xã Hải Long", 14254, VietNamDivisionType.XA, "xa_hai_long", 366)
    W_14257 = Ward("Xã Hải Phương", 14257, VietNamDivisionType.XA, "xa_hai_phuong", 366)
    W_14260 = Ward("Xã Hải Đường", 14260, VietNamDivisionType.XA, "xa_hai_duong", 366)
    W_14263 = Ward("Xã Hải Lộc", 14263, VietNamDivisionType.XA, "xa_hai_loc", 366)
    W_14266 = Ward("Xã Hải Quang", 14266, VietNamDivisionType.XA, "xa_hai_quang", 366)
    W_14269 = Ward("Xã Hải Đông", 14269, VietNamDivisionType.XA, "xa_hai_dong", 366)
    W_14272 = Ward("Xã Hải Sơn", 14272, VietNamDivisionType.XA, "xa_hai_son", 366)
    W_14275 = Ward("Xã Hải Tân", 14275, VietNamDivisionType.XA, "xa_hai_tan", 366)
    W_14281 = Ward("Xã Hải Phong", 14281, VietNamDivisionType.XA, "xa_hai_phong", 366)
    W_14284 = Ward("Xã Hải An", 14284, VietNamDivisionType.XA, "xa_hai_an", 366)
    W_14287 = Ward("Xã Hải Tây", 14287, VietNamDivisionType.XA, "xa_hai_tay", 366)
    W_14290 = Ward("Xã Hải Lý", 14290, VietNamDivisionType.XA, "xa_hai_ly", 366)
    W_14293 = Ward("Xã Hải Phú", 14293, VietNamDivisionType.XA, "xa_hai_phu", 366)
    W_14296 = Ward("Xã Hải Giang", 14296, VietNamDivisionType.XA, "xa_hai_giang", 366)
    W_14299 = Ward("Xã Hải Cường", 14299, VietNamDivisionType.XA, "xa_hai_cuong", 366)
    W_14302 = Ward("Xã Hải Ninh", 14302, VietNamDivisionType.XA, "xa_hai_ninh", 366)
    W_14305 = Ward("Xã Hải Chính", 14305, VietNamDivisionType.XA, "xa_hai_chinh", 366)
    W_14308 = Ward("Xã Hải Xuân", 14308, VietNamDivisionType.XA, "xa_hai_xuan", 366)
    W_14311 = Ward("Xã Hải Châu", 14311, VietNamDivisionType.XA, "xa_hai_chau", 366)
    W_14314 = Ward("Xã Hải Triều", 14314, VietNamDivisionType.XA, "xa_hai_trieu", 366)
    W_14317 = Ward("Xã Hải Hòa", 14317, VietNamDivisionType.XA, "xa_hai_hoa", 366)
    W_14320 = Ward("Phường Đông Thành", 14320, VietNamDivisionType.PHUONG, "phuong_dong_thanh", 369)
    W_14323 = Ward("Phường Tân Thành", 14323, VietNamDivisionType.PHUONG, "phuong_tan_thanh", 369)
    W_14326 = Ward("Phường Thanh Bình", 14326, VietNamDivisionType.PHUONG, "phuong_thanh_binh", 369)
    W_14329 = Ward("Phường Vân Giang", 14329, VietNamDivisionType.PHUONG, "phuong_van_giang", 369)
    W_14332 = Ward("Phường Bích Đào", 14332, VietNamDivisionType.PHUONG, "phuong_bich_dao", 369)
    W_14335 = Ward("Phường Phúc Thành", 14335, VietNamDivisionType.PHUONG, "phuong_phuc_thanh", 369)
    W_14338 = Ward("Phường Nam Bình", 14338, VietNamDivisionType.PHUONG, "phuong_nam_binh", 369)
    W_14341 = Ward("Phường Nam Thành", 14341, VietNamDivisionType.PHUONG, "phuong_nam_thanh", 369)
    W_14344 = Ward("Phường Ninh Khánh", 14344, VietNamDivisionType.PHUONG, "phuong_ninh_khanh", 369)
    W_14347 = Ward("Xã Ninh Nhất", 14347, VietNamDivisionType.XA, "xa_ninh_nhat", 369)
    W_14350 = Ward("Xã Ninh Tiến", 14350, VietNamDivisionType.XA, "xa_ninh_tien", 369)
    W_14353 = Ward("Xã Ninh Phúc", 14353, VietNamDivisionType.XA, "xa_ninh_phuc", 369)
    W_14356 = Ward("Phường Ninh Sơn", 14356, VietNamDivisionType.PHUONG, "phuong_ninh_son", 369)
    W_14359 = Ward("Phường Ninh Phong", 14359, VietNamDivisionType.PHUONG, "phuong_ninh_phong", 369)
    W_14362 = Ward("Phường Bắc Sơn", 14362, VietNamDivisionType.PHUONG, "phuong_bac_son", 370)
    W_14365 = Ward("Phường Trung Sơn", 14365, VietNamDivisionType.PHUONG, "phuong_trung_son", 370)
    W_14368 = Ward("Phường Nam Sơn", 14368, VietNamDivisionType.PHUONG, "phuong_nam_son", 370)
    W_14369 = Ward("Phường Tây Sơn", 14369, VietNamDivisionType.PHUONG, "phuong_tay_son", 370)
    W_14371 = Ward("Xã Yên Sơn", 14371, VietNamDivisionType.XA, "xa_yen_son", 370)
    W_14374 = Ward("Phường Yên Bình", 14374, VietNamDivisionType.PHUONG, "phuong_yen_binh", 370)
    W_14375 = Ward("Phường Tân Bình", 14375, VietNamDivisionType.PHUONG, "phuong_tan_binh", 370)
    W_14377 = Ward("Xã Quang Sơn", 14377, VietNamDivisionType.XA, "xa_quang_son", 370)
    W_14380 = Ward("Xã Đông Sơn", 14380, VietNamDivisionType.XA, "xa_dong_son", 370)
    W_14383 = Ward("Thị trấn Nho Quan", 14383, VietNamDivisionType.THI_TRAN, "thi_tran_nho_quan", 372)
    W_14386 = Ward("Xã Xích Thổ", 14386, VietNamDivisionType.XA, "xa_xich_tho", 372)
    W_14389 = Ward("Xã Gia Lâm", 14389, VietNamDivisionType.XA, "xa_gia_lam", 372)
    W_14392 = Ward("Xã Gia Sơn", 14392, VietNamDivisionType.XA, "xa_gia_son", 372)
    W_14395 = Ward("Xã Thạch Bình", 14395, VietNamDivisionType.XA, "xa_thach_binh", 372)
    W_14398 = Ward("Xã Gia Thủy", 14398, VietNamDivisionType.XA, "xa_gia_thuy", 372)
    W_14401 = Ward("Xã Gia Tường", 14401, VietNamDivisionType.XA, "xa_gia_tuong", 372)
    W_14404 = Ward("Xã Cúc Phương", 14404, VietNamDivisionType.XA, "xa_cuc_phuong", 372)
    W_14407 = Ward("Xã Phú Sơn", 14407, VietNamDivisionType.XA, "xa_phu_son", 372)
    W_14410 = Ward("Xã Đức Long", 14410, VietNamDivisionType.XA, "xa_duc_long", 372)
    W_14413 = Ward("Xã Lạc Vân", 14413, VietNamDivisionType.XA, "xa_lac_van", 372)
    W_14416 = Ward("Xã Đồng Phong", 14416, VietNamDivisionType.XA, "xa_dong_phong", 372)
    W_14419 = Ward("Xã Yên Quang", 14419, VietNamDivisionType.XA, "xa_yen_quang", 372)
    W_14422 = Ward("Xã Lạng Phong", 14422, VietNamDivisionType.XA, "xa_lang_phong", 372)
    W_14425 = Ward("Xã Thượng Hòa", 14425, VietNamDivisionType.XA, "xa_thuong_hoa", 372)
    W_14428 = Ward("Xã Văn Phong", 14428, VietNamDivisionType.XA, "xa_van_phong", 372)
    W_14431 = Ward("Xã Văn Phương", 14431, VietNamDivisionType.XA, "xa_van_phuong", 372)
    W_14434 = Ward("Xã Thanh Lạc", 14434, VietNamDivisionType.XA, "xa_thanh_lac", 372)
    W_14437 = Ward("Xã Sơn Lai", 14437, VietNamDivisionType.XA, "xa_son_lai", 372)
    W_14440 = Ward("Xã Sơn Thành", 14440, VietNamDivisionType.XA, "xa_son_thanh", 372)
    W_14443 = Ward("Xã Văn Phú", 14443, VietNamDivisionType.XA, "xa_van_phu", 372)
    W_14446 = Ward("Xã Phú Lộc", 14446, VietNamDivisionType.XA, "xa_phu_loc", 372)
    W_14449 = Ward("Xã Kỳ Phú", 14449, VietNamDivisionType.XA, "xa_ky_phu", 372)
    W_14452 = Ward("Xã Quỳnh Lưu", 14452, VietNamDivisionType.XA, "xa_quynh_luu", 372)
    W_14455 = Ward("Xã Sơn Hà", 14455, VietNamDivisionType.XA, "xa_son_ha", 372)
    W_14458 = Ward("Xã Phú Long", 14458, VietNamDivisionType.XA, "xa_phu_long", 372)
    W_14461 = Ward("Xã Quảng Lạc", 14461, VietNamDivisionType.XA, "xa_quang_lac", 372)
    W_14464 = Ward("Thị trấn Me", 14464, VietNamDivisionType.THI_TRAN, "thi_tran_me", 373)
    W_14467 = Ward("Xã Gia Hòa", 14467, VietNamDivisionType.XA, "xa_gia_hoa", 373)
    W_14470 = Ward("Xã Gia Hưng", 14470, VietNamDivisionType.XA, "xa_gia_hung", 373)
    W_14473 = Ward("Xã Liên Sơn", 14473, VietNamDivisionType.XA, "xa_lien_son", 373)
    W_14476 = Ward("Xã Gia Thanh", 14476, VietNamDivisionType.XA, "xa_gia_thanh", 373)
    W_14479 = Ward("Xã Gia Vân", 14479, VietNamDivisionType.XA, "xa_gia_van", 373)
    W_14482 = Ward("Xã Gia Phú", 14482, VietNamDivisionType.XA, "xa_gia_phu", 373)
    W_14485 = Ward("Xã Gia Xuân", 14485, VietNamDivisionType.XA, "xa_gia_xuan", 373)
    W_14488 = Ward("Xã Gia Lập", 14488, VietNamDivisionType.XA, "xa_gia_lap", 373)
    W_14491 = Ward("Xã Gia Vượng", 14491, VietNamDivisionType.XA, "xa_gia_vuong", 373)
    W_14494 = Ward("Xã Gia Trấn", 14494, VietNamDivisionType.XA, "xa_gia_tran", 373)
    W_14497 = Ward("Xã Gia Thịnh", 14497, VietNamDivisionType.XA, "xa_gia_thinh", 373)
    W_14500 = Ward("Xã Gia Phương", 14500, VietNamDivisionType.XA, "xa_gia_phuong", 373)
    W_14503 = Ward("Xã Gia Tân", 14503, VietNamDivisionType.XA, "xa_gia_tan", 373)
    W_14506 = Ward("Xã Gia Thắng", 14506, VietNamDivisionType.XA, "xa_gia_thang", 373)
    W_14509 = Ward("Xã Gia Trung", 14509, VietNamDivisionType.XA, "xa_gia_trung", 373)
    W_14512 = Ward("Xã Gia Minh", 14512, VietNamDivisionType.XA, "xa_gia_minh", 373)
    W_14515 = Ward("Xã Gia Lạc", 14515, VietNamDivisionType.XA, "xa_gia_lac", 373)
    W_14518 = Ward("Xã Gia Tiến", 14518, VietNamDivisionType.XA, "xa_gia_tien", 373)
    W_14521 = Ward("Xã Gia Sinh", 14521, VietNamDivisionType.XA, "xa_gia_sinh", 373)
    W_14524 = Ward("Xã Gia Phong", 14524, VietNamDivisionType.XA, "xa_gia_phong", 373)
    W_14527 = Ward("Thị trấn Thiên Tôn", 14527, VietNamDivisionType.THI_TRAN, "thi_tran_thien_ton", 374)
    W_14530 = Ward("Xã Ninh Giang", 14530, VietNamDivisionType.XA, "xa_ninh_giang", 374)
    W_14533 = Ward("Xã Trường Yên", 14533, VietNamDivisionType.XA, "xa_truong_yen", 374)
    W_14536 = Ward("Xã Ninh Khang", 14536, VietNamDivisionType.XA, "xa_ninh_khang", 374)
    W_14539 = Ward("Xã Ninh Mỹ", 14539, VietNamDivisionType.XA, "xa_ninh_my", 374)
    W_14542 = Ward("Xã Ninh Hòa", 14542, VietNamDivisionType.XA, "xa_ninh_hoa", 374)
    W_14545 = Ward("Xã Ninh Xuân", 14545, VietNamDivisionType.XA, "xa_ninh_xuan", 374)
    W_14548 = Ward("Xã Ninh Hải", 14548, VietNamDivisionType.XA, "xa_ninh_hai", 374)
    W_14551 = Ward("Xã Ninh Thắng", 14551, VietNamDivisionType.XA, "xa_ninh_thang", 374)
    W_14554 = Ward("Xã Ninh Vân", 14554, VietNamDivisionType.XA, "xa_ninh_van", 374)
    W_14557 = Ward("Xã Ninh An", 14557, VietNamDivisionType.XA, "xa_ninh_an", 374)
    W_14560 = Ward("Thị trấn Yên Ninh", 14560, VietNamDivisionType.THI_TRAN, "thi_tran_yen_ninh", 375)
    W_14563 = Ward("Xã Khánh Tiên", 14563, VietNamDivisionType.XA, "xa_khanh_tien", 375)
    W_14566 = Ward("Xã Khánh Phú", 14566, VietNamDivisionType.XA, "xa_khanh_phu", 375)
    W_14569 = Ward("Xã Khánh Hòa", 14569, VietNamDivisionType.XA, "xa_khanh_hoa", 375)
    W_14572 = Ward("Xã Khánh Lợi", 14572, VietNamDivisionType.XA, "xa_khanh_loi", 375)
    W_14575 = Ward("Xã Khánh An", 14575, VietNamDivisionType.XA, "xa_khanh_an", 375)
    W_14578 = Ward("Xã Khánh Cường", 14578, VietNamDivisionType.XA, "xa_khanh_cuong", 375)
    W_14581 = Ward("Xã Khánh Cư", 14581, VietNamDivisionType.XA, "xa_khanh_cu", 375)
    W_14584 = Ward("Xã Khánh Thiện", 14584, VietNamDivisionType.XA, "xa_khanh_thien", 375)
    W_14587 = Ward("Xã Khánh Hải", 14587, VietNamDivisionType.XA, "xa_khanh_hai", 375)
    W_14590 = Ward("Xã Khánh Trung", 14590, VietNamDivisionType.XA, "xa_khanh_trung", 375)
    W_14593 = Ward("Xã Khánh Mậu", 14593, VietNamDivisionType.XA, "xa_khanh_mau", 375)
    W_14596 = Ward("Xã Khánh Vân", 14596, VietNamDivisionType.XA, "xa_khanh_van", 375)
    W_14599 = Ward("Xã Khánh Hội", 14599, VietNamDivisionType.XA, "xa_khanh_hoi", 375)
    W_14602 = Ward("Xã Khánh Công", 14602, VietNamDivisionType.XA, "xa_khanh_cong", 375)
    W_14608 = Ward("Xã Khánh Thành", 14608, VietNamDivisionType.XA, "xa_khanh_thanh", 375)
    W_14611 = Ward("Xã Khánh Nhạc", 14611, VietNamDivisionType.XA, "xa_khanh_nhac", 375)
    W_14614 = Ward("Xã Khánh Thủy", 14614, VietNamDivisionType.XA, "xa_khanh_thuy", 375)
    W_14617 = Ward("Xã Khánh Hồng", 14617, VietNamDivisionType.XA, "xa_khanh_hong", 375)
    W_14620 = Ward("Thị trấn Phát Diệm", 14620, VietNamDivisionType.THI_TRAN, "thi_tran_phat_diem", 376)
    W_14623 = Ward("Thị trấn Bình Minh", 14623, VietNamDivisionType.THI_TRAN, "thi_tran_binh_minh", 376)
    W_14629 = Ward("Xã Hồi Ninh", 14629, VietNamDivisionType.XA, "xa_hoi_ninh", 376)
    W_14632 = Ward("Xã Xuân Chính", 14632, VietNamDivisionType.XA, "xa_xuan_chinh", 376)
    W_14635 = Ward("Xã Kim Định", 14635, VietNamDivisionType.XA, "xa_kim_dinh", 376)
    W_14638 = Ward("Xã Ân Hòa", 14638, VietNamDivisionType.XA, "xa_an_hoa", 376)
    W_14641 = Ward("Xã Hùng Tiến", 14641, VietNamDivisionType.XA, "xa_hung_tien", 376)
    W_14647 = Ward("Xã Quang Thiện", 14647, VietNamDivisionType.XA, "xa_quang_thien", 376)
    W_14650 = Ward("Xã Như Hòa", 14650, VietNamDivisionType.XA, "xa_nhu_hoa", 376)
    W_14653 = Ward("Xã Chất Bình", 14653, VietNamDivisionType.XA, "xa_chat_binh", 376)
    W_14656 = Ward("Xã Đồng Hướng", 14656, VietNamDivisionType.XA, "xa_dong_huong", 376)
    W_14659 = Ward("Xã Kim Chính", 14659, VietNamDivisionType.XA, "xa_kim_chinh", 376)
    W_14662 = Ward("Xã Thượng Kiệm", 14662, VietNamDivisionType.XA, "xa_thuong_kiem", 376)
    W_14665 = Ward("Xã Lưu Phương", 14665, VietNamDivisionType.XA, "xa_luu_phuong", 376)
    W_14668 = Ward("Xã Tân Thành", 14668, VietNamDivisionType.XA, "xa_tan_thanh", 376)
    W_14671 = Ward("Xã Yên Lộc", 14671, VietNamDivisionType.XA, "xa_yen_loc", 376)
    W_14674 = Ward("Xã Lai Thành", 14674, VietNamDivisionType.XA, "xa_lai_thanh", 376)
    W_14677 = Ward("Xã Định Hóa", 14677, VietNamDivisionType.XA, "xa_dinh_hoa", 376)
    W_14680 = Ward("Xã Văn Hải", 14680, VietNamDivisionType.XA, "xa_van_hai", 376)
    W_14683 = Ward("Xã Kim Tân", 14683, VietNamDivisionType.XA, "xa_kim_tan", 376)
    W_14686 = Ward("Xã Kim Mỹ", 14686, VietNamDivisionType.XA, "xa_kim_my", 376)
    W_14689 = Ward("Xã Cồn Thoi", 14689, VietNamDivisionType.XA, "xa_con_thoi", 376)
    W_14692 = Ward("Xã Kim Hải", 14692, VietNamDivisionType.XA, "xa_kim_hai", 376)
    W_14695 = Ward("Xã Kim Trung", 14695, VietNamDivisionType.XA, "xa_kim_trung", 376)
    W_14698 = Ward("Xã Kim Đông", 14698, VietNamDivisionType.XA, "xa_kim_dong", 376)
    W_14701 = Ward("Thị trấn Yên Thịnh", 14701, VietNamDivisionType.THI_TRAN, "thi_tran_yen_thinh", 377)
    W_14704 = Ward("Xã Khánh Thượng", 14704, VietNamDivisionType.XA, "xa_khanh_thuong", 377)
    W_14707 = Ward("Xã Khánh Dương", 14707, VietNamDivisionType.XA, "xa_khanh_duong", 377)
    W_14710 = Ward("Xã Mai Sơn", 14710, VietNamDivisionType.XA, "xa_mai_son", 377)
    W_14713 = Ward("Xã Khánh Thịnh", 14713, VietNamDivisionType.XA, "xa_khanh_thinh", 377)
    W_14719 = Ward("Xã Yên Phong", 14719, VietNamDivisionType.XA, "xa_yen_phong", 377)
    W_14722 = Ward("Xã Yên Hòa", 14722, VietNamDivisionType.XA, "xa_yen_hoa", 377)
    W_14725 = Ward("Xã Yên Thắng", 14725, VietNamDivisionType.XA, "xa_yen_thang", 377)
    W_14728 = Ward("Xã Yên Từ", 14728, VietNamDivisionType.XA, "xa_yen_tu", 377)
    W_14731 = Ward("Xã Yên Hưng", 14731, VietNamDivisionType.XA, "xa_yen_hung", 377)
    W_14734 = Ward("Xã Yên Thành", 14734, VietNamDivisionType.XA, "xa_yen_thanh", 377)
    W_14737 = Ward("Xã Yên Nhân", 14737, VietNamDivisionType.XA, "xa_yen_nhan", 377)
    W_14740 = Ward("Xã Yên Mỹ", 14740, VietNamDivisionType.XA, "xa_yen_my", 377)
    W_14743 = Ward("Xã Yên Mạc", 14743, VietNamDivisionType.XA, "xa_yen_mac", 377)
    W_14746 = Ward("Xã Yên Đồng", 14746, VietNamDivisionType.XA, "xa_yen_dong", 377)
    W_14749 = Ward("Xã Yên Thái", 14749, VietNamDivisionType.XA, "xa_yen_thai", 377)
    W_14752 = Ward("Xã Yên Lâm", 14752, VietNamDivisionType.XA, "xa_yen_lam", 377)
    W_14755 = Ward("Phường Hàm Rồng", 14755, VietNamDivisionType.PHUONG, "phuong_ham_rong", 380)
    W_14758 = Ward("Phường Đông Thọ", 14758, VietNamDivisionType.PHUONG, "phuong_dong_tho", 380)
    W_14761 = Ward("Phường Nam Ngạn", 14761, VietNamDivisionType.PHUONG, "phuong_nam_ngan", 380)
    W_14764 = Ward("Phường Trường Thi", 14764, VietNamDivisionType.PHUONG, "phuong_truong_thi", 380)
    W_14767 = Ward("Phường Điện Biên", 14767, VietNamDivisionType.PHUONG, "phuong_dien_bien", 380)
    W_14770 = Ward("Phường Phú Sơn", 14770, VietNamDivisionType.PHUONG, "phuong_phu_son", 380)
    W_14773 = Ward("Phường Lam Sơn", 14773, VietNamDivisionType.PHUONG, "phuong_lam_son", 380)
    W_14776 = Ward("Phường Ba Đình", 14776, VietNamDivisionType.PHUONG, "phuong_ba_dinh", 380)
    W_14779 = Ward("Phường Ngọc Trạo", 14779, VietNamDivisionType.PHUONG, "phuong_ngoc_trao", 380)
    W_14782 = Ward("Phường Đông Vệ", 14782, VietNamDivisionType.PHUONG, "phuong_dong_ve", 380)
    W_14785 = Ward("Phường Đông Sơn", 14785, VietNamDivisionType.PHUONG, "phuong_dong_son", 380)
    W_14788 = Ward("Phường Tân Sơn", 14788, VietNamDivisionType.PHUONG, "phuong_tan_son", 380)
    W_14791 = Ward("Phường Đông Cương", 14791, VietNamDivisionType.PHUONG, "phuong_dong_cuong", 380)
    W_14794 = Ward("Phường Đông Hương", 14794, VietNamDivisionType.PHUONG, "phuong_dong_huong", 380)
    W_14797 = Ward("Phường Đông Hải", 14797, VietNamDivisionType.PHUONG, "phuong_dong_hai", 380)
    W_14800 = Ward("Phường Quảng Hưng", 14800, VietNamDivisionType.PHUONG, "phuong_quang_hung", 380)
    W_14803 = Ward("Phường Quảng Thắng", 14803, VietNamDivisionType.PHUONG, "phuong_quang_thang", 380)
    W_14806 = Ward("Phường Quảng Thành", 14806, VietNamDivisionType.PHUONG, "phuong_quang_thanh", 380)
    W_15850 = Ward("Xã Thiệu Vân", 15850, VietNamDivisionType.XA, "xa_thieu_van", 380)
    W_15856 = Ward("Phường Thiệu Khánh", 15856, VietNamDivisionType.PHUONG, "phuong_thieu_khanh", 380)
    W_15859 = Ward("Phường Thiệu Dương", 15859, VietNamDivisionType.PHUONG, "phuong_thieu_duong", 380)
    W_15913 = Ward("Phường Tào Xuyên", 15913, VietNamDivisionType.PHUONG, "phuong_tao_xuyen", 380)
    W_15922 = Ward("Phường Long Anh", 15922, VietNamDivisionType.PHUONG, "phuong_long_anh", 380)
    W_15925 = Ward("Xã Hoằng Quang", 15925, VietNamDivisionType.XA, "xa_hoang_quang", 380)
    W_15970 = Ward("Xã Hoằng Đại", 15970, VietNamDivisionType.XA, "xa_hoang_dai", 380)
    W_16396 = Ward("Phường Đông Lĩnh", 16396, VietNamDivisionType.PHUONG, "phuong_dong_linh", 380)
    W_16429 = Ward("Xã Đông Vinh", 16429, VietNamDivisionType.XA, "xa_dong_vinh", 380)
    W_16432 = Ward("Phường Đông Tân", 16432, VietNamDivisionType.PHUONG, "phuong_dong_tan", 380)
    W_16435 = Ward("Phường An Hưng", 16435, VietNamDivisionType.PHUONG, "phuong_an_hung", 380)
    W_16441 = Ward("Phường Quảng Thịnh", 16441, VietNamDivisionType.PHUONG, "phuong_quang_thinh", 380)
    W_16459 = Ward("Phường Quảng Đông", 16459, VietNamDivisionType.PHUONG, "phuong_quang_dong", 380)
    W_16507 = Ward("Phường Quảng Cát", 16507, VietNamDivisionType.PHUONG, "phuong_quang_cat", 380)
    W_16522 = Ward("Phường Quảng Phú", 16522, VietNamDivisionType.PHUONG, "phuong_quang_phu", 380)
    W_16525 = Ward("Phường Quảng Tâm", 16525, VietNamDivisionType.PHUONG, "phuong_quang_tam", 380)
    W_14809 = Ward("Phường Bắc Sơn", 14809, VietNamDivisionType.PHUONG, "phuong_bac_son", 381)
    W_14812 = Ward("Phường Ba Đình", 14812, VietNamDivisionType.PHUONG, "phuong_ba_dinh", 381)
    W_14815 = Ward("Phường Lam Sơn", 14815, VietNamDivisionType.PHUONG, "phuong_lam_son", 381)
    W_14818 = Ward("Phường Ngọc Trạo", 14818, VietNamDivisionType.PHUONG, "phuong_ngoc_trao", 381)
    W_14821 = Ward("Phường Đông Sơn", 14821, VietNamDivisionType.PHUONG, "phuong_dong_son", 381)
    W_14823 = Ward("Phường Phú Sơn", 14823, VietNamDivisionType.PHUONG, "phuong_phu_son", 381)
    W_14824 = Ward("Xã Quang Trung", 14824, VietNamDivisionType.XA, "xa_quang_trung", 381)
    W_14830 = Ward("Phường Trung Sơn", 14830, VietNamDivisionType.PHUONG, "phuong_trung_son", 382)
    W_14833 = Ward("Phường Bắc Sơn", 14833, VietNamDivisionType.PHUONG, "phuong_bac_son", 382)
    W_14836 = Ward("Phường Trường Sơn", 14836, VietNamDivisionType.PHUONG, "phuong_truong_son", 382)
    W_14839 = Ward("Phường Quảng Cư", 14839, VietNamDivisionType.PHUONG, "phuong_quang_cu", 382)
    W_14842 = Ward("Phường Quảng Tiến", 14842, VietNamDivisionType.PHUONG, "phuong_quang_tien", 382)
    W_16513 = Ward("Xã Quảng Minh", 16513, VietNamDivisionType.XA, "xa_quang_minh", 382)
    W_16516 = Ward("Xã Quảng Hùng", 16516, VietNamDivisionType.XA, "xa_quang_hung", 382)
    W_16528 = Ward("Phường Quảng Thọ", 16528, VietNamDivisionType.PHUONG, "phuong_quang_tho", 382)
    W_16531 = Ward("Phường Quảng Châu", 16531, VietNamDivisionType.PHUONG, "phuong_quang_chau", 382)
    W_16534 = Ward("Phường Quảng Vinh", 16534, VietNamDivisionType.PHUONG, "phuong_quang_vinh", 382)
    W_16537 = Ward("Xã Quảng Đại", 16537, VietNamDivisionType.XA, "xa_quang_dai", 382)
    W_14845 = Ward("Thị trấn Mường Lát", 14845, VietNamDivisionType.THI_TRAN, "thi_tran_muong_lat", 384)
    W_14848 = Ward("Xã Tam Chung", 14848, VietNamDivisionType.XA, "xa_tam_chung", 384)
    W_14854 = Ward("Xã Mường Lý", 14854, VietNamDivisionType.XA, "xa_muong_ly", 384)
    W_14857 = Ward("Xã Trung Lý", 14857, VietNamDivisionType.XA, "xa_trung_ly", 384)
    W_14860 = Ward("Xã Quang Chiểu", 14860, VietNamDivisionType.XA, "xa_quang_chieu", 384)
    W_14863 = Ward("Xã Pù Nhi", 14863, VietNamDivisionType.XA, "xa_pu_nhi", 384)
    W_14864 = Ward("Xã Nhi Sơn", 14864, VietNamDivisionType.XA, "xa_nhi_son", 384)
    W_14866 = Ward("Xã Mường Chanh", 14866, VietNamDivisionType.XA, "xa_muong_chanh", 384)
    W_14869 = Ward("Thị trấn Hồi Xuân", 14869, VietNamDivisionType.THI_TRAN, "thi_tran_hoi_xuan", 385)
    W_14872 = Ward("Xã Thành Sơn", 14872, VietNamDivisionType.XA, "xa_thanh_son", 385)
    W_14875 = Ward("Xã Trung Sơn", 14875, VietNamDivisionType.XA, "xa_trung_son", 385)
    W_14878 = Ward("Xã Phú Thanh", 14878, VietNamDivisionType.XA, "xa_phu_thanh", 385)
    W_14881 = Ward("Xã Trung Thành", 14881, VietNamDivisionType.XA, "xa_trung_thanh", 385)
    W_14884 = Ward("Xã Phú Lệ", 14884, VietNamDivisionType.XA, "xa_phu_le", 385)
    W_14887 = Ward("Xã Phú Sơn", 14887, VietNamDivisionType.XA, "xa_phu_son", 385)
    W_14890 = Ward("Xã Phú Xuân", 14890, VietNamDivisionType.XA, "xa_phu_xuan", 385)
    W_14896 = Ward("Xã Hiền Chung", 14896, VietNamDivisionType.XA, "xa_hien_chung", 385)
    W_14899 = Ward("Xã Hiền Kiệt", 14899, VietNamDivisionType.XA, "xa_hien_kiet", 385)
    W_14902 = Ward("Xã Nam Tiến", 14902, VietNamDivisionType.XA, "xa_nam_tien", 385)
    W_14908 = Ward("Xã Thiên Phủ", 14908, VietNamDivisionType.XA, "xa_thien_phu", 385)
    W_14911 = Ward("Xã Phú Nghiêm", 14911, VietNamDivisionType.XA, "xa_phu_nghiem", 385)
    W_14914 = Ward("Xã Nam Xuân", 14914, VietNamDivisionType.XA, "xa_nam_xuan", 385)
    W_14917 = Ward("Xã Nam Động", 14917, VietNamDivisionType.XA, "xa_nam_dong", 385)
    W_14923 = Ward("Thị trấn Cành Nàng", 14923, VietNamDivisionType.THI_TRAN, "thi_tran_canh_nang", 386)
    W_14926 = Ward("Xã Điền Thượng", 14926, VietNamDivisionType.XA, "xa_dien_thuong", 386)
    W_14929 = Ward("Xã Điền Hạ", 14929, VietNamDivisionType.XA, "xa_dien_ha", 386)
    W_14932 = Ward("Xã Điền Quang", 14932, VietNamDivisionType.XA, "xa_dien_quang", 386)
    W_14935 = Ward("Xã Điền Trung", 14935, VietNamDivisionType.XA, "xa_dien_trung", 386)
    W_14938 = Ward("Xã Thành Sơn", 14938, VietNamDivisionType.XA, "xa_thanh_son", 386)
    W_14941 = Ward("Xã Lương Ngoại", 14941, VietNamDivisionType.XA, "xa_luong_ngoai", 386)
    W_14944 = Ward("Xã Ái Thượng", 14944, VietNamDivisionType.XA, "xa_ai_thuong", 386)
    W_14947 = Ward("Xã Lương Nội", 14947, VietNamDivisionType.XA, "xa_luong_noi", 386)
    W_14950 = Ward("Xã Điền Lư", 14950, VietNamDivisionType.XA, "xa_dien_lu", 386)
    W_14953 = Ward("Xã Lương Trung", 14953, VietNamDivisionType.XA, "xa_luong_trung", 386)
    W_14956 = Ward("Xã Lũng Niêm", 14956, VietNamDivisionType.XA, "xa_lung_niem", 386)
    W_14959 = Ward("Xã Lũng Cao", 14959, VietNamDivisionType.XA, "xa_lung_cao", 386)
    W_14962 = Ward("Xã Hạ Trung", 14962, VietNamDivisionType.XA, "xa_ha_trung", 386)
    W_14965 = Ward("Xã Cổ Lũng", 14965, VietNamDivisionType.XA, "xa_co_lung", 386)
    W_14968 = Ward("Xã Thành Lâm", 14968, VietNamDivisionType.XA, "xa_thanh_lam", 386)
    W_14971 = Ward("Xã Ban Công", 14971, VietNamDivisionType.XA, "xa_ban_cong", 386)
    W_14974 = Ward("Xã Kỳ Tân", 14974, VietNamDivisionType.XA, "xa_ky_tan", 386)
    W_14977 = Ward("Xã Văn Nho", 14977, VietNamDivisionType.XA, "xa_van_nho", 386)
    W_14980 = Ward("Xã Thiết Ống", 14980, VietNamDivisionType.XA, "xa_thiet_ong", 386)
    W_14986 = Ward("Xã Thiết Kế", 14986, VietNamDivisionType.XA, "xa_thiet_ke", 386)
    W_14995 = Ward("Xã Trung Xuân", 14995, VietNamDivisionType.XA, "xa_trung_xuan", 387)
    W_14998 = Ward("Xã Trung Thượng", 14998, VietNamDivisionType.XA, "xa_trung_thuong", 387)
    W_14999 = Ward("Xã Trung Tiến", 14999, VietNamDivisionType.XA, "xa_trung_tien", 387)
    W_15001 = Ward("Xã Trung Hạ", 15001, VietNamDivisionType.XA, "xa_trung_ha", 387)
    W_15004 = Ward("Xã Sơn Hà", 15004, VietNamDivisionType.XA, "xa_son_ha", 387)
    W_15007 = Ward("Xã Tam Thanh", 15007, VietNamDivisionType.XA, "xa_tam_thanh", 387)
    W_15010 = Ward("Xã Sơn Thủy", 15010, VietNamDivisionType.XA, "xa_son_thuy", 387)
    W_15013 = Ward("Xã Na Mèo", 15013, VietNamDivisionType.XA, "xa_na_meo", 387)
    W_15016 = Ward("Thị trấn Sơn Lư", 15016, VietNamDivisionType.THI_TRAN, "thi_tran_son_lu", 387)
    W_15019 = Ward("Xã Tam Lư", 15019, VietNamDivisionType.XA, "xa_tam_lu", 387)
    W_15022 = Ward("Xã Sơn Điện", 15022, VietNamDivisionType.XA, "xa_son_dien", 387)
    W_15025 = Ward("Xã Mường Mìn", 15025, VietNamDivisionType.XA, "xa_muong_min", 387)
    W_15031 = Ward("Xã Yên Khương", 15031, VietNamDivisionType.XA, "xa_yen_khuong", 388)
    W_15034 = Ward("Xã Yên Thắng", 15034, VietNamDivisionType.XA, "xa_yen_thang", 388)
    W_15037 = Ward("Xã Trí Nang", 15037, VietNamDivisionType.XA, "xa_tri_nang", 388)
    W_15040 = Ward("Xã Giao An", 15040, VietNamDivisionType.XA, "xa_giao_an", 388)
    W_15043 = Ward("Xã Giao Thiện", 15043, VietNamDivisionType.XA, "xa_giao_thien", 388)
    W_15046 = Ward("Xã Tân Phúc", 15046, VietNamDivisionType.XA, "xa_tan_phuc", 388)
    W_15049 = Ward("Xã Tam Văn", 15049, VietNamDivisionType.XA, "xa_tam_van", 388)
    W_15052 = Ward("Xã Lâm Phú", 15052, VietNamDivisionType.XA, "xa_lam_phu", 388)
    W_15055 = Ward("Thị trấn Lang Chánh", 15055, VietNamDivisionType.THI_TRAN, "thi_tran_lang_chanh", 388)
    W_15058 = Ward("Xã Đồng Lương", 15058, VietNamDivisionType.XA, "xa_dong_luong", 388)
    W_15061 = Ward("Thị trấn Ngọc Lặc", 15061, VietNamDivisionType.THI_TRAN, "thi_tran_ngoc_lac", 389)
    W_15064 = Ward("Xã Lam Sơn", 15064, VietNamDivisionType.XA, "xa_lam_son", 389)
    W_15067 = Ward("Xã Mỹ Tân", 15067, VietNamDivisionType.XA, "xa_my_tan", 389)
    W_15070 = Ward("Xã Thúy Sơn", 15070, VietNamDivisionType.XA, "xa_thuy_son", 389)
    W_15073 = Ward("Xã Thạch Lập", 15073, VietNamDivisionType.XA, "xa_thach_lap", 389)
    W_15076 = Ward("Xã Vân Âm", 15076, VietNamDivisionType.XA, "xa_van_am", 389)
    W_15079 = Ward("Xã Cao Ngọc", 15079, VietNamDivisionType.XA, "xa_cao_ngoc", 389)
    W_15085 = Ward("Xã Quang Trung", 15085, VietNamDivisionType.XA, "xa_quang_trung", 389)
    W_15088 = Ward("Xã Đồng Thịnh", 15088, VietNamDivisionType.XA, "xa_dong_thinh", 389)
    W_15091 = Ward("Xã Ngọc Liên", 15091, VietNamDivisionType.XA, "xa_ngoc_lien", 389)
    W_15094 = Ward("Xã Ngọc Sơn", 15094, VietNamDivisionType.XA, "xa_ngoc_son", 389)
    W_15097 = Ward("Xã Lộc Thịnh", 15097, VietNamDivisionType.XA, "xa_loc_thinh", 389)
    W_15100 = Ward("Xã Cao Thịnh", 15100, VietNamDivisionType.XA, "xa_cao_thinh", 389)
    W_15103 = Ward("Xã Ngọc Trung", 15103, VietNamDivisionType.XA, "xa_ngoc_trung", 389)
    W_15106 = Ward("Xã Phùng Giáo", 15106, VietNamDivisionType.XA, "xa_phung_giao", 389)
    W_15109 = Ward("Xã Phùng Minh", 15109, VietNamDivisionType.XA, "xa_phung_minh", 389)
    W_15112 = Ward("Xã Phúc Thịnh", 15112, VietNamDivisionType.XA, "xa_phuc_thinh", 389)
    W_15115 = Ward("Xã Nguyệt Ấn", 15115, VietNamDivisionType.XA, "xa_nguyet_an", 389)
    W_15118 = Ward("Xã Kiên Thọ", 15118, VietNamDivisionType.XA, "xa_kien_tho", 389)
    W_15121 = Ward("Xã Minh Tiến", 15121, VietNamDivisionType.XA, "xa_minh_tien", 389)
    W_15124 = Ward("Xã Minh Sơn", 15124, VietNamDivisionType.XA, "xa_minh_son", 389)
    W_15127 = Ward("Thị trấn Phong Sơn", 15127, VietNamDivisionType.THI_TRAN, "thi_tran_phong_son", 390)
    W_15133 = Ward("Xã Cẩm Thành", 15133, VietNamDivisionType.XA, "xa_cam_thanh", 390)
    W_15136 = Ward("Xã Cẩm Quý", 15136, VietNamDivisionType.XA, "xa_cam_quy", 390)
    W_15139 = Ward("Xã Cẩm Lương", 15139, VietNamDivisionType.XA, "xa_cam_luong", 390)
    W_15142 = Ward("Xã Cẩm Thạch", 15142, VietNamDivisionType.XA, "xa_cam_thach", 390)
    W_15145 = Ward("Xã Cẩm Liên", 15145, VietNamDivisionType.XA, "xa_cam_lien", 390)
    W_15148 = Ward("Xã Cẩm Giang", 15148, VietNamDivisionType.XA, "xa_cam_giang", 390)
    W_15151 = Ward("Xã Cẩm Bình", 15151, VietNamDivisionType.XA, "xa_cam_binh", 390)
    W_15154 = Ward("Xã Cẩm Tú", 15154, VietNamDivisionType.XA, "xa_cam_tu", 390)
    W_15160 = Ward("Xã Cẩm Châu", 15160, VietNamDivisionType.XA, "xa_cam_chau", 390)
    W_15163 = Ward("Xã Cẩm Tâm", 15163, VietNamDivisionType.XA, "xa_cam_tam", 390)
    W_15169 = Ward("Xã Cẩm Ngọc", 15169, VietNamDivisionType.XA, "xa_cam_ngoc", 390)
    W_15172 = Ward("Xã Cẩm Long", 15172, VietNamDivisionType.XA, "xa_cam_long", 390)
    W_15175 = Ward("Xã Cẩm Yên", 15175, VietNamDivisionType.XA, "xa_cam_yen", 390)
    W_15178 = Ward("Xã Cẩm Tân", 15178, VietNamDivisionType.XA, "xa_cam_tan", 390)
    W_15181 = Ward("Xã Cẩm Phú", 15181, VietNamDivisionType.XA, "xa_cam_phu", 390)
    W_15184 = Ward("Xã Cẩm Vân", 15184, VietNamDivisionType.XA, "xa_cam_van", 390)
    W_15187 = Ward("Thị trấn Kim Tân", 15187, VietNamDivisionType.THI_TRAN, "thi_tran_kim_tan", 391)
    W_15190 = Ward("Thị trấn Vân Du", 15190, VietNamDivisionType.THI_TRAN, "thi_tran_van_du", 391)
    W_15196 = Ward("Xã Thạch Lâm", 15196, VietNamDivisionType.XA, "xa_thach_lam", 391)
    W_15199 = Ward("Xã Thạch Quảng", 15199, VietNamDivisionType.XA, "xa_thach_quang", 391)
    W_15202 = Ward("Xã Thạch Tượng", 15202, VietNamDivisionType.XA, "xa_thach_tuong", 391)
    W_15205 = Ward("Xã Thạch Cẩm", 15205, VietNamDivisionType.XA, "xa_thach_cam", 391)
    W_15208 = Ward("Xã Thạch Sơn", 15208, VietNamDivisionType.XA, "xa_thach_son", 391)
    W_15211 = Ward("Xã Thạch Bình", 15211, VietNamDivisionType.XA, "xa_thach_binh", 391)
    W_15214 = Ward("Xã Thạch Định", 15214, VietNamDivisionType.XA, "xa_thach_dinh", 391)
    W_15217 = Ward("Xã Thạch Đồng", 15217, VietNamDivisionType.XA, "xa_thach_dong", 391)
    W_15220 = Ward("Xã Thạch Long", 15220, VietNamDivisionType.XA, "xa_thach_long", 391)
    W_15223 = Ward("Xã Thành Mỹ", 15223, VietNamDivisionType.XA, "xa_thanh_my", 391)
    W_15226 = Ward("Xã Thành Yên", 15226, VietNamDivisionType.XA, "xa_thanh_yen", 391)
    W_15229 = Ward("Xã Thành Vinh", 15229, VietNamDivisionType.XA, "xa_thanh_vinh", 391)
    W_15232 = Ward("Xã Thành Minh", 15232, VietNamDivisionType.XA, "xa_thanh_minh", 391)
    W_15235 = Ward("Xã Thành Công", 15235, VietNamDivisionType.XA, "xa_thanh_cong", 391)
    W_15238 = Ward("Xã Thành Tân", 15238, VietNamDivisionType.XA, "xa_thanh_tan", 391)
    W_15241 = Ward("Xã Thành Trực", 15241, VietNamDivisionType.XA, "xa_thanh_truc", 391)
    W_15247 = Ward("Xã Thành Tâm", 15247, VietNamDivisionType.XA, "xa_thanh_tam", 391)
    W_15250 = Ward("Xã Thành An", 15250, VietNamDivisionType.XA, "xa_thanh_an", 391)
    W_15253 = Ward("Xã Thành Thọ", 15253, VietNamDivisionType.XA, "xa_thanh_tho", 391)
    W_15256 = Ward("Xã Thành Tiến", 15256, VietNamDivisionType.XA, "xa_thanh_tien", 391)
    W_15259 = Ward("Xã Thành Long", 15259, VietNamDivisionType.XA, "xa_thanh_long", 391)
    W_15265 = Ward("Xã Thành Hưng", 15265, VietNamDivisionType.XA, "xa_thanh_hung", 391)
    W_15268 = Ward("Xã Ngọc Trạo", 15268, VietNamDivisionType.XA, "xa_ngoc_trao", 391)
    W_15271 = Ward("Thị trấn Hà Trung", 15271, VietNamDivisionType.THI_TRAN, "thi_tran_ha_trung", 392)
    W_15274 = Ward("Xã Hà Long", 15274, VietNamDivisionType.XA, "xa_ha_long", 392)
    W_15277 = Ward("Xã Hà Vinh", 15277, VietNamDivisionType.XA, "xa_ha_vinh", 392)
    W_15280 = Ward("Xã Hà Bắc", 15280, VietNamDivisionType.XA, "xa_ha_bac", 392)
    W_15283 = Ward("Xã Hoạt Giang", 15283, VietNamDivisionType.XA, "xa_hoat_giang", 392)
    W_15286 = Ward("Xã Yên Dương", 15286, VietNamDivisionType.XA, "xa_yen_duong", 392)
    W_15292 = Ward("Xã Hà Giang", 15292, VietNamDivisionType.XA, "xa_ha_giang", 392)
    W_15298 = Ward("Xã Lĩnh Toại", 15298, VietNamDivisionType.XA, "xa_linh_toai", 392)
    W_15304 = Ward("Xã Hà Ngọc", 15304, VietNamDivisionType.XA, "xa_ha_ngoc", 392)
    W_15307 = Ward("Xã Yến Sơn", 15307, VietNamDivisionType.XA, "xa_yen_son", 392)
    W_15313 = Ward("Xã Hà Sơn", 15313, VietNamDivisionType.XA, "xa_ha_son", 392)
    W_15316 = Ward("Xã Hà Lĩnh", 15316, VietNamDivisionType.XA, "xa_ha_linh", 392)
    W_15319 = Ward("Xã Hà Đông", 15319, VietNamDivisionType.XA, "xa_ha_dong", 392)
    W_15322 = Ward("Xã Hà Tân", 15322, VietNamDivisionType.XA, "xa_ha_tan", 392)
    W_15325 = Ward("Xã Hà Tiến", 15325, VietNamDivisionType.XA, "xa_ha_tien", 392)
    W_15328 = Ward("Xã Hà Bình", 15328, VietNamDivisionType.XA, "xa_ha_binh", 392)
    W_15331 = Ward("Xã Hà Lai", 15331, VietNamDivisionType.XA, "xa_ha_lai", 392)
    W_15334 = Ward("Xã Hà Châu", 15334, VietNamDivisionType.XA, "xa_ha_chau", 392)
    W_15340 = Ward("Xã Hà Thái", 15340, VietNamDivisionType.XA, "xa_ha_thai", 392)
    W_15343 = Ward("Xã Hà Hải", 15343, VietNamDivisionType.XA, "xa_ha_hai", 392)
    W_15349 = Ward("Thị trấn Vĩnh Lộc", 15349, VietNamDivisionType.THI_TRAN, "thi_tran_vinh_loc", 393)
    W_15352 = Ward("Xã Vĩnh Quang", 15352, VietNamDivisionType.XA, "xa_vinh_quang", 393)
    W_15355 = Ward("Xã Vĩnh Yên", 15355, VietNamDivisionType.XA, "xa_vinh_yen", 393)
    W_15358 = Ward("Xã Vĩnh Tiến", 15358, VietNamDivisionType.XA, "xa_vinh_tien", 393)
    W_15361 = Ward("Xã Vĩnh Long", 15361, VietNamDivisionType.XA, "xa_vinh_long", 393)
    W_15364 = Ward("Xã Vĩnh Phúc", 15364, VietNamDivisionType.XA, "xa_vinh_phuc", 393)
    W_15367 = Ward("Xã Vĩnh Hưng", 15367, VietNamDivisionType.XA, "xa_vinh_hung", 393)
    W_15376 = Ward("Xã Vĩnh Hòa", 15376, VietNamDivisionType.XA, "xa_vinh_hoa", 393)
    W_15379 = Ward("Xã Vĩnh Hùng", 15379, VietNamDivisionType.XA, "xa_vinh_hung", 393)
    W_15382 = Ward("Xã Minh Tân", 15382, VietNamDivisionType.XA, "xa_minh_tan", 393)
    W_15385 = Ward("Xã Ninh Khang", 15385, VietNamDivisionType.XA, "xa_ninh_khang", 393)
    W_15388 = Ward("Xã Vĩnh Thịnh", 15388, VietNamDivisionType.XA, "xa_vinh_thinh", 393)
    W_15391 = Ward("Xã Vĩnh An", 15391, VietNamDivisionType.XA, "xa_vinh_an", 393)
    W_15397 = Ward("Thị trấn Thống Nhất", 15397, VietNamDivisionType.THI_TRAN, "thi_tran_thong_nhat", 394)
    W_15403 = Ward("Xã Yên Lâm", 15403, VietNamDivisionType.XA, "xa_yen_lam", 394)
    W_15406 = Ward("Xã Yên Tâm", 15406, VietNamDivisionType.XA, "xa_yen_tam", 394)
    W_15409 = Ward("Xã Yên Phú", 15409, VietNamDivisionType.XA, "xa_yen_phu", 394)
    W_15412 = Ward("Xã Quí Lộc", 15412, VietNamDivisionType.XA, "xa_qui_loc", 394)
    W_15415 = Ward("Xã Yên Thọ", 15415, VietNamDivisionType.XA, "xa_yen_tho", 394)
    W_15418 = Ward("Xã Yên Trung", 15418, VietNamDivisionType.XA, "xa_yen_trung", 394)
    W_15421 = Ward("Xã Yên Trường", 15421, VietNamDivisionType.XA, "xa_yen_truong", 394)
    W_15427 = Ward("Xã Yên Phong", 15427, VietNamDivisionType.XA, "xa_yen_phong", 394)
    W_15430 = Ward("Xã Yên Thái", 15430, VietNamDivisionType.XA, "xa_yen_thai", 394)
    W_15433 = Ward("Xã Yên Hùng", 15433, VietNamDivisionType.XA, "xa_yen_hung", 394)
    W_15436 = Ward("Xã Yên Thịnh", 15436, VietNamDivisionType.XA, "xa_yen_thinh", 394)
    W_15439 = Ward("Xã Yên Ninh", 15439, VietNamDivisionType.XA, "xa_yen_ninh", 394)
    W_15442 = Ward("Xã Yên Lạc", 15442, VietNamDivisionType.XA, "xa_yen_lac", 394)
    W_15445 = Ward("Xã Định Tăng", 15445, VietNamDivisionType.XA, "xa_dinh_tang", 394)
    W_15448 = Ward("Xã Định Hòa", 15448, VietNamDivisionType.XA, "xa_dinh_hoa", 394)
    W_15451 = Ward("Xã Định Thành", 15451, VietNamDivisionType.XA, "xa_dinh_thanh", 394)
    W_15454 = Ward("Xã Định Công", 15454, VietNamDivisionType.XA, "xa_dinh_cong", 394)
    W_15457 = Ward("Xã Định Tân", 15457, VietNamDivisionType.XA, "xa_dinh_tan", 394)
    W_15460 = Ward("Xã Định Tiến", 15460, VietNamDivisionType.XA, "xa_dinh_tien", 394)
    W_15463 = Ward("Xã Định Long", 15463, VietNamDivisionType.XA, "xa_dinh_long", 394)
    W_15466 = Ward("Xã Định Liên", 15466, VietNamDivisionType.XA, "xa_dinh_lien", 394)
    W_15469 = Ward("Thị trấn Quán Lào", 15469, VietNamDivisionType.THI_TRAN, "thi_tran_quan_lao", 394)
    W_15472 = Ward("Xã Định Hưng", 15472, VietNamDivisionType.XA, "xa_dinh_hung", 394)
    W_15475 = Ward("Xã Định Hải", 15475, VietNamDivisionType.XA, "xa_dinh_hai", 394)
    W_15478 = Ward("Xã Định Bình", 15478, VietNamDivisionType.XA, "xa_dinh_binh", 394)
    W_15493 = Ward("Xã Xuân Hồng", 15493, VietNamDivisionType.XA, "xa_xuan_hong", 395)
    W_15499 = Ward("Thị trấn Thọ Xuân", 15499, VietNamDivisionType.THI_TRAN, "thi_tran_tho_xuan", 395)
    W_15502 = Ward("Xã Bắc Lương", 15502, VietNamDivisionType.XA, "xa_bac_luong", 395)
    W_15505 = Ward("Xã Nam Giang", 15505, VietNamDivisionType.XA, "xa_nam_giang", 395)
    W_15508 = Ward("Xã Xuân Phong", 15508, VietNamDivisionType.XA, "xa_xuan_phong", 395)
    W_15511 = Ward("Xã Thọ Lộc", 15511, VietNamDivisionType.XA, "xa_tho_loc", 395)
    W_15514 = Ward("Xã Xuân Trường", 15514, VietNamDivisionType.XA, "xa_xuan_truong", 395)
    W_15517 = Ward("Xã Xuân Hòa", 15517, VietNamDivisionType.XA, "xa_xuan_hoa", 395)
    W_15520 = Ward("Xã Thọ Hải", 15520, VietNamDivisionType.XA, "xa_tho_hai", 395)
    W_15523 = Ward("Xã Tây Hồ", 15523, VietNamDivisionType.XA, "xa_tay_ho", 395)
    W_15526 = Ward("Xã Xuân Giang", 15526, VietNamDivisionType.XA, "xa_xuan_giang", 395)
    W_15532 = Ward("Xã Xuân Sinh", 15532, VietNamDivisionType.XA, "xa_xuan_sinh", 395)
    W_15535 = Ward("Xã Xuân Hưng", 15535, VietNamDivisionType.XA, "xa_xuan_hung", 395)
    W_15538 = Ward("Xã Thọ Diên", 15538, VietNamDivisionType.XA, "xa_tho_dien", 395)
    W_15541 = Ward("Xã Thọ Lâm", 15541, VietNamDivisionType.XA, "xa_tho_lam", 395)
    W_15544 = Ward("Xã Thọ Xương", 15544, VietNamDivisionType.XA, "xa_tho_xuong", 395)
    W_15547 = Ward("Xã Xuân Bái", 15547, VietNamDivisionType.XA, "xa_xuan_bai", 395)
    W_15550 = Ward("Xã Xuân Phú", 15550, VietNamDivisionType.XA, "xa_xuan_phu", 395)
    W_15553 = Ward("Thị trấn Sao Vàng", 15553, VietNamDivisionType.THI_TRAN, "thi_tran_sao_vang", 395)
    W_15556 = Ward("Thị trấn Lam Sơn", 15556, VietNamDivisionType.THI_TRAN, "thi_tran_lam_son", 395)
    W_15559 = Ward("Xã Xuân Thiên", 15559, VietNamDivisionType.XA, "xa_xuan_thien", 395)
    W_15565 = Ward("Xã Thuận Minh", 15565, VietNamDivisionType.XA, "xa_thuan_minh", 395)
    W_15568 = Ward("Xã Thọ Lập", 15568, VietNamDivisionType.XA, "xa_tho_lap", 395)
    W_15571 = Ward("Xã Quảng Phú", 15571, VietNamDivisionType.XA, "xa_quang_phu", 395)
    W_15574 = Ward("Xã Xuân Tín", 15574, VietNamDivisionType.XA, "xa_xuan_tin", 395)
    W_15577 = Ward("Xã Phú Xuân", 15577, VietNamDivisionType.XA, "xa_phu_xuan", 395)
    W_15583 = Ward("Xã Xuân Lai", 15583, VietNamDivisionType.XA, "xa_xuan_lai", 395)
    W_15586 = Ward("Xã Xuân Lập", 15586, VietNamDivisionType.XA, "xa_xuan_lap", 395)
    W_15592 = Ward("Xã Xuân Minh", 15592, VietNamDivisionType.XA, "xa_xuan_minh", 395)
    W_15598 = Ward("Xã Trường Xuân", 15598, VietNamDivisionType.XA, "xa_truong_xuan", 395)
    W_15607 = Ward("Xã Bát Mọt", 15607, VietNamDivisionType.XA, "xa_bat_mot", 396)
    W_15610 = Ward("Xã Yên Nhân", 15610, VietNamDivisionType.XA, "xa_yen_nhan", 396)
    W_15619 = Ward("Xã Xuân Lẹ", 15619, VietNamDivisionType.XA, "xa_xuan_le", 396)
    W_15622 = Ward("Xã Vạn Xuân", 15622, VietNamDivisionType.XA, "xa_van_xuan", 396)
    W_15628 = Ward("Xã Lương Sơn", 15628, VietNamDivisionType.XA, "xa_luong_son", 396)
    W_15631 = Ward("Xã Xuân Cao", 15631, VietNamDivisionType.XA, "xa_xuan_cao", 396)
    W_15634 = Ward("Xã Luận Thành", 15634, VietNamDivisionType.XA, "xa_luan_thanh", 396)
    W_15637 = Ward("Xã Luận Khê", 15637, VietNamDivisionType.XA, "xa_luan_khe", 396)
    W_15640 = Ward("Xã Xuân Thắng", 15640, VietNamDivisionType.XA, "xa_xuan_thang", 396)
    W_15643 = Ward("Xã Xuân Lộc", 15643, VietNamDivisionType.XA, "xa_xuan_loc", 396)
    W_15646 = Ward("Thị trấn Thường Xuân", 15646, VietNamDivisionType.THI_TRAN, "thi_tran_thuong_xuan", 396)
    W_15649 = Ward("Xã Xuân Dương", 15649, VietNamDivisionType.XA, "xa_xuan_duong", 396)
    W_15652 = Ward("Xã Thọ Thanh", 15652, VietNamDivisionType.XA, "xa_tho_thanh", 396)
    W_15655 = Ward("Xã Ngọc Phụng", 15655, VietNamDivisionType.XA, "xa_ngoc_phung", 396)
    W_15658 = Ward("Xã Xuân Chinh", 15658, VietNamDivisionType.XA, "xa_xuan_chinh", 396)
    W_15661 = Ward("Xã Tân Thành", 15661, VietNamDivisionType.XA, "xa_tan_thanh", 396)
    W_15664 = Ward("Thị trấn Triệu Sơn", 15664, VietNamDivisionType.THI_TRAN, "thi_tran_trieu_son", 397)
    W_15667 = Ward("Xã Thọ Sơn", 15667, VietNamDivisionType.XA, "xa_tho_son", 397)
    W_15670 = Ward("Xã Thọ Bình", 15670, VietNamDivisionType.XA, "xa_tho_binh", 397)
    W_15673 = Ward("Xã Thọ Tiến", 15673, VietNamDivisionType.XA, "xa_tho_tien", 397)
    W_15676 = Ward("Xã Hợp Lý", 15676, VietNamDivisionType.XA, "xa_hop_ly", 397)
    W_15679 = Ward("Xã Hợp Tiến", 15679, VietNamDivisionType.XA, "xa_hop_tien", 397)
    W_15682 = Ward("Xã Hợp Thành", 15682, VietNamDivisionType.XA, "xa_hop_thanh", 397)
    W_15685 = Ward("Xã Triệu Thành", 15685, VietNamDivisionType.XA, "xa_trieu_thanh", 397)
    W_15688 = Ward("Xã Hợp Thắng", 15688, VietNamDivisionType.XA, "xa_hop_thang", 397)
    W_15691 = Ward("Xã Minh Sơn", 15691, VietNamDivisionType.XA, "xa_minh_son", 397)
    W_15700 = Ward("Xã Dân Lực", 15700, VietNamDivisionType.XA, "xa_dan_luc", 397)
    W_15703 = Ward("Xã Dân Lý", 15703, VietNamDivisionType.XA, "xa_dan_ly", 397)
    W_15706 = Ward("Xã Dân Quyền", 15706, VietNamDivisionType.XA, "xa_dan_quyen", 397)
    W_15709 = Ward("Xã An Nông", 15709, VietNamDivisionType.XA, "xa_an_nong", 397)
    W_15712 = Ward("Xã Văn Sơn", 15712, VietNamDivisionType.XA, "xa_van_son", 397)
    W_15715 = Ward("Xã Thái Hòa", 15715, VietNamDivisionType.XA, "xa_thai_hoa", 397)
    W_15718 = Ward("Thị trấn Nưa", 15718, VietNamDivisionType.THI_TRAN, "thi_tran_nua", 397)
    W_15721 = Ward("Xã Đồng Lợi", 15721, VietNamDivisionType.XA, "xa_dong_loi", 397)
    W_15724 = Ward("Xã Đồng Tiến", 15724, VietNamDivisionType.XA, "xa_dong_tien", 397)
    W_15727 = Ward("Xã Đồng Thắng", 15727, VietNamDivisionType.XA, "xa_dong_thang", 397)
    W_15730 = Ward("Xã Tiến Nông", 15730, VietNamDivisionType.XA, "xa_tien_nong", 397)
    W_15733 = Ward("Xã Khuyến Nông", 15733, VietNamDivisionType.XA, "xa_khuyen_nong", 397)
    W_15736 = Ward("Xã Xuân Thịnh", 15736, VietNamDivisionType.XA, "xa_xuan_thinh", 397)
    W_15739 = Ward("Xã Xuân Lộc", 15739, VietNamDivisionType.XA, "xa_xuan_loc", 397)
    W_15742 = Ward("Xã Thọ Dân", 15742, VietNamDivisionType.XA, "xa_tho_dan", 397)
    W_15745 = Ward("Xã Xuân Thọ", 15745, VietNamDivisionType.XA, "xa_xuan_tho", 397)
    W_15748 = Ward("Xã Thọ Tân", 15748, VietNamDivisionType.XA, "xa_tho_tan", 397)
    W_15751 = Ward("Xã Thọ Ngọc", 15751, VietNamDivisionType.XA, "xa_tho_ngoc", 397)
    W_15754 = Ward("Xã Thọ Cường", 15754, VietNamDivisionType.XA, "xa_tho_cuong", 397)
    W_15757 = Ward("Xã Thọ Phú", 15757, VietNamDivisionType.XA, "xa_tho_phu", 397)
    W_15760 = Ward("Xã Thọ Vực", 15760, VietNamDivisionType.XA, "xa_tho_vuc", 397)
    W_15763 = Ward("Xã Thọ Thế", 15763, VietNamDivisionType.XA, "xa_tho_the", 397)
    W_15766 = Ward("Xã Nông Trường", 15766, VietNamDivisionType.XA, "xa_nong_truong", 397)
    W_15769 = Ward("Xã Bình Sơn", 15769, VietNamDivisionType.XA, "xa_binh_son", 397)
    W_15772 = Ward("Thị trấn Thiệu Hóa", 15772, VietNamDivisionType.THI_TRAN, "thi_tran_thieu_hoa", 398)
    W_15775 = Ward("Xã Thiệu Ngọc", 15775, VietNamDivisionType.XA, "xa_thieu_ngoc", 398)
    W_15778 = Ward("Xã Thiệu Vũ", 15778, VietNamDivisionType.XA, "xa_thieu_vu", 398)
    W_15781 = Ward("Xã Thiệu Phúc", 15781, VietNamDivisionType.XA, "xa_thieu_phuc", 398)
    W_15784 = Ward("Xã Thiệu Tiến", 15784, VietNamDivisionType.XA, "xa_thieu_tien", 398)
    W_15787 = Ward("Xã Thiệu Công", 15787, VietNamDivisionType.XA, "xa_thieu_cong", 398)
    W_15790 = Ward("Xã Thiệu Phú", 15790, VietNamDivisionType.XA, "xa_thieu_phu", 398)
    W_15793 = Ward("Xã Thiệu Long", 15793, VietNamDivisionType.XA, "xa_thieu_long", 398)
    W_15796 = Ward("Xã Thiệu Giang", 15796, VietNamDivisionType.XA, "xa_thieu_giang", 398)
    W_15799 = Ward("Xã Thiệu Duy", 15799, VietNamDivisionType.XA, "xa_thieu_duy", 398)
    W_15802 = Ward("Xã Thiệu Nguyên", 15802, VietNamDivisionType.XA, "xa_thieu_nguyen", 398)
    W_15805 = Ward("Xã Thiệu Hợp", 15805, VietNamDivisionType.XA, "xa_thieu_hop", 398)
    W_15808 = Ward("Xã Thiệu Thịnh", 15808, VietNamDivisionType.XA, "xa_thieu_thinh", 398)
    W_15811 = Ward("Xã Thiệu Quang", 15811, VietNamDivisionType.XA, "xa_thieu_quang", 398)
    W_15814 = Ward("Xã Thiệu Thành", 15814, VietNamDivisionType.XA, "xa_thieu_thanh", 398)
    W_15817 = Ward("Xã Thiệu Toán", 15817, VietNamDivisionType.XA, "xa_thieu_toan", 398)
    W_15820 = Ward("Xã Thiệu Chính", 15820, VietNamDivisionType.XA, "xa_thieu_chinh", 398)
    W_15823 = Ward("Xã Thiệu Hòa", 15823, VietNamDivisionType.XA, "xa_thieu_hoa", 398)
    W_15829 = Ward("Xã Minh Tâm", 15829, VietNamDivisionType.XA, "xa_minh_tam", 398)
    W_15832 = Ward("Xã Thiệu Viên", 15832, VietNamDivisionType.XA, "xa_thieu_vien", 398)
    W_15835 = Ward("Xã Thiệu Lý", 15835, VietNamDivisionType.XA, "xa_thieu_ly", 398)
    W_15838 = Ward("Xã Thiệu Vận", 15838, VietNamDivisionType.XA, "xa_thieu_van", 398)
    W_15841 = Ward("Xã Thiệu Trung", 15841, VietNamDivisionType.XA, "xa_thieu_trung", 398)
    W_15847 = Ward("Xã Tân Châu", 15847, VietNamDivisionType.XA, "xa_tan_chau", 398)
    W_15853 = Ward("Xã Thiệu Giao", 15853, VietNamDivisionType.XA, "xa_thieu_giao", 398)
    W_15865 = Ward("Thị trấn Bút Sơn", 15865, VietNamDivisionType.THI_TRAN, "thi_tran_but_son", 399)
    W_15871 = Ward("Xã Hoằng Giang", 15871, VietNamDivisionType.XA, "xa_hoang_giang", 399)
    W_15877 = Ward("Xã Hoằng Xuân", 15877, VietNamDivisionType.XA, "xa_hoang_xuan", 399)
    W_15880 = Ward("Xã Hoằng Phượng", 15880, VietNamDivisionType.XA, "xa_hoang_phuong", 399)
    W_15883 = Ward("Xã Hoằng Phú", 15883, VietNamDivisionType.XA, "xa_hoang_phu", 399)
    W_15886 = Ward("Xã Hoằng Quỳ", 15886, VietNamDivisionType.XA, "xa_hoang_quy", 399)
    W_15889 = Ward("Xã Hoằng Kim", 15889, VietNamDivisionType.XA, "xa_hoang_kim", 399)
    W_15892 = Ward("Xã Hoằng Trung", 15892, VietNamDivisionType.XA, "xa_hoang_trung", 399)
    W_15895 = Ward("Xã Hoằng Trinh", 15895, VietNamDivisionType.XA, "xa_hoang_trinh", 399)
    W_15901 = Ward("Xã Hoằng Sơn", 15901, VietNamDivisionType.XA, "xa_hoang_son", 399)
    W_15907 = Ward("Xã Hoằng Cát", 15907, VietNamDivisionType.XA, "xa_hoang_cat", 399)
    W_15910 = Ward("Xã Hoằng Xuyên", 15910, VietNamDivisionType.XA, "xa_hoang_xuyen", 399)
    W_15916 = Ward("Xã Hoằng Quý", 15916, VietNamDivisionType.XA, "xa_hoang_quy", 399)
    W_15919 = Ward("Xã Hoằng Hợp", 15919, VietNamDivisionType.XA, "xa_hoang_hop", 399)
    W_15928 = Ward("Xã Hoằng Đức", 15928, VietNamDivisionType.XA, "xa_hoang_duc", 399)
    W_15937 = Ward("Xã Hoằng Hà", 15937, VietNamDivisionType.XA, "xa_hoang_ha", 399)
    W_15940 = Ward("Xã Hoằng Đạt", 15940, VietNamDivisionType.XA, "xa_hoang_dat", 399)
    W_15946 = Ward("Xã Hoằng Đạo", 15946, VietNamDivisionType.XA, "xa_hoang_dao", 399)
    W_15949 = Ward("Xã Hoằng Thắng", 15949, VietNamDivisionType.XA, "xa_hoang_thang", 399)
    W_15952 = Ward("Xã Hoằng Đồng", 15952, VietNamDivisionType.XA, "xa_hoang_dong", 399)
    W_15955 = Ward("Xã Hoằng Thái", 15955, VietNamDivisionType.XA, "xa_hoang_thai", 399)
    W_15958 = Ward("Xã Hoằng Thịnh", 15958, VietNamDivisionType.XA, "xa_hoang_thinh", 399)
    W_15961 = Ward("Xã Hoằng Thành", 15961, VietNamDivisionType.XA, "xa_hoang_thanh", 399)
    W_15964 = Ward("Xã Hoằng Lộc", 15964, VietNamDivisionType.XA, "xa_hoang_loc", 399)
    W_15967 = Ward("Xã Hoằng Trạch", 15967, VietNamDivisionType.XA, "xa_hoang_trach", 399)
    W_15973 = Ward("Xã Hoằng Phong", 15973, VietNamDivisionType.XA, "xa_hoang_phong", 399)
    W_15976 = Ward("Xã Hoằng Lưu", 15976, VietNamDivisionType.XA, "xa_hoang_luu", 399)
    W_15979 = Ward("Xã Hoằng Châu", 15979, VietNamDivisionType.XA, "xa_hoang_chau", 399)
    W_15982 = Ward("Xã Hoằng Tân", 15982, VietNamDivisionType.XA, "xa_hoang_tan", 399)
    W_15985 = Ward("Xã Hoằng Yến", 15985, VietNamDivisionType.XA, "xa_hoang_yen", 399)
    W_15988 = Ward("Xã Hoằng Tiến", 15988, VietNamDivisionType.XA, "xa_hoang_tien", 399)
    W_15991 = Ward("Xã Hoằng Hải", 15991, VietNamDivisionType.XA, "xa_hoang_hai", 399)
    W_15994 = Ward("Xã Hoằng Ngọc", 15994, VietNamDivisionType.XA, "xa_hoang_ngoc", 399)
    W_15997 = Ward("Xã Hoằng Đông", 15997, VietNamDivisionType.XA, "xa_hoang_dong", 399)
    W_16000 = Ward("Xã Hoằng Thanh", 16000, VietNamDivisionType.XA, "xa_hoang_thanh", 399)
    W_16003 = Ward("Xã Hoằng Phụ", 16003, VietNamDivisionType.XA, "xa_hoang_phu", 399)
    W_16006 = Ward("Xã Hoằng Trường", 16006, VietNamDivisionType.XA, "xa_hoang_truong", 399)
    W_16012 = Ward("Thị trấn Hậu Lộc", 16012, VietNamDivisionType.THI_TRAN, "thi_tran_hau_loc", 400)
    W_16015 = Ward("Xã Đồng Lộc", 16015, VietNamDivisionType.XA, "xa_dong_loc", 400)
    W_16018 = Ward("Xã Đại Lộc", 16018, VietNamDivisionType.XA, "xa_dai_loc", 400)
    W_16021 = Ward("Xã Triệu Lộc", 16021, VietNamDivisionType.XA, "xa_trieu_loc", 400)
    W_16027 = Ward("Xã Tiến Lộc", 16027, VietNamDivisionType.XA, "xa_tien_loc", 400)
    W_16030 = Ward("Xã Lộc Sơn", 16030, VietNamDivisionType.XA, "xa_loc_son", 400)
    W_16033 = Ward("Xã Cầu Lộc", 16033, VietNamDivisionType.XA, "xa_cau_loc", 400)
    W_16036 = Ward("Xã Thành Lộc", 16036, VietNamDivisionType.XA, "xa_thanh_loc", 400)
    W_16039 = Ward("Xã Tuy Lộc", 16039, VietNamDivisionType.XA, "xa_tuy_loc", 400)
    W_16042 = Ward("Xã Phong Lộc", 16042, VietNamDivisionType.XA, "xa_phong_loc", 400)
    W_16045 = Ward("Xã Mỹ Lộc", 16045, VietNamDivisionType.XA, "xa_my_loc", 400)
    W_16048 = Ward("Xã Thuần Lộc", 16048, VietNamDivisionType.XA, "xa_thuan_loc", 400)
    W_16057 = Ward("Xã Xuân Lộc", 16057, VietNamDivisionType.XA, "xa_xuan_loc", 400)
    W_16063 = Ward("Xã Hoa Lộc", 16063, VietNamDivisionType.XA, "xa_hoa_loc", 400)
    W_16066 = Ward("Xã Liên Lộc", 16066, VietNamDivisionType.XA, "xa_lien_loc", 400)
    W_16069 = Ward("Xã Quang Lộc", 16069, VietNamDivisionType.XA, "xa_quang_loc", 400)
    W_16072 = Ward("Xã Phú Lộc", 16072, VietNamDivisionType.XA, "xa_phu_loc", 400)
    W_16075 = Ward("Xã Hòa Lộc", 16075, VietNamDivisionType.XA, "xa_hoa_loc", 400)
    W_16078 = Ward("Xã Minh Lộc", 16078, VietNamDivisionType.XA, "xa_minh_loc", 400)
    W_16081 = Ward("Xã Hưng Lộc", 16081, VietNamDivisionType.XA, "xa_hung_loc", 400)
    W_16084 = Ward("Xã Hải Lộc", 16084, VietNamDivisionType.XA, "xa_hai_loc", 400)
    W_16087 = Ward("Xã Đa Lộc", 16087, VietNamDivisionType.XA, "xa_da_loc", 400)
    W_16090 = Ward("Xã Ngư Lộc", 16090, VietNamDivisionType.XA, "xa_ngu_loc", 400)
    W_16093 = Ward("Thị trấn Nga Sơn", 16093, VietNamDivisionType.THI_TRAN, "thi_tran_nga_son", 401)
    W_16096 = Ward("Xã Ba Đình", 16096, VietNamDivisionType.XA, "xa_ba_dinh", 401)
    W_16099 = Ward("Xã Nga Vịnh", 16099, VietNamDivisionType.XA, "xa_nga_vinh", 401)
    W_16102 = Ward("Xã Nga Văn", 16102, VietNamDivisionType.XA, "xa_nga_van", 401)
    W_16105 = Ward("Xã Nga Thiện", 16105, VietNamDivisionType.XA, "xa_nga_thien", 401)
    W_16108 = Ward("Xã Nga Tiến", 16108, VietNamDivisionType.XA, "xa_nga_tien", 401)
    W_16114 = Ward("Xã Nga Phượng", 16114, VietNamDivisionType.XA, "xa_nga_phuong", 401)
    W_16117 = Ward("Xã Nga Trung", 16117, VietNamDivisionType.XA, "xa_nga_trung", 401)
    W_16120 = Ward("Xã Nga Bạch", 16120, VietNamDivisionType.XA, "xa_nga_bach", 401)
    W_16123 = Ward("Xã Nga Thanh", 16123, VietNamDivisionType.XA, "xa_nga_thanh", 401)
    W_16132 = Ward("Xã Nga Yên", 16132, VietNamDivisionType.XA, "xa_nga_yen", 401)
    W_16135 = Ward("Xã Nga Giáp", 16135, VietNamDivisionType.XA, "xa_nga_giap", 401)
    W_16138 = Ward("Xã Nga Hải", 16138, VietNamDivisionType.XA, "xa_nga_hai", 401)
    W_16141 = Ward("Xã Nga Thành", 16141, VietNamDivisionType.XA, "xa_nga_thanh", 401)
    W_16144 = Ward("Xã Nga An", 16144, VietNamDivisionType.XA, "xa_nga_an", 401)
    W_16147 = Ward("Xã Nga Phú", 16147, VietNamDivisionType.XA, "xa_nga_phu", 401)
    W_16150 = Ward("Xã Nga Điền", 16150, VietNamDivisionType.XA, "xa_nga_dien", 401)
    W_16153 = Ward("Xã Nga Tân", 16153, VietNamDivisionType.XA, "xa_nga_tan", 401)
    W_16156 = Ward("Xã Nga Thủy", 16156, VietNamDivisionType.XA, "xa_nga_thuy", 401)
    W_16159 = Ward("Xã Nga Liên", 16159, VietNamDivisionType.XA, "xa_nga_lien", 401)
    W_16162 = Ward("Xã Nga Thái", 16162, VietNamDivisionType.XA, "xa_nga_thai", 401)
    W_16165 = Ward("Xã Nga Thạch", 16165, VietNamDivisionType.XA, "xa_nga_thach", 401)
    W_16168 = Ward("Xã Nga Thắng", 16168, VietNamDivisionType.XA, "xa_nga_thang", 401)
    W_16171 = Ward("Xã Nga Trường", 16171, VietNamDivisionType.XA, "xa_nga_truong", 401)
    W_16174 = Ward("Thị trấn Yên Cát", 16174, VietNamDivisionType.THI_TRAN, "thi_tran_yen_cat", 402)
    W_16177 = Ward("Xã Bãi Trành", 16177, VietNamDivisionType.XA, "xa_bai_tranh", 402)
    W_16180 = Ward("Xã Xuân Hòa", 16180, VietNamDivisionType.XA, "xa_xuan_hoa", 402)
    W_16183 = Ward("Xã Xuân Bình", 16183, VietNamDivisionType.XA, "xa_xuan_binh", 402)
    W_16186 = Ward("Xã Hóa Quỳ", 16186, VietNamDivisionType.XA, "xa_hoa_quy", 402)
    W_16195 = Ward("Xã Cát Vân", 16195, VietNamDivisionType.XA, "xa_cat_van", 402)
    W_16198 = Ward("Xã Cát Tân", 16198, VietNamDivisionType.XA, "xa_cat_tan", 402)
    W_16201 = Ward("Xã Tân Bình", 16201, VietNamDivisionType.XA, "xa_tan_binh", 402)
    W_16204 = Ward("Xã Bình Lương", 16204, VietNamDivisionType.XA, "xa_binh_luong", 402)
    W_16207 = Ward("Xã Thanh Quân", 16207, VietNamDivisionType.XA, "xa_thanh_quan", 402)
    W_16210 = Ward("Xã Thanh Xuân", 16210, VietNamDivisionType.XA, "xa_thanh_xuan", 402)
    W_16213 = Ward("Xã Thanh Hòa", 16213, VietNamDivisionType.XA, "xa_thanh_hoa", 402)
    W_16216 = Ward("Xã Thanh Phong", 16216, VietNamDivisionType.XA, "xa_thanh_phong", 402)
    W_16219 = Ward("Xã Thanh Lâm", 16219, VietNamDivisionType.XA, "xa_thanh_lam", 402)
    W_16222 = Ward("Xã Thanh Sơn", 16222, VietNamDivisionType.XA, "xa_thanh_son", 402)
    W_16225 = Ward("Xã Thượng Ninh", 16225, VietNamDivisionType.XA, "xa_thuong_ninh", 402)
    W_16228 = Ward("Thị trấn Bến Sung", 16228, VietNamDivisionType.THI_TRAN, "thi_tran_ben_sung", 403)
    W_16231 = Ward("Xã Cán Khê", 16231, VietNamDivisionType.XA, "xa_can_khe", 403)
    W_16234 = Ward("Xã Xuân Du", 16234, VietNamDivisionType.XA, "xa_xuan_du", 403)
    W_16240 = Ward("Xã Phượng Nghi", 16240, VietNamDivisionType.XA, "xa_phuong_nghi", 403)
    W_16243 = Ward("Xã Mậu Lâm", 16243, VietNamDivisionType.XA, "xa_mau_lam", 403)
    W_16246 = Ward("Xã Xuân Khang", 16246, VietNamDivisionType.XA, "xa_xuan_khang", 403)
    W_16249 = Ward("Xã Phú Nhuận", 16249, VietNamDivisionType.XA, "xa_phu_nhuan", 403)
    W_16252 = Ward("Xã Hải Long", 16252, VietNamDivisionType.XA, "xa_hai_long", 403)
    W_16258 = Ward("Xã Xuân Thái", 16258, VietNamDivisionType.XA, "xa_xuan_thai", 403)
    W_16261 = Ward("Xã Xuân Phúc", 16261, VietNamDivisionType.XA, "xa_xuan_phuc", 403)
    W_16264 = Ward("Xã Yên Thọ", 16264, VietNamDivisionType.XA, "xa_yen_tho", 403)
    W_16267 = Ward("Xã Yên Lạc", 16267, VietNamDivisionType.XA, "xa_yen_lac", 403)
    W_16273 = Ward("Xã Thanh Tân", 16273, VietNamDivisionType.XA, "xa_thanh_tan", 403)
    W_16276 = Ward("Xã Thanh Kỳ", 16276, VietNamDivisionType.XA, "xa_thanh_ky", 403)
    W_16279 = Ward("Thị trấn Nông Cống", 16279, VietNamDivisionType.THI_TRAN, "thi_tran_nong_cong", 404)
    W_16282 = Ward("Xã Tân Phúc", 16282, VietNamDivisionType.XA, "xa_tan_phuc", 404)
    W_16285 = Ward("Xã Tân Thọ", 16285, VietNamDivisionType.XA, "xa_tan_tho", 404)
    W_16288 = Ward("Xã Hoàng Sơn", 16288, VietNamDivisionType.XA, "xa_hoang_son", 404)
    W_16291 = Ward("Xã Tân Khang", 16291, VietNamDivisionType.XA, "xa_tan_khang", 404)
    W_16294 = Ward("Xã Hoàng Giang", 16294, VietNamDivisionType.XA, "xa_hoang_giang", 404)
    W_16297 = Ward("Xã Trung Chính", 16297, VietNamDivisionType.XA, "xa_trung_chinh", 404)
    W_16303 = Ward("Xã Trung Thành", 16303, VietNamDivisionType.XA, "xa_trung_thanh", 404)
    W_16309 = Ward("Xã Tế Thắng", 16309, VietNamDivisionType.XA, "xa_te_thang", 404)
    W_16315 = Ward("Xã Tế Lợi", 16315, VietNamDivisionType.XA, "xa_te_loi", 404)
    W_16318 = Ward("Xã Tế Nông", 16318, VietNamDivisionType.XA, "xa_te_nong", 404)
    W_16321 = Ward("Xã Minh Nghĩa", 16321, VietNamDivisionType.XA, "xa_minh_nghia", 404)
    W_16324 = Ward("Xã Minh Khôi", 16324, VietNamDivisionType.XA, "xa_minh_khoi", 404)
    W_16327 = Ward("Xã Vạn Hòa", 16327, VietNamDivisionType.XA, "xa_van_hoa", 404)
    W_16330 = Ward("Xã Trường Trung", 16330, VietNamDivisionType.XA, "xa_truong_trung", 404)
    W_16333 = Ward("Xã Vạn Thắng", 16333, VietNamDivisionType.XA, "xa_van_thang", 404)
    W_16336 = Ward("Xã Trường Giang", 16336, VietNamDivisionType.XA, "xa_truong_giang", 404)
    W_16339 = Ward("Xã Vạn Thiện", 16339, VietNamDivisionType.XA, "xa_van_thien", 404)
    W_16342 = Ward("Xã Thăng Long", 16342, VietNamDivisionType.XA, "xa_thang_long", 404)
    W_16345 = Ward("Xã Trường Minh", 16345, VietNamDivisionType.XA, "xa_truong_minh", 404)
    W_16348 = Ward("Xã Trường Sơn", 16348, VietNamDivisionType.XA, "xa_truong_son", 404)
    W_16351 = Ward("Xã Thăng Bình", 16351, VietNamDivisionType.XA, "xa_thang_binh", 404)
    W_16354 = Ward("Xã Công Liêm", 16354, VietNamDivisionType.XA, "xa_cong_liem", 404)
    W_16357 = Ward("Xã Tượng Văn", 16357, VietNamDivisionType.XA, "xa_tuong_van", 404)
    W_16360 = Ward("Xã Thăng Thọ", 16360, VietNamDivisionType.XA, "xa_thang_tho", 404)
    W_16363 = Ward("Xã Tượng Lĩnh", 16363, VietNamDivisionType.XA, "xa_tuong_linh", 404)
    W_16366 = Ward("Xã Tượng Sơn", 16366, VietNamDivisionType.XA, "xa_tuong_son", 404)
    W_16369 = Ward("Xã Công Chính", 16369, VietNamDivisionType.XA, "xa_cong_chinh", 404)
    W_16375 = Ward("Xã Yên Mỹ", 16375, VietNamDivisionType.XA, "xa_yen_my", 404)
    W_16378 = Ward("Thị trấn Rừng Thông", 16378, VietNamDivisionType.THI_TRAN, "thi_tran_rung_thong", 405)
    W_16381 = Ward("Xã Đông Hoàng", 16381, VietNamDivisionType.XA, "xa_dong_hoang", 405)
    W_16384 = Ward("Xã Đông Ninh", 16384, VietNamDivisionType.XA, "xa_dong_ninh", 405)
    W_16390 = Ward("Xã Đông Hòa", 16390, VietNamDivisionType.XA, "xa_dong_hoa", 405)
    W_16393 = Ward("Xã Đông Yên", 16393, VietNamDivisionType.XA, "xa_dong_yen", 405)
    W_16399 = Ward("Xã Đông Minh", 16399, VietNamDivisionType.XA, "xa_dong_minh", 405)
    W_16402 = Ward("Xã Đông Thanh", 16402, VietNamDivisionType.XA, "xa_dong_thanh", 405)
    W_16405 = Ward("Xã Đông Tiến", 16405, VietNamDivisionType.XA, "xa_dong_tien", 405)
    W_16408 = Ward("Xã Đông Khê", 16408, VietNamDivisionType.XA, "xa_dong_khe", 405)
    W_16414 = Ward("Xã Đông Thịnh", 16414, VietNamDivisionType.XA, "xa_dong_thinh", 405)
    W_16417 = Ward("Xã Đông Văn", 16417, VietNamDivisionType.XA, "xa_dong_van", 405)
    W_16420 = Ward("Xã Đông Phú", 16420, VietNamDivisionType.XA, "xa_dong_phu", 405)
    W_16423 = Ward("Xã Đông Nam", 16423, VietNamDivisionType.XA, "xa_dong_nam", 405)
    W_16426 = Ward("Xã Đông Quang", 16426, VietNamDivisionType.XA, "xa_dong_quang", 405)
    W_16438 = Ward("Thị trấn Tân Phong", 16438, VietNamDivisionType.THI_TRAN, "thi_tran_tan_phong", 406)
    W_16447 = Ward("Xã Quảng Trạch", 16447, VietNamDivisionType.XA, "xa_quang_trach", 406)
    W_16453 = Ward("Xã Quảng Đức", 16453, VietNamDivisionType.XA, "xa_quang_duc", 406)
    W_16456 = Ward("Xã Quảng Định", 16456, VietNamDivisionType.XA, "xa_quang_dinh", 406)
    W_16462 = Ward("Xã Quảng Nhân", 16462, VietNamDivisionType.XA, "xa_quang_nhan", 406)
    W_16465 = Ward("Xã Quảng Ninh", 16465, VietNamDivisionType.XA, "xa_quang_ninh", 406)
    W_16468 = Ward("Xã Quảng Bình", 16468, VietNamDivisionType.XA, "xa_quang_binh", 406)
    W_16471 = Ward("Xã Quảng Hợp", 16471, VietNamDivisionType.XA, "xa_quang_hop", 406)
    W_16474 = Ward("Xã Quảng Văn", 16474, VietNamDivisionType.XA, "xa_quang_van", 406)
    W_16477 = Ward("Xã Quảng Long", 16477, VietNamDivisionType.XA, "xa_quang_long", 406)
    W_16480 = Ward("Xã Quảng Yên", 16480, VietNamDivisionType.XA, "xa_quang_yen", 406)
    W_16483 = Ward("Xã Quảng Hòa", 16483, VietNamDivisionType.XA, "xa_quang_hoa", 406)
    W_16489 = Ward("Xã Quảng Khê", 16489, VietNamDivisionType.XA, "xa_quang_khe", 406)
    W_16492 = Ward("Xã Quảng Trung", 16492, VietNamDivisionType.XA, "xa_quang_trung", 406)
    W_16495 = Ward("Xã Quảng Chính", 16495, VietNamDivisionType.XA, "xa_quang_chinh", 406)
    W_16498 = Ward("Xã Quảng Ngọc", 16498, VietNamDivisionType.XA, "xa_quang_ngoc", 406)
    W_16501 = Ward("Xã Quảng Trường", 16501, VietNamDivisionType.XA, "xa_quang_truong", 406)
    W_16510 = Ward("Xã Quảng Phúc", 16510, VietNamDivisionType.XA, "xa_quang_phuc", 406)
    W_16519 = Ward("Xã Quảng Giao", 16519, VietNamDivisionType.XA, "xa_quang_giao", 406)
    W_16540 = Ward("Xã Quảng Hải", 16540, VietNamDivisionType.XA, "xa_quang_hai", 406)
    W_16543 = Ward("Xã Quảng Lưu", 16543, VietNamDivisionType.XA, "xa_quang_luu", 406)
    W_16546 = Ward("Xã Quảng Lộc", 16546, VietNamDivisionType.XA, "xa_quang_loc", 406)
    W_16549 = Ward("Xã Tiên Trang", 16549, VietNamDivisionType.XA, "xa_tien_trang", 406)
    W_16552 = Ward("Xã Quảng Nham", 16552, VietNamDivisionType.XA, "xa_quang_nham", 406)
    W_16555 = Ward("Xã Quảng Thạch", 16555, VietNamDivisionType.XA, "xa_quang_thach", 406)
    W_16558 = Ward("Xã Quảng Thái", 16558, VietNamDivisionType.XA, "xa_quang_thai", 406)
    W_16561 = Ward("Phường Hải Hòa", 16561, VietNamDivisionType.PHUONG, "phuong_hai_hoa", 407)
    W_16564 = Ward("Phường Hải Châu", 16564, VietNamDivisionType.PHUONG, "phuong_hai_chau", 407)
    W_16567 = Ward("Xã Thanh Thủy", 16567, VietNamDivisionType.XA, "xa_thanh_thuy", 407)
    W_16570 = Ward("Xã Thanh Sơn", 16570, VietNamDivisionType.XA, "xa_thanh_son", 407)
    W_16576 = Ward("Phường Hải Ninh", 16576, VietNamDivisionType.PHUONG, "phuong_hai_ninh", 407)
    W_16579 = Ward("Xã Anh Sơn", 16579, VietNamDivisionType.XA, "xa_anh_son", 407)
    W_16582 = Ward("Xã Ngọc Lĩnh", 16582, VietNamDivisionType.XA, "xa_ngoc_linh", 407)
    W_16585 = Ward("Phường Hải An", 16585, VietNamDivisionType.PHUONG, "phuong_hai_an", 407)
    W_16591 = Ward("Xã Các Sơn", 16591, VietNamDivisionType.XA, "xa_cac_son", 407)
    W_16594 = Ward("Phường Tân Dân", 16594, VietNamDivisionType.PHUONG, "phuong_tan_dan", 407)
    W_16597 = Ward("Phường Hải Lĩnh", 16597, VietNamDivisionType.PHUONG, "phuong_hai_linh", 407)
    W_16600 = Ward("Xã Định Hải", 16600, VietNamDivisionType.XA, "xa_dinh_hai", 407)
    W_16603 = Ward("Xã Phú Sơn", 16603, VietNamDivisionType.XA, "xa_phu_son", 407)
    W_16606 = Ward("Phường Ninh Hải", 16606, VietNamDivisionType.PHUONG, "phuong_ninh_hai", 407)
    W_16609 = Ward("Phường Nguyên Bình", 16609, VietNamDivisionType.PHUONG, "phuong_nguyen_binh", 407)
    W_16612 = Ward("Xã Hải Nhân", 16612, VietNamDivisionType.XA, "xa_hai_nhan", 407)
    W_16618 = Ward("Phường Bình Minh", 16618, VietNamDivisionType.PHUONG, "phuong_binh_minh", 407)
    W_16621 = Ward("Phường Hải Thanh", 16621, VietNamDivisionType.PHUONG, "phuong_hai_thanh", 407)
    W_16624 = Ward("Xã Phú Lâm", 16624, VietNamDivisionType.XA, "xa_phu_lam", 407)
    W_16627 = Ward("Phường Xuân Lâm", 16627, VietNamDivisionType.PHUONG, "phuong_xuan_lam", 407)
    W_16630 = Ward("Phường Trúc Lâm", 16630, VietNamDivisionType.PHUONG, "phuong_truc_lam", 407)
    W_16633 = Ward("Phường Hải Bình", 16633, VietNamDivisionType.PHUONG, "phuong_hai_binh", 407)
    W_16636 = Ward("Xã Tân Trường", 16636, VietNamDivisionType.XA, "xa_tan_truong", 407)
    W_16639 = Ward("Xã Tùng Lâm", 16639, VietNamDivisionType.XA, "xa_tung_lam", 407)
    W_16642 = Ward("Phường Tĩnh Hải", 16642, VietNamDivisionType.PHUONG, "phuong_tinh_hai", 407)
    W_16645 = Ward("Phường Mai Lâm", 16645, VietNamDivisionType.PHUONG, "phuong_mai_lam", 407)
    W_16648 = Ward("Xã Trường Lâm", 16648, VietNamDivisionType.XA, "xa_truong_lam", 407)
    W_16651 = Ward("Xã Hải Yến", 16651, VietNamDivisionType.XA, "xa_hai_yen", 407)
    W_16654 = Ward("Phường Hải Thượng", 16654, VietNamDivisionType.PHUONG, "phuong_hai_thuong", 407)
    W_16657 = Ward("Xã Nghi Sơn", 16657, VietNamDivisionType.XA, "xa_nghi_son", 407)
    W_16660 = Ward("Xã Hải Hà", 16660, VietNamDivisionType.XA, "xa_hai_ha", 407)
    W_16663 = Ward("Phường Đông Vĩnh", 16663, VietNamDivisionType.PHUONG, "phuong_dong_vinh", 412)
    W_16666 = Ward("Phường Hà Huy Tập", 16666, VietNamDivisionType.PHUONG, "phuong_ha_huy_tap", 412)
    W_16669 = Ward("Phường Lê Lợi", 16669, VietNamDivisionType.PHUONG, "phuong_le_loi", 412)
    W_16670 = Ward("Phường Quán Bàu", 16670, VietNamDivisionType.PHUONG, "phuong_quan_bau", 412)
    W_16672 = Ward("Phường Hưng Bình", 16672, VietNamDivisionType.PHUONG, "phuong_hung_binh", 412)
    W_16673 = Ward("Phường Hưng Phúc", 16673, VietNamDivisionType.PHUONG, "phuong_hung_phuc", 412)
    W_16675 = Ward("Phường Hưng Dũng", 16675, VietNamDivisionType.PHUONG, "phuong_hung_dung", 412)
    W_16678 = Ward("Phường Cửa Nam", 16678, VietNamDivisionType.PHUONG, "phuong_cua_nam", 412)
    W_16681 = Ward("Phường Quang Trung", 16681, VietNamDivisionType.PHUONG, "phuong_quang_trung", 412)
    W_16684 = Ward("Phường Đội Cung", 16684, VietNamDivisionType.PHUONG, "phuong_doi_cung", 412)
    W_16687 = Ward("Phường Lê Mao", 16687, VietNamDivisionType.PHUONG, "phuong_le_mao", 412)
    W_16690 = Ward("Phường Trường Thi", 16690, VietNamDivisionType.PHUONG, "phuong_truong_thi", 412)
    W_16693 = Ward("Phường Bến Thủy", 16693, VietNamDivisionType.PHUONG, "phuong_ben_thuy", 412)
    W_16696 = Ward("Phường Hồng Sơn", 16696, VietNamDivisionType.PHUONG, "phuong_hong_son", 412)
    W_16699 = Ward("Phường Trung Đô", 16699, VietNamDivisionType.PHUONG, "phuong_trung_do", 412)
    W_16702 = Ward("Xã Nghi Phú", 16702, VietNamDivisionType.XA, "xa_nghi_phu", 412)
    W_16705 = Ward("Xã Hưng Đông", 16705, VietNamDivisionType.XA, "xa_hung_dong", 412)
    W_16708 = Ward("Xã Hưng Lộc", 16708, VietNamDivisionType.XA, "xa_hung_loc", 412)
    W_16711 = Ward("Xã Hưng Hòa", 16711, VietNamDivisionType.XA, "xa_hung_hoa", 412)
    W_16714 = Ward("Phường Vinh Tân", 16714, VietNamDivisionType.PHUONG, "phuong_vinh_tan", 412)
    W_17908 = Ward("Xã Nghi Liên", 17908, VietNamDivisionType.XA, "xa_nghi_lien", 412)
    W_17914 = Ward("Xã Nghi Ân", 17914, VietNamDivisionType.XA, "xa_nghi_an", 412)
    W_17920 = Ward("Xã Nghi Kim", 17920, VietNamDivisionType.XA, "xa_nghi_kim", 412)
    W_17923 = Ward("Xã Nghi Đức", 17923, VietNamDivisionType.XA, "xa_nghi_duc", 412)
    W_18013 = Ward("Xã Hưng Chính", 18013, VietNamDivisionType.XA, "xa_hung_chinh", 412)
    W_16717 = Ward("Phường Nghi Thuỷ", 16717, VietNamDivisionType.PHUONG, "phuong_nghi_thuy", 413)
    W_16720 = Ward("Phường Nghi Tân", 16720, VietNamDivisionType.PHUONG, "phuong_nghi_tan", 413)
    W_16723 = Ward("Phường Thu Thuỷ", 16723, VietNamDivisionType.PHUONG, "phuong_thu_thuy", 413)
    W_16726 = Ward("Phường Nghi Hòa", 16726, VietNamDivisionType.PHUONG, "phuong_nghi_hoa", 413)
    W_16729 = Ward("Phường Nghi Hải", 16729, VietNamDivisionType.PHUONG, "phuong_nghi_hai", 413)
    W_16732 = Ward("Phường Nghi Hương", 16732, VietNamDivisionType.PHUONG, "phuong_nghi_huong", 413)
    W_16735 = Ward("Phường Nghi Thu", 16735, VietNamDivisionType.PHUONG, "phuong_nghi_thu", 413)
    W_16939 = Ward("Phường Hoà Hiếu", 16939, VietNamDivisionType.PHUONG, "phuong_hoa_hieu", 414)
    W_16993 = Ward("Phường Quang Phong", 16993, VietNamDivisionType.PHUONG, "phuong_quang_phong", 414)
    W_16994 = Ward("Phường Quang Tiến", 16994, VietNamDivisionType.PHUONG, "phuong_quang_tien", 414)
    W_17003 = Ward("Phường Long Sơn", 17003, VietNamDivisionType.PHUONG, "phuong_long_son", 414)
    W_17005 = Ward("Xã Nghĩa Tiến", 17005, VietNamDivisionType.XA, "xa_nghia_tien", 414)
    W_17008 = Ward("Xã Nghĩa Mỹ", 17008, VietNamDivisionType.XA, "xa_nghia_my", 414)
    W_17011 = Ward("Xã Tây Hiếu", 17011, VietNamDivisionType.XA, "xa_tay_hieu", 414)
    W_17014 = Ward("Xã Nghĩa Thuận", 17014, VietNamDivisionType.XA, "xa_nghia_thuan", 414)
    W_17017 = Ward("Xã Đông Hiếu", 17017, VietNamDivisionType.XA, "xa_dong_hieu", 414)
    W_16738 = Ward("Thị trấn Kim Sơn", 16738, VietNamDivisionType.THI_TRAN, "thi_tran_kim_son", 415)
    W_16741 = Ward("Xã Thông Thụ", 16741, VietNamDivisionType.XA, "xa_thong_thu", 415)
    W_16744 = Ward("Xã Đồng Văn", 16744, VietNamDivisionType.XA, "xa_dong_van", 415)
    W_16747 = Ward("Xã Hạnh Dịch", 16747, VietNamDivisionType.XA, "xa_hanh_dich", 415)
    W_16750 = Ward("Xã Tiền Phong", 16750, VietNamDivisionType.XA, "xa_tien_phong", 415)
    W_16753 = Ward("Xã Nậm Giải", 16753, VietNamDivisionType.XA, "xa_nam_giai", 415)
    W_16756 = Ward("Xã Tri Lễ", 16756, VietNamDivisionType.XA, "xa_tri_le", 415)
    W_16759 = Ward("Xã Châu Kim", 16759, VietNamDivisionType.XA, "xa_chau_kim", 415)
    W_16763 = Ward("Xã Mường Nọc", 16763, VietNamDivisionType.XA, "xa_muong_noc", 415)
    W_16765 = Ward("Xã Châu Thôn", 16765, VietNamDivisionType.XA, "xa_chau_thon", 415)
    W_16768 = Ward("Xã Nậm Nhoóng", 16768, VietNamDivisionType.XA, "xa_nam_nhoong", 415)
    W_16771 = Ward("Xã Quang Phong", 16771, VietNamDivisionType.XA, "xa_quang_phong", 415)
    W_16774 = Ward("Xã Căm Muộn", 16774, VietNamDivisionType.XA, "xa_cam_muon", 415)
    W_16777 = Ward("Thị trấn Tân Lạc", 16777, VietNamDivisionType.THI_TRAN, "thi_tran_tan_lac", 416)
    W_16780 = Ward("Xã Châu Bính", 16780, VietNamDivisionType.XA, "xa_chau_binh", 416)
    W_16783 = Ward("Xã Châu Thuận", 16783, VietNamDivisionType.XA, "xa_chau_thuan", 416)
    W_16786 = Ward("Xã Châu Hội", 16786, VietNamDivisionType.XA, "xa_chau_hoi", 416)
    W_16789 = Ward("Xã Châu Nga", 16789, VietNamDivisionType.XA, "xa_chau_nga", 416)
    W_16792 = Ward("Xã Châu Tiến", 16792, VietNamDivisionType.XA, "xa_chau_tien", 416)
    W_16795 = Ward("Xã Châu Hạnh", 16795, VietNamDivisionType.XA, "xa_chau_hanh", 416)
    W_16798 = Ward("Xã Châu Thắng", 16798, VietNamDivisionType.XA, "xa_chau_thang", 416)
    W_16801 = Ward("Xã Châu Phong", 16801, VietNamDivisionType.XA, "xa_chau_phong", 416)
    W_16804 = Ward("Xã Châu Bình", 16804, VietNamDivisionType.XA, "xa_chau_binh", 416)
    W_16807 = Ward("Xã Châu Hoàn", 16807, VietNamDivisionType.XA, "xa_chau_hoan", 416)
    W_16810 = Ward("Xã Diên Lãm", 16810, VietNamDivisionType.XA, "xa_dien_lam", 416)
    W_16813 = Ward("Thị trấn Mường Xén", 16813, VietNamDivisionType.THI_TRAN, "thi_tran_muong_xen", 417)
    W_16816 = Ward("Xã Mỹ Lý", 16816, VietNamDivisionType.XA, "xa_my_ly", 417)
    W_16819 = Ward("Xã Bắc Lý", 16819, VietNamDivisionType.XA, "xa_bac_ly", 417)
    W_16822 = Ward("Xã Keng Đu", 16822, VietNamDivisionType.XA, "xa_keng_du", 417)
    W_16825 = Ward("Xã Đoọc Mạy", 16825, VietNamDivisionType.XA, "xa_dooc_may", 417)
    W_16828 = Ward("Xã Huồi Tụ", 16828, VietNamDivisionType.XA, "xa_huoi_tu", 417)
    W_16831 = Ward("Xã Mường Lống", 16831, VietNamDivisionType.XA, "xa_muong_long", 417)
    W_16834 = Ward("Xã Na Loi", 16834, VietNamDivisionType.XA, "xa_na_loi", 417)
    W_16837 = Ward("Xã Nậm Cắn", 16837, VietNamDivisionType.XA, "xa_nam_can", 417)
    W_16840 = Ward("Xã Bảo Nam", 16840, VietNamDivisionType.XA, "xa_bao_nam", 417)
    W_16843 = Ward("Xã Phà Đánh", 16843, VietNamDivisionType.XA, "xa_pha_danh", 417)
    W_16846 = Ward("Xã Bảo Thắng", 16846, VietNamDivisionType.XA, "xa_bao_thang", 417)
    W_16849 = Ward("Xã Hữu Lập", 16849, VietNamDivisionType.XA, "xa_huu_lap", 417)
    W_16852 = Ward("Xã Tà Cạ", 16852, VietNamDivisionType.XA, "xa_ta_ca", 417)
    W_16855 = Ward("Xã Chiêu Lưu", 16855, VietNamDivisionType.XA, "xa_chieu_luu", 417)
    W_16858 = Ward("Xã Mường Típ", 16858, VietNamDivisionType.XA, "xa_muong_tip", 417)
    W_16861 = Ward("Xã Hữu Kiệm", 16861, VietNamDivisionType.XA, "xa_huu_kiem", 417)
    W_16864 = Ward("Xã Tây Sơn", 16864, VietNamDivisionType.XA, "xa_tay_son", 417)
    W_16867 = Ward("Xã Mường Ải", 16867, VietNamDivisionType.XA, "xa_muong_ai", 417)
    W_16870 = Ward("Xã Na Ngoi", 16870, VietNamDivisionType.XA, "xa_na_ngoi", 417)
    W_16873 = Ward("Xã Nậm Càn", 16873, VietNamDivisionType.XA, "xa_nam_can", 417)
    W_16876 = Ward("Thị trấn Thạch Giám", 16876, VietNamDivisionType.THI_TRAN, "thi_tran_thach_giam", 418)
    W_16879 = Ward("Xã Mai Sơn", 16879, VietNamDivisionType.XA, "xa_mai_son", 418)
    W_16882 = Ward("Xã Nhôn Mai", 16882, VietNamDivisionType.XA, "xa_nhon_mai", 418)
    W_16885 = Ward("Xã Hữu Khuông", 16885, VietNamDivisionType.XA, "xa_huu_khuong", 418)
    W_16900 = Ward("Xã Yên Tĩnh", 16900, VietNamDivisionType.XA, "xa_yen_tinh", 418)
    W_16903 = Ward("Xã Nga My", 16903, VietNamDivisionType.XA, "xa_nga_my", 418)
    W_16904 = Ward("Xã Xiêng My", 16904, VietNamDivisionType.XA, "xa_xieng_my", 418)
    W_16906 = Ward("Xã Lưỡng Minh", 16906, VietNamDivisionType.XA, "xa_luong_minh", 418)
    W_16909 = Ward("Xã Yên Hòa", 16909, VietNamDivisionType.XA, "xa_yen_hoa", 418)
    W_16912 = Ward("Xã Yên Na", 16912, VietNamDivisionType.XA, "xa_yen_na", 418)
    W_16915 = Ward("Xã Lưu Kiền", 16915, VietNamDivisionType.XA, "xa_luu_kien", 418)
    W_16921 = Ward("Xã Xá Lượng", 16921, VietNamDivisionType.XA, "xa_xa_luong", 418)
    W_16924 = Ward("Xã Tam Thái", 16924, VietNamDivisionType.XA, "xa_tam_thai", 418)
    W_16927 = Ward("Xã Tam Đình", 16927, VietNamDivisionType.XA, "xa_tam_dinh", 418)
    W_16930 = Ward("Xã Yên Thắng", 16930, VietNamDivisionType.XA, "xa_yen_thang", 418)
    W_16933 = Ward("Xã Tam Quang", 16933, VietNamDivisionType.XA, "xa_tam_quang", 418)
    W_16936 = Ward("Xã Tam Hợp", 16936, VietNamDivisionType.XA, "xa_tam_hop", 418)
    W_16941 = Ward("Thị trấn Nghĩa Đàn", 16941, VietNamDivisionType.THI_TRAN, "thi_tran_nghia_dan", 419)
    W_16942 = Ward("Xã Nghĩa Mai", 16942, VietNamDivisionType.XA, "xa_nghia_mai", 419)
    W_16945 = Ward("Xã Nghĩa Yên", 16945, VietNamDivisionType.XA, "xa_nghia_yen", 419)
    W_16948 = Ward("Xã Nghĩa Lạc", 16948, VietNamDivisionType.XA, "xa_nghia_lac", 419)
    W_16951 = Ward("Xã Nghĩa Lâm", 16951, VietNamDivisionType.XA, "xa_nghia_lam", 419)
    W_16954 = Ward("Xã Nghĩa Sơn", 16954, VietNamDivisionType.XA, "xa_nghia_son", 419)
    W_16957 = Ward("Xã Nghĩa Lợi", 16957, VietNamDivisionType.XA, "xa_nghia_loi", 419)
    W_16960 = Ward("Xã Nghĩa Bình", 16960, VietNamDivisionType.XA, "xa_nghia_binh", 419)
    W_16963 = Ward("Xã Nghĩa Thọ", 16963, VietNamDivisionType.XA, "xa_nghia_tho", 419)
    W_16966 = Ward("Xã Nghĩa Minh", 16966, VietNamDivisionType.XA, "xa_nghia_minh", 419)
    W_16969 = Ward("Xã Nghĩa Phú", 16969, VietNamDivisionType.XA, "xa_nghia_phu", 419)
    W_16972 = Ward("Xã Nghĩa Hưng", 16972, VietNamDivisionType.XA, "xa_nghia_hung", 419)
    W_16975 = Ward("Xã Nghĩa Hồng", 16975, VietNamDivisionType.XA, "xa_nghia_hong", 419)
    W_16978 = Ward("Xã Nghĩa Thịnh", 16978, VietNamDivisionType.XA, "xa_nghia_thinh", 419)
    W_16981 = Ward("Xã Nghĩa Trung", 16981, VietNamDivisionType.XA, "xa_nghia_trung", 419)
    W_16984 = Ward("Xã Nghĩa Hội", 16984, VietNamDivisionType.XA, "xa_nghia_hoi", 419)
    W_16987 = Ward("Xã Nghĩa Thành", 16987, VietNamDivisionType.XA, "xa_nghia_thanh", 419)
    W_16996 = Ward("Xã Nghĩa Hiếu", 16996, VietNamDivisionType.XA, "xa_nghia_hieu", 419)
    W_17020 = Ward("Xã Nghĩa Đức", 17020, VietNamDivisionType.XA, "xa_nghia_duc", 419)
    W_17023 = Ward("Xã Nghĩa An", 17023, VietNamDivisionType.XA, "xa_nghia_an", 419)
    W_17026 = Ward("Xã Nghĩa Long", 17026, VietNamDivisionType.XA, "xa_nghia_long", 419)
    W_17029 = Ward("Xã Nghĩa Lộc", 17029, VietNamDivisionType.XA, "xa_nghia_loc", 419)
    W_17032 = Ward("Xã Nghĩa Khánh", 17032, VietNamDivisionType.XA, "xa_nghia_khanh", 419)
    W_17035 = Ward("Thị trấn Quỳ Hợp", 17035, VietNamDivisionType.THI_TRAN, "thi_tran_quy_hop", 420)
    W_17038 = Ward("Xã Yên Hợp", 17038, VietNamDivisionType.XA, "xa_yen_hop", 420)
    W_17041 = Ward("Xã Châu Tiến", 17041, VietNamDivisionType.XA, "xa_chau_tien", 420)
    W_17044 = Ward("Xã Châu Hồng", 17044, VietNamDivisionType.XA, "xa_chau_hong", 420)
    W_17047 = Ward("Xã Đồng Hợp", 17047, VietNamDivisionType.XA, "xa_dong_hop", 420)
    W_17050 = Ward("Xã Châu Thành", 17050, VietNamDivisionType.XA, "xa_chau_thanh", 420)
    W_17053 = Ward("Xã Liên Hợp", 17053, VietNamDivisionType.XA, "xa_lien_hop", 420)
    W_17056 = Ward("Xã Châu Lộc", 17056, VietNamDivisionType.XA, "xa_chau_loc", 420)
    W_17059 = Ward("Xã Tam Hợp", 17059, VietNamDivisionType.XA, "xa_tam_hop", 420)
    W_17062 = Ward("Xã Châu Cường", 17062, VietNamDivisionType.XA, "xa_chau_cuong", 420)
    W_17065 = Ward("Xã Châu Quang", 17065, VietNamDivisionType.XA, "xa_chau_quang", 420)
    W_17068 = Ward("Xã Thọ Hợp", 17068, VietNamDivisionType.XA, "xa_tho_hop", 420)
    W_17071 = Ward("Xã Minh Hợp", 17071, VietNamDivisionType.XA, "xa_minh_hop", 420)
    W_17074 = Ward("Xã Nghĩa Xuân", 17074, VietNamDivisionType.XA, "xa_nghia_xuan", 420)
    W_17077 = Ward("Xã Châu Thái", 17077, VietNamDivisionType.XA, "xa_chau_thai", 420)
    W_17080 = Ward("Xã Châu Đình", 17080, VietNamDivisionType.XA, "xa_chau_dinh", 420)
    W_17083 = Ward("Xã Văn Lợi", 17083, VietNamDivisionType.XA, "xa_van_loi", 420)
    W_17086 = Ward("Xã Nam Sơn", 17086, VietNamDivisionType.XA, "xa_nam_son", 420)
    W_17089 = Ward("Xã Châu Lý", 17089, VietNamDivisionType.XA, "xa_chau_ly", 420)
    W_17092 = Ward("Xã Hạ Sơn", 17092, VietNamDivisionType.XA, "xa_ha_son", 420)
    W_17095 = Ward("Xã Bắc Sơn", 17095, VietNamDivisionType.XA, "xa_bac_son", 420)
    W_17098 = Ward("Thị trấn Cầu Giát", 17098, VietNamDivisionType.THI_TRAN, "thi_tran_cau_giat", 421)
    W_17101 = Ward("Xã Quỳnh Thắng", 17101, VietNamDivisionType.XA, "xa_quynh_thang", 421)
    W_17119 = Ward("Xã Quỳnh Tân", 17119, VietNamDivisionType.XA, "xa_quynh_tan", 421)
    W_17122 = Ward("Xã Quỳnh Châu", 17122, VietNamDivisionType.XA, "xa_quynh_chau", 421)
    W_17140 = Ward("Xã Tân Sơn", 17140, VietNamDivisionType.XA, "xa_tan_son", 421)
    W_17143 = Ward("Xã Quỳnh Văn", 17143, VietNamDivisionType.XA, "xa_quynh_van", 421)
    W_17146 = Ward("Xã Ngọc Sơn", 17146, VietNamDivisionType.XA, "xa_ngoc_son", 421)
    W_17149 = Ward("Xã Quỳnh Tam", 17149, VietNamDivisionType.XA, "xa_quynh_tam", 421)
    W_17152 = Ward("Xã Quỳnh Hoa", 17152, VietNamDivisionType.XA, "xa_quynh_hoa", 421)
    W_17155 = Ward("Xã Quỳnh Thạch", 17155, VietNamDivisionType.XA, "xa_quynh_thach", 421)
    W_17158 = Ward("Xã Quỳnh Bảng", 17158, VietNamDivisionType.XA, "xa_quynh_bang", 421)
    W_17161 = Ward("Xã Quỳnh Mỹ", 17161, VietNamDivisionType.XA, "xa_quynh_my", 421)
    W_17164 = Ward("Xã Quỳnh Thanh", 17164, VietNamDivisionType.XA, "xa_quynh_thanh", 421)
    W_17167 = Ward("Xã Quỳnh Hậu", 17167, VietNamDivisionType.XA, "xa_quynh_hau", 421)
    W_17170 = Ward("Xã Quỳnh Lâm", 17170, VietNamDivisionType.XA, "xa_quynh_lam", 421)
    W_17173 = Ward("Xã Quỳnh Đôi", 17173, VietNamDivisionType.XA, "xa_quynh_doi", 421)
    W_17176 = Ward("Xã Quỳnh Lương", 17176, VietNamDivisionType.XA, "xa_quynh_luong", 421)
    W_17179 = Ward("Xã Quỳnh Hồng", 17179, VietNamDivisionType.XA, "xa_quynh_hong", 421)
    W_17182 = Ward("Xã Quỳnh Yên", 17182, VietNamDivisionType.XA, "xa_quynh_yen", 421)
    W_17185 = Ward("Xã Quỳnh Bá", 17185, VietNamDivisionType.XA, "xa_quynh_ba", 421)
    W_17188 = Ward("Xã Quỳnh Minh", 17188, VietNamDivisionType.XA, "xa_quynh_minh", 421)
    W_17191 = Ward("Xã Quỳnh Diễn", 17191, VietNamDivisionType.XA, "xa_quynh_dien", 421)
    W_17194 = Ward("Xã Quỳnh Hưng", 17194, VietNamDivisionType.XA, "xa_quynh_hung", 421)
    W_17197 = Ward("Xã Quỳnh Giang", 17197, VietNamDivisionType.XA, "xa_quynh_giang", 421)
    W_17200 = Ward("Xã Quỳnh Ngọc", 17200, VietNamDivisionType.XA, "xa_quynh_ngoc", 421)
    W_17203 = Ward("Xã Quỳnh Nghĩa", 17203, VietNamDivisionType.XA, "xa_quynh_nghia", 421)
    W_17206 = Ward("Xã An Hòa", 17206, VietNamDivisionType.XA, "xa_an_hoa", 421)
    W_17209 = Ward("Xã Tiến Thủy", 17209, VietNamDivisionType.XA, "xa_tien_thuy", 421)
    W_17212 = Ward("Xã Sơn Hải", 17212, VietNamDivisionType.XA, "xa_son_hai", 421)
    W_17215 = Ward("Xã Quỳnh Thọ", 17215, VietNamDivisionType.XA, "xa_quynh_tho", 421)
    W_17218 = Ward("Xã Quỳnh Thuận", 17218, VietNamDivisionType.XA, "xa_quynh_thuan", 421)
    W_17221 = Ward("Xã Quỳnh Long", 17221, VietNamDivisionType.XA, "xa_quynh_long", 421)
    W_17224 = Ward("Xã Tân Thắng", 17224, VietNamDivisionType.XA, "xa_tan_thang", 421)
    W_17227 = Ward("Thị trấn Con Cuông", 17227, VietNamDivisionType.THI_TRAN, "thi_tran_con_cuong", 422)
    W_17230 = Ward("Xã Bình Chuẩn", 17230, VietNamDivisionType.XA, "xa_binh_chuan", 422)
    W_17233 = Ward("Xã Lạng Khê", 17233, VietNamDivisionType.XA, "xa_lang_khe", 422)
    W_17236 = Ward("Xã Cam Lâm", 17236, VietNamDivisionType.XA, "xa_cam_lam", 422)
    W_17239 = Ward("Xã Thạch Ngàn", 17239, VietNamDivisionType.XA, "xa_thach_ngan", 422)
    W_17242 = Ward("Xã Đôn Phục", 17242, VietNamDivisionType.XA, "xa_don_phuc", 422)
    W_17245 = Ward("Xã Mậu Đức", 17245, VietNamDivisionType.XA, "xa_mau_duc", 422)
    W_17248 = Ward("Xã Châu Khê", 17248, VietNamDivisionType.XA, "xa_chau_khe", 422)
    W_17251 = Ward("Xã Chi Khê", 17251, VietNamDivisionType.XA, "xa_chi_khe", 422)
    W_17254 = Ward("Xã Bồng Khê", 17254, VietNamDivisionType.XA, "xa_bong_khe", 422)
    W_17257 = Ward("Xã Yên Khê", 17257, VietNamDivisionType.XA, "xa_yen_khe", 422)
    W_17260 = Ward("Xã Lục Dạ", 17260, VietNamDivisionType.XA, "xa_luc_da", 422)
    W_17263 = Ward("Xã Môn Sơn", 17263, VietNamDivisionType.XA, "xa_mon_son", 422)
    W_17266 = Ward("Thị trấn Tân Kỳ", 17266, VietNamDivisionType.THI_TRAN, "thi_tran_tan_ky", 423)
    W_17269 = Ward("Xã Tân Hợp", 17269, VietNamDivisionType.XA, "xa_tan_hop", 423)
    W_17272 = Ward("Xã Tân Phú", 17272, VietNamDivisionType.XA, "xa_tan_phu", 423)
    W_17275 = Ward("Xã Tân Xuân", 17275, VietNamDivisionType.XA, "xa_tan_xuan", 423)
    W_17278 = Ward("Xã Giai Xuân", 17278, VietNamDivisionType.XA, "xa_giai_xuan", 423)
    W_17281 = Ward("Xã Nghĩa Bình", 17281, VietNamDivisionType.XA, "xa_nghia_binh", 423)
    W_17284 = Ward("Xã Nghĩa Đồng", 17284, VietNamDivisionType.XA, "xa_nghia_dong", 423)
    W_17287 = Ward("Xã Đồng Văn", 17287, VietNamDivisionType.XA, "xa_dong_van", 423)
    W_17290 = Ward("Xã Nghĩa Thái", 17290, VietNamDivisionType.XA, "xa_nghia_thai", 423)
    W_17293 = Ward("Xã Nghĩa Hợp", 17293, VietNamDivisionType.XA, "xa_nghia_hop", 423)
    W_17296 = Ward("Xã Nghĩa Hoàn", 17296, VietNamDivisionType.XA, "xa_nghia_hoan", 423)
    W_17299 = Ward("Xã Nghĩa Phúc", 17299, VietNamDivisionType.XA, "xa_nghia_phuc", 423)
    W_17302 = Ward("Xã Tiên Kỳ", 17302, VietNamDivisionType.XA, "xa_tien_ky", 423)
    W_17305 = Ward("Xã Tân An", 17305, VietNamDivisionType.XA, "xa_tan_an", 423)
    W_17308 = Ward("Xã Nghĩa Dũng", 17308, VietNamDivisionType.XA, "xa_nghia_dung", 423)
    W_17311 = Ward("Xã Tân Long", 17311, VietNamDivisionType.XA, "xa_tan_long", 423)
    W_17314 = Ward("Xã Kỳ Sơn", 17314, VietNamDivisionType.XA, "xa_ky_son", 423)
    W_17317 = Ward("Xã Hương Sơn", 17317, VietNamDivisionType.XA, "xa_huong_son", 423)
    W_17320 = Ward("Xã Kỳ Tân", 17320, VietNamDivisionType.XA, "xa_ky_tan", 423)
    W_17323 = Ward("Xã Phú Sơn", 17323, VietNamDivisionType.XA, "xa_phu_son", 423)
    W_17325 = Ward("Xã Tân Hương", 17325, VietNamDivisionType.XA, "xa_tan_huong", 423)
    W_17326 = Ward("Xã Nghĩa Hành", 17326, VietNamDivisionType.XA, "xa_nghia_hanh", 423)
    W_17329 = Ward("Thị trấn Anh Sơn", 17329, VietNamDivisionType.THI_TRAN, "thi_tran_anh_son", 424)
    W_17332 = Ward("Xã Thọ Sơn", 17332, VietNamDivisionType.XA, "xa_tho_son", 424)
    W_17335 = Ward("Xã Thành Sơn", 17335, VietNamDivisionType.XA, "xa_thanh_son", 424)
    W_17338 = Ward("Xã Bình Sơn", 17338, VietNamDivisionType.XA, "xa_binh_son", 424)
    W_17341 = Ward("Xã Tam Sơn", 17341, VietNamDivisionType.XA, "xa_tam_son", 424)
    W_17344 = Ward("Xã Đỉnh Sơn", 17344, VietNamDivisionType.XA, "xa_dinh_son", 424)
    W_17347 = Ward("Xã Hùng Sơn", 17347, VietNamDivisionType.XA, "xa_hung_son", 424)
    W_17350 = Ward("Xã Cẩm Sơn", 17350, VietNamDivisionType.XA, "xa_cam_son", 424)
    W_17353 = Ward("Xã Đức Sơn", 17353, VietNamDivisionType.XA, "xa_duc_son", 424)
    W_17356 = Ward("Xã Tường Sơn", 17356, VietNamDivisionType.XA, "xa_tuong_son", 424)
    W_17357 = Ward("Xã Hoa Sơn", 17357, VietNamDivisionType.XA, "xa_hoa_son", 424)
    W_17359 = Ward("Xã Tào Sơn", 17359, VietNamDivisionType.XA, "xa_tao_son", 424)
    W_17362 = Ward("Xã Vĩnh Sơn", 17362, VietNamDivisionType.XA, "xa_vinh_son", 424)
    W_17365 = Ward("Xã Lạng Sơn", 17365, VietNamDivisionType.XA, "xa_lang_son", 424)
    W_17368 = Ward("Xã Hội Sơn", 17368, VietNamDivisionType.XA, "xa_hoi_son", 424)
    W_17371 = Ward("Xã Thạch Sơn", 17371, VietNamDivisionType.XA, "xa_thach_son", 424)
    W_17374 = Ward("Xã Phúc Sơn", 17374, VietNamDivisionType.XA, "xa_phuc_son", 424)
    W_17377 = Ward("Xã Long Sơn", 17377, VietNamDivisionType.XA, "xa_long_son", 424)
    W_17380 = Ward("Xã Khai Sơn", 17380, VietNamDivisionType.XA, "xa_khai_son", 424)
    W_17383 = Ward("Xã Lĩnh Sơn", 17383, VietNamDivisionType.XA, "xa_linh_son", 424)
    W_17386 = Ward("Xã Cao Sơn", 17386, VietNamDivisionType.XA, "xa_cao_son", 424)
    W_17389 = Ward("Thị trấn Diễn Châu", 17389, VietNamDivisionType.THI_TRAN, "thi_tran_dien_chau", 425)
    W_17392 = Ward("Xã Diễn Lâm", 17392, VietNamDivisionType.XA, "xa_dien_lam", 425)
    W_17395 = Ward("Xã Diễn Đoài", 17395, VietNamDivisionType.XA, "xa_dien_doai", 425)
    W_17398 = Ward("Xã Diễn Trường", 17398, VietNamDivisionType.XA, "xa_dien_truong", 425)
    W_17401 = Ward("Xã Diễn Yên", 17401, VietNamDivisionType.XA, "xa_dien_yen", 425)
    W_17404 = Ward("Xã Diễn Hoàng", 17404, VietNamDivisionType.XA, "xa_dien_hoang", 425)
    W_17407 = Ward("Xã Diễn Hùng", 17407, VietNamDivisionType.XA, "xa_dien_hung", 425)
    W_17410 = Ward("Xã Diễn Mỹ", 17410, VietNamDivisionType.XA, "xa_dien_my", 425)
    W_17413 = Ward("Xã Diễn Hồng", 17413, VietNamDivisionType.XA, "xa_dien_hong", 425)
    W_17416 = Ward("Xã Diễn Phong", 17416, VietNamDivisionType.XA, "xa_dien_phong", 425)
    W_17419 = Ward("Xã Diễn Hải", 17419, VietNamDivisionType.XA, "xa_dien_hai", 425)
    W_17422 = Ward("Xã Diễn Tháp", 17422, VietNamDivisionType.XA, "xa_dien_thap", 425)
    W_17425 = Ward("Xã Diễn Liên", 17425, VietNamDivisionType.XA, "xa_dien_lien", 425)
    W_17428 = Ward("Xã Diễn Vạn", 17428, VietNamDivisionType.XA, "xa_dien_van", 425)
    W_17431 = Ward("Xã Diễn Kim", 17431, VietNamDivisionType.XA, "xa_dien_kim", 425)
    W_17434 = Ward("Xã Diễn Kỷ", 17434, VietNamDivisionType.XA, "xa_dien_ky", 425)
    W_17437 = Ward("Xã Diễn Xuân", 17437, VietNamDivisionType.XA, "xa_dien_xuan", 425)
    W_17440 = Ward("Xã Diễn Thái", 17440, VietNamDivisionType.XA, "xa_dien_thai", 425)
    W_17443 = Ward("Xã Diễn Đồng", 17443, VietNamDivisionType.XA, "xa_dien_dong", 425)
    W_17446 = Ward("Xã Diễn Bích", 17446, VietNamDivisionType.XA, "xa_dien_bich", 425)
    W_17449 = Ward("Xã Diễn Hạnh", 17449, VietNamDivisionType.XA, "xa_dien_hanh", 425)
    W_17452 = Ward("Xã Diễn Ngọc", 17452, VietNamDivisionType.XA, "xa_dien_ngoc", 425)
    W_17455 = Ward("Xã Diễn Quảng", 17455, VietNamDivisionType.XA, "xa_dien_quang", 425)
    W_17458 = Ward("Xã Diễn Nguyên", 17458, VietNamDivisionType.XA, "xa_dien_nguyen", 425)
    W_17461 = Ward("Xã Diễn Hoa", 17461, VietNamDivisionType.XA, "xa_dien_hoa", 425)
    W_17464 = Ward("Xã Diễn Thành", 17464, VietNamDivisionType.XA, "xa_dien_thanh", 425)
    W_17467 = Ward("Xã Diễn Phúc", 17467, VietNamDivisionType.XA, "xa_dien_phuc", 425)
    W_17476 = Ward("Xã Diễn Cát", 17476, VietNamDivisionType.XA, "xa_dien_cat", 425)
    W_17479 = Ward("Xã Diễn Thịnh", 17479, VietNamDivisionType.XA, "xa_dien_thinh", 425)
    W_17482 = Ward("Xã Diễn Tân", 17482, VietNamDivisionType.XA, "xa_dien_tan", 425)
    W_17485 = Ward("Xã Minh Châu", 17485, VietNamDivisionType.XA, "xa_minh_chau", 425)
    W_17488 = Ward("Xã Diễn Thọ", 17488, VietNamDivisionType.XA, "xa_dien_tho", 425)
    W_17491 = Ward("Xã Diễn Lợi", 17491, VietNamDivisionType.XA, "xa_dien_loi", 425)
    W_17494 = Ward("Xã Diễn Lộc", 17494, VietNamDivisionType.XA, "xa_dien_loc", 425)
    W_17497 = Ward("Xã Diễn Trung", 17497, VietNamDivisionType.XA, "xa_dien_trung", 425)
    W_17500 = Ward("Xã Diễn An", 17500, VietNamDivisionType.XA, "xa_dien_an", 425)
    W_17503 = Ward("Xã Diễn Phú", 17503, VietNamDivisionType.XA, "xa_dien_phu", 425)
    W_17506 = Ward("Thị trấn Yên Thành", 17506, VietNamDivisionType.THI_TRAN, "thi_tran_yen_thanh", 426)
    W_17509 = Ward("Xã Mã Thành", 17509, VietNamDivisionType.XA, "xa_ma_thanh", 426)
    W_17510 = Ward("Xã Tiến Thành", 17510, VietNamDivisionType.XA, "xa_tien_thanh", 426)
    W_17512 = Ward("Xã Lăng Thành", 17512, VietNamDivisionType.XA, "xa_lang_thanh", 426)
    W_17515 = Ward("Xã Tân Thành", 17515, VietNamDivisionType.XA, "xa_tan_thanh", 426)
    W_17518 = Ward("Xã Đức Thành", 17518, VietNamDivisionType.XA, "xa_duc_thanh", 426)
    W_17521 = Ward("Xã Kim Thành", 17521, VietNamDivisionType.XA, "xa_kim_thanh", 426)
    W_17524 = Ward("Xã Hậu Thành", 17524, VietNamDivisionType.XA, "xa_hau_thanh", 426)
    W_17525 = Ward("Xã Hùng Thành", 17525, VietNamDivisionType.XA, "xa_hung_thanh", 426)
    W_17527 = Ward("Xã Đô Thành", 17527, VietNamDivisionType.XA, "xa_do_thanh", 426)
    W_17530 = Ward("Xã Thọ Thành", 17530, VietNamDivisionType.XA, "xa_tho_thanh", 426)
    W_17533 = Ward("Xã Quang Thành", 17533, VietNamDivisionType.XA, "xa_quang_thanh", 426)
    W_17536 = Ward("Xã Tây Thành", 17536, VietNamDivisionType.XA, "xa_tay_thanh", 426)
    W_17539 = Ward("Xã Phúc Thành", 17539, VietNamDivisionType.XA, "xa_phuc_thanh", 426)
    W_17542 = Ward("Xã Hồng Thành", 17542, VietNamDivisionType.XA, "xa_hong_thanh", 426)
    W_17545 = Ward("Xã Đồng Thành", 17545, VietNamDivisionType.XA, "xa_dong_thanh", 426)
    W_17548 = Ward("Xã Phú Thành", 17548, VietNamDivisionType.XA, "xa_phu_thanh", 426)
    W_17551 = Ward("Xã Hoa Thành", 17551, VietNamDivisionType.XA, "xa_hoa_thanh", 426)
    W_17554 = Ward("Xã Tăng Thành", 17554, VietNamDivisionType.XA, "xa_tang_thanh", 426)
    W_17557 = Ward("Xã Văn Thành", 17557, VietNamDivisionType.XA, "xa_van_thanh", 426)
    W_17560 = Ward("Xã Thịnh Thành", 17560, VietNamDivisionType.XA, "xa_thinh_thanh", 426)
    W_17563 = Ward("Xã Hợp Thành", 17563, VietNamDivisionType.XA, "xa_hop_thanh", 426)
    W_17566 = Ward("Xã Xuân Thành", 17566, VietNamDivisionType.XA, "xa_xuan_thanh", 426)
    W_17569 = Ward("Xã Bắc Thành", 17569, VietNamDivisionType.XA, "xa_bac_thanh", 426)
    W_17572 = Ward("Xã Nhân Thành", 17572, VietNamDivisionType.XA, "xa_nhan_thanh", 426)
    W_17575 = Ward("Xã Trung Thành", 17575, VietNamDivisionType.XA, "xa_trung_thanh", 426)
    W_17578 = Ward("Xã Long Thành", 17578, VietNamDivisionType.XA, "xa_long_thanh", 426)
    W_17581 = Ward("Xã Minh Thành", 17581, VietNamDivisionType.XA, "xa_minh_thanh", 426)
    W_17584 = Ward("Xã Nam Thành", 17584, VietNamDivisionType.XA, "xa_nam_thanh", 426)
    W_17587 = Ward("Xã Vĩnh Thành", 17587, VietNamDivisionType.XA, "xa_vinh_thanh", 426)
    W_17590 = Ward("Xã Lý Thành", 17590, VietNamDivisionType.XA, "xa_ly_thanh", 426)
    W_17593 = Ward("Xã Khánh Thành", 17593, VietNamDivisionType.XA, "xa_khanh_thanh", 426)
    W_17596 = Ward("Xã Viên Thành", 17596, VietNamDivisionType.XA, "xa_vien_thanh", 426)
    W_17599 = Ward("Xã Đại Thành", 17599, VietNamDivisionType.XA, "xa_dai_thanh", 426)
    W_17602 = Ward("Xã Liên Thành", 17602, VietNamDivisionType.XA, "xa_lien_thanh", 426)
    W_17605 = Ward("Xã Bảo Thành", 17605, VietNamDivisionType.XA, "xa_bao_thanh", 426)
    W_17608 = Ward("Xã Mỹ Thành", 17608, VietNamDivisionType.XA, "xa_my_thanh", 426)
    W_17611 = Ward("Xã Công Thành", 17611, VietNamDivisionType.XA, "xa_cong_thanh", 426)
    W_17614 = Ward("Xã Sơn Thành", 17614, VietNamDivisionType.XA, "xa_son_thanh", 426)
    W_17617 = Ward("Thị trấn Đô Lương", 17617, VietNamDivisionType.THI_TRAN, "thi_tran_do_luong", 427)
    W_17619 = Ward("Xã Giang Sơn Đông", 17619, VietNamDivisionType.XA, "xa_giang_son_dong", 427)
    W_17620 = Ward("Xã Giang Sơn Tây", 17620, VietNamDivisionType.XA, "xa_giang_son_tay", 427)
    W_17623 = Ward("Xã Lam Sơn", 17623, VietNamDivisionType.XA, "xa_lam_son", 427)
    W_17626 = Ward("Xã Bồi Sơn", 17626, VietNamDivisionType.XA, "xa_boi_son", 427)
    W_17629 = Ward("Xã Hồng Sơn", 17629, VietNamDivisionType.XA, "xa_hong_son", 427)
    W_17632 = Ward("Xã Bài Sơn", 17632, VietNamDivisionType.XA, "xa_bai_son", 427)
    W_17635 = Ward("Xã Ngọc Sơn", 17635, VietNamDivisionType.XA, "xa_ngoc_son", 427)
    W_17638 = Ward("Xã Bắc Sơn", 17638, VietNamDivisionType.XA, "xa_bac_son", 427)
    W_17641 = Ward("Xã Tràng Sơn", 17641, VietNamDivisionType.XA, "xa_trang_son", 427)
    W_17644 = Ward("Xã Thượng Sơn", 17644, VietNamDivisionType.XA, "xa_thuong_son", 427)
    W_17647 = Ward("Xã Hòa Sơn", 17647, VietNamDivisionType.XA, "xa_hoa_son", 427)
    W_17650 = Ward("Xã Đặng Sơn", 17650, VietNamDivisionType.XA, "xa_dang_son", 427)
    W_17653 = Ward("Xã Đông Sơn", 17653, VietNamDivisionType.XA, "xa_dong_son", 427)
    W_17656 = Ward("Xã Nam Sơn", 17656, VietNamDivisionType.XA, "xa_nam_son", 427)
    W_17659 = Ward("Xã Lưu Sơn", 17659, VietNamDivisionType.XA, "xa_luu_son", 427)
    W_17662 = Ward("Xã Yên Sơn", 17662, VietNamDivisionType.XA, "xa_yen_son", 427)
    W_17665 = Ward("Xã Văn Sơn", 17665, VietNamDivisionType.XA, "xa_van_son", 427)
    W_17668 = Ward("Xã Đà Sơn", 17668, VietNamDivisionType.XA, "xa_da_son", 427)
    W_17671 = Ward("Xã Lạc Sơn", 17671, VietNamDivisionType.XA, "xa_lac_son", 427)
    W_17674 = Ward("Xã Tân Sơn", 17674, VietNamDivisionType.XA, "xa_tan_son", 427)
    W_17677 = Ward("Xã Thái Sơn", 17677, VietNamDivisionType.XA, "xa_thai_son", 427)
    W_17680 = Ward("Xã Quang Sơn", 17680, VietNamDivisionType.XA, "xa_quang_son", 427)
    W_17683 = Ward("Xã Thịnh Sơn", 17683, VietNamDivisionType.XA, "xa_thinh_son", 427)
    W_17686 = Ward("Xã Trung Sơn", 17686, VietNamDivisionType.XA, "xa_trung_son", 427)
    W_17689 = Ward("Xã Xuân Sơn", 17689, VietNamDivisionType.XA, "xa_xuan_son", 427)
    W_17692 = Ward("Xã Minh Sơn", 17692, VietNamDivisionType.XA, "xa_minh_son", 427)
    W_17695 = Ward("Xã Thuận Sơn", 17695, VietNamDivisionType.XA, "xa_thuan_son", 427)
    W_17698 = Ward("Xã Nhân Sơn", 17698, VietNamDivisionType.XA, "xa_nhan_son", 427)
    W_17701 = Ward("Xã Hiến Sơn", 17701, VietNamDivisionType.XA, "xa_hien_son", 427)
    W_17704 = Ward("Xã Mỹ Sơn", 17704, VietNamDivisionType.XA, "xa_my_son", 427)
    W_17707 = Ward("Xã Trù Sơn", 17707, VietNamDivisionType.XA, "xa_tru_son", 427)
    W_17710 = Ward("Xã Đại Sơn", 17710, VietNamDivisionType.XA, "xa_dai_son", 427)
    W_17713 = Ward("Thị trấn Thanh Chương", 17713, VietNamDivisionType.THI_TRAN, "thi_tran_thanh_chuong", 428)
    W_17716 = Ward("Xã Cát Văn", 17716, VietNamDivisionType.XA, "xa_cat_van", 428)
    W_17719 = Ward("Xã Thanh Nho", 17719, VietNamDivisionType.XA, "xa_thanh_nho", 428)
    W_17722 = Ward("Xã Hạnh Lâm", 17722, VietNamDivisionType.XA, "xa_hanh_lam", 428)
    W_17723 = Ward("Xã Thanh Sơn", 17723, VietNamDivisionType.XA, "xa_thanh_son", 428)
    W_17725 = Ward("Xã Thanh Hòa", 17725, VietNamDivisionType.XA, "xa_thanh_hoa", 428)
    W_17728 = Ward("Xã Phong Thịnh", 17728, VietNamDivisionType.XA, "xa_phong_thinh", 428)
    W_17731 = Ward("Xã Thanh Phong", 17731, VietNamDivisionType.XA, "xa_thanh_phong", 428)
    W_17734 = Ward("Xã Thanh Mỹ", 17734, VietNamDivisionType.XA, "xa_thanh_my", 428)
    W_17737 = Ward("Xã Thanh Tiên", 17737, VietNamDivisionType.XA, "xa_thanh_tien", 428)
    W_17743 = Ward("Xã Thanh Liên", 17743, VietNamDivisionType.XA, "xa_thanh_lien", 428)
    W_17749 = Ward("Xã Đại Đồng", 17749, VietNamDivisionType.XA, "xa_dai_dong", 428)
    W_17752 = Ward("Xã Thanh Đồng", 17752, VietNamDivisionType.XA, "xa_thanh_dong", 428)
    W_17755 = Ward("Xã Thanh Ngọc", 17755, VietNamDivisionType.XA, "xa_thanh_ngoc", 428)
    W_17758 = Ward("Xã Thanh Hương", 17758, VietNamDivisionType.XA, "xa_thanh_huong", 428)
    W_17759 = Ward("Xã Ngọc Lâm", 17759, VietNamDivisionType.XA, "xa_ngoc_lam", 428)
    W_17761 = Ward("Xã Thanh Lĩnh", 17761, VietNamDivisionType.XA, "xa_thanh_linh", 428)
    W_17764 = Ward("Xã Đồng Văn", 17764, VietNamDivisionType.XA, "xa_dong_van", 428)
    W_17767 = Ward("Xã Ngọc Sơn", 17767, VietNamDivisionType.XA, "xa_ngoc_son", 428)
    W_17770 = Ward("Xã Thanh Thịnh", 17770, VietNamDivisionType.XA, "xa_thanh_thinh", 428)
    W_17773 = Ward("Xã Thanh An", 17773, VietNamDivisionType.XA, "xa_thanh_an", 428)
    W_17776 = Ward("Xã Thanh Chi", 17776, VietNamDivisionType.XA, "xa_thanh_chi", 428)
    W_17779 = Ward("Xã Xuân Tường", 17779, VietNamDivisionType.XA, "xa_xuan_tuong", 428)
    W_17782 = Ward("Xã Thanh Dương", 17782, VietNamDivisionType.XA, "xa_thanh_duong", 428)
    W_17785 = Ward("Xã Thanh Lương", 17785, VietNamDivisionType.XA, "xa_thanh_luong", 428)
    W_17788 = Ward("Xã Thanh Khê", 17788, VietNamDivisionType.XA, "xa_thanh_khe", 428)
    W_17791 = Ward("Xã Võ Liệt", 17791, VietNamDivisionType.XA, "xa_vo_liet", 428)
    W_17794 = Ward("Xã Thanh Long", 17794, VietNamDivisionType.XA, "xa_thanh_long", 428)
    W_17797 = Ward("Xã Thanh Thủy", 17797, VietNamDivisionType.XA, "xa_thanh_thuy", 428)
    W_17800 = Ward("Xã Thanh Khai", 17800, VietNamDivisionType.XA, "xa_thanh_khai", 428)
    W_17803 = Ward("Xã Thanh Yên", 17803, VietNamDivisionType.XA, "xa_thanh_yen", 428)
    W_17806 = Ward("Xã Thanh Hà", 17806, VietNamDivisionType.XA, "xa_thanh_ha", 428)
    W_17809 = Ward("Xã Thanh Giang", 17809, VietNamDivisionType.XA, "xa_thanh_giang", 428)
    W_17812 = Ward("Xã Thanh Tùng", 17812, VietNamDivisionType.XA, "xa_thanh_tung", 428)
    W_17815 = Ward("Xã Thanh Lâm", 17815, VietNamDivisionType.XA, "xa_thanh_lam", 428)
    W_17818 = Ward("Xã Thanh Mai", 17818, VietNamDivisionType.XA, "xa_thanh_mai", 428)
    W_17821 = Ward("Xã Thanh Xuân", 17821, VietNamDivisionType.XA, "xa_thanh_xuan", 428)
    W_17824 = Ward("Xã Thanh Đức", 17824, VietNamDivisionType.XA, "xa_thanh_duc", 428)
    W_17827 = Ward("Thị trấn Quán Hành", 17827, VietNamDivisionType.THI_TRAN, "thi_tran_quan_hanh", 429)
    W_17830 = Ward("Xã Nghi Văn", 17830, VietNamDivisionType.XA, "xa_nghi_van", 429)
    W_17833 = Ward("Xã Nghi Yên", 17833, VietNamDivisionType.XA, "xa_nghi_yen", 429)
    W_17836 = Ward("Xã Nghi Tiến", 17836, VietNamDivisionType.XA, "xa_nghi_tien", 429)
    W_17839 = Ward("Xã Nghi Hưng", 17839, VietNamDivisionType.XA, "xa_nghi_hung", 429)
    W_17842 = Ward("Xã Nghi Đồng", 17842, VietNamDivisionType.XA, "xa_nghi_dong", 429)
    W_17845 = Ward("Xã Nghi Thiết", 17845, VietNamDivisionType.XA, "xa_nghi_thiet", 429)
    W_17848 = Ward("Xã Nghi Lâm", 17848, VietNamDivisionType.XA, "xa_nghi_lam", 429)
    W_17851 = Ward("Xã Nghi Quang", 17851, VietNamDivisionType.XA, "xa_nghi_quang", 429)
    W_17854 = Ward("Xã Nghi Kiều", 17854, VietNamDivisionType.XA, "xa_nghi_kieu", 429)
    W_17857 = Ward("Xã Nghi Mỹ", 17857, VietNamDivisionType.XA, "xa_nghi_my", 429)
    W_17860 = Ward("Xã Nghi Phương", 17860, VietNamDivisionType.XA, "xa_nghi_phuong", 429)
    W_17863 = Ward("Xã Nghi Thuận", 17863, VietNamDivisionType.XA, "xa_nghi_thuan", 429)
    W_17866 = Ward("Xã Nghi Long", 17866, VietNamDivisionType.XA, "xa_nghi_long", 429)
    W_17869 = Ward("Xã Nghi Xá", 17869, VietNamDivisionType.XA, "xa_nghi_xa", 429)
    W_17875 = Ward("Xã Nghi Hoa", 17875, VietNamDivisionType.XA, "xa_nghi_hoa", 429)
    W_17878 = Ward("Xã Khánh Hợp", 17878, VietNamDivisionType.XA, "xa_khanh_hop", 429)
    W_17881 = Ward("Xã Nghi Thịnh", 17881, VietNamDivisionType.XA, "xa_nghi_thinh", 429)
    W_17884 = Ward("Xã Nghi Công Bắc", 17884, VietNamDivisionType.XA, "xa_nghi_cong_bac", 429)
    W_17887 = Ward("Xã Nghi Công Nam", 17887, VietNamDivisionType.XA, "xa_nghi_cong_nam", 429)
    W_17890 = Ward("Xã Nghi Thạch", 17890, VietNamDivisionType.XA, "xa_nghi_thach", 429)
    W_17893 = Ward("Xã Nghi Trung", 17893, VietNamDivisionType.XA, "xa_nghi_trung", 429)
    W_17896 = Ward("Xã Nghi Trường", 17896, VietNamDivisionType.XA, "xa_nghi_truong", 429)
    W_17899 = Ward("Xã Nghi Diên", 17899, VietNamDivisionType.XA, "xa_nghi_dien", 429)
    W_17902 = Ward("Xã Nghi Phong", 17902, VietNamDivisionType.XA, "xa_nghi_phong", 429)
    W_17905 = Ward("Xã Nghi Xuân", 17905, VietNamDivisionType.XA, "xa_nghi_xuan", 429)
    W_17911 = Ward("Xã Nghi Vạn", 17911, VietNamDivisionType.XA, "xa_nghi_van", 429)
    W_17917 = Ward("Xã Phúc Thọ", 17917, VietNamDivisionType.XA, "xa_phuc_tho", 429)
    W_17926 = Ward("Xã Nghi Thái", 17926, VietNamDivisionType.XA, "xa_nghi_thai", 429)
    W_17932 = Ward("Xã Nam Hưng", 17932, VietNamDivisionType.XA, "xa_nam_hung", 430)
    W_17935 = Ward("Xã Nam Nghĩa", 17935, VietNamDivisionType.XA, "xa_nam_nghia", 430)
    W_17938 = Ward("Xã Nam Thanh", 17938, VietNamDivisionType.XA, "xa_nam_thanh", 430)
    W_17941 = Ward("Xã Nam Anh", 17941, VietNamDivisionType.XA, "xa_nam_anh", 430)
    W_17944 = Ward("Xã Nam Xuân", 17944, VietNamDivisionType.XA, "xa_nam_xuan", 430)
    W_17947 = Ward("Xã Nam Thái", 17947, VietNamDivisionType.XA, "xa_nam_thai", 430)
    W_17950 = Ward("Thị trấn Nam Đàn", 17950, VietNamDivisionType.THI_TRAN, "thi_tran_nam_dan", 430)
    W_17953 = Ward("Xã Nam Lĩnh", 17953, VietNamDivisionType.XA, "xa_nam_linh", 430)
    W_17956 = Ward("Xã Nam Giang", 17956, VietNamDivisionType.XA, "xa_nam_giang", 430)
    W_17959 = Ward("Xã Xuân Hòa", 17959, VietNamDivisionType.XA, "xa_xuan_hoa", 430)
    W_17962 = Ward("Xã Hùng Tiến", 17962, VietNamDivisionType.XA, "xa_hung_tien", 430)
    W_17968 = Ward("Xã Thượng Tân Lộc", 17968, VietNamDivisionType.XA, "xa_thuong_tan_loc", 430)
    W_17971 = Ward("Xã Kim Liên", 17971, VietNamDivisionType.XA, "xa_kim_lien", 430)
    W_17977 = Ward("Xã Hồng Long", 17977, VietNamDivisionType.XA, "xa_hong_long", 430)
    W_17980 = Ward("Xã Xuân Lâm", 17980, VietNamDivisionType.XA, "xa_xuan_lam", 430)
    W_17983 = Ward("Xã Nam Cát", 17983, VietNamDivisionType.XA, "xa_nam_cat", 430)
    W_17986 = Ward("Xã Khánh Sơn", 17986, VietNamDivisionType.XA, "xa_khanh_son", 430)
    W_17989 = Ward("Xã Trung Phúc Cường", 17989, VietNamDivisionType.XA, "xa_trung_phuc_cuong", 430)
    W_17998 = Ward("Xã Nam Kim", 17998, VietNamDivisionType.XA, "xa_nam_kim", 430)
    W_18001 = Ward("Thị trấn Hưng Nguyên", 18001, VietNamDivisionType.THI_TRAN, "thi_tran_hung_nguyen", 431)
    W_18004 = Ward("Xã Hưng Trung", 18004, VietNamDivisionType.XA, "xa_hung_trung", 431)
    W_18007 = Ward("Xã Hưng Yên", 18007, VietNamDivisionType.XA, "xa_hung_yen", 431)
    W_18008 = Ward("Xã Hưng Yên Bắc", 18008, VietNamDivisionType.XA, "xa_hung_yen_bac", 431)
    W_18010 = Ward("Xã Hưng Tây", 18010, VietNamDivisionType.XA, "xa_hung_tay", 431)
    W_18016 = Ward("Xã Hưng Đạo", 18016, VietNamDivisionType.XA, "xa_hung_dao", 431)
    W_18019 = Ward("Xã Hưng Mỹ", 18019, VietNamDivisionType.XA, "xa_hung_my", 431)
    W_18022 = Ward("Xã Hưng Thịnh", 18022, VietNamDivisionType.XA, "xa_hung_thinh", 431)
    W_18025 = Ward("Xã Hưng Lĩnh", 18025, VietNamDivisionType.XA, "xa_hung_linh", 431)
    W_18028 = Ward("Xã Hưng Thông", 18028, VietNamDivisionType.XA, "xa_hung_thong", 431)
    W_18031 = Ward("Xã Hưng Tân", 18031, VietNamDivisionType.XA, "xa_hung_tan", 431)
    W_18034 = Ward("Xã Hưng Lợi", 18034, VietNamDivisionType.XA, "xa_hung_loi", 431)
    W_18037 = Ward("Xã Hưng Nghĩa", 18037, VietNamDivisionType.XA, "xa_hung_nghia", 431)
    W_18040 = Ward("Xã Hưng Phúc", 18040, VietNamDivisionType.XA, "xa_hung_phuc", 431)
    W_18043 = Ward("Xã Long Xá", 18043, VietNamDivisionType.XA, "xa_long_xa", 431)
    W_18052 = Ward("Xã Châu Nhân", 18052, VietNamDivisionType.XA, "xa_chau_nhan", 431)
    W_18055 = Ward("Xã Xuân Lam", 18055, VietNamDivisionType.XA, "xa_xuan_lam", 431)
    W_18064 = Ward("Xã Hưng Thành", 18064, VietNamDivisionType.XA, "xa_hung_thanh", 431)
    W_17104 = Ward("Xã Quỳnh Vinh", 17104, VietNamDivisionType.XA, "xa_quynh_vinh", 432)
    W_17107 = Ward("Xã Quỳnh Lộc", 17107, VietNamDivisionType.XA, "xa_quynh_loc", 432)
    W_17110 = Ward("Phường Quỳnh Thiện", 17110, VietNamDivisionType.PHUONG, "phuong_quynh_thien", 432)
    W_17113 = Ward("Xã Quỳnh Lập", 17113, VietNamDivisionType.XA, "xa_quynh_lap", 432)
    W_17116 = Ward("Xã Quỳnh Trang", 17116, VietNamDivisionType.XA, "xa_quynh_trang", 432)
    W_17125 = Ward("Phường Mai Hùng", 17125, VietNamDivisionType.PHUONG, "phuong_mai_hung", 432)
    W_17128 = Ward("Phường Quỳnh Dị", 17128, VietNamDivisionType.PHUONG, "phuong_quynh_di", 432)
    W_17131 = Ward("Phường Quỳnh Xuân", 17131, VietNamDivisionType.PHUONG, "phuong_quynh_xuan", 432)
    W_17134 = Ward("Phường Quỳnh Phương", 17134, VietNamDivisionType.PHUONG, "phuong_quynh_phuong", 432)
    W_17137 = Ward("Xã Quỳnh Liên", 17137, VietNamDivisionType.XA, "xa_quynh_lien", 432)
    W_18070 = Ward("Phường Trần Phú", 18070, VietNamDivisionType.PHUONG, "phuong_tran_phu", 436)
    W_18073 = Ward("Phường Nam Hà", 18073, VietNamDivisionType.PHUONG, "phuong_nam_ha", 436)
    W_18076 = Ward("Phường Bắc Hà", 18076, VietNamDivisionType.PHUONG, "phuong_bac_ha", 436)
    W_18077 = Ward("Phường Nguyễn Du", 18077, VietNamDivisionType.PHUONG, "phuong_nguyen_du", 436)
    W_18079 = Ward("Phường Tân Giang", 18079, VietNamDivisionType.PHUONG, "phuong_tan_giang", 436)
    W_18082 = Ward("Phường Đại Nài", 18082, VietNamDivisionType.PHUONG, "phuong_dai_nai", 436)
    W_18085 = Ward("Phường Hà Huy Tập", 18085, VietNamDivisionType.PHUONG, "phuong_ha_huy_tap", 436)
    W_18088 = Ward("Xã Thạch Trung", 18088, VietNamDivisionType.XA, "xa_thach_trung", 436)
    W_18091 = Ward("Phường Thạch Quý", 18091, VietNamDivisionType.PHUONG, "phuong_thach_quy", 436)
    W_18094 = Ward("Phường Thạch Linh", 18094, VietNamDivisionType.PHUONG, "phuong_thach_linh", 436)
    W_18097 = Ward("Phường Văn Yên", 18097, VietNamDivisionType.PHUONG, "phuong_van_yen", 436)
    W_18100 = Ward("Xã Thạch Hạ", 18100, VietNamDivisionType.XA, "xa_thach_ha", 436)
    W_18103 = Ward("Xã Đồng Môn", 18103, VietNamDivisionType.XA, "xa_dong_mon", 436)
    W_18109 = Ward("Xã Thạch Hưng", 18109, VietNamDivisionType.XA, "xa_thach_hung", 436)
    W_18112 = Ward("Xã Thạch Bình", 18112, VietNamDivisionType.XA, "xa_thach_binh", 436)
    W_18115 = Ward("Phường Bắc Hồng", 18115, VietNamDivisionType.PHUONG, "phuong_bac_hong", 437)
    W_18118 = Ward("Phường Nam Hồng", 18118, VietNamDivisionType.PHUONG, "phuong_nam_hong", 437)
    W_18121 = Ward("Phường Trung Lương", 18121, VietNamDivisionType.PHUONG, "phuong_trung_luong", 437)
    W_18124 = Ward("Phường Đức Thuận", 18124, VietNamDivisionType.PHUONG, "phuong_duc_thuan", 437)
    W_18127 = Ward("Phường Đậu Liêu", 18127, VietNamDivisionType.PHUONG, "phuong_dau_lieu", 437)
    W_18130 = Ward("Xã Thuận Lộc", 18130, VietNamDivisionType.XA, "xa_thuan_loc", 437)
    W_18133 = Ward("Thị trấn Phố Châu", 18133, VietNamDivisionType.THI_TRAN, "thi_tran_pho_chau", 439)
    W_18136 = Ward("Thị trấn Tây Sơn", 18136, VietNamDivisionType.THI_TRAN, "thi_tran_tay_son", 439)
    W_18139 = Ward("Xã Sơn Hồng", 18139, VietNamDivisionType.XA, "xa_son_hong", 439)
    W_18142 = Ward("Xã Sơn Tiến", 18142, VietNamDivisionType.XA, "xa_son_tien", 439)
    W_18145 = Ward("Xã Sơn Lâm", 18145, VietNamDivisionType.XA, "xa_son_lam", 439)
    W_18148 = Ward("Xã Sơn Lễ", 18148, VietNamDivisionType.XA, "xa_son_le", 439)
    W_18157 = Ward("Xã Sơn Giang", 18157, VietNamDivisionType.XA, "xa_son_giang", 439)
    W_18160 = Ward("Xã Sơn Lĩnh", 18160, VietNamDivisionType.XA, "xa_son_linh", 439)
    W_18163 = Ward("Xã An Hòa Thịnh", 18163, VietNamDivisionType.XA, "xa_an_hoa_thinh", 439)
    W_18172 = Ward("Xã Sơn Tây", 18172, VietNamDivisionType.XA, "xa_son_tay", 439)
    W_18175 = Ward("Xã Sơn Ninh", 18175, VietNamDivisionType.XA, "xa_son_ninh", 439)
    W_18178 = Ward("Xã Sơn Châu", 18178, VietNamDivisionType.XA, "xa_son_chau", 439)
    W_18181 = Ward("Xã Tân Mỹ Hà", 18181, VietNamDivisionType.XA, "xa_tan_my_ha", 439)
    W_18184 = Ward("Xã Quang Diệm", 18184, VietNamDivisionType.XA, "xa_quang_diem", 439)
    W_18187 = Ward("Xã Sơn Trung", 18187, VietNamDivisionType.XA, "xa_son_trung", 439)
    W_18190 = Ward("Xã Sơn Bằng", 18190, VietNamDivisionType.XA, "xa_son_bang", 439)
    W_18193 = Ward("Xã Sơn Bình", 18193, VietNamDivisionType.XA, "xa_son_binh", 439)
    W_18196 = Ward("Xã Sơn Kim 1", 18196, VietNamDivisionType.XA, "xa_son_kim_1", 439)
    W_18199 = Ward("Xã Sơn Kim 2", 18199, VietNamDivisionType.XA, "xa_son_kim_2", 439)
    W_18202 = Ward("Xã Sơn Trà", 18202, VietNamDivisionType.XA, "xa_son_tra", 439)
    W_18205 = Ward("Xã Sơn Long", 18205, VietNamDivisionType.XA, "xa_son_long", 439)
    W_18211 = Ward("Xã Kim Hoa", 18211, VietNamDivisionType.XA, "xa_kim_hoa", 439)
    W_18214 = Ward("Xã Sơn Hàm", 18214, VietNamDivisionType.XA, "xa_son_ham", 439)
    W_18217 = Ward("Xã Sơn Phú", 18217, VietNamDivisionType.XA, "xa_son_phu", 439)
    W_18223 = Ward("Xã Sơn Trường", 18223, VietNamDivisionType.XA, "xa_son_truong", 439)
    W_18229 = Ward("Thị trấn Đức Thọ", 18229, VietNamDivisionType.THI_TRAN, "thi_tran_duc_tho", 440)
    W_18235 = Ward("Xã Quang Vĩnh", 18235, VietNamDivisionType.XA, "xa_quang_vinh", 440)
    W_18241 = Ward("Xã Tùng Châu", 18241, VietNamDivisionType.XA, "xa_tung_chau", 440)
    W_18244 = Ward("Xã Trường Sơn", 18244, VietNamDivisionType.XA, "xa_truong_son", 440)
    W_18247 = Ward("Xã Liên Minh", 18247, VietNamDivisionType.XA, "xa_lien_minh", 440)
    W_18253 = Ward("Xã Yên Hồ", 18253, VietNamDivisionType.XA, "xa_yen_ho", 440)
    W_18259 = Ward("Xã Tùng Ảnh", 18259, VietNamDivisionType.XA, "xa_tung_anh", 440)
    W_18262 = Ward("Xã Bùi La Nhân", 18262, VietNamDivisionType.XA, "xa_bui_la_nhan", 440)
    W_18274 = Ward("Xã Thanh Bình Thịnh", 18274, VietNamDivisionType.XA, "xa_thanh_binh_thinh", 440)
    W_18277 = Ward("Xã Lâm Trung Thủy", 18277, VietNamDivisionType.XA, "xa_lam_trung_thuy", 440)
    W_18280 = Ward("Xã Hòa Lạc", 18280, VietNamDivisionType.XA, "xa_hoa_lac", 440)
    W_18283 = Ward("Xã Tân Dân", 18283, VietNamDivisionType.XA, "xa_tan_dan", 440)
    W_18298 = Ward("Xã An Dũng", 18298, VietNamDivisionType.XA, "xa_an_dung", 440)
    W_18304 = Ward("Xã Đức Đồng", 18304, VietNamDivisionType.XA, "xa_duc_dong", 440)
    W_18307 = Ward("Xã Đức Lạng", 18307, VietNamDivisionType.XA, "xa_duc_lang", 440)
    W_18310 = Ward("Xã Tân Hương", 18310, VietNamDivisionType.XA, "xa_tan_huong", 440)
    W_18313 = Ward("Thị trấn Vũ Quang", 18313, VietNamDivisionType.THI_TRAN, "thi_tran_vu_quang", 441)
    W_18316 = Ward("Xã Ân Phú", 18316, VietNamDivisionType.XA, "xa_an_phu", 441)
    W_18319 = Ward("Xã Đức Giang", 18319, VietNamDivisionType.XA, "xa_duc_giang", 441)
    W_18322 = Ward("Xã Đức Lĩnh", 18322, VietNamDivisionType.XA, "xa_duc_linh", 441)
    W_18325 = Ward("Xã Thọ Điền", 18325, VietNamDivisionType.XA, "xa_tho_dien", 441)
    W_18328 = Ward("Xã Đức Hương", 18328, VietNamDivisionType.XA, "xa_duc_huong", 441)
    W_18331 = Ward("Xã Đức Bồng", 18331, VietNamDivisionType.XA, "xa_duc_bong", 441)
    W_18334 = Ward("Xã Đức Liên", 18334, VietNamDivisionType.XA, "xa_duc_lien", 441)
    W_18340 = Ward("Xã Hương Minh", 18340, VietNamDivisionType.XA, "xa_huong_minh", 441)
    W_18343 = Ward("Xã Quang Thọ", 18343, VietNamDivisionType.XA, "xa_quang_tho", 441)
    W_18352 = Ward("Thị trấn Xuân An", 18352, VietNamDivisionType.THI_TRAN, "thi_tran_xuan_an", 442)
    W_18355 = Ward("Xã Xuân Hội", 18355, VietNamDivisionType.XA, "xa_xuan_hoi", 442)
    W_18358 = Ward("Xã Đan Trường", 18358, VietNamDivisionType.XA, "xa_dan_truong", 442)
    W_18364 = Ward("Xã Xuân Phổ", 18364, VietNamDivisionType.XA, "xa_xuan_pho", 442)
    W_18367 = Ward("Xã Xuân Hải", 18367, VietNamDivisionType.XA, "xa_xuan_hai", 442)
    W_18370 = Ward("Xã Xuân Giang", 18370, VietNamDivisionType.XA, "xa_xuan_giang", 442)
    W_18373 = Ward("Thị trấn Tiên Điền", 18373, VietNamDivisionType.THI_TRAN, "thi_tran_tien_dien", 442)
    W_18376 = Ward("Xã Xuân Yên", 18376, VietNamDivisionType.XA, "xa_xuan_yen", 442)
    W_18379 = Ward("Xã Xuân Mỹ", 18379, VietNamDivisionType.XA, "xa_xuan_my", 442)
    W_18382 = Ward("Xã Xuân Thành", 18382, VietNamDivisionType.XA, "xa_xuan_thanh", 442)
    W_18385 = Ward("Xã Xuân Viên", 18385, VietNamDivisionType.XA, "xa_xuan_vien", 442)
    W_18388 = Ward("Xã Xuân Hồng", 18388, VietNamDivisionType.XA, "xa_xuan_hong", 442)
    W_18391 = Ward("Xã Cỗ Đạm", 18391, VietNamDivisionType.XA, "xa_co_dam", 442)
    W_18394 = Ward("Xã Xuân Liên", 18394, VietNamDivisionType.XA, "xa_xuan_lien", 442)
    W_18397 = Ward("Xã Xuân Lĩnh", 18397, VietNamDivisionType.XA, "xa_xuan_linh", 442)
    W_18400 = Ward("Xã Xuân Lam", 18400, VietNamDivisionType.XA, "xa_xuan_lam", 442)
    W_18403 = Ward("Xã Cương Gián", 18403, VietNamDivisionType.XA, "xa_cuong_gian", 442)
    W_18406 = Ward("Thị trấn Nghèn", 18406, VietNamDivisionType.THI_TRAN, "thi_tran_nghen", 443)
    W_18415 = Ward("Xã Thiên Lộc", 18415, VietNamDivisionType.XA, "xa_thien_loc", 443)
    W_18418 = Ward("Xã Thuần Thiện", 18418, VietNamDivisionType.XA, "xa_thuan_thien", 443)
    W_18427 = Ward("Xã Vượng Lộc", 18427, VietNamDivisionType.XA, "xa_vuong_loc", 443)
    W_18433 = Ward("Xã Thanh Lộc", 18433, VietNamDivisionType.XA, "xa_thanh_loc", 443)
    W_18436 = Ward("Xã Kim Song Trường", 18436, VietNamDivisionType.XA, "xa_kim_song_truong", 443)
    W_18439 = Ward("Xã Thường Nga", 18439, VietNamDivisionType.XA, "xa_thuong_nga", 443)
    W_18445 = Ward("Xã Tùng Lộc", 18445, VietNamDivisionType.XA, "xa_tung_loc", 443)
    W_18454 = Ward("Xã Phú Lộc", 18454, VietNamDivisionType.XA, "xa_phu_loc", 443)
    W_18463 = Ward("Xã Gia Hanh", 18463, VietNamDivisionType.XA, "xa_gia_hanh", 443)
    W_18466 = Ward("Xã Khánh Vĩnh Yên", 18466, VietNamDivisionType.XA, "xa_khanh_vinh_yen", 443)
    W_18472 = Ward("Xã Trung Lộc", 18472, VietNamDivisionType.XA, "xa_trung_loc", 443)
    W_18475 = Ward("Xã Xuân Lộc", 18475, VietNamDivisionType.XA, "xa_xuan_loc", 443)
    W_18478 = Ward("Xã Thượng Lộc", 18478, VietNamDivisionType.XA, "xa_thuong_loc", 443)
    W_18481 = Ward("Xã Quang Lộc", 18481, VietNamDivisionType.XA, "xa_quang_loc", 443)
    W_18484 = Ward("Thị trấn Đồng Lộc", 18484, VietNamDivisionType.THI_TRAN, "thi_tran_dong_loc", 443)
    W_18487 = Ward("Xã Mỹ Lộc", 18487, VietNamDivisionType.XA, "xa_my_loc", 443)
    W_18490 = Ward("Xã Sơn Lộc", 18490, VietNamDivisionType.XA, "xa_son_loc", 443)
    W_18496 = Ward("Thị trấn Hương Khê", 18496, VietNamDivisionType.THI_TRAN, "thi_tran_huong_khe", 444)
    W_18499 = Ward("Xã Điền Mỹ", 18499, VietNamDivisionType.XA, "xa_dien_my", 444)
    W_18502 = Ward("Xã Hà Linh", 18502, VietNamDivisionType.XA, "xa_ha_linh", 444)
    W_18505 = Ward("Xã Hương Thủy", 18505, VietNamDivisionType.XA, "xa_huong_thuy", 444)
    W_18508 = Ward("Xã Hòa Hải", 18508, VietNamDivisionType.XA, "xa_hoa_hai", 444)
    W_18514 = Ward("Xã Phúc Đồng", 18514, VietNamDivisionType.XA, "xa_phuc_dong", 444)
    W_18517 = Ward("Xã Hương Giang", 18517, VietNamDivisionType.XA, "xa_huong_giang", 444)
    W_18520 = Ward("Xã Lộc Yên", 18520, VietNamDivisionType.XA, "xa_loc_yen", 444)
    W_18523 = Ward("Xã Hương Bình", 18523, VietNamDivisionType.XA, "xa_huong_binh", 444)
    W_18526 = Ward("Xã Hương Long", 18526, VietNamDivisionType.XA, "xa_huong_long", 444)
    W_18529 = Ward("Xã Phú Gia", 18529, VietNamDivisionType.XA, "xa_phu_gia", 444)
    W_18532 = Ward("Xã Gia Phố", 18532, VietNamDivisionType.XA, "xa_gia_pho", 444)
    W_18535 = Ward("Xã Phú Phong", 18535, VietNamDivisionType.XA, "xa_phu_phong", 444)
    W_18538 = Ward("Xã Hương Đô", 18538, VietNamDivisionType.XA, "xa_huong_do", 444)
    W_18541 = Ward("Xã Hương Vĩnh", 18541, VietNamDivisionType.XA, "xa_huong_vinh", 444)
    W_18544 = Ward("Xã Hương Xuân", 18544, VietNamDivisionType.XA, "xa_huong_xuan", 444)
    W_18547 = Ward("Xã Phúc Trạch", 18547, VietNamDivisionType.XA, "xa_phuc_trach", 444)
    W_18550 = Ward("Xã Hương Trà", 18550, VietNamDivisionType.XA, "xa_huong_tra", 444)
    W_18553 = Ward("Xã Hương Trạch", 18553, VietNamDivisionType.XA, "xa_huong_trach", 444)
    W_18556 = Ward("Xã Hương Lâm", 18556, VietNamDivisionType.XA, "xa_huong_lam", 444)
    W_18559 = Ward("Xã Hương Liên", 18559, VietNamDivisionType.XA, "xa_huong_lien", 444)
    W_18562 = Ward("Thị trấn Thạch Hà", 18562, VietNamDivisionType.THI_TRAN, "thi_tran_thach_ha", 445)
    W_18565 = Ward("Xã Ngọc Sơn", 18565, VietNamDivisionType.XA, "xa_ngoc_son", 445)
    W_18571 = Ward("Xã Thạch Hải", 18571, VietNamDivisionType.XA, "xa_thach_hai", 445)
    W_18586 = Ward("Xã Thạch Kênh", 18586, VietNamDivisionType.XA, "xa_thach_kenh", 445)
    W_18589 = Ward("Xã Thạch Sơn", 18589, VietNamDivisionType.XA, "xa_thach_son", 445)
    W_18592 = Ward("Xã Thạch Liên", 18592, VietNamDivisionType.XA, "xa_thach_lien", 445)
    W_18595 = Ward("Xã Đỉnh Bàn", 18595, VietNamDivisionType.XA, "xa_dinh_ban", 445)
    W_18601 = Ward("Xã Việt Tiến", 18601, VietNamDivisionType.XA, "xa_viet_tien", 445)
    W_18604 = Ward("Xã Thạch Khê", 18604, VietNamDivisionType.XA, "xa_thach_khe", 445)
    W_18607 = Ward("Xã Thạch Long", 18607, VietNamDivisionType.XA, "xa_thach_long", 445)
    W_18619 = Ward("Xã Thạch Trị", 18619, VietNamDivisionType.XA, "xa_thach_tri", 445)
    W_18622 = Ward("Xã Thạch Lạc", 18622, VietNamDivisionType.XA, "xa_thach_lac", 445)
    W_18625 = Ward("Xã Thạch Ngọc", 18625, VietNamDivisionType.XA, "xa_thach_ngoc", 445)
    W_18628 = Ward("Xã Tượng Sơn", 18628, VietNamDivisionType.XA, "xa_tuong_son", 445)
    W_18631 = Ward("Xã Thạch Văn", 18631, VietNamDivisionType.XA, "xa_thach_van", 445)
    W_18634 = Ward("Xã Lưu Vĩnh Sơn", 18634, VietNamDivisionType.XA, "xa_luu_vinh_son", 445)
    W_18637 = Ward("Xã Thạch Thắng", 18637, VietNamDivisionType.XA, "xa_thach_thang", 445)
    W_18643 = Ward("Xã Thạch Đài", 18643, VietNamDivisionType.XA, "xa_thach_dai", 445)
    W_18649 = Ward("Xã Thạch Hội", 18649, VietNamDivisionType.XA, "xa_thach_hoi", 445)
    W_18652 = Ward("Xã Tân Lâm Hương", 18652, VietNamDivisionType.XA, "xa_tan_lam_huong", 445)
    W_18658 = Ward("Xã Thạch Xuân", 18658, VietNamDivisionType.XA, "xa_thach_xuan", 445)
    W_18667 = Ward("Xã Nam Điền", 18667, VietNamDivisionType.XA, "xa_nam_dien", 445)
    W_18673 = Ward("Thị trấn Cẩm Xuyên", 18673, VietNamDivisionType.THI_TRAN, "thi_tran_cam_xuyen", 446)
    W_18676 = Ward("Thị trấn Thiên Cầm", 18676, VietNamDivisionType.THI_TRAN, "thi_tran_thien_cam", 446)
    W_18679 = Ward("Xã Yên Hòa", 18679, VietNamDivisionType.XA, "xa_yen_hoa", 446)
    W_18682 = Ward("Xã Cẩm Dương", 18682, VietNamDivisionType.XA, "xa_cam_duong", 446)
    W_18685 = Ward("Xã Cẩm Bình", 18685, VietNamDivisionType.XA, "xa_cam_binh", 446)
    W_18691 = Ward("Xã Cẩm Vĩnh", 18691, VietNamDivisionType.XA, "xa_cam_vinh", 446)
    W_18694 = Ward("Xã Cẩm Thành", 18694, VietNamDivisionType.XA, "xa_cam_thanh", 446)
    W_18697 = Ward("Xã Cẩm Quang", 18697, VietNamDivisionType.XA, "xa_cam_quang", 446)
    W_18706 = Ward("Xã Cẩm Thạch", 18706, VietNamDivisionType.XA, "xa_cam_thach", 446)
    W_18709 = Ward("Xã Cẩm Nhượng", 18709, VietNamDivisionType.XA, "xa_cam_nhuong", 446)
    W_18712 = Ward("Xã Nam Phúc Thăng", 18712, VietNamDivisionType.XA, "xa_nam_phuc_thang", 446)
    W_18715 = Ward("Xã Cẩm Duệ", 18715, VietNamDivisionType.XA, "xa_cam_due", 446)
    W_18721 = Ward("Xã Cẩm Lĩnh", 18721, VietNamDivisionType.XA, "xa_cam_linh", 446)
    W_18724 = Ward("Xã Cẩm Quan", 18724, VietNamDivisionType.XA, "xa_cam_quan", 446)
    W_18727 = Ward("Xã Cẩm Hà", 18727, VietNamDivisionType.XA, "xa_cam_ha", 446)
    W_18730 = Ward("Xã Cẩm Lộc", 18730, VietNamDivisionType.XA, "xa_cam_loc", 446)
    W_18733 = Ward("Xã Cẩm Hưng", 18733, VietNamDivisionType.XA, "xa_cam_hung", 446)
    W_18736 = Ward("Xã Cẩm Thịnh", 18736, VietNamDivisionType.XA, "xa_cam_thinh", 446)
    W_18739 = Ward("Xã Cẩm Mỹ", 18739, VietNamDivisionType.XA, "xa_cam_my", 446)
    W_18742 = Ward("Xã Cẩm Trung", 18742, VietNamDivisionType.XA, "xa_cam_trung", 446)
    W_18745 = Ward("Xã Cẩm Sơn", 18745, VietNamDivisionType.XA, "xa_cam_son", 446)
    W_18748 = Ward("Xã Cẩm Lạc", 18748, VietNamDivisionType.XA, "xa_cam_lac", 446)
    W_18751 = Ward("Xã Cẩm Minh", 18751, VietNamDivisionType.XA, "xa_cam_minh", 446)
    W_18757 = Ward("Xã Kỳ Xuân", 18757, VietNamDivisionType.XA, "xa_ky_xuan", 447)
    W_18760 = Ward("Xã Kỳ Bắc", 18760, VietNamDivisionType.XA, "xa_ky_bac", 447)
    W_18763 = Ward("Xã Kỳ Phú", 18763, VietNamDivisionType.XA, "xa_ky_phu", 447)
    W_18766 = Ward("Xã Kỳ Phong", 18766, VietNamDivisionType.XA, "xa_ky_phong", 447)
    W_18769 = Ward("Xã Kỳ Tiến", 18769, VietNamDivisionType.XA, "xa_ky_tien", 447)
    W_18772 = Ward("Xã Kỳ Giang", 18772, VietNamDivisionType.XA, "xa_ky_giang", 447)
    W_18775 = Ward("Xã Kỳ Đồng", 18775, VietNamDivisionType.XA, "xa_ky_dong", 447)
    W_18778 = Ward("Xã Kỳ Khang", 18778, VietNamDivisionType.XA, "xa_ky_khang", 447)
    W_18784 = Ward("Xã Kỳ Văn", 18784, VietNamDivisionType.XA, "xa_ky_van", 447)
    W_18787 = Ward("Xã Kỳ Trung", 18787, VietNamDivisionType.XA, "xa_ky_trung", 447)
    W_18790 = Ward("Xã Kỳ Thọ", 18790, VietNamDivisionType.XA, "xa_ky_tho", 447)
    W_18793 = Ward("Xã Kỳ Tây", 18793, VietNamDivisionType.XA, "xa_ky_tay", 447)
    W_18799 = Ward("Xã Kỳ Thượng", 18799, VietNamDivisionType.XA, "xa_ky_thuong", 447)
    W_18802 = Ward("Xã Kỳ Hải", 18802, VietNamDivisionType.XA, "xa_ky_hai", 447)
    W_18805 = Ward("Xã Kỳ Thư", 18805, VietNamDivisionType.XA, "xa_ky_thu", 447)
    W_18811 = Ward("Xã Kỳ Châu", 18811, VietNamDivisionType.XA, "xa_ky_chau", 447)
    W_18814 = Ward("Xã Kỳ Tân", 18814, VietNamDivisionType.XA, "xa_ky_tan", 447)
    W_18838 = Ward("Xã Lâm Hợp", 18838, VietNamDivisionType.XA, "xa_lam_hop", 447)
    W_18844 = Ward("Xã Kỳ Sơn", 18844, VietNamDivisionType.XA, "xa_ky_son", 447)
    W_18850 = Ward("Xã Kỳ Lạc", 18850, VietNamDivisionType.XA, "xa_ky_lac", 447)
    W_18409 = Ward("Xã Tân Lộc", 18409, VietNamDivisionType.XA, "xa_tan_loc", 448)
    W_18412 = Ward("Xã Hồng Lộc", 18412, VietNamDivisionType.XA, "xa_hong_loc", 448)
    W_18421 = Ward("Xã Thịnh Lộc", 18421, VietNamDivisionType.XA, "xa_thinh_loc", 448)
    W_18430 = Ward("Xã Bình An", 18430, VietNamDivisionType.XA, "xa_binh_an", 448)
    W_18457 = Ward("Xã Ích Hậu", 18457, VietNamDivisionType.XA, "xa_ich_hau", 448)
    W_18493 = Ward("Xã Phù Lưu", 18493, VietNamDivisionType.XA, "xa_phu_luu", 448)
    W_18568 = Ward("Thị trấn Lộc Hà", 18568, VietNamDivisionType.THI_TRAN, "thi_tran_loc_ha", 448)
    W_18577 = Ward("Xã Thạch Mỹ", 18577, VietNamDivisionType.XA, "xa_thach_my", 448)
    W_18580 = Ward("Xã Thạch Kim", 18580, VietNamDivisionType.XA, "xa_thach_kim", 448)
    W_18583 = Ward("Xã Thạch Châu", 18583, VietNamDivisionType.XA, "xa_thach_chau", 448)
    W_18598 = Ward("Xã Hộ Độ", 18598, VietNamDivisionType.XA, "xa_ho_do", 448)
    W_18670 = Ward("Xã Mai Phụ", 18670, VietNamDivisionType.XA, "xa_mai_phu", 448)
    W_18754 = Ward("Phường Hưng Trí", 18754, VietNamDivisionType.PHUONG, "phuong_hung_tri", 449)
    W_18781 = Ward("Xã Kỳ Ninh", 18781, VietNamDivisionType.XA, "xa_ky_ninh", 449)
    W_18796 = Ward("Xã Kỳ Lợi", 18796, VietNamDivisionType.XA, "xa_ky_loi", 449)
    W_18808 = Ward("Xã Kỳ Hà", 18808, VietNamDivisionType.XA, "xa_ky_ha", 449)
    W_18820 = Ward("Phường Kỳ Trinh", 18820, VietNamDivisionType.PHUONG, "phuong_ky_trinh", 449)
    W_18823 = Ward("Phường Kỳ Thịnh", 18823, VietNamDivisionType.PHUONG, "phuong_ky_thinh", 449)
    W_18829 = Ward("Xã Kỳ Hoa", 18829, VietNamDivisionType.XA, "xa_ky_hoa", 449)
    W_18832 = Ward("Phường Kỳ Phương", 18832, VietNamDivisionType.PHUONG, "phuong_ky_phuong", 449)
    W_18835 = Ward("Phường Kỳ Long", 18835, VietNamDivisionType.PHUONG, "phuong_ky_long", 449)
    W_18841 = Ward("Phường Kỳ Liên", 18841, VietNamDivisionType.PHUONG, "phuong_ky_lien", 449)
    W_18847 = Ward("Xã Kỳ Nam", 18847, VietNamDivisionType.XA, "xa_ky_nam", 449)
    W_18853 = Ward("Phường Hải Thành", 18853, VietNamDivisionType.PHUONG, "phuong_hai_thanh", 450)
    W_18856 = Ward("Phường Đồng Phú", 18856, VietNamDivisionType.PHUONG, "phuong_dong_phu", 450)
    W_18859 = Ward("Phường Bắc Lý", 18859, VietNamDivisionType.PHUONG, "phuong_bac_ly", 450)
    W_18865 = Ward("Phường Nam Lý", 18865, VietNamDivisionType.PHUONG, "phuong_nam_ly", 450)
    W_18868 = Ward("Phường Đồng Hải", 18868, VietNamDivisionType.PHUONG, "phuong_dong_hai", 450)
    W_18871 = Ward("Phường Đồng Sơn", 18871, VietNamDivisionType.PHUONG, "phuong_dong_son", 450)
    W_18874 = Ward("Phường Phú Hải", 18874, VietNamDivisionType.PHUONG, "phuong_phu_hai", 450)
    W_18877 = Ward("Phường Bắc Nghĩa", 18877, VietNamDivisionType.PHUONG, "phuong_bac_nghia", 450)
    W_18880 = Ward("Phường Đức Ninh Đông", 18880, VietNamDivisionType.PHUONG, "phuong_duc_ninh_dong", 450)
    W_18883 = Ward("Xã Quang Phú", 18883, VietNamDivisionType.XA, "xa_quang_phu", 450)
    W_18886 = Ward("Xã Lộc Ninh", 18886, VietNamDivisionType.XA, "xa_loc_ninh", 450)
    W_18889 = Ward("Xã Bảo Ninh", 18889, VietNamDivisionType.XA, "xa_bao_ninh", 450)
    W_18892 = Ward("Xã Nghĩa Ninh", 18892, VietNamDivisionType.XA, "xa_nghia_ninh", 450)
    W_18895 = Ward("Xã Thuận Đức", 18895, VietNamDivisionType.XA, "xa_thuan_duc", 450)
    W_18898 = Ward("Xã Đức Ninh", 18898, VietNamDivisionType.XA, "xa_duc_ninh", 450)
    W_18901 = Ward("Thị trấn Quy Đạt", 18901, VietNamDivisionType.THI_TRAN, "thi_tran_quy_dat", 452)
    W_18904 = Ward("Xã Dân Hóa", 18904, VietNamDivisionType.XA, "xa_dan_hoa", 452)
    W_18907 = Ward("Xã Trọng Hóa", 18907, VietNamDivisionType.XA, "xa_trong_hoa", 452)
    W_18910 = Ward("Xã Hóa Phúc", 18910, VietNamDivisionType.XA, "xa_hoa_phuc", 452)
    W_18913 = Ward("Xã Hồng Hóa", 18913, VietNamDivisionType.XA, "xa_hong_hoa", 452)
    W_18916 = Ward("Xã Hóa Thanh", 18916, VietNamDivisionType.XA, "xa_hoa_thanh", 452)
    W_18919 = Ward("Xã Hóa Tiến", 18919, VietNamDivisionType.XA, "xa_hoa_tien", 452)
    W_18922 = Ward("Xã Hóa Hợp", 18922, VietNamDivisionType.XA, "xa_hoa_hop", 452)
    W_18925 = Ward("Xã Xuân Hóa", 18925, VietNamDivisionType.XA, "xa_xuan_hoa", 452)
    W_18928 = Ward("Xã Yên Hóa", 18928, VietNamDivisionType.XA, "xa_yen_hoa", 452)
    W_18931 = Ward("Xã Minh Hóa", 18931, VietNamDivisionType.XA, "xa_minh_hoa", 452)
    W_18934 = Ward("Xã Tân Hóa", 18934, VietNamDivisionType.XA, "xa_tan_hoa", 452)
    W_18937 = Ward("Xã Hóa Sơn", 18937, VietNamDivisionType.XA, "xa_hoa_son", 452)
    W_18943 = Ward("Xã Trung Hóa", 18943, VietNamDivisionType.XA, "xa_trung_hoa", 452)
    W_18946 = Ward("Xã Thượng Hóa", 18946, VietNamDivisionType.XA, "xa_thuong_hoa", 452)
    W_18949 = Ward("Thị trấn Đồng Lê", 18949, VietNamDivisionType.THI_TRAN, "thi_tran_dong_le", 453)
    W_18952 = Ward("Xã Hương Hóa", 18952, VietNamDivisionType.XA, "xa_huong_hoa", 453)
    W_18955 = Ward("Xã Kim Hóa", 18955, VietNamDivisionType.XA, "xa_kim_hoa", 453)
    W_18958 = Ward("Xã Thanh Hóa", 18958, VietNamDivisionType.XA, "xa_thanh_hoa", 453)
    W_18961 = Ward("Xã Thanh Thạch", 18961, VietNamDivisionType.XA, "xa_thanh_thach", 453)
    W_18964 = Ward("Xã Thuận Hóa", 18964, VietNamDivisionType.XA, "xa_thuan_hoa", 453)
    W_18967 = Ward("Xã Lâm Hóa", 18967, VietNamDivisionType.XA, "xa_lam_hoa", 453)
    W_18970 = Ward("Xã Lê Hóa", 18970, VietNamDivisionType.XA, "xa_le_hoa", 453)
    W_18973 = Ward("Xã Sơn Hóa", 18973, VietNamDivisionType.XA, "xa_son_hoa", 453)
    W_18976 = Ward("Xã Đồng Hóa", 18976, VietNamDivisionType.XA, "xa_dong_hoa", 453)
    W_18979 = Ward("Xã Ngư Hóa", 18979, VietNamDivisionType.XA, "xa_ngu_hoa", 453)
    W_18985 = Ward("Xã Thạch Hóa", 18985, VietNamDivisionType.XA, "xa_thach_hoa", 453)
    W_18988 = Ward("Xã Đức Hóa", 18988, VietNamDivisionType.XA, "xa_duc_hoa", 453)
    W_18991 = Ward("Xã Phong Hóa", 18991, VietNamDivisionType.XA, "xa_phong_hoa", 453)
    W_18994 = Ward("Xã Mai Hóa", 18994, VietNamDivisionType.XA, "xa_mai_hoa", 453)
    W_18997 = Ward("Xã Tiến Hóa", 18997, VietNamDivisionType.XA, "xa_tien_hoa", 453)
    W_19000 = Ward("Xã Châu Hóa", 19000, VietNamDivisionType.XA, "xa_chau_hoa", 453)
    W_19003 = Ward("Xã Cao Quảng", 19003, VietNamDivisionType.XA, "xa_cao_quang", 453)
    W_19006 = Ward("Xã Văn Hóa", 19006, VietNamDivisionType.XA, "xa_van_hoa", 453)
    W_19012 = Ward("Xã Quảng Hợp", 19012, VietNamDivisionType.XA, "xa_quang_hop", 454)
    W_19015 = Ward("Xã Quảng Kim", 19015, VietNamDivisionType.XA, "xa_quang_kim", 454)
    W_19018 = Ward("Xã Quảng Đông", 19018, VietNamDivisionType.XA, "xa_quang_dong", 454)
    W_19021 = Ward("Xã Quảng Phú", 19021, VietNamDivisionType.XA, "xa_quang_phu", 454)
    W_19024 = Ward("Xã Quảng Châu", 19024, VietNamDivisionType.XA, "xa_quang_chau", 454)
    W_19027 = Ward("Xã Quảng Thạch", 19027, VietNamDivisionType.XA, "xa_quang_thach", 454)
    W_19030 = Ward("Xã Quảng Lưu", 19030, VietNamDivisionType.XA, "xa_quang_luu", 454)
    W_19033 = Ward("Xã Quảng Tùng", 19033, VietNamDivisionType.XA, "xa_quang_tung", 454)
    W_19036 = Ward("Xã Cảnh Dương", 19036, VietNamDivisionType.XA, "xa_canh_duong", 454)
    W_19039 = Ward("Xã Quảng Tiến", 19039, VietNamDivisionType.XA, "xa_quang_tien", 454)
    W_19042 = Ward("Xã Quảng Hưng", 19042, VietNamDivisionType.XA, "xa_quang_hung", 454)
    W_19045 = Ward("Xã Quảng Xuân", 19045, VietNamDivisionType.XA, "xa_quang_xuan", 454)
    W_19048 = Ward("Xã Cảnh Hóa", 19048, VietNamDivisionType.XA, "xa_canh_hoa", 454)
    W_19051 = Ward("Xã Liên Trường", 19051, VietNamDivisionType.XA, "xa_lien_truong", 454)
    W_19057 = Ward("Xã Quảng Phương", 19057, VietNamDivisionType.XA, "xa_quang_phuong", 454)
    W_19063 = Ward("Xã Phù Hóa", 19063, VietNamDivisionType.XA, "xa_phu_hoa", 454)
    W_19072 = Ward("Xã Quảng Thanh", 19072, VietNamDivisionType.XA, "xa_quang_thanh", 454)
    W_19111 = Ward("Thị trấn Hoàn Lão", 19111, VietNamDivisionType.THI_TRAN, "thi_tran_hoan_lao", 455)
    W_19114 = Ward("Thị trấn NT Việt Trung", 19114, VietNamDivisionType.THI_TRAN, "thi_tran_nt_viet_trung", 455)
    W_19117 = Ward("Xã Xuân Trạch", 19117, VietNamDivisionType.XA, "xa_xuan_trach", 455)
    W_19120 = Ward("Xã Mỹ Trạch", 19120, VietNamDivisionType.XA, "xa_my_trach", 455)
    W_19123 = Ward("Xã Hạ Trạch", 19123, VietNamDivisionType.XA, "xa_ha_trach", 455)
    W_19126 = Ward("Xã Bắc Trạch", 19126, VietNamDivisionType.XA, "xa_bac_trach", 455)
    W_19129 = Ward("Xã Lâm Trạch", 19129, VietNamDivisionType.XA, "xa_lam_trach", 455)
    W_19132 = Ward("Xã Thanh Trạch", 19132, VietNamDivisionType.XA, "xa_thanh_trach", 455)
    W_19135 = Ward("Xã Liên Trạch", 19135, VietNamDivisionType.XA, "xa_lien_trach", 455)
    W_19138 = Ward("Xã Phúc Trạch", 19138, VietNamDivisionType.XA, "xa_phuc_trach", 455)
    W_19141 = Ward("Xã Cự Nẫm", 19141, VietNamDivisionType.XA, "xa_cu_nam", 455)
    W_19144 = Ward("Xã Hải Phú", 19144, VietNamDivisionType.XA, "xa_hai_phu", 455)
    W_19147 = Ward("Xã Thượng Trạch", 19147, VietNamDivisionType.XA, "xa_thuong_trach", 455)
    W_19150 = Ward("Xã Sơn Lộc", 19150, VietNamDivisionType.XA, "xa_son_loc", 455)
    W_19156 = Ward("Xã Hưng Trạch", 19156, VietNamDivisionType.XA, "xa_hung_trach", 455)
    W_19159 = Ward("Xã Đồng Trạch", 19159, VietNamDivisionType.XA, "xa_dong_trach", 455)
    W_19162 = Ward("Xã Đức Trạch", 19162, VietNamDivisionType.XA, "xa_duc_trach", 455)
    W_19165 = Ward("Thị trấn Phong Nha", 19165, VietNamDivisionType.THI_TRAN, "thi_tran_phong_nha", 455)
    W_19168 = Ward("Xã Vạn Trạch", 19168, VietNamDivisionType.XA, "xa_van_trach", 455)
    W_19174 = Ward("Xã Phú Định", 19174, VietNamDivisionType.XA, "xa_phu_dinh", 455)
    W_19177 = Ward("Xã Trung Trạch", 19177, VietNamDivisionType.XA, "xa_trung_trach", 455)
    W_19180 = Ward("Xã Tây Trạch", 19180, VietNamDivisionType.XA, "xa_tay_trach", 455)
    W_19183 = Ward("Xã Hòa Trạch", 19183, VietNamDivisionType.XA, "xa_hoa_trach", 455)
    W_19186 = Ward("Xã Đại Trạch", 19186, VietNamDivisionType.XA, "xa_dai_trach", 455)
    W_19189 = Ward("Xã Nhân Trạch", 19189, VietNamDivisionType.XA, "xa_nhan_trach", 455)
    W_19192 = Ward("Xã Tân Trạch", 19192, VietNamDivisionType.XA, "xa_tan_trach", 455)
    W_19195 = Ward("Xã Nam Trạch", 19195, VietNamDivisionType.XA, "xa_nam_trach", 455)
    W_19198 = Ward("Xã Lý Trạch", 19198, VietNamDivisionType.XA, "xa_ly_trach", 455)
    W_19201 = Ward("Thị trấn Quán Hàu", 19201, VietNamDivisionType.THI_TRAN, "thi_tran_quan_hau", 456)
    W_19204 = Ward("Xã Trường Sơn", 19204, VietNamDivisionType.XA, "xa_truong_son", 456)
    W_19207 = Ward("Xã Lương Ninh", 19207, VietNamDivisionType.XA, "xa_luong_ninh", 456)
    W_19210 = Ward("Xã Vĩnh Ninh", 19210, VietNamDivisionType.XA, "xa_vinh_ninh", 456)
    W_19213 = Ward("Xã Võ Ninh", 19213, VietNamDivisionType.XA, "xa_vo_ninh", 456)
    W_19216 = Ward("Xã Hải Ninh", 19216, VietNamDivisionType.XA, "xa_hai_ninh", 456)
    W_19219 = Ward("Xã Hàm Ninh", 19219, VietNamDivisionType.XA, "xa_ham_ninh", 456)
    W_19222 = Ward("Xã Duy Ninh", 19222, VietNamDivisionType.XA, "xa_duy_ninh", 456)
    W_19225 = Ward("Xã Gia Ninh", 19225, VietNamDivisionType.XA, "xa_gia_ninh", 456)
    W_19228 = Ward("Xã Trường Xuân", 19228, VietNamDivisionType.XA, "xa_truong_xuan", 456)
    W_19231 = Ward("Xã Hiền Ninh", 19231, VietNamDivisionType.XA, "xa_hien_ninh", 456)
    W_19234 = Ward("Xã Tân Ninh", 19234, VietNamDivisionType.XA, "xa_tan_ninh", 456)
    W_19237 = Ward("Xã Xuân Ninh", 19237, VietNamDivisionType.XA, "xa_xuan_ninh", 456)
    W_19240 = Ward("Xã An Ninh", 19240, VietNamDivisionType.XA, "xa_an_ninh", 456)
    W_19243 = Ward("Xã Vạn Ninh", 19243, VietNamDivisionType.XA, "xa_van_ninh", 456)
    W_19246 = Ward("Thị trấn NT Lệ Ninh", 19246, VietNamDivisionType.THI_TRAN, "thi_tran_nt_le_ninh", 457)
    W_19249 = Ward("Thị trấn Kiến Giang", 19249, VietNamDivisionType.THI_TRAN, "thi_tran_kien_giang", 457)
    W_19252 = Ward("Xã Hồng Thủy", 19252, VietNamDivisionType.XA, "xa_hong_thuy", 457)
    W_19255 = Ward("Xã Ngư Thủy Bắc", 19255, VietNamDivisionType.XA, "xa_ngu_thuy_bac", 457)
    W_19258 = Ward("Xã Hoa Thủy", 19258, VietNamDivisionType.XA, "xa_hoa_thuy", 457)
    W_19261 = Ward("Xã Thanh Thủy", 19261, VietNamDivisionType.XA, "xa_thanh_thuy", 457)
    W_19264 = Ward("Xã An Thủy", 19264, VietNamDivisionType.XA, "xa_an_thuy", 457)
    W_19267 = Ward("Xã Phong Thủy", 19267, VietNamDivisionType.XA, "xa_phong_thuy", 457)
    W_19270 = Ward("Xã Cam Thủy", 19270, VietNamDivisionType.XA, "xa_cam_thuy", 457)
    W_19273 = Ward("Xã Ngân Thủy", 19273, VietNamDivisionType.XA, "xa_ngan_thuy", 457)
    W_19276 = Ward("Xã Sơn Thủy", 19276, VietNamDivisionType.XA, "xa_son_thuy", 457)
    W_19279 = Ward("Xã Lộc Thủy", 19279, VietNamDivisionType.XA, "xa_loc_thuy", 457)
    W_19285 = Ward("Xã Liên Thủy", 19285, VietNamDivisionType.XA, "xa_lien_thuy", 457)
    W_19288 = Ward("Xã Hưng Thủy", 19288, VietNamDivisionType.XA, "xa_hung_thuy", 457)
    W_19291 = Ward("Xã Dương Thủy", 19291, VietNamDivisionType.XA, "xa_duong_thuy", 457)
    W_19294 = Ward("Xã Tân Thủy", 19294, VietNamDivisionType.XA, "xa_tan_thuy", 457)
    W_19297 = Ward("Xã Phú Thủy", 19297, VietNamDivisionType.XA, "xa_phu_thuy", 457)
    W_19300 = Ward("Xã Xuân Thủy", 19300, VietNamDivisionType.XA, "xa_xuan_thuy", 457)
    W_19303 = Ward("Xã Mỹ Thủy", 19303, VietNamDivisionType.XA, "xa_my_thuy", 457)
    W_19306 = Ward("Xã Ngư Thủy", 19306, VietNamDivisionType.XA, "xa_ngu_thuy", 457)
    W_19309 = Ward("Xã Mai Thủy", 19309, VietNamDivisionType.XA, "xa_mai_thuy", 457)
    W_19312 = Ward("Xã Sen Thủy", 19312, VietNamDivisionType.XA, "xa_sen_thuy", 457)
    W_19315 = Ward("Xã Thái Thủy", 19315, VietNamDivisionType.XA, "xa_thai_thuy", 457)
    W_19318 = Ward("Xã Kim Thủy", 19318, VietNamDivisionType.XA, "xa_kim_thuy", 457)
    W_19321 = Ward("Xã Trường Thủy", 19321, VietNamDivisionType.XA, "xa_truong_thuy", 457)
    W_19327 = Ward("Xã Lâm Thủy", 19327, VietNamDivisionType.XA, "xa_lam_thuy", 457)
    W_19009 = Ward("Phường Ba Đồn", 19009, VietNamDivisionType.PHUONG, "phuong_ba_don", 458)
    W_19060 = Ward("Phường Quảng Long", 19060, VietNamDivisionType.PHUONG, "phuong_quang_long", 458)
    W_19066 = Ward("Phường Quảng Thọ", 19066, VietNamDivisionType.PHUONG, "phuong_quang_tho", 458)
    W_19069 = Ward("Xã Quảng Tiên", 19069, VietNamDivisionType.XA, "xa_quang_tien", 458)
    W_19075 = Ward("Xã Quảng Trung", 19075, VietNamDivisionType.XA, "xa_quang_trung", 458)
    W_19078 = Ward("Phường Quảng Phong", 19078, VietNamDivisionType.PHUONG, "phuong_quang_phong", 458)
    W_19081 = Ward("Phường Quảng Thuận", 19081, VietNamDivisionType.PHUONG, "phuong_quang_thuan", 458)
    W_19084 = Ward("Xã Quảng Tân", 19084, VietNamDivisionType.XA, "xa_quang_tan", 458)
    W_19087 = Ward("Xã Quảng Hải", 19087, VietNamDivisionType.XA, "xa_quang_hai", 458)
    W_19090 = Ward("Xã Quảng Sơn", 19090, VietNamDivisionType.XA, "xa_quang_son", 458)
    W_19093 = Ward("Xã Quảng Lộc", 19093, VietNamDivisionType.XA, "xa_quang_loc", 458)
    W_19096 = Ward("Xã Quảng Thủy", 19096, VietNamDivisionType.XA, "xa_quang_thuy", 458)
    W_19099 = Ward("Xã Quảng Văn", 19099, VietNamDivisionType.XA, "xa_quang_van", 458)
    W_19102 = Ward("Phường Quảng Phúc", 19102, VietNamDivisionType.PHUONG, "phuong_quang_phuc", 458)
    W_19105 = Ward("Xã Quảng Hòa", 19105, VietNamDivisionType.XA, "xa_quang_hoa", 458)
    W_19108 = Ward("Xã Quảng Minh", 19108, VietNamDivisionType.XA, "xa_quang_minh", 458)
    W_19330 = Ward("Phường Đông Giang", 19330, VietNamDivisionType.PHUONG, "phuong_dong_giang", 461)
    W_19333 = Ward("Phường 1", 19333, VietNamDivisionType.PHUONG, "phuong_1", 461)
    W_19336 = Ward("Phường Đông Lễ", 19336, VietNamDivisionType.PHUONG, "phuong_dong_le", 461)
    W_19339 = Ward("Phường Đông Thanh", 19339, VietNamDivisionType.PHUONG, "phuong_dong_thanh", 461)
    W_19342 = Ward("Phường 2", 19342, VietNamDivisionType.PHUONG, "phuong_2", 461)
    W_19345 = Ward("Phường 4", 19345, VietNamDivisionType.PHUONG, "phuong_4", 461)
    W_19348 = Ward("Phường 5", 19348, VietNamDivisionType.PHUONG, "phuong_5", 461)
    W_19351 = Ward("Phường Đông Lương", 19351, VietNamDivisionType.PHUONG, "phuong_dong_luong", 461)
    W_19354 = Ward("Phường 3", 19354, VietNamDivisionType.PHUONG, "phuong_3", 461)
    W_19357 = Ward("Phường 1", 19357, VietNamDivisionType.PHUONG, "phuong_1", 462)
    W_19358 = Ward("Phường An Đôn", 19358, VietNamDivisionType.PHUONG, "phuong_an_don", 462)
    W_19360 = Ward("Phường 2", 19360, VietNamDivisionType.PHUONG, "phuong_2", 462)
    W_19361 = Ward("Phường 3", 19361, VietNamDivisionType.PHUONG, "phuong_3", 462)
    W_19705 = Ward("Xã Hải Lệ", 19705, VietNamDivisionType.XA, "xa_hai_le", 462)
    W_19363 = Ward("Thị trấn Hồ Xá", 19363, VietNamDivisionType.THI_TRAN, "thi_tran_ho_xa", 464)
    W_19366 = Ward("Thị trấn Bến Quan", 19366, VietNamDivisionType.THI_TRAN, "thi_tran_ben_quan", 464)
    W_19369 = Ward("Xã Vĩnh Thái", 19369, VietNamDivisionType.XA, "xa_vinh_thai", 464)
    W_19372 = Ward("Xã Vĩnh Tú", 19372, VietNamDivisionType.XA, "xa_vinh_tu", 464)
    W_19375 = Ward("Xã Vĩnh Chấp", 19375, VietNamDivisionType.XA, "xa_vinh_chap", 464)
    W_19378 = Ward("Xã Trung Nam", 19378, VietNamDivisionType.XA, "xa_trung_nam", 464)
    W_19384 = Ward("Xã Kim Thạch", 19384, VietNamDivisionType.XA, "xa_kim_thach", 464)
    W_19387 = Ward("Xã Vĩnh Long", 19387, VietNamDivisionType.XA, "xa_vinh_long", 464)
    W_19393 = Ward("Xã Vĩnh Khê", 19393, VietNamDivisionType.XA, "xa_vinh_khe", 464)
    W_19396 = Ward("Xã Vĩnh Hòa", 19396, VietNamDivisionType.XA, "xa_vinh_hoa", 464)
    W_19402 = Ward("Xã Vĩnh Thủy", 19402, VietNamDivisionType.XA, "xa_vinh_thuy", 464)
    W_19405 = Ward("Xã Vĩnh Lâm", 19405, VietNamDivisionType.XA, "xa_vinh_lam", 464)
    W_19408 = Ward("Xã Hiền Thành", 19408, VietNamDivisionType.XA, "xa_hien_thanh", 464)
    W_19414 = Ward("Thị trấn Cửa Tùng", 19414, VietNamDivisionType.THI_TRAN, "thi_tran_cua_tung", 464)
    W_19417 = Ward("Xã Vĩnh Hà", 19417, VietNamDivisionType.XA, "xa_vinh_ha", 464)
    W_19420 = Ward("Xã Vĩnh Sơn", 19420, VietNamDivisionType.XA, "xa_vinh_son", 464)
    W_19423 = Ward("Xã Vĩnh Giang", 19423, VietNamDivisionType.XA, "xa_vinh_giang", 464)
    W_19426 = Ward("Xã Vĩnh Ô", 19426, VietNamDivisionType.XA, "xa_vinh_o", 464)
    W_19429 = Ward("Thị trấn Khe Sanh", 19429, VietNamDivisionType.THI_TRAN, "thi_tran_khe_sanh", 465)
    W_19432 = Ward("Thị trấn Lao Bảo", 19432, VietNamDivisionType.THI_TRAN, "thi_tran_lao_bao", 465)
    W_19435 = Ward("Xã Hướng Lập", 19435, VietNamDivisionType.XA, "xa_huong_lap", 465)
    W_19438 = Ward("Xã Hướng Việt", 19438, VietNamDivisionType.XA, "xa_huong_viet", 465)
    W_19441 = Ward("Xã Hướng Phùng", 19441, VietNamDivisionType.XA, "xa_huong_phung", 465)
    W_19444 = Ward("Xã Hướng Sơn", 19444, VietNamDivisionType.XA, "xa_huong_son", 465)
    W_19447 = Ward("Xã Hướng Linh", 19447, VietNamDivisionType.XA, "xa_huong_linh", 465)
    W_19450 = Ward("Xã Tân Hợp", 19450, VietNamDivisionType.XA, "xa_tan_hop", 465)
    W_19453 = Ward("Xã Hướng Tân", 19453, VietNamDivisionType.XA, "xa_huong_tan", 465)
    W_19456 = Ward("Xã Tân Thành", 19456, VietNamDivisionType.XA, "xa_tan_thanh", 465)
    W_19459 = Ward("Xã Tân Long", 19459, VietNamDivisionType.XA, "xa_tan_long", 465)
    W_19462 = Ward("Xã Tân Lập", 19462, VietNamDivisionType.XA, "xa_tan_lap", 465)
    W_19465 = Ward("Xã Tân Liên", 19465, VietNamDivisionType.XA, "xa_tan_lien", 465)
    W_19468 = Ward("Xã Húc", 19468, VietNamDivisionType.XA, "xa_huc", 465)
    W_19471 = Ward("Xã Thuận", 19471, VietNamDivisionType.XA, "xa_thuan", 465)
    W_19474 = Ward("Xã Hướng Lộc", 19474, VietNamDivisionType.XA, "xa_huong_loc", 465)
    W_19477 = Ward("Xã Ba Tầng", 19477, VietNamDivisionType.XA, "xa_ba_tang", 465)
    W_19480 = Ward("Xã Thanh", 19480, VietNamDivisionType.XA, "xa_thanh", 465)
    W_19483 = Ward("Xã A Dơi", 19483, VietNamDivisionType.XA, "xa_a_doi", 465)
    W_19489 = Ward("Xã Lìa", 19489, VietNamDivisionType.XA, "xa_lia", 465)
    W_19492 = Ward("Xã Xy", 19492, VietNamDivisionType.XA, "xa_xy", 465)
    W_19495 = Ward("Thị trấn Gio Linh", 19495, VietNamDivisionType.THI_TRAN, "thi_tran_gio_linh", 466)
    W_19496 = Ward("Thị trấn Cửa Việt", 19496, VietNamDivisionType.THI_TRAN, "thi_tran_cua_viet", 466)
    W_19498 = Ward("Xã Trung Giang", 19498, VietNamDivisionType.XA, "xa_trung_giang", 466)
    W_19501 = Ward("Xã Trung Hải", 19501, VietNamDivisionType.XA, "xa_trung_hai", 466)
    W_19504 = Ward("Xã Trung Sơn", 19504, VietNamDivisionType.XA, "xa_trung_son", 466)
    W_19507 = Ward("Xã Phong Bình", 19507, VietNamDivisionType.XA, "xa_phong_binh", 466)
    W_19510 = Ward("Xã Gio Mỹ", 19510, VietNamDivisionType.XA, "xa_gio_my", 466)
    W_19519 = Ward("Xã Gio Hải", 19519, VietNamDivisionType.XA, "xa_gio_hai", 466)
    W_19522 = Ward("Xã Gio An", 19522, VietNamDivisionType.XA, "xa_gio_an", 466)
    W_19525 = Ward("Xã Gio Châu", 19525, VietNamDivisionType.XA, "xa_gio_chau", 466)
    W_19531 = Ward("Xã Gio Việt", 19531, VietNamDivisionType.XA, "xa_gio_viet", 466)
    W_19534 = Ward("Xã Linh Trường", 19534, VietNamDivisionType.XA, "xa_linh_truong", 466)
    W_19537 = Ward("Xã Gio Sơn", 19537, VietNamDivisionType.XA, "xa_gio_son", 466)
    W_19543 = Ward("Xã Gio Mai", 19543, VietNamDivisionType.XA, "xa_gio_mai", 466)
    W_19546 = Ward("Xã Hải Thái", 19546, VietNamDivisionType.XA, "xa_hai_thai", 466)
    W_19549 = Ward("Xã Linh Hải", 19549, VietNamDivisionType.XA, "xa_linh_hai", 466)
    W_19552 = Ward("Xã Gio Quang", 19552, VietNamDivisionType.XA, "xa_gio_quang", 466)
    W_19555 = Ward("Thị trấn Krông Klang", 19555, VietNamDivisionType.THI_TRAN, "thi_tran_krong_klang", 467)
    W_19558 = Ward("Xã Mò Ó", 19558, VietNamDivisionType.XA, "xa_mo_o", 467)
    W_19561 = Ward("Xã Hướng Hiệp", 19561, VietNamDivisionType.XA, "xa_huong_hiep", 467)
    W_19564 = Ward("Xã Đa Krông", 19564, VietNamDivisionType.XA, "xa_da_krong", 467)
    W_19567 = Ward("Xã Triệu Nguyên", 19567, VietNamDivisionType.XA, "xa_trieu_nguyen", 467)
    W_19570 = Ward("Xã Ba Lòng", 19570, VietNamDivisionType.XA, "xa_ba_long", 467)
    W_19576 = Ward("Xã Ba Nang", 19576, VietNamDivisionType.XA, "xa_ba_nang", 467)
    W_19579 = Ward("Xã Tà Long", 19579, VietNamDivisionType.XA, "xa_ta_long", 467)
    W_19582 = Ward("Xã Húc Nghì", 19582, VietNamDivisionType.XA, "xa_huc_nghi", 467)
    W_19585 = Ward("Xã A Vao", 19585, VietNamDivisionType.XA, "xa_a_vao", 467)
    W_19588 = Ward("Xã Tà Rụt", 19588, VietNamDivisionType.XA, "xa_ta_rut", 467)
    W_19591 = Ward("Xã A Bung", 19591, VietNamDivisionType.XA, "xa_a_bung", 467)
    W_19594 = Ward("Xã A Ngo", 19594, VietNamDivisionType.XA, "xa_a_ngo", 467)
    W_19597 = Ward("Thị trấn Cam Lộ", 19597, VietNamDivisionType.THI_TRAN, "thi_tran_cam_lo", 468)
    W_19600 = Ward("Xã Cam Tuyền", 19600, VietNamDivisionType.XA, "xa_cam_tuyen", 468)
    W_19603 = Ward("Xã Thanh An", 19603, VietNamDivisionType.XA, "xa_thanh_an", 468)
    W_19606 = Ward("Xã Cam Thủy", 19606, VietNamDivisionType.XA, "xa_cam_thuy", 468)
    W_19612 = Ward("Xã Cam Thành", 19612, VietNamDivisionType.XA, "xa_cam_thanh", 468)
    W_19615 = Ward("Xã Cam Hiếu", 19615, VietNamDivisionType.XA, "xa_cam_hieu", 468)
    W_19618 = Ward("Xã Cam Chính", 19618, VietNamDivisionType.XA, "xa_cam_chinh", 468)
    W_19621 = Ward("Xã Cam Nghĩa", 19621, VietNamDivisionType.XA, "xa_cam_nghia", 468)
    W_19624 = Ward("Thị trấn Ái Tử", 19624, VietNamDivisionType.THI_TRAN, "thi_tran_ai_tu", 469)
    W_19627 = Ward("Xã Triệu An", 19627, VietNamDivisionType.XA, "xa_trieu_an", 469)
    W_19630 = Ward("Xã Triệu Vân", 19630, VietNamDivisionType.XA, "xa_trieu_van", 469)
    W_19633 = Ward("Xã Triệu Phước", 19633, VietNamDivisionType.XA, "xa_trieu_phuoc", 469)
    W_19636 = Ward("Xã Triệu Độ", 19636, VietNamDivisionType.XA, "xa_trieu_do", 469)
    W_19639 = Ward("Xã Triệu Trạch", 19639, VietNamDivisionType.XA, "xa_trieu_trach", 469)
    W_19642 = Ward("Xã Triệu Thuận", 19642, VietNamDivisionType.XA, "xa_trieu_thuan", 469)
    W_19645 = Ward("Xã Triệu Đại", 19645, VietNamDivisionType.XA, "xa_trieu_dai", 469)
    W_19648 = Ward("Xã Triệu Hòa", 19648, VietNamDivisionType.XA, "xa_trieu_hoa", 469)
    W_19651 = Ward("Xã Triệu Lăng", 19651, VietNamDivisionType.XA, "xa_trieu_lang", 469)
    W_19654 = Ward("Xã Triệu Sơn", 19654, VietNamDivisionType.XA, "xa_trieu_son", 469)
    W_19657 = Ward("Xã Triệu Long", 19657, VietNamDivisionType.XA, "xa_trieu_long", 469)
    W_19660 = Ward("Xã Triệu Tài", 19660, VietNamDivisionType.XA, "xa_trieu_tai", 469)
    W_19666 = Ward("Xã Triệu Trung", 19666, VietNamDivisionType.XA, "xa_trieu_trung", 469)
    W_19669 = Ward("Xã Triệu Ái", 19669, VietNamDivisionType.XA, "xa_trieu_ai", 469)
    W_19672 = Ward("Xã Triệu Thượng", 19672, VietNamDivisionType.XA, "xa_trieu_thuong", 469)
    W_19675 = Ward("Xã Triệu Giang", 19675, VietNamDivisionType.XA, "xa_trieu_giang", 469)
    W_19678 = Ward("Xã Triệu Thành", 19678, VietNamDivisionType.XA, "xa_trieu_thanh", 469)
    W_19681 = Ward("Thị trấn Diên Sanh", 19681, VietNamDivisionType.THI_TRAN, "thi_tran_dien_sanh", 470)
    W_19684 = Ward("Xã Hải An", 19684, VietNamDivisionType.XA, "xa_hai_an", 470)
    W_19687 = Ward("Xã Hải Ba", 19687, VietNamDivisionType.XA, "xa_hai_ba", 470)
    W_19693 = Ward("Xã Hải Quy", 19693, VietNamDivisionType.XA, "xa_hai_quy", 470)
    W_19696 = Ward("Xã Hải Quế", 19696, VietNamDivisionType.XA, "xa_hai_que", 470)
    W_19699 = Ward("Xã Hải Hưng", 19699, VietNamDivisionType.XA, "xa_hai_hung", 470)
    W_19702 = Ward("Xã Hải Phú", 19702, VietNamDivisionType.XA, "xa_hai_phu", 470)
    W_19708 = Ward("Xã Hải Thượng", 19708, VietNamDivisionType.XA, "xa_hai_thuong", 470)
    W_19711 = Ward("Xã Hải Dương", 19711, VietNamDivisionType.XA, "xa_hai_duong", 470)
    W_19714 = Ward("Xã Hải Định", 19714, VietNamDivisionType.XA, "xa_hai_dinh", 470)
    W_19717 = Ward("Xã Hải Lâm", 19717, VietNamDivisionType.XA, "xa_hai_lam", 470)
    W_19726 = Ward("Xã Hải Phong", 19726, VietNamDivisionType.XA, "xa_hai_phong", 470)
    W_19729 = Ward("Xã Hải Trường", 19729, VietNamDivisionType.XA, "xa_hai_truong", 470)
    W_19735 = Ward("Xã Hải Sơn", 19735, VietNamDivisionType.XA, "xa_hai_son", 470)
    W_19738 = Ward("Xã Hải Chánh", 19738, VietNamDivisionType.XA, "xa_hai_chanh", 470)
    W_19741 = Ward("Xã Hải Khê", 19741, VietNamDivisionType.XA, "xa_hai_khe", 470)
    W_19744 = Ward("Phường Phú Thuận", 19744, VietNamDivisionType.PHUONG, "phuong_phu_thuan", 474)
    W_19747 = Ward("Phường Phú Bình", 19747, VietNamDivisionType.PHUONG, "phuong_phu_binh", 474)
    W_19750 = Ward("Phường Tây Lộc", 19750, VietNamDivisionType.PHUONG, "phuong_tay_loc", 474)
    W_19753 = Ward("Phường Thuận Lộc", 19753, VietNamDivisionType.PHUONG, "phuong_thuan_loc", 474)
    W_19756 = Ward("Phường Phú Hiệp", 19756, VietNamDivisionType.PHUONG, "phuong_phu_hiep", 474)
    W_19759 = Ward("Phường Phú Hậu", 19759, VietNamDivisionType.PHUONG, "phuong_phu_hau", 474)
    W_19762 = Ward("Phường Thuận Hòa", 19762, VietNamDivisionType.PHUONG, "phuong_thuan_hoa", 474)
    W_19765 = Ward("Phường Thuận Thành", 19765, VietNamDivisionType.PHUONG, "phuong_thuan_thanh", 474)
    W_19768 = Ward("Phường Phú Hòa", 19768, VietNamDivisionType.PHUONG, "phuong_phu_hoa", 474)
    W_19771 = Ward("Phường Phú Cát", 19771, VietNamDivisionType.PHUONG, "phuong_phu_cat", 474)
    W_19774 = Ward("Phường Kim Long", 19774, VietNamDivisionType.PHUONG, "phuong_kim_long", 474)
    W_19777 = Ward("Phường Vỹ Dạ", 19777, VietNamDivisionType.PHUONG, "phuong_vy_da", 474)
    W_19780 = Ward("Phường Phường Đúc", 19780, VietNamDivisionType.PHUONG, "phuong_phuong_duc", 474)
    W_19783 = Ward("Phường Vĩnh Ninh", 19783, VietNamDivisionType.PHUONG, "phuong_vinh_ninh", 474)
    W_19786 = Ward("Phường Phú Hội", 19786, VietNamDivisionType.PHUONG, "phuong_phu_hoi", 474)
    W_19789 = Ward("Phường Phú Nhuận", 19789, VietNamDivisionType.PHUONG, "phuong_phu_nhuan", 474)
    W_19792 = Ward("Phường Xuân Phú", 19792, VietNamDivisionType.PHUONG, "phuong_xuan_phu", 474)
    W_19795 = Ward("Phường Trường An", 19795, VietNamDivisionType.PHUONG, "phuong_truong_an", 474)
    W_19798 = Ward("Phường Phước Vĩnh", 19798, VietNamDivisionType.PHUONG, "phuong_phuoc_vinh", 474)
    W_19801 = Ward("Phường An Cựu", 19801, VietNamDivisionType.PHUONG, "phuong_an_cuu", 474)
    W_19803 = Ward("Phường An Hòa", 19803, VietNamDivisionType.PHUONG, "phuong_an_hoa", 474)
    W_19804 = Ward("Phường Hương Sơ", 19804, VietNamDivisionType.PHUONG, "phuong_huong_so", 474)
    W_19807 = Ward("Phường Thuỷ Biều", 19807, VietNamDivisionType.PHUONG, "phuong_thuy_bieu", 474)
    W_19810 = Ward("Phường Hương Long", 19810, VietNamDivisionType.PHUONG, "phuong_huong_long", 474)
    W_19813 = Ward("Phường Thuỷ Xuân", 19813, VietNamDivisionType.PHUONG, "phuong_thuy_xuan", 474)
    W_19815 = Ward("Phường An Đông", 19815, VietNamDivisionType.PHUONG, "phuong_an_dong", 474)
    W_19816 = Ward("Phường An Tây", 19816, VietNamDivisionType.PHUONG, "phuong_an_tay", 474)
    W_19819 = Ward("Thị trấn Phong Điền", 19819, VietNamDivisionType.THI_TRAN, "thi_tran_phong_dien", 476)
    W_19822 = Ward("Xã Điền Hương", 19822, VietNamDivisionType.XA, "xa_dien_huong", 476)
    W_19825 = Ward("Xã Điền Môn", 19825, VietNamDivisionType.XA, "xa_dien_mon", 476)
    W_19828 = Ward("Xã Điền Lộc", 19828, VietNamDivisionType.XA, "xa_dien_loc", 476)
    W_19831 = Ward("Xã Phong Bình", 19831, VietNamDivisionType.XA, "xa_phong_binh", 476)
    W_19834 = Ward("Xã Điền Hòa", 19834, VietNamDivisionType.XA, "xa_dien_hoa", 476)
    W_19837 = Ward("Xã Phong Chương", 19837, VietNamDivisionType.XA, "xa_phong_chuong", 476)
    W_19840 = Ward("Xã Phong Hải", 19840, VietNamDivisionType.XA, "xa_phong_hai", 476)
    W_19843 = Ward("Xã Điền Hải", 19843, VietNamDivisionType.XA, "xa_dien_hai", 476)
    W_19846 = Ward("Xã Phong Hòa", 19846, VietNamDivisionType.XA, "xa_phong_hoa", 476)
    W_19849 = Ward("Xã Phong Thu", 19849, VietNamDivisionType.XA, "xa_phong_thu", 476)
    W_19852 = Ward("Xã Phong Hiền", 19852, VietNamDivisionType.XA, "xa_phong_hien", 476)
    W_19855 = Ward("Xã Phong Mỹ", 19855, VietNamDivisionType.XA, "xa_phong_my", 476)
    W_19858 = Ward("Xã Phong An", 19858, VietNamDivisionType.XA, "xa_phong_an", 476)
    W_19861 = Ward("Xã Phong Xuân", 19861, VietNamDivisionType.XA, "xa_phong_xuan", 476)
    W_19864 = Ward("Xã Phong Sơn", 19864, VietNamDivisionType.XA, "xa_phong_son", 476)
    W_19867 = Ward("Thị trấn Sịa", 19867, VietNamDivisionType.THI_TRAN, "thi_tran_sia", 477)
    W_19870 = Ward("Xã Quảng Thái", 19870, VietNamDivisionType.XA, "xa_quang_thai", 477)
    W_19873 = Ward("Xã Quảng Ngạn", 19873, VietNamDivisionType.XA, "xa_quang_ngan", 477)
    W_19876 = Ward("Xã Quảng Lợi", 19876, VietNamDivisionType.XA, "xa_quang_loi", 477)
    W_19879 = Ward("Xã Quảng Công", 19879, VietNamDivisionType.XA, "xa_quang_cong", 477)
    W_19882 = Ward("Xã Quảng Phước", 19882, VietNamDivisionType.XA, "xa_quang_phuoc", 477)
    W_19885 = Ward("Xã Quảng Vinh", 19885, VietNamDivisionType.XA, "xa_quang_vinh", 477)
    W_19888 = Ward("Xã Quảng An", 19888, VietNamDivisionType.XA, "xa_quang_an", 477)
    W_19891 = Ward("Xã Quảng Thành", 19891, VietNamDivisionType.XA, "xa_quang_thanh", 477)
    W_19894 = Ward("Xã Quảng Thọ", 19894, VietNamDivisionType.XA, "xa_quang_tho", 477)
    W_19897 = Ward("Xã Quảng Phú", 19897, VietNamDivisionType.XA, "xa_quang_phu", 477)
    W_19900 = Ward("Thị trấn Thuận An", 19900, VietNamDivisionType.THI_TRAN, "thi_tran_thuan_an", 478)
    W_19903 = Ward("Xã Phú Thuận", 19903, VietNamDivisionType.XA, "xa_phu_thuan", 478)
    W_19906 = Ward("Xã Phú Dương", 19906, VietNamDivisionType.XA, "xa_phu_duong", 478)
    W_19909 = Ward("Xã Phú Mậu", 19909, VietNamDivisionType.XA, "xa_phu_mau", 478)
    W_19912 = Ward("Xã Phú An", 19912, VietNamDivisionType.XA, "xa_phu_an", 478)
    W_19915 = Ward("Xã Phú Hải", 19915, VietNamDivisionType.XA, "xa_phu_hai", 478)
    W_19918 = Ward("Xã Phú Xuân", 19918, VietNamDivisionType.XA, "xa_phu_xuan", 478)
    W_19921 = Ward("Xã Phú Diên", 19921, VietNamDivisionType.XA, "xa_phu_dien", 478)
    W_19924 = Ward("Xã Phú Thanh", 19924, VietNamDivisionType.XA, "xa_phu_thanh", 478)
    W_19927 = Ward("Xã Phú Mỹ", 19927, VietNamDivisionType.XA, "xa_phu_my", 478)
    W_19930 = Ward("Xã Phú Thượng", 19930, VietNamDivisionType.XA, "xa_phu_thuong", 478)
    W_19933 = Ward("Xã Phú Hồ", 19933, VietNamDivisionType.XA, "xa_phu_ho", 478)
    W_19936 = Ward("Xã Vinh Xuân", 19936, VietNamDivisionType.XA, "xa_vinh_xuan", 478)
    W_19939 = Ward("Xã Phú Lương", 19939, VietNamDivisionType.XA, "xa_phu_luong", 478)
    W_19942 = Ward("Thị trấn Phú Đa", 19942, VietNamDivisionType.THI_TRAN, "thi_tran_phu_da", 478)
    W_19945 = Ward("Xã Vinh Thanh", 19945, VietNamDivisionType.XA, "xa_vinh_thanh", 478)
    W_19948 = Ward("Xã Vinh An", 19948, VietNamDivisionType.XA, "xa_vinh_an", 478)
    W_19954 = Ward("Xã Phú Gia", 19954, VietNamDivisionType.XA, "xa_phu_gia", 478)
    W_19957 = Ward("Xã Vinh Hà", 19957, VietNamDivisionType.XA, "xa_vinh_ha", 478)
    W_19960 = Ward("Phường Phú Bài", 19960, VietNamDivisionType.PHUONG, "phuong_phu_bai", 479)
    W_19963 = Ward("Xã Thủy Vân", 19963, VietNamDivisionType.XA, "xa_thuy_van", 479)
    W_19966 = Ward("Xã Thủy Thanh", 19966, VietNamDivisionType.XA, "xa_thuy_thanh", 479)
    W_19969 = Ward("Phường Thủy Dương", 19969, VietNamDivisionType.PHUONG, "phuong_thuy_duong", 479)
    W_19972 = Ward("Phường Thủy Phương", 19972, VietNamDivisionType.PHUONG, "phuong_thuy_phuong", 479)
    W_19975 = Ward("Phường Thủy Châu", 19975, VietNamDivisionType.PHUONG, "phuong_thuy_chau", 479)
    W_19978 = Ward("Phường Thủy Lương", 19978, VietNamDivisionType.PHUONG, "phuong_thuy_luong", 479)
    W_19981 = Ward("Xã Thủy Bằng", 19981, VietNamDivisionType.XA, "xa_thuy_bang", 479)
    W_19984 = Ward("Xã Thủy Tân", 19984, VietNamDivisionType.XA, "xa_thuy_tan", 479)
    W_19987 = Ward("Xã Thủy Phù", 19987, VietNamDivisionType.XA, "xa_thuy_phu", 479)
    W_19990 = Ward("Xã Phú Sơn", 19990, VietNamDivisionType.XA, "xa_phu_son", 479)
    W_19993 = Ward("Xã Dương Hòa", 19993, VietNamDivisionType.XA, "xa_duong_hoa", 479)
    W_19996 = Ward("Phường Tứ Hạ", 19996, VietNamDivisionType.PHUONG, "phuong_tu_ha", 480)
    W_19999 = Ward("Xã Hải Dương", 19999, VietNamDivisionType.XA, "xa_hai_duong", 480)
    W_20002 = Ward("Xã Hương Phong", 20002, VietNamDivisionType.XA, "xa_huong_phong", 480)
    W_20005 = Ward("Xã Hương Toàn", 20005, VietNamDivisionType.XA, "xa_huong_toan", 480)
    W_20008 = Ward("Phường Hương Vân", 20008, VietNamDivisionType.PHUONG, "phuong_huong_van", 480)
    W_20011 = Ward("Phường Hương Văn", 20011, VietNamDivisionType.PHUONG, "phuong_huong_van", 480)
    W_20014 = Ward("Xã Hương Vinh", 20014, VietNamDivisionType.XA, "xa_huong_vinh", 480)
    W_20017 = Ward("Phường Hương Xuân", 20017, VietNamDivisionType.PHUONG, "phuong_huong_xuan", 480)
    W_20020 = Ward("Phường Hương Chữ", 20020, VietNamDivisionType.PHUONG, "phuong_huong_chu", 480)
    W_20023 = Ward("Phường Hương An", 20023, VietNamDivisionType.PHUONG, "phuong_huong_an", 480)
    W_20026 = Ward("Xã Hương Bình", 20026, VietNamDivisionType.XA, "xa_huong_binh", 480)
    W_20029 = Ward("Phường Hương Hồ", 20029, VietNamDivisionType.PHUONG, "phuong_huong_ho", 480)
    W_20032 = Ward("Xã Hương Thọ", 20032, VietNamDivisionType.XA, "xa_huong_tho", 480)
    W_20035 = Ward("Xã Bình Tiến", 20035, VietNamDivisionType.XA, "xa_binh_tien", 480)
    W_20041 = Ward("Xã Bình Thành", 20041, VietNamDivisionType.XA, "xa_binh_thanh", 480)
    W_20044 = Ward("Thị trấn A Lưới", 20044, VietNamDivisionType.THI_TRAN, "thi_tran_a_luoi", 481)
    W_20047 = Ward("Xã Hồng Vân", 20047, VietNamDivisionType.XA, "xa_hong_van", 481)
    W_20050 = Ward("Xã Hồng Hạ", 20050, VietNamDivisionType.XA, "xa_hong_ha", 481)
    W_20053 = Ward("Xã Hồng Kim", 20053, VietNamDivisionType.XA, "xa_hong_kim", 481)
    W_20056 = Ward("Xã Trung Sơn", 20056, VietNamDivisionType.XA, "xa_trung_son", 481)
    W_20059 = Ward("Xã Hương Nguyên", 20059, VietNamDivisionType.XA, "xa_huong_nguyen", 481)
    W_20065 = Ward("Xã Hồng Bắc", 20065, VietNamDivisionType.XA, "xa_hong_bac", 481)
    W_20068 = Ward("Xã A Ngo", 20068, VietNamDivisionType.XA, "xa_a_ngo", 481)
    W_20071 = Ward("Xã Sơn Thủy", 20071, VietNamDivisionType.XA, "xa_son_thuy", 481)
    W_20074 = Ward("Xã Phú Vinh", 20074, VietNamDivisionType.XA, "xa_phu_vinh", 481)
    W_20080 = Ward("Xã Hương Phong", 20080, VietNamDivisionType.XA, "xa_huong_phong", 481)
    W_20083 = Ward("Xã Quảng Nhâm", 20083, VietNamDivisionType.XA, "xa_quang_nham", 481)
    W_20086 = Ward("Xã Hồng Thượng", 20086, VietNamDivisionType.XA, "xa_hong_thuong", 481)
    W_20089 = Ward("Xã Hồng Thái", 20089, VietNamDivisionType.XA, "xa_hong_thai", 481)
    W_20095 = Ward("Xã A Roàng", 20095, VietNamDivisionType.XA, "xa_a_roang", 481)
    W_20098 = Ward("Xã Đông Sơn", 20098, VietNamDivisionType.XA, "xa_dong_son", 481)
    W_20101 = Ward("Xã Lâm Đớt", 20101, VietNamDivisionType.XA, "xa_lam_dot", 481)
    W_20104 = Ward("Xã Hồng Thủy", 20104, VietNamDivisionType.XA, "xa_hong_thuy", 481)
    W_20107 = Ward("Thị trấn Phú Lộc", 20107, VietNamDivisionType.THI_TRAN, "thi_tran_phu_loc", 482)
    W_20110 = Ward("Thị trấn Lăng Cô", 20110, VietNamDivisionType.THI_TRAN, "thi_tran_lang_co", 482)
    W_20113 = Ward("Xã Vinh Mỹ", 20113, VietNamDivisionType.XA, "xa_vinh_my", 482)
    W_20116 = Ward("Xã Vinh Hưng", 20116, VietNamDivisionType.XA, "xa_vinh_hung", 482)
    W_20122 = Ward("Xã Giang Hải", 20122, VietNamDivisionType.XA, "xa_giang_hai", 482)
    W_20125 = Ward("Xã Vinh Hiền", 20125, VietNamDivisionType.XA, "xa_vinh_hien", 482)
    W_20128 = Ward("Xã Lộc Bổn", 20128, VietNamDivisionType.XA, "xa_loc_bon", 482)
    W_20131 = Ward("Xã Lộc Sơn", 20131, VietNamDivisionType.XA, "xa_loc_son", 482)
    W_20134 = Ward("Xã Lộc Bình", 20134, VietNamDivisionType.XA, "xa_loc_binh", 482)
    W_20137 = Ward("Xã Lộc Vĩnh", 20137, VietNamDivisionType.XA, "xa_loc_vinh", 482)
    W_20140 = Ward("Xã Lộc An", 20140, VietNamDivisionType.XA, "xa_loc_an", 482)
    W_20143 = Ward("Xã Lộc Điền", 20143, VietNamDivisionType.XA, "xa_loc_dien", 482)
    W_20146 = Ward("Xã Lộc Thủy", 20146, VietNamDivisionType.XA, "xa_loc_thuy", 482)
    W_20149 = Ward("Xã Lộc Trì", 20149, VietNamDivisionType.XA, "xa_loc_tri", 482)
    W_20152 = Ward("Xã Lộc Tiến", 20152, VietNamDivisionType.XA, "xa_loc_tien", 482)
    W_20155 = Ward("Xã Lộc Hòa", 20155, VietNamDivisionType.XA, "xa_loc_hoa", 482)
    W_20158 = Ward("Xã Xuân Lộc", 20158, VietNamDivisionType.XA, "xa_xuan_loc", 482)
    W_20161 = Ward("Thị trấn Khe Tre", 20161, VietNamDivisionType.THI_TRAN, "thi_tran_khe_tre", 483)
    W_20164 = Ward("Xã Hương Phú", 20164, VietNamDivisionType.XA, "xa_huong_phu", 483)
    W_20167 = Ward("Xã Hương Sơn", 20167, VietNamDivisionType.XA, "xa_huong_son", 483)
    W_20170 = Ward("Xã Hương Lộc", 20170, VietNamDivisionType.XA, "xa_huong_loc", 483)
    W_20173 = Ward("Xã Thượng Quảng", 20173, VietNamDivisionType.XA, "xa_thuong_quang", 483)
    W_20179 = Ward("Xã Hương Xuân", 20179, VietNamDivisionType.XA, "xa_huong_xuan", 483)
    W_20182 = Ward("Xã Hương Hữu", 20182, VietNamDivisionType.XA, "xa_huong_huu", 483)
    W_20185 = Ward("Xã Thượng Lộ", 20185, VietNamDivisionType.XA, "xa_thuong_lo", 483)
    W_20188 = Ward("Xã Thượng Long", 20188, VietNamDivisionType.XA, "xa_thuong_long", 483)
    W_20191 = Ward("Xã Thượng Nhật", 20191, VietNamDivisionType.XA, "xa_thuong_nhat", 483)
    W_20194 = Ward("Phường Hòa Hiệp Bắc", 20194, VietNamDivisionType.PHUONG, "phuong_hoa_hiep_bac", 490)
    W_20195 = Ward("Phường Hòa Hiệp Nam", 20195, VietNamDivisionType.PHUONG, "phuong_hoa_hiep_nam", 490)
    W_20197 = Ward("Phường Hòa Khánh Bắc", 20197, VietNamDivisionType.PHUONG, "phuong_hoa_khanh_bac", 490)
    W_20198 = Ward("Phường Hòa Khánh Nam", 20198, VietNamDivisionType.PHUONG, "phuong_hoa_khanh_nam", 490)
    W_20200 = Ward("Phường Hòa Minh", 20200, VietNamDivisionType.PHUONG, "phuong_hoa_minh", 490)
    W_20203 = Ward("Phường Tam Thuận", 20203, VietNamDivisionType.PHUONG, "phuong_tam_thuan", 491)
    W_20206 = Ward("Phường Thanh Khê Tây", 20206, VietNamDivisionType.PHUONG, "phuong_thanh_khe_tay", 491)
    W_20207 = Ward("Phường Thanh Khê Đông", 20207, VietNamDivisionType.PHUONG, "phuong_thanh_khe_dong", 491)
    W_20209 = Ward("Phường Xuân Hà", 20209, VietNamDivisionType.PHUONG, "phuong_xuan_ha", 491)
    W_20212 = Ward("Phường Tân Chính", 20212, VietNamDivisionType.PHUONG, "phuong_tan_chinh", 491)
    W_20215 = Ward("Phường Chính Gián", 20215, VietNamDivisionType.PHUONG, "phuong_chinh_gian", 491)
    W_20218 = Ward("Phường Vĩnh Trung", 20218, VietNamDivisionType.PHUONG, "phuong_vinh_trung", 491)
    W_20221 = Ward("Phường Thạc Gián", 20221, VietNamDivisionType.PHUONG, "phuong_thac_gian", 491)
    W_20224 = Ward("Phường An Khê", 20224, VietNamDivisionType.PHUONG, "phuong_an_khe", 491)
    W_20225 = Ward("Phường Hòa Khê", 20225, VietNamDivisionType.PHUONG, "phuong_hoa_khe", 491)
    W_20227 = Ward("Phường Thanh Bình", 20227, VietNamDivisionType.PHUONG, "phuong_thanh_binh", 492)
    W_20230 = Ward("Phường Thuận Phước", 20230, VietNamDivisionType.PHUONG, "phuong_thuan_phuoc", 492)
    W_20233 = Ward("Phường Thạch Thang", 20233, VietNamDivisionType.PHUONG, "phuong_thach_thang", 492)
    W_20236 = Ward("Phường Hải Châu I", 20236, VietNamDivisionType.PHUONG, "phuong_hai_chau_i", 492)
    W_20239 = Ward("Phường Hải Châu II", 20239, VietNamDivisionType.PHUONG, "phuong_hai_chau_ii", 492)
    W_20242 = Ward("Phường Phước Ninh", 20242, VietNamDivisionType.PHUONG, "phuong_phuoc_ninh", 492)
    W_20245 = Ward("Phường Hòa Thuận Tây", 20245, VietNamDivisionType.PHUONG, "phuong_hoa_thuan_tay", 492)
    W_20246 = Ward("Phường Hòa Thuận Đông", 20246, VietNamDivisionType.PHUONG, "phuong_hoa_thuan_dong", 492)
    W_20248 = Ward("Phường Nam Dương", 20248, VietNamDivisionType.PHUONG, "phuong_nam_duong", 492)
    W_20251 = Ward("Phường Bình Hiên", 20251, VietNamDivisionType.PHUONG, "phuong_binh_hien", 492)
    W_20254 = Ward("Phường Bình Thuận", 20254, VietNamDivisionType.PHUONG, "phuong_binh_thuan", 492)
    W_20257 = Ward("Phường Hòa Cường Bắc", 20257, VietNamDivisionType.PHUONG, "phuong_hoa_cuong_bac", 492)
    W_20258 = Ward("Phường Hòa Cường Nam", 20258, VietNamDivisionType.PHUONG, "phuong_hoa_cuong_nam", 492)
    W_20263 = Ward("Phường Thọ Quang", 20263, VietNamDivisionType.PHUONG, "phuong_tho_quang", 493)
    W_20266 = Ward("Phường Nại Hiên Đông", 20266, VietNamDivisionType.PHUONG, "phuong_nai_hien_dong", 493)
    W_20269 = Ward("Phường Mân Thái", 20269, VietNamDivisionType.PHUONG, "phuong_man_thai", 493)
    W_20272 = Ward("Phường An Hải Bắc", 20272, VietNamDivisionType.PHUONG, "phuong_an_hai_bac", 493)
    W_20275 = Ward("Phường Phước Mỹ", 20275, VietNamDivisionType.PHUONG, "phuong_phuoc_my", 493)
    W_20278 = Ward("Phường An Hải Tây", 20278, VietNamDivisionType.PHUONG, "phuong_an_hai_tay", 493)
    W_20281 = Ward("Phường An Hải Đông", 20281, VietNamDivisionType.PHUONG, "phuong_an_hai_dong", 493)
    W_20284 = Ward("Phường Mỹ An", 20284, VietNamDivisionType.PHUONG, "phuong_my_an", 494)
    W_20285 = Ward("Phường Khuê Mỹ", 20285, VietNamDivisionType.PHUONG, "phuong_khue_my", 494)
    W_20287 = Ward("Phường Hoà Quý", 20287, VietNamDivisionType.PHUONG, "phuong_hoa_quy", 494)
    W_20290 = Ward("Phường Hoà Hải", 20290, VietNamDivisionType.PHUONG, "phuong_hoa_hai", 494)
    W_20260 = Ward("Phường Khuê Trung", 20260, VietNamDivisionType.PHUONG, "phuong_khue_trung", 495)
    W_20305 = Ward("Phường Hòa Phát", 20305, VietNamDivisionType.PHUONG, "phuong_hoa_phat", 495)
    W_20306 = Ward("Phường Hòa An", 20306, VietNamDivisionType.PHUONG, "phuong_hoa_an", 495)
    W_20311 = Ward("Phường Hòa Thọ Tây", 20311, VietNamDivisionType.PHUONG, "phuong_hoa_tho_tay", 495)
    W_20312 = Ward("Phường Hòa Thọ Đông", 20312, VietNamDivisionType.PHUONG, "phuong_hoa_tho_dong", 495)
    W_20314 = Ward("Phường Hòa Xuân", 20314, VietNamDivisionType.PHUONG, "phuong_hoa_xuan", 495)
    W_20293 = Ward("Xã Hòa Bắc", 20293, VietNamDivisionType.XA, "xa_hoa_bac", 497)
    W_20296 = Ward("Xã Hòa Liên", 20296, VietNamDivisionType.XA, "xa_hoa_lien", 497)
    W_20299 = Ward("Xã Hòa Ninh", 20299, VietNamDivisionType.XA, "xa_hoa_ninh", 497)
    W_20302 = Ward("Xã Hòa Sơn", 20302, VietNamDivisionType.XA, "xa_hoa_son", 497)
    W_20308 = Ward("Xã Hòa Nhơn", 20308, VietNamDivisionType.XA, "xa_hoa_nhon", 497)
    W_20317 = Ward("Xã Hòa Phú", 20317, VietNamDivisionType.XA, "xa_hoa_phu", 497)
    W_20320 = Ward("Xã Hòa Phong", 20320, VietNamDivisionType.XA, "xa_hoa_phong", 497)
    W_20323 = Ward("Xã Hòa Châu", 20323, VietNamDivisionType.XA, "xa_hoa_chau", 497)
    W_20326 = Ward("Xã Hòa Tiến", 20326, VietNamDivisionType.XA, "xa_hoa_tien", 497)
    W_20329 = Ward("Xã Hòa Phước", 20329, VietNamDivisionType.XA, "xa_hoa_phuoc", 497)
    W_20332 = Ward("Xã Hòa Khương", 20332, VietNamDivisionType.XA, "xa_hoa_khuong", 497)
    W_20335 = Ward("Phường Tân Thạnh", 20335, VietNamDivisionType.PHUONG, "phuong_tan_thanh", 502)
    W_20338 = Ward("Phường Phước Hòa", 20338, VietNamDivisionType.PHUONG, "phuong_phuoc_hoa", 502)
    W_20341 = Ward("Phường An Mỹ", 20341, VietNamDivisionType.PHUONG, "phuong_an_my", 502)
    W_20344 = Ward("Phường Hòa Hương", 20344, VietNamDivisionType.PHUONG, "phuong_hoa_huong", 502)
    W_20347 = Ward("Phường An Xuân", 20347, VietNamDivisionType.PHUONG, "phuong_an_xuan", 502)
    W_20350 = Ward("Phường An Sơn", 20350, VietNamDivisionType.PHUONG, "phuong_an_son", 502)
    W_20353 = Ward("Phường Trường Xuân", 20353, VietNamDivisionType.PHUONG, "phuong_truong_xuan", 502)
    W_20356 = Ward("Phường An Phú", 20356, VietNamDivisionType.PHUONG, "phuong_an_phu", 502)
    W_20359 = Ward("Xã Tam Thanh", 20359, VietNamDivisionType.XA, "xa_tam_thanh", 502)
    W_20362 = Ward("Xã Tam Thăng", 20362, VietNamDivisionType.XA, "xa_tam_thang", 502)
    W_20371 = Ward("Xã Tam Phú", 20371, VietNamDivisionType.XA, "xa_tam_phu", 502)
    W_20375 = Ward("Phường Hoà Thuận", 20375, VietNamDivisionType.PHUONG, "phuong_hoa_thuan", 502)
    W_20389 = Ward("Xã Tam Ngọc", 20389, VietNamDivisionType.XA, "xa_tam_ngoc", 502)
    W_20398 = Ward("Phường Minh An", 20398, VietNamDivisionType.PHUONG, "phuong_minh_an", 503)
    W_20401 = Ward("Phường Tân An", 20401, VietNamDivisionType.PHUONG, "phuong_tan_an", 503)
    W_20404 = Ward("Phường Cẩm Phô", 20404, VietNamDivisionType.PHUONG, "phuong_cam_pho", 503)
    W_20407 = Ward("Phường Thanh Hà", 20407, VietNamDivisionType.PHUONG, "phuong_thanh_ha", 503)
    W_20410 = Ward("Phường Sơn Phong", 20410, VietNamDivisionType.PHUONG, "phuong_son_phong", 503)
    W_20413 = Ward("Phường Cẩm Châu", 20413, VietNamDivisionType.PHUONG, "phuong_cam_chau", 503)
    W_20416 = Ward("Phường Cửa Đại", 20416, VietNamDivisionType.PHUONG, "phuong_cua_dai", 503)
    W_20419 = Ward("Phường Cẩm An", 20419, VietNamDivisionType.PHUONG, "phuong_cam_an", 503)
    W_20422 = Ward("Xã Cẩm Hà", 20422, VietNamDivisionType.XA, "xa_cam_ha", 503)
    W_20425 = Ward("Xã Cẩm Kim", 20425, VietNamDivisionType.XA, "xa_cam_kim", 503)
    W_20428 = Ward("Phường Cẩm Nam", 20428, VietNamDivisionType.PHUONG, "phuong_cam_nam", 503)
    W_20431 = Ward("Xã Cẩm Thanh", 20431, VietNamDivisionType.XA, "xa_cam_thanh", 503)
    W_20434 = Ward("Xã Tân Hiệp", 20434, VietNamDivisionType.XA, "xa_tan_hiep", 503)
    W_20437 = Ward("Xã Ch'ơm", 20437, VietNamDivisionType.XA, "xa_chom", 504)
    W_20440 = Ward("Xã Ga Ri", 20440, VietNamDivisionType.XA, "xa_ga_ri", 504)
    W_20443 = Ward("Xã A Xan", 20443, VietNamDivisionType.XA, "xa_a_xan", 504)
    W_20446 = Ward("Xã Tr'Hy", 20446, VietNamDivisionType.XA, "xa_trhy", 504)
    W_20449 = Ward("Xã Lăng", 20449, VietNamDivisionType.XA, "xa_lang", 504)
    W_20452 = Ward("Xã A Nông", 20452, VietNamDivisionType.XA, "xa_a_nong", 504)
    W_20455 = Ward("Xã A Tiêng", 20455, VietNamDivisionType.XA, "xa_a_tieng", 504)
    W_20458 = Ward("Xã Bha Lê", 20458, VietNamDivisionType.XA, "xa_bha_le", 504)
    W_20461 = Ward("Xã A Vương", 20461, VietNamDivisionType.XA, "xa_a_vuong", 504)
    W_20464 = Ward("Xã Dang", 20464, VietNamDivisionType.XA, "xa_dang", 504)
    W_20467 = Ward("Thị trấn P Rao", 20467, VietNamDivisionType.THI_TRAN, "thi_tran_p_rao", 505)
    W_20470 = Ward("Xã Tà Lu", 20470, VietNamDivisionType.XA, "xa_ta_lu", 505)
    W_20473 = Ward("Xã Sông Kôn", 20473, VietNamDivisionType.XA, "xa_song_kon", 505)
    W_20476 = Ward("Xã Jơ Ngây", 20476, VietNamDivisionType.XA, "xa_jo_ngay", 505)
    W_20479 = Ward("Xã A Ting", 20479, VietNamDivisionType.XA, "xa_a_ting", 505)
    W_20482 = Ward("Xã Tư", 20482, VietNamDivisionType.XA, "xa_tu", 505)
    W_20485 = Ward("Xã Ba", 20485, VietNamDivisionType.XA, "xa_ba", 505)
    W_20488 = Ward("Xã A Rooi", 20488, VietNamDivisionType.XA, "xa_a_rooi", 505)
    W_20491 = Ward("Xã Za Hung", 20491, VietNamDivisionType.XA, "xa_za_hung", 505)
    W_20494 = Ward("Xã Mà Cooi", 20494, VietNamDivisionType.XA, "xa_ma_cooi", 505)
    W_20497 = Ward("Xã Ka Dăng", 20497, VietNamDivisionType.XA, "xa_ka_dang", 505)
    W_20500 = Ward("Thị trấn Ái Nghĩa", 20500, VietNamDivisionType.THI_TRAN, "thi_tran_ai_nghia", 506)
    W_20503 = Ward("Xã Đại Sơn", 20503, VietNamDivisionType.XA, "xa_dai_son", 506)
    W_20506 = Ward("Xã Đại Lãnh", 20506, VietNamDivisionType.XA, "xa_dai_lanh", 506)
    W_20509 = Ward("Xã Đại Hưng", 20509, VietNamDivisionType.XA, "xa_dai_hung", 506)
    W_20512 = Ward("Xã Đại Hồng", 20512, VietNamDivisionType.XA, "xa_dai_hong", 506)
    W_20515 = Ward("Xã Đại Đồng", 20515, VietNamDivisionType.XA, "xa_dai_dong", 506)
    W_20518 = Ward("Xã Đại Quang", 20518, VietNamDivisionType.XA, "xa_dai_quang", 506)
    W_20521 = Ward("Xã Đại Nghĩa", 20521, VietNamDivisionType.XA, "xa_dai_nghia", 506)
    W_20524 = Ward("Xã Đại Hiệp", 20524, VietNamDivisionType.XA, "xa_dai_hiep", 506)
    W_20527 = Ward("Xã Đại Thạnh", 20527, VietNamDivisionType.XA, "xa_dai_thanh", 506)
    W_20530 = Ward("Xã Đại Chánh", 20530, VietNamDivisionType.XA, "xa_dai_chanh", 506)
    W_20533 = Ward("Xã Đại Tân", 20533, VietNamDivisionType.XA, "xa_dai_tan", 506)
    W_20536 = Ward("Xã Đại Phong", 20536, VietNamDivisionType.XA, "xa_dai_phong", 506)
    W_20539 = Ward("Xã Đại Minh", 20539, VietNamDivisionType.XA, "xa_dai_minh", 506)
    W_20542 = Ward("Xã Đại Thắng", 20542, VietNamDivisionType.XA, "xa_dai_thang", 506)
    W_20545 = Ward("Xã Đại Cường", 20545, VietNamDivisionType.XA, "xa_dai_cuong", 506)
    W_20547 = Ward("Xã Đại An", 20547, VietNamDivisionType.XA, "xa_dai_an", 506)
    W_20548 = Ward("Xã Đại Hòa", 20548, VietNamDivisionType.XA, "xa_dai_hoa", 506)
    W_20551 = Ward("Phường Vĩnh Điện", 20551, VietNamDivisionType.PHUONG, "phuong_vinh_dien", 507)
    W_20554 = Ward("Xã Điện Tiến", 20554, VietNamDivisionType.XA, "xa_dien_tien", 507)
    W_20557 = Ward("Xã Điện Hòa", 20557, VietNamDivisionType.XA, "xa_dien_hoa", 507)
    W_20560 = Ward("Xã Điện Thắng Bắc", 20560, VietNamDivisionType.XA, "xa_dien_thang_bac", 507)
    W_20561 = Ward("Xã Điện Thắng Trung", 20561, VietNamDivisionType.XA, "xa_dien_thang_trung", 507)
    W_20562 = Ward("Xã Điện Thắng Nam", 20562, VietNamDivisionType.XA, "xa_dien_thang_nam", 507)
    W_20563 = Ward("Phường Điện Ngọc", 20563, VietNamDivisionType.PHUONG, "phuong_dien_ngoc", 507)
    W_20566 = Ward("Xã Điện Hồng", 20566, VietNamDivisionType.XA, "xa_dien_hong", 507)
    W_20569 = Ward("Xã Điện Thọ", 20569, VietNamDivisionType.XA, "xa_dien_tho", 507)
    W_20572 = Ward("Xã Điện Phước", 20572, VietNamDivisionType.XA, "xa_dien_phuoc", 507)
    W_20575 = Ward("Phường Điện An", 20575, VietNamDivisionType.PHUONG, "phuong_dien_an", 507)
    W_20578 = Ward("Phường Điện Nam Bắc", 20578, VietNamDivisionType.PHUONG, "phuong_dien_nam_bac", 507)
    W_20579 = Ward("Phường Điện Nam Trung", 20579, VietNamDivisionType.PHUONG, "phuong_dien_nam_trung", 507)
    W_20580 = Ward("Phường Điện Nam Đông", 20580, VietNamDivisionType.PHUONG, "phuong_dien_nam_dong", 507)
    W_20581 = Ward("Phường Điện Dương", 20581, VietNamDivisionType.PHUONG, "phuong_dien_duong", 507)
    W_20584 = Ward("Xã Điện Quang", 20584, VietNamDivisionType.XA, "xa_dien_quang", 507)
    W_20587 = Ward("Xã Điện Trung", 20587, VietNamDivisionType.XA, "xa_dien_trung", 507)
    W_20590 = Ward("Xã Điện Phong", 20590, VietNamDivisionType.XA, "xa_dien_phong", 507)
    W_20593 = Ward("Xã Điện Minh", 20593, VietNamDivisionType.XA, "xa_dien_minh", 507)
    W_20596 = Ward("Xã Điện Phương", 20596, VietNamDivisionType.XA, "xa_dien_phuong", 507)
    W_20599 = Ward("Thị trấn Nam Phước", 20599, VietNamDivisionType.THI_TRAN, "thi_tran_nam_phuoc", 508)
    W_20602 = Ward("Xã Duy Thu", 20602, VietNamDivisionType.XA, "xa_duy_thu", 508)
    W_20605 = Ward("Xã Duy Phú", 20605, VietNamDivisionType.XA, "xa_duy_phu", 508)
    W_20608 = Ward("Xã Duy Tân", 20608, VietNamDivisionType.XA, "xa_duy_tan", 508)
    W_20611 = Ward("Xã Duy Hòa", 20611, VietNamDivisionType.XA, "xa_duy_hoa", 508)
    W_20614 = Ward("Xã Duy Châu", 20614, VietNamDivisionType.XA, "xa_duy_chau", 508)
    W_20617 = Ward("Xã Duy Trinh", 20617, VietNamDivisionType.XA, "xa_duy_trinh", 508)
    W_20620 = Ward("Xã Duy Sơn", 20620, VietNamDivisionType.XA, "xa_duy_son", 508)
    W_20623 = Ward("Xã Duy Trung", 20623, VietNamDivisionType.XA, "xa_duy_trung", 508)
    W_20626 = Ward("Xã Duy Phước", 20626, VietNamDivisionType.XA, "xa_duy_phuoc", 508)
    W_20629 = Ward("Xã Duy Thành", 20629, VietNamDivisionType.XA, "xa_duy_thanh", 508)
    W_20632 = Ward("Xã Duy Vinh", 20632, VietNamDivisionType.XA, "xa_duy_vinh", 508)
    W_20635 = Ward("Xã Duy Nghĩa", 20635, VietNamDivisionType.XA, "xa_duy_nghia", 508)
    W_20638 = Ward("Xã Duy Hải", 20638, VietNamDivisionType.XA, "xa_duy_hai", 508)
    W_20641 = Ward("Thị trấn Đông Phú", 20641, VietNamDivisionType.THI_TRAN, "thi_tran_dong_phu", 509)
    W_20644 = Ward("Xã Quế Xuân 1", 20644, VietNamDivisionType.XA, "xa_que_xuan_1", 509)
    W_20647 = Ward("Xã Quế Xuân 2", 20647, VietNamDivisionType.XA, "xa_que_xuan_2", 509)
    W_20650 = Ward("Xã Quế Phú", 20650, VietNamDivisionType.XA, "xa_que_phu", 509)
    W_20651 = Ward("Thị trấn Hương An", 20651, VietNamDivisionType.THI_TRAN, "thi_tran_huong_an", 509)
    W_20659 = Ward("Xã Quế Hiệp", 20659, VietNamDivisionType.XA, "xa_que_hiep", 509)
    W_20662 = Ward("Xã Quế Thuận", 20662, VietNamDivisionType.XA, "xa_que_thuan", 509)
    W_20665 = Ward("Xã Quế Mỹ", 20665, VietNamDivisionType.XA, "xa_que_my", 509)
    W_20677 = Ward("Xã Quế Long", 20677, VietNamDivisionType.XA, "xa_que_long", 509)
    W_20680 = Ward("Xã Quế Châu", 20680, VietNamDivisionType.XA, "xa_que_chau", 509)
    W_20683 = Ward("Xã Quế Phong", 20683, VietNamDivisionType.XA, "xa_que_phong", 509)
    W_20686 = Ward("Xã Quế An", 20686, VietNamDivisionType.XA, "xa_que_an", 509)
    W_20689 = Ward("Xã Quế Minh", 20689, VietNamDivisionType.XA, "xa_que_minh", 509)
    W_20695 = Ward("Thị trấn Thạnh Mỹ", 20695, VietNamDivisionType.THI_TRAN, "thi_tran_thanh_my", 510)
    W_20698 = Ward("Xã Laêê", 20698, VietNamDivisionType.XA, "xa_laee", 510)
    W_20699 = Ward("Xã Chơ Chun", 20699, VietNamDivisionType.XA, "xa_cho_chun", 510)
    W_20701 = Ward("Xã Zuôich", 20701, VietNamDivisionType.XA, "xa_zuoich", 510)
    W_20702 = Ward("Xã Tà Pơơ", 20702, VietNamDivisionType.XA, "xa_ta_poo", 510)
    W_20704 = Ward("Xã La Dêê", 20704, VietNamDivisionType.XA, "xa_la_dee", 510)
    W_20705 = Ward("Xã Đắc Tôi", 20705, VietNamDivisionType.XA, "xa_dac_toi", 510)
    W_20707 = Ward("Xã Chà Vàl", 20707, VietNamDivisionType.XA, "xa_cha_val", 510)
    W_20710 = Ward("Xã Tà Bhinh", 20710, VietNamDivisionType.XA, "xa_ta_bhinh", 510)
    W_20713 = Ward("Xã Cà Dy", 20713, VietNamDivisionType.XA, "xa_ca_dy", 510)
    W_20716 = Ward("Xã Đắc Pre", 20716, VietNamDivisionType.XA, "xa_dac_pre", 510)
    W_20719 = Ward("Xã Đắc Pring", 20719, VietNamDivisionType.XA, "xa_dac_pring", 510)
    W_20722 = Ward("Thị trấn Khâm Đức", 20722, VietNamDivisionType.THI_TRAN, "thi_tran_kham_duc", 511)
    W_20725 = Ward("Xã Phước Xuân", 20725, VietNamDivisionType.XA, "xa_phuoc_xuan", 511)
    W_20728 = Ward("Xã Phước Hiệp", 20728, VietNamDivisionType.XA, "xa_phuoc_hiep", 511)
    W_20729 = Ward("Xã Phước Hoà", 20729, VietNamDivisionType.XA, "xa_phuoc_hoa", 511)
    W_20731 = Ward("Xã Phước Đức", 20731, VietNamDivisionType.XA, "xa_phuoc_duc", 511)
    W_20734 = Ward("Xã Phước Năng", 20734, VietNamDivisionType.XA, "xa_phuoc_nang", 511)
    W_20737 = Ward("Xã Phước Mỹ", 20737, VietNamDivisionType.XA, "xa_phuoc_my", 511)
    W_20740 = Ward("Xã Phước Chánh", 20740, VietNamDivisionType.XA, "xa_phuoc_chanh", 511)
    W_20743 = Ward("Xã Phước Công", 20743, VietNamDivisionType.XA, "xa_phuoc_cong", 511)
    W_20746 = Ward("Xã Phước Kim", 20746, VietNamDivisionType.XA, "xa_phuoc_kim", 511)
    W_20749 = Ward("Xã Phước Lộc", 20749, VietNamDivisionType.XA, "xa_phuoc_loc", 511)
    W_20752 = Ward("Xã Phước Thành", 20752, VietNamDivisionType.XA, "xa_phuoc_thanh", 511)
    W_20758 = Ward("Xã Hiệp Hòa", 20758, VietNamDivisionType.XA, "xa_hiep_hoa", 512)
    W_20761 = Ward("Xã Hiệp Thuận", 20761, VietNamDivisionType.XA, "xa_hiep_thuan", 512)
    W_20764 = Ward("Xã Quế Thọ", 20764, VietNamDivisionType.XA, "xa_que_tho", 512)
    W_20767 = Ward("Xã Bình Lâm", 20767, VietNamDivisionType.XA, "xa_binh_lam", 512)
    W_20770 = Ward("Xã Sông Trà", 20770, VietNamDivisionType.XA, "xa_song_tra", 512)
    W_20773 = Ward("Xã Phước Trà", 20773, VietNamDivisionType.XA, "xa_phuoc_tra", 512)
    W_20776 = Ward("Xã Phước Gia", 20776, VietNamDivisionType.XA, "xa_phuoc_gia", 512)
    W_20779 = Ward("Thị trấn Tân Bình", 20779, VietNamDivisionType.THI_TRAN, "thi_tran_tan_binh", 512)
    W_20782 = Ward("Xã Quế Lưu", 20782, VietNamDivisionType.XA, "xa_que_luu", 512)
    W_20785 = Ward("Xã Thăng Phước", 20785, VietNamDivisionType.XA, "xa_thang_phuoc", 512)
    W_20788 = Ward("Xã Bình Sơn", 20788, VietNamDivisionType.XA, "xa_binh_son", 512)
    W_20791 = Ward("Thị trấn Hà Lam", 20791, VietNamDivisionType.THI_TRAN, "thi_tran_ha_lam", 513)
    W_20794 = Ward("Xã Bình Dương", 20794, VietNamDivisionType.XA, "xa_binh_duong", 513)
    W_20797 = Ward("Xã Bình Giang", 20797, VietNamDivisionType.XA, "xa_binh_giang", 513)
    W_20800 = Ward("Xã Bình Nguyên", 20800, VietNamDivisionType.XA, "xa_binh_nguyen", 513)
    W_20803 = Ward("Xã Bình Phục", 20803, VietNamDivisionType.XA, "xa_binh_phuc", 513)
    W_20806 = Ward("Xã Bình Triều", 20806, VietNamDivisionType.XA, "xa_binh_trieu", 513)
    W_20809 = Ward("Xã Bình Đào", 20809, VietNamDivisionType.XA, "xa_binh_dao", 513)
    W_20812 = Ward("Xã Bình Minh", 20812, VietNamDivisionType.XA, "xa_binh_minh", 513)
    W_20815 = Ward("Xã Bình Lãnh", 20815, VietNamDivisionType.XA, "xa_binh_lanh", 513)
    W_20818 = Ward("Xã Bình Trị", 20818, VietNamDivisionType.XA, "xa_binh_tri", 513)
    W_20821 = Ward("Xã Bình Định Bắc", 20821, VietNamDivisionType.XA, "xa_binh_dinh_bac", 513)
    W_20822 = Ward("Xã Bình Định Nam", 20822, VietNamDivisionType.XA, "xa_binh_dinh_nam", 513)
    W_20824 = Ward("Xã Bình Quý", 20824, VietNamDivisionType.XA, "xa_binh_quy", 513)
    W_20827 = Ward("Xã Bình Phú", 20827, VietNamDivisionType.XA, "xa_binh_phu", 513)
    W_20830 = Ward("Xã Bình Chánh", 20830, VietNamDivisionType.XA, "xa_binh_chanh", 513)
    W_20833 = Ward("Xã Bình Tú", 20833, VietNamDivisionType.XA, "xa_binh_tu", 513)
    W_20836 = Ward("Xã Bình Sa", 20836, VietNamDivisionType.XA, "xa_binh_sa", 513)
    W_20839 = Ward("Xã Bình Hải", 20839, VietNamDivisionType.XA, "xa_binh_hai", 513)
    W_20842 = Ward("Xã Bình Quế", 20842, VietNamDivisionType.XA, "xa_binh_que", 513)
    W_20845 = Ward("Xã Bình An", 20845, VietNamDivisionType.XA, "xa_binh_an", 513)
    W_20848 = Ward("Xã Bình Trung", 20848, VietNamDivisionType.XA, "xa_binh_trung", 513)
    W_20851 = Ward("Xã Bình Nam", 20851, VietNamDivisionType.XA, "xa_binh_nam", 513)
    W_20854 = Ward("Thị trấn Tiên Kỳ", 20854, VietNamDivisionType.THI_TRAN, "thi_tran_tien_ky", 514)
    W_20857 = Ward("Xã Tiên Sơn", 20857, VietNamDivisionType.XA, "xa_tien_son", 514)
    W_20860 = Ward("Xã Tiên Hà", 20860, VietNamDivisionType.XA, "xa_tien_ha", 514)
    W_20863 = Ward("Xã Tiên Cẩm", 20863, VietNamDivisionType.XA, "xa_tien_cam", 514)
    W_20866 = Ward("Xã Tiên Châu", 20866, VietNamDivisionType.XA, "xa_tien_chau", 514)
    W_20869 = Ward("Xã Tiên Lãnh", 20869, VietNamDivisionType.XA, "xa_tien_lanh", 514)
    W_20872 = Ward("Xã Tiên Ngọc", 20872, VietNamDivisionType.XA, "xa_tien_ngoc", 514)
    W_20875 = Ward("Xã Tiên Hiệp", 20875, VietNamDivisionType.XA, "xa_tien_hiep", 514)
    W_20878 = Ward("Xã Tiên Cảnh", 20878, VietNamDivisionType.XA, "xa_tien_canh", 514)
    W_20881 = Ward("Xã Tiên Mỹ", 20881, VietNamDivisionType.XA, "xa_tien_my", 514)
    W_20884 = Ward("Xã Tiên Phong", 20884, VietNamDivisionType.XA, "xa_tien_phong", 514)
    W_20887 = Ward("Xã Tiên Thọ", 20887, VietNamDivisionType.XA, "xa_tien_tho", 514)
    W_20890 = Ward("Xã Tiên An", 20890, VietNamDivisionType.XA, "xa_tien_an", 514)
    W_20893 = Ward("Xã Tiên Lộc", 20893, VietNamDivisionType.XA, "xa_tien_loc", 514)
    W_20896 = Ward("Xã Tiên Lập", 20896, VietNamDivisionType.XA, "xa_tien_lap", 514)
    W_20899 = Ward("Thị trấn Trà My", 20899, VietNamDivisionType.THI_TRAN, "thi_tran_tra_my", 515)
    W_20900 = Ward("Xã Trà Sơn", 20900, VietNamDivisionType.XA, "xa_tra_son", 515)
    W_20902 = Ward("Xã Trà Kót", 20902, VietNamDivisionType.XA, "xa_tra_kot", 515)
    W_20905 = Ward("Xã Trà Nú", 20905, VietNamDivisionType.XA, "xa_tra_nu", 515)
    W_20908 = Ward("Xã Trà Đông", 20908, VietNamDivisionType.XA, "xa_tra_dong", 515)
    W_20911 = Ward("Xã Trà Dương", 20911, VietNamDivisionType.XA, "xa_tra_duong", 515)
    W_20914 = Ward("Xã Trà Giang", 20914, VietNamDivisionType.XA, "xa_tra_giang", 515)
    W_20917 = Ward("Xã Trà Bui", 20917, VietNamDivisionType.XA, "xa_tra_bui", 515)
    W_20920 = Ward("Xã Trà Đốc", 20920, VietNamDivisionType.XA, "xa_tra_doc", 515)
    W_20923 = Ward("Xã Trà Tân", 20923, VietNamDivisionType.XA, "xa_tra_tan", 515)
    W_20926 = Ward("Xã Trà Giác", 20926, VietNamDivisionType.XA, "xa_tra_giac", 515)
    W_20929 = Ward("Xã Trà Giáp", 20929, VietNamDivisionType.XA, "xa_tra_giap", 515)
    W_20932 = Ward("Xã Trà Ka", 20932, VietNamDivisionType.XA, "xa_tra_ka", 515)
    W_20935 = Ward("Xã Trà Leng", 20935, VietNamDivisionType.XA, "xa_tra_leng", 516)
    W_20938 = Ward("Xã Trà Dơn", 20938, VietNamDivisionType.XA, "xa_tra_don", 516)
    W_20941 = Ward("Xã Trà Tập", 20941, VietNamDivisionType.XA, "xa_tra_tap", 516)
    W_20944 = Ward("Xã Trà Mai", 20944, VietNamDivisionType.XA, "xa_tra_mai", 516)
    W_20947 = Ward("Xã Trà Cang", 20947, VietNamDivisionType.XA, "xa_tra_cang", 516)
    W_20950 = Ward("Xã Trà Linh", 20950, VietNamDivisionType.XA, "xa_tra_linh", 516)
    W_20953 = Ward("Xã Trà Nam", 20953, VietNamDivisionType.XA, "xa_tra_nam", 516)
    W_20956 = Ward("Xã Trà Don", 20956, VietNamDivisionType.XA, "xa_tra_don", 516)
    W_20959 = Ward("Xã Trà Vân", 20959, VietNamDivisionType.XA, "xa_tra_van", 516)
    W_20962 = Ward("Xã Trà Vinh", 20962, VietNamDivisionType.XA, "xa_tra_vinh", 516)
    W_20965 = Ward("Thị trấn Núi Thành", 20965, VietNamDivisionType.THI_TRAN, "thi_tran_nui_thanh", 517)
    W_20968 = Ward("Xã Tam Xuân I", 20968, VietNamDivisionType.XA, "xa_tam_xuan_i", 517)
    W_20971 = Ward("Xã Tam Xuân II", 20971, VietNamDivisionType.XA, "xa_tam_xuan_ii", 517)
    W_20974 = Ward("Xã Tam Tiến", 20974, VietNamDivisionType.XA, "xa_tam_tien", 517)
    W_20977 = Ward("Xã Tam Sơn", 20977, VietNamDivisionType.XA, "xa_tam_son", 517)
    W_20980 = Ward("Xã Tam Thạnh", 20980, VietNamDivisionType.XA, "xa_tam_thanh", 517)
    W_20983 = Ward("Xã Tam Anh Bắc", 20983, VietNamDivisionType.XA, "xa_tam_anh_bac", 517)
    W_20984 = Ward("Xã Tam Anh Nam", 20984, VietNamDivisionType.XA, "xa_tam_anh_nam", 517)
    W_20986 = Ward("Xã Tam Hòa", 20986, VietNamDivisionType.XA, "xa_tam_hoa", 517)
    W_20989 = Ward("Xã Tam Hiệp", 20989, VietNamDivisionType.XA, "xa_tam_hiep", 517)
    W_20992 = Ward("Xã Tam Hải", 20992, VietNamDivisionType.XA, "xa_tam_hai", 517)
    W_20995 = Ward("Xã Tam Giang", 20995, VietNamDivisionType.XA, "xa_tam_giang", 517)
    W_20998 = Ward("Xã Tam Quang", 20998, VietNamDivisionType.XA, "xa_tam_quang", 517)
    W_21001 = Ward("Xã Tam Nghĩa", 21001, VietNamDivisionType.XA, "xa_tam_nghia", 517)
    W_21004 = Ward("Xã Tam Mỹ Tây", 21004, VietNamDivisionType.XA, "xa_tam_my_tay", 517)
    W_21005 = Ward("Xã Tam Mỹ Đông", 21005, VietNamDivisionType.XA, "xa_tam_my_dong", 517)
    W_21007 = Ward("Xã Tam Trà", 21007, VietNamDivisionType.XA, "xa_tam_tra", 517)
    W_20364 = Ward("Thị trấn Phú Thịnh", 20364, VietNamDivisionType.THI_TRAN, "thi_tran_phu_thinh", 518)
    W_20365 = Ward("Xã Tam Thành", 20365, VietNamDivisionType.XA, "xa_tam_thanh", 518)
    W_20368 = Ward("Xã Tam An", 20368, VietNamDivisionType.XA, "xa_tam_an", 518)
    W_20374 = Ward("Xã Tam Đàn", 20374, VietNamDivisionType.XA, "xa_tam_dan", 518)
    W_20377 = Ward("Xã Tam Lộc", 20377, VietNamDivisionType.XA, "xa_tam_loc", 518)
    W_20380 = Ward("Xã Tam Phước", 20380, VietNamDivisionType.XA, "xa_tam_phuoc", 518)
    W_20383 = Ward("Xã Tam Vinh", 20383, VietNamDivisionType.XA, "xa_tam_vinh", 518)
    W_20386 = Ward("Xã Tam Thái", 20386, VietNamDivisionType.XA, "xa_tam_thai", 518)
    W_20387 = Ward("Xã Tam Đại", 20387, VietNamDivisionType.XA, "xa_tam_dai", 518)
    W_20392 = Ward("Xã Tam Dân", 20392, VietNamDivisionType.XA, "xa_tam_dan", 518)
    W_20395 = Ward("Xã Tam Lãnh", 20395, VietNamDivisionType.XA, "xa_tam_lanh", 518)
    W_20656 = Ward("Xã Quế Trung", 20656, VietNamDivisionType.XA, "xa_que_trung", 519)
    W_20668 = Ward("Xã Ninh Phước", 20668, VietNamDivisionType.XA, "xa_ninh_phuoc", 519)
    W_20669 = Ward("Xã Phước Ninh", 20669, VietNamDivisionType.XA, "xa_phuoc_ninh", 519)
    W_20671 = Ward("Xã Quế Lộc", 20671, VietNamDivisionType.XA, "xa_que_loc", 519)
    W_20672 = Ward("Xã Sơn Viên", 20672, VietNamDivisionType.XA, "xa_son_vien", 519)
    W_20692 = Ward("Xã Quế Lâm", 20692, VietNamDivisionType.XA, "xa_que_lam", 519)
    W_21010 = Ward("Phường Lê Hồng Phong", 21010, VietNamDivisionType.PHUONG, "phuong_le_hong_phong", 522)
    W_21013 = Ward("Phường Trần Phú", 21013, VietNamDivisionType.PHUONG, "phuong_tran_phu", 522)
    W_21016 = Ward("Phường Quảng Phú", 21016, VietNamDivisionType.PHUONG, "phuong_quang_phu", 522)
    W_21019 = Ward("Phường Nghĩa Chánh", 21019, VietNamDivisionType.PHUONG, "phuong_nghia_chanh", 522)
    W_21022 = Ward("Phường Trần Hưng Đạo", 21022, VietNamDivisionType.PHUONG, "phuong_tran_hung_dao", 522)
    W_21025 = Ward("Phường Nguyễn Nghiêm", 21025, VietNamDivisionType.PHUONG, "phuong_nguyen_nghiem", 522)
    W_21028 = Ward("Phường Nghĩa Lộ", 21028, VietNamDivisionType.PHUONG, "phuong_nghia_lo", 522)
    W_21031 = Ward("Phường Chánh Lộ", 21031, VietNamDivisionType.PHUONG, "phuong_chanh_lo", 522)
    W_21034 = Ward("Xã Nghĩa Dũng", 21034, VietNamDivisionType.XA, "xa_nghia_dung", 522)
    W_21037 = Ward("Xã Nghĩa Dõng", 21037, VietNamDivisionType.XA, "xa_nghia_dong", 522)
    W_21172 = Ward("Phường Trương Quang Trọng", 21172, VietNamDivisionType.PHUONG, "phuong_truong_quang_trong", 522)
    W_21187 = Ward("Xã Tịnh Hòa", 21187, VietNamDivisionType.XA, "xa_tinh_hoa", 522)
    W_21190 = Ward("Xã Tịnh Kỳ", 21190, VietNamDivisionType.XA, "xa_tinh_ky", 522)
    W_21199 = Ward("Xã Tịnh Thiện", 21199, VietNamDivisionType.XA, "xa_tinh_thien", 522)
    W_21202 = Ward("Xã Tịnh Ấn Đông", 21202, VietNamDivisionType.XA, "xa_tinh_an_dong", 522)
    W_21208 = Ward("Xã Tịnh Châu", 21208, VietNamDivisionType.XA, "xa_tinh_chau", 522)
    W_21211 = Ward("Xã Tịnh Khê", 21211, VietNamDivisionType.XA, "xa_tinh_khe", 522)
    W_21214 = Ward("Xã Tịnh Long", 21214, VietNamDivisionType.XA, "xa_tinh_long", 522)
    W_21223 = Ward("Xã Tịnh Ấn Tây", 21223, VietNamDivisionType.XA, "xa_tinh_an_tay", 522)
    W_21232 = Ward("Xã Tịnh An", 21232, VietNamDivisionType.XA, "xa_tinh_an", 522)
    W_21253 = Ward("Xã Nghĩa Phú", 21253, VietNamDivisionType.XA, "xa_nghia_phu", 522)
    W_21256 = Ward("Xã Nghĩa Hà", 21256, VietNamDivisionType.XA, "xa_nghia_ha", 522)
    W_21262 = Ward("Xã Nghĩa An", 21262, VietNamDivisionType.XA, "xa_nghia_an", 522)
    W_21040 = Ward("Thị trấn Châu Ổ", 21040, VietNamDivisionType.THI_TRAN, "thi_tran_chau_o", 524)
    W_21043 = Ward("Xã Bình Thuận", 21043, VietNamDivisionType.XA, "xa_binh_thuan", 524)
    W_21046 = Ward("Xã Bình Thạnh", 21046, VietNamDivisionType.XA, "xa_binh_thanh", 524)
    W_21049 = Ward("Xã Bình Đông", 21049, VietNamDivisionType.XA, "xa_binh_dong", 524)
    W_21052 = Ward("Xã Bình Chánh", 21052, VietNamDivisionType.XA, "xa_binh_chanh", 524)
    W_21055 = Ward("Xã Bình Nguyên", 21055, VietNamDivisionType.XA, "xa_binh_nguyen", 524)
    W_21058 = Ward("Xã Bình Khương", 21058, VietNamDivisionType.XA, "xa_binh_khuong", 524)
    W_21061 = Ward("Xã Bình Trị", 21061, VietNamDivisionType.XA, "xa_binh_tri", 524)
    W_21064 = Ward("Xã Bình An", 21064, VietNamDivisionType.XA, "xa_binh_an", 524)
    W_21067 = Ward("Xã Bình Hải", 21067, VietNamDivisionType.XA, "xa_binh_hai", 524)
    W_21070 = Ward("Xã Bình Dương", 21070, VietNamDivisionType.XA, "xa_binh_duong", 524)
    W_21073 = Ward("Xã Bình Phước", 21073, VietNamDivisionType.XA, "xa_binh_phuoc", 524)
    W_21079 = Ward("Xã Bình Hòa", 21079, VietNamDivisionType.XA, "xa_binh_hoa", 524)
    W_21082 = Ward("Xã Bình Trung", 21082, VietNamDivisionType.XA, "xa_binh_trung", 524)
    W_21085 = Ward("Xã Bình Minh", 21085, VietNamDivisionType.XA, "xa_binh_minh", 524)
    W_21088 = Ward("Xã Bình Long", 21088, VietNamDivisionType.XA, "xa_binh_long", 524)
    W_21091 = Ward("Xã Bình Thanh", 21091, VietNamDivisionType.XA, "xa_binh_thanh", 524)
    W_21100 = Ward("Xã Bình Chương", 21100, VietNamDivisionType.XA, "xa_binh_chuong", 524)
    W_21103 = Ward("Xã Bình Hiệp", 21103, VietNamDivisionType.XA, "xa_binh_hiep", 524)
    W_21106 = Ward("Xã Bình Mỹ", 21106, VietNamDivisionType.XA, "xa_binh_my", 524)
    W_21109 = Ward("Xã Bình Tân Phú", 21109, VietNamDivisionType.XA, "xa_binh_tan_phu", 524)
    W_21112 = Ward("Xã Bình Châu", 21112, VietNamDivisionType.XA, "xa_binh_chau", 524)
    W_21115 = Ward("Thị trấn Trà Xuân", 21115, VietNamDivisionType.THI_TRAN, "thi_tran_tra_xuan", 525)
    W_21118 = Ward("Xã Trà Giang", 21118, VietNamDivisionType.XA, "xa_tra_giang", 525)
    W_21121 = Ward("Xã Trà Thủy", 21121, VietNamDivisionType.XA, "xa_tra_thuy", 525)
    W_21124 = Ward("Xã Trà Hiệp", 21124, VietNamDivisionType.XA, "xa_tra_hiep", 525)
    W_21127 = Ward("Xã Trà Bình", 21127, VietNamDivisionType.XA, "xa_tra_binh", 525)
    W_21130 = Ward("Xã Trà Phú", 21130, VietNamDivisionType.XA, "xa_tra_phu", 525)
    W_21133 = Ward("Xã Trà Lâm", 21133, VietNamDivisionType.XA, "xa_tra_lam", 525)
    W_21136 = Ward("Xã Trà Tân", 21136, VietNamDivisionType.XA, "xa_tra_tan", 525)
    W_21139 = Ward("Xã Trà Sơn", 21139, VietNamDivisionType.XA, "xa_tra_son", 525)
    W_21142 = Ward("Xã Trà Bùi", 21142, VietNamDivisionType.XA, "xa_tra_bui", 525)
    W_21145 = Ward("Xã Trà Thanh", 21145, VietNamDivisionType.XA, "xa_tra_thanh", 525)
    W_21148 = Ward("Xã Sơn Trà", 21148, VietNamDivisionType.XA, "xa_son_tra", 525)
    W_21154 = Ward("Xã Trà Phong", 21154, VietNamDivisionType.XA, "xa_tra_phong", 525)
    W_21157 = Ward("Xã Hương Trà", 21157, VietNamDivisionType.XA, "xa_huong_tra", 525)
    W_21163 = Ward("Xã Trà Xinh", 21163, VietNamDivisionType.XA, "xa_tra_xinh", 525)
    W_21166 = Ward("Xã Trà Tây", 21166, VietNamDivisionType.XA, "xa_tra_tay", 525)
    W_21175 = Ward("Xã Tịnh Thọ", 21175, VietNamDivisionType.XA, "xa_tinh_tho", 527)
    W_21178 = Ward("Xã Tịnh Trà", 21178, VietNamDivisionType.XA, "xa_tinh_tra", 527)
    W_21181 = Ward("Xã Tịnh Phong", 21181, VietNamDivisionType.XA, "xa_tinh_phong", 527)
    W_21184 = Ward("Xã Tịnh Hiệp", 21184, VietNamDivisionType.XA, "xa_tinh_hiep", 527)
    W_21193 = Ward("Xã Tịnh Bình", 21193, VietNamDivisionType.XA, "xa_tinh_binh", 527)
    W_21196 = Ward("Xã Tịnh Đông", 21196, VietNamDivisionType.XA, "xa_tinh_dong", 527)
    W_21205 = Ward("Xã Tịnh Bắc", 21205, VietNamDivisionType.XA, "xa_tinh_bac", 527)
    W_21217 = Ward("Xã Tịnh Sơn", 21217, VietNamDivisionType.XA, "xa_tinh_son", 527)
    W_21220 = Ward("Xã Tịnh Hà", 21220, VietNamDivisionType.XA, "xa_tinh_ha", 527)
    W_21226 = Ward("Xã Tịnh Giang", 21226, VietNamDivisionType.XA, "xa_tinh_giang", 527)
    W_21229 = Ward("Xã Tịnh Minh", 21229, VietNamDivisionType.XA, "xa_tinh_minh", 527)
    W_21235 = Ward("Thị trấn La Hà", 21235, VietNamDivisionType.THI_TRAN, "thi_tran_la_ha", 528)
    W_21238 = Ward("Thị trấn Sông Vệ", 21238, VietNamDivisionType.THI_TRAN, "thi_tran_song_ve", 528)
    W_21241 = Ward("Xã Nghĩa Lâm", 21241, VietNamDivisionType.XA, "xa_nghia_lam", 528)
    W_21244 = Ward("Xã Nghĩa Thắng", 21244, VietNamDivisionType.XA, "xa_nghia_thang", 528)
    W_21247 = Ward("Xã Nghĩa Thuận", 21247, VietNamDivisionType.XA, "xa_nghia_thuan", 528)
    W_21250 = Ward("Xã Nghĩa Kỳ", 21250, VietNamDivisionType.XA, "xa_nghia_ky", 528)
    W_21259 = Ward("Xã Nghĩa Sơn", 21259, VietNamDivisionType.XA, "xa_nghia_son", 528)
    W_21268 = Ward("Xã Nghĩa Hòa", 21268, VietNamDivisionType.XA, "xa_nghia_hoa", 528)
    W_21271 = Ward("Xã Nghĩa Điền", 21271, VietNamDivisionType.XA, "xa_nghia_dien", 528)
    W_21274 = Ward("Xã Nghĩa Thương", 21274, VietNamDivisionType.XA, "xa_nghia_thuong", 528)
    W_21277 = Ward("Xã Nghĩa Trung", 21277, VietNamDivisionType.XA, "xa_nghia_trung", 528)
    W_21280 = Ward("Xã Nghĩa Hiệp", 21280, VietNamDivisionType.XA, "xa_nghia_hiep", 528)
    W_21283 = Ward("Xã Nghĩa Phương", 21283, VietNamDivisionType.XA, "xa_nghia_phuong", 528)
    W_21286 = Ward("Xã Nghĩa Mỹ", 21286, VietNamDivisionType.XA, "xa_nghia_my", 528)
    W_21289 = Ward("Thị trấn Di Lăng", 21289, VietNamDivisionType.THI_TRAN, "thi_tran_di_lang", 529)
    W_21292 = Ward("Xã Sơn Hạ", 21292, VietNamDivisionType.XA, "xa_son_ha", 529)
    W_21295 = Ward("Xã Sơn Thành", 21295, VietNamDivisionType.XA, "xa_son_thanh", 529)
    W_21298 = Ward("Xã Sơn Nham", 21298, VietNamDivisionType.XA, "xa_son_nham", 529)
    W_21301 = Ward("Xã Sơn Bao", 21301, VietNamDivisionType.XA, "xa_son_bao", 529)
    W_21304 = Ward("Xã Sơn Linh", 21304, VietNamDivisionType.XA, "xa_son_linh", 529)
    W_21307 = Ward("Xã Sơn Giang", 21307, VietNamDivisionType.XA, "xa_son_giang", 529)
    W_21310 = Ward("Xã Sơn Trung", 21310, VietNamDivisionType.XA, "xa_son_trung", 529)
    W_21313 = Ward("Xã Sơn Thượng", 21313, VietNamDivisionType.XA, "xa_son_thuong", 529)
    W_21316 = Ward("Xã Sơn Cao", 21316, VietNamDivisionType.XA, "xa_son_cao", 529)
    W_21319 = Ward("Xã Sơn Hải", 21319, VietNamDivisionType.XA, "xa_son_hai", 529)
    W_21322 = Ward("Xã Sơn Thủy", 21322, VietNamDivisionType.XA, "xa_son_thuy", 529)
    W_21325 = Ward("Xã Sơn Kỳ", 21325, VietNamDivisionType.XA, "xa_son_ky", 529)
    W_21328 = Ward("Xã Sơn Ba", 21328, VietNamDivisionType.XA, "xa_son_ba", 529)
    W_21331 = Ward("Xã Sơn Bua", 21331, VietNamDivisionType.XA, "xa_son_bua", 530)
    W_21334 = Ward("Xã Sơn Mùa", 21334, VietNamDivisionType.XA, "xa_son_mua", 530)
    W_21335 = Ward("Xã Sơn Liên", 21335, VietNamDivisionType.XA, "xa_son_lien", 530)
    W_21337 = Ward("Xã Sơn Tân", 21337, VietNamDivisionType.XA, "xa_son_tan", 530)
    W_21338 = Ward("Xã Sơn Màu", 21338, VietNamDivisionType.XA, "xa_son_mau", 530)
    W_21340 = Ward("Xã Sơn Dung", 21340, VietNamDivisionType.XA, "xa_son_dung", 530)
    W_21341 = Ward("Xã Sơn Long", 21341, VietNamDivisionType.XA, "xa_son_long", 530)
    W_21343 = Ward("Xã Sơn Tinh", 21343, VietNamDivisionType.XA, "xa_son_tinh", 530)
    W_21346 = Ward("Xã Sơn Lập", 21346, VietNamDivisionType.XA, "xa_son_lap", 530)
    W_21349 = Ward("Xã Long Sơn", 21349, VietNamDivisionType.XA, "xa_long_son", 531)
    W_21352 = Ward("Xã Long Mai", 21352, VietNamDivisionType.XA, "xa_long_mai", 531)
    W_21355 = Ward("Xã Thanh An", 21355, VietNamDivisionType.XA, "xa_thanh_an", 531)
    W_21358 = Ward("Xã Long Môn", 21358, VietNamDivisionType.XA, "xa_long_mon", 531)
    W_21361 = Ward("Xã Long Hiệp", 21361, VietNamDivisionType.XA, "xa_long_hiep", 531)
    W_21364 = Ward("Thị trấn Chợ Chùa", 21364, VietNamDivisionType.THI_TRAN, "thi_tran_cho_chua", 532)
    W_21367 = Ward("Xã Hành Thuận", 21367, VietNamDivisionType.XA, "xa_hanh_thuan", 532)
    W_21370 = Ward("Xã Hành Dũng", 21370, VietNamDivisionType.XA, "xa_hanh_dung", 532)
    W_21373 = Ward("Xã Hành Trung", 21373, VietNamDivisionType.XA, "xa_hanh_trung", 532)
    W_21376 = Ward("Xã Hành Nhân", 21376, VietNamDivisionType.XA, "xa_hanh_nhan", 532)
    W_21379 = Ward("Xã Hành Đức", 21379, VietNamDivisionType.XA, "xa_hanh_duc", 532)
    W_21382 = Ward("Xã Hành Minh", 21382, VietNamDivisionType.XA, "xa_hanh_minh", 532)
    W_21385 = Ward("Xã Hành Phước", 21385, VietNamDivisionType.XA, "xa_hanh_phuoc", 532)
    W_21388 = Ward("Xã Hành Thiện", 21388, VietNamDivisionType.XA, "xa_hanh_thien", 532)
    W_21391 = Ward("Xã Hành Thịnh", 21391, VietNamDivisionType.XA, "xa_hanh_thinh", 532)
    W_21394 = Ward("Xã Hành Tín Tây", 21394, VietNamDivisionType.XA, "xa_hanh_tin_tay", 532)
    W_21397 = Ward("Xã Hành Tín Đông", 21397, VietNamDivisionType.XA, "xa_hanh_tin_dong", 532)
    W_21400 = Ward("Thị trấn Mộ Đức", 21400, VietNamDivisionType.THI_TRAN, "thi_tran_mo_duc", 533)
    W_21403 = Ward("Xã Đức Lợi", 21403, VietNamDivisionType.XA, "xa_duc_loi", 533)
    W_21406 = Ward("Xã Đức Thắng", 21406, VietNamDivisionType.XA, "xa_duc_thang", 533)
    W_21409 = Ward("Xã Đức Nhuận", 21409, VietNamDivisionType.XA, "xa_duc_nhuan", 533)
    W_21412 = Ward("Xã Đức Chánh", 21412, VietNamDivisionType.XA, "xa_duc_chanh", 533)
    W_21415 = Ward("Xã Đức Hiệp", 21415, VietNamDivisionType.XA, "xa_duc_hiep", 533)
    W_21418 = Ward("Xã Đức Minh", 21418, VietNamDivisionType.XA, "xa_duc_minh", 533)
    W_21421 = Ward("Xã Đức Thạnh", 21421, VietNamDivisionType.XA, "xa_duc_thanh", 533)
    W_21424 = Ward("Xã Đức Hòa", 21424, VietNamDivisionType.XA, "xa_duc_hoa", 533)
    W_21427 = Ward("Xã Đức Tân", 21427, VietNamDivisionType.XA, "xa_duc_tan", 533)
    W_21430 = Ward("Xã Đức Phú", 21430, VietNamDivisionType.XA, "xa_duc_phu", 533)
    W_21433 = Ward("Xã Đức Phong", 21433, VietNamDivisionType.XA, "xa_duc_phong", 533)
    W_21436 = Ward("Xã Đức Lân", 21436, VietNamDivisionType.XA, "xa_duc_lan", 533)
    W_21439 = Ward("Phường Nguyễn Nghiêm", 21439, VietNamDivisionType.PHUONG, "phuong_nguyen_nghiem", 534)
    W_21442 = Ward("Xã Phổ An", 21442, VietNamDivisionType.XA, "xa_pho_an", 534)
    W_21445 = Ward("Xã Phổ Phong", 21445, VietNamDivisionType.XA, "xa_pho_phong", 534)
    W_21448 = Ward("Xã Phổ Thuận", 21448, VietNamDivisionType.XA, "xa_pho_thuan", 534)
    W_21451 = Ward("Phường Phổ Văn", 21451, VietNamDivisionType.PHUONG, "phuong_pho_van", 534)
    W_21454 = Ward("Phường Phổ Quang", 21454, VietNamDivisionType.PHUONG, "phuong_pho_quang", 534)
    W_21457 = Ward("Xã Phổ Nhơn", 21457, VietNamDivisionType.XA, "xa_pho_nhon", 534)
    W_21460 = Ward("Phường Phổ Ninh", 21460, VietNamDivisionType.PHUONG, "phuong_pho_ninh", 534)
    W_21463 = Ward("Phường Phổ Minh", 21463, VietNamDivisionType.PHUONG, "phuong_pho_minh", 534)
    W_21466 = Ward("Phường Phổ Vinh", 21466, VietNamDivisionType.PHUONG, "phuong_pho_vinh", 534)
    W_21469 = Ward("Phường Phổ Hòa", 21469, VietNamDivisionType.PHUONG, "phuong_pho_hoa", 534)
    W_21472 = Ward("Xã Phổ Cường", 21472, VietNamDivisionType.XA, "xa_pho_cuong", 534)
    W_21475 = Ward("Xã Phổ Khánh", 21475, VietNamDivisionType.XA, "xa_pho_khanh", 534)
    W_21478 = Ward("Phường Phổ Thạnh", 21478, VietNamDivisionType.PHUONG, "phuong_pho_thanh", 534)
    W_21481 = Ward("Xã Phổ Châu", 21481, VietNamDivisionType.XA, "xa_pho_chau", 534)
    W_21484 = Ward("Thị trấn Ba Tơ", 21484, VietNamDivisionType.THI_TRAN, "thi_tran_ba_to", 535)
    W_21487 = Ward("Xã Ba Điền", 21487, VietNamDivisionType.XA, "xa_ba_dien", 535)
    W_21490 = Ward("Xã Ba Vinh", 21490, VietNamDivisionType.XA, "xa_ba_vinh", 535)
    W_21493 = Ward("Xã Ba Thành", 21493, VietNamDivisionType.XA, "xa_ba_thanh", 535)
    W_21496 = Ward("Xã Ba Động", 21496, VietNamDivisionType.XA, "xa_ba_dong", 535)
    W_21499 = Ward("Xã Ba Dinh", 21499, VietNamDivisionType.XA, "xa_ba_dinh", 535)
    W_21500 = Ward("Xã Ba Giang", 21500, VietNamDivisionType.XA, "xa_ba_giang", 535)
    W_21502 = Ward("Xã Ba Liên", 21502, VietNamDivisionType.XA, "xa_ba_lien", 535)
    W_21505 = Ward("Xã Ba Ngạc", 21505, VietNamDivisionType.XA, "xa_ba_ngac", 535)
    W_21508 = Ward("Xã Ba Khâm", 21508, VietNamDivisionType.XA, "xa_ba_kham", 535)
    W_21511 = Ward("Xã Ba Cung", 21511, VietNamDivisionType.XA, "xa_ba_cung", 535)
    W_21517 = Ward("Xã Ba Tiêu", 21517, VietNamDivisionType.XA, "xa_ba_tieu", 535)
    W_21520 = Ward("Xã Ba Trang", 21520, VietNamDivisionType.XA, "xa_ba_trang", 535)
    W_21523 = Ward("Xã Ba Tô", 21523, VietNamDivisionType.XA, "xa_ba_to", 535)
    W_21526 = Ward("Xã Ba Bích", 21526, VietNamDivisionType.XA, "xa_ba_bich", 535)
    W_21529 = Ward("Xã Ba Vì", 21529, VietNamDivisionType.XA, "xa_ba_vi", 535)
    W_21532 = Ward("Xã Ba Lế", 21532, VietNamDivisionType.XA, "xa_ba_le", 535)
    W_21535 = Ward("Xã Ba Nam", 21535, VietNamDivisionType.XA, "xa_ba_nam", 535)
    W_21538 = Ward("Xã Ba Xa", 21538, VietNamDivisionType.XA, "xa_ba_xa", 535)
    W_21550 = Ward("Phường Nhơn Bình", 21550, VietNamDivisionType.PHUONG, "phuong_nhon_binh", 540)
    W_21553 = Ward("Phường Nhơn Phú", 21553, VietNamDivisionType.PHUONG, "phuong_nhon_phu", 540)
    W_21556 = Ward("Phường Đống Đa", 21556, VietNamDivisionType.PHUONG, "phuong_dong_da", 540)
    W_21559 = Ward("Phường Trần Quang Diệu", 21559, VietNamDivisionType.PHUONG, "phuong_tran_quang_dieu", 540)
    W_21562 = Ward("Phường Hải Cảng", 21562, VietNamDivisionType.PHUONG, "phuong_hai_cang", 540)
    W_21565 = Ward("Phường Quang Trung", 21565, VietNamDivisionType.PHUONG, "phuong_quang_trung", 540)
    W_21568 = Ward("Phường Thị Nại", 21568, VietNamDivisionType.PHUONG, "phuong_thi_nai", 540)
    W_21571 = Ward("Phường Lê Hồng Phong", 21571, VietNamDivisionType.PHUONG, "phuong_le_hong_phong", 540)
    W_21574 = Ward("Phường Trần Hưng Đạo", 21574, VietNamDivisionType.PHUONG, "phuong_tran_hung_dao", 540)
    W_21577 = Ward("Phường Ngô Mây", 21577, VietNamDivisionType.PHUONG, "phuong_ngo_may", 540)
    W_21580 = Ward("Phường Lý Thường Kiệt", 21580, VietNamDivisionType.PHUONG, "phuong_ly_thuong_kiet", 540)
    W_21583 = Ward("Phường Lê Lợi", 21583, VietNamDivisionType.PHUONG, "phuong_le_loi", 540)
    W_21586 = Ward("Phường Trần Phú", 21586, VietNamDivisionType.PHUONG, "phuong_tran_phu", 540)
    W_21589 = Ward("Phường Bùi Thị Xuân", 21589, VietNamDivisionType.PHUONG, "phuong_bui_thi_xuan", 540)
    W_21592 = Ward("Phường Nguyễn Văn Cừ", 21592, VietNamDivisionType.PHUONG, "phuong_nguyen_van_cu", 540)
    W_21595 = Ward("Phường Ghềnh Ráng", 21595, VietNamDivisionType.PHUONG, "phuong_ghenh_rang", 540)
    W_21598 = Ward("Xã Nhơn Lý", 21598, VietNamDivisionType.XA, "xa_nhon_ly", 540)
    W_21601 = Ward("Xã Nhơn Hội", 21601, VietNamDivisionType.XA, "xa_nhon_hoi", 540)
    W_21604 = Ward("Xã Nhơn Hải", 21604, VietNamDivisionType.XA, "xa_nhon_hai", 540)
    W_21607 = Ward("Xã Nhơn Châu", 21607, VietNamDivisionType.XA, "xa_nhon_chau", 540)
    W_21991 = Ward("Xã Phước Mỹ", 21991, VietNamDivisionType.XA, "xa_phuoc_my", 540)
    W_21609 = Ward("Thị trấn An Lão", 21609, VietNamDivisionType.THI_TRAN, "thi_tran_an_lao", 542)
    W_21610 = Ward("Xã An Hưng", 21610, VietNamDivisionType.XA, "xa_an_hung", 542)
    W_21613 = Ward("Xã An Trung", 21613, VietNamDivisionType.XA, "xa_an_trung", 542)
    W_21616 = Ward("Xã An Dũng", 21616, VietNamDivisionType.XA, "xa_an_dung", 542)
    W_21619 = Ward("Xã An Vinh", 21619, VietNamDivisionType.XA, "xa_an_vinh", 542)
    W_21622 = Ward("Xã An Toàn", 21622, VietNamDivisionType.XA, "xa_an_toan", 542)
    W_21625 = Ward("Xã An Tân", 21625, VietNamDivisionType.XA, "xa_an_tan", 542)
    W_21628 = Ward("Xã An Hòa", 21628, VietNamDivisionType.XA, "xa_an_hoa", 542)
    W_21631 = Ward("Xã An Quang", 21631, VietNamDivisionType.XA, "xa_an_quang", 542)
    W_21634 = Ward("Xã An Nghĩa", 21634, VietNamDivisionType.XA, "xa_an_nghia", 542)
    W_21637 = Ward("Phường Tam Quan", 21637, VietNamDivisionType.PHUONG, "phuong_tam_quan", 543)
    W_21640 = Ward("Phường Bồng Sơn", 21640, VietNamDivisionType.PHUONG, "phuong_bong_son", 543)
    W_21643 = Ward("Xã Hoài Sơn", 21643, VietNamDivisionType.XA, "xa_hoai_son", 543)
    W_21646 = Ward("Xã Hoài Châu Bắc", 21646, VietNamDivisionType.XA, "xa_hoai_chau_bac", 543)
    W_21649 = Ward("Xã Hoài Châu", 21649, VietNamDivisionType.XA, "xa_hoai_chau", 543)
    W_21652 = Ward("Xã Hoài Phú", 21652, VietNamDivisionType.XA, "xa_hoai_phu", 543)
    W_21655 = Ward("Phường Tam Quan Bắc", 21655, VietNamDivisionType.PHUONG, "phuong_tam_quan_bac", 543)
    W_21658 = Ward("Phường Tam Quan Nam", 21658, VietNamDivisionType.PHUONG, "phuong_tam_quan_nam", 543)
    W_21661 = Ward("Phường Hoài Hảo", 21661, VietNamDivisionType.PHUONG, "phuong_hoai_hao", 543)
    W_21664 = Ward("Phường Hoài Thanh Tây", 21664, VietNamDivisionType.PHUONG, "phuong_hoai_thanh_tay", 543)
    W_21667 = Ward("Phường Hoài Thanh", 21667, VietNamDivisionType.PHUONG, "phuong_hoai_thanh", 543)
    W_21670 = Ward("Phường Hoài Hương", 21670, VietNamDivisionType.PHUONG, "phuong_hoai_huong", 543)
    W_21673 = Ward("Phường Hoài Tân", 21673, VietNamDivisionType.PHUONG, "phuong_hoai_tan", 543)
    W_21676 = Ward("Xã Hoài Hải", 21676, VietNamDivisionType.XA, "xa_hoai_hai", 543)
    W_21679 = Ward("Phường Hoài Xuân", 21679, VietNamDivisionType.PHUONG, "phuong_hoai_xuan", 543)
    W_21682 = Ward("Xã Hoài Mỹ", 21682, VietNamDivisionType.XA, "xa_hoai_my", 543)
    W_21685 = Ward("Phường Hoài Đức", 21685, VietNamDivisionType.PHUONG, "phuong_hoai_duc", 543)
    W_21688 = Ward("Thị trấn Tăng Bạt Hổ", 21688, VietNamDivisionType.THI_TRAN, "thi_tran_tang_bat_ho", 544)
    W_21690 = Ward("Xã Ân Hảo Tây", 21690, VietNamDivisionType.XA, "xa_an_hao_tay", 544)
    W_21691 = Ward("Xã Ân Hảo Đông", 21691, VietNamDivisionType.XA, "xa_an_hao_dong", 544)
    W_21694 = Ward("Xã Ân Sơn", 21694, VietNamDivisionType.XA, "xa_an_son", 544)
    W_21697 = Ward("Xã Ân Mỹ", 21697, VietNamDivisionType.XA, "xa_an_my", 544)
    W_21700 = Ward("Xã Đak Mang", 21700, VietNamDivisionType.XA, "xa_dak_mang", 544)
    W_21703 = Ward("Xã Ân Tín", 21703, VietNamDivisionType.XA, "xa_an_tin", 544)
    W_21706 = Ward("Xã Ân Thạnh", 21706, VietNamDivisionType.XA, "xa_an_thanh", 544)
    W_21709 = Ward("Xã Ân Phong", 21709, VietNamDivisionType.XA, "xa_an_phong", 544)
    W_21712 = Ward("Xã Ân Đức", 21712, VietNamDivisionType.XA, "xa_an_duc", 544)
    W_21715 = Ward("Xã Ân Hữu", 21715, VietNamDivisionType.XA, "xa_an_huu", 544)
    W_21718 = Ward("Xã Bok Tới", 21718, VietNamDivisionType.XA, "xa_bok_toi", 544)
    W_21721 = Ward("Xã Ân Tường Tây", 21721, VietNamDivisionType.XA, "xa_an_tuong_tay", 544)
    W_21724 = Ward("Xã Ân Tường Đông", 21724, VietNamDivisionType.XA, "xa_an_tuong_dong", 544)
    W_21727 = Ward("Xã Ân Nghĩa", 21727, VietNamDivisionType.XA, "xa_an_nghia", 544)
    W_21730 = Ward("Thị trấn Phù Mỹ", 21730, VietNamDivisionType.THI_TRAN, "thi_tran_phu_my", 545)
    W_21733 = Ward("Thị trấn Bình Dương", 21733, VietNamDivisionType.THI_TRAN, "thi_tran_binh_duong", 545)
    W_21736 = Ward("Xã Mỹ Đức", 21736, VietNamDivisionType.XA, "xa_my_duc", 545)
    W_21739 = Ward("Xã Mỹ Châu", 21739, VietNamDivisionType.XA, "xa_my_chau", 545)
    W_21742 = Ward("Xã Mỹ Thắng", 21742, VietNamDivisionType.XA, "xa_my_thang", 545)
    W_21745 = Ward("Xã Mỹ Lộc", 21745, VietNamDivisionType.XA, "xa_my_loc", 545)
    W_21748 = Ward("Xã Mỹ Lợi", 21748, VietNamDivisionType.XA, "xa_my_loi", 545)
    W_21751 = Ward("Xã Mỹ An", 21751, VietNamDivisionType.XA, "xa_my_an", 545)
    W_21754 = Ward("Xã Mỹ Phong", 21754, VietNamDivisionType.XA, "xa_my_phong", 545)
    W_21757 = Ward("Xã Mỹ Trinh", 21757, VietNamDivisionType.XA, "xa_my_trinh", 545)
    W_21760 = Ward("Xã Mỹ Thọ", 21760, VietNamDivisionType.XA, "xa_my_tho", 545)
    W_21763 = Ward("Xã Mỹ Hòa", 21763, VietNamDivisionType.XA, "xa_my_hoa", 545)
    W_21766 = Ward("Xã Mỹ Thành", 21766, VietNamDivisionType.XA, "xa_my_thanh", 545)
    W_21769 = Ward("Xã Mỹ Chánh", 21769, VietNamDivisionType.XA, "xa_my_chanh", 545)
    W_21772 = Ward("Xã Mỹ Quang", 21772, VietNamDivisionType.XA, "xa_my_quang", 545)
    W_21775 = Ward("Xã Mỹ Hiệp", 21775, VietNamDivisionType.XA, "xa_my_hiep", 545)
    W_21778 = Ward("Xã Mỹ Tài", 21778, VietNamDivisionType.XA, "xa_my_tai", 545)
    W_21781 = Ward("Xã Mỹ Cát", 21781, VietNamDivisionType.XA, "xa_my_cat", 545)
    W_21784 = Ward("Xã Mỹ Chánh Tây", 21784, VietNamDivisionType.XA, "xa_my_chanh_tay", 545)
    W_21786 = Ward("Thị trấn Vĩnh Thạnh", 21786, VietNamDivisionType.THI_TRAN, "thi_tran_vinh_thanh", 546)
    W_21787 = Ward("Xã Vĩnh Sơn", 21787, VietNamDivisionType.XA, "xa_vinh_son", 546)
    W_21790 = Ward("Xã Vĩnh Kim", 21790, VietNamDivisionType.XA, "xa_vinh_kim", 546)
    W_21796 = Ward("Xã Vĩnh Hiệp", 21796, VietNamDivisionType.XA, "xa_vinh_hiep", 546)
    W_21799 = Ward("Xã Vĩnh Hảo", 21799, VietNamDivisionType.XA, "xa_vinh_hao", 546)
    W_21801 = Ward("Xã Vĩnh Hòa", 21801, VietNamDivisionType.XA, "xa_vinh_hoa", 546)
    W_21802 = Ward("Xã Vĩnh Thịnh", 21802, VietNamDivisionType.XA, "xa_vinh_thinh", 546)
    W_21804 = Ward("Xã Vĩnh Thuận", 21804, VietNamDivisionType.XA, "xa_vinh_thuan", 546)
    W_21805 = Ward("Xã Vĩnh Quang", 21805, VietNamDivisionType.XA, "xa_vinh_quang", 546)
    W_21808 = Ward("Thị trấn Phú Phong", 21808, VietNamDivisionType.THI_TRAN, "thi_tran_phu_phong", 547)
    W_21811 = Ward("Xã Bình Tân", 21811, VietNamDivisionType.XA, "xa_binh_tan", 547)
    W_21814 = Ward("Xã Tây Thuận", 21814, VietNamDivisionType.XA, "xa_tay_thuan", 547)
    W_21817 = Ward("Xã Bình Thuận", 21817, VietNamDivisionType.XA, "xa_binh_thuan", 547)
    W_21820 = Ward("Xã Tây Giang", 21820, VietNamDivisionType.XA, "xa_tay_giang", 547)
    W_21823 = Ward("Xã Bình Thành", 21823, VietNamDivisionType.XA, "xa_binh_thanh", 547)
    W_21826 = Ward("Xã Tây An", 21826, VietNamDivisionType.XA, "xa_tay_an", 547)
    W_21829 = Ward("Xã Bình Hòa", 21829, VietNamDivisionType.XA, "xa_binh_hoa", 547)
    W_21832 = Ward("Xã Tây Bình", 21832, VietNamDivisionType.XA, "xa_tay_binh", 547)
    W_21835 = Ward("Xã Bình Tường", 21835, VietNamDivisionType.XA, "xa_binh_tuong", 547)
    W_21838 = Ward("Xã Tây Vinh", 21838, VietNamDivisionType.XA, "xa_tay_vinh", 547)
    W_21841 = Ward("Xã Vĩnh An", 21841, VietNamDivisionType.XA, "xa_vinh_an", 547)
    W_21844 = Ward("Xã Tây Xuân", 21844, VietNamDivisionType.XA, "xa_tay_xuan", 547)
    W_21847 = Ward("Xã Bình Nghi", 21847, VietNamDivisionType.XA, "xa_binh_nghi", 547)
    W_21850 = Ward("Xã Tây Phú", 21850, VietNamDivisionType.XA, "xa_tay_phu", 547)
    W_21853 = Ward("Thị trấn Ngô Mây", 21853, VietNamDivisionType.THI_TRAN, "thi_tran_ngo_may", 548)
    W_21856 = Ward("Xã Cát Sơn", 21856, VietNamDivisionType.XA, "xa_cat_son", 548)
    W_21859 = Ward("Xã Cát Minh", 21859, VietNamDivisionType.XA, "xa_cat_minh", 548)
    W_21862 = Ward("Xã Cát Khánh", 21862, VietNamDivisionType.XA, "xa_cat_khanh", 548)
    W_21865 = Ward("Xã Cát Tài", 21865, VietNamDivisionType.XA, "xa_cat_tai", 548)
    W_21868 = Ward("Xã Cát Lâm", 21868, VietNamDivisionType.XA, "xa_cat_lam", 548)
    W_21871 = Ward("Xã Cát Hanh", 21871, VietNamDivisionType.XA, "xa_cat_hanh", 548)
    W_21874 = Ward("Xã Cát Thành", 21874, VietNamDivisionType.XA, "xa_cat_thanh", 548)
    W_21877 = Ward("Xã Cát Trinh", 21877, VietNamDivisionType.XA, "xa_cat_trinh", 548)
    W_21880 = Ward("Xã Cát Hải", 21880, VietNamDivisionType.XA, "xa_cat_hai", 548)
    W_21883 = Ward("Xã Cát Hiệp", 21883, VietNamDivisionType.XA, "xa_cat_hiep", 548)
    W_21886 = Ward("Xã Cát Nhơn", 21886, VietNamDivisionType.XA, "xa_cat_nhon", 548)
    W_21889 = Ward("Xã Cát Hưng", 21889, VietNamDivisionType.XA, "xa_cat_hung", 548)
    W_21892 = Ward("Xã Cát Tường", 21892, VietNamDivisionType.XA, "xa_cat_tuong", 548)
    W_21895 = Ward("Xã Cát Tân", 21895, VietNamDivisionType.XA, "xa_cat_tan", 548)
    W_21898 = Ward("Thị trấn Cát Tiến", 21898, VietNamDivisionType.THI_TRAN, "thi_tran_cat_tien", 548)
    W_21901 = Ward("Xã Cát Thắng", 21901, VietNamDivisionType.XA, "xa_cat_thang", 548)
    W_21904 = Ward("Xã Cát Chánh", 21904, VietNamDivisionType.XA, "xa_cat_chanh", 548)
    W_21907 = Ward("Phường Bình Định", 21907, VietNamDivisionType.PHUONG, "phuong_binh_dinh", 549)
    W_21910 = Ward("Phường Đập Đá", 21910, VietNamDivisionType.PHUONG, "phuong_dap_da", 549)
    W_21913 = Ward("Xã Nhơn Mỹ", 21913, VietNamDivisionType.XA, "xa_nhon_my", 549)
    W_21916 = Ward("Phường Nhơn Thành", 21916, VietNamDivisionType.PHUONG, "phuong_nhon_thanh", 549)
    W_21919 = Ward("Xã Nhơn Hạnh", 21919, VietNamDivisionType.XA, "xa_nhon_hanh", 549)
    W_21922 = Ward("Xã Nhơn Hậu", 21922, VietNamDivisionType.XA, "xa_nhon_hau", 549)
    W_21925 = Ward("Xã Nhơn Phong", 21925, VietNamDivisionType.XA, "xa_nhon_phong", 549)
    W_21928 = Ward("Xã Nhơn An", 21928, VietNamDivisionType.XA, "xa_nhon_an", 549)
    W_21931 = Ward("Xã Nhơn Phúc", 21931, VietNamDivisionType.XA, "xa_nhon_phuc", 549)
    W_21934 = Ward("Phường Nhơn Hưng", 21934, VietNamDivisionType.PHUONG, "phuong_nhon_hung", 549)
    W_21937 = Ward("Xã Nhơn Khánh", 21937, VietNamDivisionType.XA, "xa_nhon_khanh", 549)
    W_21940 = Ward("Xã Nhơn Lộc", 21940, VietNamDivisionType.XA, "xa_nhon_loc", 549)
    W_21943 = Ward("Phường Nhơn Hoà", 21943, VietNamDivisionType.PHUONG, "phuong_nhon_hoa", 549)
    W_21946 = Ward("Xã Nhơn Tân", 21946, VietNamDivisionType.XA, "xa_nhon_tan", 549)
    W_21949 = Ward("Xã Nhơn Thọ", 21949, VietNamDivisionType.XA, "xa_nhon_tho", 549)
    W_21952 = Ward("Thị trấn Tuy Phước", 21952, VietNamDivisionType.THI_TRAN, "thi_tran_tuy_phuoc", 550)
    W_21955 = Ward("Thị trấn Diêu Trì", 21955, VietNamDivisionType.THI_TRAN, "thi_tran_dieu_tri", 550)
    W_21958 = Ward("Xã Phước Thắng", 21958, VietNamDivisionType.XA, "xa_phuoc_thang", 550)
    W_21961 = Ward("Xã Phước Hưng", 21961, VietNamDivisionType.XA, "xa_phuoc_hung", 550)
    W_21964 = Ward("Xã Phước Quang", 21964, VietNamDivisionType.XA, "xa_phuoc_quang", 550)
    W_21967 = Ward("Xã Phước Hòa", 21967, VietNamDivisionType.XA, "xa_phuoc_hoa", 550)
    W_21970 = Ward("Xã Phước Sơn", 21970, VietNamDivisionType.XA, "xa_phuoc_son", 550)
    W_21973 = Ward("Xã Phước Hiệp", 21973, VietNamDivisionType.XA, "xa_phuoc_hiep", 550)
    W_21976 = Ward("Xã Phước Lộc", 21976, VietNamDivisionType.XA, "xa_phuoc_loc", 550)
    W_21979 = Ward("Xã Phước Nghĩa", 21979, VietNamDivisionType.XA, "xa_phuoc_nghia", 550)
    W_21982 = Ward("Xã Phước Thuận", 21982, VietNamDivisionType.XA, "xa_phuoc_thuan", 550)
    W_21985 = Ward("Xã Phước An", 21985, VietNamDivisionType.XA, "xa_phuoc_an", 550)
    W_21988 = Ward("Xã Phước Thành", 21988, VietNamDivisionType.XA, "xa_phuoc_thanh", 550)
    W_21994 = Ward("Thị trấn Vân Canh", 21994, VietNamDivisionType.THI_TRAN, "thi_tran_van_canh", 551)
    W_21997 = Ward("Xã Canh Liên", 21997, VietNamDivisionType.XA, "xa_canh_lien", 551)
    W_22000 = Ward("Xã Canh Hiệp", 22000, VietNamDivisionType.XA, "xa_canh_hiep", 551)
    W_22003 = Ward("Xã Canh Vinh", 22003, VietNamDivisionType.XA, "xa_canh_vinh", 551)
    W_22006 = Ward("Xã Canh Hiển", 22006, VietNamDivisionType.XA, "xa_canh_hien", 551)
    W_22009 = Ward("Xã Canh Thuận", 22009, VietNamDivisionType.XA, "xa_canh_thuan", 551)
    W_22012 = Ward("Xã Canh Hòa", 22012, VietNamDivisionType.XA, "xa_canh_hoa", 551)
    W_22015 = Ward("Phường 1", 22015, VietNamDivisionType.PHUONG, "phuong_1", 555)
    W_22018 = Ward("Phường 8", 22018, VietNamDivisionType.PHUONG, "phuong_8", 555)
    W_22021 = Ward("Phường 2", 22021, VietNamDivisionType.PHUONG, "phuong_2", 555)
    W_22024 = Ward("Phường 9", 22024, VietNamDivisionType.PHUONG, "phuong_9", 555)
    W_22027 = Ward("Phường 3", 22027, VietNamDivisionType.PHUONG, "phuong_3", 555)
    W_22030 = Ward("Phường 4", 22030, VietNamDivisionType.PHUONG, "phuong_4", 555)
    W_22033 = Ward("Phường 5", 22033, VietNamDivisionType.PHUONG, "phuong_5", 555)
    W_22036 = Ward("Phường 7", 22036, VietNamDivisionType.PHUONG, "phuong_7", 555)
    W_22039 = Ward("Phường 6", 22039, VietNamDivisionType.PHUONG, "phuong_6", 555)
    W_22040 = Ward("Phường Phú Thạnh", 22040, VietNamDivisionType.PHUONG, "phuong_phu_thanh", 555)
    W_22041 = Ward("Phường Phú Đông", 22041, VietNamDivisionType.PHUONG, "phuong_phu_dong", 555)
    W_22042 = Ward("Xã Hòa Kiến", 22042, VietNamDivisionType.XA, "xa_hoa_kien", 555)
    W_22045 = Ward("Xã Bình Kiến", 22045, VietNamDivisionType.XA, "xa_binh_kien", 555)
    W_22048 = Ward("Xã Bình Ngọc", 22048, VietNamDivisionType.XA, "xa_binh_ngoc", 555)
    W_22162 = Ward("Xã An Phú", 22162, VietNamDivisionType.XA, "xa_an_phu", 555)
    W_22240 = Ward("Phường Phú Lâm", 22240, VietNamDivisionType.PHUONG, "phuong_phu_lam", 555)
    W_22051 = Ward("Phường Xuân Phú", 22051, VietNamDivisionType.PHUONG, "phuong_xuan_phu", 557)
    W_22052 = Ward("Xã Xuân Lâm", 22052, VietNamDivisionType.XA, "xa_xuan_lam", 557)
    W_22053 = Ward("Phường Xuân Thành", 22053, VietNamDivisionType.PHUONG, "phuong_xuan_thanh", 557)
    W_22054 = Ward("Xã Xuân Hải", 22054, VietNamDivisionType.XA, "xa_xuan_hai", 557)
    W_22057 = Ward("Xã Xuân Lộc", 22057, VietNamDivisionType.XA, "xa_xuan_loc", 557)
    W_22060 = Ward("Xã Xuân Bình", 22060, VietNamDivisionType.XA, "xa_xuan_binh", 557)
    W_22066 = Ward("Xã Xuân Cảnh", 22066, VietNamDivisionType.XA, "xa_xuan_canh", 557)
    W_22069 = Ward("Xã Xuân Thịnh", 22069, VietNamDivisionType.XA, "xa_xuan_thinh", 557)
    W_22072 = Ward("Xã Xuân Phương", 22072, VietNamDivisionType.XA, "xa_xuan_phuong", 557)
    W_22073 = Ward("Phường Xuân Yên", 22073, VietNamDivisionType.PHUONG, "phuong_xuan_yen", 557)
    W_22075 = Ward("Xã Xuân Thọ 1", 22075, VietNamDivisionType.XA, "xa_xuan_tho_1", 557)
    W_22076 = Ward("Phường Xuân Đài", 22076, VietNamDivisionType.PHUONG, "phuong_xuan_dai", 557)
    W_22078 = Ward("Xã Xuân Thọ 2", 22078, VietNamDivisionType.XA, "xa_xuan_tho_2", 557)
    W_22081 = Ward("Thị trấn La Hai", 22081, VietNamDivisionType.THI_TRAN, "thi_tran_la_hai", 558)
    W_22084 = Ward("Xã Đa Lộc", 22084, VietNamDivisionType.XA, "xa_da_loc", 558)
    W_22087 = Ward("Xã Phú Mỡ", 22087, VietNamDivisionType.XA, "xa_phu_mo", 558)
    W_22090 = Ward("Xã Xuân Lãnh", 22090, VietNamDivisionType.XA, "xa_xuan_lanh", 558)
    W_22093 = Ward("Xã Xuân Long", 22093, VietNamDivisionType.XA, "xa_xuan_long", 558)
    W_22096 = Ward("Xã Xuân Quang 1", 22096, VietNamDivisionType.XA, "xa_xuan_quang_1", 558)
    W_22099 = Ward("Xã Xuân Sơn Bắc", 22099, VietNamDivisionType.XA, "xa_xuan_son_bac", 558)
    W_22102 = Ward("Xã Xuân Quang 2", 22102, VietNamDivisionType.XA, "xa_xuan_quang_2", 558)
    W_22105 = Ward("Xã Xuân Sơn Nam", 22105, VietNamDivisionType.XA, "xa_xuan_son_nam", 558)
    W_22108 = Ward("Xã Xuân Quang 3", 22108, VietNamDivisionType.XA, "xa_xuan_quang_3", 558)
    W_22111 = Ward("Xã Xuân Phước", 22111, VietNamDivisionType.XA, "xa_xuan_phuoc", 558)
    W_22114 = Ward("Thị trấn Chí Thạnh", 22114, VietNamDivisionType.THI_TRAN, "thi_tran_chi_thanh", 559)
    W_22117 = Ward("Xã An Dân", 22117, VietNamDivisionType.XA, "xa_an_dan", 559)
    W_22120 = Ward("Xã An Ninh Tây", 22120, VietNamDivisionType.XA, "xa_an_ninh_tay", 559)
    W_22123 = Ward("Xã An Ninh Đông", 22123, VietNamDivisionType.XA, "xa_an_ninh_dong", 559)
    W_22126 = Ward("Xã An Thạch", 22126, VietNamDivisionType.XA, "xa_an_thach", 559)
    W_22129 = Ward("Xã An Định", 22129, VietNamDivisionType.XA, "xa_an_dinh", 559)
    W_22132 = Ward("Xã An Nghiệp", 22132, VietNamDivisionType.XA, "xa_an_nghiep", 559)
    W_22138 = Ward("Xã An Cư", 22138, VietNamDivisionType.XA, "xa_an_cu", 559)
    W_22141 = Ward("Xã An Xuân", 22141, VietNamDivisionType.XA, "xa_an_xuan", 559)
    W_22144 = Ward("Xã An Lĩnh", 22144, VietNamDivisionType.XA, "xa_an_linh", 559)
    W_22147 = Ward("Xã An Hòa Hải", 22147, VietNamDivisionType.XA, "xa_an_hoa_hai", 559)
    W_22150 = Ward("Xã An Hiệp", 22150, VietNamDivisionType.XA, "xa_an_hiep", 559)
    W_22153 = Ward("Xã An Mỹ", 22153, VietNamDivisionType.XA, "xa_an_my", 559)
    W_22156 = Ward("Xã An Chấn", 22156, VietNamDivisionType.XA, "xa_an_chan", 559)
    W_22159 = Ward("Xã An Thọ", 22159, VietNamDivisionType.XA, "xa_an_tho", 559)
    W_22165 = Ward("Thị trấn Củng Sơn", 22165, VietNamDivisionType.THI_TRAN, "thi_tran_cung_son", 560)
    W_22168 = Ward("Xã Phước Tân", 22168, VietNamDivisionType.XA, "xa_phuoc_tan", 560)
    W_22171 = Ward("Xã Sơn Hội", 22171, VietNamDivisionType.XA, "xa_son_hoi", 560)
    W_22174 = Ward("Xã Sơn Định", 22174, VietNamDivisionType.XA, "xa_son_dinh", 560)
    W_22177 = Ward("Xã Sơn Long", 22177, VietNamDivisionType.XA, "xa_son_long", 560)
    W_22180 = Ward("Xã Cà Lúi", 22180, VietNamDivisionType.XA, "xa_ca_lui", 560)
    W_22183 = Ward("Xã Sơn Phước", 22183, VietNamDivisionType.XA, "xa_son_phuoc", 560)
    W_22186 = Ward("Xã Sơn Xuân", 22186, VietNamDivisionType.XA, "xa_son_xuan", 560)
    W_22189 = Ward("Xã Sơn Nguyên", 22189, VietNamDivisionType.XA, "xa_son_nguyen", 560)
    W_22192 = Ward("Xã Eachà Rang", 22192, VietNamDivisionType.XA, "xa_eacha_rang", 560)
    W_22195 = Ward("Xã Krông Pa", 22195, VietNamDivisionType.XA, "xa_krong_pa", 560)
    W_22198 = Ward("Xã Suối Bạc", 22198, VietNamDivisionType.XA, "xa_suoi_bac", 560)
    W_22201 = Ward("Xã Sơn Hà", 22201, VietNamDivisionType.XA, "xa_son_ha", 560)
    W_22204 = Ward("Xã Suối Trai", 22204, VietNamDivisionType.XA, "xa_suoi_trai", 560)
    W_22207 = Ward("Thị trấn Hai Riêng", 22207, VietNamDivisionType.THI_TRAN, "thi_tran_hai_rieng", 561)
    W_22210 = Ward("Xã Ea Lâm", 22210, VietNamDivisionType.XA, "xa_ea_lam", 561)
    W_22213 = Ward("Xã Đức Bình Tây", 22213, VietNamDivisionType.XA, "xa_duc_binh_tay", 561)
    W_22216 = Ward("Xã Ea Bá", 22216, VietNamDivisionType.XA, "xa_ea_ba", 561)
    W_22219 = Ward("Xã Sơn Giang", 22219, VietNamDivisionType.XA, "xa_son_giang", 561)
    W_22222 = Ward("Xã Đức Bình Đông", 22222, VietNamDivisionType.XA, "xa_duc_binh_dong", 561)
    W_22225 = Ward("Xã EaBar", 22225, VietNamDivisionType.XA, "xa_eabar", 561)
    W_22228 = Ward("Xã EaBia", 22228, VietNamDivisionType.XA, "xa_eabia", 561)
    W_22231 = Ward("Xã EaTrol", 22231, VietNamDivisionType.XA, "xa_eatrol", 561)
    W_22234 = Ward("Xã Sông Hinh", 22234, VietNamDivisionType.XA, "xa_song_hinh", 561)
    W_22237 = Ward("Xã Ealy", 22237, VietNamDivisionType.XA, "xa_ealy", 561)
    W_22249 = Ward("Xã Sơn Thành Tây", 22249, VietNamDivisionType.XA, "xa_son_thanh_tay", 562)
    W_22250 = Ward("Xã Sơn Thành Đông", 22250, VietNamDivisionType.XA, "xa_son_thanh_dong", 562)
    W_22252 = Ward("Xã Hòa Bình 1", 22252, VietNamDivisionType.XA, "xa_hoa_binh_1", 562)
    W_22255 = Ward("Thị trấn Phú Thứ", 22255, VietNamDivisionType.THI_TRAN, "thi_tran_phu_thu", 562)
    W_22264 = Ward("Xã Hòa Phong", 22264, VietNamDivisionType.XA, "xa_hoa_phong", 562)
    W_22270 = Ward("Xã Hòa Phú", 22270, VietNamDivisionType.XA, "xa_hoa_phu", 562)
    W_22273 = Ward("Xã Hòa Tân Tây", 22273, VietNamDivisionType.XA, "xa_hoa_tan_tay", 562)
    W_22276 = Ward("Xã Hòa Đồng", 22276, VietNamDivisionType.XA, "xa_hoa_dong", 562)
    W_22285 = Ward("Xã Hòa Mỹ Đông", 22285, VietNamDivisionType.XA, "xa_hoa_my_dong", 562)
    W_22288 = Ward("Xã Hòa Mỹ Tây", 22288, VietNamDivisionType.XA, "xa_hoa_my_tay", 562)
    W_22294 = Ward("Xã Hòa Thịnh", 22294, VietNamDivisionType.XA, "xa_hoa_thinh", 562)
    W_22303 = Ward("Xã Hòa Quang Bắc", 22303, VietNamDivisionType.XA, "xa_hoa_quang_bac", 563)
    W_22306 = Ward("Xã Hòa Quang Nam", 22306, VietNamDivisionType.XA, "xa_hoa_quang_nam", 563)
    W_22309 = Ward("Xã Hòa Hội", 22309, VietNamDivisionType.XA, "xa_hoa_hoi", 563)
    W_22312 = Ward("Xã Hòa Trị", 22312, VietNamDivisionType.XA, "xa_hoa_tri", 563)
    W_22315 = Ward("Xã Hòa An", 22315, VietNamDivisionType.XA, "xa_hoa_an", 563)
    W_22318 = Ward("Xã Hòa Định Đông", 22318, VietNamDivisionType.XA, "xa_hoa_dinh_dong", 563)
    W_22319 = Ward("Thị trấn Phú Hoà", 22319, VietNamDivisionType.THI_TRAN, "thi_tran_phu_hoa", 563)
    W_22321 = Ward("Xã Hòa Định Tây", 22321, VietNamDivisionType.XA, "xa_hoa_dinh_tay", 563)
    W_22324 = Ward("Xã Hòa Thắng", 22324, VietNamDivisionType.XA, "xa_hoa_thang", 563)
    W_22243 = Ward("Xã Hòa Thành", 22243, VietNamDivisionType.XA, "xa_hoa_thanh", 564)
    W_22246 = Ward("Phường Hòa Hiệp Bắc", 22246, VietNamDivisionType.PHUONG, "phuong_hoa_hiep_bac", 564)
    W_22258 = Ward("Phường Hoà Vinh", 22258, VietNamDivisionType.PHUONG, "phuong_hoa_vinh", 564)
    W_22261 = Ward("Phường Hoà Hiệp Trung", 22261, VietNamDivisionType.PHUONG, "phuong_hoa_hiep_trung", 564)
    W_22267 = Ward("Xã Hòa Tân Đông", 22267, VietNamDivisionType.XA, "xa_hoa_tan_dong", 564)
    W_22279 = Ward("Phường Hòa Xuân Tây", 22279, VietNamDivisionType.PHUONG, "phuong_hoa_xuan_tay", 564)
    W_22282 = Ward("Phường Hòa Hiệp Nam", 22282, VietNamDivisionType.PHUONG, "phuong_hoa_hiep_nam", 564)
    W_22291 = Ward("Xã Hòa Xuân Đông", 22291, VietNamDivisionType.XA, "xa_hoa_xuan_dong", 564)
    W_22297 = Ward("Xã Hòa Tâm", 22297, VietNamDivisionType.XA, "xa_hoa_tam", 564)
    W_22300 = Ward("Xã Hòa Xuân Nam", 22300, VietNamDivisionType.XA, "xa_hoa_xuan_nam", 564)
    W_22327 = Ward("Phường Vĩnh Hòa", 22327, VietNamDivisionType.PHUONG, "phuong_vinh_hoa", 568)
    W_22330 = Ward("Phường Vĩnh Hải", 22330, VietNamDivisionType.PHUONG, "phuong_vinh_hai", 568)
    W_22333 = Ward("Phường Vĩnh Phước", 22333, VietNamDivisionType.PHUONG, "phuong_vinh_phuoc", 568)
    W_22336 = Ward("Phường Ngọc Hiệp", 22336, VietNamDivisionType.PHUONG, "phuong_ngoc_hiep", 568)
    W_22339 = Ward("Phường Vĩnh Thọ", 22339, VietNamDivisionType.PHUONG, "phuong_vinh_tho", 568)
    W_22342 = Ward("Phường Xương Huân", 22342, VietNamDivisionType.PHUONG, "phuong_xuong_huan", 568)
    W_22345 = Ward("Phường Vạn Thắng", 22345, VietNamDivisionType.PHUONG, "phuong_van_thang", 568)
    W_22348 = Ward("Phường Vạn Thạnh", 22348, VietNamDivisionType.PHUONG, "phuong_van_thanh", 568)
    W_22351 = Ward("Phường Phương Sài", 22351, VietNamDivisionType.PHUONG, "phuong_phuong_sai", 568)
    W_22354 = Ward("Phường Phương Sơn", 22354, VietNamDivisionType.PHUONG, "phuong_phuong_son", 568)
    W_22357 = Ward("Phường Phước Hải", 22357, VietNamDivisionType.PHUONG, "phuong_phuoc_hai", 568)
    W_22360 = Ward("Phường Phước Tân", 22360, VietNamDivisionType.PHUONG, "phuong_phuoc_tan", 568)
    W_22363 = Ward("Phường Lộc Thọ", 22363, VietNamDivisionType.PHUONG, "phuong_loc_tho", 568)
    W_22366 = Ward("Phường Phước Tiến", 22366, VietNamDivisionType.PHUONG, "phuong_phuoc_tien", 568)
    W_22369 = Ward("Phường Tân Lập", 22369, VietNamDivisionType.PHUONG, "phuong_tan_lap", 568)
    W_22372 = Ward("Phường Phước Hòa", 22372, VietNamDivisionType.PHUONG, "phuong_phuoc_hoa", 568)
    W_22375 = Ward("Phường Vĩnh Nguyên", 22375, VietNamDivisionType.PHUONG, "phuong_vinh_nguyen", 568)
    W_22378 = Ward("Phường Phước Long", 22378, VietNamDivisionType.PHUONG, "phuong_phuoc_long", 568)
    W_22381 = Ward("Phường Vĩnh Trường", 22381, VietNamDivisionType.PHUONG, "phuong_vinh_truong", 568)
    W_22384 = Ward("Xã Vĩnh Lương", 22384, VietNamDivisionType.XA, "xa_vinh_luong", 568)
    W_22387 = Ward("Xã Vĩnh Phương", 22387, VietNamDivisionType.XA, "xa_vinh_phuong", 568)
    W_22390 = Ward("Xã Vĩnh Ngọc", 22390, VietNamDivisionType.XA, "xa_vinh_ngoc", 568)
    W_22393 = Ward("Xã Vĩnh Thạnh", 22393, VietNamDivisionType.XA, "xa_vinh_thanh", 568)
    W_22396 = Ward("Xã Vĩnh Trung", 22396, VietNamDivisionType.XA, "xa_vinh_trung", 568)
    W_22399 = Ward("Xã Vĩnh Hiệp", 22399, VietNamDivisionType.XA, "xa_vinh_hiep", 568)
    W_22402 = Ward("Xã Vĩnh Thái", 22402, VietNamDivisionType.XA, "xa_vinh_thai", 568)
    W_22405 = Ward("Xã Phước Đồng", 22405, VietNamDivisionType.XA, "xa_phuoc_dong", 568)
    W_22408 = Ward("Phường Cam Nghĩa", 22408, VietNamDivisionType.PHUONG, "phuong_cam_nghia", 569)
    W_22411 = Ward("Phường Cam Phúc Bắc", 22411, VietNamDivisionType.PHUONG, "phuong_cam_phuc_bac", 569)
    W_22414 = Ward("Phường Cam Phúc Nam", 22414, VietNamDivisionType.PHUONG, "phuong_cam_phuc_nam", 569)
    W_22417 = Ward("Phường Cam Lộc", 22417, VietNamDivisionType.PHUONG, "phuong_cam_loc", 569)
    W_22420 = Ward("Phường Cam Phú", 22420, VietNamDivisionType.PHUONG, "phuong_cam_phu", 569)
    W_22423 = Ward("Phường Ba Ngòi", 22423, VietNamDivisionType.PHUONG, "phuong_ba_ngoi", 569)
    W_22426 = Ward("Phường Cam Thuận", 22426, VietNamDivisionType.PHUONG, "phuong_cam_thuan", 569)
    W_22429 = Ward("Phường Cam Lợi", 22429, VietNamDivisionType.PHUONG, "phuong_cam_loi", 569)
    W_22432 = Ward("Phường Cam Linh", 22432, VietNamDivisionType.PHUONG, "phuong_cam_linh", 569)
    W_22468 = Ward("Xã Cam Thành Nam", 22468, VietNamDivisionType.XA, "xa_cam_thanh_nam", 569)
    W_22474 = Ward("Xã Cam Phước Đông", 22474, VietNamDivisionType.XA, "xa_cam_phuoc_dong", 569)
    W_22477 = Ward("Xã Cam Thịnh Tây", 22477, VietNamDivisionType.XA, "xa_cam_thinh_tay", 569)
    W_22480 = Ward("Xã Cam Thịnh Đông", 22480, VietNamDivisionType.XA, "xa_cam_thinh_dong", 569)
    W_22483 = Ward("Xã Cam Lập", 22483, VietNamDivisionType.XA, "xa_cam_lap", 569)
    W_22486 = Ward("Xã Cam Bình", 22486, VietNamDivisionType.XA, "xa_cam_binh", 569)
    W_22435 = Ward("Xã Cam Tân", 22435, VietNamDivisionType.XA, "xa_cam_tan", 570)
    W_22438 = Ward("Xã Cam Hòa", 22438, VietNamDivisionType.XA, "xa_cam_hoa", 570)
    W_22441 = Ward("Xã Cam Hải Đông", 22441, VietNamDivisionType.XA, "xa_cam_hai_dong", 570)
    W_22444 = Ward("Xã Cam Hải Tây", 22444, VietNamDivisionType.XA, "xa_cam_hai_tay", 570)
    W_22447 = Ward("Xã Sơn Tân", 22447, VietNamDivisionType.XA, "xa_son_tan", 570)
    W_22450 = Ward("Xã Cam Hiệp Bắc", 22450, VietNamDivisionType.XA, "xa_cam_hiep_bac", 570)
    W_22453 = Ward("Thị trấn Cam Đức", 22453, VietNamDivisionType.THI_TRAN, "thi_tran_cam_duc", 570)
    W_22456 = Ward("Xã Cam Hiệp Nam", 22456, VietNamDivisionType.XA, "xa_cam_hiep_nam", 570)
    W_22459 = Ward("Xã Cam Phước Tây", 22459, VietNamDivisionType.XA, "xa_cam_phuoc_tay", 570)
    W_22462 = Ward("Xã Cam Thành Bắc", 22462, VietNamDivisionType.XA, "xa_cam_thanh_bac", 570)
    W_22465 = Ward("Xã Cam An Bắc", 22465, VietNamDivisionType.XA, "xa_cam_an_bac", 570)
    W_22471 = Ward("Xã Cam An Nam", 22471, VietNamDivisionType.XA, "xa_cam_an_nam", 570)
    W_22708 = Ward("Xã Suối Cát", 22708, VietNamDivisionType.XA, "xa_suoi_cat", 570)
    W_22711 = Ward("Xã Suối Tân", 22711, VietNamDivisionType.XA, "xa_suoi_tan", 570)
    W_22489 = Ward("Thị trấn Vạn Giã", 22489, VietNamDivisionType.THI_TRAN, "thi_tran_van_gia", 571)
    W_22492 = Ward("Xã Đại Lãnh", 22492, VietNamDivisionType.XA, "xa_dai_lanh", 571)
    W_22495 = Ward("Xã Vạn Phước", 22495, VietNamDivisionType.XA, "xa_van_phuoc", 571)
    W_22498 = Ward("Xã Vạn Long", 22498, VietNamDivisionType.XA, "xa_van_long", 571)
    W_22501 = Ward("Xã Vạn Bình", 22501, VietNamDivisionType.XA, "xa_van_binh", 571)
    W_22504 = Ward("Xã Vạn Thọ", 22504, VietNamDivisionType.XA, "xa_van_tho", 571)
    W_22507 = Ward("Xã Vạn Khánh", 22507, VietNamDivisionType.XA, "xa_van_khanh", 571)
    W_22510 = Ward("Xã Vạn Phú", 22510, VietNamDivisionType.XA, "xa_van_phu", 571)
    W_22513 = Ward("Xã Vạn Lương", 22513, VietNamDivisionType.XA, "xa_van_luong", 571)
    W_22516 = Ward("Xã Vạn Thắng", 22516, VietNamDivisionType.XA, "xa_van_thang", 571)
    W_22519 = Ward("Xã Vạn Thạnh", 22519, VietNamDivisionType.XA, "xa_van_thanh", 571)
    W_22522 = Ward("Xã Xuân Sơn", 22522, VietNamDivisionType.XA, "xa_xuan_son", 571)
    W_22525 = Ward("Xã Vạn Hưng", 22525, VietNamDivisionType.XA, "xa_van_hung", 571)
    W_22528 = Ward("Phường Ninh Hiệp", 22528, VietNamDivisionType.PHUONG, "phuong_ninh_hiep", 572)
    W_22531 = Ward("Xã Ninh Sơn", 22531, VietNamDivisionType.XA, "xa_ninh_son", 572)
    W_22534 = Ward("Xã Ninh Tây", 22534, VietNamDivisionType.XA, "xa_ninh_tay", 572)
    W_22537 = Ward("Xã Ninh Thượng", 22537, VietNamDivisionType.XA, "xa_ninh_thuong", 572)
    W_22540 = Ward("Xã Ninh An", 22540, VietNamDivisionType.XA, "xa_ninh_an", 572)
    W_22543 = Ward("Phường Ninh Hải", 22543, VietNamDivisionType.PHUONG, "phuong_ninh_hai", 572)
    W_22546 = Ward("Xã Ninh Thọ", 22546, VietNamDivisionType.XA, "xa_ninh_tho", 572)
    W_22549 = Ward("Xã Ninh Trung", 22549, VietNamDivisionType.XA, "xa_ninh_trung", 572)
    W_22552 = Ward("Xã Ninh Sim", 22552, VietNamDivisionType.XA, "xa_ninh_sim", 572)
    W_22555 = Ward("Xã Ninh Xuân", 22555, VietNamDivisionType.XA, "xa_ninh_xuan", 572)
    W_22558 = Ward("Xã Ninh Thân", 22558, VietNamDivisionType.XA, "xa_ninh_than", 572)
    W_22561 = Ward("Phường Ninh Diêm", 22561, VietNamDivisionType.PHUONG, "phuong_ninh_diem", 572)
    W_22564 = Ward("Xã Ninh Đông", 22564, VietNamDivisionType.XA, "xa_ninh_dong", 572)
    W_22567 = Ward("Phường Ninh Thủy", 22567, VietNamDivisionType.PHUONG, "phuong_ninh_thuy", 572)
    W_22570 = Ward("Phường Ninh Đa", 22570, VietNamDivisionType.PHUONG, "phuong_ninh_da", 572)
    W_22573 = Ward("Xã Ninh Phụng", 22573, VietNamDivisionType.XA, "xa_ninh_phung", 572)
    W_22576 = Ward("Xã Ninh Bình", 22576, VietNamDivisionType.XA, "xa_ninh_binh", 572)
    W_22579 = Ward("Xã Ninh Phước", 22579, VietNamDivisionType.XA, "xa_ninh_phuoc", 572)
    W_22582 = Ward("Xã Ninh Phú", 22582, VietNamDivisionType.XA, "xa_ninh_phu", 572)
    W_22585 = Ward("Xã Ninh Tân", 22585, VietNamDivisionType.XA, "xa_ninh_tan", 572)
    W_22588 = Ward("Xã Ninh Quang", 22588, VietNamDivisionType.XA, "xa_ninh_quang", 572)
    W_22591 = Ward("Phường Ninh Giang", 22591, VietNamDivisionType.PHUONG, "phuong_ninh_giang", 572)
    W_22594 = Ward("Phường Ninh Hà", 22594, VietNamDivisionType.PHUONG, "phuong_ninh_ha", 572)
    W_22597 = Ward("Xã Ninh Hưng", 22597, VietNamDivisionType.XA, "xa_ninh_hung", 572)
    W_22600 = Ward("Xã Ninh Lộc", 22600, VietNamDivisionType.XA, "xa_ninh_loc", 572)
    W_22603 = Ward("Xã Ninh Ích", 22603, VietNamDivisionType.XA, "xa_ninh_ich", 572)
    W_22606 = Ward("Xã Ninh Vân", 22606, VietNamDivisionType.XA, "xa_ninh_van", 572)
    W_22609 = Ward("Thị trấn Khánh Vĩnh", 22609, VietNamDivisionType.THI_TRAN, "thi_tran_khanh_vinh", 573)
    W_22612 = Ward("Xã Khánh Hiệp", 22612, VietNamDivisionType.XA, "xa_khanh_hiep", 573)
    W_22615 = Ward("Xã Khánh Bình", 22615, VietNamDivisionType.XA, "xa_khanh_binh", 573)
    W_22618 = Ward("Xã Khánh Trung", 22618, VietNamDivisionType.XA, "xa_khanh_trung", 573)
    W_22621 = Ward("Xã Khánh Đông", 22621, VietNamDivisionType.XA, "xa_khanh_dong", 573)
    W_22624 = Ward("Xã Khánh Thượng", 22624, VietNamDivisionType.XA, "xa_khanh_thuong", 573)
    W_22627 = Ward("Xã Khánh Nam", 22627, VietNamDivisionType.XA, "xa_khanh_nam", 573)
    W_22630 = Ward("Xã Sông Cầu", 22630, VietNamDivisionType.XA, "xa_song_cau", 573)
    W_22633 = Ward("Xã Giang Ly", 22633, VietNamDivisionType.XA, "xa_giang_ly", 573)
    W_22636 = Ward("Xã Cầu Bà", 22636, VietNamDivisionType.XA, "xa_cau_ba", 573)
    W_22639 = Ward("Xã Liên Sang", 22639, VietNamDivisionType.XA, "xa_lien_sang", 573)
    W_22642 = Ward("Xã Khánh Thành", 22642, VietNamDivisionType.XA, "xa_khanh_thanh", 573)
    W_22645 = Ward("Xã Khánh Phú", 22645, VietNamDivisionType.XA, "xa_khanh_phu", 573)
    W_22648 = Ward("Xã Sơn Thái", 22648, VietNamDivisionType.XA, "xa_son_thai", 573)
    W_22651 = Ward("Thị trấn Diên Khánh", 22651, VietNamDivisionType.THI_TRAN, "thi_tran_dien_khanh", 574)
    W_22654 = Ward("Xã Diên Lâm", 22654, VietNamDivisionType.XA, "xa_dien_lam", 574)
    W_22657 = Ward("Xã Diên Điền", 22657, VietNamDivisionType.XA, "xa_dien_dien", 574)
    W_22660 = Ward("Xã Diên Xuân", 22660, VietNamDivisionType.XA, "xa_dien_xuan", 574)
    W_22663 = Ward("Xã Diên Sơn", 22663, VietNamDivisionType.XA, "xa_dien_son", 574)
    W_22666 = Ward("Xã Diên Đồng", 22666, VietNamDivisionType.XA, "xa_dien_dong", 574)
    W_22669 = Ward("Xã Diên Phú", 22669, VietNamDivisionType.XA, "xa_dien_phu", 574)
    W_22672 = Ward("Xã Diên Thọ", 22672, VietNamDivisionType.XA, "xa_dien_tho", 574)
    W_22675 = Ward("Xã Diên Phước", 22675, VietNamDivisionType.XA, "xa_dien_phuoc", 574)
    W_22678 = Ward("Xã Diên Lạc", 22678, VietNamDivisionType.XA, "xa_dien_lac", 574)
    W_22681 = Ward("Xã Diên Tân", 22681, VietNamDivisionType.XA, "xa_dien_tan", 574)
    W_22684 = Ward("Xã Diên Hòa", 22684, VietNamDivisionType.XA, "xa_dien_hoa", 574)
    W_22687 = Ward("Xã Diên Thạnh", 22687, VietNamDivisionType.XA, "xa_dien_thanh", 574)
    W_22690 = Ward("Xã Diên Toàn", 22690, VietNamDivisionType.XA, "xa_dien_toan", 574)
    W_22693 = Ward("Xã Diên An", 22693, VietNamDivisionType.XA, "xa_dien_an", 574)
    W_22696 = Ward("Xã Bình Lộc", 22696, VietNamDivisionType.XA, "xa_binh_loc", 574)
    W_22702 = Ward("Xã Suối Hiệp", 22702, VietNamDivisionType.XA, "xa_suoi_hiep", 574)
    W_22705 = Ward("Xã Suối Tiên", 22705, VietNamDivisionType.XA, "xa_suoi_tien", 574)
    W_22714 = Ward("Thị trấn Tô Hạp", 22714, VietNamDivisionType.THI_TRAN, "thi_tran_to_hap", 575)
    W_22717 = Ward("Xã Thành Sơn", 22717, VietNamDivisionType.XA, "xa_thanh_son", 575)
    W_22720 = Ward("Xã Sơn Lâm", 22720, VietNamDivisionType.XA, "xa_son_lam", 575)
    W_22723 = Ward("Xã Sơn Hiệp", 22723, VietNamDivisionType.XA, "xa_son_hiep", 575)
    W_22726 = Ward("Xã Sơn Bình", 22726, VietNamDivisionType.XA, "xa_son_binh", 575)
    W_22729 = Ward("Xã Sơn Trung", 22729, VietNamDivisionType.XA, "xa_son_trung", 575)
    W_22732 = Ward("Xã Ba Cụm Bắc", 22732, VietNamDivisionType.XA, "xa_ba_cum_bac", 575)
    W_22735 = Ward("Xã Ba Cụm Nam", 22735, VietNamDivisionType.XA, "xa_ba_cum_nam", 575)
    W_22736 = Ward("Thị trấn Trường Sa", 22736, VietNamDivisionType.THI_TRAN, "thi_tran_truong_sa", 576)
    W_22737 = Ward("Xã Song Tử Tây", 22737, VietNamDivisionType.XA, "xa_song_tu_tay", 576)
    W_22739 = Ward("Xã Sinh Tồn", 22739, VietNamDivisionType.XA, "xa_sinh_ton", 576)
    W_22738 = Ward("Phường Đô Vinh", 22738, VietNamDivisionType.PHUONG, "phuong_do_vinh", 582)
    W_22741 = Ward("Phường Phước Mỹ", 22741, VietNamDivisionType.PHUONG, "phuong_phuoc_my", 582)
    W_22744 = Ward("Phường Bảo An", 22744, VietNamDivisionType.PHUONG, "phuong_bao_an", 582)
    W_22747 = Ward("Phường Phủ Hà", 22747, VietNamDivisionType.PHUONG, "phuong_phu_ha", 582)
    W_22750 = Ward("Phường Thanh Sơn", 22750, VietNamDivisionType.PHUONG, "phuong_thanh_son", 582)
    W_22753 = Ward("Phường Mỹ Hương", 22753, VietNamDivisionType.PHUONG, "phuong_my_huong", 582)
    W_22756 = Ward("Phường Tấn Tài", 22756, VietNamDivisionType.PHUONG, "phuong_tan_tai", 582)
    W_22759 = Ward("Phường Kinh Dinh", 22759, VietNamDivisionType.PHUONG, "phuong_kinh_dinh", 582)
    W_22762 = Ward("Phường Đạo Long", 22762, VietNamDivisionType.PHUONG, "phuong_dao_long", 582)
    W_22765 = Ward("Phường Đài Sơn", 22765, VietNamDivisionType.PHUONG, "phuong_dai_son", 582)
    W_22768 = Ward("Phường Đông Hải", 22768, VietNamDivisionType.PHUONG, "phuong_dong_hai", 582)
    W_22771 = Ward("Phường Mỹ Đông", 22771, VietNamDivisionType.PHUONG, "phuong_my_dong", 582)
    W_22774 = Ward("Xã Thành Hải", 22774, VietNamDivisionType.XA, "xa_thanh_hai", 582)
    W_22777 = Ward("Phường Văn Hải", 22777, VietNamDivisionType.PHUONG, "phuong_van_hai", 582)
    W_22779 = Ward("Phường Mỹ Bình", 22779, VietNamDivisionType.PHUONG, "phuong_my_binh", 582)
    W_22780 = Ward("Phường Mỹ Hải", 22780, VietNamDivisionType.PHUONG, "phuong_my_hai", 582)
    W_22783 = Ward("Xã Phước Bình", 22783, VietNamDivisionType.XA, "xa_phuoc_binh", 584)
    W_22786 = Ward("Xã Phước Hòa", 22786, VietNamDivisionType.XA, "xa_phuoc_hoa", 584)
    W_22789 = Ward("Xã Phước Tân", 22789, VietNamDivisionType.XA, "xa_phuoc_tan", 584)
    W_22792 = Ward("Xã Phước Tiến", 22792, VietNamDivisionType.XA, "xa_phuoc_tien", 584)
    W_22795 = Ward("Xã Phước Thắng", 22795, VietNamDivisionType.XA, "xa_phuoc_thang", 584)
    W_22798 = Ward("Xã Phước Thành", 22798, VietNamDivisionType.XA, "xa_phuoc_thanh", 584)
    W_22801 = Ward("Xã Phước Đại", 22801, VietNamDivisionType.XA, "xa_phuoc_dai", 584)
    W_22804 = Ward("Xã Phước Chính", 22804, VietNamDivisionType.XA, "xa_phuoc_chinh", 584)
    W_22807 = Ward("Xã Phước Trung", 22807, VietNamDivisionType.XA, "xa_phuoc_trung", 584)
    W_22810 = Ward("Thị trấn Tân Sơn", 22810, VietNamDivisionType.THI_TRAN, "thi_tran_tan_son", 585)
    W_22813 = Ward("Xã Lâm Sơn", 22813, VietNamDivisionType.XA, "xa_lam_son", 585)
    W_22816 = Ward("Xã Lương Sơn", 22816, VietNamDivisionType.XA, "xa_luong_son", 585)
    W_22819 = Ward("Xã Quảng Sơn", 22819, VietNamDivisionType.XA, "xa_quang_son", 585)
    W_22822 = Ward("Xã Mỹ Sơn", 22822, VietNamDivisionType.XA, "xa_my_son", 585)
    W_22825 = Ward("Xã Hòa Sơn", 22825, VietNamDivisionType.XA, "xa_hoa_son", 585)
    W_22828 = Ward("Xã Ma Nới", 22828, VietNamDivisionType.XA, "xa_ma_noi", 585)
    W_22831 = Ward("Xã Nhơn Sơn", 22831, VietNamDivisionType.XA, "xa_nhon_son", 585)
    W_22834 = Ward("Thị trấn Khánh Hải", 22834, VietNamDivisionType.THI_TRAN, "thi_tran_khanh_hai", 586)
    W_22846 = Ward("Xã Vĩnh Hải", 22846, VietNamDivisionType.XA, "xa_vinh_hai", 586)
    W_22852 = Ward("Xã Phương Hải", 22852, VietNamDivisionType.XA, "xa_phuong_hai", 586)
    W_22855 = Ward("Xã Tân Hải", 22855, VietNamDivisionType.XA, "xa_tan_hai", 586)
    W_22858 = Ward("Xã Xuân Hải", 22858, VietNamDivisionType.XA, "xa_xuan_hai", 586)
    W_22861 = Ward("Xã Hộ Hải", 22861, VietNamDivisionType.XA, "xa_ho_hai", 586)
    W_22864 = Ward("Xã Tri Hải", 22864, VietNamDivisionType.XA, "xa_tri_hai", 586)
    W_22867 = Ward("Xã Nhơn Hải", 22867, VietNamDivisionType.XA, "xa_nhon_hai", 586)
    W_22868 = Ward("Xã Thanh Hải", 22868, VietNamDivisionType.XA, "xa_thanh_hai", 586)
    W_22870 = Ward("Thị trấn Phước Dân", 22870, VietNamDivisionType.THI_TRAN, "thi_tran_phuoc_dan", 587)
    W_22873 = Ward("Xã Phước Sơn", 22873, VietNamDivisionType.XA, "xa_phuoc_son", 587)
    W_22876 = Ward("Xã Phước Thái", 22876, VietNamDivisionType.XA, "xa_phuoc_thai", 587)
    W_22879 = Ward("Xã Phước Hậu", 22879, VietNamDivisionType.XA, "xa_phuoc_hau", 587)
    W_22882 = Ward("Xã Phước Thuận", 22882, VietNamDivisionType.XA, "xa_phuoc_thuan", 587)
    W_22888 = Ward("Xã An Hải", 22888, VietNamDivisionType.XA, "xa_an_hai", 587)
    W_22891 = Ward("Xã Phước Hữu", 22891, VietNamDivisionType.XA, "xa_phuoc_huu", 587)
    W_22894 = Ward("Xã Phước Hải", 22894, VietNamDivisionType.XA, "xa_phuoc_hai", 587)
    W_22912 = Ward("Xã Phước Vinh", 22912, VietNamDivisionType.XA, "xa_phuoc_vinh", 587)
    W_22837 = Ward("Xã Phước Chiến", 22837, VietNamDivisionType.XA, "xa_phuoc_chien", 588)
    W_22840 = Ward("Xã Công Hải", 22840, VietNamDivisionType.XA, "xa_cong_hai", 588)
    W_22843 = Ward("Xã Phước Kháng", 22843, VietNamDivisionType.XA, "xa_phuoc_khang", 588)
    W_22849 = Ward("Xã Lợi Hải", 22849, VietNamDivisionType.XA, "xa_loi_hai", 588)
    W_22853 = Ward("Xã Bắc Sơn", 22853, VietNamDivisionType.XA, "xa_bac_son", 588)
    W_22856 = Ward("Xã Bắc Phong", 22856, VietNamDivisionType.XA, "xa_bac_phong", 588)
    W_22885 = Ward("Xã Phước Hà", 22885, VietNamDivisionType.XA, "xa_phuoc_ha", 589)
    W_22897 = Ward("Xã Phước Nam", 22897, VietNamDivisionType.XA, "xa_phuoc_nam", 589)
    W_22898 = Ward("Xã Phước Ninh", 22898, VietNamDivisionType.XA, "xa_phuoc_ninh", 589)
    W_22900 = Ward("Xã Nhị Hà", 22900, VietNamDivisionType.XA, "xa_nhi_ha", 589)
    W_22903 = Ward("Xã Phước Dinh", 22903, VietNamDivisionType.XA, "xa_phuoc_dinh", 589)
    W_22906 = Ward("Xã Phước Minh", 22906, VietNamDivisionType.XA, "xa_phuoc_minh", 589)
    W_22909 = Ward("Xã Phước Diêm", 22909, VietNamDivisionType.XA, "xa_phuoc_diem", 589)
    W_22910 = Ward("Xã Cà Ná", 22910, VietNamDivisionType.XA, "xa_ca_na", 589)
    W_22915 = Ward("Phường Mũi Né", 22915, VietNamDivisionType.PHUONG, "phuong_mui_ne", 593)
    W_22918 = Ward("Phường Hàm Tiến", 22918, VietNamDivisionType.PHUONG, "phuong_ham_tien", 593)
    W_22921 = Ward("Phường Phú Hài", 22921, VietNamDivisionType.PHUONG, "phuong_phu_hai", 593)
    W_22924 = Ward("Phường Phú Thủy", 22924, VietNamDivisionType.PHUONG, "phuong_phu_thuy", 593)
    W_22927 = Ward("Phường Phú Tài", 22927, VietNamDivisionType.PHUONG, "phuong_phu_tai", 593)
    W_22930 = Ward("Phường Phú Trinh", 22930, VietNamDivisionType.PHUONG, "phuong_phu_trinh", 593)
    W_22933 = Ward("Phường Xuân An", 22933, VietNamDivisionType.PHUONG, "phuong_xuan_an", 593)
    W_22936 = Ward("Phường Thanh Hải", 22936, VietNamDivisionType.PHUONG, "phuong_thanh_hai", 593)
    W_22939 = Ward("Phường Bình Hưng", 22939, VietNamDivisionType.PHUONG, "phuong_binh_hung", 593)
    W_22942 = Ward("Phường Đức Nghĩa", 22942, VietNamDivisionType.PHUONG, "phuong_duc_nghia", 593)
    W_22945 = Ward("Phường Lạc Đạo", 22945, VietNamDivisionType.PHUONG, "phuong_lac_dao", 593)
    W_22948 = Ward("Phường Đức Thắng", 22948, VietNamDivisionType.PHUONG, "phuong_duc_thang", 593)
    W_22951 = Ward("Phường Hưng Long", 22951, VietNamDivisionType.PHUONG, "phuong_hung_long", 593)
    W_22954 = Ward("Phường Đức Long", 22954, VietNamDivisionType.PHUONG, "phuong_duc_long", 593)
    W_22957 = Ward("Xã Thiện Nghiệp", 22957, VietNamDivisionType.XA, "xa_thien_nghiep", 593)
    W_22960 = Ward("Xã Phong Nẫm", 22960, VietNamDivisionType.XA, "xa_phong_nam", 593)
    W_22963 = Ward("Xã Tiến Lợi", 22963, VietNamDivisionType.XA, "xa_tien_loi", 593)
    W_22966 = Ward("Xã Tiến Thành", 22966, VietNamDivisionType.XA, "xa_tien_thanh", 593)
    W_23231 = Ward("Phường Phước Hội", 23231, VietNamDivisionType.PHUONG, "phuong_phuoc_hoi", 594)
    W_23232 = Ward("Phường Phước Lộc", 23232, VietNamDivisionType.PHUONG, "phuong_phuoc_loc", 594)
    W_23234 = Ward("Phường Tân Thiện", 23234, VietNamDivisionType.PHUONG, "phuong_tan_thien", 594)
    W_23235 = Ward("Phường Tân An", 23235, VietNamDivisionType.PHUONG, "phuong_tan_an", 594)
    W_23237 = Ward("Phường Bình Tân", 23237, VietNamDivisionType.PHUONG, "phuong_binh_tan", 594)
    W_23245 = Ward("Xã Tân Hải", 23245, VietNamDivisionType.XA, "xa_tan_hai", 594)
    W_23246 = Ward("Xã Tân Tiến", 23246, VietNamDivisionType.XA, "xa_tan_tien", 594)
    W_23248 = Ward("Xã Tân Bình", 23248, VietNamDivisionType.XA, "xa_tan_binh", 594)
    W_23268 = Ward("Xã Tân Phước", 23268, VietNamDivisionType.XA, "xa_tan_phuoc", 594)
    W_22969 = Ward("Thị trấn Liên Hương", 22969, VietNamDivisionType.THI_TRAN, "thi_tran_lien_huong", 595)
    W_22972 = Ward("Thị trấn Phan Rí Cửa", 22972, VietNamDivisionType.THI_TRAN, "thi_tran_phan_ri_cua", 595)
    W_22975 = Ward("Xã Phan Dũng", 22975, VietNamDivisionType.XA, "xa_phan_dung", 595)
    W_22978 = Ward("Xã Phong Phú", 22978, VietNamDivisionType.XA, "xa_phong_phu", 595)
    W_22981 = Ward("Xã Vĩnh Hảo", 22981, VietNamDivisionType.XA, "xa_vinh_hao", 595)
    W_22984 = Ward("Xã Vĩnh Tân", 22984, VietNamDivisionType.XA, "xa_vinh_tan", 595)
    W_22987 = Ward("Xã Phú Lạc", 22987, VietNamDivisionType.XA, "xa_phu_lac", 595)
    W_22990 = Ward("Xã Phước Thể", 22990, VietNamDivisionType.XA, "xa_phuoc_the", 595)
    W_22993 = Ward("Xã Hòa Minh", 22993, VietNamDivisionType.XA, "xa_hoa_minh", 595)
    W_22996 = Ward("Xã Chí Công", 22996, VietNamDivisionType.XA, "xa_chi_cong", 595)
    W_22999 = Ward("Xã Bình Thạnh", 22999, VietNamDivisionType.XA, "xa_binh_thanh", 595)
    W_23005 = Ward("Thị trấn Chợ Lầu", 23005, VietNamDivisionType.THI_TRAN, "thi_tran_cho_lau", 596)
    W_23008 = Ward("Xã Phan Sơn", 23008, VietNamDivisionType.XA, "xa_phan_son", 596)
    W_23011 = Ward("Xã Phan Lâm", 23011, VietNamDivisionType.XA, "xa_phan_lam", 596)
    W_23014 = Ward("Xã Bình An", 23014, VietNamDivisionType.XA, "xa_binh_an", 596)
    W_23017 = Ward("Xã Phan Điền", 23017, VietNamDivisionType.XA, "xa_phan_dien", 596)
    W_23020 = Ward("Xã Hải Ninh", 23020, VietNamDivisionType.XA, "xa_hai_ninh", 596)
    W_23023 = Ward("Xã Sông Lũy", 23023, VietNamDivisionType.XA, "xa_song_luy", 596)
    W_23026 = Ward("Xã Phan Tiến", 23026, VietNamDivisionType.XA, "xa_phan_tien", 596)
    W_23029 = Ward("Xã Sông Bình", 23029, VietNamDivisionType.XA, "xa_song_binh", 596)
    W_23032 = Ward("Thị trấn Lương Sơn", 23032, VietNamDivisionType.THI_TRAN, "thi_tran_luong_son", 596)
    W_23035 = Ward("Xã Phan Hòa", 23035, VietNamDivisionType.XA, "xa_phan_hoa", 596)
    W_23038 = Ward("Xã Phan Thanh", 23038, VietNamDivisionType.XA, "xa_phan_thanh", 596)
    W_23041 = Ward("Xã Hồng Thái", 23041, VietNamDivisionType.XA, "xa_hong_thai", 596)
    W_23044 = Ward("Xã Phan Hiệp", 23044, VietNamDivisionType.XA, "xa_phan_hiep", 596)
    W_23047 = Ward("Xã Bình Tân", 23047, VietNamDivisionType.XA, "xa_binh_tan", 596)
    W_23050 = Ward("Xã Phan Rí Thành", 23050, VietNamDivisionType.XA, "xa_phan_ri_thanh", 596)
    W_23053 = Ward("Xã Hòa Thắng", 23053, VietNamDivisionType.XA, "xa_hoa_thang", 596)
    W_23056 = Ward("Xã Hồng Phong", 23056, VietNamDivisionType.XA, "xa_hong_phong", 596)
    W_23059 = Ward("Thị trấn Ma Lâm", 23059, VietNamDivisionType.THI_TRAN, "thi_tran_ma_lam", 597)
    W_23062 = Ward("Thị trấn Phú Long", 23062, VietNamDivisionType.THI_TRAN, "thi_tran_phu_long", 597)
    W_23065 = Ward("Xã La Dạ", 23065, VietNamDivisionType.XA, "xa_la_da", 597)
    W_23068 = Ward("Xã Đông Tiến", 23068, VietNamDivisionType.XA, "xa_dong_tien", 597)
    W_23071 = Ward("Xã Thuận Hòa", 23071, VietNamDivisionType.XA, "xa_thuan_hoa", 597)
    W_23074 = Ward("Xã Đông Giang", 23074, VietNamDivisionType.XA, "xa_dong_giang", 597)
    W_23077 = Ward("Xã Hàm Phú", 23077, VietNamDivisionType.XA, "xa_ham_phu", 597)
    W_23080 = Ward("Xã Hồng Liêm", 23080, VietNamDivisionType.XA, "xa_hong_liem", 597)
    W_23083 = Ward("Xã Thuận Minh", 23083, VietNamDivisionType.XA, "xa_thuan_minh", 597)
    W_23086 = Ward("Xã Hồng Sơn", 23086, VietNamDivisionType.XA, "xa_hong_son", 597)
    W_23089 = Ward("Xã Hàm Trí", 23089, VietNamDivisionType.XA, "xa_ham_tri", 597)
    W_23092 = Ward("Xã Hàm Đức", 23092, VietNamDivisionType.XA, "xa_ham_duc", 597)
    W_23095 = Ward("Xã Hàm Liêm", 23095, VietNamDivisionType.XA, "xa_ham_liem", 597)
    W_23098 = Ward("Xã Hàm Chính", 23098, VietNamDivisionType.XA, "xa_ham_chinh", 597)
    W_23101 = Ward("Xã Hàm Hiệp", 23101, VietNamDivisionType.XA, "xa_ham_hiep", 597)
    W_23104 = Ward("Xã Hàm Thắng", 23104, VietNamDivisionType.XA, "xa_ham_thang", 597)
    W_23107 = Ward("Xã Đa Mi", 23107, VietNamDivisionType.XA, "xa_da_mi", 597)
    W_23110 = Ward("Thị trấn Thuận Nam", 23110, VietNamDivisionType.THI_TRAN, "thi_tran_thuan_nam", 598)
    W_23113 = Ward("Xã Mỹ Thạnh", 23113, VietNamDivisionType.XA, "xa_my_thanh", 598)
    W_23116 = Ward("Xã Hàm Cần", 23116, VietNamDivisionType.XA, "xa_ham_can", 598)
    W_23119 = Ward("Xã Mương Mán", 23119, VietNamDivisionType.XA, "xa_muong_man", 598)
    W_23122 = Ward("Xã Hàm Thạnh", 23122, VietNamDivisionType.XA, "xa_ham_thanh", 598)
    W_23125 = Ward("Xã Hàm Kiệm", 23125, VietNamDivisionType.XA, "xa_ham_kiem", 598)
    W_23128 = Ward("Xã Hàm Cường", 23128, VietNamDivisionType.XA, "xa_ham_cuong", 598)
    W_23131 = Ward("Xã Hàm Mỹ", 23131, VietNamDivisionType.XA, "xa_ham_my", 598)
    W_23134 = Ward("Xã Tân Lập", 23134, VietNamDivisionType.XA, "xa_tan_lap", 598)
    W_23137 = Ward("Xã Hàm Minh", 23137, VietNamDivisionType.XA, "xa_ham_minh", 598)
    W_23140 = Ward("Xã Thuận Quí", 23140, VietNamDivisionType.XA, "xa_thuan_qui", 598)
    W_23143 = Ward("Xã Tân Thuận", 23143, VietNamDivisionType.XA, "xa_tan_thuan", 598)
    W_23146 = Ward("Xã Tân Thành", 23146, VietNamDivisionType.XA, "xa_tan_thanh", 598)
    W_23149 = Ward("Thị trấn Lạc Tánh", 23149, VietNamDivisionType.THI_TRAN, "thi_tran_lac_tanh", 599)
    W_23152 = Ward("Xã Bắc Ruộng", 23152, VietNamDivisionType.XA, "xa_bac_ruong", 599)
    W_23158 = Ward("Xã Nghị Đức", 23158, VietNamDivisionType.XA, "xa_nghi_duc", 599)
    W_23161 = Ward("Xã La Ngâu", 23161, VietNamDivisionType.XA, "xa_la_ngau", 599)
    W_23164 = Ward("Xã Huy Khiêm", 23164, VietNamDivisionType.XA, "xa_huy_khiem", 599)
    W_23167 = Ward("Xã Măng Tố", 23167, VietNamDivisionType.XA, "xa_mang_to", 599)
    W_23170 = Ward("Xã Đức Phú", 23170, VietNamDivisionType.XA, "xa_duc_phu", 599)
    W_23173 = Ward("Xã Đồng Kho", 23173, VietNamDivisionType.XA, "xa_dong_kho", 599)
    W_23176 = Ward("Xã Gia An", 23176, VietNamDivisionType.XA, "xa_gia_an", 599)
    W_23179 = Ward("Xã Đức Bình", 23179, VietNamDivisionType.XA, "xa_duc_binh", 599)
    W_23182 = Ward("Xã Gia Huynh", 23182, VietNamDivisionType.XA, "xa_gia_huynh", 599)
    W_23185 = Ward("Xã Đức Thuận", 23185, VietNamDivisionType.XA, "xa_duc_thuan", 599)
    W_23188 = Ward("Xã Suối Kiết", 23188, VietNamDivisionType.XA, "xa_suoi_kiet", 599)
    W_23191 = Ward("Thị trấn Võ Xu", 23191, VietNamDivisionType.THI_TRAN, "thi_tran_vo_xu", 600)
    W_23194 = Ward("Thị trấn Đức Tài", 23194, VietNamDivisionType.THI_TRAN, "thi_tran_duc_tai", 600)
    W_23197 = Ward("Xã Đa Kai", 23197, VietNamDivisionType.XA, "xa_da_kai", 600)
    W_23200 = Ward("Xã Sùng Nhơn", 23200, VietNamDivisionType.XA, "xa_sung_nhon", 600)
    W_23203 = Ward("Xã Mê Pu", 23203, VietNamDivisionType.XA, "xa_me_pu", 600)
    W_23206 = Ward("Xã Nam Chính", 23206, VietNamDivisionType.XA, "xa_nam_chinh", 600)
    W_23212 = Ward("Xã Đức Hạnh", 23212, VietNamDivisionType.XA, "xa_duc_hanh", 600)
    W_23215 = Ward("Xã Đức Tín", 23215, VietNamDivisionType.XA, "xa_duc_tin", 600)
    W_23218 = Ward("Xã Vũ Hoà", 23218, VietNamDivisionType.XA, "xa_vu_hoa", 600)
    W_23221 = Ward("Xã Tân Hà", 23221, VietNamDivisionType.XA, "xa_tan_ha", 600)
    W_23224 = Ward("Xã Đông Hà", 23224, VietNamDivisionType.XA, "xa_dong_ha", 600)
    W_23227 = Ward("Xã Trà Tân", 23227, VietNamDivisionType.XA, "xa_tra_tan", 600)
    W_23230 = Ward("Thị trấn Tân Minh", 23230, VietNamDivisionType.THI_TRAN, "thi_tran_tan_minh", 601)
    W_23236 = Ward("Thị trấn Tân Nghĩa", 23236, VietNamDivisionType.THI_TRAN, "thi_tran_tan_nghia", 601)
    W_23239 = Ward("Xã Sông Phan", 23239, VietNamDivisionType.XA, "xa_song_phan", 601)
    W_23242 = Ward("Xã Tân Phúc", 23242, VietNamDivisionType.XA, "xa_tan_phuc", 601)
    W_23251 = Ward("Xã Tân Đức", 23251, VietNamDivisionType.XA, "xa_tan_duc", 601)
    W_23254 = Ward("Xã Tân Thắng", 23254, VietNamDivisionType.XA, "xa_tan_thang", 601)
    W_23255 = Ward("Xã Thắng Hải", 23255, VietNamDivisionType.XA, "xa_thang_hai", 601)
    W_23257 = Ward("Xã Tân Hà", 23257, VietNamDivisionType.XA, "xa_tan_ha", 601)
    W_23260 = Ward("Xã Tân Xuân", 23260, VietNamDivisionType.XA, "xa_tan_xuan", 601)
    W_23266 = Ward("Xã Sơn Mỹ", 23266, VietNamDivisionType.XA, "xa_son_my", 601)
    W_23272 = Ward("Xã Ngũ Phụng", 23272, VietNamDivisionType.XA, "xa_ngu_phung", 602)
    W_23275 = Ward("Xã Long Hải", 23275, VietNamDivisionType.XA, "xa_long_hai", 602)
    W_23278 = Ward("Xã Tam Thanh", 23278, VietNamDivisionType.XA, "xa_tam_thanh", 602)
    W_23281 = Ward("Phường Quang Trung", 23281, VietNamDivisionType.PHUONG, "phuong_quang_trung", 608)
    W_23284 = Ward("Phường Duy Tân", 23284, VietNamDivisionType.PHUONG, "phuong_duy_tan", 608)
    W_23287 = Ward("Phường Quyết Thắng", 23287, VietNamDivisionType.PHUONG, "phuong_quyet_thang", 608)
    W_23290 = Ward("Phường Trường Chinh", 23290, VietNamDivisionType.PHUONG, "phuong_truong_chinh", 608)
    W_23293 = Ward("Phường Thắng Lợi", 23293, VietNamDivisionType.PHUONG, "phuong_thang_loi", 608)
    W_23296 = Ward("Phường Ngô Mây", 23296, VietNamDivisionType.PHUONG, "phuong_ngo_may", 608)
    W_23299 = Ward("Phường Thống Nhất", 23299, VietNamDivisionType.PHUONG, "phuong_thong_nhat", 608)
    W_23302 = Ward("Phường Lê Lợi", 23302, VietNamDivisionType.PHUONG, "phuong_le_loi", 608)
    W_23305 = Ward("Phường Nguyễn Trãi", 23305, VietNamDivisionType.PHUONG, "phuong_nguyen_trai", 608)
    W_23308 = Ward("Phường Trần Hưng Đạo", 23308, VietNamDivisionType.PHUONG, "phuong_tran_hung_dao", 608)
    W_23311 = Ward("Xã Đắk Cấm", 23311, VietNamDivisionType.XA, "xa_dak_cam", 608)
    W_23314 = Ward("Xã Kroong", 23314, VietNamDivisionType.XA, "xa_kroong", 608)
    W_23317 = Ward("Xã Ngọk Bay", 23317, VietNamDivisionType.XA, "xa_ngok_bay", 608)
    W_23320 = Ward("Xã Vinh Quang", 23320, VietNamDivisionType.XA, "xa_vinh_quang", 608)
    W_23323 = Ward("Xã Đắk Blà", 23323, VietNamDivisionType.XA, "xa_dak_bla", 608)
    W_23326 = Ward("Xã Ia Chim", 23326, VietNamDivisionType.XA, "xa_ia_chim", 608)
    W_23327 = Ward("Xã Đăk Năng", 23327, VietNamDivisionType.XA, "xa_dak_nang", 608)
    W_23329 = Ward("Xã Đoàn Kết", 23329, VietNamDivisionType.XA, "xa_doan_ket", 608)
    W_23332 = Ward("Xã Chư Hreng", 23332, VietNamDivisionType.XA, "xa_chu_hreng", 608)
    W_23335 = Ward("Xã Đắk Rơ Wa", 23335, VietNamDivisionType.XA, "xa_dak_ro_wa", 608)
    W_23338 = Ward("Xã Hòa Bình", 23338, VietNamDivisionType.XA, "xa_hoa_binh", 608)
    W_23341 = Ward("Thị trấn Đắk Glei", 23341, VietNamDivisionType.THI_TRAN, "thi_tran_dak_glei", 610)
    W_23344 = Ward("Xã Đắk Blô", 23344, VietNamDivisionType.XA, "xa_dak_blo", 610)
    W_23347 = Ward("Xã Đắk Man", 23347, VietNamDivisionType.XA, "xa_dak_man", 610)
    W_23350 = Ward("Xã Đắk Nhoong", 23350, VietNamDivisionType.XA, "xa_dak_nhoong", 610)
    W_23353 = Ward("Xã Đắk Pék", 23353, VietNamDivisionType.XA, "xa_dak_pek", 610)
    W_23356 = Ward("Xã Đắk Choong", 23356, VietNamDivisionType.XA, "xa_dak_choong", 610)
    W_23359 = Ward("Xã Xốp", 23359, VietNamDivisionType.XA, "xa_xop", 610)
    W_23362 = Ward("Xã Mường Hoong", 23362, VietNamDivisionType.XA, "xa_muong_hoong", 610)
    W_23365 = Ward("Xã Ngọc Linh", 23365, VietNamDivisionType.XA, "xa_ngoc_linh", 610)
    W_23368 = Ward("Xã Đắk Long", 23368, VietNamDivisionType.XA, "xa_dak_long", 610)
    W_23371 = Ward("Xã Đắk KRoong", 23371, VietNamDivisionType.XA, "xa_dak_kroong", 610)
    W_23374 = Ward("Xã Đắk Môn", 23374, VietNamDivisionType.XA, "xa_dak_mon", 610)
    W_23377 = Ward("Thị trấn Plei Kần", 23377, VietNamDivisionType.THI_TRAN, "thi_tran_plei_kan", 611)
    W_23380 = Ward("Xã Đắk Ang", 23380, VietNamDivisionType.XA, "xa_dak_ang", 611)
    W_23383 = Ward("Xã Đắk Dục", 23383, VietNamDivisionType.XA, "xa_dak_duc", 611)
    W_23386 = Ward("Xã Đắk Nông", 23386, VietNamDivisionType.XA, "xa_dak_nong", 611)
    W_23389 = Ward("Xã Đắk Xú", 23389, VietNamDivisionType.XA, "xa_dak_xu", 611)
    W_23392 = Ward("Xã Đắk Kan", 23392, VietNamDivisionType.XA, "xa_dak_kan", 611)
    W_23395 = Ward("Xã Bờ Y", 23395, VietNamDivisionType.XA, "xa_bo_y", 611)
    W_23398 = Ward("Xã Sa Loong", 23398, VietNamDivisionType.XA, "xa_sa_loong", 611)
    W_23401 = Ward("Thị trấn Đắk Tô", 23401, VietNamDivisionType.THI_TRAN, "thi_tran_dak_to", 612)
    W_23427 = Ward("Xã Đắk Rơ Nga", 23427, VietNamDivisionType.XA, "xa_dak_ro_nga", 612)
    W_23428 = Ward("Xã Ngọk Tụ", 23428, VietNamDivisionType.XA, "xa_ngok_tu", 612)
    W_23430 = Ward("Xã Đắk Trăm", 23430, VietNamDivisionType.XA, "xa_dak_tram", 612)
    W_23431 = Ward("Xã Văn Lem", 23431, VietNamDivisionType.XA, "xa_van_lem", 612)
    W_23434 = Ward("Xã Kon Đào", 23434, VietNamDivisionType.XA, "xa_kon_dao", 612)
    W_23437 = Ward("Xã Tân Cảnh", 23437, VietNamDivisionType.XA, "xa_tan_canh", 612)
    W_23440 = Ward("Xã Diên Bình", 23440, VietNamDivisionType.XA, "xa_dien_binh", 612)
    W_23443 = Ward("Xã Pô Kô", 23443, VietNamDivisionType.XA, "xa_po_ko", 612)
    W_23452 = Ward("Xã Đắk Nên", 23452, VietNamDivisionType.XA, "xa_dak_nen", 613)
    W_23455 = Ward("Xã Đắk Ring", 23455, VietNamDivisionType.XA, "xa_dak_ring", 613)
    W_23458 = Ward("Xã Măng Buk", 23458, VietNamDivisionType.XA, "xa_mang_buk", 613)
    W_23461 = Ward("Xã Đắk Tăng", 23461, VietNamDivisionType.XA, "xa_dak_tang", 613)
    W_23464 = Ward("Xã Ngok Tem", 23464, VietNamDivisionType.XA, "xa_ngok_tem", 613)
    W_23467 = Ward("Xã Pờ Ê", 23467, VietNamDivisionType.XA, "xa_po_e", 613)
    W_23470 = Ward("Xã Măng Cành", 23470, VietNamDivisionType.XA, "xa_mang_canh", 613)
    W_23473 = Ward("Thị trấn Măng Đen", 23473, VietNamDivisionType.THI_TRAN, "thi_tran_mang_den", 613)
    W_23476 = Ward("Xã Hiếu", 23476, VietNamDivisionType.XA, "xa_hieu", 613)
    W_23479 = Ward("Thị trấn Đắk Rve", 23479, VietNamDivisionType.THI_TRAN, "thi_tran_dak_rve", 614)
    W_23482 = Ward("Xã Đắk Kôi", 23482, VietNamDivisionType.XA, "xa_dak_koi", 614)
    W_23485 = Ward("Xã Đắk Tơ Lung", 23485, VietNamDivisionType.XA, "xa_dak_to_lung", 614)
    W_23488 = Ward("Xã Đắk Ruồng", 23488, VietNamDivisionType.XA, "xa_dak_ruong", 614)
    W_23491 = Ward("Xã Đắk Pne", 23491, VietNamDivisionType.XA, "xa_dak_pne", 614)
    W_23494 = Ward("Xã Đắk Tờ Re", 23494, VietNamDivisionType.XA, "xa_dak_to_re", 614)
    W_23497 = Ward("Xã Tân Lập", 23497, VietNamDivisionType.XA, "xa_tan_lap", 614)
    W_23500 = Ward("Thị trấn Đắk Hà", 23500, VietNamDivisionType.THI_TRAN, "thi_tran_dak_ha", 615)
    W_23503 = Ward("Xã Đắk PXi", 23503, VietNamDivisionType.XA, "xa_dak_pxi", 615)
    W_23504 = Ward("Xã Đăk Long", 23504, VietNamDivisionType.XA, "xa_dak_long", 615)
    W_23506 = Ward("Xã Đắk HRing", 23506, VietNamDivisionType.XA, "xa_dak_hring", 615)
    W_23509 = Ward("Xã Đắk Ui", 23509, VietNamDivisionType.XA, "xa_dak_ui", 615)
    W_23510 = Ward("Xã Đăk Ngọk", 23510, VietNamDivisionType.XA, "xa_dak_ngok", 615)
    W_23512 = Ward("Xã Đắk Mar", 23512, VietNamDivisionType.XA, "xa_dak_mar", 615)
    W_23515 = Ward("Xã Ngok Wang", 23515, VietNamDivisionType.XA, "xa_ngok_wang", 615)
    W_23518 = Ward("Xã Ngok Réo", 23518, VietNamDivisionType.XA, "xa_ngok_reo", 615)
    W_23521 = Ward("Xã Hà Mòn", 23521, VietNamDivisionType.XA, "xa_ha_mon", 615)
    W_23524 = Ward("Xã Đắk La", 23524, VietNamDivisionType.XA, "xa_dak_la", 615)
    W_23527 = Ward("Thị trấn Sa Thầy", 23527, VietNamDivisionType.THI_TRAN, "thi_tran_sa_thay", 616)
    W_23530 = Ward("Xã Rơ Kơi", 23530, VietNamDivisionType.XA, "xa_ro_koi", 616)
    W_23533 = Ward("Xã Sa Nhơn", 23533, VietNamDivisionType.XA, "xa_sa_nhon", 616)
    W_23534 = Ward("Xã Hơ Moong", 23534, VietNamDivisionType.XA, "xa_ho_moong", 616)
    W_23536 = Ward("Xã Mô Rai", 23536, VietNamDivisionType.XA, "xa_mo_rai", 616)
    W_23539 = Ward("Xã Sa Sơn", 23539, VietNamDivisionType.XA, "xa_sa_son", 616)
    W_23542 = Ward("Xã Sa Nghĩa", 23542, VietNamDivisionType.XA, "xa_sa_nghia", 616)
    W_23545 = Ward("Xã Sa Bình", 23545, VietNamDivisionType.XA, "xa_sa_binh", 616)
    W_23548 = Ward("Xã Ya Xiêr", 23548, VietNamDivisionType.XA, "xa_ya_xier", 616)
    W_23551 = Ward("Xã Ya Tăng", 23551, VietNamDivisionType.XA, "xa_ya_tang", 616)
    W_23554 = Ward("Xã Ya ly", 23554, VietNamDivisionType.XA, "xa_ya_ly", 616)
    W_23404 = Ward("Xã Ngọc Lây", 23404, VietNamDivisionType.XA, "xa_ngoc_lay", 617)
    W_23407 = Ward("Xã Đắk Na", 23407, VietNamDivisionType.XA, "xa_dak_na", 617)
    W_23410 = Ward("Xã Măng Ri", 23410, VietNamDivisionType.XA, "xa_mang_ri", 617)
    W_23413 = Ward("Xã Ngọc Yêu", 23413, VietNamDivisionType.XA, "xa_ngoc_yeu", 617)
    W_23416 = Ward("Xã Đắk Sao", 23416, VietNamDivisionType.XA, "xa_dak_sao", 617)
    W_23417 = Ward("Xã Đắk Rơ Ông", 23417, VietNamDivisionType.XA, "xa_dak_ro_ong", 617)
    W_23419 = Ward("Xã Đắk Tờ Kan", 23419, VietNamDivisionType.XA, "xa_dak_to_kan", 617)
    W_23422 = Ward("Xã Tu Mơ Rông", 23422, VietNamDivisionType.XA, "xa_tu_mo_rong", 617)
    W_23425 = Ward("Xã Đắk Hà", 23425, VietNamDivisionType.XA, "xa_dak_ha", 617)
    W_23446 = Ward("Xã Tê Xăng", 23446, VietNamDivisionType.XA, "xa_te_xang", 617)
    W_23449 = Ward("Xã Văn Xuôi", 23449, VietNamDivisionType.XA, "xa_van_xuoi", 617)
    W_23535 = Ward("Xã Ia Đal", 23535, VietNamDivisionType.XA, "xa_ia_dal", 618)
    W_23537 = Ward("Xã Ia Dom", 23537, VietNamDivisionType.XA, "xa_ia_dom", 618)
    W_23538 = Ward("Xã Ia Tơi", 23538, VietNamDivisionType.XA, "xa_ia_toi", 618)
    W_23557 = Ward("Phường Yên Đỗ", 23557, VietNamDivisionType.PHUONG, "phuong_yen_do", 622)
    W_23560 = Ward("Phường Diên Hồng", 23560, VietNamDivisionType.PHUONG, "phuong_dien_hong", 622)
    W_23563 = Ward("Phường Ia Kring", 23563, VietNamDivisionType.PHUONG, "phuong_ia_kring", 622)
    W_23566 = Ward("Phường Hội Thương", 23566, VietNamDivisionType.PHUONG, "phuong_hoi_thuong", 622)
    W_23569 = Ward("Phường Hội Phú", 23569, VietNamDivisionType.PHUONG, "phuong_hoi_phu", 622)
    W_23570 = Ward("Phường Phù Đổng", 23570, VietNamDivisionType.PHUONG, "phuong_phu_dong", 622)
    W_23572 = Ward("Phường Hoa Lư", 23572, VietNamDivisionType.PHUONG, "phuong_hoa_lu", 622)
    W_23575 = Ward("Phường Tây Sơn", 23575, VietNamDivisionType.PHUONG, "phuong_tay_son", 622)
    W_23578 = Ward("Phường Thống Nhất", 23578, VietNamDivisionType.PHUONG, "phuong_thong_nhat", 622)
    W_23579 = Ward("Phường Đống Đa", 23579, VietNamDivisionType.PHUONG, "phuong_dong_da", 622)
    W_23581 = Ward("Phường Trà Bá", 23581, VietNamDivisionType.PHUONG, "phuong_tra_ba", 622)
    W_23582 = Ward("Phường Thắng Lợi", 23582, VietNamDivisionType.PHUONG, "phuong_thang_loi", 622)
    W_23584 = Ward("Phường Yên Thế", 23584, VietNamDivisionType.PHUONG, "phuong_yen_the", 622)
    W_23586 = Ward("Phường Chi Lăng", 23586, VietNamDivisionType.PHUONG, "phuong_chi_lang", 622)
    W_23590 = Ward("Xã Biển Hồ", 23590, VietNamDivisionType.XA, "xa_bien_ho", 622)
    W_23593 = Ward("Xã Tân Sơn", 23593, VietNamDivisionType.XA, "xa_tan_son", 622)
    W_23596 = Ward("Xã Trà Đa", 23596, VietNamDivisionType.XA, "xa_tra_da", 622)
    W_23599 = Ward("Xã Chư Á", 23599, VietNamDivisionType.XA, "xa_chu_a", 622)
    W_23602 = Ward("Xã An Phú", 23602, VietNamDivisionType.XA, "xa_an_phu", 622)
    W_23605 = Ward("Xã Diên Phú", 23605, VietNamDivisionType.XA, "xa_dien_phu", 622)
    W_23608 = Ward("Xã Ia Kênh", 23608, VietNamDivisionType.XA, "xa_ia_kenh", 622)
    W_23611 = Ward("Xã Gào", 23611, VietNamDivisionType.XA, "xa_gao", 622)
    W_23614 = Ward("Phường An Bình", 23614, VietNamDivisionType.PHUONG, "phuong_an_binh", 623)
    W_23617 = Ward("Phường Tây Sơn", 23617, VietNamDivisionType.PHUONG, "phuong_tay_son", 623)
    W_23620 = Ward("Phường An Phú", 23620, VietNamDivisionType.PHUONG, "phuong_an_phu", 623)
    W_23623 = Ward("Phường An Tân", 23623, VietNamDivisionType.PHUONG, "phuong_an_tan", 623)
    W_23626 = Ward("Xã Tú An", 23626, VietNamDivisionType.XA, "xa_tu_an", 623)
    W_23627 = Ward("Xã Xuân An", 23627, VietNamDivisionType.XA, "xa_xuan_an", 623)
    W_23629 = Ward("Xã Cửu An", 23629, VietNamDivisionType.XA, "xa_cuu_an", 623)
    W_23630 = Ward("Phường An Phước", 23630, VietNamDivisionType.PHUONG, "phuong_an_phuoc", 623)
    W_23632 = Ward("Xã Song An", 23632, VietNamDivisionType.XA, "xa_song_an", 623)
    W_23633 = Ward("Phường Ngô Mây", 23633, VietNamDivisionType.PHUONG, "phuong_ngo_may", 623)
    W_23635 = Ward("Xã Thành An", 23635, VietNamDivisionType.XA, "xa_thanh_an", 623)
    W_24041 = Ward("Phường Cheo Reo", 24041, VietNamDivisionType.PHUONG, "phuong_cheo_reo", 624)
    W_24042 = Ward("Phường Hòa Bình", 24042, VietNamDivisionType.PHUONG, "phuong_hoa_binh", 624)
    W_24044 = Ward("Phường Đoàn Kết", 24044, VietNamDivisionType.PHUONG, "phuong_doan_ket", 624)
    W_24045 = Ward("Phường Sông Bờ", 24045, VietNamDivisionType.PHUONG, "phuong_song_bo", 624)
    W_24064 = Ward("Xã Ia RBol", 24064, VietNamDivisionType.XA, "xa_ia_rbol", 624)
    W_24065 = Ward("Xã Chư Băh", 24065, VietNamDivisionType.XA, "xa_chu_bah", 624)
    W_24070 = Ward("Xã Ia RTô", 24070, VietNamDivisionType.XA, "xa_ia_rto", 624)
    W_24073 = Ward("Xã Ia Sao", 24073, VietNamDivisionType.XA, "xa_ia_sao", 624)
    W_23638 = Ward("Thị trấn KBang", 23638, VietNamDivisionType.THI_TRAN, "thi_tran_kbang", 625)
    W_23641 = Ward("Xã Kon Pne", 23641, VietNamDivisionType.XA, "xa_kon_pne", 625)
    W_23644 = Ward("Xã Đăk Roong", 23644, VietNamDivisionType.XA, "xa_dak_roong", 625)
    W_23647 = Ward("Xã Sơn Lang", 23647, VietNamDivisionType.XA, "xa_son_lang", 625)
    W_23650 = Ward("Xã KRong", 23650, VietNamDivisionType.XA, "xa_krong", 625)
    W_23653 = Ward("Xã Sơ Pai", 23653, VietNamDivisionType.XA, "xa_so_pai", 625)
    W_23656 = Ward("Xã Lơ Ku", 23656, VietNamDivisionType.XA, "xa_lo_ku", 625)
    W_23659 = Ward("Xã Đông", 23659, VietNamDivisionType.XA, "xa_dong", 625)
    W_23660 = Ward("Xã Đak SMar", 23660, VietNamDivisionType.XA, "xa_dak_smar", 625)
    W_23662 = Ward("Xã Nghĩa An", 23662, VietNamDivisionType.XA, "xa_nghia_an", 625)
    W_23665 = Ward("Xã Tơ Tung", 23665, VietNamDivisionType.XA, "xa_to_tung", 625)
    W_23668 = Ward("Xã Kông Lơng Khơng", 23668, VietNamDivisionType.XA, "xa_kong_long_khong", 625)
    W_23671 = Ward("Xã Kông Pla", 23671, VietNamDivisionType.XA, "xa_kong_pla", 625)
    W_23674 = Ward("Xã Đăk HLơ", 23674, VietNamDivisionType.XA, "xa_dak_hlo", 625)
    W_23677 = Ward("Thị trấn Đăk Đoa", 23677, VietNamDivisionType.THI_TRAN, "thi_tran_dak_doa", 626)
    W_23680 = Ward("Xã Hà Đông", 23680, VietNamDivisionType.XA, "xa_ha_dong", 626)
    W_23683 = Ward("Xã Đăk Sơmei", 23683, VietNamDivisionType.XA, "xa_dak_somei", 626)
    W_23684 = Ward("Xã Đăk Krong", 23684, VietNamDivisionType.XA, "xa_dak_krong", 626)
    W_23686 = Ward("Xã Hải Yang", 23686, VietNamDivisionType.XA, "xa_hai_yang", 626)
    W_23689 = Ward("Xã Kon Gang", 23689, VietNamDivisionType.XA, "xa_kon_gang", 626)
    W_23692 = Ward("Xã Hà Bầu", 23692, VietNamDivisionType.XA, "xa_ha_bau", 626)
    W_23695 = Ward("Xã Nam Yang", 23695, VietNamDivisionType.XA, "xa_nam_yang", 626)
    W_23698 = Ward("Xã K' Dang", 23698, VietNamDivisionType.XA, "xa_k_dang", 626)
    W_23701 = Ward("Xã H' Neng", 23701, VietNamDivisionType.XA, "xa_h_neng", 626)
    W_23704 = Ward("Xã Tân Bình", 23704, VietNamDivisionType.XA, "xa_tan_binh", 626)
    W_23707 = Ward("Xã Glar", 23707, VietNamDivisionType.XA, "xa_glar", 626)
    W_23710 = Ward("Xã A Dơk", 23710, VietNamDivisionType.XA, "xa_a_dok", 626)
    W_23713 = Ward("Xã Trang", 23713, VietNamDivisionType.XA, "xa_trang", 626)
    W_23714 = Ward("Xã HNol", 23714, VietNamDivisionType.XA, "xa_hnol", 626)
    W_23716 = Ward("Xã Ia Pết", 23716, VietNamDivisionType.XA, "xa_ia_pet", 626)
    W_23719 = Ward("Xã Ia Băng", 23719, VietNamDivisionType.XA, "xa_ia_bang", 626)
    W_23722 = Ward("Thị trấn Phú Hòa", 23722, VietNamDivisionType.THI_TRAN, "thi_tran_phu_hoa", 627)
    W_23725 = Ward("Xã Hà Tây", 23725, VietNamDivisionType.XA, "xa_ha_tay", 627)
    W_23728 = Ward("Xã Ia Khươl", 23728, VietNamDivisionType.XA, "xa_ia_khuol", 627)
    W_23731 = Ward("Xã Ia Phí", 23731, VietNamDivisionType.XA, "xa_ia_phi", 627)
    W_23734 = Ward("Thị trấn Ia Ly", 23734, VietNamDivisionType.THI_TRAN, "thi_tran_ia_ly", 627)
    W_23737 = Ward("Xã Ia Mơ Nông", 23737, VietNamDivisionType.XA, "xa_ia_mo_nong", 627)
    W_23738 = Ward("Xã Ia Kreng", 23738, VietNamDivisionType.XA, "xa_ia_kreng", 627)
    W_23740 = Ward("Xã Đăk Tơ Ver", 23740, VietNamDivisionType.XA, "xa_dak_to_ver", 627)
    W_23743 = Ward("Xã Hòa Phú", 23743, VietNamDivisionType.XA, "xa_hoa_phu", 627)
    W_23746 = Ward("Xã Chư Đăng Ya", 23746, VietNamDivisionType.XA, "xa_chu_dang_ya", 627)
    W_23749 = Ward("Xã Ia Ka", 23749, VietNamDivisionType.XA, "xa_ia_ka", 627)
    W_23752 = Ward("Xã Ia Nhin", 23752, VietNamDivisionType.XA, "xa_ia_nhin", 627)
    W_23755 = Ward("Xã Nghĩa Hòa", 23755, VietNamDivisionType.XA, "xa_nghia_hoa", 627)
    W_23761 = Ward("Xã Nghĩa Hưng", 23761, VietNamDivisionType.XA, "xa_nghia_hung", 627)
    W_23764 = Ward("Thị trấn Ia Kha", 23764, VietNamDivisionType.THI_TRAN, "thi_tran_ia_kha", 628)
    W_23767 = Ward("Xã Ia Sao", 23767, VietNamDivisionType.XA, "xa_ia_sao", 628)
    W_23768 = Ward("Xã Ia Yok", 23768, VietNamDivisionType.XA, "xa_ia_yok", 628)
    W_23770 = Ward("Xã Ia Hrung", 23770, VietNamDivisionType.XA, "xa_ia_hrung", 628)
    W_23771 = Ward("Xã Ia Bă", 23771, VietNamDivisionType.XA, "xa_ia_ba", 628)
    W_23773 = Ward("Xã Ia Khai", 23773, VietNamDivisionType.XA, "xa_ia_khai", 628)
    W_23776 = Ward("Xã Ia KRai", 23776, VietNamDivisionType.XA, "xa_ia_krai", 628)
    W_23778 = Ward("Xã Ia Grăng", 23778, VietNamDivisionType.XA, "xa_ia_grang", 628)
    W_23779 = Ward("Xã Ia Tô", 23779, VietNamDivisionType.XA, "xa_ia_to", 628)
    W_23782 = Ward("Xã Ia O", 23782, VietNamDivisionType.XA, "xa_ia_o", 628)
    W_23785 = Ward("Xã Ia Dêr", 23785, VietNamDivisionType.XA, "xa_ia_der", 628)
    W_23788 = Ward("Xã Ia Chia", 23788, VietNamDivisionType.XA, "xa_ia_chia", 628)
    W_23791 = Ward("Xã Ia Pếch", 23791, VietNamDivisionType.XA, "xa_ia_pech", 628)
    W_23794 = Ward("Thị trấn Kon Dơng", 23794, VietNamDivisionType.THI_TRAN, "thi_tran_kon_dong", 629)
    W_23797 = Ward("Xã Ayun", 23797, VietNamDivisionType.XA, "xa_ayun", 629)
    W_23798 = Ward("Xã Đak Jơ Ta", 23798, VietNamDivisionType.XA, "xa_dak_jo_ta", 629)
    W_23799 = Ward("Xã Đak Ta Ley", 23799, VietNamDivisionType.XA, "xa_dak_ta_ley", 629)
    W_23800 = Ward("Xã Hra", 23800, VietNamDivisionType.XA, "xa_hra", 629)
    W_23803 = Ward("Xã Đăk Yă", 23803, VietNamDivisionType.XA, "xa_dak_ya", 629)
    W_23806 = Ward("Xã Đăk Djrăng", 23806, VietNamDivisionType.XA, "xa_dak_djrang", 629)
    W_23809 = Ward("Xã Lơ Pang", 23809, VietNamDivisionType.XA, "xa_lo_pang", 629)
    W_23812 = Ward("Xã Kon Thụp", 23812, VietNamDivisionType.XA, "xa_kon_thup", 629)
    W_23815 = Ward("Xã Đê Ar", 23815, VietNamDivisionType.XA, "xa_de_ar", 629)
    W_23818 = Ward("Xã Kon Chiêng", 23818, VietNamDivisionType.XA, "xa_kon_chieng", 629)
    W_23821 = Ward("Xã Đăk Trôi", 23821, VietNamDivisionType.XA, "xa_dak_troi", 629)
    W_23824 = Ward("Thị trấn Kông Chro", 23824, VietNamDivisionType.THI_TRAN, "thi_tran_kong_chro", 630)
    W_23827 = Ward("Xã Chư Krêy", 23827, VietNamDivisionType.XA, "xa_chu_krey", 630)
    W_23830 = Ward("Xã An Trung", 23830, VietNamDivisionType.XA, "xa_an_trung", 630)
    W_23833 = Ward("Xã Kông Yang", 23833, VietNamDivisionType.XA, "xa_kong_yang", 630)
    W_23836 = Ward("Xã Đăk Tơ Pang", 23836, VietNamDivisionType.XA, "xa_dak_to_pang", 630)
    W_23839 = Ward("Xã SRó", 23839, VietNamDivisionType.XA, "xa_sro", 630)
    W_23840 = Ward("Xã Đắk Kơ Ning", 23840, VietNamDivisionType.XA, "xa_dak_ko_ning", 630)
    W_23842 = Ward("Xã Đăk Song", 23842, VietNamDivisionType.XA, "xa_dak_song", 630)
    W_23843 = Ward("Xã Đăk Pling", 23843, VietNamDivisionType.XA, "xa_dak_pling", 630)
    W_23845 = Ward("Xã Yang Trung", 23845, VietNamDivisionType.XA, "xa_yang_trung", 630)
    W_23846 = Ward("Xã Đăk Pơ Pho", 23846, VietNamDivisionType.XA, "xa_dak_po_pho", 630)
    W_23848 = Ward("Xã Ya Ma", 23848, VietNamDivisionType.XA, "xa_ya_ma", 630)
    W_23851 = Ward("Xã Chơ Long", 23851, VietNamDivisionType.XA, "xa_cho_long", 630)
    W_23854 = Ward("Xã Yang Nam", 23854, VietNamDivisionType.XA, "xa_yang_nam", 630)
    W_23857 = Ward("Thị trấn Chư Ty", 23857, VietNamDivisionType.THI_TRAN, "thi_tran_chu_ty", 631)
    W_23860 = Ward("Xã Ia Dơk", 23860, VietNamDivisionType.XA, "xa_ia_dok", 631)
    W_23863 = Ward("Xã Ia Krêl", 23863, VietNamDivisionType.XA, "xa_ia_krel", 631)
    W_23866 = Ward("Xã Ia Din", 23866, VietNamDivisionType.XA, "xa_ia_din", 631)
    W_23869 = Ward("Xã Ia Kla", 23869, VietNamDivisionType.XA, "xa_ia_kla", 631)
    W_23872 = Ward("Xã Ia Dom", 23872, VietNamDivisionType.XA, "xa_ia_dom", 631)
    W_23875 = Ward("Xã Ia Lang", 23875, VietNamDivisionType.XA, "xa_ia_lang", 631)
    W_23878 = Ward("Xã Ia Kriêng", 23878, VietNamDivisionType.XA, "xa_ia_krieng", 631)
    W_23881 = Ward("Xã Ia Pnôn", 23881, VietNamDivisionType.XA, "xa_ia_pnon", 631)
    W_23884 = Ward("Xã Ia Nan", 23884, VietNamDivisionType.XA, "xa_ia_nan", 631)
    W_23887 = Ward("Thị trấn Chư Prông", 23887, VietNamDivisionType.THI_TRAN, "thi_tran_chu_prong", 632)
    W_23888 = Ward("Xã Ia Kly", 23888, VietNamDivisionType.XA, "xa_ia_kly", 632)
    W_23890 = Ward("Xã Bình Giáo", 23890, VietNamDivisionType.XA, "xa_binh_giao", 632)
    W_23893 = Ward("Xã Ia Drăng", 23893, VietNamDivisionType.XA, "xa_ia_drang", 632)
    W_23896 = Ward("Xã Thăng Hưng", 23896, VietNamDivisionType.XA, "xa_thang_hung", 632)
    W_23899 = Ward("Xã Bàu Cạn", 23899, VietNamDivisionType.XA, "xa_bau_can", 632)
    W_23902 = Ward("Xã Ia Phìn", 23902, VietNamDivisionType.XA, "xa_ia_phin", 632)
    W_23905 = Ward("Xã Ia Băng", 23905, VietNamDivisionType.XA, "xa_ia_bang", 632)
    W_23908 = Ward("Xã Ia Tôr", 23908, VietNamDivisionType.XA, "xa_ia_tor", 632)
    W_23911 = Ward("Xã Ia Boòng", 23911, VietNamDivisionType.XA, "xa_ia_boong", 632)
    W_23914 = Ward("Xã Ia O", 23914, VietNamDivisionType.XA, "xa_ia_o", 632)
    W_23917 = Ward("Xã Ia Púch", 23917, VietNamDivisionType.XA, "xa_ia_puch", 632)
    W_23920 = Ward("Xã Ia Me", 23920, VietNamDivisionType.XA, "xa_ia_me", 632)
    W_23923 = Ward("Xã Ia Vê", 23923, VietNamDivisionType.XA, "xa_ia_ve", 632)
    W_23924 = Ward("Xã Ia Bang", 23924, VietNamDivisionType.XA, "xa_ia_bang", 632)
    W_23926 = Ward("Xã Ia Pia", 23926, VietNamDivisionType.XA, "xa_ia_pia", 632)
    W_23929 = Ward("Xã Ia Ga", 23929, VietNamDivisionType.XA, "xa_ia_ga", 632)
    W_23932 = Ward("Xã Ia Lâu", 23932, VietNamDivisionType.XA, "xa_ia_lau", 632)
    W_23935 = Ward("Xã Ia Piơr", 23935, VietNamDivisionType.XA, "xa_ia_pior", 632)
    W_23938 = Ward("Xã Ia Mơ", 23938, VietNamDivisionType.XA, "xa_ia_mo", 632)
    W_23941 = Ward("Thị trấn Chư Sê", 23941, VietNamDivisionType.THI_TRAN, "thi_tran_chu_se", 633)
    W_23944 = Ward("Xã Ia Tiêm", 23944, VietNamDivisionType.XA, "xa_ia_tiem", 633)
    W_23945 = Ward("Xã Chư Pơng", 23945, VietNamDivisionType.XA, "xa_chu_pong", 633)
    W_23946 = Ward("Xã Bar Măih", 23946, VietNamDivisionType.XA, "xa_bar_maih", 633)
    W_23947 = Ward("Xã Bờ Ngoong", 23947, VietNamDivisionType.XA, "xa_bo_ngoong", 633)
    W_23950 = Ward("Xã Ia Glai", 23950, VietNamDivisionType.XA, "xa_ia_glai", 633)
    W_23953 = Ward("Xã AL Bá", 23953, VietNamDivisionType.XA, "xa_al_ba", 633)
    W_23954 = Ward("Xã Kông HTok", 23954, VietNamDivisionType.XA, "xa_kong_htok", 633)
    W_23956 = Ward("Xã AYun", 23956, VietNamDivisionType.XA, "xa_ayun", 633)
    W_23959 = Ward("Xã Ia HLốp", 23959, VietNamDivisionType.XA, "xa_ia_hlop", 633)
    W_23962 = Ward("Xã Ia Blang", 23962, VietNamDivisionType.XA, "xa_ia_blang", 633)
    W_23965 = Ward("Xã Dun", 23965, VietNamDivisionType.XA, "xa_dun", 633)
    W_23966 = Ward("Xã Ia Pal", 23966, VietNamDivisionType.XA, "xa_ia_pal", 633)
    W_23968 = Ward("Xã H Bông", 23968, VietNamDivisionType.XA, "xa_h_bong", 633)
    W_23977 = Ward("Xã Ia Ko", 23977, VietNamDivisionType.XA, "xa_ia_ko", 633)
    W_23989 = Ward("Xã Hà Tam", 23989, VietNamDivisionType.XA, "xa_ha_tam", 634)
    W_23992 = Ward("Xã An Thành", 23992, VietNamDivisionType.XA, "xa_an_thanh", 634)
    W_23995 = Ward("Thị trấn Đak Pơ", 23995, VietNamDivisionType.THI_TRAN, "thi_tran_dak_po", 634)
    W_23998 = Ward("Xã Yang Bắc", 23998, VietNamDivisionType.XA, "xa_yang_bac", 634)
    W_24001 = Ward("Xã Cư An", 24001, VietNamDivisionType.XA, "xa_cu_an", 634)
    W_24004 = Ward("Xã Tân An", 24004, VietNamDivisionType.XA, "xa_tan_an", 634)
    W_24007 = Ward("Xã Phú An", 24007, VietNamDivisionType.XA, "xa_phu_an", 634)
    W_24010 = Ward("Xã Ya Hội", 24010, VietNamDivisionType.XA, "xa_ya_hoi", 634)
    W_24013 = Ward("Xã Pờ Tó", 24013, VietNamDivisionType.XA, "xa_po_to", 635)
    W_24016 = Ward("Xã Chư Răng", 24016, VietNamDivisionType.XA, "xa_chu_rang", 635)
    W_24019 = Ward("Xã Ia KDăm", 24019, VietNamDivisionType.XA, "xa_ia_kdam", 635)
    W_24022 = Ward("Xã Kim Tân", 24022, VietNamDivisionType.XA, "xa_kim_tan", 635)
    W_24025 = Ward("Xã Chư Mố", 24025, VietNamDivisionType.XA, "xa_chu_mo", 635)
    W_24028 = Ward("Xã Ia Tul", 24028, VietNamDivisionType.XA, "xa_ia_tul", 635)
    W_24031 = Ward("Xã Ia Ma Rơn", 24031, VietNamDivisionType.XA, "xa_ia_ma_ron", 635)
    W_24034 = Ward("Xã Ia Broăi", 24034, VietNamDivisionType.XA, "xa_ia_broai", 635)
    W_24037 = Ward("Xã Ia Trok", 24037, VietNamDivisionType.XA, "xa_ia_trok", 635)
    W_24076 = Ward("Thị trấn Phú Túc", 24076, VietNamDivisionType.THI_TRAN, "thi_tran_phu_tuc", 637)
    W_24079 = Ward("Xã Ia RSai", 24079, VietNamDivisionType.XA, "xa_ia_rsai", 637)
    W_24082 = Ward("Xã Ia RSươm", 24082, VietNamDivisionType.XA, "xa_ia_rsuom", 637)
    W_24085 = Ward("Xã Chư Gu", 24085, VietNamDivisionType.XA, "xa_chu_gu", 637)
    W_24088 = Ward("Xã Đất Bằng", 24088, VietNamDivisionType.XA, "xa_dat_bang", 637)
    W_24091 = Ward("Xã Ia Mláh", 24091, VietNamDivisionType.XA, "xa_ia_mlah", 637)
    W_24094 = Ward("Xã Chư Drăng", 24094, VietNamDivisionType.XA, "xa_chu_drang", 637)
    W_24097 = Ward("Xã Phú Cần", 24097, VietNamDivisionType.XA, "xa_phu_can", 637)
    W_24100 = Ward("Xã Ia HDreh", 24100, VietNamDivisionType.XA, "xa_ia_hdreh", 637)
    W_24103 = Ward("Xã Ia RMok", 24103, VietNamDivisionType.XA, "xa_ia_rmok", 637)
    W_24106 = Ward("Xã Chư Ngọc", 24106, VietNamDivisionType.XA, "xa_chu_ngoc", 637)
    W_24109 = Ward("Xã Uar", 24109, VietNamDivisionType.XA, "xa_uar", 637)
    W_24112 = Ward("Xã Chư Rcăm", 24112, VietNamDivisionType.XA, "xa_chu_rcam", 637)
    W_24115 = Ward("Xã Krông Năng", 24115, VietNamDivisionType.XA, "xa_krong_nang", 637)
    W_24043 = Ward("Thị trấn Phú Thiện", 24043, VietNamDivisionType.THI_TRAN, "thi_tran_phu_thien", 638)
    W_24046 = Ward("Xã Chư A Thai", 24046, VietNamDivisionType.XA, "xa_chu_a_thai", 638)
    W_24048 = Ward("Xã Ayun Hạ", 24048, VietNamDivisionType.XA, "xa_ayun_ha", 638)
    W_24049 = Ward("Xã Ia Ake", 24049, VietNamDivisionType.XA, "xa_ia_ake", 638)
    W_24052 = Ward("Xã Ia Sol", 24052, VietNamDivisionType.XA, "xa_ia_sol", 638)
    W_24055 = Ward("Xã Ia Piar", 24055, VietNamDivisionType.XA, "xa_ia_piar", 638)
    W_24058 = Ward("Xã Ia Peng", 24058, VietNamDivisionType.XA, "xa_ia_peng", 638)
    W_24060 = Ward("Xã Chrôh Pơnan", 24060, VietNamDivisionType.XA, "xa_chroh_ponan", 638)
    W_24061 = Ward("Xã Ia Hiao", 24061, VietNamDivisionType.XA, "xa_ia_hiao", 638)
    W_24067 = Ward("Xã Ia Yeng", 24067, VietNamDivisionType.XA, "xa_ia_yeng", 638)
    W_23942 = Ward("Thị trấn Nhơn Hoà", 23942, VietNamDivisionType.THI_TRAN, "thi_tran_nhon_hoa", 639)
    W_23971 = Ward("Xã Ia Hrú", 23971, VietNamDivisionType.XA, "xa_ia_hru", 639)
    W_23972 = Ward("Xã Ia Rong", 23972, VietNamDivisionType.XA, "xa_ia_rong", 639)
    W_23974 = Ward("Xã Ia Dreng", 23974, VietNamDivisionType.XA, "xa_ia_dreng", 639)
    W_23978 = Ward("Xã Ia Hla", 23978, VietNamDivisionType.XA, "xa_ia_hla", 639)
    W_23980 = Ward("Xã Chư Don", 23980, VietNamDivisionType.XA, "xa_chu_don", 639)
    W_23983 = Ward("Xã Ia Phang", 23983, VietNamDivisionType.XA, "xa_ia_phang", 639)
    W_23986 = Ward("Xã Ia Le", 23986, VietNamDivisionType.XA, "xa_ia_le", 639)
    W_23987 = Ward("Xã Ia BLứ", 23987, VietNamDivisionType.XA, "xa_ia_blu", 639)
    W_24118 = Ward("Phường Tân Lập", 24118, VietNamDivisionType.PHUONG, "phuong_tan_lap", 643)
    W_24121 = Ward("Phường Tân Hòa", 24121, VietNamDivisionType.PHUONG, "phuong_tan_hoa", 643)
    W_24124 = Ward("Phường Tân An", 24124, VietNamDivisionType.PHUONG, "phuong_tan_an", 643)
    W_24127 = Ward("Phường Thống Nhất", 24127, VietNamDivisionType.PHUONG, "phuong_thong_nhat", 643)
    W_24130 = Ward("Phường Thành Nhất", 24130, VietNamDivisionType.PHUONG, "phuong_thanh_nhat", 643)
    W_24133 = Ward("Phường Thắng Lợi", 24133, VietNamDivisionType.PHUONG, "phuong_thang_loi", 643)
    W_24136 = Ward("Phường Tân Lợi", 24136, VietNamDivisionType.PHUONG, "phuong_tan_loi", 643)
    W_24139 = Ward("Phường Thành Công", 24139, VietNamDivisionType.PHUONG, "phuong_thanh_cong", 643)
    W_24142 = Ward("Phường Tân Thành", 24142, VietNamDivisionType.PHUONG, "phuong_tan_thanh", 643)
    W_24145 = Ward("Phường Tân Tiến", 24145, VietNamDivisionType.PHUONG, "phuong_tan_tien", 643)
    W_24148 = Ward("Phường Tự An", 24148, VietNamDivisionType.PHUONG, "phuong_tu_an", 643)
    W_24151 = Ward("Phường Ea Tam", 24151, VietNamDivisionType.PHUONG, "phuong_ea_tam", 643)
    W_24154 = Ward("Phường Khánh Xuân", 24154, VietNamDivisionType.PHUONG, "phuong_khanh_xuan", 643)
    W_24157 = Ward("Xã Hòa Thuận", 24157, VietNamDivisionType.XA, "xa_hoa_thuan", 643)
    W_24160 = Ward("Xã Cư ÊBur", 24160, VietNamDivisionType.XA, "xa_cu_ebur", 643)
    W_24163 = Ward("Xã Ea Tu", 24163, VietNamDivisionType.XA, "xa_ea_tu", 643)
    W_24166 = Ward("Xã Hòa Thắng", 24166, VietNamDivisionType.XA, "xa_hoa_thang", 643)
    W_24169 = Ward("Xã Ea Kao", 24169, VietNamDivisionType.XA, "xa_ea_kao", 643)
    W_24172 = Ward("Xã Hòa Phú", 24172, VietNamDivisionType.XA, "xa_hoa_phu", 643)
    W_24175 = Ward("Xã Hòa Khánh", 24175, VietNamDivisionType.XA, "xa_hoa_khanh", 643)
    W_24178 = Ward("Xã Hòa Xuân", 24178, VietNamDivisionType.XA, "xa_hoa_xuan", 643)
    W_24305 = Ward("Phường An Lạc", 24305, VietNamDivisionType.PHUONG, "phuong_an_lac", 644)
    W_24308 = Ward("Phường An Bình", 24308, VietNamDivisionType.PHUONG, "phuong_an_binh", 644)
    W_24311 = Ward("Phường Thiện An", 24311, VietNamDivisionType.PHUONG, "phuong_thien_an", 644)
    W_24318 = Ward("Phường Đạt Hiếu", 24318, VietNamDivisionType.PHUONG, "phuong_dat_hieu", 644)
    W_24322 = Ward("Phường Đoàn Kết", 24322, VietNamDivisionType.PHUONG, "phuong_doan_ket", 644)
    W_24325 = Ward("Xã Ea Blang", 24325, VietNamDivisionType.XA, "xa_ea_blang", 644)
    W_24328 = Ward("Xã Ea Drông", 24328, VietNamDivisionType.XA, "xa_ea_drong", 644)
    W_24331 = Ward("Phường Thống Nhất", 24331, VietNamDivisionType.PHUONG, "phuong_thong_nhat", 644)
    W_24332 = Ward("Phường Bình Tân", 24332, VietNamDivisionType.PHUONG, "phuong_binh_tan", 644)
    W_24334 = Ward("Xã Ea Siên", 24334, VietNamDivisionType.XA, "xa_ea_sien", 644)
    W_24337 = Ward("Xã Bình Thuận", 24337, VietNamDivisionType.XA, "xa_binh_thuan", 644)
    W_24340 = Ward("Xã Cư Bao", 24340, VietNamDivisionType.XA, "xa_cu_bao", 644)
    W_24181 = Ward("Thị trấn Ea Drăng", 24181, VietNamDivisionType.THI_TRAN, "thi_tran_ea_drang", 645)
    W_24184 = Ward("Xã Ea H'leo", 24184, VietNamDivisionType.XA, "xa_ea_hleo", 645)
    W_24187 = Ward("Xã Ea Sol", 24187, VietNamDivisionType.XA, "xa_ea_sol", 645)
    W_24190 = Ward("Xã Ea Ral", 24190, VietNamDivisionType.XA, "xa_ea_ral", 645)
    W_24193 = Ward("Xã Ea Wy", 24193, VietNamDivisionType.XA, "xa_ea_wy", 645)
    W_24194 = Ward("Xã Cư A Mung", 24194, VietNamDivisionType.XA, "xa_cu_a_mung", 645)
    W_24196 = Ward("Xã Cư Mốt", 24196, VietNamDivisionType.XA, "xa_cu_mot", 645)
    W_24199 = Ward("Xã Ea Hiao", 24199, VietNamDivisionType.XA, "xa_ea_hiao", 645)
    W_24202 = Ward("Xã Ea Khal", 24202, VietNamDivisionType.XA, "xa_ea_khal", 645)
    W_24205 = Ward("Xã Dliê Yang", 24205, VietNamDivisionType.XA, "xa_dlie_yang", 645)
    W_24207 = Ward("Xã Ea Tir", 24207, VietNamDivisionType.XA, "xa_ea_tir", 645)
    W_24208 = Ward("Xã Ea Nam", 24208, VietNamDivisionType.XA, "xa_ea_nam", 645)
    W_24211 = Ward("Thị trấn Ea Súp", 24211, VietNamDivisionType.THI_TRAN, "thi_tran_ea_sup", 646)
    W_24214 = Ward("Xã Ia Lốp", 24214, VietNamDivisionType.XA, "xa_ia_lop", 646)
    W_24215 = Ward("Xã Ia JLơi", 24215, VietNamDivisionType.XA, "xa_ia_jloi", 646)
    W_24217 = Ward("Xã Ea Rốk", 24217, VietNamDivisionType.XA, "xa_ea_rok", 646)
    W_24220 = Ward("Xã Ya Tờ Mốt", 24220, VietNamDivisionType.XA, "xa_ya_to_mot", 646)
    W_24221 = Ward("Xã Ia RVê", 24221, VietNamDivisionType.XA, "xa_ia_rve", 646)
    W_24223 = Ward("Xã Ea Lê", 24223, VietNamDivisionType.XA, "xa_ea_le", 646)
    W_24226 = Ward("Xã Cư KBang", 24226, VietNamDivisionType.XA, "xa_cu_kbang", 646)
    W_24229 = Ward("Xã Ea Bung", 24229, VietNamDivisionType.XA, "xa_ea_bung", 646)
    W_24232 = Ward("Xã Cư M'Lan", 24232, VietNamDivisionType.XA, "xa_cu_mlan", 646)
    W_24235 = Ward("Xã Krông Na", 24235, VietNamDivisionType.XA, "xa_krong_na", 647)
    W_24238 = Ward("Xã Ea Huar", 24238, VietNamDivisionType.XA, "xa_ea_huar", 647)
    W_24241 = Ward("Xã Ea Wer", 24241, VietNamDivisionType.XA, "xa_ea_wer", 647)
    W_24244 = Ward("Xã Tân Hoà", 24244, VietNamDivisionType.XA, "xa_tan_hoa", 647)
    W_24247 = Ward("Xã Cuôr KNia", 24247, VietNamDivisionType.XA, "xa_cuor_knia", 647)
    W_24250 = Ward("Xã Ea Bar", 24250, VietNamDivisionType.XA, "xa_ea_bar", 647)
    W_24253 = Ward("Xã Ea Nuôl", 24253, VietNamDivisionType.XA, "xa_ea_nuol", 647)
    W_24256 = Ward("Thị trấn Ea Pốk", 24256, VietNamDivisionType.THI_TRAN, "thi_tran_ea_pok", 648)
    W_24259 = Ward("Thị trấn Quảng Phú", 24259, VietNamDivisionType.THI_TRAN, "thi_tran_quang_phu", 648)
    W_24262 = Ward("Xã Quảng Tiến", 24262, VietNamDivisionType.XA, "xa_quang_tien", 648)
    W_24264 = Ward("Xã Ea Kuêh", 24264, VietNamDivisionType.XA, "xa_ea_kueh", 648)
    W_24265 = Ward("Xã Ea Kiết", 24265, VietNamDivisionType.XA, "xa_ea_kiet", 648)
    W_24268 = Ward("Xã Ea Tar", 24268, VietNamDivisionType.XA, "xa_ea_tar", 648)
    W_24271 = Ward("Xã Cư Dliê M'nông", 24271, VietNamDivisionType.XA, "xa_cu_dlie_mnong", 648)
    W_24274 = Ward("Xã Ea H'đinh", 24274, VietNamDivisionType.XA, "xa_ea_hdinh", 648)
    W_24277 = Ward("Xã Ea Tul", 24277, VietNamDivisionType.XA, "xa_ea_tul", 648)
    W_24280 = Ward("Xã Ea KPam", 24280, VietNamDivisionType.XA, "xa_ea_kpam", 648)
    W_24283 = Ward("Xã Ea M'DRóh", 24283, VietNamDivisionType.XA, "xa_ea_mdroh", 648)
    W_24286 = Ward("Xã Quảng Hiệp", 24286, VietNamDivisionType.XA, "xa_quang_hiep", 648)
    W_24289 = Ward("Xã Cư M'gar", 24289, VietNamDivisionType.XA, "xa_cu_mgar", 648)
    W_24292 = Ward("Xã Ea D'Rơng", 24292, VietNamDivisionType.XA, "xa_ea_drong", 648)
    W_24295 = Ward("Xã Ea M'nang", 24295, VietNamDivisionType.XA, "xa_ea_mnang", 648)
    W_24298 = Ward("Xã Cư Suê", 24298, VietNamDivisionType.XA, "xa_cu_sue", 648)
    W_24301 = Ward("Xã Cuor Đăng", 24301, VietNamDivisionType.XA, "xa_cuor_dang", 648)
    W_24307 = Ward("Xã Cư Né", 24307, VietNamDivisionType.XA, "xa_cu_ne", 649)
    W_24310 = Ward("Xã Chư KBô", 24310, VietNamDivisionType.XA, "xa_chu_kbo", 649)
    W_24313 = Ward("Xã Cư Pơng", 24313, VietNamDivisionType.XA, "xa_cu_pong", 649)
    W_24314 = Ward("Xã Ea Sin", 24314, VietNamDivisionType.XA, "xa_ea_sin", 649)
    W_24316 = Ward("Xã Pơng Drang", 24316, VietNamDivisionType.XA, "xa_pong_drang", 649)
    W_24317 = Ward("Xã Tân Lập", 24317, VietNamDivisionType.XA, "xa_tan_lap", 649)
    W_24319 = Ward("Xã Ea Ngai", 24319, VietNamDivisionType.XA, "xa_ea_ngai", 649)
    W_24343 = Ward("Thị trấn Krông Năng", 24343, VietNamDivisionType.THI_TRAN, "thi_tran_krong_nang", 650)
    W_24346 = Ward("Xã ĐLiê Ya", 24346, VietNamDivisionType.XA, "xa_dlie_ya", 650)
    W_24349 = Ward("Xã Ea Tóh", 24349, VietNamDivisionType.XA, "xa_ea_toh", 650)
    W_24352 = Ward("Xã Ea Tam", 24352, VietNamDivisionType.XA, "xa_ea_tam", 650)
    W_24355 = Ward("Xã Phú Lộc", 24355, VietNamDivisionType.XA, "xa_phu_loc", 650)
    W_24358 = Ward("Xã Tam Giang", 24358, VietNamDivisionType.XA, "xa_tam_giang", 650)
    W_24359 = Ward("Xã Ea Puk", 24359, VietNamDivisionType.XA, "xa_ea_puk", 650)
    W_24360 = Ward("Xã Ea Dăh", 24360, VietNamDivisionType.XA, "xa_ea_dah", 650)
    W_24361 = Ward("Xã Ea Hồ", 24361, VietNamDivisionType.XA, "xa_ea_ho", 650)
    W_24364 = Ward("Xã Phú Xuân", 24364, VietNamDivisionType.XA, "xa_phu_xuan", 650)
    W_24367 = Ward("Xã Cư Klông", 24367, VietNamDivisionType.XA, "xa_cu_klong", 650)
    W_24370 = Ward("Xã Ea Tân", 24370, VietNamDivisionType.XA, "xa_ea_tan", 650)
    W_24373 = Ward("Thị trấn Ea Kar", 24373, VietNamDivisionType.THI_TRAN, "thi_tran_ea_kar", 651)
    W_24376 = Ward("Thị trấn Ea Knốp", 24376, VietNamDivisionType.THI_TRAN, "thi_tran_ea_knop", 651)
    W_24379 = Ward("Xã Ea Sô", 24379, VietNamDivisionType.XA, "xa_ea_so", 651)
    W_24380 = Ward("Xã Ea Sar", 24380, VietNamDivisionType.XA, "xa_ea_sar", 651)
    W_24382 = Ward("Xã Xuân Phú", 24382, VietNamDivisionType.XA, "xa_xuan_phu", 651)
    W_24385 = Ward("Xã Cư Huê", 24385, VietNamDivisionType.XA, "xa_cu_hue", 651)
    W_24388 = Ward("Xã Ea Tih", 24388, VietNamDivisionType.XA, "xa_ea_tih", 651)
    W_24391 = Ward("Xã Ea Đar", 24391, VietNamDivisionType.XA, "xa_ea_dar", 651)
    W_24394 = Ward("Xã Ea Kmút", 24394, VietNamDivisionType.XA, "xa_ea_kmut", 651)
    W_24397 = Ward("Xã Cư Ni", 24397, VietNamDivisionType.XA, "xa_cu_ni", 651)
    W_24400 = Ward("Xã Ea Păl", 24400, VietNamDivisionType.XA, "xa_ea_pal", 651)
    W_24401 = Ward("Xã Cư Prông", 24401, VietNamDivisionType.XA, "xa_cu_prong", 651)
    W_24403 = Ward("Xã Ea Ô", 24403, VietNamDivisionType.XA, "xa_ea_o", 651)
    W_24404 = Ward("Xã Cư ELang", 24404, VietNamDivisionType.XA, "xa_cu_elang", 651)
    W_24406 = Ward("Xã Cư Bông", 24406, VietNamDivisionType.XA, "xa_cu_bong", 651)
    W_24409 = Ward("Xã Cư Jang", 24409, VietNamDivisionType.XA, "xa_cu_jang", 651)
    W_24412 = Ward("Thị trấn M'Đrắk", 24412, VietNamDivisionType.THI_TRAN, "thi_tran_mdrak", 652)
    W_24415 = Ward("Xã Cư Prao", 24415, VietNamDivisionType.XA, "xa_cu_prao", 652)
    W_24418 = Ward("Xã Ea Pil", 24418, VietNamDivisionType.XA, "xa_ea_pil", 652)
    W_24421 = Ward("Xã Ea Lai", 24421, VietNamDivisionType.XA, "xa_ea_lai", 652)
    W_24424 = Ward("Xã Ea H'MLay", 24424, VietNamDivisionType.XA, "xa_ea_hmlay", 652)
    W_24427 = Ward("Xã Krông Jing", 24427, VietNamDivisionType.XA, "xa_krong_jing", 652)
    W_24430 = Ward("Xã Ea M' Doal", 24430, VietNamDivisionType.XA, "xa_ea_m_doal", 652)
    W_24433 = Ward("Xã Ea Riêng", 24433, VietNamDivisionType.XA, "xa_ea_rieng", 652)
    W_24436 = Ward("Xã Cư M'ta", 24436, VietNamDivisionType.XA, "xa_cu_mta", 652)
    W_24439 = Ward("Xã Cư K Róa", 24439, VietNamDivisionType.XA, "xa_cu_k_roa", 652)
    W_24442 = Ward("Xã Krông Á", 24442, VietNamDivisionType.XA, "xa_krong_a", 652)
    W_24444 = Ward("Xã Cư San", 24444, VietNamDivisionType.XA, "xa_cu_san", 652)
    W_24445 = Ward("Xã Ea Trang", 24445, VietNamDivisionType.XA, "xa_ea_trang", 652)
    W_24448 = Ward("Thị trấn Krông Kmar", 24448, VietNamDivisionType.THI_TRAN, "thi_tran_krong_kmar", 653)
    W_24451 = Ward("Xã Dang Kang", 24451, VietNamDivisionType.XA, "xa_dang_kang", 653)
    W_24454 = Ward("Xã Cư KTy", 24454, VietNamDivisionType.XA, "xa_cu_kty", 653)
    W_24457 = Ward("Xã Hòa Thành", 24457, VietNamDivisionType.XA, "xa_hoa_thanh", 653)
    W_24460 = Ward("Xã Hòa Tân", 24460, VietNamDivisionType.XA, "xa_hoa_tan", 653)
    W_24463 = Ward("Xã Hòa Phong", 24463, VietNamDivisionType.XA, "xa_hoa_phong", 653)
    W_24466 = Ward("Xã Hòa Lễ", 24466, VietNamDivisionType.XA, "xa_hoa_le", 653)
    W_24469 = Ward("Xã Yang Reh", 24469, VietNamDivisionType.XA, "xa_yang_reh", 653)
    W_24472 = Ward("Xã Ea Trul", 24472, VietNamDivisionType.XA, "xa_ea_trul", 653)
    W_24475 = Ward("Xã Khuê Ngọc Điền", 24475, VietNamDivisionType.XA, "xa_khue_ngoc_dien", 653)
    W_24478 = Ward("Xã Cư Pui", 24478, VietNamDivisionType.XA, "xa_cu_pui", 653)
    W_24481 = Ward("Xã Hòa Sơn", 24481, VietNamDivisionType.XA, "xa_hoa_son", 653)
    W_24484 = Ward("Xã Cư Drăm", 24484, VietNamDivisionType.XA, "xa_cu_dram", 653)
    W_24487 = Ward("Xã Yang Mao", 24487, VietNamDivisionType.XA, "xa_yang_mao", 653)
    W_24490 = Ward("Thị trấn Phước An", 24490, VietNamDivisionType.THI_TRAN, "thi_tran_phuoc_an", 654)
    W_24493 = Ward("Xã KRông Búk", 24493, VietNamDivisionType.XA, "xa_krong_buk", 654)
    W_24496 = Ward("Xã Ea Kly", 24496, VietNamDivisionType.XA, "xa_ea_kly", 654)
    W_24499 = Ward("Xã Ea Kênh", 24499, VietNamDivisionType.XA, "xa_ea_kenh", 654)
    W_24502 = Ward("Xã Ea Phê", 24502, VietNamDivisionType.XA, "xa_ea_phe", 654)
    W_24505 = Ward("Xã Ea KNuec", 24505, VietNamDivisionType.XA, "xa_ea_knuec", 654)
    W_24508 = Ward("Xã Ea Yông", 24508, VietNamDivisionType.XA, "xa_ea_yong", 654)
    W_24511 = Ward("Xã Hòa An", 24511, VietNamDivisionType.XA, "xa_hoa_an", 654)
    W_24514 = Ward("Xã Ea Kuăng", 24514, VietNamDivisionType.XA, "xa_ea_kuang", 654)
    W_24517 = Ward("Xã Hòa Đông", 24517, VietNamDivisionType.XA, "xa_hoa_dong", 654)
    W_24520 = Ward("Xã Ea Hiu", 24520, VietNamDivisionType.XA, "xa_ea_hiu", 654)
    W_24523 = Ward("Xã Hòa Tiến", 24523, VietNamDivisionType.XA, "xa_hoa_tien", 654)
    W_24526 = Ward("Xã Tân Tiến", 24526, VietNamDivisionType.XA, "xa_tan_tien", 654)
    W_24529 = Ward("Xã Vụ Bổn", 24529, VietNamDivisionType.XA, "xa_vu_bon", 654)
    W_24532 = Ward("Xã Ea Uy", 24532, VietNamDivisionType.XA, "xa_ea_uy", 654)
    W_24535 = Ward("Xã Ea Yiêng", 24535, VietNamDivisionType.XA, "xa_ea_yieng", 654)
    W_24538 = Ward("Thị trấn Buôn Trấp", 24538, VietNamDivisionType.THI_TRAN, "thi_tran_buon_trap", 655)
    W_24556 = Ward("Xã Dray Sáp", 24556, VietNamDivisionType.XA, "xa_dray_sap", 655)
    W_24559 = Ward("Xã Ea Na", 24559, VietNamDivisionType.XA, "xa_ea_na", 655)
    W_24565 = Ward("Xã Ea Bông", 24565, VietNamDivisionType.XA, "xa_ea_bong", 655)
    W_24568 = Ward("Xã Băng A Drênh", 24568, VietNamDivisionType.XA, "xa_bang_a_drenh", 655)
    W_24571 = Ward("Xã Dur KMăl", 24571, VietNamDivisionType.XA, "xa_dur_kmal", 655)
    W_24574 = Ward("Xã Bình Hòa", 24574, VietNamDivisionType.XA, "xa_binh_hoa", 655)
    W_24577 = Ward("Xã Quảng Điền", 24577, VietNamDivisionType.XA, "xa_quang_dien", 655)
    W_24580 = Ward("Thị trấn Liên Sơn", 24580, VietNamDivisionType.THI_TRAN, "thi_tran_lien_son", 656)
    W_24583 = Ward("Xã Yang Tao", 24583, VietNamDivisionType.XA, "xa_yang_tao", 656)
    W_24586 = Ward("Xã Bông Krang", 24586, VietNamDivisionType.XA, "xa_bong_krang", 656)
    W_24589 = Ward("Xã Đắk Liêng", 24589, VietNamDivisionType.XA, "xa_dak_lieng", 656)
    W_24592 = Ward("Xã Buôn Triết", 24592, VietNamDivisionType.XA, "xa_buon_triet", 656)
    W_24595 = Ward("Xã Buôn Tría", 24595, VietNamDivisionType.XA, "xa_buon_tria", 656)
    W_24598 = Ward("Xã Đắk Phơi", 24598, VietNamDivisionType.XA, "xa_dak_phoi", 656)
    W_24601 = Ward("Xã Đắk Nuê", 24601, VietNamDivisionType.XA, "xa_dak_nue", 656)
    W_24604 = Ward("Xã Krông Nô", 24604, VietNamDivisionType.XA, "xa_krong_no", 656)
    W_24607 = Ward("Xã Nam Ka", 24607, VietNamDivisionType.XA, "xa_nam_ka", 656)
    W_24610 = Ward("Xã Ea R'Bin", 24610, VietNamDivisionType.XA, "xa_ea_rbin", 656)
    W_24540 = Ward("Xã Ea Ning", 24540, VietNamDivisionType.XA, "xa_ea_ning", 657)
    W_24541 = Ward("Xã Cư Ê Wi", 24541, VietNamDivisionType.XA, "xa_cu_e_wi", 657)
    W_24544 = Ward("Xã Ea Ktur", 24544, VietNamDivisionType.XA, "xa_ea_ktur", 657)
    W_24547 = Ward("Xã Ea Tiêu", 24547, VietNamDivisionType.XA, "xa_ea_tieu", 657)
    W_24550 = Ward("Xã Ea BHốk", 24550, VietNamDivisionType.XA, "xa_ea_bhok", 657)
    W_24553 = Ward("Xã Ea Hu", 24553, VietNamDivisionType.XA, "xa_ea_hu", 657)
    W_24561 = Ward("Xã Dray Bhăng", 24561, VietNamDivisionType.XA, "xa_dray_bhang", 657)
    W_24562 = Ward("Xã Hòa Hiệp", 24562, VietNamDivisionType.XA, "xa_hoa_hiep", 657)
    W_24611 = Ward("Phường Nghĩa Đức", 24611, VietNamDivisionType.PHUONG, "phuong_nghia_duc", 660)
    W_24612 = Ward("Phường Nghĩa Thành", 24612, VietNamDivisionType.PHUONG, "phuong_nghia_thanh", 660)
    W_24614 = Ward("Phường Nghĩa Phú", 24614, VietNamDivisionType.PHUONG, "phuong_nghia_phu", 660)
    W_24615 = Ward("Phường Nghĩa Tân", 24615, VietNamDivisionType.PHUONG, "phuong_nghia_tan", 660)
    W_24617 = Ward("Phường Nghĩa Trung", 24617, VietNamDivisionType.PHUONG, "phuong_nghia_trung", 660)
    W_24618 = Ward("Xã Đăk R'Moan", 24618, VietNamDivisionType.XA, "xa_dak_rmoan", 660)
    W_24619 = Ward("Phường Quảng Thành", 24619, VietNamDivisionType.PHUONG, "phuong_quang_thanh", 660)
    W_24628 = Ward("Xã Đắk Nia", 24628, VietNamDivisionType.XA, "xa_dak_nia", 660)
    W_24616 = Ward("Xã Quảng Sơn", 24616, VietNamDivisionType.XA, "xa_quang_son", 661)
    W_24620 = Ward("Xã Quảng Hoà", 24620, VietNamDivisionType.XA, "xa_quang_hoa", 661)
    W_24622 = Ward("Xã Đắk Ha", 24622, VietNamDivisionType.XA, "xa_dak_ha", 661)
    W_24625 = Ward("Xã Đắk R'Măng", 24625, VietNamDivisionType.XA, "xa_dak_rmang", 661)
    W_24631 = Ward("Xã Quảng Khê", 24631, VietNamDivisionType.XA, "xa_quang_khe", 661)
    W_24634 = Ward("Xã Đắk Plao", 24634, VietNamDivisionType.XA, "xa_dak_plao", 661)
    W_24637 = Ward("Xã Đắk Som", 24637, VietNamDivisionType.XA, "xa_dak_som", 661)
    W_24640 = Ward("Thị trấn Ea T'Ling", 24640, VietNamDivisionType.THI_TRAN, "thi_tran_ea_tling", 662)
    W_24643 = Ward("Xã Đắk Wil", 24643, VietNamDivisionType.XA, "xa_dak_wil", 662)
    W_24646 = Ward("Xã Ea Pô", 24646, VietNamDivisionType.XA, "xa_ea_po", 662)
    W_24649 = Ward("Xã Nam Dong", 24649, VietNamDivisionType.XA, "xa_nam_dong", 662)
    W_24652 = Ward("Xã Đắk DRông", 24652, VietNamDivisionType.XA, "xa_dak_drong", 662)
    W_24655 = Ward("Xã Tâm Thắng", 24655, VietNamDivisionType.XA, "xa_tam_thang", 662)
    W_24658 = Ward("Xã Cư Knia", 24658, VietNamDivisionType.XA, "xa_cu_knia", 662)
    W_24661 = Ward("Xã Trúc Sơn", 24661, VietNamDivisionType.XA, "xa_truc_son", 662)
    W_24664 = Ward("Thị trấn Đắk Mil", 24664, VietNamDivisionType.THI_TRAN, "thi_tran_dak_mil", 663)
    W_24667 = Ward("Xã Đắk Lao", 24667, VietNamDivisionType.XA, "xa_dak_lao", 663)
    W_24670 = Ward("Xã Đắk R'La", 24670, VietNamDivisionType.XA, "xa_dak_rla", 663)
    W_24673 = Ward("Xã Đắk Gằn", 24673, VietNamDivisionType.XA, "xa_dak_gan", 663)
    W_24676 = Ward("Xã Đức Mạnh", 24676, VietNamDivisionType.XA, "xa_duc_manh", 663)
    W_24677 = Ward("Xã Đắk N'Drót", 24677, VietNamDivisionType.XA, "xa_dak_ndrot", 663)
    W_24678 = Ward("Xã Long Sơn", 24678, VietNamDivisionType.XA, "xa_long_son", 663)
    W_24679 = Ward("Xã Đắk Sắk", 24679, VietNamDivisionType.XA, "xa_dak_sak", 663)
    W_24682 = Ward("Xã Thuận An", 24682, VietNamDivisionType.XA, "xa_thuan_an", 663)
    W_24685 = Ward("Xã Đức Minh", 24685, VietNamDivisionType.XA, "xa_duc_minh", 663)
    W_24688 = Ward("Thị trấn Đắk Mâm", 24688, VietNamDivisionType.THI_TRAN, "thi_tran_dak_mam", 664)
    W_24691 = Ward("Xã Đắk Sôr", 24691, VietNamDivisionType.XA, "xa_dak_sor", 664)
    W_24692 = Ward("Xã Nam Xuân", 24692, VietNamDivisionType.XA, "xa_nam_xuan", 664)
    W_24694 = Ward("Xã Buôn Choah", 24694, VietNamDivisionType.XA, "xa_buon_choah", 664)
    W_24697 = Ward("Xã Nam Đà", 24697, VietNamDivisionType.XA, "xa_nam_da", 664)
    W_24699 = Ward("Xã Tân Thành", 24699, VietNamDivisionType.XA, "xa_tan_thanh", 664)
    W_24700 = Ward("Xã Đắk Drô", 24700, VietNamDivisionType.XA, "xa_dak_dro", 664)
    W_24703 = Ward("Xã Nâm Nung", 24703, VietNamDivisionType.XA, "xa_nam_nung", 664)
    W_24706 = Ward("Xã Đức Xuyên", 24706, VietNamDivisionType.XA, "xa_duc_xuyen", 664)
    W_24709 = Ward("Xã Đắk Nang", 24709, VietNamDivisionType.XA, "xa_dak_nang", 664)
    W_24712 = Ward("Xã Quảng Phú", 24712, VietNamDivisionType.XA, "xa_quang_phu", 664)
    W_24715 = Ward("Xã Nâm N'Đir", 24715, VietNamDivisionType.XA, "xa_nam_ndir", 664)
    W_24717 = Ward("Thị trấn Đức An", 24717, VietNamDivisionType.THI_TRAN, "thi_tran_duc_an", 665)
    W_24718 = Ward("Xã Đắk Môl", 24718, VietNamDivisionType.XA, "xa_dak_mol", 665)
    W_24719 = Ward("Xã Đắk Hòa", 24719, VietNamDivisionType.XA, "xa_dak_hoa", 665)
    W_24721 = Ward("Xã Nam Bình", 24721, VietNamDivisionType.XA, "xa_nam_binh", 665)
    W_24722 = Ward("Xã Thuận Hà", 24722, VietNamDivisionType.XA, "xa_thuan_ha", 665)
    W_24724 = Ward("Xã Thuận Hạnh", 24724, VietNamDivisionType.XA, "xa_thuan_hanh", 665)
    W_24727 = Ward("Xã Đắk N'Dung", 24727, VietNamDivisionType.XA, "xa_dak_ndung", 665)
    W_24728 = Ward("Xã Nâm N'Jang", 24728, VietNamDivisionType.XA, "xa_nam_njang", 665)
    W_24730 = Ward("Xã Trường Xuân", 24730, VietNamDivisionType.XA, "xa_truong_xuan", 665)
    W_24733 = Ward("Thị trấn Kiến Đức", 24733, VietNamDivisionType.THI_TRAN, "thi_tran_kien_duc", 666)
    W_24745 = Ward("Xã Quảng Tín", 24745, VietNamDivisionType.XA, "xa_quang_tin", 666)
    W_24750 = Ward("Xã Đắk Wer", 24750, VietNamDivisionType.XA, "xa_dak_wer", 666)
    W_24751 = Ward("Xã Nhân Cơ", 24751, VietNamDivisionType.XA, "xa_nhan_co", 666)
    W_24754 = Ward("Xã Kiến Thành", 24754, VietNamDivisionType.XA, "xa_kien_thanh", 666)
    W_24756 = Ward("Xã Nghĩa Thắng", 24756, VietNamDivisionType.XA, "xa_nghia_thang", 666)
    W_24757 = Ward("Xã Đạo Nghĩa", 24757, VietNamDivisionType.XA, "xa_dao_nghia", 666)
    W_24760 = Ward("Xã Đắk Sin", 24760, VietNamDivisionType.XA, "xa_dak_sin", 666)
    W_24761 = Ward("Xã Hưng Bình", 24761, VietNamDivisionType.XA, "xa_hung_binh", 666)
    W_24763 = Ward("Xã Đắk Ru", 24763, VietNamDivisionType.XA, "xa_dak_ru", 666)
    W_24766 = Ward("Xã Nhân Đạo", 24766, VietNamDivisionType.XA, "xa_nhan_dao", 666)
    W_24736 = Ward("Xã Quảng Trực", 24736, VietNamDivisionType.XA, "xa_quang_truc", 667)
    W_24739 = Ward("Xã Đắk Búk So", 24739, VietNamDivisionType.XA, "xa_dak_buk_so", 667)
    W_24740 = Ward("Xã Quảng Tâm", 24740, VietNamDivisionType.XA, "xa_quang_tam", 667)
    W_24742 = Ward("Xã Đắk R'Tíh", 24742, VietNamDivisionType.XA, "xa_dak_rtih", 667)
    W_24746 = Ward("Xã Đắk Ngo", 24746, VietNamDivisionType.XA, "xa_dak_ngo", 667)
    W_24748 = Ward("Xã Quảng Tân", 24748, VietNamDivisionType.XA, "xa_quang_tan", 667)
    W_24769 = Ward("Phường 7", 24769, VietNamDivisionType.PHUONG, "phuong_7", 672)
    W_24772 = Ward("Phường 8", 24772, VietNamDivisionType.PHUONG, "phuong_8", 672)
    W_24775 = Ward("Phường 12", 24775, VietNamDivisionType.PHUONG, "phuong_12", 672)
    W_24778 = Ward("Phường 9", 24778, VietNamDivisionType.PHUONG, "phuong_9", 672)
    W_24781 = Ward("Phường 2", 24781, VietNamDivisionType.PHUONG, "phuong_2", 672)
    W_24784 = Ward("Phường 1", 24784, VietNamDivisionType.PHUONG, "phuong_1", 672)
    W_24787 = Ward("Phường 6", 24787, VietNamDivisionType.PHUONG, "phuong_6", 672)
    W_24790 = Ward("Phường 5", 24790, VietNamDivisionType.PHUONG, "phuong_5", 672)
    W_24793 = Ward("Phường 4", 24793, VietNamDivisionType.PHUONG, "phuong_4", 672)
    W_24796 = Ward("Phường 10", 24796, VietNamDivisionType.PHUONG, "phuong_10", 672)
    W_24799 = Ward("Phường 11", 24799, VietNamDivisionType.PHUONG, "phuong_11", 672)
    W_24802 = Ward("Phường 3", 24802, VietNamDivisionType.PHUONG, "phuong_3", 672)
    W_24805 = Ward("Xã Xuân Thọ", 24805, VietNamDivisionType.XA, "xa_xuan_tho", 672)
    W_24808 = Ward("Xã Tà Nung", 24808, VietNamDivisionType.XA, "xa_ta_nung", 672)
    W_24810 = Ward("Xã Trạm Hành", 24810, VietNamDivisionType.XA, "xa_tram_hanh", 672)
    W_24811 = Ward("Xã Xuân Trường", 24811, VietNamDivisionType.XA, "xa_xuan_truong", 672)
    W_24814 = Ward("Phường Lộc Phát", 24814, VietNamDivisionType.PHUONG, "phuong_loc_phat", 673)
    W_24817 = Ward("Phường Lộc Tiến", 24817, VietNamDivisionType.PHUONG, "phuong_loc_tien", 673)
    W_24820 = Ward("Phường 2", 24820, VietNamDivisionType.PHUONG, "phuong_2", 673)
    W_24823 = Ward("Phường 1", 24823, VietNamDivisionType.PHUONG, "phuong_1", 673)
    W_24826 = Ward("Phường B'lao", 24826, VietNamDivisionType.PHUONG, "phuong_blao", 673)
    W_24829 = Ward("Phường Lộc Sơn", 24829, VietNamDivisionType.PHUONG, "phuong_loc_son", 673)
    W_24832 = Ward("Xã Đạm Bri", 24832, VietNamDivisionType.XA, "xa_dam_bri", 673)
    W_24835 = Ward("Xã Lộc Thanh", 24835, VietNamDivisionType.XA, "xa_loc_thanh", 673)
    W_24838 = Ward("Xã Lộc Nga", 24838, VietNamDivisionType.XA, "xa_loc_nga", 673)
    W_24841 = Ward("Xã Lộc Châu", 24841, VietNamDivisionType.XA, "xa_loc_chau", 673)
    W_24844 = Ward("Xã Đại Lào", 24844, VietNamDivisionType.XA, "xa_dai_lao", 673)
    W_24853 = Ward("Xã Đạ Tông", 24853, VietNamDivisionType.XA, "xa_da_tong", 674)
    W_24856 = Ward("Xã Đạ Long", 24856, VietNamDivisionType.XA, "xa_da_long", 674)
    W_24859 = Ward("Xã Đạ M' Rong", 24859, VietNamDivisionType.XA, "xa_da_m_rong", 674)
    W_24874 = Ward("Xã Liêng Srônh", 24874, VietNamDivisionType.XA, "xa_lieng_sronh", 674)
    W_24875 = Ward("Xã Đạ Rsal", 24875, VietNamDivisionType.XA, "xa_da_rsal", 674)
    W_24877 = Ward("Xã Rô Men", 24877, VietNamDivisionType.XA, "xa_ro_men", 674)
    W_24886 = Ward("Xã Phi Liêng", 24886, VietNamDivisionType.XA, "xa_phi_lieng", 674)
    W_24889 = Ward("Xã Đạ K' Nàng", 24889, VietNamDivisionType.XA, "xa_da_k_nang", 674)
    W_24846 = Ward("Thị trấn Lạc Dương", 24846, VietNamDivisionType.THI_TRAN, "thi_tran_lac_duong", 675)
    W_24847 = Ward("Xã Đạ Chais", 24847, VietNamDivisionType.XA, "xa_da_chais", 675)
    W_24848 = Ward("Xã Đạ Nhim", 24848, VietNamDivisionType.XA, "xa_da_nhim", 675)
    W_24850 = Ward("Xã Đưng KNớ", 24850, VietNamDivisionType.XA, "xa_dung_kno", 675)
    W_24862 = Ward("Xã Lát", 24862, VietNamDivisionType.XA, "xa_lat", 675)
    W_24865 = Ward("Xã Đạ Sar", 24865, VietNamDivisionType.XA, "xa_da_sar", 675)
    W_24868 = Ward("Thị trấn Nam Ban", 24868, VietNamDivisionType.THI_TRAN, "thi_tran_nam_ban", 676)
    W_24871 = Ward("Thị trấn Đinh Văn", 24871, VietNamDivisionType.THI_TRAN, "thi_tran_dinh_van", 676)
    W_24880 = Ward("Xã Phú Sơn", 24880, VietNamDivisionType.XA, "xa_phu_son", 676)
    W_24883 = Ward("Xã Phi Tô", 24883, VietNamDivisionType.XA, "xa_phi_to", 676)
    W_24892 = Ward("Xã Mê Linh", 24892, VietNamDivisionType.XA, "xa_me_linh", 676)
    W_24895 = Ward("Xã Đạ Đờn", 24895, VietNamDivisionType.XA, "xa_da_don", 676)
    W_24898 = Ward("Xã Phúc Thọ", 24898, VietNamDivisionType.XA, "xa_phuc_tho", 676)
    W_24901 = Ward("Xã Đông Thanh", 24901, VietNamDivisionType.XA, "xa_dong_thanh", 676)
    W_24904 = Ward("Xã Gia Lâm", 24904, VietNamDivisionType.XA, "xa_gia_lam", 676)
    W_24907 = Ward("Xã Tân Thanh", 24907, VietNamDivisionType.XA, "xa_tan_thanh", 676)
    W_24910 = Ward("Xã Tân Văn", 24910, VietNamDivisionType.XA, "xa_tan_van", 676)
    W_24913 = Ward("Xã Hoài Đức", 24913, VietNamDivisionType.XA, "xa_hoai_duc", 676)
    W_24916 = Ward("Xã Tân Hà", 24916, VietNamDivisionType.XA, "xa_tan_ha", 676)
    W_24919 = Ward("Xã Liên Hà", 24919, VietNamDivisionType.XA, "xa_lien_ha", 676)
    W_24922 = Ward("Xã Đan Phượng", 24922, VietNamDivisionType.XA, "xa_dan_phuong", 676)
    W_24925 = Ward("Xã Nam Hà", 24925, VietNamDivisionType.XA, "xa_nam_ha", 676)
    W_24928 = Ward("Thị trấn D'Ran", 24928, VietNamDivisionType.THI_TRAN, "thi_tran_dran", 677)
    W_24931 = Ward("Thị trấn Thạnh Mỹ", 24931, VietNamDivisionType.THI_TRAN, "thi_tran_thanh_my", 677)
    W_24934 = Ward("Xã Lạc Xuân", 24934, VietNamDivisionType.XA, "xa_lac_xuan", 677)
    W_24937 = Ward("Xã Đạ Ròn", 24937, VietNamDivisionType.XA, "xa_da_ron", 677)
    W_24940 = Ward("Xã Lạc Lâm", 24940, VietNamDivisionType.XA, "xa_lac_lam", 677)
    W_24943 = Ward("Xã Ka Đô", 24943, VietNamDivisionType.XA, "xa_ka_do", 677)
    W_24946 = Ward("Xã Quảng Lập", 24946, VietNamDivisionType.XA, "xa_quang_lap", 677)
    W_24949 = Ward("Xã Ka Đơn", 24949, VietNamDivisionType.XA, "xa_ka_don", 677)
    W_24952 = Ward("Xã Tu Tra", 24952, VietNamDivisionType.XA, "xa_tu_tra", 677)
    W_24955 = Ward("Xã Pró", 24955, VietNamDivisionType.XA, "xa_pro", 677)
    W_24958 = Ward("Thị trấn Liên Nghĩa", 24958, VietNamDivisionType.THI_TRAN, "thi_tran_lien_nghia", 678)
    W_24961 = Ward("Xã Hiệp An", 24961, VietNamDivisionType.XA, "xa_hiep_an", 678)
    W_24964 = Ward("Xã Liên Hiệp", 24964, VietNamDivisionType.XA, "xa_lien_hiep", 678)
    W_24967 = Ward("Xã Hiệp Thạnh", 24967, VietNamDivisionType.XA, "xa_hiep_thanh", 678)
    W_24970 = Ward("Xã Bình Thạnh", 24970, VietNamDivisionType.XA, "xa_binh_thanh", 678)
    W_24973 = Ward("Xã N'Thol Hạ", 24973, VietNamDivisionType.XA, "xa_nthol_ha", 678)
    W_24976 = Ward("Xã Tân Hội", 24976, VietNamDivisionType.XA, "xa_tan_hoi", 678)
    W_24979 = Ward("Xã Tân Thành", 24979, VietNamDivisionType.XA, "xa_tan_thanh", 678)
    W_24982 = Ward("Xã Phú Hội", 24982, VietNamDivisionType.XA, "xa_phu_hoi", 678)
    W_24985 = Ward("Xã Ninh Gia", 24985, VietNamDivisionType.XA, "xa_ninh_gia", 678)
    W_24988 = Ward("Xã Tà Năng", 24988, VietNamDivisionType.XA, "xa_ta_nang", 678)
    W_24989 = Ward("Xã Đa Quyn", 24989, VietNamDivisionType.XA, "xa_da_quyn", 678)
    W_24991 = Ward("Xã Tà Hine", 24991, VietNamDivisionType.XA, "xa_ta_hine", 678)
    W_24994 = Ward("Xã Đà Loan", 24994, VietNamDivisionType.XA, "xa_da_loan", 678)
    W_24997 = Ward("Xã Ninh Loan", 24997, VietNamDivisionType.XA, "xa_ninh_loan", 678)
    W_25000 = Ward("Thị trấn Di Linh", 25000, VietNamDivisionType.THI_TRAN, "thi_tran_di_linh", 679)
    W_25003 = Ward("Xã Đinh Trang Thượng", 25003, VietNamDivisionType.XA, "xa_dinh_trang_thuong", 679)
    W_25006 = Ward("Xã Tân Thượng", 25006, VietNamDivisionType.XA, "xa_tan_thuong", 679)
    W_25007 = Ward("Xã Tân Lâm", 25007, VietNamDivisionType.XA, "xa_tan_lam", 679)
    W_25009 = Ward("Xã Tân Châu", 25009, VietNamDivisionType.XA, "xa_tan_chau", 679)
    W_25012 = Ward("Xã Tân Nghĩa", 25012, VietNamDivisionType.XA, "xa_tan_nghia", 679)
    W_25015 = Ward("Xã Gia Hiệp", 25015, VietNamDivisionType.XA, "xa_gia_hiep", 679)
    W_25018 = Ward("Xã Đinh Lạc", 25018, VietNamDivisionType.XA, "xa_dinh_lac", 679)
    W_25021 = Ward("Xã Tam Bố", 25021, VietNamDivisionType.XA, "xa_tam_bo", 679)
    W_25024 = Ward("Xã Đinh Trang Hòa", 25024, VietNamDivisionType.XA, "xa_dinh_trang_hoa", 679)
    W_25027 = Ward("Xã Liên Đầm", 25027, VietNamDivisionType.XA, "xa_lien_dam", 679)
    W_25030 = Ward("Xã Gung Ré", 25030, VietNamDivisionType.XA, "xa_gung_re", 679)
    W_25033 = Ward("Xã Bảo Thuận", 25033, VietNamDivisionType.XA, "xa_bao_thuan", 679)
    W_25036 = Ward("Xã Hòa Ninh", 25036, VietNamDivisionType.XA, "xa_hoa_ninh", 679)
    W_25039 = Ward("Xã Hòa Trung", 25039, VietNamDivisionType.XA, "xa_hoa_trung", 679)
    W_25042 = Ward("Xã Hòa Nam", 25042, VietNamDivisionType.XA, "xa_hoa_nam", 679)
    W_25045 = Ward("Xã Hòa Bắc", 25045, VietNamDivisionType.XA, "xa_hoa_bac", 679)
    W_25048 = Ward("Xã Sơn Điền", 25048, VietNamDivisionType.XA, "xa_son_dien", 679)
    W_25051 = Ward("Xã Gia Bắc", 25051, VietNamDivisionType.XA, "xa_gia_bac", 679)
    W_25054 = Ward("Thị trấn Lộc Thắng", 25054, VietNamDivisionType.THI_TRAN, "thi_tran_loc_thang", 680)
    W_25057 = Ward("Xã Lộc Bảo", 25057, VietNamDivisionType.XA, "xa_loc_bao", 680)
    W_25060 = Ward("Xã Lộc Lâm", 25060, VietNamDivisionType.XA, "xa_loc_lam", 680)
    W_25063 = Ward("Xã Lộc Phú", 25063, VietNamDivisionType.XA, "xa_loc_phu", 680)
    W_25066 = Ward("Xã Lộc Bắc", 25066, VietNamDivisionType.XA, "xa_loc_bac", 680)
    W_25069 = Ward("Xã B' Lá", 25069, VietNamDivisionType.XA, "xa_b_la", 680)
    W_25072 = Ward("Xã Lộc Ngãi", 25072, VietNamDivisionType.XA, "xa_loc_ngai", 680)
    W_25075 = Ward("Xã Lộc Quảng", 25075, VietNamDivisionType.XA, "xa_loc_quang", 680)
    W_25078 = Ward("Xã Lộc Tân", 25078, VietNamDivisionType.XA, "xa_loc_tan", 680)
    W_25081 = Ward("Xã Lộc Đức", 25081, VietNamDivisionType.XA, "xa_loc_duc", 680)
    W_25084 = Ward("Xã Lộc An", 25084, VietNamDivisionType.XA, "xa_loc_an", 680)
    W_25087 = Ward("Xã Tân Lạc", 25087, VietNamDivisionType.XA, "xa_tan_lac", 680)
    W_25090 = Ward("Xã Lộc Thành", 25090, VietNamDivisionType.XA, "xa_loc_thanh", 680)
    W_25093 = Ward("Xã Lộc Nam", 25093, VietNamDivisionType.XA, "xa_loc_nam", 680)
    W_25096 = Ward("Thị trấn Đạ M'ri", 25096, VietNamDivisionType.THI_TRAN, "thi_tran_da_mri", 681)
    W_25099 = Ward("Thị trấn Ma Đa Guôi", 25099, VietNamDivisionType.THI_TRAN, "thi_tran_ma_da_guoi", 681)
    W_25105 = Ward("Xã Hà Lâm", 25105, VietNamDivisionType.XA, "xa_ha_lam", 681)
    W_25108 = Ward("Xã Đạ Tồn", 25108, VietNamDivisionType.XA, "xa_da_ton", 681)
    W_25111 = Ward("Xã Đạ Oai", 25111, VietNamDivisionType.XA, "xa_da_oai", 681)
    W_25114 = Ward("Xã Đạ Ploa", 25114, VietNamDivisionType.XA, "xa_da_ploa", 681)
    W_25117 = Ward("Xã Ma Đa Guôi", 25117, VietNamDivisionType.XA, "xa_ma_da_guoi", 681)
    W_25120 = Ward("Xã Đoàn Kết", 25120, VietNamDivisionType.XA, "xa_doan_ket", 681)
    W_25123 = Ward("Xã Phước Lộc", 25123, VietNamDivisionType.XA, "xa_phuoc_loc", 681)
    W_25126 = Ward("Thị trấn Đạ Tẻh", 25126, VietNamDivisionType.THI_TRAN, "thi_tran_da_teh", 682)
    W_25129 = Ward("Xã An Nhơn", 25129, VietNamDivisionType.XA, "xa_an_nhon", 682)
    W_25132 = Ward("Xã Quốc Oai", 25132, VietNamDivisionType.XA, "xa_quoc_oai", 682)
    W_25135 = Ward("Xã Mỹ Đức", 25135, VietNamDivisionType.XA, "xa_my_duc", 682)
    W_25138 = Ward("Xã Quảng Trị", 25138, VietNamDivisionType.XA, "xa_quang_tri", 682)
    W_25141 = Ward("Xã Đạ Lây", 25141, VietNamDivisionType.XA, "xa_da_lay", 682)
    W_25147 = Ward("Xã Triệu Hải", 25147, VietNamDivisionType.XA, "xa_trieu_hai", 682)
    W_25153 = Ward("Xã Đạ Kho", 25153, VietNamDivisionType.XA, "xa_da_kho", 682)
    W_25156 = Ward("Xã Đạ Pal", 25156, VietNamDivisionType.XA, "xa_da_pal", 682)
    W_25159 = Ward("Thị trấn Cát Tiên", 25159, VietNamDivisionType.THI_TRAN, "thi_tran_cat_tien", 683)
    W_25162 = Ward("Xã Tiên Hoàng", 25162, VietNamDivisionType.XA, "xa_tien_hoang", 683)
    W_25165 = Ward("Xã Phước Cát 2", 25165, VietNamDivisionType.XA, "xa_phuoc_cat_2", 683)
    W_25168 = Ward("Xã Gia Viễn", 25168, VietNamDivisionType.XA, "xa_gia_vien", 683)
    W_25171 = Ward("Xã Nam Ninh", 25171, VietNamDivisionType.XA, "xa_nam_ninh", 683)
    W_25180 = Ward("Thị trấn Phước Cát", 25180, VietNamDivisionType.THI_TRAN, "thi_tran_phuoc_cat", 683)
    W_25183 = Ward("Xã Đức Phổ", 25183, VietNamDivisionType.XA, "xa_duc_pho", 683)
    W_25189 = Ward("Xã Quảng Ngãi", 25189, VietNamDivisionType.XA, "xa_quang_ngai", 683)
    W_25192 = Ward("Xã Đồng Nai Thượng", 25192, VietNamDivisionType.XA, "xa_dong_nai_thuong", 683)
    W_25216 = Ward("Phường Thác Mơ", 25216, VietNamDivisionType.PHUONG, "phuong_thac_mo", 688)
    W_25217 = Ward("Phường Long Thủy", 25217, VietNamDivisionType.PHUONG, "phuong_long_thuy", 688)
    W_25219 = Ward("Phường Phước Bình", 25219, VietNamDivisionType.PHUONG, "phuong_phuoc_binh", 688)
    W_25220 = Ward("Phường Long Phước", 25220, VietNamDivisionType.PHUONG, "phuong_long_phuoc", 688)
    W_25237 = Ward("Phường Sơn Giang", 25237, VietNamDivisionType.PHUONG, "phuong_son_giang", 688)
    W_25245 = Ward("Xã Long Giang", 25245, VietNamDivisionType.XA, "xa_long_giang", 688)
    W_25249 = Ward("Xã Phước Tín", 25249, VietNamDivisionType.XA, "xa_phuoc_tin", 688)
    W_25195 = Ward("Phường Tân Phú", 25195, VietNamDivisionType.PHUONG, "phuong_tan_phu", 689)
    W_25198 = Ward("Phường Tân Đồng", 25198, VietNamDivisionType.PHUONG, "phuong_tan_dong", 689)
    W_25201 = Ward("Phường Tân Bình", 25201, VietNamDivisionType.PHUONG, "phuong_tan_binh", 689)
    W_25204 = Ward("Phường Tân Xuân", 25204, VietNamDivisionType.PHUONG, "phuong_tan_xuan", 689)
    W_25205 = Ward("Phường Tân Thiện", 25205, VietNamDivisionType.PHUONG, "phuong_tan_thien", 689)
    W_25207 = Ward("Xã Tân Thành", 25207, VietNamDivisionType.XA, "xa_tan_thanh", 689)
    W_25210 = Ward("Phường Tiến Thành", 25210, VietNamDivisionType.PHUONG, "phuong_tien_thanh", 689)
    W_25213 = Ward("Xã Tiến Hưng", 25213, VietNamDivisionType.XA, "xa_tien_hung", 689)
    W_25320 = Ward("Phường Hưng Chiến", 25320, VietNamDivisionType.PHUONG, "phuong_hung_chien", 690)
    W_25324 = Ward("Phường An Lộc", 25324, VietNamDivisionType.PHUONG, "phuong_an_loc", 690)
    W_25325 = Ward("Phường Phú Thịnh", 25325, VietNamDivisionType.PHUONG, "phuong_phu_thinh", 690)
    W_25326 = Ward("Phường Phú Đức", 25326, VietNamDivisionType.PHUONG, "phuong_phu_duc", 690)
    W_25333 = Ward("Xã Thanh Lương", 25333, VietNamDivisionType.XA, "xa_thanh_luong", 690)
    W_25336 = Ward("Xã Thanh Phú", 25336, VietNamDivisionType.XA, "xa_thanh_phu", 690)
    W_25222 = Ward("Xã Bù Gia Mập", 25222, VietNamDivisionType.XA, "xa_bu_gia_map", 691)
    W_25225 = Ward("Xã Đak Ơ", 25225, VietNamDivisionType.XA, "xa_dak_o", 691)
    W_25228 = Ward("Xã Đức Hạnh", 25228, VietNamDivisionType.XA, "xa_duc_hanh", 691)
    W_25229 = Ward("Xã Phú Văn", 25229, VietNamDivisionType.XA, "xa_phu_van", 691)
    W_25231 = Ward("Xã Đa Kia", 25231, VietNamDivisionType.XA, "xa_da_kia", 691)
    W_25232 = Ward("Xã Phước Minh", 25232, VietNamDivisionType.XA, "xa_phuoc_minh", 691)
    W_25234 = Ward("Xã Bình Thắng", 25234, VietNamDivisionType.XA, "xa_binh_thang", 691)
    W_25267 = Ward("Xã Phú Nghĩa", 25267, VietNamDivisionType.XA, "xa_phu_nghia", 691)
    W_25270 = Ward("Thị trấn Lộc Ninh", 25270, VietNamDivisionType.THI_TRAN, "thi_tran_loc_ninh", 692)
    W_25273 = Ward("Xã Lộc Hòa", 25273, VietNamDivisionType.XA, "xa_loc_hoa", 692)
    W_25276 = Ward("Xã Lộc An", 25276, VietNamDivisionType.XA, "xa_loc_an", 692)
    W_25279 = Ward("Xã Lộc Tấn", 25279, VietNamDivisionType.XA, "xa_loc_tan", 692)
    W_25280 = Ward("Xã Lộc Thạnh", 25280, VietNamDivisionType.XA, "xa_loc_thanh", 692)
    W_25282 = Ward("Xã Lộc Hiệp", 25282, VietNamDivisionType.XA, "xa_loc_hiep", 692)
    W_25285 = Ward("Xã Lộc Thiện", 25285, VietNamDivisionType.XA, "xa_loc_thien", 692)
    W_25288 = Ward("Xã Lộc Thuận", 25288, VietNamDivisionType.XA, "xa_loc_thuan", 692)
    W_25291 = Ward("Xã Lộc Quang", 25291, VietNamDivisionType.XA, "xa_loc_quang", 692)
    W_25292 = Ward("Xã Lộc Phú", 25292, VietNamDivisionType.XA, "xa_loc_phu", 692)
    W_25294 = Ward("Xã Lộc Thành", 25294, VietNamDivisionType.XA, "xa_loc_thanh", 692)
    W_25297 = Ward("Xã Lộc Thái", 25297, VietNamDivisionType.XA, "xa_loc_thai", 692)
    W_25300 = Ward("Xã Lộc Điền", 25300, VietNamDivisionType.XA, "xa_loc_dien", 692)
    W_25303 = Ward("Xã Lộc Hưng", 25303, VietNamDivisionType.XA, "xa_loc_hung", 692)
    W_25305 = Ward("Xã Lộc Thịnh", 25305, VietNamDivisionType.XA, "xa_loc_thinh", 692)
    W_25306 = Ward("Xã Lộc Khánh", 25306, VietNamDivisionType.XA, "xa_loc_khanh", 692)
    W_25308 = Ward("Thị trấn Thanh Bình", 25308, VietNamDivisionType.THI_TRAN, "thi_tran_thanh_binh", 693)
    W_25309 = Ward("Xã Hưng Phước", 25309, VietNamDivisionType.XA, "xa_hung_phuoc", 693)
    W_25310 = Ward("Xã Phước Thiện", 25310, VietNamDivisionType.XA, "xa_phuoc_thien", 693)
    W_25312 = Ward("Xã Thiện Hưng", 25312, VietNamDivisionType.XA, "xa_thien_hung", 693)
    W_25315 = Ward("Xã Thanh Hòa", 25315, VietNamDivisionType.XA, "xa_thanh_hoa", 693)
    W_25318 = Ward("Xã Tân Thành", 25318, VietNamDivisionType.XA, "xa_tan_thanh", 693)
    W_25321 = Ward("Xã Tân Tiến", 25321, VietNamDivisionType.XA, "xa_tan_tien", 693)
    W_25327 = Ward("Xã Thanh An", 25327, VietNamDivisionType.XA, "xa_thanh_an", 694)
    W_25330 = Ward("Xã An Khương", 25330, VietNamDivisionType.XA, "xa_an_khuong", 694)
    W_25339 = Ward("Xã An Phú", 25339, VietNamDivisionType.XA, "xa_an_phu", 694)
    W_25342 = Ward("Xã Tân Lợi", 25342, VietNamDivisionType.XA, "xa_tan_loi", 694)
    W_25345 = Ward("Xã Tân Hưng", 25345, VietNamDivisionType.XA, "xa_tan_hung", 694)
    W_25348 = Ward("Xã Minh Đức", 25348, VietNamDivisionType.XA, "xa_minh_duc", 694)
    W_25349 = Ward("Xã Minh Tâm", 25349, VietNamDivisionType.XA, "xa_minh_tam", 694)
    W_25351 = Ward("Xã Phước An", 25351, VietNamDivisionType.XA, "xa_phuoc_an", 694)
    W_25354 = Ward("Xã Thanh Bình", 25354, VietNamDivisionType.XA, "xa_thanh_binh", 694)
    W_25357 = Ward("Thị trấn Tân Khai", 25357, VietNamDivisionType.THI_TRAN, "thi_tran_tan_khai", 694)
    W_25360 = Ward("Xã Đồng Nơ", 25360, VietNamDivisionType.XA, "xa_dong_no", 694)
    W_25361 = Ward("Xã Tân Hiệp", 25361, VietNamDivisionType.XA, "xa_tan_hiep", 694)
    W_25438 = Ward("Xã Tân Quan", 25438, VietNamDivisionType.XA, "xa_tan_quan", 694)
    W_25363 = Ward("Thị trấn Tân Phú", 25363, VietNamDivisionType.THI_TRAN, "thi_tran_tan_phu", 695)
    W_25366 = Ward("Xã Thuận Lợi", 25366, VietNamDivisionType.XA, "xa_thuan_loi", 695)
    W_25369 = Ward("Xã Đồng Tâm", 25369, VietNamDivisionType.XA, "xa_dong_tam", 695)
    W_25372 = Ward("Xã Tân Phước", 25372, VietNamDivisionType.XA, "xa_tan_phuoc", 695)
    W_25375 = Ward("Xã Tân Hưng", 25375, VietNamDivisionType.XA, "xa_tan_hung", 695)
    W_25378 = Ward("Xã Tân Lợi", 25378, VietNamDivisionType.XA, "xa_tan_loi", 695)
    W_25381 = Ward("Xã Tân Lập", 25381, VietNamDivisionType.XA, "xa_tan_lap", 695)
    W_25384 = Ward("Xã Tân Hòa", 25384, VietNamDivisionType.XA, "xa_tan_hoa", 695)
    W_25387 = Ward("Xã Thuận Phú", 25387, VietNamDivisionType.XA, "xa_thuan_phu", 695)
    W_25390 = Ward("Xã Đồng Tiến", 25390, VietNamDivisionType.XA, "xa_dong_tien", 695)
    W_25393 = Ward("Xã Tân Tiến", 25393, VietNamDivisionType.XA, "xa_tan_tien", 695)
    W_25396 = Ward("Thị trấn Đức Phong", 25396, VietNamDivisionType.THI_TRAN, "thi_tran_duc_phong", 696)
    W_25398 = Ward("Xã Đường 10", 25398, VietNamDivisionType.XA, "xa_duong_10", 696)
    W_25399 = Ward("Xã Đak Nhau", 25399, VietNamDivisionType.XA, "xa_dak_nhau", 696)
    W_25400 = Ward("Xã Phú Sơn", 25400, VietNamDivisionType.XA, "xa_phu_son", 696)
    W_25402 = Ward("Xã Thọ Sơn", 25402, VietNamDivisionType.XA, "xa_tho_son", 696)
    W_25404 = Ward("Xã Bình Minh", 25404, VietNamDivisionType.XA, "xa_binh_minh", 696)
    W_25405 = Ward("Xã Bom Bo", 25405, VietNamDivisionType.XA, "xa_bom_bo", 696)
    W_25408 = Ward("Xã Minh Hưng", 25408, VietNamDivisionType.XA, "xa_minh_hung", 696)
    W_25411 = Ward("Xã Đoàn Kết", 25411, VietNamDivisionType.XA, "xa_doan_ket", 696)
    W_25414 = Ward("Xã Đồng Nai", 25414, VietNamDivisionType.XA, "xa_dong_nai", 696)
    W_25417 = Ward("Xã Đức Liễu", 25417, VietNamDivisionType.XA, "xa_duc_lieu", 696)
    W_25420 = Ward("Xã Thống Nhất", 25420, VietNamDivisionType.XA, "xa_thong_nhat", 696)
    W_25423 = Ward("Xã Nghĩa Trung", 25423, VietNamDivisionType.XA, "xa_nghia_trung", 696)
    W_25424 = Ward("Xã Nghĩa Bình", 25424, VietNamDivisionType.XA, "xa_nghia_binh", 696)
    W_25426 = Ward("Xã Đăng Hà", 25426, VietNamDivisionType.XA, "xa_dang_ha", 696)
    W_25429 = Ward("Xã Phước Sơn", 25429, VietNamDivisionType.XA, "xa_phuoc_son", 696)
    W_25432 = Ward("Thị trấn Chơn Thành", 25432, VietNamDivisionType.THI_TRAN, "thi_tran_chon_thanh", 697)
    W_25433 = Ward("Xã Thành Tâm", 25433, VietNamDivisionType.XA, "xa_thanh_tam", 697)
    W_25435 = Ward("Xã Minh Lập", 25435, VietNamDivisionType.XA, "xa_minh_lap", 697)
    W_25439 = Ward("Xã Quang Minh", 25439, VietNamDivisionType.XA, "xa_quang_minh", 697)
    W_25441 = Ward("Xã Minh Hưng", 25441, VietNamDivisionType.XA, "xa_minh_hung", 697)
    W_25444 = Ward("Xã Minh Long", 25444, VietNamDivisionType.XA, "xa_minh_long", 697)
    W_25447 = Ward("Xã Minh Thành", 25447, VietNamDivisionType.XA, "xa_minh_thanh", 697)
    W_25450 = Ward("Xã Nha Bích", 25450, VietNamDivisionType.XA, "xa_nha_bich", 697)
    W_25453 = Ward("Xã Minh Thắng", 25453, VietNamDivisionType.XA, "xa_minh_thang", 697)
    W_25240 = Ward("Xã Long Bình", 25240, VietNamDivisionType.XA, "xa_long_binh", 698)
    W_25243 = Ward("Xã Bình Tân", 25243, VietNamDivisionType.XA, "xa_binh_tan", 698)
    W_25244 = Ward("Xã Bình Sơn", 25244, VietNamDivisionType.XA, "xa_binh_son", 698)
    W_25246 = Ward("Xã Long Hưng", 25246, VietNamDivisionType.XA, "xa_long_hung", 698)
    W_25250 = Ward("Xã Phước Tân", 25250, VietNamDivisionType.XA, "xa_phuoc_tan", 698)
    W_25252 = Ward("Xã Bù Nho", 25252, VietNamDivisionType.XA, "xa_bu_nho", 698)
    W_25255 = Ward("Xã Long Hà", 25255, VietNamDivisionType.XA, "xa_long_ha", 698)
    W_25258 = Ward("Xã Long Tân", 25258, VietNamDivisionType.XA, "xa_long_tan", 698)
    W_25261 = Ward("Xã Phú Trung", 25261, VietNamDivisionType.XA, "xa_phu_trung", 698)
    W_25264 = Ward("Xã Phú Riềng", 25264, VietNamDivisionType.XA, "xa_phu_rieng", 698)
    W_25456 = Ward("Phường 1", 25456, VietNamDivisionType.PHUONG, "phuong_1", 703)
    W_25459 = Ward("Phường 3", 25459, VietNamDivisionType.PHUONG, "phuong_3", 703)
    W_25462 = Ward("Phường 4", 25462, VietNamDivisionType.PHUONG, "phuong_4", 703)
    W_25465 = Ward("Phường Hiệp Ninh", 25465, VietNamDivisionType.PHUONG, "phuong_hiep_ninh", 703)
    W_25468 = Ward("Phường 2", 25468, VietNamDivisionType.PHUONG, "phuong_2", 703)
    W_25471 = Ward("Xã Thạnh Tân", 25471, VietNamDivisionType.XA, "xa_thanh_tan", 703)
    W_25474 = Ward("Xã Tân Bình", 25474, VietNamDivisionType.XA, "xa_tan_binh", 703)
    W_25477 = Ward("Xã Bình Minh", 25477, VietNamDivisionType.XA, "xa_binh_minh", 703)
    W_25480 = Ward("Phường Ninh Sơn", 25480, VietNamDivisionType.PHUONG, "phuong_ninh_son", 703)
    W_25483 = Ward("Phường Ninh Thạnh", 25483, VietNamDivisionType.PHUONG, "phuong_ninh_thanh", 703)
    W_25486 = Ward("Thị trấn Tân Biên", 25486, VietNamDivisionType.THI_TRAN, "thi_tran_tan_bien", 705)
    W_25489 = Ward("Xã Tân Lập", 25489, VietNamDivisionType.XA, "xa_tan_lap", 705)
    W_25492 = Ward("Xã Thạnh Bắc", 25492, VietNamDivisionType.XA, "xa_thanh_bac", 705)
    W_25495 = Ward("Xã Tân Bình", 25495, VietNamDivisionType.XA, "xa_tan_binh", 705)
    W_25498 = Ward("Xã Thạnh Bình", 25498, VietNamDivisionType.XA, "xa_thanh_binh", 705)
    W_25501 = Ward("Xã Thạnh Tây", 25501, VietNamDivisionType.XA, "xa_thanh_tay", 705)
    W_25504 = Ward("Xã Hòa Hiệp", 25504, VietNamDivisionType.XA, "xa_hoa_hiep", 705)
    W_25507 = Ward("Xã Tân Phong", 25507, VietNamDivisionType.XA, "xa_tan_phong", 705)
    W_25510 = Ward("Xã Mỏ Công", 25510, VietNamDivisionType.XA, "xa_mo_cong", 705)
    W_25513 = Ward("Xã Trà Vong", 25513, VietNamDivisionType.XA, "xa_tra_vong", 705)
    W_25516 = Ward("Thị trấn Tân Châu", 25516, VietNamDivisionType.THI_TRAN, "thi_tran_tan_chau", 706)
    W_25519 = Ward("Xã Tân Hà", 25519, VietNamDivisionType.XA, "xa_tan_ha", 706)
    W_25522 = Ward("Xã Tân Đông", 25522, VietNamDivisionType.XA, "xa_tan_dong", 706)
    W_25525 = Ward("Xã Tân Hội", 25525, VietNamDivisionType.XA, "xa_tan_hoi", 706)
    W_25528 = Ward("Xã Tân Hòa", 25528, VietNamDivisionType.XA, "xa_tan_hoa", 706)
    W_25531 = Ward("Xã Suối Ngô", 25531, VietNamDivisionType.XA, "xa_suoi_ngo", 706)
    W_25534 = Ward("Xã Suối Dây", 25534, VietNamDivisionType.XA, "xa_suoi_day", 706)
    W_25537 = Ward("Xã Tân Hiệp", 25537, VietNamDivisionType.XA, "xa_tan_hiep", 706)
    W_25540 = Ward("Xã Thạnh Đông", 25540, VietNamDivisionType.XA, "xa_thanh_dong", 706)
    W_25543 = Ward("Xã Tân Thành", 25543, VietNamDivisionType.XA, "xa_tan_thanh", 706)
    W_25546 = Ward("Xã Tân Phú", 25546, VietNamDivisionType.XA, "xa_tan_phu", 706)
    W_25549 = Ward("Xã Tân Hưng", 25549, VietNamDivisionType.XA, "xa_tan_hung", 706)
    W_25552 = Ward("Thị trấn Dương Minh Châu", 25552, VietNamDivisionType.THI_TRAN, "thi_tran_duong_minh_chau", 707)
    W_25555 = Ward("Xã Suối Đá", 25555, VietNamDivisionType.XA, "xa_suoi_da", 707)
    W_25558 = Ward("Xã Phan", 25558, VietNamDivisionType.XA, "xa_phan", 707)
    W_25561 = Ward("Xã Phước Ninh", 25561, VietNamDivisionType.XA, "xa_phuoc_ninh", 707)
    W_25564 = Ward("Xã Phước Minh", 25564, VietNamDivisionType.XA, "xa_phuoc_minh", 707)
    W_25567 = Ward("Xã Bàu Năng", 25567, VietNamDivisionType.XA, "xa_bau_nang", 707)
    W_25570 = Ward("Xã Chà Là", 25570, VietNamDivisionType.XA, "xa_cha_la", 707)
    W_25573 = Ward("Xã Cầu Khởi", 25573, VietNamDivisionType.XA, "xa_cau_khoi", 707)
    W_25576 = Ward("Xã Bến Củi", 25576, VietNamDivisionType.XA, "xa_ben_cui", 707)
    W_25579 = Ward("Xã Lộc Ninh", 25579, VietNamDivisionType.XA, "xa_loc_ninh", 707)
    W_25582 = Ward("Xã Truông Mít", 25582, VietNamDivisionType.XA, "xa_truong_mit", 707)
    W_25585 = Ward("Thị trấn Châu Thành", 25585, VietNamDivisionType.THI_TRAN, "thi_tran_chau_thanh", 708)
    W_25588 = Ward("Xã Hảo Đước", 25588, VietNamDivisionType.XA, "xa_hao_duoc", 708)
    W_25591 = Ward("Xã Phước Vinh", 25591, VietNamDivisionType.XA, "xa_phuoc_vinh", 708)
    W_25594 = Ward("Xã Đồng Khởi", 25594, VietNamDivisionType.XA, "xa_dong_khoi", 708)
    W_25597 = Ward("Xã Thái Bình", 25597, VietNamDivisionType.XA, "xa_thai_binh", 708)
    W_25600 = Ward("Xã An Cơ", 25600, VietNamDivisionType.XA, "xa_an_co", 708)
    W_25603 = Ward("Xã Biên Giới", 25603, VietNamDivisionType.XA, "xa_bien_gioi", 708)
    W_25606 = Ward("Xã Hòa Thạnh", 25606, VietNamDivisionType.XA, "xa_hoa_thanh", 708)
    W_25609 = Ward("Xã Trí Bình", 25609, VietNamDivisionType.XA, "xa_tri_binh", 708)
    W_25612 = Ward("Xã Hòa Hội", 25612, VietNamDivisionType.XA, "xa_hoa_hoi", 708)
    W_25615 = Ward("Xã An Bình", 25615, VietNamDivisionType.XA, "xa_an_binh", 708)
    W_25618 = Ward("Xã Thanh Điền", 25618, VietNamDivisionType.XA, "xa_thanh_dien", 708)
    W_25621 = Ward("Xã Thành Long", 25621, VietNamDivisionType.XA, "xa_thanh_long", 708)
    W_25624 = Ward("Xã Ninh Điền", 25624, VietNamDivisionType.XA, "xa_ninh_dien", 708)
    W_25627 = Ward("Xã Long Vĩnh", 25627, VietNamDivisionType.XA, "xa_long_vinh", 708)
    W_25630 = Ward("Phường Long Hoa", 25630, VietNamDivisionType.PHUONG, "phuong_long_hoa", 709)
    W_25633 = Ward("Phường Hiệp Tân", 25633, VietNamDivisionType.PHUONG, "phuong_hiep_tan", 709)
    W_25636 = Ward("Phường Long Thành Bắc", 25636, VietNamDivisionType.PHUONG, "phuong_long_thanh_bac", 709)
    W_25639 = Ward("Xã Trường Hòa", 25639, VietNamDivisionType.XA, "xa_truong_hoa", 709)
    W_25642 = Ward("Xã Trường Đông", 25642, VietNamDivisionType.XA, "xa_truong_dong", 709)
    W_25645 = Ward("Phường Long Thành Trung", 25645, VietNamDivisionType.PHUONG, "phuong_long_thanh_trung", 709)
    W_25648 = Ward("Xã Trường Tây", 25648, VietNamDivisionType.XA, "xa_truong_tay", 709)
    W_25651 = Ward("Xã Long Thành Nam", 25651, VietNamDivisionType.XA, "xa_long_thanh_nam", 709)
    W_25654 = Ward("Thị trấn Gò Dầu", 25654, VietNamDivisionType.THI_TRAN, "thi_tran_go_dau", 710)
    W_25657 = Ward("Xã Thạnh Đức", 25657, VietNamDivisionType.XA, "xa_thanh_duc", 710)
    W_25660 = Ward("Xã Cẩm Giang", 25660, VietNamDivisionType.XA, "xa_cam_giang", 710)
    W_25663 = Ward("Xã Hiệp Thạnh", 25663, VietNamDivisionType.XA, "xa_hiep_thanh", 710)
    W_25666 = Ward("Xã Bàu Đồn", 25666, VietNamDivisionType.XA, "xa_bau_don", 710)
    W_25669 = Ward("Xã Phước Thạnh", 25669, VietNamDivisionType.XA, "xa_phuoc_thanh", 710)
    W_25672 = Ward("Xã Phước Đông", 25672, VietNamDivisionType.XA, "xa_phuoc_dong", 710)
    W_25675 = Ward("Xã Phước Trạch", 25675, VietNamDivisionType.XA, "xa_phuoc_trach", 710)
    W_25678 = Ward("Xã Thanh Phước", 25678, VietNamDivisionType.XA, "xa_thanh_phuoc", 710)
    W_25681 = Ward("Thị trấn Bến Cầu", 25681, VietNamDivisionType.THI_TRAN, "thi_tran_ben_cau", 711)
    W_25684 = Ward("Xã Long Chữ", 25684, VietNamDivisionType.XA, "xa_long_chu", 711)
    W_25687 = Ward("Xã Long Phước", 25687, VietNamDivisionType.XA, "xa_long_phuoc", 711)
    W_25690 = Ward("Xã Long Giang", 25690, VietNamDivisionType.XA, "xa_long_giang", 711)
    W_25693 = Ward("Xã Tiên Thuận", 25693, VietNamDivisionType.XA, "xa_tien_thuan", 711)
    W_25696 = Ward("Xã Long Khánh", 25696, VietNamDivisionType.XA, "xa_long_khanh", 711)
    W_25699 = Ward("Xã Lợi Thuận", 25699, VietNamDivisionType.XA, "xa_loi_thuan", 711)
    W_25702 = Ward("Xã Long Thuận", 25702, VietNamDivisionType.XA, "xa_long_thuan", 711)
    W_25705 = Ward("Xã An Thạnh", 25705, VietNamDivisionType.XA, "xa_an_thanh", 711)
    W_25708 = Ward("Phường Trảng Bàng", 25708, VietNamDivisionType.PHUONG, "phuong_trang_bang", 712)
    W_25711 = Ward("Xã Đôn Thuận", 25711, VietNamDivisionType.XA, "xa_don_thuan", 712)
    W_25714 = Ward("Xã Hưng Thuận", 25714, VietNamDivisionType.XA, "xa_hung_thuan", 712)
    W_25717 = Ward("Phường Lộc Hưng", 25717, VietNamDivisionType.PHUONG, "phuong_loc_hung", 712)
    W_25720 = Ward("Phường Gia Lộc", 25720, VietNamDivisionType.PHUONG, "phuong_gia_loc", 712)
    W_25723 = Ward("Phường Gia Bình", 25723, VietNamDivisionType.PHUONG, "phuong_gia_binh", 712)
    W_25729 = Ward("Xã Phước Bình", 25729, VietNamDivisionType.XA, "xa_phuoc_binh", 712)
    W_25732 = Ward("Phường An Tịnh", 25732, VietNamDivisionType.PHUONG, "phuong_an_tinh", 712)
    W_25735 = Ward("Phường An Hòa", 25735, VietNamDivisionType.PHUONG, "phuong_an_hoa", 712)
    W_25738 = Ward("Xã Phước Chỉ", 25738, VietNamDivisionType.XA, "xa_phuoc_chi", 712)
    W_25741 = Ward("Phường Hiệp Thành", 25741, VietNamDivisionType.PHUONG, "phuong_hiep_thanh", 718)
    W_25744 = Ward("Phường Phú Lợi", 25744, VietNamDivisionType.PHUONG, "phuong_phu_loi", 718)
    W_25747 = Ward("Phường Phú Cường", 25747, VietNamDivisionType.PHUONG, "phuong_phu_cuong", 718)
    W_25750 = Ward("Phường Phú Hòa", 25750, VietNamDivisionType.PHUONG, "phuong_phu_hoa", 718)
    W_25753 = Ward("Phường Phú Thọ", 25753, VietNamDivisionType.PHUONG, "phuong_phu_tho", 718)
    W_25756 = Ward("Phường Chánh Nghĩa", 25756, VietNamDivisionType.PHUONG, "phuong_chanh_nghia", 718)
    W_25759 = Ward("Phường Định Hoà", 25759, VietNamDivisionType.PHUONG, "phuong_dinh_hoa", 718)
    W_25760 = Ward("Phường Hoà Phú", 25760, VietNamDivisionType.PHUONG, "phuong_hoa_phu", 718)
    W_25762 = Ward("Phường Phú Mỹ", 25762, VietNamDivisionType.PHUONG, "phuong_phu_my", 718)
    W_25763 = Ward("Phường Phú Tân", 25763, VietNamDivisionType.PHUONG, "phuong_phu_tan", 718)
    W_25765 = Ward("Phường Tân An", 25765, VietNamDivisionType.PHUONG, "phuong_tan_an", 718)
    W_25768 = Ward("Phường Hiệp An", 25768, VietNamDivisionType.PHUONG, "phuong_hiep_an", 718)
    W_25771 = Ward("Phường Tương Bình Hiệp", 25771, VietNamDivisionType.PHUONG, "phuong_tuong_binh_hiep", 718)
    W_25774 = Ward("Phường Chánh Mỹ", 25774, VietNamDivisionType.PHUONG, "phuong_chanh_my", 718)
    W_25816 = Ward("Xã Trừ Văn Thố", 25816, VietNamDivisionType.XA, "xa_tru_van_tho", 719)
    W_25819 = Ward("Xã Cây Trường II", 25819, VietNamDivisionType.XA, "xa_cay_truong_ii", 719)
    W_25822 = Ward("Thị trấn Lai Uyên", 25822, VietNamDivisionType.THI_TRAN, "thi_tran_lai_uyen", 719)
    W_25825 = Ward("Xã Tân Hưng", 25825, VietNamDivisionType.XA, "xa_tan_hung", 719)
    W_25828 = Ward("Xã Long Nguyên", 25828, VietNamDivisionType.XA, "xa_long_nguyen", 719)
    W_25831 = Ward("Xã Hưng Hòa", 25831, VietNamDivisionType.XA, "xa_hung_hoa", 719)
    W_25834 = Ward("Xã Lai Hưng", 25834, VietNamDivisionType.XA, "xa_lai_hung", 719)
    W_25777 = Ward("Thị trấn Dầu Tiếng", 25777, VietNamDivisionType.THI_TRAN, "thi_tran_dau_tieng", 720)
    W_25780 = Ward("Xã Minh Hoà", 25780, VietNamDivisionType.XA, "xa_minh_hoa", 720)
    W_25783 = Ward("Xã Minh Thạnh", 25783, VietNamDivisionType.XA, "xa_minh_thanh", 720)
    W_25786 = Ward("Xã Minh Tân", 25786, VietNamDivisionType.XA, "xa_minh_tan", 720)
    W_25789 = Ward("Xã Định An", 25789, VietNamDivisionType.XA, "xa_dinh_an", 720)
    W_25792 = Ward("Xã Long Hoà", 25792, VietNamDivisionType.XA, "xa_long_hoa", 720)
    W_25795 = Ward("Xã Định Thành", 25795, VietNamDivisionType.XA, "xa_dinh_thanh", 720)
    W_25798 = Ward("Xã Định Hiệp", 25798, VietNamDivisionType.XA, "xa_dinh_hiep", 720)
    W_25801 = Ward("Xã An Lập", 25801, VietNamDivisionType.XA, "xa_an_lap", 720)
    W_25804 = Ward("Xã Long Tân", 25804, VietNamDivisionType.XA, "xa_long_tan", 720)
    W_25807 = Ward("Xã Thanh An", 25807, VietNamDivisionType.XA, "xa_thanh_an", 720)
    W_25810 = Ward("Xã Thanh Tuyền", 25810, VietNamDivisionType.XA, "xa_thanh_tuyen", 720)
    W_25813 = Ward("Phường Mỹ Phước", 25813, VietNamDivisionType.PHUONG, "phuong_my_phuoc", 721)
    W_25837 = Ward("Phường Chánh Phú Hòa", 25837, VietNamDivisionType.PHUONG, "phuong_chanh_phu_hoa", 721)
    W_25840 = Ward("Xã An Điền", 25840, VietNamDivisionType.XA, "xa_an_dien", 721)
    W_25843 = Ward("Xã An Tây", 25843, VietNamDivisionType.XA, "xa_an_tay", 721)
    W_25846 = Ward("Phường Thới Hòa", 25846, VietNamDivisionType.PHUONG, "phuong_thoi_hoa", 721)
    W_25849 = Ward("Phường Hòa Lợi", 25849, VietNamDivisionType.PHUONG, "phuong_hoa_loi", 721)
    W_25852 = Ward("Phường Tân Định", 25852, VietNamDivisionType.PHUONG, "phuong_tan_dinh", 721)
    W_25855 = Ward("Xã Phú An", 25855, VietNamDivisionType.XA, "xa_phu_an", 721)
    W_25858 = Ward("Thị trấn Phước Vĩnh", 25858, VietNamDivisionType.THI_TRAN, "thi_tran_phuoc_vinh", 722)
    W_25861 = Ward("Xã An Linh", 25861, VietNamDivisionType.XA, "xa_an_linh", 722)
    W_25864 = Ward("Xã Phước Sang", 25864, VietNamDivisionType.XA, "xa_phuoc_sang", 722)
    W_25865 = Ward("Xã An Thái", 25865, VietNamDivisionType.XA, "xa_an_thai", 722)
    W_25867 = Ward("Xã An Long", 25867, VietNamDivisionType.XA, "xa_an_long", 722)
    W_25870 = Ward("Xã An Bình", 25870, VietNamDivisionType.XA, "xa_an_binh", 722)
    W_25873 = Ward("Xã Tân Hiệp", 25873, VietNamDivisionType.XA, "xa_tan_hiep", 722)
    W_25876 = Ward("Xã Tam Lập", 25876, VietNamDivisionType.XA, "xa_tam_lap", 722)
    W_25879 = Ward("Xã Tân Long", 25879, VietNamDivisionType.XA, "xa_tan_long", 722)
    W_25882 = Ward("Xã Vĩnh Hoà", 25882, VietNamDivisionType.XA, "xa_vinh_hoa", 722)
    W_25885 = Ward("Xã Phước Hoà", 25885, VietNamDivisionType.XA, "xa_phuoc_hoa", 722)
    W_25888 = Ward("Phường Uyên Hưng", 25888, VietNamDivisionType.PHUONG, "phuong_uyen_hung", 723)
    W_25891 = Ward("Phường Tân Phước Khánh", 25891, VietNamDivisionType.PHUONG, "phuong_tan_phuoc_khanh", 723)
    W_25912 = Ward("Phường Vĩnh Tân", 25912, VietNamDivisionType.PHUONG, "phuong_vinh_tan", 723)
    W_25915 = Ward("Phường Hội Nghĩa", 25915, VietNamDivisionType.PHUONG, "phuong_hoi_nghia", 723)
    W_25920 = Ward("Phường Tân Hiệp", 25920, VietNamDivisionType.PHUONG, "phuong_tan_hiep", 723)
    W_25921 = Ward("Phường Khánh Bình", 25921, VietNamDivisionType.PHUONG, "phuong_khanh_binh", 723)
    W_25924 = Ward("Phường Phú Chánh", 25924, VietNamDivisionType.PHUONG, "phuong_phu_chanh", 723)
    W_25930 = Ward("Xã Bạch Đằng", 25930, VietNamDivisionType.XA, "xa_bach_dang", 723)
    W_25933 = Ward("Phường Tân Vĩnh Hiệp", 25933, VietNamDivisionType.PHUONG, "phuong_tan_vinh_hiep", 723)
    W_25936 = Ward("Phường Thạnh Phước", 25936, VietNamDivisionType.PHUONG, "phuong_thanh_phuoc", 723)
    W_25937 = Ward("Xã Thạnh Hội", 25937, VietNamDivisionType.XA, "xa_thanh_hoi", 723)
    W_25939 = Ward("Phường Thái Hòa", 25939, VietNamDivisionType.PHUONG, "phuong_thai_hoa", 723)
    W_25942 = Ward("Phường Dĩ An", 25942, VietNamDivisionType.PHUONG, "phuong_di_an", 724)
    W_25945 = Ward("Phường Tân Bình", 25945, VietNamDivisionType.PHUONG, "phuong_tan_binh", 724)
    W_25948 = Ward("Phường Tân Đông Hiệp", 25948, VietNamDivisionType.PHUONG, "phuong_tan_dong_hiep", 724)
    W_25951 = Ward("Phường Bình An", 25951, VietNamDivisionType.PHUONG, "phuong_binh_an", 724)
    W_25954 = Ward("Phường Bình Thắng", 25954, VietNamDivisionType.PHUONG, "phuong_binh_thang", 724)
    W_25957 = Ward("Phường Đông Hòa", 25957, VietNamDivisionType.PHUONG, "phuong_dong_hoa", 724)
    W_25960 = Ward("Phường An Bình", 25960, VietNamDivisionType.PHUONG, "phuong_an_binh", 724)
    W_25963 = Ward("Phường An Thạnh", 25963, VietNamDivisionType.PHUONG, "phuong_an_thanh", 725)
    W_25966 = Ward("Phường Lái Thiêu", 25966, VietNamDivisionType.PHUONG, "phuong_lai_thieu", 725)
    W_25969 = Ward("Phường Bình Chuẩn", 25969, VietNamDivisionType.PHUONG, "phuong_binh_chuan", 725)
    W_25972 = Ward("Phường Thuận Giao", 25972, VietNamDivisionType.PHUONG, "phuong_thuan_giao", 725)
    W_25975 = Ward("Phường An Phú", 25975, VietNamDivisionType.PHUONG, "phuong_an_phu", 725)
    W_25978 = Ward("Phường Hưng Định", 25978, VietNamDivisionType.PHUONG, "phuong_hung_dinh", 725)
    W_25981 = Ward("Xã An Sơn", 25981, VietNamDivisionType.XA, "xa_an_son", 725)
    W_25984 = Ward("Phường Bình Nhâm", 25984, VietNamDivisionType.PHUONG, "phuong_binh_nham", 725)
    W_25987 = Ward("Phường Bình Hòa", 25987, VietNamDivisionType.PHUONG, "phuong_binh_hoa", 725)
    W_25990 = Ward("Phường Vĩnh Phú", 25990, VietNamDivisionType.PHUONG, "phuong_vinh_phu", 725)
    W_25894 = Ward("Xã Tân Định", 25894, VietNamDivisionType.XA, "xa_tan_dinh", 726)
    W_25897 = Ward("Xã Bình Mỹ", 25897, VietNamDivisionType.XA, "xa_binh_my", 726)
    W_25900 = Ward("Thị trấn Tân Bình", 25900, VietNamDivisionType.THI_TRAN, "thi_tran_tan_binh", 726)
    W_25903 = Ward("Xã Tân Lập", 25903, VietNamDivisionType.XA, "xa_tan_lap", 726)
    W_25906 = Ward("Thị trấn Tân Thành", 25906, VietNamDivisionType.THI_TRAN, "thi_tran_tan_thanh", 726)
    W_25907 = Ward("Xã Đất Cuốc", 25907, VietNamDivisionType.XA, "xa_dat_cuoc", 726)
    W_25908 = Ward("Xã Hiếu Liêm", 25908, VietNamDivisionType.XA, "xa_hieu_liem", 726)
    W_25909 = Ward("Xã Lạc An", 25909, VietNamDivisionType.XA, "xa_lac_an", 726)
    W_25918 = Ward("Xã Tân Mỹ", 25918, VietNamDivisionType.XA, "xa_tan_my", 726)
    W_25927 = Ward("Xã Thường Tân", 25927, VietNamDivisionType.XA, "xa_thuong_tan", 726)
    W_25993 = Ward("Phường Trảng Dài", 25993, VietNamDivisionType.PHUONG, "phuong_trang_dai", 731)
    W_25996 = Ward("Phường Tân Phong", 25996, VietNamDivisionType.PHUONG, "phuong_tan_phong", 731)
    W_25999 = Ward("Phường Tân Biên", 25999, VietNamDivisionType.PHUONG, "phuong_tan_bien", 731)
    W_26002 = Ward("Phường Hố Nai", 26002, VietNamDivisionType.PHUONG, "phuong_ho_nai", 731)
    W_26005 = Ward("Phường Tân Hòa", 26005, VietNamDivisionType.PHUONG, "phuong_tan_hoa", 731)
    W_26008 = Ward("Phường Tân Hiệp", 26008, VietNamDivisionType.PHUONG, "phuong_tan_hiep", 731)
    W_26011 = Ward("Phường Bửu Long", 26011, VietNamDivisionType.PHUONG, "phuong_buu_long", 731)
    W_26014 = Ward("Phường Tân Tiến", 26014, VietNamDivisionType.PHUONG, "phuong_tan_tien", 731)
    W_26017 = Ward("Phường Tam Hiệp", 26017, VietNamDivisionType.PHUONG, "phuong_tam_hiep", 731)
    W_26020 = Ward("Phường Long Bình", 26020, VietNamDivisionType.PHUONG, "phuong_long_binh", 731)
    W_26023 = Ward("Phường Quang Vinh", 26023, VietNamDivisionType.PHUONG, "phuong_quang_vinh", 731)
    W_26026 = Ward("Phường Tân Mai", 26026, VietNamDivisionType.PHUONG, "phuong_tan_mai", 731)
    W_26029 = Ward("Phường Thống Nhất", 26029, VietNamDivisionType.PHUONG, "phuong_thong_nhat", 731)
    W_26032 = Ward("Phường Trung Dũng", 26032, VietNamDivisionType.PHUONG, "phuong_trung_dung", 731)
    W_26035 = Ward("Phường Tam Hòa", 26035, VietNamDivisionType.PHUONG, "phuong_tam_hoa", 731)
    W_26038 = Ward("Phường Hòa Bình", 26038, VietNamDivisionType.PHUONG, "phuong_hoa_binh", 731)
    W_26041 = Ward("Phường Quyết Thắng", 26041, VietNamDivisionType.PHUONG, "phuong_quyet_thang", 731)
    W_26044 = Ward("Phường Thanh Bình", 26044, VietNamDivisionType.PHUONG, "phuong_thanh_binh", 731)
    W_26047 = Ward("Phường Bình Đa", 26047, VietNamDivisionType.PHUONG, "phuong_binh_da", 731)
    W_26050 = Ward("Phường An Bình", 26050, VietNamDivisionType.PHUONG, "phuong_an_binh", 731)
    W_26053 = Ward("Phường Bửu Hòa", 26053, VietNamDivisionType.PHUONG, "phuong_buu_hoa", 731)
    W_26056 = Ward("Phường Long Bình Tân", 26056, VietNamDivisionType.PHUONG, "phuong_long_binh_tan", 731)
    W_26059 = Ward("Phường Tân Vạn", 26059, VietNamDivisionType.PHUONG, "phuong_tan_van", 731)
    W_26062 = Ward("Phường Tân Hạnh", 26062, VietNamDivisionType.PHUONG, "phuong_tan_hanh", 731)
    W_26065 = Ward("Phường Hiệp Hòa", 26065, VietNamDivisionType.PHUONG, "phuong_hiep_hoa", 731)
    W_26068 = Ward("Phường Hóa An", 26068, VietNamDivisionType.PHUONG, "phuong_hoa_an", 731)
    W_26371 = Ward("Phường An Hòa", 26371, VietNamDivisionType.PHUONG, "phuong_an_hoa", 731)
    W_26374 = Ward("Phường Tam Phước", 26374, VietNamDivisionType.PHUONG, "phuong_tam_phuoc", 731)
    W_26377 = Ward("Phường Phước Tân", 26377, VietNamDivisionType.PHUONG, "phuong_phuoc_tan", 731)
    W_26380 = Ward("Xã Long Hưng", 26380, VietNamDivisionType.XA, "xa_long_hung", 731)
    W_26071 = Ward("Phường Xuân Trung", 26071, VietNamDivisionType.PHUONG, "phuong_xuan_trung", 732)
    W_26074 = Ward("Phường Xuân Thanh", 26074, VietNamDivisionType.PHUONG, "phuong_xuan_thanh", 732)
    W_26077 = Ward("Phường Xuân Bình", 26077, VietNamDivisionType.PHUONG, "phuong_xuan_binh", 732)
    W_26080 = Ward("Phường Xuân An", 26080, VietNamDivisionType.PHUONG, "phuong_xuan_an", 732)
    W_26083 = Ward("Phường Xuân Hoà", 26083, VietNamDivisionType.PHUONG, "phuong_xuan_hoa", 732)
    W_26086 = Ward("Phường Phú Bình", 26086, VietNamDivisionType.PHUONG, "phuong_phu_binh", 732)
    W_26089 = Ward("Xã Bình Lộc", 26089, VietNamDivisionType.XA, "xa_binh_loc", 732)
    W_26092 = Ward("Xã Bảo Quang", 26092, VietNamDivisionType.XA, "xa_bao_quang", 732)
    W_26095 = Ward("Phường Suối Tre", 26095, VietNamDivisionType.PHUONG, "phuong_suoi_tre", 732)
    W_26098 = Ward("Phường Bảo Vinh", 26098, VietNamDivisionType.PHUONG, "phuong_bao_vinh", 732)
    W_26101 = Ward("Phường Xuân Lập", 26101, VietNamDivisionType.PHUONG, "phuong_xuan_lap", 732)
    W_26104 = Ward("Phường Bàu Sen", 26104, VietNamDivisionType.PHUONG, "phuong_bau_sen", 732)
    W_26107 = Ward("Xã Bàu Trâm", 26107, VietNamDivisionType.XA, "xa_bau_tram", 732)
    W_26110 = Ward("Phường Xuân Tân", 26110, VietNamDivisionType.PHUONG, "phuong_xuan_tan", 732)
    W_26113 = Ward("Xã Hàng Gòn", 26113, VietNamDivisionType.XA, "xa_hang_gon", 732)
    W_26116 = Ward("Thị trấn Tân Phú", 26116, VietNamDivisionType.THI_TRAN, "thi_tran_tan_phu", 734)
    W_26119 = Ward("Xã Dak Lua", 26119, VietNamDivisionType.XA, "xa_dak_lua", 734)
    W_26122 = Ward("Xã Nam Cát Tiên", 26122, VietNamDivisionType.XA, "xa_nam_cat_tien", 734)
    W_26125 = Ward("Xã Phú An", 26125, VietNamDivisionType.XA, "xa_phu_an", 734)
    W_26128 = Ward("Xã Núi Tượng", 26128, VietNamDivisionType.XA, "xa_nui_tuong", 734)
    W_26131 = Ward("Xã Tà Lài", 26131, VietNamDivisionType.XA, "xa_ta_lai", 734)
    W_26134 = Ward("Xã Phú Lập", 26134, VietNamDivisionType.XA, "xa_phu_lap", 734)
    W_26137 = Ward("Xã Phú Sơn", 26137, VietNamDivisionType.XA, "xa_phu_son", 734)
    W_26140 = Ward("Xã Phú Thịnh", 26140, VietNamDivisionType.XA, "xa_phu_thinh", 734)
    W_26143 = Ward("Xã Thanh Sơn", 26143, VietNamDivisionType.XA, "xa_thanh_son", 734)
    W_26146 = Ward("Xã Phú Trung", 26146, VietNamDivisionType.XA, "xa_phu_trung", 734)
    W_26149 = Ward("Xã Phú Xuân", 26149, VietNamDivisionType.XA, "xa_phu_xuan", 734)
    W_26152 = Ward("Xã Phú Lộc", 26152, VietNamDivisionType.XA, "xa_phu_loc", 734)
    W_26155 = Ward("Xã Phú Lâm", 26155, VietNamDivisionType.XA, "xa_phu_lam", 734)
    W_26158 = Ward("Xã Phú Bình", 26158, VietNamDivisionType.XA, "xa_phu_binh", 734)
    W_26161 = Ward("Xã Phú Thanh", 26161, VietNamDivisionType.XA, "xa_phu_thanh", 734)
    W_26164 = Ward("Xã Trà Cổ", 26164, VietNamDivisionType.XA, "xa_tra_co", 734)
    W_26167 = Ward("Xã Phú Điền", 26167, VietNamDivisionType.XA, "xa_phu_dien", 734)
    W_26170 = Ward("Thị trấn Vĩnh An", 26170, VietNamDivisionType.THI_TRAN, "thi_tran_vinh_an", 735)
    W_26173 = Ward("Xã Phú Lý", 26173, VietNamDivisionType.XA, "xa_phu_ly", 735)
    W_26176 = Ward("Xã Trị An", 26176, VietNamDivisionType.XA, "xa_tri_an", 735)
    W_26179 = Ward("Xã Tân An", 26179, VietNamDivisionType.XA, "xa_tan_an", 735)
    W_26182 = Ward("Xã Vĩnh Tân", 26182, VietNamDivisionType.XA, "xa_vinh_tan", 735)
    W_26185 = Ward("Xã Bình Lợi", 26185, VietNamDivisionType.XA, "xa_binh_loi", 735)
    W_26188 = Ward("Xã Thạnh Phú", 26188, VietNamDivisionType.XA, "xa_thanh_phu", 735)
    W_26191 = Ward("Xã Thiện Tân", 26191, VietNamDivisionType.XA, "xa_thien_tan", 735)
    W_26194 = Ward("Xã Tân Bình", 26194, VietNamDivisionType.XA, "xa_tan_binh", 735)
    W_26197 = Ward("Xã Bình Hòa", 26197, VietNamDivisionType.XA, "xa_binh_hoa", 735)
    W_26200 = Ward("Xã Mã Đà", 26200, VietNamDivisionType.XA, "xa_ma_da", 735)
    W_26203 = Ward("Xã Hiếu Liêm", 26203, VietNamDivisionType.XA, "xa_hieu_liem", 735)
    W_26206 = Ward("Thị trấn Định Quán", 26206, VietNamDivisionType.THI_TRAN, "thi_tran_dinh_quan", 736)
    W_26209 = Ward("Xã Thanh Sơn", 26209, VietNamDivisionType.XA, "xa_thanh_son", 736)
    W_26212 = Ward("Xã Phú Tân", 26212, VietNamDivisionType.XA, "xa_phu_tan", 736)
    W_26215 = Ward("Xã Phú Vinh", 26215, VietNamDivisionType.XA, "xa_phu_vinh", 736)
    W_26218 = Ward("Xã Phú Lợi", 26218, VietNamDivisionType.XA, "xa_phu_loi", 736)
    W_26221 = Ward("Xã Phú Hòa", 26221, VietNamDivisionType.XA, "xa_phu_hoa", 736)
    W_26224 = Ward("Xã Ngọc Định", 26224, VietNamDivisionType.XA, "xa_ngoc_dinh", 736)
    W_26227 = Ward("Xã La Ngà", 26227, VietNamDivisionType.XA, "xa_la_nga", 736)
    W_26230 = Ward("Xã Gia Canh", 26230, VietNamDivisionType.XA, "xa_gia_canh", 736)
    W_26233 = Ward("Xã Phú Ngọc", 26233, VietNamDivisionType.XA, "xa_phu_ngoc", 736)
    W_26236 = Ward("Xã Phú Cường", 26236, VietNamDivisionType.XA, "xa_phu_cuong", 736)
    W_26239 = Ward("Xã Túc Trưng", 26239, VietNamDivisionType.XA, "xa_tuc_trung", 736)
    W_26242 = Ward("Xã Phú Túc", 26242, VietNamDivisionType.XA, "xa_phu_tuc", 736)
    W_26245 = Ward("Xã Suối Nho", 26245, VietNamDivisionType.XA, "xa_suoi_nho", 736)
    W_26248 = Ward("Thị trấn Trảng Bom", 26248, VietNamDivisionType.THI_TRAN, "thi_tran_trang_bom", 737)
    W_26251 = Ward("Xã Thanh Bình", 26251, VietNamDivisionType.XA, "xa_thanh_binh", 737)
    W_26254 = Ward("Xã Cây Gáo", 26254, VietNamDivisionType.XA, "xa_cay_gao", 737)
    W_26257 = Ward("Xã Bàu Hàm", 26257, VietNamDivisionType.XA, "xa_bau_ham", 737)
    W_26260 = Ward("Xã Sông Thao", 26260, VietNamDivisionType.XA, "xa_song_thao", 737)
    W_26263 = Ward("Xã Sông Trầu", 26263, VietNamDivisionType.XA, "xa_song_trau", 737)
    W_26266 = Ward("Xã Đông Hoà", 26266, VietNamDivisionType.XA, "xa_dong_hoa", 737)
    W_26269 = Ward("Xã Bắc Sơn", 26269, VietNamDivisionType.XA, "xa_bac_son", 737)
    W_26272 = Ward("Xã Hố Nai 3", 26272, VietNamDivisionType.XA, "xa_ho_nai_3", 737)
    W_26275 = Ward("Xã Tây Hoà", 26275, VietNamDivisionType.XA, "xa_tay_hoa", 737)
    W_26278 = Ward("Xã Bình Minh", 26278, VietNamDivisionType.XA, "xa_binh_minh", 737)
    W_26281 = Ward("Xã Trung Hoà", 26281, VietNamDivisionType.XA, "xa_trung_hoa", 737)
    W_26284 = Ward("Xã Đồi 61", 26284, VietNamDivisionType.XA, "xa_doi_61", 737)
    W_26287 = Ward("Xã Hưng Thịnh", 26287, VietNamDivisionType.XA, "xa_hung_thinh", 737)
    W_26290 = Ward("Xã Quảng Tiến", 26290, VietNamDivisionType.XA, "xa_quang_tien", 737)
    W_26293 = Ward("Xã Giang Điền", 26293, VietNamDivisionType.XA, "xa_giang_dien", 737)
    W_26296 = Ward("Xã An Viễn", 26296, VietNamDivisionType.XA, "xa_an_vien", 737)
    W_26299 = Ward("Xã Gia Tân 1", 26299, VietNamDivisionType.XA, "xa_gia_tan_1", 738)
    W_26302 = Ward("Xã Gia Tân 2", 26302, VietNamDivisionType.XA, "xa_gia_tan_2", 738)
    W_26305 = Ward("Xã Gia Tân 3", 26305, VietNamDivisionType.XA, "xa_gia_tan_3", 738)
    W_26308 = Ward("Xã Gia Kiệm", 26308, VietNamDivisionType.XA, "xa_gia_kiem", 738)
    W_26311 = Ward("Xã Quang Trung", 26311, VietNamDivisionType.XA, "xa_quang_trung", 738)
    W_26314 = Ward("Xã Bàu Hàm 2", 26314, VietNamDivisionType.XA, "xa_bau_ham_2", 738)
    W_26317 = Ward("Xã Hưng Lộc", 26317, VietNamDivisionType.XA, "xa_hung_loc", 738)
    W_26320 = Ward("Xã Lộ 25", 26320, VietNamDivisionType.XA, "xa_lo_25", 738)
    W_26323 = Ward("Xã Xuân Thiện", 26323, VietNamDivisionType.XA, "xa_xuan_thien", 738)
    W_26326 = Ward("Thị trấn Dầu Giây", 26326, VietNamDivisionType.THI_TRAN, "thi_tran_dau_giay", 738)
    W_26329 = Ward("Xã Sông Nhạn", 26329, VietNamDivisionType.XA, "xa_song_nhan", 739)
    W_26332 = Ward("Xã Xuân Quế", 26332, VietNamDivisionType.XA, "xa_xuan_que", 739)
    W_26335 = Ward("Xã Nhân Nghĩa", 26335, VietNamDivisionType.XA, "xa_nhan_nghia", 739)
    W_26338 = Ward("Xã Xuân Đường", 26338, VietNamDivisionType.XA, "xa_xuan_duong", 739)
    W_26341 = Ward("Xã Long Giao", 26341, VietNamDivisionType.XA, "xa_long_giao", 739)
    W_26344 = Ward("Xã Xuân Mỹ", 26344, VietNamDivisionType.XA, "xa_xuan_my", 739)
    W_26347 = Ward("Xã Thừa Đức", 26347, VietNamDivisionType.XA, "xa_thua_duc", 739)
    W_26350 = Ward("Xã Bảo Bình", 26350, VietNamDivisionType.XA, "xa_bao_binh", 739)
    W_26353 = Ward("Xã Xuân Bảo", 26353, VietNamDivisionType.XA, "xa_xuan_bao", 739)
    W_26356 = Ward("Xã Xuân Tây", 26356, VietNamDivisionType.XA, "xa_xuan_tay", 739)
    W_26359 = Ward("Xã Xuân Đông", 26359, VietNamDivisionType.XA, "xa_xuan_dong", 739)
    W_26362 = Ward("Xã Sông Ray", 26362, VietNamDivisionType.XA, "xa_song_ray", 739)
    W_26365 = Ward("Xã Lâm San", 26365, VietNamDivisionType.XA, "xa_lam_san", 739)
    W_26368 = Ward("Thị trấn Long Thành", 26368, VietNamDivisionType.THI_TRAN, "thi_tran_long_thanh", 740)
    W_26383 = Ward("Xã An Phước", 26383, VietNamDivisionType.XA, "xa_an_phuoc", 740)
    W_26386 = Ward("Xã Bình An", 26386, VietNamDivisionType.XA, "xa_binh_an", 740)
    W_26389 = Ward("Xã Long Đức", 26389, VietNamDivisionType.XA, "xa_long_duc", 740)
    W_26392 = Ward("Xã Lộc An", 26392, VietNamDivisionType.XA, "xa_loc_an", 740)
    W_26395 = Ward("Xã Bình Sơn", 26395, VietNamDivisionType.XA, "xa_binh_son", 740)
    W_26398 = Ward("Xã Tam An", 26398, VietNamDivisionType.XA, "xa_tam_an", 740)
    W_26401 = Ward("Xã Cẩm Đường", 26401, VietNamDivisionType.XA, "xa_cam_duong", 740)
    W_26404 = Ward("Xã Long An", 26404, VietNamDivisionType.XA, "xa_long_an", 740)
    W_26410 = Ward("Xã Bàu Cạn", 26410, VietNamDivisionType.XA, "xa_bau_can", 740)
    W_26413 = Ward("Xã Long Phước", 26413, VietNamDivisionType.XA, "xa_long_phuoc", 740)
    W_26416 = Ward("Xã Phước Bình", 26416, VietNamDivisionType.XA, "xa_phuoc_binh", 740)
    W_26419 = Ward("Xã Tân Hiệp", 26419, VietNamDivisionType.XA, "xa_tan_hiep", 740)
    W_26422 = Ward("Xã Phước Thái", 26422, VietNamDivisionType.XA, "xa_phuoc_thai", 740)
    W_26425 = Ward("Thị trấn Gia Ray", 26425, VietNamDivisionType.THI_TRAN, "thi_tran_gia_ray", 741)
    W_26428 = Ward("Xã Xuân Bắc", 26428, VietNamDivisionType.XA, "xa_xuan_bac", 741)
    W_26431 = Ward("Xã Suối Cao", 26431, VietNamDivisionType.XA, "xa_suoi_cao", 741)
    W_26434 = Ward("Xã Xuân Thành", 26434, VietNamDivisionType.XA, "xa_xuan_thanh", 741)
    W_26437 = Ward("Xã Xuân Thọ", 26437, VietNamDivisionType.XA, "xa_xuan_tho", 741)
    W_26440 = Ward("Xã Xuân Trường", 26440, VietNamDivisionType.XA, "xa_xuan_truong", 741)
    W_26443 = Ward("Xã Xuân Hòa", 26443, VietNamDivisionType.XA, "xa_xuan_hoa", 741)
    W_26446 = Ward("Xã Xuân Hưng", 26446, VietNamDivisionType.XA, "xa_xuan_hung", 741)
    W_26449 = Ward("Xã Xuân Tâm", 26449, VietNamDivisionType.XA, "xa_xuan_tam", 741)
    W_26452 = Ward("Xã Suối Cát", 26452, VietNamDivisionType.XA, "xa_suoi_cat", 741)
    W_26455 = Ward("Xã Xuân Hiệp", 26455, VietNamDivisionType.XA, "xa_xuan_hiep", 741)
    W_26458 = Ward("Xã Xuân Phú", 26458, VietNamDivisionType.XA, "xa_xuan_phu", 741)
    W_26461 = Ward("Xã Xuân Định", 26461, VietNamDivisionType.XA, "xa_xuan_dinh", 741)
    W_26464 = Ward("Xã Bảo Hoà", 26464, VietNamDivisionType.XA, "xa_bao_hoa", 741)
    W_26467 = Ward("Xã Lang Minh", 26467, VietNamDivisionType.XA, "xa_lang_minh", 741)
    W_26470 = Ward("Xã Phước Thiền", 26470, VietNamDivisionType.XA, "xa_phuoc_thien", 742)
    W_26473 = Ward("Xã Long Tân", 26473, VietNamDivisionType.XA, "xa_long_tan", 742)
    W_26476 = Ward("Xã Đại Phước", 26476, VietNamDivisionType.XA, "xa_dai_phuoc", 742)
    W_26479 = Ward("Thị trấn Hiệp Phước", 26479, VietNamDivisionType.THI_TRAN, "thi_tran_hiep_phuoc", 742)
    W_26482 = Ward("Xã Phú Hữu", 26482, VietNamDivisionType.XA, "xa_phu_huu", 742)
    W_26485 = Ward("Xã Phú Hội", 26485, VietNamDivisionType.XA, "xa_phu_hoi", 742)
    W_26488 = Ward("Xã Phú Thạnh", 26488, VietNamDivisionType.XA, "xa_phu_thanh", 742)
    W_26491 = Ward("Xã Phú Đông", 26491, VietNamDivisionType.XA, "xa_phu_dong", 742)
    W_26494 = Ward("Xã Long Thọ", 26494, VietNamDivisionType.XA, "xa_long_tho", 742)
    W_26497 = Ward("Xã Vĩnh Thanh", 26497, VietNamDivisionType.XA, "xa_vinh_thanh", 742)
    W_26500 = Ward("Xã Phước Khánh", 26500, VietNamDivisionType.XA, "xa_phuoc_khanh", 742)
    W_26503 = Ward("Xã Phước An", 26503, VietNamDivisionType.XA, "xa_phuoc_an", 742)
    W_26506 = Ward("Phường 1", 26506, VietNamDivisionType.PHUONG, "phuong_1", 747)
    W_26508 = Ward("Phường Thắng Tam", 26508, VietNamDivisionType.PHUONG, "phuong_thang_tam", 747)
    W_26509 = Ward("Phường 2", 26509, VietNamDivisionType.PHUONG, "phuong_2", 747)
    W_26512 = Ward("Phường 3", 26512, VietNamDivisionType.PHUONG, "phuong_3", 747)
    W_26515 = Ward("Phường 4", 26515, VietNamDivisionType.PHUONG, "phuong_4", 747)
    W_26518 = Ward("Phường 5", 26518, VietNamDivisionType.PHUONG, "phuong_5", 747)
    W_26521 = Ward("Phường Thắng Nhì", 26521, VietNamDivisionType.PHUONG, "phuong_thang_nhi", 747)
    W_26524 = Ward("Phường 7", 26524, VietNamDivisionType.PHUONG, "phuong_7", 747)
    W_26526 = Ward("Phường Nguyễn An Ninh", 26526, VietNamDivisionType.PHUONG, "phuong_nguyen_an_ninh", 747)
    W_26527 = Ward("Phường 8", 26527, VietNamDivisionType.PHUONG, "phuong_8", 747)
    W_26530 = Ward("Phường 9", 26530, VietNamDivisionType.PHUONG, "phuong_9", 747)
    W_26533 = Ward("Phường Thắng Nhất", 26533, VietNamDivisionType.PHUONG, "phuong_thang_nhat", 747)
    W_26535 = Ward("Phường Rạch Dừa", 26535, VietNamDivisionType.PHUONG, "phuong_rach_dua", 747)
    W_26536 = Ward("Phường 10", 26536, VietNamDivisionType.PHUONG, "phuong_10", 747)
    W_26539 = Ward("Phường 11", 26539, VietNamDivisionType.PHUONG, "phuong_11", 747)
    W_26542 = Ward("Phường 12", 26542, VietNamDivisionType.PHUONG, "phuong_12", 747)
    W_26545 = Ward("Xã Long Sơn", 26545, VietNamDivisionType.XA, "xa_long_son", 747)
    W_26548 = Ward("Phường Phước Hưng", 26548, VietNamDivisionType.PHUONG, "phuong_phuoc_hung", 748)
    W_26551 = Ward("Phường Phước Hiệp", 26551, VietNamDivisionType.PHUONG, "phuong_phuoc_hiep", 748)
    W_26554 = Ward("Phường Phước Nguyên", 26554, VietNamDivisionType.PHUONG, "phuong_phuoc_nguyen", 748)
    W_26557 = Ward("Phường Long Toàn", 26557, VietNamDivisionType.PHUONG, "phuong_long_toan", 748)
    W_26558 = Ward("Phường Long Tâm", 26558, VietNamDivisionType.PHUONG, "phuong_long_tam", 748)
    W_26560 = Ward("Phường Phước Trung", 26560, VietNamDivisionType.PHUONG, "phuong_phuoc_trung", 748)
    W_26563 = Ward("Phường Long Hương", 26563, VietNamDivisionType.PHUONG, "phuong_long_huong", 748)
    W_26566 = Ward("Phường Kim Dinh", 26566, VietNamDivisionType.PHUONG, "phuong_kim_dinh", 748)
    W_26567 = Ward("Xã Tân Hưng", 26567, VietNamDivisionType.XA, "xa_tan_hung", 748)
    W_26569 = Ward("Xã Long Phước", 26569, VietNamDivisionType.XA, "xa_long_phuoc", 748)
    W_26572 = Ward("Xã Hoà Long", 26572, VietNamDivisionType.XA, "xa_hoa_long", 748)
    W_26574 = Ward("Xã Bàu Chinh", 26574, VietNamDivisionType.XA, "xa_bau_chinh", 750)
    W_26575 = Ward("Thị trấn Ngãi Giao", 26575, VietNamDivisionType.THI_TRAN, "thi_tran_ngai_giao", 750)
    W_26578 = Ward("Xã Bình Ba", 26578, VietNamDivisionType.XA, "xa_binh_ba", 750)
    W_26581 = Ward("Xã Suối Nghệ", 26581, VietNamDivisionType.XA, "xa_suoi_nghe", 750)
    W_26584 = Ward("Xã Xuân Sơn", 26584, VietNamDivisionType.XA, "xa_xuan_son", 750)
    W_26587 = Ward("Xã Sơn Bình", 26587, VietNamDivisionType.XA, "xa_son_binh", 750)
    W_26590 = Ward("Xã Bình Giã", 26590, VietNamDivisionType.XA, "xa_binh_gia", 750)
    W_26593 = Ward("Xã Bình Trung", 26593, VietNamDivisionType.XA, "xa_binh_trung", 750)
    W_26596 = Ward("Xã Xà Bang", 26596, VietNamDivisionType.XA, "xa_xa_bang", 750)
    W_26599 = Ward("Xã Cù Bị", 26599, VietNamDivisionType.XA, "xa_cu_bi", 750)
    W_26602 = Ward("Xã Láng Lớn", 26602, VietNamDivisionType.XA, "xa_lang_lon", 750)
    W_26605 = Ward("Xã Quảng Thành", 26605, VietNamDivisionType.XA, "xa_quang_thanh", 750)
    W_26608 = Ward("Xã Kim Long", 26608, VietNamDivisionType.XA, "xa_kim_long", 750)
    W_26611 = Ward("Xã Suối Rao", 26611, VietNamDivisionType.XA, "xa_suoi_rao", 750)
    W_26614 = Ward("Xã Đá Bạc", 26614, VietNamDivisionType.XA, "xa_da_bac", 750)
    W_26617 = Ward("Xã Nghĩa Thành", 26617, VietNamDivisionType.XA, "xa_nghia_thanh", 750)
    W_26620 = Ward("Thị trấn Phước Bửu", 26620, VietNamDivisionType.THI_TRAN, "thi_tran_phuoc_buu", 751)
    W_26623 = Ward("Xã Phước Thuận", 26623, VietNamDivisionType.XA, "xa_phuoc_thuan", 751)
    W_26626 = Ward("Xã Phước Tân", 26626, VietNamDivisionType.XA, "xa_phuoc_tan", 751)
    W_26629 = Ward("Xã Xuyên Mộc", 26629, VietNamDivisionType.XA, "xa_xuyen_moc", 751)
    W_26632 = Ward("Xã Bông Trang", 26632, VietNamDivisionType.XA, "xa_bong_trang", 751)
    W_26635 = Ward("Xã Tân Lâm", 26635, VietNamDivisionType.XA, "xa_tan_lam", 751)
    W_26638 = Ward("Xã Bàu Lâm", 26638, VietNamDivisionType.XA, "xa_bau_lam", 751)
    W_26641 = Ward("Xã Hòa Bình", 26641, VietNamDivisionType.XA, "xa_hoa_binh", 751)
    W_26644 = Ward("Xã Hòa Hưng", 26644, VietNamDivisionType.XA, "xa_hoa_hung", 751)
    W_26647 = Ward("Xã Hòa Hiệp", 26647, VietNamDivisionType.XA, "xa_hoa_hiep", 751)
    W_26650 = Ward("Xã Hòa Hội", 26650, VietNamDivisionType.XA, "xa_hoa_hoi", 751)
    W_26653 = Ward("Xã Bưng Riềng", 26653, VietNamDivisionType.XA, "xa_bung_rieng", 751)
    W_26656 = Ward("Xã Bình Châu", 26656, VietNamDivisionType.XA, "xa_binh_chau", 751)
    W_26659 = Ward("Thị trấn Long Điền", 26659, VietNamDivisionType.THI_TRAN, "thi_tran_long_dien", 752)
    W_26662 = Ward("Thị trấn Long Hải", 26662, VietNamDivisionType.THI_TRAN, "thi_tran_long_hai", 752)
    W_26665 = Ward("Xã An Ngãi", 26665, VietNamDivisionType.XA, "xa_an_ngai", 752)
    W_26668 = Ward("Xã Tam Phước", 26668, VietNamDivisionType.XA, "xa_tam_phuoc", 752)
    W_26671 = Ward("Xã An Nhứt", 26671, VietNamDivisionType.XA, "xa_an_nhut", 752)
    W_26674 = Ward("Xã Phước Tỉnh", 26674, VietNamDivisionType.XA, "xa_phuoc_tinh", 752)
    W_26677 = Ward("Xã Phước Hưng", 26677, VietNamDivisionType.XA, "xa_phuoc_hung", 752)
    W_26680 = Ward("Thị trấn Đất Đỏ", 26680, VietNamDivisionType.THI_TRAN, "thi_tran_dat_do", 753)
    W_26683 = Ward("Xã Phước Long Thọ", 26683, VietNamDivisionType.XA, "xa_phuoc_long_tho", 753)
    W_26686 = Ward("Xã Phước Hội", 26686, VietNamDivisionType.XA, "xa_phuoc_hoi", 753)
    W_26689 = Ward("Xã Long Mỹ", 26689, VietNamDivisionType.XA, "xa_long_my", 753)
    W_26692 = Ward("Thị trấn Phước Hải", 26692, VietNamDivisionType.THI_TRAN, "thi_tran_phuoc_hai", 753)
    W_26695 = Ward("Xã Long Tân", 26695, VietNamDivisionType.XA, "xa_long_tan", 753)
    W_26698 = Ward("Xã Láng Dài", 26698, VietNamDivisionType.XA, "xa_lang_dai", 753)
    W_26701 = Ward("Xã Lộc An", 26701, VietNamDivisionType.XA, "xa_loc_an", 753)
    W_26704 = Ward("Phường Phú Mỹ", 26704, VietNamDivisionType.PHUONG, "phuong_phu_my", 754)
    W_26707 = Ward("Xã Tân Hoà", 26707, VietNamDivisionType.XA, "xa_tan_hoa", 754)
    W_26710 = Ward("Xã Tân Hải", 26710, VietNamDivisionType.XA, "xa_tan_hai", 754)
    W_26713 = Ward("Phường Phước Hoà", 26713, VietNamDivisionType.PHUONG, "phuong_phuoc_hoa", 754)
    W_26716 = Ward("Phường Tân Phước", 26716, VietNamDivisionType.PHUONG, "phuong_tan_phuoc", 754)
    W_26719 = Ward("Phường Mỹ Xuân", 26719, VietNamDivisionType.PHUONG, "phuong_my_xuan", 754)
    W_26722 = Ward("Xã Sông Xoài", 26722, VietNamDivisionType.XA, "xa_song_xoai", 754)
    W_26725 = Ward("Phường Hắc Dịch", 26725, VietNamDivisionType.PHUONG, "phuong_hac_dich", 754)
    W_26728 = Ward("Xã Châu Pha", 26728, VietNamDivisionType.XA, "xa_chau_pha", 754)
    W_26731 = Ward("Xã Tóc Tiên", 26731, VietNamDivisionType.XA, "xa_toc_tien", 754)
    W_26734 = Ward("Phường Tân Định", 26734, VietNamDivisionType.PHUONG, "phuong_tan_dinh", 760)
    W_26737 = Ward("Phường Đa Kao", 26737, VietNamDivisionType.PHUONG, "phuong_da_kao", 760)
    W_26740 = Ward("Phường Bến Nghé", 26740, VietNamDivisionType.PHUONG, "phuong_ben_nghe", 760)
    W_26743 = Ward("Phường Bến Thành", 26743, VietNamDivisionType.PHUONG, "phuong_ben_thanh", 760)
    W_26746 = Ward("Phường Nguyễn Thái Bình", 26746, VietNamDivisionType.PHUONG, "phuong_nguyen_thai_binh", 760)
    W_26749 = Ward("Phường Phạm Ngũ Lão", 26749, VietNamDivisionType.PHUONG, "phuong_pham_ngu_lao", 760)
    W_26752 = Ward("Phường Cầu Ông Lãnh", 26752, VietNamDivisionType.PHUONG, "phuong_cau_ong_lanh", 760)
    W_26755 = Ward("Phường Cô Giang", 26755, VietNamDivisionType.PHUONG, "phuong_co_giang", 760)
    W_26758 = Ward("Phường Nguyễn Cư Trinh", 26758, VietNamDivisionType.PHUONG, "phuong_nguyen_cu_trinh", 760)
    W_26761 = Ward("Phường Cầu Kho", 26761, VietNamDivisionType.PHUONG, "phuong_cau_kho", 760)
    W_26764 = Ward("Phường Thạnh Xuân", 26764, VietNamDivisionType.PHUONG, "phuong_thanh_xuan", 761)
    W_26767 = Ward("Phường Thạnh Lộc", 26767, VietNamDivisionType.PHUONG, "phuong_thanh_loc", 761)
    W_26770 = Ward("Phường Hiệp Thành", 26770, VietNamDivisionType.PHUONG, "phuong_hiep_thanh", 761)
    W_26773 = Ward("Phường Thới An", 26773, VietNamDivisionType.PHUONG, "phuong_thoi_an", 761)
    W_26776 = Ward("Phường Tân Chánh Hiệp", 26776, VietNamDivisionType.PHUONG, "phuong_tan_chanh_hiep", 761)
    W_26779 = Ward("Phường An Phú Đông", 26779, VietNamDivisionType.PHUONG, "phuong_an_phu_dong", 761)
    W_26782 = Ward("Phường Tân Thới Hiệp", 26782, VietNamDivisionType.PHUONG, "phuong_tan_thoi_hiep", 761)
    W_26785 = Ward("Phường Trung Mỹ Tây", 26785, VietNamDivisionType.PHUONG, "phuong_trung_my_tay", 761)
    W_26787 = Ward("Phường Tân Hưng Thuận", 26787, VietNamDivisionType.PHUONG, "phuong_tan_hung_thuan", 761)
    W_26788 = Ward("Phường Đông Hưng Thuận", 26788, VietNamDivisionType.PHUONG, "phuong_dong_hung_thuan", 761)
    W_26791 = Ward("Phường Tân Thới Nhất", 26791, VietNamDivisionType.PHUONG, "phuong_tan_thoi_nhat", 761)
    W_26869 = Ward("Phường 15", 26869, VietNamDivisionType.PHUONG, "phuong_15", 764)
    W_26872 = Ward("Phường 13", 26872, VietNamDivisionType.PHUONG, "phuong_13", 764)
    W_26875 = Ward("Phường 17", 26875, VietNamDivisionType.PHUONG, "phuong_17", 764)
    W_26876 = Ward("Phường 6", 26876, VietNamDivisionType.PHUONG, "phuong_6", 764)
    W_26878 = Ward("Phường 16", 26878, VietNamDivisionType.PHUONG, "phuong_16", 764)
    W_26881 = Ward("Phường 12", 26881, VietNamDivisionType.PHUONG, "phuong_12", 764)
    W_26882 = Ward("Phường 14", 26882, VietNamDivisionType.PHUONG, "phuong_14", 764)
    W_26884 = Ward("Phường 10", 26884, VietNamDivisionType.PHUONG, "phuong_10", 764)
    W_26887 = Ward("Phường 05", 26887, VietNamDivisionType.PHUONG, "phuong_05", 764)
    W_26890 = Ward("Phường 07", 26890, VietNamDivisionType.PHUONG, "phuong_07", 764)
    W_26893 = Ward("Phường 04", 26893, VietNamDivisionType.PHUONG, "phuong_04", 764)
    W_26896 = Ward("Phường 01", 26896, VietNamDivisionType.PHUONG, "phuong_01", 764)
    W_26897 = Ward("Phường 9", 26897, VietNamDivisionType.PHUONG, "phuong_9", 764)
    W_26898 = Ward("Phường 8", 26898, VietNamDivisionType.PHUONG, "phuong_8", 764)
    W_26899 = Ward("Phường 11", 26899, VietNamDivisionType.PHUONG, "phuong_11", 764)
    W_26902 = Ward("Phường 03", 26902, VietNamDivisionType.PHUONG, "phuong_03", 764)
    W_26905 = Ward("Phường 13", 26905, VietNamDivisionType.PHUONG, "phuong_13", 765)
    W_26908 = Ward("Phường 11", 26908, VietNamDivisionType.PHUONG, "phuong_11", 765)
    W_26911 = Ward("Phường 27", 26911, VietNamDivisionType.PHUONG, "phuong_27", 765)
    W_26914 = Ward("Phường 26", 26914, VietNamDivisionType.PHUONG, "phuong_26", 765)
    W_26917 = Ward("Phường 12", 26917, VietNamDivisionType.PHUONG, "phuong_12", 765)
    W_26920 = Ward("Phường 25", 26920, VietNamDivisionType.PHUONG, "phuong_25", 765)
    W_26923 = Ward("Phường 05", 26923, VietNamDivisionType.PHUONG, "phuong_05", 765)
    W_26926 = Ward("Phường 07", 26926, VietNamDivisionType.PHUONG, "phuong_07", 765)
    W_26929 = Ward("Phường 24", 26929, VietNamDivisionType.PHUONG, "phuong_24", 765)
    W_26932 = Ward("Phường 06", 26932, VietNamDivisionType.PHUONG, "phuong_06", 765)
    W_26935 = Ward("Phường 14", 26935, VietNamDivisionType.PHUONG, "phuong_14", 765)
    W_26938 = Ward("Phường 15", 26938, VietNamDivisionType.PHUONG, "phuong_15", 765)
    W_26941 = Ward("Phường 02", 26941, VietNamDivisionType.PHUONG, "phuong_02", 765)
    W_26944 = Ward("Phường 01", 26944, VietNamDivisionType.PHUONG, "phuong_01", 765)
    W_26947 = Ward("Phường 03", 26947, VietNamDivisionType.PHUONG, "phuong_03", 765)
    W_26950 = Ward("Phường 17", 26950, VietNamDivisionType.PHUONG, "phuong_17", 765)
    W_26953 = Ward("Phường 21", 26953, VietNamDivisionType.PHUONG, "phuong_21", 765)
    W_26956 = Ward("Phường 22", 26956, VietNamDivisionType.PHUONG, "phuong_22", 765)
    W_26959 = Ward("Phường 19", 26959, VietNamDivisionType.PHUONG, "phuong_19", 765)
    W_26962 = Ward("Phường 28", 26962, VietNamDivisionType.PHUONG, "phuong_28", 765)
    W_26965 = Ward("Phường 02", 26965, VietNamDivisionType.PHUONG, "phuong_02", 766)
    W_26968 = Ward("Phường 04", 26968, VietNamDivisionType.PHUONG, "phuong_04", 766)
    W_26971 = Ward("Phường 12", 26971, VietNamDivisionType.PHUONG, "phuong_12", 766)
    W_26974 = Ward("Phường 13", 26974, VietNamDivisionType.PHUONG, "phuong_13", 766)
    W_26977 = Ward("Phường 01", 26977, VietNamDivisionType.PHUONG, "phuong_01", 766)
    W_26980 = Ward("Phường 03", 26980, VietNamDivisionType.PHUONG, "phuong_03", 766)
    W_26983 = Ward("Phường 11", 26983, VietNamDivisionType.PHUONG, "phuong_11", 766)
    W_26986 = Ward("Phường 07", 26986, VietNamDivisionType.PHUONG, "phuong_07", 766)
    W_26989 = Ward("Phường 05", 26989, VietNamDivisionType.PHUONG, "phuong_05", 766)
    W_26992 = Ward("Phường 10", 26992, VietNamDivisionType.PHUONG, "phuong_10", 766)
    W_26995 = Ward("Phường 06", 26995, VietNamDivisionType.PHUONG, "phuong_06", 766)
    W_26998 = Ward("Phường 08", 26998, VietNamDivisionType.PHUONG, "phuong_08", 766)
    W_27001 = Ward("Phường 09", 27001, VietNamDivisionType.PHUONG, "phuong_09", 766)
    W_27004 = Ward("Phường 14", 27004, VietNamDivisionType.PHUONG, "phuong_14", 766)
    W_27007 = Ward("Phường 15", 27007, VietNamDivisionType.PHUONG, "phuong_15", 766)
    W_27010 = Ward("Phường Tân Sơn Nhì", 27010, VietNamDivisionType.PHUONG, "phuong_tan_son_nhi", 767)
    W_27013 = Ward("Phường Tây Thạnh", 27013, VietNamDivisionType.PHUONG, "phuong_tay_thanh", 767)
    W_27016 = Ward("Phường Sơn Kỳ", 27016, VietNamDivisionType.PHUONG, "phuong_son_ky", 767)
    W_27019 = Ward("Phường Tân Quý", 27019, VietNamDivisionType.PHUONG, "phuong_tan_quy", 767)
    W_27022 = Ward("Phường Tân Thành", 27022, VietNamDivisionType.PHUONG, "phuong_tan_thanh", 767)
    W_27025 = Ward("Phường Phú Thọ Hòa", 27025, VietNamDivisionType.PHUONG, "phuong_phu_tho_hoa", 767)
    W_27028 = Ward("Phường Phú Thạnh", 27028, VietNamDivisionType.PHUONG, "phuong_phu_thanh", 767)
    W_27031 = Ward("Phường Phú Trung", 27031, VietNamDivisionType.PHUONG, "phuong_phu_trung", 767)
    W_27034 = Ward("Phường Hòa Thạnh", 27034, VietNamDivisionType.PHUONG, "phuong_hoa_thanh", 767)
    W_27037 = Ward("Phường Hiệp Tân", 27037, VietNamDivisionType.PHUONG, "phuong_hiep_tan", 767)
    W_27040 = Ward("Phường Tân Thới Hòa", 27040, VietNamDivisionType.PHUONG, "phuong_tan_thoi_hoa", 767)
    W_27043 = Ward("Phường 04", 27043, VietNamDivisionType.PHUONG, "phuong_04", 768)
    W_27046 = Ward("Phường 05", 27046, VietNamDivisionType.PHUONG, "phuong_05", 768)
    W_27049 = Ward("Phường 09", 27049, VietNamDivisionType.PHUONG, "phuong_09", 768)
    W_27052 = Ward("Phường 07", 27052, VietNamDivisionType.PHUONG, "phuong_07", 768)
    W_27055 = Ward("Phường 03", 27055, VietNamDivisionType.PHUONG, "phuong_03", 768)
    W_27058 = Ward("Phường 01", 27058, VietNamDivisionType.PHUONG, "phuong_01", 768)
    W_27061 = Ward("Phường 02", 27061, VietNamDivisionType.PHUONG, "phuong_02", 768)
    W_27064 = Ward("Phường 08", 27064, VietNamDivisionType.PHUONG, "phuong_08", 768)
    W_27067 = Ward("Phường 15", 27067, VietNamDivisionType.PHUONG, "phuong_15", 768)
    W_27070 = Ward("Phường 10", 27070, VietNamDivisionType.PHUONG, "phuong_10", 768)
    W_27073 = Ward("Phường 11", 27073, VietNamDivisionType.PHUONG, "phuong_11", 768)
    W_27076 = Ward("Phường 17", 27076, VietNamDivisionType.PHUONG, "phuong_17", 768)
    W_27085 = Ward("Phường 13", 27085, VietNamDivisionType.PHUONG, "phuong_13", 768)
    W_26794 = Ward("Phường Linh Xuân", 26794, VietNamDivisionType.PHUONG, "phuong_linh_xuan", 769)
    W_26797 = Ward("Phường Bình Chiểu", 26797, VietNamDivisionType.PHUONG, "phuong_binh_chieu", 769)
    W_26800 = Ward("Phường Linh Trung", 26800, VietNamDivisionType.PHUONG, "phuong_linh_trung", 769)
    W_26803 = Ward("Phường Tam Bình", 26803, VietNamDivisionType.PHUONG, "phuong_tam_binh", 769)
    W_26806 = Ward("Phường Tam Phú", 26806, VietNamDivisionType.PHUONG, "phuong_tam_phu", 769)
    W_26809 = Ward("Phường Hiệp Bình Phước", 26809, VietNamDivisionType.PHUONG, "phuong_hiep_binh_phuoc", 769)
    W_26812 = Ward("Phường Hiệp Bình Chánh", 26812, VietNamDivisionType.PHUONG, "phuong_hiep_binh_chanh", 769)
    W_26815 = Ward("Phường Linh Chiểu", 26815, VietNamDivisionType.PHUONG, "phuong_linh_chieu", 769)
    W_26818 = Ward("Phường Linh Tây", 26818, VietNamDivisionType.PHUONG, "phuong_linh_tay", 769)
    W_26821 = Ward("Phường Linh Đông", 26821, VietNamDivisionType.PHUONG, "phuong_linh_dong", 769)
    W_26824 = Ward("Phường Bình Thọ", 26824, VietNamDivisionType.PHUONG, "phuong_binh_tho", 769)
    W_26827 = Ward("Phường Trường Thọ", 26827, VietNamDivisionType.PHUONG, "phuong_truong_tho", 769)
    W_26830 = Ward("Phường Long Bình", 26830, VietNamDivisionType.PHUONG, "phuong_long_binh", 769)
    W_26833 = Ward("Phường Long Thạnh Mỹ", 26833, VietNamDivisionType.PHUONG, "phuong_long_thanh_my", 769)
    W_26836 = Ward("Phường Tân Phú", 26836, VietNamDivisionType.PHUONG, "phuong_tan_phu", 769)
    W_26839 = Ward("Phường Hiệp Phú", 26839, VietNamDivisionType.PHUONG, "phuong_hiep_phu", 769)
    W_26842 = Ward("Phường Tăng Nhơn Phú A", 26842, VietNamDivisionType.PHUONG, "phuong_tang_nhon_phu_a", 769)
    W_26845 = Ward("Phường Tăng Nhơn Phú B", 26845, VietNamDivisionType.PHUONG, "phuong_tang_nhon_phu_b", 769)
    W_26848 = Ward("Phường Phước Long B", 26848, VietNamDivisionType.PHUONG, "phuong_phuoc_long_b", 769)
    W_26851 = Ward("Phường Phước Long A", 26851, VietNamDivisionType.PHUONG, "phuong_phuoc_long_a", 769)
    W_26854 = Ward("Phường Trường Thạnh", 26854, VietNamDivisionType.PHUONG, "phuong_truong_thanh", 769)
    W_26857 = Ward("Phường Long Phước", 26857, VietNamDivisionType.PHUONG, "phuong_long_phuoc", 769)
    W_26860 = Ward("Phường Long Trường", 26860, VietNamDivisionType.PHUONG, "phuong_long_truong", 769)
    W_26863 = Ward("Phường Phước Bình", 26863, VietNamDivisionType.PHUONG, "phuong_phuoc_binh", 769)
    W_26866 = Ward("Phường Phú Hữu", 26866, VietNamDivisionType.PHUONG, "phuong_phu_huu", 769)
    W_27088 = Ward("Phường Thảo Điền", 27088, VietNamDivisionType.PHUONG, "phuong_thao_dien", 769)
    W_27091 = Ward("Phường An Phú", 27091, VietNamDivisionType.PHUONG, "phuong_an_phu", 769)
    W_27094 = Ward("Phường An Khánh", 27094, VietNamDivisionType.PHUONG, "phuong_an_khanh", 769)
    W_27097 = Ward("Phường Bình Trưng Đông", 27097, VietNamDivisionType.PHUONG, "phuong_binh_trung_dong", 769)
    W_27100 = Ward("Phường Bình Trưng Tây", 27100, VietNamDivisionType.PHUONG, "phuong_binh_trung_tay", 769)
    W_27109 = Ward("Phường Cát Lái", 27109, VietNamDivisionType.PHUONG, "phuong_cat_lai", 769)
    W_27112 = Ward("Phường Thạnh Mỹ Lợi", 27112, VietNamDivisionType.PHUONG, "phuong_thanh_my_loi", 769)
    W_27115 = Ward("Phường An Lợi Đông", 27115, VietNamDivisionType.PHUONG, "phuong_an_loi_dong", 769)
    W_27118 = Ward("Phường Thủ Thiêm", 27118, VietNamDivisionType.PHUONG, "phuong_thu_thiem", 769)
    W_27127 = Ward("Phường 14", 27127, VietNamDivisionType.PHUONG, "phuong_14", 770)
    W_27130 = Ward("Phường 12", 27130, VietNamDivisionType.PHUONG, "phuong_12", 770)
    W_27133 = Ward("Phường 11", 27133, VietNamDivisionType.PHUONG, "phuong_11", 770)
    W_27136 = Ward("Phường 13", 27136, VietNamDivisionType.PHUONG, "phuong_13", 770)
    W_27139 = Ward("Phường Võ Thị Sáu", 27139, VietNamDivisionType.PHUONG, "phuong_vo_thi_sau", 770)
    W_27142 = Ward("Phường 09", 27142, VietNamDivisionType.PHUONG, "phuong_09", 770)
    W_27145 = Ward("Phường 10", 27145, VietNamDivisionType.PHUONG, "phuong_10", 770)
    W_27148 = Ward("Phường 04", 27148, VietNamDivisionType.PHUONG, "phuong_04", 770)
    W_27151 = Ward("Phường 05", 27151, VietNamDivisionType.PHUONG, "phuong_05", 770)
    W_27154 = Ward("Phường 03", 27154, VietNamDivisionType.PHUONG, "phuong_03", 770)
    W_27157 = Ward("Phường 02", 27157, VietNamDivisionType.PHUONG, "phuong_02", 770)
    W_27160 = Ward("Phường 01", 27160, VietNamDivisionType.PHUONG, "phuong_01", 770)
    W_27163 = Ward("Phường 15", 27163, VietNamDivisionType.PHUONG, "phuong_15", 771)
    W_27166 = Ward("Phường 13", 27166, VietNamDivisionType.PHUONG, "phuong_13", 771)
    W_27169 = Ward("Phường 14", 27169, VietNamDivisionType.PHUONG, "phuong_14", 771)
    W_27172 = Ward("Phường 12", 27172, VietNamDivisionType.PHUONG, "phuong_12", 771)
    W_27175 = Ward("Phường 11", 27175, VietNamDivisionType.PHUONG, "phuong_11", 771)
    W_27178 = Ward("Phường 10", 27178, VietNamDivisionType.PHUONG, "phuong_10", 771)
    W_27181 = Ward("Phường 09", 27181, VietNamDivisionType.PHUONG, "phuong_09", 771)
    W_27184 = Ward("Phường 01", 27184, VietNamDivisionType.PHUONG, "phuong_01", 771)
    W_27187 = Ward("Phường 08", 27187, VietNamDivisionType.PHUONG, "phuong_08", 771)
    W_27190 = Ward("Phường 02", 27190, VietNamDivisionType.PHUONG, "phuong_02", 771)
    W_27193 = Ward("Phường 04", 27193, VietNamDivisionType.PHUONG, "phuong_04", 771)
    W_27196 = Ward("Phường 07", 27196, VietNamDivisionType.PHUONG, "phuong_07", 771)
    W_27199 = Ward("Phường 05", 27199, VietNamDivisionType.PHUONG, "phuong_05", 771)
    W_27202 = Ward("Phường 06", 27202, VietNamDivisionType.PHUONG, "phuong_06", 771)
    W_27208 = Ward("Phường 15", 27208, VietNamDivisionType.PHUONG, "phuong_15", 772)
    W_27211 = Ward("Phường 05", 27211, VietNamDivisionType.PHUONG, "phuong_05", 772)
    W_27214 = Ward("Phường 14", 27214, VietNamDivisionType.PHUONG, "phuong_14", 772)
    W_27217 = Ward("Phường 11", 27217, VietNamDivisionType.PHUONG, "phuong_11", 772)
    W_27220 = Ward("Phường 03", 27220, VietNamDivisionType.PHUONG, "phuong_03", 772)
    W_27223 = Ward("Phường 10", 27223, VietNamDivisionType.PHUONG, "phuong_10", 772)
    W_27226 = Ward("Phường 13", 27226, VietNamDivisionType.PHUONG, "phuong_13", 772)
    W_27229 = Ward("Phường 08", 27229, VietNamDivisionType.PHUONG, "phuong_08", 772)
    W_27232 = Ward("Phường 09", 27232, VietNamDivisionType.PHUONG, "phuong_09", 772)
    W_27235 = Ward("Phường 12", 27235, VietNamDivisionType.PHUONG, "phuong_12", 772)
    W_27238 = Ward("Phường 07", 27238, VietNamDivisionType.PHUONG, "phuong_07", 772)
    W_27241 = Ward("Phường 06", 27241, VietNamDivisionType.PHUONG, "phuong_06", 772)
    W_27244 = Ward("Phường 04", 27244, VietNamDivisionType.PHUONG, "phuong_04", 772)
    W_27247 = Ward("Phường 01", 27247, VietNamDivisionType.PHUONG, "phuong_01", 772)
    W_27250 = Ward("Phường 02", 27250, VietNamDivisionType.PHUONG, "phuong_02", 772)
    W_27253 = Ward("Phường 16", 27253, VietNamDivisionType.PHUONG, "phuong_16", 772)
    W_27259 = Ward("Phường 13", 27259, VietNamDivisionType.PHUONG, "phuong_13", 773)
    W_27262 = Ward("Phường 09", 27262, VietNamDivisionType.PHUONG, "phuong_09", 773)
    W_27265 = Ward("Phường 06", 27265, VietNamDivisionType.PHUONG, "phuong_06", 773)
    W_27268 = Ward("Phường 08", 27268, VietNamDivisionType.PHUONG, "phuong_08", 773)
    W_27271 = Ward("Phường 10", 27271, VietNamDivisionType.PHUONG, "phuong_10", 773)
    W_27277 = Ward("Phường 18", 27277, VietNamDivisionType.PHUONG, "phuong_18", 773)
    W_27280 = Ward("Phường 14", 27280, VietNamDivisionType.PHUONG, "phuong_14", 773)
    W_27283 = Ward("Phường 04", 27283, VietNamDivisionType.PHUONG, "phuong_04", 773)
    W_27286 = Ward("Phường 03", 27286, VietNamDivisionType.PHUONG, "phuong_03", 773)
    W_27289 = Ward("Phường 16", 27289, VietNamDivisionType.PHUONG, "phuong_16", 773)
    W_27292 = Ward("Phường 02", 27292, VietNamDivisionType.PHUONG, "phuong_02", 773)
    W_27295 = Ward("Phường 15", 27295, VietNamDivisionType.PHUONG, "phuong_15", 773)
    W_27298 = Ward("Phường 01", 27298, VietNamDivisionType.PHUONG, "phuong_01", 773)
    W_27301 = Ward("Phường 04", 27301, VietNamDivisionType.PHUONG, "phuong_04", 774)
    W_27304 = Ward("Phường 09", 27304, VietNamDivisionType.PHUONG, "phuong_09", 774)
    W_27307 = Ward("Phường 03", 27307, VietNamDivisionType.PHUONG, "phuong_03", 774)
    W_27310 = Ward("Phường 12", 27310, VietNamDivisionType.PHUONG, "phuong_12", 774)
    W_27313 = Ward("Phường 02", 27313, VietNamDivisionType.PHUONG, "phuong_02", 774)
    W_27316 = Ward("Phường 08", 27316, VietNamDivisionType.PHUONG, "phuong_08", 774)
    W_27322 = Ward("Phường 07", 27322, VietNamDivisionType.PHUONG, "phuong_07", 774)
    W_27325 = Ward("Phường 01", 27325, VietNamDivisionType.PHUONG, "phuong_01", 774)
    W_27328 = Ward("Phường 11", 27328, VietNamDivisionType.PHUONG, "phuong_11", 774)
    W_27331 = Ward("Phường 14", 27331, VietNamDivisionType.PHUONG, "phuong_14", 774)
    W_27334 = Ward("Phường 05", 27334, VietNamDivisionType.PHUONG, "phuong_05", 774)
    W_27337 = Ward("Phường 06", 27337, VietNamDivisionType.PHUONG, "phuong_06", 774)
    W_27340 = Ward("Phường 10", 27340, VietNamDivisionType.PHUONG, "phuong_10", 774)
    W_27343 = Ward("Phường 13", 27343, VietNamDivisionType.PHUONG, "phuong_13", 774)
    W_27346 = Ward("Phường 14", 27346, VietNamDivisionType.PHUONG, "phuong_14", 775)
    W_27349 = Ward("Phường 13", 27349, VietNamDivisionType.PHUONG, "phuong_13", 775)
    W_27352 = Ward("Phường 09", 27352, VietNamDivisionType.PHUONG, "phuong_09", 775)
    W_27355 = Ward("Phường 06", 27355, VietNamDivisionType.PHUONG, "phuong_06", 775)
    W_27358 = Ward("Phường 12", 27358, VietNamDivisionType.PHUONG, "phuong_12", 775)
    W_27361 = Ward("Phường 05", 27361, VietNamDivisionType.PHUONG, "phuong_05", 775)
    W_27364 = Ward("Phường 11", 27364, VietNamDivisionType.PHUONG, "phuong_11", 775)
    W_27367 = Ward("Phường 02", 27367, VietNamDivisionType.PHUONG, "phuong_02", 775)
    W_27370 = Ward("Phường 01", 27370, VietNamDivisionType.PHUONG, "phuong_01", 775)
    W_27373 = Ward("Phường 04", 27373, VietNamDivisionType.PHUONG, "phuong_04", 775)
    W_27376 = Ward("Phường 08", 27376, VietNamDivisionType.PHUONG, "phuong_08", 775)
    W_27379 = Ward("Phường 03", 27379, VietNamDivisionType.PHUONG, "phuong_03", 775)
    W_27382 = Ward("Phường 07", 27382, VietNamDivisionType.PHUONG, "phuong_07", 775)
    W_27385 = Ward("Phường 10", 27385, VietNamDivisionType.PHUONG, "phuong_10", 775)
    W_27388 = Ward("Phường 08", 27388, VietNamDivisionType.PHUONG, "phuong_08", 776)
    W_27391 = Ward("Phường 02", 27391, VietNamDivisionType.PHUONG, "phuong_02", 776)
    W_27394 = Ward("Phường 01", 27394, VietNamDivisionType.PHUONG, "phuong_01", 776)
    W_27397 = Ward("Phường 03", 27397, VietNamDivisionType.PHUONG, "phuong_03", 776)
    W_27400 = Ward("Phường 11", 27400, VietNamDivisionType.PHUONG, "phuong_11", 776)
    W_27403 = Ward("Phường 09", 27403, VietNamDivisionType.PHUONG, "phuong_09", 776)
    W_27406 = Ward("Phường 10", 27406, VietNamDivisionType.PHUONG, "phuong_10", 776)
    W_27409 = Ward("Phường 04", 27409, VietNamDivisionType.PHUONG, "phuong_04", 776)
    W_27412 = Ward("Phường 13", 27412, VietNamDivisionType.PHUONG, "phuong_13", 776)
    W_27415 = Ward("Phường 12", 27415, VietNamDivisionType.PHUONG, "phuong_12", 776)
    W_27418 = Ward("Phường 05", 27418, VietNamDivisionType.PHUONG, "phuong_05", 776)
    W_27421 = Ward("Phường 14", 27421, VietNamDivisionType.PHUONG, "phuong_14", 776)
    W_27424 = Ward("Phường 06", 27424, VietNamDivisionType.PHUONG, "phuong_06", 776)
    W_27427 = Ward("Phường 15", 27427, VietNamDivisionType.PHUONG, "phuong_15", 776)
    W_27430 = Ward("Phường 16", 27430, VietNamDivisionType.PHUONG, "phuong_16", 776)
    W_27433 = Ward("Phường 07", 27433, VietNamDivisionType.PHUONG, "phuong_07", 776)
    W_27436 = Ward("Phường Bình Hưng Hòa", 27436, VietNamDivisionType.PHUONG, "phuong_binh_hung_hoa", 777)
    W_27439 = Ward("Phường Bình Hưng Hoà A", 27439, VietNamDivisionType.PHUONG, "phuong_binh_hung_hoa_a", 777)
    W_27442 = Ward("Phường Bình Hưng Hoà B", 27442, VietNamDivisionType.PHUONG, "phuong_binh_hung_hoa_b", 777)
    W_27445 = Ward("Phường Bình Trị Đông", 27445, VietNamDivisionType.PHUONG, "phuong_binh_tri_dong", 777)
    W_27448 = Ward("Phường Bình Trị Đông A", 27448, VietNamDivisionType.PHUONG, "phuong_binh_tri_dong_a", 777)
    W_27451 = Ward("Phường Bình Trị Đông B", 27451, VietNamDivisionType.PHUONG, "phuong_binh_tri_dong_b", 777)
    W_27454 = Ward("Phường Tân Tạo", 27454, VietNamDivisionType.PHUONG, "phuong_tan_tao", 777)
    W_27457 = Ward("Phường Tân Tạo A", 27457, VietNamDivisionType.PHUONG, "phuong_tan_tao_a", 777)
    W_27460 = Ward("Phường An Lạc", 27460, VietNamDivisionType.PHUONG, "phuong_an_lac", 777)
    W_27463 = Ward("Phường An Lạc A", 27463, VietNamDivisionType.PHUONG, "phuong_an_lac_a", 777)
    W_27466 = Ward("Phường Tân Thuận Đông", 27466, VietNamDivisionType.PHUONG, "phuong_tan_thuan_dong", 778)
    W_27469 = Ward("Phường Tân Thuận Tây", 27469, VietNamDivisionType.PHUONG, "phuong_tan_thuan_tay", 778)
    W_27472 = Ward("Phường Tân Kiểng", 27472, VietNamDivisionType.PHUONG, "phuong_tan_kieng", 778)
    W_27475 = Ward("Phường Tân Hưng", 27475, VietNamDivisionType.PHUONG, "phuong_tan_hung", 778)
    W_27478 = Ward("Phường Bình Thuận", 27478, VietNamDivisionType.PHUONG, "phuong_binh_thuan", 778)
    W_27481 = Ward("Phường Tân Quy", 27481, VietNamDivisionType.PHUONG, "phuong_tan_quy", 778)
    W_27484 = Ward("Phường Phú Thuận", 27484, VietNamDivisionType.PHUONG, "phuong_phu_thuan", 778)
    W_27487 = Ward("Phường Tân Phú", 27487, VietNamDivisionType.PHUONG, "phuong_tan_phu", 778)
    W_27490 = Ward("Phường Tân Phong", 27490, VietNamDivisionType.PHUONG, "phuong_tan_phong", 778)
    W_27493 = Ward("Phường Phú Mỹ", 27493, VietNamDivisionType.PHUONG, "phuong_phu_my", 778)
    W_27496 = Ward("Thị trấn Củ Chi", 27496, VietNamDivisionType.THI_TRAN, "thi_tran_cu_chi", 783)
    W_27499 = Ward("Xã Phú Mỹ Hưng", 27499, VietNamDivisionType.XA, "xa_phu_my_hung", 783)
    W_27502 = Ward("Xã An Phú", 27502, VietNamDivisionType.XA, "xa_an_phu", 783)
    W_27505 = Ward("Xã Trung Lập Thượng", 27505, VietNamDivisionType.XA, "xa_trung_lap_thuong", 783)
    W_27508 = Ward("Xã An Nhơn Tây", 27508, VietNamDivisionType.XA, "xa_an_nhon_tay", 783)
    W_27511 = Ward("Xã Nhuận Đức", 27511, VietNamDivisionType.XA, "xa_nhuan_duc", 783)
    W_27514 = Ward("Xã Phạm Văn Cội", 27514, VietNamDivisionType.XA, "xa_pham_van_coi", 783)
    W_27517 = Ward("Xã Phú Hòa Đông", 27517, VietNamDivisionType.XA, "xa_phu_hoa_dong", 783)
    W_27520 = Ward("Xã Trung Lập Hạ", 27520, VietNamDivisionType.XA, "xa_trung_lap_ha", 783)
    W_27523 = Ward("Xã Trung An", 27523, VietNamDivisionType.XA, "xa_trung_an", 783)
    W_27526 = Ward("Xã Phước Thạnh", 27526, VietNamDivisionType.XA, "xa_phuoc_thanh", 783)
    W_27529 = Ward("Xã Phước Hiệp", 27529, VietNamDivisionType.XA, "xa_phuoc_hiep", 783)
    W_27532 = Ward("Xã Tân An Hội", 27532, VietNamDivisionType.XA, "xa_tan_an_hoi", 783)
    W_27535 = Ward("Xã Phước Vĩnh An", 27535, VietNamDivisionType.XA, "xa_phuoc_vinh_an", 783)
    W_27538 = Ward("Xã Thái Mỹ", 27538, VietNamDivisionType.XA, "xa_thai_my", 783)
    W_27541 = Ward("Xã Tân Thạnh Tây", 27541, VietNamDivisionType.XA, "xa_tan_thanh_tay", 783)
    W_27544 = Ward("Xã Hòa Phú", 27544, VietNamDivisionType.XA, "xa_hoa_phu", 783)
    W_27547 = Ward("Xã Tân Thạnh Đông", 27547, VietNamDivisionType.XA, "xa_tan_thanh_dong", 783)
    W_27550 = Ward("Xã Bình Mỹ", 27550, VietNamDivisionType.XA, "xa_binh_my", 783)
    W_27553 = Ward("Xã Tân Phú Trung", 27553, VietNamDivisionType.XA, "xa_tan_phu_trung", 783)
    W_27556 = Ward("Xã Tân Thông Hội", 27556, VietNamDivisionType.XA, "xa_tan_thong_hoi", 783)
    W_27559 = Ward("Thị trấn Hóc Môn", 27559, VietNamDivisionType.THI_TRAN, "thi_tran_hoc_mon", 784)
    W_27562 = Ward("Xã Tân Hiệp", 27562, VietNamDivisionType.XA, "xa_tan_hiep", 784)
    W_27565 = Ward("Xã Nhị Bình", 27565, VietNamDivisionType.XA, "xa_nhi_binh", 784)
    W_27568 = Ward("Xã Đông Thạnh", 27568, VietNamDivisionType.XA, "xa_dong_thanh", 784)
    W_27571 = Ward("Xã Tân Thới Nhì", 27571, VietNamDivisionType.XA, "xa_tan_thoi_nhi", 784)
    W_27574 = Ward("Xã Thới Tam Thôn", 27574, VietNamDivisionType.XA, "xa_thoi_tam_thon", 784)
    W_27577 = Ward("Xã Xuân Thới Sơn", 27577, VietNamDivisionType.XA, "xa_xuan_thoi_son", 784)
    W_27580 = Ward("Xã Tân Xuân", 27580, VietNamDivisionType.XA, "xa_tan_xuan", 784)
    W_27583 = Ward("Xã Xuân Thới Đông", 27583, VietNamDivisionType.XA, "xa_xuan_thoi_dong", 784)
    W_27586 = Ward("Xã Trung Chánh", 27586, VietNamDivisionType.XA, "xa_trung_chanh", 784)
    W_27589 = Ward("Xã Xuân Thới Thượng", 27589, VietNamDivisionType.XA, "xa_xuan_thoi_thuong", 784)
    W_27592 = Ward("Xã Bà Điểm", 27592, VietNamDivisionType.XA, "xa_ba_diem", 784)
    W_27595 = Ward("Thị trấn Tân Túc", 27595, VietNamDivisionType.THI_TRAN, "thi_tran_tan_tuc", 785)
    W_27598 = Ward("Xã Phạm Văn Hai", 27598, VietNamDivisionType.XA, "xa_pham_van_hai", 785)
    W_27601 = Ward("Xã Vĩnh Lộc A", 27601, VietNamDivisionType.XA, "xa_vinh_loc_a", 785)
    W_27604 = Ward("Xã Vĩnh Lộc B", 27604, VietNamDivisionType.XA, "xa_vinh_loc_b", 785)
    W_27607 = Ward("Xã Bình Lợi", 27607, VietNamDivisionType.XA, "xa_binh_loi", 785)
    W_27610 = Ward("Xã Lê Minh Xuân", 27610, VietNamDivisionType.XA, "xa_le_minh_xuan", 785)
    W_27613 = Ward("Xã Tân Nhựt", 27613, VietNamDivisionType.XA, "xa_tan_nhut", 785)
    W_27616 = Ward("Xã Tân Kiên", 27616, VietNamDivisionType.XA, "xa_tan_kien", 785)
    W_27619 = Ward("Xã Bình Hưng", 27619, VietNamDivisionType.XA, "xa_binh_hung", 785)
    W_27622 = Ward("Xã Phong Phú", 27622, VietNamDivisionType.XA, "xa_phong_phu", 785)
    W_27625 = Ward("Xã An Phú Tây", 27625, VietNamDivisionType.XA, "xa_an_phu_tay", 785)
    W_27628 = Ward("Xã Hưng Long", 27628, VietNamDivisionType.XA, "xa_hung_long", 785)
    W_27631 = Ward("Xã Đa Phước", 27631, VietNamDivisionType.XA, "xa_da_phuoc", 785)
    W_27634 = Ward("Xã Tân Quý Tây", 27634, VietNamDivisionType.XA, "xa_tan_quy_tay", 785)
    W_27637 = Ward("Xã Bình Chánh", 27637, VietNamDivisionType.XA, "xa_binh_chanh", 785)
    W_27640 = Ward("Xã Quy Đức", 27640, VietNamDivisionType.XA, "xa_quy_duc", 785)
    W_27643 = Ward("Thị trấn Nhà Bè", 27643, VietNamDivisionType.THI_TRAN, "thi_tran_nha_be", 786)
    W_27646 = Ward("Xã Phước Kiển", 27646, VietNamDivisionType.XA, "xa_phuoc_kien", 786)
    W_27649 = Ward("Xã Phước Lộc", 27649, VietNamDivisionType.XA, "xa_phuoc_loc", 786)
    W_27652 = Ward("Xã Nhơn Đức", 27652, VietNamDivisionType.XA, "xa_nhon_duc", 786)
    W_27655 = Ward("Xã Phú Xuân", 27655, VietNamDivisionType.XA, "xa_phu_xuan", 786)
    W_27658 = Ward("Xã Long Thới", 27658, VietNamDivisionType.XA, "xa_long_thoi", 786)
    W_27661 = Ward("Xã Hiệp Phước", 27661, VietNamDivisionType.XA, "xa_hiep_phuoc", 786)
    W_27664 = Ward("Thị trấn Cần Thạnh", 27664, VietNamDivisionType.THI_TRAN, "thi_tran_can_thanh", 787)
    W_27667 = Ward("Xã Bình Khánh", 27667, VietNamDivisionType.XA, "xa_binh_khanh", 787)
    W_27670 = Ward("Xã Tam Thôn Hiệp", 27670, VietNamDivisionType.XA, "xa_tam_thon_hiep", 787)
    W_27673 = Ward("Xã An Thới Đông", 27673, VietNamDivisionType.XA, "xa_an_thoi_dong", 787)
    W_27676 = Ward("Xã Thạnh An", 27676, VietNamDivisionType.XA, "xa_thanh_an", 787)
    W_27679 = Ward("Xã Long Hòa", 27679, VietNamDivisionType.XA, "xa_long_hoa", 787)
    W_27682 = Ward("Xã Lý Nhơn", 27682, VietNamDivisionType.XA, "xa_ly_nhon", 787)
    W_27685 = Ward("Phường 5", 27685, VietNamDivisionType.PHUONG, "phuong_5", 794)
    W_27688 = Ward("Phường 2", 27688, VietNamDivisionType.PHUONG, "phuong_2", 794)
    W_27691 = Ward("Phường 4", 27691, VietNamDivisionType.PHUONG, "phuong_4", 794)
    W_27692 = Ward("Phường Tân Khánh", 27692, VietNamDivisionType.PHUONG, "phuong_tan_khanh", 794)
    W_27694 = Ward("Phường 1", 27694, VietNamDivisionType.PHUONG, "phuong_1", 794)
    W_27697 = Ward("Phường 3", 27697, VietNamDivisionType.PHUONG, "phuong_3", 794)
    W_27698 = Ward("Phường 7", 27698, VietNamDivisionType.PHUONG, "phuong_7", 794)
    W_27700 = Ward("Phường 6", 27700, VietNamDivisionType.PHUONG, "phuong_6", 794)
    W_27703 = Ward("Xã Hướng Thọ Phú", 27703, VietNamDivisionType.XA, "xa_huong_tho_phu", 794)
    W_27706 = Ward("Xã Nhơn Thạnh Trung", 27706, VietNamDivisionType.XA, "xa_nhon_thanh_trung", 794)
    W_27709 = Ward("Xã Lợi Bình Nhơn", 27709, VietNamDivisionType.XA, "xa_loi_binh_nhon", 794)
    W_27712 = Ward("Xã Bình Tâm", 27712, VietNamDivisionType.XA, "xa_binh_tam", 794)
    W_27715 = Ward("Phường Khánh Hậu", 27715, VietNamDivisionType.PHUONG, "phuong_khanh_hau", 794)
    W_27718 = Ward("Xã An Vĩnh Ngãi", 27718, VietNamDivisionType.XA, "xa_an_vinh_ngai", 794)
    W_27787 = Ward("Phường 1", 27787, VietNamDivisionType.PHUONG, "phuong_1", 795)
    W_27788 = Ward("Phường 2", 27788, VietNamDivisionType.PHUONG, "phuong_2", 795)
    W_27790 = Ward("Xã Thạnh Trị", 27790, VietNamDivisionType.XA, "xa_thanh_tri", 795)
    W_27793 = Ward("Xã Bình Hiệp", 27793, VietNamDivisionType.XA, "xa_binh_hiep", 795)
    W_27799 = Ward("Xã Bình Tân", 27799, VietNamDivisionType.XA, "xa_binh_tan", 795)
    W_27805 = Ward("Xã Tuyên Thạnh", 27805, VietNamDivisionType.XA, "xa_tuyen_thanh", 795)
    W_27806 = Ward("Phường 3", 27806, VietNamDivisionType.PHUONG, "phuong_3", 795)
    W_27817 = Ward("Xã Thạnh Hưng", 27817, VietNamDivisionType.XA, "xa_thanh_hung", 795)
    W_27721 = Ward("Thị trấn Tân Hưng", 27721, VietNamDivisionType.THI_TRAN, "thi_tran_tan_hung", 796)
    W_27724 = Ward("Xã Hưng Hà", 27724, VietNamDivisionType.XA, "xa_hung_ha", 796)
    W_27727 = Ward("Xã Hưng Điền B", 27727, VietNamDivisionType.XA, "xa_hung_dien_b", 796)
    W_27730 = Ward("Xã Hưng Điền", 27730, VietNamDivisionType.XA, "xa_hung_dien", 796)
    W_27733 = Ward("Xã Thạnh Hưng", 27733, VietNamDivisionType.XA, "xa_thanh_hung", 796)
    W_27736 = Ward("Xã Hưng Thạnh", 27736, VietNamDivisionType.XA, "xa_hung_thanh", 796)
    W_27739 = Ward("Xã Vĩnh Thạnh", 27739, VietNamDivisionType.XA, "xa_vinh_thanh", 796)
    W_27742 = Ward("Xã Vĩnh Châu B", 27742, VietNamDivisionType.XA, "xa_vinh_chau_b", 796)
    W_27745 = Ward("Xã Vĩnh Lợi", 27745, VietNamDivisionType.XA, "xa_vinh_loi", 796)
    W_27748 = Ward("Xã Vĩnh Đại", 27748, VietNamDivisionType.XA, "xa_vinh_dai", 796)
    W_27751 = Ward("Xã Vĩnh Châu A", 27751, VietNamDivisionType.XA, "xa_vinh_chau_a", 796)
    W_27754 = Ward("Xã Vĩnh Bửu", 27754, VietNamDivisionType.XA, "xa_vinh_buu", 796)
    W_27757 = Ward("Thị trấn Vĩnh Hưng", 27757, VietNamDivisionType.THI_TRAN, "thi_tran_vinh_hung", 797)
    W_27760 = Ward("Xã Hưng Điền A", 27760, VietNamDivisionType.XA, "xa_hung_dien_a", 797)
    W_27763 = Ward("Xã Khánh Hưng", 27763, VietNamDivisionType.XA, "xa_khanh_hung", 797)
    W_27766 = Ward("Xã Thái Trị", 27766, VietNamDivisionType.XA, "xa_thai_tri", 797)
    W_27769 = Ward("Xã Vĩnh Trị", 27769, VietNamDivisionType.XA, "xa_vinh_tri", 797)
    W_27772 = Ward("Xã Thái Bình Trung", 27772, VietNamDivisionType.XA, "xa_thai_binh_trung", 797)
    W_27775 = Ward("Xã Vĩnh Bình", 27775, VietNamDivisionType.XA, "xa_vinh_binh", 797)
    W_27778 = Ward("Xã Vĩnh Thuận", 27778, VietNamDivisionType.XA, "xa_vinh_thuan", 797)
    W_27781 = Ward("Xã Tuyên Bình", 27781, VietNamDivisionType.XA, "xa_tuyen_binh", 797)
    W_27784 = Ward("Xã Tuyên Bình Tây", 27784, VietNamDivisionType.XA, "xa_tuyen_binh_tay", 797)
    W_27796 = Ward("Xã Bình Hòa Tây", 27796, VietNamDivisionType.XA, "xa_binh_hoa_tay", 798)
    W_27802 = Ward("Xã Bình Thạnh", 27802, VietNamDivisionType.XA, "xa_binh_thanh", 798)
    W_27808 = Ward("Xã Bình Hòa Trung", 27808, VietNamDivisionType.XA, "xa_binh_hoa_trung", 798)
    W_27811 = Ward("Xã Bình Hòa Đông", 27811, VietNamDivisionType.XA, "xa_binh_hoa_dong", 798)
    W_27814 = Ward("Thị trấn Bình Phong Thạnh", 27814, VietNamDivisionType.THI_TRAN, "thi_tran_binh_phong_thanh", 798)
    W_27820 = Ward("Xã Tân Lập", 27820, VietNamDivisionType.XA, "xa_tan_lap", 798)
    W_27823 = Ward("Xã Tân Thành", 27823, VietNamDivisionType.XA, "xa_tan_thanh", 798)
    W_27826 = Ward("Thị trấn Tân Thạnh", 27826, VietNamDivisionType.THI_TRAN, "thi_tran_tan_thanh", 799)
    W_27829 = Ward("Xã Bắc Hòa", 27829, VietNamDivisionType.XA, "xa_bac_hoa", 799)
    W_27832 = Ward("Xã Hậu Thạnh Tây", 27832, VietNamDivisionType.XA, "xa_hau_thanh_tay", 799)
    W_27835 = Ward("Xã Nhơn Hòa Lập", 27835, VietNamDivisionType.XA, "xa_nhon_hoa_lap", 799)
    W_27838 = Ward("Xã Tân Lập", 27838, VietNamDivisionType.XA, "xa_tan_lap", 799)
    W_27841 = Ward("Xã Hậu Thạnh Đông", 27841, VietNamDivisionType.XA, "xa_hau_thanh_dong", 799)
    W_27844 = Ward("Xã Nhơn Hoà", 27844, VietNamDivisionType.XA, "xa_nhon_hoa", 799)
    W_27847 = Ward("Xã Kiến Bình", 27847, VietNamDivisionType.XA, "xa_kien_binh", 799)
    W_27850 = Ward("Xã Tân Thành", 27850, VietNamDivisionType.XA, "xa_tan_thanh", 799)
    W_27853 = Ward("Xã Tân Bình", 27853, VietNamDivisionType.XA, "xa_tan_binh", 799)
    W_27856 = Ward("Xã Tân Ninh", 27856, VietNamDivisionType.XA, "xa_tan_ninh", 799)
    W_27859 = Ward("Xã Nhơn Ninh", 27859, VietNamDivisionType.XA, "xa_nhon_ninh", 799)
    W_27862 = Ward("Xã Tân Hòa", 27862, VietNamDivisionType.XA, "xa_tan_hoa", 799)
    W_27865 = Ward("Thị trấn Thạnh Hóa", 27865, VietNamDivisionType.THI_TRAN, "thi_tran_thanh_hoa", 800)
    W_27868 = Ward("Xã Tân Hiệp", 27868, VietNamDivisionType.XA, "xa_tan_hiep", 800)
    W_27871 = Ward("Xã Thuận Bình", 27871, VietNamDivisionType.XA, "xa_thuan_binh", 800)
    W_27874 = Ward("Xã Thạnh Phước", 27874, VietNamDivisionType.XA, "xa_thanh_phuoc", 800)
    W_27877 = Ward("Xã Thạnh Phú", 27877, VietNamDivisionType.XA, "xa_thanh_phu", 800)
    W_27880 = Ward("Xã Thuận Nghĩa Hòa", 27880, VietNamDivisionType.XA, "xa_thuan_nghia_hoa", 800)
    W_27883 = Ward("Xã Thủy Đông", 27883, VietNamDivisionType.XA, "xa_thuy_dong", 800)
    W_27886 = Ward("Xã Thủy Tây", 27886, VietNamDivisionType.XA, "xa_thuy_tay", 800)
    W_27889 = Ward("Xã Tân Tây", 27889, VietNamDivisionType.XA, "xa_tan_tay", 800)
    W_27892 = Ward("Xã Tân Đông", 27892, VietNamDivisionType.XA, "xa_tan_dong", 800)
    W_27895 = Ward("Xã Thạnh An", 27895, VietNamDivisionType.XA, "xa_thanh_an", 800)
    W_27898 = Ward("Thị trấn Đông Thành", 27898, VietNamDivisionType.THI_TRAN, "thi_tran_dong_thanh", 801)
    W_27901 = Ward("Xã Mỹ Quý Đông", 27901, VietNamDivisionType.XA, "xa_my_quy_dong", 801)
    W_27904 = Ward("Xã Mỹ Thạnh Bắc", 27904, VietNamDivisionType.XA, "xa_my_thanh_bac", 801)
    W_27907 = Ward("Xã Mỹ Quý Tây", 27907, VietNamDivisionType.XA, "xa_my_quy_tay", 801)
    W_27910 = Ward("Xã Mỹ Thạnh Tây", 27910, VietNamDivisionType.XA, "xa_my_thanh_tay", 801)
    W_27913 = Ward("Xã Mỹ Thạnh Đông", 27913, VietNamDivisionType.XA, "xa_my_thanh_dong", 801)
    W_27916 = Ward("Xã Bình Thành", 27916, VietNamDivisionType.XA, "xa_binh_thanh", 801)
    W_27919 = Ward("Xã Bình Hòa Bắc", 27919, VietNamDivisionType.XA, "xa_binh_hoa_bac", 801)
    W_27922 = Ward("Xã Bình Hòa Hưng", 27922, VietNamDivisionType.XA, "xa_binh_hoa_hung", 801)
    W_27925 = Ward("Xã Bình Hòa Nam", 27925, VietNamDivisionType.XA, "xa_binh_hoa_nam", 801)
    W_27928 = Ward("Xã Mỹ Bình", 27928, VietNamDivisionType.XA, "xa_my_binh", 801)
    W_27931 = Ward("Thị trấn Hậu Nghĩa", 27931, VietNamDivisionType.THI_TRAN, "thi_tran_hau_nghia", 802)
    W_27934 = Ward("Thị trấn Hiệp Hòa", 27934, VietNamDivisionType.THI_TRAN, "thi_tran_hiep_hoa", 802)
    W_27937 = Ward("Thị trấn Đức Hòa", 27937, VietNamDivisionType.THI_TRAN, "thi_tran_duc_hoa", 802)
    W_27940 = Ward("Xã Lộc Giang", 27940, VietNamDivisionType.XA, "xa_loc_giang", 802)
    W_27943 = Ward("Xã An Ninh Đông", 27943, VietNamDivisionType.XA, "xa_an_ninh_dong", 802)
    W_27946 = Ward("Xã An Ninh Tây", 27946, VietNamDivisionType.XA, "xa_an_ninh_tay", 802)
    W_27949 = Ward("Xã Tân Mỹ", 27949, VietNamDivisionType.XA, "xa_tan_my", 802)
    W_27952 = Ward("Xã Hiệp Hòa", 27952, VietNamDivisionType.XA, "xa_hiep_hoa", 802)
    W_27955 = Ward("Xã Đức Lập Thượng", 27955, VietNamDivisionType.XA, "xa_duc_lap_thuong", 802)
    W_27958 = Ward("Xã Đức Lập Hạ", 27958, VietNamDivisionType.XA, "xa_duc_lap_ha", 802)
    W_27961 = Ward("Xã Tân Phú", 27961, VietNamDivisionType.XA, "xa_tan_phu", 802)
    W_27964 = Ward("Xã Mỹ Hạnh Bắc", 27964, VietNamDivisionType.XA, "xa_my_hanh_bac", 802)
    W_27967 = Ward("Xã Đức Hòa Thượng", 27967, VietNamDivisionType.XA, "xa_duc_hoa_thuong", 802)
    W_27970 = Ward("Xã Hòa Khánh Tây", 27970, VietNamDivisionType.XA, "xa_hoa_khanh_tay", 802)
    W_27973 = Ward("Xã Hòa Khánh Đông", 27973, VietNamDivisionType.XA, "xa_hoa_khanh_dong", 802)
    W_27976 = Ward("Xã Mỹ Hạnh Nam", 27976, VietNamDivisionType.XA, "xa_my_hanh_nam", 802)
    W_27979 = Ward("Xã Hòa Khánh Nam", 27979, VietNamDivisionType.XA, "xa_hoa_khanh_nam", 802)
    W_27982 = Ward("Xã Đức Hòa Đông", 27982, VietNamDivisionType.XA, "xa_duc_hoa_dong", 802)
    W_27985 = Ward("Xã Đức Hòa Hạ", 27985, VietNamDivisionType.XA, "xa_duc_hoa_ha", 802)
    W_27988 = Ward("Xã Hựu Thạnh", 27988, VietNamDivisionType.XA, "xa_huu_thanh", 802)
    W_27991 = Ward("Thị trấn Bến Lức", 27991, VietNamDivisionType.THI_TRAN, "thi_tran_ben_luc", 803)
    W_27994 = Ward("Xã Thạnh Lợi", 27994, VietNamDivisionType.XA, "xa_thanh_loi", 803)
    W_27997 = Ward("Xã Lương Bình", 27997, VietNamDivisionType.XA, "xa_luong_binh", 803)
    W_28000 = Ward("Xã Thạnh Hòa", 28000, VietNamDivisionType.XA, "xa_thanh_hoa", 803)
    W_28003 = Ward("Xã Lương Hòa", 28003, VietNamDivisionType.XA, "xa_luong_hoa", 803)
    W_28006 = Ward("Xã Tân Hòa", 28006, VietNamDivisionType.XA, "xa_tan_hoa", 803)
    W_28009 = Ward("Xã Tân Bửu", 28009, VietNamDivisionType.XA, "xa_tan_buu", 803)
    W_28012 = Ward("Xã An Thạnh", 28012, VietNamDivisionType.XA, "xa_an_thanh", 803)
    W_28015 = Ward("Xã Bình Đức", 28015, VietNamDivisionType.XA, "xa_binh_duc", 803)
    W_28018 = Ward("Xã Mỹ Yên", 28018, VietNamDivisionType.XA, "xa_my_yen", 803)
    W_28021 = Ward("Xã Thanh Phú", 28021, VietNamDivisionType.XA, "xa_thanh_phu", 803)
    W_28024 = Ward("Xã Long Hiệp", 28024, VietNamDivisionType.XA, "xa_long_hiep", 803)
    W_28027 = Ward("Xã Thạnh Đức", 28027, VietNamDivisionType.XA, "xa_thanh_duc", 803)
    W_28030 = Ward("Xã Phước Lợi", 28030, VietNamDivisionType.XA, "xa_phuoc_loi", 803)
    W_28033 = Ward("Xã Nhựt Chánh", 28033, VietNamDivisionType.XA, "xa_nhut_chanh", 803)
    W_28036 = Ward("Thị trấn Thủ Thừa", 28036, VietNamDivisionType.THI_TRAN, "thi_tran_thu_thua", 804)
    W_28039 = Ward("Xã Long Thạnh", 28039, VietNamDivisionType.XA, "xa_long_thanh", 804)
    W_28042 = Ward("Xã Tân Thành", 28042, VietNamDivisionType.XA, "xa_tan_thanh", 804)
    W_28045 = Ward("Xã Long Thuận", 28045, VietNamDivisionType.XA, "xa_long_thuan", 804)
    W_28048 = Ward("Xã Mỹ Lạc", 28048, VietNamDivisionType.XA, "xa_my_lac", 804)
    W_28051 = Ward("Xã Mỹ Thạnh", 28051, VietNamDivisionType.XA, "xa_my_thanh", 804)
    W_28054 = Ward("Xã Bình An", 28054, VietNamDivisionType.XA, "xa_binh_an", 804)
    W_28057 = Ward("Xã Nhị Thành", 28057, VietNamDivisionType.XA, "xa_nhi_thanh", 804)
    W_28060 = Ward("Xã Mỹ An", 28060, VietNamDivisionType.XA, "xa_my_an", 804)
    W_28063 = Ward("Xã Bình Thạnh", 28063, VietNamDivisionType.XA, "xa_binh_thanh", 804)
    W_28066 = Ward("Xã Mỹ Phú", 28066, VietNamDivisionType.XA, "xa_my_phu", 804)
    W_28072 = Ward("Xã Tân Long", 28072, VietNamDivisionType.XA, "xa_tan_long", 804)
    W_28075 = Ward("Thị trấn Tân Trụ", 28075, VietNamDivisionType.THI_TRAN, "thi_tran_tan_tru", 805)
    W_28078 = Ward("Xã Tân Bình", 28078, VietNamDivisionType.XA, "xa_tan_binh", 805)
    W_28084 = Ward("Xã Quê Mỹ Thạnh", 28084, VietNamDivisionType.XA, "xa_que_my_thanh", 805)
    W_28087 = Ward("Xã Lạc Tấn", 28087, VietNamDivisionType.XA, "xa_lac_tan", 805)
    W_28090 = Ward("Xã Bình Trinh Đông", 28090, VietNamDivisionType.XA, "xa_binh_trinh_dong", 805)
    W_28093 = Ward("Xã Tân Phước Tây", 28093, VietNamDivisionType.XA, "xa_tan_phuoc_tay", 805)
    W_28096 = Ward("Xã Bình Lãng", 28096, VietNamDivisionType.XA, "xa_binh_lang", 805)
    W_28099 = Ward("Xã Bình Tịnh", 28099, VietNamDivisionType.XA, "xa_binh_tinh", 805)
    W_28102 = Ward("Xã Đức Tân", 28102, VietNamDivisionType.XA, "xa_duc_tan", 805)
    W_28105 = Ward("Xã Nhựt Ninh", 28105, VietNamDivisionType.XA, "xa_nhut_ninh", 805)
    W_28108 = Ward("Thị trấn Cần Đước", 28108, VietNamDivisionType.THI_TRAN, "thi_tran_can_duoc", 806)
    W_28111 = Ward("Xã Long Trạch", 28111, VietNamDivisionType.XA, "xa_long_trach", 806)
    W_28114 = Ward("Xã Long Khê", 28114, VietNamDivisionType.XA, "xa_long_khe", 806)
    W_28117 = Ward("Xã Long Định", 28117, VietNamDivisionType.XA, "xa_long_dinh", 806)
    W_28120 = Ward("Xã Phước Vân", 28120, VietNamDivisionType.XA, "xa_phuoc_van", 806)
    W_28123 = Ward("Xã Long Hòa", 28123, VietNamDivisionType.XA, "xa_long_hoa", 806)
    W_28126 = Ward("Xã Long Cang", 28126, VietNamDivisionType.XA, "xa_long_cang", 806)
    W_28129 = Ward("Xã Long Sơn", 28129, VietNamDivisionType.XA, "xa_long_son", 806)
    W_28132 = Ward("Xã Tân Trạch", 28132, VietNamDivisionType.XA, "xa_tan_trach", 806)
    W_28135 = Ward("Xã Mỹ Lệ", 28135, VietNamDivisionType.XA, "xa_my_le", 806)
    W_28138 = Ward("Xã Tân Lân", 28138, VietNamDivisionType.XA, "xa_tan_lan", 806)
    W_28141 = Ward("Xã Phước Tuy", 28141, VietNamDivisionType.XA, "xa_phuoc_tuy", 806)
    W_28144 = Ward("Xã Long Hựu Đông", 28144, VietNamDivisionType.XA, "xa_long_huu_dong", 806)
    W_28147 = Ward("Xã Tân Ân", 28147, VietNamDivisionType.XA, "xa_tan_an", 806)
    W_28150 = Ward("Xã Phước Đông", 28150, VietNamDivisionType.XA, "xa_phuoc_dong", 806)
    W_28153 = Ward("Xã Long Hựu Tây", 28153, VietNamDivisionType.XA, "xa_long_huu_tay", 806)
    W_28156 = Ward("Xã Tân Chánh", 28156, VietNamDivisionType.XA, "xa_tan_chanh", 806)
    W_28159 = Ward("Thị trấn Cần Giuộc", 28159, VietNamDivisionType.THI_TRAN, "thi_tran_can_giuoc", 807)
    W_28162 = Ward("Xã Phước Lý", 28162, VietNamDivisionType.XA, "xa_phuoc_ly", 807)
    W_28165 = Ward("Xã Long Thượng", 28165, VietNamDivisionType.XA, "xa_long_thuong", 807)
    W_28168 = Ward("Xã Long Hậu", 28168, VietNamDivisionType.XA, "xa_long_hau", 807)
    W_28174 = Ward("Xã Phước Hậu", 28174, VietNamDivisionType.XA, "xa_phuoc_hau", 807)
    W_28177 = Ward("Xã Mỹ Lộc", 28177, VietNamDivisionType.XA, "xa_my_loc", 807)
    W_28180 = Ward("Xã Phước Lại", 28180, VietNamDivisionType.XA, "xa_phuoc_lai", 807)
    W_28183 = Ward("Xã Phước Lâm", 28183, VietNamDivisionType.XA, "xa_phuoc_lam", 807)
    W_28189 = Ward("Xã Thuận Thành", 28189, VietNamDivisionType.XA, "xa_thuan_thanh", 807)
    W_28192 = Ward("Xã Phước Vĩnh Tây", 28192, VietNamDivisionType.XA, "xa_phuoc_vinh_tay", 807)
    W_28195 = Ward("Xã Phước Vĩnh Đông", 28195, VietNamDivisionType.XA, "xa_phuoc_vinh_dong", 807)
    W_28198 = Ward("Xã Long An", 28198, VietNamDivisionType.XA, "xa_long_an", 807)
    W_28201 = Ward("Xã Long Phụng", 28201, VietNamDivisionType.XA, "xa_long_phung", 807)
    W_28204 = Ward("Xã Đông Thạnh", 28204, VietNamDivisionType.XA, "xa_dong_thanh", 807)
    W_28207 = Ward("Xã Tân Tập", 28207, VietNamDivisionType.XA, "xa_tan_tap", 807)
    W_28210 = Ward("Thị trấn Tầm Vu", 28210, VietNamDivisionType.THI_TRAN, "thi_tran_tam_vu", 808)
    W_28213 = Ward("Xã Bình Quới", 28213, VietNamDivisionType.XA, "xa_binh_quoi", 808)
    W_28216 = Ward("Xã Hòa Phú", 28216, VietNamDivisionType.XA, "xa_hoa_phu", 808)
    W_28219 = Ward("Xã Phú Ngãi Trị", 28219, VietNamDivisionType.XA, "xa_phu_ngai_tri", 808)
    W_28222 = Ward("Xã Vĩnh Công", 28222, VietNamDivisionType.XA, "xa_vinh_cong", 808)
    W_28225 = Ward("Xã Thuận Mỹ", 28225, VietNamDivisionType.XA, "xa_thuan_my", 808)
    W_28228 = Ward("Xã Hiệp Thạnh", 28228, VietNamDivisionType.XA, "xa_hiep_thanh", 808)
    W_28231 = Ward("Xã Phước Tân Hưng", 28231, VietNamDivisionType.XA, "xa_phuoc_tan_hung", 808)
    W_28234 = Ward("Xã Thanh Phú Long", 28234, VietNamDivisionType.XA, "xa_thanh_phu_long", 808)
    W_28237 = Ward("Xã Dương Xuân Hội", 28237, VietNamDivisionType.XA, "xa_duong_xuan_hoi", 808)
    W_28240 = Ward("Xã An Lục Long", 28240, VietNamDivisionType.XA, "xa_an_luc_long", 808)
    W_28243 = Ward("Xã Long Trì", 28243, VietNamDivisionType.XA, "xa_long_tri", 808)
    W_28246 = Ward("Xã Thanh Vĩnh Đông", 28246, VietNamDivisionType.XA, "xa_thanh_vinh_dong", 808)
    W_28249 = Ward("Phường 5", 28249, VietNamDivisionType.PHUONG, "phuong_5", 815)
    W_28252 = Ward("Phường 4", 28252, VietNamDivisionType.PHUONG, "phuong_4", 815)
    W_28255 = Ward("Phường 7", 28255, VietNamDivisionType.PHUONG, "phuong_7", 815)
    W_28258 = Ward("Phường 3", 28258, VietNamDivisionType.PHUONG, "phuong_3", 815)
    W_28261 = Ward("Phường 1", 28261, VietNamDivisionType.PHUONG, "phuong_1", 815)
    W_28264 = Ward("Phường 2", 28264, VietNamDivisionType.PHUONG, "phuong_2", 815)
    W_28267 = Ward("Phường 8", 28267, VietNamDivisionType.PHUONG, "phuong_8", 815)
    W_28270 = Ward("Phường 6", 28270, VietNamDivisionType.PHUONG, "phuong_6", 815)
    W_28273 = Ward("Phường 9", 28273, VietNamDivisionType.PHUONG, "phuong_9", 815)
    W_28276 = Ward("Phường 10", 28276, VietNamDivisionType.PHUONG, "phuong_10", 815)
    W_28279 = Ward("Phường Tân Long", 28279, VietNamDivisionType.PHUONG, "phuong_tan_long", 815)
    W_28282 = Ward("Xã Đạo Thạnh", 28282, VietNamDivisionType.XA, "xa_dao_thanh", 815)
    W_28285 = Ward("Xã Trung An", 28285, VietNamDivisionType.XA, "xa_trung_an", 815)
    W_28288 = Ward("Xã Mỹ Phong", 28288, VietNamDivisionType.XA, "xa_my_phong", 815)
    W_28291 = Ward("Xã Tân Mỹ Chánh", 28291, VietNamDivisionType.XA, "xa_tan_my_chanh", 815)
    W_28567 = Ward("Xã Phước Thạnh", 28567, VietNamDivisionType.XA, "xa_phuoc_thanh", 815)
    W_28591 = Ward("Xã Thới Sơn", 28591, VietNamDivisionType.XA, "xa_thoi_son", 815)
    W_28294 = Ward("Phường 3", 28294, VietNamDivisionType.PHUONG, "phuong_3", 816)
    W_28297 = Ward("Phường 2", 28297, VietNamDivisionType.PHUONG, "phuong_2", 816)
    W_28300 = Ward("Phường 4", 28300, VietNamDivisionType.PHUONG, "phuong_4", 816)
    W_28303 = Ward("Phường 1", 28303, VietNamDivisionType.PHUONG, "phuong_1", 816)
    W_28306 = Ward("Phường 5", 28306, VietNamDivisionType.PHUONG, "phuong_5", 816)
    W_28309 = Ward("Xã Long Hưng", 28309, VietNamDivisionType.XA, "xa_long_hung", 816)
    W_28312 = Ward("Xã Long Thuận", 28312, VietNamDivisionType.XA, "xa_long_thuan", 816)
    W_28315 = Ward("Xã Long Chánh", 28315, VietNamDivisionType.XA, "xa_long_chanh", 816)
    W_28318 = Ward("Xã Long Hòa", 28318, VietNamDivisionType.XA, "xa_long_hoa", 816)
    W_28708 = Ward("Xã Bình Đông", 28708, VietNamDivisionType.XA, "xa_binh_dong", 816)
    W_28717 = Ward("Xã Bình Xuân", 28717, VietNamDivisionType.XA, "xa_binh_xuan", 816)
    W_28729 = Ward("Xã Tân Trung", 28729, VietNamDivisionType.XA, "xa_tan_trung", 816)
    W_28435 = Ward("Phường 1", 28435, VietNamDivisionType.PHUONG, "phuong_1", 817)
    W_28436 = Ward("Phường 2", 28436, VietNamDivisionType.PHUONG, "phuong_2", 817)
    W_28437 = Ward("Phường 3", 28437, VietNamDivisionType.PHUONG, "phuong_3", 817)
    W_28439 = Ward("Phường 4", 28439, VietNamDivisionType.PHUONG, "phuong_4", 817)
    W_28440 = Ward("Phường 5", 28440, VietNamDivisionType.PHUONG, "phuong_5", 817)
    W_28447 = Ward("Xã Mỹ Phước Tây", 28447, VietNamDivisionType.XA, "xa_my_phuoc_tay", 817)
    W_28450 = Ward("Xã Mỹ Hạnh Đông", 28450, VietNamDivisionType.XA, "xa_my_hanh_dong", 817)
    W_28453 = Ward("Xã Mỹ Hạnh Trung", 28453, VietNamDivisionType.XA, "xa_my_hanh_trung", 817)
    W_28459 = Ward("Xã Tân Phú", 28459, VietNamDivisionType.XA, "xa_tan_phu", 817)
    W_28462 = Ward("Xã Tân Bình", 28462, VietNamDivisionType.XA, "xa_tan_binh", 817)
    W_28468 = Ward("Xã Tân Hội", 28468, VietNamDivisionType.XA, "xa_tan_hoi", 817)
    W_28474 = Ward("Phường Nhị Mỹ", 28474, VietNamDivisionType.PHUONG, "phuong_nhi_my", 817)
    W_28477 = Ward("Xã Nhị Quý", 28477, VietNamDivisionType.XA, "xa_nhi_quy", 817)
    W_28480 = Ward("Xã Thanh Hòa", 28480, VietNamDivisionType.XA, "xa_thanh_hoa", 817)
    W_28483 = Ward("Xã Phú Quý", 28483, VietNamDivisionType.XA, "xa_phu_quy", 817)
    W_28486 = Ward("Xã Long Khánh", 28486, VietNamDivisionType.XA, "xa_long_khanh", 817)
    W_28321 = Ward("Thị trấn Mỹ Phước", 28321, VietNamDivisionType.THI_TRAN, "thi_tran_my_phuoc", 818)
    W_28324 = Ward("Xã Tân Hòa Đông", 28324, VietNamDivisionType.XA, "xa_tan_hoa_dong", 818)
    W_28327 = Ward("Xã Thạnh Tân", 28327, VietNamDivisionType.XA, "xa_thanh_tan", 818)
    W_28330 = Ward("Xã Thạnh Mỹ", 28330, VietNamDivisionType.XA, "xa_thanh_my", 818)
    W_28333 = Ward("Xã Thạnh Hoà", 28333, VietNamDivisionType.XA, "xa_thanh_hoa", 818)
    W_28336 = Ward("Xã Phú Mỹ", 28336, VietNamDivisionType.XA, "xa_phu_my", 818)
    W_28339 = Ward("Xã Tân Hòa Thành", 28339, VietNamDivisionType.XA, "xa_tan_hoa_thanh", 818)
    W_28342 = Ward("Xã Hưng Thạnh", 28342, VietNamDivisionType.XA, "xa_hung_thanh", 818)
    W_28345 = Ward("Xã Tân Lập 1", 28345, VietNamDivisionType.XA, "xa_tan_lap_1", 818)
    W_28348 = Ward("Xã Tân Hòa Tây", 28348, VietNamDivisionType.XA, "xa_tan_hoa_tay", 818)
    W_28354 = Ward("Xã Tân Lập 2", 28354, VietNamDivisionType.XA, "xa_tan_lap_2", 818)
    W_28357 = Ward("Xã Phước Lập", 28357, VietNamDivisionType.XA, "xa_phuoc_lap", 818)
    W_28360 = Ward("Thị trấn Cái Bè", 28360, VietNamDivisionType.THI_TRAN, "thi_tran_cai_be", 819)
    W_28363 = Ward("Xã Hậu Mỹ Bắc B", 28363, VietNamDivisionType.XA, "xa_hau_my_bac_b", 819)
    W_28366 = Ward("Xã Hậu Mỹ Bắc A", 28366, VietNamDivisionType.XA, "xa_hau_my_bac_a", 819)
    W_28369 = Ward("Xã Mỹ Trung", 28369, VietNamDivisionType.XA, "xa_my_trung", 819)
    W_28372 = Ward("Xã Hậu Mỹ Trinh", 28372, VietNamDivisionType.XA, "xa_hau_my_trinh", 819)
    W_28375 = Ward("Xã Hậu Mỹ Phú", 28375, VietNamDivisionType.XA, "xa_hau_my_phu", 819)
    W_28378 = Ward("Xã Mỹ Tân", 28378, VietNamDivisionType.XA, "xa_my_tan", 819)
    W_28381 = Ward("Xã Mỹ Lợi B", 28381, VietNamDivisionType.XA, "xa_my_loi_b", 819)
    W_28384 = Ward("Xã Thiện Trung", 28384, VietNamDivisionType.XA, "xa_thien_trung", 819)
    W_28387 = Ward("Xã Mỹ Hội", 28387, VietNamDivisionType.XA, "xa_my_hoi", 819)
    W_28390 = Ward("Xã An Cư", 28390, VietNamDivisionType.XA, "xa_an_cu", 819)
    W_28393 = Ward("Xã Hậu Thành", 28393, VietNamDivisionType.XA, "xa_hau_thanh", 819)
    W_28396 = Ward("Xã Mỹ Lợi A", 28396, VietNamDivisionType.XA, "xa_my_loi_a", 819)
    W_28399 = Ward("Xã Hòa Khánh", 28399, VietNamDivisionType.XA, "xa_hoa_khanh", 819)
    W_28402 = Ward("Xã Thiện Trí", 28402, VietNamDivisionType.XA, "xa_thien_tri", 819)
    W_28405 = Ward("Xã Mỹ Đức Đông", 28405, VietNamDivisionType.XA, "xa_my_duc_dong", 819)
    W_28408 = Ward("Xã Mỹ Đức Tây", 28408, VietNamDivisionType.XA, "xa_my_duc_tay", 819)
    W_28411 = Ward("Xã Đông Hòa Hiệp", 28411, VietNamDivisionType.XA, "xa_dong_hoa_hiep", 819)
    W_28414 = Ward("Xã An Thái Đông", 28414, VietNamDivisionType.XA, "xa_an_thai_dong", 819)
    W_28417 = Ward("Xã Tân Hưng", 28417, VietNamDivisionType.XA, "xa_tan_hung", 819)
    W_28420 = Ward("Xã Mỹ Lương", 28420, VietNamDivisionType.XA, "xa_my_luong", 819)
    W_28423 = Ward("Xã Tân Thanh", 28423, VietNamDivisionType.XA, "xa_tan_thanh", 819)
    W_28426 = Ward("Xã An Thái Trung", 28426, VietNamDivisionType.XA, "xa_an_thai_trung", 819)
    W_28429 = Ward("Xã An Hữu", 28429, VietNamDivisionType.XA, "xa_an_huu", 819)
    W_28432 = Ward("Xã Hòa Hưng", 28432, VietNamDivisionType.XA, "xa_hoa_hung", 819)
    W_28438 = Ward("Xã Thạnh Lộc", 28438, VietNamDivisionType.XA, "xa_thanh_loc", 820)
    W_28441 = Ward("Xã Mỹ Thành Bắc", 28441, VietNamDivisionType.XA, "xa_my_thanh_bac", 820)
    W_28444 = Ward("Xã Phú Cường", 28444, VietNamDivisionType.XA, "xa_phu_cuong", 820)
    W_28456 = Ward("Xã Mỹ Thành Nam", 28456, VietNamDivisionType.XA, "xa_my_thanh_nam", 820)
    W_28465 = Ward("Xã Phú Nhuận", 28465, VietNamDivisionType.XA, "xa_phu_nhuan", 820)
    W_28471 = Ward("Xã Bình Phú", 28471, VietNamDivisionType.XA, "xa_binh_phu", 820)
    W_28489 = Ward("Xã Cẩm Sơn", 28489, VietNamDivisionType.XA, "xa_cam_son", 820)
    W_28492 = Ward("Xã Phú An", 28492, VietNamDivisionType.XA, "xa_phu_an", 820)
    W_28495 = Ward("Xã Mỹ Long", 28495, VietNamDivisionType.XA, "xa_my_long", 820)
    W_28498 = Ward("Xã Long Tiên", 28498, VietNamDivisionType.XA, "xa_long_tien", 820)
    W_28501 = Ward("Xã Hiệp Đức", 28501, VietNamDivisionType.XA, "xa_hiep_duc", 820)
    W_28504 = Ward("Xã Long Trung", 28504, VietNamDivisionType.XA, "xa_long_trung", 820)
    W_28507 = Ward("Xã Hội Xuân", 28507, VietNamDivisionType.XA, "xa_hoi_xuan", 820)
    W_28510 = Ward("Xã Tân Phong", 28510, VietNamDivisionType.XA, "xa_tan_phong", 820)
    W_28513 = Ward("Xã Tam Bình", 28513, VietNamDivisionType.XA, "xa_tam_binh", 820)
    W_28516 = Ward("Xã Ngũ Hiệp", 28516, VietNamDivisionType.XA, "xa_ngu_hiep", 820)
    W_28519 = Ward("Thị trấn Tân Hiệp", 28519, VietNamDivisionType.THI_TRAN, "thi_tran_tan_hiep", 821)
    W_28522 = Ward("Xã Tân Hội Đông", 28522, VietNamDivisionType.XA, "xa_tan_hoi_dong", 821)
    W_28525 = Ward("Xã Tân Hương", 28525, VietNamDivisionType.XA, "xa_tan_huong", 821)
    W_28528 = Ward("Xã Tân Lý Đông", 28528, VietNamDivisionType.XA, "xa_tan_ly_dong", 821)
    W_28531 = Ward("Xã Tân Lý Tây", 28531, VietNamDivisionType.XA, "xa_tan_ly_tay", 821)
    W_28534 = Ward("Xã Thân Cửu Nghĩa", 28534, VietNamDivisionType.XA, "xa_than_cuu_nghia", 821)
    W_28537 = Ward("Xã Tam Hiệp", 28537, VietNamDivisionType.XA, "xa_tam_hiep", 821)
    W_28540 = Ward("Xã Điềm Hy", 28540, VietNamDivisionType.XA, "xa_diem_hy", 821)
    W_28543 = Ward("Xã Nhị Bình", 28543, VietNamDivisionType.XA, "xa_nhi_binh", 821)
    W_28546 = Ward("Xã Dưỡng Điềm", 28546, VietNamDivisionType.XA, "xa_duong_diem", 821)
    W_28549 = Ward("Xã Đông Hòa", 28549, VietNamDivisionType.XA, "xa_dong_hoa", 821)
    W_28552 = Ward("Xã Long Định", 28552, VietNamDivisionType.XA, "xa_long_dinh", 821)
    W_28555 = Ward("Xã Hữu Đạo", 28555, VietNamDivisionType.XA, "xa_huu_dao", 821)
    W_28558 = Ward("Xã Long An", 28558, VietNamDivisionType.XA, "xa_long_an", 821)
    W_28561 = Ward("Xã Long Hưng", 28561, VietNamDivisionType.XA, "xa_long_hung", 821)
    W_28564 = Ward("Xã Bình Trưng", 28564, VietNamDivisionType.XA, "xa_binh_trung", 821)
    W_28570 = Ward("Xã Thạnh Phú", 28570, VietNamDivisionType.XA, "xa_thanh_phu", 821)
    W_28573 = Ward("Xã Bàn Long", 28573, VietNamDivisionType.XA, "xa_ban_long", 821)
    W_28576 = Ward("Xã Vĩnh Kim", 28576, VietNamDivisionType.XA, "xa_vinh_kim", 821)
    W_28579 = Ward("Xã Bình Đức", 28579, VietNamDivisionType.XA, "xa_binh_duc", 821)
    W_28582 = Ward("Xã Song Thuận", 28582, VietNamDivisionType.XA, "xa_song_thuan", 821)
    W_28585 = Ward("Xã Kim Sơn", 28585, VietNamDivisionType.XA, "xa_kim_son", 821)
    W_28588 = Ward("Xã Phú Phong", 28588, VietNamDivisionType.XA, "xa_phu_phong", 821)
    W_28594 = Ward("Thị trấn Chợ Gạo", 28594, VietNamDivisionType.THI_TRAN, "thi_tran_cho_gao", 822)
    W_28597 = Ward("Xã Trung Hòa", 28597, VietNamDivisionType.XA, "xa_trung_hoa", 822)
    W_28600 = Ward("Xã Hòa Tịnh", 28600, VietNamDivisionType.XA, "xa_hoa_tinh", 822)
    W_28603 = Ward("Xã Mỹ Tịnh An", 28603, VietNamDivisionType.XA, "xa_my_tinh_an", 822)
    W_28606 = Ward("Xã Tân Bình Thạnh", 28606, VietNamDivisionType.XA, "xa_tan_binh_thanh", 822)
    W_28609 = Ward("Xã Phú Kiết", 28609, VietNamDivisionType.XA, "xa_phu_kiet", 822)
    W_28612 = Ward("Xã Lương Hòa Lạc", 28612, VietNamDivisionType.XA, "xa_luong_hoa_lac", 822)
    W_28615 = Ward("Xã Thanh Bình", 28615, VietNamDivisionType.XA, "xa_thanh_binh", 822)
    W_28618 = Ward("Xã Quơn Long", 28618, VietNamDivisionType.XA, "xa_quon_long", 822)
    W_28621 = Ward("Xã Bình Phục Nhứt", 28621, VietNamDivisionType.XA, "xa_binh_phuc_nhut", 822)
    W_28624 = Ward("Xã Đăng Hưng Phước", 28624, VietNamDivisionType.XA, "xa_dang_hung_phuoc", 822)
    W_28627 = Ward("Xã Tân Thuận Bình", 28627, VietNamDivisionType.XA, "xa_tan_thuan_binh", 822)
    W_28630 = Ward("Xã Song Bình", 28630, VietNamDivisionType.XA, "xa_song_binh", 822)
    W_28633 = Ward("Xã Bình Phan", 28633, VietNamDivisionType.XA, "xa_binh_phan", 822)
    W_28636 = Ward("Xã Long Bình Điền", 28636, VietNamDivisionType.XA, "xa_long_binh_dien", 822)
    W_28639 = Ward("Xã An Thạnh Thủy", 28639, VietNamDivisionType.XA, "xa_an_thanh_thuy", 822)
    W_28642 = Ward("Xã Xuân Đông", 28642, VietNamDivisionType.XA, "xa_xuan_dong", 822)
    W_28645 = Ward("Xã Hòa Định", 28645, VietNamDivisionType.XA, "xa_hoa_dinh", 822)
    W_28648 = Ward("Xã Bình Ninh", 28648, VietNamDivisionType.XA, "xa_binh_ninh", 822)
    W_28651 = Ward("Thị trấn Vĩnh Bình", 28651, VietNamDivisionType.THI_TRAN, "thi_tran_vinh_binh", 823)
    W_28654 = Ward("Xã Đồng Sơn", 28654, VietNamDivisionType.XA, "xa_dong_son", 823)
    W_28657 = Ward("Xã Bình Phú", 28657, VietNamDivisionType.XA, "xa_binh_phu", 823)
    W_28660 = Ward("Xã Đồng Thạnh", 28660, VietNamDivisionType.XA, "xa_dong_thanh", 823)
    W_28663 = Ward("Xã Thành Công", 28663, VietNamDivisionType.XA, "xa_thanh_cong", 823)
    W_28666 = Ward("Xã Bình Nhì", 28666, VietNamDivisionType.XA, "xa_binh_nhi", 823)
    W_28669 = Ward("Xã Yên Luông", 28669, VietNamDivisionType.XA, "xa_yen_luong", 823)
    W_28672 = Ward("Xã Thạnh Trị", 28672, VietNamDivisionType.XA, "xa_thanh_tri", 823)
    W_28675 = Ward("Xã Thạnh Nhựt", 28675, VietNamDivisionType.XA, "xa_thanh_nhut", 823)
    W_28678 = Ward("Xã Long Vĩnh", 28678, VietNamDivisionType.XA, "xa_long_vinh", 823)
    W_28681 = Ward("Xã Bình Tân", 28681, VietNamDivisionType.XA, "xa_binh_tan", 823)
    W_28684 = Ward("Xã Vĩnh Hựu", 28684, VietNamDivisionType.XA, "xa_vinh_huu", 823)
    W_28687 = Ward("Xã Long Bình", 28687, VietNamDivisionType.XA, "xa_long_binh", 823)
    W_28702 = Ward("Thị trấn Tân Hòa", 28702, VietNamDivisionType.THI_TRAN, "thi_tran_tan_hoa", 824)
    W_28705 = Ward("Xã Tăng Hoà", 28705, VietNamDivisionType.XA, "xa_tang_hoa", 824)
    W_28711 = Ward("Xã Tân Phước", 28711, VietNamDivisionType.XA, "xa_tan_phuoc", 824)
    W_28714 = Ward("Xã Gia Thuận", 28714, VietNamDivisionType.XA, "xa_gia_thuan", 824)
    W_28720 = Ward("Thị trấn Vàm Láng", 28720, VietNamDivisionType.THI_TRAN, "thi_tran_vam_lang", 824)
    W_28723 = Ward("Xã Tân Tây", 28723, VietNamDivisionType.XA, "xa_tan_tay", 824)
    W_28726 = Ward("Xã Kiểng Phước", 28726, VietNamDivisionType.XA, "xa_kieng_phuoc", 824)
    W_28732 = Ward("Xã Tân Đông", 28732, VietNamDivisionType.XA, "xa_tan_dong", 824)
    W_28735 = Ward("Xã Bình Ân", 28735, VietNamDivisionType.XA, "xa_binh_an", 824)
    W_28738 = Ward("Xã Tân Điền", 28738, VietNamDivisionType.XA, "xa_tan_dien", 824)
    W_28741 = Ward("Xã Bình Nghị", 28741, VietNamDivisionType.XA, "xa_binh_nghi", 824)
    W_28744 = Ward("Xã Phước Trung", 28744, VietNamDivisionType.XA, "xa_phuoc_trung", 824)
    W_28747 = Ward("Xã Tân Thành", 28747, VietNamDivisionType.XA, "xa_tan_thanh", 824)
    W_28690 = Ward("Xã Tân Thới", 28690, VietNamDivisionType.XA, "xa_tan_thoi", 825)
    W_28693 = Ward("Xã Tân Phú", 28693, VietNamDivisionType.XA, "xa_tan_phu", 825)
    W_28696 = Ward("Xã Phú Thạnh", 28696, VietNamDivisionType.XA, "xa_phu_thanh", 825)
    W_28699 = Ward("Xã Tân Thạnh", 28699, VietNamDivisionType.XA, "xa_tan_thanh", 825)
    W_28750 = Ward("Xã Phú Đông", 28750, VietNamDivisionType.XA, "xa_phu_dong", 825)
    W_28753 = Ward("Xã Phú Tân", 28753, VietNamDivisionType.XA, "xa_phu_tan", 825)
    W_28756 = Ward("Phường Phú Khương", 28756, VietNamDivisionType.PHUONG, "phuong_phu_khuong", 829)
    W_28757 = Ward("Phường Phú Tân", 28757, VietNamDivisionType.PHUONG, "phuong_phu_tan", 829)
    W_28759 = Ward("Phường 8", 28759, VietNamDivisionType.PHUONG, "phuong_8", 829)
    W_28762 = Ward("Phường 6", 28762, VietNamDivisionType.PHUONG, "phuong_6", 829)
    W_28765 = Ward("Phường 4", 28765, VietNamDivisionType.PHUONG, "phuong_4", 829)
    W_28768 = Ward("Phường 5", 28768, VietNamDivisionType.PHUONG, "phuong_5", 829)
    W_28777 = Ward("Phường An Hội", 28777, VietNamDivisionType.PHUONG, "phuong_an_hoi", 829)
    W_28780 = Ward("Phường 7", 28780, VietNamDivisionType.PHUONG, "phuong_7", 829)
    W_28783 = Ward("Xã Sơn Đông", 28783, VietNamDivisionType.XA, "xa_son_dong", 829)
    W_28786 = Ward("Xã Phú Hưng", 28786, VietNamDivisionType.XA, "xa_phu_hung", 829)
    W_28789 = Ward("Xã Bình Phú", 28789, VietNamDivisionType.XA, "xa_binh_phu", 829)
    W_28792 = Ward("Xã Mỹ Thạnh An", 28792, VietNamDivisionType.XA, "xa_my_thanh_an", 829)
    W_28795 = Ward("Xã Nhơn Thạnh", 28795, VietNamDivisionType.XA, "xa_nhon_thanh", 829)
    W_28798 = Ward("Xã Phú Nhuận", 28798, VietNamDivisionType.XA, "xa_phu_nhuan", 829)
    W_28801 = Ward("Thị trấn Châu Thành", 28801, VietNamDivisionType.THI_TRAN, "thi_tran_chau_thanh", 831)
    W_28804 = Ward("Xã Tân Thạch", 28804, VietNamDivisionType.XA, "xa_tan_thach", 831)
    W_28807 = Ward("Xã Qưới Sơn", 28807, VietNamDivisionType.XA, "xa_quoi_son", 831)
    W_28810 = Ward("Xã An Khánh", 28810, VietNamDivisionType.XA, "xa_an_khanh", 831)
    W_28813 = Ward("Xã Giao Long", 28813, VietNamDivisionType.XA, "xa_giao_long", 831)
    W_28819 = Ward("Xã Phú Túc", 28819, VietNamDivisionType.XA, "xa_phu_tuc", 831)
    W_28822 = Ward("Xã Phú Đức", 28822, VietNamDivisionType.XA, "xa_phu_duc", 831)
    W_28825 = Ward("Xã Phú An Hòa", 28825, VietNamDivisionType.XA, "xa_phu_an_hoa", 831)
    W_28828 = Ward("Xã An Phước", 28828, VietNamDivisionType.XA, "xa_an_phuoc", 831)
    W_28831 = Ward("Xã Tam Phước", 28831, VietNamDivisionType.XA, "xa_tam_phuoc", 831)
    W_28834 = Ward("Xã Thành Triệu", 28834, VietNamDivisionType.XA, "xa_thanh_trieu", 831)
    W_28837 = Ward("Xã Tường Đa", 28837, VietNamDivisionType.XA, "xa_tuong_da", 831)
    W_28840 = Ward("Xã Tân Phú", 28840, VietNamDivisionType.XA, "xa_tan_phu", 831)
    W_28843 = Ward("Xã Quới Thành", 28843, VietNamDivisionType.XA, "xa_quoi_thanh", 831)
    W_28846 = Ward("Xã Phước Thạnh", 28846, VietNamDivisionType.XA, "xa_phuoc_thanh", 831)
    W_28849 = Ward("Xã An Hóa", 28849, VietNamDivisionType.XA, "xa_an_hoa", 831)
    W_28852 = Ward("Xã Tiên Long", 28852, VietNamDivisionType.XA, "xa_tien_long", 831)
    W_28855 = Ward("Xã An Hiệp", 28855, VietNamDivisionType.XA, "xa_an_hiep", 831)
    W_28858 = Ward("Xã Hữu Định", 28858, VietNamDivisionType.XA, "xa_huu_dinh", 831)
    W_28861 = Ward("Xã Tiên Thủy", 28861, VietNamDivisionType.XA, "xa_tien_thuy", 831)
    W_28864 = Ward("Xã Sơn Hòa", 28864, VietNamDivisionType.XA, "xa_son_hoa", 831)
    W_28870 = Ward("Thị trấn Chợ Lách", 28870, VietNamDivisionType.THI_TRAN, "thi_tran_cho_lach", 832)
    W_28873 = Ward("Xã Phú Phụng", 28873, VietNamDivisionType.XA, "xa_phu_phung", 832)
    W_28876 = Ward("Xã Sơn Định", 28876, VietNamDivisionType.XA, "xa_son_dinh", 832)
    W_28879 = Ward("Xã Vĩnh Bình", 28879, VietNamDivisionType.XA, "xa_vinh_binh", 832)
    W_28882 = Ward("Xã Hòa Nghĩa", 28882, VietNamDivisionType.XA, "xa_hoa_nghia", 832)
    W_28885 = Ward("Xã Long Thới", 28885, VietNamDivisionType.XA, "xa_long_thoi", 832)
    W_28888 = Ward("Xã Phú Sơn", 28888, VietNamDivisionType.XA, "xa_phu_son", 832)
    W_28891 = Ward("Xã Tân Thiềng", 28891, VietNamDivisionType.XA, "xa_tan_thieng", 832)
    W_28894 = Ward("Xã Vĩnh Thành", 28894, VietNamDivisionType.XA, "xa_vinh_thanh", 832)
    W_28897 = Ward("Xã Vĩnh Hòa", 28897, VietNamDivisionType.XA, "xa_vinh_hoa", 832)
    W_28900 = Ward("Xã Hưng Khánh Trung B", 28900, VietNamDivisionType.XA, "xa_hung_khanh_trung_b", 832)
    W_28903 = Ward("Thị trấn Mỏ Cày", 28903, VietNamDivisionType.THI_TRAN, "thi_tran_mo_cay", 833)
    W_28930 = Ward("Xã Định Thủy", 28930, VietNamDivisionType.XA, "xa_dinh_thuy", 833)
    W_28939 = Ward("Xã Đa Phước Hội", 28939, VietNamDivisionType.XA, "xa_da_phuoc_hoi", 833)
    W_28940 = Ward("Xã Tân Hội", 28940, VietNamDivisionType.XA, "xa_tan_hoi", 833)
    W_28942 = Ward("Xã Phước Hiệp", 28942, VietNamDivisionType.XA, "xa_phuoc_hiep", 833)
    W_28945 = Ward("Xã Bình Khánh", 28945, VietNamDivisionType.XA, "xa_binh_khanh", 833)
    W_28951 = Ward("Xã An Thạnh", 28951, VietNamDivisionType.XA, "xa_an_thanh", 833)
    W_28957 = Ward("Xã An Định", 28957, VietNamDivisionType.XA, "xa_an_dinh", 833)
    W_28960 = Ward("Xã Thành Thới B", 28960, VietNamDivisionType.XA, "xa_thanh_thoi_b", 833)
    W_28963 = Ward("Xã Tân Trung", 28963, VietNamDivisionType.XA, "xa_tan_trung", 833)
    W_28966 = Ward("Xã An Thới", 28966, VietNamDivisionType.XA, "xa_an_thoi", 833)
    W_28969 = Ward("Xã Thành Thới A", 28969, VietNamDivisionType.XA, "xa_thanh_thoi_a", 833)
    W_28972 = Ward("Xã Minh Đức", 28972, VietNamDivisionType.XA, "xa_minh_duc", 833)
    W_28975 = Ward("Xã Ngãi Đăng", 28975, VietNamDivisionType.XA, "xa_ngai_dang", 833)
    W_28978 = Ward("Xã Cẩm Sơn", 28978, VietNamDivisionType.XA, "xa_cam_son", 833)
    W_28981 = Ward("Xã Hương Mỹ", 28981, VietNamDivisionType.XA, "xa_huong_my", 833)
    W_28984 = Ward("Thị trấn Giồng Trôm", 28984, VietNamDivisionType.THI_TRAN, "thi_tran_giong_trom", 834)
    W_28987 = Ward("Xã Phong Nẫm", 28987, VietNamDivisionType.XA, "xa_phong_nam", 834)
    W_28993 = Ward("Xã Mỹ Thạnh", 28993, VietNamDivisionType.XA, "xa_my_thanh", 834)
    W_28996 = Ward("Xã Châu Hòa", 28996, VietNamDivisionType.XA, "xa_chau_hoa", 834)
    W_28999 = Ward("Xã Lương Hòa", 28999, VietNamDivisionType.XA, "xa_luong_hoa", 834)
    W_29002 = Ward("Xã Lương Quới", 29002, VietNamDivisionType.XA, "xa_luong_quoi", 834)
    W_29005 = Ward("Xã Lương Phú", 29005, VietNamDivisionType.XA, "xa_luong_phu", 834)
    W_29008 = Ward("Xã Châu Bình", 29008, VietNamDivisionType.XA, "xa_chau_binh", 834)
    W_29011 = Ward("Xã Thuận Điền", 29011, VietNamDivisionType.XA, "xa_thuan_dien", 834)
    W_29014 = Ward("Xã Sơn Phú", 29014, VietNamDivisionType.XA, "xa_son_phu", 834)
    W_29017 = Ward("Xã Bình Hoà", 29017, VietNamDivisionType.XA, "xa_binh_hoa", 834)
    W_29020 = Ward("Xã Phước Long", 29020, VietNamDivisionType.XA, "xa_phuoc_long", 834)
    W_29023 = Ward("Xã Hưng Phong", 29023, VietNamDivisionType.XA, "xa_hung_phong", 834)
    W_29026 = Ward("Xã Long Mỹ", 29026, VietNamDivisionType.XA, "xa_long_my", 834)
    W_29029 = Ward("Xã Tân Hào", 29029, VietNamDivisionType.XA, "xa_tan_hao", 834)
    W_29032 = Ward("Xã Bình Thành", 29032, VietNamDivisionType.XA, "xa_binh_thanh", 834)
    W_29035 = Ward("Xã Tân Thanh", 29035, VietNamDivisionType.XA, "xa_tan_thanh", 834)
    W_29038 = Ward("Xã Tân Lợi Thạnh", 29038, VietNamDivisionType.XA, "xa_tan_loi_thanh", 834)
    W_29041 = Ward("Xã Thạnh Phú Đông", 29041, VietNamDivisionType.XA, "xa_thanh_phu_dong", 834)
    W_29044 = Ward("Xã Hưng Nhượng", 29044, VietNamDivisionType.XA, "xa_hung_nhuong", 834)
    W_29047 = Ward("Xã Hưng Lễ", 29047, VietNamDivisionType.XA, "xa_hung_le", 834)
    W_29050 = Ward("Thị trấn Bình Đại", 29050, VietNamDivisionType.THI_TRAN, "thi_tran_binh_dai", 835)
    W_29053 = Ward("Xã Tam Hiệp", 29053, VietNamDivisionType.XA, "xa_tam_hiep", 835)
    W_29056 = Ward("Xã Long Định", 29056, VietNamDivisionType.XA, "xa_long_dinh", 835)
    W_29059 = Ward("Xã Long Hòa", 29059, VietNamDivisionType.XA, "xa_long_hoa", 835)
    W_29062 = Ward("Xã Phú Thuận", 29062, VietNamDivisionType.XA, "xa_phu_thuan", 835)
    W_29065 = Ward("Xã Vang Quới Tây", 29065, VietNamDivisionType.XA, "xa_vang_quoi_tay", 835)
    W_29068 = Ward("Xã Vang Quới Đông", 29068, VietNamDivisionType.XA, "xa_vang_quoi_dong", 835)
    W_29071 = Ward("Xã Châu Hưng", 29071, VietNamDivisionType.XA, "xa_chau_hung", 835)
    W_29074 = Ward("Xã Phú Vang", 29074, VietNamDivisionType.XA, "xa_phu_vang", 835)
    W_29077 = Ward("Xã Lộc Thuận", 29077, VietNamDivisionType.XA, "xa_loc_thuan", 835)
    W_29080 = Ward("Xã Định Trung", 29080, VietNamDivisionType.XA, "xa_dinh_trung", 835)
    W_29083 = Ward("Xã Thới Lai", 29083, VietNamDivisionType.XA, "xa_thoi_lai", 835)
    W_29086 = Ward("Xã Bình Thới", 29086, VietNamDivisionType.XA, "xa_binh_thoi", 835)
    W_29089 = Ward("Xã Phú Long", 29089, VietNamDivisionType.XA, "xa_phu_long", 835)
    W_29092 = Ward("Xã Bình Thắng", 29092, VietNamDivisionType.XA, "xa_binh_thang", 835)
    W_29095 = Ward("Xã Thạnh Trị", 29095, VietNamDivisionType.XA, "xa_thanh_tri", 835)
    W_29098 = Ward("Xã Đại Hòa Lộc", 29098, VietNamDivisionType.XA, "xa_dai_hoa_loc", 835)
    W_29101 = Ward("Xã Thừa Đức", 29101, VietNamDivisionType.XA, "xa_thua_duc", 835)
    W_29104 = Ward("Xã Thạnh Phước", 29104, VietNamDivisionType.XA, "xa_thanh_phuoc", 835)
    W_29107 = Ward("Xã Thới Thuận", 29107, VietNamDivisionType.XA, "xa_thoi_thuan", 835)
    W_29110 = Ward("Thị trấn Ba Tri", 29110, VietNamDivisionType.THI_TRAN, "thi_tran_ba_tri", 836)
    W_29113 = Ward("Xã Tân Mỹ", 29113, VietNamDivisionType.XA, "xa_tan_my", 836)
    W_29116 = Ward("Xã Mỹ Hòa", 29116, VietNamDivisionType.XA, "xa_my_hoa", 836)
    W_29119 = Ward("Xã Tân Xuân", 29119, VietNamDivisionType.XA, "xa_tan_xuan", 836)
    W_29122 = Ward("Xã Mỹ Chánh", 29122, VietNamDivisionType.XA, "xa_my_chanh", 836)
    W_29125 = Ward("Xã Bảo Thạnh", 29125, VietNamDivisionType.XA, "xa_bao_thanh", 836)
    W_29128 = Ward("Xã An Phú Trung", 29128, VietNamDivisionType.XA, "xa_an_phu_trung", 836)
    W_29131 = Ward("Xã Mỹ Thạnh", 29131, VietNamDivisionType.XA, "xa_my_thanh", 836)
    W_29134 = Ward("Xã Mỹ Nhơn", 29134, VietNamDivisionType.XA, "xa_my_nhon", 836)
    W_29137 = Ward("Xã Phước Ngãi", 29137, VietNamDivisionType.XA, "xa_phuoc_ngai", 836)
    W_29143 = Ward("Xã An Ngãi Trung", 29143, VietNamDivisionType.XA, "xa_an_ngai_trung", 836)
    W_29146 = Ward("Xã Phú Lễ", 29146, VietNamDivisionType.XA, "xa_phu_le", 836)
    W_29149 = Ward("Xã An Bình Tây", 29149, VietNamDivisionType.XA, "xa_an_binh_tay", 836)
    W_29152 = Ward("Xã Bảo Thuận", 29152, VietNamDivisionType.XA, "xa_bao_thuan", 836)
    W_29155 = Ward("Xã Tân Hưng", 29155, VietNamDivisionType.XA, "xa_tan_hung", 836)
    W_29158 = Ward("Xã An Ngãi Tây", 29158, VietNamDivisionType.XA, "xa_an_ngai_tay", 836)
    W_29161 = Ward("Xã An Hiệp", 29161, VietNamDivisionType.XA, "xa_an_hiep", 836)
    W_29164 = Ward("Xã Vĩnh Hòa", 29164, VietNamDivisionType.XA, "xa_vinh_hoa", 836)
    W_29167 = Ward("Xã Tân Thủy", 29167, VietNamDivisionType.XA, "xa_tan_thuy", 836)
    W_29170 = Ward("Xã Vĩnh An", 29170, VietNamDivisionType.XA, "xa_vinh_an", 836)
    W_29173 = Ward("Xã An Đức", 29173, VietNamDivisionType.XA, "xa_an_duc", 836)
    W_29176 = Ward("Xã An Hòa Tây", 29176, VietNamDivisionType.XA, "xa_an_hoa_tay", 836)
    W_29179 = Ward("Xã An Thủy", 29179, VietNamDivisionType.XA, "xa_an_thuy", 836)
    W_29182 = Ward("Thị trấn Thạnh Phú", 29182, VietNamDivisionType.THI_TRAN, "thi_tran_thanh_phu", 837)
    W_29185 = Ward("Xã Phú Khánh", 29185, VietNamDivisionType.XA, "xa_phu_khanh", 837)
    W_29188 = Ward("Xã Đại Điền", 29188, VietNamDivisionType.XA, "xa_dai_dien", 837)
    W_29191 = Ward("Xã Quới Điền", 29191, VietNamDivisionType.XA, "xa_quoi_dien", 837)
    W_29194 = Ward("Xã Tân Phong", 29194, VietNamDivisionType.XA, "xa_tan_phong", 837)
    W_29197 = Ward("Xã Mỹ Hưng", 29197, VietNamDivisionType.XA, "xa_my_hung", 837)
    W_29200 = Ward("Xã An Thạnh", 29200, VietNamDivisionType.XA, "xa_an_thanh", 837)
    W_29203 = Ward("Xã Thới Thạnh", 29203, VietNamDivisionType.XA, "xa_thoi_thanh", 837)
    W_29206 = Ward("Xã Hòa Lợi", 29206, VietNamDivisionType.XA, "xa_hoa_loi", 837)
    W_29209 = Ward("Xã An Điền", 29209, VietNamDivisionType.XA, "xa_an_dien", 837)
    W_29212 = Ward("Xã Bình Thạnh", 29212, VietNamDivisionType.XA, "xa_binh_thanh", 837)
    W_29215 = Ward("Xã An Thuận", 29215, VietNamDivisionType.XA, "xa_an_thuan", 837)
    W_29218 = Ward("Xã An Quy", 29218, VietNamDivisionType.XA, "xa_an_quy", 837)
    W_29221 = Ward("Xã Thạnh Hải", 29221, VietNamDivisionType.XA, "xa_thanh_hai", 837)
    W_29224 = Ward("Xã An Nhơn", 29224, VietNamDivisionType.XA, "xa_an_nhon", 837)
    W_29227 = Ward("Xã Giao Thạnh", 29227, VietNamDivisionType.XA, "xa_giao_thanh", 837)
    W_29230 = Ward("Xã Thạnh Phong", 29230, VietNamDivisionType.XA, "xa_thanh_phong", 837)
    W_29233 = Ward("Xã Mỹ An", 29233, VietNamDivisionType.XA, "xa_my_an", 837)
    W_28889 = Ward("Xã Phú Mỹ", 28889, VietNamDivisionType.XA, "xa_phu_my", 838)
    W_28901 = Ward("Xã Hưng Khánh Trung A", 28901, VietNamDivisionType.XA, "xa_hung_khanh_trung_a", 838)
    W_28906 = Ward("Xã Thanh Tân", 28906, VietNamDivisionType.XA, "xa_thanh_tan", 838)
    W_28909 = Ward("Xã Thạnh Ngãi", 28909, VietNamDivisionType.XA, "xa_thanh_ngai", 838)
    W_28912 = Ward("Xã Tân Phú Tây", 28912, VietNamDivisionType.XA, "xa_tan_phu_tay", 838)
    W_28915 = Ward("Xã Phước Mỹ Trung", 28915, VietNamDivisionType.XA, "xa_phuoc_my_trung", 838)
    W_28918 = Ward("Xã Tân Thành Bình", 28918, VietNamDivisionType.XA, "xa_tan_thanh_binh", 838)
    W_28921 = Ward("Xã Thành An", 28921, VietNamDivisionType.XA, "xa_thanh_an", 838)
    W_28924 = Ward("Xã Hòa Lộc", 28924, VietNamDivisionType.XA, "xa_hoa_loc", 838)
    W_28927 = Ward("Xã Tân Thanh Tây", 28927, VietNamDivisionType.XA, "xa_tan_thanh_tay", 838)
    W_28933 = Ward("Xã Tân Bình", 28933, VietNamDivisionType.XA, "xa_tan_binh", 838)
    W_28936 = Ward("Xã Nhuận Phú Tân", 28936, VietNamDivisionType.XA, "xa_nhuan_phu_tan", 838)
    W_28948 = Ward("Xã Khánh Thạnh Tân", 28948, VietNamDivisionType.XA, "xa_khanh_thanh_tan", 838)
    W_29236 = Ward("Phường 4", 29236, VietNamDivisionType.PHUONG, "phuong_4", 842)
    W_29239 = Ward("Phường 1", 29239, VietNamDivisionType.PHUONG, "phuong_1", 842)
    W_29242 = Ward("Phường 3", 29242, VietNamDivisionType.PHUONG, "phuong_3", 842)
    W_29245 = Ward("Phường 2", 29245, VietNamDivisionType.PHUONG, "phuong_2", 842)
    W_29248 = Ward("Phường 5", 29248, VietNamDivisionType.PHUONG, "phuong_5", 842)
    W_29251 = Ward("Phường 6", 29251, VietNamDivisionType.PHUONG, "phuong_6", 842)
    W_29254 = Ward("Phường 7", 29254, VietNamDivisionType.PHUONG, "phuong_7", 842)
    W_29257 = Ward("Phường 8", 29257, VietNamDivisionType.PHUONG, "phuong_8", 842)
    W_29260 = Ward("Phường 9", 29260, VietNamDivisionType.PHUONG, "phuong_9", 842)
    W_29263 = Ward("Xã Long Đức", 29263, VietNamDivisionType.XA, "xa_long_duc", 842)
    W_29266 = Ward("Thị trấn Càng Long", 29266, VietNamDivisionType.THI_TRAN, "thi_tran_cang_long", 844)
    W_29269 = Ward("Xã Mỹ Cẩm", 29269, VietNamDivisionType.XA, "xa_my_cam", 844)
    W_29272 = Ward("Xã An Trường A", 29272, VietNamDivisionType.XA, "xa_an_truong_a", 844)
    W_29275 = Ward("Xã An Trường", 29275, VietNamDivisionType.XA, "xa_an_truong", 844)
    W_29278 = Ward("Xã Huyền Hội", 29278, VietNamDivisionType.XA, "xa_huyen_hoi", 844)
    W_29281 = Ward("Xã Tân An", 29281, VietNamDivisionType.XA, "xa_tan_an", 844)
    W_29284 = Ward("Xã Tân Bình", 29284, VietNamDivisionType.XA, "xa_tan_binh", 844)
    W_29287 = Ward("Xã Bình Phú", 29287, VietNamDivisionType.XA, "xa_binh_phu", 844)
    W_29290 = Ward("Xã Phương Thạnh", 29290, VietNamDivisionType.XA, "xa_phuong_thanh", 844)
    W_29293 = Ward("Xã Đại Phúc", 29293, VietNamDivisionType.XA, "xa_dai_phuc", 844)
    W_29296 = Ward("Xã Đại Phước", 29296, VietNamDivisionType.XA, "xa_dai_phuoc", 844)
    W_29299 = Ward("Xã Nhị Long Phú", 29299, VietNamDivisionType.XA, "xa_nhi_long_phu", 844)
    W_29302 = Ward("Xã Nhị Long", 29302, VietNamDivisionType.XA, "xa_nhi_long", 844)
    W_29305 = Ward("Xã Đức Mỹ", 29305, VietNamDivisionType.XA, "xa_duc_my", 844)
    W_29308 = Ward("Thị trấn Cầu Kè", 29308, VietNamDivisionType.THI_TRAN, "thi_tran_cau_ke", 845)
    W_29311 = Ward("Xã Hòa Ân", 29311, VietNamDivisionType.XA, "xa_hoa_an", 845)
    W_29314 = Ward("Xã Châu Điền", 29314, VietNamDivisionType.XA, "xa_chau_dien", 845)
    W_29317 = Ward("Xã An Phú Tân", 29317, VietNamDivisionType.XA, "xa_an_phu_tan", 845)
    W_29320 = Ward("Xã Hoà Tân", 29320, VietNamDivisionType.XA, "xa_hoa_tan", 845)
    W_29323 = Ward("Xã Ninh Thới", 29323, VietNamDivisionType.XA, "xa_ninh_thoi", 845)
    W_29326 = Ward("Xã Phong Phú", 29326, VietNamDivisionType.XA, "xa_phong_phu", 845)
    W_29329 = Ward("Xã Phong Thạnh", 29329, VietNamDivisionType.XA, "xa_phong_thanh", 845)
    W_29332 = Ward("Xã Tam Ngãi", 29332, VietNamDivisionType.XA, "xa_tam_ngai", 845)
    W_29335 = Ward("Xã Thông Hòa", 29335, VietNamDivisionType.XA, "xa_thong_hoa", 845)
    W_29338 = Ward("Xã Thạnh Phú", 29338, VietNamDivisionType.XA, "xa_thanh_phu", 845)
    W_29341 = Ward("Thị trấn Tiểu Cần", 29341, VietNamDivisionType.THI_TRAN, "thi_tran_tieu_can", 846)
    W_29344 = Ward("Thị trấn Cầu Quan", 29344, VietNamDivisionType.THI_TRAN, "thi_tran_cau_quan", 846)
    W_29347 = Ward("Xã Phú Cần", 29347, VietNamDivisionType.XA, "xa_phu_can", 846)
    W_29350 = Ward("Xã Hiếu Tử", 29350, VietNamDivisionType.XA, "xa_hieu_tu", 846)
    W_29353 = Ward("Xã Hiếu Trung", 29353, VietNamDivisionType.XA, "xa_hieu_trung", 846)
    W_29356 = Ward("Xã Long Thới", 29356, VietNamDivisionType.XA, "xa_long_thoi", 846)
    W_29359 = Ward("Xã Hùng Hòa", 29359, VietNamDivisionType.XA, "xa_hung_hoa", 846)
    W_29362 = Ward("Xã Tân Hùng", 29362, VietNamDivisionType.XA, "xa_tan_hung", 846)
    W_29365 = Ward("Xã Tập Ngãi", 29365, VietNamDivisionType.XA, "xa_tap_ngai", 846)
    W_29368 = Ward("Xã Ngãi Hùng", 29368, VietNamDivisionType.XA, "xa_ngai_hung", 846)
    W_29371 = Ward("Xã Tân Hòa", 29371, VietNamDivisionType.XA, "xa_tan_hoa", 846)
    W_29374 = Ward("Thị trấn Châu Thành", 29374, VietNamDivisionType.THI_TRAN, "thi_tran_chau_thanh", 847)
    W_29377 = Ward("Xã Đa Lộc", 29377, VietNamDivisionType.XA, "xa_da_loc", 847)
    W_29380 = Ward("Xã Mỹ Chánh", 29380, VietNamDivisionType.XA, "xa_my_chanh", 847)
    W_29383 = Ward("Xã Thanh Mỹ", 29383, VietNamDivisionType.XA, "xa_thanh_my", 847)
    W_29386 = Ward("Xã Lương Hoà A", 29386, VietNamDivisionType.XA, "xa_luong_hoa_a", 847)
    W_29389 = Ward("Xã Lương Hòa", 29389, VietNamDivisionType.XA, "xa_luong_hoa", 847)
    W_29392 = Ward("Xã Song Lộc", 29392, VietNamDivisionType.XA, "xa_song_loc", 847)
    W_29395 = Ward("Xã Nguyệt Hóa", 29395, VietNamDivisionType.XA, "xa_nguyet_hoa", 847)
    W_29398 = Ward("Xã Hòa Thuận", 29398, VietNamDivisionType.XA, "xa_hoa_thuan", 847)
    W_29401 = Ward("Xã Hòa Lợi", 29401, VietNamDivisionType.XA, "xa_hoa_loi", 847)
    W_29404 = Ward("Xã Phước Hảo", 29404, VietNamDivisionType.XA, "xa_phuoc_hao", 847)
    W_29407 = Ward("Xã Hưng Mỹ", 29407, VietNamDivisionType.XA, "xa_hung_my", 847)
    W_29410 = Ward("Xã Hòa Minh", 29410, VietNamDivisionType.XA, "xa_hoa_minh", 847)
    W_29413 = Ward("Xã Long Hòa", 29413, VietNamDivisionType.XA, "xa_long_hoa", 847)
    W_29416 = Ward("Thị trấn Cầu Ngang", 29416, VietNamDivisionType.THI_TRAN, "thi_tran_cau_ngang", 848)
    W_29419 = Ward("Thị trấn Mỹ Long", 29419, VietNamDivisionType.THI_TRAN, "thi_tran_my_long", 848)
    W_29422 = Ward("Xã Mỹ Long Bắc", 29422, VietNamDivisionType.XA, "xa_my_long_bac", 848)
    W_29425 = Ward("Xã Mỹ Long Nam", 29425, VietNamDivisionType.XA, "xa_my_long_nam", 848)
    W_29428 = Ward("Xã Mỹ Hòa", 29428, VietNamDivisionType.XA, "xa_my_hoa", 848)
    W_29431 = Ward("Xã Vĩnh Kim", 29431, VietNamDivisionType.XA, "xa_vinh_kim", 848)
    W_29434 = Ward("Xã Kim Hòa", 29434, VietNamDivisionType.XA, "xa_kim_hoa", 848)
    W_29437 = Ward("Xã Hiệp Hòa", 29437, VietNamDivisionType.XA, "xa_hiep_hoa", 848)
    W_29440 = Ward("Xã Thuận Hòa", 29440, VietNamDivisionType.XA, "xa_thuan_hoa", 848)
    W_29443 = Ward("Xã Long Sơn", 29443, VietNamDivisionType.XA, "xa_long_son", 848)
    W_29446 = Ward("Xã Nhị Trường", 29446, VietNamDivisionType.XA, "xa_nhi_truong", 848)
    W_29449 = Ward("Xã Trường Thọ", 29449, VietNamDivisionType.XA, "xa_truong_tho", 848)
    W_29452 = Ward("Xã Hiệp Mỹ Đông", 29452, VietNamDivisionType.XA, "xa_hiep_my_dong", 848)
    W_29455 = Ward("Xã Hiệp Mỹ Tây", 29455, VietNamDivisionType.XA, "xa_hiep_my_tay", 848)
    W_29458 = Ward("Xã Thạnh Hòa Sơn", 29458, VietNamDivisionType.XA, "xa_thanh_hoa_son", 848)
    W_29461 = Ward("Thị trấn Trà Cú", 29461, VietNamDivisionType.THI_TRAN, "thi_tran_tra_cu", 849)
    W_29462 = Ward("Thị trấn Định An", 29462, VietNamDivisionType.THI_TRAN, "thi_tran_dinh_an", 849)
    W_29464 = Ward("Xã Phước Hưng", 29464, VietNamDivisionType.XA, "xa_phuoc_hung", 849)
    W_29467 = Ward("Xã Tập Sơn", 29467, VietNamDivisionType.XA, "xa_tap_son", 849)
    W_29470 = Ward("Xã Tân Sơn", 29470, VietNamDivisionType.XA, "xa_tan_son", 849)
    W_29473 = Ward("Xã An Quảng Hữu", 29473, VietNamDivisionType.XA, "xa_an_quang_huu", 849)
    W_29476 = Ward("Xã Lưu Nghiệp Anh", 29476, VietNamDivisionType.XA, "xa_luu_nghiep_anh", 849)
    W_29479 = Ward("Xã Ngãi Xuyên", 29479, VietNamDivisionType.XA, "xa_ngai_xuyen", 849)
    W_29482 = Ward("Xã Kim Sơn", 29482, VietNamDivisionType.XA, "xa_kim_son", 849)
    W_29485 = Ward("Xã Thanh Sơn", 29485, VietNamDivisionType.XA, "xa_thanh_son", 849)
    W_29488 = Ward("Xã Hàm Giang", 29488, VietNamDivisionType.XA, "xa_ham_giang", 849)
    W_29489 = Ward("Xã Hàm Tân", 29489, VietNamDivisionType.XA, "xa_ham_tan", 849)
    W_29491 = Ward("Xã Đại An", 29491, VietNamDivisionType.XA, "xa_dai_an", 849)
    W_29494 = Ward("Xã Định An", 29494, VietNamDivisionType.XA, "xa_dinh_an", 849)
    W_29503 = Ward("Xã Ngọc Biên", 29503, VietNamDivisionType.XA, "xa_ngoc_bien", 849)
    W_29506 = Ward("Xã Long Hiệp", 29506, VietNamDivisionType.XA, "xa_long_hiep", 849)
    W_29509 = Ward("Xã Tân Hiệp", 29509, VietNamDivisionType.XA, "xa_tan_hiep", 849)
    W_29497 = Ward("Xã Đôn Xuân", 29497, VietNamDivisionType.XA, "xa_don_xuan", 850)
    W_29500 = Ward("Xã Đôn Châu", 29500, VietNamDivisionType.XA, "xa_don_chau", 850)
    W_29513 = Ward("Thị trấn Long Thành", 29513, VietNamDivisionType.THI_TRAN, "thi_tran_long_thanh", 850)
    W_29521 = Ward("Xã Long Khánh", 29521, VietNamDivisionType.XA, "xa_long_khanh", 850)
    W_29530 = Ward("Xã Ngũ Lạc", 29530, VietNamDivisionType.XA, "xa_ngu_lac", 850)
    W_29533 = Ward("Xã Long Vĩnh", 29533, VietNamDivisionType.XA, "xa_long_vinh", 850)
    W_29536 = Ward("Xã Đông Hải", 29536, VietNamDivisionType.XA, "xa_dong_hai", 850)
    W_29512 = Ward("Phường 1", 29512, VietNamDivisionType.PHUONG, "phuong_1", 851)
    W_29515 = Ward("Xã Long Toàn", 29515, VietNamDivisionType.XA, "xa_long_toan", 851)
    W_29516 = Ward("Phường 2", 29516, VietNamDivisionType.PHUONG, "phuong_2", 851)
    W_29518 = Ward("Xã Long Hữu", 29518, VietNamDivisionType.XA, "xa_long_huu", 851)
    W_29524 = Ward("Xã Dân Thành", 29524, VietNamDivisionType.XA, "xa_dan_thanh", 851)
    W_29527 = Ward("Xã Trường Long Hòa", 29527, VietNamDivisionType.XA, "xa_truong_long_hoa", 851)
    W_29539 = Ward("Xã Hiệp Thạnh", 29539, VietNamDivisionType.XA, "xa_hiep_thanh", 851)
    W_29542 = Ward("Phường 9", 29542, VietNamDivisionType.PHUONG, "phuong_9", 855)
    W_29545 = Ward("Phường 5", 29545, VietNamDivisionType.PHUONG, "phuong_5", 855)
    W_29548 = Ward("Phường 1", 29548, VietNamDivisionType.PHUONG, "phuong_1", 855)
    W_29551 = Ward("Phường 2", 29551, VietNamDivisionType.PHUONG, "phuong_2", 855)
    W_29554 = Ward("Phường 4", 29554, VietNamDivisionType.PHUONG, "phuong_4", 855)
    W_29557 = Ward("Phường 3", 29557, VietNamDivisionType.PHUONG, "phuong_3", 855)
    W_29560 = Ward("Phường 8", 29560, VietNamDivisionType.PHUONG, "phuong_8", 855)
    W_29563 = Ward("Phường Tân Ngãi", 29563, VietNamDivisionType.PHUONG, "phuong_tan_ngai", 855)
    W_29566 = Ward("Phường Tân Hòa", 29566, VietNamDivisionType.PHUONG, "phuong_tan_hoa", 855)
    W_29569 = Ward("Phường Tân Hội", 29569, VietNamDivisionType.PHUONG, "phuong_tan_hoi", 855)
    W_29572 = Ward("Phường Trường An", 29572, VietNamDivisionType.PHUONG, "phuong_truong_an", 855)
    W_29575 = Ward("Thị trấn Long Hồ", 29575, VietNamDivisionType.THI_TRAN, "thi_tran_long_ho", 857)
    W_29578 = Ward("Xã Đồng Phú", 29578, VietNamDivisionType.XA, "xa_dong_phu", 857)
    W_29581 = Ward("Xã Bình Hòa Phước", 29581, VietNamDivisionType.XA, "xa_binh_hoa_phuoc", 857)
    W_29584 = Ward("Xã Hòa Ninh", 29584, VietNamDivisionType.XA, "xa_hoa_ninh", 857)
    W_29587 = Ward("Xã An Bình", 29587, VietNamDivisionType.XA, "xa_an_binh", 857)
    W_29590 = Ward("Xã Thanh Đức", 29590, VietNamDivisionType.XA, "xa_thanh_duc", 857)
    W_29593 = Ward("Xã Tân Hạnh", 29593, VietNamDivisionType.XA, "xa_tan_hanh", 857)
    W_29596 = Ward("Xã Phước Hậu", 29596, VietNamDivisionType.XA, "xa_phuoc_hau", 857)
    W_29599 = Ward("Xã Long Phước", 29599, VietNamDivisionType.XA, "xa_long_phuoc", 857)
    W_29602 = Ward("Xã Phú Đức", 29602, VietNamDivisionType.XA, "xa_phu_duc", 857)
    W_29605 = Ward("Xã Lộc Hòa", 29605, VietNamDivisionType.XA, "xa_loc_hoa", 857)
    W_29608 = Ward("Xã Long An", 29608, VietNamDivisionType.XA, "xa_long_an", 857)
    W_29611 = Ward("Xã Phú Quới", 29611, VietNamDivisionType.XA, "xa_phu_quoi", 857)
    W_29614 = Ward("Xã Thạnh Quới", 29614, VietNamDivisionType.XA, "xa_thanh_quoi", 857)
    W_29617 = Ward("Xã Hòa Phú", 29617, VietNamDivisionType.XA, "xa_hoa_phu", 857)
    W_29623 = Ward("Xã Mỹ An", 29623, VietNamDivisionType.XA, "xa_my_an", 858)
    W_29626 = Ward("Xã Mỹ Phước", 29626, VietNamDivisionType.XA, "xa_my_phuoc", 858)
    W_29629 = Ward("Xã An Phước", 29629, VietNamDivisionType.XA, "xa_an_phuoc", 858)
    W_29632 = Ward("Xã Nhơn Phú", 29632, VietNamDivisionType.XA, "xa_nhon_phu", 858)
    W_29635 = Ward("Xã Long Mỹ", 29635, VietNamDivisionType.XA, "xa_long_my", 858)
    W_29638 = Ward("Xã Hòa Tịnh", 29638, VietNamDivisionType.XA, "xa_hoa_tinh", 858)
    W_29641 = Ward("Thị trấn Cái Nhum", 29641, VietNamDivisionType.THI_TRAN, "thi_tran_cai_nhum", 858)
    W_29644 = Ward("Xã Bình Phước", 29644, VietNamDivisionType.XA, "xa_binh_phuoc", 858)
    W_29647 = Ward("Xã Chánh An", 29647, VietNamDivisionType.XA, "xa_chanh_an", 858)
    W_29650 = Ward("Xã Tân An Hội", 29650, VietNamDivisionType.XA, "xa_tan_an_hoi", 858)
    W_29653 = Ward("Xã Tân Long", 29653, VietNamDivisionType.XA, "xa_tan_long", 858)
    W_29656 = Ward("Xã Tân Long Hội", 29656, VietNamDivisionType.XA, "xa_tan_long_hoi", 858)
    W_29659 = Ward("Thị trấn Vũng Liêm", 29659, VietNamDivisionType.THI_TRAN, "thi_tran_vung_liem", 859)
    W_29662 = Ward("Xã Tân Quới Trung", 29662, VietNamDivisionType.XA, "xa_tan_quoi_trung", 859)
    W_29665 = Ward("Xã Quới Thiện", 29665, VietNamDivisionType.XA, "xa_quoi_thien", 859)
    W_29668 = Ward("Xã Quới An", 29668, VietNamDivisionType.XA, "xa_quoi_an", 859)
    W_29671 = Ward("Xã Trung Chánh", 29671, VietNamDivisionType.XA, "xa_trung_chanh", 859)
    W_29674 = Ward("Xã Tân An Luông", 29674, VietNamDivisionType.XA, "xa_tan_an_luong", 859)
    W_29677 = Ward("Xã Thanh Bình", 29677, VietNamDivisionType.XA, "xa_thanh_binh", 859)
    W_29680 = Ward("Xã Trung Thành Tây", 29680, VietNamDivisionType.XA, "xa_trung_thanh_tay", 859)
    W_29683 = Ward("Xã Trung Hiệp", 29683, VietNamDivisionType.XA, "xa_trung_hiep", 859)
    W_29686 = Ward("Xã Hiếu Phụng", 29686, VietNamDivisionType.XA, "xa_hieu_phung", 859)
    W_29689 = Ward("Xã Trung Thành Đông", 29689, VietNamDivisionType.XA, "xa_trung_thanh_dong", 859)
    W_29692 = Ward("Xã Trung Thành", 29692, VietNamDivisionType.XA, "xa_trung_thanh", 859)
    W_29695 = Ward("Xã Trung Hiếu", 29695, VietNamDivisionType.XA, "xa_trung_hieu", 859)
    W_29698 = Ward("Xã Trung Ngãi", 29698, VietNamDivisionType.XA, "xa_trung_ngai", 859)
    W_29701 = Ward("Xã Hiếu Thuận", 29701, VietNamDivisionType.XA, "xa_hieu_thuan", 859)
    W_29704 = Ward("Xã Trung Nghĩa", 29704, VietNamDivisionType.XA, "xa_trung_nghia", 859)
    W_29707 = Ward("Xã Trung An", 29707, VietNamDivisionType.XA, "xa_trung_an", 859)
    W_29710 = Ward("Xã Hiếu Nhơn", 29710, VietNamDivisionType.XA, "xa_hieu_nhon", 859)
    W_29713 = Ward("Xã Hiếu Thành", 29713, VietNamDivisionType.XA, "xa_hieu_thanh", 859)
    W_29716 = Ward("Xã Hiếu Nghĩa", 29716, VietNamDivisionType.XA, "xa_hieu_nghia", 859)
    W_29719 = Ward("Thị trấn Tam Bình", 29719, VietNamDivisionType.THI_TRAN, "thi_tran_tam_binh", 860)
    W_29722 = Ward("Xã Tân Lộc", 29722, VietNamDivisionType.XA, "xa_tan_loc", 860)
    W_29725 = Ward("Xã Phú Thịnh", 29725, VietNamDivisionType.XA, "xa_phu_thinh", 860)
    W_29728 = Ward("Xã Hậu Lộc", 29728, VietNamDivisionType.XA, "xa_hau_loc", 860)
    W_29731 = Ward("Xã Hòa Thạnh", 29731, VietNamDivisionType.XA, "xa_hoa_thanh", 860)
    W_29734 = Ward("Xã Hoà Lộc", 29734, VietNamDivisionType.XA, "xa_hoa_loc", 860)
    W_29737 = Ward("Xã Phú Lộc", 29737, VietNamDivisionType.XA, "xa_phu_loc", 860)
    W_29740 = Ward("Xã Song Phú", 29740, VietNamDivisionType.XA, "xa_song_phu", 860)
    W_29743 = Ward("Xã Hòa Hiệp", 29743, VietNamDivisionType.XA, "xa_hoa_hiep", 860)
    W_29746 = Ward("Xã Mỹ Lộc", 29746, VietNamDivisionType.XA, "xa_my_loc", 860)
    W_29749 = Ward("Xã Tân Phú", 29749, VietNamDivisionType.XA, "xa_tan_phu", 860)
    W_29752 = Ward("Xã Long Phú", 29752, VietNamDivisionType.XA, "xa_long_phu", 860)
    W_29755 = Ward("Xã Mỹ Thạnh Trung", 29755, VietNamDivisionType.XA, "xa_my_thanh_trung", 860)
    W_29758 = Ward("Xã Tường Lộc", 29758, VietNamDivisionType.XA, "xa_tuong_loc", 860)
    W_29761 = Ward("Xã Loan Mỹ", 29761, VietNamDivisionType.XA, "xa_loan_my", 860)
    W_29764 = Ward("Xã Ngãi Tứ", 29764, VietNamDivisionType.XA, "xa_ngai_tu", 860)
    W_29767 = Ward("Xã Bình Ninh", 29767, VietNamDivisionType.XA, "xa_binh_ninh", 860)
    W_29770 = Ward("Phường Cái Vồn", 29770, VietNamDivisionType.PHUONG, "phuong_cai_von", 861)
    W_29771 = Ward("Phường Thành Phước", 29771, VietNamDivisionType.PHUONG, "phuong_thanh_phuoc", 861)
    W_29806 = Ward("Xã Thuận An", 29806, VietNamDivisionType.XA, "xa_thuan_an", 861)
    W_29809 = Ward("Xã Đông Thạnh", 29809, VietNamDivisionType.XA, "xa_dong_thanh", 861)
    W_29812 = Ward("Xã Đông Bình", 29812, VietNamDivisionType.XA, "xa_dong_binh", 861)
    W_29813 = Ward("Phường Đông Thuận", 29813, VietNamDivisionType.PHUONG, "phuong_dong_thuan", 861)
    W_29815 = Ward("Xã Mỹ Hòa", 29815, VietNamDivisionType.XA, "xa_my_hoa", 861)
    W_29818 = Ward("Xã Đông Thành", 29818, VietNamDivisionType.XA, "xa_dong_thanh", 861)
    W_29821 = Ward("Thị trấn Trà Ôn", 29821, VietNamDivisionType.THI_TRAN, "thi_tran_tra_on", 862)
    W_29824 = Ward("Xã Xuân Hiệp", 29824, VietNamDivisionType.XA, "xa_xuan_hiep", 862)
    W_29827 = Ward("Xã Nhơn Bình", 29827, VietNamDivisionType.XA, "xa_nhon_binh", 862)
    W_29830 = Ward("Xã Hòa Bình", 29830, VietNamDivisionType.XA, "xa_hoa_binh", 862)
    W_29833 = Ward("Xã Thới Hòa", 29833, VietNamDivisionType.XA, "xa_thoi_hoa", 862)
    W_29836 = Ward("Xã Trà Côn", 29836, VietNamDivisionType.XA, "xa_tra_con", 862)
    W_29839 = Ward("Xã Tân Mỹ", 29839, VietNamDivisionType.XA, "xa_tan_my", 862)
    W_29842 = Ward("Xã Hựu Thành", 29842, VietNamDivisionType.XA, "xa_huu_thanh", 862)
    W_29845 = Ward("Xã Vĩnh Xuân", 29845, VietNamDivisionType.XA, "xa_vinh_xuan", 862)
    W_29848 = Ward("Xã Thuận Thới", 29848, VietNamDivisionType.XA, "xa_thuan_thoi", 862)
    W_29851 = Ward("Xã Phú Thành", 29851, VietNamDivisionType.XA, "xa_phu_thanh", 862)
    W_29854 = Ward("Xã Thiện Mỹ", 29854, VietNamDivisionType.XA, "xa_thien_my", 862)
    W_29857 = Ward("Xã Lục Sỹ Thành", 29857, VietNamDivisionType.XA, "xa_luc_sy_thanh", 862)
    W_29860 = Ward("Xã Tích Thiện", 29860, VietNamDivisionType.XA, "xa_tich_thien", 862)
    W_29773 = Ward("Xã Tân Hưng", 29773, VietNamDivisionType.XA, "xa_tan_hung", 863)
    W_29776 = Ward("Xã Tân Thành", 29776, VietNamDivisionType.XA, "xa_tan_thanh", 863)
    W_29779 = Ward("Xã Thành Trung", 29779, VietNamDivisionType.XA, "xa_thanh_trung", 863)
    W_29782 = Ward("Xã Tân An Thạnh", 29782, VietNamDivisionType.XA, "xa_tan_an_thanh", 863)
    W_29785 = Ward("Xã Tân Lược", 29785, VietNamDivisionType.XA, "xa_tan_luoc", 863)
    W_29788 = Ward("Xã Nguyễn Văn Thảnh", 29788, VietNamDivisionType.XA, "xa_nguyen_van_thanh", 863)
    W_29791 = Ward("Xã Thành Lợi", 29791, VietNamDivisionType.XA, "xa_thanh_loi", 863)
    W_29794 = Ward("Xã Mỹ Thuận", 29794, VietNamDivisionType.XA, "xa_my_thuan", 863)
    W_29797 = Ward("Xã Tân Bình", 29797, VietNamDivisionType.XA, "xa_tan_binh", 863)
    W_29800 = Ward("Thị trấn Tân Quới", 29800, VietNamDivisionType.THI_TRAN, "thi_tran_tan_quoi", 863)
    W_29863 = Ward("Phường 11", 29863, VietNamDivisionType.PHUONG, "phuong_11", 866)
    W_29866 = Ward("Phường 1", 29866, VietNamDivisionType.PHUONG, "phuong_1", 866)
    W_29869 = Ward("Phường 2", 29869, VietNamDivisionType.PHUONG, "phuong_2", 866)
    W_29872 = Ward("Phường 4", 29872, VietNamDivisionType.PHUONG, "phuong_4", 866)
    W_29875 = Ward("Phường 3", 29875, VietNamDivisionType.PHUONG, "phuong_3", 866)
    W_29878 = Ward("Phường 6", 29878, VietNamDivisionType.PHUONG, "phuong_6", 866)
    W_29881 = Ward("Xã Mỹ Ngãi", 29881, VietNamDivisionType.XA, "xa_my_ngai", 866)
    W_29884 = Ward("Xã Mỹ Tân", 29884, VietNamDivisionType.XA, "xa_my_tan", 866)
    W_29887 = Ward("Xã Mỹ Trà", 29887, VietNamDivisionType.XA, "xa_my_tra", 866)
    W_29888 = Ward("Phường Mỹ Phú", 29888, VietNamDivisionType.PHUONG, "phuong_my_phu", 866)
    W_29890 = Ward("Xã Tân Thuận Tây", 29890, VietNamDivisionType.XA, "xa_tan_thuan_tay", 866)
    W_29892 = Ward("Phường Hoà Thuận", 29892, VietNamDivisionType.PHUONG, "phuong_hoa_thuan", 866)
    W_29893 = Ward("Xã Hòa An", 29893, VietNamDivisionType.XA, "xa_hoa_an", 866)
    W_29896 = Ward("Xã Tân Thuận Đông", 29896, VietNamDivisionType.XA, "xa_tan_thuan_dong", 866)
    W_29899 = Ward("Xã Tịnh Thới", 29899, VietNamDivisionType.XA, "xa_tinh_thoi", 866)
    W_29902 = Ward("Phường 3", 29902, VietNamDivisionType.PHUONG, "phuong_3", 867)
    W_29905 = Ward("Phường 1", 29905, VietNamDivisionType.PHUONG, "phuong_1", 867)
    W_29908 = Ward("Phường 4", 29908, VietNamDivisionType.PHUONG, "phuong_4", 867)
    W_29911 = Ward("Phường 2", 29911, VietNamDivisionType.PHUONG, "phuong_2", 867)
    W_29914 = Ward("Xã Tân Khánh Đông", 29914, VietNamDivisionType.XA, "xa_tan_khanh_dong", 867)
    W_29917 = Ward("Phường Tân Quy Đông", 29917, VietNamDivisionType.PHUONG, "phuong_tan_quy_dong", 867)
    W_29919 = Ward("Phường An Hoà", 29919, VietNamDivisionType.PHUONG, "phuong_an_hoa", 867)
    W_29920 = Ward("Xã Tân Quy Tây", 29920, VietNamDivisionType.XA, "xa_tan_quy_tay", 867)
    W_29923 = Ward("Xã Tân Phú Đông", 29923, VietNamDivisionType.XA, "xa_tan_phu_dong", 867)
    W_29954 = Ward("Phường An Lộc", 29954, VietNamDivisionType.PHUONG, "phuong_an_loc", 868)
    W_29955 = Ward("Phường An Thạnh", 29955, VietNamDivisionType.PHUONG, "phuong_an_thanh", 868)
    W_29959 = Ward("Xã Bình Thạnh", 29959, VietNamDivisionType.XA, "xa_binh_thanh", 868)
    W_29965 = Ward("Xã Tân Hội", 29965, VietNamDivisionType.XA, "xa_tan_hoi", 868)
    W_29978 = Ward("Phường An Lạc", 29978, VietNamDivisionType.PHUONG, "phuong_an_lac", 868)
    W_29986 = Ward("Phường An Bình B", 29986, VietNamDivisionType.PHUONG, "phuong_an_binh_b", 868)
    W_29989 = Ward("Phường An Bình A", 29989, VietNamDivisionType.PHUONG, "phuong_an_binh_a", 868)
    W_29926 = Ward("Thị trấn Sa Rài", 29926, VietNamDivisionType.THI_TRAN, "thi_tran_sa_rai", 869)
    W_29929 = Ward("Xã Tân Hộ Cơ", 29929, VietNamDivisionType.XA, "xa_tan_ho_co", 869)
    W_29932 = Ward("Xã Thông Bình", 29932, VietNamDivisionType.XA, "xa_thong_binh", 869)
    W_29935 = Ward("Xã Bình Phú", 29935, VietNamDivisionType.XA, "xa_binh_phu", 869)
    W_29938 = Ward("Xã Tân Thành A", 29938, VietNamDivisionType.XA, "xa_tan_thanh_a", 869)
    W_29941 = Ward("Xã Tân Thành B", 29941, VietNamDivisionType.XA, "xa_tan_thanh_b", 869)
    W_29944 = Ward("Xã Tân Phước", 29944, VietNamDivisionType.XA, "xa_tan_phuoc", 869)
    W_29947 = Ward("Xã Tân Công Chí", 29947, VietNamDivisionType.XA, "xa_tan_cong_chi", 869)
    W_29950 = Ward("Xã An Phước", 29950, VietNamDivisionType.XA, "xa_an_phuoc", 869)
    W_29956 = Ward("Xã Thường Phước 1", 29956, VietNamDivisionType.XA, "xa_thuong_phuoc_1", 870)
    W_29962 = Ward("Xã Thường Thới Hậu A", 29962, VietNamDivisionType.XA, "xa_thuong_thoi_hau_a", 870)
    W_29971 = Ward("Thị trấn Thường Thới Tiền", 29971, VietNamDivisionType.THI_TRAN, "thi_tran_thuong_thoi_tien", 870)
    W_29974 = Ward("Xã Thường Phước 2", 29974, VietNamDivisionType.XA, "xa_thuong_phuoc_2", 870)
    W_29977 = Ward("Xã Thường Lạc", 29977, VietNamDivisionType.XA, "xa_thuong_lac", 870)
    W_29980 = Ward("Xã Long Khánh A", 29980, VietNamDivisionType.XA, "xa_long_khanh_a", 870)
    W_29983 = Ward("Xã Long Khánh B", 29983, VietNamDivisionType.XA, "xa_long_khanh_b", 870)
    W_29992 = Ward("Xã Long Thuận", 29992, VietNamDivisionType.XA, "xa_long_thuan", 870)
    W_29995 = Ward("Xã Phú Thuận B", 29995, VietNamDivisionType.XA, "xa_phu_thuan_b", 870)
    W_29998 = Ward("Xã Phú Thuận A", 29998, VietNamDivisionType.XA, "xa_phu_thuan_a", 870)
    W_30001 = Ward("Thị trấn Tràm Chim", 30001, VietNamDivisionType.THI_TRAN, "thi_tran_tram_chim", 871)
    W_30004 = Ward("Xã Hoà Bình", 30004, VietNamDivisionType.XA, "xa_hoa_binh", 871)
    W_30007 = Ward("Xã Tân Công Sính", 30007, VietNamDivisionType.XA, "xa_tan_cong_sinh", 871)
    W_30010 = Ward("Xã Phú Hiệp", 30010, VietNamDivisionType.XA, "xa_phu_hiep", 871)
    W_30013 = Ward("Xã Phú Đức", 30013, VietNamDivisionType.XA, "xa_phu_duc", 871)
    W_30016 = Ward("Xã Phú Thành B", 30016, VietNamDivisionType.XA, "xa_phu_thanh_b", 871)
    W_30019 = Ward("Xã An Hòa", 30019, VietNamDivisionType.XA, "xa_an_hoa", 871)
    W_30022 = Ward("Xã An Long", 30022, VietNamDivisionType.XA, "xa_an_long", 871)
    W_30025 = Ward("Xã Phú Cường", 30025, VietNamDivisionType.XA, "xa_phu_cuong", 871)
    W_30028 = Ward("Xã Phú Ninh", 30028, VietNamDivisionType.XA, "xa_phu_ninh", 871)
    W_30031 = Ward("Xã Phú Thọ", 30031, VietNamDivisionType.XA, "xa_phu_tho", 871)
    W_30034 = Ward("Xã Phú Thành A", 30034, VietNamDivisionType.XA, "xa_phu_thanh_a", 871)
    W_30037 = Ward("Thị trấn Mỹ An", 30037, VietNamDivisionType.THI_TRAN, "thi_tran_my_an", 872)
    W_30040 = Ward("Xã Thạnh Lợi", 30040, VietNamDivisionType.XA, "xa_thanh_loi", 872)
    W_30043 = Ward("Xã Hưng Thạnh", 30043, VietNamDivisionType.XA, "xa_hung_thanh", 872)
    W_30046 = Ward("Xã Trường Xuân", 30046, VietNamDivisionType.XA, "xa_truong_xuan", 872)
    W_30049 = Ward("Xã Tân Kiều", 30049, VietNamDivisionType.XA, "xa_tan_kieu", 872)
    W_30052 = Ward("Xã Mỹ Hòa", 30052, VietNamDivisionType.XA, "xa_my_hoa", 872)
    W_30055 = Ward("Xã Mỹ Quý", 30055, VietNamDivisionType.XA, "xa_my_quy", 872)
    W_30058 = Ward("Xã Mỹ Đông", 30058, VietNamDivisionType.XA, "xa_my_dong", 872)
    W_30061 = Ward("Xã Đốc Binh Kiều", 30061, VietNamDivisionType.XA, "xa_doc_binh_kieu", 872)
    W_30064 = Ward("Xã Mỹ An", 30064, VietNamDivisionType.XA, "xa_my_an", 872)
    W_30067 = Ward("Xã Phú Điền", 30067, VietNamDivisionType.XA, "xa_phu_dien", 872)
    W_30070 = Ward("Xã Láng Biển", 30070, VietNamDivisionType.XA, "xa_lang_bien", 872)
    W_30073 = Ward("Xã Thanh Mỹ", 30073, VietNamDivisionType.XA, "xa_thanh_my", 872)
    W_30076 = Ward("Thị trấn Mỹ Thọ", 30076, VietNamDivisionType.THI_TRAN, "thi_tran_my_tho", 873)
    W_30079 = Ward("Xã Gáo Giồng", 30079, VietNamDivisionType.XA, "xa_gao_giong", 873)
    W_30082 = Ward("Xã Phương Thịnh", 30082, VietNamDivisionType.XA, "xa_phuong_thinh", 873)
    W_30085 = Ward("Xã Ba Sao", 30085, VietNamDivisionType.XA, "xa_ba_sao", 873)
    W_30088 = Ward("Xã Phong Mỹ", 30088, VietNamDivisionType.XA, "xa_phong_my", 873)
    W_30091 = Ward("Xã Tân Nghĩa", 30091, VietNamDivisionType.XA, "xa_tan_nghia", 873)
    W_30094 = Ward("Xã Phương Trà", 30094, VietNamDivisionType.XA, "xa_phuong_tra", 873)
    W_30097 = Ward("Xã Nhị Mỹ", 30097, VietNamDivisionType.XA, "xa_nhi_my", 873)
    W_30100 = Ward("Xã Mỹ Thọ", 30100, VietNamDivisionType.XA, "xa_my_tho", 873)
    W_30103 = Ward("Xã Tân Hội Trung", 30103, VietNamDivisionType.XA, "xa_tan_hoi_trung", 873)
    W_30106 = Ward("Xã An Bình", 30106, VietNamDivisionType.XA, "xa_an_binh", 873)
    W_30109 = Ward("Xã Mỹ Hội", 30109, VietNamDivisionType.XA, "xa_my_hoi", 873)
    W_30112 = Ward("Xã Mỹ Hiệp", 30112, VietNamDivisionType.XA, "xa_my_hiep", 873)
    W_30115 = Ward("Xã Mỹ Long", 30115, VietNamDivisionType.XA, "xa_my_long", 873)
    W_30118 = Ward("Xã Bình Hàng Trung", 30118, VietNamDivisionType.XA, "xa_binh_hang_trung", 873)
    W_30121 = Ward("Xã Mỹ Xương", 30121, VietNamDivisionType.XA, "xa_my_xuong", 873)
    W_30124 = Ward("Xã Bình Hàng Tây", 30124, VietNamDivisionType.XA, "xa_binh_hang_tay", 873)
    W_30127 = Ward("Xã Bình Thạnh", 30127, VietNamDivisionType.XA, "xa_binh_thanh", 873)
    W_30130 = Ward("Thị trấn Thanh Bình", 30130, VietNamDivisionType.THI_TRAN, "thi_tran_thanh_binh", 874)
    W_30133 = Ward("Xã Tân Quới", 30133, VietNamDivisionType.XA, "xa_tan_quoi", 874)
    W_30136 = Ward("Xã Tân Hòa", 30136, VietNamDivisionType.XA, "xa_tan_hoa", 874)
    W_30139 = Ward("Xã An Phong", 30139, VietNamDivisionType.XA, "xa_an_phong", 874)
    W_30142 = Ward("Xã Phú Lợi", 30142, VietNamDivisionType.XA, "xa_phu_loi", 874)
    W_30145 = Ward("Xã Tân Mỹ", 30145, VietNamDivisionType.XA, "xa_tan_my", 874)
    W_30148 = Ward("Xã Bình Tấn", 30148, VietNamDivisionType.XA, "xa_binh_tan", 874)
    W_30151 = Ward("Xã Tân Huề", 30151, VietNamDivisionType.XA, "xa_tan_hue", 874)
    W_30154 = Ward("Xã Tân Bình", 30154, VietNamDivisionType.XA, "xa_tan_binh", 874)
    W_30157 = Ward("Xã Tân Thạnh", 30157, VietNamDivisionType.XA, "xa_tan_thanh", 874)
    W_30160 = Ward("Xã Tân Phú", 30160, VietNamDivisionType.XA, "xa_tan_phu", 874)
    W_30163 = Ward("Xã Bình Thành", 30163, VietNamDivisionType.XA, "xa_binh_thanh", 874)
    W_30166 = Ward("Xã Tân Long", 30166, VietNamDivisionType.XA, "xa_tan_long", 874)
    W_30169 = Ward("Thị trấn Lấp Vò", 30169, VietNamDivisionType.THI_TRAN, "thi_tran_lap_vo", 875)
    W_30172 = Ward("Xã Mỹ An Hưng A", 30172, VietNamDivisionType.XA, "xa_my_an_hung_a", 875)
    W_30175 = Ward("Xã Tân Mỹ", 30175, VietNamDivisionType.XA, "xa_tan_my", 875)
    W_30178 = Ward("Xã Mỹ An Hưng B", 30178, VietNamDivisionType.XA, "xa_my_an_hung_b", 875)
    W_30181 = Ward("Xã Tân Khánh Trung", 30181, VietNamDivisionType.XA, "xa_tan_khanh_trung", 875)
    W_30184 = Ward("Xã Long Hưng A", 30184, VietNamDivisionType.XA, "xa_long_hung_a", 875)
    W_30187 = Ward("Xã Vĩnh Thạnh", 30187, VietNamDivisionType.XA, "xa_vinh_thanh", 875)
    W_30190 = Ward("Xã Long Hưng B", 30190, VietNamDivisionType.XA, "xa_long_hung_b", 875)
    W_30193 = Ward("Xã Bình Thành", 30193, VietNamDivisionType.XA, "xa_binh_thanh", 875)
    W_30196 = Ward("Xã Định An", 30196, VietNamDivisionType.XA, "xa_dinh_an", 875)
    W_30199 = Ward("Xã Định Yên", 30199, VietNamDivisionType.XA, "xa_dinh_yen", 875)
    W_30202 = Ward("Xã Hội An Đông", 30202, VietNamDivisionType.XA, "xa_hoi_an_dong", 875)
    W_30205 = Ward("Xã Bình Thạnh Trung", 30205, VietNamDivisionType.XA, "xa_binh_thanh_trung", 875)
    W_30208 = Ward("Thị trấn Lai Vung", 30208, VietNamDivisionType.THI_TRAN, "thi_tran_lai_vung", 876)
    W_30211 = Ward("Xã Tân Dương", 30211, VietNamDivisionType.XA, "xa_tan_duong", 876)
    W_30214 = Ward("Xã Hòa Thành", 30214, VietNamDivisionType.XA, "xa_hoa_thanh", 876)
    W_30217 = Ward("Xã Long Hậu", 30217, VietNamDivisionType.XA, "xa_long_hau", 876)
    W_30220 = Ward("Xã Tân Phước", 30220, VietNamDivisionType.XA, "xa_tan_phuoc", 876)
    W_30223 = Ward("Xã Hòa Long", 30223, VietNamDivisionType.XA, "xa_hoa_long", 876)
    W_30226 = Ward("Xã Tân Thành", 30226, VietNamDivisionType.XA, "xa_tan_thanh", 876)
    W_30229 = Ward("Xã Long Thắng", 30229, VietNamDivisionType.XA, "xa_long_thang", 876)
    W_30232 = Ward("Xã Vĩnh Thới", 30232, VietNamDivisionType.XA, "xa_vinh_thoi", 876)
    W_30235 = Ward("Xã Tân Hòa", 30235, VietNamDivisionType.XA, "xa_tan_hoa", 876)
    W_30238 = Ward("Xã Định Hòa", 30238, VietNamDivisionType.XA, "xa_dinh_hoa", 876)
    W_30241 = Ward("Xã Phong Hòa", 30241, VietNamDivisionType.XA, "xa_phong_hoa", 876)
    W_30244 = Ward("Thị trấn Cái Tàu Hạ", 30244, VietNamDivisionType.THI_TRAN, "thi_tran_cai_tau_ha", 877)
    W_30247 = Ward("Xã An Hiệp", 30247, VietNamDivisionType.XA, "xa_an_hiep", 877)
    W_30250 = Ward("Xã An Nhơn", 30250, VietNamDivisionType.XA, "xa_an_nhon", 877)
    W_30253 = Ward("Xã Tân Nhuận Đông", 30253, VietNamDivisionType.XA, "xa_tan_nhuan_dong", 877)
    W_30256 = Ward("Xã Tân Bình", 30256, VietNamDivisionType.XA, "xa_tan_binh", 877)
    W_30259 = Ward("Xã Tân Phú Trung", 30259, VietNamDivisionType.XA, "xa_tan_phu_trung", 877)
    W_30262 = Ward("Xã Phú Long", 30262, VietNamDivisionType.XA, "xa_phu_long", 877)
    W_30265 = Ward("Xã An Phú Thuận", 30265, VietNamDivisionType.XA, "xa_an_phu_thuan", 877)
    W_30268 = Ward("Xã Phú Hựu", 30268, VietNamDivisionType.XA, "xa_phu_huu", 877)
    W_30271 = Ward("Xã An Khánh", 30271, VietNamDivisionType.XA, "xa_an_khanh", 877)
    W_30274 = Ward("Xã Tân Phú", 30274, VietNamDivisionType.XA, "xa_tan_phu", 877)
    W_30277 = Ward("Xã Hòa Tân", 30277, VietNamDivisionType.XA, "xa_hoa_tan", 877)
    W_30280 = Ward("Phường Mỹ Bình", 30280, VietNamDivisionType.PHUONG, "phuong_my_binh", 883)
    W_30283 = Ward("Phường Mỹ Long", 30283, VietNamDivisionType.PHUONG, "phuong_my_long", 883)
    W_30285 = Ward("Phường Đông Xuyên", 30285, VietNamDivisionType.PHUONG, "phuong_dong_xuyen", 883)
    W_30286 = Ward("Phường Mỹ Xuyên", 30286, VietNamDivisionType.PHUONG, "phuong_my_xuyen", 883)
    W_30289 = Ward("Phường Bình Đức", 30289, VietNamDivisionType.PHUONG, "phuong_binh_duc", 883)
    W_30292 = Ward("Phường Bình Khánh", 30292, VietNamDivisionType.PHUONG, "phuong_binh_khanh", 883)
    W_30295 = Ward("Phường Mỹ Phước", 30295, VietNamDivisionType.PHUONG, "phuong_my_phuoc", 883)
    W_30298 = Ward("Phường Mỹ Quý", 30298, VietNamDivisionType.PHUONG, "phuong_my_quy", 883)
    W_30301 = Ward("Phường Mỹ Thới", 30301, VietNamDivisionType.PHUONG, "phuong_my_thoi", 883)
    W_30304 = Ward("Phường Mỹ Thạnh", 30304, VietNamDivisionType.PHUONG, "phuong_my_thanh", 883)
    W_30307 = Ward("Phường Mỹ Hòa", 30307, VietNamDivisionType.PHUONG, "phuong_my_hoa", 883)
    W_30310 = Ward("Xã Mỹ Khánh", 30310, VietNamDivisionType.XA, "xa_my_khanh", 883)
    W_30313 = Ward("Xã Mỹ Hoà Hưng", 30313, VietNamDivisionType.XA, "xa_my_hoa_hung", 883)
    W_30316 = Ward("Phường Châu Phú B", 30316, VietNamDivisionType.PHUONG, "phuong_chau_phu_b", 884)
    W_30319 = Ward("Phường Châu Phú A", 30319, VietNamDivisionType.PHUONG, "phuong_chau_phu_a", 884)
    W_30322 = Ward("Phường Vĩnh Mỹ", 30322, VietNamDivisionType.PHUONG, "phuong_vinh_my", 884)
    W_30325 = Ward("Phường Núi Sam", 30325, VietNamDivisionType.PHUONG, "phuong_nui_sam", 884)
    W_30328 = Ward("Phường Vĩnh Ngươn", 30328, VietNamDivisionType.PHUONG, "phuong_vinh_nguon", 884)
    W_30331 = Ward("Xã Vĩnh Tế", 30331, VietNamDivisionType.XA, "xa_vinh_te", 884)
    W_30334 = Ward("Xã Vĩnh Châu", 30334, VietNamDivisionType.XA, "xa_vinh_chau", 884)
    W_30337 = Ward("Thị trấn An Phú", 30337, VietNamDivisionType.THI_TRAN, "thi_tran_an_phu", 886)
    W_30340 = Ward("Xã Khánh An", 30340, VietNamDivisionType.XA, "xa_khanh_an", 886)
    W_30341 = Ward("Thị trấn Long Bình", 30341, VietNamDivisionType.THI_TRAN, "thi_tran_long_binh", 886)
    W_30343 = Ward("Xã Khánh Bình", 30343, VietNamDivisionType.XA, "xa_khanh_binh", 886)
    W_30346 = Ward("Xã Quốc Thái", 30346, VietNamDivisionType.XA, "xa_quoc_thai", 886)
    W_30349 = Ward("Xã Nhơn Hội", 30349, VietNamDivisionType.XA, "xa_nhon_hoi", 886)
    W_30352 = Ward("Xã Phú Hữu", 30352, VietNamDivisionType.XA, "xa_phu_huu", 886)
    W_30355 = Ward("Xã Phú Hội", 30355, VietNamDivisionType.XA, "xa_phu_hoi", 886)
    W_30358 = Ward("Xã Phước Hưng", 30358, VietNamDivisionType.XA, "xa_phuoc_hung", 886)
    W_30361 = Ward("Xã Vĩnh Lộc", 30361, VietNamDivisionType.XA, "xa_vinh_loc", 886)
    W_30364 = Ward("Xã Vĩnh Hậu", 30364, VietNamDivisionType.XA, "xa_vinh_hau", 886)
    W_30367 = Ward("Xã Vĩnh Trường", 30367, VietNamDivisionType.XA, "xa_vinh_truong", 886)
    W_30370 = Ward("Xã Vĩnh Hội Đông", 30370, VietNamDivisionType.XA, "xa_vinh_hoi_dong", 886)
    W_30373 = Ward("Xã Đa Phước", 30373, VietNamDivisionType.XA, "xa_da_phuoc", 886)
    W_30376 = Ward("Phường Long Thạnh", 30376, VietNamDivisionType.PHUONG, "phuong_long_thanh", 887)
    W_30377 = Ward("Phường Long Hưng", 30377, VietNamDivisionType.PHUONG, "phuong_long_hung", 887)
    W_30378 = Ward("Phường Long Châu", 30378, VietNamDivisionType.PHUONG, "phuong_long_chau", 887)
    W_30379 = Ward("Xã Phú Lộc", 30379, VietNamDivisionType.XA, "xa_phu_loc", 887)
    W_30382 = Ward("Xã Vĩnh Xương", 30382, VietNamDivisionType.XA, "xa_vinh_xuong", 887)
    W_30385 = Ward("Xã Vĩnh Hòa", 30385, VietNamDivisionType.XA, "xa_vinh_hoa", 887)
    W_30387 = Ward("Xã Tân Thạnh", 30387, VietNamDivisionType.XA, "xa_tan_thanh", 887)
    W_30388 = Ward("Xã Tân An", 30388, VietNamDivisionType.XA, "xa_tan_an", 887)
    W_30391 = Ward("Xã Long An", 30391, VietNamDivisionType.XA, "xa_long_an", 887)
    W_30394 = Ward("Phường Long Phú", 30394, VietNamDivisionType.PHUONG, "phuong_long_phu", 887)
    W_30397 = Ward("Xã Châu Phong", 30397, VietNamDivisionType.XA, "xa_chau_phong", 887)
    W_30400 = Ward("Xã Phú Vĩnh", 30400, VietNamDivisionType.XA, "xa_phu_vinh", 887)
    W_30403 = Ward("Xã Lê Chánh", 30403, VietNamDivisionType.XA, "xa_le_chanh", 887)
    W_30412 = Ward("Phường Long Sơn", 30412, VietNamDivisionType.PHUONG, "phuong_long_son", 887)
    W_30406 = Ward("Thị trấn Phú Mỹ", 30406, VietNamDivisionType.THI_TRAN, "thi_tran_phu_my", 888)
    W_30409 = Ward("Thị trấn Chợ Vàm", 30409, VietNamDivisionType.THI_TRAN, "thi_tran_cho_vam", 888)
    W_30415 = Ward("Xã Long Hoà", 30415, VietNamDivisionType.XA, "xa_long_hoa", 888)
    W_30418 = Ward("Xã Phú Long", 30418, VietNamDivisionType.XA, "xa_phu_long", 888)
    W_30421 = Ward("Xã Phú Lâm", 30421, VietNamDivisionType.XA, "xa_phu_lam", 888)
    W_30424 = Ward("Xã Phú Hiệp", 30424, VietNamDivisionType.XA, "xa_phu_hiep", 888)
    W_30427 = Ward("Xã Phú Thạnh", 30427, VietNamDivisionType.XA, "xa_phu_thanh", 888)
    W_30430 = Ward("Xã Hoà Lạc", 30430, VietNamDivisionType.XA, "xa_hoa_lac", 888)
    W_30433 = Ward("Xã Phú Thành", 30433, VietNamDivisionType.XA, "xa_phu_thanh", 888)
    W_30436 = Ward("Xã Phú An", 30436, VietNamDivisionType.XA, "xa_phu_an", 888)
    W_30439 = Ward("Xã Phú Xuân", 30439, VietNamDivisionType.XA, "xa_phu_xuan", 888)
    W_30442 = Ward("Xã Hiệp Xương", 30442, VietNamDivisionType.XA, "xa_hiep_xuong", 888)
    W_30445 = Ward("Xã Phú Bình", 30445, VietNamDivisionType.XA, "xa_phu_binh", 888)
    W_30448 = Ward("Xã Phú Thọ", 30448, VietNamDivisionType.XA, "xa_phu_tho", 888)
    W_30451 = Ward("Xã Phú Hưng", 30451, VietNamDivisionType.XA, "xa_phu_hung", 888)
    W_30454 = Ward("Xã Bình Thạnh Đông", 30454, VietNamDivisionType.XA, "xa_binh_thanh_dong", 888)
    W_30457 = Ward("Xã Tân Hòa", 30457, VietNamDivisionType.XA, "xa_tan_hoa", 888)
    W_30460 = Ward("Xã Tân Trung", 30460, VietNamDivisionType.XA, "xa_tan_trung", 888)
    W_30463 = Ward("Thị trấn Cái Dầu", 30463, VietNamDivisionType.THI_TRAN, "thi_tran_cai_dau", 889)
    W_30466 = Ward("Xã Khánh Hòa", 30466, VietNamDivisionType.XA, "xa_khanh_hoa", 889)
    W_30469 = Ward("Xã Mỹ Đức", 30469, VietNamDivisionType.XA, "xa_my_duc", 889)
    W_30472 = Ward("Xã Mỹ Phú", 30472, VietNamDivisionType.XA, "xa_my_phu", 889)
    W_30475 = Ward("Xã Ô Long Vỹ", 30475, VietNamDivisionType.XA, "xa_o_long_vy", 889)
    W_30478 = Ward("Thị trấn Vĩnh Thạnh Trung", 30478, VietNamDivisionType.THI_TRAN, "thi_tran_vinh_thanh_trung", 889)
    W_30481 = Ward("Xã Thạnh Mỹ Tây", 30481, VietNamDivisionType.XA, "xa_thanh_my_tay", 889)
    W_30484 = Ward("Xã Bình Long", 30484, VietNamDivisionType.XA, "xa_binh_long", 889)
    W_30487 = Ward("Xã Bình Mỹ", 30487, VietNamDivisionType.XA, "xa_binh_my", 889)
    W_30490 = Ward("Xã Bình Thủy", 30490, VietNamDivisionType.XA, "xa_binh_thuy", 889)
    W_30493 = Ward("Xã Đào Hữu Cảnh", 30493, VietNamDivisionType.XA, "xa_dao_huu_canh", 889)
    W_30496 = Ward("Xã Bình Phú", 30496, VietNamDivisionType.XA, "xa_binh_phu", 889)
    W_30499 = Ward("Xã Bình Chánh", 30499, VietNamDivisionType.XA, "xa_binh_chanh", 889)
    W_30502 = Ward("Thị trấn Nhà Bàng", 30502, VietNamDivisionType.THI_TRAN, "thi_tran_nha_bang", 890)
    W_30505 = Ward("Thị trấn Chi Lăng", 30505, VietNamDivisionType.THI_TRAN, "thi_tran_chi_lang", 890)
    W_30508 = Ward("Xã Núi Voi", 30508, VietNamDivisionType.XA, "xa_nui_voi", 890)
    W_30511 = Ward("Xã Nhơn Hưng", 30511, VietNamDivisionType.XA, "xa_nhon_hung", 890)
    W_30514 = Ward("Xã An Phú", 30514, VietNamDivisionType.XA, "xa_an_phu", 890)
    W_30517 = Ward("Xã Thới Sơn", 30517, VietNamDivisionType.XA, "xa_thoi_son", 890)
    W_30520 = Ward("Thị trấn Tịnh Biên", 30520, VietNamDivisionType.THI_TRAN, "thi_tran_tinh_bien", 890)
    W_30523 = Ward("Xã Văn Giáo", 30523, VietNamDivisionType.XA, "xa_van_giao", 890)
    W_30526 = Ward("Xã An Cư", 30526, VietNamDivisionType.XA, "xa_an_cu", 890)
    W_30529 = Ward("Xã An Nông", 30529, VietNamDivisionType.XA, "xa_an_nong", 890)
    W_30532 = Ward("Xã Vĩnh Trung", 30532, VietNamDivisionType.XA, "xa_vinh_trung", 890)
    W_30535 = Ward("Xã Tân Lợi", 30535, VietNamDivisionType.XA, "xa_tan_loi", 890)
    W_30538 = Ward("Xã An Hảo", 30538, VietNamDivisionType.XA, "xa_an_hao", 890)
    W_30541 = Ward("Xã Tân Lập", 30541, VietNamDivisionType.XA, "xa_tan_lap", 890)
    W_30544 = Ward("Thị trấn Tri Tôn", 30544, VietNamDivisionType.THI_TRAN, "thi_tran_tri_ton", 891)
    W_30547 = Ward("Thị trấn Ba Chúc", 30547, VietNamDivisionType.THI_TRAN, "thi_tran_ba_chuc", 891)
    W_30550 = Ward("Xã Lạc Quới", 30550, VietNamDivisionType.XA, "xa_lac_quoi", 891)
    W_30553 = Ward("Xã Lê Trì", 30553, VietNamDivisionType.XA, "xa_le_tri", 891)
    W_30556 = Ward("Xã Vĩnh Gia", 30556, VietNamDivisionType.XA, "xa_vinh_gia", 891)
    W_30559 = Ward("Xã Vĩnh Phước", 30559, VietNamDivisionType.XA, "xa_vinh_phuoc", 891)
    W_30562 = Ward("Xã Châu Lăng", 30562, VietNamDivisionType.XA, "xa_chau_lang", 891)
    W_30565 = Ward("Xã Lương Phi", 30565, VietNamDivisionType.XA, "xa_luong_phi", 891)
    W_30568 = Ward("Xã Lương An Trà", 30568, VietNamDivisionType.XA, "xa_luong_an_tra", 891)
    W_30571 = Ward("Xã Tà Đảnh", 30571, VietNamDivisionType.XA, "xa_ta_danh", 891)
    W_30574 = Ward("Xã Núi Tô", 30574, VietNamDivisionType.XA, "xa_nui_to", 891)
    W_30577 = Ward("Xã An Tức", 30577, VietNamDivisionType.XA, "xa_an_tuc", 891)
    W_30580 = Ward("Thị trấn Cô Tô", 30580, VietNamDivisionType.THI_TRAN, "thi_tran_co_to", 891)
    W_30583 = Ward("Xã Tân Tuyến", 30583, VietNamDivisionType.XA, "xa_tan_tuyen", 891)
    W_30586 = Ward("Xã Ô Lâm", 30586, VietNamDivisionType.XA, "xa_o_lam", 891)
    W_30589 = Ward("Thị trấn An Châu", 30589, VietNamDivisionType.THI_TRAN, "thi_tran_an_chau", 892)
    W_30592 = Ward("Xã An Hòa", 30592, VietNamDivisionType.XA, "xa_an_hoa", 892)
    W_30595 = Ward("Xã Cần Đăng", 30595, VietNamDivisionType.XA, "xa_can_dang", 892)
    W_30598 = Ward("Xã Vĩnh Hanh", 30598, VietNamDivisionType.XA, "xa_vinh_hanh", 892)
    W_30601 = Ward("Xã Bình Thạnh", 30601, VietNamDivisionType.XA, "xa_binh_thanh", 892)
    W_30604 = Ward("Thị trấn Vĩnh Bình", 30604, VietNamDivisionType.THI_TRAN, "thi_tran_vinh_binh", 892)
    W_30607 = Ward("Xã Bình Hòa", 30607, VietNamDivisionType.XA, "xa_binh_hoa", 892)
    W_30610 = Ward("Xã Vĩnh An", 30610, VietNamDivisionType.XA, "xa_vinh_an", 892)
    W_30613 = Ward("Xã Hòa Bình Thạnh", 30613, VietNamDivisionType.XA, "xa_hoa_binh_thanh", 892)
    W_30616 = Ward("Xã Vĩnh Lợi", 30616, VietNamDivisionType.XA, "xa_vinh_loi", 892)
    W_30619 = Ward("Xã Vĩnh Nhuận", 30619, VietNamDivisionType.XA, "xa_vinh_nhuan", 892)
    W_30622 = Ward("Xã Tân Phú", 30622, VietNamDivisionType.XA, "xa_tan_phu", 892)
    W_30625 = Ward("Xã Vĩnh Thành", 30625, VietNamDivisionType.XA, "xa_vinh_thanh", 892)
    W_30628 = Ward("Thị trấn Chợ Mới", 30628, VietNamDivisionType.THI_TRAN, "thi_tran_cho_moi", 893)
    W_30631 = Ward("Thị trấn Mỹ Luông", 30631, VietNamDivisionType.THI_TRAN, "thi_tran_my_luong", 893)
    W_30634 = Ward("Xã Kiến An", 30634, VietNamDivisionType.XA, "xa_kien_an", 893)
    W_30637 = Ward("Xã Mỹ Hội Đông", 30637, VietNamDivisionType.XA, "xa_my_hoi_dong", 893)
    W_30640 = Ward("Xã Long Điền A", 30640, VietNamDivisionType.XA, "xa_long_dien_a", 893)
    W_30643 = Ward("Xã Tấn Mỹ", 30643, VietNamDivisionType.XA, "xa_tan_my", 893)
    W_30646 = Ward("Xã Long Điền B", 30646, VietNamDivisionType.XA, "xa_long_dien_b", 893)
    W_30649 = Ward("Xã Kiến Thành", 30649, VietNamDivisionType.XA, "xa_kien_thanh", 893)
    W_30652 = Ward("Xã Mỹ Hiệp", 30652, VietNamDivisionType.XA, "xa_my_hiep", 893)
    W_30655 = Ward("Xã Mỹ An", 30655, VietNamDivisionType.XA, "xa_my_an", 893)
    W_30658 = Ward("Xã Nhơn Mỹ", 30658, VietNamDivisionType.XA, "xa_nhon_my", 893)
    W_30661 = Ward("Xã Long Giang", 30661, VietNamDivisionType.XA, "xa_long_giang", 893)
    W_30664 = Ward("Xã Long Kiến", 30664, VietNamDivisionType.XA, "xa_long_kien", 893)
    W_30667 = Ward("Xã Bình Phước Xuân", 30667, VietNamDivisionType.XA, "xa_binh_phuoc_xuan", 893)
    W_30670 = Ward("Xã An Thạnh Trung", 30670, VietNamDivisionType.XA, "xa_an_thanh_trung", 893)
    W_30673 = Ward("Xã Hội An", 30673, VietNamDivisionType.XA, "xa_hoi_an", 893)
    W_30676 = Ward("Xã Hòa Bình", 30676, VietNamDivisionType.XA, "xa_hoa_binh", 893)
    W_30679 = Ward("Xã Hòa An", 30679, VietNamDivisionType.XA, "xa_hoa_an", 893)
    W_30682 = Ward("Thị trấn Núi Sập", 30682, VietNamDivisionType.THI_TRAN, "thi_tran_nui_sap", 894)
    W_30685 = Ward("Thị trấn Phú Hoà", 30685, VietNamDivisionType.THI_TRAN, "thi_tran_phu_hoa", 894)
    W_30688 = Ward("Thị trấn Óc Eo", 30688, VietNamDivisionType.THI_TRAN, "thi_tran_oc_eo", 894)
    W_30691 = Ward("Xã Tây Phú", 30691, VietNamDivisionType.XA, "xa_tay_phu", 894)
    W_30692 = Ward("Xã An Bình", 30692, VietNamDivisionType.XA, "xa_an_binh", 894)
    W_30694 = Ward("Xã Vĩnh Phú", 30694, VietNamDivisionType.XA, "xa_vinh_phu", 894)
    W_30697 = Ward("Xã Vĩnh Trạch", 30697, VietNamDivisionType.XA, "xa_vinh_trach", 894)
    W_30700 = Ward("Xã Phú Thuận", 30700, VietNamDivisionType.XA, "xa_phu_thuan", 894)
    W_30703 = Ward("Xã Vĩnh Chánh", 30703, VietNamDivisionType.XA, "xa_vinh_chanh", 894)
    W_30706 = Ward("Xã Định Mỹ", 30706, VietNamDivisionType.XA, "xa_dinh_my", 894)
    W_30709 = Ward("Xã Định Thành", 30709, VietNamDivisionType.XA, "xa_dinh_thanh", 894)
    W_30712 = Ward("Xã Mỹ Phú Đông", 30712, VietNamDivisionType.XA, "xa_my_phu_dong", 894)
    W_30715 = Ward("Xã Vọng Đông", 30715, VietNamDivisionType.XA, "xa_vong_dong", 894)
    W_30718 = Ward("Xã Vĩnh Khánh", 30718, VietNamDivisionType.XA, "xa_vinh_khanh", 894)
    W_30721 = Ward("Xã Thoại Giang", 30721, VietNamDivisionType.XA, "xa_thoai_giang", 894)
    W_30724 = Ward("Xã Bình Thành", 30724, VietNamDivisionType.XA, "xa_binh_thanh", 894)
    W_30727 = Ward("Xã Vọng Thê", 30727, VietNamDivisionType.XA, "xa_vong_the", 894)
    W_30730 = Ward("Phường Vĩnh Thanh Vân", 30730, VietNamDivisionType.PHUONG, "phuong_vinh_thanh_van", 899)
    W_30733 = Ward("Phường Vĩnh Thanh", 30733, VietNamDivisionType.PHUONG, "phuong_vinh_thanh", 899)
    W_30736 = Ward("Phường Vĩnh Quang", 30736, VietNamDivisionType.PHUONG, "phuong_vinh_quang", 899)
    W_30739 = Ward("Phường Vĩnh Hiệp", 30739, VietNamDivisionType.PHUONG, "phuong_vinh_hiep", 899)
    W_30742 = Ward("Phường Vĩnh Bảo", 30742, VietNamDivisionType.PHUONG, "phuong_vinh_bao", 899)
    W_30745 = Ward("Phường Vĩnh Lạc", 30745, VietNamDivisionType.PHUONG, "phuong_vinh_lac", 899)
    W_30748 = Ward("Phường An Hòa", 30748, VietNamDivisionType.PHUONG, "phuong_an_hoa", 899)
    W_30751 = Ward("Phường An Bình", 30751, VietNamDivisionType.PHUONG, "phuong_an_binh", 899)
    W_30754 = Ward("Phường Rạch Sỏi", 30754, VietNamDivisionType.PHUONG, "phuong_rach_soi", 899)
    W_30757 = Ward("Phường Vĩnh Lợi", 30757, VietNamDivisionType.PHUONG, "phuong_vinh_loi", 899)
    W_30760 = Ward("Phường Vĩnh Thông", 30760, VietNamDivisionType.PHUONG, "phuong_vinh_thong", 899)
    W_30763 = Ward("Xã Phi Thông", 30763, VietNamDivisionType.XA, "xa_phi_thong", 899)
    W_30766 = Ward("Phường Tô Châu", 30766, VietNamDivisionType.PHUONG, "phuong_to_chau", 900)
    W_30769 = Ward("Phường Đông Hồ", 30769, VietNamDivisionType.PHUONG, "phuong_dong_ho", 900)
    W_30772 = Ward("Phường Bình San", 30772, VietNamDivisionType.PHUONG, "phuong_binh_san", 900)
    W_30775 = Ward("Phường Pháo Đài", 30775, VietNamDivisionType.PHUONG, "phuong_phao_dai", 900)
    W_30778 = Ward("Phường Mỹ Đức", 30778, VietNamDivisionType.PHUONG, "phuong_my_duc", 900)
    W_30781 = Ward("Xã Tiên Hải", 30781, VietNamDivisionType.XA, "xa_tien_hai", 900)
    W_30784 = Ward("Xã Thuận Yên", 30784, VietNamDivisionType.XA, "xa_thuan_yen", 900)
    W_30787 = Ward("Thị trấn Kiên Lương", 30787, VietNamDivisionType.THI_TRAN, "thi_tran_kien_luong", 902)
    W_30790 = Ward("Xã Kiên Bình", 30790, VietNamDivisionType.XA, "xa_kien_binh", 902)
    W_30802 = Ward("Xã Hòa Điền", 30802, VietNamDivisionType.XA, "xa_hoa_dien", 902)
    W_30805 = Ward("Xã Dương Hòa", 30805, VietNamDivisionType.XA, "xa_duong_hoa", 902)
    W_30808 = Ward("Xã Bình An", 30808, VietNamDivisionType.XA, "xa_binh_an", 902)
    W_30809 = Ward("Xã Bình Trị", 30809, VietNamDivisionType.XA, "xa_binh_tri", 902)
    W_30811 = Ward("Xã Sơn Hải", 30811, VietNamDivisionType.XA, "xa_son_hai", 902)
    W_30814 = Ward("Xã Hòn Nghệ", 30814, VietNamDivisionType.XA, "xa_hon_nghe", 902)
    W_30817 = Ward("Thị trấn Hòn Đất", 30817, VietNamDivisionType.THI_TRAN, "thi_tran_hon_dat", 903)
    W_30820 = Ward("Thị trấn Sóc Sơn", 30820, VietNamDivisionType.THI_TRAN, "thi_tran_soc_son", 903)
    W_30823 = Ward("Xã Bình Sơn", 30823, VietNamDivisionType.XA, "xa_binh_son", 903)
    W_30826 = Ward("Xã Bình Giang", 30826, VietNamDivisionType.XA, "xa_binh_giang", 903)
    W_30828 = Ward("Xã Mỹ Thái", 30828, VietNamDivisionType.XA, "xa_my_thai", 903)
    W_30829 = Ward("Xã Nam Thái Sơn", 30829, VietNamDivisionType.XA, "xa_nam_thai_son", 903)
    W_30832 = Ward("Xã Mỹ Hiệp Sơn", 30832, VietNamDivisionType.XA, "xa_my_hiep_son", 903)
    W_30835 = Ward("Xã Sơn Kiên", 30835, VietNamDivisionType.XA, "xa_son_kien", 903)
    W_30836 = Ward("Xã Sơn Bình", 30836, VietNamDivisionType.XA, "xa_son_binh", 903)
    W_30838 = Ward("Xã Mỹ Thuận", 30838, VietNamDivisionType.XA, "xa_my_thuan", 903)
    W_30840 = Ward("Xã Lình Huỳnh", 30840, VietNamDivisionType.XA, "xa_linh_huynh", 903)
    W_30841 = Ward("Xã Thổ Sơn", 30841, VietNamDivisionType.XA, "xa_tho_son", 903)
    W_30844 = Ward("Xã Mỹ Lâm", 30844, VietNamDivisionType.XA, "xa_my_lam", 903)
    W_30847 = Ward("Xã Mỹ Phước", 30847, VietNamDivisionType.XA, "xa_my_phuoc", 903)
    W_30850 = Ward("Thị trấn Tân Hiệp", 30850, VietNamDivisionType.THI_TRAN, "thi_tran_tan_hiep", 904)
    W_30853 = Ward("Xã Tân Hội", 30853, VietNamDivisionType.XA, "xa_tan_hoi", 904)
    W_30856 = Ward("Xã Tân Thành", 30856, VietNamDivisionType.XA, "xa_tan_thanh", 904)
    W_30859 = Ward("Xã Tân Hiệp B", 30859, VietNamDivisionType.XA, "xa_tan_hiep_b", 904)
    W_30860 = Ward("Xã Tân Hoà", 30860, VietNamDivisionType.XA, "xa_tan_hoa", 904)
    W_30862 = Ward("Xã Thạnh Đông B", 30862, VietNamDivisionType.XA, "xa_thanh_dong_b", 904)
    W_30865 = Ward("Xã Thạnh Đông", 30865, VietNamDivisionType.XA, "xa_thanh_dong", 904)
    W_30868 = Ward("Xã Tân Hiệp A", 30868, VietNamDivisionType.XA, "xa_tan_hiep_a", 904)
    W_30871 = Ward("Xã Tân An", 30871, VietNamDivisionType.XA, "xa_tan_an", 904)
    W_30874 = Ward("Xã Thạnh Đông A", 30874, VietNamDivisionType.XA, "xa_thanh_dong_a", 904)
    W_30877 = Ward("Xã Thạnh Trị", 30877, VietNamDivisionType.XA, "xa_thanh_tri", 904)
    W_30880 = Ward("Thị trấn Minh Lương", 30880, VietNamDivisionType.THI_TRAN, "thi_tran_minh_luong", 905)
    W_30883 = Ward("Xã Mong Thọ A", 30883, VietNamDivisionType.XA, "xa_mong_tho_a", 905)
    W_30886 = Ward("Xã Mong Thọ B", 30886, VietNamDivisionType.XA, "xa_mong_tho_b", 905)
    W_30887 = Ward("Xã Mong Thọ", 30887, VietNamDivisionType.XA, "xa_mong_tho", 905)
    W_30889 = Ward("Xã Giục Tượng", 30889, VietNamDivisionType.XA, "xa_giuc_tuong", 905)
    W_30892 = Ward("Xã Vĩnh Hòa Hiệp", 30892, VietNamDivisionType.XA, "xa_vinh_hoa_hiep", 905)
    W_30893 = Ward("Xã Vĩnh Hoà Phú", 30893, VietNamDivisionType.XA, "xa_vinh_hoa_phu", 905)
    W_30895 = Ward("Xã Minh Hòa", 30895, VietNamDivisionType.XA, "xa_minh_hoa", 905)
    W_30898 = Ward("Xã Bình An", 30898, VietNamDivisionType.XA, "xa_binh_an", 905)
    W_30901 = Ward("Xã Thạnh Lộc", 30901, VietNamDivisionType.XA, "xa_thanh_loc", 905)
    W_30904 = Ward("Thị trấn Giồng Riềng", 30904, VietNamDivisionType.THI_TRAN, "thi_tran_giong_rieng", 906)
    W_30907 = Ward("Xã Thạnh Hưng", 30907, VietNamDivisionType.XA, "xa_thanh_hung", 906)
    W_30910 = Ward("Xã Thạnh Phước", 30910, VietNamDivisionType.XA, "xa_thanh_phuoc", 906)
    W_30913 = Ward("Xã Thạnh Lộc", 30913, VietNamDivisionType.XA, "xa_thanh_loc", 906)
    W_30916 = Ward("Xã Thạnh Hòa", 30916, VietNamDivisionType.XA, "xa_thanh_hoa", 906)
    W_30917 = Ward("Xã Thạnh Bình", 30917, VietNamDivisionType.XA, "xa_thanh_binh", 906)
    W_30919 = Ward("Xã Bàn Thạch", 30919, VietNamDivisionType.XA, "xa_ban_thach", 906)
    W_30922 = Ward("Xã Bàn Tân Định", 30922, VietNamDivisionType.XA, "xa_ban_tan_dinh", 906)
    W_30925 = Ward("Xã Ngọc Thành", 30925, VietNamDivisionType.XA, "xa_ngoc_thanh", 906)
    W_30928 = Ward("Xã Ngọc Chúc", 30928, VietNamDivisionType.XA, "xa_ngoc_chuc", 906)
    W_30931 = Ward("Xã Ngọc Thuận", 30931, VietNamDivisionType.XA, "xa_ngoc_thuan", 906)
    W_30934 = Ward("Xã Hòa Hưng", 30934, VietNamDivisionType.XA, "xa_hoa_hung", 906)
    W_30937 = Ward("Xã Hoà Lợi", 30937, VietNamDivisionType.XA, "xa_hoa_loi", 906)
    W_30940 = Ward("Xã Hoà An", 30940, VietNamDivisionType.XA, "xa_hoa_an", 906)
    W_30943 = Ward("Xã Long Thạnh", 30943, VietNamDivisionType.XA, "xa_long_thanh", 906)
    W_30946 = Ward("Xã Vĩnh Thạnh", 30946, VietNamDivisionType.XA, "xa_vinh_thanh", 906)
    W_30947 = Ward("Xã Vĩnh Phú", 30947, VietNamDivisionType.XA, "xa_vinh_phu", 906)
    W_30949 = Ward("Xã Hòa Thuận", 30949, VietNamDivisionType.XA, "xa_hoa_thuan", 906)
    W_30950 = Ward("Xã Ngọc Hoà", 30950, VietNamDivisionType.XA, "xa_ngoc_hoa", 906)
    W_30952 = Ward("Thị trấn Gò Quao", 30952, VietNamDivisionType.THI_TRAN, "thi_tran_go_quao", 907)
    W_30955 = Ward("Xã Vĩnh Hòa Hưng Bắc", 30955, VietNamDivisionType.XA, "xa_vinh_hoa_hung_bac", 907)
    W_30958 = Ward("Xã Định Hòa", 30958, VietNamDivisionType.XA, "xa_dinh_hoa", 907)
    W_30961 = Ward("Xã Thới Quản", 30961, VietNamDivisionType.XA, "xa_thoi_quan", 907)
    W_30964 = Ward("Xã Định An", 30964, VietNamDivisionType.XA, "xa_dinh_an", 907)
    W_30967 = Ward("Xã Thủy Liễu", 30967, VietNamDivisionType.XA, "xa_thuy_lieu", 907)
    W_30970 = Ward("Xã Vĩnh Hòa Hưng Nam", 30970, VietNamDivisionType.XA, "xa_vinh_hoa_hung_nam", 907)
    W_30973 = Ward("Xã Vĩnh Phước A", 30973, VietNamDivisionType.XA, "xa_vinh_phuoc_a", 907)
    W_30976 = Ward("Xã Vĩnh Phước B", 30976, VietNamDivisionType.XA, "xa_vinh_phuoc_b", 907)
    W_30979 = Ward("Xã Vĩnh Tuy", 30979, VietNamDivisionType.XA, "xa_vinh_tuy", 907)
    W_30982 = Ward("Xã Vĩnh Thắng", 30982, VietNamDivisionType.XA, "xa_vinh_thang", 907)
    W_30985 = Ward("Thị trấn Thứ Ba", 30985, VietNamDivisionType.THI_TRAN, "thi_tran_thu_ba", 908)
    W_30988 = Ward("Xã Tây Yên", 30988, VietNamDivisionType.XA, "xa_tay_yen", 908)
    W_30991 = Ward("Xã Tây Yên A", 30991, VietNamDivisionType.XA, "xa_tay_yen_a", 908)
    W_30994 = Ward("Xã Nam Yên", 30994, VietNamDivisionType.XA, "xa_nam_yen", 908)
    W_30997 = Ward("Xã Hưng Yên", 30997, VietNamDivisionType.XA, "xa_hung_yen", 908)
    W_31000 = Ward("Xã Nam Thái", 31000, VietNamDivisionType.XA, "xa_nam_thai", 908)
    W_31003 = Ward("Xã Nam Thái A", 31003, VietNamDivisionType.XA, "xa_nam_thai_a", 908)
    W_31006 = Ward("Xã Đông Thái", 31006, VietNamDivisionType.XA, "xa_dong_thai", 908)
    W_31009 = Ward("Xã Đông Yên", 31009, VietNamDivisionType.XA, "xa_dong_yen", 908)
    W_31018 = Ward("Thị trấn Thứ Mười Một", 31018, VietNamDivisionType.THI_TRAN, "thi_tran_thu_muoi_mot", 909)
    W_31021 = Ward("Xã Thuận Hoà", 31021, VietNamDivisionType.XA, "xa_thuan_hoa", 909)
    W_31024 = Ward("Xã Đông Hòa", 31024, VietNamDivisionType.XA, "xa_dong_hoa", 909)
    W_31030 = Ward("Xã Đông Thạnh", 31030, VietNamDivisionType.XA, "xa_dong_thanh", 909)
    W_31031 = Ward("Xã Tân Thạnh", 31031, VietNamDivisionType.XA, "xa_tan_thanh", 909)
    W_31033 = Ward("Xã Đông Hưng", 31033, VietNamDivisionType.XA, "xa_dong_hung", 909)
    W_31036 = Ward("Xã Đông Hưng A", 31036, VietNamDivisionType.XA, "xa_dong_hung_a", 909)
    W_31039 = Ward("Xã Đông Hưng B", 31039, VietNamDivisionType.XA, "xa_dong_hung_b", 909)
    W_31042 = Ward("Xã Vân Khánh", 31042, VietNamDivisionType.XA, "xa_van_khanh", 909)
    W_31045 = Ward("Xã Vân Khánh Đông", 31045, VietNamDivisionType.XA, "xa_van_khanh_dong", 909)
    W_31048 = Ward("Xã Vân Khánh Tây", 31048, VietNamDivisionType.XA, "xa_van_khanh_tay", 909)
    W_31051 = Ward("Thị trấn Vĩnh Thuận", 31051, VietNamDivisionType.THI_TRAN, "thi_tran_vinh_thuan", 910)
    W_31060 = Ward("Xã Vĩnh Bình Bắc", 31060, VietNamDivisionType.XA, "xa_vinh_binh_bac", 910)
    W_31063 = Ward("Xã Vĩnh Bình Nam", 31063, VietNamDivisionType.XA, "xa_vinh_binh_nam", 910)
    W_31064 = Ward("Xã Bình Minh", 31064, VietNamDivisionType.XA, "xa_binh_minh", 910)
    W_31069 = Ward("Xã Vĩnh Thuận", 31069, VietNamDivisionType.XA, "xa_vinh_thuan", 910)
    W_31072 = Ward("Xã Tân Thuận", 31072, VietNamDivisionType.XA, "xa_tan_thuan", 910)
    W_31074 = Ward("Xã Phong Đông", 31074, VietNamDivisionType.XA, "xa_phong_dong", 910)
    W_31075 = Ward("Xã Vĩnh Phong", 31075, VietNamDivisionType.XA, "xa_vinh_phong", 910)
    W_31078 = Ward("Phường Dương Đông", 31078, VietNamDivisionType.PHUONG, "phuong_duong_dong", 911)
    W_31081 = Ward("Phường An Thới", 31081, VietNamDivisionType.PHUONG, "phuong_an_thoi", 911)
    W_31084 = Ward("Xã Cửa Cạn", 31084, VietNamDivisionType.XA, "xa_cua_can", 911)
    W_31087 = Ward("Xã Gành Dầu", 31087, VietNamDivisionType.XA, "xa_ganh_dau", 911)
    W_31090 = Ward("Xã Cửa Dương", 31090, VietNamDivisionType.XA, "xa_cua_duong", 911)
    W_31093 = Ward("Xã Hàm Ninh", 31093, VietNamDivisionType.XA, "xa_ham_ninh", 911)
    W_31096 = Ward("Xã Dương Tơ", 31096, VietNamDivisionType.XA, "xa_duong_to", 911)
    W_31102 = Ward("Xã Bãi Thơm", 31102, VietNamDivisionType.XA, "xa_bai_thom", 911)
    W_31105 = Ward("Xã Thổ Châu", 31105, VietNamDivisionType.XA, "xa_tho_chau", 911)
    W_31108 = Ward("Xã Hòn Tre", 31108, VietNamDivisionType.XA, "xa_hon_tre", 912)
    W_31111 = Ward("Xã Lại Sơn", 31111, VietNamDivisionType.XA, "xa_lai_son", 912)
    W_31114 = Ward("Xã An Sơn", 31114, VietNamDivisionType.XA, "xa_an_son", 912)
    W_31115 = Ward("Xã Nam Du", 31115, VietNamDivisionType.XA, "xa_nam_du", 912)
    W_31012 = Ward("Xã Thạnh Yên", 31012, VietNamDivisionType.XA, "xa_thanh_yen", 913)
    W_31015 = Ward("Xã Thạnh Yên A", 31015, VietNamDivisionType.XA, "xa_thanh_yen_a", 913)
    W_31027 = Ward("Xã An Minh Bắc", 31027, VietNamDivisionType.XA, "xa_an_minh_bac", 913)
    W_31054 = Ward("Xã Vĩnh Hòa", 31054, VietNamDivisionType.XA, "xa_vinh_hoa", 913)
    W_31057 = Ward("Xã Hoà Chánh", 31057, VietNamDivisionType.XA, "xa_hoa_chanh", 913)
    W_31066 = Ward("Xã Minh Thuận", 31066, VietNamDivisionType.XA, "xa_minh_thuan", 913)
    W_30791 = Ward("Xã Vĩnh Phú", 30791, VietNamDivisionType.XA, "xa_vinh_phu", 914)
    W_30793 = Ward("Xã Vĩnh Điều", 30793, VietNamDivisionType.XA, "xa_vinh_dieu", 914)
    W_30796 = Ward("Xã Tân Khánh Hòa", 30796, VietNamDivisionType.XA, "xa_tan_khanh_hoa", 914)
    W_30797 = Ward("Xã Phú Lợi", 30797, VietNamDivisionType.XA, "xa_phu_loi", 914)
    W_30799 = Ward("Xã Phú Mỹ", 30799, VietNamDivisionType.XA, "xa_phu_my", 914)
    W_31117 = Ward("Phường Cái Khế", 31117, VietNamDivisionType.PHUONG, "phuong_cai_khe", 916)
    W_31120 = Ward("Phường An Hòa", 31120, VietNamDivisionType.PHUONG, "phuong_an_hoa", 916)
    W_31123 = Ward("Phường Thới Bình", 31123, VietNamDivisionType.PHUONG, "phuong_thoi_binh", 916)
    W_31126 = Ward("Phường An Nghiệp", 31126, VietNamDivisionType.PHUONG, "phuong_an_nghiep", 916)
    W_31129 = Ward("Phường An Cư", 31129, VietNamDivisionType.PHUONG, "phuong_an_cu", 916)
    W_31135 = Ward("Phường Tân An", 31135, VietNamDivisionType.PHUONG, "phuong_tan_an", 916)
    W_31141 = Ward("Phường An Phú", 31141, VietNamDivisionType.PHUONG, "phuong_an_phu", 916)
    W_31144 = Ward("Phường Xuân Khánh", 31144, VietNamDivisionType.PHUONG, "phuong_xuan_khanh", 916)
    W_31147 = Ward("Phường Hưng Lợi", 31147, VietNamDivisionType.PHUONG, "phuong_hung_loi", 916)
    W_31149 = Ward("Phường An Khánh", 31149, VietNamDivisionType.PHUONG, "phuong_an_khanh", 916)
    W_31150 = Ward("Phường An Bình", 31150, VietNamDivisionType.PHUONG, "phuong_an_binh", 916)
    W_31153 = Ward("Phường Châu Văn Liêm", 31153, VietNamDivisionType.PHUONG, "phuong_chau_van_liem", 917)
    W_31154 = Ward("Phường Thới Hòa", 31154, VietNamDivisionType.PHUONG, "phuong_thoi_hoa", 917)
    W_31156 = Ward("Phường Thới Long", 31156, VietNamDivisionType.PHUONG, "phuong_thoi_long", 917)
    W_31157 = Ward("Phường Long Hưng", 31157, VietNamDivisionType.PHUONG, "phuong_long_hung", 917)
    W_31159 = Ward("Phường Thới An", 31159, VietNamDivisionType.PHUONG, "phuong_thoi_an", 917)
    W_31162 = Ward("Phường Phước Thới", 31162, VietNamDivisionType.PHUONG, "phuong_phuoc_thoi", 917)
    W_31165 = Ward("Phường Trường Lạc", 31165, VietNamDivisionType.PHUONG, "phuong_truong_lac", 917)
    W_31168 = Ward("Phường Bình Thủy", 31168, VietNamDivisionType.PHUONG, "phuong_binh_thuy", 918)
    W_31169 = Ward("Phường Trà An", 31169, VietNamDivisionType.PHUONG, "phuong_tra_an", 918)
    W_31171 = Ward("Phường Trà Nóc", 31171, VietNamDivisionType.PHUONG, "phuong_tra_noc", 918)
    W_31174 = Ward("Phường Thới An Đông", 31174, VietNamDivisionType.PHUONG, "phuong_thoi_an_dong", 918)
    W_31177 = Ward("Phường An Thới", 31177, VietNamDivisionType.PHUONG, "phuong_an_thoi", 918)
    W_31178 = Ward("Phường Bùi Hữu Nghĩa", 31178, VietNamDivisionType.PHUONG, "phuong_bui_huu_nghia", 918)
    W_31180 = Ward("Phường Long Hòa", 31180, VietNamDivisionType.PHUONG, "phuong_long_hoa", 918)
    W_31183 = Ward("Phường Long Tuyền", 31183, VietNamDivisionType.PHUONG, "phuong_long_tuyen", 918)
    W_31186 = Ward("Phường Lê Bình", 31186, VietNamDivisionType.PHUONG, "phuong_le_binh", 919)
    W_31189 = Ward("Phường Hưng Phú", 31189, VietNamDivisionType.PHUONG, "phuong_hung_phu", 919)
    W_31192 = Ward("Phường Hưng Thạnh", 31192, VietNamDivisionType.PHUONG, "phuong_hung_thanh", 919)
    W_31195 = Ward("Phường Ba Láng", 31195, VietNamDivisionType.PHUONG, "phuong_ba_lang", 919)
    W_31198 = Ward("Phường Thường Thạnh", 31198, VietNamDivisionType.PHUONG, "phuong_thuong_thanh", 919)
    W_31201 = Ward("Phường Phú Thứ", 31201, VietNamDivisionType.PHUONG, "phuong_phu_thu", 919)
    W_31204 = Ward("Phường Tân Phú", 31204, VietNamDivisionType.PHUONG, "phuong_tan_phu", 919)
    W_31207 = Ward("Phường Thốt Nốt", 31207, VietNamDivisionType.PHUONG, "phuong_thot_not", 923)
    W_31210 = Ward("Phường Thới Thuận", 31210, VietNamDivisionType.PHUONG, "phuong_thoi_thuan", 923)
    W_31212 = Ward("Phường Thuận An", 31212, VietNamDivisionType.PHUONG, "phuong_thuan_an", 923)
    W_31213 = Ward("Phường Tân Lộc", 31213, VietNamDivisionType.PHUONG, "phuong_tan_loc", 923)
    W_31216 = Ward("Phường Trung Nhứt", 31216, VietNamDivisionType.PHUONG, "phuong_trung_nhut", 923)
    W_31217 = Ward("Phường Thạnh Hoà", 31217, VietNamDivisionType.PHUONG, "phuong_thanh_hoa", 923)
    W_31219 = Ward("Phường Trung Kiên", 31219, VietNamDivisionType.PHUONG, "phuong_trung_kien", 923)
    W_31227 = Ward("Phường Tân Hưng", 31227, VietNamDivisionType.PHUONG, "phuong_tan_hung", 923)
    W_31228 = Ward("Phường Thuận Hưng", 31228, VietNamDivisionType.PHUONG, "phuong_thuan_hung", 923)
    W_31211 = Ward("Xã Vĩnh Bình", 31211, VietNamDivisionType.XA, "xa_vinh_binh", 924)
    W_31231 = Ward("Thị trấn Thanh An", 31231, VietNamDivisionType.THI_TRAN, "thi_tran_thanh_an", 924)
    W_31232 = Ward("Thị trấn Vĩnh Thạnh", 31232, VietNamDivisionType.THI_TRAN, "thi_tran_vinh_thanh", 924)
    W_31234 = Ward("Xã Thạnh Mỹ", 31234, VietNamDivisionType.XA, "xa_thanh_my", 924)
    W_31237 = Ward("Xã Vĩnh Trinh", 31237, VietNamDivisionType.XA, "xa_vinh_trinh", 924)
    W_31240 = Ward("Xã Thạnh An", 31240, VietNamDivisionType.XA, "xa_thanh_an", 924)
    W_31241 = Ward("Xã Thạnh Tiến", 31241, VietNamDivisionType.XA, "xa_thanh_tien", 924)
    W_31243 = Ward("Xã Thạnh Thắng", 31243, VietNamDivisionType.XA, "xa_thanh_thang", 924)
    W_31244 = Ward("Xã Thạnh Lợi", 31244, VietNamDivisionType.XA, "xa_thanh_loi", 924)
    W_31246 = Ward("Xã Thạnh Qưới", 31246, VietNamDivisionType.XA, "xa_thanh_quoi", 924)
    W_31252 = Ward("Xã Thạnh Lộc", 31252, VietNamDivisionType.XA, "xa_thanh_loc", 924)
    W_31222 = Ward("Xã Trung An", 31222, VietNamDivisionType.XA, "xa_trung_an", 925)
    W_31225 = Ward("Xã Trung Thạnh", 31225, VietNamDivisionType.XA, "xa_trung_thanh", 925)
    W_31249 = Ward("Xã Thạnh Phú", 31249, VietNamDivisionType.XA, "xa_thanh_phu", 925)
    W_31255 = Ward("Xã Trung Hưng", 31255, VietNamDivisionType.XA, "xa_trung_hung", 925)
    W_31261 = Ward("Thị trấn Cờ Đỏ", 31261, VietNamDivisionType.THI_TRAN, "thi_tran_co_do", 925)
    W_31264 = Ward("Xã Thới Hưng", 31264, VietNamDivisionType.XA, "xa_thoi_hung", 925)
    W_31273 = Ward("Xã Đông Hiệp", 31273, VietNamDivisionType.XA, "xa_dong_hiep", 925)
    W_31274 = Ward("Xã Đông Thắng", 31274, VietNamDivisionType.XA, "xa_dong_thang", 925)
    W_31276 = Ward("Xã Thới Đông", 31276, VietNamDivisionType.XA, "xa_thoi_dong", 925)
    W_31277 = Ward("Xã Thới Xuân", 31277, VietNamDivisionType.XA, "xa_thoi_xuan", 925)
    W_31299 = Ward("Thị trấn Phong Điền", 31299, VietNamDivisionType.THI_TRAN, "thi_tran_phong_dien", 926)
    W_31300 = Ward("Xã Nhơn Ái", 31300, VietNamDivisionType.XA, "xa_nhon_ai", 926)
    W_31303 = Ward("Xã Giai Xuân", 31303, VietNamDivisionType.XA, "xa_giai_xuan", 926)
    W_31306 = Ward("Xã Tân Thới", 31306, VietNamDivisionType.XA, "xa_tan_thoi", 926)
    W_31309 = Ward("Xã Trường Long", 31309, VietNamDivisionType.XA, "xa_truong_long", 926)
    W_31312 = Ward("Xã Mỹ Khánh", 31312, VietNamDivisionType.XA, "xa_my_khanh", 926)
    W_31315 = Ward("Xã Nhơn Nghĩa", 31315, VietNamDivisionType.XA, "xa_nhon_nghia", 926)
    W_31258 = Ward("Thị trấn Thới Lai", 31258, VietNamDivisionType.THI_TRAN, "thi_tran_thoi_lai", 927)
    W_31267 = Ward("Xã Thới Thạnh", 31267, VietNamDivisionType.XA, "xa_thoi_thanh", 927)
    W_31268 = Ward("Xã Tân Thạnh", 31268, VietNamDivisionType.XA, "xa_tan_thanh", 927)
    W_31270 = Ward("Xã Xuân Thắng", 31270, VietNamDivisionType.XA, "xa_xuan_thang", 927)
    W_31279 = Ward("Xã Đông Bình", 31279, VietNamDivisionType.XA, "xa_dong_binh", 927)
    W_31282 = Ward("Xã Đông Thuận", 31282, VietNamDivisionType.XA, "xa_dong_thuan", 927)
    W_31285 = Ward("Xã Thới Tân", 31285, VietNamDivisionType.XA, "xa_thoi_tan", 927)
    W_31286 = Ward("Xã Trường Thắng", 31286, VietNamDivisionType.XA, "xa_truong_thang", 927)
    W_31288 = Ward("Xã Định Môn", 31288, VietNamDivisionType.XA, "xa_dinh_mon", 927)
    W_31291 = Ward("Xã Trường Thành", 31291, VietNamDivisionType.XA, "xa_truong_thanh", 927)
    W_31294 = Ward("Xã Trường Xuân", 31294, VietNamDivisionType.XA, "xa_truong_xuan", 927)
    W_31297 = Ward("Xã Trường Xuân A", 31297, VietNamDivisionType.XA, "xa_truong_xuan_a", 927)
    W_31298 = Ward("Xã Trường Xuân B", 31298, VietNamDivisionType.XA, "xa_truong_xuan_b", 927)
    W_31318 = Ward("Phường I", 31318, VietNamDivisionType.PHUONG, "phuong_i", 930)
    W_31321 = Ward("Phường III", 31321, VietNamDivisionType.PHUONG, "phuong_iii", 930)
    W_31324 = Ward("Phường IV", 31324, VietNamDivisionType.PHUONG, "phuong_iv", 930)
    W_31327 = Ward("Phường V", 31327, VietNamDivisionType.PHUONG, "phuong_v", 930)
    W_31330 = Ward("Phường VII", 31330, VietNamDivisionType.PHUONG, "phuong_vii", 930)
    W_31333 = Ward("Xã Vị Tân", 31333, VietNamDivisionType.XA, "xa_vi_tan", 930)
    W_31336 = Ward("Xã Hoả Lựu", 31336, VietNamDivisionType.XA, "xa_hoa_luu", 930)
    W_31338 = Ward("Xã Tân Tiến", 31338, VietNamDivisionType.XA, "xa_tan_tien", 930)
    W_31339 = Ward("Xã Hoả Tiến", 31339, VietNamDivisionType.XA, "xa_hoa_tien", 930)
    W_31340 = Ward("Phường Ngã Bảy", 31340, VietNamDivisionType.PHUONG, "phuong_nga_bay", 931)
    W_31341 = Ward("Phường Lái Hiếu", 31341, VietNamDivisionType.PHUONG, "phuong_lai_hieu", 931)
    W_31343 = Ward("Phường Hiệp Thành", 31343, VietNamDivisionType.PHUONG, "phuong_hiep_thanh", 931)
    W_31344 = Ward("Phường Hiệp Lợi", 31344, VietNamDivisionType.PHUONG, "phuong_hiep_loi", 931)
    W_31411 = Ward("Xã Đại Thành", 31411, VietNamDivisionType.XA, "xa_dai_thanh", 931)
    W_31414 = Ward("Xã Tân Thành", 31414, VietNamDivisionType.XA, "xa_tan_thanh", 931)
    W_31342 = Ward("Thị trấn Một Ngàn", 31342, VietNamDivisionType.THI_TRAN, "thi_tran_mot_ngan", 932)
    W_31345 = Ward("Xã Tân Hoà", 31345, VietNamDivisionType.XA, "xa_tan_hoa", 932)
    W_31346 = Ward("Thị trấn Bảy Ngàn", 31346, VietNamDivisionType.THI_TRAN, "thi_tran_bay_ngan", 932)
    W_31348 = Ward("Xã Trường Long Tây", 31348, VietNamDivisionType.XA, "xa_truong_long_tay", 932)
    W_31351 = Ward("Xã Trường Long A", 31351, VietNamDivisionType.XA, "xa_truong_long_a", 932)
    W_31357 = Ward("Xã Nhơn Nghĩa A", 31357, VietNamDivisionType.XA, "xa_nhon_nghia_a", 932)
    W_31359 = Ward("Thị trấn Rạch Gòi", 31359, VietNamDivisionType.THI_TRAN, "thi_tran_rach_goi", 932)
    W_31360 = Ward("Xã Thạnh Xuân", 31360, VietNamDivisionType.XA, "xa_thanh_xuan", 932)
    W_31362 = Ward("Thị trấn Cái Tắc", 31362, VietNamDivisionType.THI_TRAN, "thi_tran_cai_tac", 932)
    W_31363 = Ward("Xã Tân Phú Thạnh", 31363, VietNamDivisionType.XA, "xa_tan_phu_thanh", 932)
    W_31366 = Ward("Thị trấn Ngã Sáu", 31366, VietNamDivisionType.THI_TRAN, "thi_tran_nga_sau", 933)
    W_31369 = Ward("Xã Đông Thạnh", 31369, VietNamDivisionType.XA, "xa_dong_thanh", 933)
    W_31375 = Ward("Xã Đông Phú", 31375, VietNamDivisionType.XA, "xa_dong_phu", 933)
    W_31378 = Ward("Xã Phú Hữu", 31378, VietNamDivisionType.XA, "xa_phu_huu", 933)
    W_31379 = Ward("Xã Phú Tân", 31379, VietNamDivisionType.XA, "xa_phu_tan", 933)
    W_31381 = Ward("Thị trấn Mái Dầm", 31381, VietNamDivisionType.THI_TRAN, "thi_tran_mai_dam", 933)
    W_31384 = Ward("Xã Đông Phước", 31384, VietNamDivisionType.XA, "xa_dong_phuoc", 933)
    W_31387 = Ward("Xã Đông Phước A", 31387, VietNamDivisionType.XA, "xa_dong_phuoc_a", 933)
    W_31393 = Ward("Thị trấn Kinh Cùng", 31393, VietNamDivisionType.THI_TRAN, "thi_tran_kinh_cung", 934)
    W_31396 = Ward("Thị trấn Cây Dương", 31396, VietNamDivisionType.THI_TRAN, "thi_tran_cay_duong", 934)
    W_31399 = Ward("Xã Tân Bình", 31399, VietNamDivisionType.XA, "xa_tan_binh", 934)
    W_31402 = Ward("Xã Bình Thành", 31402, VietNamDivisionType.XA, "xa_binh_thanh", 934)
    W_31405 = Ward("Xã Thạnh Hòa", 31405, VietNamDivisionType.XA, "xa_thanh_hoa", 934)
    W_31408 = Ward("Xã Long Thạnh", 31408, VietNamDivisionType.XA, "xa_long_thanh", 934)
    W_31417 = Ward("Xã Phụng Hiệp", 31417, VietNamDivisionType.XA, "xa_phung_hiep", 934)
    W_31420 = Ward("Xã Hòa Mỹ", 31420, VietNamDivisionType.XA, "xa_hoa_my", 934)
    W_31423 = Ward("Xã Hòa An", 31423, VietNamDivisionType.XA, "xa_hoa_an", 934)
    W_31426 = Ward("Xã Phương Bình", 31426, VietNamDivisionType.XA, "xa_phuong_binh", 934)
    W_31429 = Ward("Xã Hiệp Hưng", 31429, VietNamDivisionType.XA, "xa_hiep_hung", 934)
    W_31432 = Ward("Xã Tân Phước Hưng", 31432, VietNamDivisionType.XA, "xa_tan_phuoc_hung", 934)
    W_31433 = Ward("Thị trấn Búng Tàu", 31433, VietNamDivisionType.THI_TRAN, "thi_tran_bung_tau", 934)
    W_31435 = Ward("Xã Phương Phú", 31435, VietNamDivisionType.XA, "xa_phuong_phu", 934)
    W_31438 = Ward("Xã Tân Long", 31438, VietNamDivisionType.XA, "xa_tan_long", 934)
    W_31441 = Ward("Thị trấn Nàng Mau", 31441, VietNamDivisionType.THI_TRAN, "thi_tran_nang_mau", 935)
    W_31444 = Ward("Xã Vị Trung", 31444, VietNamDivisionType.XA, "xa_vi_trung", 935)
    W_31447 = Ward("Xã Vị Thuỷ", 31447, VietNamDivisionType.XA, "xa_vi_thuy", 935)
    W_31450 = Ward("Xã Vị Thắng", 31450, VietNamDivisionType.XA, "xa_vi_thang", 935)
    W_31453 = Ward("Xã Vĩnh Thuận Tây", 31453, VietNamDivisionType.XA, "xa_vinh_thuan_tay", 935)
    W_31456 = Ward("Xã Vĩnh Trung", 31456, VietNamDivisionType.XA, "xa_vinh_trung", 935)
    W_31459 = Ward("Xã Vĩnh Tường", 31459, VietNamDivisionType.XA, "xa_vinh_tuong", 935)
    W_31462 = Ward("Xã Vị Đông", 31462, VietNamDivisionType.XA, "xa_vi_dong", 935)
    W_31465 = Ward("Xã Vị Thanh", 31465, VietNamDivisionType.XA, "xa_vi_thanh", 935)
    W_31468 = Ward("Xã Vị Bình", 31468, VietNamDivisionType.XA, "xa_vi_binh", 935)
    W_31483 = Ward("Xã Thuận Hưng", 31483, VietNamDivisionType.XA, "xa_thuan_hung", 936)
    W_31484 = Ward("Xã Thuận Hòa", 31484, VietNamDivisionType.XA, "xa_thuan_hoa", 936)
    W_31486 = Ward("Xã Vĩnh Thuận Đông", 31486, VietNamDivisionType.XA, "xa_vinh_thuan_dong", 936)
    W_31489 = Ward("Thị trấn Vĩnh Viễn", 31489, VietNamDivisionType.THI_TRAN, "thi_tran_vinh_vien", 936)
    W_31490 = Ward("Xã Vĩnh Viễn A", 31490, VietNamDivisionType.XA, "xa_vinh_vien_a", 936)
    W_31492 = Ward("Xã Lương Tâm", 31492, VietNamDivisionType.XA, "xa_luong_tam", 936)
    W_31493 = Ward("Xã Lương Nghĩa", 31493, VietNamDivisionType.XA, "xa_luong_nghia", 936)
    W_31495 = Ward("Xã Xà Phiên", 31495, VietNamDivisionType.XA, "xa_xa_phien", 936)
    W_31471 = Ward("Phường Thuận An", 31471, VietNamDivisionType.PHUONG, "phuong_thuan_an", 937)
    W_31472 = Ward("Phường Trà Lồng", 31472, VietNamDivisionType.PHUONG, "phuong_tra_long", 937)
    W_31473 = Ward("Phường Bình Thạnh", 31473, VietNamDivisionType.PHUONG, "phuong_binh_thanh", 937)
    W_31474 = Ward("Xã Long Bình", 31474, VietNamDivisionType.XA, "xa_long_binh", 937)
    W_31475 = Ward("Phường Vĩnh Tường", 31475, VietNamDivisionType.PHUONG, "phuong_vinh_tuong", 937)
    W_31477 = Ward("Xã Long Trị", 31477, VietNamDivisionType.XA, "xa_long_tri", 937)
    W_31478 = Ward("Xã Long Trị A", 31478, VietNamDivisionType.XA, "xa_long_tri_a", 937)
    W_31480 = Ward("Xã Long Phú", 31480, VietNamDivisionType.XA, "xa_long_phu", 937)
    W_31481 = Ward("Xã Tân Phú", 31481, VietNamDivisionType.XA, "xa_tan_phu", 937)
    W_31498 = Ward("Phường 5", 31498, VietNamDivisionType.PHUONG, "phuong_5", 941)
    W_31501 = Ward("Phường 7", 31501, VietNamDivisionType.PHUONG, "phuong_7", 941)
    W_31504 = Ward("Phường 8", 31504, VietNamDivisionType.PHUONG, "phuong_8", 941)
    W_31507 = Ward("Phường 6", 31507, VietNamDivisionType.PHUONG, "phuong_6", 941)
    W_31510 = Ward("Phường 2", 31510, VietNamDivisionType.PHUONG, "phuong_2", 941)
    W_31513 = Ward("Phường 1", 31513, VietNamDivisionType.PHUONG, "phuong_1", 941)
    W_31516 = Ward("Phường 4", 31516, VietNamDivisionType.PHUONG, "phuong_4", 941)
    W_31519 = Ward("Phường 3", 31519, VietNamDivisionType.PHUONG, "phuong_3", 941)
    W_31522 = Ward("Phường 9", 31522, VietNamDivisionType.PHUONG, "phuong_9", 941)
    W_31525 = Ward("Phường 10", 31525, VietNamDivisionType.PHUONG, "phuong_10", 941)
    W_31569 = Ward("Thị trấn Châu Thành", 31569, VietNamDivisionType.THI_TRAN, "thi_tran_chau_thanh", 942)
    W_31570 = Ward("Xã Hồ Đắc Kiện", 31570, VietNamDivisionType.XA, "xa_ho_dac_kien", 942)
    W_31573 = Ward("Xã Phú Tâm", 31573, VietNamDivisionType.XA, "xa_phu_tam", 942)
    W_31576 = Ward("Xã Thuận Hòa", 31576, VietNamDivisionType.XA, "xa_thuan_hoa", 942)
    W_31582 = Ward("Xã Phú Tân", 31582, VietNamDivisionType.XA, "xa_phu_tan", 942)
    W_31585 = Ward("Xã Thiện Mỹ", 31585, VietNamDivisionType.XA, "xa_thien_my", 942)
    W_31594 = Ward("Xã An Hiệp", 31594, VietNamDivisionType.XA, "xa_an_hiep", 942)
    W_31600 = Ward("Xã An Ninh", 31600, VietNamDivisionType.XA, "xa_an_ninh", 942)
    W_31528 = Ward("Thị trấn Kế Sách", 31528, VietNamDivisionType.THI_TRAN, "thi_tran_ke_sach", 943)
    W_31531 = Ward("Thị trấn An Lạc Thôn", 31531, VietNamDivisionType.THI_TRAN, "thi_tran_an_lac_thon", 943)
    W_31534 = Ward("Xã Xuân Hòa", 31534, VietNamDivisionType.XA, "xa_xuan_hoa", 943)
    W_31537 = Ward("Xã Phong Nẫm", 31537, VietNamDivisionType.XA, "xa_phong_nam", 943)
    W_31540 = Ward("Xã An Lạc Tây", 31540, VietNamDivisionType.XA, "xa_an_lac_tay", 943)
    W_31543 = Ward("Xã Trinh Phú", 31543, VietNamDivisionType.XA, "xa_trinh_phu", 943)
    W_31546 = Ward("Xã Ba Trinh", 31546, VietNamDivisionType.XA, "xa_ba_trinh", 943)
    W_31549 = Ward("Xã Thới An Hội", 31549, VietNamDivisionType.XA, "xa_thoi_an_hoi", 943)
    W_31552 = Ward("Xã Nhơn Mỹ", 31552, VietNamDivisionType.XA, "xa_nhon_my", 943)
    W_31555 = Ward("Xã Kế Thành", 31555, VietNamDivisionType.XA, "xa_ke_thanh", 943)
    W_31558 = Ward("Xã Kế An", 31558, VietNamDivisionType.XA, "xa_ke_an", 943)
    W_31561 = Ward("Xã Đại Hải", 31561, VietNamDivisionType.XA, "xa_dai_hai", 943)
    W_31564 = Ward("Xã An Mỹ", 31564, VietNamDivisionType.XA, "xa_an_my", 943)
    W_31567 = Ward("Thị trấn Huỳnh Hữu Nghĩa", 31567, VietNamDivisionType.THI_TRAN, "thi_tran_huynh_huu_nghia", 944)
    W_31579 = Ward("Xã Long Hưng", 31579, VietNamDivisionType.XA, "xa_long_hung", 944)
    W_31588 = Ward("Xã Hưng Phú", 31588, VietNamDivisionType.XA, "xa_hung_phu", 944)
    W_31591 = Ward("Xã Mỹ Hương", 31591, VietNamDivisionType.XA, "xa_my_huong", 944)
    W_31597 = Ward("Xã Mỹ Tú", 31597, VietNamDivisionType.XA, "xa_my_tu", 944)
    W_31603 = Ward("Xã Mỹ Phước", 31603, VietNamDivisionType.XA, "xa_my_phuoc", 944)
    W_31606 = Ward("Xã Thuận Hưng", 31606, VietNamDivisionType.XA, "xa_thuan_hung", 944)
    W_31609 = Ward("Xã Mỹ Thuận", 31609, VietNamDivisionType.XA, "xa_my_thuan", 944)
    W_31612 = Ward("Xã Phú Mỹ", 31612, VietNamDivisionType.XA, "xa_phu_my", 944)
    W_31615 = Ward("Thị trấn Cù Lao Dung", 31615, VietNamDivisionType.THI_TRAN, "thi_tran_cu_lao_dung", 945)
    W_31618 = Ward("Xã An Thạnh 1", 31618, VietNamDivisionType.XA, "xa_an_thanh_1", 945)
    W_31621 = Ward("Xã An Thạnh Tây", 31621, VietNamDivisionType.XA, "xa_an_thanh_tay", 945)
    W_31624 = Ward("Xã An Thạnh Đông", 31624, VietNamDivisionType.XA, "xa_an_thanh_dong", 945)
    W_31627 = Ward("Xã Đại Ân 1", 31627, VietNamDivisionType.XA, "xa_dai_an_1", 945)
    W_31630 = Ward("Xã An Thạnh 2", 31630, VietNamDivisionType.XA, "xa_an_thanh_2", 945)
    W_31633 = Ward("Xã An Thạnh 3", 31633, VietNamDivisionType.XA, "xa_an_thanh_3", 945)
    W_31636 = Ward("Xã An Thạnh Nam", 31636, VietNamDivisionType.XA, "xa_an_thanh_nam", 945)
    W_31639 = Ward("Thị trấn Long Phú", 31639, VietNamDivisionType.THI_TRAN, "thi_tran_long_phu", 946)
    W_31642 = Ward("Xã Song Phụng", 31642, VietNamDivisionType.XA, "xa_song_phung", 946)
    W_31645 = Ward("Thị trấn Đại Ngãi", 31645, VietNamDivisionType.THI_TRAN, "thi_tran_dai_ngai", 946)
    W_31648 = Ward("Xã Hậu Thạnh", 31648, VietNamDivisionType.XA, "xa_hau_thanh", 946)
    W_31651 = Ward("Xã Long Đức", 31651, VietNamDivisionType.XA, "xa_long_duc", 946)
    W_31654 = Ward("Xã Trường Khánh", 31654, VietNamDivisionType.XA, "xa_truong_khanh", 946)
    W_31657 = Ward("Xã Phú Hữu", 31657, VietNamDivisionType.XA, "xa_phu_huu", 946)
    W_31660 = Ward("Xã Tân Hưng", 31660, VietNamDivisionType.XA, "xa_tan_hung", 946)
    W_31663 = Ward("Xã Châu Khánh", 31663, VietNamDivisionType.XA, "xa_chau_khanh", 946)
    W_31666 = Ward("Xã Tân Thạnh", 31666, VietNamDivisionType.XA, "xa_tan_thanh", 946)
    W_31669 = Ward("Xã Long Phú", 31669, VietNamDivisionType.XA, "xa_long_phu", 946)
    W_31684 = Ward("Thị trấn Mỹ Xuyên", 31684, VietNamDivisionType.THI_TRAN, "thi_tran_my_xuyen", 947)
    W_31690 = Ward("Xã Đại Tâm", 31690, VietNamDivisionType.XA, "xa_dai_tam", 947)
    W_31693 = Ward("Xã Tham Đôn", 31693, VietNamDivisionType.XA, "xa_tham_don", 947)
    W_31708 = Ward("Xã Thạnh Phú", 31708, VietNamDivisionType.XA, "xa_thanh_phu", 947)
    W_31711 = Ward("Xã Ngọc Đông", 31711, VietNamDivisionType.XA, "xa_ngoc_dong", 947)
    W_31714 = Ward("Xã Thạnh Quới", 31714, VietNamDivisionType.XA, "xa_thanh_quoi", 947)
    W_31717 = Ward("Xã Hòa Tú 1", 31717, VietNamDivisionType.XA, "xa_hoa_tu_1", 947)
    W_31720 = Ward("Xã Gia Hòa 1", 31720, VietNamDivisionType.XA, "xa_gia_hoa_1", 947)
    W_31723 = Ward("Xã Ngọc Tố", 31723, VietNamDivisionType.XA, "xa_ngoc_to", 947)
    W_31726 = Ward("Xã Gia Hòa 2", 31726, VietNamDivisionType.XA, "xa_gia_hoa_2", 947)
    W_31729 = Ward("Xã Hòa Tú II", 31729, VietNamDivisionType.XA, "xa_hoa_tu_ii", 947)
    W_31732 = Ward("Phường 1", 31732, VietNamDivisionType.PHUONG, "phuong_1", 948)
    W_31735 = Ward("Phường 2", 31735, VietNamDivisionType.PHUONG, "phuong_2", 948)
    W_31738 = Ward("Xã Vĩnh Quới", 31738, VietNamDivisionType.XA, "xa_vinh_quoi", 948)
    W_31741 = Ward("Xã Tân Long", 31741, VietNamDivisionType.XA, "xa_tan_long", 948)
    W_31744 = Ward("Xã Long Bình", 31744, VietNamDivisionType.XA, "xa_long_binh", 948)
    W_31747 = Ward("Phường 3", 31747, VietNamDivisionType.PHUONG, "phuong_3", 948)
    W_31750 = Ward("Xã Mỹ Bình", 31750, VietNamDivisionType.XA, "xa_my_binh", 948)
    W_31753 = Ward("Xã Mỹ Quới", 31753, VietNamDivisionType.XA, "xa_my_quoi", 948)
    W_31756 = Ward("Thị trấn Phú Lộc", 31756, VietNamDivisionType.THI_TRAN, "thi_tran_phu_loc", 949)
    W_31757 = Ward("Thị trấn Hưng Lợi", 31757, VietNamDivisionType.THI_TRAN, "thi_tran_hung_loi", 949)
    W_31759 = Ward("Xã Lâm Tân", 31759, VietNamDivisionType.XA, "xa_lam_tan", 949)
    W_31762 = Ward("Xã Thạnh Tân", 31762, VietNamDivisionType.XA, "xa_thanh_tan", 949)
    W_31765 = Ward("Xã Lâm Kiết", 31765, VietNamDivisionType.XA, "xa_lam_kiet", 949)
    W_31768 = Ward("Xã Tuân Tức", 31768, VietNamDivisionType.XA, "xa_tuan_tuc", 949)
    W_31771 = Ward("Xã Vĩnh Thành", 31771, VietNamDivisionType.XA, "xa_vinh_thanh", 949)
    W_31774 = Ward("Xã Thạnh Trị", 31774, VietNamDivisionType.XA, "xa_thanh_tri", 949)
    W_31777 = Ward("Xã Vĩnh Lợi", 31777, VietNamDivisionType.XA, "xa_vinh_loi", 949)
    W_31780 = Ward("Xã Châu Hưng", 31780, VietNamDivisionType.XA, "xa_chau_hung", 949)
    W_31783 = Ward("Phường 1", 31783, VietNamDivisionType.PHUONG, "phuong_1", 950)
    W_31786 = Ward("Xã Hòa Đông", 31786, VietNamDivisionType.XA, "xa_hoa_dong", 950)
    W_31789 = Ward("Phường Khánh Hòa", 31789, VietNamDivisionType.PHUONG, "phuong_khanh_hoa", 950)
    W_31792 = Ward("Xã Vĩnh Hiệp", 31792, VietNamDivisionType.XA, "xa_vinh_hiep", 950)
    W_31795 = Ward("Xã Vĩnh Hải", 31795, VietNamDivisionType.XA, "xa_vinh_hai", 950)
    W_31798 = Ward("Xã Lạc Hòa", 31798, VietNamDivisionType.XA, "xa_lac_hoa", 950)
    W_31801 = Ward("Phường 2", 31801, VietNamDivisionType.PHUONG, "phuong_2", 950)
    W_31804 = Ward("Phường Vĩnh Phước", 31804, VietNamDivisionType.PHUONG, "phuong_vinh_phuoc", 950)
    W_31807 = Ward("Xã Vĩnh Tân", 31807, VietNamDivisionType.XA, "xa_vinh_tan", 950)
    W_31810 = Ward("Xã Lai Hòa", 31810, VietNamDivisionType.XA, "xa_lai_hoa", 950)
    W_31672 = Ward("Xã Đại Ân 2", 31672, VietNamDivisionType.XA, "xa_dai_an_2", 951)
    W_31673 = Ward("Thị trấn Trần Đề", 31673, VietNamDivisionType.THI_TRAN, "thi_tran_tran_de", 951)
    W_31675 = Ward("Xã Liêu Tú", 31675, VietNamDivisionType.XA, "xa_lieu_tu", 951)
    W_31678 = Ward("Xã Lịch Hội Thượng", 31678, VietNamDivisionType.XA, "xa_lich_hoi_thuong", 951)
    W_31679 = Ward("Thị trấn Lịch Hội Thượng", 31679, VietNamDivisionType.THI_TRAN, "thi_tran_lich_hoi_thuong", 951)
    W_31681 = Ward("Xã Trung Bình", 31681, VietNamDivisionType.XA, "xa_trung_binh", 951)
    W_31687 = Ward("Xã Tài Văn", 31687, VietNamDivisionType.XA, "xa_tai_van", 951)
    W_31696 = Ward("Xã Viên An", 31696, VietNamDivisionType.XA, "xa_vien_an", 951)
    W_31699 = Ward("Xã Thạnh Thới An", 31699, VietNamDivisionType.XA, "xa_thanh_thoi_an", 951)
    W_31702 = Ward("Xã Thạnh Thới Thuận", 31702, VietNamDivisionType.XA, "xa_thanh_thoi_thuan", 951)
    W_31705 = Ward("Xã Viên Bình", 31705, VietNamDivisionType.XA, "xa_vien_binh", 951)
    W_31813 = Ward("Phường 2", 31813, VietNamDivisionType.PHUONG, "phuong_2", 954)
    W_31816 = Ward("Phường 3", 31816, VietNamDivisionType.PHUONG, "phuong_3", 954)
    W_31819 = Ward("Phường 5", 31819, VietNamDivisionType.PHUONG, "phuong_5", 954)
    W_31822 = Ward("Phường 7", 31822, VietNamDivisionType.PHUONG, "phuong_7", 954)
    W_31825 = Ward("Phường 1", 31825, VietNamDivisionType.PHUONG, "phuong_1", 954)
    W_31828 = Ward("Phường 8", 31828, VietNamDivisionType.PHUONG, "phuong_8", 954)
    W_31831 = Ward("Phường Nhà Mát", 31831, VietNamDivisionType.PHUONG, "phuong_nha_mat", 954)
    W_31834 = Ward("Xã Vĩnh Trạch", 31834, VietNamDivisionType.XA, "xa_vinh_trach", 954)
    W_31837 = Ward("Xã Vĩnh Trạch Đông", 31837, VietNamDivisionType.XA, "xa_vinh_trach_dong", 954)
    W_31840 = Ward("Xã Hiệp Thành", 31840, VietNamDivisionType.XA, "xa_hiep_thanh", 954)
    W_31843 = Ward("Thị trấn Ngan Dừa", 31843, VietNamDivisionType.THI_TRAN, "thi_tran_ngan_dua", 956)
    W_31846 = Ward("Xã Ninh Quới", 31846, VietNamDivisionType.XA, "xa_ninh_quoi", 956)
    W_31849 = Ward("Xã Ninh Quới A", 31849, VietNamDivisionType.XA, "xa_ninh_quoi_a", 956)
    W_31852 = Ward("Xã Ninh Hòa", 31852, VietNamDivisionType.XA, "xa_ninh_hoa", 956)
    W_31855 = Ward("Xã Lộc Ninh", 31855, VietNamDivisionType.XA, "xa_loc_ninh", 956)
    W_31858 = Ward("Xã Vĩnh Lộc", 31858, VietNamDivisionType.XA, "xa_vinh_loc", 956)
    W_31861 = Ward("Xã Vĩnh Lộc A", 31861, VietNamDivisionType.XA, "xa_vinh_loc_a", 956)
    W_31863 = Ward("Xã Ninh Thạnh Lợi A", 31863, VietNamDivisionType.XA, "xa_ninh_thanh_loi_a", 956)
    W_31864 = Ward("Xã Ninh Thạnh Lợi", 31864, VietNamDivisionType.XA, "xa_ninh_thanh_loi", 956)
    W_31867 = Ward("Thị trấn Phước Long", 31867, VietNamDivisionType.THI_TRAN, "thi_tran_phuoc_long", 957)
    W_31870 = Ward("Xã Vĩnh Phú Đông", 31870, VietNamDivisionType.XA, "xa_vinh_phu_dong", 957)
    W_31873 = Ward("Xã Vĩnh Phú Tây", 31873, VietNamDivisionType.XA, "xa_vinh_phu_tay", 957)
    W_31876 = Ward("Xã Phước Long", 31876, VietNamDivisionType.XA, "xa_phuoc_long", 957)
    W_31879 = Ward("Xã Hưng Phú", 31879, VietNamDivisionType.XA, "xa_hung_phu", 957)
    W_31882 = Ward("Xã Vĩnh Thanh", 31882, VietNamDivisionType.XA, "xa_vinh_thanh", 957)
    W_31885 = Ward("Xã Phong Thạnh Tây A", 31885, VietNamDivisionType.XA, "xa_phong_thanh_tay_a", 957)
    W_31888 = Ward("Xã Phong Thạnh Tây B", 31888, VietNamDivisionType.XA, "xa_phong_thanh_tay_b", 957)
    W_31894 = Ward("Xã Vĩnh Hưng", 31894, VietNamDivisionType.XA, "xa_vinh_hung", 958)
    W_31897 = Ward("Xã Vĩnh Hưng A", 31897, VietNamDivisionType.XA, "xa_vinh_hung_a", 958)
    W_31900 = Ward("Thị trấn Châu Hưng", 31900, VietNamDivisionType.THI_TRAN, "thi_tran_chau_hung", 958)
    W_31903 = Ward("Xã Châu Hưng A", 31903, VietNamDivisionType.XA, "xa_chau_hung_a", 958)
    W_31906 = Ward("Xã Hưng Thành", 31906, VietNamDivisionType.XA, "xa_hung_thanh", 958)
    W_31909 = Ward("Xã Hưng Hội", 31909, VietNamDivisionType.XA, "xa_hung_hoi", 958)
    W_31912 = Ward("Xã Châu Thới", 31912, VietNamDivisionType.XA, "xa_chau_thoi", 958)
    W_31921 = Ward("Xã Long Thạnh", 31921, VietNamDivisionType.XA, "xa_long_thanh", 958)
    W_31942 = Ward("Phường 1", 31942, VietNamDivisionType.PHUONG, "phuong_1", 959)
    W_31945 = Ward("Phường Hộ Phòng", 31945, VietNamDivisionType.PHUONG, "phuong_ho_phong", 959)
    W_31948 = Ward("Xã Phong Thạnh Đông", 31948, VietNamDivisionType.XA, "xa_phong_thanh_dong", 959)
    W_31951 = Ward("Phường Láng Tròn", 31951, VietNamDivisionType.PHUONG, "phuong_lang_tron", 959)
    W_31954 = Ward("Xã Phong Tân", 31954, VietNamDivisionType.XA, "xa_phong_tan", 959)
    W_31957 = Ward("Xã Tân Phong", 31957, VietNamDivisionType.XA, "xa_tan_phong", 959)
    W_31960 = Ward("Xã Phong Thạnh", 31960, VietNamDivisionType.XA, "xa_phong_thanh", 959)
    W_31963 = Ward("Xã Phong Thạnh A", 31963, VietNamDivisionType.XA, "xa_phong_thanh_a", 959)
    W_31966 = Ward("Xã Phong Thạnh Tây", 31966, VietNamDivisionType.XA, "xa_phong_thanh_tay", 959)
    W_31969 = Ward("Xã Tân Thạnh", 31969, VietNamDivisionType.XA, "xa_tan_thanh", 959)
    W_31972 = Ward("Thị trấn Gành Hào", 31972, VietNamDivisionType.THI_TRAN, "thi_tran_ganh_hao", 960)
    W_31975 = Ward("Xã Long Điền Đông", 31975, VietNamDivisionType.XA, "xa_long_dien_dong", 960)
    W_31978 = Ward("Xã Long Điền Đông A", 31978, VietNamDivisionType.XA, "xa_long_dien_dong_a", 960)
    W_31981 = Ward("Xã Long Điền", 31981, VietNamDivisionType.XA, "xa_long_dien", 960)
    W_31984 = Ward("Xã Long Điền Tây", 31984, VietNamDivisionType.XA, "xa_long_dien_tay", 960)
    W_31985 = Ward("Xã Điền Hải", 31985, VietNamDivisionType.XA, "xa_dien_hai", 960)
    W_31987 = Ward("Xã An Trạch", 31987, VietNamDivisionType.XA, "xa_an_trach", 960)
    W_31988 = Ward("Xã An Trạch A", 31988, VietNamDivisionType.XA, "xa_an_trach_a", 960)
    W_31990 = Ward("Xã An Phúc", 31990, VietNamDivisionType.XA, "xa_an_phuc", 960)
    W_31993 = Ward("Xã Định Thành", 31993, VietNamDivisionType.XA, "xa_dinh_thanh", 960)
    W_31996 = Ward("Xã Định Thành A", 31996, VietNamDivisionType.XA, "xa_dinh_thanh_a", 960)
    W_31891 = Ward("Thị trấn Hòa Bình", 31891, VietNamDivisionType.THI_TRAN, "thi_tran_hoa_binh", 961)
    W_31915 = Ward("Xã Minh Diệu", 31915, VietNamDivisionType.XA, "xa_minh_dieu", 961)
    W_31918 = Ward("Xã Vĩnh Bình", 31918, VietNamDivisionType.XA, "xa_vinh_binh", 961)
    W_31924 = Ward("Xã Vĩnh Mỹ B", 31924, VietNamDivisionType.XA, "xa_vinh_my_b", 961)
    W_31927 = Ward("Xã Vĩnh Hậu", 31927, VietNamDivisionType.XA, "xa_vinh_hau", 961)
    W_31930 = Ward("Xã Vĩnh Hậu A", 31930, VietNamDivisionType.XA, "xa_vinh_hau_a", 961)
    W_31933 = Ward("Xã Vĩnh Mỹ A", 31933, VietNamDivisionType.XA, "xa_vinh_my_a", 961)
    W_31936 = Ward("Xã Vĩnh Thịnh", 31936, VietNamDivisionType.XA, "xa_vinh_thinh", 961)
    W_31999 = Ward("Phường 9", 31999, VietNamDivisionType.PHUONG, "phuong_9", 964)
    W_32002 = Ward("Phường 4", 32002, VietNamDivisionType.PHUONG, "phuong_4", 964)
    W_32005 = Ward("Phường 1", 32005, VietNamDivisionType.PHUONG, "phuong_1", 964)
    W_32008 = Ward("Phường 5", 32008, VietNamDivisionType.PHUONG, "phuong_5", 964)
    W_32011 = Ward("Phường 2", 32011, VietNamDivisionType.PHUONG, "phuong_2", 964)
    W_32014 = Ward("Phường 8", 32014, VietNamDivisionType.PHUONG, "phuong_8", 964)
    W_32017 = Ward("Phường 6", 32017, VietNamDivisionType.PHUONG, "phuong_6", 964)
    W_32020 = Ward("Phường 7", 32020, VietNamDivisionType.PHUONG, "phuong_7", 964)
    W_32022 = Ward("Phường Tân Xuyên", 32022, VietNamDivisionType.PHUONG, "phuong_tan_xuyen", 964)
    W_32023 = Ward("Xã An Xuyên", 32023, VietNamDivisionType.XA, "xa_an_xuyen", 964)
    W_32025 = Ward("Phường Tân Thành", 32025, VietNamDivisionType.PHUONG, "phuong_tan_thanh", 964)
    W_32026 = Ward("Xã Tân Thành", 32026, VietNamDivisionType.XA, "xa_tan_thanh", 964)
    W_32029 = Ward("Xã Tắc Vân", 32029, VietNamDivisionType.XA, "xa_tac_van", 964)
    W_32032 = Ward("Xã Lý Văn Lâm", 32032, VietNamDivisionType.XA, "xa_ly_van_lam", 964)
    W_32035 = Ward("Xã Định Bình", 32035, VietNamDivisionType.XA, "xa_dinh_binh", 964)
    W_32038 = Ward("Xã Hòa Thành", 32038, VietNamDivisionType.XA, "xa_hoa_thanh", 964)
    W_32041 = Ward("Xã Hòa Tân", 32041, VietNamDivisionType.XA, "xa_hoa_tan", 964)
    W_32044 = Ward("Thị trấn U Minh", 32044, VietNamDivisionType.THI_TRAN, "thi_tran_u_minh", 966)
    W_32047 = Ward("Xã Khánh Hòa", 32047, VietNamDivisionType.XA, "xa_khanh_hoa", 966)
    W_32048 = Ward("Xã Khánh Thuận", 32048, VietNamDivisionType.XA, "xa_khanh_thuan", 966)
    W_32050 = Ward("Xã Khánh Tiến", 32050, VietNamDivisionType.XA, "xa_khanh_tien", 966)
    W_32053 = Ward("Xã Nguyễn Phích", 32053, VietNamDivisionType.XA, "xa_nguyen_phich", 966)
    W_32056 = Ward("Xã Khánh Lâm", 32056, VietNamDivisionType.XA, "xa_khanh_lam", 966)
    W_32059 = Ward("Xã Khánh An", 32059, VietNamDivisionType.XA, "xa_khanh_an", 966)
    W_32062 = Ward("Xã Khánh Hội", 32062, VietNamDivisionType.XA, "xa_khanh_hoi", 966)
    W_32065 = Ward("Thị trấn Thới Bình", 32065, VietNamDivisionType.THI_TRAN, "thi_tran_thoi_binh", 967)
    W_32068 = Ward("Xã Biển Bạch", 32068, VietNamDivisionType.XA, "xa_bien_bach", 967)
    W_32069 = Ward("Xã Tân Bằng", 32069, VietNamDivisionType.XA, "xa_tan_bang", 967)
    W_32071 = Ward("Xã Trí Phải", 32071, VietNamDivisionType.XA, "xa_tri_phai", 967)
    W_32072 = Ward("Xã Trí Lực", 32072, VietNamDivisionType.XA, "xa_tri_luc", 967)
    W_32074 = Ward("Xã Biển Bạch Đông", 32074, VietNamDivisionType.XA, "xa_bien_bach_dong", 967)
    W_32077 = Ward("Xã Thới Bình", 32077, VietNamDivisionType.XA, "xa_thoi_binh", 967)
    W_32080 = Ward("Xã Tân Phú", 32080, VietNamDivisionType.XA, "xa_tan_phu", 967)
    W_32083 = Ward("Xã Tân Lộc Bắc", 32083, VietNamDivisionType.XA, "xa_tan_loc_bac", 967)
    W_32086 = Ward("Xã Tân Lộc", 32086, VietNamDivisionType.XA, "xa_tan_loc", 967)
    W_32089 = Ward("Xã Tân Lộc Đông", 32089, VietNamDivisionType.XA, "xa_tan_loc_dong", 967)
    W_32092 = Ward("Xã Hồ Thị Kỷ", 32092, VietNamDivisionType.XA, "xa_ho_thi_ky", 967)
    W_32095 = Ward("Thị trấn Trần Văn Thời", 32095, VietNamDivisionType.THI_TRAN, "thi_tran_tran_van_thoi", 968)
    W_32098 = Ward("Thị trấn Sông Đốc", 32098, VietNamDivisionType.THI_TRAN, "thi_tran_song_doc", 968)
    W_32101 = Ward("Xã Khánh Bình Tây Bắc", 32101, VietNamDivisionType.XA, "xa_khanh_binh_tay_bac", 968)
    W_32104 = Ward("Xã Khánh Bình Tây", 32104, VietNamDivisionType.XA, "xa_khanh_binh_tay", 968)
    W_32107 = Ward("Xã Trần Hợi", 32107, VietNamDivisionType.XA, "xa_tran_hoi", 968)
    W_32108 = Ward("Xã Khánh Lộc", 32108, VietNamDivisionType.XA, "xa_khanh_loc", 968)
    W_32110 = Ward("Xã Khánh Bình", 32110, VietNamDivisionType.XA, "xa_khanh_binh", 968)
    W_32113 = Ward("Xã Khánh Hưng", 32113, VietNamDivisionType.XA, "xa_khanh_hung", 968)
    W_32116 = Ward("Xã Khánh Bình Đông", 32116, VietNamDivisionType.XA, "xa_khanh_binh_dong", 968)
    W_32119 = Ward("Xã Khánh Hải", 32119, VietNamDivisionType.XA, "xa_khanh_hai", 968)
    W_32122 = Ward("Xã Lợi An", 32122, VietNamDivisionType.XA, "xa_loi_an", 968)
    W_32124 = Ward("Xã Phong Điền", 32124, VietNamDivisionType.XA, "xa_phong_dien", 968)
    W_32125 = Ward("Xã Phong Lạc", 32125, VietNamDivisionType.XA, "xa_phong_lac", 968)
    W_32128 = Ward("Thị trấn Cái Nước", 32128, VietNamDivisionType.THI_TRAN, "thi_tran_cai_nuoc", 969)
    W_32130 = Ward("Xã Thạnh Phú", 32130, VietNamDivisionType.XA, "xa_thanh_phu", 969)
    W_32131 = Ward("Xã Lương Thế Trân", 32131, VietNamDivisionType.XA, "xa_luong_the_tran", 969)
    W_32134 = Ward("Xã Phú Hưng", 32134, VietNamDivisionType.XA, "xa_phu_hung", 969)
    W_32137 = Ward("Xã Tân Hưng", 32137, VietNamDivisionType.XA, "xa_tan_hung", 969)
    W_32140 = Ward("Xã Hưng Mỹ", 32140, VietNamDivisionType.XA, "xa_hung_my", 969)
    W_32141 = Ward("Xã Hoà Mỹ", 32141, VietNamDivisionType.XA, "xa_hoa_my", 969)
    W_32142 = Ward("Xã Đông Hưng", 32142, VietNamDivisionType.XA, "xa_dong_hung", 969)
    W_32143 = Ward("Xã Đông Thới", 32143, VietNamDivisionType.XA, "xa_dong_thoi", 969)
    W_32146 = Ward("Xã Tân Hưng Đông", 32146, VietNamDivisionType.XA, "xa_tan_hung_dong", 969)
    W_32149 = Ward("Xã Trần Thới", 32149, VietNamDivisionType.XA, "xa_tran_thoi", 969)
    W_32152 = Ward("Thị trấn Đầm Dơi", 32152, VietNamDivisionType.THI_TRAN, "thi_tran_dam_doi", 970)
    W_32155 = Ward("Xã Tạ An Khương", 32155, VietNamDivisionType.XA, "xa_ta_an_khuong", 970)
    W_32158 = Ward("Xã Tạ An Khương Đông", 32158, VietNamDivisionType.XA, "xa_ta_an_khuong_dong", 970)
    W_32161 = Ward("Xã Trần Phán", 32161, VietNamDivisionType.XA, "xa_tran_phan", 970)
    W_32162 = Ward("Xã Tân Trung", 32162, VietNamDivisionType.XA, "xa_tan_trung", 970)
    W_32164 = Ward("Xã Tân Đức", 32164, VietNamDivisionType.XA, "xa_tan_duc", 970)
    W_32167 = Ward("Xã Tân Thuận", 32167, VietNamDivisionType.XA, "xa_tan_thuan", 970)
    W_32170 = Ward("Xã Tạ An Khương Nam", 32170, VietNamDivisionType.XA, "xa_ta_an_khuong_nam", 970)
    W_32173 = Ward("Xã Tân Duyệt", 32173, VietNamDivisionType.XA, "xa_tan_duyet", 970)
    W_32174 = Ward("Xã Tân Dân", 32174, VietNamDivisionType.XA, "xa_tan_dan", 970)
    W_32176 = Ward("Xã Tân Tiến", 32176, VietNamDivisionType.XA, "xa_tan_tien", 970)
    W_32179 = Ward("Xã Quách Phẩm Bắc", 32179, VietNamDivisionType.XA, "xa_quach_pham_bac", 970)
    W_32182 = Ward("Xã Quách Phẩm", 32182, VietNamDivisionType.XA, "xa_quach_pham", 970)
    W_32185 = Ward("Xã Thanh Tùng", 32185, VietNamDivisionType.XA, "xa_thanh_tung", 970)
    W_32186 = Ward("Xã Ngọc Chánh", 32186, VietNamDivisionType.XA, "xa_ngoc_chanh", 970)
    W_32188 = Ward("Xã Nguyễn Huân", 32188, VietNamDivisionType.XA, "xa_nguyen_huan", 970)
    W_32191 = Ward("Thị trấn Năm Căn", 32191, VietNamDivisionType.THI_TRAN, "thi_tran_nam_can", 971)
    W_32194 = Ward("Xã Hàm Rồng", 32194, VietNamDivisionType.XA, "xa_ham_rong", 971)
    W_32197 = Ward("Xã Hiệp Tùng", 32197, VietNamDivisionType.XA, "xa_hiep_tung", 971)
    W_32200 = Ward("Xã Đất Mới", 32200, VietNamDivisionType.XA, "xa_dat_moi", 971)
    W_32201 = Ward("Xã Lâm Hải", 32201, VietNamDivisionType.XA, "xa_lam_hai", 971)
    W_32203 = Ward("Xã Hàng Vịnh", 32203, VietNamDivisionType.XA, "xa_hang_vinh", 971)
    W_32206 = Ward("Xã Tam Giang", 32206, VietNamDivisionType.XA, "xa_tam_giang", 971)
    W_32209 = Ward("Xã Tam Giang Đông", 32209, VietNamDivisionType.XA, "xa_tam_giang_dong", 971)
    W_32212 = Ward("Thị trấn Cái Đôi Vàm", 32212, VietNamDivisionType.THI_TRAN, "thi_tran_cai_doi_vam", 972)
    W_32214 = Ward("Xã Phú Thuận", 32214, VietNamDivisionType.XA, "xa_phu_thuan", 972)
    W_32215 = Ward("Xã Phú Mỹ", 32215, VietNamDivisionType.XA, "xa_phu_my", 972)
    W_32218 = Ward("Xã Phú Tân", 32218, VietNamDivisionType.XA, "xa_phu_tan", 972)
    W_32221 = Ward("Xã Tân Hải", 32221, VietNamDivisionType.XA, "xa_tan_hai", 972)
    W_32224 = Ward("Xã Việt Thắng", 32224, VietNamDivisionType.XA, "xa_viet_thang", 972)
    W_32227 = Ward("Xã Tân Hưng Tây", 32227, VietNamDivisionType.XA, "xa_tan_hung_tay", 972)
    W_32228 = Ward("Xã Rạch Chèo", 32228, VietNamDivisionType.XA, "xa_rach_cheo", 972)
    W_32230 = Ward("Xã Nguyễn Việt Khái", 32230, VietNamDivisionType.XA, "xa_nguyen_viet_khai", 972)
    W_32233 = Ward("Xã Tam Giang Tây", 32233, VietNamDivisionType.XA, "xa_tam_giang_tay", 973)
    W_32236 = Ward("Xã Tân Ân Tây", 32236, VietNamDivisionType.XA, "xa_tan_an_tay", 973)
    W_32239 = Ward("Xã Viên An Đông", 32239, VietNamDivisionType.XA, "xa_vien_an_dong", 973)
    W_32242 = Ward("Xã Viên An", 32242, VietNamDivisionType.XA, "xa_vien_an", 973)
    W_32244 = Ward("Thị trấn Rạch Gốc", 32244, VietNamDivisionType.THI_TRAN, "thi_tran_rach_goc", 973)
    W_32245 = Ward("Xã Tân Ân", 32245, VietNamDivisionType.XA, "xa_tan_an", 973)
    W_32248 = Ward("Xã Đất Mũi", 32248, VietNamDivisionType.XA, "xa_dat_mui", 973)


class WardDEnum(metaclass=FastEnum):
    """
    Ward Enum type, whose member name is more descriptive, with ward name, abbreviated province name.

    It helps developer have more idea what Ward he is selecting.
    """

    HN_PHUC_XA_1 = WardEnum.W_1.value
    HN_TRUC_BACH_4 = WardEnum.W_4.value
    HN_VINH_PHUC_6 = WardEnum.W_6.value
    HN_CONG_VI_7 = WardEnum.W_7.value
    HN_LIEU_GIAI_8 = WardEnum.W_8.value
    HN_NGUYEN_TRUNG_TRUC_10 = WardEnum.W_10.value
    HN_QUAN_THANH_13 = WardEnum.W_13.value
    HN_NGOC_HA_16 = WardEnum.W_16.value
    HN_DIEN_BIEN_19 = WardEnum.W_19.value
    HN_DOI_CAN_22 = WardEnum.W_22.value
    HN_NGOC_KHANH_25 = WardEnum.W_25.value
    HN_KIM_MA_28 = WardEnum.W_28.value
    HN_GIANG_VO_31 = WardEnum.W_31.value
    HN_THANH_CONG_34 = WardEnum.W_34.value
    HN_PHUC_TAN_37 = WardEnum.W_37.value
    HN_DONG_XUAN_40 = WardEnum.W_40.value
    HN_HANG_MA_43 = WardEnum.W_43.value
    HN_HANG_BUOM_46 = WardEnum.W_46.value
    HN_HANG_DAO_49 = WardEnum.W_49.value
    HN_HANG_BO_52 = WardEnum.W_52.value
    HN_CUA_DONG_55 = WardEnum.W_55.value
    HN_LY_THAI_TO_58 = WardEnum.W_58.value
    HN_HANG_BAC_61 = WardEnum.W_61.value
    HN_HANG_GAI_64 = WardEnum.W_64.value
    HN_CHUONG_DUONG_67 = WardEnum.W_67.value
    HN_HANG_TRONG_70 = WardEnum.W_70.value
    HN_CUA_NAM_73 = WardEnum.W_73.value
    HN_HANG_BONG_76 = WardEnum.W_76.value
    HN_TRANG_TIEN_79 = WardEnum.W_79.value
    HN_TRAN_HUNG_DAO_82 = WardEnum.W_82.value
    HN_PHAN_CHU_TRINH_85 = WardEnum.W_85.value
    HN_HANG_BAI_88 = WardEnum.W_88.value
    HN_PHU_THUONG_91 = WardEnum.W_91.value
    HN_NHAT_TAN_94 = WardEnum.W_94.value
    HN_TU_LIEN_97 = WardEnum.W_97.value
    HN_QUANG_AN_100 = WardEnum.W_100.value
    HN_XUAN_LA_103 = WardEnum.W_103.value
    HN_YEN_PHU_106 = WardEnum.W_106.value
    HN_BUOI_109 = WardEnum.W_109.value
    HN_THUY_KHUE_112 = WardEnum.W_112.value
    HN_THUONG_THANH_115 = WardEnum.W_115.value
    HN_NGOC_THUY_118 = WardEnum.W_118.value
    HN_GIANG_BIEN_121 = WardEnum.W_121.value
    HN_DUC_GIANG_124 = WardEnum.W_124.value
    HN_VIET_HUNG_127 = WardEnum.W_127.value
    HN_GIA_THUY_130 = WardEnum.W_130.value
    HN_NGOC_LAM_133 = WardEnum.W_133.value
    HN_PHUC_LOI_136 = WardEnum.W_136.value
    HN_BO_DE_139 = WardEnum.W_139.value
    HN_SAI_DONG_142 = WardEnum.W_142.value
    HN_LONG_BIEN_145 = WardEnum.W_145.value
    HN_THACH_BAN_148 = WardEnum.W_148.value
    HN_PHUC_DONG_151 = WardEnum.W_151.value
    HN_CU_KHOI_154 = WardEnum.W_154.value
    HN_NGHIA_DO_157 = WardEnum.W_157.value
    HN_NGHIA_TAN_160 = WardEnum.W_160.value
    HN_MAI_DICH_163 = WardEnum.W_163.value
    HN_DICH_VONG_166 = WardEnum.W_166.value
    HN_DICH_VONG_HAU_167 = WardEnum.W_167.value
    HN_QUAN_HOA_169 = WardEnum.W_169.value
    HN_YEN_HOA_172 = WardEnum.W_172.value
    HN_TRUNG_HOA_175 = WardEnum.W_175.value
    HN_CAT_LINH_178 = WardEnum.W_178.value
    HN_VAN_MIEU_181 = WardEnum.W_181.value
    HN_QUOC_TU_GIAM_184 = WardEnum.W_184.value
    HN_LANG_THUONG_187 = WardEnum.W_187.value
    HN_O_CHO_DUA_190 = WardEnum.W_190.value
    HN_VAN_CHUONG_193 = WardEnum.W_193.value
    HN_HANG_BOT_196 = WardEnum.W_196.value
    HN_LANG_HA_199 = WardEnum.W_199.value
    HN_KHAM_THIEN_202 = WardEnum.W_202.value
    HN_THO_QUAN_205 = WardEnum.W_205.value
    HN_NAM_DONG_208 = WardEnum.W_208.value
    HN_TRUNG_PHUNG_211 = WardEnum.W_211.value
    HN_QUANG_TRUNG_214 = WardEnum.W_214.value
    HN_TRUNG_LIET_217 = WardEnum.W_217.value
    HN_PHUONG_LIEN_220 = WardEnum.W_220.value
    HN_THINH_QUANG_223 = WardEnum.W_223.value
    HN_TRUNG_TU_226 = WardEnum.W_226.value
    HN_KIM_LIEN_229 = WardEnum.W_229.value
    HN_PHUONG_MAI_232 = WardEnum.W_232.value
    HN_NGA_TU_SO_235 = WardEnum.W_235.value
    HN_KHUONG_THUONG_238 = WardEnum.W_238.value
    HN_NGUYEN_DU_241 = WardEnum.W_241.value
    HN_BACH_DANG_244 = WardEnum.W_244.value
    HN_PHAM_DINH_HO_247 = WardEnum.W_247.value
    HN_LE_DAI_HANH_256 = WardEnum.W_256.value
    HN_DONG_NHAN_259 = WardEnum.W_259.value
    HN_PHO_HUE_262 = WardEnum.W_262.value
    HN_DONG_MAC_265 = WardEnum.W_265.value
    HN_THANH_LUONG_268 = WardEnum.W_268.value
    HN_THANH_NHAN_271 = WardEnum.W_271.value
    HN_CAU_DEN_274 = WardEnum.W_274.value
    HN_BACH_KHOA_277 = WardEnum.W_277.value
    HN_DONG_TAM_280 = WardEnum.W_280.value
    HN_VINH_TUY_283 = WardEnum.W_283.value
    HN_BACH_MAI_286 = WardEnum.W_286.value
    HN_QUYNH_MAI_289 = WardEnum.W_289.value
    HN_QUYNH_LOI_292 = WardEnum.W_292.value
    HN_MINH_KHAI_295 = WardEnum.W_295.value
    HN_TRUONG_DINH_298 = WardEnum.W_298.value
    HN_THANH_TRI_301 = WardEnum.W_301.value
    HN_VINH_HUNG_304 = WardEnum.W_304.value
    HN_DINH_CONG_307 = WardEnum.W_307.value
    HN_MAI_DONG_310 = WardEnum.W_310.value
    HN_TUONG_MAI_313 = WardEnum.W_313.value
    HN_DAI_KIM_316 = WardEnum.W_316.value
    HN_TAN_MAI_319 = WardEnum.W_319.value
    HN_HOANG_VAN_THU_322 = WardEnum.W_322.value
    HN_GIAP_BAT_325 = WardEnum.W_325.value
    HN_LINH_NAM_328 = WardEnum.W_328.value
    HN_THINH_LIET_331 = WardEnum.W_331.value
    HN_TRAN_PHU_334 = WardEnum.W_334.value
    HN_HOANG_LIET_337 = WardEnum.W_337.value
    HN_YEN_SO_340 = WardEnum.W_340.value
    HN_NHAN_CHINH_343 = WardEnum.W_343.value
    HN_THUONG_DINH_346 = WardEnum.W_346.value
    HN_KHUONG_TRUNG_349 = WardEnum.W_349.value
    HN_KHUONG_MAI_352 = WardEnum.W_352.value
    HN_THANH_XUAN_TRUNG_355 = WardEnum.W_355.value
    HN_PHUONG_LIET_358 = WardEnum.W_358.value
    HN_HA_DINH_361 = WardEnum.W_361.value
    HN_KHUONG_DINH_364 = WardEnum.W_364.value
    HN_THANH_XUAN_BAC_367 = WardEnum.W_367.value
    HN_THANH_XUAN_NAM_370 = WardEnum.W_370.value
    HN_KIM_GIANG_373 = WardEnum.W_373.value
    HN_SOC_SON_376 = WardEnum.W_376.value
    HN_BAC_SON_379 = WardEnum.W_379.value
    HN_MINH_TRI_382 = WardEnum.W_382.value
    HN_HONG_KY_385 = WardEnum.W_385.value
    HN_NAM_SON_388 = WardEnum.W_388.value
    HN_TRUNG_GIA_391 = WardEnum.W_391.value
    HN_TAN_HUNG_394 = WardEnum.W_394.value
    HN_MINH_PHU_397 = WardEnum.W_397.value
    HN_PHU_LINH_400 = WardEnum.W_400.value
    HN_BAC_PHU_403 = WardEnum.W_403.value
    HN_TAN_MINH_406 = WardEnum.W_406.value
    HN_QUANG_TIEN_409 = WardEnum.W_409.value
    HN_HIEN_NINH_412 = WardEnum.W_412.value
    HN_TAN_DAN_415 = WardEnum.W_415.value
    HN_TIEN_DUOC_418 = WardEnum.W_418.value
    HN_VIET_LONG_421 = WardEnum.W_421.value
    HN_XUAN_GIANG_424 = WardEnum.W_424.value
    HN_MAI_DINH_427 = WardEnum.W_427.value
    HN_DUC_HOA_430 = WardEnum.W_430.value
    HN_THANH_XUAN_433 = WardEnum.W_433.value
    HN_DONG_XUAN_436 = WardEnum.W_436.value
    HN_KIM_LU_439 = WardEnum.W_439.value
    HN_PHU_CUONG_442 = WardEnum.W_442.value
    HN_PHU_MINH_445 = WardEnum.W_445.value
    HN_PHU_LO_448 = WardEnum.W_448.value
    HN_XUAN_THU_451 = WardEnum.W_451.value
    HN_DONG_ANH_454 = WardEnum.W_454.value
    HN_XUAN_NON_457 = WardEnum.W_457.value
    HN_THUY_LAM_460 = WardEnum.W_460.value
    HN_BAC_HONG_463 = WardEnum.W_463.value
    HN_NGUYEN_KHE_466 = WardEnum.W_466.value
    HN_NAM_HONG_469 = WardEnum.W_469.value
    HN_TIEN_DUONG_472 = WardEnum.W_472.value
    HN_VAN_HA_475 = WardEnum.W_475.value
    HN_UY_NO_478 = WardEnum.W_478.value
    HN_VAN_NOI_481 = WardEnum.W_481.value
    HN_LIEN_HA_484 = WardEnum.W_484.value
    HN_VIET_HUNG_487 = WardEnum.W_487.value
    HN_KIM_NO_490 = WardEnum.W_490.value
    HN_KIM_CHUNG_493 = WardEnum.W_493.value
    HN_DUC_TU_496 = WardEnum.W_496.value
    HN_DAI_MACH_499 = WardEnum.W_499.value
    HN_VINH_NGOC_502 = WardEnum.W_502.value
    HN_CO_LOA_505 = WardEnum.W_505.value
    HN_HAI_BOI_508 = WardEnum.W_508.value
    HN_XUAN_CANH_511 = WardEnum.W_511.value
    HN_VONG_LA_514 = WardEnum.W_514.value
    HN_TAM_XA_517 = WardEnum.W_517.value
    HN_MAI_LAM_520 = WardEnum.W_520.value
    HN_DONG_HOI_523 = WardEnum.W_523.value
    HN_YEN_VIEN_526 = WardEnum.W_526.value
    HN_YEN_THUONG_529 = WardEnum.W_529.value
    HN_XA_YEN_VIEN_532 = WardEnum.W_532.value
    HN_NINH_HIEP_535 = WardEnum.W_535.value
    HN_DINH_XUYEN_538 = WardEnum.W_538.value
    HN_DUONG_HA_541 = WardEnum.W_541.value
    HN_PHU_DONG_544 = WardEnum.W_544.value
    HN_TRUNG_MAU_547 = WardEnum.W_547.value
    HN_LE_CHI_550 = WardEnum.W_550.value
    HN_CO_BI_553 = WardEnum.W_553.value
    HN_DANG_XA_556 = WardEnum.W_556.value
    HN_PHU_THI_559 = WardEnum.W_559.value
    HN_KIM_SON_562 = WardEnum.W_562.value
    HN_TRAU_QUY_565 = WardEnum.W_565.value
    HN_DUONG_QUANG_568 = WardEnum.W_568.value
    HN_DUONG_XA_571 = WardEnum.W_571.value
    HN_DONG_DU_574 = WardEnum.W_574.value
    HN_DA_TON_577 = WardEnum.W_577.value
    HN_KIEU_KY_580 = WardEnum.W_580.value
    HN_BAT_TRANG_583 = WardEnum.W_583.value
    HN_KIM_LAN_586 = WardEnum.W_586.value
    HN_VAN_DUC_589 = WardEnum.W_589.value
    HN_CAU_DIEN_592 = WardEnum.W_592.value
    HN_XUAN_PHUONG_622 = WardEnum.W_622.value
    HN_PHUONG_CANH_623 = WardEnum.W_623.value
    HN_MY_DINH_1_625 = WardEnum.W_625.value
    HN_MY_DINH_2_626 = WardEnum.W_626.value
    HN_TAY_MO_628 = WardEnum.W_628.value
    HN_ME_TRI_631 = WardEnum.W_631.value
    HN_PHU_DO_632 = WardEnum.W_632.value
    HN_DAI_MO_634 = WardEnum.W_634.value
    HN_TRUNG_VAN_637 = WardEnum.W_637.value
    HN_VAN_DIEN_640 = WardEnum.W_640.value
    HN_TAN_TRIEU_643 = WardEnum.W_643.value
    HN_THANH_LIET_646 = WardEnum.W_646.value
    HN_TA_THANH_OAI_649 = WardEnum.W_649.value
    HN_HUU_HOA_652 = WardEnum.W_652.value
    HN_TAM_HIEP_655 = WardEnum.W_655.value
    HN_TU_HIEP_658 = WardEnum.W_658.value
    HN_YEN_MY_661 = WardEnum.W_661.value
    HN_VINH_QUYNH_664 = WardEnum.W_664.value
    HN_NGU_HIEP_667 = WardEnum.W_667.value
    HN_DUYEN_HA_670 = WardEnum.W_670.value
    HN_NGOC_HOI_673 = WardEnum.W_673.value
    HN_VAN_PHUC_676 = WardEnum.W_676.value
    HN_DAI_ANG_679 = WardEnum.W_679.value
    HN_LIEN_NINH_682 = WardEnum.W_682.value
    HN_DONG_MY_685 = WardEnum.W_685.value
    HN_THUONG_CAT_595 = WardEnum.W_595.value
    HN_LIEN_MAC_598 = WardEnum.W_598.value
    HN_DONG_NGAC_601 = WardEnum.W_601.value
    HN_DUC_THANG_602 = WardEnum.W_602.value
    HN_THUY_PHUONG_604 = WardEnum.W_604.value
    HN_TAY_TUU_607 = WardEnum.W_607.value
    HN_XUAN_DINH_610 = WardEnum.W_610.value
    HN_XUAN_TAO_611 = WardEnum.W_611.value
    HN_MINH_KHAI_613 = WardEnum.W_613.value
    HN_CO_NHUE_1_616 = WardEnum.W_616.value
    HN_CO_NHUE_2_617 = WardEnum.W_617.value
    HN_PHU_DIEN_619 = WardEnum.W_619.value
    HN_PHUC_DIEN_620 = WardEnum.W_620.value
    HN_CHI_DONG_8973 = WardEnum.W_8973.value
    HN_DAI_THINH_8974 = WardEnum.W_8974.value
    HN_KIM_HOA_8977 = WardEnum.W_8977.value
    HN_THACH_DA_8980 = WardEnum.W_8980.value
    HN_TIEN_THANG_8983 = WardEnum.W_8983.value
    HN_TU_LAP_8986 = WardEnum.W_8986.value
    HN_QUANG_MINH_8989 = WardEnum.W_8989.value
    HN_THANH_LAM_8992 = WardEnum.W_8992.value
    HN_TAM_DONG_8995 = WardEnum.W_8995.value
    HN_LIEN_MAC_8998 = WardEnum.W_8998.value
    HN_VAN_YEN_9001 = WardEnum.W_9001.value
    HN_CHU_PHAN_9004 = WardEnum.W_9004.value
    HN_TIEN_THINH_9007 = WardEnum.W_9007.value
    HN_ME_LINH_9010 = WardEnum.W_9010.value
    HN_VAN_KHE_9013 = WardEnum.W_9013.value
    HN_HOANG_KIM_9016 = WardEnum.W_9016.value
    HN_TIEN_PHONG_9019 = WardEnum.W_9019.value
    HN_TRANG_VIET_9022 = WardEnum.W_9022.value
    HN_NGUYEN_TRAI_9538 = WardEnum.W_9538.value
    HN_MO_LAO_9541 = WardEnum.W_9541.value
    HN_VAN_QUAN_9542 = WardEnum.W_9542.value
    HN_VAN_PHUC_9544 = WardEnum.W_9544.value
    HN_YET_KIEU_9547 = WardEnum.W_9547.value
    HN_QUANG_TRUNG_9550 = WardEnum.W_9550.value
    HN_LA_KHE_9551 = WardEnum.W_9551.value
    HN_PHU_LA_9552 = WardEnum.W_9552.value
    HN_PHUC_LA_9553 = WardEnum.W_9553.value
    HN_HA_CAU_9556 = WardEnum.W_9556.value
    HN_YEN_NGHIA_9562 = WardEnum.W_9562.value
    HN_KIEN_HUNG_9565 = WardEnum.W_9565.value
    HN_PHU_LAM_9568 = WardEnum.W_9568.value
    HN_PHU_LUONG_9571 = WardEnum.W_9571.value
    HN_DUONG_NOI_9886 = WardEnum.W_9886.value
    HN_DONG_MAI_10117 = WardEnum.W_10117.value
    HN_BIEN_GIANG_10123 = WardEnum.W_10123.value
    HN_LE_LOI_9574 = WardEnum.W_9574.value
    HN_PHU_THINH_9577 = WardEnum.W_9577.value
    HN_NGO_QUYEN_9580 = WardEnum.W_9580.value
    HN_QUANG_TRUNG_9583 = WardEnum.W_9583.value
    HN_SON_LOC_9586 = WardEnum.W_9586.value
    HN_XUAN_KHANH_9589 = WardEnum.W_9589.value
    HN_DUONG_LAM_9592 = WardEnum.W_9592.value
    HN_VIEN_SON_9595 = WardEnum.W_9595.value
    HN_XUAN_SON_9598 = WardEnum.W_9598.value
    HN_TRUNG_HUNG_9601 = WardEnum.W_9601.value
    HN_THANH_MY_9604 = WardEnum.W_9604.value
    HN_TRUNG_SON_TRAM_9607 = WardEnum.W_9607.value
    HN_KIM_SON_9610 = WardEnum.W_9610.value
    HN_SON_DONG_9613 = WardEnum.W_9613.value
    HN_CO_DONG_9616 = WardEnum.W_9616.value
    HN_TAY_DANG_9619 = WardEnum.W_9619.value
    HN_PHU_CUONG_9625 = WardEnum.W_9625.value
    HN_CO_DO_9628 = WardEnum.W_9628.value
    HN_TAN_HONG_9631 = WardEnum.W_9631.value
    HN_VAN_THANG_9634 = WardEnum.W_9634.value
    HN_CHAU_SON_9637 = WardEnum.W_9637.value
    HN_PHONG_VAN_9640 = WardEnum.W_9640.value
    HN_PHU_DONG_9643 = WardEnum.W_9643.value
    HN_PHU_PHUONG_9646 = WardEnum.W_9646.value
    HN_PHU_CHAU_9649 = WardEnum.W_9649.value
    HN_THAI_HOA_9652 = WardEnum.W_9652.value
    HN_DONG_THAI_9655 = WardEnum.W_9655.value
    HN_PHU_SON_9658 = WardEnum.W_9658.value
    HN_MINH_CHAU_9661 = WardEnum.W_9661.value
    HN_VAT_LAI_9664 = WardEnum.W_9664.value
    HN_CHU_MINH_9667 = WardEnum.W_9667.value
    HN_TONG_BAT_9670 = WardEnum.W_9670.value
    HN_CAM_LINH_9673 = WardEnum.W_9673.value
    HN_SON_DA_9676 = WardEnum.W_9676.value
    HN_DONG_QUANG_9679 = WardEnum.W_9679.value
    HN_TIEN_PHONG_9682 = WardEnum.W_9682.value
    HN_THUY_AN_9685 = WardEnum.W_9685.value
    HN_CAM_THUONG_9688 = WardEnum.W_9688.value
    HN_THUAN_MY_9691 = WardEnum.W_9691.value
    HN_TAN_LINH_9694 = WardEnum.W_9694.value
    HN_BA_TRAI_9697 = WardEnum.W_9697.value
    HN_MINH_QUANG_9700 = WardEnum.W_9700.value
    HN_BA_VI_9703 = WardEnum.W_9703.value
    HN_VAN_HOA_9706 = WardEnum.W_9706.value
    HN_YEN_BAI_9709 = WardEnum.W_9709.value
    HN_KHANH_THUONG_9712 = WardEnum.W_9712.value
    HN_PHUC_THO_9715 = WardEnum.W_9715.value
    HN_VAN_HA_9718 = WardEnum.W_9718.value
    HN_VAN_PHUC_9721 = WardEnum.W_9721.value
    HN_VAN_NAM_9724 = WardEnum.W_9724.value
    HN_XUAN_DINH_9727 = WardEnum.W_9727.value
    HN_SEN_PHUONG_9733 = WardEnum.W_9733.value
    HN_VONG_XUYEN_9739 = WardEnum.W_9739.value
    HN_THO_LOC_9742 = WardEnum.W_9742.value
    HN_LONG_XUYEN_9745 = WardEnum.W_9745.value
    HN_THUONG_COC_9748 = WardEnum.W_9748.value
    HN_HAT_MON_9751 = WardEnum.W_9751.value
    HN_TICH_GIANG_9754 = WardEnum.W_9754.value
    HN_THANH_DA_9757 = WardEnum.W_9757.value
    HN_TRACH_MY_LOC_9760 = WardEnum.W_9760.value
    HN_PHUC_HOA_9763 = WardEnum.W_9763.value
    HN_NGOC_TAO_9766 = WardEnum.W_9766.value
    HN_PHUNG_THUONG_9769 = WardEnum.W_9769.value
    HN_TAM_THUAN_9772 = WardEnum.W_9772.value
    HN_TAM_HIEP_9775 = WardEnum.W_9775.value
    HN_HIEP_THUAN_9778 = WardEnum.W_9778.value
    HN_LIEN_HIEP_9781 = WardEnum.W_9781.value
    HN_PHUNG_9784 = WardEnum.W_9784.value
    HN_TRUNG_CHAU_9787 = WardEnum.W_9787.value
    HN_THO_AN_9790 = WardEnum.W_9790.value
    HN_THO_XUAN_9793 = WardEnum.W_9793.value
    HN_HONG_HA_9796 = WardEnum.W_9796.value
    HN_LIEN_HONG_9799 = WardEnum.W_9799.value
    HN_LIEN_HA_9802 = WardEnum.W_9802.value
    HN_HA_MO_9805 = WardEnum.W_9805.value
    HN_LIEN_TRUNG_9808 = WardEnum.W_9808.value
    HN_PHUONG_DINH_9811 = WardEnum.W_9811.value
    HN_THUONG_MO_9814 = WardEnum.W_9814.value
    HN_TAN_HOI_9817 = WardEnum.W_9817.value
    HN_TAN_LAP_9820 = WardEnum.W_9820.value
    HN_DAN_PHUONG_9823 = WardEnum.W_9823.value
    HN_DONG_THAP_9826 = WardEnum.W_9826.value
    HN_SONG_PHUONG_9829 = WardEnum.W_9829.value
    HN_TRAM_TROI_9832 = WardEnum.W_9832.value
    HN_DUC_THUONG_9835 = WardEnum.W_9835.value
    HN_MINH_KHAI_9838 = WardEnum.W_9838.value
    HN_DUONG_LIEU_9841 = WardEnum.W_9841.value
    HN_DI_TRACH_9844 = WardEnum.W_9844.value
    HN_DUC_GIANG_9847 = WardEnum.W_9847.value
    HN_CAT_QUE_9850 = WardEnum.W_9850.value
    HN_KIM_CHUNG_9853 = WardEnum.W_9853.value
    HN_YEN_SO_9856 = WardEnum.W_9856.value
    HN_SON_DONG_9859 = WardEnum.W_9859.value
    HN_VAN_CANH_9862 = WardEnum.W_9862.value
    HN_DAC_SO_9865 = WardEnum.W_9865.value
    HN_LAI_YEN_9868 = WardEnum.W_9868.value
    HN_TIEN_YEN_9871 = WardEnum.W_9871.value
    HN_SONG_PHUONG_9874 = WardEnum.W_9874.value
    HN_AN_KHANH_9877 = WardEnum.W_9877.value
    HN_AN_THUONG_9880 = WardEnum.W_9880.value
    HN_VAN_CON_9883 = WardEnum.W_9883.value
    HN_LA_PHU_9889 = WardEnum.W_9889.value
    HN_DONG_LA_9892 = WardEnum.W_9892.value
    HN_DONG_XUAN_4939 = WardEnum.W_4939.value
    HN_QUOC_OAI_9895 = WardEnum.W_9895.value
    HN_SAI_SON_9898 = WardEnum.W_9898.value
    HN_PHUONG_CACH_9901 = WardEnum.W_9901.value
    HN_YEN_SON_9904 = WardEnum.W_9904.value
    HN_NGOC_LIEP_9907 = WardEnum.W_9907.value
    HN_NGOC_MY_9910 = WardEnum.W_9910.value
    HN_LIEP_TUYET_9913 = WardEnum.W_9913.value
    HN_THACH_THAN_9916 = WardEnum.W_9916.value
    HN_DONG_QUANG_9919 = WardEnum.W_9919.value
    HN_PHU_CAT_9922 = WardEnum.W_9922.value
    HN_TUYET_NGHIA_9925 = WardEnum.W_9925.value
    HN_NGHIA_HUONG_9928 = WardEnum.W_9928.value
    HN_CONG_HOA_9931 = WardEnum.W_9931.value
    HN_TAN_PHU_9934 = WardEnum.W_9934.value
    HN_DAI_THANH_9937 = WardEnum.W_9937.value
    HN_PHU_MAN_9940 = WardEnum.W_9940.value
    HN_CAN_HUU_9943 = WardEnum.W_9943.value
    HN_TAN_HOA_9946 = WardEnum.W_9946.value
    HN_HOA_THACH_9949 = WardEnum.W_9949.value
    HN_DONG_YEN_9952 = WardEnum.W_9952.value
    HN_YEN_TRUNG_4927 = WardEnum.W_4927.value
    HN_YEN_BINH_4930 = WardEnum.W_4930.value
    HN_TIEN_XUAN_4936 = WardEnum.W_4936.value
    HN_LIEN_QUAN_9955 = WardEnum.W_9955.value
    HN_DAI_DONG_9958 = WardEnum.W_9958.value
    HN_CAM_YEN_9961 = WardEnum.W_9961.value
    HN_LAI_THUONG_9964 = WardEnum.W_9964.value
    HN_PHU_KIM_9967 = WardEnum.W_9967.value
    HN_HUONG_NGAI_9970 = WardEnum.W_9970.value
    HN_CANH_NAU_9973 = WardEnum.W_9973.value
    HN_KIM_QUAN_9976 = WardEnum.W_9976.value
    HN_DI_NAU_9979 = WardEnum.W_9979.value
    HN_BINH_YEN_9982 = WardEnum.W_9982.value
    HN_CHANG_SON_9985 = WardEnum.W_9985.value
    HN_THACH_HOA_9988 = WardEnum.W_9988.value
    HN_CAN_KIEM_9991 = WardEnum.W_9991.value
    HN_HUU_BANG_9994 = WardEnum.W_9994.value
    HN_PHUNG_XA_9997 = WardEnum.W_9997.value
    HN_TAN_XA_10000 = WardEnum.W_10000.value
    HN_THACH_XA_10003 = WardEnum.W_10003.value
    HN_BINH_PHU_10006 = WardEnum.W_10006.value
    HN_HA_BANG_10009 = WardEnum.W_10009.value
    HN_DONG_TRUC_10012 = WardEnum.W_10012.value
    HN_CHUC_SON_10015 = WardEnum.W_10015.value
    HN_XUAN_MAI_10018 = WardEnum.W_10018.value
    HN_PHUNG_CHAU_10021 = WardEnum.W_10021.value
    HN_TIEN_PHUONG_10024 = WardEnum.W_10024.value
    HN_DONG_SON_10027 = WardEnum.W_10027.value
    HN_DONG_PHUONG_YEN_10030 = WardEnum.W_10030.value
    HN_PHU_NGHIA_10033 = WardEnum.W_10033.value
    HN_TRUONG_YEN_10039 = WardEnum.W_10039.value
    HN_NGOC_HOA_10042 = WardEnum.W_10042.value
    HN_THUY_XUAN_TIEN_10045 = WardEnum.W_10045.value
    HN_THANH_BINH_10048 = WardEnum.W_10048.value
    HN_TRUNG_HOA_10051 = WardEnum.W_10051.value
    HN_DAI_YEN_10054 = WardEnum.W_10054.value
    HN_THUY_HUONG_10057 = WardEnum.W_10057.value
    HN_TOT_DONG_10060 = WardEnum.W_10060.value
    HN_LAM_DIEN_10063 = WardEnum.W_10063.value
    HN_TAN_TIEN_10066 = WardEnum.W_10066.value
    HN_NAM_PHUONG_TIEN_10069 = WardEnum.W_10069.value
    HN_HOP_DONG_10072 = WardEnum.W_10072.value
    HN_HOANG_VAN_THU_10075 = WardEnum.W_10075.value
    HN_HOANG_DIEU_10078 = WardEnum.W_10078.value
    HN_HUU_VAN_10081 = WardEnum.W_10081.value
    HN_QUANG_BI_10084 = WardEnum.W_10084.value
    HN_MY_LUONG_10087 = WardEnum.W_10087.value
    HN_THUONG_VUC_10090 = WardEnum.W_10090.value
    HN_HONG_PHONG_10093 = WardEnum.W_10093.value
    HN_DONG_PHU_10096 = WardEnum.W_10096.value
    HN_TRAN_PHU_10099 = WardEnum.W_10099.value
    HN_VAN_VO_10102 = WardEnum.W_10102.value
    HN_DONG_LAC_10105 = WardEnum.W_10105.value
    HN_HOA_CHINH_10108 = WardEnum.W_10108.value
    HN_PHU_NAM_AN_10111 = WardEnum.W_10111.value
    HN_KIM_BAI_10114 = WardEnum.W_10114.value
    HN_CU_KHE_10120 = WardEnum.W_10120.value
    HN_BICH_HOA_10126 = WardEnum.W_10126.value
    HN_MY_HUNG_10129 = WardEnum.W_10129.value
    HN_CAO_VIEN_10132 = WardEnum.W_10132.value
    HN_BINH_MINH_10135 = WardEnum.W_10135.value
    HN_TAM_HUNG_10138 = WardEnum.W_10138.value
    HN_THANH_CAO_10141 = WardEnum.W_10141.value
    HN_THANH_THUY_10144 = WardEnum.W_10144.value
    HN_THANH_MAI_10147 = WardEnum.W_10147.value
    HN_THANH_VAN_10150 = WardEnum.W_10150.value
    HN_DO_DONG_10153 = WardEnum.W_10153.value
    HN_KIM_AN_10156 = WardEnum.W_10156.value
    HN_KIM_THU_10159 = WardEnum.W_10159.value
    HN_PHUONG_TRUNG_10162 = WardEnum.W_10162.value
    HN_TAN_UOC_10165 = WardEnum.W_10165.value
    HN_DAN_HOA_10168 = WardEnum.W_10168.value
    HN_LIEN_CHAU_10171 = WardEnum.W_10171.value
    HN_CAO_DUONG_10174 = WardEnum.W_10174.value
    HN_XUAN_DUONG_10177 = WardEnum.W_10177.value
    HN_HONG_DUONG_10180 = WardEnum.W_10180.value
    HN_THUONG_TIN_10183 = WardEnum.W_10183.value
    HN_NINH_SO_10186 = WardEnum.W_10186.value
    HN_NHI_KHE_10189 = WardEnum.W_10189.value
    HN_DUYEN_THAI_10192 = WardEnum.W_10192.value
    HN_KHANH_HA_10195 = WardEnum.W_10195.value
    HN_HOA_BINH_10198 = WardEnum.W_10198.value
    HN_VAN_BINH_10201 = WardEnum.W_10201.value
    HN_HIEN_GIANG_10204 = WardEnum.W_10204.value
    HN_HONG_VAN_10207 = WardEnum.W_10207.value
    HN_VAN_TAO_10210 = WardEnum.W_10210.value
    HN_LIEN_PHUONG_10213 = WardEnum.W_10213.value
    HN_VAN_PHU_10216 = WardEnum.W_10216.value
    HN_TU_NHIEN_10219 = WardEnum.W_10219.value
    HN_TIEN_PHONG_10222 = WardEnum.W_10222.value
    HN_HA_HOI_10225 = WardEnum.W_10225.value
    HN_THU_PHU_10228 = WardEnum.W_10228.value
    HN_NGUYEN_TRAI_10231 = WardEnum.W_10231.value
    HN_QUAT_DONG_10234 = WardEnum.W_10234.value
    HN_CHUONG_DUONG_10237 = WardEnum.W_10237.value
    HN_TAN_MINH_10240 = WardEnum.W_10240.value
    HN_LE_LOI_10243 = WardEnum.W_10243.value
    HN_THANG_LOI_10246 = WardEnum.W_10246.value
    HN_DUNG_TIEN_10249 = WardEnum.W_10249.value
    HN_THONG_NHAT_10252 = WardEnum.W_10252.value
    HN_NGHIEM_XUYEN_10255 = WardEnum.W_10255.value
    HN_TO_HIEU_10258 = WardEnum.W_10258.value
    HN_VAN_TU_10261 = WardEnum.W_10261.value
    HN_VAN_DIEM_10264 = WardEnum.W_10264.value
    HN_MINH_CUONG_10267 = WardEnum.W_10267.value
    HN_PHU_MINH_10270 = WardEnum.W_10270.value
    HN_PHU_XUYEN_10273 = WardEnum.W_10273.value
    HN_HONG_MINH_10276 = WardEnum.W_10276.value
    HN_PHUONG_DUC_10279 = WardEnum.W_10279.value
    HN_NAM_TIEN_10282 = WardEnum.W_10282.value
    HN_TRI_TRUNG_10288 = WardEnum.W_10288.value
    HN_DAI_THANG_10291 = WardEnum.W_10291.value
    HN_PHU_TUC_10294 = WardEnum.W_10294.value
    HN_VAN_HOANG_10297 = WardEnum.W_10297.value
    HN_HONG_THAI_10300 = WardEnum.W_10300.value
    HN_HOANG_LONG_10303 = WardEnum.W_10303.value
    HN_QUANG_TRUNG_10306 = WardEnum.W_10306.value
    HN_NAM_PHONG_10309 = WardEnum.W_10309.value
    HN_NAM_TRIEU_10312 = WardEnum.W_10312.value
    HN_TAN_DAN_10315 = WardEnum.W_10315.value
    HN_SON_HA_10318 = WardEnum.W_10318.value
    HN_CHUYEN_MY_10321 = WardEnum.W_10321.value
    HN_KHAI_THAI_10324 = WardEnum.W_10324.value
    HN_PHUC_TIEN_10327 = WardEnum.W_10327.value
    HN_VAN_TU_10330 = WardEnum.W_10330.value
    HN_TRI_THUY_10333 = WardEnum.W_10333.value
    HN_DAI_XUYEN_10336 = WardEnum.W_10336.value
    HN_PHU_YEN_10339 = WardEnum.W_10339.value
    HN_BACH_HA_10342 = WardEnum.W_10342.value
    HN_QUANG_LANG_10345 = WardEnum.W_10345.value
    HN_CHAU_CAN_10348 = WardEnum.W_10348.value
    HN_MINH_TAN_10351 = WardEnum.W_10351.value
    HN_VAN_DINH_10354 = WardEnum.W_10354.value
    HN_VIEN_AN_10357 = WardEnum.W_10357.value
    HN_VIEN_NOI_10360 = WardEnum.W_10360.value
    HN_HOA_SON_10363 = WardEnum.W_10363.value
    HN_QUANG_PHU_CAU_10366 = WardEnum.W_10366.value
    HN_TRUONG_THINH_10369 = WardEnum.W_10369.value
    HN_CAO_THANH_10372 = WardEnum.W_10372.value
    HN_LIEN_BAT_10375 = WardEnum.W_10375.value
    HN_SON_CONG_10378 = WardEnum.W_10378.value
    HN_DONG_TIEN_10381 = WardEnum.W_10381.value
    HN_PHUONG_TU_10384 = WardEnum.W_10384.value
    HN_TRUNG_TU_10387 = WardEnum.W_10387.value
    HN_DONG_TAN_10390 = WardEnum.W_10390.value
    HN_TAO_DUONG_VAN_10393 = WardEnum.W_10393.value
    HN_VAN_THAI_10396 = WardEnum.W_10396.value
    HN_MINH_DUC_10399 = WardEnum.W_10399.value
    HN_HOA_LAM_10402 = WardEnum.W_10402.value
    HN_HOA_XA_10405 = WardEnum.W_10405.value
    HN_TRAM_LONG_10408 = WardEnum.W_10408.value
    HN_KIM_DUONG_10411 = WardEnum.W_10411.value
    HN_HOA_NAM_10414 = WardEnum.W_10414.value
    HN_HOA_PHU_10417 = WardEnum.W_10417.value
    HN_DOI_BINH_10420 = WardEnum.W_10420.value
    HN_DAI_HUNG_10423 = WardEnum.W_10423.value
    HN_DONG_LO_10426 = WardEnum.W_10426.value
    HN_PHU_LUU_10429 = WardEnum.W_10429.value
    HN_DAI_CUONG_10432 = WardEnum.W_10432.value
    HN_LUU_HOANG_10435 = WardEnum.W_10435.value
    HN_HONG_QUANG_10438 = WardEnum.W_10438.value
    HN_DAI_NGHIA_10441 = WardEnum.W_10441.value
    HN_DONG_TAM_10444 = WardEnum.W_10444.value
    HN_THUONG_LAM_10447 = WardEnum.W_10447.value
    HN_TUY_LAI_10450 = WardEnum.W_10450.value
    HN_PHUC_LAM_10453 = WardEnum.W_10453.value
    HN_MY_THANH_10456 = WardEnum.W_10456.value
    HN_BOT_XUYEN_10459 = WardEnum.W_10459.value
    HN_AN_MY_10462 = WardEnum.W_10462.value
    HN_HONG_SON_10465 = WardEnum.W_10465.value
    HN_LE_THANH_10468 = WardEnum.W_10468.value
    HN_XUY_XA_10471 = WardEnum.W_10471.value
    HN_PHUNG_XA_10474 = WardEnum.W_10474.value
    HN_PHU_LUU_TE_10477 = WardEnum.W_10477.value
    HN_DAI_HUNG_10480 = WardEnum.W_10480.value
    HN_VAN_KIM_10483 = WardEnum.W_10483.value
    HN_DOC_TIN_10486 = WardEnum.W_10486.value
    HN_HUONG_SON_10489 = WardEnum.W_10489.value
    HN_HUNG_TIEN_10492 = WardEnum.W_10492.value
    HN_AN_TIEN_10495 = WardEnum.W_10495.value
    HN_HOP_TIEN_10498 = WardEnum.W_10498.value
    HN_HOP_THANH_10501 = WardEnum.W_10501.value
    HN_AN_PHU_10504 = WardEnum.W_10504.value
    HG_QUANG_TRUNG_688 = WardEnum.W_688.value
    HG_TRAN_PHU_691 = WardEnum.W_691.value
    HG_NGOC_HA_692 = WardEnum.W_692.value
    HG_NGUYEN_TRAI_694 = WardEnum.W_694.value
    HG_MINH_KHAI_697 = WardEnum.W_697.value
    HG_NGOC_DUONG_700 = WardEnum.W_700.value
    HG_PHUONG_DO_946 = WardEnum.W_946.value
    HG_PHUONG_THIEN_949 = WardEnum.W_949.value
    HG_PHO_BANG_712 = WardEnum.W_712.value
    HG_LUNG_CU_715 = WardEnum.W_715.value
    HG_MA_LE_718 = WardEnum.W_718.value
    HG_DONG_VAN_721 = WardEnum.W_721.value
    HG_LUNG_TAO_724 = WardEnum.W_724.value
    HG_PHO_LA_727 = WardEnum.W_727.value
    HG_THAI_PHIN_TUNG_730 = WardEnum.W_730.value
    HG_SUNG_LA_733 = WardEnum.W_733.value
    HG_XA_PHIN_736 = WardEnum.W_736.value
    HG_TA_PHIN_739 = WardEnum.W_739.value
    HG_TA_LUNG_742 = WardEnum.W_742.value
    HG_PHO_CAO_745 = WardEnum.W_745.value
    HG_SINH_LUNG_748 = WardEnum.W_748.value
    HG_SANG_TUNG_751 = WardEnum.W_751.value
    HG_LUNG_THAU_754 = WardEnum.W_754.value
    HG_HO_QUANG_PHIN_757 = WardEnum.W_757.value
    HG_VAN_CHAI_760 = WardEnum.W_760.value
    HG_LUNG_PHIN_763 = WardEnum.W_763.value
    HG_SUNG_TRAI_766 = WardEnum.W_766.value
    HG_MEO_VAC_769 = WardEnum.W_769.value
    HG_THUONG_PHUNG_772 = WardEnum.W_772.value
    HG_PAI_LUNG_775 = WardEnum.W_775.value
    HG_XIN_CAI_778 = WardEnum.W_778.value
    HG_PA_VI_781 = WardEnum.W_781.value
    HG_GIANG_CHU_PHIN_784 = WardEnum.W_784.value
    HG_SUNG_TRA_787 = WardEnum.W_787.value
    HG_SUNG_MANG_790 = WardEnum.W_790.value
    HG_SON_VI_793 = WardEnum.W_793.value
    HG_TA_LUNG_796 = WardEnum.W_796.value
    HG_CAN_CHU_PHIN_799 = WardEnum.W_799.value
    HG_LUNG_PU_802 = WardEnum.W_802.value
    HG_LUNG_CHINH_805 = WardEnum.W_805.value
    HG_TAT_NGA_808 = WardEnum.W_808.value
    HG_NAM_BAN_811 = WardEnum.W_811.value
    HG_KHAU_VAI_814 = WardEnum.W_814.value
    HG_NIEM_TONG_815 = WardEnum.W_815.value
    HG_NIEM_SON_817 = WardEnum.W_817.value
    HG_YEN_MINH_820 = WardEnum.W_820.value
    HG_THANG_MO_823 = WardEnum.W_823.value
    HG_PHU_LUNG_826 = WardEnum.W_826.value
    HG_SUNG_TRANG_829 = WardEnum.W_829.value
    HG_BACH_DICH_832 = WardEnum.W_832.value
    HG_NA_KHE_835 = WardEnum.W_835.value
    HG_SUNG_THAI_838 = WardEnum.W_838.value
    HG_HUU_VINH_841 = WardEnum.W_841.value
    HG_LAO_VA_CHAI_844 = WardEnum.W_844.value
    HG_MAU_DUE_847 = WardEnum.W_847.value
    HG_DONG_MINH_850 = WardEnum.W_850.value
    HG_MAU_LONG_853 = WardEnum.W_853.value
    HG_NGAM_LA_856 = WardEnum.W_856.value
    HG_NGOC_LONG_859 = WardEnum.W_859.value
    HG_DUONG_THUONG_862 = WardEnum.W_862.value
    HG_LUNG_HO_865 = WardEnum.W_865.value
    HG_DU_TIEN_868 = WardEnum.W_868.value
    HG_DU_GIA_871 = WardEnum.W_871.value
    HG_TAM_SON_874 = WardEnum.W_874.value
    HG_BAT_DAI_SON_877 = WardEnum.W_877.value
    HG_NGHIA_THUAN_880 = WardEnum.W_880.value
    HG_CAN_TY_883 = WardEnum.W_883.value
    HG_CAO_MA_PO_886 = WardEnum.W_886.value
    HG_THANH_VAN_889 = WardEnum.W_889.value
    HG_TUNG_VAI_892 = WardEnum.W_892.value
    HG_DONG_HA_895 = WardEnum.W_895.value
    HG_QUAN_BA_898 = WardEnum.W_898.value
    HG_LUNG_TAM_901 = WardEnum.W_901.value
    HG_QUYET_TIEN_904 = WardEnum.W_904.value
    HG_TA_VAN_907 = WardEnum.W_907.value
    HG_THAI_AN_910 = WardEnum.W_910.value
    HG_KIM_THACH_703 = WardEnum.W_703.value
    HG_PHU_LINH_706 = WardEnum.W_706.value
    HG_KIM_LINH_709 = WardEnum.W_709.value
    HG_VI_XUYEN_913 = WardEnum.W_913.value
    HG_NONG_TRUONG_VIET_LAM_916 = WardEnum.W_916.value
    HG_MINH_TAN_919 = WardEnum.W_919.value
    HG_THUAN_HOA_922 = WardEnum.W_922.value
    HG_TUNG_BA_925 = WardEnum.W_925.value
    HG_THANH_THUY_928 = WardEnum.W_928.value
    HG_THANH_DUC_931 = WardEnum.W_931.value
    HG_PHONG_QUANG_934 = WardEnum.W_934.value
    HG_XIN_CHAI_937 = WardEnum.W_937.value
    HG_PHUONG_TIEN_940 = WardEnum.W_940.value
    HG_LAO_CHAI_943 = WardEnum.W_943.value
    HG_CAO_BO_952 = WardEnum.W_952.value
    HG_DAO_DUC_955 = WardEnum.W_955.value
    HG_THUONG_SON_958 = WardEnum.W_958.value
    HG_LINH_HO_961 = WardEnum.W_961.value
    HG_QUANG_NGAN_964 = WardEnum.W_964.value
    HG_VIET_LAM_967 = WardEnum.W_967.value
    HG_NGOC_LINH_970 = WardEnum.W_970.value
    HG_NGOC_MINH_973 = WardEnum.W_973.value
    HG_BACH_NGOC_976 = WardEnum.W_976.value
    HG_TRUNG_THANH_979 = WardEnum.W_979.value
    HG_MINH_SON_982 = WardEnum.W_982.value
    HG_GIAP_TRUNG_985 = WardEnum.W_985.value
    HG_YEN_DINH_988 = WardEnum.W_988.value
    HG_YEN_PHU_991 = WardEnum.W_991.value
    HG_MINH_NGOC_994 = WardEnum.W_994.value
    HG_YEN_PHONG_997 = WardEnum.W_997.value
    HG_LAC_NONG_1000 = WardEnum.W_1000.value
    HG_PHU_NAM_1003 = WardEnum.W_1003.value
    HG_YEN_CUONG_1006 = WardEnum.W_1006.value
    HG_THUONG_TAN_1009 = WardEnum.W_1009.value
    HG_DUONG_AM_1012 = WardEnum.W_1012.value
    HG_DUONG_HONG_1015 = WardEnum.W_1015.value
    HG_PHIENG_LUONG_1018 = WardEnum.W_1018.value
    HG_VINH_QUANG_1021 = WardEnum.W_1021.value
    HG_BAN_MAY_1024 = WardEnum.W_1024.value
    HG_THANG_TIN_1027 = WardEnum.W_1027.value
    HG_THEN_CHU_PHIN_1030 = WardEnum.W_1030.value
    HG_PO_LO_1033 = WardEnum.W_1033.value
    HG_BAN_PHUNG_1036 = WardEnum.W_1036.value
    HG_TUNG_SAN_1039 = WardEnum.W_1039.value
    HG_CHIEN_PHO_1042 = WardEnum.W_1042.value
    HG_DAN_VAN_1045 = WardEnum.W_1045.value
    HG_TU_NHAN_1048 = WardEnum.W_1048.value
    HG_TAN_TIEN_1051 = WardEnum.W_1051.value
    HG_NANG_DON_1054 = WardEnum.W_1054.value
    HG_PO_LY_NGAI_1057 = WardEnum.W_1057.value
    HG_SAN_XA_HO_1060 = WardEnum.W_1060.value
    HG_BAN_LUOC_1063 = WardEnum.W_1063.value
    HG_NGAM_DANG_VAI_1066 = WardEnum.W_1066.value
    HG_BAN_NHUNG_1069 = WardEnum.W_1069.value
    HG_TA_SU_CHOONG_1072 = WardEnum.W_1072.value
    HG_NAM_DICH_1075 = WardEnum.W_1075.value
    HG_HO_THAU_1081 = WardEnum.W_1081.value
    HG_NAM_SON_1084 = WardEnum.W_1084.value
    HG_NAM_TY_1087 = WardEnum.W_1087.value
    HG_THONG_NGUYEN_1090 = WardEnum.W_1090.value
    HG_NAM_KHOA_1093 = WardEnum.W_1093.value
    HG_COC_PAI_1096 = WardEnum.W_1096.value
    HG_NAN_XIN_1099 = WardEnum.W_1099.value
    HG_BAN_DIU_1102 = WardEnum.W_1102.value
    HG_CHI_CA_1105 = WardEnum.W_1105.value
    HG_XIN_MAN_1108 = WardEnum.W_1108.value
    HG_THEN_PHANG_1114 = WardEnum.W_1114.value
    HG_TRUNG_THINH_1117 = WardEnum.W_1117.value
    HG_PA_VAY_SU_1120 = WardEnum.W_1120.value
    HG_COC_RE_1123 = WardEnum.W_1123.value
    HG_THU_TA_1126 = WardEnum.W_1126.value
    HG_NAN_MA_1129 = WardEnum.W_1129.value
    HG_TA_NHIU_1132 = WardEnum.W_1132.value
    HG_BAN_NGO_1135 = WardEnum.W_1135.value
    HG_CHE_LA_1138 = WardEnum.W_1138.value
    HG_NAM_DAN_1141 = WardEnum.W_1141.value
    HG_QUANG_NGUYEN_1144 = WardEnum.W_1144.value
    HG_NA_CHI_1147 = WardEnum.W_1147.value
    HG_KHUON_LUNG_1150 = WardEnum.W_1150.value
    HG_VIET_QUANG_1153 = WardEnum.W_1153.value
    HG_VINH_TUY_1156 = WardEnum.W_1156.value
    HG_TAN_LAP_1159 = WardEnum.W_1159.value
    HG_TAN_THANH_1162 = WardEnum.W_1162.value
    HG_DONG_TIEN_1165 = WardEnum.W_1165.value
    HG_DONG_TAM_1168 = WardEnum.W_1168.value
    HG_TAN_QUANG_1171 = WardEnum.W_1171.value
    HG_THUONG_BINH_1174 = WardEnum.W_1174.value
    HG_HUU_SAN_1177 = WardEnum.W_1177.value
    HG_KIM_NGOC_1180 = WardEnum.W_1180.value
    HG_VIET_VINH_1183 = WardEnum.W_1183.value
    HG_BANG_HANH_1186 = WardEnum.W_1186.value
    HG_QUANG_MINH_1189 = WardEnum.W_1189.value
    HG_LIEN_HIEP_1192 = WardEnum.W_1192.value
    HG_VO_DIEM_1195 = WardEnum.W_1195.value
    HG_VIET_HONG_1198 = WardEnum.W_1198.value
    HG_HUNG_AN_1201 = WardEnum.W_1201.value
    HG_DUC_XUAN_1204 = WardEnum.W_1204.value
    HG_TIEN_KIEU_1207 = WardEnum.W_1207.value
    HG_VINH_HAO_1210 = WardEnum.W_1210.value
    HG_VINH_PHUC_1213 = WardEnum.W_1213.value
    HG_DONG_YEN_1216 = WardEnum.W_1216.value
    HG_DONG_THANH_1219 = WardEnum.W_1219.value
    HG_XUAN_MINH_1222 = WardEnum.W_1222.value
    HG_TIEN_NGUYEN_1225 = WardEnum.W_1225.value
    HG_TAN_NAM_1228 = WardEnum.W_1228.value
    HG_BAN_RIA_1231 = WardEnum.W_1231.value
    HG_YEN_THANH_1234 = WardEnum.W_1234.value
    HG_YEN_BINH_1237 = WardEnum.W_1237.value
    HG_TAN_TRINH_1240 = WardEnum.W_1240.value
    HG_TAN_BAC_1243 = WardEnum.W_1243.value
    HG_BANG_LANG_1246 = WardEnum.W_1246.value
    HG_YEN_HA_1249 = WardEnum.W_1249.value
    HG_HUONG_SON_1252 = WardEnum.W_1252.value
    HG_XUAN_GIANG_1255 = WardEnum.W_1255.value
    HG_NA_KHUONG_1258 = WardEnum.W_1258.value
    HG_TIEN_YEN_1261 = WardEnum.W_1261.value
    HG_VI_THUONG_1264 = WardEnum.W_1264.value
    CB_SONG_HIEN_1267 = WardEnum.W_1267.value
    CB_SONG_BANG_1270 = WardEnum.W_1270.value
    CB_HOP_GIANG_1273 = WardEnum.W_1273.value
    CB_TAN_GIANG_1276 = WardEnum.W_1276.value
    CB_NGOC_XUAN_1279 = WardEnum.W_1279.value
    CB_DE_THAM_1282 = WardEnum.W_1282.value
    CB_HOA_CHUNG_1285 = WardEnum.W_1285.value
    CB_DUYET_TRUNG_1288 = WardEnum.W_1288.value
    CB_VINH_QUANG_1693 = WardEnum.W_1693.value
    CB_HUNG_DAO_1705 = WardEnum.W_1705.value
    CB_CHU_TRINH_1720 = WardEnum.W_1720.value
    CB_PAC_MIAU_1290 = WardEnum.W_1290.value
    CB_DUC_HANH_1291 = WardEnum.W_1291.value
    CB_LY_BON_1294 = WardEnum.W_1294.value
    CB_NAM_CAO_1296 = WardEnum.W_1296.value
    CB_NAM_QUANG_1297 = WardEnum.W_1297.value
    CB_VINH_QUANG_1300 = WardEnum.W_1300.value
    CB_QUANG_LAM_1303 = WardEnum.W_1303.value
    CB_THACH_LAM_1304 = WardEnum.W_1304.value
    CB_VINH_PHONG_1309 = WardEnum.W_1309.value
    CB_MONG_AN_1312 = WardEnum.W_1312.value
    CB_THAI_HOC_1315 = WardEnum.W_1315.value
    CB_THAI_SON_1316 = WardEnum.W_1316.value
    CB_YEN_THO_1318 = WardEnum.W_1318.value
    CB_BAO_LAC_1321 = WardEnum.W_1321.value
    CB_COC_PANG_1324 = WardEnum.W_1324.value
    CB_THUONG_HA_1327 = WardEnum.W_1327.value
    CB_CO_BA_1330 = WardEnum.W_1330.value
    CB_BAO_TOAN_1333 = WardEnum.W_1333.value
    CB_KHANH_XUAN_1336 = WardEnum.W_1336.value
    CB_XUAN_TRUONG_1339 = WardEnum.W_1339.value
    CB_HONG_TRI_1342 = WardEnum.W_1342.value
    CB_KIM_CUC_1343 = WardEnum.W_1343.value
    CB_PHAN_THANH_1345 = WardEnum.W_1345.value
    CB_HONG_AN_1348 = WardEnum.W_1348.value
    CB_HUNG_DAO_1351 = WardEnum.W_1351.value
    CB_HUNG_THINH_1352 = WardEnum.W_1352.value
    CB_HUY_GIAP_1354 = WardEnum.W_1354.value
    CB_DINH_PHUNG_1357 = WardEnum.W_1357.value
    CB_SON_LAP_1359 = WardEnum.W_1359.value
    CB_SON_LO_1360 = WardEnum.W_1360.value
    CB_THONG_NONG_1363 = WardEnum.W_1363.value
    CB_CAN_YEN_1366 = WardEnum.W_1366.value
    CB_CAN_NONG_1367 = WardEnum.W_1367.value
    CB_LUONG_THONG_1372 = WardEnum.W_1372.value
    CB_DA_THONG_1375 = WardEnum.W_1375.value
    CB_NGOC_DONG_1378 = WardEnum.W_1378.value
    CB_YEN_SON_1381 = WardEnum.W_1381.value
    CB_LUONG_CAN_1384 = WardEnum.W_1384.value
    CB_THANH_LONG_1387 = WardEnum.W_1387.value
    CB_XUAN_HOA_1392 = WardEnum.W_1392.value
    CB_LUNG_NAM_1393 = WardEnum.W_1393.value
    CB_TRUONG_HA_1399 = WardEnum.W_1399.value
    CB_CAI_VIEN_1402 = WardEnum.W_1402.value
    CB_NOI_THON_1411 = WardEnum.W_1411.value
    CB_TONG_COT_1414 = WardEnum.W_1414.value
    CB_SOC_HA_1417 = WardEnum.W_1417.value
    CB_THUONG_THON_1420 = WardEnum.W_1420.value
    CB_HONG_SY_1429 = WardEnum.W_1429.value
    CB_QUY_QUAN_1432 = WardEnum.W_1432.value
    CB_MA_BA_1435 = WardEnum.W_1435.value
    CB_NGOC_DAO_1438 = WardEnum.W_1438.value
    CB_TRA_LINH_1447 = WardEnum.W_1447.value
    CB_TRI_PHUONG_1453 = WardEnum.W_1453.value
    CB_QUANG_HAN_1456 = WardEnum.W_1456.value
    CB_XUAN_NOI_1462 = WardEnum.W_1462.value
    CB_QUANG_TRUNG_1465 = WardEnum.W_1465.value
    CB_QUANG_VINH_1468 = WardEnum.W_1468.value
    CB_CAO_CHUONG_1471 = WardEnum.W_1471.value
    CB_TRUNG_KHANH_1477 = WardEnum.W_1477.value
    CB_NGOC_KHE_1480 = WardEnum.W_1480.value
    CB_NGOC_CON_1481 = WardEnum.W_1481.value
    CB_PHONG_NAM_1483 = WardEnum.W_1483.value
    CB_DINH_PHONG_1489 = WardEnum.W_1489.value
    CB_DAM_THUY_1495 = WardEnum.W_1495.value
    CB_KHAM_THANH_1498 = WardEnum.W_1498.value
    CB_CHI_VIEN_1501 = WardEnum.W_1501.value
    CB_LANG_HIEU_1504 = WardEnum.W_1504.value
    CB_PHONG_CHAU_1507 = WardEnum.W_1507.value
    CB_TRUNG_PHUC_1516 = WardEnum.W_1516.value
    CB_CAO_THANG_1519 = WardEnum.W_1519.value
    CB_DUC_HONG_1522 = WardEnum.W_1522.value
    CB_DOAI_DUONG_1525 = WardEnum.W_1525.value
    CB_MINH_LONG_1534 = WardEnum.W_1534.value
    CB_LY_QUOC_1537 = WardEnum.W_1537.value
    CB_THANG_LOI_1540 = WardEnum.W_1540.value
    CB_DONG_LOAN_1543 = WardEnum.W_1543.value
    CB_DUC_QUANG_1546 = WardEnum.W_1546.value
    CB_KIM_LOAN_1549 = WardEnum.W_1549.value
    CB_QUANG_LONG_1552 = WardEnum.W_1552.value
    CB_AN_LAC_1555 = WardEnum.W_1555.value
    CB_THANH_NHAT_1558 = WardEnum.W_1558.value
    CB_VINH_QUY_1561 = WardEnum.W_1561.value
    CB_THONG_NHAT_1564 = WardEnum.W_1564.value
    CB_CO_NGAN_1567 = WardEnum.W_1567.value
    CB_THI_HOA_1573 = WardEnum.W_1573.value
    CB_QUOC_TOAN_1474 = WardEnum.W_1474.value
    CB_QUANG_UYEN_1576 = WardEnum.W_1576.value
    CB_PHI_HAI_1579 = WardEnum.W_1579.value
    CB_QUANG_HUNG_1582 = WardEnum.W_1582.value
    CB_DOC_LAP_1594 = WardEnum.W_1594.value
    CB_CAI_BO_1597 = WardEnum.W_1597.value
    CB_PHUC_SEN_1603 = WardEnum.W_1603.value
    CB_CHI_THAO_1606 = WardEnum.W_1606.value
    CB_TU_DO_1609 = WardEnum.W_1609.value
    CB_HONG_QUANG_1615 = WardEnum.W_1615.value
    CB_NGOC_DONG_1618 = WardEnum.W_1618.value
    CB_HANH_PHUC_1624 = WardEnum.W_1624.value
    CB_TA_LUNG_1627 = WardEnum.W_1627.value
    CB_BE_VAN_DAN_1630 = WardEnum.W_1630.value
    CB_CACH_LINH_1636 = WardEnum.W_1636.value
    CB_DAI_SON_1639 = WardEnum.W_1639.value
    CB_TIEN_THANH_1645 = WardEnum.W_1645.value
    CB_HOA_THUAN_1648 = WardEnum.W_1648.value
    CB_MY_HUNG_1651 = WardEnum.W_1651.value
    CB_NUOC_HAI_1654 = WardEnum.W_1654.value
    CB_DAN_CHU_1657 = WardEnum.W_1657.value
    CB_NAM_TUAN_1660 = WardEnum.W_1660.value
    CB_DAI_TIEN_1666 = WardEnum.W_1666.value
    CB_DUC_LONG_1669 = WardEnum.W_1669.value
    CB_NGU_LAO_1672 = WardEnum.W_1672.value
    CB_TRUONG_LUONG_1675 = WardEnum.W_1675.value
    CB_HONG_VIET_1687 = WardEnum.W_1687.value
    CB_HOANG_TUNG_1696 = WardEnum.W_1696.value
    CB_NGUYEN_HUE_1699 = WardEnum.W_1699.value
    CB_QUANG_TRUNG_1702 = WardEnum.W_1702.value
    CB_BACH_DANG_1708 = WardEnum.W_1708.value
    CB_BINH_DUONG_1711 = WardEnum.W_1711.value
    CB_LE_CHUNG_1714 = WardEnum.W_1714.value
    CB_HONG_NAM_1723 = WardEnum.W_1723.value
    CB_NGUYEN_BINH_1726 = WardEnum.W_1726.value
    CB_TINH_TUC_1729 = WardEnum.W_1729.value
    CB_YEN_LAC_1732 = WardEnum.W_1732.value
    CB_TRIEU_NGUYEN_1735 = WardEnum.W_1735.value
    CB_CA_THANH_1738 = WardEnum.W_1738.value
    CB_VU_NONG_1744 = WardEnum.W_1744.value
    CB_MINH_TAM_1747 = WardEnum.W_1747.value
    CB_THE_DUC_1750 = WardEnum.W_1750.value
    CB_MAI_LONG_1756 = WardEnum.W_1756.value
    CB_VU_MINH_1762 = WardEnum.W_1762.value
    CB_HOA_THAM_1765 = WardEnum.W_1765.value
    CB_PHAN_THANH_1768 = WardEnum.W_1768.value
    CB_QUANG_THANH_1771 = WardEnum.W_1771.value
    CB_TAM_KIM_1774 = WardEnum.W_1774.value
    CB_THANH_CONG_1777 = WardEnum.W_1777.value
    CB_THINH_VUONG_1780 = WardEnum.W_1780.value
    CB_HUNG_DAO_1783 = WardEnum.W_1783.value
    CB_DONG_KHE_1786 = WardEnum.W_1786.value
    CB_CANH_TAN_1789 = WardEnum.W_1789.value
    CB_KIM_DONG_1792 = WardEnum.W_1792.value
    CB_MINH_KHAI_1795 = WardEnum.W_1795.value
    CB_DUC_THONG_1801 = WardEnum.W_1801.value
    CB_THAI_CUONG_1804 = WardEnum.W_1804.value
    CB_VAN_TRINH_1807 = WardEnum.W_1807.value
    CB_THUY_HUNG_1810 = WardEnum.W_1810.value
    CB_QUANG_TRONG_1813 = WardEnum.W_1813.value
    CB_TRONG_CON_1816 = WardEnum.W_1816.value
    CB_LE_LAI_1819 = WardEnum.W_1819.value
    CB_DUC_LONG_1822 = WardEnum.W_1822.value
    CB_LE_LOI_1828 = WardEnum.W_1828.value
    CB_DUC_XUAN_1831 = WardEnum.W_1831.value
    BK_NGUYEN_THI_MINH_KHAI_1834 = WardEnum.W_1834.value
    BK_SONG_CAU_1837 = WardEnum.W_1837.value
    BK_DUC_XUAN_1840 = WardEnum.W_1840.value
    BK_PHUNG_CHI_KIEN_1843 = WardEnum.W_1843.value
    BK_HUYEN_TUNG_1846 = WardEnum.W_1846.value
    BK_DUONG_QUANG_1849 = WardEnum.W_1849.value
    BK_NONG_THUONG_1852 = WardEnum.W_1852.value
    BK_XUAT_HOA_1855 = WardEnum.W_1855.value
    BK_BANG_THANH_1858 = WardEnum.W_1858.value
    BK_NHAN_MON_1861 = WardEnum.W_1861.value
    BK_BOC_BO_1864 = WardEnum.W_1864.value
    BK_CONG_BANG_1867 = WardEnum.W_1867.value
    BK_GIAO_HIEU_1870 = WardEnum.W_1870.value
    BK_XUAN_LA_1873 = WardEnum.W_1873.value
    BK_AN_THANG_1876 = WardEnum.W_1876.value
    BK_CO_LINH_1879 = WardEnum.W_1879.value
    BK_NGHIEN_LOAN_1882 = WardEnum.W_1882.value
    BK_CAO_TAN_1885 = WardEnum.W_1885.value
    BK_CHO_RA_1888 = WardEnum.W_1888.value
    BK_BANH_TRACH_1891 = WardEnum.W_1891.value
    BK_PHUC_LOC_1894 = WardEnum.W_1894.value
    BK_HA_HIEU_1897 = WardEnum.W_1897.value
    BK_CAO_THUONG_1900 = WardEnum.W_1900.value
    BK_KHANG_NINH_1906 = WardEnum.W_1906.value
    BK_NAM_MAU_1909 = WardEnum.W_1909.value
    BK_THUONG_GIAO_1912 = WardEnum.W_1912.value
    BK_DIA_LINH_1915 = WardEnum.W_1915.value
    BK_YEN_DUONG_1918 = WardEnum.W_1918.value
    BK_CHU_HUONG_1921 = WardEnum.W_1921.value
    BK_QUANG_KHE_1924 = WardEnum.W_1924.value
    BK_MY_PHUONG_1927 = WardEnum.W_1927.value
    BK_HOANG_TRI_1930 = WardEnum.W_1930.value
    BK_DONG_PHUC_1933 = WardEnum.W_1933.value
    BK_NA_PHAC_1936 = WardEnum.W_1936.value
    BK_THUONG_AN_1939 = WardEnum.W_1939.value
    BK_BANG_VAN_1942 = WardEnum.W_1942.value
    BK_COC_DAN_1945 = WardEnum.W_1945.value
    BK_TRUNG_HOA_1948 = WardEnum.W_1948.value
    BK_DUC_VAN_1951 = WardEnum.W_1951.value
    BK_VAN_TUNG_1954 = WardEnum.W_1954.value
    BK_THUONG_QUAN_1957 = WardEnum.W_1957.value
    BK_HIEP_LUC_1960 = WardEnum.W_1960.value
    BK_THUAN_MANG_1963 = WardEnum.W_1963.value
    BK_PHU_THONG_1969 = WardEnum.W_1969.value
    BK_VI_HUONG_1975 = WardEnum.W_1975.value
    BK_SI_BINH_1978 = WardEnum.W_1978.value
    BK_VU_MUON_1981 = WardEnum.W_1981.value
    BK_DON_PHONG_1984 = WardEnum.W_1984.value
    BK_LUC_BINH_1990 = WardEnum.W_1990.value
    BK_TAN_TU_1993 = WardEnum.W_1993.value
    BK_NGUYEN_PHUC_1999 = WardEnum.W_1999.value
    BK_CAO_SON_2002 = WardEnum.W_2002.value
    BK_QUAN_HA_2005 = WardEnum.W_2005.value
    BK_CAM_GIANG_2008 = WardEnum.W_2008.value
    BK_MY_THANH_2011 = WardEnum.W_2011.value
    BK_DUONG_PHONG_2014 = WardEnum.W_2014.value
    BK_QUANG_THUAN_2017 = WardEnum.W_2017.value
    BK_BANG_LUNG_2020 = WardEnum.W_2020.value
    BK_XUAN_LAC_2023 = WardEnum.W_2023.value
    BK_NAM_CUONG_2026 = WardEnum.W_2026.value
    BK_DONG_LAC_2029 = WardEnum.W_2029.value
    BK_TAN_LAP_2032 = WardEnum.W_2032.value
    BK_BAN_THI_2035 = WardEnum.W_2035.value
    BK_QUANG_BACH_2038 = WardEnum.W_2038.value
    BK_BANG_PHUC_2041 = WardEnum.W_2041.value
    BK_YEN_THINH_2044 = WardEnum.W_2044.value
    BK_YEN_THUONG_2047 = WardEnum.W_2047.value
    BK_PHUONG_VIEN_2050 = WardEnum.W_2050.value
    BK_NGOC_PHAI_2053 = WardEnum.W_2053.value
    BK_DONG_THANG_2059 = WardEnum.W_2059.value
    BK_LUONG_BANG_2062 = WardEnum.W_2062.value
    BK_BANG_LANG_2065 = WardEnum.W_2065.value
    BK_DAI_SAO_2068 = WardEnum.W_2068.value
    BK_NGHIA_TA_2071 = WardEnum.W_2071.value
    BK_YEN_MY_2077 = WardEnum.W_2077.value
    BK_BINH_TRUNG_2080 = WardEnum.W_2080.value
    BK_YEN_PHONG_2083 = WardEnum.W_2083.value
    BK_DONG_TAM_2086 = WardEnum.W_2086.value
    BK_TAN_SON_2089 = WardEnum.W_2089.value
    BK_THANH_VAN_2092 = WardEnum.W_2092.value
    BK_MAI_LAP_2095 = WardEnum.W_2095.value
    BK_HOA_MUC_2098 = WardEnum.W_2098.value
    BK_THANH_MAI_2101 = WardEnum.W_2101.value
    BK_CAO_KY_2104 = WardEnum.W_2104.value
    BK_NONG_HA_2107 = WardEnum.W_2107.value
    BK_YEN_CU_2110 = WardEnum.W_2110.value
    BK_THANH_THINH_2113 = WardEnum.W_2113.value
    BK_YEN_HAN_2116 = WardEnum.W_2116.value
    BK_NHU_CO_2122 = WardEnum.W_2122.value
    BK_BINH_VAN_2125 = WardEnum.W_2125.value
    BK_QUANG_CHU_2131 = WardEnum.W_2131.value
    BK_VAN_VU_2137 = WardEnum.W_2137.value
    BK_VAN_LANG_2140 = WardEnum.W_2140.value
    BK_LUONG_THUONG_2143 = WardEnum.W_2143.value
    BK_KIM_HY_2146 = WardEnum.W_2146.value
    BK_CUONG_LOI_2152 = WardEnum.W_2152.value
    BK_YEN_LAC_2155 = WardEnum.W_2155.value
    BK_KIM_LU_2158 = WardEnum.W_2158.value
    BK_SON_THANH_2161 = WardEnum.W_2161.value
    BK_VAN_MINH_2170 = WardEnum.W_2170.value
    BK_CON_MINH_2173 = WardEnum.W_2173.value
    BK_CU_LE_2176 = WardEnum.W_2176.value
    BK_TRAN_PHU_2179 = WardEnum.W_2179.value
    BK_QUANG_PHONG_2185 = WardEnum.W_2185.value
    BK_DUONG_SON_2188 = WardEnum.W_2188.value
    BK_XUAN_DUONG_2191 = WardEnum.W_2191.value
    BK_DONG_XA_2194 = WardEnum.W_2194.value
    BK_LIEM_THUY_2197 = WardEnum.W_2197.value
    TQ_PHAN_THIET_2200 = WardEnum.W_2200.value
    TQ_MINH_XUAN_2203 = WardEnum.W_2203.value
    TQ_TAN_QUANG_2206 = WardEnum.W_2206.value
    TQ_TRANG_DA_2209 = WardEnum.W_2209.value
    TQ_NONG_TIEN_2212 = WardEnum.W_2212.value
    TQ_Y_LA_2215 = WardEnum.W_2215.value
    TQ_TAN_HA_2216 = WardEnum.W_2216.value
    TQ_HUNG_THANH_2218 = WardEnum.W_2218.value
    TQ_KIM_PHU_2497 = WardEnum.W_2497.value
    TQ_AN_KHANG_2503 = WardEnum.W_2503.value
    TQ_MY_LAM_2509 = WardEnum.W_2509.value
    TQ_AN_TUONG_2512 = WardEnum.W_2512.value
    TQ_LUONG_VUONG_2515 = WardEnum.W_2515.value
    TQ_THAI_LONG_2521 = WardEnum.W_2521.value
    TQ_DOI_CAN_2524 = WardEnum.W_2524.value
    TQ_PHUC_YEN_2233 = WardEnum.W_2233.value
    TQ_XUAN_LAP_2242 = WardEnum.W_2242.value
    TQ_KHUON_HA_2251 = WardEnum.W_2251.value
    TQ_LANG_CAN_2266 = WardEnum.W_2266.value
    TQ_THUONG_LAM_2269 = WardEnum.W_2269.value
    TQ_BINH_AN_2290 = WardEnum.W_2290.value
    TQ_HONG_QUANG_2293 = WardEnum.W_2293.value
    TQ_THO_BINH_2296 = WardEnum.W_2296.value
    TQ_NA_HANG_2221 = WardEnum.W_2221.value
    TQ_SINH_LONG_2227 = WardEnum.W_2227.value
    TQ_THUONG_GIAP_2230 = WardEnum.W_2230.value
    TQ_THUONG_NONG_2239 = WardEnum.W_2239.value
    TQ_CON_LON_2245 = WardEnum.W_2245.value
    TQ_YEN_HOA_2248 = WardEnum.W_2248.value
    TQ_HONG_THAI_2254 = WardEnum.W_2254.value
    TQ_DA_VI_2260 = WardEnum.W_2260.value
    TQ_KHAU_TINH_2263 = WardEnum.W_2263.value
    TQ_SON_PHU_2275 = WardEnum.W_2275.value
    TQ_NANG_KHA_2281 = WardEnum.W_2281.value
    TQ_THANH_TUONG_2284 = WardEnum.W_2284.value
    TQ_VINH_LOC_2287 = WardEnum.W_2287.value
    TQ_PHUC_SON_2299 = WardEnum.W_2299.value
    TQ_MINH_QUANG_2302 = WardEnum.W_2302.value
    TQ_TRUNG_HA_2305 = WardEnum.W_2305.value
    TQ_TAN_MY_2308 = WardEnum.W_2308.value
    TQ_HA_LANG_2311 = WardEnum.W_2311.value
    TQ_HUNG_MY_2314 = WardEnum.W_2314.value
    TQ_YEN_LAP_2317 = WardEnum.W_2317.value
    TQ_TAN_AN_2320 = WardEnum.W_2320.value
    TQ_BINH_PHU_2323 = WardEnum.W_2323.value
    TQ_XUAN_QUANG_2326 = WardEnum.W_2326.value
    TQ_NGOC_HOI_2329 = WardEnum.W_2329.value
    TQ_PHU_BINH_2332 = WardEnum.W_2332.value
    TQ_HOA_PHU_2335 = WardEnum.W_2335.value
    TQ_PHUC_THINH_2338 = WardEnum.W_2338.value
    TQ_KIEN_DAI_2341 = WardEnum.W_2341.value
    TQ_TAN_THINH_2344 = WardEnum.W_2344.value
    TQ_TRUNG_HOA_2347 = WardEnum.W_2347.value
    TQ_KIM_BINH_2350 = WardEnum.W_2350.value
    TQ_HOA_AN_2353 = WardEnum.W_2353.value
    TQ_VINH_QUANG_2356 = WardEnum.W_2356.value
    TQ_TRI_PHU_2359 = WardEnum.W_2359.value
    TQ_NHAN_LY_2362 = WardEnum.W_2362.value
    TQ_YEN_NGUYEN_2365 = WardEnum.W_2365.value
    TQ_LINH_PHU_2368 = WardEnum.W_2368.value
    TQ_BINH_NHAN_2371 = WardEnum.W_2371.value
    TQ_TAN_YEN_2374 = WardEnum.W_2374.value
    TQ_YEN_THUAN_2377 = WardEnum.W_2377.value
    TQ_BACH_XA_2380 = WardEnum.W_2380.value
    TQ_MINH_KHUONG_2383 = WardEnum.W_2383.value
    TQ_YEN_LAM_2386 = WardEnum.W_2386.value
    TQ_MINH_DAN_2389 = WardEnum.W_2389.value
    TQ_PHU_LUU_2392 = WardEnum.W_2392.value
    TQ_MINH_HUONG_2395 = WardEnum.W_2395.value
    TQ_YEN_PHU_2398 = WardEnum.W_2398.value
    TQ_TAN_THANH_2401 = WardEnum.W_2401.value
    TQ_BINH_XA_2404 = WardEnum.W_2404.value
    TQ_THAI_SON_2407 = WardEnum.W_2407.value
    TQ_NHAN_MUC_2410 = WardEnum.W_2410.value
    TQ_THANH_LONG_2413 = WardEnum.W_2413.value
    TQ_BANG_COC_2416 = WardEnum.W_2416.value
    TQ_THAI_HOA_2419 = WardEnum.W_2419.value
    TQ_DUC_NINH_2422 = WardEnum.W_2422.value
    TQ_HUNG_DUC_2425 = WardEnum.W_2425.value
    TQ_QUI_QUAN_2431 = WardEnum.W_2431.value
    TQ_LUC_HANH_2434 = WardEnum.W_2434.value
    TQ_KIEN_THIET_2437 = WardEnum.W_2437.value
    TQ_TRUNG_MINH_2440 = WardEnum.W_2440.value
    TQ_CHIEU_YEN_2443 = WardEnum.W_2443.value
    TQ_TRUNG_TRUC_2446 = WardEnum.W_2446.value
    TQ_XUAN_VAN_2449 = WardEnum.W_2449.value
    TQ_PHUC_NINH_2452 = WardEnum.W_2452.value
    TQ_HUNG_LOI_2455 = WardEnum.W_2455.value
    TQ_TRUNG_SON_2458 = WardEnum.W_2458.value
    TQ_TAN_TIEN_2461 = WardEnum.W_2461.value
    TQ_TU_QUAN_2464 = WardEnum.W_2464.value
    TQ_DAO_VIEN_2467 = WardEnum.W_2467.value
    TQ_TAN_LONG_2470 = WardEnum.W_2470.value
    TQ_THANG_QUAN_2473 = WardEnum.W_2473.value
    TQ_KIM_QUAN_2476 = WardEnum.W_2476.value
    TQ_LANG_QUAN_2479 = WardEnum.W_2479.value
    TQ_PHU_THINH_2482 = WardEnum.W_2482.value
    TQ_CONG_DA_2485 = WardEnum.W_2485.value
    TQ_TRUNG_MON_2488 = WardEnum.W_2488.value
    TQ_CHAN_SON_2491 = WardEnum.W_2491.value
    TQ_THAI_BINH_2494 = WardEnum.W_2494.value
    TQ_TIEN_BO_2500 = WardEnum.W_2500.value
    TQ_MY_BANG_2506 = WardEnum.W_2506.value
    TQ_HOANG_KHAI_2518 = WardEnum.W_2518.value
    TQ_NHU_HAN_2527 = WardEnum.W_2527.value
    TQ_NHU_KHE_2530 = WardEnum.W_2530.value
    TQ_DOI_BINH_2533 = WardEnum.W_2533.value
    TQ_SON_DUONG_2536 = WardEnum.W_2536.value
    TQ_TRUNG_YEN_2539 = WardEnum.W_2539.value
    TQ_MINH_THANH_2542 = WardEnum.W_2542.value
    TQ_TAN_TRAO_2545 = WardEnum.W_2545.value
    TQ_VINH_LOI_2548 = WardEnum.W_2548.value
    TQ_THUONG_AM_2551 = WardEnum.W_2551.value
    TQ_BINH_YEN_2554 = WardEnum.W_2554.value
    TQ_LUONG_THIEN_2557 = WardEnum.W_2557.value
    TQ_TU_THINH_2560 = WardEnum.W_2560.value
    TQ_CAP_TIEN_2563 = WardEnum.W_2563.value
    TQ_HOP_THANH_2566 = WardEnum.W_2566.value
    TQ_PHUC_UNG_2569 = WardEnum.W_2569.value
    TQ_DONG_THO_2572 = WardEnum.W_2572.value
    TQ_KHANG_NHAT_2575 = WardEnum.W_2575.value
    TQ_HOP_HOA_2578 = WardEnum.W_2578.value
    TQ_QUYET_THANG_2584 = WardEnum.W_2584.value
    TQ_DONG_QUY_2587 = WardEnum.W_2587.value
    TQ_TAN_THANH_2590 = WardEnum.W_2590.value
    TQ_VAN_SON_2593 = WardEnum.W_2593.value
    TQ_VAN_PHU_2596 = WardEnum.W_2596.value
    TQ_CHI_THIET_2599 = WardEnum.W_2599.value
    TQ_DONG_LOI_2602 = WardEnum.W_2602.value
    TQ_THIEN_KE_2605 = WardEnum.W_2605.value
    TQ_HONG_LAC_2608 = WardEnum.W_2608.value
    TQ_PHU_LUONG_2611 = WardEnum.W_2611.value
    TQ_NINH_LAI_2614 = WardEnum.W_2614.value
    TQ_DAI_PHU_2617 = WardEnum.W_2617.value
    TQ_SON_NAM_2620 = WardEnum.W_2620.value
    TQ_HAO_PHU_2623 = WardEnum.W_2623.value
    TQ_TAM_DA_2626 = WardEnum.W_2626.value
    TQ_TRUONG_SINH_2632 = WardEnum.W_2632.value
    LC_DUYEN_HAI_2635 = WardEnum.W_2635.value
    LC_LAO_CAI_2641 = WardEnum.W_2641.value
    LC_COC_LEU_2644 = WardEnum.W_2644.value
    LC_KIM_TAN_2647 = WardEnum.W_2647.value
    LC_BAC_LENH_2650 = WardEnum.W_2650.value
    LC_POM_HAN_2653 = WardEnum.W_2653.value
    LC_XUAN_TANG_2656 = WardEnum.W_2656.value
    LC_BINH_MINH_2658 = WardEnum.W_2658.value
    LC_THONG_NHAT_2659 = WardEnum.W_2659.value
    LC_DONG_TUYEN_2662 = WardEnum.W_2662.value
    LC_VAN_HOA_2665 = WardEnum.W_2665.value
    LC_BAC_CUONG_2668 = WardEnum.W_2668.value
    LC_NAM_CUONG_2671 = WardEnum.W_2671.value
    LC_CAM_DUONG_2674 = WardEnum.W_2674.value
    LC_TA_PHOI_2677 = WardEnum.W_2677.value
    LC_HOP_THANH_2680 = WardEnum.W_2680.value
    LC_COC_SAN_2746 = WardEnum.W_2746.value
    LC_BAT_XAT_2683 = WardEnum.W_2683.value
    LC_A_MU_SUNG_2686 = WardEnum.W_2686.value
    LC_NAM_CHAC_2689 = WardEnum.W_2689.value
    LC_A_LU_2692 = WardEnum.W_2692.value
    LC_TRINH_TUONG_2695 = WardEnum.W_2695.value
    LC_Y_TY_2701 = WardEnum.W_2701.value
    LC_COC_MY_2704 = WardEnum.W_2704.value
    LC_DEN_SANG_2707 = WardEnum.W_2707.value
    LC_BAN_VUOC_2710 = WardEnum.W_2710.value
    LC_SANG_MA_SAO_2713 = WardEnum.W_2713.value
    LC_BAN_QUA_2716 = WardEnum.W_2716.value
    LC_MUONG_VI_2719 = WardEnum.W_2719.value
    LC_DEN_THANG_2722 = WardEnum.W_2722.value
    LC_BAN_XEO_2725 = WardEnum.W_2725.value
    LC_MUONG_HUM_2728 = WardEnum.W_2728.value
    LC_TRUNG_LENG_HO_2731 = WardEnum.W_2731.value
    LC_QUANG_KIM_2734 = WardEnum.W_2734.value
    LC_PA_CHEO_2737 = WardEnum.W_2737.value
    LC_NAM_PUNG_2740 = WardEnum.W_2740.value
    LC_PHIN_NGAN_2743 = WardEnum.W_2743.value
    LC_TONG_SANH_2749 = WardEnum.W_2749.value
    LC_PHA_LONG_2752 = WardEnum.W_2752.value
    LC_TA_NGAI_CHO_2755 = WardEnum.W_2755.value
    LC_TUNG_CHUNG_PHO_2758 = WardEnum.W_2758.value
    LC_MUONG_KHUONG_2761 = WardEnum.W_2761.value
    LC_DIN_CHIN_2764 = WardEnum.W_2764.value
    LC_TA_GIA_KHAU_2767 = WardEnum.W_2767.value
    LC_NAM_CHAY_2770 = WardEnum.W_2770.value
    LC_NAM_LU_2773 = WardEnum.W_2773.value
    LC_LUNG_KHAU_NHIN_2776 = WardEnum.W_2776.value
    LC_THANH_BINH_2779 = WardEnum.W_2779.value
    LC_CAO_SON_2782 = WardEnum.W_2782.value
    LC_LUNG_VAI_2785 = WardEnum.W_2785.value
    LC_BAN_LAU_2788 = WardEnum.W_2788.value
    LC_LA_PAN_TAN_2791 = WardEnum.W_2791.value
    LC_TA_THANG_2794 = WardEnum.W_2794.value
    LC_BAN_SEN_2797 = WardEnum.W_2797.value
    LC_NAN_SAN_2800 = WardEnum.W_2800.value
    LC_THAO_CHU_PHIN_2803 = WardEnum.W_2803.value
    LC_BAN_ME_2806 = WardEnum.W_2806.value
    LC_SI_MA_CAI_2809 = WardEnum.W_2809.value
    LC_SAN_CHAI_2812 = WardEnum.W_2812.value
    LC_LUNG_THAN_2818 = WardEnum.W_2818.value
    LC_CAN_CAU_2821 = WardEnum.W_2821.value
    LC_SIN_CHENG_2824 = WardEnum.W_2824.value
    LC_QUAN_HO_THAN_2827 = WardEnum.W_2827.value
    LC_NAN_XIN_2836 = WardEnum.W_2836.value
    LC_BAC_HA_2839 = WardEnum.W_2839.value
    LC_LUNG_CAI_2842 = WardEnum.W_2842.value
    LC_LUNG_PHINH_2848 = WardEnum.W_2848.value
    LC_TA_VAN_CHU_2851 = WardEnum.W_2851.value
    LC_TA_CU_TY_2854 = WardEnum.W_2854.value
    LC_THAI_GIANG_PHO_2857 = WardEnum.W_2857.value
    LC_HOANG_THU_PHO_2863 = WardEnum.W_2863.value
    LC_BAN_PHO_2866 = WardEnum.W_2866.value
    LC_BAN_LIEN_2869 = WardEnum.W_2869.value
    LC_TA_CHAI_2872 = WardEnum.W_2872.value
    LC_NA_HOI_2875 = WardEnum.W_2875.value
    LC_COC_LY_2878 = WardEnum.W_2878.value
    LC_NAM_MON_2881 = WardEnum.W_2881.value
    LC_NAM_DET_2884 = WardEnum.W_2884.value
    LC_NAM_KHANH_2887 = WardEnum.W_2887.value
    LC_BAO_NHAI_2890 = WardEnum.W_2890.value
    LC_NAM_LUC_2893 = WardEnum.W_2893.value
    LC_COC_LAU_2896 = WardEnum.W_2896.value
    LC_BAN_CAI_2899 = WardEnum.W_2899.value
    LC_N_T_PHONG_HAI_2902 = WardEnum.W_2902.value
    LC_PHO_LU_2905 = WardEnum.W_2905.value
    LC_TANG_LOONG_2908 = WardEnum.W_2908.value
    LC_BAN_PHIET_2911 = WardEnum.W_2911.value
    LC_BAN_CAM_2914 = WardEnum.W_2914.value
    LC_THAI_NIEN_2917 = WardEnum.W_2917.value
    LC_PHONG_NIEN_2920 = WardEnum.W_2920.value
    LC_GIA_PHU_2923 = WardEnum.W_2923.value
    LC_XUAN_QUANG_2926 = WardEnum.W_2926.value
    LC_SON_HAI_2929 = WardEnum.W_2929.value
    LC_XUAN_GIAO_2932 = WardEnum.W_2932.value
    LC_TRI_QUANG_2935 = WardEnum.W_2935.value
    LC_SON_HA_2938 = WardEnum.W_2938.value
    LC_PHU_NHUAN_2944 = WardEnum.W_2944.value
    LC_PHO_RANG_2947 = WardEnum.W_2947.value
    LC_TAN_TIEN_2950 = WardEnum.W_2950.value
    LC_NGHIA_DO_2953 = WardEnum.W_2953.value
    LC_VINH_YEN_2956 = WardEnum.W_2956.value
    LC_DIEN_QUAN_2959 = WardEnum.W_2959.value
    LC_XUAN_HOA_2962 = WardEnum.W_2962.value
    LC_TAN_DUONG_2965 = WardEnum.W_2965.value
    LC_THUONG_HA_2968 = WardEnum.W_2968.value
    LC_KIM_SON_2971 = WardEnum.W_2971.value
    LC_CAM_CON_2974 = WardEnum.W_2974.value
    LC_MINH_TAN_2977 = WardEnum.W_2977.value
    LC_XUAN_THUONG_2980 = WardEnum.W_2980.value
    LC_VIET_TIEN_2983 = WardEnum.W_2983.value
    LC_YEN_SON_2986 = WardEnum.W_2986.value
    LC_BAO_HA_2989 = WardEnum.W_2989.value
    LC_LUONG_SON_2992 = WardEnum.W_2992.value
    LC_PHUC_KHANH_2998 = WardEnum.W_2998.value
    LC_SA_PA_3001 = WardEnum.W_3001.value
    LC_SA_PA_3002 = WardEnum.W_3002.value
    LC_O_QUY_HO_3003 = WardEnum.W_3003.value
    LC_NGU_CHI_SON_3004 = WardEnum.W_3004.value
    LC_PHAN_SI_PANG_3006 = WardEnum.W_3006.value
    LC_TRUNG_CHAI_3010 = WardEnum.W_3010.value
    LC_TA_PHIN_3013 = WardEnum.W_3013.value
    LC_HAM_RONG_3016 = WardEnum.W_3016.value
    LC_HOANG_LIEN_3019 = WardEnum.W_3019.value
    LC_THANH_BINH_3022 = WardEnum.W_3022.value
    LC_CAU_MAY_3028 = WardEnum.W_3028.value
    LC_MUONG_HOA_3037 = WardEnum.W_3037.value
    LC_TA_VAN_3040 = WardEnum.W_3040.value
    LC_MUONG_BO_3043 = WardEnum.W_3043.value
    LC_BAN_HO_3046 = WardEnum.W_3046.value
    LC_LIEN_MINH_3052 = WardEnum.W_3052.value
    LC_KHANH_YEN_3055 = WardEnum.W_3055.value
    LC_VO_LAO_3061 = WardEnum.W_3061.value
    LC_SON_THUY_3064 = WardEnum.W_3064.value
    LC_NAM_MA_3067 = WardEnum.W_3067.value
    LC_TAN_THUONG_3070 = WardEnum.W_3070.value
    LC_NAM_RANG_3073 = WardEnum.W_3073.value
    LC_NAM_CHAY_3076 = WardEnum.W_3076.value
    LC_TAN_AN_3079 = WardEnum.W_3079.value
    LC_KHANH_YEN_THUONG_3082 = WardEnum.W_3082.value
    LC_NAM_XE_3085 = WardEnum.W_3085.value
    LC_DAN_THANG_3088 = WardEnum.W_3088.value
    LC_CHIENG_KEN_3091 = WardEnum.W_3091.value
    LC_LANG_GIANG_3094 = WardEnum.W_3094.value
    LC_HOA_MAC_3097 = WardEnum.W_3097.value
    LC_KHANH_YEN_TRUNG_3100 = WardEnum.W_3100.value
    LC_KHANH_YEN_HA_3103 = WardEnum.W_3103.value
    LC_DUONG_QUY_3106 = WardEnum.W_3106.value
    LC_NAM_THA_3109 = WardEnum.W_3109.value
    LC_MINH_LUONG_3112 = WardEnum.W_3112.value
    LC_THAM_DUONG_3115 = WardEnum.W_3115.value
    LC_LIEM_PHU_3118 = WardEnum.W_3118.value
    LC_NAM_XAY_3121 = WardEnum.W_3121.value
    DB_NOONG_BUA_3124 = WardEnum.W_3124.value
    DB_HIM_LAM_3127 = WardEnum.W_3127.value
    DB_THANH_BINH_3130 = WardEnum.W_3130.value
    DB_TAN_THANH_3133 = WardEnum.W_3133.value
    DB_MUONG_THANH_3136 = WardEnum.W_3136.value
    DB_NAM_THANH_3139 = WardEnum.W_3139.value
    DB_THANH_TRUONG_3142 = WardEnum.W_3142.value
    DB_THANH_MINH_3145 = WardEnum.W_3145.value
    DB_NA_TAU_3316 = WardEnum.W_3316.value
    DB_NA_NHAN_3317 = WardEnum.W_3317.value
    DB_MUONG_PHANG_3325 = WardEnum.W_3325.value
    DB_PA_KHOANG_3326 = WardEnum.W_3326.value
    DB_SONG_DA_3148 = WardEnum.W_3148.value
    DB_NA_LAY_3151 = WardEnum.W_3151.value
    DB_LAY_NUA_3184 = WardEnum.W_3184.value
    DB_SIN_THAU_3154 = WardEnum.W_3154.value
    DB_SEN_THUONG_3155 = WardEnum.W_3155.value
    DB_CHUNG_CHAI_3157 = WardEnum.W_3157.value
    DB_LENG_SU_SIN_3158 = WardEnum.W_3158.value
    DB_PA_MY_3159 = WardEnum.W_3159.value
    DB_MUONG_NHE_3160 = WardEnum.W_3160.value
    DB_NAM_VI_3161 = WardEnum.W_3161.value
    DB_NAM_KE_3162 = WardEnum.W_3162.value
    DB_MUONG_TOONG_3163 = WardEnum.W_3163.value
    DB_QUANG_LAM_3164 = WardEnum.W_3164.value
    DB_HUOI_LENH_3177 = WardEnum.W_3177.value
    DB_MUONG_CHA_3172 = WardEnum.W_3172.value
    DB_XA_TONG_3178 = WardEnum.W_3178.value
    DB_MUONG_TUNG_3181 = WardEnum.W_3181.value
    DB_HUA_NGAI_3190 = WardEnum.W_3190.value
    DB_HUOI_MI_3191 = WardEnum.W_3191.value
    DB_PA_HAM_3193 = WardEnum.W_3193.value
    DB_NAM_NEN_3194 = WardEnum.W_3194.value
    DB_HUOI_LENG_3196 = WardEnum.W_3196.value
    DB_SA_LONG_3197 = WardEnum.W_3197.value
    DB_MA_THI_HO_3200 = WardEnum.W_3200.value
    DB_NA_SANG_3201 = WardEnum.W_3201.value
    DB_MUONG_MUON_3202 = WardEnum.W_3202.value
    DB_TUA_CHUA_3217 = WardEnum.W_3217.value
    DB_HUOI_SO_3220 = WardEnum.W_3220.value
    DB_XIN_CHAI_3223 = WardEnum.W_3223.value
    DB_TA_SIN_THANG_3226 = WardEnum.W_3226.value
    DB_LAO_XA_PHINH_3229 = WardEnum.W_3229.value
    DB_TA_PHIN_3232 = WardEnum.W_3232.value
    DB_TUA_THANG_3235 = WardEnum.W_3235.value
    DB_TRUNG_THU_3238 = WardEnum.W_3238.value
    DB_SINH_PHINH_3241 = WardEnum.W_3241.value
    DB_SANG_NHE_3244 = WardEnum.W_3244.value
    DB_MUONG_DUN_3247 = WardEnum.W_3247.value
    DB_MUONG_BANG_3250 = WardEnum.W_3250.value
    DB_TUAN_GIAO_3253 = WardEnum.W_3253.value
    DB_PHINH_SANG_3259 = WardEnum.W_3259.value
    DB_RANG_DONG_3260 = WardEnum.W_3260.value
    DB_MUN_CHUNG_3262 = WardEnum.W_3262.value
    DB_NA_TONG_3263 = WardEnum.W_3263.value
    DB_TA_MA_3265 = WardEnum.W_3265.value
    DB_MUONG_MUN_3268 = WardEnum.W_3268.value
    DB_PU_XI_3269 = WardEnum.W_3269.value
    DB_PU_NHUNG_3271 = WardEnum.W_3271.value
    DB_QUAI_NUA_3274 = WardEnum.W_3274.value
    DB_MUONG_THIN_3277 = WardEnum.W_3277.value
    DB_TOA_TINH_3280 = WardEnum.W_3280.value
    DB_NA_SAY_3283 = WardEnum.W_3283.value
    DB_MUONG_KHONG_3284 = WardEnum.W_3284.value
    DB_QUAI_CANG_3289 = WardEnum.W_3289.value
    DB_QUAI_TO_3295 = WardEnum.W_3295.value
    DB_CHIENG_SINH_3298 = WardEnum.W_3298.value
    DB_CHIENG_DONG_3299 = WardEnum.W_3299.value
    DB_TENH_PHONG_3304 = WardEnum.W_3304.value
    DB_MUONG_PON_3319 = WardEnum.W_3319.value
    DB_THANH_NUA_3322 = WardEnum.W_3322.value
    DB_HUA_THANH_3323 = WardEnum.W_3323.value
    DB_THANH_LUONG_3328 = WardEnum.W_3328.value
    DB_THANH_HUNG_3331 = WardEnum.W_3331.value
    DB_THANH_XUONG_3334 = WardEnum.W_3334.value
    DB_THANH_CHAN_3337 = WardEnum.W_3337.value
    DB_PA_THOM_3340 = WardEnum.W_3340.value
    DB_THANH_AN_3343 = WardEnum.W_3343.value
    DB_THANH_YEN_3346 = WardEnum.W_3346.value
    DB_NOONG_LUONG_3349 = WardEnum.W_3349.value
    DB_NOONG_HET_3352 = WardEnum.W_3352.value
    DB_SAM_MUN_3355 = WardEnum.W_3355.value
    DB_POM_LOT_3356 = WardEnum.W_3356.value
    DB_NUA_NGAM_3358 = WardEnum.W_3358.value
    DB_HE_MUONG_3359 = WardEnum.W_3359.value
    DB_NA_U_3361 = WardEnum.W_3361.value
    DB_MUONG_NHA_3364 = WardEnum.W_3364.value
    DB_NA_TONG_3365 = WardEnum.W_3365.value
    DB_MUONG_LOI_3367 = WardEnum.W_3367.value
    DB_PHU_LUONG_3368 = WardEnum.W_3368.value
    DB_DIEN_BIEN_DONG_3203 = WardEnum.W_3203.value
    DB_NA_SON_3205 = WardEnum.W_3205.value
    DB_PHI_NHU_3208 = WardEnum.W_3208.value
    DB_CHIENG_SO_3211 = WardEnum.W_3211.value
    DB_MUONG_LUAN_3214 = WardEnum.W_3214.value
    DB_PU_NHI_3370 = WardEnum.W_3370.value
    DB_NONG_U_3371 = WardEnum.W_3371.value
    DB_XA_DUNG_3373 = WardEnum.W_3373.value
    DB_KEO_LOM_3376 = WardEnum.W_3376.value
    DB_LUAN_GIOI_3379 = WardEnum.W_3379.value
    DB_PHINH_GIANG_3382 = WardEnum.W_3382.value
    DB_PU_HONG_3383 = WardEnum.W_3383.value
    DB_TIA_DINH_3384 = WardEnum.W_3384.value
    DB_HANG_LIA_3385 = WardEnum.W_3385.value
    DB_MUONG_ANG_3256 = WardEnum.W_3256.value
    DB_MUONG_DANG_3286 = WardEnum.W_3286.value
    DB_NGOI_CAY_3287 = WardEnum.W_3287.value
    DB_ANG_TO_3292 = WardEnum.W_3292.value
    DB_BUNG_LAO_3301 = WardEnum.W_3301.value
    DB_XUAN_LAO_3302 = WardEnum.W_3302.value
    DB_ANG_NUA_3307 = WardEnum.W_3307.value
    DB_ANG_CANG_3310 = WardEnum.W_3310.value
    DB_NAM_LICH_3312 = WardEnum.W_3312.value
    DB_MUONG_LAN_3313 = WardEnum.W_3313.value
    DB_NAM_TIN_3156 = WardEnum.W_3156.value
    DB_PA_TAN_3165 = WardEnum.W_3165.value
    DB_CHA_CANG_3166 = WardEnum.W_3166.value
    DB_NA_CO_SA_3167 = WardEnum.W_3167.value
    DB_NA_KHOA_3168 = WardEnum.W_3168.value
    DB_NA_HY_3169 = WardEnum.W_3169.value
    DB_NA_BUNG_3170 = WardEnum.W_3170.value
    DB_NAM_NHU_3171 = WardEnum.W_3171.value
    DB_NAM_CHUA_3173 = WardEnum.W_3173.value
    DB_NAM_KHAN_3174 = WardEnum.W_3174.value
    DB_CHA_TO_3175 = WardEnum.W_3175.value
    DB_VANG_DAN_3176 = WardEnum.W_3176.value
    DB_CHA_NUA_3187 = WardEnum.W_3187.value
    DB_PHIN_HO_3198 = WardEnum.W_3198.value
    DB_SI_PA_PHIN_3199 = WardEnum.W_3199.value
    LC_QUYET_THANG_3386 = WardEnum.W_3386.value
    LC_TAN_PHONG_3387 = WardEnum.W_3387.value
    LC_QUYET_TIEN_3388 = WardEnum.W_3388.value
    LC_DOAN_KET_3389 = WardEnum.W_3389.value
    LC_SUNG_PHAI_3403 = WardEnum.W_3403.value
    LC_DONG_PHONG_3408 = WardEnum.W_3408.value
    LC_SAN_THANG_3409 = WardEnum.W_3409.value
    LC_TAM_DUONG_3390 = WardEnum.W_3390.value
    LC_THEN_SIN_3394 = WardEnum.W_3394.value
    LC_TA_LENG_3400 = WardEnum.W_3400.value
    LC_GIANG_MA_3405 = WardEnum.W_3405.value
    LC_HO_THAU_3406 = WardEnum.W_3406.value
    LC_BINH_LU_3412 = WardEnum.W_3412.value
    LC_SON_BINH_3413 = WardEnum.W_3413.value
    LC_NUNG_NANG_3415 = WardEnum.W_3415.value
    LC_BAN_GIANG_3418 = WardEnum.W_3418.value
    LC_BAN_HON_3421 = WardEnum.W_3421.value
    LC_BAN_BO_3424 = WardEnum.W_3424.value
    LC_NA_TAM_3427 = WardEnum.W_3427.value
    LC_KHUN_HA_3430 = WardEnum.W_3430.value
    LC_MUONG_TE_3433 = WardEnum.W_3433.value
    LC_THU_LUM_3436 = WardEnum.W_3436.value
    LC_KA_LANG_3439 = WardEnum.W_3439.value
    LC_TA_BA_3440 = WardEnum.W_3440.value
    LC_PA_U_3442 = WardEnum.W_3442.value
    LC_XA_MUONG_TE_3445 = WardEnum.W_3445.value
    LC_PA_VE_SU_3448 = WardEnum.W_3448.value
    LC_MU_CA_3451 = WardEnum.W_3451.value
    LC_BUM_TO_3454 = WardEnum.W_3454.value
    LC_NAM_KHAO_3457 = WardEnum.W_3457.value
    LC_TA_TONG_3463 = WardEnum.W_3463.value
    LC_BUM_NUA_3466 = WardEnum.W_3466.value
    LC_VANG_SAN_3467 = WardEnum.W_3467.value
    LC_KAN_HO_3469 = WardEnum.W_3469.value
    LC_SIN_HO_3478 = WardEnum.W_3478.value
    LC_CHAN_NUA_3487 = WardEnum.W_3487.value
    LC_PA_TAN_3493 = WardEnum.W_3493.value
    LC_PHIN_HO_3496 = WardEnum.W_3496.value
    LC_HONG_THU_3499 = WardEnum.W_3499.value
    LC_PHANG_SO_LIN_3505 = WardEnum.W_3505.value
    LC_MA_QUAI_3508 = WardEnum.W_3508.value
    LC_LUNG_THANG_3509 = WardEnum.W_3509.value
    LC_TA_PHIN_3511 = WardEnum.W_3511.value
    LC_SA_DE_PHIN_3514 = WardEnum.W_3514.value
    LC_NAM_TAM_3517 = WardEnum.W_3517.value
    LC_TA_NGAO_3520 = WardEnum.W_3520.value
    LC_PU_SAM_CAP_3523 = WardEnum.W_3523.value
    LC_NAM_CHA_3526 = WardEnum.W_3526.value
    LC_PA_KHOA_3527 = WardEnum.W_3527.value
    LC_LANG_MO_3529 = WardEnum.W_3529.value
    LC_NOONG_HEO_3532 = WardEnum.W_3532.value
    LC_NAM_MA_3535 = WardEnum.W