import { aws_backup, aws_dynamodb, aws_events } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface CompliantDynamoDbProps extends aws_dynamodb.TableProps {
    /**
     * Use an existing BackupVault and import it by name.
     *
     * @default - create a new BackupVault
     * @stability stable
     */
    readonly backupVaultName?: string;
    /**
     * Days until the backup is deleted from the vault.
     *
     * @default - 35 days
     * @stability stable
     */
    readonly deleteBackupAfterDays?: number;
    /**
     * AWS Config rules that I want to opt out.
     *
     * @default - table is compliant against all rules
     *
     * List of rules to opt out:
     * 'BACKUP_RECOVERY_POINT_MANUAL_DELETION_DISABLED',
     * 'DYNAMODB_IN_BACKUP_PLAN',
     * 'DYNAMODB_PITR_ENABLED',
     * 'DYNAMODB_AUTOSCALING_ENABLED',
     * 'DYNAMODB_THROUGHPUT_LIMIT_CHECK',
     * 'DYNAMODB_TABLE_ENCRYPTED_KMS',
     * @stability stable
     */
    readonly disabledRules?: string[];
    /**
     * Time to start the backup.
     *
     * @default - 9pm
     * @stability stable
     */
    readonly backupPlanStartTime?: aws_events.Schedule;
}
/**
 * Creates a DynamoDB table that is secured by an AWS backup plan und with point in time recovery enabled by default.
 *
 * @stability stable
 */
export declare class CompliantDynamoDb extends aws_dynamodb.Table {
    /**
     * @stability stable
     */
    readonly backupPlan: aws_backup.BackupPlan;
    /**
     * @stability stable
     */
    readonly backupVault: aws_backup.BackupVault;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: CompliantDynamoDbProps);
}
