"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompliantDynamoDb = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const services_1 = require("./services");
/**
 * Creates a DynamoDB table that is secured by an AWS backup plan und with point in time recovery enabled by default.
 *
 * @stability stable
 */
class CompliantDynamoDb extends aws_cdk_lib_1.aws_dynamodb.Table {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            encryption: services_1.getEncrytion(props),
            pointInTimeRecovery: services_1.getPitr(props),
            billingMode: services_1.getBillingMode(props),
        });
        services_1.createBackupPlan(this, props);
    }
}
exports.CompliantDynamoDb = CompliantDynamoDb;
_a = JSII_RTTI_SYMBOL_1;
CompliantDynamoDb[_a] = { fqn: "cdk-compliant-dynamodb.CompliantDynamoDb", version: "0.0.1" };
//# sourceMappingURL=data:application/json;base64,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