"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTest = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const _1 = require(".");
const disabledRules = [
    // 'BACKUP_RECOVERY_POINT_ENCRYPTED',
    // 'BACKUP_RECOVERY_POINT_MANUAL_DELETION_DISABLED',
    // 'DYNAMODB_IN_BACKUP_PLAN',
    // 'DYNAMODB_PITR_ENABLED',
    // 'DYNAMODB_AUTOSCALING_ENABLED',
    'DYNAMODB_TABLE_ENCRYPTION_ENABLED',
];
const tableProps = {
    partitionKey: {
        name: 'id',
        type: aws_cdk_lib_1.aws_dynamodb.AttributeType.STRING,
    },
    disabledRules: disabledRules,
};
class IntegTest {
    constructor() {
        const app = new aws_cdk_lib_1.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new aws_cdk_lib_1.Stack(app, 'testing-stack', { env });
        new _1.CompliantDynamoDb(stack, 'DynamoDB', tableProps);
        this.stack = [stack];
    }
}
exports.IntegTest = IntegTest;
new IntegTest();
//# sourceMappingURL=data:application/json;base64,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