"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createBackupPlan = exports.getBillingMode = exports.getPitr = exports.getEncrytion = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const KMS_RULE = 'DYNAMODB_TABLE_ENCRYPTED_KMS';
const ENCRYPTION_RULE = 'DYNAMODB_TABLE_ENCRYPTION_ENABLED';
const PITR_RULE = 'DYNAMODB_PITR_ENABLED';
const ASG_RULE = 'DYNAMODB_AUTOSCALING_ENABLED';
const BACKUP_RULE = 'DYNAMODB_IN_BACKUP_PLAN';
const MANUAL_DELETION_RULE = 'BACKUP_RECOVERY_POINT_MANUAL_DELETION_DISABLED';
function getEncrytion(props) {
    var _a, _b, _c;
    if (props.encryption != undefined) {
        return props.encryption;
    }
    if (((_a = props.disabledRules) === null || _a === void 0 ? void 0 : _a.includes(ENCRYPTION_RULE)) && ((_b = props.disabledRules) === null || _b === void 0 ? void 0 : _b.includes(KMS_RULE))) {
        return aws_cdk_lib_1.aws_dynamodb.TableEncryption.DEFAULT;
    }
    if ((_c = props.disabledRules) === null || _c === void 0 ? void 0 : _c.includes(KMS_RULE)) {
        return aws_cdk_lib_1.aws_dynamodb.TableEncryption.AWS_MANAGED;
    }
    return aws_cdk_lib_1.aws_dynamodb.TableEncryption.CUSTOMER_MANAGED;
}
exports.getEncrytion = getEncrytion;
function getPitr(props) {
    var _a;
    if (props.pointInTimeRecovery != undefined) {
        return props.pointInTimeRecovery;
    }
    return !((_a = props.disabledRules) === null || _a === void 0 ? void 0 : _a.includes(PITR_RULE));
}
exports.getPitr = getPitr;
function getBillingMode(props) {
    var _a;
    if (props.billingMode != undefined) {
        return props.billingMode;
    }
    if ((_a = props.disabledRules) === null || _a === void 0 ? void 0 : _a.includes(ASG_RULE)) {
        return aws_cdk_lib_1.aws_dynamodb.BillingMode.PROVISIONED;
    }
    return aws_cdk_lib_1.aws_dynamodb.BillingMode.PAY_PER_REQUEST;
}
exports.getBillingMode = getBillingMode;
function createBackupPlan(table, props) {
    var _a, _b, _c;
    if ((_a = props.disabledRules) === null || _a === void 0 ? void 0 : _a.includes(BACKUP_RULE)) {
        return undefined;
    }
    const backupPlan = new aws_cdk_lib_1.aws_backup.BackupPlan(table, 'DynamoDbBackupPlan', {
        backupVault: createBackupVault(table, props),
        backupPlanRules: [
            new aws_cdk_lib_1.aws_backup.BackupPlanRule({
                ruleName: 'daily-aws_dynamodb-aws_backup',
                scheduleExpression: (_b = props.backupPlanStartTime) !== null && _b !== void 0 ? _b : aws_cdk_lib_1.aws_events.Schedule.cron({
                    hour: '21',
                    minute: '0',
                }),
                deleteAfter: aws_cdk_lib_1.Duration.days((_c = props.deleteBackupAfterDays) !== null && _c !== void 0 ? _c : 35),
            }),
        ],
    });
    backupPlan.addSelection('DynamoDb', {
        resources: [aws_cdk_lib_1.aws_backup.BackupResource.fromArn(table.tableArn)],
    });
    return backupPlan;
}
exports.createBackupPlan = createBackupPlan;
function createBackupVault(table, props) {
    var _a;
    if ((_a = props.disabledRules) === null || _a === void 0 ? void 0 : _a.includes(MANUAL_DELETION_RULE)) {
        const backupVault = new aws_cdk_lib_1.aws_backup.BackupVault(table, 'DynamoDbBackupVault');
        return backupVault;
    }
    if (props.backupVaultName) {
        return aws_cdk_lib_1.aws_backup.BackupVault.fromBackupVaultName(table, 'ImportedBackupVault', props.backupVaultName);
    }
    return new aws_cdk_lib_1.aws_backup.BackupVault(table, 'DynamoDbBackupVault', {
        accessPolicy: new aws_cdk_lib_1.aws_iam.PolicyDocument({
            statements: [
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    sid: 'backup-recovery-point-manual-deletion-disabled',
                    effect: aws_cdk_lib_1.aws_iam.Effect.DENY,
                    principals: [new aws_cdk_lib_1.aws_iam.AnyPrincipal()],
                    actions: [
                        'backup:DeleteRecoveryPoint',
                        'backup:PutBackupVaultAccessPolicy',
                        'backup:UpdateRecoveryPointLifecycle',
                    ],
                    resources: ['*'],
                }),
            ],
        }),
    });
}
//# sourceMappingURL=data:application/json;base64,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