class NaturalRights:
    """
    天赋人权是一种政治哲学概念，它认为每个人生来就拥有某些基本的、不可剥夺的人权。这些人权不仅是社会和政府赋予的，而是来自于人类的本质。天赋人权的特征包括：

    不可剥夺性：天赋人权是每个人天生就拥有的，无论任何情况下都不应该被剥夺或否认。
    普遍性：天赋人权适用于每个人，无论他们的国籍、性别、种族、信仰或社会地位如何。
    平等性：每个人在天赋人权面前都是平等的，没有任何一个人可以剥夺他人的权利或在权利方面拥有特权。
    多元性：天赋人权是多元化的，它们包括政治权利、经济权利、社会权利和文化权利等。
    """
    def __init__(self, indivisibility, universality, equality, diversity):
        self.indivisibility = indivisibility
        self.universality = universality
        self.equality = equality
        self.diversity = diversity
    
    def describe_indivisibility(self):
        return f"Natural rights are indivisible and inalienable, meaning they cannot be taken away or denied under any circumstances."
    
    def describe_universality(self):
        return f"Natural rights apply to every individual, regardless of their nationality, gender, race, belief, or social status."
    
    def describe_equality(self):
        return f"Every person is equal in natural rights, and no one can deprive others of their rights or have privilege in rights."
    
    def describe_diversity(self):
        return f"Natural rights are diverse, including political rights, economic rights, social rights, cultural rights, and so on."
