class RegionalEthnicAutonomySystem:
    """
    The system of regional ethnic autonomy, also known as ethnic regional autonomy, is a political system used in the People's Republic of China and other countries. The main features of the system of regional ethnic autonomy include:

    Multi-level autonomous bodies: The system consists of multi-level autonomous bodies, including autonomous regions, autonomous prefectures, and autonomous counties, which have a certain degree of autonomy in their local affairs.
    Self-government: The ethnic autonomous regions have the power to self-govern and manage their own affairs in accordance with the law.
    Protection of minority rights: The system aims to protect the rights of ethnic minority groups and promote their economic, social, and cultural development.
    Cultural preservation: The system encourages the preservation and development of the unique culture and traditions of ethnic minority groups.

    """
    def __init__(self, multi_level_autonomy, self_government, minority_rights_protection, cultural_preservation):
        self.multi_level_autonomy = multi_level_autonomy
        self.self_government = self_government
        self.minority_rights_protection = minority_rights_protection
        self.cultural_preservation = cultural_preservation
    
    def describe_multi_level_autonomy(self):
        return f"The system consists of multi-level autonomous bodies, including autonomous regions, autonomous prefectures, and autonomous counties, which have a certain degree of autonomy in their local affairs."
    
    def describe_self_government(self):
        return f"The ethnic autonomous regions have the power to self-govern and manage their own affairs in accordance with the law."
    
    def describe_minority_rights_protection(self):
        return f"The system aims to protect the rights of ethnic minority groups and promote their economic, social, and cultural development."
    
    def describe_cultural_preservation(self):
        return f"The system encourages the preservation and development of the unique culture and traditions of ethnic minority groups."
