class SurplusValue:
    """
    Surplus value is a concept in Marxist political economy which refers to the value created by workers in excess of their own labor costs, which is appropriated by the capitalist as profit. The main features of surplus value include:

    - Labor exploitation: The extraction of surplus value occurs because the capitalist pays the worker only a portion of the value of the goods and services they produce, while keeping the remaining value as profit.

    - Social relations: The concept of surplus value emphasizes the social and economic relations between capitalists and workers, and highlights the ways in which the capitalist class exploits the working class.
    
    - Economic crisis: The accumulation of surplus value is often seen as a driving force behind economic crises, as capitalists seek to increase profits by lowering labor costs and thereby reducing the purchasing power of workers.

    - Class struggle: The concept of surplus value is closely linked to the idea of class struggle, as workers seek to increase their share of the value they create through collective bargaining and political action.
    """
    def __init__(self, labor_exploitation, social_relations, economic_crisis, class_struggle):
        self.labor_exploitation = labor_exploitation
        self.social_relations = social_relations
        self.economic_crisis = economic_crisis
        self.class_struggle = class_struggle
    
    def describe_labor_exploitation(self):
        return f"The extraction of surplus value occurs because the capitalist pays the worker only a portion of the value of the goods and services they produce, while keeping the remaining value as profit."
    
    def describe_social_relations(self):
        return f"The concept of surplus value emphasizes the social and economic relations between capitalists and workers."
    
    def describe_economic_crisis(self):
        return f"The accumulation of surplus value is often seen as a driving force behind economic crises."
    
    def describe_class_struggle(self):
        return f"The concept of surplus value is closely linked to the idea of class struggle."
