# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class DatabaseFirewall(pulumi.CustomResource):
    cluster_id: pulumi.Output[str]
    """
    The ID of the target database cluster.
    """
    rules: pulumi.Output[list]
    """
    A rule specifying a resource allowed to access the database cluster. The following arguments must be specified:
    - `type` - (Required) The type of resource that the firewall rule allows to access the database cluster. The possible values are: `droplet`, `k8s`, `ip_addr`, or `tag`.
    - `value` - (Required) The ID of the specific resource, the name of a tag applied to a group of resources, or the IP address that the firewall rule allows to access the database cluster.

      * `created_at` (`str`) - The date and time when the firewall rule was created.
      * `type` (`str`)
      * `uuid` (`str`) - A unique identifier for the firewall rule.
      * `value` (`str`)
    """
    def __init__(__self__, resource_name, opts=None, cluster_id=None, rules=None, __props__=None, __name__=None, __opts__=None):
        """
        Provides a DigitalOcean database firewall resource allowing you to restrict
        connections to your database to trusted sources. You may limit connections to
        specific Droplets, Kubernetes clusters, or IP addresses.

        ## Example Usage

        ### Create a new database firewall allowing multiple IP addresses

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        postgres_example = digitalocean.DatabaseCluster("postgres-example",
            engine="pg",
            version="11",
            size="db-s-1vcpu-1gb",
            region="nyc1",
            node_count=1)
        example_fw = digitalocean.DatabaseFirewall("example-fw",
            cluster_id=postgres_example.id,
            rule=[
                {
                    "type": "ip_addr",
                    "value": "192.168.1.1",
                },
                {
                    "type": "ip_addr",
                    "value": "192.0.2.0",
                },
            ])
        ```

        ### Create a new database firewall allowing a Droplet

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        web = digitalocean.Droplet("web",
            size="s-1vcpu-1gb",
            image="centos-7-x64",
            region="nyc3")
        postgres_example = digitalocean.DatabaseCluster("postgres-example",
            engine="pg",
            version="11",
            size="db-s-1vcpu-1gb",
            region="nyc1",
            node_count=1)
        example_fw = digitalocean.DatabaseFirewall("example-fw",
            cluster_id=postgres_example.id,
            rule=[{
                "type": "droplet",
                "value": web.id,
            }])
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: The ID of the target database cluster.
        :param pulumi.Input[list] rules: A rule specifying a resource allowed to access the database cluster. The following arguments must be specified:
               - `type` - (Required) The type of resource that the firewall rule allows to access the database cluster. The possible values are: `droplet`, `k8s`, `ip_addr`, or `tag`.
               - `value` - (Required) The ID of the specific resource, the name of a tag applied to a group of resources, or the IP address that the firewall rule allows to access the database cluster.

        The **rules** object supports the following:

          * `created_at` (`pulumi.Input[str]`) - The date and time when the firewall rule was created.
          * `type` (`pulumi.Input[str]`)
          * `uuid` (`pulumi.Input[str]`) - A unique identifier for the firewall rule.
          * `value` (`pulumi.Input[str]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if cluster_id is None:
                raise TypeError("Missing required property 'cluster_id'")
            __props__['cluster_id'] = cluster_id
            if rules is None:
                raise TypeError("Missing required property 'rules'")
            __props__['rules'] = rules
        super(DatabaseFirewall, __self__).__init__(
            'digitalocean:index:DatabaseFirewall',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, cluster_id=None, rules=None):
        """
        Get an existing DatabaseFirewall resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: The ID of the target database cluster.
        :param pulumi.Input[list] rules: A rule specifying a resource allowed to access the database cluster. The following arguments must be specified:
               - `type` - (Required) The type of resource that the firewall rule allows to access the database cluster. The possible values are: `droplet`, `k8s`, `ip_addr`, or `tag`.
               - `value` - (Required) The ID of the specific resource, the name of a tag applied to a group of resources, or the IP address that the firewall rule allows to access the database cluster.

        The **rules** object supports the following:

          * `created_at` (`pulumi.Input[str]`) - The date and time when the firewall rule was created.
          * `type` (`pulumi.Input[str]`)
          * `uuid` (`pulumi.Input[str]`) - A unique identifier for the firewall rule.
          * `value` (`pulumi.Input[str]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["cluster_id"] = cluster_id
        __props__["rules"] = rules
        return DatabaseFirewall(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

