import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KmipSecretRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#id KmipSecretRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#namespace KmipSecretRole#namespace}
    */
    readonly namespace?: string;
    /**
    * Grant permission to use the KMIP Activate operation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#operation_activate KmipSecretRole#operation_activate}
    */
    readonly operationActivate?: boolean | cdktf.IResolvable;
    /**
    * Grant permission to use the KMIP Add Attribute operation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#operation_add_attribute KmipSecretRole#operation_add_attribute}
    */
    readonly operationAddAttribute?: boolean | cdktf.IResolvable;
    /**
    * Grant all permissions to this role. May not be specified with any other operation_* params
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#operation_all KmipSecretRole#operation_all}
    */
    readonly operationAll?: boolean | cdktf.IResolvable;
    /**
    * Grant permission to use the KMIP Create operation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#operation_create KmipSecretRole#operation_create}
    */
    readonly operationCreate?: boolean | cdktf.IResolvable;
    /**
    * Grant permission to use the KMIP Destroy operation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#operation_destroy KmipSecretRole#operation_destroy}
    */
    readonly operationDestroy?: boolean | cdktf.IResolvable;
    /**
    * Grant permission to use the KMIP Discover Version operation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#operation_discover_versions KmipSecretRole#operation_discover_versions}
    */
    readonly operationDiscoverVersions?: boolean | cdktf.IResolvable;
    /**
    * Grant permission to use the KMIP Get operation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#operation_get KmipSecretRole#operation_get}
    */
    readonly operationGet?: boolean | cdktf.IResolvable;
    /**
    * Grant permission to use the KMIP Get Attribute List operation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#operation_get_attribute_list KmipSecretRole#operation_get_attribute_list}
    */
    readonly operationGetAttributeList?: boolean | cdktf.IResolvable;
    /**
    * Grant permission to use the KMIP Get Attributes operation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#operation_get_attributes KmipSecretRole#operation_get_attributes}
    */
    readonly operationGetAttributes?: boolean | cdktf.IResolvable;
    /**
    * Grant permission to use the KMIP Locate operation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#operation_locate KmipSecretRole#operation_locate}
    */
    readonly operationLocate?: boolean | cdktf.IResolvable;
    /**
    * Remove all permissions from this role. May not be specified with any other operation_* params
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#operation_none KmipSecretRole#operation_none}
    */
    readonly operationNone?: boolean | cdktf.IResolvable;
    /**
    * Grant permission to use the KMIP Register operation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#operation_register KmipSecretRole#operation_register}
    */
    readonly operationRegister?: boolean | cdktf.IResolvable;
    /**
    * Grant permission to use the KMIP Rekey operation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#operation_rekey KmipSecretRole#operation_rekey}
    */
    readonly operationRekey?: boolean | cdktf.IResolvable;
    /**
    * Grant permission to use the KMIP Revoke operation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#operation_revoke KmipSecretRole#operation_revoke}
    */
    readonly operationRevoke?: boolean | cdktf.IResolvable;
    /**
    * Path where KMIP backend is mounted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#path KmipSecretRole#path}
    */
    readonly path: string;
    /**
    * Name of the role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#role KmipSecretRole#role}
    */
    readonly role: string;
    /**
    * Name of the scope
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#scope KmipSecretRole#scope}
    */
    readonly scope: string;
    /**
    * Client certificate key bits, valid values depend on key type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#tls_client_key_bits KmipSecretRole#tls_client_key_bits}
    */
    readonly tlsClientKeyBits?: number;
    /**
    * Client certificate key type, rsa or ec
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#tls_client_key_type KmipSecretRole#tls_client_key_type}
    */
    readonly tlsClientKeyType?: string;
    /**
    * Client certificate TTL in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role#tls_client_ttl KmipSecretRole#tls_client_ttl}
    */
    readonly tlsClientTtl?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role vault_kmip_secret_role}
*/
export declare class KmipSecretRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_kmip_secret_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/kmip_secret_role vault_kmip_secret_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KmipSecretRoleConfig
    */
    constructor(scope: Construct, id: string, config: KmipSecretRoleConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _operationActivate?;
    get operationActivate(): boolean | cdktf.IResolvable;
    set operationActivate(value: boolean | cdktf.IResolvable);
    resetOperationActivate(): void;
    get operationActivateInput(): boolean | cdktf.IResolvable | undefined;
    private _operationAddAttribute?;
    get operationAddAttribute(): boolean | cdktf.IResolvable;
    set operationAddAttribute(value: boolean | cdktf.IResolvable);
    resetOperationAddAttribute(): void;
    get operationAddAttributeInput(): boolean | cdktf.IResolvable | undefined;
    private _operationAll?;
    get operationAll(): boolean | cdktf.IResolvable;
    set operationAll(value: boolean | cdktf.IResolvable);
    resetOperationAll(): void;
    get operationAllInput(): boolean | cdktf.IResolvable | undefined;
    private _operationCreate?;
    get operationCreate(): boolean | cdktf.IResolvable;
    set operationCreate(value: boolean | cdktf.IResolvable);
    resetOperationCreate(): void;
    get operationCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _operationDestroy?;
    get operationDestroy(): boolean | cdktf.IResolvable;
    set operationDestroy(value: boolean | cdktf.IResolvable);
    resetOperationDestroy(): void;
    get operationDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _operationDiscoverVersions?;
    get operationDiscoverVersions(): boolean | cdktf.IResolvable;
    set operationDiscoverVersions(value: boolean | cdktf.IResolvable);
    resetOperationDiscoverVersions(): void;
    get operationDiscoverVersionsInput(): boolean | cdktf.IResolvable | undefined;
    private _operationGet?;
    get operationGet(): boolean | cdktf.IResolvable;
    set operationGet(value: boolean | cdktf.IResolvable);
    resetOperationGet(): void;
    get operationGetInput(): boolean | cdktf.IResolvable | undefined;
    private _operationGetAttributeList?;
    get operationGetAttributeList(): boolean | cdktf.IResolvable;
    set operationGetAttributeList(value: boolean | cdktf.IResolvable);
    resetOperationGetAttributeList(): void;
    get operationGetAttributeListInput(): boolean | cdktf.IResolvable | undefined;
    private _operationGetAttributes?;
    get operationGetAttributes(): boolean | cdktf.IResolvable;
    set operationGetAttributes(value: boolean | cdktf.IResolvable);
    resetOperationGetAttributes(): void;
    get operationGetAttributesInput(): boolean | cdktf.IResolvable | undefined;
    private _operationLocate?;
    get operationLocate(): boolean | cdktf.IResolvable;
    set operationLocate(value: boolean | cdktf.IResolvable);
    resetOperationLocate(): void;
    get operationLocateInput(): boolean | cdktf.IResolvable | undefined;
    private _operationNone?;
    get operationNone(): boolean | cdktf.IResolvable;
    set operationNone(value: boolean | cdktf.IResolvable);
    resetOperationNone(): void;
    get operationNoneInput(): boolean | cdktf.IResolvable | undefined;
    private _operationRegister?;
    get operationRegister(): boolean | cdktf.IResolvable;
    set operationRegister(value: boolean | cdktf.IResolvable);
    resetOperationRegister(): void;
    get operationRegisterInput(): boolean | cdktf.IResolvable | undefined;
    private _operationRekey?;
    get operationRekey(): boolean | cdktf.IResolvable;
    set operationRekey(value: boolean | cdktf.IResolvable);
    resetOperationRekey(): void;
    get operationRekeyInput(): boolean | cdktf.IResolvable | undefined;
    private _operationRevoke?;
    get operationRevoke(): boolean | cdktf.IResolvable;
    set operationRevoke(value: boolean | cdktf.IResolvable);
    resetOperationRevoke(): void;
    get operationRevokeInput(): boolean | cdktf.IResolvable | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    private _tlsClientKeyBits?;
    get tlsClientKeyBits(): number;
    set tlsClientKeyBits(value: number);
    resetTlsClientKeyBits(): void;
    get tlsClientKeyBitsInput(): number | undefined;
    private _tlsClientKeyType?;
    get tlsClientKeyType(): string;
    set tlsClientKeyType(value: string);
    resetTlsClientKeyType(): void;
    get tlsClientKeyTypeInput(): string | undefined;
    private _tlsClientTtl?;
    get tlsClientTtl(): number;
    set tlsClientTtl(value: number);
    resetTlsClientTtl(): void;
    get tlsClientTtlInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
