import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RabbitmqSecretBackendConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the RabbitMQ connection URI.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend#connection_uri RabbitmqSecretBackend#connection_uri}
    */
    readonly connectionUri: string;
    /**
    * Default lease duration for secrets in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend#default_lease_ttl_seconds RabbitmqSecretBackend#default_lease_ttl_seconds}
    */
    readonly defaultLeaseTtlSeconds?: number;
    /**
    * Human-friendly description of the mount for the backend.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend#description RabbitmqSecretBackend#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend#id RabbitmqSecretBackend#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Maximum possible lease duration for secrets in seconds
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend#max_lease_ttl_seconds RabbitmqSecretBackend#max_lease_ttl_seconds}
    */
    readonly maxLeaseTtlSeconds?: number;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend#namespace RabbitmqSecretBackend#namespace}
    */
    readonly namespace?: string;
    /**
    * Specifies the RabbitMQ management administrator password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend#password RabbitmqSecretBackend#password}
    */
    readonly password: string;
    /**
    * Specifies a password policy to use when creating dynamic credentials. Defaults to generating an alphanumeric password if not set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend#password_policy RabbitmqSecretBackend#password_policy}
    */
    readonly passwordPolicy?: string;
    /**
    * The path of the RabbitMQ Secret Backend where the connection should be configured
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend#path RabbitmqSecretBackend#path}
    */
    readonly path?: string;
    /**
    * Specifies the RabbitMQ management administrator username
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend#username RabbitmqSecretBackend#username}
    */
    readonly username: string;
    /**
    * Template describing how dynamic usernames are generated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend#username_template RabbitmqSecretBackend#username_template}
    */
    readonly usernameTemplate?: string;
    /**
    * Specifies whether to verify connection URI, username, and password.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend#verify_connection RabbitmqSecretBackend#verify_connection}
    */
    readonly verifyConnection?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend vault_rabbitmq_secret_backend}
*/
export declare class RabbitmqSecretBackend extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_rabbitmq_secret_backend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/rabbitmq_secret_backend vault_rabbitmq_secret_backend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RabbitmqSecretBackendConfig
    */
    constructor(scope: Construct, id: string, config: RabbitmqSecretBackendConfig);
    private _connectionUri?;
    get connectionUri(): string;
    set connectionUri(value: string);
    get connectionUriInput(): string | undefined;
    private _defaultLeaseTtlSeconds?;
    get defaultLeaseTtlSeconds(): number;
    set defaultLeaseTtlSeconds(value: number);
    resetDefaultLeaseTtlSeconds(): void;
    get defaultLeaseTtlSecondsInput(): number | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxLeaseTtlSeconds?;
    get maxLeaseTtlSeconds(): number;
    set maxLeaseTtlSeconds(value: number);
    resetMaxLeaseTtlSeconds(): void;
    get maxLeaseTtlSecondsInput(): number | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _passwordPolicy?;
    get passwordPolicy(): string;
    set passwordPolicy(value: string);
    resetPasswordPolicy(): void;
    get passwordPolicyInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    private _usernameTemplate?;
    get usernameTemplate(): string;
    set usernameTemplate(value: string);
    resetUsernameTemplate(): void;
    get usernameTemplateInput(): string | undefined;
    private _verifyConnection?;
    get verifyConnection(): boolean | cdktf.IResolvable;
    set verifyConnection(value: boolean | cdktf.IResolvable);
    resetVerifyConnection(): void;
    get verifyConnectionInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
