"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TokenAuthBackendRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role vault_token_auth_backend_role}
*/
class TokenAuthBackendRole extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/token_auth_backend_role vault_token_auth_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TokenAuthBackendRoleConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_token_auth_backend_role',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.8.2',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._allowedEntityAliases = config.allowedEntityAliases;
        this._allowedPolicies = config.allowedPolicies;
        this._allowedPoliciesGlob = config.allowedPoliciesGlob;
        this._disallowedPolicies = config.disallowedPolicies;
        this._disallowedPoliciesGlob = config.disallowedPoliciesGlob;
        this._id = config.id;
        this._namespace = config.namespace;
        this._orphan = config.orphan;
        this._pathSuffix = config.pathSuffix;
        this._renewable = config.renewable;
        this._roleName = config.roleName;
        this._tokenBoundCidrs = config.tokenBoundCidrs;
        this._tokenExplicitMaxTtl = config.tokenExplicitMaxTtl;
        this._tokenMaxTtl = config.tokenMaxTtl;
        this._tokenNoDefaultPolicy = config.tokenNoDefaultPolicy;
        this._tokenNumUses = config.tokenNumUses;
        this._tokenPeriod = config.tokenPeriod;
        this._tokenPolicies = config.tokenPolicies;
        this._tokenTtl = config.tokenTtl;
        this._tokenType = config.tokenType;
    }
    get allowedEntityAliases() {
        return cdktf.Fn.tolist(this.getListAttribute('allowed_entity_aliases'));
    }
    set allowedEntityAliases(value) {
        this._allowedEntityAliases = value;
    }
    resetAllowedEntityAliases() {
        this._allowedEntityAliases = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedEntityAliasesInput() {
        return this._allowedEntityAliases;
    }
    get allowedPolicies() {
        return cdktf.Fn.tolist(this.getListAttribute('allowed_policies'));
    }
    set allowedPolicies(value) {
        this._allowedPolicies = value;
    }
    resetAllowedPolicies() {
        this._allowedPolicies = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedPoliciesInput() {
        return this._allowedPolicies;
    }
    get allowedPoliciesGlob() {
        return cdktf.Fn.tolist(this.getListAttribute('allowed_policies_glob'));
    }
    set allowedPoliciesGlob(value) {
        this._allowedPoliciesGlob = value;
    }
    resetAllowedPoliciesGlob() {
        this._allowedPoliciesGlob = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedPoliciesGlobInput() {
        return this._allowedPoliciesGlob;
    }
    get disallowedPolicies() {
        return cdktf.Fn.tolist(this.getListAttribute('disallowed_policies'));
    }
    set disallowedPolicies(value) {
        this._disallowedPolicies = value;
    }
    resetDisallowedPolicies() {
        this._disallowedPolicies = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disallowedPoliciesInput() {
        return this._disallowedPolicies;
    }
    get disallowedPoliciesGlob() {
        return cdktf.Fn.tolist(this.getListAttribute('disallowed_policies_glob'));
    }
    set disallowedPoliciesGlob(value) {
        this._disallowedPoliciesGlob = value;
    }
    resetDisallowedPoliciesGlob() {
        this._disallowedPoliciesGlob = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disallowedPoliciesGlobInput() {
        return this._disallowedPoliciesGlob;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get orphan() {
        return this.getBooleanAttribute('orphan');
    }
    set orphan(value) {
        this._orphan = value;
    }
    resetOrphan() {
        this._orphan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get orphanInput() {
        return this._orphan;
    }
    get pathSuffix() {
        return this.getStringAttribute('path_suffix');
    }
    set pathSuffix(value) {
        this._pathSuffix = value;
    }
    resetPathSuffix() {
        this._pathSuffix = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pathSuffixInput() {
        return this._pathSuffix;
    }
    get renewable() {
        return this.getBooleanAttribute('renewable');
    }
    set renewable(value) {
        this._renewable = value;
    }
    resetRenewable() {
        this._renewable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get renewableInput() {
        return this._renewable;
    }
    get roleName() {
        return this.getStringAttribute('role_name');
    }
    set roleName(value) {
        this._roleName = value;
    }
    // Temporarily expose input value. Use with caution.
    get roleNameInput() {
        return this._roleName;
    }
    get tokenBoundCidrs() {
        return cdktf.Fn.tolist(this.getListAttribute('token_bound_cidrs'));
    }
    set tokenBoundCidrs(value) {
        this._tokenBoundCidrs = value;
    }
    resetTokenBoundCidrs() {
        this._tokenBoundCidrs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenBoundCidrsInput() {
        return this._tokenBoundCidrs;
    }
    get tokenExplicitMaxTtl() {
        return this.getNumberAttribute('token_explicit_max_ttl');
    }
    set tokenExplicitMaxTtl(value) {
        this._tokenExplicitMaxTtl = value;
    }
    resetTokenExplicitMaxTtl() {
        this._tokenExplicitMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenExplicitMaxTtlInput() {
        return this._tokenExplicitMaxTtl;
    }
    get tokenMaxTtl() {
        return this.getNumberAttribute('token_max_ttl');
    }
    set tokenMaxTtl(value) {
        this._tokenMaxTtl = value;
    }
    resetTokenMaxTtl() {
        this._tokenMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenMaxTtlInput() {
        return this._tokenMaxTtl;
    }
    get tokenNoDefaultPolicy() {
        return this.getBooleanAttribute('token_no_default_policy');
    }
    set tokenNoDefaultPolicy(value) {
        this._tokenNoDefaultPolicy = value;
    }
    resetTokenNoDefaultPolicy() {
        this._tokenNoDefaultPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNoDefaultPolicyInput() {
        return this._tokenNoDefaultPolicy;
    }
    get tokenNumUses() {
        return this.getNumberAttribute('token_num_uses');
    }
    set tokenNumUses(value) {
        this._tokenNumUses = value;
    }
    resetTokenNumUses() {
        this._tokenNumUses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNumUsesInput() {
        return this._tokenNumUses;
    }
    get tokenPeriod() {
        return this.getNumberAttribute('token_period');
    }
    set tokenPeriod(value) {
        this._tokenPeriod = value;
    }
    resetTokenPeriod() {
        this._tokenPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPeriodInput() {
        return this._tokenPeriod;
    }
    get tokenPolicies() {
        return cdktf.Fn.tolist(this.getListAttribute('token_policies'));
    }
    set tokenPolicies(value) {
        this._tokenPolicies = value;
    }
    resetTokenPolicies() {
        this._tokenPolicies = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPoliciesInput() {
        return this._tokenPolicies;
    }
    get tokenTtl() {
        return this.getNumberAttribute('token_ttl');
    }
    set tokenTtl(value) {
        this._tokenTtl = value;
    }
    resetTokenTtl() {
        this._tokenTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTtlInput() {
        return this._tokenTtl;
    }
    get tokenType() {
        return this.getStringAttribute('token_type');
    }
    set tokenType(value) {
        this._tokenType = value;
    }
    resetTokenType() {
        this._tokenType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTypeInput() {
        return this._tokenType;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allowed_entity_aliases: cdktf.listMapper(cdktf.stringToTerraform, false)(this._allowedEntityAliases),
            allowed_policies: cdktf.listMapper(cdktf.stringToTerraform, false)(this._allowedPolicies),
            allowed_policies_glob: cdktf.listMapper(cdktf.stringToTerraform, false)(this._allowedPoliciesGlob),
            disallowed_policies: cdktf.listMapper(cdktf.stringToTerraform, false)(this._disallowedPolicies),
            disallowed_policies_glob: cdktf.listMapper(cdktf.stringToTerraform, false)(this._disallowedPoliciesGlob),
            id: cdktf.stringToTerraform(this._id),
            namespace: cdktf.stringToTerraform(this._namespace),
            orphan: cdktf.booleanToTerraform(this._orphan),
            path_suffix: cdktf.stringToTerraform(this._pathSuffix),
            renewable: cdktf.booleanToTerraform(this._renewable),
            role_name: cdktf.stringToTerraform(this._roleName),
            token_bound_cidrs: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tokenBoundCidrs),
            token_explicit_max_ttl: cdktf.numberToTerraform(this._tokenExplicitMaxTtl),
            token_max_ttl: cdktf.numberToTerraform(this._tokenMaxTtl),
            token_no_default_policy: cdktf.booleanToTerraform(this._tokenNoDefaultPolicy),
            token_num_uses: cdktf.numberToTerraform(this._tokenNumUses),
            token_period: cdktf.numberToTerraform(this._tokenPeriod),
            token_policies: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tokenPolicies),
            token_ttl: cdktf.numberToTerraform(this._tokenTtl),
            token_type: cdktf.stringToTerraform(this._tokenType),
        };
    }
}
exports.TokenAuthBackendRole = TokenAuthBackendRole;
_a = JSII_RTTI_SYMBOL_1;
TokenAuthBackendRole[_a] = { fqn: "@cdktf/provider-vault.TokenAuthBackendRole", version: "2.0.63" };
// =================
// STATIC PROPERTIES
// =================
TokenAuthBackendRole.tfResourceType = "vault_token_auth_backend_role";
//# sourceMappingURL=data:application/json;base64,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