from os import path, makedirs
import typer

from .initialise import CreateDataFactoryObjects

app = typer.Typer(name="ingeniiadfg")

@app.callback()
def callback():
    """
    Ingenii Azure Data Factory Generator
    """

@app.command()
def generate(
    configs_folder: str,
    target_folder: str = typer.Option(
        ".",
        help="The root path to write the object .JSON files. Defaults to the folder the command is run in",
    ),
    overwrite: bool = typer.Option(
        False,
        help="Overwrites objects completely, ignoring what's been set so far",
    ),
    remove_not_generated: bool = typer.Option(
        False,
        help="Delete any other objects not generated by this command",
    )
        ):
    """
    Generate Data Factory objects from files in the CONFIGS_FOLDER
    """

    if not path.exists(configs_folder):
        raise Exception(
            f"Provided config files folder `{configs_folder}`"
            " does not exist!")
    if target_folder != "." and not path.exists(target_folder):
        makedirs(target_folder)

    initialisation_obj = CreateDataFactoryObjects(
        configs_folder, target_folder,
        overwrite=overwrite,
        remove_not_generated=remove_not_generated
    )
    initialisation_obj.create_all()
