# Contributing to Oríon
Hi there 👋. Thank you for considering contributing to Oríon 🎉. We're excited to have you here!

We present the guidelines for contributing to the project. They are not hard rules, use your best judgment, and feel free to propose changes to this document in a pull request. If you havn't already, it's a good idea to quickly pass through our [code of conduct](https://github.com/Epistimio/orion/blob/develop/CODE_OF_CONDUCT.md) to ensure everyone has a good time.

## Where do I go from here?
If you have a question, found a bug or have a feature request, you're welcome to open a new issue at https://github.com/Epistimio/orion/issues. It's generally best if you get confirmation of your bug or approval for your feature request before starting to code.

Depending on what you want to do, we're suggesting you read the respective guidelines:
- [Asking a question](###how-to-ask-a-question)
- [Reporting a bug](###how-to-report-a-bug)
- [Proposing enhancements](###how-to-propose-enhancements)
- [Submitting changes](###how-to-submit-changes)

In some cases, you might want to add a new algorithm for Oríon, make sure to check out the [plugin documentation](https://orion.readthedocs.io/en/latest/plugins/base.html).

### How to ask a question
Asking a question is also a contribution to the project! We'll be happy to help you if you have any question. Before opening a new issue, make sure to do a quick search. It's possible your question has already been answered! Otherwise, go ahead. We're looking forward to help you.

### How to report a bug
You found a bug? Great! Before submitting, make sure you're experiencing the bug on the latest version of Oríon and that it's not already opened in our issue tracker.

Please use the [bug report template](https://github.com/Epistimio/orion/issues/new/choose) to open a new bug; make sure to choose a clear and descriptive title for your issue.

### How to propose enhancements
We're thrilled to hear you found a way to make Oríon better through minor improvements to completely new features!
Before creating enhancement suggestions, please check that your idea is not already present in the list of issues. You might find that you don't need to create one and can just join in the discussion directly and give your opinion!

Please use the [feature request template](https://github.com/Epistimio/orion/issues/new/choose) to propose changes; make sure to choose a clear and descriptive title for your issue.

### How to submit changes
We're grateful you're considering making changes to Oríon!

To get started, you need to first fork the repository and then create a new branch on your fork where you'll do your changes.

Once you implemented the changes, make sure to [rebase](https://www.atlassian.com/git/tutorials/rewriting-history/git-rebase) your branch on the latest Oríon's *develop* branch and finally submit a [pull request](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/about-pull-requests).
All changes to Oríon are done through PRs, where they will be peer-reviewed and checked against our continuous integration system to ensure the quality of the code base.

During this process keep in mind to:
- Set a descriptive and short branch name
- Create a descriptive and clear title for the PR
- Motivate the *why* and *how* of the PR (get inspiration from current or past PRs!)
- Write [good commits](https://chris.beams.io/posts/git-commit/)
- Include tests for new features or bug fixes
- Update the source code documentation (docstring) and, if applicable, the [general documentation](https://orion.readthedocs.io/en/latest/index.html)

Next, you need to get familiar with the developer documentation. You will find the instructions to set up your development environment, including how to use the test suite and verify you changes will pass the CI as well as our style guides for source code and documentation.

-> https://orion.readthedocs.io/en/latest/developer/overview.html

#### Your first contribution
If you are not sure about what to work on first, we suggest you take a look on the [help wanted](https://github.com/Epistimio/orion/labels/help%20wanted) and [good first issues](https://github.com/Epistimio/orion/labels/good%20first%20issue) opened. They are great places to start!

---
Thank you for contributing! We really appreciate it!
