import pypega.environment
import json

def register_new(system_name:str, environment_url:str, production_level:int=0):
    return PegaDMCandidate(system_name=system_name, environment_url=environment_url, production_level=production_level)

class PegaDMCandidate(pypega.environment.PegaEnvironment):
    ## Candidate - Application endpoints
    API_ENDPOINT_CANDIDATE_GET_RULESET = "/api/cicdext/v1/ruleset/{ruleset_name}/{ruleset_version}"
    API_ENDPOINT_CANDIDATE_GET_APPLICATION = "/api/cicdext/v1/application/{appName}/{appVersion}"
    API_ENDPOINT_CANDIDATE_CREATE_RULESET = "/api/cicdext/v1/ruleset/{ruleset_name}/{ruleset_version}"
    API_ENDPOINT_CANDIDATE_GET_ACCESSGORUPS = "/api/cicdext/v1/accessgroups"
    
    def __init__(self, system_name, environment_url, production_level):
        pypega.pypega.environment.PegaEnvironment.__init__(self, system_namef, environment_url, production_level)

    def get_application(self, application_name: str, application_version: str):
        response = self.api_request_get(
            self.API_ENDPOINT_CANDIDATE_GET_APPLICATION.format(
                appName=application_name, appVersion=application_version
            )
        )
        if response.ok:
            return json.loads(response.content)
        else:
            return None

    def get_ruleset(self, ruleset_name: str, ruleset_version: str):
        response = self.api_request_get(
            self.API_ENDPOINT_CANDIDATE_GET_RULESET.format(
                ruleset_name=ruleset_name, ruleset_version=ruleset_version
            )
        )
        if response.ok:
            return json.loads(response.content)
        else:
            return None

    def create_ruleset(self, ruleset_name: str, ruleset_version: str):
        response = self.api_request_post(
            self.API_ENDPOINT_CANDIDATE_CREATE_RULESET.format(
                ruleset_name=ruleset_name, ruleset_version=ruleset_version
            ),
            "",
        )
        return response.ok

    def increase_ruleset_patch_version(self, ruleset_name: str):
        response = self.api_request_get(self.API_ENDPOINT_CANDIDATE_CREATE_RULESET)
        return response.ok

    def increase_ruleset_minor_version(self, ruleset_name: str):
        response = self.api_request_get(self.API_ENDPOINT_CANDIDATE_CREATE_RULESET)
        return response.ok
