"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Database = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_glue_1 = require("aws-cdk-lib/aws-glue");
/**
 * A Glue database.
 */
class Database extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.databaseName ??
                aws_cdk_lib_1.Lazy.string({
                    produce: () => aws_cdk_lib_1.Names.uniqueResourceName(this, {}).toLowerCase(),
                }),
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_glue_alpha_DatabaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Database);
            }
            throw error;
        }
        let databaseInput = {
            name: this.physicalName,
        };
        if (props.locationUri !== undefined) {
            validateLocationUri(props.locationUri);
            this.locationUri = props.locationUri;
            databaseInput = {
                locationUri: this.locationUri,
                ...databaseInput,
            };
        }
        this.catalogId = aws_cdk_lib_1.Stack.of(this).account;
        const resource = new aws_glue_1.CfnDatabase(this, 'Resource', {
            catalogId: this.catalogId,
            databaseInput,
        });
        // see https://docs.aws.amazon.com/glue/latest/dg/glue-specifying-resource-arns.html#data-catalog-resource-arns
        this.databaseName = this.getResourceNameAttribute(resource.ref);
        this.databaseArn = this.stack.formatArn({
            service: 'glue',
            resource: 'database',
            resourceName: this.databaseName,
        });
        // catalogId is implicitly the accountId, which is why we don't pass the catalogId here
        this.catalogArn = aws_cdk_lib_1.Stack.of(this).formatArn({
            service: 'glue',
            resource: 'catalog',
        });
    }
    static fromDatabaseArn(scope, id, databaseArn) {
        const stack = aws_cdk_lib_1.Stack.of(scope);
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.databaseArn = databaseArn;
                this.databaseName = stack.splitArn(databaseArn, aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
                this.catalogArn = stack.formatArn({ service: 'glue', resource: 'catalog' });
                this.catalogId = stack.account;
            }
        }
        return new Import(scope, id);
    }
}
exports.Database = Database;
_a = JSII_RTTI_SYMBOL_1;
Database[_a] = { fqn: "@aws-cdk/aws-glue-alpha.Database", version: "2.61.0-alpha.0" };
function validateLocationUri(locationUri) {
    if (locationUri.length < 1 || locationUri.length > 1024) {
        throw new Error(`locationUri length must be (inclusively) between 1 and 1024, but was ${locationUri.length}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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