# **Google login with Selenium**

## Overview
This is a small package to log in to Google account with Selenium. After signin,
Chrome profile of that user will be create and stored. With Chrome profile you can do so many automatic things
with it.

Always active extension is installed by default. 
To store the profile with minimum size on disk, WorkerService cache, OptimizationGuide and cache is cleared when quitting driver.

>This has been developed for testing purposes only.
> Any action you take using this script is strictly at your own risk. 
> I will not be liable for any losses or damages you face using this script.

## Requirement
Must have Python <= 3.9 and Google Chrome installed.

## Usage
```pycon
pip install login_gmail_selenium
```
And then on example.py
```pycon
from login_gmail_selenium.util.profile import ChromeProfile

profile = ChromeProfile(email, password, backup_email)
# To allow downloads add insecure=True to ChromeProfile
# To handle false email with custom functions, use param false_email_callback
driver = profile.retrieve_driver()
profile.start()
# Do whatever with driver afterward
driver.get('https://www.google.com/')
driver.quit()
...
```
1. Add folder extension/ if you want custom extensions for Chrome (.crx or .zip)
2. The temp folder's content will be generated by the library.
Your folder should look like this
```cvs
/temp
    /profiles
        /profile1
        /profile2
/extension
    /custom_extension
        extension1.zip
        extension2.crx
example.py
```

## License
Copyright © 2022 [MoliGroup](https://moligroup.co/), [MIT license](./LICENSE). 
For an improvement or a bug please feel free to open a PR

For work information please contact ngminhhoang1412@gmail.com or 
[LinkedIn](https://www.linkedin.com/in/ho%C3%A0ng-nguy%E1%BB%85n-1b13481b7/).
