from typing import Any

from pony.orm import core as core
from pony.orm import dbapiprovider as dbapiprovider
from pony.orm import dbschema as dbschema
from pony.orm.core import log_orm as log_orm
from pony.orm.dbapiprovider import DBAPIProvider as DBAPIProvider
from pony.orm.dbapiprovider import Pool as Pool
from pony.orm.dbapiprovider import wrap_dbapi_exceptions as wrap_dbapi_exceptions
from pony.orm.ormtypes import Json as Json
from pony.orm.ormtypes import TrackedArray as TrackedArray
from pony.orm.sqlbuilding import SQLBuilder as SQLBuilder
from pony.orm.sqlbuilding import Value as Value
from pony.orm.sqlbuilding import join as join
from pony.orm.sqlbuilding import make_unary_func as make_unary_func
from pony.orm.sqltranslation import SQLTranslator as SQLTranslator
from pony.orm.sqltranslation import StringExprMonad as StringExprMonad
from pony.py23compat import buffer as buffer
from pony.py23compat import int_types as int_types
from pony.utils import absolutize_path as absolutize_path
from pony.utils import cut_traceback_depth as cut_traceback_depth
from pony.utils import datetime2timestamp as datetime2timestamp
from pony.utils import localbase as localbase
from pony.utils import reraise as reraise
from pony.utils import throw as throw
from pony.utils import timestamp2datetime as timestamp2datetime

class SqliteExtensionUnavailable(Exception): ...

NoneType: Any

class SQLiteForeignKey(dbschema.ForeignKey):
    def get_create_command(foreign_key) -> None: ...

class SQLiteSchema(dbschema.DBSchema):
    dialect: str
    named_foreign_keys: bool
    fk_class: Any

def make_overriden_string_func(sqlop: Any) -> Any: ...

class SQLiteTranslator(SQLTranslator):
    dialect: str
    sqlite_version: Any
    row_value_syntax: bool
    rowid_support: bool
    StringMixin_UPPER: Any
    StringMixin_LOWER: Any

class SQLiteValue(Value): ...

class SQLiteBuilder(SQLBuilder):
    dialect: str
    least_func_name: str
    greatest_func_name: str
    value_class: Any
    def __init__(builder, provider: Any, ast: Any) -> None: ...
    def SELECT_FOR_UPDATE(
        builder, nowait: Any, skip_locked: Any, *sections: Any
    ) -> Any: ...
    def INSERT(
        builder, table_name: Any, columns: Any, values: Any, returning: Any | None = ...
    ) -> Any: ...
    def STRING_SLICE(builder, expr: Any, start: Any, stop: Any) -> Any: ...
    def IN(builder, expr1: Any, x: Any) -> Any: ...
    def NOT_IN(builder, expr1: Any, x: Any) -> Any: ...
    def TODAY(builder) -> Any: ...
    def NOW(builder) -> Any: ...
    def YEAR(builder, expr: Any) -> Any: ...
    def MONTH(builder, expr: Any) -> Any: ...
    def DAY(builder, expr: Any) -> Any: ...
    def HOUR(builder, expr: Any) -> Any: ...
    def MINUTE(builder, expr: Any) -> Any: ...
    def SECOND(builder, expr: Any) -> Any: ...
    def datetime_add(builder, funcname: Any, expr: Any, td: Any) -> Any: ...
    def DATE_ADD(builder, expr: Any, delta: Any) -> Any: ...
    def DATE_SUB(builder, expr: Any, delta: Any) -> Any: ...
    def DATE_DIFF(builder, expr1: Any, expr2: Any) -> Any: ...
    def DATETIME_ADD(builder, expr: Any, delta: Any) -> Any: ...
    def DATETIME_SUB(builder, expr: Any, delta: Any) -> Any: ...
    def DATETIME_DIFF(builder, expr1: Any, expr2: Any) -> Any: ...
    def RANDOM(builder) -> Any: ...
    PY_UPPER: Any
    PY_LOWER: Any
    def FLOAT_EQ(builder, a: Any, b: Any) -> Any: ...
    def FLOAT_NE(builder, a: Any, b: Any) -> Any: ...
    def JSON_QUERY(builder, expr: Any, path: Any) -> Any: ...
    json_value_type_mapping: Any
    def JSON_VALUE(builder, expr: Any, path: Any, type: Any) -> Any: ...
    def JSON_NONZERO(builder, expr: Any) -> Any: ...
    def JSON_ARRAY_LENGTH(builder, value: Any) -> Any: ...
    def JSON_CONTAINS(builder, expr: Any, path: Any, key: Any) -> Any: ...
    def ARRAY_INDEX(builder, col: Any, index: Any) -> Any: ...
    def ARRAY_CONTAINS(builder, key: Any, not_in: Any, col: Any) -> Any: ...
    def ARRAY_SUBSET(builder, array1: Any, not_in: Any, array2: Any) -> Any: ...
    def ARRAY_LENGTH(builder, array: Any) -> Any: ...
    def ARRAY_SLICE(builder, array: Any, start: Any, stop: Any) -> Any: ...
    def MAKE_ARRAY(builder, *items: Any) -> Any: ...

class SQLiteIntConverter(dbapiprovider.IntConverter):
    def sql_type(converter) -> Any: ...

class SQLiteDecimalConverter(dbapiprovider.DecimalConverter):
    inf: Any
    neg_inf: Any
    NaN: Any
    def sql2py(converter, val: Any) -> Any: ...
    def py2sql(converter, val: Any) -> Any: ...

class SQLiteDateConverter(dbapiprovider.DateConverter):
    def sql2py(converter, val: Any) -> Any: ...
    def py2sql(converter, val: Any) -> Any: ...

class SQLiteTimeConverter(dbapiprovider.TimeConverter):
    def sql2py(converter, val: Any) -> Any: ...
    def py2sql(converter, val: Any) -> Any: ...

class SQLiteTimedeltaConverter(dbapiprovider.TimedeltaConverter):
    def sql2py(converter, val: Any) -> Any: ...
    def py2sql(converter, val: Any) -> Any: ...

class SQLiteDatetimeConverter(dbapiprovider.DatetimeConverter):
    def sql2py(converter, val: Any) -> Any: ...
    def py2sql(converter, val: Any) -> Any: ...

class SQLiteJsonConverter(dbapiprovider.JsonConverter):
    json_kwargs: Any

def dumps(items: Any) -> Any: ...

class SQLiteArrayConverter(dbapiprovider.ArrayConverter):
    array_types: Any
    def dbval2val(converter, dbval: Any, obj: Any | None = ...) -> Any: ...
    def val2dbval(converter, val: Any, obj: Any | None = ...) -> Any: ...

class LocalExceptions(localbase):
    exc_info: Any
    keep_traceback: bool
    def __init__(self) -> None: ...

local_exceptions: Any

def keep_exception(func: Any) -> Any: ...

class SQLiteProvider(DBAPIProvider):
    dialect: str
    local_exceptions: Any
    max_name_len: int
    dbapi_module: Any
    dbschema_cls: Any
    translator_cls: Any
    sqlbuilder_cls: Any
    array_converter_cls: Any
    name_before_table: str
    server_version: Any
    converter_classes: Any
    def __init__(provider, database: Any, filename: Any, **kwargs: Any) -> None: ...
    def inspect_connection(provider, conn: Any) -> None: ...
    def restore_exception(provider) -> None: ...
    def acquire_lock(provider) -> None: ...
    def release_lock(provider) -> None: ...
    def set_transaction_mode(provider, connection: Any, cache: Any) -> None: ...
    def commit(provider, connection: Any, cache: Any | None = ...) -> None: ...
    def rollback(provider, connection: Any, cache: Any | None = ...) -> None: ...
    def drop(provider, connection: Any, cache: Any | None = ...) -> None: ...
    def release(provider, connection: Any, cache: Any | None = ...) -> None: ...
    def get_pool(  # type: ignore
        provider,
        is_shared_memory_db: Any,
        filename: Any,
        create_db: bool = ...,
        **kwargs: Any
    ) -> Any: ...
    def table_exists(
        provider, connection: Any, table_name: Any, case_sensitive: bool = ...
    ) -> Any: ...
    def index_exists(
        provider,
        connection: Any,
        table_name: Any,
        index_name: Any,
        case_sensitive: bool = ...,
    ) -> Any: ...
    def fk_exists(  # type: ignore
        provider, connection: Any, table_name: Any, fk_name: Any
    ) -> None: ...
    def check_json1(provider, connection: Any) -> Any: ...

provider_cls = SQLiteProvider

def make_string_function(name: Any, base_func: Any) -> Any: ...

py_upper: Any
py_lower: Any

def py_json_unwrap(value: Any) -> Any: ...

path_cache: Any
json_path_re: Any

def py_json_extract(expr: Any, *paths: Any) -> Any: ...
def py_json_query(expr: Any, path: Any, with_wrapper: Any) -> Any: ...
def py_json_value(expr: Any, path: Any) -> Any: ...
def py_json_contains(expr: Any, path: Any, key: Any) -> Any: ...
def py_json_nonzero(expr: Any, path: Any) -> Any: ...
def py_json_array_length(expr: Any, path: Any | None = ...) -> Any: ...
def wrap_array_func(func: Any) -> Any: ...
def py_array_index(array: Any, index: Any) -> Any: ...
def py_array_contains(array: Any, item: Any) -> Any: ...
def py_array_subset(array: Any, items: Any) -> Any: ...
def py_array_length(array: Any) -> Any: ...
def py_array_slice(array: Any, start: Any, stop: Any) -> Any: ...
def py_make_array(*items: Any) -> Any: ...
def py_string_slice(s: Any, start: Any, end: Any) -> Any: ...

class SQLitePool(Pool):
    def __init__(
        pool, is_shared_memory_db: Any, filename: Any, create_db: Any, **kwargs: Any
    ) -> None: ...
    def disconnect(pool) -> None: ...
    def drop(pool, con: Any) -> None: ...
