"""adding jobs tables

Revision ID: 794249a0b1bd
Revises: db1c56bf4d57
Create Date: 2020-12-14 16:11:19.819492

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = '794249a0b1bd'
down_revision = 'db1c56bf4d57'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        'jobs',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created', sa.DateTime(), nullable=False),
        sa.Column('updated', sa.DateTime(), nullable=False),
        sa.Column('manifest', sa.LargeBinary(), nullable=False),
        sa.Column('owner_id', sa.LargeBinary(length=16), nullable=True),
        sa.Column("items_spec", sa.String(), nullable=True),
        sa.Column(
            'items',
            sa.Enum('watch', 'watch_for', 'all', 'list', name='itemsselection'),
            nullable=False,
        ),
        sa.Column(
            'status',
            sa.Enum(
                'pending',
                'queued',
                'running',
                'success',
                'failed',
                'timeout',
                'cancelled',
                name='jobstatus',
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ['owner_id'],
            ['users.id'],
            ondelete="cascade",
        ),
        sa.PrimaryKeyConstraint('id'),
    )
    op.create_table(
        'tasks',
        sa.Column('id', sa.Integer(), nullable=False),
        sa.Column('created', sa.DateTime(), nullable=False),
        sa.Column('updated', sa.DateTime(), nullable=False),
        sa.Column(
            'status',
            sa.Enum(
                'pending', 'running', 'success', 'failed', 'skipped', name='taskstatus'
            ),
            nullable=False,
        ),
        sa.Column('job_id', sa.Integer(), nullable=False),
        sa.Column('package_version_id', sa.LargeBinary(length=16), nullable=True),
        sa.ForeignKeyConstraint(
            ['job_id'],
            ['jobs.id'],
            ondelete="cascade",
        ),
        sa.ForeignKeyConstraint(
            ['package_version_id'],
            ['package_versions.id'],
            ondelete="cascade",
        ),
        sa.PrimaryKeyConstraint('id'),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('tasks')
    op.drop_table('jobs')
    # ### end Alembic commands ###
