"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AfterCreate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const core_1 = require("@aws-cdk/core");
/**
 * @stability stable
 */
class AfterCreate extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const provider = core_1.CustomResourceProvider.getOrCreateProvider(this, 'AWSCDK.TriggerCustomResourceProvider', {
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_14_X,
            codeDirectory: path_1.join(__dirname, 'handler'),
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: ['lambda:InvokeFunction'],
                    Resource: ['*'],
                },
            ],
        });
        const resource = new core_1.CustomResource(this, 'Resource', {
            resourceType: 'Custom::Trigger',
            serviceToken: provider.serviceToken,
            properties: {
                HandlerArn: props.handler.functionArn,
            },
        });
        // add a dependency between our resource and the resources we want to invoke
        // after.
        resource.node.addDependency(...(_b = props.resources) !== null && _b !== void 0 ? _b : []);
    }
}
exports.AfterCreate = AfterCreate;
_a = JSII_RTTI_SYMBOL_1;
AfterCreate[_a] = { fqn: "cdk-triggers.AfterCreate", version: "0.0.9" };
//# sourceMappingURL=data:application/json;base64,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