"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Trail = exports.TrailProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const actiontrail_generated_1 = require("./actiontrail.generated");
Object.defineProperty(exports, "TrailProperty", { enumerable: true, get: function () { return actiontrail_generated_1.RosTrail; } });
/**
 * A ROS resource type:  `ALIYUN::ACTIONTRAIL::Trail`
 */
class Trail extends ros.Resource {
    /**
     * Create a new `ALIYUN::ACTIONTRAIL::Trail`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTrail = new actiontrail_generated_1.RosTrail(this, id, {
            slsProjectArn: props.slsProjectArn,
            roleName: props.roleName,
            eventRw: props.eventRw ? props.eventRw : 'Write',
            ossKeyPrefix: props.ossKeyPrefix,
            ossBucketName: props.ossBucketName,
            slsWriteRoleArn: props.slsWriteRoleArn,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTrail;
        this.attrName = rosTrail.attrName;
    }
}
exports.Trail = Trail;
//# sourceMappingURL=data:application/json;base64,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