"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TrailLogging = exports.TrailLoggingProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const actiontrail_generated_1 = require("./actiontrail.generated");
Object.defineProperty(exports, "TrailLoggingProperty", { enumerable: true, get: function () { return actiontrail_generated_1.RosTrailLogging; } });
/**
 * A ROS resource type:  `ALIYUN::ACTIONTRAIL::TrailLogging`
 */
class TrailLogging extends ros.Resource {
    /**
     * Create a new `ALIYUN::ACTIONTRAIL::TrailLogging`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosTrailLogging = new actiontrail_generated_1.RosTrailLogging(this, id, {
            enable: props.enable,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTrailLogging;
        this.attrIsLogging = rosTrailLogging.attrIsLogging;
        this.attrLatestDeliveryError = rosTrailLogging.attrLatestDeliveryError;
        this.attrLatestDeliveryTime = rosTrailLogging.attrLatestDeliveryTime;
        this.attrStartLoggingTime = rosTrailLogging.attrStartLoggingTime;
        this.attrStopLoggingTime = rosTrailLogging.attrStopLoggingTime;
    }
}
exports.TrailLogging = TrailLogging;
//# sourceMappingURL=data:application/json;base64,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