# -*- coding: utf-8 -*-
"""v0.1.2. Initial db

Revision ID: 23c1bf9b7f48
Revises:
Create Date: 2022-10-19 01:56:29.299702

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "23c1bf9b7f48"
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "taskCategory",
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("modified", sa.DateTime(), nullable=False),
        sa.Column("task_category_id", sa.Integer(), autoincrement=False, nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("handler", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("task_category_id"),
        sa.UniqueConstraint("name"),
    )
    op.create_table(
        "user",
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("modified", sa.DateTime(), nullable=False),
        sa.Column("user_id", sa.Integer(), nullable=False),
        sa.Column("uuid", sa.String(), nullable=False),
        sa.Column("username", sa.String(), nullable=False),
        sa.Column("email", sa.String(), nullable=False),
        sa.Column("password", sa.String(), nullable=False),
        sa.Column("role_id", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("user_id"),
        sa.UniqueConstraint("username"),
        sa.UniqueConstraint("uuid"),
        comment="Stores all user info",
    )
    op.create_table(
        "project",
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("modified", sa.DateTime(), nullable=False),
        sa.Column("project_id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("task_category_id", sa.Integer(), nullable=True),
        sa.Column("data_dir", sa.String(), nullable=False),
        sa.Column("label_dir", sa.String(), nullable=True),
        sa.Column("label_format", sa.String(), nullable=True),
        sa.Column("other_settings", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["task_category_id"],
            ["taskCategory.task_category_id"],
        ),
        sa.PrimaryKeyConstraint("project_id"),
        sa.UniqueConstraint("data_dir"),
        sa.UniqueConstraint("label_dir"),
        sa.UniqueConstraint("name"),
        comment="Stores information and settings for each project",
    )
    op.create_table(
        "label",
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("modified", sa.DateTime(), nullable=False),
        sa.Column("label_id", sa.Integer(), nullable=False),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("project_id", sa.Integer(), nullable=True),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("color", sa.String(), nullable=True),
        sa.Column("comment", sa.String(), nullable=True),
        sa.Column("super_category_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["project_id"],
            ["project.project_id"],
        ),
        sa.PrimaryKeyConstraint("label_id"),
        comment="Contains all the label information",
    )
    op.create_table(
        "tag",
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("modified", sa.DateTime(), nullable=False),
        sa.Column("tag_id", sa.Integer(), nullable=False),
        sa.Column("project_id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("color", sa.String(), nullable=True),
        sa.Column("comment", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["project_id"],
            ["project.project_id"],
        ),
        sa.PrimaryKeyConstraint("tag_id"),
        comment="Contains all the tags",
    )
    op.create_table(
        "task",
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("modified", sa.DateTime(), nullable=False),
        sa.Column("task_id", sa.Integer(), nullable=False),
        sa.Column("project_id", sa.Integer(), nullable=False),
        sa.Column("set", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(["project_id"], ["project.project_id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("task_id"),
        comment="Contains all the tasks",
    )
    op.create_table(
        "data",
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("modified", sa.DateTime(), nullable=False),
        sa.Column("data_id", sa.Integer(), nullable=False),
        sa.Column("task_id", sa.Integer(), nullable=True),
        sa.Column("path", sa.String(), nullable=False),
        sa.Column("size", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(["task_id"], ["task.task_id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("data_id"),
        comment="Contains all the data files",
    )
    op.create_table(
        "tagTask",
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("modified", sa.DateTime(), nullable=False),
        sa.Column("tag_task_id", sa.Integer(), nullable=False),
        sa.Column("project_id", sa.Integer(), nullable=False),
        sa.Column("tag_id", sa.Integer(), nullable=False),
        sa.Column("task_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["project_id"],
            ["project.project_id"],
        ),
        sa.ForeignKeyConstraint(
            ["tag_id"],
            ["tag.tag_id"],
        ),
        sa.ForeignKeyConstraint(
            ["task_id"],
            ["task.task_id"],
        ),
        sa.PrimaryKeyConstraint("tag_task_id"),
        comment="Tag and task intersect",
    )
    op.create_table(
        "annotation",
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("modified", sa.DateTime(), nullable=False),
        sa.Column("annotation_id", sa.Integer(), nullable=False),
        sa.Column("frontend_id", sa.Integer(), nullable=True),
        sa.Column("result", sa.String(), nullable=True),
        sa.Column("type", sa.String(), nullable=True),
        sa.Column("label_id", sa.Integer(), nullable=False),
        sa.Column("data_id", sa.Integer(), nullable=True),
        sa.Column("task_id", sa.Integer(), nullable=False),
        sa.Column("project_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(["data_id"], ["data.data_id"], ondelete="CASCADE"),
        sa.ForeignKeyConstraint(["label_id"], ["label.label_id"], ondelete="CASCADE"),
        sa.ForeignKeyConstraint(
            ["project_id"],
            ["project.project_id"],
        ),
        sa.ForeignKeyConstraint(["task_id"], ["task.task_id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("annotation_id"),
        comment="Contains all the annotations",
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("annotation")
    op.drop_table("tagTask")
    op.drop_table("data")
    op.drop_table("task")
    op.drop_table("tag")
    op.drop_table("label")
    op.drop_table("project")
    op.drop_table("user")
    op.drop_table("taskCategory")
    # ### end Alembic commands ###
