# -*- coding: utf-8 -*-
"""v1.0.0
- Make sure the size of all tasks are 1,h,w

Revision ID: f47b7f5b73b9
Revises: a609821ce310
Create Date: 2023-01-09 18:31:50.399688

"""
from pathlib import Path

from paddlelabel.api.model import Project, Task
from paddlelabel.config import se
from paddlelabel.io.image import getSize

# revision identifiers, used by Alembic.
revision = "f47b7f5b73b9"
down_revision = "a609821ce310"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    projects = Project.query.all()
    pjid2data_dir = {p.project_id: Path(p.data_dir) for p in projects}

    tasks = Task.query.all()
    for task in tasks:
        data = task.datas[0]
        img_path = Path(pjid2data_dir[task.project_id]) / data.path
        s, _, _ = getSize(img_path)
        data.size = s
    se.commit()

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###
