# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = [
    'GetRecordsResult',
    'AwaitableGetRecordsResult',
    'get_records',
]

@pulumi.output_type
class GetRecordsResult:
    """
    A collection of values returned by getRecords.
    """
    def __init__(__self__, domain=None, filters=None, id=None, records=None, sorts=None):
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if records and not isinstance(records, list):
            raise TypeError("Expected argument 'records' to be a list")
        pulumi.set(__self__, "records", records)
        if sorts and not isinstance(sorts, list):
            raise TypeError("Expected argument 'sorts' to be a list")
        pulumi.set(__self__, "sorts", sorts)

    @property
    @pulumi.getter
    def domain(self) -> str:
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetRecordsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def records(self) -> Sequence['outputs.GetRecordsRecordResult']:
        return pulumi.get(self, "records")

    @property
    @pulumi.getter
    def sorts(self) -> Optional[Sequence['outputs.GetRecordsSortResult']]:
        return pulumi.get(self, "sorts")


class AwaitableGetRecordsResult(GetRecordsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRecordsResult(
            domain=self.domain,
            filters=self.filters,
            id=self.id,
            records=self.records,
            sorts=self.sorts)


def get_records(domain: Optional[str] = None,
                filters: Optional[Sequence[pulumi.InputType['GetRecordsFilterArgs']]] = None,
                sorts: Optional[Sequence[pulumi.InputType['GetRecordsSortArgs']]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRecordsResult:
    """
    Retrieve information about all DNS records within a domain, with the ability to filter and sort the results.
    If no filters are specified, all records will be returned.


    :param str domain: The domain name to search for DNS records
    :param Sequence[pulumi.InputType['GetRecordsFilterArgs']] filters: Filter the results.
           The `filter` block is documented below.
    :param Sequence[pulumi.InputType['GetRecordsSortArgs']] sorts: Sort the results.
           The `sort` block is documented below.
    """
    __args__ = dict()
    __args__['domain'] = domain
    __args__['filters'] = filters
    __args__['sorts'] = sorts
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('digitalocean:index/getRecords:getRecords', __args__, opts=opts, typ=GetRecordsResult).value

    return AwaitableGetRecordsResult(
        domain=__ret__.domain,
        filters=__ret__.filters,
        id=__ret__.id,
        records=__ret__.records,
        sorts=__ret__.sorts)
