# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['Tag']


class Tag(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a DigitalOcean Tag resource. A Tag is a label that can be applied to a
        Droplet resource in order to better organize or facilitate the lookups and
        actions on it. Tags created with this resource can be referenced in your Droplet
        configuration via their ID or name.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        # Create a new tag
        foobar = digitalocean.Tag("foobar")
        # Create a new Droplet in nyc3 with the foobar tag
        web = digitalocean.Droplet("web",
            image="ubuntu-18-04-x64",
            region="nyc3",
            size="s-1vcpu-1gb",
            tags=[foobar.id])
        ```

        ## Import

        Tags can be imported using the `name`, e.g.

        ```sh
         $ pulumi import digitalocean:index/tag:Tag mytag tagname
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the tag
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['name'] = name
            __props__['databases_count'] = None
            __props__['droplets_count'] = None
            __props__['images_count'] = None
            __props__['total_resource_count'] = None
            __props__['volume_snapshots_count'] = None
            __props__['volumes_count'] = None
        super(Tag, __self__).__init__(
            'digitalocean:index/tag:Tag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            databases_count: Optional[pulumi.Input[int]] = None,
            droplets_count: Optional[pulumi.Input[int]] = None,
            images_count: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            total_resource_count: Optional[pulumi.Input[int]] = None,
            volume_snapshots_count: Optional[pulumi.Input[int]] = None,
            volumes_count: Optional[pulumi.Input[int]] = None) -> 'Tag':
        """
        Get an existing Tag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] databases_count: A count of the database clusters that the tag is applied to.
        :param pulumi.Input[int] droplets_count: A count of the Droplets the tag is applied to.
        :param pulumi.Input[int] images_count: A count of the images that the tag is applied to.
        :param pulumi.Input[str] name: The name of the tag
        :param pulumi.Input[int] total_resource_count: A count of the total number of resources that the tag is applied to.
        :param pulumi.Input[int] volume_snapshots_count: A count of the volume snapshots that the tag is applied to.
        :param pulumi.Input[int] volumes_count: A count of the volumes that the tag is applied to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["databases_count"] = databases_count
        __props__["droplets_count"] = droplets_count
        __props__["images_count"] = images_count
        __props__["name"] = name
        __props__["total_resource_count"] = total_resource_count
        __props__["volume_snapshots_count"] = volume_snapshots_count
        __props__["volumes_count"] = volumes_count
        return Tag(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="databasesCount")
    def databases_count(self) -> pulumi.Output[int]:
        """
        A count of the database clusters that the tag is applied to.
        """
        return pulumi.get(self, "databases_count")

    @property
    @pulumi.getter(name="dropletsCount")
    def droplets_count(self) -> pulumi.Output[int]:
        """
        A count of the Droplets the tag is applied to.
        """
        return pulumi.get(self, "droplets_count")

    @property
    @pulumi.getter(name="imagesCount")
    def images_count(self) -> pulumi.Output[int]:
        """
        A count of the images that the tag is applied to.
        """
        return pulumi.get(self, "images_count")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the tag
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="totalResourceCount")
    def total_resource_count(self) -> pulumi.Output[int]:
        """
        A count of the total number of resources that the tag is applied to.
        """
        return pulumi.get(self, "total_resource_count")

    @property
    @pulumi.getter(name="volumeSnapshotsCount")
    def volume_snapshots_count(self) -> pulumi.Output[int]:
        """
        A count of the volume snapshots that the tag is applied to.
        """
        return pulumi.get(self, "volume_snapshots_count")

    @property
    @pulumi.getter(name="volumesCount")
    def volumes_count(self) -> pulumi.Output[int]:
        """
        A count of the volumes that the tag is applied to.
        """
        return pulumi.get(self, "volumes_count")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

