import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HealthcareDicomStoreConfig extends cdktf.TerraformMetaArguments {
    /**
     * Identifies the dataset addressed by this request. Must be in the format 'projects/{project}/locations/{location}/datasets/{dataset}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store.html#dataset HealthcareDicomStore#dataset}
     *
     * @stability stable
     */
    readonly dataset: string;
    /**
     * User-supplied key-value pairs used to organize DICOM stores.
     *
     * Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must
     * conform to the following PCRE regular expression: [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
     *
     * Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128
     * bytes, and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
     *
     * No more than 64 labels can be associated with a given store.
     *
     * An object containing a list of "key": value pairs.
     * Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store.html#labels HealthcareDicomStore#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The resource name for the DicomStore.
     *
     * * Changing this property may recreate the Dicom store (removing all data) **
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store.html#name HealthcareDicomStore#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * notification_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store.html#notification_config HealthcareDicomStore#notification_config}
     *
     * @stability stable
     */
    readonly notificationConfig?: HealthcareDicomStoreNotificationConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store.html#timeouts HealthcareDicomStore#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: HealthcareDicomStoreTimeouts;
}
/**
 * @stability stable
 */
export interface HealthcareDicomStoreNotificationConfig {
    /**
     * The Cloud Pub/Sub topic that notifications of changes are published on.
     *
     * Supplied by the client.
     * PubsubMessage.Data will contain the resource name. PubsubMessage.MessageId is the ID of this message.
     * It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message
     * was published. Notifications are only sent if the topic is non-empty. Topic names must be scoped to a
     * project. service-PROJECT_NUMBER@gcp-sa-healthcare.iam.gserviceaccount.com must have publisher permissions on the given
     * Cloud Pub/Sub topic. Not having adequate permissions will cause the calls that send notifications to fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store.html#pubsub_topic HealthcareDicomStore#pubsub_topic}
     *
     * @stability stable
     */
    readonly pubsubTopic: string;
}
export declare function healthcareDicomStoreNotificationConfigToTerraform(struct?: HealthcareDicomStoreNotificationConfigOutputReference | HealthcareDicomStoreNotificationConfig): any;
/**
 * @stability stable
 */
export declare class HealthcareDicomStoreNotificationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HealthcareDicomStoreNotificationConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HealthcareDicomStoreNotificationConfig | undefined);
    private _pubsubTopic?;
    /**
     * @stability stable
     */
    get pubsubTopic(): string;
    /**
     * @stability stable
     */
    set pubsubTopic(value: string);
    /**
     * @stability stable
     */
    get pubsubTopicInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HealthcareDicomStoreTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store.html#create HealthcareDicomStore#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store.html#delete HealthcareDicomStore#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store.html#update HealthcareDicomStore#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function healthcareDicomStoreTimeoutsToTerraform(struct?: HealthcareDicomStoreTimeoutsOutputReference | HealthcareDicomStoreTimeouts): any;
/**
 * @stability stable
 */
export declare class HealthcareDicomStoreTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HealthcareDicomStoreTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HealthcareDicomStoreTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store.html google_healthcare_dicom_store}.
 *
 * @stability stable
 */
export declare class HealthcareDicomStore extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_dicom_store.html google_healthcare_dicom_store} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HealthcareDicomStoreConfig);
    private _dataset?;
    /**
     * @stability stable
     */
    get dataset(): string;
    /**
     * @stability stable
     */
    set dataset(value: string);
    /**
     * @stability stable
     */
    get datasetInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _notificationConfig;
    /**
     * @stability stable
     */
    get notificationConfig(): HealthcareDicomStoreNotificationConfigOutputReference;
    /**
     * @stability stable
     */
    putNotificationConfig(value: HealthcareDicomStoreNotificationConfig): void;
    /**
     * @stability stable
     */
    resetNotificationConfig(): void;
    /**
     * @stability stable
     */
    get notificationConfigInput(): HealthcareDicomStoreNotificationConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): HealthcareDicomStoreTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: HealthcareDicomStoreTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): HealthcareDicomStoreTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
