# (C) Copyright 2015 Hewlett Packard Enterprise Development LP
# Copyright 2017 Fujitsu LIMITED
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import abc


class AbstractNotifier(object, metaclass=abc.ABCMeta):

    def __init__(self):
        pass

    @abc.abstractproperty
    def statsd_name(self):
        pass

    @abc.abstractmethod
    def config(self, config):
        pass

    @abc.abstractmethod
    def send_notification(self, notification):
        pass
