"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataProduct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class DataProduct {
    constructor(props) {
        this.accountId = props.accountId;
        this.dataCatalogAccountId = props.dataCatalogAccountId;
        this.databaseName = props.databaseName;
        this.pipelines = props.pipelines;
        if (props.s3BucketProps) {
            this.s3BucketProps = props.s3BucketProps;
        }
        else {
            this.s3BucketProps = {
                removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
                autoDeleteObjects: true,
                lifecycleRules: [
                    {
                        expiration: aws_cdk_lib_1.Duration.days(30),
                    },
                ],
            };
        }
    }
}
exports.DataProduct = DataProduct;
_a = JSII_RTTI_SYMBOL_1;
DataProduct[_a] = { fqn: "@randyridgley/cdk-datalake-constructs.DataProduct", version: "0.0.52" };
//# sourceMappingURL=data:application/json;base64,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