import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import { Construct } from 'constructs';
import { KinesisStream } from './kinesis-stream';
import { S3DeliveryStream } from './s3-delivery-stream';
export interface IKinesisOpsProperties {
    stream: KinesisStream;
    deliveryStream: S3DeliveryStream;
    inputStreamIteratorAgeCritical?: cloudwatch.CreateAlarmOptions;
    inputStreamIteratorAgeWarning?: cloudwatch.CreateAlarmOptions;
    inputStreamReadThroughputWarning?: cloudwatch.CreateAlarmOptions;
    inputStreamWriteThroughputWarning?: cloudwatch.CreateAlarmOptions;
    inputStreamGetRecordsWarning?: cloudwatch.CreateAlarmOptions;
    inputStreamPutRecordsWarning?: cloudwatch.CreateAlarmOptions;
    firehoseDeliveryToS3Critical?: cloudwatch.CreateAlarmOptions;
    firehoseDeliveryToS3Warning?: cloudwatch.CreateAlarmOptions;
}
export declare class KinesisOps extends Construct {
    dashboard: cloudwatch.Dashboard;
    readonly stream: KinesisStream;
    readonly deliveryStream: S3DeliveryStream;
    readonly streamName: string;
    readonly inputStreamIteratorAgeCriticalAlarm: cloudwatch.Alarm;
    readonly inputStreamIteratorAgeWarningAlarm: cloudwatch.Alarm;
    readonly inputStreamReadThroughputWarningAlarm: cloudwatch.Alarm;
    readonly inputStreamWriteThroughputWarningAlarm: cloudwatch.Alarm;
    readonly inputStreamGetRecordsWarningAlarm: cloudwatch.Alarm;
    readonly inputStreamPutRecordsWarningAlarm: cloudwatch.Alarm;
    readonly firehoseDeliveryToS3WarningAlarm: cloudwatch.Alarm;
    readonly firehoseDeliveryToS3CriticalAlarm: cloudwatch.Alarm;
    readonly alarmsSev2: cloudwatch.Alarm[];
    readonly alarmsSev3: cloudwatch.Alarm[];
    constructor(scope: Construct, id: string, props: IKinesisOpsProperties);
    private alarmWidgets;
    private addWidgets;
    private setupDashboard;
}
