import { Resource } from 'aws-cdk-lib';
import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import * as iam from 'aws-cdk-lib/aws-iam';
import * as kinesis from 'aws-cdk-lib/aws-kinesis';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
export declare enum DeliveryStreamType {
    DIRECT_PUT = "DirectPut",
    KINESIS_STREAM_AS_SOURCE = "KinesisStreamAsSource"
}
export declare enum ProcessorType {
    LAMBDA = "Lambda"
}
export declare enum CompressionType {
    UNCOMPRESSED = "UNCOMPRESSED",
    GZIP = "GZIP",
    ZIP = "ZIP",
    SNAPPY = "Snappy"
}
export interface DeliveryStreamProperties {
    readonly kinesisStream: kinesis.Stream;
    readonly s3Bucket: s3.IBucket;
    readonly s3Prefix?: string;
    readonly compression?: CompressionType;
    readonly transformFunction?: lambda.Function;
}
export declare class S3DeliveryStream extends Resource {
    s3Bucket: s3.IBucket;
    protected cloudWatchLogsRole?: iam.Role;
    readonly deliveryStreamArn: string;
    readonly deliveryStreamName: string;
    private readonly role;
    private readonly deliveryStreamResource;
    constructor(parent: Construct, name: string, props: DeliveryStreamProperties);
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricBackupToS3Bytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricBackupToS3DataFreshness(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricBackupToS3Records(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricBackupToS3Success(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricDataReadFromKinesisStreamBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricDataReadFromKinesisStreamRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricDeliveryToS3Bytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricDeliveryToS3DataFreshness(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricDeliveryToS3Records(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricDeliveryToS3Success(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricIncomingBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricIncomingRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    private makeKinesisSourceConfig;
    private makeS3Config;
    private makeProcessorConfig;
}
