import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import * as events from 'aws-cdk-lib/aws-events';
import * as glue from 'aws-cdk-lib/aws-glue';
import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
export interface IGlueCrawlerProperties {
    name: string;
    databaseName: string;
    roleName?: string;
    trigger?: glue.CfnTrigger;
    bucketName: string;
    bucketPrefix?: string;
}
export declare class GlueCrawler extends Construct {
    readonly crawler: glue.CfnCrawler;
    readonly role: iam.IRole;
    readonly metricSuccessRule: events.Rule;
    readonly metricFailureRule: events.Rule;
    constructor(scope: Construct, id: string, props: IGlueCrawlerProperties);
    metricSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricFailure(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    private ruleMetric;
    private crawlerRule;
    private createGlueCrawlerRole;
}
