import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import * as events from 'aws-cdk-lib/aws-events';
import * as glue from 'aws-cdk-lib/aws-glue';
import * as iam from 'aws-cdk-lib/aws-iam';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
export declare enum GlueWorkerType {
    STANDARD = "Standard",
    G1_X = "G.1X",
    G2_X = "G.2X"
}
export declare enum GlueVersion {
    V_0 = "0.9",
    V_1 = "1.0",
    V_2 = "2.0",
    V_3 = "3.0"
}
export declare enum GlueJobType {
    GLUE_ETL = "glueetl",
    GLUE_STREAMING = "gluestreaming"
}
export interface GlueJobProperties {
    readonly name: string;
    readonly roleName?: string;
    readonly description?: string;
    readonly deploymentBucket: s3.IBucket;
    readonly readAccessBuckets?: s3.IBucket[];
    readonly writeAccessBuckets?: s3.IBucket[];
    readonly glueVersion?: GlueVersion;
    readonly workerType: GlueWorkerType;
    readonly numberOfWorkers?: number;
    readonly maxCapacity?: number;
    readonly maxRetries?: number;
    readonly maxConcurrentRuns?: number;
    readonly jobScript: string;
    readonly jobArgs?: {
        [key: string]: string;
    };
    readonly timeout?: number;
    readonly jobType: GlueJobType;
}
export declare class GlueJob extends Construct {
    private static readonly DAY_IN_MINUTES;
    readonly job: glue.CfnJob;
    readonly role: iam.IRole;
    readonly name: string;
    readonly metricSuccessRule: events.Rule;
    readonly metricTimeoutRule: events.Rule;
    readonly metricFailureRule: events.Rule;
    readonly allExecutionAttemptsFailedEventSource = "custom.aws.glue.allExecutionAttemptsFailed";
    readonly allExecutionAttemptsFailedEventDetailType = "All Execution Attempts Failed";
    readonly executionFailureRule: events.Rule;
    readonly lambdaFunction: lambda.SingletonFunction;
    private allExecutionAttemptsFailedRule;
    constructor(scope: Construct, id: string, props: GlueJobProperties);
    private createGlueJobRole;
    private jobRule;
    metricSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricFailure(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricAllExecutionAttemptsFailed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    metricTimeout(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    private ruleMetric;
    metric(metricName: string, dimensionType: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    jvmHeapUsageMetric(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    elapsedTimeMetric(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    diskSpaceUsedMbMetric(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    runTimeInMiliseconds(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    private createLambdaFunction;
}
