"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataLakeAnalyst = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
class DataLakeAnalyst extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.user = new iam.User(this, 'DataAnalystUser', {
            userName: props.name,
            password: aws_cdk_lib_1.SecretValue.plainText(this.node.tryGetContext('initialPassword')),
            passwordResetRequired: true,
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonAthenaFullAccess'),
                iam.ManagedPolicy.fromAwsManagedPolicyName('IAMUserChangePassword'),
            ],
        });
        // need to add access to Athena worgroup output S3 bucket
        this.user.attachInlinePolicy(new iam.Policy(this, 'DataAnalystPermissions', {
            policyName: 'DataAnalystPermissions',
            statements: [
                new iam.PolicyStatement({
                    effect: iam.Effect.ALLOW,
                    actions: [
                        'lakeformation:GetDataAccess',
                        'glue:GetTable',
                        'glue:GetTables',
                        'glue:SearchTables',
                        'glue:GetDatabase',
                        'glue:GetDatabases',
                        'glue:GetPartitions',
                    ],
                    resources: ['*'],
                }),
                new iam.PolicyStatement({
                    effect: iam.Effect.ALLOW,
                    actions: [
                        'lambda:InvokeFunction',
                    ],
                    resources: ['*'],
                }),
            ],
        }));
        if (props.readAccessBuckets) {
            props.readAccessBuckets.forEach(bucket => {
                bucket.grantRead(this.user);
            });
        }
        if (props.writeAccessBuckets) {
            props.writeAccessBuckets.forEach(bucket => {
                bucket.grantWrite(this.user);
            });
        }
    }
}
exports.DataLakeAnalyst = DataLakeAnalyst;
_a = JSII_RTTI_SYMBOL_1;
DataLakeAnalyst[_a] = { fqn: "@randyridgley/cdk-datalake-constructs.DataLakeAnalyst", version: "0.0.52" };
//# sourceMappingURL=data:application/json;base64,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