import { Duration } from 'aws-cdk-lib';
import * as events from 'aws-cdk-lib/aws-events';
import * as sfn from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
import { Stage } from '../global/enums';
export interface ScheduledJobWorkflowProps {
    readonly schedule: events.Schedule;
    readonly name: string;
    readonly stageName: Stage;
    readonly jobName: string;
    readonly jobArguments: {
        [key: string]: any;
    };
    readonly jobTimeout: Duration;
}
export declare class ScheduledJobWorkflow extends Construct {
    readonly rule: events.Rule;
    readonly stateMachine: sfn.StateMachine;
    constructor(scope: Construct, id: string, props: ScheduledJobWorkflowProps);
    private getStateMachineFailureHandlerState;
}
