# MIT License
# 
# Copyright (c) 2020 Erik Scharwächter
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

import numpy as np

def time_tolerant_recall_(A, E, d):
    N_E = float(E.sum())
    T = len(E)
    return len([t for t in range(d, T-d) if (E[t] == 1) and np.sum(A[(t-d):(t+d)+1]) >= 1])/N_E

def time_tolerant_precision_(A, E, d):
    N_A = float(A.sum())
    T = len(E)
    return len([t for t in range(d, T-d) if (A[t] == 1) and np.sum(E[(t-d):(t+d)+1]) >= 1])/N_A
