import pytest
from saudi_id_validator import validate


@pytest.mark.parametrize(
    "test_input, expected",
    [
        (1101798278, True),
        (1102544994, True),
        (1103536825, True),
        (1072701178, True),
        (1098558388, True),
        (1093202487, True),
        (1066124791, True),
        (1071744369, True),
        (1057924043, True),
        (1071956831, True),
        (1074220144, True),
        (1060207394, True),
        (1097469397, True),
        (1029178249, True),
        (1008500256, True),
        (1105598583, True),
        (1019595063, True),
        (1073937326, True),
        (1071565988, True),
        (1080612698, True),
        (1113080038, True),
        (2078295124, True),
        (2060212574, True),
        (2065933661, True),
        (2068961222, True),
        (2108949716, True),
        (2117956975, True),
        (2119657464, True),
        (2184960793, True),
        (2190353660, True),
        (2270299072, True),
        (2291707913, True),
        (2377423518, True),
        (2379247717, True),
        (2406361044, True),
        (1204592553, False),
        (1103364028, False),
        (1165598583, False),
        (2067961222, False),
        (2068495124, False),
        (3182960793, False),
        (108061268, False),
        (10727011784, False),
        (0, False),
        ('1113080038', True),
        ('2406361044', True),
    ],
)
def test_validate_id_numbers(test_input, expected):
    assert validate(test_input) == expected
