# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from fabric_cf.orchestrator.swagger_server.models.base_model_ import Model
from fabric_cf.orchestrator.swagger_server.models.slice import Slice  # noqa: F401,E501
from fabric_cf.orchestrator.swagger_server.models.status200_ok_single import Status200OkSingle  # noqa: F401,E501
from fabric_cf.orchestrator.swagger_server import util


class SliceDetails(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, size: int=1, status: int=200, type: str=None, data: List[Slice]=None):  # noqa: E501
        """SliceDetails - a model defined in Swagger

        :param size: The size of this SliceDetails.  # noqa: E501
        :type size: int
        :param status: The status of this SliceDetails.  # noqa: E501
        :type status: int
        :param type: The type of this SliceDetails.  # noqa: E501
        :type type: str
        :param data: The data of this SliceDetails.  # noqa: E501
        :type data: List[Slice]
        """
        self.swagger_types = {
            'size': int,
            'status': int,
            'type': str,
            'data': List[Slice]
        }

        self.attribute_map = {
            'size': 'size',
            'status': 'status',
            'type': 'type',
            'data': 'data'
        }
        self._size = size
        self._status = status
        self._type = type
        self._data = data

    @classmethod
    def from_dict(cls, dikt) -> 'SliceDetails':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The slice_details of this SliceDetails.  # noqa: E501
        :rtype: SliceDetails
        """
        return util.deserialize_model(dikt, cls)

    @property
    def size(self) -> int:
        """Gets the size of this SliceDetails.


        :return: The size of this SliceDetails.
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size: int):
        """Sets the size of this SliceDetails.


        :param size: The size of this SliceDetails.
        :type size: int
        """

        self._size = size

    @property
    def status(self) -> int:
        """Gets the status of this SliceDetails.


        :return: The status of this SliceDetails.
        :rtype: int
        """
        return self._status

    @status.setter
    def status(self, status: int):
        """Sets the status of this SliceDetails.


        :param status: The status of this SliceDetails.
        :type status: int
        """

        self._status = status

    @property
    def type(self) -> str:
        """Gets the type of this SliceDetails.


        :return: The type of this SliceDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str):
        """Sets the type of this SliceDetails.


        :param type: The type of this SliceDetails.
        :type type: str
        """

        self._type = type

    @property
    def data(self) -> List[Slice]:
        """Gets the data of this SliceDetails.


        :return: The data of this SliceDetails.
        :rtype: List[Slice]
        """
        return self._data

    @data.setter
    def data(self, data: List[Slice]):
        """Sets the data of this SliceDetails.


        :param data: The data of this SliceDetails.
        :type data: List[Slice]
        """

        self._data = data
