"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Chime = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [chime](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonchime.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Chime extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [chime](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonchime.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'chime';
        this.accessLevelList = {
            Write: [
                'AcceptDelegate',
                'ActivateUsers',
                'AddDomain',
                'AddOrUpdateGroups',
                'AssociateChannelFlow',
                'AssociatePhoneNumberWithUser',
                'AssociatePhoneNumbersWithVoiceConnector',
                'AssociatePhoneNumbersWithVoiceConnectorGroup',
                'AssociateSigninDelegateGroupsWithAccount',
                'AuthorizeDirectory',
                'BatchCreateAttendee',
                'BatchCreateChannelMembership',
                'BatchCreateRoomMembership',
                'BatchDeletePhoneNumber',
                'BatchSuspendUser',
                'BatchUnsuspendUser',
                'BatchUpdateAttendeeCapabilitiesExcept',
                'BatchUpdatePhoneNumber',
                'BatchUpdateUser',
                'ChannelFlowCallback',
                'Connect',
                'ConnectDirectory',
                'CreateAccount',
                'CreateApiKey',
                'CreateAppInstance',
                'CreateAppInstanceAdmin',
                'CreateAppInstanceUser',
                'CreateAttendee',
                'CreateBot',
                'CreateCDRBucket',
                'CreateChannel',
                'CreateChannelBan',
                'CreateChannelFlow',
                'CreateChannelMembership',
                'CreateChannelModerator',
                'CreateMediaCapturePipeline',
                'CreateMediaConcatenationPipeline',
                'CreateMediaLiveConnectorPipeline',
                'CreateMeeting',
                'CreateMeetingDialOut',
                'CreateMeetingWithAttendees',
                'CreatePhoneNumberOrder',
                'CreateProxySession',
                'CreateRoom',
                'CreateRoomMembership',
                'CreateSipMediaApplication',
                'CreateSipMediaApplicationCall',
                'CreateSipRule',
                'CreateUser',
                'CreateVoiceConnector',
                'CreateVoiceConnectorGroup',
                'DeleteAccount',
                'DeleteAccountOpenIdConfig',
                'DeleteApiKey',
                'DeleteAppInstance',
                'DeleteAppInstanceAdmin',
                'DeleteAppInstanceStreamingConfigurations',
                'DeleteAppInstanceUser',
                'DeleteAttendee',
                'DeleteCDRBucket',
                'DeleteChannel',
                'DeleteChannelBan',
                'DeleteChannelFlow',
                'DeleteChannelMembership',
                'DeleteChannelMessage',
                'DeleteChannelModerator',
                'DeleteDelegate',
                'DeleteDomain',
                'DeleteEventsConfiguration',
                'DeleteGroups',
                'DeleteMediaCapturePipeline',
                'DeleteMediaPipeline',
                'DeleteMeeting',
                'DeletePhoneNumber',
                'DeleteProxySession',
                'DeleteRoom',
                'DeleteRoomMembership',
                'DeleteSipMediaApplication',
                'DeleteSipRule',
                'DeleteVoiceConnector',
                'DeleteVoiceConnectorEmergencyCallingConfiguration',
                'DeleteVoiceConnectorGroup',
                'DeleteVoiceConnectorOrigination',
                'DeleteVoiceConnectorProxy',
                'DeleteVoiceConnectorStreamingConfiguration',
                'DeleteVoiceConnectorTermination',
                'DeleteVoiceConnectorTerminationCredentials',
                'DeregisterAppInstanceUserEndpoint',
                'DisassociateChannelFlow',
                'DisassociatePhoneNumberFromUser',
                'DisassociatePhoneNumbersFromVoiceConnector',
                'DisassociatePhoneNumbersFromVoiceConnectorGroup',
                'DisassociateSigninDelegateGroupsFromAccount',
                'DisconnectDirectory',
                'InviteDelegate',
                'InviteUsers',
                'InviteUsersFromProvider',
                'LogoutUser',
                'PutAppInstanceRetentionSettings',
                'PutAppInstanceStreamingConfigurations',
                'PutChannelMembershipPreferences',
                'PutEventsConfiguration',
                'PutRetentionSettings',
                'PutSipMediaApplicationLoggingConfiguration',
                'PutVoiceConnectorEmergencyCallingConfiguration',
                'PutVoiceConnectorLoggingConfiguration',
                'PutVoiceConnectorOrigination',
                'PutVoiceConnectorProxy',
                'PutVoiceConnectorStreamingConfiguration',
                'PutVoiceConnectorTermination',
                'PutVoiceConnectorTerminationCredentials',
                'RedactChannelMessage',
                'RedactConversationMessage',
                'RedactRoomMessage',
                'RegenerateSecurityToken',
                'RegisterAppInstanceUserEndpoint',
                'RenameAccount',
                'RenewDelegate',
                'ResetAccountResource',
                'ResetPersonalPIN',
                'RestorePhoneNumber',
                'SendChannelMessage',
                'StartDataExport',
                'StartMeetingTranscription',
                'StopMeetingTranscription',
                'SubmitSupportRequest',
                'SuspendUsers',
                'UnauthorizeDirectory',
                'UpdateAccount',
                'UpdateAccountOpenIdConfig',
                'UpdateAccountResource',
                'UpdateAccountSettings',
                'UpdateAppInstance',
                'UpdateAppInstanceUser',
                'UpdateAppInstanceUserEndpoint',
                'UpdateAttendeeCapabilities',
                'UpdateBot',
                'UpdateCDRSettings',
                'UpdateChannel',
                'UpdateChannelFlow',
                'UpdateChannelMessage',
                'UpdateChannelReadMarker',
                'UpdateGlobalSettings',
                'UpdatePhoneNumber',
                'UpdatePhoneNumberSettings',
                'UpdateProxySession',
                'UpdateRoom',
                'UpdateRoomMembership',
                'UpdateSipMediaApplication',
                'UpdateSipMediaApplicationCall',
                'UpdateSipRule',
                'UpdateSupportedLicenses',
                'UpdateUser',
                'UpdateUserLicenses',
                'UpdateUserSettings',
                'UpdateVoiceConnector',
                'UpdateVoiceConnectorGroup'
            ],
            Read: [
                'DescribeAppInstance',
                'DescribeAppInstanceAdmin',
                'DescribeAppInstanceUser',
                'DescribeAppInstanceUserEndpoint',
                'DescribeChannel',
                'DescribeChannelBan',
                'DescribeChannelFlow',
                'DescribeChannelMembership',
                'DescribeChannelMembershipForAppInstanceUser',
                'DescribeChannelModeratedByAppInstanceUser',
                'DescribeChannelModerator',
                'GetAccount',
                'GetAccountResource',
                'GetAccountSettings',
                'GetAccountWithOpenIdConfig',
                'GetAppInstanceRetentionSettings',
                'GetAppInstanceStreamingConfigurations',
                'GetAttendee',
                'GetBot',
                'GetCDRBucket',
                'GetChannelMembershipPreferences',
                'GetChannelMessage',
                'GetChannelMessageStatus',
                'GetDomain',
                'GetEventsConfiguration',
                'GetGlobalSettings',
                'GetMediaCapturePipeline',
                'GetMediaPipeline',
                'GetMeeting',
                'GetMeetingDetail',
                'GetMessagingSessionEndpoint',
                'GetPhoneNumber',
                'GetPhoneNumberOrder',
                'GetPhoneNumberSettings',
                'GetProxySession',
                'GetRetentionSettings',
                'GetRoom',
                'GetSipMediaApplication',
                'GetSipMediaApplicationLoggingConfiguration',
                'GetSipRule',
                'GetTelephonyLimits',
                'GetUser',
                'GetUserActivityReportData',
                'GetUserByEmail',
                'GetUserSettings',
                'GetVoiceConnector',
                'GetVoiceConnectorEmergencyCallingConfiguration',
                'GetVoiceConnectorGroup',
                'GetVoiceConnectorLoggingConfiguration',
                'GetVoiceConnectorOrigination',
                'GetVoiceConnectorProxy',
                'GetVoiceConnectorStreamingConfiguration',
                'GetVoiceConnectorTermination',
                'GetVoiceConnectorTerminationHealth',
                'ListChannelMessages',
                'ListTagsForResource',
                'RetrieveDataExports',
                'SearchAvailablePhoneNumbers',
                'ValidateAccountResource'
            ],
            List: [
                'ListAccountUsageReportData',
                'ListAccounts',
                'ListApiKeys',
                'ListAppInstanceAdmins',
                'ListAppInstanceUserEndpoints',
                'ListAppInstanceUsers',
                'ListAppInstances',
                'ListAttendeeTags',
                'ListAttendees',
                'ListBots',
                'ListCDRBucket',
                'ListCallingRegions',
                'ListChannelBans',
                'ListChannelFlows',
                'ListChannelMemberships',
                'ListChannelMembershipsForAppInstanceUser',
                'ListChannelModerators',
                'ListChannels',
                'ListChannelsAssociatedWithChannelFlow',
                'ListChannelsModeratedByAppInstanceUser',
                'ListDelegates',
                'ListDirectories',
                'ListDomains',
                'ListGroups',
                'ListMediaCapturePipelines',
                'ListMediaPipelines',
                'ListMeetingEvents',
                'ListMeetingTags',
                'ListMeetings',
                'ListMeetingsReportData',
                'ListPhoneNumberOrders',
                'ListPhoneNumbers',
                'ListProxySessions',
                'ListRoomMemberships',
                'ListRooms',
                'ListSipMediaApplications',
                'ListSipRules',
                'ListSubChannels',
                'ListSupportedPhoneNumberCountries',
                'ListUsers',
                'ListVoiceConnectorGroups',
                'ListVoiceConnectorTerminationCredentials',
                'ListVoiceConnectors',
                'SearchChannels'
            ],
            Tagging: [
                'TagAttendee',
                'TagMeeting',
                'TagResource',
                'UntagAttendee',
                'UntagMeeting',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to accept the delegate invitation to share management of an Amazon Chime account with another AWS Account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toAcceptDelegate() {
        return this.to('AcceptDelegate');
    }
    /**
     * Grants permission to activate users in an Amazon Chime Enterprise account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/manage-access.html
     */
    toActivateUsers() {
        return this.to('ActivateUsers');
    }
    /**
     * Grants permission to add a domain to your Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/claim-domain.html
     */
    toAddDomain() {
        return this.to('AddDomain');
    }
    /**
     * Grants permission to add new or update existing Active Directory or Okta user groups associated with your Amazon Chime Enterprise account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html
     */
    toAddOrUpdateGroups() {
        return this.to('AddOrUpdateGroups');
    }
    /**
     * Grants permission to associate a flow with a channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_AssociateChannelFlow.html
     */
    toAssociateChannelFlow() {
        return this.to('AssociateChannelFlow');
    }
    /**
     * Grants permission to associate a phone number with an Amazon Chime user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_AssociatePhoneNumberWithUser.html
     */
    toAssociatePhoneNumberWithUser() {
        return this.to('AssociatePhoneNumberWithUser');
    }
    /**
     * Grants permission to associate multiple phone numbers with an Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_AssociatePhoneNumbersWithVoiceConnector.html
     */
    toAssociatePhoneNumbersWithVoiceConnector() {
        return this.to('AssociatePhoneNumbersWithVoiceConnector');
    }
    /**
     * Grants permission to associate multiple phone numbers with an Amazon Chime Voice Connector Group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_AssociatePhoneNumbersWithVoiceConnectorGroup.html
     */
    toAssociatePhoneNumbersWithVoiceConnectorGroup() {
        return this.to('AssociatePhoneNumbersWithVoiceConnectorGroup');
    }
    /**
     * Grants permission to associate the specified sign-in delegate groups with the specified Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_AssociateSigninDelegateGroupsWithAccount.html
     */
    toAssociateSigninDelegateGroupsWithAccount() {
        return this.to('AssociateSigninDelegateGroupsWithAccount');
    }
    /**
     * Grants permission to authorize an Active Directory for your Amazon Chime Enterprise account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toAuthorizeDirectory() {
        return this.to('AuthorizeDirectory');
    }
    /**
     * Grants permission to create new attendees for an active Amazon Chime SDK meeting
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_BatchCreateAttendee.html
     */
    toBatchCreateAttendee() {
        return this.to('BatchCreateAttendee');
    }
    /**
     * Grants permission to add multiple users to a channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_BatchCreateChannelMembership.html
     */
    toBatchCreateChannelMembership() {
        return this.to('BatchCreateChannelMembership');
    }
    /**
     * Grants permission to batch add room members
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_BatchCreateRoomMembership.html
     */
    toBatchCreateRoomMembership() {
        return this.to('BatchCreateRoomMembership');
    }
    /**
     * Grants permission to move up to 50 phone numbers to the deletion queue
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_BatchDeletePhoneNumber.html
     */
    toBatchDeletePhoneNumber() {
        return this.to('BatchDeletePhoneNumber');
    }
    /**
     * Grants permission to suspend up to 50 users from a Team or EnterpriseLWA Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_BatchSuspendUser.html
     */
    toBatchSuspendUser() {
        return this.to('BatchSuspendUser');
    }
    /**
     * Grants permission to remove the suspension from up to 50 previously suspended users for the specified Amazon Chime EnterpriseLWA account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_BatchUnsuspendUser.html
     */
    toBatchUnsuspendUser() {
        return this.to('BatchUnsuspendUser');
    }
    /**
     * Grants permission to update AttendeeCapabilities except the capabilities listed in an ExcludedAttendeeIds table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_BatchUpdateAttendeeCapabilitiesExcept.html
     */
    toBatchUpdateAttendeeCapabilitiesExcept() {
        return this.to('BatchUpdateAttendeeCapabilitiesExcept');
    }
    /**
     * Grants permission to update phone number details within the UpdatePhoneNumberRequestItem object for up to 50 phone numbers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_BatchUpdatePhoneNumber.html
     */
    toBatchUpdatePhoneNumber() {
        return this.to('BatchUpdatePhoneNumber');
    }
    /**
     * Grants permission to update user details within the UpdateUserRequestItem object for up to 20 users for the specified Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_BatchUpdateUser.html
     */
    toBatchUpdateUser() {
        return this.to('BatchUpdateUser');
    }
    /**
     * Grants permission to callback for a message on a channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ChannelFlowCallback.html
     */
    toChannelFlowCallback() {
        return this.to('ChannelFlowCallback');
    }
    /**
     * Grants permission to establish a web socket connection for app instance user to the messaging session endpoint
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_Connect.html
     */
    toConnect() {
        return this.to('Connect');
    }
    /**
     * Grants permission to connect an Active Directory to your Amazon Chime Enterprise account
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ds:ConnectDirectory
     *
     * https://docs.aws.amazon.com/chime/latest/ag/active_directory.html
     */
    toConnectDirectory() {
        return this.to('ConnectDirectory');
    }
    /**
     * Grants permission to create an Amazon Chime account under the administrator's AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateAccount.html
     */
    toCreateAccount() {
        return this.to('CreateAccount');
    }
    /**
     * Grants permission to create a new SCIM access key for your Amazon Chime account and Okta configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/okta_sso.html
     */
    toCreateApiKey() {
        return this.to('CreateApiKey');
    }
    /**
     * Grants permission to create an app instance under the AWS account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_CreateAppInstance.html
     */
    toCreateAppInstance() {
        return this.to('CreateAppInstance');
    }
    /**
     * Grants permission to promote an AppInstanceUser to an AppInstanceAdmin
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_CreateAppInstanceAdmin.html
     */
    toCreateAppInstanceAdmin() {
        return this.to('CreateAppInstanceAdmin');
    }
    /**
     * Grants permission to create a user under an Amazon Chime AppInstance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_CreateAppInstanceUser.html
     */
    toCreateAppInstanceUser() {
        return this.to('CreateAppInstanceUser');
    }
    /**
     * Grants permission to create a new attendee for an active Amazon Chime SDK meeting
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateAttendee.html
     */
    toCreateAttendee() {
        return this.to('CreateAttendee');
    }
    /**
     * Grants permission to create a bot for an Amazon Chime Enterprise account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateBot.html
     */
    toCreateBot() {
        return this.to('CreateBot');
    }
    /**
     * Grants permission to create a new Call Detail Record S3 bucket
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:CreateBucket
     * - s3:ListAllMyBuckets
     *
     * https://docs.aws.amazon.com/chime/latest/ag/manage-access.html
     */
    toCreateCDRBucket() {
        return this.to('CreateCDRBucket');
    }
    /**
     * Grants permission to create a channel for an app instance under the AWS account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_CreateChannel.html
     */
    toCreateChannel() {
        return this.to('CreateChannel');
    }
    /**
     * Grants permission to ban a user from a channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_CreateChannelBan.html
     */
    toCreateChannelBan() {
        return this.to('CreateChannelBan');
    }
    /**
     * Grants permission to create a channel flow for an app instance under the AWS account
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_CreateChannelFlow.html
     */
    toCreateChannelFlow() {
        return this.to('CreateChannelFlow');
    }
    /**
     * Grants permission to add a user to a channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_CreateChannelMembership.html
     */
    toCreateChannelMembership() {
        return this.to('CreateChannelMembership');
    }
    /**
     * Grants permission to create a channel moderator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_CreateChannelModerator.html
     */
    toCreateChannelModerator() {
        return this.to('CreateChannelModerator');
    }
    /**
     * Grants permission to create a media capture pipeline
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - s3:GetBucketPolicy
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_media-pipelines-chime_CreateMediaCapturePipeline.html
     */
    toCreateMediaCapturePipeline() {
        return this.to('CreateMediaCapturePipeline');
    }
    /**
     * Grants permission to create a media concatenation pipeline
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - s3:GetBucketPolicy
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_media-pipelines-chime_CreateMediaConcatenationPipeline.html
     */
    toCreateMediaConcatenationPipeline() {
        return this.to('CreateMediaConcatenationPipeline');
    }
    /**
     * Grants permission to create a media live connector pipeline
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_media-pipelines-chime_CreateMediaLiveConnectorPipeline.html
     */
    toCreateMediaLiveConnectorPipeline() {
        return this.to('CreateMediaLiveConnectorPipeline');
    }
    /**
     * Grants permission to create a new Amazon Chime SDK meeting in the specified media Region, with no initial attendees
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateMeeting.html
     */
    toCreateMeeting() {
        return this.to('CreateMeeting');
    }
    /**
     * Grants permission to call a phone number to join the specified Amazon Chime SDK meeting
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateMeetingDialOut.html
     */
    toCreateMeetingDialOut() {
        return this.to('CreateMeetingDialOut');
    }
    /**
     * Grants permission to create a new Amazon Chime SDK meeting in the specified media Region, with a set of attendees
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateMeetingWithAttendees.html
     */
    toCreateMeetingWithAttendees() {
        return this.to('CreateMeetingWithAttendees');
    }
    /**
     * Grants permission to create a phone number order with the Carriers
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_CreatePhoneNumberOrder.html
     */
    toCreatePhoneNumberOrder() {
        return this.to('CreatePhoneNumberOrder');
    }
    /**
     * Grants permission to create a proxy session for the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateProxySession.html
     */
    toCreateProxySession() {
        return this.to('CreateProxySession');
    }
    /**
     * Grants permission to create a room
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateRoom.html
     */
    toCreateRoom() {
        return this.to('CreateRoom');
    }
    /**
     * Grants permission to add a room member
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateRoomMembership.html
     */
    toCreateRoomMembership() {
        return this.to('CreateRoomMembership');
    }
    /**
     * Grants permission to create an Amazon Chime SIP media application under the administrator's AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateSipMediaApplication.html
     */
    toCreateSipMediaApplication() {
        return this.to('CreateSipMediaApplication');
    }
    /**
     * Grants permission to create outbound call for Amazon Chime SIP media application under the administrator's AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateSipMediaApplicationCall.html
     */
    toCreateSipMediaApplicationCall() {
        return this.to('CreateSipMediaApplicationCall');
    }
    /**
     * Grants permission to create an Amazon Chime SIP rule under the administrator's AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateSipRule.html
     */
    toCreateSipRule() {
        return this.to('CreateSipRule');
    }
    /**
     * Grants permission to create a user under the specified Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateUser.html
     */
    toCreateUser() {
        return this.to('CreateUser');
    }
    /**
     * Grants permission to create a Amazon Chime Voice Connector under the administrator's AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateVoiceConnector.html
     */
    toCreateVoiceConnector() {
        return this.to('CreateVoiceConnector');
    }
    /**
     * Grants permission to create a Amazon Chime Voice Connector Group under the administrator's AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_CreateVoiceConnectorGroup.html
     */
    toCreateVoiceConnectorGroup() {
        return this.to('CreateVoiceConnectorGroup');
    }
    /**
     * Grants permission to delete the specified Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeleteAccount.html
     */
    toDeleteAccount() {
        return this.to('DeleteAccount');
    }
    /**
     * Grants permission to delete the OpenIdConfig attributes from your Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/okta_sso.html
     */
    toDeleteAccountOpenIdConfig() {
        return this.to('DeleteAccountOpenIdConfig');
    }
    /**
     * Grants permission to delete the specified SCIM access key associated with your Amazon Chime account and Okta configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/okta_sso.html
     */
    toDeleteApiKey() {
        return this.to('DeleteApiKey');
    }
    /**
     * Grants permission to delete an AppInstance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_DeleteAppInstance.html
     */
    toDeleteAppInstance() {
        return this.to('DeleteAppInstance');
    }
    /**
     * Grants permission to demote an AppInstanceAdmin to an AppInstanceUser
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_DeleteAppInstanceAdmin.html
     */
    toDeleteAppInstanceAdmin() {
        return this.to('DeleteAppInstanceAdmin');
    }
    /**
     * Grants permission to disable data streaming for the app instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_DeleteAppInstanceStreamingConfigurations.html
     */
    toDeleteAppInstanceStreamingConfigurations() {
        return this.to('DeleteAppInstanceStreamingConfigurations');
    }
    /**
     * Grants permission to delete an AppInstanceUser
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_DeleteAppInstanceUser.html
     */
    toDeleteAppInstanceUser() {
        return this.to('DeleteAppInstanceUser');
    }
    /**
     * Grants permission to delete the specified attendee from an Amazon Chime SDK meeting
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeleteAttendee.html
     */
    toDeleteAttendee() {
        return this.to('DeleteAttendee');
    }
    /**
     * Grants permission to delete a Call Detail Record S3 bucket from your Amazon Chime account
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:DeleteBucket
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toDeleteCDRBucket() {
        return this.to('DeleteCDRBucket');
    }
    /**
     * Grants permission to delete a channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DeleteChannel.html
     */
    toDeleteChannel() {
        return this.to('DeleteChannel');
    }
    /**
     * Grants permission to remove a user from a channel's ban list
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DeleteChannelBan.html
     */
    toDeleteChannelBan() {
        return this.to('DeleteChannelBan');
    }
    /**
     * Grants permission to delete a channel flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DeleteChannelFlow.html
     */
    toDeleteChannelFlow() {
        return this.to('DeleteChannelFlow');
    }
    /**
     * Grants permission to remove a member from a channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DeleteChannelMembership.html
     */
    toDeleteChannelMembership() {
        return this.to('DeleteChannelMembership');
    }
    /**
     * Grants permission to delete a channel message
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DeleteChannelMessage.html
     */
    toDeleteChannelMessage() {
        return this.to('DeleteChannelMessage');
    }
    /**
     * Grants permission to delete a channel moderator
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DeleteChannelModerator.html
     */
    toDeleteChannelModerator() {
        return this.to('DeleteChannelModerator');
    }
    /**
     * Grants permission to delete delegated AWS account management from your Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toDeleteDelegate() {
        return this.to('DeleteDelegate');
    }
    /**
     * Grants permission to delete a domain from your Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/claim-domain.html
     */
    toDeleteDomain() {
        return this.to('DeleteDomain');
    }
    /**
     * Grants permission to delete an events configuration for a bot to receive outgoing events
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeleteEventsConfiguration.html
     */
    toDeleteEventsConfiguration() {
        return this.to('DeleteEventsConfiguration');
    }
    /**
     * Grants permission to delete Active Directory or Okta user groups from your Amazon Chime Enterprise account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toDeleteGroups() {
        return this.to('DeleteGroups');
    }
    /**
     * Grants permission to delete a media capture pipeline
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_media-pipelines-chime_DeleteMediaCapturePipeline.html
     */
    toDeleteMediaCapturePipeline() {
        return this.to('DeleteMediaCapturePipeline');
    }
    /**
     * Grants permission to delete a media pipeline
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_media-pipelines-chime_DeleteMediaPipeline.html
     */
    toDeleteMediaPipeline() {
        return this.to('DeleteMediaPipeline');
    }
    /**
     * Grants permission to delete the specified Amazon Chime SDK meeting
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeleteMeeting.html
     */
    toDeleteMeeting() {
        return this.to('DeleteMeeting');
    }
    /**
     * Grants permission to move a phone number to the deletion queue
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeletePhoneNumber.html
     */
    toDeletePhoneNumber() {
        return this.to('DeletePhoneNumber');
    }
    /**
     * Grants permission to delete a proxy session for the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeleteProxySession.html
     */
    toDeleteProxySession() {
        return this.to('DeleteProxySession');
    }
    /**
     * Grants permission to delete a room
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeleteRoom.html
     */
    toDeleteRoom() {
        return this.to('DeleteRoom');
    }
    /**
     * Grants permission to remove a room member
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeleteRoomMembership.html
     */
    toDeleteRoomMembership() {
        return this.to('DeleteRoomMembership');
    }
    /**
     * Grants permission to delete Amazon Chime SIP media application under the administrator's AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeleteSipMediaApplication.html
     */
    toDeleteSipMediaApplication() {
        return this.to('DeleteSipMediaApplication');
    }
    /**
     * Grants permission to delete Amazon Chime SIP rule under the administrator's AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeleteSipRule.html
     */
    toDeleteSipRule() {
        return this.to('DeleteSipRule');
    }
    /**
     * Grants permission to delete the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - logs:CreateLogDelivery
     * - logs:DeleteLogDelivery
     * - logs:GetLogDelivery
     * - logs:ListLogDeliveries
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeleteVoiceConnector.html
     */
    toDeleteVoiceConnector() {
        return this.to('DeleteVoiceConnector');
    }
    /**
     * Grants permission to delete emergency calling configuration for the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeleteVoiceConnectorEmergencyCallingConfiguration.html
     */
    toDeleteVoiceConnectorEmergencyCallingConfiguration() {
        return this.to('DeleteVoiceConnectorEmergencyCallingConfiguration');
    }
    /**
     * Grants permission to delete the specified Amazon Chime Voice Connector Group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeleteVoiceConnectorGroup.html
     */
    toDeleteVoiceConnectorGroup() {
        return this.to('DeleteVoiceConnectorGroup');
    }
    /**
     * Grants permission to delete the origination settings for the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeleteVoiceConnectorOrigination.html
     */
    toDeleteVoiceConnectorOrigination() {
        return this.to('DeleteVoiceConnectorOrigination');
    }
    /**
     * Grants permission to delete proxy configuration for the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeleteVoiceConnectorProxy.html
     */
    toDeleteVoiceConnectorProxy() {
        return this.to('DeleteVoiceConnectorProxy');
    }
    /**
     * Grants permission to delete streaming configuration for the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeleteVoiceConnectorStreamingConfiguration.html
     */
    toDeleteVoiceConnectorStreamingConfiguration() {
        return this.to('DeleteVoiceConnectorStreamingConfiguration');
    }
    /**
     * Grants permission to delete the termination settings for the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeleteVoiceConnectorTermination.html
     */
    toDeleteVoiceConnectorTermination() {
        return this.to('DeleteVoiceConnectorTermination');
    }
    /**
     * Grants permission to delete SIP termination credentials for the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DeleteVoiceConnectorTerminationCredentials.html
     */
    toDeleteVoiceConnectorTerminationCredentials() {
        return this.to('DeleteVoiceConnectorTerminationCredentials');
    }
    /**
     * Grants permission to deregister an endpoint for an app instance user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_DeregisterAppInstanceUserEndpoint.html
     */
    toDeregisterAppInstanceUserEndpoint() {
        return this.to('DeregisterAppInstanceUserEndpoint');
    }
    /**
     * Grants permission to get the full details of an AppInstance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_DescribeAppInstance.html
     */
    toDescribeAppInstance() {
        return this.to('DescribeAppInstance');
    }
    /**
     * Grants permission to get the full details of an AppInstanceAdmin
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_DescribeAppInstanceAdmin.html
     */
    toDescribeAppInstanceAdmin() {
        return this.to('DescribeAppInstanceAdmin');
    }
    /**
     * Grants permission to get the full details of an AppInstanceUser
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_DescribeAppInstanceUser.html
     */
    toDescribeAppInstanceUser() {
        return this.to('DescribeAppInstanceUser');
    }
    /**
     * Grants permission to describe an endpoint registered for an app instance user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_DescribeAppInstanceUserEndpoint.html
     */
    toDescribeAppInstanceUserEndpoint() {
        return this.to('DescribeAppInstanceUserEndpoint');
    }
    /**
     * Grants permission to get the full details of a channel
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DescribeChannel.html
     */
    toDescribeChannel() {
        return this.to('DescribeChannel');
    }
    /**
     * Grants permission to get the full details of a channel ban
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DescribeChannelBan.html
     */
    toDescribeChannelBan() {
        return this.to('DescribeChannelBan');
    }
    /**
     * Grants permission to get the full details of a channel flow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DescribeChannelFlow.html
     */
    toDescribeChannelFlow() {
        return this.to('DescribeChannelFlow');
    }
    /**
     * Grants permission to get the full details of a channel membership
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DescribeChannelMembership.html
     */
    toDescribeChannelMembership() {
        return this.to('DescribeChannelMembership');
    }
    /**
     * Grants permission to get the details of a channel based on the membership of the specified AppInstanceUser
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DescribeChannelMembershipForAppInstanceUser.html
     */
    toDescribeChannelMembershipForAppInstanceUser() {
        return this.to('DescribeChannelMembershipForAppInstanceUser');
    }
    /**
     * Grants permission to get the full details of a channel moderated by the specified AppInstanceUser
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DescribeChannelModeratedByAppInstanceUser.html
     */
    toDescribeChannelModeratedByAppInstanceUser() {
        return this.to('DescribeChannelModeratedByAppInstanceUser');
    }
    /**
     * Grants permission to get the full details of a single ChannelModerator
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DescribeChannelModerator.html
     */
    toDescribeChannelModerator() {
        return this.to('DescribeChannelModerator');
    }
    /**
     * Grants permission to disassociate a flow from a channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_DisassociateChannelFlow.html
     */
    toDisassociateChannelFlow() {
        return this.to('DisassociateChannelFlow');
    }
    /**
     * Grants permission to disassociate the primary provisioned number from the specified Amazon Chime user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DisassociatePhoneNumberFromUser.html
     */
    toDisassociatePhoneNumberFromUser() {
        return this.to('DisassociatePhoneNumberFromUser');
    }
    /**
     * Grants permission to disassociate multiple phone numbers from the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DisassociatePhoneNumbersFromVoiceConnector.html
     */
    toDisassociatePhoneNumbersFromVoiceConnector() {
        return this.to('DisassociatePhoneNumbersFromVoiceConnector');
    }
    /**
     * Grants permission to disassociate multiple phone numbers from the specified Amazon Chime Voice Connector Group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DisassociatePhoneNumbersFromVoiceConnectorGroup.html
     */
    toDisassociatePhoneNumbersFromVoiceConnectorGroup() {
        return this.to('DisassociatePhoneNumbersFromVoiceConnectorGroup');
    }
    /**
     * Grants permission to disassociate the specified sign-in delegate groups from the specified Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_DisassociateSigninDelegateGroupsFromAccount.html
     */
    toDisassociateSigninDelegateGroupsFromAccount() {
        return this.to('DisassociateSigninDelegateGroupsFromAccount');
    }
    /**
     * Grants permission to disconnect the Active Directory from your Amazon Chime Enterprise account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toDisconnectDirectory() {
        return this.to('DisconnectDirectory');
    }
    /**
     * Grants permission to get details for the specified Amazon Chime account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetAccount.html
     */
    toGetAccount() {
        return this.to('GetAccount');
    }
    /**
     * Grants permission to get details for the account resource associated with your Amazon Chime account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toGetAccountResource() {
        return this.to('GetAccountResource');
    }
    /**
     * Grants permission to get account settings for the specified Amazon Chime account ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetAccountSettings.html
     */
    toGetAccountSettings() {
        return this.to('GetAccountSettings');
    }
    /**
     * Grants permission to get the account details and OpenIdConfig attributes for your Amazon Chime account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/ag/okta_sso.html
     */
    toGetAccountWithOpenIdConfig() {
        return this.to('GetAccountWithOpenIdConfig');
    }
    /**
     * Grants permission to get retention settings for an app instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_GetAppInstanceRetentionSettings.html
     */
    toGetAppInstanceRetentionSettings() {
        return this.to('GetAppInstanceRetentionSettings');
    }
    /**
     * Grants permission to get the streaming configurations for an app instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_GetAppInstanceStreamingConfigurations.html
     */
    toGetAppInstanceStreamingConfigurations() {
        return this.to('GetAppInstanceStreamingConfigurations');
    }
    /**
     * Grants permission to get attendee details for a specified meeting ID and attendee ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetAttendee.html
     */
    toGetAttendee() {
        return this.to('GetAttendee');
    }
    /**
     * Grants permission to retrieve details for the specified bot
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetBot.html
     */
    toGetBot() {
        return this.to('GetBot');
    }
    /**
     * Grants permission to get details of a Call Detail Record S3 bucket associated with your Amazon Chime account
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetBucketAcl
     * - s3:GetBucketLocation
     * - s3:GetBucketLogging
     * - s3:GetBucketVersioning
     * - s3:GetBucketWebsite
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toGetCDRBucket() {
        return this.to('GetCDRBucket');
    }
    /**
     * Grants permission to get the preferences for a channel membership
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_GetChannelMembershipPreferences.html
     */
    toGetChannelMembershipPreferences() {
        return this.to('GetChannelMembershipPreferences');
    }
    /**
     * Grants permission to get the full details of a channel message
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_GetChannelMessage.html
     */
    toGetChannelMessage() {
        return this.to('GetChannelMessage');
    }
    /**
     * Grants permission to get the status of a channel message
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_GetChannelMessageStatus.html
     */
    toGetChannelMessageStatus() {
        return this.to('GetChannelMessageStatus');
    }
    /**
     * Grants permission to get domain details for a domain associated with your Amazon Chime account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/ag/claim-domain.html
     */
    toGetDomain() {
        return this.to('GetDomain');
    }
    /**
     * Grants permission to retrieve details for an events configuration for a bot to receive outgoing events
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetEventsConfiguration.html
     */
    toGetEventsConfiguration() {
        return this.to('GetEventsConfiguration');
    }
    /**
     * Grants permission to get global settings related to Amazon Chime for the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetGlobalSettings.html
     */
    toGetGlobalSettings() {
        return this.to('GetGlobalSettings');
    }
    /**
     * Grants permission to get an existing media capture pipeline
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_media-pipelines-chime_GetMediaCapturePipeline.html
     */
    toGetMediaCapturePipeline() {
        return this.to('GetMediaCapturePipeline');
    }
    /**
     * Grants permission to get an existing media pipeline
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_media-pipelines-chime_GetMediaPipeline.html
     */
    toGetMediaPipeline() {
        return this.to('GetMediaPipeline');
    }
    /**
     * Grants permission to get the meeting record for a specified meeting ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetMeeting.html
     */
    toGetMeeting() {
        return this.to('GetMeeting');
    }
    /**
     * Grants permission to get attendee, connection, and other details for a meeting
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toGetMeetingDetail() {
        return this.to('GetMeetingDetail');
    }
    /**
     * Grants permission to get the endpoint for the messaging session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_GetMessagingSessionEndpoint.html
     */
    toGetMessagingSessionEndpoint() {
        return this.to('GetMessagingSessionEndpoint');
    }
    /**
     * Grants permission to get details for the specified phone number
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetPhoneNumber.html
     */
    toGetPhoneNumber() {
        return this.to('GetPhoneNumber');
    }
    /**
     * Grants permission to get details for the specified phone number order
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetPhoneNumberOrder.html
     */
    toGetPhoneNumberOrder() {
        return this.to('GetPhoneNumberOrder');
    }
    /**
     * Grants permission to get phone number settings related to Amazon Chime for the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetPhoneNumberSettings.html
     */
    toGetPhoneNumberSettings() {
        return this.to('GetPhoneNumberSettings');
    }
    /**
     * Grants permission to get details of the specified proxy session for the specified Amazon Chime Voice Connector
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetProxySession.html
     */
    toGetProxySession() {
        return this.to('GetProxySession');
    }
    /**
     * Grants permission to retrieve the retention settings for the specified Amazon Chime account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetRetentionSettings.html
     */
    toGetRetentionSettings() {
        return this.to('GetRetentionSettings');
    }
    /**
     * Grants permission to retrieve a room
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetRoom.html
     */
    toGetRoom() {
        return this.to('GetRoom');
    }
    /**
     * Grants permission to get details of Amazon Chime SIP media application under the administrator's AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetSipMediaApplication.html
     */
    toGetSipMediaApplication() {
        return this.to('GetSipMediaApplication');
    }
    /**
     * Grants permission to get logging configuration settings for Amazon Chime SIP media application under the administrator's AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetSipMediaApplicationLoggingConfiguration.html
     */
    toGetSipMediaApplicationLoggingConfiguration() {
        return this.to('GetSipMediaApplicationLoggingConfiguration');
    }
    /**
     * Grants permission to get details of Amazon Chime SIP rule under the administrator's AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetSipRule.html
     */
    toGetSipRule() {
        return this.to('GetSipRule');
    }
    /**
     * Grants permission to get telephony limits for the AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/ag/phone-numbers.html
     */
    toGetTelephonyLimits() {
        return this.to('GetTelephonyLimits');
    }
    /**
     * Grants permission to get details for the specified user ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetUser.html
     */
    toGetUser() {
        return this.to('GetUser');
    }
    /**
     * Grants permission to get a summary of user activity on the user details page
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/ag/user-details.html
     */
    toGetUserActivityReportData() {
        return this.to('GetUserActivityReportData');
    }
    /**
     * Grants permission to get user details for an Amazon Chime user based on the email address in an Amazon Chime Enterprise or Team account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/ag/user-details.html
     */
    toGetUserByEmail() {
        return this.to('GetUserByEmail');
    }
    /**
     * Grants permission to get user settings related to the specified Amazon Chime user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetUserSettings.html
     */
    toGetUserSettings() {
        return this.to('GetUserSettings');
    }
    /**
     * Grants permission to get details for the specified Amazon Chime Voice Connector
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetVoiceConnector.html
     */
    toGetVoiceConnector() {
        return this.to('GetVoiceConnector');
    }
    /**
     * Grants permission to get details of the emergency calling configuration for the specified Amazon Chime Voice Connector
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetVoiceConnectorEmergencyCallingConfiguration.html
     */
    toGetVoiceConnectorEmergencyCallingConfiguration() {
        return this.to('GetVoiceConnectorEmergencyCallingConfiguration');
    }
    /**
     * Grants permission to get details for the specified Amazon Chime Voice Connector Group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetVoiceConnectorGroup.html
     */
    toGetVoiceConnectorGroup() {
        return this.to('GetVoiceConnectorGroup');
    }
    /**
     * Grants permission to get details of the logging configuration for the specified Amazon Chime Voice Connector
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetVoiceConnectorLoggingConfiguration.html
     */
    toGetVoiceConnectorLoggingConfiguration() {
        return this.to('GetVoiceConnectorLoggingConfiguration');
    }
    /**
     * Grants permission to get details of the origination settings for the specified Amazon Chime Voice Connector
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetVoiceConnectorOrigination.html
     */
    toGetVoiceConnectorOrigination() {
        return this.to('GetVoiceConnectorOrigination');
    }
    /**
     * Grants permission to get details of the proxy configuration for the specified Amazon Chime Voice Connector
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetVoiceConnectorProxy.html
     */
    toGetVoiceConnectorProxy() {
        return this.to('GetVoiceConnectorProxy');
    }
    /**
     * Grants permission to get details of the streaming configuration for the specified Amazon Chime Voice Connector
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetVoiceConnectorStreamingConfiguration.html
     */
    toGetVoiceConnectorStreamingConfiguration() {
        return this.to('GetVoiceConnectorStreamingConfiguration');
    }
    /**
     * Grants permission to get details of the termination settings for the specified Amazon Chime Voice Connector
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetVoiceConnectorTermination.html
     */
    toGetVoiceConnectorTermination() {
        return this.to('GetVoiceConnectorTermination');
    }
    /**
     * Grants permission to get details of the termination health for the specified Amazon Chime Voice Connector
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_GetVoiceConnectorTerminationHealth.html
     */
    toGetVoiceConnectorTerminationHealth() {
        return this.to('GetVoiceConnectorTerminationHealth');
    }
    /**
     * Grants permission to send an invitation to accept a request for AWS account delegation for an Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toInviteDelegate() {
        return this.to('InviteDelegate');
    }
    /**
     * Grants permission to invite as many as 50 users to the specified Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_InviteUsers.html
     */
    toInviteUsers() {
        return this.to('InviteUsers');
    }
    /**
     * Grants permission to invite users from a third party provider to your Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toInviteUsersFromProvider() {
        return this.to('InviteUsersFromProvider');
    }
    /**
     * Grants permission to list Amazon Chime account usage reporting data
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/ag/view-reports.html
     */
    toListAccountUsageReportData() {
        return this.to('ListAccountUsageReportData');
    }
    /**
     * Grants permission to list the Amazon Chime accounts under the administrator's AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListAccounts.html
     */
    toListAccounts() {
        return this.to('ListAccounts');
    }
    /**
     * Grants permission to list the SCIM access keys defined for your Amazon Chime account and Okta configuration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/ag/okta_sso.html
     */
    toListApiKeys() {
        return this.to('ListApiKeys');
    }
    /**
     * Grants permission to list administrators in the app instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_ListAppInstanceAdmins.html
     */
    toListAppInstanceAdmins() {
        return this.to('ListAppInstanceAdmins');
    }
    /**
     * Grants permission to list the endpoints registered for an app instance user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_ListAppInstanceUserEndpoints.html
     */
    toListAppInstanceUserEndpoints() {
        return this.to('ListAppInstanceUserEndpoints');
    }
    /**
     * Grants permission to list all AppInstanceUsers created under a single app instance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_ListAppInstanceUsers.html
     */
    toListAppInstanceUsers() {
        return this.to('ListAppInstanceUsers');
    }
    /**
     * Grants permission to list all Amazon Chime app instances created under a single AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_ListAppInstances.html
     */
    toListAppInstances() {
        return this.to('ListAppInstances');
    }
    /**
     * Grants permission to list the tags applied to an Amazon Chime SDK attendee resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListAttendeeTags.html
     */
    toListAttendeeTags() {
        return this.to('ListAttendeeTags');
    }
    /**
     * Grants permission to list up to 100 attendees for a specified Amazon Chime SDK meeting
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListAttendees.html
     */
    toListAttendees() {
        return this.to('ListAttendees');
    }
    /**
     * Grants permission to list the bots associated with the administrator's Amazon Chime Enterprise account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListBots.html
     */
    toListBots() {
        return this.to('ListBots');
    }
    /**
     * Grants permission to list Call Detail Record S3 buckets
     *
     * Access Level: List
     *
     * Dependent actions:
     * - s3:ListAllMyBuckets
     * - s3:ListBucket
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toListCDRBucket() {
        return this.to('ListCDRBucket');
    }
    /**
     * Grants permission to list the calling regions available for the administrator's AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/ag/phone-numbers.html
     */
    toListCallingRegions() {
        return this.to('ListCallingRegions');
    }
    /**
     * Grants permission to list all the users banned from a particular channel
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListChannelBans.html
     */
    toListChannelBans() {
        return this.to('ListChannelBans');
    }
    /**
     * Grants permission to list all the Channel Flows created under a single Chime AppInstance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListChannelFlows.html
     */
    toListChannelFlows() {
        return this.to('ListChannelFlows');
    }
    /**
     * Grants permission to list all channel memberships in a channel
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListChannelMemberships.html
     */
    toListChannelMemberships() {
        return this.to('ListChannelMemberships');
    }
    /**
     * Grants permission to list all channels that a particular AppInstanceUser is a part of
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListChannelMembershipsForAppInstanceUser.html
     */
    toListChannelMembershipsForAppInstanceUser() {
        return this.to('ListChannelMembershipsForAppInstanceUser');
    }
    /**
     * Grants permission to list all the messages in a channel
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListChannelMessages.html
     */
    toListChannelMessages() {
        return this.to('ListChannelMessages');
    }
    /**
     * Grants permission to list all the moderators for a channel
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListChannelModerators.html
     */
    toListChannelModerators() {
        return this.to('ListChannelModerators');
    }
    /**
     * Grants permission to list all the Channels created under a single Chime AppInstance
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListChannels.html
     */
    toListChannels() {
        return this.to('ListChannels');
    }
    /**
     * Grants permission to list all the Channels associated with a single Chime Channel Flow
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListChannelsAssociatedWithChannelFlow.html
     */
    toListChannelsAssociatedWithChannelFlow() {
        return this.to('ListChannelsAssociatedWithChannelFlow');
    }
    /**
     * Grants permission to list all channels moderated by an app instance user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListChannelsModeratedByAppInstanceUser.html
     */
    toListChannelsModeratedByAppInstanceUser() {
        return this.to('ListChannelsModeratedByAppInstanceUser');
    }
    /**
     * Grants permission to list account delegate information associated with your Amazon Chime account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toListDelegates() {
        return this.to('ListDelegates');
    }
    /**
     * Grants permission to list active Active Directories hosted in the Directory Service of your AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toListDirectories() {
        return this.to('ListDirectories');
    }
    /**
     * Grants permission to list domains associated with your Amazon Chime account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/ag/claim-domain.html
     */
    toListDomains() {
        return this.to('ListDomains');
    }
    /**
     * Grants permission to list Active Directory or Okta user groups associated with your Amazon Chime Enterprise account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toListGroups() {
        return this.to('ListGroups');
    }
    /**
     * Grants permission to list media capture pipelines
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_media-pipelines-chime_ListMediaCapturePipelines.html
     */
    toListMediaCapturePipelines() {
        return this.to('ListMediaCapturePipelines');
    }
    /**
     * Grants permission to list media pipelines
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_media-pipelines-chime_ListMediaPipelines.html
     */
    toListMediaPipelines() {
        return this.to('ListMediaPipelines');
    }
    /**
     * Grants permission to list all events that occurred for a specified meeting
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/ag/view-reports.html
     */
    toListMeetingEvents() {
        return this.to('ListMeetingEvents');
    }
    /**
     * Grants permission to list the tags applied to an Amazon Chime SDK meeting resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListMeetingTags.html
     */
    toListMeetingTags() {
        return this.to('ListMeetingTags');
    }
    /**
     * Grants permission to list up to 100 active Amazon Chime SDK meetings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListMeetings.html
     */
    toListMeetings() {
        return this.to('ListMeetings');
    }
    /**
     * Grants permission to list meetings ended during the specified date range
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/ag/view-reports.html
     */
    toListMeetingsReportData() {
        return this.to('ListMeetingsReportData');
    }
    /**
     * Grants permission to list the phone number orders under the administrator's AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListPhoneNumberOrders.html
     */
    toListPhoneNumberOrders() {
        return this.to('ListPhoneNumberOrders');
    }
    /**
     * Grants permission to list the phone numbers under the administrator's AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListPhoneNumbers.html
     */
    toListPhoneNumbers() {
        return this.to('ListPhoneNumbers');
    }
    /**
     * Grants permission to list proxy sessions for the specified Amazon Chime Voice Connector
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListProxySessions.html
     */
    toListProxySessions() {
        return this.to('ListProxySessions');
    }
    /**
     * Grants permission to list all room members
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListRoomMemberships.html
     */
    toListRoomMemberships() {
        return this.to('ListRoomMemberships');
    }
    /**
     * Grants permission to list rooms
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListRooms.html
     */
    toListRooms() {
        return this.to('ListRooms');
    }
    /**
     * Grants permission to list all Amazon Chime SIP media applications under the administrator's AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListSipMediaApplications.html
     */
    toListSipMediaApplications() {
        return this.to('ListSipMediaApplications');
    }
    /**
     * Grants permission to list all Amazon Chime SIP rules under the administrator's AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListSipRules.html
     */
    toListSipRules() {
        return this.to('ListSipRules');
    }
    /**
     * Grants permission to list all the SubChannels under a single Channel
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ListSubChannels.html
     */
    toListSubChannels() {
        return this.to('ListSubChannels');
    }
    /**
     * Grants permission to list the phone number countries supported by the AWS account
     *
     * Access Level: List
     */
    toListSupportedPhoneNumberCountries() {
        return this.to('ListSupportedPhoneNumberCountries');
    }
    /**
     * Grants permission to list the tags applied to an Amazon Chime resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list the users that belong to the specified Amazon Chime account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListUsers.html
     */
    toListUsers() {
        return this.to('ListUsers');
    }
    /**
     * Grants permission to list the Amazon Chime Voice Connector Groups under the administrator's AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListVoiceConnectorGroups.html
     */
    toListVoiceConnectorGroups() {
        return this.to('ListVoiceConnectorGroups');
    }
    /**
     * Grants permission to list the SIP termination credentials for the specified Amazon Chime Voice Connector
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListVoiceConnectorTerminationCredentials.html
     */
    toListVoiceConnectorTerminationCredentials() {
        return this.to('ListVoiceConnectorTerminationCredentials');
    }
    /**
     * Grants permission to list the Amazon Chime Voice Connectors under the administrator's AWS account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ListVoiceConnectors.html
     */
    toListVoiceConnectors() {
        return this.to('ListVoiceConnectors');
    }
    /**
     * Grants permission to log out the specified user from all of the devices they are currently logged into
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_LogoutUser.html
     */
    toLogoutUser() {
        return this.to('LogoutUser');
    }
    /**
     * Grants permission to enable data retention for the app instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_PutAppInstanceRetentionSettings.html
     */
    toPutAppInstanceRetentionSettings() {
        return this.to('PutAppInstanceRetentionSettings');
    }
    /**
     * Grants permission to configure data streaming for the app instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_PutAppInstanceStreamingConfigurations.html
     */
    toPutAppInstanceStreamingConfigurations() {
        return this.to('PutAppInstanceStreamingConfigurations');
    }
    /**
     * Grants permission to put the preferences for a channel membership
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_PutChannelMembershipPreferences.html
     */
    toPutChannelMembershipPreferences() {
        return this.to('PutChannelMembershipPreferences');
    }
    /**
     * Grants permission to update details for an events configuration for a bot to receive outgoing events
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_PutEventsConfiguration.html
     */
    toPutEventsConfiguration() {
        return this.to('PutEventsConfiguration');
    }
    /**
     * Grants permission to create or update retention settings for the specified Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_PutRetentionSettings.html
     */
    toPutRetentionSettings() {
        return this.to('PutRetentionSettings');
    }
    /**
     * Grants permission to update logging configuration settings for Amazon Chime SIP media application under the administrator's AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_PutSipMediaApplicationLoggingConfiguration.html
     */
    toPutSipMediaApplicationLoggingConfiguration() {
        return this.to('PutSipMediaApplicationLoggingConfiguration');
    }
    /**
     * Grants permission to add emergency calling configuration for the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_PutVoiceConnectorEmergencyCallingConfiguration.html
     */
    toPutVoiceConnectorEmergencyCallingConfiguration() {
        return this.to('PutVoiceConnectorEmergencyCallingConfiguration');
    }
    /**
     * Grants permission to add logging configuration for the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - logs:CreateLogDelivery
     * - logs:CreateLogGroup
     * - logs:DeleteLogDelivery
     * - logs:DescribeLogGroups
     * - logs:GetLogDelivery
     * - logs:ListLogDeliveries
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_PutVoiceConnectorLoggingConfiguration.html
     */
    toPutVoiceConnectorLoggingConfiguration() {
        return this.to('PutVoiceConnectorLoggingConfiguration');
    }
    /**
     * Grants permission to update the origination settings for the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_PutVoiceConnectorOrigination.html
     */
    toPutVoiceConnectorOrigination() {
        return this.to('PutVoiceConnectorOrigination');
    }
    /**
     * Grants permission to add proxy configuration for the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_PutVoiceConnectorProxy.html
     */
    toPutVoiceConnectorProxy() {
        return this.to('PutVoiceConnectorProxy');
    }
    /**
     * Grants permission to add streaming configuration for the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_PutVoiceConnectorStreamingConfiguration.html
     */
    toPutVoiceConnectorStreamingConfiguration() {
        return this.to('PutVoiceConnectorStreamingConfiguration');
    }
    /**
     * Grants permission to update the termination settings for the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_PutVoiceConnectorTermination.html
     */
    toPutVoiceConnectorTermination() {
        return this.to('PutVoiceConnectorTermination');
    }
    /**
     * Grants permission to add SIP termination credentials for the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_PutVoiceConnectorTerminationCredentials.html
     */
    toPutVoiceConnectorTerminationCredentials() {
        return this.to('PutVoiceConnectorTerminationCredentials');
    }
    /**
     * Grants permission to redact message content
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_RedactChannelMessage.html
     */
    toRedactChannelMessage() {
        return this.to('RedactChannelMessage');
    }
    /**
     * Grants permission to redact the specified Chime conversation Message
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_RedactConversationMessage.html
     */
    toRedactConversationMessage() {
        return this.to('RedactConversationMessage');
    }
    /**
     * Grants permission to redacts the specified Chime room Message
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_RedactRoomMessage.html
     */
    toRedactRoomMessage() {
        return this.to('RedactRoomMessage');
    }
    /**
     * Grants permission to regenerate the security token for the specified bot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_RegenerateSecurityToken.html
     */
    toRegenerateSecurityToken() {
        return this.to('RegenerateSecurityToken');
    }
    /**
     * Grants permission to register an endpoint for an app instance user
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - mobiletargeting:GetApp
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_RegisterAppInstanceUserEndpoint.html
     */
    toRegisterAppInstanceUserEndpoint() {
        return this.to('RegisterAppInstanceUserEndpoint');
    }
    /**
     * Grants permission to modify the account name for your Amazon Chime Enterprise or Team account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/rename-account.html
     */
    toRenameAccount() {
        return this.to('RenameAccount');
    }
    /**
     * Grants permission to renew the delegation request associated with an Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toRenewDelegate() {
        return this.to('RenewDelegate');
    }
    /**
     * Grants permission to reset the account resource in your Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toResetAccountResource() {
        return this.to('ResetAccountResource');
    }
    /**
     * Grants permission to reset the personal meeting PIN for the specified user on an Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_ResetPersonalPIN.html
     */
    toResetPersonalPIN() {
        return this.to('ResetPersonalPIN');
    }
    /**
     * Grants permission to restore the specified phone number from the deltion queue back to the phone number inventory
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_RestorePhoneNumber.html
     */
    toRestorePhoneNumber() {
        return this.to('RestorePhoneNumber');
    }
    /**
     * Grants permission to download the file containing links to all user attachments returned as part of the "Request attachments" action
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/ag/request-attachments.html
     */
    toRetrieveDataExports() {
        return this.to('RetrieveDataExports');
    }
    /**
     * Grants permission to search phone numbers that can be ordered from the carrier
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_SearchAvailablePhoneNumbers.html
     */
    toSearchAvailablePhoneNumbers() {
        return this.to('SearchAvailablePhoneNumbers');
    }
    /**
     * Grants permission to search channels that an AppInstanceUser belongs to, or search channels across the AppInstance for an AppInstaceAdmin
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_SearchChannels.html
     */
    toSearchChannels() {
        return this.to('SearchChannels');
    }
    /**
     * Grants permission to send a message to a particular channel that the member is a part of
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_SendChannelMessage.html
     */
    toSendChannelMessage() {
        return this.to('SendChannelMessage');
    }
    /**
     * Grants permission to submit the "Request attachments" request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/request-attachments.html
     */
    toStartDataExport() {
        return this.to('StartDataExport');
    }
    /**
     * Grants permission to start transcription for a meeting
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_StartMeetingTranscription.html
     */
    toStartMeetingTranscription() {
        return this.to('StartMeetingTranscription');
    }
    /**
     * Grants permission to stop transcription for a meeting
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_StopMeetingTranscription.html
     */
    toStopMeetingTranscription() {
        return this.to('StopMeetingTranscription');
    }
    /**
     * Grants permission to submit a customer service support request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/chime-getting-admin-support.html
     */
    toSubmitSupportRequest() {
        return this.to('SubmitSupportRequest');
    }
    /**
     * Grants permission to suspend users from an Amazon Chime Enterprise account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/manage-access.html
     */
    toSuspendUsers() {
        return this.to('SuspendUsers');
    }
    /**
     * Grants permission to apply the specified tags to the specified Amazon Chime SDK attendee
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_TagAttendee.html
     */
    toTagAttendee() {
        return this.to('TagAttendee');
    }
    /**
     * Grants permission to apply the specified tags to the specified Amazon Chime SDK meeting
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_TagMeeting.html
     */
    toTagMeeting() {
        return this.to('TagMeeting');
    }
    /**
     * Grants permission to apply the specified tags to the specified Amazon Chime resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to unauthorize an Active Directory from your Amazon Chime Enterprise account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toUnauthorizeDirectory() {
        return this.to('UnauthorizeDirectory');
    }
    /**
     * Grants permission to untag the specified tags from the specified Amazon Chime SDK attendee
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UntagAttendee.html
     */
    toUntagAttendee() {
        return this.to('UntagAttendee');
    }
    /**
     * Grants permission to untag the specified tags from the specified Amazon Chime SDK meeting
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UntagMeeting.html
     */
    toUntagMeeting() {
        return this.to('UntagMeeting');
    }
    /**
     * Grants permission to untag the specified tags from the specified Amazon Chime resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update account details for the specified Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UpdateAccount.html
     */
    toUpdateAccount() {
        return this.to('UpdateAccount');
    }
    /**
     * Grants permission to update the OpenIdConfig attributes for your Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/okta_sso.html
     */
    toUpdateAccountOpenIdConfig() {
        return this.to('UpdateAccountOpenIdConfig');
    }
    /**
     * Grants permission to update the account resource in your Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toUpdateAccountResource() {
        return this.to('UpdateAccountResource');
    }
    /**
     * Grants permission to update the settings for the specified Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UpdateAccountSettings.html
     */
    toUpdateAccountSettings() {
        return this.to('UpdateAccountSettings');
    }
    /**
     * Grants permission to update AppInstance metadata
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_UpdateAppInstance.html
     */
    toUpdateAppInstance() {
        return this.to('UpdateAppInstance');
    }
    /**
     * Grants permission to update the details for an AppInstanceUser
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_UpdateAppInstanceUser.html
     */
    toUpdateAppInstanceUser() {
        return this.to('UpdateAppInstanceUser');
    }
    /**
     * Grants permission to update an endpoint registered for an app instance user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_UpdateAppInstanceUserEndpoint.html
     */
    toUpdateAppInstanceUserEndpoint() {
        return this.to('UpdateAppInstanceUserEndpoint');
    }
    /**
     * Grants permission to the capabilties that you want to update
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_meeting-chime_UpdateAttendeeCapabilities.html
     */
    toUpdateAttendeeCapabilities() {
        return this.to('UpdateAttendeeCapabilities');
    }
    /**
     * Grants permission to update the status of the specified bot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UpdateBot.html
     */
    toUpdateBot() {
        return this.to('UpdateBot');
    }
    /**
     * Grants permission to update your Call Detail Record S3 bucket
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:CreateBucket
     * - s3:DeleteBucket
     * - s3:ListAllMyBuckets
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toUpdateCDRSettings() {
        return this.to('UpdateCDRSettings');
    }
    /**
     * Grants permission to update a channel's attributes
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_UpdateChannel.html
     */
    toUpdateChannel() {
        return this.to('UpdateChannel');
    }
    /**
     * Grants permission to update a channel flow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_UpdateChannelFlow.html
     */
    toUpdateChannelFlow() {
        return this.to('UpdateChannelFlow');
    }
    /**
     * Grants permission to update the content of a message
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_UpdateChannelMessage.html
     */
    toUpdateChannelMessage() {
        return this.to('UpdateChannelMessage');
    }
    /**
     * Grants permission to set the timestamp to the point when a user last read messages in a channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_UpdateChannelReadMarker.html
     */
    toUpdateChannelReadMarker() {
        return this.to('UpdateChannelReadMarker');
    }
    /**
     * Grants permission to update the global settings related to Amazon Chime for the AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UpdateGlobalSettings.html
     */
    toUpdateGlobalSettings() {
        return this.to('UpdateGlobalSettings');
    }
    /**
     * Grants permission to update phone number details for the specified phone number
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UpdatePhoneNumber.html
     */
    toUpdatePhoneNumber() {
        return this.to('UpdatePhoneNumber');
    }
    /**
     * Grants permission to update phone number settings related to Amazon Chime for the AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UpdatePhoneNumberSettings.html
     */
    toUpdatePhoneNumberSettings() {
        return this.to('UpdatePhoneNumberSettings');
    }
    /**
     * Grants permission to update a proxy session for the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UpdateProxySession.html
     */
    toUpdateProxySession() {
        return this.to('UpdateProxySession');
    }
    /**
     * Grants permission to update a room
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UpdateRoom.html
     */
    toUpdateRoom() {
        return this.to('UpdateRoom');
    }
    /**
     * Grants permission to update room membership role
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UpdateRoomMembership.html
     */
    toUpdateRoomMembership() {
        return this.to('UpdateRoomMembership');
    }
    /**
     * Grants permission to update properties of Amazon Chime SIP media application under the administrator's AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UpdateSipMediaApplication.html
     */
    toUpdateSipMediaApplication() {
        return this.to('UpdateSipMediaApplication');
    }
    /**
     * Grants permission to update an Amazon Chime SIP media application call under the administrator's AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UpdateSipMediaApplicationCall.html
     */
    toUpdateSipMediaApplicationCall() {
        return this.to('UpdateSipMediaApplicationCall');
    }
    /**
     * Grants permission to update properties of Amazon Chime SIP rule under the administrator's AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UpdateSipRule.html
     */
    toUpdateSipRule() {
        return this.to('UpdateSipRule');
    }
    /**
     * Grants permission to update the supported license tiers available for users in your Amazon Chime account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/manage-access.html
     */
    toUpdateSupportedLicenses() {
        return this.to('UpdateSupportedLicenses');
    }
    /**
     * Grants permission to update user details for a specified user ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UpdateUser.html
     */
    toUpdateUser() {
        return this.to('UpdateUser');
    }
    /**
     * Grants permission to update the licenses for your Amazon Chime users
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/ag/manage-access.html
     */
    toUpdateUserLicenses() {
        return this.to('UpdateUserLicenses');
    }
    /**
     * Grants permission to update user settings related to the specified Amazon Chime user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UpdateUserSettings.html
     */
    toUpdateUserSettings() {
        return this.to('UpdateUserSettings');
    }
    /**
     * Grants permission to update Amazon Chime Voice Connector details for the specified Amazon Chime Voice Connector
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UpdateVoiceConnector.html
     */
    toUpdateVoiceConnector() {
        return this.to('UpdateVoiceConnector');
    }
    /**
     * Grants permission to update Amazon Chime Voice Connector Group details for the specified Amazon Chime Voice Connector Group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_UpdateVoiceConnectorGroup.html
     */
    toUpdateVoiceConnectorGroup() {
        return this.to('UpdateVoiceConnectorGroup');
    }
    /**
     * Grants permission to validate the account resource in your Amazon Chime account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chime/latest/ag/control-access.html
     */
    toValidateAccountResource() {
        return this.to('ValidateAccountResource');
    }
    /**
     * Adds a resource of type meeting to the statement
     *
     * https://docs.aws.amazon.com/chime/latest/APIReference/API_Meeting.html
     *
     * @param meetingId - Identifier for the meetingId.
     * @param accountId - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMeeting(meetingId, accountId, partition) {
        return this.on(`arn:${partition || Chime.defaultPartition}:chime::${accountId || '*'}:meeting/${meetingId}`);
    }
    /**
     * Adds a resource of type app-instance to the statement
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_AppInstance.html
     *
     * @param appInstanceId - Identifier for the appInstanceId.
     * @param accountId - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAppInstance(appInstanceId, accountId, region, partition) {
        return this.on(`arn:${partition || Chime.defaultPartition}:chime:${region || '*'}:${accountId || '*'}:app-instance/${appInstanceId}`);
    }
    /**
     * Adds a resource of type app-instance-user to the statement
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_identity-chime_AppInstanceUser.html
     *
     * @param appInstanceId - Identifier for the appInstanceId.
     * @param appInstanceUserId - Identifier for the appInstanceUserId.
     * @param accountId - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAppInstanceUser(appInstanceId, appInstanceUserId, accountId, region, partition) {
        return this.on(`arn:${partition || Chime.defaultPartition}:chime:${region || '*'}:${accountId || '*'}:app-instance/${appInstanceId}/user/${appInstanceUserId}`);
    }
    /**
     * Adds a resource of type channel to the statement
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_Channel.html
     *
     * @param appInstanceId - Identifier for the appInstanceId.
     * @param channelId - Identifier for the channelId.
     * @param accountId - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onChannel(appInstanceId, channelId, accountId, region, partition) {
        return this.on(`arn:${partition || Chime.defaultPartition}:chime:${region || '*'}:${accountId || '*'}:app-instance/${appInstanceId}/channel/${channelId}`);
    }
    /**
     * Adds a resource of type channel-flow to the statement
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ChannelFlow.html
     *
     * @param appInstanceId - Identifier for the appInstanceId.
     * @param channelFlowId - Identifier for the channelFlowId.
     * @param accountId - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onChannelFlow(appInstanceId, channelFlowId, accountId, region, partition) {
        return this.on(`arn:${partition || Chime.defaultPartition}:chime:${region || '*'}:${accountId || '*'}:app-instance/${appInstanceId}/channel-flow/${channelFlowId}`);
    }
    /**
     * Adds a resource of type media-pipeline to the statement
     *
     * https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_media-pipelines-chime_MediaPipeline.html
     *
     * @param mediaPipelineId - Identifier for the mediaPipelineId.
     * @param accountId - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMediaPipeline(mediaPipelineId, accountId, region, partition) {
        return this.on(`arn:${partition || Chime.defaultPartition}:chime:${region || '*'}:${accountId || '*'}:media-pipeline/${mediaPipelineId}`);
    }
}
exports.Chime = Chime;
_a = JSII_RTTI_SYMBOL_1;
Chime[_a] = { fqn: "iam-floyd.Chime", version: "0.442.0" };
//# sourceMappingURL=data:application/json;base64,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