"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Rolesanywhere = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [rolesanywhere](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentityandaccessmanagementrolesanywhere.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Rolesanywhere extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [rolesanywhere](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsidentityandaccessmanagementrolesanywhere.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'rolesanywhere';
        this.accessLevelList = {
            Write: [
                'CreateProfile',
                'CreateTrustAnchor',
                'DeleteCrl',
                'DeleteProfile',
                'DeleteTrustAnchor',
                'DisableCrl',
                'DisableProfile',
                'DisableTrustAnchor',
                'EnableCrl',
                'EnableProfile',
                'EnableTrustAnchor',
                'ImportCrl',
                'UpdateCrl',
                'UpdateProfile',
                'UpdateTrustAnchor'
            ],
            Read: [
                'GetCrl',
                'GetProfile',
                'GetSubject',
                'GetTrustAnchor'
            ],
            List: [
                'ListCrls',
                'ListProfiles',
                'ListSubjects',
                'ListTagsForResource',
                'ListTrustAnchors'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to create a profile
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateProfile.html
     */
    toCreateProfile() {
        return this.to('CreateProfile');
    }
    /**
     * Grants permission to create a trust anchor
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_CreateTrustAnchor.html
     */
    toCreateTrustAnchor() {
        return this.to('CreateTrustAnchor');
    }
    /**
     * Grants permission to delete a certificate revocation list (crl)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DeleteCrl.html
     */
    toDeleteCrl() {
        return this.to('DeleteCrl');
    }
    /**
     * Grants permission to delete a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DeleteProfile.html
     */
    toDeleteProfile() {
        return this.to('DeleteProfile');
    }
    /**
     * Grants permission to delete a trust anchor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DeleteTrustAnchor.html
     */
    toDeleteTrustAnchor() {
        return this.to('DeleteTrustAnchor');
    }
    /**
     * Grants permission to disable a certificate revocation list (crl)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DisableCrl.html
     */
    toDisableCrl() {
        return this.to('DisableCrl');
    }
    /**
     * Grants permission to disable a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DisableProfile.html
     */
    toDisableProfile() {
        return this.to('DisableProfile');
    }
    /**
     * Grants permission to disable a trust anchor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_DisableTrustAnchor.html
     */
    toDisableTrustAnchor() {
        return this.to('DisableTrustAnchor');
    }
    /**
     * Grants permission to enable a certificate revocation list (crl)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_EnableCrl.html
     */
    toEnableCrl() {
        return this.to('EnableCrl');
    }
    /**
     * Grants permission to enable a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_EnableProfile.html
     */
    toEnableProfile() {
        return this.to('EnableProfile');
    }
    /**
     * Grants permission to enable a trust anchor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_EnableTrustAnchor.html
     */
    toEnableTrustAnchor() {
        return this.to('EnableTrustAnchor');
    }
    /**
     * Grants permission to get a certificate revocation list (crl)
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_GetCrl.html
     */
    toGetCrl() {
        return this.to('GetCrl');
    }
    /**
     * Grants permission to get a profile
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_GetProfile.html
     */
    toGetProfile() {
        return this.to('GetProfile');
    }
    /**
     * Grants permission to get a subject
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_GetSubject.html
     */
    toGetSubject() {
        return this.to('GetSubject');
    }
    /**
     * Grants permission to get a trust anchor
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_GetTrustAnchor.html
     */
    toGetTrustAnchor() {
        return this.to('GetTrustAnchor');
    }
    /**
     * Grants permission to import a certificate revocation list (crl)
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ImportCrl.html
     */
    toImportCrl() {
        return this.to('ImportCrl');
    }
    /**
     * Grants permission to list certificate revocation lists (crls)
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListCrls.html
     */
    toListCrls() {
        return this.to('ListCrls');
    }
    /**
     * Grants permission to list profiles
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListProfiles.html
     */
    toListProfiles() {
        return this.to('ListProfiles');
    }
    /**
     * Grants permission to list subjects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListSubjects.html
     */
    toListSubjects() {
        return this.to('ListSubjects');
    }
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list trust anchors
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_ListTrustAnchors.html
     */
    toListTrustAnchors() {
        return this.to('ListTrustAnchors');
    }
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update a certificate revocation list (crl)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_UpdateCrl.html
     */
    toUpdateCrl() {
        return this.to('UpdateCrl');
    }
    /**
     * Grants permission to update a profile
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_UpdateProfile.html
     */
    toUpdateProfile() {
        return this.to('UpdateProfile');
    }
    /**
     * Grants permission to update a trust anchor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/API_UpdateTrustAnchor.html
     */
    toUpdateTrustAnchor() {
        return this.to('UpdateTrustAnchor');
    }
    /**
     * Adds a resource of type trust-anchor to the statement
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html#first-time-user
     *
     * @param trustAnchorId - Identifier for the trustAnchorId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTrustAnchor(trustAnchorId, account, partition) {
        return this.on(`arn:${partition || Rolesanywhere.defaultPartition}:rolesanywhere::${account || '*'}:trust-anchor/${trustAnchorId}`);
    }
    /**
     * Adds a resource of type profile to the statement
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html#first-time-user
     *
     * @param profileId - Identifier for the profileId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProfile(profileId, account, partition) {
        return this.on(`arn:${partition || Rolesanywhere.defaultPartition}:rolesanywhere::${account || '*'}:profile/${profileId}`);
    }
    /**
     * Adds a resource of type subject to the statement
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html#first-time-user
     *
     * @param subjectId - Identifier for the subjectId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSubject(subjectId, account, partition) {
        return this.on(`arn:${partition || Rolesanywhere.defaultPartition}:rolesanywhere::${account || '*'}:subject/${subjectId}`);
    }
    /**
     * Adds a resource of type crl to the statement
     *
     * https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html#first-time-user
     *
     * @param crlId - Identifier for the crlId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCrl(crlId, account, partition) {
        return this.on(`arn:${partition || Rolesanywhere.defaultPartition}:rolesanywhere::${account || '*'}:crl/${crlId}`);
    }
}
exports.Rolesanywhere = Rolesanywhere;
_a = JSII_RTTI_SYMBOL_1;
Rolesanywhere[_a] = { fqn: "iam-floyd.Rolesanywhere", version: "0.442.0" };
//# sourceMappingURL=data:application/json;base64,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