"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Iotroborunner = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [iotroborunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotroborunner.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Iotroborunner extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [iotroborunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotroborunner.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'iotroborunner';
        this.accessLevelList = {
            Write: [
                'CreateAction',
                'CreateActionTemplate',
                'CreateActionTemplateDependency',
                'CreateActivity',
                'CreateActivityDependency',
                'CreateDestination',
                'CreateDestinationRelationship',
                'CreateSite',
                'CreateTask',
                'CreateTaskDependency',
                'CreateWorker',
                'CreateWorkerFleet',
                'DeleteAction',
                'DeleteActionTemplate',
                'DeleteActionTemplateDependency',
                'DeleteActivity',
                'DeleteActivityDependency',
                'DeleteDestination',
                'DeleteDestinationRelationship',
                'DeleteSite',
                'DeleteTask',
                'DeleteTaskDependency',
                'DeleteWorker',
                'DeleteWorkerFleet',
                'UpdateActionState',
                'UpdateActivity',
                'UpdateDestination',
                'UpdateSite',
                'UpdateTask',
                'UpdateWorker',
                'UpdateWorkerFleet'
            ],
            Read: [
                'GetAction',
                'GetActionTemplate',
                'GetActivity',
                'GetDestination',
                'GetDestinationRelationship',
                'GetSite',
                'GetTask',
                'GetWorker',
                'GetWorkerFleet',
                'ListActionTemplates',
                'ListActions',
                'ListActivities',
                'ListDestinationRelationships',
                'ListDestinations',
                'ListSites',
                'ListTasks',
                'ListWorkerFleets',
                'ListWorkers'
            ]
        };
    }
    /**
     * Grants permission to create an action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateAction.html
     */
    toCreateAction() {
        return this.to('CreateAction');
    }
    /**
     * Grants permission to create an action template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateActionTemplate.html
     */
    toCreateActionTemplate() {
        return this.to('CreateActionTemplate');
    }
    /**
     * Grants permission to create an action template dependency
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateActionTemplateDependency.html
     */
    toCreateActionTemplateDependency() {
        return this.to('CreateActionTemplateDependency');
    }
    /**
     * Grants permission to create an activity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateActivity.html
     */
    toCreateActivity() {
        return this.to('CreateActivity');
    }
    /**
     * Grants permission to create an activity dependency
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateActivityDependency.html
     */
    toCreateActivityDependency() {
        return this.to('CreateActivityDependency');
    }
    /**
     * Grants permission to create a destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateDestination.html
     */
    toCreateDestination() {
        return this.to('CreateDestination');
    }
    /**
     * Grants permission to create a destination relationship
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateDestinationRelationship.html
     */
    toCreateDestinationRelationship() {
        return this.to('CreateDestinationRelationship');
    }
    /**
     * Grants permission to create a site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateSite.html
     */
    toCreateSite() {
        return this.to('CreateSite');
    }
    /**
     * Grants permission to create a task
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateTask.html
     */
    toCreateTask() {
        return this.to('CreateTask');
    }
    /**
     * Grants permission to create a task dependency
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateTaskDependency.html
     */
    toCreateTaskDependency() {
        return this.to('CreateTaskDependency');
    }
    /**
     * Grants permission to create a worker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateWorker.html
     */
    toCreateWorker() {
        return this.to('CreateWorker');
    }
    /**
     * Grants permission to create a worker fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateWorkerFleet.html
     */
    toCreateWorkerFleet() {
        return this.to('CreateWorkerFleet');
    }
    /**
     * Grants permission to delete an action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteAction.html
     */
    toDeleteAction() {
        return this.to('DeleteAction');
    }
    /**
     * Grants permission to delete an action template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteActionTemplate.html
     */
    toDeleteActionTemplate() {
        return this.to('DeleteActionTemplate');
    }
    /**
     * Grants permission to delete an action template dependency
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteActionTemplateDependency.html
     */
    toDeleteActionTemplateDependency() {
        return this.to('DeleteActionTemplateDependency');
    }
    /**
     * Grants permission to delete an activity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteActivity.html
     */
    toDeleteActivity() {
        return this.to('DeleteActivity');
    }
    /**
     * Grants permission to delete an activity dependency
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteActivityDependency.html
     */
    toDeleteActivityDependency() {
        return this.to('DeleteActivityDependency');
    }
    /**
     * Grants permission to delete a destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteDestination.html
     */
    toDeleteDestination() {
        return this.to('DeleteDestination');
    }
    /**
     * Grants permission to delete a destination relationship
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteDestinationRelationship.html
     */
    toDeleteDestinationRelationship() {
        return this.to('DeleteDestinationRelationship');
    }
    /**
     * Grants permission to delete a site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteSite.html
     */
    toDeleteSite() {
        return this.to('DeleteSite');
    }
    /**
     * Grants permission to delete a task
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteTask.html
     */
    toDeleteTask() {
        return this.to('DeleteTask');
    }
    /**
     * Grants permission to delete a task dependency
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteTaskDependency.html
     */
    toDeleteTaskDependency() {
        return this.to('DeleteTaskDependency');
    }
    /**
     * Grants permission to delete a worker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteWorker.html
     */
    toDeleteWorker() {
        return this.to('DeleteWorker');
    }
    /**
     * Grants permission to delete a worker fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteWorkerFleet.html
     */
    toDeleteWorkerFleet() {
        return this.to('DeleteWorkerFleet');
    }
    /**
     * Grants permission to get an action
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetAction.html
     */
    toGetAction() {
        return this.to('GetAction');
    }
    /**
     * Grants permission to get an action template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetActionTemplate.html
     */
    toGetActionTemplate() {
        return this.to('GetActionTemplate');
    }
    /**
     * Grants permission to get an activity
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetActivity.html
     */
    toGetActivity() {
        return this.to('GetActivity');
    }
    /**
     * Grants permission to get a destination
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetDestination.html
     */
    toGetDestination() {
        return this.to('GetDestination');
    }
    /**
     * Grants permission to get a destination relationship
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetDestinationRelationship.html
     */
    toGetDestinationRelationship() {
        return this.to('GetDestinationRelationship');
    }
    /**
     * Grants permission to get a site
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetSite.html
     */
    toGetSite() {
        return this.to('GetSite');
    }
    /**
     * Grants permission to get a task
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetTask.html
     */
    toGetTask() {
        return this.to('GetTask');
    }
    /**
     * Grants permission to get a worker
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetWorker.html
     */
    toGetWorker() {
        return this.to('GetWorker');
    }
    /**
     * Grants permission to get a worker fleet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetWorkerFleet.html
     */
    toGetWorkerFleet() {
        return this.to('GetWorkerFleet');
    }
    /**
     * Grants permission to list action templates
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListActionTemplates.html
     */
    toListActionTemplates() {
        return this.to('ListActionTemplates');
    }
    /**
     * Grants permission to list actions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListActions.html
     */
    toListActions() {
        return this.to('ListActions');
    }
    /**
     * Grants permission to list activities
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListActivities.html
     */
    toListActivities() {
        return this.to('ListActivities');
    }
    /**
     * Grants permission to list destination relationships
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListDestinationRelationships.html
     */
    toListDestinationRelationships() {
        return this.to('ListDestinationRelationships');
    }
    /**
     * Grants permission to list destinations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListDestinations.html
     */
    toListDestinations() {
        return this.to('ListDestinations');
    }
    /**
     * Grants permission to list sites
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListSites.html
     */
    toListSites() {
        return this.to('ListSites');
    }
    /**
     * Grants permission to list tasks
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListTasks.html
     */
    toListTasks() {
        return this.to('ListTasks');
    }
    /**
     * Grants permission to list worker fleets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListWorkerFleets.html
     */
    toListWorkerFleets() {
        return this.to('ListWorkerFleets');
    }
    /**
     * Grants permission to list workers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListWorkers.html
     */
    toListWorkers() {
        return this.to('ListWorkers');
    }
    /**
     * Grants permission to update an action's state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateActionState.html
     */
    toUpdateActionState() {
        return this.to('UpdateActionState');
    }
    /**
     * Grants permission to update an activity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateActivity.html
     */
    toUpdateActivity() {
        return this.to('UpdateActivity');
    }
    /**
     * Grants permission to update a destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateDestination.html
     */
    toUpdateDestination() {
        return this.to('UpdateDestination');
    }
    /**
     * Grants permission to update a site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateSite.html
     */
    toUpdateSite() {
        return this.to('UpdateSite');
    }
    /**
     * Grants permission to update a task
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateTask.html
     */
    toUpdateTask() {
        return this.to('UpdateTask');
    }
    /**
     * Grants permission to update a worker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateWorker.html
     */
    toUpdateWorker() {
        return this.to('UpdateWorker');
    }
    /**
     * Grants permission to update a worker fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateWorkerFleet.html
     */
    toUpdateWorkerFleet() {
        return this.to('UpdateWorkerFleet');
    }
    /**
     * Adds a resource of type ActionResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param actionId - Identifier for the actionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifActionResourceId()
     */
    onActionResource(actionId, account, region, partition) {
        return this.on(`arn:${partition || Iotroborunner.defaultPartition}:iotroborunner:${region || '*'}:${account || '*'}:action/${actionId}`);
    }
    /**
     * Adds a resource of type ActionTemplateResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param actionTemplateId - Identifier for the actionTemplateId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifActionTemplateResourceId()
     */
    onActionTemplateResource(actionTemplateId, account, region, partition) {
        return this.on(`arn:${partition || Iotroborunner.defaultPartition}:iotroborunner:${region || '*'}:${account || '*'}:action-template/${actionTemplateId}`);
    }
    /**
     * Adds a resource of type ActivityResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param activityId - Identifier for the activityId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifActivityResourceId()
     */
    onActivityResource(activityId, account, region, partition) {
        return this.on(`arn:${partition || Iotroborunner.defaultPartition}:iotroborunner:${region || '*'}:${account || '*'}:activity/${activityId}`);
    }
    /**
     * Adds a resource of type DestinationRelationshipResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param destinationRelationshipId - Identifier for the destinationRelationshipId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifDestinationRelationshipResourceId()
     */
    onDestinationRelationshipResource(destinationRelationshipId, account, region, partition) {
        return this.on(`arn:${partition || Iotroborunner.defaultPartition}:iotroborunner:${region || '*'}:${account || '*'}:destination-relationship/${destinationRelationshipId}`);
    }
    /**
     * Adds a resource of type DestinationResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param destinationId - Identifier for the destinationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifDestinationResourceId()
     */
    onDestinationResource(destinationId, account, region, partition) {
        return this.on(`arn:${partition || Iotroborunner.defaultPartition}:iotroborunner:${region || '*'}:${account || '*'}:destination/${destinationId}`);
    }
    /**
     * Adds a resource of type SiteResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param siteId - Identifier for the siteId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifSiteResourceId()
     */
    onSiteResource(siteId, account, region, partition) {
        return this.on(`arn:${partition || Iotroborunner.defaultPartition}:iotroborunner:${region || '*'}:${account || '*'}:site/${siteId}`);
    }
    /**
     * Adds a resource of type TaggingResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param tagKey - Identifier for the tagKey.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifTaggingResourceTagKey()
     */
    onTaggingResource(tagKey, account, region, partition) {
        return this.on(`arn:${partition || Iotroborunner.defaultPartition}:iotroborunner:${region || '*'}:${account || '*'}:tag/${tagKey}`);
    }
    /**
     * Adds a resource of type TaskResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param taskId - Identifier for the taskId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifTaskResourceId()
     */
    onTaskResource(taskId, account, region, partition) {
        return this.on(`arn:${partition || Iotroborunner.defaultPartition}:iotroborunner:${region || '*'}:${account || '*'}:task/${taskId}`);
    }
    /**
     * Adds a resource of type WorkerFleetResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param siteId - Identifier for the siteId.
     * @param workerFleetId - Identifier for the workerFleetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifWorkerFleetResourceId()
     */
    onWorkerFleetResource(siteId, workerFleetId, account, region, partition) {
        return this.on(`arn:${partition || Iotroborunner.defaultPartition}:iotroborunner:${region || '*'}:${account || '*'}:site/${siteId}/worker-fleet/${workerFleetId}`);
    }
    /**
     * Adds a resource of type WorkerResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param siteId - Identifier for the siteId.
     * @param workerFleetId - Identifier for the workerFleetId.
     * @param workerId - Identifier for the workerId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifWorkerResourceId()
     */
    onWorkerResource(siteId, workerFleetId, workerId, account, region, partition) {
        return this.on(`arn:${partition || Iotroborunner.defaultPartition}:iotroborunner:${region || '*'}:${account || '*'}:site/${siteId}/worker-fleet/${workerFleetId}/worker/${workerId}`);
    }
    /**
     * Filters access by the action's identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Action
     *
     * Applies to resource types:
     * - ActionResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifActionResourceId(value, operator) {
        return this.if(`ActionResourceId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the action template's identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#ActionTemplate
     *
     * Applies to resource types:
     * - ActionTemplateResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifActionTemplateResourceId(value, operator) {
        return this.if(`ActionTemplateResourceId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the activity's identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Activity
     *
     * Applies to resource types:
     * - ActivityResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifActivityResourceId(value, operator) {
        return this.if(`ActivityResourceId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the destination relationship's identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#DestinationRelationship
     *
     * Applies to resource types:
     * - DestinationRelationshipResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifDestinationRelationshipResourceId(value, operator) {
        return this.if(`DestinationRelationshipResourceId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the destination's identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Destination
     *
     * Applies to resource types:
     * - DestinationResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifDestinationResourceId(value, operator) {
        return this.if(`DestinationResourceId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the site's identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Site
     *
     * Applies to resource types:
     * - SiteResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSiteResourceId(value, operator) {
        return this.if(`SiteResourceId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the metadata tag name
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Tagging
     *
     * Applies to resource types:
     * - TaggingResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTaggingResourceTagKey(value, operator) {
        return this.if(`TaggingResourceTagKey`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the task's identifer
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Task
     *
     * Applies to resource types:
     * - TaskResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTaskResourceId(value, operator) {
        return this.if(`TaskResourceId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the worker fleet's identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#WorkerFleet
     *
     * Applies to resource types:
     * - WorkerFleetResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifWorkerFleetResourceId(value, operator) {
        return this.if(`WorkerFleetResourceId`, value, operator || 'StringLike');
    }
    /**
     * Filters access by the workers identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Worker
     *
     * Applies to resource types:
     * - WorkerResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifWorkerResourceId(value, operator) {
        return this.if(`WorkerResourceId`, value, operator || 'StringLike');
    }
}
exports.Iotroborunner = Iotroborunner;
_a = JSII_RTTI_SYMBOL_1;
Iotroborunner[_a] = { fqn: "iam-floyd.Iotroborunner", version: "0.442.0" };
//# sourceMappingURL=data:application/json;base64,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